/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "cpptcl_type.h"
 *									  created: 19/7/96 {8:24:11 pm}	
 *								  last update: 19/11/97 {1:57:30 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	19/7/96	 VMD 1.0 original
 * ###################################################################
 */


#ifndef _Cpptcl_cpptcl_type_
#define _Cpptcl_cpptcl_type_

//@Section: Cpptcl library
///
class cpx_type  {
  private:
	///
	const char* _type;

  public:
	///
	cpx_type(const char* t=0):_type(t) {}
	///
	cpx_type(const cpx_type& t):_type(t._type) {}
	///
	const cpx_type& operator=(const cpx_type& t) { _type = t._type; return *this;}
	///
	const cpx_type& operator=(const char* t) { _type = t; return *this;}
	///
	operator const char* () { return _type;}
	///
	operator ==(const cpx_type& e)  { return (e._type == _type);}
	///
	operator !=(const cpx_type& e)  { return (e._type != _type);}
	//operator int() { return (_type?1:0);}
};

#include "tcl_args.h"

// This lets us read directly into any cpx type.  You'll have to
// make sure the template function is generated for each type you
// use in this way. 'T' can be cpx_object, info_event, topology, ...
// and any class you derive yourself.  Now you can do this:
// 		my_class* m;  arg >> m >> done; 
// and you can assume 'm' is a real meta_object of type 'my_class'
// because otherwise an error will have been generated!
template <class T> tcl_args& operator >> (tcl_args& arg, T*& t);

class meta_object;
tcl_args& operator >> (tcl_args&, cpx_type&);
tcl_args& operator >> (tcl_args&, const meta_object*&);


#endif