## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "alphaCommands.tcl"
 #                                    created: 03/18/1998 {01:13:44 AM} 
 #                                last update: 11/7/1999 {9:45:24 pm} 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #  
 # Copyright (c) 1999 Vince Darley
 # 
 # All rights reserved.
 # 
 # See the file "license.terms" for information on usage and redistribution of
 # this file, and for a DISCLAIMER OF ALL WARRANTIES.
 #  
 #  Description: 
 # 
 #   Mostly procedures which would really help Alpha if they were
 #   hard-coded.  Some other procedures for convenience are here too.
 #  History
 # 
 #  modified by  rev reason
 #  -------- --- --- -----------
 #  03/18/19 VMD 1.0 original
 # ###################################################################
 ##

if {${alpha::platform} != "alpha"} {
    alertnote "Shouldn't load this code!"
    return
}

namespace eval tmark {}

## 
 # -------------------------------------------------------------------------
 # 
 # "tmark::getPos" --
 # 
 #  This procedure is pretty slow, due to limitations in Alpha.  Hopefully
 #  one day we'll have a hard-wired quick version.  It also works around
 #  a bug in which Alpha tells us that windows which aren't files (e.g.
 #  just created with 'new -n') are located in Alpha's 'pwd' directory.
 #  
 #  The stupid thing is that Alpha knows exactly where each stop is, but
 #  it won't tell us!  'gotoTMark $m' goes to exactly the position we
 #  want, but we can't find it out some other way.
 # -------------------------------------------------------------------------
 ##
if {[info tclversion] < 8.0} {
    proc tmark::getPos {m {f ""}} {
	if {$f == ""} {set f [win::Current]}
	regsub { <[0-9]+>$} $f "" f
	if {[file exists $f]} {
	    if {[regexp "\{$m \{[quote::Regfind $f]\} (\[0-9\]+) \[0-9\]+\}" [getTMarks] "" where]} {
		return $where
	    }
	} else {
	    if {[regexp "\{$m \{[quote::Regfind [pwd]$f]\} (\[0-9\]+) \[0-9\]+\}" [getTMarks] "" where]} {
		return $where
	    }
	}
	error "No such mark"
    }
} else {
    proc tmark::getPos {m {f ""}} { 
	if {$f == ""} {
	    return [lindex [getPosOfTMark $m] 0] 
	} else {
	    return [lindex [getPosOfTMark -w $f $m] 0] 
	}
    }

}
if {[info tclversion] < 8.0} {
    proc tmark::getRange {m {f ""}} {
	if {$f == ""} {set f [win::Current]}
	regsub { <[0-9]+>$} $f "" df
	if {[file exists $df]} {
	    if {[regexp "\{ \{$m\} \{[quote::Regfind $df]\} (\[0-9\]+ \[0-9\]+ \[0-9\]+) \}" [getNamedMarks -w $f] "" where]} {
		return $where
	    }
	} else {
	    if {[regexp "\{ \{$m\} \{[quote::Regfind [pwd]$df]\} (\[0-9\]+ \[0-9\]+ \[0-9\]+) \}" [getNamedMarks -w $f] "" where]} {
		return $where
	    }
	}
	error "No such mark"
    }
} else {
    proc tmark::getRange {m {f ""}} { 
	if {$f == ""} {
	    return [getPosOfTMark $m]
	} else {
	    return [getPosOfTMark -w $f $m]
	}
    }

}
namespace eval mark {}
if {[info tclversion] < 8.0} {
    proc mark::getRange {m {f ""}} {
	if {$f == ""} {set f [win::Current]}
	regsub { <[0-9]+>$} $f "" df
	if {[file exists $df]} {
	    if {[regexp "\{ \{$m\} \{[quote::Regfind $df]\} (\[0-9\]+ \[0-9\]+ \[0-9\]+)" [getNamedMarks -w $f] "" where]} {
		return $where
	    }
	} else {
	    if {[regexp "\{ \{$m\} \{[quote::Regfind [pwd]$df]\} (\[0-9\]+ \[0-9\]+ \[0-9\]+)" [getNamedMarks -w $f] "" where]} {
		return $where
	    }
	}
	error "No such mark"
    }
} else {
    proc mark::getRange {m {f ""}} { 
	if {$f == ""} {
	    return [getPosOfMark $m]
	} else {
	    return [getPosOfMark -w $f $m]
	}
    }

}

## 
 # -------------------------------------------------------------------------
 # 
 # "tmark::getPositions" --
 # 
 #  For speed you can ask for a bunch of positions at once.
 # -------------------------------------------------------------------------
 ##
if {[info tclversion] < 8.0} {
    proc tmark::getPositions {mm} {
	regexp {(.*) <[0-9]+>$} [set f [win::Current]] "" f
	if {[file exists $f]} {
	    set reg " \{[quote::Regfind $f]\} (\[0-9\]+) \[0-9\]+\}"
	} else {
	    set reg " \{[quote::Regfind [pwd]$f]\} (\[0-9\]+) \[0-9\]+\}"
	}
	set marks [getTMarks]
	foreach m $mm {
	    if {[regexp "\{$m$reg" $marks "" where]} {
		lappend res $where
	    } else {
		error "No such mark"
	    }
	}
	return $res
    }
} else {
    proc tmark::getPositions {mm} {
	foreach m $mm {
	    lappend res [lindex [getPosOfTMark $m] 0]
	}
	return $res
    }
}

if {[info tclversion] < 8.0} {

proc tmark::isAt {p} {
    regexp {(.*) <[0-9]+>$} [set f [win::Current]] "" f
    if {[file exists $f]} {
	if {[regexp "\{(stop\[0-9\]+:\[0-9\]+) \{[quote::Regfind $f]\} $p $p\}" [getTMarks] "" which]} {
	    return $which
	}
    } else {
	if {[regexp "\{(stop\[0-9\]+:\[0-9\]+) \{[quote::Regfind [pwd]$f]\} $p $p\}" [getTMarks] "" which]} {
	    return $which
	}
    }
    return ""
}

} else {
    proc tmark::isAt {p} { return [isTMarkAt $p] }
}

# Thanks to Johan Linde:
proc refresh {{w ""}} {
    if {$w == ""} {
	eval sizeWin [lrange [getGeometry] 2 end]
    } else {
	eval sizeWin [list $w] [lrange [getGeometry $w] 2 end]
    }
}


namespace eval text {}

proc text::hyper {from to hyper} {
    text::color $from $to 15 $hyper
}

proc text::color {from to colour {hyper ""}} {
    if {$colour > 7} {
	if {$colour == 15} {
	    insertColorEscape $from $colour $hyper
	} else {
	    insertColorEscape $from $colour
	}
	insertColorEscape $to 12
    } else {
	insertColorEscape $from $colour
	insertColorEscape $to 0
    }
}

namespace eval status {}

proc status::prompt {prompt {func ""} {type "key"}} {
    global status::proc status::add
    set status::proc $func
    set status::add $type
    return [uplevel [list statusPrompt $prompt status::helper]]
}

proc status::helper {args} {
    global status::add status::proc
    switch -- ${status::add} {
	"modifiers" -
	"anything" {
	    lappend args [getModifiers]
	} 
    }
    return [uplevel ${status::proc} $args]
}

namespace eval pos {}

proc pos::compare {args} {uplevel expr $args}
proc pos::math {args} {uplevel expr $args}
proc minPos {} { return 0 }




