#========================(install)==========================================
# Compare Windows.
# 
# Simplified (and improved) version of David C. Black's 'compare-windows'.
# Modified by Mark Nagata, 2/23/93, corrected, 2/24/93.
# Sped-up version, 2/25/93.
#
# The return position bug in David's routine (when $patt != "") 
# is fixed in this version.
# 
# Vince renamed a couple of things and added the 'package' stuff so
# this works smoothly with the new Alpha Tcl scheme.  The bindings
# can now be adjusted via a preferences dialog.  Also rewrote a few
# bits to try to avoid window-toggling.
#===========================================================================

alpha::extension compareWindows 0.23 {
    namespace eval compare {}
    menu::insert Utils submenu 0 compare
    menu::insert "compare" items end windowsInPlace
    hook::register requireOpenWindowsHook [list compare windowsInPlace] 2
    newPref binding findDifference "/`X" compareWindows "" compare::windowsInPlace
    newPref binding findDifferenceIgnoringSpace "/1X" compareWindows "" compareOpt
    newPref binding findNextDifference "<U/`X" compareWindows "" compareNext
    newPref binding findNextDifferenceIgnoringSpace "<U/1X" compareWindows "" compareOptNext
    package::addPrefsDialog compareWindows
}
####
# On my Extended Keyboard (where the backquote key is to the left of the 
# "1" key), I Bind prefix-(shift)-backquote to 'compare(Next)' and
# prefix-(shift)-1 to 'compareOpt(Next)', as in the above.
# 
# On my Powerbook keyboard (where nothing is to the left of the "1" key),
# I Bind prefix-(shift)-1 to 'compare(Next)' and
# prefix-(shift)-2 to 'compareOpt(Next)', respectively.
####

proc compareOpt {} {
    compare::windowsInPlace -w
}

proc compare::windowsInPlace {args} {
    if {[lindex $args 0] == "-w"} {
	set patt "\[ \t\n\r\]+"
    } else {
	set patt {}
    }
    
    set files [winNames -f]
    if {[llength $files] < 2} {
	alertnote "If you want to Compare texts, you need two windows."
	return
    }
    
    watchCursor
    for {set i 1} {$i < 3} {incr i} {
	set wn($i) [lindex $files [expr {$i -1}]]
	set wp($i) [getPos -w $wn($i)]
	select -w $wn($i) $wp($i) $wp($i)
	set wrt($i) [getText -w $wn($i) $wp($i) [maxPos -w $wn($i)]]
	set wt($i) $wrt($i)
	if {$patt != ""} {
	    regsub -all $patt $wt($i) " " wt($i)
	}
    }
    
    # Exactly equal
    if {$wt(1) == $wt(2)} {
	alertnote "The windows match from cursors to ends."
	return
    }
    
    # Only consider smaller of two strings
    set siz [string length $wt(1)]
    if {$siz > [string length $wt(2)]} {
	set siz [string length $wt(2)]
    }
    
    # Equal except for added stuff
    set l [expr {$siz-1}]
    if {[string range $wt(1) 0 $l] == [string range $wt(2) 0 $l]} {
	set beg $siz
	set offset(1) $beg
	set offset(2) $beg
    } else {
	set beg 0
	
	while {$siz} {
	    set siz [expr {$siz/ 2}]
	    set end [expr {$beg+$siz}]
	    if {[string range $wt(1) $beg $end] == [string range $wt(2) $beg $end]} {
		incr beg $siz
		incr beg
	    }
	}
	set offset(1) $beg
	set offset(2) $beg
    }
    for {set i 2} {$i > 0} {incr i -1} {
	set count $offset($i)
	set pos [pos::math $wp($i) + $count]
	if {$patt != ""} {
	    set ans [string range $wt($i) 0 [expr {$offset($i)-1}]]
	    set lans [string length $ans]
	    set tt [string range $wrt($i) 0 [expr {$count-1}]]
	    regsub -all $patt $tt " " tt
	    set ltt [string length $tt]
	    while {$ltt < $lans} {
		incr count [expr {$lans-$ltt}]
		set pos [pos::math $pos + [expr {$lans-$ltt}]]
		message $pos
		set tt [string range $wrt($i) 0 [expr {$count-1}]]
		regsub -all $patt $tt " " tt
		set ltt [string length $tt]
	    }
	}
	
	set pos [expr [pos::compare $pos > [maxPos -w $wn($i)]] ? [maxPos -w $wn($i)] : $pos]
	display -w $wn($i) [pos::math $pos - 1]
	select -w $wn($i) $pos [pos::math $pos + 1]
	refresh $wn($i)
    }
    message "difference found"
    return
}

proc compareNext {} {
    endOfLine
    catch {bringToFront [lindex [winNames -f] 1]}
    endOfLine
    compare::windowsInPlace
}

proc compareOptNext {} {
    endOfLine
    catch {bringToFront [lindex [winNames -f] 1]}
    endOfLine
    compare::windowsInPlace -w
}



