/* hyphen_show: listing hyphenations                                       */
/*                                                                         */
/* Copyright (C) 1997, 2004                                                */
/* G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Uni Bremen                    */

/***************************************************************/ 
/*  Plea to the implementator:                                 */
/*                                                             */
/*  If you have to modify the following include instructions   */
/*  (or any other command of this program)                     */
/*  please send your modifications to us:                      */
/*                                                             */
/*       email: Roland.Weibezahn@web.de                        */
/*                                                             */
/*  See also ifdef's after command                             */
/*       main(n_arg,v_arg) int n_arg; char *v_arg[];           */
/***************************************************************/ 

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define LAENGE_PUF         250
#define LAENGE_NEU        5000 
#define LAENGE_SEITE      5000 
#define LAENGE_HCK       20000
#define MITTE               30

#define TRUE               1
#define FALSE              0

#if defined(AIX)  /*  AIX Compiler call:                               */
	 /*  gcc -o hyphen_show hyphen_show.c -DAIX                    */
	 /*  xlc -o hyphen_show hyphen_show.c -DAIX -D_POSIX_SOURCE    */
  #include <fcntl.h>
  #include <unistd.h>
  int open(const char *, int,...);
  int close(int);
  ssize_t read(int,void *,size_t);
  int isalpha(char);

#elif defined(__BORLANDC__)
  #include <io.h>
  #include <stdlib.h>
  #include <ctype.h>
  #include <fcntl.h>

#elif defined(__DECC__)  /*  VMS Compiler call:                        */
	/*  compile:  cc/decc/define=(__DECC__) hyphen_show            */
	/*  link:     link hyphen_show                                 */
	/*  install:  hyphen_show == "$<directory>hyphen_show.exe      */
        /* works with cc/decc on OpenVMS versions >=6.1 Alpha and VAX  */
        /* To install this helpfile in the standard DECUS TeX release  */
        /* use "LIBRARY/INSERT/HELP DECUS[.HLB] HYPHEN_SHOW[.HLP]".    */
#include <stdlib.h>
  #include <file.h>
  int open(const char *, int);
  int close(int);
  int read(int,char *,unsigned);
  int isalpha(char);

#else             /* tested with: SUN-Solaris 2.5 (cc, gcc),
		                  Linux (gcc),
				  SGI IRIS 5.2                              */
  #include <sys/fcntl.h>
  int close(int);
  int read(int,char *,unsigned);
  int isalpha(char);
#endif

int gchar(unsigned char *);
void fehler(void);
unsigned  char e_inbyte(void);
void a_outimage(void);
void a_outchar(unsigned char);
void skip(int);
int special_char(int,unsigned char);
void set_put(int);
void bop(unsigned char);
void test_neue_seite(void);
int gefunden(char *);
char * wortanfang(char *);
char * wortende(char *);
void f_set_pos(int);
void set_pos(int);
char *strip(char *);
int vergl_test(char *);
int zugelassen(int, unsigned char);
char* text_clear(char *, int *);
void eop(void);
long pow(int,int);
void eingabe(long *, unsigned char);
void right(unsigned char);
void w0(void);
void w(unsigned char);
void x0(void);
void x(unsigned char);
void down(unsigned char);
void y0(void);
void y(unsigned char);
void z0(void);
void z(unsigned char);
void xxx(unsigned char);
void fnt_def(unsigned char);
void pre(void);
void optionen( char *v_arg[]);

/***********************************************************/ 

#define BUFLEN_E 32768
int  filed1;
FILE *a_file,*ver_dat;
int  anzz=0;

int gchar( unsigned char *byt)
{ static char buffer[BUFLEN_E];
  static int cnt=0;
  static char *ptr;

  if (cnt == 0)
  {cnt=read(filed1,buffer,BUFLEN_E);
   ptr=buffer;
  }
  if (cnt > 0)
  {*byt = *ptr; 
   cnt--;  ptr++;  anzz++;
   return (1);
  }
  else if (cnt < 0)
  {printf("\nerror in reading, return code=%d\n",cnt);
   return (cnt);
  }
  else return (cnt);
}

double xfaktor = 1, yfaktor = 1;

long
     d_r, r_grenze, r_grenze_zeile,
     d_v, v_grenze, v_grenze_zeile,
     d_w, w_grenze, w_grenze_zeile,
     d_x, x_grenze, x_grenze_zeile,
     d_y, y_grenze, y_grenze_zeile,
     d_z, z_grenze, z_grenze_zeile,
     gesamt,anzgef,lauf;
int
     laenge_hck = LAENGE_HCK,
     laenge_neu = LAENGE_NEU,
     laenge_puf = LAENGE_PUF,
     mitte      = MITTE,
     fc         = TRUE,                     /* Codierung T1 als default  */
     s_p,s_max, hck_p,hck_max,neu_max,s_puffer_p,np,pos1, n_t1_ot1,ny,
     vorschub,enthalten, tr_gef,kon;

char
     seite[LAENGE_SEITE][LAENGE_PUF],
    *seitep[LAENGE_SEITE],
     s_puffer[LAENGE_PUF],hh[LAENGE_PUF], hh1[LAENGE_PUF],
     wortanf[LAENGE_PUF],wortend[LAENGE_PUF],stra[LAENGE_PUF],
     hck[LAENGE_HCK][80], neu[LAENGE_NEU+1][LAENGE_PUF],
     hauptdatei[80],verdatei[80],ausdatei[80],
    *hauptdateip,  *verdateip,  *ausdateip,  
     tns_alt[80];

unsigned char k,zz;


void fehler(void)
{printf("\nError: eof before postamble\n"); exit(0);
}

unsigned  char e_inbyte(void)
  {
   if ( gchar(&zz) != 1) fehler();
   return zz; 
  }

/* Beginn der Umsetzroutinen */

void a_outimage(void)
  { int b;
    if (s_puffer_p > 2) 
   { if (s_puffer[s_puffer_p-2] == '-') { b = TRUE; } else
     if (s_puffer[s_puffer_p-1] == '-') { b = TRUE; } else {b = FALSE;};
     if (s_puffer_p > 3) {if (s_puffer[s_puffer_p-3] == '-') {b = TRUE;} };
     if ((b) || (enthalten)) 
     { memset(&seite[s_p][0],(char)0,laenge_puf);
       seitep[s_p] = strncpy(&seite[s_p][0],&s_puffer[0],s_puffer_p);  
       s_p++; 
       enthalten = b;
     }
     s_puffer_p = 0;
   }
  }

void a_outchar(unsigned char c)
  { s_puffer[s_puffer_p] = c;
    s_puffer_p++; if (s_puffer_p >= laenge_puf-1) a_outimage();
    s_puffer[s_puffer_p] = (char)0;
  }

void skip(int kk)
  { for (lauf=1; lauf <= kk; lauf++)
      {e_inbyte();}
  }

int special_char(int opcode,unsigned char k)
  {
    if ((k >= 97) && (k <= 122)) {return FALSE;} /*Klein-Buchstabe liegt vor;*/
    if ((k >= 65) && (k <=  90)) {return FALSE;} /*Gross-Buchstabe liegt vor;*/

    if (fc)
    { if      (k <= 15) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else if (k == 16) {a_outchar('"'); return TRUE;}
      else if (k == 17) {a_outchar('"'); return TRUE;}
      else if (k <= 26) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else if (k == 27) {a_outchar('f'); a_outchar('f'); return TRUE;}
      else if (k == 28) {a_outchar('f'); a_outchar('i'); return TRUE;}
      else if (k == 29) {a_outchar('f'); a_outchar('l'); return TRUE;}
      else if (k == 30) {a_outchar('f'); a_outchar('f'); a_outchar('i');
                                         return TRUE;}
      else if (k == 31) {a_outchar('f'); a_outchar('f'); a_outchar('l');
                                         return TRUE;}
      else if (k == 123){a_outchar('-'); a_outchar('-'); return TRUE;}
      else if (k == 124){a_outchar('-'); a_outchar('-'); a_outchar('-');
                                         return TRUE;}
      else if (k == 255) {a_outchar((char)223); return TRUE;}
      else return FALSE;
    }
    else 
    {
      if ((opcode)) {if (k > 127) { n_t1_ot1++ ; return FALSE;}};
      if      (k <= 10) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else if (k == 11) {a_outchar('f'); a_outchar('f'); return TRUE;}
      else if (k == 12) {a_outchar('f'); a_outchar('i'); return TRUE;}
      else if (k == 13) {a_outchar('f'); a_outchar('l'); return TRUE;}
      else if (k == 14) {a_outchar('f'); a_outchar('f'); a_outchar('i');
                                         return TRUE;}
      else if (k == 15) {a_outchar('f'); a_outchar('f'); a_outchar('l');
                                         return TRUE;}
      else if (k <= 24) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else if (k == 25) {a_outchar('"'); a_outchar('s'); return TRUE;}
      else if (k <= 31) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else if (k == 123){a_outchar('-'); a_outchar('-'); return TRUE;}
      else if (k == 124){a_outchar('-'); a_outchar('-'); a_outchar('-'); 
                                         return TRUE;}
      else return FALSE;
    };
  }

void set_put(int hj)
  { unsigned  char hc;
    for (lauf = 1; lauf<= hj+1; lauf++)
    { hc = e_inbyte();
      if (!(special_char(TRUE,hc))){a_outchar(hc);}
    }
  }

void bop(unsigned char code)
  { int b;
    long hw; unsigned  char hk;
    a_outimage();
    vorschub = TRUE;
    hw = (int) e_inbyte();
    for (lauf=2; lauf <= 4; lauf++) 
    { hk = e_inbyte();
      hw = hw * 256 + (long) hk;
    }
    skip(40);                               /* skip 9*c[4] und p[1]  */
    sprintf(&s_puffer[0],"%c %d", code, hw);
    s_puffer_p = strlen(&s_puffer[0]);
    b = enthalten; enthalten = TRUE;
    a_outimage();
    enthalten = b;
  }

void test_neue_seite(void)
  { char * pp,tns[80];
    pp = strchr(seitep[s_p], (char) 139);
    if (pp != NULL)
    { if (np >= 15) {printf("\n"); np = 0;}
      strcpy(tns,pp+2);
      if(strcmp(tns,tns_alt) != 0) 
      {
        if (tr_gef) {printf("[%s]",tns_alt); np++;};
        tr_gef = FALSE;
        printf("[%s]",tns); np++;
        strcpy(tns_alt, tns);
      };
    };
  }

int gefunden(char *str)
  { int p1;
    p1 = strlen(str);
    if (str[p1-1] != '-') {return FALSE;}
    if (p1 > 1){if (str[p1-2] != '-') {gesamt++; return TRUE;}} 
    return FALSE;
  }

char * wortanfang(char *str)
  { char ht[2] = {(char)0, (char)0};
    int n,k;
    n = strlen(str);

    k = 0;
    while ((str[k] == ' ') && (k <= n)) k++;
    memset(&stra[0], (char)0,laenge_puf);
    strncpy(&stra[0], &str[k],n-k);
    if (k == n) goto fin;
    n = n-k; k = n;
    ht[0] = (char)0;
    if (n <= 2) 
    { if (stra[0] == '-') {goto fin;}
      else {ht[0] = '-';}
    }
/* wenn sich \emph{Textwert}- am Ende einer Zeile ergibt, dann steht 
                >Textwert -< in .dvi-Datei, deshalb:
*/
    if (stra[n-2] == ' ') {stra[n-2] = '}';}

    while ((k) && (stra[k-1] != ' '))
    { if (!k) {goto fin;}
      k--;
    }
fin:
    memset(&wortanf[0], (char)0,mitte+1);
    if (n-k > mitte)
      {return strcat(strncpy(&wortanf[0],&stra[n-mitte],mitte),&ht[0]);}
    else return strcat(strncpy(&wortanf[0],&stra[k],n-k),&ht[0]);
  } 

char * wortende(char *str)
  { int n,k,k1;
    n = strlen(str); 
    k1 = 0; k = 0;
    while ((str[k1] == ' ') && (k1 <= n)) k1++;
    if (k1 == n) goto fin;
    k = k1;
    while ((k<n) && (str[k] != ' ')) k++;
fin:
    memset(&wortend[0],(char)0,mitte+1);
    if (k-k1 > mitte) {return strncpy(&wortend[0],&str[k1],mitte);}
    else return strncpy(&wortend[0],&str[k1],k-k1);
  }

void f_set_pos(int k)
  { for (lauf=1; lauf <= k; lauf++)
    { fprintf(a_file," "); }
  }

void set_pos(int k)
  { for (lauf=1; lauf <= k; lauf++)
    { printf(" "); }
  }

char * strip(char *str)
  { lauf = strlen(str); 
    while ((lauf) && (str[lauf-1] == ' ')){ str[lauf-1] = (char)0; lauf--;};
    return str;
  }

int vergl_test(char * tcp)
  { lauf = 0;
    while ( lauf < hck_max)
    { if (strcmp(tcp, &hck[lauf][0]) == 0) {anzgef++; return TRUE;}
      lauf++;
    }
    lauf = 0;
    while ( lauf <= neu_max)
    {
      if (strcmp(tcp, &neu[lauf][0]) == 0) {anzgef++; return TRUE;}
      lauf++;
    }
    neu_max++;
    if (neu_max > laenge_neu) { neu_max = laenge_neu; }
    else  strcpy(&neu[neu_max][0],tcp);
    return FALSE;
  }

int zugelassen(int sta, unsigned char c)
  { if ((c == '-') || (isalpha(c)>0)) return TRUE;
    if (fc)
/*    Cork-Tabelle, Sept 1990  */
    { if ((c >= 128) && (c != 159)
                     && (c != 189)
                     && (c != 190)
                     && (c != 191)) {return TRUE;}
    }
/*     Nationals nach DIN 66 303, Tab 1; `A bis ''y, ohne \times und \div.  */
    else {if ((c >= 192) && (c != 215) && (c != 247)) {return TRUE;};}
    if (sta) { if (c == '"') {return TRUE;}};
    return FALSE;
  }

char * text_clear(char * str, int* p)
  { unsigned n; unsigned char cc;
    n = 0; *p = 0;
    while (strlen(str) > 0)
    { cc = (unsigned char) str[strlen(str)-1];
      if (!(zugelassen(FALSE,cc))) { str[strlen(str)-1] = (char) 0;}
      else goto trail;
    }
trail:
    while (n < strlen(str))
    { cc = (unsigned char) str[n];
      if (!(zugelassen(TRUE,cc))) {n++;}
      else goto fin;
    }
fin:
    *p =  n;
    memset(&hh1[0],(char)0,laenge_puf);
    return strncpy(&hh1[0], &str[n], strlen(&str[n]));
  }

void eop(void)
  { char * ttp, *ttap,*tgesp, *tcp, *terr;
    int ttapl,ntc,gef;
    a_outimage();
    s_max = s_p-1;
    s_p = 0;
    test_neue_seite();
    while  (s_p <= s_max)
    { ttp = strip(seitep[s_p]);
      gef = gefunden(ttp);
      if (gef)
      {
        ttap = wortanfang(ttp);
        ttapl = strlen(ttap);
        if (mitte-ttapl > 1) {pos1 = mitte-ttapl+1;} else pos1 = 1;
        s_p++; if (s_p > s_max) goto hinter_schl;
	if (ttapl < 2){gef = FALSE; gesamt--; goto schl;};
	if (ttapl == 2){if (ttap[0] == '}')
          {gef = FALSE; gesamt--; goto schl;};};
        test_neue_seite();
        ttp = strip(seitep[s_p]);
        terr = wortende(ttp);
        tgesp = strcat(ttap,terr);
        strcpy(&hh[0],tgesp);
        tcp = text_clear(&hh[0],&ntc);
        if (vergl_test(tcp) == FALSE)
        { if (vorschub) {printf("\n"); np = 0; vorschub = FALSE;}
          if (a_file != NULL){f_set_pos(pos1+ntc);fprintf(a_file,"%s\n",tcp);};
          set_pos(pos1+ntc); printf("%s\n",tcp);
          tr_gef = TRUE;
        }
        goto schl;
      }
      s_p++; if (s_p > s_max) goto hinter_schl;
      test_neue_seite();
schl: ;
    }
hinter_schl:

    if (gef)
    { 
      strcpy(&hh[0],ttap);
      tcp = text_clear(&hh[0],&ntc);
      if (!(vergl_test(tcp)))
      {
        if (vorschub) {printf("\n"); np = 0; vorschub = FALSE;};
        if (a_file != NULL){f_set_pos(pos1+ntc); fprintf(a_file,"%s\n",tcp);};
        set_pos(pos1+ntc);  printf("%s\n",tcp);
      }
    }
    s_p = 0;
  }

long pow(int b,int p)
  { long w;
    w = b;
    for (lauf=1; lauf < p; lauf++) {w = w *b;};
    return w;
  }

void eingabe(long* dd, unsigned char k)
  { int neg; unsigned char hk;
    long hw; 
    hw = (int) e_inbyte();
    neg = FALSE;
    if (hw > 127) {neg = TRUE;};
    for (lauf = 2; lauf <= (long) k; lauf++) 
    { hk = e_inbyte();
      hw = hw*256+hk;
    };
    if (neg) {*dd = -(pow(2,k*8))+hw; } else *dd = hw;
  }

void right(unsigned char code)
  { eingabe(&d_r, code-142);
    if (d_r > r_grenze) a_outchar(' ');
    if (d_r > r_grenze_zeile) a_outimage();
  }

void w0(void)
  { if (d_w > w_grenze) a_outchar(' ');
    if (abs(d_w) > w_grenze_zeile) a_outimage();
  }

void w(unsigned char code)
  { eingabe(&d_w, code-147);
    if (d_w > w_grenze) a_outchar(' ');
    if (d_w > w_grenze_zeile) a_outimage();
  }

void x0(void)
  { if (d_x > x_grenze) a_outchar(' ');
    if (abs(d_x) > x_grenze_zeile) a_outimage();
  }

void x(unsigned char code)
  { eingabe(&d_x, code-152);
    if (d_x > x_grenze) a_outchar(' ');
    if (d_x > x_grenze_zeile) a_outimage();
  }

void down(unsigned char code)
  { eingabe(&d_v, code-156);
    if (d_v > v_grenze_zeile) a_outimage();
  }

void y0(void)
  { if (d_y > y_grenze)  a_outimage();
    if (abs(d_y) > y_grenze_zeile) a_outimage();
  }

void y(unsigned char code)
  { eingabe(&d_y, code-161);
    if (d_y > y_grenze) a_outchar(' ');
    if (d_y > y_grenze_zeile) a_outimage();
  }

void z0(void)
  { if (d_z > z_grenze) a_outimage();
    if (abs(d_z) > z_grenze_zeile) a_outimage();
  }

void z(unsigned char code)
  { eingabe(&d_z, code-166);
    if (d_z > z_grenze) a_outchar(' ');
    if (d_z > z_grenze_zeile) a_outimage();
  }

void xxx(unsigned char code)
  { long hw,hk,hk1;
    hk = (int) code-238;
    hw = (int) e_inbyte();
    for (lauf=2; lauf <= hk; lauf++) 
    { hk1 = (int) e_inbyte();
      hw = hw * 256 + (long) hk1;
    }
    skip(hw);             
  }

void fnt_def(unsigned char code)
  { long hw,hk; 
    skip(code - 230);                       /* skip k[1] bzw k[4]  */
    hw = (int) e_inbyte();                  /* Lesen a[1]          */
    hk = (int) e_inbyte();                  /* Lesen l[1]          */
    skip(2*hw+hk);                          /* skip a + 1          */
  }

void kontrollausgabe(long num,long den,double frac)
{
  printf("num    %15d\n", num);
  printf("den    %15d\n", den);
  printf("frac   %15f\n", frac);
  printf("xfaktor%15f\n", xfaktor);
  printf("yfaktor%15f\n", yfaktor);
  printf("r %15d %15d\n", r_grenze, r_grenze_zeile);
  printf("v %15d %15d\n", v_grenze, v_grenze_zeile);
  printf("w %15d %15d\n", w_grenze, w_grenze_zeile);
  printf("x %15d %15d\n", x_grenze, x_grenze_zeile);
  printf("y %15d %15d\n", y_grenze, y_grenze_zeile);
  printf("z %15d %15d\n", z_grenze, z_grenze_zeile);
}

void pre(void)
  { long num,den; 
    double frac;

    skip(1);
    num = (long) e_inbyte();
    for (lauf = 2; lauf <= 4; lauf++)
    {
      num = num * 256 + (long) e_inbyte();
    };

    den = (long) e_inbyte();
    for (lauf = 2; lauf <= 4; lauf++)
    {
      den = den * 256 + (long) e_inbyte();
    };
 
    frac = den*10000.0/num;

    r_grenze = xfaktor*0.25*frac+0.5; r_grenze_zeile = yfaktor*  5*frac+0.5;
    v_grenze = xfaktor*1.0 *frac+0.5; v_grenze_zeile = yfaktor*3.2*frac+0.5;
    w_grenze = xfaktor*0.25*frac+0.5; w_grenze_zeile = yfaktor* 25*frac+0.5;
    x_grenze = xfaktor*0.25*frac+0.5; x_grenze_zeile = yfaktor*3.5*frac+0.5;
    y_grenze = xfaktor*0.05*frac+0.5; y_grenze_zeile = yfaktor*0.5*frac+0.5;
    z_grenze = xfaktor*0.05*frac+0.5; z_grenze_zeile = yfaktor*3.5*frac+0.5;

/*
 folgende Werte sollten ungefaehr gesetzt sein:

  r_grenze = 50000;  r_grenze_zeile = 1000000;
  v_grenze = 10000;  v_grenze_zeile =  600000;
  w_grenze = 50000;  w_grenze_zeile = 5000000;
  x_grenze = 50000;  x_grenze_zeile =  700000;
  y_grenze = 10000;  y_grenze_zeile =  100000;
  z_grenze = 10000;  z_grenze_zeile =  700000;
*/
    if (kon) kontrollausgabe(num,den,frac);
    skip(4);
    num = (long) e_inbyte();
    skip(num); 
  }

void optionen( char *v_arg[])
{
  if (strcmp(v_arg[ny],"-c") == 0)
    {
      ny++;
/* Codierung T1 als default kann durch OT1 ueberschrieben werden */
      if ((strcmp(v_arg[ny], "OT1") != 0) &&  (strcmp(v_arg[ny], "T1") != 0))
      { printf("Coding OT1 or T1 must be given\n");}
      if (strcmp(v_arg[ny], "OT1") == 0) {fc = FALSE;}
      if (strcmp(v_arg[ny],  "T1") == 0) {fc = TRUE;}
    }
  else if (strcmp(v_arg[ny],"-x") == 0)
    {
      ny++;
      xfaktor = (double) atof(v_arg[ny]);
    }
  else if (strcmp(v_arg[ny],"-y") == 0)
    {
      ny++;
      yfaktor = (double)atof(v_arg[ny]);
    }
  else if (strcmp(v_arg[ny],"-K") == 0)
    {
      ny++;
      if (strcmp(v_arg[ny],"yes") == 0){ kon = TRUE; }
    }
}

int main(int n_arg, char *v_arg[])
  {

/***********************************************************/ 
#ifdef  __BORLANDC__
    _fmode = O_BINARY;
#endif
/***********************************************************/ 

    verdateip = NULL;
    if (setvbuf(stdout,NULL,_IOLBF,0) != 0)
      { perror("setvbuf"); exit(1);}
    printf("\n%s ",v_arg[0]); printf("version 12.1.2001\n");

    if (n_arg == 1) {printf("missing file name; exit\n"); goto schluss;}
    ny = 1;
    if (n_arg >= 4) 
    { while (ny < n_arg-2)
      { optionen(v_arg); ny++; }
    };

    hauptdateip = strcpy(&hauptdatei[0],v_arg[ny]);
    ny++;
    if (ny == n_arg-1) verdateip = strcpy(&verdatei[0],v_arg[ny]);

    if ((strlen(hauptdateip) <= 4) || (strstr(hauptdateip,".dvi") == 0))
    { hauptdateip = strcat(hauptdateip,".dvi");
    };

    ausdateip = strncpy(&ausdatei[0],hauptdateip, strlen(hauptdateip)-4); 
    ausdateip = strcat(ausdateip,".hyp"); 

    filed1 = open(hauptdateip,O_RDONLY);    
    if ((int)filed1 <= 0) {printf("\ninput file not found\n");goto schluss;}

    a_file=fopen(ausdateip,"w+");    
    if (a_file == NULL)
      {printf("\nwarning: could not open file %s for writing\n",ausdateip);};
    if (verdateip == NULL) {}
    else
    { ver_dat = fopen(verdateip,"r");    
      if (ver_dat == NULL) {printf("\nfile not found: %s\n",verdateip);}
      else
      { hck_p = 0;
        fscanf(ver_dat,"%s", & hck[hck_p][0]);
        while (feof(ver_dat) == 0)
        { hck_p++;
          if (hck_p >= laenge_hck)
          { printf("\nwarning: more than %d lines in file %s\n",
            laenge_hck,verdateip);
            goto weiter;
          }
          fscanf(ver_dat,"%s", & hck[hck_p][0]);
        }
weiter:
       hck_max = hck_p;
      }
    }

    tr_gef = FALSE;

    if (fc) {printf("coding: T1\n");} else {printf("coding: OT1\n");} 
    printf("same words are given only once\n\n"); 

    s_puffer_p = 0; s_p = 0; enthalten = FALSE;
    anzgef = 0; neu_max = 0; np = 0;

  wdh:
      k =  e_inbyte();
      if      (k == 0) {;}                      /* set_char_0               */
      else if (special_char(FALSE,k)) {;}       /* Ligatur, sz -- u. ---    */
      else if (k <= 126) {a_outchar(k);}        /* Ausgabe druckb. Zeichen  */
      else if (k == 127) {a_outchar('"');}      /* Umlautzeichen wird zu "  */
      else if (k <= 131) {set_put(k-128);}      /* set1 bis set4            */
      else if (k == 132) {skip(8);}             /* set_rule                 */
      else if (k <= 136) {set_put(k-133);}      /* put1 bis put4            */
      else if (k == 137) {skip(8);}             /* put_rule                 */
      else if (k == 138) {;}                    /* nop (no operation)       */
      else if (k == 139) {bop(k);}              /* Seiten-Beginn            */
      else if (k == 140) {eop();}               /* Seiten-Ende              */
      else if (k <= 142) {;}                    /* push, pop                */
      else if (k <= 146) {right(k);}            /* right1 bis right4        */
      else if (k == 147) {w0();}                /* w0                       */
      else if (k <= 151) {w(k);}                /* w1 bis w4                */
      else if (k == 152) {x0();}                /* x0                       */
      else if (k <= 156) {x(k);}                /* x1 bis x4                */
      else if (k <= 160) {down(k);}             /* down1 bis down4          */
      else if (k == 161) {y0();}                /* y0                       */
      else if (k <= 165) {y(k);}                /* y1 bis y4                */
      else if (k == 166) {z0();}                /* z0                       */
      else if (k <= 170) {z(k);}                /* z1 bis z4                */
      else if (k <= 234) {;}                    /* Fontumschaltungen        */
      else if (k <= 238) {skip(k-234);}         /* fnt1 bis fnt4            */
      else if (k <= 242) {xxx(k);}              /* xxx1 bis xxx4            */
      else if (k <= 246) {fnt_def(k);}          /* Font-Definitionen        */
      else if (k == 247) {pre();}               /* Praeambel                */
      else if (k == 248) {goto fin;}            /* Ueberlesen Post,Post_post*/
      ;   
  goto wdh;
 fin:
    close(filed1);

    printf("\nnumber of hyphenations:%5ld\n",gesamt);
    printf("already known/multiple:%5ld\n",anzgef);

    if (n_t1_ot1 > 0) 
    { printf("warning: coding OT1 used, T1 may be correct\n");
      printf("         number of OT1/T1-faults:%10d\n",n_t1_ot1);
    };
    if (a_file != NULL) {fclose(a_file);}
    else
      {printf("\nwarning: could not open file %s for writing\n\n",ausdateip);};
    exit(0);
schluss:  exit(1);
  }
