/* $Id: ukdate.cc,v 1.4 1997/04/13 15:42:32 dps Exp $ */
/* Date formatter for the UK */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef TM_IN_SYS_TIME
#include <sys/time.h>
#else
#include <time.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif /* HAVE_STRINGS_H */
#define __EXCLUDE_READER_CLASSES
#include "lib.h"

char *uk_date(time_t when)
{
    static const char *months[]=
    {
	"January", "February", "March", "April",
	"May", "June", "July", "August",
	"September", "October", "November", "December",
    };

    struct tm *tim;
    char date_buf[200];
    const char *postfix;
    
    tim=localtime(&when);
    switch (tim->tm_mday % 10)
    {
    case 1:
	postfix="st";
	break;

    case 2:
	postfix="nd";
	break;

    case 3:
	postfix="rd";
	break;

    default:
	postfix="th";
	break;
    }
    if (tim->tm_mday > 10 && tim->tm_mday < 14) postfix="th";

    sprintf(date_buf, "%d%s %s, %d", tim->tm_mday, postfix,
	    months[tim->tm_mon], 1900+tim->tm_year);
    
    return strdup(date_buf);
}


    
