%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 						C/C++ Syntax Highlight
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 			Andre Hentz (andre@lcmi.ufsc.br) 		Mar 26, 1995
%
% This file is base on John E. Davis' C function and is intended to 
% be an example of how you can highlight any language using JED. 
%

variable JMAX_COLORS = 10;
variable JNORMAL_COLOR = 1;
variable JCURSOR_COLOR = 2;
variable JSTATUS_COLOR = 3;
variable JREGION_COLOR = 4;
variable JOP_COLOR = 5;
variable JNUM_COLOR = 6;
variable JSTR_COLOR = 7;
variable JCOM_COLOR = 8;
variable JKEY_COLOR = 9;
variable JDELIM_COLOR = 10;

variable str_len;
variable index;
variable str;
variable attr;
 	
define setattr_and_advance(color)
{
	index++;
	attr = strsub(attr, index, color);
}
			   
%  These are the C++ keywords:
%  asm auto
%  break
%  case catch char class const continue
%  default delete do double
%  else enum extern
%  float for friend
%  goto
%  if inline int
%  long
%  new
%  operator
%  private protected public
%  register return
%  short signed sizeof static struct switch
%  template this throw try typedef
%  union unsigned
%  virtual void volatile
%  while
% 

define get_keywords(n)
{
	switch(n)	
	{ () == 2: "doif";}			 
    { () == 3: "asmforintnewtry";}	
    { () == 4: "autocasecharelseenumgotolongthisvoid";}
    { () == 5: "breakcatchclassconstfloatshortthrowunionwhile";} 
    { () == 6: "deletedoubleexternfriendinlinepublicreturnsignedsizeofstaticstructswitch";}
    { () == 7: "defaultprivatetypedefvirtual";}    
    { () == 8: "continueoperatorregistertemplateunsignedvolatile";}  
    { () == 9: "protected";} 
	{ pop(); "";}	
}

define c_highlight_token()
{
	variable i, n, t;
	variable ch, keywords;
	variable key_len;
	variable skip = 0;

	% identify a word
	i = index;
	while (i < str_len)
	{
		ch = str[i];
		if (is_one_of("0123456789.", ch) ) skip = 1;
		else !if ( is_one_of("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$@_`", ch) ) 
			break;
		i++;
    }
	
	if (skip) 
	{
		index = i;
		return;
	}
	
	
	n =  i - index;	
	keywords = get_keywords(n);
	t = 0;
	key_len = strlen(keywords);
	while (t < key_len)
    {
		index = i - n;
		while ((index < i) and (keywords[t] == str[index]))
		{
	    	index++; t++;
		}
		if (index == i) %  keyword matched
	  	{
	    	index = i - n;
	     	while (index < i) 
				setattr_and_advance(JKEY_COLOR);
			return;
		}	
		if (keywords[t] > str[index]) 
			break;	% alphabetical ordering of keywords
		t += (i - index);
	}
	index = i;
}

define c_highlight_string()
{
	variable ch, first_ch;
	
	first_ch = str[index];
	setattr_and_advance(JSTR_COLOR);
	while (index < str_len)
    {
		ch = str[index];
		setattr_and_advance(JSTR_COLOR);
		if (ch == first_ch) 
			break;
		if ((ch == '\\') and (index < str_len))
			setattr_and_advance(JSTR_COLOR);
	}
}

define c_highlight_number()
{
	variable len;

	len = number_length(str, index);
	if (len == 0)
	{
		setattr_and_advance(JDELIM_COLOR);
		return;
	}	

	while (len)
	{
		len--;			
		setattr_and_advance(JNUM_COLOR);
	}		
}  

define c_highlight_comment ()
{
   variable ch;
   while (index < str_len)
	{
		ch = str[index];
		setattr_and_advance(JCOM_COLOR);
		if ((ch == '*') and (index < str_len) and (str[index] == '/'))
		{			
			setattr_and_advance(JCOM_COLOR);
	    	break;
	  	}
	}
}
 
define cpp_highlight_comment ()
{
   while (index < str_len)
		setattr_and_advance(JCOM_COLOR);
}

define do_slash()
{	
	variable ch;
	
	if (index + 1 < str_len)
	{					
		ch = str[index + 1];
		if (ch == '/')
			cpp_highlight_comment();
  		else if (ch == '*') 
		{	
			setattr_and_advance(JCOM_COLOR);
			setattr_and_advance(JCOM_COLOR);
			c_highlight_comment();
		}					
		else 
			setattr_and_advance(JOP_COLOR);
	}				
	else
		setattr_and_advance(JOP_COLOR);
}

define do_asterisk()
{		 
	if ((index + 1 < str_len) and (str[index + 1] == '/'))
	{
		index = 0;
		c_highlight_comment();	
	}
	else if ((index + 1 < str_len) and (str[index + 1] <= ' '))
	{
		setattr_and_advance(JCOM_COLOR);
		c_highlight_comment();	
	}	
	else
		setattr_and_advance(JOP_COLOR);
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%						C Syntax Highlight							%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
define c_syntax_highlight ()
{
	variable ch;
	variable color;
	
	=attr; =str;
 
    str_len = strlen(str);
	index = 0;

%   
% Skip the whitespace and if we find a '*' with a followed by whitespace,
% highlight it as a comment-- like these lines
%    
	while (index < str_len)
    {
		if (str[index] > ' ') break;
		index++;
    }

	ch = str[index];
	if ( ((index + 1) < str_len) and (ch == '*') )
		if (str[index + 1] <= ' ')
		{
			setattr_and_advance(JCOM_COLOR);
	     	c_highlight_comment();
		}

   	while (index < str_len)
    {
		ch = str[index];
    	if ( is_one_of("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$@_`" , ch) ) 
			c_highlight_token();
    	else if ( (ch == '"') or (ch == '\'') ) c_highlight_string();
    	else if (is_one_of("0123456789.", ch)) c_highlight_number();
    	else if (is_one_of("{}[](),.;\\", ch)) 
			setattr_and_advance(JDELIM_COLOR);
    	else if (is_one_of("!#%+-:<=>?^|~", ch))
			setattr_and_advance(JOP_COLOR);
    	else if (ch == '/')
     		do_slash();
		else if (ch == '*')
			do_asterisk();
		else 
			index++; 
	}
	attr;
}
