/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       wp2lsec.c                                                     *
 * description: This modul contains functions for second pass. In the second  *
 *              pass the text file stripped from the WP binary file will be   *
 *              completed with the information of the binary table file which *
 *              contains additional information about environments.           *
 ******************************************************************************/
#include <io.h>
#include <math.h>
#include <stdio.h>
#include "wp2latex.h"

static void Read_tabelentry(short n, struct LOC_Convert_second_pass *LINK)
{
  unsigned short w;
  uchar    b;
  short    j, FORLIM;

  /* Begin met een schone lei die dan door deze procedure verder wordt *
   * opgevuld.                                                         */

  LINK->envir[n] = ' ';
  LINK->new_tabset[n] = false;
  LINK->new_tabent_rightjust[n] = false;

  LINK->num_of_attr[n] = 0;
  for (j = 1; j <= 16; j++)
    LINK->attr_BOL[n][j] = 0;

  if (ftell(tabel) / sizeof(uchar) > filelength(fileno(tabel)) )
    return;

  /* Er is geen volgende tabelentry dus ook geen volgende regel */
  /* De tabelentry is 'schoon'.                                 */
  /* Zodat het document 'schoon' wordt afgesloten.              */

  LINK->num_of_attr[n] = getc(tabel);
  FORLIM = LINK->num_of_attr[n];
  for (j = 1; j <= FORLIM; j++)
    LINK->attr_BOL[n][j] = getc(tabel);

  b = 0;
  while ((b != 0xff) && ((b = getc(tabel)) != (uchar)EOF)) {

    switch (b) {   /*Case*/

    case 'C':
      LINK->envir[n] = 'C';
      break;

    case 'T':
      LINK->envir[n] = 'T';
      break;

    case 'I':
      LINK->envir[n] = 'I';
      Rd_word(tabel, &LINK->ind_leftmargin[n]);
      Rd_word(tabel, &LINK->ind_rightmargin[n]);
      LINK->ind_label[n] = getc(tabel);
      break;

    case 'S':
      LINK->new_tabset[n] = true;
      LINK->tabent_num_of_tabs[n] = b = getc(tabel);

      FORLIM = LINK->tabent_num_of_tabs[n];
      for (j = 0; j < FORLIM; j++) {
        Rd_word(tabel, &w);
        LINK->tabent_tabpos[n][j] = w;
      }
      break;

    case 'U':
      LINK->new_tabent_rightjust[n] = true;
      if ( (b = getc(tabel)) == 0)
        LINK->tabent_rightjust[n] = false;
      else
        LINK->tabent_rightjust[n] = true;
      break;

    case 'R':
    case 'r':
    case 'P':
    case 'p':
      LINK->line_term[n] = b;
      break;

    }
  }
}

static void Open_all_attr_BOL(LINK)
struct LOC_Convert_second_pass *LINK;
{
  /* -- Open alle commando's door de Attributen-rij af te lopen -- */
  short j, FORLIM;

  FORLIM = LINK->num_of_attr[LINK->cur];
  for (j = 0x1; j <= FORLIM; j++)
    fputs(open_com[LINK->attr_BOL[LINK->cur][j]], latex);

  LINK->attr_closed = false;
}

static void Close_all_attr_BOL(LINK)
struct LOC_Convert_second_pass *LINK;
{
  /* -- Sluit alle commando's door de Attributen-rij af te lopen -- */
  short j;

  for (j = LINK->num_of_attr[LINK->cur]; j >= 0x1; j--)
    fputs(close_com[LINK->attr_BOL[LINK->cur][j]], latex);

  LINK->attr_closed = true;
}

static void Close_all_attr_EOL(LINK)
struct LOC_Convert_second_pass *LINK;
{
  /* -- Sluit alle commando's door de Attributen-rij af te lopen -- */
  short j;

  for (j = LINK->num_of_attr[LINK->next]; j >= 0x1; j--)
    fputs(close_com[LINK->attr_BOL[LINK->next][j]], latex);

  LINK->attr_closed = true;
}

static void Latex_head(struct LOC_Convert_second_pass *LINK, char *wpd_fn)
{
  /* -- Maak het de standard-heading voor een latex-file aan -- */
  fprintf(latex, "\\documentclass[11pt]{report}\n");
  fprintf(latex, "\\usepackage{wp2latex}\n");
  fprintf(latex, "\n%% Converted to LaTeX by Wp2LaTeX %s, version of %s\n",
                                          versionname,versiondate);
  fprintf(latex, "%% from Word Perfect document '%s'.\n\n",wpd_fn);
  fprintf(latex, "%% Requires wp2latex.sty for printing.\n");
  fprintf(latex, "%% If you insert the contents of wp2latex.sty right here\n");
  fprintf(latex, "%% and delete \\usepackage{wp2latex} in the second line,\n");
  fprintf(latex, "%% wp2latex.sty will then no longer be required.\n\n");
  fprintf(latex, "\\begin{document}\n");
}

static void Latex_foot(LINK)
struct LOC_Convert_second_pass *LINK;
{
  /* -- Sluit de latex-file op de juiste wijze af -- */
  fprintf(latex, "\n\\end{document}\n");
}

static void Latex_tabset(LINK)
struct LOC_Convert_second_pass *LINK;
{
  short atpr, j;
  double l, ol;
  short FORLIM;

  atpr = 0;   /* Huiding aantal tabs per regel */
  ol = 0.0;
  FORLIM = LINK->num_of_tabs;
  for (j = 0; j < FORLIM; j++) {
    l = LINK->tabpos[j] / 1200.0 * 2.54;
    fprintf(latex, "\\hspace{%3.2fcm}\\=", l - ol);
    atpr++;
    if (atpr >= 4) {
      fprintf(latex, "%%\n");
      atpr = 0;
    }
    ol = l;
  }
  fprintf(latex, "\\kill\n");
}

static boolean Change_envir_BOL(LINK)
struct LOC_Convert_second_pass *LINK;
{
  boolean hulp;

  hulp = false;

  hulp = ((LINK->envir[LINK->cur] == 'C' && LINK->envir[LINK->pre] != 'C') ||
          hulp);
  hulp = ((LINK->envir[LINK->cur] == 'T' && LINK->envir[LINK->pre] != 'T') ||
          hulp);
  hulp = ((LINK->envir[LINK->cur] == 'I' && LINK->envir[LINK->pre] != 'I') ||
          hulp);

  return hulp;
}

static boolean Change_envir_EOL(LINK)
struct LOC_Convert_second_pass *LINK;
{
  boolean hulp;

  hulp = false;

  hulp = (((LINK->envir[LINK->next] == 'C') ^ (LINK->envir[LINK->cur] == 'C')) ||
          hulp);
  hulp = (((LINK->envir[LINK->next] == 'T') ^ (LINK->envir[LINK->cur] == 'T')) ||
          hulp);
  hulp = (((LINK->envir[LINK->next] == 'I') ^ (LINK->envir[LINK->cur] == 'I')) ||
          hulp);

  return hulp;
}

static void Open_environment(LINK)
struct LOC_Convert_second_pass *LINK;
{
  if (!Change_envir_BOL(LINK)) {   /* andere environment ? */
    if (LINK->new_tabset[LINK->cur] && LINK->envir[LINK->cur] == 'T')
      Latex_tabset(LINK);
    return;
  }

  if (!LINK->attr_closed)
    Close_all_attr_BOL(LINK);

  switch (LINK->envir[LINK->cur]) {

  case 'C':
    fprintf(latex, "\\begin{center}\n");
    break;

  case 'T':
    fprintf(latex, "\\begin{tabbing}\n");
    Latex_tabset(LINK);
    break;

  case 'I':
    fprintf(latex, "\\begin{indenting}");
    fprintf(latex, "{%3.2fcm}",
            LINK->ind_leftmargin[LINK->cur] / 1200.0 * 2.54);
    fprintf(latex, "{%3.2fcm}",
            LINK->ind_rightmargin[LINK->cur] / 1200.0 * 2.54);
    if (LINK->ind_label[LINK->cur] == 1) {
      fprintf(latex, "%%\n");
      putc('{', latex);
    } else
      fprintf(latex, "{}\n");
    break;
  }
}

static void Close_environment(LINK)
struct LOC_Convert_second_pass *LINK;
{
  switch (LINK->envir[LINK->cur]) {

  case 'C':
    fprintf(latex, "\\end{center}\n");
    break;

  case 'T':
    fprintf(latex, "\\end{tabbing}\n");
    break;

  case 'I':
    fprintf(latex, "\\end{indenting}\n");
    break;
  }

  LINK->just_envir_closed = true;

}

static void Update_global_information(LINK)
struct LOC_Convert_second_pass *LINK;
{
  short j, FORLIM;

  if (LINK->new_tabset[LINK->cur]) {
    LINK->num_of_tabs = LINK->tabent_num_of_tabs[LINK->cur];
    FORLIM = LINK->num_of_tabs;
    for (j = 0; j < FORLIM; j++)
      LINK->tabpos[j] = LINK->tabent_tabpos[LINK->cur][j];
  }

  if (LINK->new_tabent_rightjust[LINK->cur])
    LINK->new_rightjust = LINK->tabent_rightjust[LINK->cur];

}

static void Change_tabelentry(LINK)
struct LOC_Convert_second_pass *LINK;
{
  short help;

  help = LINK->pre;
  LINK->pre = LINK->cur;
  LINK->cur = LINK->next;
  LINK->next = help;
  Read_tabelentry(LINK->next, LINK);
}

/*---SLAG2---*/

void Convert_second_pass(char *wpd_fn)
{
  struct   LOC_Convert_second_pass V;
  unsigned short regelnum;
  short    convperc, i;
  boolean  underline, rightjust;
  char     regel[MaxParLength], *ap, *fip;
  int      len_reg;

  V.pre = 0;
  V.cur = 1;
  V.next = 2;

  V.envir[V.pre] = ' ';
  V.new_tabset[V.pre] = false;

  V.just_envir_closed = true;
  V.attr_closed = false;

  rightjust = true;
  V.new_rightjust = true;
  for (i = 0; i <= 2; i++) {
    V.new_tabent_rightjust[i] = false;
    V.tabent_rightjust[i] = false;
  }

  Read_tabelentry(V.cur, &V);
  Read_tabelentry(V.next, &V);

  regelnum = 1;

  printf("\nSecond pass :     ");

  Latex_head(&V, wpd_fn);

  while ( ReadAndSplitLine(strip, regel) ) {

    Update_global_information(&V);

#ifndef sun
    convperc = floor (regelnum * 100.0 / num_of_lines_stripfile + 0.5 );
    if (convperc > 100) convperc = 100;
    printf("\b\b\b\b%3d%%", convperc);
#endif

    len_reg = strlen(regel);

    /* Meerdere spaties achter elkaar vervangen door harde spaties. */

    for (fip = (ap = regel) + len_reg - 1; ap < fip; ap++) {
      if ( (*ap == ' ' || *ap == '~') && *(ap + 1) == ' ')
         *(ap + 1) = '~';
    }

    if (V.new_rightjust ^ rightjust) {
      rightjust = V.new_rightjust;
      if (rightjust)
        fprintf(latex, "\\justified\n");
      else
        fprintf(latex, "\\raggedright\n");
    }

    Open_environment(&V);

    if (len_reg > 0) {
         if (V.attr_closed)
        Open_all_attr_BOL(&V);

   /* Zoek naar een illegaal argument en zet hier accolades voor. */

      if ((len_reg >= 1 && regel[0] == '[') ||
          (len_reg >= 2 && regel[0] == ' ' && regel[1] == '['))
        fputs("{}", latex);

      fputs(regel, latex);

      V.just_envir_closed = false;
    }

    switch (V.line_term[V.cur]) {   /*Case*/

    case 'r':
    case 'p':
          fputc('\n', latex);
      if (Change_envir_EOL(&V)) {
             if (!V.attr_closed) {
               Close_all_attr_EOL(&V);
                 }

             Close_environment(&V);
      }
      break;

    case 'R':
      if (V.envir[V.cur] == 'I') {
        if (!V.attr_closed)
          Close_all_attr_EOL(&V);

        putc('\n', latex);
        Close_environment(&V);
        V.envir[V.cur] = ' ';
      } else {
        underline = false;
        for (i = 0x1; i <= 0x10; i++)
          underline = (underline || V.attr_BOL[V.next][i] == 0xb ||
                       V.attr_BOL[V.next][i] == 0xe);

        if (underline && !V.attr_closed)
          Close_all_attr_EOL(&V);

        /* Elke Indent-environment moet na een harde Return*/
        /* Afgesloten worden.*/


        if (Change_envir_EOL(&V)) {
          if (V.just_envir_closed)
            fprintf(latex, "\\nwln\n");
          else
            putc('\n', latex);

          if (!V.attr_closed)
            Close_all_attr_EOL(&V);

          Close_environment(&V);
        } else {
          if (V.just_envir_closed)
            fprintf(latex, "\\nwln\n");
          else
            fprintf(latex, "\\\\\n");   /* Need to modify here */
        }
      }

      break;

    case 'P':
      if (!V.attr_closed)
        Close_all_attr_EOL(&V);

      putc('\n', latex);
      Close_environment(&V);
      fprintf(latex, "\\newpage\n");
      V.envir[V.cur] = ' ';
      break;

    }

    Change_tabelentry(&V);

    regelnum++;
  }

  Latex_foot(&V);
  putchar('\n');
}

