/***************************************************************************
                   ktexshell.h  -  header for the main class
                             -------------------
    begin                : Son Okt  1 17:17:42 CEST 2000
    copyright            : (C) 2000 by Arnd Fischer
    email                : lxuser@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTEXSHELL_H
#define KTEXSHELL_H

#include <qwidget.h>
#include <qmultilinedit.h>
#include <kapp.h>
#include <kfiledialog.h>
#include <ktmainwindow.h>
#include <kprocess.h>
#include <klocale.h>
#include <khelpmenu.h>
#include <qstring.h>
#include <qlist.h>
#include "ktsclosetex.h"
#include "ktsconfig.h"
#include <config.h>

#define KTS_VERSION VERSION
#define KTS_COPYRIGHT i18n( "KTeXShell - " \
		"A K Shell around TeX\nVersion " \
		KTS_VERSION \
		"\n\n(c) 2000, 2001 Arnd Fischer\n" \
		"lxuser@users.sourceforge.net\n\n" \
		"This software is licensed under the GPL." )

// declare the main object
class KTeXShell : public KTMainWindow
{
  Q_OBJECT 
  public:
    /** construtor */
    KTeXShell(const char *name=0, KAboutData *aboutData=0);
    /** destructor */
    ~KTeXShell();

	private: // private methods and variables
		/** read the configuration */
		void readConfig();
		/** save the configuration */
		void saveConfig();

	protected: // Protected methods
  	/** set up the status bar */
  	void setupStatusbar();
  	/** set up tool- and menubar */
  	void setupGUI();
		/** make other filenames from .tex-name */
		QString tex2other(const QString &, const QString &);
		/** the resize event for the main window */
		void resizeEvent(QResizeEvent *);
		/** test if we have a primary file to edit, compose etc. */
		bool testPrimary();
		/** test if we have a working dir */
		bool testWorkingDir(bool WARNING = true);
		/** get the working dir from the primary file */
		void getWDFromPrim();
		/** close app via "X" */
		bool queryClose();
		/** the output widget */
		QMultiLineEdit *outwidget;
		/** the external processes */
		KShellProcess *process, *texprocess;
		/** the problem solving dialog */
		KTSCloseTeX *closeTeXDialog;
		/** the configuration dialog */
		KTSConfig *configDialog;
		/** the internal process list */
		QList<pid_t> *processlist;
    /** the help menu */
		KHelpMenu *helpMenu;

    // the configuration data
		/** the working directory */
		QString workingDir;
		/** the primary file */
		QString primary;
		/** the template dir */
		QString templateDir;
		/** the TeX format */
		QString texFormat;
		/** the editor */
		QString editor;
		/** the dvi viewer */
		QString dviViewer;
		/** here are the configured programs stored */
		struct ConfPrograms {
			QStrList editors;
			QStrList formats;
			QStrList viewers;
		} ktsConfPrograms;

	protected slots: // Protected slots
		/** slot: quit the app */
		void slotQuit();
		/** set the selected file als primary */
		void slotSetPrimary();
		/** edit the primary file */
		void slotEditPrimary();
		/** call the dvi viewer */
		void slotView();
		/** call TeX to compose the document */
		void slotCompose();
		/** filter the TeX- (and other) Output */
		void slotFilterOutput(KProcess*, char* buffer, int len);
		/** set the working directory */
		void slotSetWorkingDir();
		/** Process is done */
		void slotProcessOK(KProcess*);
		/** test if TeX returned an error */
		void slotTestTeXOK();
		/** view the logfile */
		void slotViewLog();
		/** make the index */
		void slotMakeIndex();
		/** generate and set a new primay from template */
		void slotNewPrimFromTemplate();
		/** get the selected TeX error action */
		void slotGetAction(QString & action);
		/** open editor for a project file */
		void slotEditFile();
		/** the whole configuration */
		void slotConfSettings();
		/** set the template dir */
		void slotSetTempDir(QString td);
	  /** set the dvi viewer */
  	void slotSetViewer(QString v);
  	/** set the compose format */
  	void slotSetFormat(QString f);
  	/** set the editor */
  	void slotSetEditor(QString ed);
		/** set the available programs */
		void slotSetConf(ConfPrograms *confPrograms);
		/** clear the output window */
		void slotClearOutput();
		/** clear the working dir from all TeX output */
		void slotClearWD();
		/** print the primary DVI-file */
		void slotPrint();
		/** an entry from the dynamic menu is choosen */
		void slotMenuFormatChoosen(int id);

	signals: // Signals
		/** provides the process output suitable for QMultiLineEdit::append */	
		void signalProcessOutput(const QString &buf);
};

#endif
