(* 12/18/1991 Dan Dill dan@chem.bu.edu *)

(* See also PSTeX.m, which does *not* include the prolog in the file. *)

Unprotect[System`PSTeXpro]

System`PSTeXpro::usage = "PSTeXpro[-graphics-, \"file\"].  Process a graphics
object to a PostScript file for inclusion is a TeX document (using \\psfig).
Quotes are required around the file name and suffix `.ps' is added.  The
graphic object is preprocessed through psfix to prepend the Mathematica
PostScript precedures to the file, so that it can be included in the TeX
document directly (for example, with \\psfig{figure=file.ps}).  The height of
the scaled graphic is PSTeXHeight (default 100) in big points (72 bp per
inch).  For example,

\n
\n
\t PSTeXpro[myplot, \"p4/myplot\"]
\n
\n
  will convert the graphics object myplot to the PostScript file myplot.ps in
the subdirectory p4 of the current directory.

\n
\n
  Note: PSTeXpro yields a graphic scaled to height PSTeXHeight and without
centering or margins, and so is not generally suitable for printing.  Use
PSFile to produce a graphic in a file, centered and scaled to fill the whole
page."

If[ !ValueQ[PSTeXHeight], PSTeXHeight = 100];

System`PSTeXpro::file = "Graphics being processed (with prolog) to file \"`1`\".";

Begin["System`Private`"]
PSTeXpro[g_, f_String] := Block[{filename},
    filename = StringJoin[f, ".ps"];
    Message[PSTeXpro::file, filename ];
    Display[StringJoin[
	"! psfix",
	" | ",
	"addBBoxpro",
	" ",
	ToString[PSTeXHeight],
	" > ",
	filename
	], g]
]
End[]

Protect[PSTeXpro]
