/*
 *	Header file for VMS I/O.
 *
 *	Define the BAB (Block Access I/O Block) used for stream file I/O.
 */

#include fab
#include rab
#include xab
#include nam

struct BAB {
	unsigned char bab$b_bid;	/* Block Id */
	unsigned char bab$b_bln;	/* Block size in bytes */
	unsigned short bab$w_flags;	/* Flags word */
#define BAB_IO_BLOCKED     0x0001
#define BAB_BUFFER_WRITTEN 0x0002
#define BAB_VAR_FORMAT     0x0004
	struct RAB *bab$l_rab;		/* Pointer to RAB */
	unsigned long *bab$l_rcidx;	/* Record index for non-block i/o */
	char *bab$l_eof;		/* Pointer to EOF byte */
	char *bab$l_bfp;		/* Pointer to next character in buffer */
	char *bab$l_eolstr;		/* End-of-Line string */
	unsigned long bab$l_vbn;	/* Virtual block number */
	unsigned long bab$l_nrecs;	/* Number of records */
	unsigned long bab$l_nreads;	/* Number of reads from file */
	unsigned long bab$l_nwrites;	/* Number of writes to file */
	unsigned short bab$w_hsz;	/* Size of remaining buffer */
	unsigned short bab$w_eolslen;	/* End-of-Line string length */
};

#define BAB$C_BID 0x80
#define BAB$C_BLN sizeof (struct BAB)
#define BAB$K_BLN sizeof (struct BAB)

/*
 *	The DCB (Device Control Block) is used to provide control in
 *	directly accessing a device. The Buffer control block, an auxiliary
 *	component to the DCB, provides output buffering control.
 */

struct BCB {
	unsigned char bcb$b_bid;	/* Block Id */
	unsigned char bcb$b_bln;	/* Block size in bytes */
	unsigned short bcb$w_flags;	/* Flags word */
#define BCB$M_ACTIVE 0x0001		/* I/O in progress */
	struct DCB *bcb$l_dcb;		/* Back-pointer to Device Control Block */
	struct BCB *bcb$l_nxt;		/* Pointer to next buffer in chain */
	char *bcb$l_buf;		/* Pointer to start of buffer */
	char *bcb$l_bfp;		/* Pointer to next available byte */
	struct Write_IO_Status_Block bcb$l_ios; /* I/O status block */
	unsigned long bcb$l_evf;	/* Event flag for I/O on this buffer */
	unsigned short bcb$w_bsz;	/* The buffer size in bytes */
	unsigned short bcb$w_hsz;	/* Amount of buffer remaining */
};

#define BCB$C_BID 0x81
#define BCB$C_BLN sizeof (struct BCB)
#define BCB$K_BLN sizeof (struct BCB)

struct DCB {
	unsigned char dcb$b_bid;	/* Block Id */
	unsigned char dcb$b_bln;	/* Block size in bytes */
	unsigned short dcb$w_flags;	/* Flags word */
	struct BCB *dcb$l_bcb;		/* Pointer to first buffer */
	struct BCB *dcb$l_abf;		/* Pointer to active buffer */
	struct Read_IO_Status_Block dcb$l_ios; /* I/O status block for reads */
	struct Mailbox_IO_Status_Block dcb$l_mbxios; /* Mailbox I/O status block */
	struct dsc$descriptor dcb$l_maskdesc; /* Terminator mask descriptor */
	unsigned long dcb$l_evf;	/* Event flag for read I/O */
	unsigned long dcb$l_mbxevf;	/* Mailbox event flag */
	unsigned long dcb$l_devchar[8];	/* Device characteristics */
	unsigned long dcb$l_tmask[8];	/* Terminator mask for reads */
	unsigned long dcb$l_nreads;	/* Number of reads from device */
	unsigned long dcb$l_nwrites;	/* Number of writes to device */
	unsigned short dcb$w_chan;	/* VMS I/O channel number */
	unsigned short dcb$w_mbxchan;	/* Associated mailbox channel */
	unsigned short dcb$w_nbf;	/* Number of buffers */
	char dcb$b_devname[64];		/* Device name */
};

#define DCB$C_BID 0x82
#define DCB$C_BLN sizeof (struct DCB)
#define DCB$K_BLN sizeof (struct DCB)

/*
 *	Define the Library Access Block - used for VMS libraries:
 */

struct LFAB {
	unsigned char lfab$b_bid;	/* Block Id */
	unsigned char lfab$b_bln;	/* Block size in bytes */
	unsigned short lfab$w_flags;	/* Flags word */
	struct NAM *lfab$l_nam;		/* NAM block pointer */
	unsigned long lfab$l_index;	/* Library Index */
	unsigned long lfab$l_type;	/* Library type */
	unsigned long lfab$l_func;	/* READ or UPDATE */
};
#define LFAB$C_BID 0x83
#define LFAB$C_BLN sizeof (struct LFAB)
#define LFAB$K_BLN sizeof (struct LFAB)

/*
 *	Also, the control blocks for a file within the library:
 */

struct LRAB {
	unsigned char lrab$b_bid;	/* Block Id */
	unsigned char lrab$b_bln;	/* Block size in bytes */
	unsigned short lrab$w_flags;	/* Flags word */
#define LRAB$M_EOF    0x0001
#define LRAB$M_EOLSTR 0x0002
	struct LFAB *lrab$l_lfab;	/* Pointer to LFAB */
	struct dsc$descriptor lrab$l_eoldesc; /* Descriptor for end of line string */
	struct dsc$descriptor lrab$l_bufdesc; /* Whole buffer descriptor */
	struct dsc$descriptor lrab$l_curdesc; /* Current buffer descriptor */
	unsigned long lrab$l_rfa[2];	/* RFA address of file */
	unsigned long lrab$l_nreads;	/* Number of reads from module */
	unsigned long lrab$l_nwrites;	/* Number of writes to module */
};
#define LRAB$C_BID 0x84
#define LRAB$C_BLN sizeof (struct LRAB)
#define LRAB$K_BLN sizeof (struct LRAB)
