#include "symbiont.h"

#define Copy_Array(a,b) *(struct { char x[sizeof(b)]; } *) b = *(struct { char x[sizeof(b)]; } *) a

char Scratch_String[256];

/*
 *	Routine Read_Message_Items gets all of the items and places them
 *	into the stream thread descriptor:
 */

unsigned long Read_Message_Items (Msg_Desc, Thread_Ptr)
struct dsc$descriptor *Msg_Desc;
struct Thread *Thread_Ptr;
{
	auto   union smbmsg$r_item_data *Item_Ptr;
	auto   unsigned long Sys_Status, Index;
	auto   unsigned char *Data_Ptr, *Ptr;
	static struct dsc$descriptor Buf_Desc = { 0, 0, 0, 0 };
	static struct dsc$descriptor Str_Desc;
	static unsigned long Context, Item_Code;
	static unsigned short Size;
	extern unsigned long Smb$Read_Message_Item(), Str$Copy_R();
	extern unsigned long Process_Option();
	globalvalue SMB$_NOMOREITEMS, SS$_NORMAL;
/*
 *	First, allocate a dynamic string descriptor to be used henceforth
 *	if it has not already been done.
 */
	if (Buf_Desc.dsc$b_class == 0)
		Set_Dynamic_VMS_Descriptor (&Buf_Desc);
/*
 *	Initialize context; read in one item and perform the necessary
 *	processing to reduce it to useable form:
 */
	Context = 0;
	while ((Sys_Status = Smb$Read_Message_Item (Msg_Desc, &Context, &Item_Code,
						    &Buf_Desc, &Size)) == SS$_NORMAL) {
		Item_Ptr = (union smbmsg$r_item_data *) Buf_Desc.dsc$a_pointer;
		Data_Ptr = &Item_Ptr->smbmsg$b_char_data[0];
		switch (Item_Code) {

		case SMBMSG$K_ACCOUNT_NAME:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Account_Name, &Size, Data_Ptr);
			break;

		case SMBMSG$K_AFTER_TIME:
			Thread_Ptr->After_Time = Item_Ptr->smbmsg$q_quadword_data[0];
			break;

		case SMBMSG$K_ALIGNMENT_PAGES:
			Thread_Ptr->Alignment_Pages = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_BOTTOM_MARGIN:
			Thread_Ptr->Bottom_Margin = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_CHARACTERISTICS:
			Copy_Array (Data_Ptr, Thread_Ptr->Characteristics);
			break;

		case SMBMSG$K_CHECKPOINT_DATA:
			Thread_Ptr->Checkpoint_Data = Item_Ptr->smbmsg$checkpoint_data;
			break;

		case SMBMSG$K_DEVICE_NAME:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Device_Name, &Size, Data_Ptr);
			break;

		case SMBMSG$K_ENTRY_NUMBER:
			Thread_Ptr->Entry_Number = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_EXECUTOR_QUEUE:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Executor_Queue, &Size, Data_Ptr);
			break;

		case SMBMSG$K_FILE_COPIES:
			Thread_Ptr->File_Copies = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_FILE_COUNT:
			Thread_Ptr->File_Count = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_FILE_SETUP_MODULES:
			Sys_Status = Str$Copy_R (&Thread_Ptr->File_Setup_Modules, &Size, Data_Ptr);
			break;

		case SMBMSG$K_FIRST_PAGE:
			Thread_Ptr->First_Page = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_FORM_LENGTH:
			Thread_Ptr->Form_Length = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_FORM_NAME:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Form_Name, &Size, Data_Ptr);
			break;

		case SMBMSG$K_FORM_SETUP_MODULES:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Form_Setup_Modules, &Size, Data_Ptr);
			break;

		case SMBMSG$K_FORM_WIDTH:
			Thread_Ptr->Form_Width = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_FILE_IDENTIFICATION:
			Copy_Array (Data_Ptr, Thread_Ptr->File_Identification);
			break;

		case SMBMSG$K_MESSAGE_VECTOR:
			Thread_Ptr->N_Message_Values = Item_Ptr->smbmsg$l_longword_data[0];
			for (Index = 0; Index < Thread_Ptr->N_Message_Values; Index++)
				Thread_Ptr->Message_Vector[Index] =
					Item_Ptr->smbmsg$l_longword_data[Index+1];
			break;

		case SMBMSG$K_FILE_SPECIFICATION:
			Sys_Status = Str$Copy_R (&Thread_Ptr->File_Specification, &Size, Data_Ptr);
			break;

		case SMBMSG$K_JOB_COPIES:
			Thread_Ptr->Job_Copies = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_JOB_COUNT:
			Thread_Ptr->Job_Count = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_JOB_NAME:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Job_Name, &Size, Data_Ptr);
			break;

		case SMBMSG$K_JOB_RESET_MODULES:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Job_Reset_Modules, &Size, Data_Ptr);
			break;

		case SMBMSG$K_LAST_PAGE:
			Thread_Ptr->Last_Page = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_LEFT_MARGIN:
			Thread_Ptr->Left_Margin = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_LIBRARY_SPECIFICATION:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Library_Specification, &Size, Data_Ptr);
			break;

		case SMBMSG$K_NOTE:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Note, &Size, Data_Ptr);
			break;

		case SMBMSG$K_PAGE_SETUP_MODULES:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Page_Setup_Modules, &Size, Data_Ptr);
			break;

		case SMBMSG$K_PARAMETER_1: case SMBMSG$K_PARAMETER_2:
		case SMBMSG$K_PARAMETER_3: case SMBMSG$K_PARAMETER_4:
		case SMBMSG$K_PARAMETER_5: case SMBMSG$K_PARAMETER_6:
		case SMBMSG$K_PARAMETER_7: case SMBMSG$K_PARAMETER_8:
			Set_VMS_Descriptor (Data_Ptr, Size, &Str_Desc);
			Copy_Desc_to_String (&Str_Desc, Scratch_String, sizeof (Scratch_String));
			for (Ptr = &Scratch_String[0]; *Ptr != '\0'; Ptr++)
			if (*Ptr == ':' || *Ptr == '=') {
				*Ptr++ = '\0';
				break;
			}
			Sys_Status = Process_Option (Scratch_String, Ptr, Thread_Ptr);
			break;

		case SMBMSG$K_PRIORITY:
			Thread_Ptr->Priority = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_PRINT_CONTROL:
			Thread_Ptr->Print_Control = Item_Ptr->smbmsg$print_control.smbmsg$l_print_flags;
			break;

		case SMBMSG$K_QUEUE:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Queue, &Size, Data_Ptr);
			break;

		case SMBMSG$K_RELATIVE_PAGE:
			Thread_Ptr->Relative_Page = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_RIGHT_MARGIN:
			Thread_Ptr->Right_Margin = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_REQUEST_CONTROL:
			Thread_Ptr->Request_Control = Item_Ptr->smbmsg$request.smbmsg$l_request_flags;
			break;

		case SMBMSG$K_SEARCH_STRING:
			Sys_Status = Str$Copy_R (&Thread_Ptr->Search_String, &Size, Data_Ptr);
			break;

		case SMBMSG$K_SEPARATION_CONTROL:
			Thread_Ptr->Separation_Control = Item_Ptr->smbmsg$separation_control.smbmsg$l_separation_flags;
			break;

		case SMBMSG$K_STOP_CONDITION:
			Thread_Ptr->Stop_Condition = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_TIME_QUEUED:
			Thread_Ptr->Time_Queued = Item_Ptr->smbmsg$q_quadword_data[0];
			break;

		case SMBMSG$K_TOP_MARGIN:
			Thread_Ptr->Top_Margin = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_UIC:
			Thread_Ptr->Uic = Item_Ptr->smbmsg$l_longword_data[0];
			break;

		case SMBMSG$K_USER_NAME:
			Sys_Status = Str$Copy_R (&Thread_Ptr->User_Name, &Size, Data_Ptr);
			break;
		}
		Set_Item (Item_Code, Thread_Ptr);
		if ((Sys_Status & 0x01) == 0)
			break;
	}
	if (Sys_Status == SMB$_NOMOREITEMS)
		Sys_Status = SS$_NORMAL;
	return (Sys_Status);
}

/*
 *	Routine Process_Option interprets parameters passed via the
 *	/PARAMETER print option. This includes:
 *
 *	/PARAMETER=MANUAL_FEED     Specifies single-page feed for main file.
 *	/PARAMETER=TEXT_FILE       Main file is an ordinary text file (not
 *                                 PostScript) [future extension].
 *	/PARAMETER=FORM:form_name  Specifies a form name for the operator.
 *	/PARAMETER=STATISTICS      Outputs special statistics page
 */

unsigned long Process_Option (Keyword, Value, Thread_Ptr)
char *Keyword, *Value;
struct Thread *Thread_Ptr;
{
	struct Option_Value {
		char *Keyword_Value;
		unsigned long Mask;
		unsigned long Control;
#define CTL_M_MIN_CHARS 0x00000003
#define CTL_M_NEGATION  0x00000004
		struct dsc$descriptor *Value_Ptr;
	};
	auto   struct Option_Value Keyword_List[] = {
		{ "MANUAL_FEED", TASK_M_MANUAL_FEED, CTL_M_NEGATION | 1, 0 },
		{ "TEXT_FILE",   TASK_M_TEXT_FILE,   CTL_M_NEGATION | 1, 0 },
		{ "FORM",        TASK_M_FORM,        1, &Thread_Ptr->Form_Type },
		{ "STATISTICS",  TASK_M_STATISTICS,  CTL_M_NEGATION | 1, 0 },
		{ 0 }
	};
	auto   struct Option_Value *Option_Ptr;
	auto   unsigned long Sys_Status;
	auto   int Indicator;
	static unsigned short Length;
	extern unsigned long Str$Copy_R();
	extern int Compare_Keyword(), strlen();
	globalvalue SS$_NORMAL;

	Sys_Status = SS$_NORMAL;
	Indicator = 0;
	for (Option_Ptr = &Keyword_List[0]; Indicator == 0 && Option_Ptr->Keyword_Value != 0; Option_Ptr++) {
		Indicator = Compare_Keyword (Keyword, Option_Ptr->Keyword_Value,
					     Option_Ptr->Control & CTL_M_MIN_CHARS, 4,
					     Option_Ptr->Control & CTL_M_NEGATION);
		if (Indicator == 1) {
			Thread_Ptr->Task_Options |= Option_Ptr->Mask;
			if (Option_Ptr->Value_Ptr != 0) {
				Length = strlen (Value);
				Sys_Status = Str$Copy_R (Option_Ptr->Value_Ptr, &Length, Value);
			}
		} else if (Indicator == -1)
			Thread_Ptr->Task_Options &= ~Option_Ptr->Mask;
	}
	return (Sys_Status);
}
#undef CTL_M_MIN_CHARS
#undef CTL_M_NEGATION

/*
 *	Routine Send_JBC_Message constructs and sends a message to the
 *	Job Controller:
 */

unsigned long Send_JBC_Message (Request, Flags, Thread_Ptr)
unsigned long Request;
unsigned short Flags;
struct Thread *Thread_Ptr;
{
	auto   unsigned long Sys_Status, Index;
	static struct dsc$descriptor Acnt_Desc, Ckpt_Desc;
	extern unsigned long SMB$Send_to_JobCtl();
	globalvalue SMB$_NOMOREITEMS, SS$_JBCERROR;
/*
 *	Construct descriptors for accounting data and checkpoint data:
 */
	if ((Flags & JBC_ACNT) != 0)
		Set_VMS_Descriptor (&Thread_Ptr->Accounting_Data, sizeof (Thread_Ptr->Accounting_Data),
				    &Acnt_Desc);
	if ((Flags & JBC_CKPT) != 0)
		Set_VMS_Descriptor (&Thread_Ptr->Checkpoint_Data, sizeof (Thread_Ptr->Checkpoint_Data),
				    &Ckpt_Desc);
/*
 *	Convert all return status values to have '%SMB-' in front:
 */
	if ((Flags & JBC_ERR) != 0)
		for (Index = 0; Index < Thread_Ptr->N_Condition_Values; Index++) {
			Thread_Ptr->Condition_Vector[Index] &= 0xF000FFFF;
			Thread_Ptr->Condition_Vector[Index] |= SMB$_NOMOREITEMS & 0x0FFF0000;
		}
/*
 *	Send the message:
 */
	Sys_Status = SMB$Send_to_JobCtl (&Thread_Ptr->Stream_Number, &Request,
					 ((Flags & JBC_ACNT) == 0) ? 0 : &Acnt_Desc,
					 ((Flags & JBC_CKPT) == 0) ? 0 : &Ckpt_Desc,
					 ((Flags & JBC_DVST) == 0) ? 0 : &Thread_Ptr->Device_Status,
					 ((Flags & JBC_ERR) == 0 || Thread_Ptr->N_Condition_Values == 0) ?
						0 : &Thread_Ptr->N_Condition_Values);
	if ((Sys_Status & 0x01) == 0)
		Sys_Status = SS$_JBCERROR;
	return (Sys_Status);
}

Set_Item (Item, Thread_Ptr)
struct Thread *Thread_Ptr;
unsigned long Item;
{
	if (Item < 8 * sizeof (Thread_Ptr->Item_Flags))
		Thread_Ptr->Item_Flags[Item>>5] |= (1 << (Item & 0x1F));
}

int Test_Item (Item, Thread_Ptr)
unsigned long Item;
struct Thread *Thread_Ptr;
{
	if (Item >= 8 * sizeof (Thread_Ptr->Item_Flags) ||
	    (Thread_Ptr->Item_Flags[Item>>5] & (1 << (Item&0x1F))) == 0)
		return (0);
	else
		return (1);
}
