/* -*-C-*- */
#define VERSION_NO  "2"  /* DVI driver version number */

#define  DEVICE_ID  "Version 1.1 Silicon Graphics Iris workstation"
/* this string is printed at runtime */

#define DEBUG  1    /* for optional massive trace printing */
#undef DEBUG      /* do not want this now */

#define OS_UNIX    1
#define ATT    1

#undef BSD42
/* #define BSD42    1  /* want DVISPOOL code in dviterm.h */
  
#define USEGLOBALMAG  1
#define VIRTUAL_FONTS  0
#define ALLOW_INTERRUPT  0  /* to allow ^C for debugging */
  /* undefine for normal catch-^C mode */
  
#define ARITHRSHIFT  1  /* most C compilers use arithmetic right
			 * shift */
#define FASTZERO  0
#define MAXFNAME  256  /* longest host complete filename */
#define HOST_WORD_SIZE  32  /* must be 32 or larger -- used in */
  /* signex to pack 8-bit bytes back */
  /* into integer values, and in dispchar */
  /* and fillrect for managing character */
  /* raster storage. */
#define  BYTE_SIZE        8  /* output file byte size */
  
#define  FIRSTBGCHAR   32
#define  LASTBGCHAR  127
  
#define DVIEXT    ".dvi"
#define DVIPREFIX  "dvi-"
#define SUBEXT    ".sub"
#define SUBNAME    "texfonts"
#define DVIHELP    "man texsgi\n"
  
#define DISKFULL(fp)  (ferror(fp) && (errno == ENOSPC))
#define FILE_CNT(fp)  (fp)->_cnt
#define FILE_BASE(fp)  (fp)->_base
#define FILE_PTR(fp)  (fp)->_ptr
  
#define MAXDRIFT  2  /* we insist that
		      * abs|(hh-pixel_round(h))<=MAXDRIFT| */
  
#ifdef FONTLIST      /* can be set at compile time */
#else
#define FONTLIST  "PK-GF"  /* preferred search order */
#endif        /* FONTLIST */
  
#ifdef FONTPATH      /* can be set at compile time */
#else
#define FONTPATH  "/usr/local/share/tex82/fonts/"
#endif
  
#ifdef SUBPATH      /* can be set at compile time */
#else
#define SUBPATH    "/usr/local/tex/macros/"
#endif
  
#if    TEXINPUTS    /* can be set at compile time */
#else
#define TEXINPUTS  "TEXINPUTS"
#endif
  
#if    TEXFONTS      /* can be set at compile time */
#else
#define TEXFONTS  "TEXFONTS"
#endif
  
#define  NPXLCHARS  256
#define  MAXSTR    257  /* DVI file text string size */
  
#include <stdio.h>    /* must come after the others to */
  /* enable type checking */
#include <errno.h>    /* needed only for DISKFULL() definition */
#if    (BSD41 | BSD42)
extern int      errno;    /* not in all errno.h files, sigh... */
#endif

/*
 * types.h and stat.h are needed for fstat(), which is used by special() and
 * the virtual font mechanism in openfont.h to get the input file size.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <math.h>
#include <signal.h>

#if    BSD42
#include <sys/ioctl.h>    /* need for DVISPOOL in dviterm.h */
#ifndef _NFILE
#include <sys/param.h>
#ifdef NOFILE
#define _NFILE NOFILE    /* need for gblvars.h */
#else
#define _NFILE MAXOPEN    /* use our font limit value */
#endif
#endif
#endif        /* BSD42 */
#include <limits.h>
#define MAXOPEN    (OPEN_MAX - 6)

/*
 * Typedefs
 */

typedef unsigned char BOOLEAN;  /* value in (FALSE,TRUE) */
     
#define  FALSE      0
#define  TRUE      1
     
typedef unsigned char BYTE;  /* unsigned 8-bit integers */
typedef short int INT8;    /* signed  8-bit integers (C has no "signed
			    * char" type) yet */
typedef short int INT16;  /* signed 16-bit integers */
typedef long    INT32;    /* signed 32-bit integers */
     
typedef unsigned short UNSIGN16;/* unsigned 16-bit integers */
     
typedef unsigned long UNSIGN32;  /* unsigned 32-bit integers */
     
typedef short int COORDINATE;  /* signed integer (x,y) coordinate */
     /* variable in bit map */
struct char_entry {    /* character entry        */
  COORDINATE      wp, hp;  /* width and height in pixels      */
  COORDINATE      xoffp, yoffp;  /* x offset and y offset in pixels    */
  long            fontrp;  /* font file raster pointer      */
  UNSIGN32        tfmw;  /* TFM width          */
  INT32           dx, dy;  /* character escapements      */
  UNSIGN16        pxlw;  /* pixel width == round(TFM width in    */
  /* pixels for .PXL files, or      */
  /* float(char_dx)/65536.0 for .GF and .PK */
  /* files)          */
  INT16           refcount;  /* reference count for memory
			      * management  */
  UNSIGN32       *rasters;/* raster description (dynamically loaded) */
  
  BOOLEAN         istoobig;  /* is the character too big? */
  BOOLEAN         isloaded;  /* is the character loaded? */
  INT16           bgfont, bgchar;  /* font and character      */
  
};
     
struct font_entry {
  struct font_entry *next;/* pointer to next font entry       */
  void            (*charxx) ();  /* pointer to chargf(), charpk()           */
  FILE           *font_file_id;  /* file identifier (NULL if none)     */
  INT32           k;  /* font number                             */
  UNSIGN32        c;  /* checksum                                */
  UNSIGN32        d;  /* design size                             */
  UNSIGN32        s;  /* scale factor                            */
  INT32           font_space;  /* computed from FNT_DEF s parameter     */
  UNSIGN32        font_mag;  /* computed from FNT_DEF s and d
			      * parameters */
  UNSIGN32        magnification;  /* magnification read from PXL file     */
  UNSIGN32        designsize;  /* design size read from PXL file     */
  UNSIGN32        hppp;  /* horizontal pixels/point * 2**16     */
  UNSIGN32        vppp;  /* vertical pixels/point * 2**16     */
  INT32           min_m;  /* GF bounding box values       */
  INT32           max_m;
  INT32           min_n;
  INT32           max_n;
  
  BYTE            font_type;  /* GF, PK  font file       */
  BYTE            a;  /* length of font area in n[]              */
  BYTE            l;  /* length of font name in n[]              */
  char            n[MAXSTR];  /* font area and name                      */
  char            name[MAXSTR];  /* full name of PXL file       */
  struct char_entry ch[NPXLCHARS];  /* character information       */
};
     
struct font_list {
  FILE           *font_id;/* file identifier         */
  INT16           use_count;  /* count of "opens"         */
};
     
/*--------------------------------------------------------------------
 * DVI file opcodes
 *--------------------------------------------------------------------*/

#define  SETC_000    0
     /* SETC_001 .. SETC_126 not required */
#define  SETC_127  127
#define  SET1          128
#define  SET2          129
#define  SET3          130
#define  SET4          131
#define  SET_RULE      132
#define  PUT1          133
#define  PUT2          134
#define  PUT3          135
#define  PUT4          136
#define  PUT_RULE      137
#define  NOP           138
#define  BOP           139
#define  EOP           140
#define  PUSH          141
#define  POP           142
#define  RIGHT1        143
#define  RIGHT2        144
#define  RIGHT3        145
#define  RIGHT4        146
#define  W0            147
#define  W1            148
#define  W2            149
#define  W3            150
#define  W4            151
#define  X0            152
#define  X1            153
#define  X2            154
#define  X3            155
#define  X4            156
#define  DOWN1         157
#define  DOWN2         158
#define  DOWN3         159
#define  DOWN4         160
#define  Y0            161
#define  Y1            162
#define  Y2            163
#define  Y3            164
#define  Y4            165
#define  Z0            166
#define  Z1            167
#define  Z2            168
#define  Z3            169
#define  Z4            170
#define  FONT_00    171
     /* FONT_01 .. FONT_62 not required */
#define  FONT_63    234
#define  FNT1          235
#define  FNT2          236
#define  FNT3          237
#define  FNT4          238
#define  XXX1          239
#define  XXX2          240
#define  XXX3          241
#define  XXX4          242
#define  FNT_DEF1      243
#define  FNT_DEF2      244
#define  FNT_DEF3      245
#define  FNT_DEF4      246
#define  PRE           247
#define  POST          248
#define  POST_POST     249
     
     /*--------------------------------------------------------------------
      * GF file opcodes
      *--------------------------------------------------------------------*/
     
#define  GFPAINT0        0
#define  GFPAINT1       64
#define  GFPAINT2       65
#define  GFPAINT3       66
#define  GFBOC          67
#define  GFBOC1         68
#define  GFEOC          69
#define  GFSKIP0        70
#define  GFSKIP1        71
#define  GFSKIP2        72
#define  GFSKIP3        73
#define  GFNROW0        74
#define  GFEOF         223
#define  GFNROWMAX     238
#define  GFXXX1        239
#define  GFXXX2        240
#define  GFXXX3        241
#define  GFXXX4        242
#define  GFYYY         243
#define  GFNOOP        244
#define  GFCHLOC       245
#define  GFCHLOC0      246
#define  GFPRE         247
#define  GFPOST        248
#define  GFPOSTPOST    249
     
#define  GFID          131
     
     /*--------------------------------------------------------------------
      * GF file opcodes
      *--------------------------------------------------------------------*/
     
#define  PKXXX1        240
#define  PKXXX2        241
#define  PKXXX3        242
#define  PKXXX4        243
#define  PKYYY         244
#define  PKPOST        245
#define  PKNOOP        246
#define  PKPRE         247
     
#define  PKID           89
     
     /*--------------------------------------------------------------------*/
     
#include "gl.h"
#include "device.h"
     
#define  NBGFONTS    3
     
#define  XSIZE    1280  /* number of horizontal dots */
#define  YSIZE    1024  /* number of vertical dots */
     
#define  XDPI    118  /* horizontal dots/inch */
#define  YDPI    118  /* vertical dots/inch */
     
#define  XDIFFMAX  20
#define  XDIFFORG  (FIRSTBGCHAR+XDIFFMAX)
#define  YDIFFMAX  20
#define  YDIFFORG  (FIRSTBGCHAR+XDIFFMAX+1+XDIFFMAX+YDIFFMAX)
     
#define  FGCOLOR  BLACK
#define  BGCOLOR  WHITE
     
     /*
      * set entry in parray to fgcolor
      */
#define  SETPKBIT(y, x) parray[x + (c_height - (y) - 1)*c_width] = fgcolor
#define  PKBIT(y, x) parray[x + (c_height - (y) - 1)*c_width]


#define  SETBIT(m) parray[(m-min_m) + \
			  (n-min_n)*(max_m - min_m + 1)] = fgcolor
#define  TESTBIT(m) (parray[(m-min_m) + \
			    (n-min_n)*(max_m - min_m + 1)] == fgcolor)
     
#define MAXFRAC   2    /* maximum fractional step divisor */
#define NORMFRAC  8    /* normal fractional step divisor */
#define MINFRAC  32    /* minimum fractional step divisor */
#define DIGVAL(c) (INT16)(c - '0')
     
     /*--------------------------------------------------------------------*/
     
     
#define ISSET(s, i) ((s) & (1 << (31 - (i))))
#define  ABS(x)    ((x) < 0 ? -(x) : (x))
#define  DBGOPT(flag)  (debug_code & (flag))
#define  DBG_PAGE_DUMP  0x0001
#define  DBG_CHAR_DUMP  0x0002
#define  DBG_POS_CHAR  0x0004
#define  DBG_OKAY_OPEN  0x0008
#define  DBG_FAIL_OPEN  0x0010
#define  DBG_OFF_PAGE  0x0020
#define  DBG_FONT_CACHE  0x0040
#define  DBG_SET_TEXT  0x0080
#define  DEBUG_OPEN(fp,fname,openmode) dbgopen(fp,fname,openmode)
#define  DVIFORMAT    2
#define  FIRSTPXLCHAR    0
#define  FT_GF    0
#define  FT_PK    1
#define  FT_PXL    2
#define  IN(a,b,c)  (((a) <= (b)) && ((b) <= (c)))
     
     /*
      * Computer Modern has 128 characters (0..127), but Japanese fonts and
      * extended European Computer Moderns may have up to 256 (0..255) characters
      */
#define  LASTPXLCHAR  255
     
#define  MAGSIZE(f)  ((UNSIGN32)(1000.0*(f) + 0.5))
     
#ifdef MAX
#undef MAX
#endif
#define  MAX(a,b)  ((a) > (b) ? (a) : (b))
#define  MAXFONTS       32  /* number of fonts per job (HPLJ, Canon A2) */
#define  MAXMSG    1024  /* message[] size--big enough for 2 file
			  * names */
#define  MAXPAGE  999  /* limit on number of pages in a DVI file */
#define  MAXREQUEST  256  /* limit on number of explicit page print
			   * requests */
#define  MAXSPECIAL  500  /* limit on \special{} string size; it need
			   * not be larger than TeX's compile-time
			   * parameter buf_siz, which is 500 in
			   * Standard TeX-82 */
     
#define  MAXFORMATS   2  /* number of font file naming formats */
#define  MIN_M    -500  /* GF character image extents */
#define  MAX_M    1500
#define  MIN_N    -500
#define  MAX_N    1500
     
#ifdef MIN
#undef MIN
#endif
#define  MIN(a,b)  ((a) < (b) ? (a) : (b))
     
#define NL(fp) (void)putc((char)'\n',fp)  /* want bare <LF> */
     
#define  ONES     ~0  /* a word of all one bits */
     
#define  PIXROUND(n,c)  ((COORDINATE)(((float)(n))*(c) + 0.5))
     
#define  STDMAG  590    /* 1500/(1.2**5) to stay in magstep family */
     
#define  RESOLUTION  (((float)STDMAG)/5.0)  /* dots per inch */
#define  STACKSIZE  100
     
#define  VISIBLE(t) ((t->wp > 0) && (t->hp > 0))
     /* true if both pixel height and width are non-zero */
     
#define MAGTABSIZE (sizeof(mag_table) / sizeof(float))
     
