Cursor hourglass = {0xFFFF, 0x47E2, 0x23C4, 0x1188, 
		      0x0890, 0x0420, 0x02C0, 0x02C0, 
		      0x02C0, 0x02C0, 0x06E0, 0x0810, 
		      0x1008, 0x2004, 0x4002, 0xFFFF};

char            curpath[MAXFNAME];  /* current file area */
char            curext[MAXFNAME];  /* current file extension */
char            curname[MAXFNAME];  /* current file name */

UNSIGN16        debug_code;  /* 0 for no debug output */

char            dviname[MAXFNAME];  /* DVI filespec */
char            dvoname[MAXFNAME];  /* device output filespec */

char            fontlist[MAXSTR];  /* FONTLIST environment string */
char            fontpath[MAXFNAME];  /* font directory path */

char            helpcmd[MAXSTR];/* where to look for help */

char            message[MAXMSG];/* for formatting error messages */

/***********************************************************************
  Magnification table for 118dpi, 300dpi devices
  ***********************************************************************/
float    mag_table[] = {
/* 118 DPI */
  0.59,
  0.645,
  0.71,
  0.85,
  1.02,
  1.225,
  1.47,
  1.76,
/* 300 DPI */
  1.5,
  1.645,
  1.80,
  2.16,
  2.59,
  3.11,
  3.73,
  4.48
};

INT16           mag_index;  /* set by actfact */

int             g_errenc = 0;  /* has an error been encountered?  */
char            g_logname[MAXSTR];  /* name of log file, if created  */
BOOLEAN         g_dolog = TRUE;  /* allow log file creation  */
FILE           *g_logfp = (FILE *) NULL;  /* log file pointer (for errors) */
char            g_progname[MAXSTR];  /* program name    */

FILE           *plotfp = (FILE *) NULL;  /* plot file pointer  */

INT32           cache_size;  /* record of how much character raster  */
                             /* is actually used    */
float           conv;    /* converts DVI units to pixels  */
UNSIGN16        copies;    /* number of copies to print of each page */
INT16           cur_page_number;/* sequential output page number in 1..N  */
INT16           cur_index;  /* current index in page_ptr[]        */

COORDINATE      xcp, ycp;  /* current position    */
UNSIGN32        den;    /* denominator specified in preamble  */
FILE           *dvifp = (FILE *) NULL;  /* DVI file pointer    */
struct          font_entry *fontptr;  /* font_entry pointer    */
struct font_entry *hfontptr = (struct font_entry *) NULL;
     /* head font_entry pointer  */
     
INT16           gf_index, pk_index;
/* indexes into filelist[] in fontfile(); */
/* they define the search order, and are  */
/* in initglob().    */
UNSIGN32        gpower[33];  /* gpower[k] = 2**k-1 (k = 0..32)  */
INT32           h;    /* current horizontal position  */
COORDINATE      hh;    /* current horizontal position in pixels  */
     
short           parray[256 * 256];  /* largest character possible... */
static int      parridx = 0;
     
UNSIGN32        img_mask[32];  /* initialized at run-time so that bit k  */
/* (counting from high end) is one  */
UNSIGN32        img_row[(MAX_M - MIN_M + 1 + 31) >> 5];
/* current character image row of bits  */
INT16           max_m, min_m, max_n, min_n;
/* current character matrix extents  */
UNSIGN16        img_words;  /* number of words in use in img_row[]  */
float           leftmargin;  /* left margin in inches  */
COORDINATE      lmargin;  /* left margin offset in pixels  */
INT16           nopen;    /* number of open PXL files  */
INT16           page_count;  /* number of entries in page_ptr[]  */

long            page_ptr[MAXPAGE + 1];  /* byte pointers to pages (reverse
					 * order) */
     
INT16           page_begin[MAXREQUEST + 1],
                page_end[MAXREQUEST + 1],
                page_step[MAXREQUEST + 1];  /* explicit page range requests */
INT16           npage;    /* number of explicit page range requests */
struct font_list font_files[MAXOPEN + 1];
/* list of open PXL file identifiers  */
     
UNSIGN32        power[32];  /* power[k] = 1 << k    */

UNSIGN32        rightones[HOST_WORD_SIZE];  /* bit masks */

UNSIGN32        runmag;    /* runtime magnification  */
UNSIGN32        mag;    /* magnification specified in preamble  */
UNSIGN32        num;    /* numerator specified in preamble  */
struct font_entry *pfontptr = (struct font_entry *) NULL;
/* previous font_entry pointer  */
BOOLEAN         preload = TRUE;  /* preload the font descriptions?  */
FILE           *fontfp = (FILE *) NULL;  /* font file pointer    */

BOOLEAN         quiet = TRUE;  /* suppress status display when TRUE  */
BOOLEAN         showhelp = TRUE;  /* create help window  when TRUE  */
     
BOOLEAN         backwards = FALSE;  /* print in backwards order  */
     
#if    BSD42
BOOLEAN         spool_output = FALSE;  /* offer to send output to spooler */
#endif        /* BSD42 */
     
char            subpath[MAXFNAME];  /* font substitution file path  */
char            subname[MAXFNAME];  /* font substitution file name field  */
char            subext[MAXFNAME];  /* font substitution file extension
				    * field */
char            subfile[MAXFNAME];  /* font substitution filename  */

INT32           tex_counter[10];/* TeX c0..c9 counters on current page  */
float           topmargin;  /* top margin in inches    */
COORDINATE      tmargin;  /* top margin offset in pixels  */

INT32           v;    /* current vertical position  */

#if    VIRTUAL_FONTS
BOOLEAN         virt_font;  /* virtual font cache flag            */
struct virt_data {
  int             cnt;
  char           *ptr;
  char           *base;
};
struct virt_data virt_save[_NFILE];  /* space for saving old FILE values  */
#endif        /* VIRTUAL_FONTS */

COORDINATE      vv;    /* current vertical position in pixels  */

struct char_entry *bgcp[NBGFONTS + (NBGFONTS + 2) / 3][NPXLCHARS];
     /* Pointer to corresponding char_entry for this BitGraph font */
     /* and character.  These are used to set the char_entry's */
     /* status to "not loaded" when we have to reuse the BitGraph */
     /* character.  The array is cleared initially in devinit(). */
     
int             fgcolor = FGCOLOR;
int             bgcolor = BGCOLOR;
INT16           fullfont = 0;  /* full font to load in BitGraph  */
BOOLEAN         g_interactive = TRUE;  /* is the program running
					* interactively */
/* (i.e., standard output not redirected)? */
INT16           partchar = FIRSTBGCHAR;  /* partial font character to load in
					  * BitGraph */
INT16           partfont = NBGFONTS;  /* partial font to load in BitGraph  */
INT16           pbghpos;  /* previous BitGraph horizontal position  */
INT16           pbgvpos;  /* previous BitGraph vertical position  */
INT16           pbgf = -1;  /* previous BitGraph font  */
COORDINATE      xdiff;    /* x difference      */
COORDINATE      xscreen;  /* x screen adjustment    */
COORDINATE      ydiff;    /* y difference      */
COORDINATE      yscreen;  /* y screen adjustment    */
long            win_x_size = -1, win_y_size = -1;   /* GL window size */
long            win_left = -1, win_right = -1, win_bottom = -1, win_top = -1;
long            win_x_aspect = -1, win_y_aspect = -1;
long            help_ox = -1, help_oy = -1;
long            cpagep;    /* pointer to current page in DVI file  */
long            ppagep;    /* pointer to previous page in DVI file */
int             magtablesize = MAGTABSIZE;
