/*############################################################################
 # ==========================>  common.h  <================================= #
 #***************************************************************************#
 # This set of macro definitions are commonly used by dvixx.c and creresxx.c #
 #***************************************************************************# 
 # Some of the definitions could be optimized in respect to system dependen- #
 # cies. The general function definitions should be system independent, but  #
 # they need additional overhead in calling them. So in using macros instead #
 # speeds up the program, but makes it less portable. E.g., the group from   #
 # `#else' works fine on HP9000 Series 500 and 800 but not on Serie 300.     #
 # Make the changes in the macros you need for your system, or use the       #
 # slightly less efficient functions instead.                                #
 ############################################################################*/

/* Some global Type-Definitions */

typedef char    byte;
typedef unsigned char  ubyte;
typedef unsigned short ushort;

/* Some macros to read pk objects of different length */


#define getpkbyte(p) (*p++ & 0xff)
#define sigpkbyte(p) (*p++)

#ifndef MACROS

getpkpair(p)
byte *p;
{ register int a;
  a = getpkbyte(p);
  return( (a << 8) + getpkbyte(p));
}

getpktrio(p)
byte *p;
{ register int a;
  a = getpkbyte(p);
  a = (a << 8) + getpkbyte(p);
  return( (a << 8) + getpkbyte(p));
}

getpkquad(p)
byte *p;
{ register int a;
  a = getpkbyte(p);
  a = (a << 8) + getpkbyte(p);
  a = (a << 8) + getpkbyte(p);
  return( (a << 8) + getpkbyte(p));
}

sigpkpair(p)
byte *p;
{ register int a;
  a = sigpkbyte(p);
  return( (a << 8) + getpkbyte(p));
}

sigpktrio(p)
byte *p;
{ register int a;
  a = sigpkbyte(p);
  a = (a << 8) + getpkbyte(p);
  return( (a << 8) + getpkbyte(p));
}

sigpkquad(p)
byte *p;
{ register int a;
  a = sigpkbyte(p);
  a = (a << 8) + getpkbyte(p);
  a = (a << 8) + getpkbyte(p);
  return( (a << 8) + getpkbyte(p));
}

#else

#define getpkpair(p) (getpkbyte(p) << 8) + getpkbyte(p)
#define getpktrio(p) ((getpkpair(p)) << 8) + getpkbyte(p)
#define getpkquad(p) ((getpktrio(p)) << 8) + getpkbyte(p)
#define sigpkpair(p) (sigpkbyte(p) << 8) + getpkbyte(p)
#define sigpktrio(p) ((sigpkpair(p)) << 8) + getpkbyte(p)
#define sigpkquad(p) ((sigpktrio(p)) << 8) + getpkbyte(p)

#endif
/* get_nybble macro */
#define get_nyb() ((c_nyb = ~c_nyb) ? (*pk_ptr & 0xf0)>>4 : *pk_ptr++ & 0xf)

double _f;
#define round(f) (long) ((_f = (double) f) < 0 ? _f - 0.5 : _f + 0.5)

/* define pk commands */

#define pk_xxx1  240
#define pk_xxx2  241
#define pk_xxx3  242
#define pk_xxx4  243
#define pk_yyy   244
#define pk_post  245 
#define pk_no_op 246
#define pk_pre   247
#define pk_undef 248
#define pk_cmd   240

