/* modified by Peter Damron 1987 University of Washington */
/*---------------------------------------------------------------------*/
/* $Header: font.h,v 2.0 88/06/07 15:02:12 peterd Rel2 $ */
/*---------------------------------------------------------------------*/
/* constants */

#define  MAXFONTCHARS		256
#define  PXLID			1001

#ifdef NOTDEF

#define  RESOLUTION		300
#define  hconvRESOLUTION	300
#define  vconvRESOLUTION	300

#define  NONEXISTANT		-1	/* offset for PXL files not found */
#define  NO_FILE		(FILE *)-1

#endif NOTDEF

/*---------------------------------------------------------------------*/
/* data structures */
/**********************************************************************/
/***********************  Font Data Structures  ***********************/
/**********************************************************************/

typedef struct char_entry *CharEntryType;

struct char_entry {			/* character entry */
#ifdef USEPXL
    unsigned short width;	/* char width in pixels */
    unsigned short height;	/* char height in pixels */
    short xOffset;		/* char x offset in pixels */
    short yOffset;		/* char y offset in pixels */
#endif
    struct {
	int isloaded;		/* has this char been down-loaded */
	union {
	   long fileOffset;	/* file offset of char for fseek() */
	   long *pixptr;	/* pointer to char bitmap */
	} address;
    } where;
    int tfmw;			/* TFM char width */
};

typedef struct font_entry *FontEntryType;

struct font_entry {	/* font entry */
   int dvi_fnum;	/* font number - from dvi file */
   int dvi_check;	/* checksum - never checked */
   int dvi_s;		/* font space size */
   int dvi_d;		/* font design size */
   int dvi_alen;	/* area (directory) name length for font name */
   int dvi_nlen;	/* font style name length */
			/* dvi_alen + dvi_nlen == length of dvi_name (name) */
   char dvi_name[STRSIZE];	/* FNT_DEF command parameters (??) (font name?) */
   int font_space;	/* computed from FNT_DEF s parameter */
   int font_mag;	/* computed from FNT_DEF s and d parameters */
   char psname[STRSIZE]; /* PostScript name of the font */
   char name[STRSIZE];	/* full name of font file (full path) */
   FILE *font_file_id;  /* file identifier (NO_FILE if none) */
   struct open_font_list *open_font_ptr;	/* entry in open font list */
#ifdef USEPXL
   int magnification;	/* magnification read from PXL file */
   int designsize;	/* design size read from PXL file */
#endif
   struct char_entry ch[MAXFONTCHARS];	/* character information */
   struct font_entry *next;		/* next font entry in list */
   int ncdl;		/* # of different chars actually downloaded */
#ifdef STATS
   int nbpxl;		/* # of bytes of font data downloaded*/
   int ncts;		/* # characters typeset for this font */
   int nopen;		/* # file opens requested for this font */
   int nclose;		/* # file closes performed for this font */
#endif
};

typedef struct open_font_list *OpenFontType;

struct open_font_list
{
    FILE *pixel_file_id;		/* file identifier */
    struct font_entry *font_entry_ptr;	/* font entry (fast lookup) */
    int use_count;			/* count of "opens" */
};


/*---------------------------------------------------------------------*/
/**********************************************************************/
/*************************  Global Variables  *************************/
/**********************************************************************/

/* font stuff */
extern int  G_nopen;			/* number of open font files (pxl/gf) */
extern FILE *G_fontfp;			/* font file pointer */
extern char *G_fontpath[PATHSIZE];	/* a list of directories for fonts */
extern int  G_fontpathsize;		/* number of directories on font path */
extern long G_postambleptr;		/* Pointer to the postamble */
extern struct font_entry *G_prevfont;	/* previous font_entry ptr */
extern struct font_entry *G_fontptr;	/* current font_entry ptr */
extern struct font_entry *G_hfontptr;	/* head of font_entry list */
extern struct font_entry *G_pfontptr;	/* previous font_entry ptr */
extern struct open_font_list G_font_files[MAXOPEN];	/* list of open files */

/*---------------------------------------------------------------------*/

