// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
// $Header: hp33440.C,v 1.13 91/02/22 15:56:21 hmgr Exp $

// LaserJetII series device-specific functions.
// The LaserJetII Reference Manual should be consulted for more
// information on various the escape-sequences.
//
// by Parag Patel

#include "defs.h"
#include "hp2686.h"
#include "hp33440.h"


// LaserJetII:

// initialize the LaserJet II
HP33440::HP33440() :
	HP2686(257, 256, 32, 32, 300, HP2686_HOFFSET, HP2686_VOFFSET,
			-128, 127, -128, 127, 128, 128, HP2686_FPATH)
{
}

// LaserJetIID:

// initialize the LaserJet IID using explicit args - handle 2-sided
//
HP33447::HP33447(int maxf, int maxc, int maxpg, int maxld, int res,
		int ho, int vo, int fhmn, int fhmx, int fvmn,
		int fvmx, int fwd, int fhg, char *deffp) :
    HP33440(maxf, maxc, maxpg, maxld, res, ho, vo,
	fhmn, fhmx, fvmn, fvmx, fwd, fhg, deffp)
{
    if (duplexv)
	fputs("\033&l1S", stdout);
    else if (duplexh)
	fputs("\033&l2S", stdout);
}

// initialize the LaserJet IID - use defaults for LJII & handled 2-sided
//
HP33447::HP33447() : HP33440()
{
    if (duplexv)
	fputs("\033&l1S", stdout);
    else if (duplexh)
	fputs("\033&l2S", stdout);
}

// back to normal mode - switch off 2-sided
//
HP33447::~HP33447()
{
    if (duplexv || duplexh)
	fputs("\033&l0S", stdout);
}

// flush out (print) the current page in the LJIID - get ready to
// print a new page
// 
void HP33447::newpage(boolean odd, boolean first)
{
    // print even pages on "front" for reverse output, else odd
    debug(2, "newpage: odd=%d reverse=%d odd^reverse=%d first=%d",
	    odd, reverse, odd ^ reverse, first);
    if (duplexv || duplexh)
    {
	if (odd ^ reverse)
	    fputs("\033&a1G", stdout);
	else
	    fputs("\033&a2G", stdout);
    }
    else if (!first)
	putchar('\f');
}
