/*
  This is the file findex.c of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/


#include "ttf.h"


static int getFontIndex0(TTF *f, BYTE *cc);
static int getFontIndex2(TTF *f, BYTE *cc);
static int getFontIndex4(TTF *f, BYTE *cc);


/*@@*/

/* prototype declaration in ttf.h */

void ttf_selectCmap(f, platId, encId)
  TTF *f;
  USHORT platId, encId;
{
  int i;

  for (i = 0; i < f->numberOfEncoding; i++)
  {
    if ((f->cmap[i].PlatformID == platId) ||
        (f->cmap[i].EncodingID == encId))
      break;
  }
  if (i == f->numberOfEncoding)
    f->curmap = &f->cmap[0];
  else
    f->curmap = &f->cmap[i];
}


/*
   These functions translate two-byte character codes into
   glyph indices which can be used to access data in various tables.
*/

/* prototype declaration in ttf.h */

int ttf_getFontIndex(f, cc)
  TTF *f;
  BYTE *cc;
{
  switch (f->curmap->format)
  {
  case 0:
    return getFontIndex0(f, cc);
  case 2:
    return getFontIndex2(f, cc);
  case 4:
    return getFontIndex4(f, cc);
#if 0
  case 6:
    return getFontIndex6(f, cc);
#endif
  default:
    return -1;
  }
}


static int getFontIndex0(f, cc)
  TTF *f;
  BYTE *cc;
{
  return f->curmap->map.cmap0->glyphIdArray[*cc];
}


static int getFontIndex2(f, cc)
  TTF *f;
  BYTE *cc;
{
  USHORT index;
  USHORT index1, firstCode, entryCount;
  SHORT idDelta;
  USHORT idRangeOffset;
  CMAP *cm;

  cm = f->curmap;
  index1 = cm->map.cmap2->subHeaderKeys[*cc];

  if (index1 == 0)
    index = cm->map.cmap2->glyphIdArray[*cc];
  else
  {
    firstCode = cm->map.cmap2->data[index1 * 4];
    entryCount = cm->map.cmap2->data[index1 * 4 + 1];
    idDelta = ((SHORT *)cm->map.cmap2->data)[index1 * 4 + 2];
    idRangeOffset = cm->map.cmap2->data[index1 * 4 + 3];

    if (cc[1] < firstCode)
      return -1;

    if (cc[1] >= firstCode + entryCount)
      return -1;
    index = cm->map.cmap2->glyphIdArray[idRangeOffset / 2 + cc[1] - firstCode]
            +idDelta;
  }

  return index;
}


static int getFontIndex4(f, cc)
  TTF *f;
  BYTE *cc;
{
  CMAP *cm;
  USHORT ch, index1, index = 0;
  int i;

  cm = f->curmap;
  ch = (cc[0] << 8) + cc[1];

  for (i = 0; i < cm->map.cmap4->segCount; i++)
    if (ch <= cm->map.cmap4->endCount[i])
      break;
  if (ch < cm->map.cmap4->startCount[i])
    return -1;

  if (cm->map.cmap4->idRangeOffset[i] == 0)
    index = (int)(cm->map.cmap4->idDelta[i] + ch) % 65536;
  else
  {
    index1 = cm->map.cmap4->idRangeOffset[i] / 2 +
             (ch - cm->map.cmap4->startCount[i]) -
             (cm->map.cmap4->segCount - i);
    if(cm->map.cmap4->glyphIdArray[index1] == 0)
      return -1;
    else
      index = (int)(cm->map.cmap4->glyphIdArray[index1] +
                    cm->map.cmap4->idDelta[i]) % 65536;
  }

  return index;
}


/*
   This function translates two-byte character codes into
   location offsets in the Glyph Data.

   Say

      off = ttf_getFontOffset(f, cc);
      load_glyf(f, fp, off);

   to fetch data in f->glyf
*/

/* prototype declaration in ttf.h */

int ttf_getFontOffset(f, cc)
  TTF *f;
  BYTE *cc;
{
  int index;

  switch (f->curmap->format)
  {
  case 0:
    index = getFontIndex0(f, cc);
    break;
  case 2:
    index = getFontIndex2(f, cc);
    break;
  case 4:
    index = getFontIndex4(f, cc);
    break;
#if 0
  case 6:
    index = getFontIndex6(f, cc);
    break;
#endif
  default:
    return -1;
  }

  /* some fonts don't follow the TTF specs exactly... */

  if (index >= f->profile->numglyphs)
  {
    fprintf(stderr, "ttf2pk: Invalid TTF index\n");
    return -1;
  }
  if (index == -1)
    return -1;

  /* again some non-standard TTFs */

  if (f->indexToLocation[index] == f->indexToLocation[index + 1])
#if 0
    return f->indexToLocation[0]; /* this would be the clean solution */
#else
    return -1;
#endif

  return f->indexToLocation[index];
}


/* advanceWidth is always a positive value */
/* returns -1 on error */

/* prototype declaration in ttf.h */

int ttf_getAdvanceWidth(f, index)
  TTF *f;
  USHORT index;
{
  if (index >= f->profile->numglyphs)
    return -1;
  if (index < f->horz->numberOfHMetrics)
    return f->horz->longHorMetrics[index].advanceWidth;
  else
    return f->horz->longHorMetrics
                     [f->horz->numberOfHMetrics - 1].advanceWidth;
}


int ttf_getLsb(f, index)
  TTF *f;
  USHORT index;
{
  if (index >= f->profile->numglyphs)
    return 0;
  if (index < f->horz->numberOfHMetrics)
    return f->horz->longHorMetrics[index].lsb;
  else
    return f->horz->leftSideBearing[index - f->horz->numberOfHMetrics];
}


/* end of findex.c */
