/*
  This is the file bitmap.c of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/


#include <stdio.h>
#include <stdlib.h>
#include "ttf.h"


/*@@*/

BITMAP *BITMAP_Init(point, x_res, y_res, mode, pixel_xsize, pixel_ysize)
  double point;
  int x_res, y_res, mode;
  USHORT pixel_xsize, pixel_ysize;
{
  BITMAP *b;

  b = TTF_ALLOC(BITMAP, 1, "BITMAP_Init");
  b->xpoint = pixel_xsize;
  b->xsize = (pixel_xsize + 7) / 8;
  b->ysize = pixel_ysize;
  b->point = point;
  b->x_res = x_res;
  b->y_res = y_res;
  b->mode = mode;
  BITMAP_color(b, mode);
  b->map = TTF_ALLOC(unsigned char, b->xsize * b->ysize, "BITMAP_Init");
  return b;
}


void BITMAP_color(bit, color)
  BITMAP *bit;
  int color;
{
  int i;

  switch (bit->mode)
  {
  case BITMAP_ONE_BIT:
    if (color)
      bit->color = 0xffff;
    else
      bit->color = 0;
    bit->xsize = (bit->xpoint + 7) / 8;
    break;
  case BITMAP_TWO_BIT:
    color &= 0x3;
    bit->color = color;
    for (i = 0; i < 4; i++)
    {
      color <<= 2;
      bit->color |= color;
    }
    bit->xsize = (bit->xpoint + 3) / 4;
    break;
  case BITMAP_FOUR_BIT:
    color &= 0xf;
    bit->color = color;
    bit->color |= (color << 4);
    bit->xsize = (bit->xpoint + 1) / 2;
    break;
  case BITMAP_ONE_BYTE:
    color &= 0xff;
    bit->color = color;
    bit->xsize = bit->xpoint;
    break;
  case BITMAP_TWO_BYTES:
    color &= 0xffff;
    bit->color = color;
    bit->color |= (color << 16);
    bit->xsize = bit->xpoint * 2;
    break;
  case BITMAP_THREE_BYTES:
    color &= 0xffffff;
    bit->color = color;
    bit->xsize = bit->xpoint * 3;
    break;
  case BITMAP_FOUR_BYTES:
    bit->color = color;
    bit->xsize = bit->xpoint * 4;
    break;
  }
}


void BITMAP_done(bit)
  BITMAP *bit;
{
  TTF_FREE(bit->map, "BITMAP_done");
  TTF_FREE(bit, "BITMAP_done");
}


/* end of bitmap.c */
