/*
   Copyright by Jingbai Wang 1989
   jbw@pittvms.bitnet
   jbw@cisunx.UUCP

   The author permits free distribution of this program for non-profit
   purposes. Commercial application is reserved by the author.
*/

#define DEBUG 0

/****** This file is part of chtex to be linked with chtex.o *********/
#include <stdio.h>

#if VMS|unix
#else    /* DOS should be treated separated */
#define MSDOS 1
extern char *getenv();
/*
#if TURBO
#include <mem.h>
#endif
*/
#endif

/* What is path of Adobe TFM files */
#if VMS
#ifndef TFMarea
#define  TFMarea "usr0:[12162.jbw.tex.tfm]"
#endif
#endif

#if unix
#ifndef TFMarea
#define  TFMarea "/usr/people/jbw/usr/src/chtex/tfm"
#endif
#endif

#if MSDOS|PCDOS
#ifndef TFMarea
#define  TFMarea ""
#endif
#endif

	/* the following are for WStroff */
#if MSDOS|PCDOS
#define StringMax  128  /* define maximum string length to be 256 kbytes*/
#define MaxStrNo   32    /* there can be at most 64 definable strings*/
#else
#define StringMax  256  /* define maximum string length to be 256 kbytes*/
#define MaxStrNo   64    /* there can be at most 64 definable strings*/
#endif
#define MaxCol     64    /* there can be at most 64 columns in a page*/    

#define font_group_size 218
#define font_overhead 32
#define MAX_CHAR 8400    /* what's the maximum number of characters */
/*
#if MSDOS|PCDOS
#include "pctroff.h"
#else
*/
extern unsigned char inbuffer[1025];
extern FILE *infile, *outfile, *errfile;
extern char tempfile[60], logfile_name[60];
extern int chinese_pair;
extern int Cconvert;
extern int chinese[MAX_CHAR], newheader;
/*
#endif
*/
#if VMS
#include <file.h>
#else
#include <fcntl.h>
#endif

long int SignByte4();

struct Fonts
{
int id;   /* font id number */
int width[256]; /* width of each character */
char name[50];  /* font name */
int above;      /* above base line*/
int below;      /* below base line*/
} last_font;


  /* read in the font metrics from a TFM file */
TFMWidth(tfmfile)
unsigned char *tfmfile;
{  /* We will use TFM files to define font metric*/
  int TFMhandle;
  int TFMlength, pos, bytes;
  char work[256];
  unsigned char TFMbuffer[3000];
  int lh, begin_char, end_char, i, nw, tfmwidth[128];
  
#if MSDOS|PCDOS|USG
int lens, inhand;
char  filename[60];
unsigned char *ptr;
#endif
		strcpy(last_font.name, tfmfile);
 /* since DOS limits file name length to 8 characters, and System V also
	limits the filename length, Adobe font names are re-mapped here */

#if MSDOS|PCDOS|OLD_USG
#if MSDOS|PCDOS
	sprintf(filename, "%s\\dostfm.map", getenv("TEXFONTS"));
	if ((inhand = open(filename, O_RDONLY))<0)
	{strcpy(filename, ".\\dostfm.map");
	if ((inhand = open(filename, O_RDONLY))<0)
	{fprintf(stderr, " Can't find the PS font mapping file %s\n",filename);
	return(-1);
	}
	}
#else
	if (getenv("TEXFONTS"))
	sprintf(filename, "%s/pstfm.map", getenv("TEXFONTS"));
	else sprintf(filename, "%s/pstfm.map", TFMarea);

	if ((inhand = open(filename, O_RDONLY))<0)
	{strcpy(filename, "./pstfm.map");
	if ((inhand = open(filename, O_RDONLY))<0)
	{fprintf(stderr, "Can't find the PS font mapping file %s\n",filename);
	return(-1);
	}
	}

#endif
	lens=read(inhand, TFMbuffer, 3000);
        TFMbuffer[lens]=0;
	close(inhand);

	lens = strlen(tfmfile);
	ptr = (unsigned char *) TFMbuffer;
	
while (*ptr!=0)
    {
  if (*ptr==tfmfile[0])
    {   	
    if ( strncmp(ptr, (unsigned char *) tfmfile, lens)==0)
      { 
  	        while ( *ptr!=10) ptr--;
        	++ptr;
		sscanf(ptr, "%s", filename);
		goto done;
      }
    }
    ptr++;

    }
(void) fprintf (stderr, "Can't find Adobe TFM file for %s\n",tfmfile);
	return(-1); 
done:
		strcpy(tfmfile, filename);
#endif


#if VMS|unix
#if VMS
		(void) sprintf (work, "%s:%s.tfm", "tex$fonts", tfmfile);
#endif
#if unix
	if (getenv("TEXFONTS"))
	(void) sprintf (work, "%s/%s.tfm", getenv("TEXFONTS"), tfmfile);

#endif
#else /* suppose it is DOS */
	(void) sprintf (work, "%s\\%s.tfm", getenv("TEXFONTS"), tfmfile);

#endif


#if MSDOS|PSDOS
         	if ((TFMhandle = open(work, O_RDONLY|O_BINARY))<0)
#else                                             
         	if ((TFMhandle = open(work, O_RDONLY))<0)
#endif 
		{
#if VMS
		(void) sprintf (work, "%s%s.tfm", TFMarea, tfmfile);
#endif
#if unix
	(void) sprintf (work, "%s/%s.tfm", TFMarea, tfmfile);
#endif

#if MSDOS|PCDOS
	(void) sprintf (work, "%s.tfm", filename);
#endif

#if MSDOS|PCDOS
         	if ((TFMhandle = open(work, O_RDONLY|O_BINARY))<0)
#else
         	if ((TFMhandle = open(work, O_RDONLY))<0)
#endif
		  {
	(void) fprintf (stderr, "Can't find Adobe TFM file %s\n",work);
			return(-1);
		  }
		}



		bytes = 1;
		TFMlength =0;

		while(bytes>0)
		{
		bytes = read(TFMhandle, &TFMbuffer[TFMlength], 3000);
		TFMlength += bytes;
		}
		(void) close (TFMhandle);

		pos = 2;

                lh = NoSignExtend (TFMbuffer, 2, pos);
		 pos += 2;
		begin_char = NoSignExtend (TFMbuffer, 2,  pos);
		 pos += 2;
                end_char = NoSignExtend (TFMbuffer, 2,  pos);
		 pos += 2;
                nw = NoSignExtend (TFMbuffer, 2,  pos);
		pos += 2;
  		
		pos += (14 + (lh + end_char - begin_char + 1) * 4);

              for (i = 0; i < nw; i++) {
			tfmwidth[i] =
		(float) SignByte4(TFMbuffer, pos)/1048.576 + 0.9;
			pos+=4;
                        
		}

           
             pos = lh * 4 + 24;

               for (i = begin_char; i <= end_char; i++) {
              last_font.width[i] =
		tfmwidth[NoSignExtend(TFMbuffer, 1, pos)];
 		pos += 4;
                }

		return(1);
 }



 /* make an integer from n bytes */
int
NoSignExtend (fp, n, pos)	/* return n byte quantity from array fp */
	 unsigned char *fp;	/* buffer */
	 int n;		/* number of bytes */
	 int pos; 	/* position in the buffer */

{
	 int x;		/* number being constructed */

	x = 0;
	while (n--) {
		x <<= 8;
		x |= fp[pos++];
	}
	return (x);
}

 /* make an integer from 4 bytes */
long
SignByte4 (fp, pos)	         /* return 4 byte quantity from array fp */
	 unsigned char *fp;	/* file pointer */
	 int pos;

{
   long int x;		/* number being constructed */

	x = (unsigned)  fp[pos++];
	x = (x << 8) | (unsigned)  fp[pos++];
	x = (x << 8) | (unsigned)  fp[pos++];
	x = (x << 8) | (unsigned)  fp[pos++];

	return ((long)x);
}


 /* default prolog Use big point as the output unit, i.e., 1in=72pt */
pro_default()
{ /* output the PostScript prologue that is Scribe 7 one*/
fputs("%%EndComments\n\
%% PostScript Prelude for ChScribe.\n\
/BS {/SV save def 0.0 792.0 translate .01 -.01 scale} bind def\n\
/ES {showpage SV restore} bind def\n\
/SC {setrgbcolor} bind def\n\
/FMTX matrix def\n\
/RDF {WFT SLT 0.0 eq \n\
  {SSZ 0.0 0.0 SSZ neg STH mul 0.0 0.0 FMTX astore}\n\
  {SSZ 0.0 SLT neg sin SLT cos div SSZ mul SSZ neg STH mul 0.0 0.0 FMTX \
astore}\n\
  ifelse makefont setfont} bind def\n\
/SLT 0.0 def\n\
/STH 1.0 def\n\
/SI { /SLT exch cvr def RDF} bind def\n\
/WFT /Courier findfont def\n\
/SF { /WFT exch findfont def RDF} bind def\n\
/SSZ 1000.0 def\n\
", outfile);

fputs("\
/mkodic 7 dict def\n\
/MOF\n\
{mkodic begin\n\
/uniqueid exch def\n\
/strokewidth exch def\n\
/newfontname exch def\n\
/basefontname exch def\n\
/basefontdic basefontname findfont def\n\
/numentries basefontdic maxlength 1 add def\n\
basefontdic /UniqueID known not\n\
{/numentries numentries 1 add def} if\n\
/outfontdic numentries dict def\n\
", outfile);
fputs("\
basefontdic\n\
{exch dup /FID ne\n\
 {exch outfontdic 3 1 roll put}\n\
 {pop pop}\n\
 ifelse\n\
}forall\n\
outfontdic /FontName newfontname put\n\
outfontdic /PaintType 2 put\n\
outfontdic /StrokeWidth strokewidth put\n\
outfontdic /UniqueID uniqueid put\n\
newfontname outfontdic definefont pop\n\
end\n\
}def\n\
/MF {findfont dup /UniqueID known\n\
{/UniqueID get 1 add}\n\
{pop 1}\n\
ifelse MOF} bind def\n\
", outfile);

fputs("\
/SS { /SSZ exch 100.0 mul def RDF} bind def\n\
/ST { /STH exch def RDF} bind def\n\
/AF { /WFT exch findfont def /SSZ exch 100.0 mul def RDF} bind def\n\
/MT /moveto load def\n\
/RM /rmoveto load def\n\
/XM {currentpoint exch pop moveto} bind def\n\
/XR {0.0 rmoveto} bind def\n\
/YR {0.0 exch rmoveto} bind def\n\
/UL {gsave newpath moveto dup 2.0 div 0.0 exch rmoveto\n\
   setlinewidth 0.0 rlineto stroke grestore} bind def\n\
", outfile);

fputs("\
/SH /show load def\n\
/MX {exch show 0.0 rmoveto} bind def\n\
/W {0 32 4 -1 roll widthshow} bind def\n\
/WX {0 32 5 -1 roll widthshow 0.0 rmoveto} bind def\n\
/PB {/PV save def newpath translate\n\
    100.0 -100.0 scale /showpage {} def} bind def\n\
/PE {PV restore} bind def\n\
/GB {/PV save def newpath translate rotate\n\
    div dup scale 100.0 -100.0 scale /showpage {} def} bind def\n\
/GE {PV restore} bind def\n\
", outfile);

fputs("\
/RC {100.0 -100.0 scale\n\
612.0 0.0 translate\n\
-90.0 rotate\n\
.01 -.01 scale} bind def\n\
/URC {100.0 -100.0 scale\n\
90.0 rotate\n\
-612.0 0.0 translate\n\
.01 -.01 scale} bind def\n\
/RCC {100.0 -100.0 scale\n\
0.0 -792.0 translate 90.0 rotate\n\
.01 -.01 scale} bind def\n\
/URCC {100.0 -100.0 scale\n\
-90.0 rotate 0.0 792.0 translate\n\
.01 -.01 scale} bind def\n\
", outfile);

fputs("\
/LH {gsave newpath moveto setlinewidth\n\
   0.0 rlineto\n\
   gsave stroke grestore} bind def\n\
/LV {gsave newpath moveto setlinewidth\n\
   0.0 exch rlineto\n\
   gsave stroke grestore} bind def\n\
/BX {gsave newpath moveto setlinewidth\n\
   exch\n\
   dup 0.0 rlineto\n\
   exch 0.0 exch neg rlineto\n\
   neg 0.0 rlineto\n\
   closepath\n\
   gsave stroke grestore} bind def\n\
/BX1 {grestore} bind def\n\
/BX2 {setlinewidth 1 setgray stroke grestore} bind def\n\
", outfile);

/*
fputs("\
/FB {dict dup /FontMapDict exch def begin} bind def\n\
/FM {cvn exch cvn exch def} bind def\n\
/FE {end /original-findfont /findfont load def  /findfont\n\
   {dup FontMapDict exch known{FontMapDict exch get} if\n\
   original-findfont} def} bind def\n\
/BC {gsave moveto dup 0 exch rlineto exch 0 rlineto neg 0 exch rlineto closepath clip} bind def\n\
/EC /grestore load def\n\
", outfile);
*/

fputs("%%EndProlog\n", outfile);
}

  /* now define some useful global variables */
#define pouts(s) fputs(s, outfile)
#define poutc(c) fputc(c, outfile)

struct Fonts note_font;
struct Fonts save_font;

struct Font_Family
{
struct Fonts rm; /* Roman font */
struct Fonts it; /* italic font */
struct Fonts bf; /* boldface font */
struct Fonts tt; /* Typewirter font */
struct Fonts ph; /* Physical font */
struct Fonts sb; /* Symbol font */
char name[64]; /* Family name */
} ff;

struct Font_Family courier; /* Courier font family is special */

/****************** global style parameters ******************/

struct GSty 
{
float
leftmargin,  /* global left margin */
rightmargin, /* global right margin*/
parindent,    /* paragraph indent 24 pts by default */
offset,  /* No page offset, it is also the bindingmargin */
headsep, 	/* the separation between pageheading and text body is 0.5in*/
footskip, /* the separation between pagefootgin and text body is 0.5in*/
paperlength, /* 11in, (66 lines in WS) in a page by default */
paperwidth, /* 8.5in, (66 lines in WS) in a page by default */
textheight,   /* default textheight is 9 inches */
textwidth,   /* default textwidth is 7.5 inches */
topmargin, /* topmargin is 0.5 inches high, top edge to header */
botmargin, /* bottom margin is 0.5 inches */
notesize,   /* page number size */
chspace,  /* the width of Chinese interword space is 725/2 */
ul_weight,	/* underline weight */
ul_lower,   /* underline sink */
ul_sink[64], /* under line sink*/
ul_weit[64]; /* under line weight*/

int
pagenum, /* the page number starting from 1 */
landscape,       /* should there be landscape */
pnumbering, /* should pages be numbered ?*/
num_sty, /*  if it 1-Arabic */
num_loc,  /*  if it is 0-left, 1-center, 2-right */
num_lev,  /*  if it is 0-top, 1-bottom */
str_no,
lstr_no,
str_N,
str_len,
str_L;

unsigned char
     heading1[128], /* page heading left */
     heading2[128], /* page heading center */
     heading3[128], /* page heading right */
     footing1[128], /* page footing left */
     footing2[128], /* page footing center */
     footing3[128]; /* page footing right */


float raise1,
    raise2,
    lower1,
    lower2,
    scriptsize1,
    scriptsize2;

};



struct SString {
char name[32]; /* maximum name length for a string is 32 characters */
unsigned char str[StringMax];
} save[MaxStrNo];


/******* local paragraph style parameters *************/

struct Sty {
float
fscale,  	/* font size */
sl,		/* font slant */
sth,		/* font character stretch */
olwidth,	/* outline font stroke width*/
left,	/* local leftmargin */
right,	/* local right margin */
indent,      /* the indent */
stretch,  /* base line stretching factor is 1 */
skip, 	/*  base line skip */
cwidth[MaxCol],  /* max 16 columns, and each can have own width */
cmargins[MaxCol],  /* max 16 columns, and each can have own marginwidth */
cratio[MaxCol],  /* column width ratio deteramines the columnwidth */
cmargin,	  /* default column margin is 0.2in*/
maxY, /* maxmum useable the_y value */
maxX, /* maximum useable the_x value */
parskip,    /*paragraph spreading */
color[3];	/* RGB color */

struct Fonts font;

int
color3,	/* RGB color */
outl,		/* outline font? */
spack,   /* repack the spaces and blank line? */
cnumber , /* the defautl number is 1 */
center,	  /* center */
align,    /* left-right justified?*/
r_right, /* ragright ? = flush left*/
f_right; /* flush right ?*/
};

struct Sty save_sty;


/********** intermediate counters and carriers *************/

float
max_height,	/* maximum height of a line */
old_scale,
last_scale=0.,
left_len=0., /* buffer length left in tmpwd */
this_width,
this_x=0.,
this_y=0.,
the_x=0., /* current x position */
the_y=0., /* current y position */
curr_top,	/* current text body top */
curr_left,	  /* leftmargin = G.offset + G.leftmargin+sty.left*/
r_x=0.,	/* relative x movement*/
r_y=0.,	/* relative y movement*/
add_x=0.,	/* relative x movement due interword spaces*/
abs_x=0.,  /* moveto absolute x-position*/
abs_y=0.,  /* moveto absolute y-position */
last_x=0., /* last breakable x */
last_bot=0., /* last bottom in multiple column box */
save_x=0.,  /* saved x-pos in set mark */
b_ulx[64], /* begin underline x*/
b_uly[64], /* begin underline y*/
len_ul[64], /* underline length */
last_bk,
height_needed = 0.; /* the remainding page height should be no less than this*/


int  
current_group,
the_group,
save_group,
columns = 1,
num_ul=0,
page_count = 1,
last_last=0,
last_char=0; /* character type of last byte*/

int tmplen=0,  /* tmpbuffer length */
 last_b=0; /* last breakable byte*/

unsigned char tmpbuffer[2048],  tempwd[256];
FILE *input_F;


/********** intermediate flags *************/

int  
newmark=1, 	/* is it a new line in input buffer*/
newline=1, 	/* is it a new line */
newpage=1, 	/* is it a new page */
newpara=1, 	/* is it a new paragraph */
newpara1=1, 	/* is it a new paragraph */
old_page=0,	 /* the page number to remember */
show_str=0,
ovp=0,
ovping=0,
do_ul=0,
more_ul=0,
ul_flag=1,      /* underline flag */
raise_flag = 1, /* superscript flag */
lower_flag = 1, /* subscript flag */
bf_flag = 1,    /* boldface flag */
ch_bf = 0,      /* Chinese boldface flag*/
it_flag = 1,    /* italics flag */
ph_flag = 1,    /* physics font flag */
tt_flag = 1,    /* typewriter font flag */
sb_flag = 1,    /* symbol font flag */
input_file = 0,
input_ps = 0,
store_str=0,
value_str=0,
noindent = 0, /* no indent ?*/
history = 0;

 
WS_troff() /* translate Chinese WordStar output into PostScript */
{
struct Sty sty;
struct GSty G;

int j;

fprintf(stderr, "Generating PostScript Output %s ...\n", tempfile);

if (!newheader) pro_default();
/*
errfile = fopen(logfile_name, "w");
*/
/**************** initialize parameters ***********/


G.leftmargin = 72.;  /* global left margin */
G.rightmargin = 72.; /* global right margin*/
G.parindent = 24.;    /* paragraph indent 24 pts by default */
G.offset = 0.;  /* No page offset, it is also the bindingmargin */
G.headsep = 36.; 	/* the separation between pageheading and text body is 0.5in*/
G.footskip = 36.; /* the separation between pagefootgin and text body is 0.5in*/
G.paperlength = 792.; /* 11in, (66 lines in WS) in a page by default */
G.paperwidth = 612.; /* 8.5in, (66 lines in WS) in a page by default */
G.textheight = 648.;   /* default textheight is 9 inches */
G.textwidth = 468.;   /* default textwidth is 7.5 inches */
G.topmargin = 36.; /* topmargin is 0.5 inches high, top edge to header */
G.botmargin = 36.; /* bottom margin is 0.5 inches */
G.chspace = 362.5;  /* the width of Chinese interword space is 725/2 */

G.ul_weight=50.;	/* underline weight */
G.ul_lower = 100.;   /* underline sink */
G.pagenum = 1; /* the page number starting from 1 */
G.pnumbering = 1; /* should pages be numbered ?*/
G.num_sty = 1; /*  if it 1-Arabic */
G.num_loc = 1;  /*  if it is 0-left, 1-center, 2-right */
G.num_lev = 1;  /*  if it is 0-top, 1-bottom */
G.landscape = 0;       /* should there be landscape */
G.str_no=0;
G.lstr_no=0;
G.str_N=0;
G.str_len=0;
G.str_L=0;

    G.raise1=220.;
    G.raise2=320.;
    G.lower1=220.;
    G.lower2=320.;
    G.scriptsize1=8.;
    G.scriptsize2=6.;

sty.fscale=12.;  	/* font size */
sty.sl=0.0;		/* font slant */
sty.outl=0;		/* not outline font  */
sty.olwidth=0.5;	/* not outline font  */
sty.sth=1.0;		/* not character stretch  */
sty.color3 = 0;
sty.left = 0.;	/* local leftmargin */
sty.right = 0.;	/* local right margin */
sty.indent = G.parindent;      /* the indent is 24pts */
sty.stretch = 1.;  /* Line spacing is line */
sty.align = 0,  /* should there be left-right justification */
sty.skip = 10.; /* baseline skip is 10 pts by default for 10pts fonts*/
sty.cmargin = 14.4;	  /* default column margin is 0.2in*/
sty.parskip = 2.;    /*paragraph spreading 2pts */
sty.cnumber = 1; /* the defautl number is 1 */
sty.center=0;	  /* center ?*/
sty.r_right = 0; /* ragged right ? = flush left*/
sty.f_right = 0; /* flush right ?*/
sty.spack = 0;   /*do not repack the spaces */
G.heading1[0] = 0;
G.heading2[0] = 0;
G.heading3[0] = 0;
G.footing1[0] = 0;
G.footing2[0] = 0;
G.footing3[0] = 0;


columns = 1;
 sty.cwidth[0] = G.leftmargin+G.offset;
chinese_pair=1;

current_group = -1;
newline = 1;
r_y = 0.;
r_x = 0.;
add_x = 0.;
show_str = 0;
newpage = 1;

/* courier.rm is Courier font */
 courier.rm.id = 0;
 strcpy(courier.rm.name, "Courier");
 for (j=32; j<252; j++)
  courier.rm.width[j] = 600; /* all of them have the same width 6pt*/
 courier.rm.above = 624;
 courier.rm.below = 207;

/* fonts[0] is Chinese font all of them have the same width 7.25pt except 32
 fonts[0].id = 1;
fonts[0].width[32] = 1;
 strcpy(fonts[0].name, "Chinese");
 for (j=33; j<252; j++)
 fonts[0].width[j] = 725;
 fonts[0].above = 730;
 fonts[0].below = 10;
*/

/* ff.sb is Symbol font for every font family the symbol font is the same*/
 strcpy(ff.sb.name, "Symbol");
ff.sb.width[32]= 250;
ff.sb.width[33] = 333;
ff.sb.width[34] = 713;
ff.sb.width[35] = 500;
ff.sb.width[36] = 548;
ff.sb.width[37] = 833;
ff.sb.width[38] = 777;
ff.sb.width[39] = 439;
ff.sb.width[40] = 333;
ff.sb.width[41] = 333;
ff.sb.width[42] = 500;
ff.sb.width[43] = 548;
ff.sb.width[44] = 250;
ff.sb.width[45] = 548;
ff.sb.width[46] = 250;
ff.sb.width[47] = 277;
ff.sb.width[48] = 500;
ff.sb.width[49] = 500;
ff.sb.width[50] = 500;
ff.sb.width[51] = 500;
ff.sb.width[52] = 500;
ff.sb.width[53] = 500;
ff.sb.width[54] = 500;
ff.sb.width[55] = 500;
ff.sb.width[56] = 500;
ff.sb.width[57] = 500;
ff.sb.width[58] = 277;
ff.sb.width[59] = 277;
ff.sb.width[60] = 548;
ff.sb.width[61] = 548;
ff.sb.width[62] = 548;
ff.sb.width[63] = 444;
ff.sb.width[64] = 548;
ff.sb.width[65] = 722;
ff.sb.width[66] = 666;
ff.sb.width[67] = 722;
ff.sb.width[68] = 612;
ff.sb.width[69] = 611;
ff.sb.width[70] = 762;
ff.sb.width[71] = 602;
ff.sb.width[72] = 722;
ff.sb.width[73] = 333;
ff.sb.width[74] = 630;
ff.sb.width[75] = 722;
ff.sb.width[76] = 685;
ff.sb.width[77] = 888;
ff.sb.width[78] = 722;
ff.sb.width[79] = 722;
ff.sb.width[80] = 767;
ff.sb.width[81] = 741;
ff.sb.width[82] = 555;
ff.sb.width[83] = 592;
ff.sb.width[84] = 611;
ff.sb.width[85] = 689;
ff.sb.width[86] = 439;
ff.sb.width[87] = 767;
ff.sb.width[88] = 645;
ff.sb.width[89] = 795;
ff.sb.width[90] = 611;
ff.sb.width[91] = 333;
ff.sb.width[92] = 862;
ff.sb.width[93] = 333;
ff.sb.width[94] = 657;
ff.sb.width[95] = 500;
ff.sb.width[96] = 500;
ff.sb.width[97] = 630;
ff.sb.width[98] = 548;
ff.sb.width[99] = 548;
ff.sb.width[100] = 494;
ff.sb.width[101] = 439;
ff.sb.width[102] = 520;
ff.sb.width[103] = 411;
ff.sb.width[104] = 602;
ff.sb.width[105] = 329;
ff.sb.width[106] = 602;
ff.sb.width[107] = 548;
ff.sb.width[108] = 548;
ff.sb.width[109] = 576;
ff.sb.width[110] = 520;
ff.sb.width[111] = 548;
ff.sb.width[112] = 548;
ff.sb.width[113] = 520;
ff.sb.width[114] = 548;
ff.sb.width[115] = 602;
ff.sb.width[116] = 439;
ff.sb.width[117] = 576;
ff.sb.width[118] = 713;
ff.sb.width[119] = 685;
ff.sb.width[120] = 493;
ff.sb.width[121] = 685;
ff.sb.width[122] = 494;
ff.sb.width[123] = 479;
ff.sb.width[124] = 199;
ff.sb.width[125] = 479;
ff.sb.width[126] = 548;
ff.sb.width[161] = 619;
ff.sb.width[162] = 246;
ff.sb.width[163] = 548;
ff.sb.width[164] = 166;
ff.sb.width[165] = 713;
ff.sb.width[166] = 500;
ff.sb.width[167] = 753;
ff.sb.width[168] = 753;
ff.sb.width[169] = 753;
ff.sb.width[170] = 753;
ff.sb.width[171] = 1041;
ff.sb.width[172] = 987;
ff.sb.width[173] = 602;
ff.sb.width[174] = 987;
ff.sb.width[175] = 602;
ff.sb.width[176] = 399;
ff.sb.width[177] = 548;
ff.sb.width[178] = 411;
ff.sb.width[179] = 548;
ff.sb.width[180] = 548;
ff.sb.width[181] = 713;
ff.sb.width[182] = 494;
ff.sb.width[183] = 460;
ff.sb.width[184] = 548;
ff.sb.width[185] = 548;
ff.sb.width[186] = 548;
ff.sb.width[187] = 548;
ff.sb.width[188] = 1000;
ff.sb.width[189] = 602;
ff.sb.width[190] = 1000;
ff.sb.width[191] = 657;
ff.sb.width[192] = 822;
ff.sb.width[193] = 685;
ff.sb.width[194] = 795;
ff.sb.width[195] = 987;
ff.sb.width[196] = 767;
ff.sb.width[197] = 767;
ff.sb.width[198] = 822;
ff.sb.width[199] = 767;
ff.sb.width[200] = 767;
ff.sb.width[201] = 713;
ff.sb.width[202] = 713;
ff.sb.width[203] = 713;
ff.sb.width[204] = 713;
ff.sb.width[205] = 713;
ff.sb.width[206] = 713;
ff.sb.width[207] = 713;
ff.sb.width[208] = 767;
ff.sb.width[209] = 713;
ff.sb.width[210] = 789;
ff.sb.width[211] = 789;
ff.sb.width[212] = 890;
ff.sb.width[213] = 822;
ff.sb.width[214] = 548;
ff.sb.width[215] = 250;
ff.sb.width[216] = 713;
ff.sb.width[217] = 602;
ff.sb.width[218] = 602;
ff.sb.width[219] = 1041;
ff.sb.width[220] = 987;
ff.sb.width[221] = 602;
ff.sb.width[222] = 987;
ff.sb.width[223] = 602;
ff.sb.width[224] = 494;
ff.sb.width[225] = 329;
ff.sb.width[226] = 789;
ff.sb.width[227] = 789;
ff.sb.width[228] = 786;
ff.sb.width[229] = 713;
ff.sb.width[230] = 383;
ff.sb.width[231] = 383;
ff.sb.width[232] = 383;
ff.sb.width[233] = 383;
ff.sb.width[234] = 383;
ff.sb.width[235] = 383;
ff.sb.width[236] = 494;
ff.sb.width[237] = 494;
ff.sb.width[238] = 494;
ff.sb.width[239] = 494;
ff.sb.width[240] = 789;
ff.sb.width[241] = 329;
ff.sb.width[242] = 274;
ff.sb.width[243] = 685;
ff.sb.width[244] = 685;
ff.sb.width[245] = 685;
ff.sb.width[246] = 383;
ff.sb.width[247] = 383;
ff.sb.width[248] = 383;
ff.sb.width[249] = 383;
ff.sb.width[250] = 383;
ff.sb.width[251] = 383;
ff.sb.width[252] = 494;
ff.sb.width[253] = 494;
ff.sb.width[254] = 494;

 
courier.bf = courier.rm;
	strcat(courier.bf.name, "-Bold");
courier.tt = courier.rm;
courier.it = courier.rm;
	strcat(courier.it.name, "-Oblique");
courier.ph = courier.rm;
	strcat(courier.ph.name, "-BoldOblique");
courier.sb = ff.sb;

ff = courier;  /* Courier font by default*/

last_font = ff.rm;
save_font = ff.rm;
note_font = ff.rm;
sty.font = ff.rm;
G.notesize=sty.fscale;
sty.maxY = (G.paperlength - G.botmargin - G.footskip)*100.0;
sty.cmargins[0] = 0.;

curr_top  = (G.topmargin+G.headsep)*100.0;
the_y = curr_top;
last_bot = curr_top;
for (j=0; j<MaxCol; j++) sty.cratio[j] = 1.0;
max_height = 730;
init_width(&G, &sty);

			fprintf(outfile, "%%%%Page: %d %d\n", page_count++,
			G.pagenum); 
			pouts("BS\n0 SI\n"); /* begin a new page */
                        fprintf(outfile, "%.2f /%s AF\n", 
			sty.fscale, sty.font.name);

   
  while( fgets(&inbuffer[0], 1024, infile) != NULL)
 { /* read in line by line */


INFILE: if (input_file)
	{
	if (fgets(&inbuffer[0], 1024, input_F) == NULL) 
		{
			input_file = 0;
			fputs("]\n", stderr);
			fclose(input_F);
			goto next_while;

		}
	}

VALUE: if (value_str) value_string(&G);

 if (store_str)  
 	{
		if (inbuffer[0] == '.')
		{
		for (j=1; j<3; j++)
       			if ((inbuffer[j] > 96) && (inbuffer[j] <126))
			inbuffer[j] -= 32;
		if (strncmp(&inbuffer[1], "ED", 2)==0)
					{store_str = 0;
					 goto next_while;
					 }
		}
	strcat(save[G.str_no].str, inbuffer);
	} 
	else   process_str(inbuffer, &G, &sty);

   next_while:
   if (value_str) goto VALUE;
   if (input_file) goto INFILE;

 }
 	/* now finish up this file */

			if (show_str){
				if (!sty.align)
					pouts(")SH\n");
				else
					Show(&sty);
				}

			if (sty.align)
			{
			 break_paragraph(&G, &sty);
			 }

	       if (do_ul&&!sty.align)
	       {
		if (ul_flag<0) len_ul[num_ul] = the_x - b_ulx[num_ul];
		 for(j=1; j<=num_ul; j++)
		fprintf(outfile, "%.0f %.0f %.0f %.0f UL\n",len_ul[j],G.ul_weit[j],
		b_ulx[j], b_uly[j]);
		}
		number_page(&G, &sty);
			fprintf(outfile, "%%%%BoundingBox: %.0f %.0f %.0f %.0f\n",
			G.leftmargin, G.botmargin, G.paperwidth-G.rightmargin,
			G.paperlength-G.topmargin-G.headsep);
			fputs("ES\n", outfile);
		fprintf(outfile, "%%%%Pages: %d \n", page_count-1);
/* fprintf(stderr, "\n"); */
fclose(outfile);
fclose(infile);
}

 /* process a input string, this is a core of WStroff */
process_str(inbuff, G, sty)
struct GSty *G;
struct Sty *sty;
unsigned char *inbuff;
{
int quwei, tmpchar, j;
int  chinese_byte1;
int  tmpright;
int i;
unsigned char str[80]; 


 for (i=0; i<strlen(inbuff); i++)
  { 
    switch(inbuff[i])
    { /* check line and page breakers */
    case 26: goto next_for; /* DOS end of file, ignore */
    case 140:      /* WordStar new page command*/
		if (tmplen) break_paragraph(G, sty);
		newline = 1;
		show_str = 0;
		r_x = 0;
		add_x = 0;
		newpage = 1;
		columns ++;
		the_y = curr_top;
		break_page(G, sty);
			 newmark = 1;

			 goto next_for;
    case 10:  /* Line Feed */
    case 138:
                   chinese_pair = 1;
			 newmark = 1;
	
    	    if ((strlen(inbuff)==1)&&sty->align)
		{
			 newpara = 1;
			 return(0);
		}

	if (!sty->spack)
	      {

	       if (show_str) {
				if (!sty->align)    	   
					pouts(")SH\n");
				else Show(sty);

				show_str = 0;
				r_x = 0;
				add_x = 0;
			      }
		if (tmplen) out_buffer(sty);

	       the_y += sty->skip*sty->stretch*sty->fscale*10;
	       if (the_y>last_bot) last_bot = the_y;

	       if (do_ul)
	       {
		if (ul_flag<0) len_ul[num_ul] = the_x - b_ulx[num_ul];
		 for(j=1; j<=num_ul; j++)
		fprintf(outfile, "%.0f %.0f %.0f %.0f UL\n",len_ul[j], G->ul_weit[j],
		b_ulx[j], b_uly[j]);
		if (ul_flag<0) {
			b_ulx[1] = curr_left;
			b_uly[1] = the_y + G->ul_sink[num_ul];
			num_ul = 1;
			}
		 else{ do_ul = 0; num_ul=0;}

		}

		the_x = curr_left;
    	       newline=1;

	        if (the_y> sty->maxY)
		{
		newline = 1;
		show_str = 0;
		r_x = 0;
		newpage = 1;
		columns ++;
		if (do_ul)
			b_uly[1] = curr_top + G->ul_lower;
		}
	     }
	     else  
	     {
		if (current_group<0)
			{inbuff[i] = 32; 
			 goto do_ASCII; 
			 }
	     }
               goto next_for;
    case 141: /* Carrige Return, ignore */
    case 13:  if (!sty->align) newline=1;
              goto next_for;
    }


    		/************** check if it is a dot command********/
		if ((i==0)&&(newmark)&&(inbuff[i]=='.'))
		{get_dot_commands(inbuff, G, sty);
			if (!sty->align) newline = 1;
		history = 1;
		return(0);
		}
              	newmark=0; 

		if (newpara&&sty->align)  /* if it is a new paragraph break */
		{
		break_paragraph(G, sty);
		}
		if (newpage) break_page(G, sty); /* if it is a newpage break*/

	    		newpara1 = 0;
	    		newpara = 0;
			history = 0;
	    
	 	if (abs_x!=0.0) set_AbsX(sty); /* if absolute x-position is set*/

		 if (r_x!=0.0) { /* check is there is any horizontal space */
				if (show_str)
				{
				if (!sty->align) pouts(")SH\n");
				else Show(sty);
				show_str = 0;
				}
			if (r_y!=0.0) Rmvxy(r_x, r_y, sty);
			else	Rmvx(r_x, sty);
			r_x = 0.;
			r_y = 0.;
			}

		 if (r_y!=0.0) { /* check is there is any vertical space */
				if (show_str)
				{
				if (!sty->align) pouts(")SH\n");
				else Show(sty);
				show_str = 0;
				}
				Rmvy(r_y, sty);
				r_y = 0;
			}

    switch(inbuff[i])
    { /* check commands */
    case 19:      /* begin underline*/
    case 147:     /* end underline*/
              newline=0; 
	      --i;
	       goto UL;
    case 2:       /* begin bold face*/
    case 130:     /*end bold face*/
              newline=0; 
	      --i;
	      goto BOLD;
    case 20:      /* begin superscript*/
    case 148:     /* end superscript*/
              newline=0;
	      --i;
	      goto Super;
    case 22:      /* begin subscript*/
    case 150:     /* end subscript*/
              newmark=0;
	      --i;
	       goto Sub;
   case '%':
	      if (!sty->align) goto do_ASCII;
	      newmark = 1;
	     return(0); /* it is a comment */
   case '^':
   	switch(inbuff[i+1])
	{  /* it might be a  ^ command */
		case '*': /* linebreak */
			  tmpright = sty->r_right;
			  sty->r_right = 1;
			  newmark = 1;
			  break_line(G, sty);
			  sty->r_right = tmpright;
			  return(0);
		case '\\': /* move to curr_left */
			  abs_x = curr_left;
			i ++; goto next_for;
		case '!': /* set mark */
			  save_x = the_x;
			i ++; goto next_for;
		case '/': /* goto the mark */

			i ++; goto next_for;
		case '^': /* print ^ */
			  i++;
			  goto do_ASCII;
		case '%': /* print % */
			  i++;
			  inbuff[i] = '%';
			  goto do_ASCII;
		case 'o': /* over printing */
		case 'O': ovp = 1;
			i++;	goto next_for;
		case 'u': /* under line */
		case 'U':
UL:
			ul_flag *= -1;
			do_ul = 1;
			if (ul_flag<0) /*mark begin*/
			{
				num_ul ++;
				b_ulx[num_ul] = the_x;
				b_uly[num_ul] = the_y + G->ul_lower;
				G->ul_weit[num_ul] = G->ul_weight;
				G->ul_sink[num_ul] = G->ul_lower;
				if (sty->align)
					ppoutc(21);
			}
			else
			{
				len_ul[num_ul] = the_x - b_ulx[num_ul];
				if (sty->align)
					ppoutc(22);
			}
			i ++; goto next_for;
		case 'b':
		case 'B': /* Boldface */
BOLD:		bf_flag *= -1;
		sty->outl = 0;
			if (show_str){
				if (!sty->align)
					pouts(")SH\n");	
				else
					Show(sty);	
				show_str = 0;
				}
			if (bf_flag<0)
			{
			save_font = last_font;
			last_font = ff.bf;
			sty->font = ff.bf;
			ch_bf = 1;
			}
			else
			{
			ch_bf = 0;
			last_font = save_font;
			sty->font = save_font;
			}

			if (current_group<0) setnchf(sty);

			i ++; goto next_for;

		case 'i':
		case 'I': /*italic */
ITAL:		it_flag *= -1;
		sty->outl = 0;
			if (show_str){
				if (!sty->align)
					pouts(")SH\n");	
				else
					Show(sty);	
				show_str = 0;
				}
			if (it_flag<0)
			{
			save_font = last_font;
			last_font = ff.it;
			sty->font = ff.it;
			if (current_group>=0) sty->sl = -10.;
			}
			else
			{
			last_font = save_font;
			sty->font = save_font;
			if (current_group>=0) sty->sl = 0.;

			}

			if (current_group<0) setnchf(sty);
			else  fslant(sty);
			
			i ++; goto next_for;

		case 'p':
		case 'P': /* Bold Italic */
PHY:		ph_flag *= -1;
		sty->outl = 0;
			if (show_str){
				if (!sty->align)
					pouts(")SH\n");	
				else
					Show(sty);	
				show_str = 0;
				}
			if (ph_flag<0)
			{
			save_font = last_font;
			last_font = ff.ph;
			sty->font = ff.ph;
			if (current_group>=0) sty->sl = -10.;
			}
			else
			{
			last_font = save_font;
			sty->font = save_font;
			if (current_group>=0) sty->sl = 0.;
			}

			if (current_group<0) setnchf(sty);
			else   fslant(sty);

			i ++; goto next_for;

		case 't':
		case 'T': /* Typewriter */
TYP:		tt_flag *= -1;
		sty->outl = 0;
			if (show_str){
				if (!sty->align)
					pouts(")SH\n");	
				else
					Show(sty);	
				show_str = 0;
				}
			if (tt_flag<0)
			{
			save_font = last_font;
			last_font = ff.tt;
			sty->font = ff.tt;
			}
			else
			{
			last_font = save_font;
			sty->font = save_font;
			}

			if (current_group<0) setnchf(sty);
			i ++; goto next_for;

		case 's':
		case 'S': /* Symbol */
Sybm:		sb_flag *= -1;
		sty->outl = 0;
			if (show_str){
				if (!sty->align)
					pouts(")SH\n");	
				else
					Show(sty);	
				show_str = 0;
				}
			if (sb_flag<0)
			{
			save_font = last_font;
			last_font = ff.sb;
			sty->font = ff.sb;

			}
			else
			{
			last_font = save_font;
			sty->font = save_font;
			}

			if (current_group<0) setnchf(sty);
			i ++; goto next_for;

		case 'l': /* subscript, lower*/
Sub:			 lower_flag *= -1;
			if (lower_flag<0)
			 	{
					old_scale = sty->fscale;
					sty->fscale = G->scriptsize1;
					fsize(sty);
					r_y = G->lower1;
				}
				else
			 	{
					sty->fscale = old_scale ;
					fsize(sty);
					r_y = -1.*G->lower1;
				}
			i++; goto next_for;
		case 'L':

			 lower_flag *= -1;
			if (lower_flag<0)
			{
				if (show_str) {
					if (!sty->align)			
						pouts(")SH\n");
					else
						Show(sty);
					show_str = 0;
					add_x = 0;
					}
					r_y = G->lower1;

			}
			else
			{
				if (show_str) {
					if (!sty->align)
						pouts(")SH\n");
					else
						Show(sty);
					show_str = 0;
					add_x = 0.;
					}

				r_y = -1.*G->lower1;
			}
			i++; goto next_for;

		case 'r': /* Superscript, raise */
Super:			raise_flag *= -1;
			 if (raise_flag<0)
			 	{
					old_scale = sty->fscale;
					sty->fscale = G->scriptsize1;
					fsize(sty);
					r_y = (-1.)*G->raise1;
				}
				else
			 	{
					sty->fscale = old_scale ;
					fsize(sty);
				r_y = G->raise1;
				}
			i++; goto next_for;
		case 'R':

			raise_flag *= -1;
			if (raise_flag<0)
			{
				if (show_str) {
					if (!sty->align)
						pouts(")SH\n");
					else
						Show(sty);
					show_str = 0;
					add_x = 0.;
					}
				r_y = (-1.)*G->raise1;
			}
			else
			{
				if (show_str) {
					if (!sty->align)
						pouts(")SH\n");
					else
						Show(sty);
					show_str = 0;
					add_x = 0.;
					}
				r_y = G->raise1;

			}
			i++; goto next_for;

		case '#': /* here comes ASCII codes in 3 digit octal numbers */
			 sscanf(&inbuff[i+2], "%3o", &tmpchar);
			 i += 4 ;
			 inbuff[i] = tmpchar;
			 goto do_ASCII;
		case '0': /* here comes ASCII codes in decimal numbers */
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			 sscanf(&inbuff[i+1], "%d", &tmpchar);
			 sprintf(str, "%d", tmpchar);
			 i += strlen(str) ;
			 inbuff[i] = tmpchar;
			 goto do_ASCII;
		default:
			goto do_ASCII;
	                /* end ^ commands */
	}
    default:

/* 1. If it is a Chinese character */
   if ((inbuff[i] > 160) && (inbuff[i] < 255))
         {

          chinese_pair *= -1;
            if (chinese_pair<0) {
		chinese_byte1=inbuff[i];
                }
              else 
                { quwei = (chinese_byte1-161)*94+(inbuff[i]-161) ;
begin_ch:              the_group = chinese[quwei]/font_group_size;

     tmpchar = chinese[quwei]-font_group_size*the_group+1 + font_overhead; 


	switch(quwei) /* if it is a punctuation, do not break */
	{
		case 1:
		case 2:
		case 188:
		case 196:
		case 199:
		case 201:
		case 213:
		case 214:
		case 218:
			last_char = 3; break;
	}

	this_width = 72.5*sty->fscale;
	if (sty->align&&(last_char==0))
		this_width += add_x*sty->fscale;

	if ((the_x>sty->maxX-this_width)&&!ovping)
	{				/* good place to break the line; */
		if (!sty->align) break_line(G, sty);
		else if (!r_y&&last_char<2)
			{	break_line(G, sty);
				if (last_char==0&&left_len==0.0) add_x = 0.;
			}
	}		

	if (!r_y&&last_char<2&&!ovping) {last_b = tmplen; last_x = the_x; }

			if (newline)
			{
				AbsMv(sty);
			}

             if (current_group != the_group) 
                   { /* chteck fonts */
			if (show_str){
				if (!sty->align)
				 {
					if (add_x)
					{
						add_x -= 1.;
						add_x *= sty->fscale*0.1;
					fprintf(outfile, " )%.0f W\n",add_x);
					}
					else
					pouts(")SH\n");
				 }
				else
					Show(sty);
				add_x  = 0.;
				show_str = 0;
				}

                       	current_group = the_group;
                        setchf(current_group, sty);
                   }


		if (!sty->align&&show_str&&add_x!=0.0) /* check if there was interword_space */
		{
		
		add_x -= 1.;
		add_x *= sty->fscale*0.1;
		fprintf(outfile, " )%.0f W\n",add_x);
			add_x = 0.;
			show_str = 0;
		}

     		if (!show_str)
		{ 

				if (!sty->align)
					poutc('(');
				else
					ppoutc('(');
				show_str = 1;

		}

			      newline = 0;
			      r_x = 0.;
			      r_y = 0.;
			      add_x = 0.;

     		switch(tmpchar)
		{
			case '(': 
				if (!sty->align) 
				   pouts("\\050");
				 else poctal("\\050"); break;
			case ')':
				if (!sty->align) 
				   pouts("\\051");
				 else poctal("\\051"); break;
			case '\\':
				if (!sty->align) 
				   pouts("\\134");
				 else poctal("\\134"); break;
			default:
			  if (tmpchar>126)
			     {tmpchar ++;
				if (!sty->align)
				fprintf(outfile, "\\%03o", tmpchar);
				else
				cpoctal(tmpchar);
			     }
			     else 
			     	{if (!sty->align) poutc(tmpchar);
					else ppoutc(tmpchar);
				}

		}

		 last_last = last_char;
		 last_char = 1;
		if (ovping) {ovping = 0; ovp = 0;}

		if (ovp)
		{
			ovping = 1;
			r_x = -  72.5*sty->fscale;
		}
		else if (ch_bf)
		 {the_x += 72.5*(sty->fscale+0.5);
		  ch_bold(tmpchar, sty);
	
		 }
		else
		{the_x += 72.5*sty->fscale;

		}

		 if (sty->align&&last_last==3)
		 {
			ppoutc(160);
			last_char = 0;
			last_bk = sty->fscale*0.1;
			the_x += last_bk;
			last_scale = sty->fscale;

		 }

         }

	}
    else 
       {    /* 2. else it is not a Chinese character */

           if (inbuff[i]>127) inbuff[i] -= 128; /* It's a WordStar char*/
	  
	   if (inbuff[i] == 9) inbuff[i] = 32;

do_ASCII:
           if (Cconvert)
                 {  
		   if (inbuff[i]==32) quwei = 0;
		   else quwei=All_Ch(inbuff[i]);
                   goto begin_ch;

                 }

               /* Now deal with the spaces carefully 
                 1. The PostScript space 32 in Chinese fonts is very
                     small, 
                 2. If left alignment is requested, ignore the leading
                    spaces in  line, and use leftmargin for all lines
                 3. If paragraph alignment is requested, all the spaces
                    have to be repacked by stretching and shrinking.
               */

	       sty->font = last_font;

             if (inbuff[i]==32)
               {

	       if (!sty->align)
	        { /* in non-format environment keep the spaces*/

		if (newline)
			{
			 the_x += G->chspace*sty->fscale*0.1;
			goto next_for;
			}
		else if (current_group>=0)
			{
			 add_x += G->chspace;
			 the_x += G->chspace*sty->fscale*0.1;
			 last_char = 0;
			 goto next_for;
			}

 		}
		else
		{ /* in format environment keep spaces is important in
			marking the end of words, and provide stretches
			multiple ones are condensed to one*/
			if (newline) goto next_for;
			else if (!last_char&&sty->spack)
				 goto next_for;

			 last_char = 0;

		}


               }

	       	last_last = last_char;
		this_width= (float)sty->font.width[inbuff[i]]*sty->fscale*0.1;

	if (inbuff[i]!=32)
	 	{
		last_char = 2;
		}
		
	if ((the_x>sty->maxX-this_width)&&!ovping)
	{/* good place to break the line; */
		if (!sty->align) break_line(G, sty);
		else if (!r_y&&(last_char<2))
			{
				break_line(G, sty);
				the_group = save_group;
			if ((last_char==0)&&(left_len==0.0)) goto next_for;
		      	}
	}

	if (!r_y&&last_char<2&&!ovping) {last_b = tmplen;
		 last_x = the_x;
		last_scale = sty->fscale;
 		}


			if (newline) /* check if it is a new line */
			{
 			AbsMv(sty);
			}

              if (current_group >= 0)  /* check if the font group is right*/
                         { 
				if (last_char==0)
				{
				if (!sty->align)
				add_x += G->chspace;
				else
				add_x += (float)sty->font.width[32];
				goto next_for;
				}

			if (show_str){
				if (!sty->align)
					{
					if (add_x)
					{
						add_x -= 1.;
						add_x *= sty->fscale*0.1;
					fprintf(outfile, " )%.0f W\n",add_x);
					}
					else
					pouts(")SH\n");
					add_x = 0.;
					}
				else
					Show(sty);
				show_str = 0;
				}
				if (sty->outl) setoutlf(sty);
				else setnchf(sty);
				

                          current_group = -1;

			}


     		if (!show_str)
		{ 

				if (!sty->align)
					poutc('(');
				else
					ppoutc('(');

				add_x = 0.;
				show_str = 1;

		}

			      newline = 0;
			      r_x = 0.;
			      r_y = 0.;			   

     		switch(inbuff[i])
		{
			case '(': 
				if (!sty->align) 
				   pouts("\\050");
				 else poctal("\\050"); break;
			case ')':
				if (!sty->align) 
				   pouts("\\051");
				 else poctal("\\051"); break;
			case '\\':
				if (!sty->align) 
				   pouts("\\134");
				 else poctal("\\134"); break;
			case 32: if (sty->align)
				   ppoutc(160);
				  else poutc(32);
				  last_bk = this_width;
				  break;
			default:
			  if (inbuff[i]>126)
			     {
				if (!sty->align)
				fprintf(outfile, "\\%03o", inbuff[i]);
				else
				cpoctal(inbuff[i]);
			     }
			     else 
			     	{if (!sty->align) poutc(inbuff[i]);
					else ppoutc(inbuff[i]);
				}

		}
		if (ovping)  {ovping = 0; ovp = 0;}
		if (!ovp)
		  the_x += this_width;
		 else
		 {
			r_x = - this_width;
			ovping = 1;
		 }


       }  /* end of else < 161 */
   }     /* end of switch */
       next_for:;
  }
next_while:;
}


 /* expand the defined string */
value_string(G)
struct GSty *G;
{
int i;
unsigned char tmpchar;

 i=0;
	while((save[G->str_N].str[G->str_len+i]!=10)&&(save[G->str_N].str[G->str_len+i]!=0))
		i++;
	i++;
	if (G->str_L <= G->str_len + i) 
	{
	value_str=0;
	strcpy(inbuffer, &save[G->str_N].str[G->str_len]);
	}
	else {
	tmpchar = save[G->str_N].str[G->str_len+i];
	save[G->str_N].str[G->str_len+i] = '\0';
	strcpy(inbuffer, &save[G->str_N].str[G->str_len]);
	save[G->str_N].str[G->str_len+i] = tmpchar;
	G->str_len += i;
	}
	newmark = 1;

}

 /* expand the tmpbuffer for the current linem, write into the output file */
out_buffer(sty)
struct Sty *sty;
{ /* treat and output the line bufffer */
float final_x, final_y, stop_x, space_pad=0.0, x_mv, shift0=0.;
int j, ul_num=0, space_num=0, p_match=0, x_byte, k=0;
int stop_len;
int sub_num=0, loc_num=0, ul_no=0;
int tmpr;
unsigned int tmpint;

	if (!tmplen) return;
	tmpr = sty->r_right;

	if ((the_x>sty->maxX) && (last_b>0))
	{
			stop_len = last_b;
			stop_x = last_x;
	}
	else 
	{
		stop_len = tmplen;
		stop_x = the_x;
		if (newpara) sty->r_right = 1;

	}

	space_num = 0;
	for(j=0; j<stop_len; j++)/* check the number of spaces of underlines*/
	switch(tmpbuffer[j])
	{
	  case 160:
	  case 8: space_num ++; break;
	  case 21: ul_num ++;
	}

	if ((stop_x<sty->maxX)&&(space_num>0))
	{
		space_pad = (sty->maxX-stop_x)/space_num;
	}
	space_num = 0;
	
	for(j=0; j<stop_len; j++)/* check the number of spaces and underlines*/
	switch(tmpbuffer[j])
	{
	case 23: /* possible widthshow */
		if (sty->center||sty->r_right||sty->f_right||(space_pad==0.0)||!space_num)
		{
			pouts("SH\n");
		}
		else 
		{
			tmpint = space_pad + 0.9;
			fprintf(outfile, "%d W\n", tmpint);
		}
		  space_num = 0;

		break;
	case 8: /* may need to add width to W */
		sscanf(&tmpbuffer[j+1], "%f", &x_mv);
		k=1;
		while(tmpbuffer[j+k]!=9) k++;
		j += k;

		if (sty->center||sty->r_right||sty->f_right||(space_pad==0.0))
		{
			fprintf(outfile, ")SH %.0f XR ", x_mv);
		}
		else 
		{
			if (space_num)
			fprintf(outfile, ")%.0f W %.0f XR ",space_pad,
				x_mv+space_pad);
			else
			fprintf(outfile, ")SH %.0f XR ", x_mv+space_pad);
		}
		p_match = 0;
		sub_num++;
		loc_num++;
		break;
	case 160: /* space */
		  poutc(32); space_num ++;
		  loc_num ++;
		  sub_num ++;
		  break;
	case 24: /* ^X for absolute x move */
		if (sty->center)
		{
			shift0 = (sty->maxX - stop_x)/2.;
			this_x += shift0;
		}
		else if (sty->f_right)
		{
			shift0 = sty->maxX - stop_x;
			this_x += shift0;
		}

			fprintf(outfile, "%.0f", this_x);
		break;
	case 25: /* ^Y for absolute y move */
			fprintf(outfile, "%.0f", this_y);		
		break;
	case '(': /* open string */
		  p_match = 1;
		  space_num = 0;
		  poutc('(');
		  break;
	case ')': /* close string */
		  p_match = 0;	
		  poutc(')');
		  break;
	case 21: loc_num = 0; ul_no++;
		 b_ulx[ul_no] += shift0 + (float)sub_num*space_pad;
		 break;
	case 22:
		len_ul[ul_no] += (float)loc_num*space_pad;
		break;
	case 0: break;
	default: poutc(tmpbuffer[j]);
	}

	if (p_match)
	{
		poutc(')');
		if (sty->center||sty->r_right||sty->f_right||(space_pad==0.0)||!space_num)
		{
			pouts("SH\n");
		}
		else 
		{
			fprintf(outfile, "%.0f W\n", space_pad);
		}

	}

	/*  if the final_x and/or final_y are different from this_x and this_y
	have to fix the underline elements */

sty->r_right = tmpr;
last_b = 0;

if (DEBUG)
fprintf(stdout, "\n*begin*\n%s\n**stop=%c\n**the_x=%.0f\n\
**last_x=%.0f\n**useable=%.0f\n\
**left_len = %.0f\n\
\n", tmpbuffer, tmpbuffer[stop_len], the_x, last_x,
sty->maxX, left_len);


	if (stop_len==tmplen)
		{
		left_len = 0.;
		}
	else
	{

		if (tmpbuffer[stop_len]==8)
		{
		sscanf(&tmpbuffer[stop_len+1], "%f", &x_mv);
		k=1;
		while(tmpbuffer[stop_len+k]!=9) k++;
		stop_len += k+1;
		stop_x +=  x_mv + 0.1*last_scale;
		x_byte = 0;
		}
		else
		{
			if (tmpbuffer[stop_len]==160)
			{
			 if (tmpbuffer[stop_len+1]==')')
			 {
				k=1;
				while((tmpbuffer[stop_len+k]!=10)
				&&(tmpbuffer[stop_len+k]!=23) 
				&&(tmpbuffer[stop_len+k]!=9)) k++;
			 stop_len += k+1;
			 p_match = 0;
			 }
			 else stop_len += 1; 
			 stop_x += last_bk;
			}

			if (p_match)
			{
			tempwd[0]='(';
			x_byte = 1;
			}
			else x_byte = 0;
		}
			strcpy(&tempwd[x_byte], &tmpbuffer[stop_len]); 
		left_len = the_x - stop_x;

	}

		for (j=0; j<=tmplen; j++)
		tmpbuffer[j] = 0;
		tmplen = 0;



}


Show(sty)  /* show string */
struct Sty *sty;
{
char str[80];

		if (current_group>=0&&add_x!=0.0)
		{
		add_x *= sty->fscale*0.1;
		sprintf(str,  "%c%.0f %c",8, add_x, 9); 
				/*^H is horizontal move	flag*/
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		the_x += add_x;

		}
		else
		{
		tmpbuffer[tmplen] = ')';
		tmpbuffer[tmplen+1] = 23;  /* will be widthshow */
		tmplen += 2;
		}
		tmpbuffer[tmplen] = 0;
		noindent = 0;
		show_str = 0;
		add_x = 0.;

}

 /* output an octal number in PostScript string */
poctal(s)
char *s;
{
		 strcat(tmpbuffer, s);
		 tmplen += 4;
}

 /* write a character into an octal numer */
cpoctal(c)
unsigned char c;
{
	sprintf(&tmpbuffer[tmplen], "\\%03o", c);
	tmplen += 4;
}

 /* write a character */
ppoutc(c)
char c;
{

	tmpbuffer[tmplen] = c;
	tmplen += 1;
	tmpbuffer[tmplen] = 0;
}

 /* move to an absolute position */
AbsMv(sty)
struct Sty *sty;
{
char str[80];
		if (!sty->align)
			fprintf(outfile, "%.0f %.0f MT ", the_x, the_y);
		else
		{
		sprintf(str,  "%c %c MT ", 24, 25);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		this_x = the_x;
		this_y = the_y;
		if (left_len>0.0) {strcat(tmpbuffer, tempwd);
			tmplen += strlen(tempwd);
			the_x +=  left_len;
			left_len = 0.;
			}

		}
		newline = 0;
}

 /* move x relatively */
Rmvx(x, sty)
struct Sty *sty;
float x;
{
char str[80];
		if (!sty->align)
			fprintf(outfile, "%.0f XR ", x);
		else
		{
		sprintf(str,  "%.0f XR ", x);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}
}

 /* move y relatively */
Rmvy(y, sty)
struct Sty *sty;
float y;
{
char str[80];

		if (!sty->align)
			fprintf(outfile, "%.0f YR ", y);
		else
		{
		sprintf(str,  "%.0f YR ", y);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}

}

 /* move x absolute */
set_AbsX(sty)
struct Sty *sty;
{
float tmpwidth;
int tmpint;
		if (newline||newpara) return;

			if (show_str) {
				if (!sty->align)
					pouts(")SH\n");
				else
					Show(sty);
				show_str = 0;
				r_x = 0.;
				add_x = 0.;
			      }

			if (tmplen&&sty->align)
			{
				tmpint = sty->r_right;
				tmpwidth = sty->maxX;
				sty->maxX = the_x;
				sty->r_right = 1;
				out_buffer(sty);
				sty->maxX = tmpwidth;
				sty->r_right = tmpint;
			}
				the_x = abs_x;
				fprintf(outfile, "%.0f XM ", the_x);
				abs_x = 0.;

}


 /* move x and y relatively */
Rmvxy(x, y, sty)
struct Sty *sty;
float x, y;
{
char str[80];

		if (!sty->align)
			fprintf(outfile, "%.0f %.0f RM ", x, y);
		else
		{
		sprintf(str,  "%.0f %.0f RM ", x, y);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}

}

 /* set Chinese font */
setchf(current_group, sty)
struct Sty *sty;
int current_group;
{
char str[80];

		if (!sty->align)
                fprintf(outfile, "/chfont%d SF\n", current_group);
		else
		{
		sprintf(str,  "/chfont%d SF\n",  current_group);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}

}

 /* set outline font */
setoutlf(sty)
struct Sty *sty;
{
char str[128];

			if (show_str) {
				if (!sty->align)
					pouts(")SH\n");
				else
					Show(sty);
				show_str = 0;
				r_x = 0.;
				add_x = 0.;
			      }
		if (!sty->align) 
		{
                  fprintf(outfile, "/%s /%sOL 1000 %.2f div /%s MF /%sOL SF\n",
		  sty->font.name, sty->font.name,sty->fscale/sty->olwidth,
		  sty->font.name, sty->font.name);
		 }
		else
		{
                  sprintf(str, "/%s /%sOL 1000 %.2f div /%s MF /%sOL SF\n",
		  sty->font.name, sty->font.name, sty->fscale/sty->olwidth,
		  sty->font.name, sty->font.name);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}

}

 /* set non-Chinese font */
setnchf(sty)
struct Sty *sty;
{
char str[128];

			if (show_str) {
				if (!sty->align)
					pouts(")SH\n");
				else
					Show(sty);
				show_str = 0;
				r_x = 0.;
				add_x = 0.;
			      }
		if (!sty->align) 
                  fprintf(outfile, "/%s SF\n",  sty->font.name);
		else
		{
		sprintf(str,  "/%s SF\n",  sty->font.name);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}

}

 /* set font size */
fsize(sty)
struct Sty *sty;
{
char str[80];

			if (show_str) {
				if (!sty->align)
					pouts(")SH\n");
				else
					Show(sty);
				show_str = 0;
				r_x = 0.;
				add_x = 0.;
			      }
		if (!sty->align) 
		{
                  fprintf(outfile, "%.2f SS\n",  sty->fscale);
		}
		else
		{
		sprintf(str,  "%.2f SS\n",  sty->fscale);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}
}

 /* set slant of fonts */
fslant(sty)
struct Sty *sty;
{
char str[80];

			if (show_str) {
				if (!sty->align)
					pouts(")SH\n");
				else
					Show(sty);
				show_str = 0;
				r_x = 0.;
				add_x = 0.;
			      }
		if (!sty->align) 
                  fprintf(outfile, "%.2f SI\n",  sty->sl);
		else
		{
		sprintf(str,  "%.2f SI\n",  sty->sl);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}
}

 /* set bold-face Chinese */
ch_bold(chr, sty)
struct Sty *sty;
unsigned char chr;
{
char str[80];
float width;

 width = 72.5*sty->fscale;

 	if (sty->align)
	{
	
	if (chr>126||chr=='('||chr==')')
	sprintf(str, ")%c %.2f SS -%.0f XR(\\%03o)SH %.2f SS ", 23, 
		sty->fscale+0.5, width, chr, sty->fscale);
	else sprintf(str, ")%c %.2f SS -%.0f XR(%c)SH %.2f SS ", 23, 
		sty->fscale+0.5, width, chr, sty->fscale);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		tmpbuffer[tmplen] = 0;
	}
	else
	{
	if (chr>126||chr=='('||chr==')')
	fprintf(outfile, ")%c %.2f SS -%.0f XR(\\%03o)SH %.2f SS ", 23, 
		sty->fscale+0.5, width, chr, sty->fscale);
	else
	fprintf(outfile, ")SH %.2f SS -%.0f XR(%c)SH %.2f SS ",  
		sty->fscale+0.5, width, chr, sty->fscale);

	}

	show_str = 0;

}

 /* stretch fonts vertically */
fstretch(sty)
struct Sty *sty;
{
char str[80];
		if (!sty->align) 
                  fprintf(outfile, "%.2f ST\n",  sty->sth);
		else
		{
		sprintf(str,  "%.2f ST\n",  sty->sth);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}
}

 /* set the RGB color */
fcolor(sty)
struct Sty *sty;
{
char str[80];
		if (!sty->align) 
                  fprintf(outfile, "%.2f %.2f %.2f SC\n",  sty->color[0],
		  sty->color[1], sty->color[2]);
		else
		{
                  sprintf(str, "%.2f %.2f %.2f SC\n",  sty->color[0],
		  sty->color[1], sty->color[2]);
		strcat(tmpbuffer, str);
		tmplen += strlen(str);
		}
}

 /* break the paragraph */
break_paragraph(G, sty)		
struct GSty *G;
struct Sty *sty;
{
int j;
			/****** end of format line ********/

			newline=1;
			newpara=1;
			if (show_str) {
				if (!sty->align)
					pouts(")SH\n");
				else
					Show(sty);
				show_str = 0;
			      }

		out_buffer(sty);
		if (left_len>0.0)
		{
		break_line(G, sty);
		AbsMv(sty);
		out_buffer(sty);
		}

	if (!newpara1)
		{
	       the_y +=  sty->skip*sty->stretch*sty->fscale*10.0
	       		+ sty->parskip*100.0;
	       if (the_y>last_bot) last_bot = the_y;
	       }
	       if (do_ul)
	       {
		if (ul_flag<0) len_ul[num_ul] = the_x - b_ulx[num_ul];
		 if (!history)
		 for(j=1; j<=num_ul; j++)
		fprintf(outfile, "%.0f %.0f %.0f %.0f UL\n",len_ul[j], G->ul_weit[j],
		b_ulx[j], b_uly[j]);

		if (ul_flag<0) {
			b_ulx[1] = curr_left;
			b_uly[1] = the_y + G->ul_sink[num_ul];
			G->ul_weit[1] = G->ul_weit[num_ul];
			num_ul = 1;
			}
		 else{ do_ul = 0; num_ul=0;}

		}


	        if (the_y> sty->maxY)
		{
		newpage = 1;
		columns ++;
		if (do_ul)
			b_uly[1] = curr_top + G->ul_lower;
		}

		if (noindent||sty->r_right||sty->center||
		sty->f_right) the_x = curr_left;
			else the_x = curr_left+sty->indent*100.0;
		noindent = 0;

		newline = 1;
		show_str = 0;
		r_x = 0.;
		r_y = 0.;
		add_x = 0.;
		history = 0;
		newpara = 0;
		newpara1 = 1;
}


 /* break a page or column */
break_page(G, sty)
struct GSty *G;
struct Sty *sty;
{
int j;
			if (columns > sty->cnumber)
			{
			curr_top =  (G->topmargin+G->headsep)*100.0;
			the_y = curr_top;
			last_bot = the_y;

			columns = 1;
			number_page(G, sty);
			G->pagenum ++;
			fprintf(outfile, "%%%%BoundingBox: %.0f %.0f %.0f %.0f\n",
			G->leftmargin, G->botmargin, G->paperwidth-G->rightmargin,
			G->paperlength-G->topmargin-G->headsep);
			pouts("ES\n");
			fprintf(outfile, "%%%%Page: %d %d\n", page_count++,
			G->pagenum);   /* begin a new page */
			fprintf(outfile,"BS\n%.2f SI\n",sty->sl);
			if (G->landscape){
				if (G->paperlength>612) fputs("RCC\n", outfile);
				else fputs("RC\n", outfile);
				}
			if (sty->sth!=1.0) fprintf(outfile, "%.2f ST\n", sty->sth);
			if (sty->color3)
			fprintf(outfile, "%.2f %.2f %.2f SC\n", sty->color[0],
			sty->color[1], sty->color[2]);
			if (current_group<0)
				{
				if (sty->outl)
                  fprintf(outfile, "/%s /%sOL 1000 %.2f div /%s MF /%sOL AF\n",
		  sty->font.name, sty->font.name, sty->fscale/sty->olwidth,
		  sty->font.name, sty->font.name);
				else
                        	fprintf(outfile, "%.2f /%s AF\n", 
				sty->fscale, sty->font.name);
				}
                	 else  fprintf(outfile, "%.2f /chfont%d AF\n", 
			 	sty->fscale, the_group);
			 curr_left = sty->cwidth[0];
			 sty->maxX =(float) ((curr_left+
			 	sty->cwidth[1]-sty->right)*100.0);
			 curr_left = 100.0*(curr_left+sty->left);
			}
			else
			{

			the_y = curr_top;

			curr_left = 0.;

			for(j=0; j<columns; j++)
			 curr_left += sty->cwidth[j]+sty->cmargins[j];

			 sty->maxX = (curr_left+sty->cwidth[columns]
			 		-sty->right)*100.0;
			 curr_left = 100.0*(curr_left+sty->left);

			}

			if (sty->align)
			{
			 if (sty->center||sty->r_right||sty->f_right||noindent)
 			 the_x = curr_left;
			 else if (newpara||newpara1)
 			 the_x = curr_left+sty->indent*100.0;
			 else  the_x = curr_left;
			 noindent = 0;

			}
			else  the_x = curr_left;

			 newpage = 0;

		if (do_ul) {
			G->ul_weit[1] = G->ul_weit[num_ul];
			b_ulx[1] = the_x;
			b_uly[1] = the_y + G->ul_sink[num_ul];
			num_ul = 1;
			}

}

 /* start a new column */
new_col(G, sty)
struct GSty *G;
struct Sty *sty;
{
int j;


			if ((columns > sty->cnumber)||(columns==1))
			{
			if (last_bot>sty->maxY) 
				{
				columns = sty->cnumber+1;
				break_page(G, sty);
				return;
				}
				
			curr_top = last_bot;
			the_y = curr_top;
			columns = 1;
			curr_left = sty->cwidth[0];
			 sty->maxX =(curr_left+
			 	sty->cwidth[1]-sty->right)*100.0;
			 curr_left = 100.0*(curr_left+sty->left);
			}
			else
			{
				if (sty->cnumber==1)
				{
				columns = sty->cnumber+1;
				break_page(G, sty);
				return;
				}

			the_y = curr_top;
			curr_left = 0.;

			for(j=0; j<columns; j++)
			 curr_left += sty->cwidth[j]+sty->cmargins[j];

			 sty->maxX = (curr_left+sty->cwidth[columns]
			 		-sty->right)*100.0;
			 curr_left = 100.0*(curr_left+sty->left);

			}

			if (sty->align)
			{
			 if (sty->center||sty->r_right||sty->f_right||noindent)
 			 the_x = curr_left;
			 else if (newpara||newpara1)
 			 the_x = curr_left+sty->indent*100.0;
			 else  the_x = curr_left;
			 noindent = 0;

			}
			else  the_x = curr_left;

			 newpage = 0;

		if (do_ul) {
			G->ul_weit[1] = G->ul_weit[num_ul];
			b_ulx[1] = the_x;
			b_uly[1] = the_y + G->ul_sink[num_ul];
			num_ul = 1;
			}

}

 /* break the line */
break_line(G, sty)
struct GSty *G;
struct Sty *sty;
{/* good place to break the line; */
int j;

			/****** end of format line ********/
	       if (show_str) {
				if (!sty->align)
				  pouts(")SH\n");
				  else Show(sty);
			      }
				show_str = 0;
				r_x = 0.;
				add_x = 0.;
				r_y = 0.;
	      if (sty->align)
		out_buffer(sty);

	       the_y += sty->skip*sty->stretch*sty->fscale*10.0;
	       if (the_y>last_bot) last_bot = the_y;

	       if (do_ul)
	       {
		if (ul_flag<0)
		{
		if (sty->align&&!sty->center&&!sty->r_right)
		len_ul[num_ul] = sty->maxX - b_ulx[num_ul];
		else
		len_ul[num_ul] = the_x - b_ulx[num_ul];
		}

		 if (!history)
		 for(j=1; j<=num_ul; j++)
		fprintf(outfile, "%.0f %.0f %.0f %.0f UL\n",len_ul[j], G->ul_weit[j],
		b_ulx[j], b_uly[j]);

		 if (ul_flag>0) { do_ul = 0; num_ul=0;}

		}

	        if (the_y> sty->maxY)
		{
		newpage = 1;
		columns ++;

		break_page(G, sty);
		}
		else the_x = curr_left;

		if (do_ul) {
			G->ul_weit[1] = G->ul_weit[num_ul];
			b_ulx[1] = the_x;
			b_uly[1] = the_y + G->ul_sink[num_ul];
			num_ul = 1;
			}
		newline =1;
}

 /* renew the current left margin */
renew_inleft(sty)
struct Sty *sty;
{
int j;
			if (columns ==1)
			{
			 curr_left = 100.0*(sty->cwidth[0]
			 +sty->left);
			}
			else
			{

			curr_left = 0.;

			for(j=0; j<columns; j++)
			 curr_left += sty->cwidth[j]+sty->cmargins[j];

			 curr_left = 100.0*(curr_left+sty->left);

			}
			 the_x = curr_left + sty->indent*100.0;

}

 /* importing a PostScript file */
include_ps()
{
	
	fprintf(outfile, "\n%.0f %.0f PB\n", the_x, the_y);
	while( fgets(inbuffer, 1024, input_F) != NULL)
	fputs(inbuffer, outfile);
	fputs("\nPE\n", outfile);
	fclose(input_F);
}

 /* number the page and print page headings and footings */
number_page(G, sty)
struct GSty *G;
struct Sty *sty;
{
float width=0., x, y, tmp_y, tmp_x, tmp_width, tmpleft, t_left, tmp_scale;
int templen;
int  j, tmpalign, tmp_pack, tmppara, tmppage, tmp_g, tmp1;
int tmpcol, t_r, t_f, t_c;
char str[80];
unsigned tmptmp[256];
struct Fonts b_font;


	tmptmp[0] = 0;
		t_r = sty->r_right;
		t_f = sty->f_right;
		t_c = sty->center;
		t_left = curr_left;
		tmpalign = sty->align;
		tmpleft = left_len;
		tmppara = newpara;
		tmp1 = newpara1;
		tmp_width = sty->maxX;
		tmp_pack = sty->spack;
		templen = tmplen;
		tmppage = newpage;
		tmp_scale = sty->fscale;
		tmp_y = the_y;
		tmp_x = the_x;
		if (left_len>0.0) strcpy(tmptmp, tempwd);
		tmpcol = sty->cnumber;
		b_font = sty->font;
		tmp_g = the_group;

		sty->cnumber = 1;
		sty->spack = 0;
		left_len = 0.;
		tmplen = 0;
		newpage = 0;
		newline = 1;
		sty->align = 1;
		newpara = 0;


	/* print page heading and page heading first*
	if (G->heading1[0]!=0) /* left heading */
	{
		chinese_pair = 1;
		sty->r_right = 1;
		sty->f_right = 0;
		sty->center  = 0;
		sty->maxX = (G->paperwidth - G->rightmargin)*100.0;
		the_x = (G->leftmargin+G->offset)*100.0;
		curr_left = (G->leftmargin+G->offset)*100.0;
		sty->font = note_font;
		last_font = note_font;
		if (sty->fscale!=G->notesize)
			{sty->fscale = G->notesize;
				fsize(sty);
			}
		if (current_group<0) setnchf(sty);

		the_y = G->topmargin*100.;
		process_str( G->heading1, G, sty);
		out_buffer(sty);


	}

	if (G->heading2[0]!=0) /* center heading */
	{
		chinese_pair = 1;
		sty->r_right = 0;
		sty->f_right = 0;
		sty->center  = 1;
		sty->maxX = (G->paperwidth - G->rightmargin)*100.0;
		the_x = (G->leftmargin+G->offset)*100.0;
		curr_left = (G->leftmargin+G->offset)*100.0;
		sty->font = note_font;
		last_font = note_font;
		if (sty->fscale!=G->notesize)
			{sty->fscale = G->notesize;
				fsize(sty);
			}
		if (current_group<0) setnchf(sty);
		
		the_y = G->topmargin*100.0;
		process_str(G->heading2, G, sty);
		out_buffer(sty);

	}

	if (G->heading3[0]!=0) /* right heading */
	{
		chinese_pair = 1;
		sty->r_right = 0;
		sty->f_right = 1;
		sty->center  = 0;
		sty->maxX = (G->paperwidth - G->rightmargin)*100.0;
		the_x = (G->leftmargin+G->offset)*100.0;
		curr_left = (G->leftmargin+G->offset)*100.0;
		sty->font = note_font;
		last_font = note_font;
		if (sty->fscale!=G->notesize)
			{sty->fscale = G->notesize;
				fsize(sty);
			}
		if (current_group<0) setnchf(sty);


		the_y = G->topmargin*100.0;
		process_str(G->heading3, G, sty);
		out_buffer(sty);
	}	

	if (G->footing1[0]!=0) /* left footing */
	{
		chinese_pair = 1;
		sty->r_right = 1;
		sty->f_right = 0;
		sty->center  = 0;
		sty->maxX = (G->paperwidth - G->rightmargin)*100.0;
		the_x = (G->leftmargin+G->offset)*100.0;
		curr_left = (G->leftmargin+G->offset)*100.0;
		sty->font = note_font;
		last_font = note_font;
		if (sty->fscale!=G->notesize)
			{sty->fscale = G->notesize;
				fsize(sty);
			}
		if (current_group<0) setnchf(sty);

		the_y =  (G->paperlength - G->botmargin)*100.0;
		process_str(G->footing1, G, sty);
		out_buffer(sty);
	}

	if (G->footing2[0]!=0) /* center footing */
	{
		chinese_pair = 1;
		sty->r_right = 0;
		sty->f_right = 0;
		sty->center  = 1;
		sty->maxX = (G->paperwidth - G->rightmargin)*100.0;
		the_x = (G->leftmargin+G->offset)*100.0;
		curr_left = (G->leftmargin+G->offset)*100.0;
		sty->font = note_font;
		last_font = note_font;
		if (sty->fscale!=G->notesize)
			{sty->fscale = G->notesize;
				fsize(sty);
			}
		if (current_group<0) setnchf(sty);


		the_y =  (G->paperlength - G->botmargin)*100.0;
		process_str(G->footing2, G, sty);
		out_buffer(sty);
	}

	if (G->footing3[0]!=0) /* right footing */
	{
		chinese_pair = 1;
		sty->r_right = 0;
		sty->f_right = 1;
		sty->center  = 0;
		sty->maxX = (G->paperwidth - G->rightmargin)*100.0;
		the_x = (G->leftmargin+G->offset)*100.0;
		curr_left = (G->leftmargin+G->offset)*100.0;
		sty->font = note_font;
		last_font = note_font;
		if (sty->fscale!=G->notesize)
			{sty->fscale = G->notesize;
				fsize(sty);
			}
		if (current_group<0) setnchf(sty);


		the_y =  (G->paperlength - G->botmargin)*100.0;
		process_str(G->footing3, G, sty);
		out_buffer(sty);
	}	

		left_len = tmpleft;
		newpage = tmppage;
		newline = 1;
		newpara = tmppara;
		newpara1 = tmp1;
		sty->align = tmpalign;
		the_y = tmp_y;
		the_x = tmp_x;
		curr_left = t_left;
		sty->maxX = tmp_width;
		sty->spack = tmp_pack;
		show_str = 0;
		tmplen = templen;
		sty->fscale = tmp_scale;
		if (left_len>0) strcpy(tempwd, tmptmp);
		sty->cnumber = tmpcol;
		sty->r_right = t_r;
		sty->f_right = t_f;
		sty->center = t_c;
		sty->font = b_font;
		last_font = b_font;
		the_group = tmp_g;

	/* print the page numbers*/
	if (G->pagenum==0||!G->pnumbering) {
		fputs("[#]", stderr);
		return;
		}
	width = 0.;
	if (G->num_sty==1)
		sprintf(str, "%d", G->pagenum);
	width = 0.;
	for(j=0; j<strlen(str); j++)
		width += (float)ff.rm.width[str[j]]*sty->fscale*0.1;

	switch(G->num_loc)
	{
		case 0:
			x = G->leftmargin*100.;
			break;
		case 1:
			x = G->paperwidth/2.
				*100. - width/2.;
			break;
		case 2:
			x = (G->paperwidth-G->rightmargin)*100. - width;
			break;

	}

	switch(G->num_lev)
	{
		case 0:
			y = G->topmargin*100.;
			break;
		case 1:
			y = (G->paperlength - G->botmargin)*100.;
	}

	fprintf(outfile, "%.2f /%s AF\n", sty->fscale, note_font.name);
	fprintf(outfile, "%.0f %.0f MT (%s)SH\n", x, y, str);
	fprintf(stderr, "[%s]", str); 

}

 /* re-initialize the width of text columns */
init_width(G, sty)
struct GSty *G;
struct Sty *sty;
{
float sum, tmpf;
int j;
sum = 0.;


	  for (j=1; j<=sty->cnumber; j++)
	  {
		sty->cmargins[j] = sty->cmargin;
		if (sty->cratio[j] == 0.0) sty->cratio[j] = 1.0;
		sum += sty->cratio[j];
	  }

	for (j=1; j<=sty->cnumber; j++)
	  {
	  	tmpf = (float)sty->cnumber;
	sty->cwidth[j] = (G->textwidth-(tmpf-1.)*sty->cmargin)
				*(sty->cratio[j]/sum);
	  }


			if ((columns > sty->cnumber)||(columns==1))
			{
			curr_left = sty->cwidth[0];
			 sty->maxX =(float)((curr_left+
			 	sty->cwidth[1]-sty->right)*100.0);
			 curr_left = 100.0*(curr_left+sty->left);
			}
			else
			{
			curr_left = 0.;

			for(j=0; j<columns; j++)
			 curr_left += sty->cwidth[j]+sty->cmargins[j];

			 sty->maxX = (float)((curr_left+sty->cwidth[columns]
			 		-sty->right)*100.0);
			 curr_left = 100.0*(curr_left+sty->left);

			}

			if (sty->align)
			{
			 if (sty->center||sty->r_right||sty->f_right||noindent)
 			 the_x = curr_left;
			 else if (newpara||newpara1)
 			 the_x = (float)(curr_left+sty->indent*100.0);
			 else  the_x = curr_left;
			 noindent = 0;

			}
			else  the_x = curr_left;

}

 /* check WStroff dot commands */
get_dot_commands(s, G, sty)
unsigned char *s;
struct GSty *G;
struct Sty *sty;
{
int i, j, k;
unsigned char units[80], font_name[80];
int sum, lens, tmpint;
float tmpf=0, tmpfloat=0;
int comm_no=0;
int bb=0;

      /* change all to upcase */

     for (i=1; i<3; i++)
       if ((s[i] > 96) && (s[i] <126)) s[i] -= 32;

			if (show_str){
				if (!sty->align)
					pouts(")SH\n");
				else
					Show(sty);
				show_str = 0;
				}

      /* Font name */
    if (strncmp(&s[1], "FN",2) == 0)
        { font_name[0] = '\0';
		sscanf(&s[3], "%s", font_name);
		
		if (TFMWidth(font_name)>0)
		{
		save_font = sty->font;
		sty->font = last_font;
		if (current_group<0)
			setnchf(sty);
		}
		else
		{
					last_font = save_font;
			fprintf(stderr, "Can't find TFM file for font %s, font not changed.\n", font_name);
		}
          return(1);
        }


       /* Restore Font */
    if (strncmp(&s[1], "RF",2) == 0)
      {
	last_font = save_font;
	sty->font = save_font;
		if (current_group<0) setnchf(sty);
        return(1);
      }

       /* Font Family */
    if (strncmp(&s[1], "FF",2) == 0)
        { font_name[0] = '\0';
		sscanf(&s[3], "%s", font_name);
		sty->outl = 0;
		
	if (strncmp(font_name, "Couri", 5)==0) /*0. Courier font */
		{
		ff = courier;

		sty->font = ff.rm;
		last_font = ff.rm;
		save_font = ff.rm;
		note_font = ff.rm;

		if (current_group<0)
			setnchf(sty);

		return(1);

		}

		
	if (strncmp(font_name, "Times", 5)==0) /*1. Times font family*/
		{
		ff.tt = courier.tt;
		if (TFMWidth("Times-Roman")>0)
			ff.rm = last_font;
		else { ff.rm = courier.rm;
 		fprintf(stderr, "Can't find TFM file for rm of font %s.\n",
		font_name);
		}

		if (TFMWidth("Times-Bold")>0)
			ff.bf = last_font;
		else { ff.bf = courier.bf;
 		fprintf(stderr, "Can't find TFM file for bf of font %s.\n",
		font_name);
		}
		if (TFMWidth("Times-Italic")>0)
			ff.it = last_font;
		else { ff.it = courier.it;
 		fprintf(stderr, "Can't find TFM file for it of font %s.\n",
		font_name);
		}
		if (TFMWidth("Times-BoldItalic")>0)
			ff.ph = last_font;
		else { ff.ph = courier.ph;
 		fprintf(stderr, "Can't find TFM file for ph of font %s.\n",
		font_name);
		}
		sty->font = ff.rm;
		last_font = ff.rm;
		save_font = ff.rm;
		note_font = ff.rm;

		if (current_group<0)
			setnchf(sty);

		return(1);

		}
		
	if (strncmp(font_name, "Helve", 5)==0) /*2. Helvetica font */
		{
		ff.tt = courier.tt;
		if (TFMWidth("Helvetica")>0)
			ff.rm = last_font;
		else { ff.rm = courier.rm;
 		fprintf(stderr, "Can't find TFM file for rm of font %s.\n",
		font_name);
		}
		if (TFMWidth("Helvetica-Bold")>0)
			ff.bf = last_font;
		else { ff.bf = courier.bf;
 		fprintf(stderr, "Can't find TFM file for bf of font %s.\n",
		font_name);
		}
		if (TFMWidth("Helvetica-Oblique")>0)
			ff.it = last_font;
		else { ff.it = courier.it;
 		fprintf(stderr, "Can't find TFM file for it of font %s.\n",
		font_name);
		}
		if (TFMWidth("Helvetica-BoldOblique")>0)
			ff.ph = last_font;
		else { ff.ph = courier.ph;
 		fprintf(stderr, "Can't find TFM file for ph of font %s.\n",
		font_name);
		}
		sty->font = ff.rm;
		last_font = ff.rm;
		save_font = ff.rm;
		note_font = ff.rm;
		if (current_group<0)
			setnchf(sty);
		return(1);

		}


	if (strncmp(font_name, "NewCe", 5)==0) /*3. NewCenturySchlbk font */
		{
		ff.tt = courier.tt;
		if (TFMWidth("NewCenturySchlbk-Roman")>0)
			ff.rm = last_font;
		else { ff.rm = courier.rm;
 		fprintf(stderr, "Can't find TFM file for rm of font %s.\n",
		font_name);
		}
		if (TFMWidth("NewCenturySchlbk-Bold")>0)
			ff.bf = last_font;
		else { ff.bf = courier.bf;
 		fprintf(stderr, "\n Can't find TFM file for bf of font %s.\n",
		font_name);
		}
		if (TFMWidth("NewCenturySchlbk-Italic")>0)
			ff.it = last_font;
		else { ff.it = courier.it;
 		fprintf(stderr, "\n Can't find TFM file for it of font %s.\n",
		font_name);
		}
		if (TFMWidth("NewCenturySchlbk-BoldItalic")>0)
			ff.ph = last_font;
		else { ff.ph = courier.ph;
 		fprintf(stderr, "\n Can't find TFM file for ph of font %s.\n",
		font_name);
		}
		sty->font = ff.rm;
		last_font = ff.rm;
		save_font = ff.rm;
		note_font = ff.rm;
		if (current_group<0)
                        setnchf(sty);
		return(1);

		}


	if (strncmp(font_name, "Lubal", 5)==0) /*4. LubalinGraph font */
		{
		ff.tt = courier.tt;
		if (TFMWidth("LubalinGraph-Book")>0)
			ff.rm = last_font;
		else { ff.rm = courier.rm;
 		fprintf(stderr, "\n Can't find TFM file for rm of font %s.\n",
		font_name);
		}
		if (TFMWidth("LubalinGraph-Demi")>0)
			ff.bf = last_font;
		else { ff.bf = courier.bf;
 		fprintf(stderr, "\n Can't find TFM file for bf of font %s.\n",
		font_name);
		}
		if (TFMWidth("LubalinGraph-BookOblique")>0)
			ff.it = last_font;
		else { ff.it = courier.it;
 		fprintf(stderr, "\n Can't find TFM file for tt of font %s.\n",
		font_name);
		}
		if (TFMWidth("LubalinGraph-DemiOblique")>0)
			ff.ph = last_font;
		else { ff.ph = courier.ph;
 		fprintf(stderr, "\n Can't find TFM file for ph of font %s.\n",
		font_name);
		}
		sty->font = ff.rm;
		last_font = ff.rm;
		save_font = ff.rm;
		note_font = ff.rm;
		if (current_group<0)
                        setnchf(sty);
		return(1);

		}



	if (strncmp(font_name, "Palat", 5)==0) /*5. Palatino font */
		{
		ff.tt = courier.tt;
		if (TFMWidth("Palatino-Roman")>0)
			ff.rm = last_font;
		else { ff.rm = courier.rm;
 		fprintf(stderr, "\n Can't find TFM file for rm of font %s.\n",
		font_name);
		}
		if (TFMWidth("Palatino-Bold")>0)
			ff.bf = last_font;
		else { ff.bf = courier.bf;
 		fprintf(stderr, "\n Can't find TFM file for bf of font %s.\n",
		font_name);
		}
		if (TFMWidth("Palatino-Italic")>0)
			ff.it = last_font;
		else { ff.it = courier.it;
 		fprintf(stderr, "\n Can't find TFM file for it of font %s.\n",
		font_name);
		}
		if (TFMWidth("Palatino-BoldItalic")>0)
			ff.ph = last_font;
		else { ff.ph = courier.ph;
 		fprintf(stderr, "\n Can't find TFM file for ph of font %s.\n",
		font_name);
		}
		sty->font = ff.rm;
		last_font = ff.rm;
		save_font = ff.rm;
		note_font = ff.rm;
		if (current_group<0)
                        setnchf(sty);
		return(1);

		}



	if (strncmp(font_name, "Avant", 5)==0) /*6. AvantGarde font */
		{
		ff.tt = courier.tt;
		if (TFMWidth("AvantGarde-Book")>0)
			ff.rm = last_font;
		else { ff.rm = courier.rm;
 		fprintf(stderr, "\n Can't find TFM file for rm of font %s.\n",
		font_name);
		}
		if (TFMWidth("AvantGarde-Demi")>0)
			ff.bf = last_font;
		else { ff.bf = courier.bf;
 		fprintf(stderr, "\n Can't find TFM file for bf of font %s.\n",
		font_name);
		}
		if (TFMWidth("AvantGarde-BookOblique")>0)
			ff.it = last_font;
		else { ff.it = courier.it;
 		fprintf(stderr, "\n Can't find TFM file for it of font %s.\n",
		font_name);
		}
		if (TFMWidth("AvantGarde-DemiOblique")>0)
			ff.ph = last_font;
		else { ff.ph = courier.ph;
 		fprintf(stderr, "\n Can't find TFM file for ph of font %s.\n",
		font_name);
		}
		sty->font = ff.rm;
		last_font = ff.rm;
		save_font = ff.rm;
		note_font = ff.rm;
		if (current_group<0)
                        setnchf(sty);
		return(1);

		}



	if (strncmp(font_name, "Souve", 5)==0) /*7. Souvenir font */
		{
		ff.tt = courier.tt;
		if (TFMWidth("Souvenir-Light")>0)
			ff.rm = last_font;
		else { ff.rm = courier.rm;
 		fprintf(stderr, "\n Can't find TFM file for rm of font %s.\n",
		font_name);
		}
		if (TFMWidth("Souvenir-Demi")>0)
			ff.bf = last_font;
		else { ff.bf = courier.bf;
 		fprintf(stderr, "\n Can't find TFM file for bf of font %s.\n",
		font_name);
		}
		if (TFMWidth("Souvenir-LightItalic")>0)
			ff.it = last_font;
		else { ff.it = courier.it;
 		fprintf(stderr, "\n Can't find TFM file for it of font %s.\n",
		font_name);
		}
		if (TFMWidth("Souvenir-DemiItalic")>0)
			ff.ph = last_font;
		else { ff.ph = courier.ph;
 		fprintf(stderr, "\n Can't find TFM file for ph of font %s.\n",
		font_name);
		}
		sty->font = ff.rm;
		last_font = ff.rm;
		save_font = ff.rm;
		note_font = ff.rm;
		if (current_group<0)
                        setnchf(sty);
		return(1);

		}

	fprintf(stderr, "Font family %s is not implemented.\n", font_name);

        }


       /* Set Roman font */               
    if (strncmp(&s[1], "RT",2) == 0 )
       { 
	last_font = ff.rm;
	save_font = sty->font;
	sty->font = ff.rm;
	sty->outl = 0;
	ch_bf = 0;
		if (current_group<0)
                        setnchf(sty);
		else if (sty->sl!=0.0)
		{sty->sl = 0.;
		fslant(sty);
		}
		

         return(1);
       }

       /* Set Boldfacc font */               
    if (strncmp(&s[1], "BF",2) == 0 )
       { 
	last_font = ff.bf;
	save_font = sty->font;
	sty->font = ff.bf;
	sty->outl = 0;
	ch_bf = 1;
		if (current_group<0)
                        setnchf(sty);

         return(1);
       }

       /* Set Italic font */               
    if (strncmp(&s[1], "IT",2) == 0 )
       { 
	last_font = ff.it;
	save_font = sty->font;
	sty->font = ff.it;
	sty->outl = 0;
	ch_bf = 0;
		if (current_group<0)
                        setnchf(sty);
		else
		{ sty->sl = -10.;
		fslant(sty);
		}

         return(1);
       }


       /* Set Bold Italic font */               
    if (strncmp(&s[1], "PH",2) == 0 )
       { 
	last_font = ff.ph;
	save_font = sty->font;
	sty->font = ff.ph;
	sty->outl = 0;
	ch_bf = 0;
		if (current_group<0)
                        setnchf(sty);
		else
		{ sty->sl = -10.;
		fslant(sty);
		}

         return(1);
       }


       /* Set Typewriter font */               
    if (strncmp(&s[1], "TT",2) == 0 )
       { 
	last_font = ff.tt;
	save_font = sty->font;
	sty->font = ff.tt;
	sty->outl = 0;
	ch_bf = 0;
		if (current_group<0)
                        setnchf(sty);

         return(1);
       }


       /* Set Symbol font */               
    if (strncmp(&s[1], "SB",2) == 0 )
       { 
	last_font = ff.sb;
	save_font = sty->font;
	sty->font = ff.sb;
	sty->outl = 0;
	ch_bf = 0;
		if (current_group<0)
                        setnchf(sty);

         return(1);
       }

       /* Set Outline font */               
    if (strncmp(&s[1], "OL",2) == 0 )
       { 
	last_font = ff.bf;
	save_font = sty->font;
	sty->font = ff.bf;
	sty->outl = 1;
		if (current_group<0)
                        setoutlf(sty);

         return(1);
       }

       /* G->landscape orientation */               
    if (strncmp(&s[1], "LD",2) == 0 )
       { 
	 G->landscape = 1;
	 tmpfloat = G->paperlength;
	 G->paperlength = G->paperwidth;
	 G->paperwidth = tmpfloat;
		G->textwidth = G->paperwidth - G->leftmargin - G->rightmargin -
			    G->offset;
	 init_width(G, sty);
		sty->maxY = (G->paperlength - G->botmargin - G->footskip)*100.0;
	 if (newpage)
		if (G->paperlength>612) fputs("RCC\n", outfile);
		else fputs("RC\n", outfile);	 
         return(1);
       }

       /* portrait orientation */               
    if (strncmp(&s[1], "PT",2) == 0 )
       { 
	 G->landscape = 0;
	 tmpfloat = G->paperlength;
	 G->paperlength = G->paperwidth;
	 G->paperwidth = tmpfloat;
		G->textwidth = G->paperwidth - G->leftmargin - G->rightmargin -
			    G->offset;
		sty->maxY = (G->paperlength - G->botmargin - G->footskip)*100.0;
	 init_width(G, sty);
         return(1);
       }

       /* Message */               
    if (strncmp(&s[1], "IG",2) == 0 ||strncmp(&s[1], "DM",2) == 0)
       { fprintf(stderr, "%s\n", &s[3]);
         return(1);
       }


       /* Newpage */
    if ((strncmp(&s[1], "PA",2) == 0)||(strncmp(&s[1], "NP",2) == 0))
      {
		if (tmplen) break_paragraph(G, sty);
		newline = 1;
		show_str = 0;
		r_x = 0.;
		add_x = 0.;
		newpage = 1;
		columns = sty->cnumber+1;
		the_y = curr_top;
		break_page(G, sty);

       return(1);
       }


       /* New column */
    if (strncmp(&s[1], "NC",2) == 0)
      {
	 tmpint = 0;

	 if (tmplen) break_paragraph(G, sty);

          sscanf(&s[3], "%d", &tmpint);
		newline = 1;
		show_str = 0;
		r_x = 0.;
		r_y = 0.;
		add_x = 0.;
	if (tmpint>0) {
		if (tmpint <= columns) curr_top = last_bot;
		columns = tmpint;
		}
		else{
		if (!newpage) columns ++;
		}
		the_y = curr_top;
		new_col(G, sty);
       return(1);
       }

       /* On align paragraph */
    if ((strncmp(&s[1], "PF",2) == 0)||(strncmp(&s[1], "TX",2) == 0))
        { sty->align = 1;
		sty->indent = G->parindent;
		sty->spack = 1;
		sty->center = 0;
		sty->f_right = 0;
		sty->r_right = 0;
          return(1);
        }


       /* No fill paragraph */
    if (strncmp(&s[1], "NF",2) == 0)
        { sty->align = 0;
	   sty->spack = 0;
		sty->center = 0;
		sty->f_right = 0;
		sty->r_right = 0;
          return(1);
        }

       /* do not indent this paragraph */
    if (strncmp(&s[1], "NI",2) == 0)
        { noindent = 1;
          return(1);
        }

       /* Convert Chinese */
    if (strncmp(&s[1], "CC",2) == 0)
       {
        Cconvert = 1;
        return(1);
       }


       /* ragged right, or flush left */
    if (strncmp(&s[1], "RR",2) == 0)
        { 
		if (tmplen>0)  break_paragraph(G, sty);
		sty->r_right = 1;
		sty->center = 0;
		sty->f_right = 0;
		sty->spack = 0;
		newpara1 = 1;
		return(1);
        }

       /* flush right? */
    if ((strncmp(&s[1], "OJ",2) == 0)||(strncmp(&s[1], "FR",2) == 0))
        {
		if (tmplen>0)  break_paragraph(G, sty);
		sty->f_right = 1;
		sty->center = 0;
		sty->r_right = 0;
		sty->spack = 0;
		sty->align = 1;
		newpara1 = 1;
		return(1);
        }


       /* center? */
    if ((strncmp(&s[1], "CE",2) == 0)||(strncmp(&s[1], "CT",2) == 0))
        {
		if (tmplen>0) break_paragraph(G, sty);
		newpara1 = 1;
		sty->spack = 0;
		sty->center = 1;
		sty->r_right = 0;
		sty->f_right = 0;
		sty->align = 1;
		return(1);
        }

       /* Omit page number */
    if (strncmp(&s[1], "OP",2) == 0)
       { G->pnumbering = 0;
         return(1);
       }

       /* save some definitions */
    if (strncmp(&s[1], "SV",2) == 0)
       { 
	 save_sty = *sty;
         return(1);
       }

       /* restore everything */
    if (strncmp(&s[1], "RS",2) == 0)
       { 
	 *sty = save_sty;
	 init_width(G, sty);
	 G->parindent = sty->indent;
         return(1);
       }

       /* Restore page number */
    if (strncmp(&s[1], "PG",2) == 0)
      {
	 G->pnumbering = 1;
        return(1);
      }

       /* define a string */
    if (strncmp(&s[1], "DF",2) == 0)
      { 
	units[0] = 0;
	store_str = 1;
	G->str_len = 0;
	j=3;
	while(s[j]==32) j++;
	 G->str_N = -1;
	 sscanf(&s[j], "%s", units);
	 lens = strlen(units);

	if (G->lstr_no>=MaxStrNo)
		{
fprintf(stderr, "Capacity exceeded!! WStroff can only store %d commands.\n\
Not storing string %s", MaxStrNo, units);
		store_str=0;
		return(0);
		}

	/* see if it's a saved string */
	for(k=0; (k<MaxStrNo)&&(k<G->lstr_no); k++)
		{
		if (lens==strlen(save[k].name))
		  {
		   if (strncmp(units, save[k].name, lens)==0)
		   G->str_N = k;
		   }
		}

	if (G->str_N>=0) G->str_no = G->str_N;
	 else {	G->str_no = G->lstr_no; G->lstr_no++;}

	strcpy(save[G->str_no].name, units);
	save[G->str_no].str[0] = 0;
        return(1);
      }

       /* end define a string, it is useless here */
    if (strncmp(&s[1], "ED",2) == 0)
      {

	store_str = 0;
        return(1);
      }

       /* excute or value a string */
    if (strncmp(&s[1], "EX",2) == 0)
      {
	units[0] = 0;
	 G->str_N = -1;
	 G->str_len = 0;
	j=3;
	while(s[j]==32) j++;

	 sscanf(&s[j], "%s", units);
	 lens = strlen(units);

	/* see if it's a saved string */
	for(k=0; (k<MaxStrNo)&&(k<G->lstr_no); k++)
		{
		if (lens==strlen(save[k].name))
		  {
		   if (strncmp(units, save[k].name, lens)==0)
		   G->str_N = k;
		   }
		}
	if (G->str_N>=0) {value_str = 1;
		G->str_L = strlen(save[G->str_N].str);
		}
	else {
		fprintf(stderr, "\nUndefined String [%s]", units);
		value_str = 0;
		}

        return(1);
      }

       /* Set column number */
    if (strncmp(&s[1], "CN",2) == 0)
        {
		if (tmplen>0) break_paragraph(G, sty);
		newpara1 = 1;
          sscanf(&s[3], "%d", &sty->cnumber);
	  for (j=1; j<sty->cnumber; j++)
	  	sty->cratio[j] = 1.;
	  columns = 1;
	  init_width(G, sty);
		if (last_bot > (int) curr_top) curr_top = last_bot;
	  new_col(G, sty);
          return(1);
        }

       /* get column width ratio */
    if (strncmp(&s[1], "CR",2) == 0)
        { 
		if (tmplen>0) out_buffer(sty);
          sscanf(&s[3], "%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
	  		&sty->cratio[1],
	  		&sty->cratio[2],
	  		&sty->cratio[3],
	  		&sty->cratio[4],
	  		&sty->cratio[5],
	  		&sty->cratio[6],
	  		&sty->cratio[7],
	  		&sty->cratio[8],
	  		&sty->cratio[9],
	  		&sty->cratio[10],
	  		&sty->cratio[11],
	  		&sty->cratio[12],
	  		&sty->cratio[13],
	  		&sty->cratio[14],
	  		&sty->cratio[15],
	  		&sty->cratio[16],
	  		&sty->cratio[17],
	  		&sty->cratio[18],
	  		&sty->cratio[19],
	  		&sty->cratio[20],
	  		&sty->cratio[21],
	  		&sty->cratio[22],
	  		&sty->cratio[23],
	  		&sty->cratio[24]
);

	  init_width(G, sty);
	  columns = 1;
	  new_col(G, sty);
          return(1);
        }


      /* Heading font name*/
    if (strncmp(&s[1], "NN",2) == 0)
        {
	  units[0] = '\0';
	  bb = i = 3;
	     while(s[i++]==32) bb++; /* get rid of space */
	     sscanf(&s[bb], "%s", units);

     	for (i=0; i<strlen(units); i++)
       	if ((units[i] > 96) && (units[i] <126)) units[i] -= 32;
       
	if (strncmp(units, "RT", 2)==0)
		note_font = ff.rm;
	else if (strncmp(units, "BF", 2)==0)
		note_font = ff.bf;
	else if (strncmp(units, "IT", 2)==0)
		note_font = ff.it;
	else if (strncmp(units, "PH", 2)==0)
		note_font = ff.ph;
	else if (strncmp(units, "SB", 2)==0)
		note_font = ff.sb;
          return(1);
        }

     
      /* Heading left*/
    if ((strncmp(&s[1], "HE",2) == 0)||(strncmp(&s[1], "LH",2) == 0))
        { G->heading1[0] = '\0';
	  strcpy(G->heading1, &s[3]);
          return(1);
        }

       /* Heading line center */
    if ((strncmp(&s[1], "H2",2) == 0)||(strncmp(&s[1], "CH",2) == 0))
        { G->heading2[0] = 0;
	 strcpy(G->heading2, &s[3]);
          return(1);
        }

       /* Heading line right */
    if ((strncmp(&s[1], "H3",2) == 0)||(strncmp(&s[1], "RH",2) == 0))
        { G->heading3[0] = 0;
	  strcpy(G->heading3, &s[3]);
          return(1);
        }

       /* footing left*/
    if ((strncmp(&s[1], "FO",2) == 0)||(strncmp(&s[1], "LF",2) == 0))
        { G->footing1[0] = 0;
          strcpy(G->footing1, &s[3]);
          return(1);
        }

       /* Footing line center */
    if ((strncmp(&s[1], "F2",2) == 0)||(strncmp(&s[1], "CF",2) == 0))
        {  G->footing2[0] = 0;
	   strcpy(G->footing2, &s[3]);
          return(1);
        }

       /* Footing line right*/
    if ((strncmp(&s[1], "F3",2) == 0)||(strncmp(&s[1], "RF",2) == 0))
        {  G->footing3[0] = 0;
	   strcpy(G->footing3, &s[3]);
          return(1);
        }

       /* Including a manuscript file*/
    if (strncmp(&s[1], "IF",2) == 0)
        {  units[0] = '\0';
		sscanf(&s[3], "%s", units);
		if ((input_F=fopen(units, "r"))==NULL)
			fprintf(stderr, "\nCan't find input file>%s\n",&s[3]);
		else {
			input_file = 1;
			fprintf(stderr, "\n[Subfile >%s ",units);
		     }
          return(1);
        }

       /* Including a PostScript file*/
    if (strncmp(&s[1], "SF",2) == 0)
        { units[0] = '\0';
		if (tmplen>0) out_buffer(sty);
		sscanf(&s[3], "%s", units);
		if ((input_F=fopen(units, "r"))==NULL)
			fprintf(stderr, "\nCan't find PostScript file>%s\n",&s[3]);
		else {
			input_ps = 1;
			fprintf(stderr, "[Including PostScript file >%s] ",units);
			include_ps();
		     }
          return(1);
        }

	/* set RGB color */
    if ((strncmp(&s[1], "CL",2) == 0)||(strncmp(&s[1], "RG",2) == 0))
   {
/* RGB colors available 
0.    Black = "0 0 0",
0.    Dark = "0 0 0",
1.    Gray " .5 .5 .5",
2.    Red="1 0 0",
3.    Blue="0 0 1",
4.    Magenta = "1 0 1",
5.    Green = "0 1 0",
6.    White = "1 1 1",
7.    Cyan = "0 1 1",
8.    Yellow = "1 1 0"
*/
		j=3;
		while (j < strlen(&s[3]))
		{
		 if ((s[j] > 96) && (s[j] <126)) s[j] -= 32;
		j++;
		}
		j=3;

			while(s[j]==32) j++;

			if ((strncmp(&s[j], "BLA", 3)==0)
			  ||(strncmp(&s[j], "DAR", 3)==0))
			{
				sty->color[0]
				=sty->color[1]
				=sty->color[2]=0.;
				sty->color3 = 0;

			}
			else if (strncmp(&s[j], "GRA", 3)==0)
			{
				sty->color[0]
				=sty->color[1]
				=sty->color[2] = 0.5;
				sty->color3 = 1;

			}
			else if (strncmp(&s[j], "RED", 3)==0)
			{
				sty->color[0] = 1.;
				sty->color[1]
				=sty->color[2] = 0.;
				sty->color3 = 2;
			}
			else if (strncmp(&s[j], "BLU", 3)==0)
			{
				sty->color[0] =
				sty->color[1] = 0.;
				sty->color[2] = 1.;
				sty->color3 = 3;

			}
			else if (strncmp(&s[j], "MAG", 3)==0)
			{
				sty->color[0] =
				sty->color[2] = 1.;
				sty->color[1] = 0.;
				sty->color3 = 4;

			}
			else if (strncmp(&s[j], "GRE", 3)==0)
			{
				sty->color[0] =
				sty->color[2] = 0.;
				sty->color[1] = 1.;
				sty->color3 = 5;

			}
			else if (strncmp(&s[j], "WHI", 3)==0)
			{
				sty->color[0] =
				sty->color[2] = 
				sty->color[1] = 1.;
				sty->color3 = 6;

			}
			else if (strncmp(&s[j], "CYA", 3)==0)
			{
				sty->color[0] = 0.;
				sty->color[2] = 
				sty->color[1] = 1.;
				sty->color3 = 7;

			}
			else if (strncmp(&s[j], "YEL", 3)==0)
			{
				sty->color[0] =
				sty->color[1] = 1.;
				sty->color[2] = 0.;
				sty->color3 = 8;
			}
			else 
			{
			fprintf(stderr, "Undefined RGB color %s", &s[j]); 
			return (0);
			}
	  fcolor(sty);
          return(1);

   }
       /* page number location: left, center, right, top, bottom*/
    if (strncmp(&s[1], "PP",2) == 0)
        {
		j=3;
		sum = 1;
		while (j < strlen(&s[3]))
		{
		 if (s[j]==32) sum++;
		 if ((s[j] > 96) && (s[j] <126)) s[j] -= 32;
		j++;
		}
		j=3;
		if (sum>2) sum = 2;
		while(sum>0)
		{
			while(s[j]==32) j++;

			if (strncmp(&s[j], "LEF", 3)==0)
			{
				G->num_loc = 0;
			}
			else if (strncmp(&s[j], "CEN", 3)==0)
			{
				G->num_loc = 1;
			}
			else if (strncmp(&s[j], "RIG", 3)==0)
			{
				G->num_loc = 2;
			}
			else if (strncmp(&s[j], "TOP", 3)==0)
			{
				G->num_lev = 0;
			}
			else if (strncmp(&s[j], "BOT", 3)==0)
			{
				G->num_loc = 1;
			}
			else {}

			j += 3;
			sum --;
			if (sum>0)
			while((s[j]!=32) && (s[j]!=0)) j++;

		}
          return(1);
        }

	/* PostScript commands */
     if (strncmp(&s[1], "PC",2) == 0)
     {
	if (tmplen) out_buffer(sty);
	fprintf(outfile, "%s", &s[3]);
	return(1);

     }

/************ begin reading style parameters */


       /*vertical blank space */
    if (strncmp(&s[1], "VS",2) == 0) {comm_no =1; tmpfloat = 0.;}

       /* horizontal blankspace */
    if (strncmp(&s[1], "HS",2) == 0)  {comm_no =2; tmpfloat = 0.;}

       /* Define local Paragraph margin, or indent */
    if (strncmp(&s[1], "PM",2) == 0)  {
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
	comm_no =3; tmpfloat = sty->left;}

       /* Define indent */
    if (strncmp(&s[1], "IN",2) == 0)  {
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
	comm_no =4; tmpfloat = G->parindent; }

       /* Define leftmargin */
    if (strncmp(&s[1], "LM",2) == 0) {
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
	comm_no =5; tmpfloat = G->leftmargin;}

       /* Define rightmargin */
    if (strncmp(&s[1], "RM",2) == 0) {
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
	comm_no =6; tmpfloat= G->rightmargin;}
       
       /* Line spacing */
    if (strncmp(&s[1], "LS",2) == 0)  {
		if (tmplen) break_paragraph(G, sty);
		newpara1 = 1;
		comm_no =7; tmpfloat = sty->stretch; }
 
       /* Set page number */
    if (strncmp(&s[1], "PN",2) == 0)  {comm_no =8;
		tmpfloat = G->pagenum;}

       /* get column margin */
    if (strncmp(&s[1], "CM",2) == 0)  {comm_no =9; tmpfloat = sty->cmargin;}

       /* Print page number size #*/
    if (strncmp(&s[1], "NS",2) == 0) { comm_no =10; tmpfloat=G->notesize;}

       /* Page offset */
    if (strncmp(&s[1], "PO",2) == 0) {
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
	comm_no =11; tmpfloat=G->offset;}

       /* Head margin*/
    if (strncmp(&s[1], "HM",2) == 0)  {comm_no =12; tmpfloat = G->headsep;}

       /* Foot margin, number of lines between text and foot */
    if (strncmp(&s[1], "FM",2) == 0)  {comm_no =13; tmpfloat = G->footskip;}

       /* Page length*/
    if (strncmp(&s[1], "PL",2) == 0) {
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
	comm_no =14; tmpfloat = G->paperlength;}

       /* Top margin */
    if ((strncmp(&s[1], "TM",2) == 0)||(strncmp(&s[1], "MT",2) == 0))
    	{comm_no =15; tmpfloat = G->topmargin;}

       /* Bottom margin*/
	if ((strncmp(&s[1], "BM",2) == 0)||(strncmp(&s[1], "MB",2) == 0))
		{ comm_no =16; tmpfloat=G->botmargin;}
       /* base line skip */
    if (strncmp(&s[1], "BS",2) == 0) {
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
	comm_no =17; tmpfloat=sty->skip;}

       /* Font size */
    if (strncmp(&s[1], "FS",2) == 0)  {comm_no =18; tmpfloat = sty->fscale;}

       /* Superscript push of 1st level */
    if ((strncmp(&s[1], "UP",2) == 0)||(strncmp(&s[1], "U1",2) == 0))
     {comm_no =19; tmpfloat = G->raise1;}

       /* Superscript push of 2nd level */
    if (strncmp(&s[1], "U2",2) == 0) { comm_no =20; tmpfloat = G->raise2;}

       /* Subscript lower of 1st level */
    if ((strncmp(&s[1], "DN",2) == 0)||(strncmp(&s[1], "D1",2) == 0))
    {comm_no=20; tmpfloat = G->lower1;}

       /* Subscript lower of 2nd level */
    if (strncmp(&s[1], "D2",2) == 0)
    {comm_no=21; tmpfloat = G->lower2;}

       /* Script size of 1st level */
    if ((strncmp(&s[1], "SS",2) == 0)||(strncmp(&s[1], "S1",2) == 0))
    	{comm_no = 23; tmpfloat = G->scriptsize1;}

       /* Script size of 2st level */
    if (strncmp(&s[1], "S2",2) == 0)
    	{comm_no = 24; tmpfloat = G->scriptsize2;}


       /* Conditional Pagebreak */
    if ((strncmp(&s[1], "CP",2) == 0)||(strncmp(&s[1], "ND",2) == 0))
    	{comm_no=25;}

       /* Local rightmargin, right indent */
    if (strncmp(&s[1], "RI",2) == 0)
    	{
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
		comm_no=26; tmpfloat = sty->right;}

       /* paragraph spread */
    if (strncmp(&s[1], "PS",2) == 0)
    	{
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
		comm_no=27; tmpfloat = sty->parskip;}

       /* underline weight */
    if (strncmp(&s[1], "UW",2) == 0)
    	{comm_no=28; tmpfloat = G->ul_weight;}

       /* underline sink */
    if (strncmp(&s[1], "US",2) == 0)
    	{comm_no=29; tmpfloat = G->ul_lower;}

       /* font slant  */
    if (strncmp(&s[1], "SL",2) == 0)
    	{comm_no=30; tmpfloat = sty->sl;}

       /* Paper width*/
    if (strncmp(&s[1], "PW",2) == 0) {
	if (tmplen) break_paragraph(G, sty);
	newpara1 = 1;
	comm_no =31; tmpfloat = G->paperwidth;}

       /* font character stretch */
    if (strncmp(&s[1], "CS",2) == 0)
    	{comm_no=32; tmpfloat = sty->sth;}

       /* set outline font stroke width*/
    if (strncmp(&s[1], "OW",2) == 0)
    	{comm_no=33; tmpfloat = sty->olwidth;}

	if (comm_no>0)
        { /* decode commands */
		units[0] = '\0';

           if ((s[3]=='+') || (s[3] == '-'))
             sscanf(&s[4], "%f%s", &tmpf, units);
            else
             sscanf(&s[3], "%f%s", &tmpf, units);

	/* now decode the units , use point as standard unit*/
	     bb = i = 0;
	     while(units[i++]==32) bb++; /* get rid of space */

     for (i=0; i<strlen(units); i++)
       if ((units[i] > 96) && (units[i] <126)) units[i] -= 32;

    if ((strncmp(&units[bb], "CH",2) == 0)||(bb>=strlen(units))
    ||(strlen(units)==0)) /* char */
    	{  /* use the character width of Courier font */
		switch(comm_no)
		{
		case 7:
		case 8:
		case 10:
		case 18:
		case 23:
		case 24:
		case 32:
		case 33:
			break;
		default: tmpf *= 600.*sty->fscale;
		}
	
	}
    else if (strncmp(&units[bb], "CM",2) == 0) /* centimeter */
    	{
	tmpf *= 28.35;
	}
    else if (strncmp(&units[bb], "MM",2) == 0) /* minimeter */
    	{
	tmpf *= 2.835;
	}
    else if (strncmp(&units[bb], "PC",2) == 0) /* pica */
    	{
	tmpf *= 12.;
	}
    else if (strncmp(&units[bb], "IN",2) == 0) /* inches */
    	{
	tmpf *= 72.;
	}
    else if (strncmp(&units[bb], "PT",2) == 0) /* points */
    	{/* that 's standard unit */
	
	}
    else if (strncmp(&units[bb], "BP",2) == 0) /* big points */
    	{/* that 's standard unit */
	}
    else if (strncmp(&units[bb], "DD",2) == 0) /* diot? */
    	{
	tmpf *= 1238./1157.;
	}
    else
    	{
		fprintf(stderr, "\nUnit [%s] is not supported, use:\n\
		pt, in, cm mm, bp, pc, or dd instead", units);
	}

           if ((s[3]=='+') || (s[3] == '-'))
             {
               switch(s[3])
                {
                 case '+': tmpf = tmpfloat + tmpf; break;
                 case '-': tmpf = tmpfloat - tmpf;
                }
	     }
	     

      switch(comm_no)
	{
    	case 1: /* skip vertical space*/
		if (r_y>0) r_y += tmpf*100.;
		the_y += tmpf*100.; 
		if (newline) this_y = the_y;
		break;
    	case 2:  /* skip horizontal space */
		if (r_x>0) r_x += tmpf*100.;
		the_x += tmpf*100.;
		if (newline) this_x = the_x;
		break;
	case 3: sty->left = tmpf; /* define local leftmargin*/
		renew_inleft(sty);
		break;
	case 4: G->parindent = tmpf;
		sty->indent = tmpf; /* define paragraph indent */
		renew_inleft(sty);
 		break;
	case 5: G->leftmargin = tmpf; /* define global left margin */
		sty->cwidth[0] = G->leftmargin+G->offset;	
		G->textwidth = G->paperwidth - G->leftmargin - G->rightmargin -
			    G->offset;
		curr_left = (sty->cwidth[0]+sty->left)*100.0;
		init_width(G, sty);
		the_x = curr_left; break;
	case 6: G->rightmargin = tmpf; /* define global right margin */
		G->textwidth = G->paperwidth - G->leftmargin - G->rightmargin -
			    G->offset;
	        init_width(G, sty);
			break;
	case 7: sty->stretch = tmpf;  /* define line spacing */
		if (sty->stretch==0) sty->stretch = 1;
		break;
	case 8: G->pagenum = tmpf; break; /* define page number */
	case 9: sty->cmargin = tmpf; /* define column margins */
		init_width(G, sty);
		break;
	case 10: G->notesize = tmpf; break; /* page number size */
	case 11: G->offset = tmpf; /* page offset */
		G->textwidth = G->paperwidth - G->leftmargin - G->rightmargin -
			    G->offset;
	        init_width(G, sty);
			break;

	case 12: /* page heading separate */
		G->headsep = tmpf;
		curr_top = (G->topmargin+G->headsep)*100.0;
		break;
	case 13: /* page footing separate */
		G->footskip = tmpf;
		sty->maxY = (G->paperlength - G->botmargin - G->footskip)*100.0;
		break;
	case 14: /* paper length */
		G->paperlength = tmpfloat;
		sty->maxY = (G->paperlength - G->botmargin - G->footskip)*100.0;
		break;
	case 15: /* G->topmargin */
		G->topmargin = tmpf;
		curr_top = (G->topmargin+G->headsep)*100.0;
		break;
	case 16: /* bottom margin */
		G->botmargin = tmpf;
		sty->maxY = (G->paperlength - G->botmargin - G->footskip)*100.0;
		break;
	case 17: /* line height*/
		sty->skip = tmpf;
		break;
	case 18: /* font scale */
		sty->fscale = tmpf;
                        fsize(sty);
		break;
	case 19:  /* Superscript push of 1st level */
		G->raise1 = tmpf;
		break;
	case 20:/* Superscript push of 2nd level */
		G->raise2 = tmpf;
		break;
	case 21:/* Subscript lower of 1st level */
		G->lower1= tmpf;
		break;
	case 22:  /* Subscript lower of 2nd level */
		G->lower2 = tmpf;
		break;
	case 23: /* Script size of 1st level */
		G->scriptsize1 = tmpf;
		break;
	case 24: /* Script size of 2nd level */
		G->scriptsize2 = tmpf;
		break;
	case 25: /* conditional page break */
		height_needed = tmpf*100.0;
         if (height_needed >= (G->paperlength-G->footskip-G->botmargin)*100.0 - the_y )
             {
		newline = 1;
		show_str = 0;
		r_x = 0.;
		add_x = 0.;
		newpage = 1;
		columns ++;
		the_y = curr_top;
		if (tmplen>0) break_paragraph(G, sty);
		break_page(G, sty);
             }
	     	break;

	case 26: /* local right margin, right indent */
		sty->right = tmpf;
		sty->maxX = (curr_left+sty->cwidth[columns]
			 		-sty->right-sty->left)*100.0;
		break;

	case 27: /* paragraph spread */
		sty->parskip = tmpf;
		break;
	case 28: /* underline weight*/
		G->ul_weight = tmpf*100.;
		break;
	case 29: /* underline weight*/
		G->ul_lower = tmpf*100.;
		break;
	case 30: /* font slant*/
		sty->sl = tmpf;
		break;
	case 31: G->paperwidth = tmpf; /* define G->paperwidth */
		G->textwidth = G->paperwidth - G->leftmargin - G->rightmargin -
			    G->offset;
		init_width(G, sty);
		break;
	case 32: /* font character stretch*/
		sty->sth = tmpf;
		if (sty->sth==0.0) sty->sth = 1.;
		fstretch(sty);
		break;
	case 33: /* outline font stroke width */
		sty->olwidth = tmpf;
		if (sty->olwidth==0.0) sty->olwidth = 0.5;
		break;

	}
    return(1);
    }

    s[strlen(s)-1] = 0;
    fprintf(stderr, "Command %s is not implemented\n", s);

}
