---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              composition des mathématiques, intégrale
---

# Comment obtenir une intégrale double ou triple ?

## Avec l'extension <ctanpkg:mathtools>

Les signes de l'intégrale double, triple et quadruple s'obtiennent 
respectivement avec les commandes `\iint`, `\iiint` et `\iiiint` que
fournit l'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
Supposons que pour tout $ x \in [a,b] $, la fonction $ y\mapsto f(x,y) $ 
est intégrable sur $ [c,d] $. Alors :
\[  
  \iint_{[a,b]\times [c,d]} f(x,y) \,\textrm{d}x\textrm{d}y = 
  \int _{a}^{b} \left( \int_{c}^{d} f(x,y) \,\textrm{d}y \right) 
  \,\textrm{d}x.
\]
\end{document}
```


## Avec l'extension <ctanpkg:wasysym>

L'extension <ctanpkg:wasysym> propose également des commandes 
`\int`, `\iint` et `\iiint` mais avec des formes légèrement différentes. 
Pour éviter des incomptabilités avec l'extension <ctanpkg:mathtools>, 
l'extension <ctanpkg:wasysym> propose deux options :
- `integrals` fait primer les intégrales définies par <ctanpkg:wasysym>
  sur celles de <ctanpkg:mathtools>.
- `nointegrals`fait l'inverse (plus précisément, elle ne charge pas 
  définitions des intégrales de <ctanpkg:wasysym> mais charge bien 
  les autres symboles fournis par l'extension).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[integrals]{wasysym}

\begin{document}
Supposons que pour tout $ x \in [a,b] $, la fonction $ y\mapsto f(x,y) $ 
est intégrable sur $ [c,d] $. Alors :
\[  
  \iint_{[a,b]\times [c,d]} f(x,y) \,\textrm{d}x\textrm{d}y = 
  \int _{a}^{b} \left( \int_{c}^{d} f(x,y) \,\textrm{d}y \right) 
  \,\textrm{d}x.
\]
\end{document}
```


:::{sources}
- [Intégrale triple](https://www.mathematex.fr/viewtopic.php?t=13312), 
  sur [MathemaTeX](https://www.mathematex.fr/)
:::