#!/bin/sh
#
# This is uwpatch.sh,
# written by Werner Lemberg <wl@gnu.org>, 20-Apr-1998
#
# This script adds country-specific mapping tables (SJIS, KS 5601-92, GB
# 2312-80, and Big 5) in various uw* fonts for use with the new ttf2pk
# program of the FreeType package which is available from
#
#   ftp://ftp.physiol.med.tu-muenchen.de/pub/freetype/devel/
#
# The program ttf_edit is freely available from Richard Kinch.  Please send
# an email to kinch@holonet.net, asking for the program.  Don't forget to
# specify your platform.
#
# The uw* fonts can be found in
#
#   ftp://ftp.ifcss.org/pub/software/fonts
#
# Here are the entries for ttfonts.map -- it is assumed that ttf2pk has been
# already configured to both find the .sfd and .ttf files.
#
#   uwjmg3@sjis@    nuwjmg3     Pid = 3     Eid = 2
#   uwpstj@euc@     nuwpstj     Pid = 3     Eid = 3
#   uwcxmf@big5@    nuwcxmf     Pid = 3     Eid = 4
#   uwkmjf@euc@     nuwkmjf     Pid = 3     Eid = 5

ttf_edit force uwjmg3.ttf font uwjmg3.afm 3 2 encode nuwjmg3.ttf gen
ttf_edit force uwpstj.ttf font uwpstj.afm 3 3 encode nuwpstj.ttf gen
ttf_edit force uwcxmf.ttf font uwcxmf.afm 3 4 encode nuwcxmf.ttf gen
ttf_edit force uwkmjf.ttf font uwkmjf.afm 3 5 encode nuwkmjf.ttf gen
