#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include "dvi.h"
#include "dvidef.h"

const int max_drift = 2;

#define pixel_hround(x) round( (double)(x)*hconv )
#define pixel_vround(x) round( (double)(x)*vconv )

static int rule_hpixels(double x, double hconv)
{
    double a = x * hconv;
    int r = itrunc(a);

    if (r<a) r++;
    return r;
}

static int rule_vpixels(double x, double vconv)
{
    double a = x * vconv;
    int r = itrunc(a);

    if (r<a) r++;
    return r;
}

static int geq(long *h, long *l)
{
    int i;
    for (i=0; i<10; i++,h++,l++)
    {
	if (*h==ASTERISK || *l==ASTERISK) continue;
	if (*h<*l) return 0;
    }
    return 1;
}

int do_page(pos *ip, fnt_t **fl, double hconv, double vconv, 
    int virtual,  long *lower, long *upper)
{
    pos         p;
    int         ende = 0;
    register int i, ch;

    static long curr_space = 0;
    static long vvv, hhh, a, b, cc, s, d, k, l, width, height;
    static int  char_missing;
    static fnt_t *f = NULL;
    static long ll[10];
    static char fname[MAX_PATH_LEN];

    if (ip!=NULL) p = *ip;
    else p.h = p.v = p.w = p.x = p.y = p.z = p.hh = p.vv = 0;

    if (virtual) 
    {
	f = *fl;
	p.w = p.x = p.y = p.z = 0;
	f->locked = 1;
	do_font(f);
    }

    while(!ende)
    {
	fmt_stop();
	switch(ch=dvi_fgetc())
	{
	    case   0: case   1: case   2: case   3: case   4:
	    case   5: case   6: case   7: case   8: case   9:
	    case  10: case  11: case  12: case  13: case  14:
	    case  15: case  16: case  17: case  18: case  19:
	    case  20: case  21: case  22: case  23: case  24:
	    case  25: case  26: case  27: case  28: case  29:
	    case  30: case  31: case  32: case  33: case  34:
	    case  35: case  36: case  37: case  38: case  39:
	    case  40: case  41: case  42: case  43: case  44:
	    case  45: case  46: case  47: case  48: case  49:
	    case  50: case  51: case  52: case  53: case  54:
	    case  55: case  56: case  57: case  58: case  59:
	    case  60: case  61: case  62: case  63: case  64:
	    case  65: case  66: case  67: case  68: case  69:
	    case  70: case  71: case  72: case  73: case  74:
	    case  75: case  76: case  77: case  78: case  79:
	    case  80: case  81: case  82: case  83: case  84:
	    case  85: case  86: case  87: case  88: case  89:
	    case  90: case  91: case  92: case  93: case  94:
	    case  95: case  96: case  97: case  98: case  99:
	    case 100: case 101: case 102: case 103: case 104:
	    case 105: case 106: case 107: case 108: case 109:
	    case 110: case 111: case 112: case 113: case 114:
	    case 115: case 116: case 117: case 118: case 119:
	    case 120: case 121: case 122: case 123: case 124:
	    case 125: case 126: case 127:

		cc = ch; goto set_char;

	    case SET1: cc = dvi_fgetc(); goto set_char; 
	    case SET2: cc = dvi_fu2(); goto set_char;
	    case SET3: cc = dvi_fu3(); goto set_char;
	    case SET4: cc = dvi_fu4(); goto set_char;

	    case PUT1: cc = dvi_fgetc(); goto set_char; 
	    case PUT2: cc = dvi_fu2(); goto set_char;
	    case PUT3: cc = dvi_fu3(); goto set_char;
	    case PUT4: cc = dvi_fu4();

	    set_char:
		if (f==NULL) 
		{
		    if (op.tracechars)
			print("Warning: No font for char %ld selected",cc);
		    char_missing = 1;
		    break;
		}

		if (f->typ==f_pk)
		{
		    register pk_char *c = NULL;

		    if( f->f.pk.hash )
		    /*
		     * Warum auch immer da was schiefgehen kann ... manchmal
		     * ist wohl die Fontliste defekt :-(
		     */
		        for (c=f->f.pk.hash[(int)cc%HASHSIZE]; c!=NULL; c=c->next)
			    if (cc==c->cc) break;

		    if (c==NULL)
		    {
			if (op.tracechars)
			    print("Warning: No char %ld in PK-Font %s",cc,f->filename);
			char_missing = 1;
			end_string();
			break;
		    }

		    do_pkchar(c,&p);

		    if (ch<=SET4)
		    {
			p.hh += (c->dx)>>16;
			a = c->tfm;
			goto move_right;
		    }
		    else end_string();
		}
		else if (f->typ==f_vf)
		{
		    register vf_char *c;
		    fnt_t *save;
		    double new_hconv, new_vconv;

		    new_hconv = op.hres*(double)f->s/65536.0/72.27/1048576.0;
		    new_vconv = op.vres*(double)f->s/65536.0/72.27/1048576.0;

		    for (c=f->f.vf.hash[(int)cc%HASHSIZE]; c!=NULL; c=c->next)
			if (cc==c->cc) break;

		    if (c==NULL)
		    {
			if (op.tracechars)
			    print("Warning: No char %ld in VF-Font %s",cc,f->filename);
			char_missing = 1;
			end_string();
			break;
		    }

		    save = f;
		    dvi_fpush((FILE*)NULL,c->data,c->data+(size_t)c->pl);

		    ende = do_page(&p,&f->f.vf.fl,new_hconv,new_vconv,1,NULL,NULL);

		    dvi_fpop();
		    f = save;
		    do_font(f);

		    if (ch<=SET4)
		    {
			/*
			print("Moving %ld==%ld pixels after character %ld",
			    (long)c->tfm,(long)pixel_hround(c->tfm),(long)cc);
			*/
			p.h += c->tfm;
			p.hh = pixel_hround(p.h);
		    }
		    end_string();
		}
		else if (f->typ==f_ps)
		{
		    do_resident_char(cc, &p);
		}
		else 
		{
		    if (op.tracechars)
			print("Warning: Char %ld used from unknown font %s",cc,f->n);
		    char_missing=1;
		}

		if (f->typ==f_ps || f->typ==f_tfm)
		{
		    if ((f->typ==f_ps || f->typ==f_tfm) && ch<=SET4)
		    {
			unsigned wi;
			int c = (int)cc;
			tfm_file *t = f->f.tfm.tfm;
			if (t!=NULL)
			{
			    if ( c<t->lengths->bc || c>t->lengths->ec) wi = 0;
			    else wi = t->finfo[c - t->lengths->bc].width_index;
			    a = t->width[wi].l;
			    p.hh = pixel_hround(p.h+a);
			    goto move_right;
			}
		    }
		}

		break;


	    case BOP:
		for (i=0; i<10; i++) ll[i] = dvi_fs4();
		(void)dvi_fu4();
		p.h = p.v = p.w = p.x = p.y = p.z = p.hh = p.vv = 0;
		if (lower!=NULL && !geq(ll,lower)) return -1;
		if (upper!=NULL && geq(upper,ll)) return -1;
		do_bop(ll);
		char_missing = 0;
		break;

	    case EOP:
		do_eop(char_missing);
		ende = 1;
		break;

	    case RIGHT1: a = (signed char)dvi_fgetc(); goto out_space;
	    case RIGHT2: a = dvi_fs2(); goto out_space;
	    case RIGHT3: a = dvi_fs3(); goto out_space;
	    case RIGHT4: a = dvi_fs4(); goto out_space;

	    case W0: a = p.w; goto out_space;
	    case W1: a = p.w = (signed char)dvi_fgetc(); goto out_space;
	    case W2: a = p.w = dvi_fs2(); goto out_space;
	    case W3: a = p.w = dvi_fs3(); goto out_space;
	    case W4: a = p.w = dvi_fs4(); goto out_space;

	    case X0: a = p.x; goto out_space;
	    case X1: a = p.x = (signed char)dvi_fgetc(); goto out_space;
	    case X2: a = p.x = dvi_fs2(); goto out_space;
	    case X3: a = p.x = dvi_fs3(); goto out_space;
	    case X4: a = p.x = dvi_fs4();

	    out_space:
		end_string();
		if ( a>=curr_space || a<=-4*curr_space )
		    p.hh = pixel_hround(p.h+a);
		else
		    p.hh += pixel_hround(a);

	    move_right:
		hhh = pixel_hround(p.h+a);
		if (hhh-p.hh>max_drift) p.hh = hhh-max_drift;
		else if (p.hh-hhh>max_drift) p.hh = hhh+max_drift;
		p.h += a;
		break;

	    case DOWN1: a = (signed char)dvi_fgetc(); goto out_vmove;
	    case DOWN2: a = dvi_fs2(); goto out_vmove;
	    case DOWN3: a = dvi_fs3();; goto out_vmove;
	    case DOWN4: a = dvi_fs4();; goto out_vmove;

	    case Y0: a = p.y; goto out_vmove;
	    case Y1: a = p.y = (signed char)dvi_fgetc(); goto out_vmove;
	    case Y2: a = p.y = dvi_fs2(); goto out_vmove; 
	    case Y3: a = p.y = dvi_fs3(); goto out_vmove;
	    case Y4: a = p.y = dvi_fs4(); goto out_vmove;

	    case Z0: a = p.z; goto out_vmove;
	    case Z1: a = p.z = (signed char)dvi_fgetc(); goto out_vmove;
	    case Z2: a = p.z = dvi_fs2(); goto out_vmove; 
	    case Z3: a = p.z = dvi_fs3(); goto out_vmove;
	    case Z4: a = p.z = dvi_fs4();

	    out_vmove:
		end_string();
		if ( a>=5*curr_space || a<=-5*curr_space )
		    p.vv = pixel_vround(p.v+a);
		else
		    p.vv += pixel_vround(a);

		vvv = pixel_vround(p.v+a);
		if (vvv-p.vv>max_drift) p.vv = vvv-max_drift;
		else if (p.vv-vvv>max_drift) p.vv = vvv+max_drift;
		p.v += a;
		break;

	    case PUT_RULE:
	    case SET_RULE:
		end_string();
		b = dvi_fs4();
		a = dvi_fs4();
		width = rule_hpixels((double)a,hconv);
		height = rule_vpixels((double)b,vconv);
		if (a>0 && b>0) do_rule(&p,width,height);
		if (ch==SET_RULE)
		{
		    p.hh += width;
		    goto move_right;
		}
		break;

	    case FNT_DEF1:  k = dvi_fgetc(); goto font_def;
	    case FNT_DEF1+1: k = dvi_fs2(); goto font_def;
	    case FNT_DEF1+2: k = dvi_fs3(); goto font_def;
	    case FNT_DEF1+3: k = dvi_fs4();

	    font_def:
		end_string();
		cc = dvi_fu4();
		s = dvi_fu4();
		d = dvi_fu4();
		a = dvi_fgetc();
		l = dvi_fgetc();
		if (a+l>=MAX_PATH_LEN) halt("Font name too long");
		for (i=0; i<a+l; i++) fname[i] = dvi_fgetc();
		fname[(int)(a+l)] = '\0';
		fnt_define(fl,k,cc,s,d,fname);
		break;

	    case FNT_NUM_0+ 0: case FNT_NUM_0+ 1: case FNT_NUM_0+ 2: case FNT_NUM_0+ 3: 
	    case FNT_NUM_0+ 4: case FNT_NUM_0+ 5: case FNT_NUM_0+ 6: case FNT_NUM_0+ 7: 
	    case FNT_NUM_0+ 8: case FNT_NUM_0+ 9: case FNT_NUM_0+10: case FNT_NUM_0+11: 
	    case FNT_NUM_0+12: case FNT_NUM_0+13: case FNT_NUM_0+14: case FNT_NUM_0+15: 
	    case FNT_NUM_0+16: case FNT_NUM_0+17: case FNT_NUM_0+18: case FNT_NUM_0+19: 
	    case FNT_NUM_0+20: case FNT_NUM_0+21: case FNT_NUM_0+22: case FNT_NUM_0+23: 
	    case FNT_NUM_0+24: case FNT_NUM_0+25: case FNT_NUM_0+26: case FNT_NUM_0+27:
	    case FNT_NUM_0+28: case FNT_NUM_0+29: case FNT_NUM_0+30: case FNT_NUM_0+31: 
	    case FNT_NUM_0+32: case FNT_NUM_0+33: case FNT_NUM_0+34: case FNT_NUM_0+35: 
	    case FNT_NUM_0+36: case FNT_NUM_0+37: case FNT_NUM_0+38: case FNT_NUM_0+39: 
	    case FNT_NUM_0+40: case FNT_NUM_0+41: case FNT_NUM_0+42: case FNT_NUM_0+43: 
	    case FNT_NUM_0+44: case FNT_NUM_0+45: case FNT_NUM_0+46: case FNT_NUM_0+47: 
	    case FNT_NUM_0+48: case FNT_NUM_0+49: case FNT_NUM_0+50: case FNT_NUM_0+51: 
	    case FNT_NUM_0+52: case FNT_NUM_0+53: case FNT_NUM_0+54: case FNT_NUM_0+55: 
	    case FNT_NUM_0+56: case FNT_NUM_0+57: case FNT_NUM_0+58: case FNT_NUM_0+59: 
	    case FNT_NUM_0+60: case FNT_NUM_0+61: case FNT_NUM_0+62: case FNT_NUM_0+63: 

		k = ch-FNT_NUM_0; goto font;

	    case FNT1: k = dvi_fgetc(); goto font; 
	    case FNT2: k = dvi_fu2(); goto font;
	    case FNT3: k = dvi_fu3(); goto font;
	    case FNT4: k = dvi_fu4();

	    font:
		end_string();
		if (f!=NULL) f->locked = 0;
		for (f = *fl; f!=NULL; f=f->next) if (f->k==k) break;
		if (f==NULL)
		    print("DVI-File Error: Unknown font number %ld",k);
		else
		{
		    f->locked = 1;
		    do_font(f);
		    curr_space = f->space;
		}
		break;

	    case PUSH:
		end_string();
		ende = do_page(&p,fl,hconv,vconv,0,lower,upper);
		break;

	    case POP:
		end_string();
		return 0;

	    case NOP:
		break;

	    case PRE:
		halt("Illegal pre in DVI file");
		break;

	    case POST:
		end_string();
		(void)dvi_fu4(); (void)dvi_fu4(); (void)dvi_fu4();
		(void)dvi_fu4(); (void)dvi_fu4(); (void)dvi_fu4();
		(void)dvi_fu2(); (void)dvi_fu2();
		ende=1;
		break;

	    case POST_POST:
		(void)dvi_fu4();
		(void)dvi_fgetc();
		end_string();
		halt("Illegal post_post in DVI file");
		break;

	    case XXX1: k = dvi_fgetc(); goto xxx; 
	    case XXX2: k = dvi_fu2(); goto xxx;
	    case XXX3: k = dvi_fu3(); goto xxx;
	    case XXX4: k = dvi_fu4();

	    xxx:
		end_string();
		do_special(k,&p);
		break;

	    case EOF: 
		if (virtual && f!=NULL) f->locked = 0;
		return 0;

	    default:
		end_string();
		halt("DVI-File Error: Unknown dvi command %d",ch);
		break;
	}
    }
    return ende;
}
