/*
** Datei: DVIGR1.C
** Autor: Ingo Eichenseher
*/

#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "dvi.h"
#include "dvisplin.h"


static real temp1[MAX_VERTICES], temp2[MAX_VERTICES];

static void g_poly(const coord *p, int n, int closed, const interval_t *in, int ni)
{
    coord r[2];

    if (ni)
    {
	for (; ni--; in++)
	{
	    real t0 = in->t0, t1 = in->t1;

	    if ( t0 < 0 ) t0 = 0;
	    if ( t1 > (real)(n-1) ) t1 = (real)(n-1);
	    if ( t0 < t1 && n>1)
	    {
		int i0, i1;

		t0 -= (real)(i0 = itrunc(t0));
		t1 -= (real)(i1 = itrunc(t1));
		if (t1<0.0001) i1--, t1=1.0;

		r[0].x = t0*p[i0+1].x + (1.0-t0)*p[i0].x;
		r[0].y = t0*p[i0+1].y + (1.0-t0)*p[i0].y;
		r[1].x = t1*p[i1+1].x + (1.0-t1)*p[i1].x;
		r[1].y = t1*p[i1+1].y + (1.0-t1)*p[i1].y;
		g_dpoly(p+i0,r,i1-i0+2,0);
	    }
	}
    }
    else
    {
	r[0] = p[0];
	r[1] = p[n-1];
	g_dpoly(p,r,n,closed);
    }
}

static void g_cut1(real t, coord *p, coord *q, coord *r, const coord *s)
{
    p->x = t*p->x + (1-t)*q->x; p->y = t*p->y + (1-t)*q->y;
    q->x = t*q->x + (1-t)*r->x; q->y = t*q->y + (1-t)*r->y;
    r->x = t*r->x + (1-t)*s->x; r->y = t*r->y + (1-t)*s->y;
    p->x = t*p->x + (1-t)*q->x; p->y = t*p->y + (1-t)*q->y;
    q->x = t*q->x + (1-t)*r->x; q->y = t*q->y + (1-t)*r->y;
    p->x = t*p->x + (1-t)*q->x; p->y = t*p->y + (1-t)*q->y;
}

static void g_cut(const coord *p, const coord *q, const coord *rr, 
		  int n, const interval_t *in)
{
    coord r[6];
    real t0 = in->t0, t1 = in->t1;

    r[0] = rr[0]; r[1] = rr[1]; r[2] = rr[2];
    r[3] = rr[3]; r[4] = rr[4]; r[5] = rr[5];
    if ( t0 < 0 ) t0 = 0;
    if ( t1 > (real)(n+1) ) t1 = (real)(n+1);
    if ( t0 < t1 )
    {
	int i0, i1;

	t0 -= (real)(i0 = itrunc(t0));
	t1 -= (real)(i1 = itrunc(t1));
	if (t1<0.0001) i1--, t1=1.0;
	p += i0; q += i0; n -= i0; i1 -= i0;

	r[0] = p[0];
	if (n)
	{
	    r[1] = q[0];
	    r[2].x = 2*p[1].x-q[1].x;
	    r[2].y = 2*p[1].y-q[1].y;
	}
	r[3] = q[i1];
	if (i1<n) 
	{
	    r[4].x = 2*p[i1+1].x-q[i1+1].x;
	    r[4].y = 2*p[i1+1].y-q[i1+1].y;
	    r[5] = p[i1+1];
	}
	if (i1==0)
	{
	    g_cut1(1-t0,r,r+3,r+4,r+5);
	    g_cut1((t1-t0)/(1-t0),r+5,r+4,r+3,r);
	}
	else
	{
	    g_cut1(1-t0,r,r+1,r+2,p+1);
	    g_cut1(t1,r+5,r+4,r+3,p+i1);
	}
	g_draw(p,q,r,i1,0);
    }
}

static void g_spline(const coord *p, const coord *q, const coord *r, 
    int n, const interval_t *in, int ni, int closed)
{
    coord rr[6];
    rr[0] = p[0];
    if (n>0)
    {
	rr[1] = q[0];
	rr[2].x = 2*p[1].x-q[1].x; 
	rr[2].y = 2*p[1].y-q[1].y;
    }
    rr[3] = q[n];
    rr[4] = r[0];
    rr[5] = r[1];
    if (ni>0)
    {
	int i;
	for (i=0; i<ni; i++)
	    g_cut(p,q,rr,n,in+i);
    }
    else g_draw(p,q,rr,n,closed);
}

static void tridiag(real a0, real c0, real bn, real an, coord q[], int n)
{
    register int i;

    temp1[0] = c0/a0;
    q[0].x /= a0;
    q[0].y /= a0;
    for (i=1; i<n-1; i++)
    {
	register real alpha = 4.0 - temp1[i-1];
	q[i].x    = (q[i].x - q[i-1].x) / alpha;
	q[i].y    = (q[i].y - q[i-1].y) / alpha;
	temp1[i]  = 1.0 / alpha;
    }
    q[n-1].x = (q[n-1].x - bn*q[n-2].x) / (an-bn*temp1[n-2]);
    q[n-1].y = (q[n-1].y - bn*q[n-2].y) / (an-bn*temp1[n-2]);
    for (i=n-2; i>=0; i--)
    {
	q[i].x -= temp1[i]*q[i+1].x;
	q[i].y -= temp1[i]*q[i+1].y;
    }
}

/*
** Die folgende Funktion loest die Gleichungssysteme Au=x und Av=y
** fuer die folgende Matrix A = a[i][j] (i,j=0,...,n-1):
**
**  a[i,i] = 4                          fuer i=0,...,n-1
**  a[i,i-1] = a[i-1,i] = 1             fuer i=1,...,n-2
**  a[n-1,1] = a[n-1,n-2] = a[0,1] = a[0,n-1] = 1
**
** Die Loesung wird mit hilfe einer Cholesky-Zerlegung A=LL' der Matrix
** gewonnen. Es ist dabei nur noetig die Diagonalelemente und die
** letzte Zeile zu berechnen und zwischenzuspeichern. Die Elemente
** auf der Nebendiagonalen ergeben sich zu l[i][i-1] = l[i-1][i-1]
** fuer i=0,...,n-2.
** Die Loesungen u und v werden in den Feldern x und y zurueckgegeben.
** Bei einem System der Dimension n muessen die Werte x[0],...,x[n-1] und
** y[0],...,y[n-1] definiert sein.
*/

static void chol_141(coord q[], int n)
{
    register int i;

    temp1[0] = 2;
    q[0].x /= 2;
    q[0].y /= 2;
    temp2[0] = 0.5;
    q[n-1].x -= q[0].x/2;
    q[n-1].y -= q[0].y/2;
    temp1[n-1] = 3.75;
    for (i=1; i<n-1; i++)
    {
	temp1[i] = sqrt(4 - 1/(temp1[i-1]*temp1[i-1]));
	q[i].x = (q[i].x - q[i-1].x/temp1[i-1])/temp1[i];
	q[i].y = (q[i].y - q[i-1].y/temp1[i-1])/temp1[i];
    }
    for (i=1; i<n-2; i++)
    {
	temp2[i] = -temp2[i-1]/(temp1[i]*temp1[i-1]);
	temp1[n-1] -= temp2[i]*temp2[i];
	q[n-1].x -= q[i].x * temp2[i];
	q[n-1].y -= q[i].y * temp2[i];
    }
    temp2[n-2] = (1-temp2[n-3]/temp1[n-3])/temp1[n-2];
    temp1[n-1] = sqrt(temp1[n-1]-temp2[n-2]*temp2[n-2]);
    q[n-1].x = (q[n-1].x - temp2[n-2]*q[n-2].x)/(temp1[n-1]*temp1[n-1]);
    q[n-2].x = (q[n-2].x - temp2[n-2]*q[n-1].x)/temp1[n-2];
    q[n-1].y = (q[n-1].y - temp2[n-2]*q[n-2].y)/(temp1[n-1]*temp1[n-1]);
    q[n-2].y = (q[n-2].y - temp2[n-2]*q[n-1].y)/temp1[n-2];
    for (i=n-3; i>=0; i--)
    {
	q[i].x = (q[i].x - q[i+1].x/temp1[i] - q[n-1].x*temp2[i])/temp1[i];
	q[i].y = (q[i].y - q[i+1].y/temp1[i] - q[n-1].y*temp2[i])/temp1[i];
    }
}

void spline(const coord *p, int n, const interval_t *in, int ni, int type)
{
    static coord q[MAX_VERTICES];
    coord r[2];
    register int i;
    real a0, c0, bn, an;

    if (type==7)
    {
	for (i=0; i<n; i++)
	    g_dot(p+i);
	return;
    }

    if (n==2) g_poly(p,2,0,in,ni);
    else if (n>2) switch(type)
    {
	case 0 : /* geschlossener Spline */
	    if (n<3) break;
	    for (i=0; i<n-1; i++)
	    {
		q[i].x = 4*p[i].x+2*p[i+1].x;
		q[i].y = 4*p[i].y+2*p[i+1].y;
	    }
	    q[n-1].x = 4*p[n-1].x+2*p[0].x;
	    q[n-1].y = 4*p[n-1].y+2*p[0].y;
	    chol_141(q,n);

	    r[0].x = 2*p[0].x-q[0].x;
	    r[0].y = 2*p[0].y-q[0].y;
	    r[1] = p[0];
	    g_spline(p,q,r,n-1,in,ni,1);
	    break;

	case 1 : /* natuerlicher Spline */
	    if (n<3) break;
	    q[0].x = 2*p[1].x + p[0].x;
	    q[0].y = 2*p[1].y + p[0].y;
	    for (i=1; i<n-2; i++)
	    {
		q[i].x = 4*p[i].x + 2*p[i+1].x;
		q[i].y = 4*p[i].y + 2*p[i+1].y;
	    }
	    q[n-2].x = 8*p[n-2].x + p[n-1].x;
	    q[n-2].y = 8*p[n-2].y + p[n-1].y;
	    a0 = 2.0; c0 = 1.0;
	    an = 7.0; bn = 2.0;
	    tridiag(a0,c0,bn,an,q,n-1);

	    r[0].x = (q[n-2].x+p[n-1].x)/2;
	    r[0].y = (q[n-2].y+p[n-1].y)/2;
	    r[1] = p[n-1];
	    g_spline(p,q,r,n-2,in,ni,0);
	    break;

	case 2 : /* Kontrollpunkte der End-Kurven vorgegeben */
	    if (n<4) break;
	    r[0] = p[n-1];
	    r[1] = p[n-2];
	    q[0] = p[0];
	    if (n>4)
	    {
		for (i=1; i<n-4; i++)
		{
		    q[i].x = 4*p[i+1].x + 2*p[i+2].x;
		    q[i].y = 4*p[i+1].y + 2*p[i+2].y;
		}
		q[n-4].x = 4*p[n-3].x + p[n-1].x;
		q[n-4].y = 4*p[n-3].y + p[n-1].y;
		a0 = 1.0; c0 = 0.0;
		an = 4.0; bn = 1.0;
		tridiag(a0,c0,bn,an,q,n-3);
	    }
	    g_spline(p+1,q,r,n-4,in,ni,0);
	    break;

	case 3 : /* Erster Kontrollpunkt vorgegeben am Ende natuerlich */
	    if (n<3) return;

	    q[0] = p[0];
	    r[1] = p[n-1];
	    if (n>3)
	    {
		for (i=1; i<n-3; i++)
		{
		    q[i].x = 4*p[i+1].x + 2*p[i+2].x;
		    q[i].y = 4*p[i+1].y + 2*p[i+2].y;
		}
		q[n-3].x = 8*p[n-2].x + p[n-1].x;
		q[n-3].y = 8*p[n-2].y + p[n-1].y;
		a0 = 1.0; c0 = 0.0;
		an = 7.0; bn = 2.0;
		tridiag(a0,c0,bn,an,q,n-2);
	    }
	    r[0].x = (q[n-3].x+p[n-1].x)/2;
	    r[0].y = (q[n-3].y+p[n-1].y)/2;
	    g_spline(p+1,q,r,n-3,in,ni,0);
	    break;

	case 4 : /* Am Anfang natuerlich letzter Kontrollpunkt vorgegeben */
	    if (n<3) return;
	    r[0] = p[n-1];
	    r[1] = p[n-2];

	    if (n>3)
	    {           
		q[0].x = 2*p[1].x + p[0].x;
		q[0].y = 2*p[1].y + p[0].y;
		for (i=1; i<n-3; i++)
		{
		    q[i].x = 4*p[i].x + 2*p[i+1].x;
		    q[i].y = 4*p[i].y + 2*p[i+1].y;
		}
		q[n-3].x = 4*p[n-3].x + p[n-1].x;
		q[n-3].y = 4*p[n-3].y + p[n-1].y;
		a0 = 2.0; c0 = 1.0;
		an = 4.0; bn = 1.0;
		tridiag(a0,c0,bn,an,q,n-2);
	    }
	    else
	    {
		q[0].x = (p[0].x+p[2].x)/2;
		q[0].y = (p[0].y+p[2].y)/2;
	    }
	    g_spline(p,q,r,n-3,in,ni,0);
	    break;

	case 5 : /* Polygon */
	    g_poly(p,n,0,in,ni);
	    break;

	case 6 : /* geschlossenes Polygon */
	    g_poly(p,n,1,in,ni);
	    break;
    }
}

