/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     October 1999
 * Modified:  January 2002
 *
 */

#include  <gtk/gtk.h>

extern void close_window();   /* defined in file cleanup.c */

/* This file contains the error handling routines. */

/* The error types are:
 *    1     entries not saved
 *    2     last entry not saved
 *    3     all required fields not supplied
 *    4     requested function not implemented
 *    5     this reference has been saved already
 *    6     I am sorry, but you have already saved this entry
 *    7     cannot open that file
 *    8     currently there is no file selected
 *    9     format in the current BibTeX file selected */

void error(GtkWidget  *widget,
           GtkWidget  *type)
{
  GtkWidget  *window;
  GtkWidget  *button;
  GtkWidget  *label;
  char  bell = '\007';        /* ASCII code for a bell */

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile security");
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  button = gtk_button_new();
  gtk_widget_set_usize(GTK_WIDGET(button), 250, 100);
  g_signal_connect(GTK_OBJECT(button), "clicked",
                   G_CALLBACK(close_window), NULL);
  gtk_container_add(GTK_CONTAINER(window), button);
  switch (GPOINTER_TO_INT(type)) {
  case 1:  label = gtk_label_new("Entries not saved");
           break;
  case 2:  label = gtk_label_new("Last entry not saved");
           break;
  case 3:  label = gtk_label_new("All required fields not supplied");
           break;
  case 4:  label = gtk_label_new("Requested function not implemented");
           break;
  case 5:  label = gtk_label_new("This reference has been saved already");
           break;
  case 6:  label = gtk_label_new("I am sorry,\n but you have already saved this entry");
           break;
  case 7:  label = gtk_label_new("Cannot open that file for appending");
           break;
  case 8:  label = gtk_label_new("Currently there is no file selected");
           break;
  case 9:  label = gtk_label_new("Error detected in BibTeX file\n while processing it");
           break;
  default: label = gtk_label_new("Impossible error (ERROR)");
  }
  gtk_container_add(GTK_CONTAINER(button), label);

                           /* put the window on the screen */
  gtk_widget_show_all(window);
  g_print("%c", bell);
}




