/* conf.h (GENERATED FILE; DO NOT EDIT) */

#define	NULLPTR	(char *)0

/* Device table declarations */
struct	devsw	{			/* device table entry */
	int	dvnum;
	char	*dvname;
	int	(*dvinit)();
	int	(*dvopen)();
	int	(*dvclose)();
	int	(*dvread)();
	int	(*dvwrite)();
	int	(*dvseek)();
	int	(*dvgetc)();
	int	(*dvputc)();
	int	(*dvcntl)();
	int	dvcsr;
	int	dvivec;
	int	dvovec;
	int	(*dviint)();
	int	(*dvoint)();
	char	*dvioblk;
	int	dvminor;
	};

extern	struct	devsw devtab[];		/* one entry per device */


/* Device name definitions */

#define	CONSOLE     0			/* type tty      */
#define	ETHER       1			/* type eth      */
#define	OTHER1      2			/* type oth      */
#define	OTHER2      3			/* type oth      */
#define	UDP         4			/* type dgm      */
#define	DGRAM0      5			/* type dg       */
#define	DGRAM1      6			/* type dg       */
#define	DGRAM2      7			/* type dg       */
#define	DGRAM3      8			/* type dg       */
#define	DGRAM4      9			/* type dg       */
#define	DGRAM5      10			/* type dg       */
#define	DGRAM6      11			/* type dg       */
#define	DGRAM7      12			/* type dg       */
#define	DGRAM8      13			/* type dg       */
#define	DGRAM9      14			/* type dg       */
#define	DGRAMA      15			/* type dg       */
#define	DGRAMB      16			/* type dg       */
#define	DGRAMC      17			/* type dg       */
#define	DGRAMD      18			/* type dg       */
#define	DGRAME      19			/* type dg       */
#define	DGRAMF      20			/* type dg       */
#define	TCP         21			/* type tcpm     */
#define	TCP0        22			/* type tcp      */
#define	TCP1        23			/* type tcp      */
#define	TCP2        24			/* type tcp      */
#define	TCP3        25			/* type tcp      */
#define	TCP4        26			/* type tcp      */
#define	TCP5        27			/* type tcp      */
#define	TCP6        28			/* type tcp      */
#define	TCP7        29			/* type tcp      */
#define	TCP8        30			/* type tcp      */
#define	TCP9        31			/* type tcp      */
#define	TCPA        32			/* type tcp      */
#define	TCPB        33			/* type tcp      */
#define	TCPC        34			/* type tcp      */
#define	TCPD        35			/* type tcp      */
#define	TCPE        36			/* type tcp      */
#define	TCPF        37			/* type tcp      */
#define	RFILSYS     38			/* type rfm      */
#define	RFILE1      39			/* type rf       */
#define	RFILE2      40			/* type rf       */
#define	RFILE3      41			/* type rf       */
#define	RFILE4      42			/* type rf       */
#define	NAMESPACE   43			/* type nam      */

/* Control block sizes */

#define	Ntty	1
#define	Neth	1
#define	Noth	2
#define	Ndgm	1
#define	Ndg	16
#define	Ntcpm	1
#define	Ntcp	16
#define	Nrfm	1
#define	Nrf	4
#define	Nnam	1

#define	NDEVS	44

/* Declarations of I/O routines referenced */

extern	int	ttyinit();
extern	int	ionull();
extern	int	ttyread();
extern	int	ttywrite();
extern	int	ioerr();
extern	int	ttycntl();
extern	int	ttygetc();
extern	int	ttyputc();
extern	int	ethinit();
extern	int	ethwrite();
extern	int	ethcntl();
extern	int	ethinter();
extern	int	othinit();
extern	int	othwrite();
extern	int	dgmopen();
extern	int	dgmcntl();
extern	int	dginit();
extern	int	dgclose();
extern	int	dgread();
extern	int	dgwrite();
extern	int	dgcntl();
extern	int	tcpmopen();
extern	int	tcpmcntl();
extern	int	tcpinit();
extern	int	tcpclose();
extern	int	tcpread();
extern	int	tcpwrite();
extern	int	tcpcntl();
extern	int	tcpgetc();
extern	int	tcpputc();
extern	int	rfopen();
extern	int	rfcntl();
extern	int	rfinit();
extern	int	rfclose();
extern	int	rfread();
extern	int	rfwrite();
extern	int	rfseek();
extern	int	rfgetc();
extern	int	rfputc();
extern	int	naminit();
extern	int	namopen();


/* Configuration and Size Constants */

#define	NPROC	    50			/* number of user processes	*/
#define	NSEM	    512			/* number of semaphores		*/
#define	MEMMARK				/* define if memory marking used*/
#define	RTCLOCK				/* now have RTC support		*/
#define	STKCHK				/* resched checks stack overflow*/
#define	NETDAEMON			/* Ethernet network daemon runs	*/

#define	TSERVER	    "128.10.2.3:37"	/* Time server address		*/
#define	RSERVER	    "128.10.3.20:2001"	/* Remote file server address	*/
#define	NSERVER	    "128.10.3.20:53"	/* Domain Name server address	*/

#define	BINGID	9			/* my BING */

#define	SMALLMTU	400		/* for OTHER2 */

#define	BPMAXB	4096
#define BPMAXN	512

#define	TCPSBS	4096			/* TCP send buffer sizes	*/
#define	TCPRBS	16384			/* TCP receive buffer sizes	*/

#define	NPORTS	100

#define	TIMERGRAN	1		/* timer granularity, secs/10	*/

#ifndef	Noth
#define	Noth	0
#endif	!Noth
