/*
 * threadCalls.c
 * Support for threaded ops which may block (read, write, connect, etc.).
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 **/

/*** CHANGELOG ***
 *
 *  29.1.1998  Teemu Ikonen               support for non-blocking I/O
 *
 *  31.1.1998  Teemu Ikonen               stderr, stdin and stdout
 *
 *
 */

#define	DBG(s)

#include <u.h>
#include <libc.h>
#include "plan9interface.h"
#include "config.h"
#include "config-std.h"
#include "config-io.h"
#include "config-mem.h"
#include "lerrno.h"
#include "object.h"
#include "thread.h"
#include "locks.h"
#include "md.h"

/*
 * We only need this stuff is we are using the internal thread system.
 **/

/*
 * Create a threaded file descriptor.
 **/
int
threadedFileDescriptor(int fd)
{
    return (fd);
}

/*
 * Threaded file open.
 **/
int
threadedOpen(const char* path, int omode)
{
    return( open( path, omode ));
}

/* close file */
int 
threadedClose( int fd )
{
    return( close( fd ));
}

/*
 * Read but only if we can.
 **/
unsigned int
threadedRead(int fd, void* buf, unsigned int nbytes)
{
    return( read( fd, buf, nbytes ));
}

/*
 * Write but only if we can.
 **/
unsigned int
threadedWrite(int fd, const void* buf, unsigned int nbytes)
{
    return( write( fd, buf, nbytes ));
}

/* dummy */
void init_tio(void) {
}

void clean_tio(void) {
}
