/*
 * kthread.h
 * Define the threading used in the system.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG
 *
 * 22.1.1998    Arttu Kuukankorpi  Added definition for size_t
 *
 * 29.1.1998    Teemu Ikonen       some thread stuff
 *
 */


#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int    size_t;
#endif

#ifndef __kthread_h
#define __kthread_h

#include "md.h"

/*
 * We 'magically' thread various calls.
 */
extern int threadedFileDescriptor(int);
extern int threadedOpen(const char*, int);
extern int threadedClose(int);
extern unsigned int threadedRead(int, char*, unsigned int);
extern unsigned int threadedWrite(int, const char*, unsigned int);


#define	fixfd(_fd)			threadedFileDescriptor(_fd)
#define	open(_path,  _mode)	threadedOpen(_path, _mode)
#define close( _fd )                    threadedClose( _fd )
#define	read(_fd, _addr, _len)		threadedRead(_fd, _addr, _len)
#define	write(_fd, _addr, _len)		threadedWrite(_fd, _addr, _len)

#endif
