import java.net.*;
import java.io.*;
import java.util.*;

/**
 * MainServer class used for accepting new connections to the server.
 *
 * The connections are accepted in a single thread and the new server
 * threads are created whenever clients need to be served.
 */
public class MainServer
{
  /**
   * The document root.
   */
  public static File documentRoot;
  
  /**
   * The accepting port of the server.
   */
  public static int serverPort;
  
  /**
   * The number of active threads serving the connections.
   */
  public static int threadNum;

  //------------------------------------------------------------------
  //                            Constants
  //------------------------------------------------------------------
  
  /**
   * The default port for accepting connections.
   */
  public final static int DEFAULT_SERVER_PORT = 8080;

  /**
   * The minimum port number.
   */
  public final static int MIN_PORT = 0;
  
  /**
   * The maximum port number.
   */
  public final static int MAX_PORT = 65536;
  
  /**
   * The maximum thread number.
   */
  public final static int MAX_THREAD_NUM = 100;
  
  /**
   * The maximum waiting connections number.
   */
  public final static int MAX_QUEUE_SIZE = 100;

  /**
   * The backlog number for server socket.
   */
  public final static int SERVER_BACKLOG = 10;

  //------------------------------------------------------------------
  //                             Methods
  //------------------------------------------------------------------
  
  /**
   * The main method for HTTPServer.
   *
   * @param args_ Command line arguments for HTTPServer.
   */
  public static void main(String[] args_)
  {
    int serverPort = DEFAULT_SERVER_PORT;
    String docRoot = ".";
    boolean verbose = false;

    try
      {
	if (args_[0].compareTo("-v") == 0)
	  {
	    verbose = true;
	  }
      }
    catch (Exception e) {}
    
    try
      {
	if (verbose)
	  {
	    docRoot = args_[1];
	  }
	else
	  {
	    docRoot = args_[0];
	  }
      }
    catch (Exception e) {}
    
    try
      {
	if (verbose)
	  {
	    serverPort = Integer.parseInt(args_[2]);
	  }
	else
	  {
	    serverPort = Integer.parseInt(args_[1]);
	  }
	
	if (serverPort < MIN_PORT || serverPort > MAX_PORT)
	  {
	    serverPort = DEFAULT_SERVER_PORT;
	  }
      }
    catch (Exception e) {}
    
    // Create the main server and trigger its thread into action.

    MainServer.serverPort = serverPort;
    try {
      MainServer.documentRoot = new File(docRoot);      
    }
    catch (Exception e) {
      MainServer.documentRoot = new File(".");      
    }
    
    ServerSocket masterSocket = null;
    Socket newConnection = null;
    
    try
      {
	if (verbose)
	  {
	    System.out.println("Starting HTTP server in port: "+serverPort);
	    System.out.println("Document root is: "+docRoot);
	  }
	masterSocket = new ServerSocket(serverPort, SERVER_BACKLOG);
	while (true)
	  {
	    newConnection = masterSocket.accept();
	    
	    if (verbose) 
	      {
		System.out.println("Accepting connection: New HTTP request");
	      }
	    if (MainServer.threadNum < MAX_THREAD_NUM)
	      {
		MainServer.threadNum++;
		new HTTPServer(newConnection, verbose).serveConnection();
	      }
	    else
	      {
		// Not accepted.
	      }
	  }
      }
    catch (IOException e)
      {
	System.err.println("Server aborted.");
      }
  }
}
  



