/*
 * exception.h
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 15.1.1998     Teemu Ikonen            Removed '#include' for setjmp.h
 *
 *                                       jmp_buf turned to long[2]
 *
 * 27.1.1998     Teemu Ikonen            new exception functions 
 *
 * 26.2.1998     Teemu Ikonen            new exception functions (ver 2.0)
 *
 * 12.3.1998     Teemu Ikonen            Changed protypes for JIT
 */

#ifndef __exception_h
#define __exception_h

struct _exceptionFrame;
struct Hjava_lang_Class;
struct Hjava_lang_Object;

typedef struct _jexceptionEntry {
	uintp				start_pc;
	uintp				end_pc;
	uintp				handler_pc;
	constIndex			catch_idx;
	struct Hjava_lang_Class*	catch_type;
} jexceptionEntry;

typedef struct _jexception {
	uint32				length;
	jexceptionEntry			entry[1];
} jexception;

struct _methods;
typedef struct _vmException {
	u4				pc;
	struct Hjava_lang_Object*	mobj;
	struct _methods*		meth;
        long                            jbuf[2];
	struct _vmException*		prev;
} vmException;

struct _exceptionFrame;

void throwException(struct Hjava_lang_Object*) __NORETURN__;
void throwExternalException(struct Hjava_lang_Object*) __NORETURN__;

struct Hjava_lang_Object* buildStackTrace(struct _exceptionFrame*);

extern void notehandler( void *, char * );
extern void nullException( struct Ureg * );
extern void arithmeticException( struct Ureg * );

#define SIG_T   void*

#endif
