/*
 * java.lang.Math.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 21.1.1998   Vesa Karpijoki   Added #includes <u.h> and <libc.h>.
 *                              Removed some #includes.
 *
 * 18.3.1998   Vesa Karpijoki   Added Dokumatic documentation.
 *                              Changed #include:s.
 */

#include <u.h>
#include <libc.h>

#include "config.h"
#include "config-std.h"
#include <native.h>
#include "config-math.h"
#include "../java.lang.stubs/Math.h"

/**
  @title java_lang_Math
  @desc Native methods of the Java API class java.lang.Math.
  @funcidx
  @end
  */

/**
  @function java_lang_Math_sin
  @description Trigonometric sin function.
  @parameter Angle in radians (double).
  @rvalue Sin value.
  @end
  */
double java_lang_Math_sin(double v)
{
	return (sin(v));
}

/**
  @function java_lang_Math_cos
  @description Trigonometric cos function.
  @parameter Angle in radians (double).
  @rvalue Cos value.
  @end
  */
double java_lang_Math_cos(double v)
{
	return (cos(v));
}

/**
  @function java_lang_Math_tan
  @description Trigonometric tan function.
  @parameter Angle in radians (double).
  @rvalue Tan value.
  @end
  */
double java_lang_Math_tan(double v)
{
	return (tan(v));
}

/**
  @function java_lang_Math_asin
  @description Trigonometric arcsin function.
  @parameter Double value.
  @rvalue An angle in radians.
  @end
  */
double java_lang_Math_asin(double v)
{
	return (asin(v));
}

/**
  @function java_lang_Math_acos
  @description Trigonometric arccos function.
  @parameter Double value.
  @rvalue An angle in radians.
  @end
  */
double java_lang_Math_acos(double v)
{
	return (acos(v));
}

/**
  @function java_lang_Math_atan
  @description Trigonometric arctan function.
  @parameter Double value.
  @rvalue An angle in radians.
  @end
  */
double java_lang_Math_atan(double v)
{
	return (atan(v));
}

/**
  @function java_lang_Math_exp
  @description Returns the exponential number e raised to the power of a double value.
  @parameter The exponent as double.
  @rvalue E (2.72...) raised to the exponent.
  @end
  */
double java_lang_Math_exp(double v)
{
	return (exp(v));
}

/**
  @function java_lang_Math_log
  @description Returns the natural logarithm (base e) of a double value.
  @parameter The double value.
  @rvalue The natural logarithm of the value.
  @end
  */
double java_lang_Math_log(double v)
{
	return (log(v));
}

/**
  @function java_lang_Math_sqrt
  @description Returns the square root of a double value.
  @parameter The double value.
  @rvalue The square root of the value.
  @end
  */
double java_lang_Math_sqrt(double v)
{
	return (sqrt(v));
}

/**
  @function java_lang_Math_IEEEremainder
  @description Computes the remainder operation on two arguments as
  prescribed by the IEEE 754 standard.
  @parameter The double value v1.
  @parameter The double value v2.
  @rvalue The remainder.
  @end
  */
double java_lang_Math_IEEEremainder(double v1, double v2)
{
    return (remainder(v1, v2));
}

/**
  @function java_lang_Math_ceil
  @description Returns the smallest double value that is not less than the
  argument and is equal to a mathematical integer.
  @parameter The double value.
  @rvalue The ceil value.
  @end
  */
double java_lang_Math_ceil(double v)
{
	return (ceil(v));
}

/**
  @function java_lang_Math_floor
  @description Returns the largest double value that is not greater than the
  argument and is equal to a mathematical integer.
  @parameter The double value.
  @rvalue The floor value.
  @end
  */
double java_lang_Math_floor(double v)
{
	return (floor(v));
}

/**
  @function java_lang_Math_rint
  @description Returns the closest integer to the argument.
  @parameter The double value to be rounded.
  @rvalue The rounded integer value as double.
  @end
  */
double java_lang_Math_rint(double v)
{
	/* As per Java Class Libraries page 927 */
	return (floor(v+0.5));
}

/**
  @function java_lang_Math_atan2
  @description Converts rectangular coordinates (x1, x2) to polar (r, theta). 
  @parameter The rectangular coordinate x1.
  @parameter The rectangular coordinate x2.
  @rvalue The phase theta in the range (-pi, pi).
  @end
  */
double java_lang_Math_atan2(double v1, double v2)
{
	return (atan2(v1, v2));
}

/**
  @function java_lang_Math_pow
  @description Returns of value of the first argument raised to the power of
  the second argument. 
  @parameter The base value.
  @parameter The exponent value.
  @rvalue The base value raised to the given exponent.
  @end
  */
double java_lang_Math_pow(double v1, double v2)
{
	return (pow(v1, v2));
}
