/*
 * java.lang.ClassLoader.c
 *
 * Copyright (c) 1996,97 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.co.uk>
 **/

/*** CHANGELOG ***
 *
 * 21.1.1998   Vesa Karpijoki   Added #includes <u.h> and <libc.h>.
 *
 * 30.1.1997   Vesa Karpijoki   Added the last extern. Added some USED- and
 *                              SET-calls.
 *
 * 18.3.1998   Vesa Karpijoki   Added Dokumatic documentation.
 *                              Changed #include:s.
 *
 */

#include <u.h>
#include <libc.h>

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "../../../src/gtypes.h"
#include "../../../src/file.h"
#include "../../../src/readClass.h"
#include "../../../src/constants.h"
#include "../../../src/access.h"
#include "../../../src/classMethod.h"
#include "../../../src/object.h"
#include "../../../src/itypes.h"
#include <native.h>
#include "defs.h"

/**
  @title java_lang_ClassLoader
  @desc Native methods of the Java API class java.lang.ClassLoader.
  @funcidx  
  @end
  */

extern Hjava_lang_Class ClassClass;

extern classFile findInJar(char*);

extern int32 hashUtf8String(char*, int);

/**
  @function java_lang_ClassLoader_init
  @description Initialise this class loader. Does nothing currently.
  @parameter Reference to the current ClassLoader object (this).
  @end
  */
void java_lang_ClassLoader_init(struct Hjava_lang_ClassLoader* this)
{
	SET(this);
	USED(this);
	/* Does nothing **/
}

/**
  @function java_lang_ClassLoader_init
  @description Translates an array of bytes into a class.
  @parameter Reference to the current ClassLoader object (this).
  @parameter A reference to an array of bytes to be translated.
  @parameter The offset where the translation is started.
  @parameter The length of the byte block to be translated.
  @rvalue Reference to the created class.
  @end
  */
struct Hjava_lang_Class* java_lang_ClassLoader_defineClass0(struct Hjava_lang_ClassLoader* this, HArrayOfByte* data, jint offset, jint length)
{
	Hjava_lang_Class* clazz;
	classFile hand;

	hand.base = (unsigned char *)&unhand(data)->body[offset];
	hand.buf = hand.base;
	hand.size = length;

	clazz = (Hjava_lang_Class*)newObject(&ClassClass);
	return (readClass(clazz, &hand, this));
}

/**
  @function java_lang_ClassLoader_resolveClass0
  @description Resolve classes reference by this class.
  @parameter Reference to the current ClassLoader object (this).
  @parameter Reference to the class.
  @end
  */
void java_lang_ClassLoader_resolveClass0(struct Hjava_lang_ClassLoader* this, struct Hjava_lang_Class* class)
{
    SET(this);
    USED(this);
    processClass(class, CSTATE_LINKED);
}

/**
  @function java_lang_ClassLoader_findSystemClass0
  @description Load a system class.
  @parameter Reference to the current ClassLoader object (this).
  @parameter Reference to a string describing the path of the class.
  @rvalue Reference to the system class.
  @end
  */
struct Hjava_lang_Class* java_lang_ClassLoader_findSystemClass0(struct Hjava_lang_ClassLoader* this, struct Hjava_lang_String* str)
{
	int len = javaStringLength(str);
	Utf8Const* c;
	char* name;

	SET(this);
	USED(this);
	c = gc_malloc_fixed(sizeof(Utf8Const) + len + 1);
	name = c->data;

        javaString2CString(str, name, len+1);
	classname2pathname (name, name);
 /* ! INTERN_UTF8CONSTS **/
	c->length = len;
	c->hash = (uint16) hashUtf8String (name, len);
 /* ! INTERN_UTF8CONSTS **/
	return (loadClass(c, 0));
}


/**
  @function java_lang_ClassLoader_getSystemResourceAsStream0
  @description Locate the requested resource in the current Jar files and create a stream to the data.
  @parameter Reference to a string that describes the resource.
  @rvalue Reference to the created InputStream object.
  @end
  */
struct Hjava_io_InputStream* java_lang_ClassLoader_getSystemResourceAsStream0(struct Hjava_lang_String* str)
{
	char* name;
	struct Hjava_io_InputStream* in;
	classFile hand;
	HArrayOfByte* data;

	in = NULL;
	USED(in);
	name = makeCString(str);
	hand = findInJar(name);
	gc_free(name);
	if (hand.type == 0) {
		return (NULL);
	}

	/* Copy data from returned buffer into Java byte array. Be nice
	 * to avoid this copy but we cannot for the moment.
	 **/
	data = (HArrayOfByte*)AllocArray(hand.size, TYPE_Byte);
	memcpy(unhand(data)->body, hand.buf, hand.size);
	if (hand.base != NULL) {
		gc_free(hand.base);
	}

	/* Create input stream using byte array **/
	in = (struct Hjava_io_InputStream*)execute_java_constructor(NULL, "java.io.ByteArrayInputStream", NULL, "([B)V", data);
	return (in);
}

/**
  @function java_lang_ClassLoader_getSystemResourceAsName0
  @description ???
  @parameter ???
  @rvalue ???
  @end
  */
struct Hjava_lang_String* java_lang_ClassLoader_getSystemResourceAsName0(struct Hjava_lang_String* str)
{
  SET(str);
  USED(str);
  return (NULL);
}
