/*     
 * java.lang.reflect.Array.c
 *
 * Copyright (c) 1996,97 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *     
 * Written by Tim Wilkinson <tim@tjwassoc.co.uk>
 */
/*** CHANGELOG ***
 *
 * 15.2.1998    Arttu Kuukankorpi  Added dokumatic-documentation
 *
 * 16.3.1998    Arttu Kuukankorpi  changed include-directores
 */

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "../../../src/object.h"
#include "../java.lang.reflect.stubs/Array.h"
#include <native.h>
#include "defs.h"

/**
  @title java_lang_reflect_Array
  @end
  */

/**
  @function java_lang_reflect_Array_getLength
  @description Get length of array.
  @parameter Reference to the object.
  @rvalue Length of array.
  @end
  */

jint
java_lang_reflect_Array_getLength(struct Hjava_lang_Object* obj)
{
	return (obj_length((HArrayOfObject*)obj));
}

/**
  @function java_lang_reflect_Array_get
  @description Get data from array.
  @parameter Reference to the object.
  @parameter Number of element.
  @rvalue Reference to an object containing data.
  @end
  */

struct Hjava_lang_Object*
java_lang_reflect_Array_get(struct Hjava_lang_Object* obj, jint elem)
{
	return (unhand((HArrayOfObject*)obj)->body[elem]);
}

/**
  @function java_lang_reflect_Array_getBoolean
  @description Get data from array in boolean format.
  @parameter Reference to the object.
  @parameter Number of element.
  @rvalue Data.
  @end
  */

jbool
java_lang_reflect_Array_getBoolean(struct Hjava_lang_Object* obj, jint elem)
{
	return (unhand((HArrayOfBoolean*)obj)->body[elem]);
}

/**
  @function java_lang_reflect_Array_getByte
  @description Get data from array in byte format.
  @parameter Reference to the object.
  @parameter Number of element.
  @rvalue Data.
  @end
  */

jbyte
java_lang_reflect_Array_getByte(struct Hjava_lang_Object* obj, jint elem)
{
	return (unhand((HArrayOfByte*)obj)->body[elem]);
}

/**
  @function java_lang_reflect_Array_getChar
  @description Get data from array in char format.
  @parameter Reference to the object.
  @parameter Number of element.
  @rvalue Data.
  @end
  */

jchar
java_lang_reflect_Array_getChar(struct Hjava_lang_Object* obj, jint elem)
{
	return (unhand((HArrayOfChar*)obj)->body[elem]);
}

/**
  @function java_lang_reflect_Array_getShort
  @description Get data from array in short format.
  @parameter Reference to the object.
  @parameter Number of element.
  @rvalue Data.
  @end
  */

jshort
java_lang_reflect_Array_getShort(struct Hjava_lang_Object* obj, jint elem)
{
	return (unhand((HArrayOfShort*)obj)->body[elem]);
}

/**
  @function java_lang_reflect_Array_getInteger
  @description Get data from array in integer format.
  @parameter Reference to the object.
  @parameter Number of element.
  @rvalue Data.
  @end
  */

jint
java_lang_reflect_Array_getInt(struct Hjava_lang_Object* obj, jint elem)
{
	return (unhand((HArrayOfInt*)obj)->body[elem]);
}

/**
  @function java_lang_reflect_Array_getLong
  @description Get data from array in long format.
  @parameter Reference to the object.
  @parameter Number of element.
  @rvalue Data.
  @end
  */

jlong
java_lang_reflect_Array_getLong(struct Hjava_lang_Object* obj, jint elem)
{
	return (unhand((HArrayOfLong*)obj)->body[elem]);
}

/**
  @function java_lang_reflect_Array_getFloat
  @description Get data from array in float format.
  @parameter Reference to the object.
  @parameter Number of element.
  @rvalue Data.
  @end
  */

jfloat
java_lang_reflect_Array_getFloat(struct Hjava_lang_Object* obj, jint elem)
{
	return (unhand((HArrayOfFloat*)obj)->body[elem]);
}

/**
  @function java_lang_reflect_Array_getDouble
  @description Get data from array in double format.
  @parameter Reference to the object.
  @parameter Number of element.
  @rvalue Data.
  @end
  */

jdouble
java_lang_reflect_Array_getDouble(struct Hjava_lang_Object* obj, jint elem)
{
	return (unhand((HArrayOfDouble*)obj)->body[elem]);
}

/**
  @function java_lang_reflect_Array_set
  @description Set data to an array.
  @parameter Reference to the object.
  @parameter Number of element.
  @parameter Reference to data to set.
  @end
  */

void
java_lang_reflect_Array_set(struct Hjava_lang_Object* obj, jint elem, struct Hjava_lang_Object* val)
{
	unhand((HArrayOfObject*)obj)->body[elem] = val;
}

/**
  @function java_lang_reflect_Array_setBoolean
  @description Set data to an array.
  @parameter Reference to the object.
  @parameter Number of element.
  @parameter Data to set in boolean format.
  @end
  */

void
java_lang_reflect_Array_setBoolean(struct Hjava_lang_Object* obj, jint elem, jbool val)
{
	unhand((HArrayOfBoolean*)obj)->body[elem] = val;
}

/**
  @function java_lang_reflect_Array_setByte
  @description Set data to an array.
  @parameter Reference to the object.
  @parameter Number of element.
  @parameter Data to set in byte format.
  @end
  */

void
java_lang_reflect_Array_setByte(struct Hjava_lang_Object* obj, jint elem, jbyte val)
{
	unhand((HArrayOfByte*)obj)->body[elem] = val;
}

/**
  @function java_lang_reflect_Array_setChar
  @description Set data to an array.
  @parameter Reference to the object.
  @parameter Number of element.
  @parameter Data to set in char format.
  @end
  */

void
java_lang_reflect_Array_setChar(struct Hjava_lang_Object* obj, jint elem, jchar val)
{
	unhand((HArrayOfChar*)obj)->body[elem] = val;
}

/**
  @function java_lang_reflect_Array_setShort
  @description Set data to an array.
  @parameter Reference to the object.
  @parameter Number of element.
  @parameter Data to set in short format.
  @end
  */

void
java_lang_reflect_Array_setShort(struct Hjava_lang_Object* obj, jint elem, jshort val)
{
	unhand((HArrayOfShort*)obj)->body[elem] = val;
}

/**
  @function java_lang_reflect_Array_setInt
  @description Set data to an array.
  @parameter Reference to the object.
  @parameter Number of element.
  @parameter Data to set in integer format.
  @end
  */

void
java_lang_reflect_Array_setInt(struct Hjava_lang_Object* obj, jint elem, jint val)
{
	unhand((HArrayOfInt*)obj)->body[elem] = val;
}

/**
  @function java_lang_reflect_Array_setLong
  @description Set data to an array.
  @parameter Reference to the object.
  @parameter Number of element.
  @parameter Data to set in long format.
  @end
  */

void
java_lang_reflect_Array_setLong(struct Hjava_lang_Object* obj, jint elem, jlong val)
{
	unhand((HArrayOfLong*)obj)->body[elem] = val;
}

/**
  @function java_lang_reflect_Array_setFloat
  @description Set data to an array.
  @parameter Reference to the object.
  @parameter Number of element.
  @parameter Data to set in float format.
  @end
  */

void
java_lang_reflect_Array_setFloat(struct Hjava_lang_Object* obj, jint elem, jfloat val)
{
	unhand((HArrayOfFloat*)obj)->body[elem] = val;
}

/**
  @function java_lang_reflect_Array_setDouble
  @description Set data to an array.
  @parameter Reference to the object.
  @parameter Number of element.
  @parameter Data to set in double format.
  @end
  */

void
java_lang_reflect_Array_setDouble(struct Hjava_lang_Object* obj, jint elem, jdouble val)
{
	unhand((HArrayOfDouble*)obj)->body[elem] = val;
}

/**
  @function java_lang_reflect_Array_newArray
  @description Create new array.
  @parameter Type of objects to store in array.
  @parameter Size of array.
  @rvalue Reference to the new array.
  @end
  */

struct Hjava_lang_Object*
java_lang_reflect_Array_newArray(struct Hjava_lang_Class* clazz, jint size)
{
	return (newArray(clazz, size));
}

/**
  @function java_lang_reflect_Array_multiNewArray
  @description Create new multi-dimensional array.
  @parameter Type of objects to store in array.
  @parameter Array containing the sizes of the dimensions.
  @rvalue Reference to the new array.
  @end
  */

struct Hjava_lang_Object*
java_lang_reflect_Array_multiNewArray(struct Hjava_lang_Class* clazz, HArrayOfInt* sizes)
{
	int* dims;
	int i;
	int s;
	Hjava_lang_Object* array;

	s = obj_length(sizes);
	dims = calloc(s, sizeof(int));

	/* Copy dimentions into array */
	for( i = 0; i < s; i++ ) {
		dims[i] = unhand(sizes)->body[i];
	}
	dims[i] = 0;

	/* Create multi-dimension array */
	array = newMultiArray(clazz, dims);
	free(dims);

	return (array);
}
