/*
 * java.io.ObjectInputStream.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.co.uk>, 1997.
 */

/*** CHANGELOG ***
 *
 *  2.2.1998   Vesa Karpijoki         added some SET- and USED-calls
 *
 * 16.3.1998   Arttu Kuukankorpi      changed include-directories
 */

#include "config.h"
#include "config-std.h"
#include "config-io.h"
#include "config-mem.h"
#include <native.h>
#include "defs.h"
#include "files.h"
#include "system.h"
#include "../java.io.stubs/ObjectInputStream.h"
#include "../../../src/gtypes.h"
#include "../../../src/classMethod.h"
#include "../../../src/support.h"
#include "../../../src/lookup.h"

struct Hjava_lang_Class*
java_io_ObjectInputStream_loadClass0(struct Hjava_io_ObjectInputStream* stream, struct Hjava_lang_Class* cls, struct Hjava_lang_String* str)
{
    SET(stream);
    USED(stream);
    SET(cls);
    USED(cls);
    SET(str);
    USED(str);

    unimp("Serializable interface not implemented");

    return (NULL);
}

void
java_io_ObjectInputStream_inputClassFields(struct Hjava_io_ObjectInputStream* stream, struct Hjava_lang_Object* obj, struct Hjava_lang_Class* cls, HArrayOfInt* arr)
{
    SET(stream);
    USED(stream);
    SET(obj);
    USED(obj);
    SET(cls);
    USED(cls);
    SET(arr);
    USED(arr);

    unimp("Serializable interface not implemented");
}

struct Hjava_lang_Object*
java_io_ObjectInputStream_allocateNewObject(struct Hjava_lang_Class* cls, struct Hjava_lang_Class* cls2)
{
    SET(cls);
    USED(cls);
    SET(cls2);
    USED(cls2);

    unimp("Serializable interface not implemented");

    return (NULL);
}

struct Hjava_lang_Object*
java_io_ObjectInputStream_allocateNewArray(struct Hjava_lang_Class* cls, jint sz)
{
    SET(cls);
    USED(cls);
    SET(sz);
    USED(sz);

    unimp("Serializable interface not implemented");

    return (NULL);
}

jbool
java_io_ObjectInputStream_invokeObjectReader(struct Hjava_io_ObjectInputStream* stream, struct Hjava_lang_Object* obj, struct Hjava_lang_Class* cls)
{
    SET(stream);
    USED(stream);
    SET(obj);
    USED(obj);
    SET(cls);
    USED(cls);

    unimp("Serializable interface not implemented");

    return 0;
}
