'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetBounceKeysDelay __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetBounceKeysDelay \- Queries the current BounceKeys delay for a keyboard 
device.
.SH SYNOPSIS
.HP
.B Bool XkbGetBounceKeysDelay
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "device_spec" "\^,"
.BI "unsigned int *" "delay_rtrn" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
connection to X server
.TP
.I \- device_spec
device ID, or XkbUseCoreKbd
.TP
.I \- delay_rtrn
backfilled with bounce keys delay, ms 
.SH DESCRIPTION
.LP
The server can generate XkbAccessXNotify events for some of the global keyboard 
controls. 
The detail field describes what AccessX event just occurred and can be any of 
the values in 
Table 1.

.TS
c s
l l
l lw(4i).
Table 1 AccessXNotify Events
_
detail	Reason
_
XkbAXN_SKPress	T{
A key was pressed when SlowKeys was enabled.
T}
XkbAXN_SKAccept	T{
A key was accepted (held longer than the SlowKeys delay).
T}
XkbAXN_SKRelease	T{
An accepted SlowKeys key was released.
T}
XkbAXN_SKReject	T{
A key was rejected (released before the SlowKeys delay expired).
T}
XkbAXN_BKAccept	T{
A key was accepted by BounceKeys.
T}
XkbAXN_BKReject	T{
A key was rejected (pressed before the BounceKeys delay expired).
T}
XkbAXN_AXKWarning	T{
AccessXKeys is about to turn on/off StickyKeys or BounceKeys.
T}
.TE


The 
.I keycode 
field reports the keycode of the key for which the event occurred. If the action 
is related to
.I SlowKeys, 
the 
.I slowKeysDelay 
field contains the current SlowKeys acceptance delay. If the action is related 
to BounceKeys, 
the 
.I debounceDelay 
field contains the current BounceKeys debounce delay.

Selecting for AccessX Events

To receive XkbAccessXNotify events under all possible conditions, use 
.I XkbSelectEvents
and pass XkbAccesXNotifyMask in both 
.I bits_to_change 
and 
.I values_for_bits.

To receive XkbStateNotify events only under certain conditions, use 
.I XkbSelectEventDetails 
using XkbAccessXNotify as the 
.I event_type 
and specifying the desired state changes in 
.I bits_to_change 
and 
.I values_for_bits 
using mask bits from Table 2.

.TS
c s s
l l l
l l lw(3i).
Table 2 AccessXNotify Event Details
_
XkbAccessXNotify Event Details	Value	Circumstances
_
XkbAXN_SKPressMask	(1<<0)	T{
Slow key press notification wanted
T}
XkbAXN_SKAcceptMask	(1<<1)	T{
Slow key accept notification wanted
T}
XkbAXN_SKRejectMask	(1<<2)	T{
Slow key reject notification wanted
T}
XkbAXN_SKReleaseMask	(1<<3)	T{
Slow key release notification wanted
T}
XkbAXN_BKAcceptMask	(1<<4)	T{
Bounce key accept notification wanted
T}
XkbAXN_BKRejectMask	(1<<5)	T{
Bounce key reject notification wanted
T}
XkbAXN_AXKWarningMask	(1<<6)	T{
AccessX warning notification wanted
T}
XkbAllAccessXEventsMask	(0x7f)	T{
All AccessX features notifications wanted
T}
.TE

Some users may accidentally "bounce" on a key when they release it. They press 
it once, then accidentally press it again after they release it. The BounceKeys 
control temporarily disables a key after it has been pressed, effectively 
"debouncing" the keyboard. The period of time the key is disabled after it is 
released is known as the 
.I BounceKeys delay. 
BounceKeys is a boolean control.

When the BounceKeys control is active, the server reports acceptance or 
rejection of any key to interested clients by sending an appropriate 
AccessXNotify event (see STRUCTURES).

.I XkbGetBounceKeysDelay 
requests the attributes of the BounceKeys control from the server, waits for a 
reply, and backfills 
.I delay_rtrn 
with the BounceKeys delay attribute. 
.I XkbGetBounceKeysDelay 
returns True if successful; if a compatible version of the Xkb extension is not 
available in the server 
.I XkbGetSlowKeysDelay 
returns False.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbGetBounceKeysDelay 
function returns True when it successfully requests the attributes of the 
BounceKeys control from the server, waits for a 
reply, and backfills 
.I delay_rtrn 
with the BounceKeys delay attribute.
.TP 15
False
The 
.I XkbGetBounceKeysDelay 
function returns False if a compatible version of the Xkb extension is not 
available in the server. 
.SH STRUCTURES
.LP
The structure for the XkbAccessXNotify event type is as follows:

.nf
typedef struct {
    int            type;           /\(** Xkb extension base event code */
    unsigned long  serial;         /\(** X server serial number for event */
    Bool           send_event;     /\(** True => synthetically generated */
    Display *      display;        /\(** server connection where event generated */
    Time           time;           /\(** server time when event generated */
    int            xkb_type;       /\(** XkbAccessXNotify */
    int            device;         /\(** Xkb device ID, will not be XkbUseCoreKbd 
*/
    int            detail;         /\(** XkbAXN_* */
    KeyCode        keycode;        /\(** key of event */
    int            slowKeysDelay;  /\(** current SlowKeys delay */
    int            debounceDelay;  /\(** current debounce delay */
} XkbAccessXNotifyEvent;
    
.fi    
.SH "SEE ALSO"
.BR XkbGetSlowKeysDelay (__libmansuffix__)

