/* sparc_audio.h */

/* elf
 * sparc_audio.c,v 1.1.1.1 1993/01/21 01:04:04 elf Exp
 * 1.1.1.1
 * sparc_audio.c,v
 * Revision 1.1.1.1  1993/01/21  01:04:04  elf
 * New Tracker Amiga MOD player.
 *
 * Revision 2.5  1991/12/04  14:04:15  espie
 * Minor fix.
 *
 * Revision 2.4  1991/12/04  08:28:53  espie
 * Separated mix/stereo stuff.
 *
 * Revision 2.3  1991/12/03  20:43:46  espie
 * Added possibility to get back to MONO for the sgi.
 *
 * Revision 2.2  1991/12/03  18:07:38  espie
 * Added stereo capabilities to the indigo version.
 *
 * Revision 2.1  1991/11/18  01:10:45  espie
 * Minor corrections.
 *
 * Revision 2.0  1991/11/17  21:42:08  espie
 * New version.
 *
 * Revision 1.6  1991/11/16  15:42:43  espie
 * Can't remember what, must be tabs.
 *
 * Revision 1.5  1991/11/08  14:25:55  espie
 * We now have to return frequency.
 *
 * Revision 1.4  1991/11/07  20:12:34  espie
 * Minor problem with version id.
 *
 * Revision 1.3  1991/11/07  20:11:10  espie
 * Added embedded version id.
 *
 * Revision 1.2  1991/11/04  13:23:59  espie
 * I don't know...
 *
 * Revision 1.1  1991/11/03  22:46:57  espie
 * Initial revision
 *
 *
 */

#include <stdio.h>
#include "defs.h"

static char *id = "sparc_audio.c,v 1.1.1.1 1993/01/21 01:04:04 elf Exp";

FILE *audio;

int
open_audio (int frequency)
{
  audio = fopen ("/dev/audio", "w");
  if (audio == NULL)
    {
      fprintf (stderr, "Error: could not open audio\n");
      exit (10);
    }
  return 8000;
}

void
set_mix (int percent)
{
  /* void operation */
}

int
sign (unsigned char x)
{
  return x;
}

/************************************************************************/
/*      For routine 'cvt' only                                          */
/************************************************************************/
/*      Copyright 1989 by Rich Gopstein and Harris Corporation          */
/************************************************************************/

unsigned int
cvt (int ch)
{
  int mask;

  if (ch < 0)
    {
      ch = -ch;
      mask = 0x7f;
    }
  else
    mask = 0xff;

  if (ch < 32)
    {
      ch = 0xF0 | 15 - (ch / 2);
    }
  else if (ch < 96)
    {
      ch = 0xE0 | 15 - (ch - 32) / 4;
    }
  else if (ch < 224)
    {
      ch = 0xD0 | 15 - (ch - 96) / 8;
    }
  else if (ch < 480)
    {
      ch = 0xC0 | 15 - (ch - 224) / 16;
    }
  else if (ch < 992)
    {
      ch = 0xB0 | 15 - (ch - 480) / 32;
    }
  else if (ch < 2016)
    {
      ch = 0xA0 | 15 - (ch - 992) / 64;
    }
  else if (ch < 4064)
    {
      ch = 0x90 | 15 - (ch - 2016) / 128;
    }
  else if (ch < 8160)
    {
      ch = 0x80 | 15 - (ch - 4064) / 256;
    }
  else
    {
      ch = 0x80;
    }
  return (mask & ch);
}

void
output_samples (int left, int right)
{
  fputc (cvt ((left + right) / 16), audio);
}

void
flush_buffer (void)
{
}


void
close_audio (void)
{
  fclose (audio);
}
