/* soundblaster_audio.c */

/* elf
 * soundblaster_audio.c,v 1.2 1993/01/21 02:37:51 elf Exp
 * 1.2
 * soundblaster_audio.c,v
 * Revision 1.2  1993/01/21  02:37:51  elf
 * First BSDI version.
 *
 * Revision 1.1.1.1  1993/01/21  01:04:04  elf
 * New Tracker Amiga MOD player.
 *
 * Revision 1.1  1992/06/24  06:24:17  steve
 * Initial revision
 */

#ifndef bsdi
#include <malloc.h>
#endif
#include <stdio.h>
#include "defs.h"
#include <i386at/sblast.h>

static char *id = "soundblaster_audio.c,v 1.2 1993/01/21 02:37:51 elf Exp";

unsigned char *buffer;		/* buffer for ready-to-play samples */
/*int index;  Can't call this index!  Conflicts with index(3) */
static int buf_index;
FILE *audio;			/* /dev/sb_dsp */

/* 256th of primary/secondary source for that side. */
static int primary, secondary;

void
set_mix (int percent)
{
  percent *= 256;
  percent /= 100;
  primary = percent;
  secondary = 512 - percent;
}

int
open_audio (int frequency)
{
  audio = fopen ("/dev/sb_dsp", "w");
  if (audio == NULL)
    perror ("Error opening audio device"),
      exit (10);

  if (ioctl (fileno (audio), DSP_IOCTL_STEREO, &pref.stereo) == -1)
    perror ("Error setting stereo/mono"),
      exit (1);

  if (pref.stereo)
    frequency *= 2;		/* XXX Stereo takes twice the speed */

  if (frequency == 0)
    frequency = -1;		/* read current frequency from driver */

  if (ioctl (fileno (audio), DSP_IOCTL_SPEED, &frequency) == -1)
    perror ("Error setting frequency"),
      exit (1);

  buffer = malloc (sizeof (SAMPLE) * frequency);	/* Stereo makes x2 */
  buf_index = 0;

  if (pref.stereo)			/* tacky, I know.. */
    return (frequency / 2);
  else
    return (frequency);
}

void
output_samples (int left, int right)
{
  if (pref.stereo)
    {
      buffer[buf_index++] = (((left * primary + right * secondary) / 256)
			 + (1 << 15)) >> 8;
      buffer[buf_index++] = (((right * primary + left * secondary) / 256)
			 + (1 << 15)) >> 8;
    }
  else
    {
      buffer[buf_index++] = (left + right + (1 << 15)) >> 8;
    }
}

void
flush_buffer (void)
{
  if (fwrite (buffer, sizeof (*buffer), buf_index, audio) != buf_index)
    fprintf (stderr, "fwrite didn't write all the bytes?\n");
  buf_index = 0;
}

/*
 * Closing the BSD SBlast sound device waits for all pending samples to play.
 * I think SysV aborts, so you might have to flush manually with ioctl()
 */
void
close_audio (void)
{
  fclose (audio);
}
