#!/usr/local/bin/perl
#
# sortdups.pl - Script to remove duplicate lines from active.full, and
#               choose the best choice. Debug file "active.debug" is
#               created as a side-effect, which shows the comparisons
#               done.
#
#                      Written by Mowgli C. Assor (mowgli@infinet.com)
#
# 96/03/14 - Original version written. (MCA)
#
open(INFILE, "< active.full") || die "$argv[0] : Couldn't open input file active.full";
open(OUTFILE, "> active.sort") || die "$argv[0] : Couldn't open output file";
open(DEBUGFILE, "> active.debug") || die "$argv[0] : Couldn't open debug file";

while (<INFILE>)
{
  if ($prevline eq "")
  {
    $prevline = $_;
    $_ = <INFILE>;
  }
  $thisline = $_;
  ($g1, $ct1, $junk) = split(/[ \t\n]+/,$prevline, 3);
  ($g2, $ct2, $junk) = split(/[ \t\n]+/,$thisline, 3);
  print DEBUGFILE "Comparing $g1, $g2...\n";
  if ($g1 eq $g2)
  {
    if ($ct1 eq "0000000000") { print OUTFILE $thisline; }
    else { print OUTFILE $prevline; }
    $prevline="";
  }
  else
  {
    print OUTFILE $prevline;
    $prevline=$thisline;
  }
}

print OUTFILE $prevline;

close INFILE;
close OUTFILE;
close DEBUGFILE;
