# Copyright (c) 1993 by Sanjay Ghemawat
###############################################################################
# Ical initialization.
#
# This code is linked into the ical binaries and executed at startup.

# Initialize options
set ical(author)	{sanjay@lcs.mit.edu}
set ical(version)	{1.8b3}
set ical(mailer)	{/usr/bin/Mail}
set ical(library)	{/usr/contrib/lib/ical}
set ical(calendar)	[file dirname ~/junk]/.calendar
set ical(iconic)	0
set ical(prefs)		{}
set ical(geometry)	{}

# Handle environment variables
if [info exists env(ICAL_LIBRARY)] {set ical(library) $env(ICAL_LIBRARY)}
if [info exists env(CALENDAR)]     {set ical(calendar) $env(CALENDAR)}

# Set-up various paths
set auto_path [concat [list $ical(library) $ical(library)/tcllib] $auto_path]
set icon_path [list $ical(library) $ical(library)/tcllib]

# Check for correct Tcl version
if {[info tclversion] < 7.0} {
    puts stderr "ical: Tcl version < 7.0 cannot be used with ical"
    exit 1
}

# Load other support code
support_init

# Parse arguments
ical_parse_args

# Tk support
if [string compare [info commands tk] ""] {
    # Check Tk version
    if [info exists tk_version] {
	if {$tk_version < 3.3} {
	    puts stderr "ical: Tk version < 3.3 cannot be used with ical"
	    exit 1
	}
    }

    # Handle geometry value already parsed by Tk
    if [info exists geometry] {set ical(geometry) $geometry}

    # Fix keybindings
    fix_bindings

    # Parse tk arguments
    ical_parse_tk_args
}
