static const u8 rsa_oaep_0_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_0_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_0_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_0_m[] = {
0x66, 0x28, 0x19, 0x4e, 0x12, 0x07, 0x3d, 0xb0, 0x3b, 0xa9, 0x4c, 0xda, 0x9e, 0xf9, 0x53, 0x23, 0x97, 0xd5, 0x0d, 0xba, 0x79, 0xb9, 0x87, 0x00, 0x4a, 0xfe, 0xfe, 0x34, 
};
static const u8 rsa_oaep_0_res[] = {
0x35, 0x4f, 0xe6, 0x7b, 0x4a, 0x12, 0x6d, 0x5d, 0x35, 0xfe, 0x36, 0xc7, 0x77, 0x79, 0x1a, 0x3f, 0x7b, 0xa1, 0x3d, 0xef, 0x48, 0x4e, 0x2d, 0x39, 0x08, 0xaf, 0xf7, 0x22, 0xfa, 0xd4, 0x68, 0xfb, 0x21, 0x69, 0x6d, 0xe9, 0x5d, 0x0b, 0xe9, 0x11, 0xc2, 0xd3, 0x17, 0x4f, 0x8a, 0xfc, 0xc2, 0x01, 0x03, 0x5f, 0x7b, 0x6d, 0x8e, 0x69, 0x40, 0x2d, 0xe5, 0x45, 0x16, 0x18, 0xc2, 0x1a, 0x53, 0x5f, 0xa9, 0xd7, 0xbf, 0xc5, 0xb8, 0xdd, 0x9f, 0xc2, 0x43, 0xf8, 0xcf, 0x92, 0x7d, 0xb3, 0x13, 0x22, 0xd6, 0xe8, 0x81, 0xea, 0xa9, 0x1a, 0x99, 0x61, 0x70, 0xe6, 0x57, 0xa0, 0x5a, 0x26, 0x64, 0x26, 0xd9, 0x8c, 0x88, 0x00, 0x3f, 0x84, 0x77, 0xc1, 0x22, 0x70, 0x94, 0xa0, 0xd9, 0xfa, 0x1e, 0x8c, 0x40, 0x24, 0x30, 0x9c, 0xe1, 0xec, 0xcc, 0xb5, 0x21, 0x00, 0x35, 0xd4, 0x7a, 0xc7, 0x2e, 0x8a, 
};
static const u8 rsa_oaep_0_salt[] = {
0x18, 0xb7, 0x76, 0xea, 0x21, 0x06, 0x9d, 0x69, 0x77, 0x6a, 0x33, 0xe9, 0x6b, 0xad, 0x48, 0xe1, 0xdd, 0xa0, 0xa5, 0xef, 
};


static const rsa_test test_rsa_oaep_0 = {
	.name = "rsa_oaep_0",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_0_n,
	.nlen = sizeof(rsa_oaep_0_n),
	.d = (const u8*)&rsa_oaep_0_d,
	.dlen = sizeof(rsa_oaep_0_d),
	.e = (const u8*)&rsa_oaep_0_e,
	.elen = sizeof(rsa_oaep_0_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_0_m,
	.mlen = sizeof(rsa_oaep_0_m),
	.res = (const u8*)&rsa_oaep_0_res,
	.reslen = sizeof(rsa_oaep_0_res),
	.salt = (const u8*)&rsa_oaep_0_salt,
	.saltlen = sizeof(rsa_oaep_0_salt),
};
static const u8 rsa_oaep_1_CRT_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_1_CRT_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_1_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_1_CRT_m[] = {
0x66, 0x28, 0x19, 0x4e, 0x12, 0x07, 0x3d, 0xb0, 0x3b, 0xa9, 0x4c, 0xda, 0x9e, 0xf9, 0x53, 0x23, 0x97, 0xd5, 0x0d, 0xba, 0x79, 0xb9, 0x87, 0x00, 0x4a, 0xfe, 0xfe, 0x34, 
};
static const u8 rsa_oaep_1_CRT_res[] = {
0x35, 0x4f, 0xe6, 0x7b, 0x4a, 0x12, 0x6d, 0x5d, 0x35, 0xfe, 0x36, 0xc7, 0x77, 0x79, 0x1a, 0x3f, 0x7b, 0xa1, 0x3d, 0xef, 0x48, 0x4e, 0x2d, 0x39, 0x08, 0xaf, 0xf7, 0x22, 0xfa, 0xd4, 0x68, 0xfb, 0x21, 0x69, 0x6d, 0xe9, 0x5d, 0x0b, 0xe9, 0x11, 0xc2, 0xd3, 0x17, 0x4f, 0x8a, 0xfc, 0xc2, 0x01, 0x03, 0x5f, 0x7b, 0x6d, 0x8e, 0x69, 0x40, 0x2d, 0xe5, 0x45, 0x16, 0x18, 0xc2, 0x1a, 0x53, 0x5f, 0xa9, 0xd7, 0xbf, 0xc5, 0xb8, 0xdd, 0x9f, 0xc2, 0x43, 0xf8, 0xcf, 0x92, 0x7d, 0xb3, 0x13, 0x22, 0xd6, 0xe8, 0x81, 0xea, 0xa9, 0x1a, 0x99, 0x61, 0x70, 0xe6, 0x57, 0xa0, 0x5a, 0x26, 0x64, 0x26, 0xd9, 0x8c, 0x88, 0x00, 0x3f, 0x84, 0x77, 0xc1, 0x22, 0x70, 0x94, 0xa0, 0xd9, 0xfa, 0x1e, 0x8c, 0x40, 0x24, 0x30, 0x9c, 0xe1, 0xec, 0xcc, 0xb5, 0x21, 0x00, 0x35, 0xd4, 0x7a, 0xc7, 0x2e, 0x8a, 
};
static const u8 rsa_oaep_1_CRT_salt[] = {
0x18, 0xb7, 0x76, 0xea, 0x21, 0x06, 0x9d, 0x69, 0x77, 0x6a, 0x33, 0xe9, 0x6b, 0xad, 0x48, 0xe1, 0xdd, 0xa0, 0xa5, 0xef, 
};
static const u8 rsa_oaep_1_CRT_p[] = {
0xd3, 0x27, 0x37, 0xe7, 0x26, 0x7f, 0xfe, 0x13, 0x41, 0xb2, 0xd5, 0xc0, 0xd1, 0x50, 0xa8, 0x1b, 0x58, 0x6f, 0xb3, 0x13, 0x2b, 0xed, 0x2f, 0x8d, 0x52, 0x62, 0x86, 0x4a, 0x9c, 0xb9, 0xf3, 0x0a, 0xf3, 0x8b, 0xe4, 0x48, 0x59, 0x8d, 0x41, 0x3a, 0x17, 0x2e, 0xfb, 0x80, 0x2c, 0x21, 0xac, 0xf1, 0xc1, 0x1c, 0x52, 0x0c, 0x2f, 0x26, 0xa4, 0x71, 0xdc, 0xad, 0x21, 0x2e, 0xac, 0x7c, 0xa3, 0x9d, 
};
static const u8 rsa_oaep_1_CRT_q[] = {
0xcc, 0x88, 0x53, 0xd1, 0xd5, 0x4d, 0xa6, 0x30, 0xfa, 0xc0, 0x04, 0xf4, 0x71, 0xf2, 0x81, 0xc7, 0xb8, 0x98, 0x2d, 0x82, 0x24, 0xa4, 0x90, 0xed, 0xbe, 0xb3, 0x3d, 0x3e, 0x3d, 0x5c, 0xc9, 0x3c, 0x47, 0x65, 0x70, 0x3d, 0x1d, 0xd7, 0x91, 0x64, 0x2f, 0x1f, 0x11, 0x6a, 0x0d, 0xd8, 0x52, 0xbe, 0x24, 0x19, 0xb2, 0xaf, 0x72, 0xbf, 0xe9, 0xa0, 0x30, 0xe8, 0x60, 0xb0, 0x28, 0x8b, 0x5d, 0x77, 
};
static const u8 rsa_oaep_1_CRT_dP[] = {
0x0e, 0x12, 0xbf, 0x17, 0x18, 0xe9, 0xce, 0xf5, 0x59, 0x9b, 0xa1, 0xc3, 0x88, 0x2f, 0xe8, 0x04, 0x6a, 0x90, 0x87, 0x4e, 0xef, 0xce, 0x8f, 0x2c, 0xcc, 0x20, 0xe4, 0xf2, 0x74, 0x1f, 0xb0, 0xa3, 0x3a, 0x38, 0x48, 0xae, 0xc9, 0xc9, 0x30, 0x5f, 0xbe, 0xcb, 0xd2, 0xd7, 0x68, 0x19, 0x96, 0x7d, 0x46, 0x71, 0xac, 0xc6, 0x43, 0x1e, 0x40, 0x37, 0x96, 0x8d, 0xb3, 0x78, 0x78, 0xe6, 0x95, 0xc1, 
};
static const u8 rsa_oaep_1_CRT_dQ[] = {
0x95, 0x29, 0x7b, 0x0f, 0x95, 0xa2, 0xfa, 0x67, 0xd0, 0x07, 0x07, 0xd6, 0x09, 0xdf, 0xd4, 0xfc, 0x05, 0xc8, 0x9d, 0xaf, 0xc2, 0xef, 0x6d, 0x6e, 0xa5, 0x5b, 0xec, 0x77, 0x1e, 0xa3, 0x33, 0x73, 0x4d, 0x92, 0x51, 0xe7, 0x90, 0x82, 0xec, 0xda, 0x86, 0x6e, 0xfe, 0xf1, 0x3c, 0x45, 0x9e, 0x1a, 0x63, 0x13, 0x86, 0xb7, 0xe3, 0x54, 0xc8, 0x99, 0xf5, 0xf1, 0x12, 0xca, 0x85, 0xd7, 0x15, 0x83, 
};
static const u8 rsa_oaep_1_CRT_qInv[] = {
0x4f, 0x45, 0x6c, 0x50, 0x24, 0x93, 0xbd, 0xc0, 0xed, 0x2a, 0xb7, 0x56, 0xa3, 0xa6, 0xed, 0x4d, 0x67, 0x35, 0x2a, 0x69, 0x7d, 0x42, 0x16, 0xe9, 0x32, 0x12, 0xb1, 0x27, 0xa6, 0x3d, 0x54, 0x11, 0xce, 0x6f, 0xa9, 0x8d, 0x5d, 0xbe, 0xfd, 0x73, 0x26, 0x3e, 0x37, 0x28, 0x14, 0x27, 0x43, 0x81, 0x81, 0x66, 0xed, 0x7d, 0xd6, 0x36, 0x87, 0xdd, 0x2a, 0x8c, 0xa1, 0xd2, 0xf4, 0xfb, 0xd8, 0xe1, 
};


static const rsa_test test_rsa_oaep_1_CRT = {
	.name = "rsa_oaep_1_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_1_CRT_n,
	.nlen = sizeof(rsa_oaep_1_CRT_n),
	.d = (const u8*)&rsa_oaep_1_CRT_d,
	.dlen = sizeof(rsa_oaep_1_CRT_d),
	.e = (const u8*)&rsa_oaep_1_CRT_e,
	.elen = sizeof(rsa_oaep_1_CRT_e),
	.p = (const u8*)&rsa_oaep_1_CRT_p,
	.plen = sizeof(rsa_oaep_1_CRT_p),
	.q = (const u8*)&rsa_oaep_1_CRT_q,
	.qlen = sizeof(rsa_oaep_1_CRT_q),
	.dP = (const u8*)&rsa_oaep_1_CRT_dP,
	.dPlen = sizeof(rsa_oaep_1_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_1_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_1_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_1_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_1_CRT_qInv),
	.m = (const u8*)&rsa_oaep_1_CRT_m,
	.mlen = sizeof(rsa_oaep_1_CRT_m),
	.res = (const u8*)&rsa_oaep_1_CRT_res,
	.reslen = sizeof(rsa_oaep_1_CRT_res),
	.salt = (const u8*)&rsa_oaep_1_CRT_salt,
	.saltlen = sizeof(rsa_oaep_1_CRT_salt),
};
static const u8 rsa_oaep_2_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_2_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_2_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_2_m[] = {
0x75, 0x0c, 0x40, 0x47, 0xf5, 0x47, 0xe8, 0xe4, 0x14, 0x11, 0x85, 0x65, 0x23, 0x29, 0x8a, 0xc9, 0xba, 0xe2, 0x45, 0xef, 0xaf, 0x13, 0x97, 0xfb, 0xe5, 0x6f, 0x9d, 0xd5, 
};
static const u8 rsa_oaep_2_res[] = {
0x64, 0x0d, 0xb1, 0xac, 0xc5, 0x8e, 0x05, 0x68, 0xfe, 0x54, 0x07, 0xe5, 0xf9, 0xb7, 0x01, 0xdf, 0xf8, 0xc3, 0xc9, 0x1e, 0x71, 0x6c, 0x53, 0x6f, 0xc7, 0xfc, 0xec, 0x6c, 0xb5, 0xb7, 0x1c, 0x11, 0x65, 0x98, 0x8d, 0x4a, 0x27, 0x9e, 0x15, 0x77, 0xd7, 0x30, 0xfc, 0x7a, 0x29, 0x93, 0x2e, 0x3f, 0x00, 0xc8, 0x15, 0x15, 0x23, 0x6d, 0x8d, 0x8e, 0x31, 0x01, 0x7a, 0x7a, 0x09, 0xdf, 0x43, 0x52, 0xd9, 0x04, 0xcd, 0xeb, 0x79, 0xaa, 0x58, 0x3a, 0xdc, 0xc3, 0x1e, 0xa6, 0x98, 0xa4, 0xc0, 0x52, 0x83, 0xda, 0xba, 0x90, 0x89, 0xbe, 0x54, 0x91, 0xf6, 0x7c, 0x1a, 0x4e, 0xe4, 0x8d, 0xc7, 0x4b, 0xbb, 0xe6, 0x64, 0x3a, 0xef, 0x84, 0x66, 0x79, 0xb4, 0xcb, 0x39, 0x5a, 0x35, 0x2d, 0x5e, 0xd1, 0x15, 0x91, 0x2d, 0xf6, 0x96, 0xff, 0xe0, 0x70, 0x29, 0x32, 0x94, 0x6d, 0x71, 0x49, 0x2b, 0x44, 
};
static const u8 rsa_oaep_2_salt[] = {
0x0c, 0xc7, 0x42, 0xce, 0x4a, 0x9b, 0x7f, 0x32, 0xf9, 0x51, 0xbc, 0xb2, 0x51, 0xef, 0xd9, 0x25, 0xfe, 0x4f, 0xe3, 0x5f, 
};


static const rsa_test test_rsa_oaep_2 = {
	.name = "rsa_oaep_2",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_2_n,
	.nlen = sizeof(rsa_oaep_2_n),
	.d = (const u8*)&rsa_oaep_2_d,
	.dlen = sizeof(rsa_oaep_2_d),
	.e = (const u8*)&rsa_oaep_2_e,
	.elen = sizeof(rsa_oaep_2_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_2_m,
	.mlen = sizeof(rsa_oaep_2_m),
	.res = (const u8*)&rsa_oaep_2_res,
	.reslen = sizeof(rsa_oaep_2_res),
	.salt = (const u8*)&rsa_oaep_2_salt,
	.saltlen = sizeof(rsa_oaep_2_salt),
};
static const u8 rsa_oaep_3_CRT_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_3_CRT_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_3_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_3_CRT_m[] = {
0x75, 0x0c, 0x40, 0x47, 0xf5, 0x47, 0xe8, 0xe4, 0x14, 0x11, 0x85, 0x65, 0x23, 0x29, 0x8a, 0xc9, 0xba, 0xe2, 0x45, 0xef, 0xaf, 0x13, 0x97, 0xfb, 0xe5, 0x6f, 0x9d, 0xd5, 
};
static const u8 rsa_oaep_3_CRT_res[] = {
0x64, 0x0d, 0xb1, 0xac, 0xc5, 0x8e, 0x05, 0x68, 0xfe, 0x54, 0x07, 0xe5, 0xf9, 0xb7, 0x01, 0xdf, 0xf8, 0xc3, 0xc9, 0x1e, 0x71, 0x6c, 0x53, 0x6f, 0xc7, 0xfc, 0xec, 0x6c, 0xb5, 0xb7, 0x1c, 0x11, 0x65, 0x98, 0x8d, 0x4a, 0x27, 0x9e, 0x15, 0x77, 0xd7, 0x30, 0xfc, 0x7a, 0x29, 0x93, 0x2e, 0x3f, 0x00, 0xc8, 0x15, 0x15, 0x23, 0x6d, 0x8d, 0x8e, 0x31, 0x01, 0x7a, 0x7a, 0x09, 0xdf, 0x43, 0x52, 0xd9, 0x04, 0xcd, 0xeb, 0x79, 0xaa, 0x58, 0x3a, 0xdc, 0xc3, 0x1e, 0xa6, 0x98, 0xa4, 0xc0, 0x52, 0x83, 0xda, 0xba, 0x90, 0x89, 0xbe, 0x54, 0x91, 0xf6, 0x7c, 0x1a, 0x4e, 0xe4, 0x8d, 0xc7, 0x4b, 0xbb, 0xe6, 0x64, 0x3a, 0xef, 0x84, 0x66, 0x79, 0xb4, 0xcb, 0x39, 0x5a, 0x35, 0x2d, 0x5e, 0xd1, 0x15, 0x91, 0x2d, 0xf6, 0x96, 0xff, 0xe0, 0x70, 0x29, 0x32, 0x94, 0x6d, 0x71, 0x49, 0x2b, 0x44, 
};
static const u8 rsa_oaep_3_CRT_salt[] = {
0x0c, 0xc7, 0x42, 0xce, 0x4a, 0x9b, 0x7f, 0x32, 0xf9, 0x51, 0xbc, 0xb2, 0x51, 0xef, 0xd9, 0x25, 0xfe, 0x4f, 0xe3, 0x5f, 
};
static const u8 rsa_oaep_3_CRT_p[] = {
0xd3, 0x27, 0x37, 0xe7, 0x26, 0x7f, 0xfe, 0x13, 0x41, 0xb2, 0xd5, 0xc0, 0xd1, 0x50, 0xa8, 0x1b, 0x58, 0x6f, 0xb3, 0x13, 0x2b, 0xed, 0x2f, 0x8d, 0x52, 0x62, 0x86, 0x4a, 0x9c, 0xb9, 0xf3, 0x0a, 0xf3, 0x8b, 0xe4, 0x48, 0x59, 0x8d, 0x41, 0x3a, 0x17, 0x2e, 0xfb, 0x80, 0x2c, 0x21, 0xac, 0xf1, 0xc1, 0x1c, 0x52, 0x0c, 0x2f, 0x26, 0xa4, 0x71, 0xdc, 0xad, 0x21, 0x2e, 0xac, 0x7c, 0xa3, 0x9d, 
};
static const u8 rsa_oaep_3_CRT_q[] = {
0xcc, 0x88, 0x53, 0xd1, 0xd5, 0x4d, 0xa6, 0x30, 0xfa, 0xc0, 0x04, 0xf4, 0x71, 0xf2, 0x81, 0xc7, 0xb8, 0x98, 0x2d, 0x82, 0x24, 0xa4, 0x90, 0xed, 0xbe, 0xb3, 0x3d, 0x3e, 0x3d, 0x5c, 0xc9, 0x3c, 0x47, 0x65, 0x70, 0x3d, 0x1d, 0xd7, 0x91, 0x64, 0x2f, 0x1f, 0x11, 0x6a, 0x0d, 0xd8, 0x52, 0xbe, 0x24, 0x19, 0xb2, 0xaf, 0x72, 0xbf, 0xe9, 0xa0, 0x30, 0xe8, 0x60, 0xb0, 0x28, 0x8b, 0x5d, 0x77, 
};
static const u8 rsa_oaep_3_CRT_dP[] = {
0x0e, 0x12, 0xbf, 0x17, 0x18, 0xe9, 0xce, 0xf5, 0x59, 0x9b, 0xa1, 0xc3, 0x88, 0x2f, 0xe8, 0x04, 0x6a, 0x90, 0x87, 0x4e, 0xef, 0xce, 0x8f, 0x2c, 0xcc, 0x20, 0xe4, 0xf2, 0x74, 0x1f, 0xb0, 0xa3, 0x3a, 0x38, 0x48, 0xae, 0xc9, 0xc9, 0x30, 0x5f, 0xbe, 0xcb, 0xd2, 0xd7, 0x68, 0x19, 0x96, 0x7d, 0x46, 0x71, 0xac, 0xc6, 0x43, 0x1e, 0x40, 0x37, 0x96, 0x8d, 0xb3, 0x78, 0x78, 0xe6, 0x95, 0xc1, 
};
static const u8 rsa_oaep_3_CRT_dQ[] = {
0x95, 0x29, 0x7b, 0x0f, 0x95, 0xa2, 0xfa, 0x67, 0xd0, 0x07, 0x07, 0xd6, 0x09, 0xdf, 0xd4, 0xfc, 0x05, 0xc8, 0x9d, 0xaf, 0xc2, 0xef, 0x6d, 0x6e, 0xa5, 0x5b, 0xec, 0x77, 0x1e, 0xa3, 0x33, 0x73, 0x4d, 0x92, 0x51, 0xe7, 0x90, 0x82, 0xec, 0xda, 0x86, 0x6e, 0xfe, 0xf1, 0x3c, 0x45, 0x9e, 0x1a, 0x63, 0x13, 0x86, 0xb7, 0xe3, 0x54, 0xc8, 0x99, 0xf5, 0xf1, 0x12, 0xca, 0x85, 0xd7, 0x15, 0x83, 
};
static const u8 rsa_oaep_3_CRT_qInv[] = {
0x4f, 0x45, 0x6c, 0x50, 0x24, 0x93, 0xbd, 0xc0, 0xed, 0x2a, 0xb7, 0x56, 0xa3, 0xa6, 0xed, 0x4d, 0x67, 0x35, 0x2a, 0x69, 0x7d, 0x42, 0x16, 0xe9, 0x32, 0x12, 0xb1, 0x27, 0xa6, 0x3d, 0x54, 0x11, 0xce, 0x6f, 0xa9, 0x8d, 0x5d, 0xbe, 0xfd, 0x73, 0x26, 0x3e, 0x37, 0x28, 0x14, 0x27, 0x43, 0x81, 0x81, 0x66, 0xed, 0x7d, 0xd6, 0x36, 0x87, 0xdd, 0x2a, 0x8c, 0xa1, 0xd2, 0xf4, 0xfb, 0xd8, 0xe1, 
};


static const rsa_test test_rsa_oaep_3_CRT = {
	.name = "rsa_oaep_3_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_3_CRT_n,
	.nlen = sizeof(rsa_oaep_3_CRT_n),
	.d = (const u8*)&rsa_oaep_3_CRT_d,
	.dlen = sizeof(rsa_oaep_3_CRT_d),
	.e = (const u8*)&rsa_oaep_3_CRT_e,
	.elen = sizeof(rsa_oaep_3_CRT_e),
	.p = (const u8*)&rsa_oaep_3_CRT_p,
	.plen = sizeof(rsa_oaep_3_CRT_p),
	.q = (const u8*)&rsa_oaep_3_CRT_q,
	.qlen = sizeof(rsa_oaep_3_CRT_q),
	.dP = (const u8*)&rsa_oaep_3_CRT_dP,
	.dPlen = sizeof(rsa_oaep_3_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_3_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_3_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_3_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_3_CRT_qInv),
	.m = (const u8*)&rsa_oaep_3_CRT_m,
	.mlen = sizeof(rsa_oaep_3_CRT_m),
	.res = (const u8*)&rsa_oaep_3_CRT_res,
	.reslen = sizeof(rsa_oaep_3_CRT_res),
	.salt = (const u8*)&rsa_oaep_3_CRT_salt,
	.saltlen = sizeof(rsa_oaep_3_CRT_salt),
};
static const u8 rsa_oaep_4_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_4_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_4_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_4_m[] = {
0xd9, 0x4a, 0xe0, 0x83, 0x2e, 0x64, 0x45, 0xce, 0x42, 0x33, 0x1c, 0xb0, 0x6d, 0x53, 0x1a, 0x82, 0xb1, 0xdb, 0x4b, 0xaa, 0xd3, 0x0f, 0x74, 0x6d, 0xc9, 0x16, 0xdf, 0x24, 0xd4, 0xe3, 0xc2, 0x45, 0x1f, 0xff, 0x59, 0xa6, 0x42, 0x3e, 0xb0, 0xe1, 0xd0, 0x2d, 0x4f, 0xe6, 0x46, 0xcf, 0x69, 0x9d, 0xfd, 0x81, 0x8c, 0x6e, 0x97, 0xb0, 0x51, 
};
static const u8 rsa_oaep_4_res[] = {
0x42, 0x37, 0x36, 0xed, 0x03, 0x5f, 0x60, 0x26, 0xaf, 0x27, 0x6c, 0x35, 0xc0, 0xb3, 0x74, 0x1b, 0x36, 0x5e, 0x5f, 0x76, 0xca, 0x09, 0x1b, 0x4e, 0x8c, 0x29, 0xe2, 0xf0, 0xbe, 0xfe, 0xe6, 0x03, 0x59, 0x5a, 0xa8, 0x32, 0x2d, 0x60, 0x2d, 0x2e, 0x62, 0x5e, 0x95, 0xeb, 0x81, 0xb2, 0xf1, 0xc9, 0x72, 0x4e, 0x82, 0x2e, 0xca, 0x76, 0xdb, 0x86, 0x18, 0xcf, 0x09, 0xc5, 0x34, 0x35, 0x03, 0xa4, 0x36, 0x08, 0x35, 0xb5, 0x90, 0x3b, 0xc6, 0x37, 0xe3, 0x87, 0x9f, 0xb0, 0x5e, 0x0e, 0xf3, 0x26, 0x85, 0xd5, 0xae, 0xc5, 0x06, 0x7c, 0xd7, 0xcc, 0x96, 0xfe, 0x4b, 0x26, 0x70, 0xb6, 0xea, 0xc3, 0x06, 0x6b, 0x1f, 0xcf, 0x56, 0x86, 0xb6, 0x85, 0x89, 0xaa, 0xfb, 0x7d, 0x62, 0x9b, 0x02, 0xd8, 0xf8, 0x62, 0x5c, 0xa3, 0x83, 0x36, 0x24, 0xd4, 0x80, 0x0f, 0xb0, 0x81, 0xb1, 0xcf, 0x94, 0xeb, 
};
static const u8 rsa_oaep_4_salt[] = {
0x25, 0x14, 0xdf, 0x46, 0x95, 0x75, 0x5a, 0x67, 0xb2, 0x88, 0xea, 0xf4, 0x90, 0x5c, 0x36, 0xee, 0xc6, 0x6f, 0xd2, 0xfd, 
};


static const rsa_test test_rsa_oaep_4 = {
	.name = "rsa_oaep_4",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_4_n,
	.nlen = sizeof(rsa_oaep_4_n),
	.d = (const u8*)&rsa_oaep_4_d,
	.dlen = sizeof(rsa_oaep_4_d),
	.e = (const u8*)&rsa_oaep_4_e,
	.elen = sizeof(rsa_oaep_4_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_4_m,
	.mlen = sizeof(rsa_oaep_4_m),
	.res = (const u8*)&rsa_oaep_4_res,
	.reslen = sizeof(rsa_oaep_4_res),
	.salt = (const u8*)&rsa_oaep_4_salt,
	.saltlen = sizeof(rsa_oaep_4_salt),
};
static const u8 rsa_oaep_5_CRT_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_5_CRT_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_5_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_5_CRT_m[] = {
0xd9, 0x4a, 0xe0, 0x83, 0x2e, 0x64, 0x45, 0xce, 0x42, 0x33, 0x1c, 0xb0, 0x6d, 0x53, 0x1a, 0x82, 0xb1, 0xdb, 0x4b, 0xaa, 0xd3, 0x0f, 0x74, 0x6d, 0xc9, 0x16, 0xdf, 0x24, 0xd4, 0xe3, 0xc2, 0x45, 0x1f, 0xff, 0x59, 0xa6, 0x42, 0x3e, 0xb0, 0xe1, 0xd0, 0x2d, 0x4f, 0xe6, 0x46, 0xcf, 0x69, 0x9d, 0xfd, 0x81, 0x8c, 0x6e, 0x97, 0xb0, 0x51, 
};
static const u8 rsa_oaep_5_CRT_res[] = {
0x42, 0x37, 0x36, 0xed, 0x03, 0x5f, 0x60, 0x26, 0xaf, 0x27, 0x6c, 0x35, 0xc0, 0xb3, 0x74, 0x1b, 0x36, 0x5e, 0x5f, 0x76, 0xca, 0x09, 0x1b, 0x4e, 0x8c, 0x29, 0xe2, 0xf0, 0xbe, 0xfe, 0xe6, 0x03, 0x59, 0x5a, 0xa8, 0x32, 0x2d, 0x60, 0x2d, 0x2e, 0x62, 0x5e, 0x95, 0xeb, 0x81, 0xb2, 0xf1, 0xc9, 0x72, 0x4e, 0x82, 0x2e, 0xca, 0x76, 0xdb, 0x86, 0x18, 0xcf, 0x09, 0xc5, 0x34, 0x35, 0x03, 0xa4, 0x36, 0x08, 0x35, 0xb5, 0x90, 0x3b, 0xc6, 0x37, 0xe3, 0x87, 0x9f, 0xb0, 0x5e, 0x0e, 0xf3, 0x26, 0x85, 0xd5, 0xae, 0xc5, 0x06, 0x7c, 0xd7, 0xcc, 0x96, 0xfe, 0x4b, 0x26, 0x70, 0xb6, 0xea, 0xc3, 0x06, 0x6b, 0x1f, 0xcf, 0x56, 0x86, 0xb6, 0x85, 0x89, 0xaa, 0xfb, 0x7d, 0x62, 0x9b, 0x02, 0xd8, 0xf8, 0x62, 0x5c, 0xa3, 0x83, 0x36, 0x24, 0xd4, 0x80, 0x0f, 0xb0, 0x81, 0xb1, 0xcf, 0x94, 0xeb, 
};
static const u8 rsa_oaep_5_CRT_salt[] = {
0x25, 0x14, 0xdf, 0x46, 0x95, 0x75, 0x5a, 0x67, 0xb2, 0x88, 0xea, 0xf4, 0x90, 0x5c, 0x36, 0xee, 0xc6, 0x6f, 0xd2, 0xfd, 
};
static const u8 rsa_oaep_5_CRT_p[] = {
0xd3, 0x27, 0x37, 0xe7, 0x26, 0x7f, 0xfe, 0x13, 0x41, 0xb2, 0xd5, 0xc0, 0xd1, 0x50, 0xa8, 0x1b, 0x58, 0x6f, 0xb3, 0x13, 0x2b, 0xed, 0x2f, 0x8d, 0x52, 0x62, 0x86, 0x4a, 0x9c, 0xb9, 0xf3, 0x0a, 0xf3, 0x8b, 0xe4, 0x48, 0x59, 0x8d, 0x41, 0x3a, 0x17, 0x2e, 0xfb, 0x80, 0x2c, 0x21, 0xac, 0xf1, 0xc1, 0x1c, 0x52, 0x0c, 0x2f, 0x26, 0xa4, 0x71, 0xdc, 0xad, 0x21, 0x2e, 0xac, 0x7c, 0xa3, 0x9d, 
};
static const u8 rsa_oaep_5_CRT_q[] = {
0xcc, 0x88, 0x53, 0xd1, 0xd5, 0x4d, 0xa6, 0x30, 0xfa, 0xc0, 0x04, 0xf4, 0x71, 0xf2, 0x81, 0xc7, 0xb8, 0x98, 0x2d, 0x82, 0x24, 0xa4, 0x90, 0xed, 0xbe, 0xb3, 0x3d, 0x3e, 0x3d, 0x5c, 0xc9, 0x3c, 0x47, 0x65, 0x70, 0x3d, 0x1d, 0xd7, 0x91, 0x64, 0x2f, 0x1f, 0x11, 0x6a, 0x0d, 0xd8, 0x52, 0xbe, 0x24, 0x19, 0xb2, 0xaf, 0x72, 0xbf, 0xe9, 0xa0, 0x30, 0xe8, 0x60, 0xb0, 0x28, 0x8b, 0x5d, 0x77, 
};
static const u8 rsa_oaep_5_CRT_dP[] = {
0x0e, 0x12, 0xbf, 0x17, 0x18, 0xe9, 0xce, 0xf5, 0x59, 0x9b, 0xa1, 0xc3, 0x88, 0x2f, 0xe8, 0x04, 0x6a, 0x90, 0x87, 0x4e, 0xef, 0xce, 0x8f, 0x2c, 0xcc, 0x20, 0xe4, 0xf2, 0x74, 0x1f, 0xb0, 0xa3, 0x3a, 0x38, 0x48, 0xae, 0xc9, 0xc9, 0x30, 0x5f, 0xbe, 0xcb, 0xd2, 0xd7, 0x68, 0x19, 0x96, 0x7d, 0x46, 0x71, 0xac, 0xc6, 0x43, 0x1e, 0x40, 0x37, 0x96, 0x8d, 0xb3, 0x78, 0x78, 0xe6, 0x95, 0xc1, 
};
static const u8 rsa_oaep_5_CRT_dQ[] = {
0x95, 0x29, 0x7b, 0x0f, 0x95, 0xa2, 0xfa, 0x67, 0xd0, 0x07, 0x07, 0xd6, 0x09, 0xdf, 0xd4, 0xfc, 0x05, 0xc8, 0x9d, 0xaf, 0xc2, 0xef, 0x6d, 0x6e, 0xa5, 0x5b, 0xec, 0x77, 0x1e, 0xa3, 0x33, 0x73, 0x4d, 0x92, 0x51, 0xe7, 0x90, 0x82, 0xec, 0xda, 0x86, 0x6e, 0xfe, 0xf1, 0x3c, 0x45, 0x9e, 0x1a, 0x63, 0x13, 0x86, 0xb7, 0xe3, 0x54, 0xc8, 0x99, 0xf5, 0xf1, 0x12, 0xca, 0x85, 0xd7, 0x15, 0x83, 
};
static const u8 rsa_oaep_5_CRT_qInv[] = {
0x4f, 0x45, 0x6c, 0x50, 0x24, 0x93, 0xbd, 0xc0, 0xed, 0x2a, 0xb7, 0x56, 0xa3, 0xa6, 0xed, 0x4d, 0x67, 0x35, 0x2a, 0x69, 0x7d, 0x42, 0x16, 0xe9, 0x32, 0x12, 0xb1, 0x27, 0xa6, 0x3d, 0x54, 0x11, 0xce, 0x6f, 0xa9, 0x8d, 0x5d, 0xbe, 0xfd, 0x73, 0x26, 0x3e, 0x37, 0x28, 0x14, 0x27, 0x43, 0x81, 0x81, 0x66, 0xed, 0x7d, 0xd6, 0x36, 0x87, 0xdd, 0x2a, 0x8c, 0xa1, 0xd2, 0xf4, 0xfb, 0xd8, 0xe1, 
};


static const rsa_test test_rsa_oaep_5_CRT = {
	.name = "rsa_oaep_5_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_5_CRT_n,
	.nlen = sizeof(rsa_oaep_5_CRT_n),
	.d = (const u8*)&rsa_oaep_5_CRT_d,
	.dlen = sizeof(rsa_oaep_5_CRT_d),
	.e = (const u8*)&rsa_oaep_5_CRT_e,
	.elen = sizeof(rsa_oaep_5_CRT_e),
	.p = (const u8*)&rsa_oaep_5_CRT_p,
	.plen = sizeof(rsa_oaep_5_CRT_p),
	.q = (const u8*)&rsa_oaep_5_CRT_q,
	.qlen = sizeof(rsa_oaep_5_CRT_q),
	.dP = (const u8*)&rsa_oaep_5_CRT_dP,
	.dPlen = sizeof(rsa_oaep_5_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_5_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_5_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_5_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_5_CRT_qInv),
	.m = (const u8*)&rsa_oaep_5_CRT_m,
	.mlen = sizeof(rsa_oaep_5_CRT_m),
	.res = (const u8*)&rsa_oaep_5_CRT_res,
	.reslen = sizeof(rsa_oaep_5_CRT_res),
	.salt = (const u8*)&rsa_oaep_5_CRT_salt,
	.saltlen = sizeof(rsa_oaep_5_CRT_salt),
};
static const u8 rsa_oaep_6_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_6_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_6_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_6_m[] = {
0x52, 0xe6, 0x50, 0xd9, 0x8e, 0x7f, 0x2a, 0x04, 0x8b, 0x4f, 0x86, 0x85, 0x21, 0x53, 0xb9, 0x7e, 0x01, 0xdd, 0x31, 0x6f, 0x34, 0x6a, 0x19, 0xf6, 0x7a, 0x85, 
};
static const u8 rsa_oaep_6_res[] = {
0x45, 0xea, 0xd4, 0xca, 0x55, 0x1e, 0x66, 0x2c, 0x98, 0x00, 0xf1, 0xac, 0xa8, 0x28, 0x3b, 0x05, 0x25, 0xe6, 0xab, 0xae, 0x30, 0xbe, 0x4b, 0x4a, 0xba, 0x76, 0x2f, 0xa4, 0x0f, 0xd3, 0xd3, 0x8e, 0x22, 0xab, 0xef, 0xc6, 0x97, 0x94, 0xf6, 0xeb, 0xbb, 0xc0, 0x5d, 0xdb, 0xb1, 0x12, 0x16, 0x24, 0x7d, 0x2f, 0x41, 0x2f, 0xd0, 0xfb, 0xa8, 0x7c, 0x6e, 0x3a, 0xcd, 0x88, 0x88, 0x13, 0x64, 0x6f, 0xd0, 0xe4, 0x8e, 0x78, 0x52, 0x04, 0xf9, 0xc3, 0xf7, 0x3d, 0x6d, 0x82, 0x39, 0x56, 0x27, 0x22, 0xdd, 0xdd, 0x87, 0x71, 0xfe, 0xc4, 0x8b, 0x83, 0xa3, 0x1e, 0xe6, 0xf5, 0x92, 0xc4, 0xcf, 0xd4, 0xbc, 0x88, 0x17, 0x4f, 0x3b, 0x13, 0xa1, 0x12, 0xaa, 0xe3, 0xb9, 0xf7, 0xb8, 0x0e, 0x0f, 0xc6, 0xf7, 0x25, 0x5b, 0xa8, 0x80, 0xdc, 0x7d, 0x80, 0x21, 0xe2, 0x2a, 0xd6, 0xa8, 0x5f, 0x07, 0x55, 
};
static const u8 rsa_oaep_6_salt[] = {
0xc4, 0x43, 0x5a, 0x3e, 0x1a, 0x18, 0xa6, 0x8b, 0x68, 0x20, 0x43, 0x62, 0x90, 0xa3, 0x7c, 0xef, 0xb8, 0x5d, 0xb3, 0xfb, 
};


static const rsa_test test_rsa_oaep_6 = {
	.name = "rsa_oaep_6",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_6_n,
	.nlen = sizeof(rsa_oaep_6_n),
	.d = (const u8*)&rsa_oaep_6_d,
	.dlen = sizeof(rsa_oaep_6_d),
	.e = (const u8*)&rsa_oaep_6_e,
	.elen = sizeof(rsa_oaep_6_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_6_m,
	.mlen = sizeof(rsa_oaep_6_m),
	.res = (const u8*)&rsa_oaep_6_res,
	.reslen = sizeof(rsa_oaep_6_res),
	.salt = (const u8*)&rsa_oaep_6_salt,
	.saltlen = sizeof(rsa_oaep_6_salt),
};
static const u8 rsa_oaep_7_CRT_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_7_CRT_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_7_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_7_CRT_m[] = {
0x52, 0xe6, 0x50, 0xd9, 0x8e, 0x7f, 0x2a, 0x04, 0x8b, 0x4f, 0x86, 0x85, 0x21, 0x53, 0xb9, 0x7e, 0x01, 0xdd, 0x31, 0x6f, 0x34, 0x6a, 0x19, 0xf6, 0x7a, 0x85, 
};
static const u8 rsa_oaep_7_CRT_res[] = {
0x45, 0xea, 0xd4, 0xca, 0x55, 0x1e, 0x66, 0x2c, 0x98, 0x00, 0xf1, 0xac, 0xa8, 0x28, 0x3b, 0x05, 0x25, 0xe6, 0xab, 0xae, 0x30, 0xbe, 0x4b, 0x4a, 0xba, 0x76, 0x2f, 0xa4, 0x0f, 0xd3, 0xd3, 0x8e, 0x22, 0xab, 0xef, 0xc6, 0x97, 0x94, 0xf6, 0xeb, 0xbb, 0xc0, 0x5d, 0xdb, 0xb1, 0x12, 0x16, 0x24, 0x7d, 0x2f, 0x41, 0x2f, 0xd0, 0xfb, 0xa8, 0x7c, 0x6e, 0x3a, 0xcd, 0x88, 0x88, 0x13, 0x64, 0x6f, 0xd0, 0xe4, 0x8e, 0x78, 0x52, 0x04, 0xf9, 0xc3, 0xf7, 0x3d, 0x6d, 0x82, 0x39, 0x56, 0x27, 0x22, 0xdd, 0xdd, 0x87, 0x71, 0xfe, 0xc4, 0x8b, 0x83, 0xa3, 0x1e, 0xe6, 0xf5, 0x92, 0xc4, 0xcf, 0xd4, 0xbc, 0x88, 0x17, 0x4f, 0x3b, 0x13, 0xa1, 0x12, 0xaa, 0xe3, 0xb9, 0xf7, 0xb8, 0x0e, 0x0f, 0xc6, 0xf7, 0x25, 0x5b, 0xa8, 0x80, 0xdc, 0x7d, 0x80, 0x21, 0xe2, 0x2a, 0xd6, 0xa8, 0x5f, 0x07, 0x55, 
};
static const u8 rsa_oaep_7_CRT_salt[] = {
0xc4, 0x43, 0x5a, 0x3e, 0x1a, 0x18, 0xa6, 0x8b, 0x68, 0x20, 0x43, 0x62, 0x90, 0xa3, 0x7c, 0xef, 0xb8, 0x5d, 0xb3, 0xfb, 
};
static const u8 rsa_oaep_7_CRT_p[] = {
0xd3, 0x27, 0x37, 0xe7, 0x26, 0x7f, 0xfe, 0x13, 0x41, 0xb2, 0xd5, 0xc0, 0xd1, 0x50, 0xa8, 0x1b, 0x58, 0x6f, 0xb3, 0x13, 0x2b, 0xed, 0x2f, 0x8d, 0x52, 0x62, 0x86, 0x4a, 0x9c, 0xb9, 0xf3, 0x0a, 0xf3, 0x8b, 0xe4, 0x48, 0x59, 0x8d, 0x41, 0x3a, 0x17, 0x2e, 0xfb, 0x80, 0x2c, 0x21, 0xac, 0xf1, 0xc1, 0x1c, 0x52, 0x0c, 0x2f, 0x26, 0xa4, 0x71, 0xdc, 0xad, 0x21, 0x2e, 0xac, 0x7c, 0xa3, 0x9d, 
};
static const u8 rsa_oaep_7_CRT_q[] = {
0xcc, 0x88, 0x53, 0xd1, 0xd5, 0x4d, 0xa6, 0x30, 0xfa, 0xc0, 0x04, 0xf4, 0x71, 0xf2, 0x81, 0xc7, 0xb8, 0x98, 0x2d, 0x82, 0x24, 0xa4, 0x90, 0xed, 0xbe, 0xb3, 0x3d, 0x3e, 0x3d, 0x5c, 0xc9, 0x3c, 0x47, 0x65, 0x70, 0x3d, 0x1d, 0xd7, 0x91, 0x64, 0x2f, 0x1f, 0x11, 0x6a, 0x0d, 0xd8, 0x52, 0xbe, 0x24, 0x19, 0xb2, 0xaf, 0x72, 0xbf, 0xe9, 0xa0, 0x30, 0xe8, 0x60, 0xb0, 0x28, 0x8b, 0x5d, 0x77, 
};
static const u8 rsa_oaep_7_CRT_dP[] = {
0x0e, 0x12, 0xbf, 0x17, 0x18, 0xe9, 0xce, 0xf5, 0x59, 0x9b, 0xa1, 0xc3, 0x88, 0x2f, 0xe8, 0x04, 0x6a, 0x90, 0x87, 0x4e, 0xef, 0xce, 0x8f, 0x2c, 0xcc, 0x20, 0xe4, 0xf2, 0x74, 0x1f, 0xb0, 0xa3, 0x3a, 0x38, 0x48, 0xae, 0xc9, 0xc9, 0x30, 0x5f, 0xbe, 0xcb, 0xd2, 0xd7, 0x68, 0x19, 0x96, 0x7d, 0x46, 0x71, 0xac, 0xc6, 0x43, 0x1e, 0x40, 0x37, 0x96, 0x8d, 0xb3, 0x78, 0x78, 0xe6, 0x95, 0xc1, 
};
static const u8 rsa_oaep_7_CRT_dQ[] = {
0x95, 0x29, 0x7b, 0x0f, 0x95, 0xa2, 0xfa, 0x67, 0xd0, 0x07, 0x07, 0xd6, 0x09, 0xdf, 0xd4, 0xfc, 0x05, 0xc8, 0x9d, 0xaf, 0xc2, 0xef, 0x6d, 0x6e, 0xa5, 0x5b, 0xec, 0x77, 0x1e, 0xa3, 0x33, 0x73, 0x4d, 0x92, 0x51, 0xe7, 0x90, 0x82, 0xec, 0xda, 0x86, 0x6e, 0xfe, 0xf1, 0x3c, 0x45, 0x9e, 0x1a, 0x63, 0x13, 0x86, 0xb7, 0xe3, 0x54, 0xc8, 0x99, 0xf5, 0xf1, 0x12, 0xca, 0x85, 0xd7, 0x15, 0x83, 
};
static const u8 rsa_oaep_7_CRT_qInv[] = {
0x4f, 0x45, 0x6c, 0x50, 0x24, 0x93, 0xbd, 0xc0, 0xed, 0x2a, 0xb7, 0x56, 0xa3, 0xa6, 0xed, 0x4d, 0x67, 0x35, 0x2a, 0x69, 0x7d, 0x42, 0x16, 0xe9, 0x32, 0x12, 0xb1, 0x27, 0xa6, 0x3d, 0x54, 0x11, 0xce, 0x6f, 0xa9, 0x8d, 0x5d, 0xbe, 0xfd, 0x73, 0x26, 0x3e, 0x37, 0x28, 0x14, 0x27, 0x43, 0x81, 0x81, 0x66, 0xed, 0x7d, 0xd6, 0x36, 0x87, 0xdd, 0x2a, 0x8c, 0xa1, 0xd2, 0xf4, 0xfb, 0xd8, 0xe1, 
};


static const rsa_test test_rsa_oaep_7_CRT = {
	.name = "rsa_oaep_7_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_7_CRT_n,
	.nlen = sizeof(rsa_oaep_7_CRT_n),
	.d = (const u8*)&rsa_oaep_7_CRT_d,
	.dlen = sizeof(rsa_oaep_7_CRT_d),
	.e = (const u8*)&rsa_oaep_7_CRT_e,
	.elen = sizeof(rsa_oaep_7_CRT_e),
	.p = (const u8*)&rsa_oaep_7_CRT_p,
	.plen = sizeof(rsa_oaep_7_CRT_p),
	.q = (const u8*)&rsa_oaep_7_CRT_q,
	.qlen = sizeof(rsa_oaep_7_CRT_q),
	.dP = (const u8*)&rsa_oaep_7_CRT_dP,
	.dPlen = sizeof(rsa_oaep_7_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_7_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_7_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_7_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_7_CRT_qInv),
	.m = (const u8*)&rsa_oaep_7_CRT_m,
	.mlen = sizeof(rsa_oaep_7_CRT_m),
	.res = (const u8*)&rsa_oaep_7_CRT_res,
	.reslen = sizeof(rsa_oaep_7_CRT_res),
	.salt = (const u8*)&rsa_oaep_7_CRT_salt,
	.saltlen = sizeof(rsa_oaep_7_CRT_salt),
};
static const u8 rsa_oaep_8_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_8_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_8_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_8_m[] = {
0x8d, 0xa8, 0x9f, 0xd9, 0xe5, 0xf9, 0x74, 0xa2, 0x9f, 0xef, 0xfb, 0x46, 0x2b, 0x49, 0x18, 0x0f, 0x6c, 0xf9, 0xe8, 0x02, 
};
static const u8 rsa_oaep_8_res[] = {
0x36, 0xf6, 0xe3, 0x4d, 0x94, 0xa8, 0xd3, 0x4d, 0xaa, 0xcb, 0xa3, 0x3a, 0x21, 0x39, 0xd0, 0x0a, 0xd8, 0x5a, 0x93, 0x45, 0xa8, 0x60, 0x51, 0xe7, 0x30, 0x71, 0x62, 0x00, 0x56, 0xb9, 0x20, 0xe2, 0x19, 0x00, 0x58, 0x55, 0xa2, 0x13, 0xa0, 0xf2, 0x38, 0x97, 0xcd, 0xcd, 0x73, 0x1b, 0x45, 0x25, 0x7c, 0x77, 0x7f, 0xe9, 0x08, 0x20, 0x2b, 0xef, 0xdd, 0x0b, 0x58, 0x38, 0x6b, 0x12, 0x44, 0xea, 0x0c, 0xf5, 0x39, 0xa0, 0x5d, 0x5d, 0x10, 0x32, 0x9d, 0xa4, 0x4e, 0x13, 0x03, 0x0f, 0xd7, 0x60, 0xdc, 0xd6, 0x44, 0xcf, 0xef, 0x20, 0x94, 0xd1, 0x91, 0x0d, 0x3f, 0x43, 0x3e, 0x1c, 0x7c, 0x6d, 0xd1, 0x8b, 0xc1, 0xf2, 0xdf, 0x7f, 0x64, 0x3d, 0x66, 0x2f, 0xb9, 0xdd, 0x37, 0xea, 0xd9, 0x05, 0x91, 0x90, 0xf4, 0xfa, 0x66, 0xca, 0x39, 0xe8, 0x69, 0xc4, 0xeb, 0x44, 0x9c, 0xbd, 0xc4, 0x39, 
};
static const u8 rsa_oaep_8_salt[] = {
0xb3, 0x18, 0xc4, 0x2d, 0xf3, 0xbe, 0x0f, 0x83, 0xfe, 0xa8, 0x23, 0xf5, 0xa7, 0xb4, 0x7e, 0xd5, 0xe4, 0x25, 0xa3, 0xb5, 
};


static const rsa_test test_rsa_oaep_8 = {
	.name = "rsa_oaep_8",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_8_n,
	.nlen = sizeof(rsa_oaep_8_n),
	.d = (const u8*)&rsa_oaep_8_d,
	.dlen = sizeof(rsa_oaep_8_d),
	.e = (const u8*)&rsa_oaep_8_e,
	.elen = sizeof(rsa_oaep_8_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_8_m,
	.mlen = sizeof(rsa_oaep_8_m),
	.res = (const u8*)&rsa_oaep_8_res,
	.reslen = sizeof(rsa_oaep_8_res),
	.salt = (const u8*)&rsa_oaep_8_salt,
	.saltlen = sizeof(rsa_oaep_8_salt),
};
static const u8 rsa_oaep_9_CRT_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_9_CRT_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_9_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_9_CRT_m[] = {
0x8d, 0xa8, 0x9f, 0xd9, 0xe5, 0xf9, 0x74, 0xa2, 0x9f, 0xef, 0xfb, 0x46, 0x2b, 0x49, 0x18, 0x0f, 0x6c, 0xf9, 0xe8, 0x02, 
};
static const u8 rsa_oaep_9_CRT_res[] = {
0x36, 0xf6, 0xe3, 0x4d, 0x94, 0xa8, 0xd3, 0x4d, 0xaa, 0xcb, 0xa3, 0x3a, 0x21, 0x39, 0xd0, 0x0a, 0xd8, 0x5a, 0x93, 0x45, 0xa8, 0x60, 0x51, 0xe7, 0x30, 0x71, 0x62, 0x00, 0x56, 0xb9, 0x20, 0xe2, 0x19, 0x00, 0x58, 0x55, 0xa2, 0x13, 0xa0, 0xf2, 0x38, 0x97, 0xcd, 0xcd, 0x73, 0x1b, 0x45, 0x25, 0x7c, 0x77, 0x7f, 0xe9, 0x08, 0x20, 0x2b, 0xef, 0xdd, 0x0b, 0x58, 0x38, 0x6b, 0x12, 0x44, 0xea, 0x0c, 0xf5, 0x39, 0xa0, 0x5d, 0x5d, 0x10, 0x32, 0x9d, 0xa4, 0x4e, 0x13, 0x03, 0x0f, 0xd7, 0x60, 0xdc, 0xd6, 0x44, 0xcf, 0xef, 0x20, 0x94, 0xd1, 0x91, 0x0d, 0x3f, 0x43, 0x3e, 0x1c, 0x7c, 0x6d, 0xd1, 0x8b, 0xc1, 0xf2, 0xdf, 0x7f, 0x64, 0x3d, 0x66, 0x2f, 0xb9, 0xdd, 0x37, 0xea, 0xd9, 0x05, 0x91, 0x90, 0xf4, 0xfa, 0x66, 0xca, 0x39, 0xe8, 0x69, 0xc4, 0xeb, 0x44, 0x9c, 0xbd, 0xc4, 0x39, 
};
static const u8 rsa_oaep_9_CRT_salt[] = {
0xb3, 0x18, 0xc4, 0x2d, 0xf3, 0xbe, 0x0f, 0x83, 0xfe, 0xa8, 0x23, 0xf5, 0xa7, 0xb4, 0x7e, 0xd5, 0xe4, 0x25, 0xa3, 0xb5, 
};
static const u8 rsa_oaep_9_CRT_p[] = {
0xd3, 0x27, 0x37, 0xe7, 0x26, 0x7f, 0xfe, 0x13, 0x41, 0xb2, 0xd5, 0xc0, 0xd1, 0x50, 0xa8, 0x1b, 0x58, 0x6f, 0xb3, 0x13, 0x2b, 0xed, 0x2f, 0x8d, 0x52, 0x62, 0x86, 0x4a, 0x9c, 0xb9, 0xf3, 0x0a, 0xf3, 0x8b, 0xe4, 0x48, 0x59, 0x8d, 0x41, 0x3a, 0x17, 0x2e, 0xfb, 0x80, 0x2c, 0x21, 0xac, 0xf1, 0xc1, 0x1c, 0x52, 0x0c, 0x2f, 0x26, 0xa4, 0x71, 0xdc, 0xad, 0x21, 0x2e, 0xac, 0x7c, 0xa3, 0x9d, 
};
static const u8 rsa_oaep_9_CRT_q[] = {
0xcc, 0x88, 0x53, 0xd1, 0xd5, 0x4d, 0xa6, 0x30, 0xfa, 0xc0, 0x04, 0xf4, 0x71, 0xf2, 0x81, 0xc7, 0xb8, 0x98, 0x2d, 0x82, 0x24, 0xa4, 0x90, 0xed, 0xbe, 0xb3, 0x3d, 0x3e, 0x3d, 0x5c, 0xc9, 0x3c, 0x47, 0x65, 0x70, 0x3d, 0x1d, 0xd7, 0x91, 0x64, 0x2f, 0x1f, 0x11, 0x6a, 0x0d, 0xd8, 0x52, 0xbe, 0x24, 0x19, 0xb2, 0xaf, 0x72, 0xbf, 0xe9, 0xa0, 0x30, 0xe8, 0x60, 0xb0, 0x28, 0x8b, 0x5d, 0x77, 
};
static const u8 rsa_oaep_9_CRT_dP[] = {
0x0e, 0x12, 0xbf, 0x17, 0x18, 0xe9, 0xce, 0xf5, 0x59, 0x9b, 0xa1, 0xc3, 0x88, 0x2f, 0xe8, 0x04, 0x6a, 0x90, 0x87, 0x4e, 0xef, 0xce, 0x8f, 0x2c, 0xcc, 0x20, 0xe4, 0xf2, 0x74, 0x1f, 0xb0, 0xa3, 0x3a, 0x38, 0x48, 0xae, 0xc9, 0xc9, 0x30, 0x5f, 0xbe, 0xcb, 0xd2, 0xd7, 0x68, 0x19, 0x96, 0x7d, 0x46, 0x71, 0xac, 0xc6, 0x43, 0x1e, 0x40, 0x37, 0x96, 0x8d, 0xb3, 0x78, 0x78, 0xe6, 0x95, 0xc1, 
};
static const u8 rsa_oaep_9_CRT_dQ[] = {
0x95, 0x29, 0x7b, 0x0f, 0x95, 0xa2, 0xfa, 0x67, 0xd0, 0x07, 0x07, 0xd6, 0x09, 0xdf, 0xd4, 0xfc, 0x05, 0xc8, 0x9d, 0xaf, 0xc2, 0xef, 0x6d, 0x6e, 0xa5, 0x5b, 0xec, 0x77, 0x1e, 0xa3, 0x33, 0x73, 0x4d, 0x92, 0x51, 0xe7, 0x90, 0x82, 0xec, 0xda, 0x86, 0x6e, 0xfe, 0xf1, 0x3c, 0x45, 0x9e, 0x1a, 0x63, 0x13, 0x86, 0xb7, 0xe3, 0x54, 0xc8, 0x99, 0xf5, 0xf1, 0x12, 0xca, 0x85, 0xd7, 0x15, 0x83, 
};
static const u8 rsa_oaep_9_CRT_qInv[] = {
0x4f, 0x45, 0x6c, 0x50, 0x24, 0x93, 0xbd, 0xc0, 0xed, 0x2a, 0xb7, 0x56, 0xa3, 0xa6, 0xed, 0x4d, 0x67, 0x35, 0x2a, 0x69, 0x7d, 0x42, 0x16, 0xe9, 0x32, 0x12, 0xb1, 0x27, 0xa6, 0x3d, 0x54, 0x11, 0xce, 0x6f, 0xa9, 0x8d, 0x5d, 0xbe, 0xfd, 0x73, 0x26, 0x3e, 0x37, 0x28, 0x14, 0x27, 0x43, 0x81, 0x81, 0x66, 0xed, 0x7d, 0xd6, 0x36, 0x87, 0xdd, 0x2a, 0x8c, 0xa1, 0xd2, 0xf4, 0xfb, 0xd8, 0xe1, 
};


static const rsa_test test_rsa_oaep_9_CRT = {
	.name = "rsa_oaep_9_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_9_CRT_n,
	.nlen = sizeof(rsa_oaep_9_CRT_n),
	.d = (const u8*)&rsa_oaep_9_CRT_d,
	.dlen = sizeof(rsa_oaep_9_CRT_d),
	.e = (const u8*)&rsa_oaep_9_CRT_e,
	.elen = sizeof(rsa_oaep_9_CRT_e),
	.p = (const u8*)&rsa_oaep_9_CRT_p,
	.plen = sizeof(rsa_oaep_9_CRT_p),
	.q = (const u8*)&rsa_oaep_9_CRT_q,
	.qlen = sizeof(rsa_oaep_9_CRT_q),
	.dP = (const u8*)&rsa_oaep_9_CRT_dP,
	.dPlen = sizeof(rsa_oaep_9_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_9_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_9_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_9_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_9_CRT_qInv),
	.m = (const u8*)&rsa_oaep_9_CRT_m,
	.mlen = sizeof(rsa_oaep_9_CRT_m),
	.res = (const u8*)&rsa_oaep_9_CRT_res,
	.reslen = sizeof(rsa_oaep_9_CRT_res),
	.salt = (const u8*)&rsa_oaep_9_CRT_salt,
	.saltlen = sizeof(rsa_oaep_9_CRT_salt),
};
static const u8 rsa_oaep_10_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_10_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_10_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_10_m[] = {
0x26, 0x52, 0x10, 0x50, 0x84, 0x42, 0x71, 
};
static const u8 rsa_oaep_10_res[] = {
0x42, 0xce, 0xe2, 0x61, 0x7b, 0x1e, 0xce, 0xa4, 0xdb, 0x3f, 0x48, 0x29, 0x38, 0x6f, 0xbd, 0x61, 0xda, 0xfb, 0xf0, 0x38, 0xe1, 0x80, 0xd8, 0x37, 0xc9, 0x63, 0x66, 0xdf, 0x24, 0xc0, 0x97, 0xb4, 0xab, 0x0f, 0xac, 0x6b, 0xdf, 0x59, 0x0d, 0x82, 0x1c, 0x9f, 0x10, 0x64, 0x2e, 0x68, 0x1a, 0xd0, 0x5b, 0x8d, 0x78, 0xb3, 0x78, 0xc0, 0xf4, 0x6c, 0xe2, 0xfa, 0xd6, 0x3f, 0x74, 0xe0, 0xad, 0x3d, 0xf0, 0x6b, 0x07, 0x5d, 0x7e, 0xb5, 0xf5, 0x63, 0x6f, 0x8d, 0x40, 0x3b, 0x90, 0x59, 0xca, 0x76, 0x1b, 0x5c, 0x62, 0xbb, 0x52, 0xaa, 0x45, 0x00, 0x2e, 0xa7, 0x0b, 0xaa, 0xce, 0x08, 0xde, 0xd2, 0x43, 0xb9, 0xd8, 0xcb, 0xd6, 0x2a, 0x68, 0xad, 0xe2, 0x65, 0x83, 0x2b, 0x56, 0x56, 0x4e, 0x43, 0xa6, 0xfa, 0x42, 0xed, 0x19, 0x9a, 0x09, 0x97, 0x69, 0x74, 0x2d, 0xf1, 0x53, 0x9e, 0x82, 0x55, 
};
static const u8 rsa_oaep_10_salt[] = {
0xe4, 0xec, 0x09, 0x82, 0xc2, 0x33, 0x6f, 0x3a, 0x67, 0x7f, 0x6a, 0x35, 0x61, 0x74, 0xeb, 0x0c, 0xe8, 0x87, 0xab, 0xc2, 
};


static const rsa_test test_rsa_oaep_10 = {
	.name = "rsa_oaep_10",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_10_n,
	.nlen = sizeof(rsa_oaep_10_n),
	.d = (const u8*)&rsa_oaep_10_d,
	.dlen = sizeof(rsa_oaep_10_d),
	.e = (const u8*)&rsa_oaep_10_e,
	.elen = sizeof(rsa_oaep_10_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_10_m,
	.mlen = sizeof(rsa_oaep_10_m),
	.res = (const u8*)&rsa_oaep_10_res,
	.reslen = sizeof(rsa_oaep_10_res),
	.salt = (const u8*)&rsa_oaep_10_salt,
	.saltlen = sizeof(rsa_oaep_10_salt),
};
static const u8 rsa_oaep_11_CRT_n[] = {
0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb, 
};
static const u8 rsa_oaep_11_CRT_d[] = {
0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1, 
};
static const u8 rsa_oaep_11_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_11_CRT_m[] = {
0x26, 0x52, 0x10, 0x50, 0x84, 0x42, 0x71, 
};
static const u8 rsa_oaep_11_CRT_res[] = {
0x42, 0xce, 0xe2, 0x61, 0x7b, 0x1e, 0xce, 0xa4, 0xdb, 0x3f, 0x48, 0x29, 0x38, 0x6f, 0xbd, 0x61, 0xda, 0xfb, 0xf0, 0x38, 0xe1, 0x80, 0xd8, 0x37, 0xc9, 0x63, 0x66, 0xdf, 0x24, 0xc0, 0x97, 0xb4, 0xab, 0x0f, 0xac, 0x6b, 0xdf, 0x59, 0x0d, 0x82, 0x1c, 0x9f, 0x10, 0x64, 0x2e, 0x68, 0x1a, 0xd0, 0x5b, 0x8d, 0x78, 0xb3, 0x78, 0xc0, 0xf4, 0x6c, 0xe2, 0xfa, 0xd6, 0x3f, 0x74, 0xe0, 0xad, 0x3d, 0xf0, 0x6b, 0x07, 0x5d, 0x7e, 0xb5, 0xf5, 0x63, 0x6f, 0x8d, 0x40, 0x3b, 0x90, 0x59, 0xca, 0x76, 0x1b, 0x5c, 0x62, 0xbb, 0x52, 0xaa, 0x45, 0x00, 0x2e, 0xa7, 0x0b, 0xaa, 0xce, 0x08, 0xde, 0xd2, 0x43, 0xb9, 0xd8, 0xcb, 0xd6, 0x2a, 0x68, 0xad, 0xe2, 0x65, 0x83, 0x2b, 0x56, 0x56, 0x4e, 0x43, 0xa6, 0xfa, 0x42, 0xed, 0x19, 0x9a, 0x09, 0x97, 0x69, 0x74, 0x2d, 0xf1, 0x53, 0x9e, 0x82, 0x55, 
};
static const u8 rsa_oaep_11_CRT_salt[] = {
0xe4, 0xec, 0x09, 0x82, 0xc2, 0x33, 0x6f, 0x3a, 0x67, 0x7f, 0x6a, 0x35, 0x61, 0x74, 0xeb, 0x0c, 0xe8, 0x87, 0xab, 0xc2, 
};
static const u8 rsa_oaep_11_CRT_p[] = {
0xd3, 0x27, 0x37, 0xe7, 0x26, 0x7f, 0xfe, 0x13, 0x41, 0xb2, 0xd5, 0xc0, 0xd1, 0x50, 0xa8, 0x1b, 0x58, 0x6f, 0xb3, 0x13, 0x2b, 0xed, 0x2f, 0x8d, 0x52, 0x62, 0x86, 0x4a, 0x9c, 0xb9, 0xf3, 0x0a, 0xf3, 0x8b, 0xe4, 0x48, 0x59, 0x8d, 0x41, 0x3a, 0x17, 0x2e, 0xfb, 0x80, 0x2c, 0x21, 0xac, 0xf1, 0xc1, 0x1c, 0x52, 0x0c, 0x2f, 0x26, 0xa4, 0x71, 0xdc, 0xad, 0x21, 0x2e, 0xac, 0x7c, 0xa3, 0x9d, 
};
static const u8 rsa_oaep_11_CRT_q[] = {
0xcc, 0x88, 0x53, 0xd1, 0xd5, 0x4d, 0xa6, 0x30, 0xfa, 0xc0, 0x04, 0xf4, 0x71, 0xf2, 0x81, 0xc7, 0xb8, 0x98, 0x2d, 0x82, 0x24, 0xa4, 0x90, 0xed, 0xbe, 0xb3, 0x3d, 0x3e, 0x3d, 0x5c, 0xc9, 0x3c, 0x47, 0x65, 0x70, 0x3d, 0x1d, 0xd7, 0x91, 0x64, 0x2f, 0x1f, 0x11, 0x6a, 0x0d, 0xd8, 0x52, 0xbe, 0x24, 0x19, 0xb2, 0xaf, 0x72, 0xbf, 0xe9, 0xa0, 0x30, 0xe8, 0x60, 0xb0, 0x28, 0x8b, 0x5d, 0x77, 
};
static const u8 rsa_oaep_11_CRT_dP[] = {
0x0e, 0x12, 0xbf, 0x17, 0x18, 0xe9, 0xce, 0xf5, 0x59, 0x9b, 0xa1, 0xc3, 0x88, 0x2f, 0xe8, 0x04, 0x6a, 0x90, 0x87, 0x4e, 0xef, 0xce, 0x8f, 0x2c, 0xcc, 0x20, 0xe4, 0xf2, 0x74, 0x1f, 0xb0, 0xa3, 0x3a, 0x38, 0x48, 0xae, 0xc9, 0xc9, 0x30, 0x5f, 0xbe, 0xcb, 0xd2, 0xd7, 0x68, 0x19, 0x96, 0x7d, 0x46, 0x71, 0xac, 0xc6, 0x43, 0x1e, 0x40, 0x37, 0x96, 0x8d, 0xb3, 0x78, 0x78, 0xe6, 0x95, 0xc1, 
};
static const u8 rsa_oaep_11_CRT_dQ[] = {
0x95, 0x29, 0x7b, 0x0f, 0x95, 0xa2, 0xfa, 0x67, 0xd0, 0x07, 0x07, 0xd6, 0x09, 0xdf, 0xd4, 0xfc, 0x05, 0xc8, 0x9d, 0xaf, 0xc2, 0xef, 0x6d, 0x6e, 0xa5, 0x5b, 0xec, 0x77, 0x1e, 0xa3, 0x33, 0x73, 0x4d, 0x92, 0x51, 0xe7, 0x90, 0x82, 0xec, 0xda, 0x86, 0x6e, 0xfe, 0xf1, 0x3c, 0x45, 0x9e, 0x1a, 0x63, 0x13, 0x86, 0xb7, 0xe3, 0x54, 0xc8, 0x99, 0xf5, 0xf1, 0x12, 0xca, 0x85, 0xd7, 0x15, 0x83, 
};
static const u8 rsa_oaep_11_CRT_qInv[] = {
0x4f, 0x45, 0x6c, 0x50, 0x24, 0x93, 0xbd, 0xc0, 0xed, 0x2a, 0xb7, 0x56, 0xa3, 0xa6, 0xed, 0x4d, 0x67, 0x35, 0x2a, 0x69, 0x7d, 0x42, 0x16, 0xe9, 0x32, 0x12, 0xb1, 0x27, 0xa6, 0x3d, 0x54, 0x11, 0xce, 0x6f, 0xa9, 0x8d, 0x5d, 0xbe, 0xfd, 0x73, 0x26, 0x3e, 0x37, 0x28, 0x14, 0x27, 0x43, 0x81, 0x81, 0x66, 0xed, 0x7d, 0xd6, 0x36, 0x87, 0xdd, 0x2a, 0x8c, 0xa1, 0xd2, 0xf4, 0xfb, 0xd8, 0xe1, 
};


static const rsa_test test_rsa_oaep_11_CRT = {
	.name = "rsa_oaep_11_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_11_CRT_n,
	.nlen = sizeof(rsa_oaep_11_CRT_n),
	.d = (const u8*)&rsa_oaep_11_CRT_d,
	.dlen = sizeof(rsa_oaep_11_CRT_d),
	.e = (const u8*)&rsa_oaep_11_CRT_e,
	.elen = sizeof(rsa_oaep_11_CRT_e),
	.p = (const u8*)&rsa_oaep_11_CRT_p,
	.plen = sizeof(rsa_oaep_11_CRT_p),
	.q = (const u8*)&rsa_oaep_11_CRT_q,
	.qlen = sizeof(rsa_oaep_11_CRT_q),
	.dP = (const u8*)&rsa_oaep_11_CRT_dP,
	.dPlen = sizeof(rsa_oaep_11_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_11_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_11_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_11_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_11_CRT_qInv),
	.m = (const u8*)&rsa_oaep_11_CRT_m,
	.mlen = sizeof(rsa_oaep_11_CRT_m),
	.res = (const u8*)&rsa_oaep_11_CRT_res,
	.reslen = sizeof(rsa_oaep_11_CRT_res),
	.salt = (const u8*)&rsa_oaep_11_CRT_salt,
	.saltlen = sizeof(rsa_oaep_11_CRT_salt),
};
static const u8 rsa_oaep_12_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_12_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_12_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_12_m[] = {
0x8f, 0xf0, 0x0c, 0xaa, 0x60, 0x5c, 0x70, 0x28, 0x30, 0x63, 0x4d, 0x9a, 0x6c, 0x3d, 0x42, 0xc6, 0x52, 0xb5, 0x8c, 0xf1, 0xd9, 0x2f, 0xec, 0x57, 0x0b, 0xee, 0xe7, 
};
static const u8 rsa_oaep_12_res[] = {
0x01, 0x81, 0xaf, 0x89, 0x22, 0xb9, 0xfc, 0xb4, 0xd7, 0x9d, 0x92, 0xeb, 0xe1, 0x98, 0x15, 0x99, 0x2f, 0xc0, 0xc1, 0x43, 0x9d, 0x8b, 0xcd, 0x49, 0x13, 0x98, 0xa0, 0xf4, 0xad, 0x3a, 0x32, 0x9a, 0x5b, 0xd9, 0x38, 0x55, 0x60, 0xdb, 0x53, 0x26, 0x83, 0xc8, 0xb7, 0xda, 0x04, 0xe4, 0xb1, 0x2a, 0xed, 0x6a, 0xac, 0xdf, 0x47, 0x1c, 0x34, 0xc9, 0xcd, 0xa8, 0x91, 0xad, 0xdc, 0xc2, 0xdf, 0x34, 0x56, 0x65, 0x3a, 0xa6, 0x38, 0x2e, 0x9a, 0xe5, 0x9b, 0x54, 0x45, 0x52, 0x57, 0xeb, 0x09, 0x9d, 0x56, 0x2b, 0xbe, 0x10, 0x45, 0x3f, 0x2b, 0x6d, 0x13, 0xc5, 0x9c, 0x02, 0xe1, 0x0f, 0x1f, 0x8a, 0xbb, 0x5d, 0xa0, 0xd0, 0x57, 0x09, 0x32, 0xda, 0xcf, 0x2d, 0x09, 0x01, 0xdb, 0x72, 0x9d, 0x0f, 0xef, 0xcc, 0x05, 0x4e, 0x70, 0x96, 0x8e, 0xa5, 0x40, 0xc8, 0x1b, 0x04, 0xbc, 0xae, 0xfe, 0x72, 0x0e, 
};
static const u8 rsa_oaep_12_salt[] = {
0x8c, 0x40, 0x7b, 0x5e, 0xc2, 0x89, 0x9e, 0x50, 0x99, 0xc5, 0x3e, 0x8c, 0xe7, 0x93, 0xbf, 0x94, 0xe7, 0x1b, 0x17, 0x82, 
};


static const rsa_test test_rsa_oaep_12 = {
	.name = "rsa_oaep_12",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_12_n,
	.nlen = sizeof(rsa_oaep_12_n),
	.d = (const u8*)&rsa_oaep_12_d,
	.dlen = sizeof(rsa_oaep_12_d),
	.e = (const u8*)&rsa_oaep_12_e,
	.elen = sizeof(rsa_oaep_12_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_12_m,
	.mlen = sizeof(rsa_oaep_12_m),
	.res = (const u8*)&rsa_oaep_12_res,
	.reslen = sizeof(rsa_oaep_12_res),
	.salt = (const u8*)&rsa_oaep_12_salt,
	.saltlen = sizeof(rsa_oaep_12_salt),
};
static const u8 rsa_oaep_13_CRT_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_13_CRT_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_13_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_13_CRT_m[] = {
0x8f, 0xf0, 0x0c, 0xaa, 0x60, 0x5c, 0x70, 0x28, 0x30, 0x63, 0x4d, 0x9a, 0x6c, 0x3d, 0x42, 0xc6, 0x52, 0xb5, 0x8c, 0xf1, 0xd9, 0x2f, 0xec, 0x57, 0x0b, 0xee, 0xe7, 
};
static const u8 rsa_oaep_13_CRT_res[] = {
0x01, 0x81, 0xaf, 0x89, 0x22, 0xb9, 0xfc, 0xb4, 0xd7, 0x9d, 0x92, 0xeb, 0xe1, 0x98, 0x15, 0x99, 0x2f, 0xc0, 0xc1, 0x43, 0x9d, 0x8b, 0xcd, 0x49, 0x13, 0x98, 0xa0, 0xf4, 0xad, 0x3a, 0x32, 0x9a, 0x5b, 0xd9, 0x38, 0x55, 0x60, 0xdb, 0x53, 0x26, 0x83, 0xc8, 0xb7, 0xda, 0x04, 0xe4, 0xb1, 0x2a, 0xed, 0x6a, 0xac, 0xdf, 0x47, 0x1c, 0x34, 0xc9, 0xcd, 0xa8, 0x91, 0xad, 0xdc, 0xc2, 0xdf, 0x34, 0x56, 0x65, 0x3a, 0xa6, 0x38, 0x2e, 0x9a, 0xe5, 0x9b, 0x54, 0x45, 0x52, 0x57, 0xeb, 0x09, 0x9d, 0x56, 0x2b, 0xbe, 0x10, 0x45, 0x3f, 0x2b, 0x6d, 0x13, 0xc5, 0x9c, 0x02, 0xe1, 0x0f, 0x1f, 0x8a, 0xbb, 0x5d, 0xa0, 0xd0, 0x57, 0x09, 0x32, 0xda, 0xcf, 0x2d, 0x09, 0x01, 0xdb, 0x72, 0x9d, 0x0f, 0xef, 0xcc, 0x05, 0x4e, 0x70, 0x96, 0x8e, 0xa5, 0x40, 0xc8, 0x1b, 0x04, 0xbc, 0xae, 0xfe, 0x72, 0x0e, 
};
static const u8 rsa_oaep_13_CRT_salt[] = {
0x8c, 0x40, 0x7b, 0x5e, 0xc2, 0x89, 0x9e, 0x50, 0x99, 0xc5, 0x3e, 0x8c, 0xe7, 0x93, 0xbf, 0x94, 0xe7, 0x1b, 0x17, 0x82, 
};
static const u8 rsa_oaep_13_CRT_p[] = {
0x01, 0x59, 0xdb, 0xde, 0x04, 0xa3, 0x3e, 0xf0, 0x6f, 0xb6, 0x08, 0xb8, 0x0b, 0x19, 0x0f, 0x4d, 0x3e, 0x22, 0xbc, 0xc1, 0x3a, 0xc8, 0xe4, 0xa0, 0x81, 0x03, 0x3a, 0xbf, 0xa4, 0x16, 0xed, 0xb0, 0xb3, 0x38, 0xaa, 0x08, 0xb5, 0x73, 0x09, 0xea, 0x5a, 0x52, 0x40, 0xe7, 0xdc, 0x6e, 0x54, 0x37, 0x8c, 0x69, 0x41, 0x4c, 0x31, 0xd9, 0x7d, 0xdb, 0x1f, 0x40, 0x6d, 0xb3, 0x76, 0x9c, 0xc4, 0x1a, 0x43, 
};
static const u8 rsa_oaep_13_CRT_q[] = {
0x01, 0x2b, 0x65, 0x2f, 0x30, 0x40, 0x3b, 0x38, 0xb4, 0x09, 0x95, 0xfd, 0x6f, 0xf4, 0x1a, 0x1a, 0xcc, 0x8a, 0xda, 0x70, 0x37, 0x32, 0x36, 0xb7, 0x20, 0x2d, 0x39, 0xb2, 0xee, 0x30, 0xcf, 0xb4, 0x6d, 0xb0, 0x95, 0x11, 0xf6, 0xf3, 0x07, 0xcc, 0x61, 0xcc, 0x21, 0x60, 0x6c, 0x18, 0xa7, 0x5b, 0x8a, 0x62, 0xf8, 0x22, 0xdf, 0x03, 0x1b, 0xa0, 0xdf, 0x0d, 0xaf, 0xd5, 0x50, 0x6f, 0x56, 0x8b, 0xd7, 
};
static const u8 rsa_oaep_13_CRT_dP[] = {
0x43, 0x6e, 0xf5, 0x08, 0xde, 0x73, 0x65, 0x19, 0xc2, 0xda, 0x4c, 0x58, 0x0d, 0x98, 0xc8, 0x2c, 0xb7, 0x45, 0x2a, 0x3f, 0xb5, 0xef, 0xad, 0xc3, 0xb9, 0xc7, 0x78, 0x9a, 0x1b, 0xc6, 0x58, 0x4f, 0x79, 0x5a, 0xdd, 0xbb, 0xd3, 0x24, 0x39, 0xc7, 0x46, 0x86, 0x55, 0x2e, 0xcb, 0x6c, 0x2c, 0x30, 0x7a, 0x4d, 0x3a, 0xf7, 0xf5, 0x39, 0xee, 0xc1, 0x57, 0x24, 0x8c, 0x7b, 0x31, 0xf1, 0xa2, 0x55, 
};
static const u8 rsa_oaep_13_CRT_dQ[] = {
0x01, 0x2b, 0x15, 0xa8, 0x9f, 0x3d, 0xfb, 0x2b, 0x39, 0x07, 0x3e, 0x73, 0xf0, 0x2b, 0xdd, 0x0c, 0x1a, 0x7b, 0x37, 0x9d, 0xd4, 0x35, 0xf0, 0x5c, 0xdd, 0xe2, 0xef, 0xf9, 0xe4, 0x62, 0x94, 0x8b, 0x7c, 0xec, 0x62, 0xee, 0x90, 0x50, 0xd5, 0xe0, 0x81, 0x6e, 0x07, 0x85, 0xa8, 0x56, 0xb4, 0x91, 0x08, 0xdc, 0xb7, 0x5f, 0x36, 0x83, 0x87, 0x4d, 0x1c, 0xa6, 0x32, 0x9a, 0x19, 0x01, 0x30, 0x66, 0xff, 
};
static const u8 rsa_oaep_13_CRT_qInv[] = {
0x02, 0x70, 0xdb, 0x17, 0xd5, 0x91, 0x4b, 0x01, 0x8d, 0x76, 0x11, 0x8b, 0x24, 0x38, 0x9a, 0x73, 0x50, 0xec, 0x83, 0x6b, 0x00, 0x63, 0xa2, 0x17, 0x21, 0x23, 0x6f, 0xd8, 0xed, 0xb6, 0xd8, 0x9b, 0x51, 0xe7, 0xee, 0xb8, 0x7b, 0x61, 0x1b, 0x71, 0x32, 0xcb, 0x7e, 0xa7, 0x35, 0x6c, 0x23, 0x15, 0x1c, 0x1e, 0x77, 0x51, 0x50, 0x7c, 0x78, 0x6d, 0x9e, 0xe1, 0x79, 0x41, 0x70, 0xa8, 0xc8, 0xe8, 
};


static const rsa_test test_rsa_oaep_13_CRT = {
	.name = "rsa_oaep_13_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_13_CRT_n,
	.nlen = sizeof(rsa_oaep_13_CRT_n),
	.d = (const u8*)&rsa_oaep_13_CRT_d,
	.dlen = sizeof(rsa_oaep_13_CRT_d),
	.e = (const u8*)&rsa_oaep_13_CRT_e,
	.elen = sizeof(rsa_oaep_13_CRT_e),
	.p = (const u8*)&rsa_oaep_13_CRT_p,
	.plen = sizeof(rsa_oaep_13_CRT_p),
	.q = (const u8*)&rsa_oaep_13_CRT_q,
	.qlen = sizeof(rsa_oaep_13_CRT_q),
	.dP = (const u8*)&rsa_oaep_13_CRT_dP,
	.dPlen = sizeof(rsa_oaep_13_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_13_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_13_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_13_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_13_CRT_qInv),
	.m = (const u8*)&rsa_oaep_13_CRT_m,
	.mlen = sizeof(rsa_oaep_13_CRT_m),
	.res = (const u8*)&rsa_oaep_13_CRT_res,
	.reslen = sizeof(rsa_oaep_13_CRT_res),
	.salt = (const u8*)&rsa_oaep_13_CRT_salt,
	.saltlen = sizeof(rsa_oaep_13_CRT_salt),
};
static const u8 rsa_oaep_14_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_14_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_14_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_14_m[] = {
0x2d, 
};
static const u8 rsa_oaep_14_res[] = {
0x01, 0x87, 0x59, 0xff, 0x1d, 0xf6, 0x3b, 0x27, 0x92, 0x41, 0x05, 0x62, 0x31, 0x44, 0x16, 0xa8, 0xae, 0xaf, 0x2a, 0xc6, 0x34, 0xb4, 0x6f, 0x94, 0x0a, 0xb8, 0x2d, 0x64, 0xdb, 0xf1, 0x65, 0xee, 0xe3, 0x30, 0x11, 0xda, 0x74, 0x9d, 0x4b, 0xab, 0x6e, 0x2f, 0xcd, 0x18, 0x12, 0x9c, 0x9e, 0x49, 0x27, 0x7d, 0x84, 0x53, 0x11, 0x2b, 0x42, 0x9a, 0x22, 0x2a, 0x84, 0x71, 0xb0, 0x70, 0x99, 0x39, 0x98, 0xe7, 0x58, 0x86, 0x1c, 0x4d, 0x3f, 0x6d, 0x74, 0x9d, 0x91, 0xc4, 0x29, 0x0d, 0x33, 0x2c, 0x7a, 0x4a, 0xb3, 0xf7, 0xea, 0x35, 0xff, 0x3a, 0x07, 0xd4, 0x97, 0xc9, 0x55, 0xff, 0x0f, 0xfc, 0x95, 0x00, 0x6b, 0x62, 0xc6, 0xd2, 0x96, 0x81, 0x0d, 0x9b, 0xfa, 0xb0, 0x24, 0x19, 0x6c, 0x79, 0x34, 0x01, 0x2c, 0x2d, 0xf9, 0x78, 0xef, 0x29, 0x9a, 0xba, 0x23, 0x99, 0x40, 0xcb, 0xa1, 0x02, 0x45, 
};
static const u8 rsa_oaep_14_salt[] = {
0xb6, 0x00, 0xcf, 0x3c, 0x2e, 0x50, 0x6d, 0x7f, 0x16, 0x77, 0x8c, 0x91, 0x0d, 0x3a, 0x8b, 0x00, 0x3e, 0xee, 0x61, 0xd5, 
};


static const rsa_test test_rsa_oaep_14 = {
	.name = "rsa_oaep_14",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_14_n,
	.nlen = sizeof(rsa_oaep_14_n),
	.d = (const u8*)&rsa_oaep_14_d,
	.dlen = sizeof(rsa_oaep_14_d),
	.e = (const u8*)&rsa_oaep_14_e,
	.elen = sizeof(rsa_oaep_14_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_14_m,
	.mlen = sizeof(rsa_oaep_14_m),
	.res = (const u8*)&rsa_oaep_14_res,
	.reslen = sizeof(rsa_oaep_14_res),
	.salt = (const u8*)&rsa_oaep_14_salt,
	.saltlen = sizeof(rsa_oaep_14_salt),
};
static const u8 rsa_oaep_15_CRT_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_15_CRT_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_15_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_15_CRT_m[] = {
0x2d, 
};
static const u8 rsa_oaep_15_CRT_res[] = {
0x01, 0x87, 0x59, 0xff, 0x1d, 0xf6, 0x3b, 0x27, 0x92, 0x41, 0x05, 0x62, 0x31, 0x44, 0x16, 0xa8, 0xae, 0xaf, 0x2a, 0xc6, 0x34, 0xb4, 0x6f, 0x94, 0x0a, 0xb8, 0x2d, 0x64, 0xdb, 0xf1, 0x65, 0xee, 0xe3, 0x30, 0x11, 0xda, 0x74, 0x9d, 0x4b, 0xab, 0x6e, 0x2f, 0xcd, 0x18, 0x12, 0x9c, 0x9e, 0x49, 0x27, 0x7d, 0x84, 0x53, 0x11, 0x2b, 0x42, 0x9a, 0x22, 0x2a, 0x84, 0x71, 0xb0, 0x70, 0x99, 0x39, 0x98, 0xe7, 0x58, 0x86, 0x1c, 0x4d, 0x3f, 0x6d, 0x74, 0x9d, 0x91, 0xc4, 0x29, 0x0d, 0x33, 0x2c, 0x7a, 0x4a, 0xb3, 0xf7, 0xea, 0x35, 0xff, 0x3a, 0x07, 0xd4, 0x97, 0xc9, 0x55, 0xff, 0x0f, 0xfc, 0x95, 0x00, 0x6b, 0x62, 0xc6, 0xd2, 0x96, 0x81, 0x0d, 0x9b, 0xfa, 0xb0, 0x24, 0x19, 0x6c, 0x79, 0x34, 0x01, 0x2c, 0x2d, 0xf9, 0x78, 0xef, 0x29, 0x9a, 0xba, 0x23, 0x99, 0x40, 0xcb, 0xa1, 0x02, 0x45, 
};
static const u8 rsa_oaep_15_CRT_salt[] = {
0xb6, 0x00, 0xcf, 0x3c, 0x2e, 0x50, 0x6d, 0x7f, 0x16, 0x77, 0x8c, 0x91, 0x0d, 0x3a, 0x8b, 0x00, 0x3e, 0xee, 0x61, 0xd5, 
};
static const u8 rsa_oaep_15_CRT_p[] = {
0x01, 0x59, 0xdb, 0xde, 0x04, 0xa3, 0x3e, 0xf0, 0x6f, 0xb6, 0x08, 0xb8, 0x0b, 0x19, 0x0f, 0x4d, 0x3e, 0x22, 0xbc, 0xc1, 0x3a, 0xc8, 0xe4, 0xa0, 0x81, 0x03, 0x3a, 0xbf, 0xa4, 0x16, 0xed, 0xb0, 0xb3, 0x38, 0xaa, 0x08, 0xb5, 0x73, 0x09, 0xea, 0x5a, 0x52, 0x40, 0xe7, 0xdc, 0x6e, 0x54, 0x37, 0x8c, 0x69, 0x41, 0x4c, 0x31, 0xd9, 0x7d, 0xdb, 0x1f, 0x40, 0x6d, 0xb3, 0x76, 0x9c, 0xc4, 0x1a, 0x43, 
};
static const u8 rsa_oaep_15_CRT_q[] = {
0x01, 0x2b, 0x65, 0x2f, 0x30, 0x40, 0x3b, 0x38, 0xb4, 0x09, 0x95, 0xfd, 0x6f, 0xf4, 0x1a, 0x1a, 0xcc, 0x8a, 0xda, 0x70, 0x37, 0x32, 0x36, 0xb7, 0x20, 0x2d, 0x39, 0xb2, 0xee, 0x30, 0xcf, 0xb4, 0x6d, 0xb0, 0x95, 0x11, 0xf6, 0xf3, 0x07, 0xcc, 0x61, 0xcc, 0x21, 0x60, 0x6c, 0x18, 0xa7, 0x5b, 0x8a, 0x62, 0xf8, 0x22, 0xdf, 0x03, 0x1b, 0xa0, 0xdf, 0x0d, 0xaf, 0xd5, 0x50, 0x6f, 0x56, 0x8b, 0xd7, 
};
static const u8 rsa_oaep_15_CRT_dP[] = {
0x43, 0x6e, 0xf5, 0x08, 0xde, 0x73, 0x65, 0x19, 0xc2, 0xda, 0x4c, 0x58, 0x0d, 0x98, 0xc8, 0x2c, 0xb7, 0x45, 0x2a, 0x3f, 0xb5, 0xef, 0xad, 0xc3, 0xb9, 0xc7, 0x78, 0x9a, 0x1b, 0xc6, 0x58, 0x4f, 0x79, 0x5a, 0xdd, 0xbb, 0xd3, 0x24, 0x39, 0xc7, 0x46, 0x86, 0x55, 0x2e, 0xcb, 0x6c, 0x2c, 0x30, 0x7a, 0x4d, 0x3a, 0xf7, 0xf5, 0x39, 0xee, 0xc1, 0x57, 0x24, 0x8c, 0x7b, 0x31, 0xf1, 0xa2, 0x55, 
};
static const u8 rsa_oaep_15_CRT_dQ[] = {
0x01, 0x2b, 0x15, 0xa8, 0x9f, 0x3d, 0xfb, 0x2b, 0x39, 0x07, 0x3e, 0x73, 0xf0, 0x2b, 0xdd, 0x0c, 0x1a, 0x7b, 0x37, 0x9d, 0xd4, 0x35, 0xf0, 0x5c, 0xdd, 0xe2, 0xef, 0xf9, 0xe4, 0x62, 0x94, 0x8b, 0x7c, 0xec, 0x62, 0xee, 0x90, 0x50, 0xd5, 0xe0, 0x81, 0x6e, 0x07, 0x85, 0xa8, 0x56, 0xb4, 0x91, 0x08, 0xdc, 0xb7, 0x5f, 0x36, 0x83, 0x87, 0x4d, 0x1c, 0xa6, 0x32, 0x9a, 0x19, 0x01, 0x30, 0x66, 0xff, 
};
static const u8 rsa_oaep_15_CRT_qInv[] = {
0x02, 0x70, 0xdb, 0x17, 0xd5, 0x91, 0x4b, 0x01, 0x8d, 0x76, 0x11, 0x8b, 0x24, 0x38, 0x9a, 0x73, 0x50, 0xec, 0x83, 0x6b, 0x00, 0x63, 0xa2, 0x17, 0x21, 0x23, 0x6f, 0xd8, 0xed, 0xb6, 0xd8, 0x9b, 0x51, 0xe7, 0xee, 0xb8, 0x7b, 0x61, 0x1b, 0x71, 0x32, 0xcb, 0x7e, 0xa7, 0x35, 0x6c, 0x23, 0x15, 0x1c, 0x1e, 0x77, 0x51, 0x50, 0x7c, 0x78, 0x6d, 0x9e, 0xe1, 0x79, 0x41, 0x70, 0xa8, 0xc8, 0xe8, 
};


static const rsa_test test_rsa_oaep_15_CRT = {
	.name = "rsa_oaep_15_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_15_CRT_n,
	.nlen = sizeof(rsa_oaep_15_CRT_n),
	.d = (const u8*)&rsa_oaep_15_CRT_d,
	.dlen = sizeof(rsa_oaep_15_CRT_d),
	.e = (const u8*)&rsa_oaep_15_CRT_e,
	.elen = sizeof(rsa_oaep_15_CRT_e),
	.p = (const u8*)&rsa_oaep_15_CRT_p,
	.plen = sizeof(rsa_oaep_15_CRT_p),
	.q = (const u8*)&rsa_oaep_15_CRT_q,
	.qlen = sizeof(rsa_oaep_15_CRT_q),
	.dP = (const u8*)&rsa_oaep_15_CRT_dP,
	.dPlen = sizeof(rsa_oaep_15_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_15_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_15_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_15_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_15_CRT_qInv),
	.m = (const u8*)&rsa_oaep_15_CRT_m,
	.mlen = sizeof(rsa_oaep_15_CRT_m),
	.res = (const u8*)&rsa_oaep_15_CRT_res,
	.reslen = sizeof(rsa_oaep_15_CRT_res),
	.salt = (const u8*)&rsa_oaep_15_CRT_salt,
	.saltlen = sizeof(rsa_oaep_15_CRT_salt),
};
static const u8 rsa_oaep_16_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_16_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_16_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_16_m[] = {
0x74, 0xfc, 0x88, 0xc5, 0x1b, 0xc9, 0x0f, 0x77, 0xaf, 0x9d, 0x5e, 0x9a, 0x4a, 0x70, 0x13, 0x3d, 0x4b, 0x4e, 0x0b, 0x34, 0xda, 0x3c, 0x37, 0xc7, 0xef, 0x8e, 
};
static const u8 rsa_oaep_16_res[] = {
0x01, 0x88, 0x02, 0xba, 0xb0, 0x4c, 0x60, 0x32, 0x5e, 0x81, 0xc4, 0x96, 0x23, 0x11, 0xf2, 0xbe, 0x7c, 0x2a, 0xdc, 0xe9, 0x30, 0x41, 0xa0, 0x07, 0x19, 0xc8, 0x8f, 0x95, 0x75, 0x75, 0xf2, 0xc7, 0x9f, 0x1b, 0x7b, 0xc8, 0xce, 0xd1, 0x15, 0xc7, 0x06, 0xb3, 0x11, 0xc0, 0x8a, 0x2d, 0x98, 0x6c, 0xa3, 0xb6, 0xa9, 0x33, 0x6b, 0x14, 0x7c, 0x29, 0xc6, 0xf2, 0x29, 0x40, 0x9d, 0xde, 0xc6, 0x51, 0xbd, 0x1f, 0xdd, 0x5a, 0x0b, 0x7f, 0x61, 0x0c, 0x99, 0x37, 0xfd, 0xb4, 0xa3, 0xa7, 0x62, 0x36, 0x4b, 0x8b, 0x32, 0x06, 0xb4, 0xea, 0x48, 0x5f, 0xd0, 0x98, 0xd0, 0x8f, 0x63, 0xd4, 0xaa, 0x8b, 0xb2, 0x69, 0x7d, 0x02, 0x7b, 0x75, 0x0c, 0x32, 0xd7, 0xf7, 0x4e, 0xaf, 0x51, 0x80, 0xd2, 0xe9, 0xb6, 0x6b, 0x17, 0xcb, 0x2f, 0xa5, 0x55, 0x23, 0xbc, 0x28, 0x0d, 0xa1, 0x0d, 0x14, 0xbe, 0x20, 0x53, 
};
static const u8 rsa_oaep_16_salt[] = {
0xa7, 0x37, 0x68, 0xae, 0xea, 0xa9, 0x1f, 0x9d, 0x8c, 0x1e, 0xd6, 0xf9, 0xd2, 0xb6, 0x34, 0x67, 0xf0, 0x7c, 0xca, 0xe3, 
};


static const rsa_test test_rsa_oaep_16 = {
	.name = "rsa_oaep_16",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_16_n,
	.nlen = sizeof(rsa_oaep_16_n),
	.d = (const u8*)&rsa_oaep_16_d,
	.dlen = sizeof(rsa_oaep_16_d),
	.e = (const u8*)&rsa_oaep_16_e,
	.elen = sizeof(rsa_oaep_16_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_16_m,
	.mlen = sizeof(rsa_oaep_16_m),
	.res = (const u8*)&rsa_oaep_16_res,
	.reslen = sizeof(rsa_oaep_16_res),
	.salt = (const u8*)&rsa_oaep_16_salt,
	.saltlen = sizeof(rsa_oaep_16_salt),
};
static const u8 rsa_oaep_17_CRT_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_17_CRT_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_17_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_17_CRT_m[] = {
0x74, 0xfc, 0x88, 0xc5, 0x1b, 0xc9, 0x0f, 0x77, 0xaf, 0x9d, 0x5e, 0x9a, 0x4a, 0x70, 0x13, 0x3d, 0x4b, 0x4e, 0x0b, 0x34, 0xda, 0x3c, 0x37, 0xc7, 0xef, 0x8e, 
};
static const u8 rsa_oaep_17_CRT_res[] = {
0x01, 0x88, 0x02, 0xba, 0xb0, 0x4c, 0x60, 0x32, 0x5e, 0x81, 0xc4, 0x96, 0x23, 0x11, 0xf2, 0xbe, 0x7c, 0x2a, 0xdc, 0xe9, 0x30, 0x41, 0xa0, 0x07, 0x19, 0xc8, 0x8f, 0x95, 0x75, 0x75, 0xf2, 0xc7, 0x9f, 0x1b, 0x7b, 0xc8, 0xce, 0xd1, 0x15, 0xc7, 0x06, 0xb3, 0x11, 0xc0, 0x8a, 0x2d, 0x98, 0x6c, 0xa3, 0xb6, 0xa9, 0x33, 0x6b, 0x14, 0x7c, 0x29, 0xc6, 0xf2, 0x29, 0x40, 0x9d, 0xde, 0xc6, 0x51, 0xbd, 0x1f, 0xdd, 0x5a, 0x0b, 0x7f, 0x61, 0x0c, 0x99, 0x37, 0xfd, 0xb4, 0xa3, 0xa7, 0x62, 0x36, 0x4b, 0x8b, 0x32, 0x06, 0xb4, 0xea, 0x48, 0x5f, 0xd0, 0x98, 0xd0, 0x8f, 0x63, 0xd4, 0xaa, 0x8b, 0xb2, 0x69, 0x7d, 0x02, 0x7b, 0x75, 0x0c, 0x32, 0xd7, 0xf7, 0x4e, 0xaf, 0x51, 0x80, 0xd2, 0xe9, 0xb6, 0x6b, 0x17, 0xcb, 0x2f, 0xa5, 0x55, 0x23, 0xbc, 0x28, 0x0d, 0xa1, 0x0d, 0x14, 0xbe, 0x20, 0x53, 
};
static const u8 rsa_oaep_17_CRT_salt[] = {
0xa7, 0x37, 0x68, 0xae, 0xea, 0xa9, 0x1f, 0x9d, 0x8c, 0x1e, 0xd6, 0xf9, 0xd2, 0xb6, 0x34, 0x67, 0xf0, 0x7c, 0xca, 0xe3, 
};
static const u8 rsa_oaep_17_CRT_p[] = {
0x01, 0x59, 0xdb, 0xde, 0x04, 0xa3, 0x3e, 0xf0, 0x6f, 0xb6, 0x08, 0xb8, 0x0b, 0x19, 0x0f, 0x4d, 0x3e, 0x22, 0xbc, 0xc1, 0x3a, 0xc8, 0xe4, 0xa0, 0x81, 0x03, 0x3a, 0xbf, 0xa4, 0x16, 0xed, 0xb0, 0xb3, 0x38, 0xaa, 0x08, 0xb5, 0x73, 0x09, 0xea, 0x5a, 0x52, 0x40, 0xe7, 0xdc, 0x6e, 0x54, 0x37, 0x8c, 0x69, 0x41, 0x4c, 0x31, 0xd9, 0x7d, 0xdb, 0x1f, 0x40, 0x6d, 0xb3, 0x76, 0x9c, 0xc4, 0x1a, 0x43, 
};
static const u8 rsa_oaep_17_CRT_q[] = {
0x01, 0x2b, 0x65, 0x2f, 0x30, 0x40, 0x3b, 0x38, 0xb4, 0x09, 0x95, 0xfd, 0x6f, 0xf4, 0x1a, 0x1a, 0xcc, 0x8a, 0xda, 0x70, 0x37, 0x32, 0x36, 0xb7, 0x20, 0x2d, 0x39, 0xb2, 0xee, 0x30, 0xcf, 0xb4, 0x6d, 0xb0, 0x95, 0x11, 0xf6, 0xf3, 0x07, 0xcc, 0x61, 0xcc, 0x21, 0x60, 0x6c, 0x18, 0xa7, 0x5b, 0x8a, 0x62, 0xf8, 0x22, 0xdf, 0x03, 0x1b, 0xa0, 0xdf, 0x0d, 0xaf, 0xd5, 0x50, 0x6f, 0x56, 0x8b, 0xd7, 
};
static const u8 rsa_oaep_17_CRT_dP[] = {
0x43, 0x6e, 0xf5, 0x08, 0xde, 0x73, 0x65, 0x19, 0xc2, 0xda, 0x4c, 0x58, 0x0d, 0x98, 0xc8, 0x2c, 0xb7, 0x45, 0x2a, 0x3f, 0xb5, 0xef, 0xad, 0xc3, 0xb9, 0xc7, 0x78, 0x9a, 0x1b, 0xc6, 0x58, 0x4f, 0x79, 0x5a, 0xdd, 0xbb, 0xd3, 0x24, 0x39, 0xc7, 0x46, 0x86, 0x55, 0x2e, 0xcb, 0x6c, 0x2c, 0x30, 0x7a, 0x4d, 0x3a, 0xf7, 0xf5, 0x39, 0xee, 0xc1, 0x57, 0x24, 0x8c, 0x7b, 0x31, 0xf1, 0xa2, 0x55, 
};
static const u8 rsa_oaep_17_CRT_dQ[] = {
0x01, 0x2b, 0x15, 0xa8, 0x9f, 0x3d, 0xfb, 0x2b, 0x39, 0x07, 0x3e, 0x73, 0xf0, 0x2b, 0xdd, 0x0c, 0x1a, 0x7b, 0x37, 0x9d, 0xd4, 0x35, 0xf0, 0x5c, 0xdd, 0xe2, 0xef, 0xf9, 0xe4, 0x62, 0x94, 0x8b, 0x7c, 0xec, 0x62, 0xee, 0x90, 0x50, 0xd5, 0xe0, 0x81, 0x6e, 0x07, 0x85, 0xa8, 0x56, 0xb4, 0x91, 0x08, 0xdc, 0xb7, 0x5f, 0x36, 0x83, 0x87, 0x4d, 0x1c, 0xa6, 0x32, 0x9a, 0x19, 0x01, 0x30, 0x66, 0xff, 
};
static const u8 rsa_oaep_17_CRT_qInv[] = {
0x02, 0x70, 0xdb, 0x17, 0xd5, 0x91, 0x4b, 0x01, 0x8d, 0x76, 0x11, 0x8b, 0x24, 0x38, 0x9a, 0x73, 0x50, 0xec, 0x83, 0x6b, 0x00, 0x63, 0xa2, 0x17, 0x21, 0x23, 0x6f, 0xd8, 0xed, 0xb6, 0xd8, 0x9b, 0x51, 0xe7, 0xee, 0xb8, 0x7b, 0x61, 0x1b, 0x71, 0x32, 0xcb, 0x7e, 0xa7, 0x35, 0x6c, 0x23, 0x15, 0x1c, 0x1e, 0x77, 0x51, 0x50, 0x7c, 0x78, 0x6d, 0x9e, 0xe1, 0x79, 0x41, 0x70, 0xa8, 0xc8, 0xe8, 
};


static const rsa_test test_rsa_oaep_17_CRT = {
	.name = "rsa_oaep_17_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_17_CRT_n,
	.nlen = sizeof(rsa_oaep_17_CRT_n),
	.d = (const u8*)&rsa_oaep_17_CRT_d,
	.dlen = sizeof(rsa_oaep_17_CRT_d),
	.e = (const u8*)&rsa_oaep_17_CRT_e,
	.elen = sizeof(rsa_oaep_17_CRT_e),
	.p = (const u8*)&rsa_oaep_17_CRT_p,
	.plen = sizeof(rsa_oaep_17_CRT_p),
	.q = (const u8*)&rsa_oaep_17_CRT_q,
	.qlen = sizeof(rsa_oaep_17_CRT_q),
	.dP = (const u8*)&rsa_oaep_17_CRT_dP,
	.dPlen = sizeof(rsa_oaep_17_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_17_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_17_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_17_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_17_CRT_qInv),
	.m = (const u8*)&rsa_oaep_17_CRT_m,
	.mlen = sizeof(rsa_oaep_17_CRT_m),
	.res = (const u8*)&rsa_oaep_17_CRT_res,
	.reslen = sizeof(rsa_oaep_17_CRT_res),
	.salt = (const u8*)&rsa_oaep_17_CRT_salt,
	.saltlen = sizeof(rsa_oaep_17_CRT_salt),
};
static const u8 rsa_oaep_18_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_18_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_18_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_18_m[] = {
0xa7, 0xeb, 0x2a, 0x50, 0x36, 0x93, 0x1d, 0x27, 0xd4, 0xe8, 0x91, 0x32, 0x6d, 0x99, 0x69, 0x2f, 0xfa, 0xdd, 0xa9, 0xbf, 0x7e, 0xfd, 0x3e, 0x34, 0xe6, 0x22, 0xc4, 0xad, 0xc0, 0x85, 0xf7, 0x21, 0xdf, 0xe8, 0x85, 0x07, 0x2c, 0x78, 0xa2, 0x03, 0xb1, 0x51, 0x73, 0x9b, 0xe5, 0x40, 0xfa, 0x8c, 0x15, 0x3a, 0x10, 0xf0, 0x0a, 
};
static const u8 rsa_oaep_18_res[] = {
0x00, 0xa4, 0x57, 0x8c, 0xbc, 0x17, 0x63, 0x18, 0xa6, 0x38, 0xfb, 0xa7, 0xd0, 0x1d, 0xf1, 0x57, 0x46, 0xaf, 0x44, 0xd4, 0xf6, 0xcd, 0x96, 0xd7, 0xe7, 0xc4, 0x95, 0xcb, 0xf4, 0x25, 0xb0, 0x9c, 0x64, 0x9d, 0x32, 0xbf, 0x88, 0x6d, 0xa4, 0x8f, 0xba, 0xf9, 0x89, 0xa2, 0x11, 0x71, 0x87, 0xca, 0xfb, 0x1f, 0xb5, 0x80, 0x31, 0x76, 0x90, 0xe3, 0xcc, 0xd4, 0x46, 0x92, 0x0b, 0x7a, 0xf8, 0x2b, 0x31, 0xdb, 0x58, 0x04, 0xd8, 0x7d, 0x01, 0x51, 0x4a, 0xcb, 0xfa, 0x91, 0x56, 0xe7, 0x82, 0xf8, 0x67, 0xf6, 0xbe, 0xd9, 0x44, 0x9e, 0x0e, 0x9a, 0x2c, 0x09, 0xbc, 0xec, 0xc6, 0xaa, 0x08, 0x76, 0x36, 0x96, 0x5e, 0x34, 0xb3, 0xec, 0x76, 0x6f, 0x2f, 0xe2, 0xe4, 0x30, 0x18, 0xa2, 0xfd, 0xde, 0xb1, 0x40, 0x61, 0x6a, 0x0e, 0x9d, 0x82, 0xe5, 0x33, 0x10, 0x24, 0xee, 0x06, 0x52, 0xfc, 0x76, 0x41, 
};
static const u8 rsa_oaep_18_salt[] = {
0x9a, 0x7b, 0x3b, 0x0e, 0x70, 0x8b, 0xd9, 0x6f, 0x81, 0x90, 0xec, 0xab, 0x4f, 0xb9, 0xb2, 0xb3, 0x80, 0x5a, 0x81, 0x56, 
};


static const rsa_test test_rsa_oaep_18 = {
	.name = "rsa_oaep_18",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_18_n,
	.nlen = sizeof(rsa_oaep_18_n),
	.d = (const u8*)&rsa_oaep_18_d,
	.dlen = sizeof(rsa_oaep_18_d),
	.e = (const u8*)&rsa_oaep_18_e,
	.elen = sizeof(rsa_oaep_18_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_18_m,
	.mlen = sizeof(rsa_oaep_18_m),
	.res = (const u8*)&rsa_oaep_18_res,
	.reslen = sizeof(rsa_oaep_18_res),
	.salt = (const u8*)&rsa_oaep_18_salt,
	.saltlen = sizeof(rsa_oaep_18_salt),
};
static const u8 rsa_oaep_19_CRT_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_19_CRT_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_19_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_19_CRT_m[] = {
0xa7, 0xeb, 0x2a, 0x50, 0x36, 0x93, 0x1d, 0x27, 0xd4, 0xe8, 0x91, 0x32, 0x6d, 0x99, 0x69, 0x2f, 0xfa, 0xdd, 0xa9, 0xbf, 0x7e, 0xfd, 0x3e, 0x34, 0xe6, 0x22, 0xc4, 0xad, 0xc0, 0x85, 0xf7, 0x21, 0xdf, 0xe8, 0x85, 0x07, 0x2c, 0x78, 0xa2, 0x03, 0xb1, 0x51, 0x73, 0x9b, 0xe5, 0x40, 0xfa, 0x8c, 0x15, 0x3a, 0x10, 0xf0, 0x0a, 
};
static const u8 rsa_oaep_19_CRT_res[] = {
0x00, 0xa4, 0x57, 0x8c, 0xbc, 0x17, 0x63, 0x18, 0xa6, 0x38, 0xfb, 0xa7, 0xd0, 0x1d, 0xf1, 0x57, 0x46, 0xaf, 0x44, 0xd4, 0xf6, 0xcd, 0x96, 0xd7, 0xe7, 0xc4, 0x95, 0xcb, 0xf4, 0x25, 0xb0, 0x9c, 0x64, 0x9d, 0x32, 0xbf, 0x88, 0x6d, 0xa4, 0x8f, 0xba, 0xf9, 0x89, 0xa2, 0x11, 0x71, 0x87, 0xca, 0xfb, 0x1f, 0xb5, 0x80, 0x31, 0x76, 0x90, 0xe3, 0xcc, 0xd4, 0x46, 0x92, 0x0b, 0x7a, 0xf8, 0x2b, 0x31, 0xdb, 0x58, 0x04, 0xd8, 0x7d, 0x01, 0x51, 0x4a, 0xcb, 0xfa, 0x91, 0x56, 0xe7, 0x82, 0xf8, 0x67, 0xf6, 0xbe, 0xd9, 0x44, 0x9e, 0x0e, 0x9a, 0x2c, 0x09, 0xbc, 0xec, 0xc6, 0xaa, 0x08, 0x76, 0x36, 0x96, 0x5e, 0x34, 0xb3, 0xec, 0x76, 0x6f, 0x2f, 0xe2, 0xe4, 0x30, 0x18, 0xa2, 0xfd, 0xde, 0xb1, 0x40, 0x61, 0x6a, 0x0e, 0x9d, 0x82, 0xe5, 0x33, 0x10, 0x24, 0xee, 0x06, 0x52, 0xfc, 0x76, 0x41, 
};
static const u8 rsa_oaep_19_CRT_salt[] = {
0x9a, 0x7b, 0x3b, 0x0e, 0x70, 0x8b, 0xd9, 0x6f, 0x81, 0x90, 0xec, 0xab, 0x4f, 0xb9, 0xb2, 0xb3, 0x80, 0x5a, 0x81, 0x56, 
};
static const u8 rsa_oaep_19_CRT_p[] = {
0x01, 0x59, 0xdb, 0xde, 0x04, 0xa3, 0x3e, 0xf0, 0x6f, 0xb6, 0x08, 0xb8, 0x0b, 0x19, 0x0f, 0x4d, 0x3e, 0x22, 0xbc, 0xc1, 0x3a, 0xc8, 0xe4, 0xa0, 0x81, 0x03, 0x3a, 0xbf, 0xa4, 0x16, 0xed, 0xb0, 0xb3, 0x38, 0xaa, 0x08, 0xb5, 0x73, 0x09, 0xea, 0x5a, 0x52, 0x40, 0xe7, 0xdc, 0x6e, 0x54, 0x37, 0x8c, 0x69, 0x41, 0x4c, 0x31, 0xd9, 0x7d, 0xdb, 0x1f, 0x40, 0x6d, 0xb3, 0x76, 0x9c, 0xc4, 0x1a, 0x43, 
};
static const u8 rsa_oaep_19_CRT_q[] = {
0x01, 0x2b, 0x65, 0x2f, 0x30, 0x40, 0x3b, 0x38, 0xb4, 0x09, 0x95, 0xfd, 0x6f, 0xf4, 0x1a, 0x1a, 0xcc, 0x8a, 0xda, 0x70, 0x37, 0x32, 0x36, 0xb7, 0x20, 0x2d, 0x39, 0xb2, 0xee, 0x30, 0xcf, 0xb4, 0x6d, 0xb0, 0x95, 0x11, 0xf6, 0xf3, 0x07, 0xcc, 0x61, 0xcc, 0x21, 0x60, 0x6c, 0x18, 0xa7, 0x5b, 0x8a, 0x62, 0xf8, 0x22, 0xdf, 0x03, 0x1b, 0xa0, 0xdf, 0x0d, 0xaf, 0xd5, 0x50, 0x6f, 0x56, 0x8b, 0xd7, 
};
static const u8 rsa_oaep_19_CRT_dP[] = {
0x43, 0x6e, 0xf5, 0x08, 0xde, 0x73, 0x65, 0x19, 0xc2, 0xda, 0x4c, 0x58, 0x0d, 0x98, 0xc8, 0x2c, 0xb7, 0x45, 0x2a, 0x3f, 0xb5, 0xef, 0xad, 0xc3, 0xb9, 0xc7, 0x78, 0x9a, 0x1b, 0xc6, 0x58, 0x4f, 0x79, 0x5a, 0xdd, 0xbb, 0xd3, 0x24, 0x39, 0xc7, 0x46, 0x86, 0x55, 0x2e, 0xcb, 0x6c, 0x2c, 0x30, 0x7a, 0x4d, 0x3a, 0xf7, 0xf5, 0x39, 0xee, 0xc1, 0x57, 0x24, 0x8c, 0x7b, 0x31, 0xf1, 0xa2, 0x55, 
};
static const u8 rsa_oaep_19_CRT_dQ[] = {
0x01, 0x2b, 0x15, 0xa8, 0x9f, 0x3d, 0xfb, 0x2b, 0x39, 0x07, 0x3e, 0x73, 0xf0, 0x2b, 0xdd, 0x0c, 0x1a, 0x7b, 0x37, 0x9d, 0xd4, 0x35, 0xf0, 0x5c, 0xdd, 0xe2, 0xef, 0xf9, 0xe4, 0x62, 0x94, 0x8b, 0x7c, 0xec, 0x62, 0xee, 0x90, 0x50, 0xd5, 0xe0, 0x81, 0x6e, 0x07, 0x85, 0xa8, 0x56, 0xb4, 0x91, 0x08, 0xdc, 0xb7, 0x5f, 0x36, 0x83, 0x87, 0x4d, 0x1c, 0xa6, 0x32, 0x9a, 0x19, 0x01, 0x30, 0x66, 0xff, 
};
static const u8 rsa_oaep_19_CRT_qInv[] = {
0x02, 0x70, 0xdb, 0x17, 0xd5, 0x91, 0x4b, 0x01, 0x8d, 0x76, 0x11, 0x8b, 0x24, 0x38, 0x9a, 0x73, 0x50, 0xec, 0x83, 0x6b, 0x00, 0x63, 0xa2, 0x17, 0x21, 0x23, 0x6f, 0xd8, 0xed, 0xb6, 0xd8, 0x9b, 0x51, 0xe7, 0xee, 0xb8, 0x7b, 0x61, 0x1b, 0x71, 0x32, 0xcb, 0x7e, 0xa7, 0x35, 0x6c, 0x23, 0x15, 0x1c, 0x1e, 0x77, 0x51, 0x50, 0x7c, 0x78, 0x6d, 0x9e, 0xe1, 0x79, 0x41, 0x70, 0xa8, 0xc8, 0xe8, 
};


static const rsa_test test_rsa_oaep_19_CRT = {
	.name = "rsa_oaep_19_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_19_CRT_n,
	.nlen = sizeof(rsa_oaep_19_CRT_n),
	.d = (const u8*)&rsa_oaep_19_CRT_d,
	.dlen = sizeof(rsa_oaep_19_CRT_d),
	.e = (const u8*)&rsa_oaep_19_CRT_e,
	.elen = sizeof(rsa_oaep_19_CRT_e),
	.p = (const u8*)&rsa_oaep_19_CRT_p,
	.plen = sizeof(rsa_oaep_19_CRT_p),
	.q = (const u8*)&rsa_oaep_19_CRT_q,
	.qlen = sizeof(rsa_oaep_19_CRT_q),
	.dP = (const u8*)&rsa_oaep_19_CRT_dP,
	.dPlen = sizeof(rsa_oaep_19_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_19_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_19_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_19_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_19_CRT_qInv),
	.m = (const u8*)&rsa_oaep_19_CRT_m,
	.mlen = sizeof(rsa_oaep_19_CRT_m),
	.res = (const u8*)&rsa_oaep_19_CRT_res,
	.reslen = sizeof(rsa_oaep_19_CRT_res),
	.salt = (const u8*)&rsa_oaep_19_CRT_salt,
	.saltlen = sizeof(rsa_oaep_19_CRT_salt),
};
static const u8 rsa_oaep_20_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_20_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_20_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_20_m[] = {
0x2e, 0xf2, 0xb0, 0x66, 0xf8, 0x54, 0xc3, 0x3f, 0x3b, 0xdc, 0xbb, 0x59, 0x94, 0xa4, 0x35, 0xe7, 0x3d, 0x6c, 0x6c, 
};
static const u8 rsa_oaep_20_res[] = {
0x00, 0xeb, 0xc5, 0xf5, 0xfd, 0xa7, 0x7c, 0xfd, 0xad, 0x3c, 0x83, 0x64, 0x1a, 0x90, 0x25, 0xe7, 0x7d, 0x72, 0xd8, 0xa6, 0xfb, 0x33, 0xa8, 0x10, 0xf5, 0x95, 0x0f, 0x8d, 0x74, 0xc7, 0x3e, 0x8d, 0x93, 0x1e, 0x86, 0x34, 0xd8, 0x6a, 0xb1, 0x24, 0x62, 0x56, 0xae, 0x07, 0xb6, 0x00, 0x5b, 0x71, 0xb7, 0xf2, 0xfb, 0x98, 0x35, 0x12, 0x18, 0x33, 0x1c, 0xe6, 0x9b, 0x8f, 0xfb, 0xdc, 0x9d, 0xa0, 0x8b, 0xbc, 0x9c, 0x70, 0x4f, 0x87, 0x6d, 0xeb, 0x9d, 0xf9, 0xfc, 0x2e, 0xc0, 0x65, 0xca, 0xd8, 0x7f, 0x90, 0x90, 0xb0, 0x7a, 0xcc, 0x17, 0xaa, 0x7f, 0x99, 0x7b, 0x27, 0xac, 0xa4, 0x88, 0x06, 0xe8, 0x97, 0xf7, 0x71, 0xd9, 0x51, 0x41, 0xfe, 0x45, 0x26, 0xd8, 0xa5, 0x30, 0x1b, 0x67, 0x86, 0x27, 0xef, 0xab, 0x70, 0x7f, 0xd4, 0x0f, 0xbe, 0xbd, 0x6e, 0x79, 0x2a, 0x25, 0x61, 0x3e, 0x7a, 0xec, 
};
static const u8 rsa_oaep_20_salt[] = {
0xeb, 0x3c, 0xeb, 0xbc, 0x4a, 0xdc, 0x16, 0xbb, 0x48, 0xe8, 0x8c, 0x8a, 0xec, 0x0e, 0x34, 0xaf, 0x7f, 0x42, 0x7f, 0xd3, 
};


static const rsa_test test_rsa_oaep_20 = {
	.name = "rsa_oaep_20",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_20_n,
	.nlen = sizeof(rsa_oaep_20_n),
	.d = (const u8*)&rsa_oaep_20_d,
	.dlen = sizeof(rsa_oaep_20_d),
	.e = (const u8*)&rsa_oaep_20_e,
	.elen = sizeof(rsa_oaep_20_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_20_m,
	.mlen = sizeof(rsa_oaep_20_m),
	.res = (const u8*)&rsa_oaep_20_res,
	.reslen = sizeof(rsa_oaep_20_res),
	.salt = (const u8*)&rsa_oaep_20_salt,
	.saltlen = sizeof(rsa_oaep_20_salt),
};
static const u8 rsa_oaep_21_CRT_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_21_CRT_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_21_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_21_CRT_m[] = {
0x2e, 0xf2, 0xb0, 0x66, 0xf8, 0x54, 0xc3, 0x3f, 0x3b, 0xdc, 0xbb, 0x59, 0x94, 0xa4, 0x35, 0xe7, 0x3d, 0x6c, 0x6c, 
};
static const u8 rsa_oaep_21_CRT_res[] = {
0x00, 0xeb, 0xc5, 0xf5, 0xfd, 0xa7, 0x7c, 0xfd, 0xad, 0x3c, 0x83, 0x64, 0x1a, 0x90, 0x25, 0xe7, 0x7d, 0x72, 0xd8, 0xa6, 0xfb, 0x33, 0xa8, 0x10, 0xf5, 0x95, 0x0f, 0x8d, 0x74, 0xc7, 0x3e, 0x8d, 0x93, 0x1e, 0x86, 0x34, 0xd8, 0x6a, 0xb1, 0x24, 0x62, 0x56, 0xae, 0x07, 0xb6, 0x00, 0x5b, 0x71, 0xb7, 0xf2, 0xfb, 0x98, 0x35, 0x12, 0x18, 0x33, 0x1c, 0xe6, 0x9b, 0x8f, 0xfb, 0xdc, 0x9d, 0xa0, 0x8b, 0xbc, 0x9c, 0x70, 0x4f, 0x87, 0x6d, 0xeb, 0x9d, 0xf9, 0xfc, 0x2e, 0xc0, 0x65, 0xca, 0xd8, 0x7f, 0x90, 0x90, 0xb0, 0x7a, 0xcc, 0x17, 0xaa, 0x7f, 0x99, 0x7b, 0x27, 0xac, 0xa4, 0x88, 0x06, 0xe8, 0x97, 0xf7, 0x71, 0xd9, 0x51, 0x41, 0xfe, 0x45, 0x26, 0xd8, 0xa5, 0x30, 0x1b, 0x67, 0x86, 0x27, 0xef, 0xab, 0x70, 0x7f, 0xd4, 0x0f, 0xbe, 0xbd, 0x6e, 0x79, 0x2a, 0x25, 0x61, 0x3e, 0x7a, 0xec, 
};
static const u8 rsa_oaep_21_CRT_salt[] = {
0xeb, 0x3c, 0xeb, 0xbc, 0x4a, 0xdc, 0x16, 0xbb, 0x48, 0xe8, 0x8c, 0x8a, 0xec, 0x0e, 0x34, 0xaf, 0x7f, 0x42, 0x7f, 0xd3, 
};
static const u8 rsa_oaep_21_CRT_p[] = {
0x01, 0x59, 0xdb, 0xde, 0x04, 0xa3, 0x3e, 0xf0, 0x6f, 0xb6, 0x08, 0xb8, 0x0b, 0x19, 0x0f, 0x4d, 0x3e, 0x22, 0xbc, 0xc1, 0x3a, 0xc8, 0xe4, 0xa0, 0x81, 0x03, 0x3a, 0xbf, 0xa4, 0x16, 0xed, 0xb0, 0xb3, 0x38, 0xaa, 0x08, 0xb5, 0x73, 0x09, 0xea, 0x5a, 0x52, 0x40, 0xe7, 0xdc, 0x6e, 0x54, 0x37, 0x8c, 0x69, 0x41, 0x4c, 0x31, 0xd9, 0x7d, 0xdb, 0x1f, 0x40, 0x6d, 0xb3, 0x76, 0x9c, 0xc4, 0x1a, 0x43, 
};
static const u8 rsa_oaep_21_CRT_q[] = {
0x01, 0x2b, 0x65, 0x2f, 0x30, 0x40, 0x3b, 0x38, 0xb4, 0x09, 0x95, 0xfd, 0x6f, 0xf4, 0x1a, 0x1a, 0xcc, 0x8a, 0xda, 0x70, 0x37, 0x32, 0x36, 0xb7, 0x20, 0x2d, 0x39, 0xb2, 0xee, 0x30, 0xcf, 0xb4, 0x6d, 0xb0, 0x95, 0x11, 0xf6, 0xf3, 0x07, 0xcc, 0x61, 0xcc, 0x21, 0x60, 0x6c, 0x18, 0xa7, 0x5b, 0x8a, 0x62, 0xf8, 0x22, 0xdf, 0x03, 0x1b, 0xa0, 0xdf, 0x0d, 0xaf, 0xd5, 0x50, 0x6f, 0x56, 0x8b, 0xd7, 
};
static const u8 rsa_oaep_21_CRT_dP[] = {
0x43, 0x6e, 0xf5, 0x08, 0xde, 0x73, 0x65, 0x19, 0xc2, 0xda, 0x4c, 0x58, 0x0d, 0x98, 0xc8, 0x2c, 0xb7, 0x45, 0x2a, 0x3f, 0xb5, 0xef, 0xad, 0xc3, 0xb9, 0xc7, 0x78, 0x9a, 0x1b, 0xc6, 0x58, 0x4f, 0x79, 0x5a, 0xdd, 0xbb, 0xd3, 0x24, 0x39, 0xc7, 0x46, 0x86, 0x55, 0x2e, 0xcb, 0x6c, 0x2c, 0x30, 0x7a, 0x4d, 0x3a, 0xf7, 0xf5, 0x39, 0xee, 0xc1, 0x57, 0x24, 0x8c, 0x7b, 0x31, 0xf1, 0xa2, 0x55, 
};
static const u8 rsa_oaep_21_CRT_dQ[] = {
0x01, 0x2b, 0x15, 0xa8, 0x9f, 0x3d, 0xfb, 0x2b, 0x39, 0x07, 0x3e, 0x73, 0xf0, 0x2b, 0xdd, 0x0c, 0x1a, 0x7b, 0x37, 0x9d, 0xd4, 0x35, 0xf0, 0x5c, 0xdd, 0xe2, 0xef, 0xf9, 0xe4, 0x62, 0x94, 0x8b, 0x7c, 0xec, 0x62, 0xee, 0x90, 0x50, 0xd5, 0xe0, 0x81, 0x6e, 0x07, 0x85, 0xa8, 0x56, 0xb4, 0x91, 0x08, 0xdc, 0xb7, 0x5f, 0x36, 0x83, 0x87, 0x4d, 0x1c, 0xa6, 0x32, 0x9a, 0x19, 0x01, 0x30, 0x66, 0xff, 
};
static const u8 rsa_oaep_21_CRT_qInv[] = {
0x02, 0x70, 0xdb, 0x17, 0xd5, 0x91, 0x4b, 0x01, 0x8d, 0x76, 0x11, 0x8b, 0x24, 0x38, 0x9a, 0x73, 0x50, 0xec, 0x83, 0x6b, 0x00, 0x63, 0xa2, 0x17, 0x21, 0x23, 0x6f, 0xd8, 0xed, 0xb6, 0xd8, 0x9b, 0x51, 0xe7, 0xee, 0xb8, 0x7b, 0x61, 0x1b, 0x71, 0x32, 0xcb, 0x7e, 0xa7, 0x35, 0x6c, 0x23, 0x15, 0x1c, 0x1e, 0x77, 0x51, 0x50, 0x7c, 0x78, 0x6d, 0x9e, 0xe1, 0x79, 0x41, 0x70, 0xa8, 0xc8, 0xe8, 
};


static const rsa_test test_rsa_oaep_21_CRT = {
	.name = "rsa_oaep_21_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_21_CRT_n,
	.nlen = sizeof(rsa_oaep_21_CRT_n),
	.d = (const u8*)&rsa_oaep_21_CRT_d,
	.dlen = sizeof(rsa_oaep_21_CRT_d),
	.e = (const u8*)&rsa_oaep_21_CRT_e,
	.elen = sizeof(rsa_oaep_21_CRT_e),
	.p = (const u8*)&rsa_oaep_21_CRT_p,
	.plen = sizeof(rsa_oaep_21_CRT_p),
	.q = (const u8*)&rsa_oaep_21_CRT_q,
	.qlen = sizeof(rsa_oaep_21_CRT_q),
	.dP = (const u8*)&rsa_oaep_21_CRT_dP,
	.dPlen = sizeof(rsa_oaep_21_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_21_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_21_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_21_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_21_CRT_qInv),
	.m = (const u8*)&rsa_oaep_21_CRT_m,
	.mlen = sizeof(rsa_oaep_21_CRT_m),
	.res = (const u8*)&rsa_oaep_21_CRT_res,
	.reslen = sizeof(rsa_oaep_21_CRT_res),
	.salt = (const u8*)&rsa_oaep_21_CRT_salt,
	.saltlen = sizeof(rsa_oaep_21_CRT_salt),
};
static const u8 rsa_oaep_22_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_22_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_22_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_22_m[] = {
0x8a, 0x7f, 0xb3, 0x44, 0xc8, 0xb6, 0xcb, 0x2c, 0xf2, 0xef, 0x1f, 0x64, 0x3f, 0x9a, 0x32, 0x18, 0xf6, 0xe1, 0x9b, 0xba, 0x89, 0xc0, 
};
static const u8 rsa_oaep_22_res[] = {
0x01, 0x08, 0x39, 0xec, 0x20, 0xc2, 0x7b, 0x90, 0x52, 0xe5, 0x5b, 0xef, 0xb9, 0xb7, 0x7e, 0x6f, 0xc2, 0x6e, 0x90, 0x75, 0xd7, 0xa5, 0x43, 0x78, 0xc6, 0x46, 0xab, 0xdf, 0x51, 0xe4, 0x45, 0xbd, 0x57, 0x15, 0xde, 0x81, 0x78, 0x9f, 0x56, 0xf1, 0x80, 0x3d, 0x91, 0x70, 0x76, 0x4a, 0x9e, 0x93, 0xcb, 0x78, 0x79, 0x86, 0x94, 0x02, 0x3e, 0xe7, 0x39, 0x3c, 0xe0, 0x4b, 0xc5, 0xd8, 0xf8, 0xc5, 0xa5, 0x2c, 0x17, 0x1d, 0x43, 0x83, 0x7e, 0x3a, 0xca, 0x62, 0xf6, 0x09, 0xeb, 0x0a, 0xa5, 0xff, 0xb0, 0x96, 0x0e, 0xf0, 0x41, 0x98, 0xdd, 0x75, 0x4f, 0x57, 0xf7, 0xfb, 0xe6, 0xab, 0xf7, 0x65, 0xcf, 0x11, 0x8b, 0x4c, 0xa4, 0x43, 0xb2, 0x3b, 0x5a, 0xab, 0x26, 0x6f, 0x95, 0x23, 0x26, 0xac, 0x45, 0x81, 0x10, 0x06, 0x44, 0x32, 0x5f, 0x8b, 0x72, 0x1a, 0xcd, 0x5d, 0x04, 0xff, 0x14, 0xef, 0x3a, 
};
static const u8 rsa_oaep_22_salt[] = {
0x4c, 0x45, 0xcf, 0x4d, 0x57, 0xc9, 0x8e, 0x3d, 0x6d, 0x20, 0x95, 0xad, 0xc5, 0x1c, 0x48, 0x9e, 0xb5, 0x0d, 0xff, 0x84, 
};


static const rsa_test test_rsa_oaep_22 = {
	.name = "rsa_oaep_22",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_22_n,
	.nlen = sizeof(rsa_oaep_22_n),
	.d = (const u8*)&rsa_oaep_22_d,
	.dlen = sizeof(rsa_oaep_22_d),
	.e = (const u8*)&rsa_oaep_22_e,
	.elen = sizeof(rsa_oaep_22_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_22_m,
	.mlen = sizeof(rsa_oaep_22_m),
	.res = (const u8*)&rsa_oaep_22_res,
	.reslen = sizeof(rsa_oaep_22_res),
	.salt = (const u8*)&rsa_oaep_22_salt,
	.saltlen = sizeof(rsa_oaep_22_salt),
};
static const u8 rsa_oaep_23_CRT_n[] = {
0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45, 
};
static const u8 rsa_oaep_23_CRT_d[] = {
0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39, 
};
static const u8 rsa_oaep_23_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_23_CRT_m[] = {
0x8a, 0x7f, 0xb3, 0x44, 0xc8, 0xb6, 0xcb, 0x2c, 0xf2, 0xef, 0x1f, 0x64, 0x3f, 0x9a, 0x32, 0x18, 0xf6, 0xe1, 0x9b, 0xba, 0x89, 0xc0, 
};
static const u8 rsa_oaep_23_CRT_res[] = {
0x01, 0x08, 0x39, 0xec, 0x20, 0xc2, 0x7b, 0x90, 0x52, 0xe5, 0x5b, 0xef, 0xb9, 0xb7, 0x7e, 0x6f, 0xc2, 0x6e, 0x90, 0x75, 0xd7, 0xa5, 0x43, 0x78, 0xc6, 0x46, 0xab, 0xdf, 0x51, 0xe4, 0x45, 0xbd, 0x57, 0x15, 0xde, 0x81, 0x78, 0x9f, 0x56, 0xf1, 0x80, 0x3d, 0x91, 0x70, 0x76, 0x4a, 0x9e, 0x93, 0xcb, 0x78, 0x79, 0x86, 0x94, 0x02, 0x3e, 0xe7, 0x39, 0x3c, 0xe0, 0x4b, 0xc5, 0xd8, 0xf8, 0xc5, 0xa5, 0x2c, 0x17, 0x1d, 0x43, 0x83, 0x7e, 0x3a, 0xca, 0x62, 0xf6, 0x09, 0xeb, 0x0a, 0xa5, 0xff, 0xb0, 0x96, 0x0e, 0xf0, 0x41, 0x98, 0xdd, 0x75, 0x4f, 0x57, 0xf7, 0xfb, 0xe6, 0xab, 0xf7, 0x65, 0xcf, 0x11, 0x8b, 0x4c, 0xa4, 0x43, 0xb2, 0x3b, 0x5a, 0xab, 0x26, 0x6f, 0x95, 0x23, 0x26, 0xac, 0x45, 0x81, 0x10, 0x06, 0x44, 0x32, 0x5f, 0x8b, 0x72, 0x1a, 0xcd, 0x5d, 0x04, 0xff, 0x14, 0xef, 0x3a, 
};
static const u8 rsa_oaep_23_CRT_salt[] = {
0x4c, 0x45, 0xcf, 0x4d, 0x57, 0xc9, 0x8e, 0x3d, 0x6d, 0x20, 0x95, 0xad, 0xc5, 0x1c, 0x48, 0x9e, 0xb5, 0x0d, 0xff, 0x84, 
};
static const u8 rsa_oaep_23_CRT_p[] = {
0x01, 0x59, 0xdb, 0xde, 0x04, 0xa3, 0x3e, 0xf0, 0x6f, 0xb6, 0x08, 0xb8, 0x0b, 0x19, 0x0f, 0x4d, 0x3e, 0x22, 0xbc, 0xc1, 0x3a, 0xc8, 0xe4, 0xa0, 0x81, 0x03, 0x3a, 0xbf, 0xa4, 0x16, 0xed, 0xb0, 0xb3, 0x38, 0xaa, 0x08, 0xb5, 0x73, 0x09, 0xea, 0x5a, 0x52, 0x40, 0xe7, 0xdc, 0x6e, 0x54, 0x37, 0x8c, 0x69, 0x41, 0x4c, 0x31, 0xd9, 0x7d, 0xdb, 0x1f, 0x40, 0x6d, 0xb3, 0x76, 0x9c, 0xc4, 0x1a, 0x43, 
};
static const u8 rsa_oaep_23_CRT_q[] = {
0x01, 0x2b, 0x65, 0x2f, 0x30, 0x40, 0x3b, 0x38, 0xb4, 0x09, 0x95, 0xfd, 0x6f, 0xf4, 0x1a, 0x1a, 0xcc, 0x8a, 0xda, 0x70, 0x37, 0x32, 0x36, 0xb7, 0x20, 0x2d, 0x39, 0xb2, 0xee, 0x30, 0xcf, 0xb4, 0x6d, 0xb0, 0x95, 0x11, 0xf6, 0xf3, 0x07, 0xcc, 0x61, 0xcc, 0x21, 0x60, 0x6c, 0x18, 0xa7, 0x5b, 0x8a, 0x62, 0xf8, 0x22, 0xdf, 0x03, 0x1b, 0xa0, 0xdf, 0x0d, 0xaf, 0xd5, 0x50, 0x6f, 0x56, 0x8b, 0xd7, 
};
static const u8 rsa_oaep_23_CRT_dP[] = {
0x43, 0x6e, 0xf5, 0x08, 0xde, 0x73, 0x65, 0x19, 0xc2, 0xda, 0x4c, 0x58, 0x0d, 0x98, 0xc8, 0x2c, 0xb7, 0x45, 0x2a, 0x3f, 0xb5, 0xef, 0xad, 0xc3, 0xb9, 0xc7, 0x78, 0x9a, 0x1b, 0xc6, 0x58, 0x4f, 0x79, 0x5a, 0xdd, 0xbb, 0xd3, 0x24, 0x39, 0xc7, 0x46, 0x86, 0x55, 0x2e, 0xcb, 0x6c, 0x2c, 0x30, 0x7a, 0x4d, 0x3a, 0xf7, 0xf5, 0x39, 0xee, 0xc1, 0x57, 0x24, 0x8c, 0x7b, 0x31, 0xf1, 0xa2, 0x55, 
};
static const u8 rsa_oaep_23_CRT_dQ[] = {
0x01, 0x2b, 0x15, 0xa8, 0x9f, 0x3d, 0xfb, 0x2b, 0x39, 0x07, 0x3e, 0x73, 0xf0, 0x2b, 0xdd, 0x0c, 0x1a, 0x7b, 0x37, 0x9d, 0xd4, 0x35, 0xf0, 0x5c, 0xdd, 0xe2, 0xef, 0xf9, 0xe4, 0x62, 0x94, 0x8b, 0x7c, 0xec, 0x62, 0xee, 0x90, 0x50, 0xd5, 0xe0, 0x81, 0x6e, 0x07, 0x85, 0xa8, 0x56, 0xb4, 0x91, 0x08, 0xdc, 0xb7, 0x5f, 0x36, 0x83, 0x87, 0x4d, 0x1c, 0xa6, 0x32, 0x9a, 0x19, 0x01, 0x30, 0x66, 0xff, 
};
static const u8 rsa_oaep_23_CRT_qInv[] = {
0x02, 0x70, 0xdb, 0x17, 0xd5, 0x91, 0x4b, 0x01, 0x8d, 0x76, 0x11, 0x8b, 0x24, 0x38, 0x9a, 0x73, 0x50, 0xec, 0x83, 0x6b, 0x00, 0x63, 0xa2, 0x17, 0x21, 0x23, 0x6f, 0xd8, 0xed, 0xb6, 0xd8, 0x9b, 0x51, 0xe7, 0xee, 0xb8, 0x7b, 0x61, 0x1b, 0x71, 0x32, 0xcb, 0x7e, 0xa7, 0x35, 0x6c, 0x23, 0x15, 0x1c, 0x1e, 0x77, 0x51, 0x50, 0x7c, 0x78, 0x6d, 0x9e, 0xe1, 0x79, 0x41, 0x70, 0xa8, 0xc8, 0xe8, 
};


static const rsa_test test_rsa_oaep_23_CRT = {
	.name = "rsa_oaep_23_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_23_CRT_n,
	.nlen = sizeof(rsa_oaep_23_CRT_n),
	.d = (const u8*)&rsa_oaep_23_CRT_d,
	.dlen = sizeof(rsa_oaep_23_CRT_d),
	.e = (const u8*)&rsa_oaep_23_CRT_e,
	.elen = sizeof(rsa_oaep_23_CRT_e),
	.p = (const u8*)&rsa_oaep_23_CRT_p,
	.plen = sizeof(rsa_oaep_23_CRT_p),
	.q = (const u8*)&rsa_oaep_23_CRT_q,
	.qlen = sizeof(rsa_oaep_23_CRT_q),
	.dP = (const u8*)&rsa_oaep_23_CRT_dP,
	.dPlen = sizeof(rsa_oaep_23_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_23_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_23_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_23_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_23_CRT_qInv),
	.m = (const u8*)&rsa_oaep_23_CRT_m,
	.mlen = sizeof(rsa_oaep_23_CRT_m),
	.res = (const u8*)&rsa_oaep_23_CRT_res,
	.reslen = sizeof(rsa_oaep_23_CRT_res),
	.salt = (const u8*)&rsa_oaep_23_CRT_salt,
	.saltlen = sizeof(rsa_oaep_23_CRT_salt),
};
static const u8 rsa_oaep_24_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_24_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_24_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_24_m[] = {
0x08, 0x78, 0x20, 0xb5, 0x69, 0xe8, 0xfa, 0x8d, 
};
static const u8 rsa_oaep_24_res[] = {
0x02, 0x6a, 0x04, 0x85, 0xd9, 0x6a, 0xeb, 0xd9, 0x6b, 0x43, 0x82, 0x08, 0x50, 0x99, 0xb9, 0x62, 0xe6, 0xa2, 0xbd, 0xec, 0x3d, 0x90, 0xc8, 0xdb, 0x62, 0x5e, 0x14, 0x37, 0x2d, 0xe8, 0x5e, 0x2d, 0x5b, 0x7b, 0xaa, 0xb6, 0x5c, 0x8f, 0xaf, 0x91, 0xbb, 0x55, 0x04, 0xfb, 0x49, 0x5a, 0xfc, 0xe5, 0xc9, 0x88, 0xb3, 0xf6, 0xa5, 0x2e, 0x20, 0xe1, 0xd6, 0xcb, 0xd3, 0x56, 0x6c, 0x5c, 0xd1, 0xf2, 0xb8, 0x31, 0x8b, 0xb5, 0x42, 0xcc, 0x0e, 0xa2, 0x5c, 0x4a, 0xab, 0x99, 0x32, 0xaf, 0xa2, 0x07, 0x60, 0xea, 0xdd, 0xec, 0x78, 0x43, 0x96, 0xa0, 0x7e, 0xa0, 0xef, 0x24, 0xd4, 0xe6, 0xf4, 0xd3, 0x7e, 0x50, 0x52, 0xa7, 0xa3, 0x1e, 0x14, 0x6a, 0xa4, 0x80, 0xa1, 0x11, 0xbb, 0xe9, 0x26, 0x40, 0x13, 0x07, 0xe0, 0x0f, 0x41, 0x00, 0x33, 0x84, 0x2b, 0x6d, 0x82, 0xfe, 0x5c, 0xe4, 0xdf, 0xae, 0x80, 
};
static const u8 rsa_oaep_24_salt[] = {
0x8c, 0xed, 0x6b, 0x19, 0x62, 0x90, 0x80, 0x57, 0x90, 0xe9, 0x09, 0x07, 0x40, 0x15, 0xe6, 0xa2, 0x0b, 0x0c, 0x48, 0x94, 
};


static const rsa_test test_rsa_oaep_24 = {
	.name = "rsa_oaep_24",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_24_n,
	.nlen = sizeof(rsa_oaep_24_n),
	.d = (const u8*)&rsa_oaep_24_d,
	.dlen = sizeof(rsa_oaep_24_d),
	.e = (const u8*)&rsa_oaep_24_e,
	.elen = sizeof(rsa_oaep_24_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_24_m,
	.mlen = sizeof(rsa_oaep_24_m),
	.res = (const u8*)&rsa_oaep_24_res,
	.reslen = sizeof(rsa_oaep_24_res),
	.salt = (const u8*)&rsa_oaep_24_salt,
	.saltlen = sizeof(rsa_oaep_24_salt),
};
static const u8 rsa_oaep_25_CRT_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_25_CRT_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_25_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_25_CRT_m[] = {
0x08, 0x78, 0x20, 0xb5, 0x69, 0xe8, 0xfa, 0x8d, 
};
static const u8 rsa_oaep_25_CRT_res[] = {
0x02, 0x6a, 0x04, 0x85, 0xd9, 0x6a, 0xeb, 0xd9, 0x6b, 0x43, 0x82, 0x08, 0x50, 0x99, 0xb9, 0x62, 0xe6, 0xa2, 0xbd, 0xec, 0x3d, 0x90, 0xc8, 0xdb, 0x62, 0x5e, 0x14, 0x37, 0x2d, 0xe8, 0x5e, 0x2d, 0x5b, 0x7b, 0xaa, 0xb6, 0x5c, 0x8f, 0xaf, 0x91, 0xbb, 0x55, 0x04, 0xfb, 0x49, 0x5a, 0xfc, 0xe5, 0xc9, 0x88, 0xb3, 0xf6, 0xa5, 0x2e, 0x20, 0xe1, 0xd6, 0xcb, 0xd3, 0x56, 0x6c, 0x5c, 0xd1, 0xf2, 0xb8, 0x31, 0x8b, 0xb5, 0x42, 0xcc, 0x0e, 0xa2, 0x5c, 0x4a, 0xab, 0x99, 0x32, 0xaf, 0xa2, 0x07, 0x60, 0xea, 0xdd, 0xec, 0x78, 0x43, 0x96, 0xa0, 0x7e, 0xa0, 0xef, 0x24, 0xd4, 0xe6, 0xf4, 0xd3, 0x7e, 0x50, 0x52, 0xa7, 0xa3, 0x1e, 0x14, 0x6a, 0xa4, 0x80, 0xa1, 0x11, 0xbb, 0xe9, 0x26, 0x40, 0x13, 0x07, 0xe0, 0x0f, 0x41, 0x00, 0x33, 0x84, 0x2b, 0x6d, 0x82, 0xfe, 0x5c, 0xe4, 0xdf, 0xae, 0x80, 
};
static const u8 rsa_oaep_25_CRT_salt[] = {
0x8c, 0xed, 0x6b, 0x19, 0x62, 0x90, 0x80, 0x57, 0x90, 0xe9, 0x09, 0x07, 0x40, 0x15, 0xe6, 0xa2, 0x0b, 0x0c, 0x48, 0x94, 
};
static const u8 rsa_oaep_25_CRT_p[] = {
0x01, 0xbf, 0x01, 0xd2, 0x16, 0xd7, 0x35, 0x95, 0xcf, 0x02, 0x70, 0xc2, 0xbe, 0xb7, 0x8d, 0x40, 0xa0, 0xd8, 0x44, 0x7d, 0x31, 0xda, 0x91, 0x9a, 0x98, 0x3f, 0x7e, 0xea, 0x78, 0x1b, 0x77, 0xd8, 0x5f, 0xe3, 0x71, 0xb3, 0xe9, 0x37, 0x3e, 0x7b, 0x69, 0x21, 0x7d, 0x31, 0x50, 0xa0, 0x2d, 0x89, 0x58, 0xde, 0x7f, 0xad, 0x9d, 0x55, 0x51, 0x60, 0x95, 0x8b, 0x44, 0x54, 0x12, 0x7e, 0x0e, 0x7e, 0xaf, 
};
static const u8 rsa_oaep_25_CRT_q[] = {
0x01, 0x8d, 0x33, 0x99, 0x65, 0x81, 0x66, 0xdb, 0x38, 0x29, 0x81, 0x6d, 0x7b, 0x29, 0x54, 0x16, 0x75, 0x9e, 0x9c, 0x91, 0x98, 0x7f, 0x5b, 0x2d, 0x8a, 0xec, 0xd6, 0x3b, 0x04, 0xb4, 0x8b, 0xd7, 0xb2, 0xfc, 0xf2, 0x29, 0xbb, 0x7f, 0x8a, 0x6d, 0xc8, 0x8b, 0xa1, 0x3d, 0xd2, 0xe3, 0x9a, 0xd5, 0x5b, 0x6d, 0x1a, 0x06, 0x16, 0x07, 0x08, 0xf9, 0x70, 0x0b, 0xe8, 0x0b, 0x8f, 0xd3, 0x74, 0x4c, 0xe7, 
};
static const u8 rsa_oaep_25_CRT_dP[] = {
0x06, 0xc0, 0xa2, 0x49, 0xd2, 0x0a, 0x6f, 0x2e, 0xe7, 0x5c, 0x88, 0xb4, 0x94, 0xd5, 0x3f, 0x6a, 0xae, 0x99, 0xaa, 0x42, 0x7c, 0x88, 0xc2, 0x8b, 0x16, 0x3a, 0x76, 0x94, 0x45, 0xe5, 0xf3, 0x90, 0xcf, 0x40, 0xc2, 0x74, 0xfd, 0x6e, 0xa6, 0x32, 0x9a, 0x5c, 0xe7, 0xc7, 0xce, 0x03, 0xa2, 0x15, 0x83, 0x96, 0xee, 0x2a, 0x78, 0x45, 0x78, 0x6e, 0x09, 0xe2, 0x88, 0x5a, 0x97, 0x28, 0xe4, 0xe5, 
};
static const u8 rsa_oaep_25_CRT_dQ[] = {
0xd1, 0xd2, 0x7c, 0x29, 0xfe, 0xdd, 0x92, 0xd8, 0x6c, 0x34, 0x8e, 0xdd, 0x0c, 0xcb, 0xfa, 0xc1, 0x4f, 0x74, 0x6e, 0x05, 0x1c, 0xe1, 0xd1, 0x81, 0x1d, 0xf3, 0x5d, 0x61, 0xf2, 0xee, 0x1c, 0x97, 0xd4, 0xbf, 0x28, 0x04, 0x80, 0x2f, 0x64, 0x27, 0x18, 0x7b, 0xa8, 0xe9, 0x0a, 0x8a, 0xf4, 0x42, 0x43, 0xb4, 0x07, 0x9b, 0x03, 0x44, 0x5e, 0x60, 0x2e, 0x29, 0xfa, 0x51, 0x93, 0xe6, 0x4f, 0xe9, 
};
static const u8 rsa_oaep_25_CRT_qInv[] = {
0x8c, 0xb2, 0xf7, 0x56, 0xbd, 0x89, 0x41, 0xb1, 0xd3, 0xb7, 0x70, 0xe5, 0xad, 0x31, 0xee, 0x37, 0x3b, 0x28, 0xac, 0xda, 0x69, 0xff, 0x9b, 0x6f, 0x40, 0xfe, 0x57, 0x8b, 0x9f, 0x1a, 0xfb, 0x85, 0x83, 0x6f, 0x96, 0x27, 0xd3, 0x7a, 0xcf, 0xf7, 0x3c, 0x27, 0x79, 0xe6, 0x34, 0xbb, 0x26, 0x01, 0x1c, 0x2c, 0x8f, 0x7f, 0x33, 0x61, 0xae, 0x2a, 0x9e, 0xa6, 0x5e, 0xd6, 0x89, 0xe3, 0x63, 0x9a, 
};


static const rsa_test test_rsa_oaep_25_CRT = {
	.name = "rsa_oaep_25_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_25_CRT_n,
	.nlen = sizeof(rsa_oaep_25_CRT_n),
	.d = (const u8*)&rsa_oaep_25_CRT_d,
	.dlen = sizeof(rsa_oaep_25_CRT_d),
	.e = (const u8*)&rsa_oaep_25_CRT_e,
	.elen = sizeof(rsa_oaep_25_CRT_e),
	.p = (const u8*)&rsa_oaep_25_CRT_p,
	.plen = sizeof(rsa_oaep_25_CRT_p),
	.q = (const u8*)&rsa_oaep_25_CRT_q,
	.qlen = sizeof(rsa_oaep_25_CRT_q),
	.dP = (const u8*)&rsa_oaep_25_CRT_dP,
	.dPlen = sizeof(rsa_oaep_25_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_25_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_25_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_25_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_25_CRT_qInv),
	.m = (const u8*)&rsa_oaep_25_CRT_m,
	.mlen = sizeof(rsa_oaep_25_CRT_m),
	.res = (const u8*)&rsa_oaep_25_CRT_res,
	.reslen = sizeof(rsa_oaep_25_CRT_res),
	.salt = (const u8*)&rsa_oaep_25_CRT_salt,
	.saltlen = sizeof(rsa_oaep_25_CRT_salt),
};
static const u8 rsa_oaep_26_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_26_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_26_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_26_m[] = {
0x46, 0x53, 0xac, 0xaf, 0x17, 0x19, 0x60, 0xb0, 0x1f, 0x52, 0xa7, 0xbe, 0x63, 0xa3, 0xab, 0x21, 0xdc, 0x36, 0x8e, 0xc4, 0x3b, 0x50, 0xd8, 0x2e, 0xc3, 0x78, 0x1e, 0x04, 
};
static const u8 rsa_oaep_26_res[] = {
0x02, 0x4d, 0xb8, 0x9c, 0x78, 0x02, 0x98, 0x9b, 0xe0, 0x78, 0x38, 0x47, 0x86, 0x30, 0x84, 0x94, 0x1b, 0xf2, 0x09, 0xd7, 0x61, 0x98, 0x7e, 0x38, 0xf9, 0x7c, 0xb5, 0xf6, 0xf1, 0xbc, 0x88, 0xda, 0x72, 0xa5, 0x0b, 0x73, 0xeb, 0xaf, 0x11, 0xc8, 0x79, 0xc4, 0xf9, 0x5d, 0xf3, 0x7b, 0x85, 0x0b, 0x8f, 0x65, 0xd7, 0x62, 0x2e, 0x25, 0xb1, 0xb8, 0x89, 0xe8, 0x0f, 0xe8, 0x0b, 0xac, 0xa2, 0x06, 0x9d, 0x6e, 0x0e, 0x1d, 0x82, 0x99, 0x53, 0xfc, 0x45, 0x90, 0x69, 0xde, 0x98, 0xea, 0x97, 0x98, 0xb4, 0x51, 0xe5, 0x57, 0xe9, 0x9a, 0xbf, 0x8f, 0xe3, 0xd9, 0xcc, 0xf9, 0x09, 0x6e, 0xbb, 0xf3, 0xe5, 0x25, 0x5d, 0x3b, 0x4e, 0x1c, 0x6d, 0x2e, 0xca, 0xdf, 0x06, 0x7a, 0x35, 0x9e, 0xea, 0x86, 0x40, 0x5a, 0xcd, 0x47, 0xd5, 0xe1, 0x65, 0x51, 0x7c, 0xca, 0xfd, 0x47, 0xd6, 0xdb, 0xee, 0x4b, 0xf5, 
};
static const u8 rsa_oaep_26_salt[] = {
0xb4, 0x29, 0x1d, 0x65, 0x67, 0x55, 0x08, 0x48, 0xcc, 0x15, 0x69, 0x67, 0xc8, 0x09, 0xba, 0xab, 0x6c, 0xa5, 0x07, 0xf0, 
};


static const rsa_test test_rsa_oaep_26 = {
	.name = "rsa_oaep_26",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_26_n,
	.nlen = sizeof(rsa_oaep_26_n),
	.d = (const u8*)&rsa_oaep_26_d,
	.dlen = sizeof(rsa_oaep_26_d),
	.e = (const u8*)&rsa_oaep_26_e,
	.elen = sizeof(rsa_oaep_26_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_26_m,
	.mlen = sizeof(rsa_oaep_26_m),
	.res = (const u8*)&rsa_oaep_26_res,
	.reslen = sizeof(rsa_oaep_26_res),
	.salt = (const u8*)&rsa_oaep_26_salt,
	.saltlen = sizeof(rsa_oaep_26_salt),
};
static const u8 rsa_oaep_27_CRT_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_27_CRT_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_27_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_27_CRT_m[] = {
0x46, 0x53, 0xac, 0xaf, 0x17, 0x19, 0x60, 0xb0, 0x1f, 0x52, 0xa7, 0xbe, 0x63, 0xa3, 0xab, 0x21, 0xdc, 0x36, 0x8e, 0xc4, 0x3b, 0x50, 0xd8, 0x2e, 0xc3, 0x78, 0x1e, 0x04, 
};
static const u8 rsa_oaep_27_CRT_res[] = {
0x02, 0x4d, 0xb8, 0x9c, 0x78, 0x02, 0x98, 0x9b, 0xe0, 0x78, 0x38, 0x47, 0x86, 0x30, 0x84, 0x94, 0x1b, 0xf2, 0x09, 0xd7, 0x61, 0x98, 0x7e, 0x38, 0xf9, 0x7c, 0xb5, 0xf6, 0xf1, 0xbc, 0x88, 0xda, 0x72, 0xa5, 0x0b, 0x73, 0xeb, 0xaf, 0x11, 0xc8, 0x79, 0xc4, 0xf9, 0x5d, 0xf3, 0x7b, 0x85, 0x0b, 0x8f, 0x65, 0xd7, 0x62, 0x2e, 0x25, 0xb1, 0xb8, 0x89, 0xe8, 0x0f, 0xe8, 0x0b, 0xac, 0xa2, 0x06, 0x9d, 0x6e, 0x0e, 0x1d, 0x82, 0x99, 0x53, 0xfc, 0x45, 0x90, 0x69, 0xde, 0x98, 0xea, 0x97, 0x98, 0xb4, 0x51, 0xe5, 0x57, 0xe9, 0x9a, 0xbf, 0x8f, 0xe3, 0xd9, 0xcc, 0xf9, 0x09, 0x6e, 0xbb, 0xf3, 0xe5, 0x25, 0x5d, 0x3b, 0x4e, 0x1c, 0x6d, 0x2e, 0xca, 0xdf, 0x06, 0x7a, 0x35, 0x9e, 0xea, 0x86, 0x40, 0x5a, 0xcd, 0x47, 0xd5, 0xe1, 0x65, 0x51, 0x7c, 0xca, 0xfd, 0x47, 0xd6, 0xdb, 0xee, 0x4b, 0xf5, 
};
static const u8 rsa_oaep_27_CRT_salt[] = {
0xb4, 0x29, 0x1d, 0x65, 0x67, 0x55, 0x08, 0x48, 0xcc, 0x15, 0x69, 0x67, 0xc8, 0x09, 0xba, 0xab, 0x6c, 0xa5, 0x07, 0xf0, 
};
static const u8 rsa_oaep_27_CRT_p[] = {
0x01, 0xbf, 0x01, 0xd2, 0x16, 0xd7, 0x35, 0x95, 0xcf, 0x02, 0x70, 0xc2, 0xbe, 0xb7, 0x8d, 0x40, 0xa0, 0xd8, 0x44, 0x7d, 0x31, 0xda, 0x91, 0x9a, 0x98, 0x3f, 0x7e, 0xea, 0x78, 0x1b, 0x77, 0xd8, 0x5f, 0xe3, 0x71, 0xb3, 0xe9, 0x37, 0x3e, 0x7b, 0x69, 0x21, 0x7d, 0x31, 0x50, 0xa0, 0x2d, 0x89, 0x58, 0xde, 0x7f, 0xad, 0x9d, 0x55, 0x51, 0x60, 0x95, 0x8b, 0x44, 0x54, 0x12, 0x7e, 0x0e, 0x7e, 0xaf, 
};
static const u8 rsa_oaep_27_CRT_q[] = {
0x01, 0x8d, 0x33, 0x99, 0x65, 0x81, 0x66, 0xdb, 0x38, 0x29, 0x81, 0x6d, 0x7b, 0x29, 0x54, 0x16, 0x75, 0x9e, 0x9c, 0x91, 0x98, 0x7f, 0x5b, 0x2d, 0x8a, 0xec, 0xd6, 0x3b, 0x04, 0xb4, 0x8b, 0xd7, 0xb2, 0xfc, 0xf2, 0x29, 0xbb, 0x7f, 0x8a, 0x6d, 0xc8, 0x8b, 0xa1, 0x3d, 0xd2, 0xe3, 0x9a, 0xd5, 0x5b, 0x6d, 0x1a, 0x06, 0x16, 0x07, 0x08, 0xf9, 0x70, 0x0b, 0xe8, 0x0b, 0x8f, 0xd3, 0x74, 0x4c, 0xe7, 
};
static const u8 rsa_oaep_27_CRT_dP[] = {
0x06, 0xc0, 0xa2, 0x49, 0xd2, 0x0a, 0x6f, 0x2e, 0xe7, 0x5c, 0x88, 0xb4, 0x94, 0xd5, 0x3f, 0x6a, 0xae, 0x99, 0xaa, 0x42, 0x7c, 0x88, 0xc2, 0x8b, 0x16, 0x3a, 0x76, 0x94, 0x45, 0xe5, 0xf3, 0x90, 0xcf, 0x40, 0xc2, 0x74, 0xfd, 0x6e, 0xa6, 0x32, 0x9a, 0x5c, 0xe7, 0xc7, 0xce, 0x03, 0xa2, 0x15, 0x83, 0x96, 0xee, 0x2a, 0x78, 0x45, 0x78, 0x6e, 0x09, 0xe2, 0x88, 0x5a, 0x97, 0x28, 0xe4, 0xe5, 
};
static const u8 rsa_oaep_27_CRT_dQ[] = {
0xd1, 0xd2, 0x7c, 0x29, 0xfe, 0xdd, 0x92, 0xd8, 0x6c, 0x34, 0x8e, 0xdd, 0x0c, 0xcb, 0xfa, 0xc1, 0x4f, 0x74, 0x6e, 0x05, 0x1c, 0xe1, 0xd1, 0x81, 0x1d, 0xf3, 0x5d, 0x61, 0xf2, 0xee, 0x1c, 0x97, 0xd4, 0xbf, 0x28, 0x04, 0x80, 0x2f, 0x64, 0x27, 0x18, 0x7b, 0xa8, 0xe9, 0x0a, 0x8a, 0xf4, 0x42, 0x43, 0xb4, 0x07, 0x9b, 0x03, 0x44, 0x5e, 0x60, 0x2e, 0x29, 0xfa, 0x51, 0x93, 0xe6, 0x4f, 0xe9, 
};
static const u8 rsa_oaep_27_CRT_qInv[] = {
0x8c, 0xb2, 0xf7, 0x56, 0xbd, 0x89, 0x41, 0xb1, 0xd3, 0xb7, 0x70, 0xe5, 0xad, 0x31, 0xee, 0x37, 0x3b, 0x28, 0xac, 0xda, 0x69, 0xff, 0x9b, 0x6f, 0x40, 0xfe, 0x57, 0x8b, 0x9f, 0x1a, 0xfb, 0x85, 0x83, 0x6f, 0x96, 0x27, 0xd3, 0x7a, 0xcf, 0xf7, 0x3c, 0x27, 0x79, 0xe6, 0x34, 0xbb, 0x26, 0x01, 0x1c, 0x2c, 0x8f, 0x7f, 0x33, 0x61, 0xae, 0x2a, 0x9e, 0xa6, 0x5e, 0xd6, 0x89, 0xe3, 0x63, 0x9a, 
};


static const rsa_test test_rsa_oaep_27_CRT = {
	.name = "rsa_oaep_27_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_27_CRT_n,
	.nlen = sizeof(rsa_oaep_27_CRT_n),
	.d = (const u8*)&rsa_oaep_27_CRT_d,
	.dlen = sizeof(rsa_oaep_27_CRT_d),
	.e = (const u8*)&rsa_oaep_27_CRT_e,
	.elen = sizeof(rsa_oaep_27_CRT_e),
	.p = (const u8*)&rsa_oaep_27_CRT_p,
	.plen = sizeof(rsa_oaep_27_CRT_p),
	.q = (const u8*)&rsa_oaep_27_CRT_q,
	.qlen = sizeof(rsa_oaep_27_CRT_q),
	.dP = (const u8*)&rsa_oaep_27_CRT_dP,
	.dPlen = sizeof(rsa_oaep_27_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_27_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_27_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_27_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_27_CRT_qInv),
	.m = (const u8*)&rsa_oaep_27_CRT_m,
	.mlen = sizeof(rsa_oaep_27_CRT_m),
	.res = (const u8*)&rsa_oaep_27_CRT_res,
	.reslen = sizeof(rsa_oaep_27_CRT_res),
	.salt = (const u8*)&rsa_oaep_27_CRT_salt,
	.saltlen = sizeof(rsa_oaep_27_CRT_salt),
};
static const u8 rsa_oaep_28_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_28_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_28_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_28_m[] = {
0xd9, 0x4c, 0xd0, 0xe0, 0x8f, 0xa4, 0x04, 0xed, 0x89, 
};
static const u8 rsa_oaep_28_res[] = {
0x02, 0x39, 0xbc, 0xe6, 0x81, 0x03, 0x24, 0x41, 0x52, 0x88, 0x77, 0xd6, 0xd1, 0xc8, 0xbb, 0x28, 0xaa, 0x3b, 0xc9, 0x7f, 0x1d, 0xf5, 0x84, 0x56, 0x36, 0x18, 0x99, 0x57, 0x97, 0x68, 0x38, 0x44, 0xca, 0x86, 0x66, 0x47, 0x32, 0xf4, 0xbe, 0xd7, 0xa0, 0xaa, 0xb0, 0x83, 0xaa, 0xab, 0xfb, 0x72, 0x38, 0xf5, 0x82, 0xe3, 0x09, 0x58, 0xc2, 0x02, 0x4e, 0x44, 0xe5, 0x70, 0x43, 0xb9, 0x79, 0x50, 0xfd, 0x54, 0x3d, 0xa9, 0x77, 0xc9, 0x0c, 0xdd, 0xe5, 0x33, 0x7d, 0x61, 0x84, 0x42, 0xf9, 0x9e, 0x60, 0xd7, 0x78, 0x3a, 0xb5, 0x9c, 0xe6, 0xdd, 0x9d, 0x69, 0xc4, 0x7a, 0xd1, 0xe9, 0x62, 0xbe, 0xc2, 0x2d, 0x05, 0x89, 0x5c, 0xff, 0x8d, 0x3f, 0x64, 0xed, 0x52, 0x61, 0xd9, 0x2b, 0x26, 0x78, 0x51, 0x03, 0x93, 0x48, 0x49, 0x90, 0xba, 0x3f, 0x7f, 0x06, 0x81, 0x8a, 0xe6, 0xff, 0xce, 0x8a, 0x3a, 
};
static const u8 rsa_oaep_28_salt[] = {
0xce, 0x89, 0x28, 0xf6, 0x05, 0x95, 0x58, 0x25, 0x40, 0x08, 0xba, 0xdd, 0x97, 0x94, 0xfa, 0xdc, 0xd2, 0xfd, 0x1f, 0x65, 
};


static const rsa_test test_rsa_oaep_28 = {
	.name = "rsa_oaep_28",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_28_n,
	.nlen = sizeof(rsa_oaep_28_n),
	.d = (const u8*)&rsa_oaep_28_d,
	.dlen = sizeof(rsa_oaep_28_d),
	.e = (const u8*)&rsa_oaep_28_e,
	.elen = sizeof(rsa_oaep_28_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_28_m,
	.mlen = sizeof(rsa_oaep_28_m),
	.res = (const u8*)&rsa_oaep_28_res,
	.reslen = sizeof(rsa_oaep_28_res),
	.salt = (const u8*)&rsa_oaep_28_salt,
	.saltlen = sizeof(rsa_oaep_28_salt),
};
static const u8 rsa_oaep_29_CRT_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_29_CRT_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_29_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_29_CRT_m[] = {
0xd9, 0x4c, 0xd0, 0xe0, 0x8f, 0xa4, 0x04, 0xed, 0x89, 
};
static const u8 rsa_oaep_29_CRT_res[] = {
0x02, 0x39, 0xbc, 0xe6, 0x81, 0x03, 0x24, 0x41, 0x52, 0x88, 0x77, 0xd6, 0xd1, 0xc8, 0xbb, 0x28, 0xaa, 0x3b, 0xc9, 0x7f, 0x1d, 0xf5, 0x84, 0x56, 0x36, 0x18, 0x99, 0x57, 0x97, 0x68, 0x38, 0x44, 0xca, 0x86, 0x66, 0x47, 0x32, 0xf4, 0xbe, 0xd7, 0xa0, 0xaa, 0xb0, 0x83, 0xaa, 0xab, 0xfb, 0x72, 0x38, 0xf5, 0x82, 0xe3, 0x09, 0x58, 0xc2, 0x02, 0x4e, 0x44, 0xe5, 0x70, 0x43, 0xb9, 0x79, 0x50, 0xfd, 0x54, 0x3d, 0xa9, 0x77, 0xc9, 0x0c, 0xdd, 0xe5, 0x33, 0x7d, 0x61, 0x84, 0x42, 0xf9, 0x9e, 0x60, 0xd7, 0x78, 0x3a, 0xb5, 0x9c, 0xe6, 0xdd, 0x9d, 0x69, 0xc4, 0x7a, 0xd1, 0xe9, 0x62, 0xbe, 0xc2, 0x2d, 0x05, 0x89, 0x5c, 0xff, 0x8d, 0x3f, 0x64, 0xed, 0x52, 0x61, 0xd9, 0x2b, 0x26, 0x78, 0x51, 0x03, 0x93, 0x48, 0x49, 0x90, 0xba, 0x3f, 0x7f, 0x06, 0x81, 0x8a, 0xe6, 0xff, 0xce, 0x8a, 0x3a, 
};
static const u8 rsa_oaep_29_CRT_salt[] = {
0xce, 0x89, 0x28, 0xf6, 0x05, 0x95, 0x58, 0x25, 0x40, 0x08, 0xba, 0xdd, 0x97, 0x94, 0xfa, 0xdc, 0xd2, 0xfd, 0x1f, 0x65, 
};
static const u8 rsa_oaep_29_CRT_p[] = {
0x01, 0xbf, 0x01, 0xd2, 0x16, 0xd7, 0x35, 0x95, 0xcf, 0x02, 0x70, 0xc2, 0xbe, 0xb7, 0x8d, 0x40, 0xa0, 0xd8, 0x44, 0x7d, 0x31, 0xda, 0x91, 0x9a, 0x98, 0x3f, 0x7e, 0xea, 0x78, 0x1b, 0x77, 0xd8, 0x5f, 0xe3, 0x71, 0xb3, 0xe9, 0x37, 0x3e, 0x7b, 0x69, 0x21, 0x7d, 0x31, 0x50, 0xa0, 0x2d, 0x89, 0x58, 0xde, 0x7f, 0xad, 0x9d, 0x55, 0x51, 0x60, 0x95, 0x8b, 0x44, 0x54, 0x12, 0x7e, 0x0e, 0x7e, 0xaf, 
};
static const u8 rsa_oaep_29_CRT_q[] = {
0x01, 0x8d, 0x33, 0x99, 0x65, 0x81, 0x66, 0xdb, 0x38, 0x29, 0x81, 0x6d, 0x7b, 0x29, 0x54, 0x16, 0x75, 0x9e, 0x9c, 0x91, 0x98, 0x7f, 0x5b, 0x2d, 0x8a, 0xec, 0xd6, 0x3b, 0x04, 0xb4, 0x8b, 0xd7, 0xb2, 0xfc, 0xf2, 0x29, 0xbb, 0x7f, 0x8a, 0x6d, 0xc8, 0x8b, 0xa1, 0x3d, 0xd2, 0xe3, 0x9a, 0xd5, 0x5b, 0x6d, 0x1a, 0x06, 0x16, 0x07, 0x08, 0xf9, 0x70, 0x0b, 0xe8, 0x0b, 0x8f, 0xd3, 0x74, 0x4c, 0xe7, 
};
static const u8 rsa_oaep_29_CRT_dP[] = {
0x06, 0xc0, 0xa2, 0x49, 0xd2, 0x0a, 0x6f, 0x2e, 0xe7, 0x5c, 0x88, 0xb4, 0x94, 0xd5, 0x3f, 0x6a, 0xae, 0x99, 0xaa, 0x42, 0x7c, 0x88, 0xc2, 0x8b, 0x16, 0x3a, 0x76, 0x94, 0x45, 0xe5, 0xf3, 0x90, 0xcf, 0x40, 0xc2, 0x74, 0xfd, 0x6e, 0xa6, 0x32, 0x9a, 0x5c, 0xe7, 0xc7, 0xce, 0x03, 0xa2, 0x15, 0x83, 0x96, 0xee, 0x2a, 0x78, 0x45, 0x78, 0x6e, 0x09, 0xe2, 0x88, 0x5a, 0x97, 0x28, 0xe4, 0xe5, 
};
static const u8 rsa_oaep_29_CRT_dQ[] = {
0xd1, 0xd2, 0x7c, 0x29, 0xfe, 0xdd, 0x92, 0xd8, 0x6c, 0x34, 0x8e, 0xdd, 0x0c, 0xcb, 0xfa, 0xc1, 0x4f, 0x74, 0x6e, 0x05, 0x1c, 0xe1, 0xd1, 0x81, 0x1d, 0xf3, 0x5d, 0x61, 0xf2, 0xee, 0x1c, 0x97, 0xd4, 0xbf, 0x28, 0x04, 0x80, 0x2f, 0x64, 0x27, 0x18, 0x7b, 0xa8, 0xe9, 0x0a, 0x8a, 0xf4, 0x42, 0x43, 0xb4, 0x07, 0x9b, 0x03, 0x44, 0x5e, 0x60, 0x2e, 0x29, 0xfa, 0x51, 0x93, 0xe6, 0x4f, 0xe9, 
};
static const u8 rsa_oaep_29_CRT_qInv[] = {
0x8c, 0xb2, 0xf7, 0x56, 0xbd, 0x89, 0x41, 0xb1, 0xd3, 0xb7, 0x70, 0xe5, 0xad, 0x31, 0xee, 0x37, 0x3b, 0x28, 0xac, 0xda, 0x69, 0xff, 0x9b, 0x6f, 0x40, 0xfe, 0x57, 0x8b, 0x9f, 0x1a, 0xfb, 0x85, 0x83, 0x6f, 0x96, 0x27, 0xd3, 0x7a, 0xcf, 0xf7, 0x3c, 0x27, 0x79, 0xe6, 0x34, 0xbb, 0x26, 0x01, 0x1c, 0x2c, 0x8f, 0x7f, 0x33, 0x61, 0xae, 0x2a, 0x9e, 0xa6, 0x5e, 0xd6, 0x89, 0xe3, 0x63, 0x9a, 
};


static const rsa_test test_rsa_oaep_29_CRT = {
	.name = "rsa_oaep_29_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_29_CRT_n,
	.nlen = sizeof(rsa_oaep_29_CRT_n),
	.d = (const u8*)&rsa_oaep_29_CRT_d,
	.dlen = sizeof(rsa_oaep_29_CRT_d),
	.e = (const u8*)&rsa_oaep_29_CRT_e,
	.elen = sizeof(rsa_oaep_29_CRT_e),
	.p = (const u8*)&rsa_oaep_29_CRT_p,
	.plen = sizeof(rsa_oaep_29_CRT_p),
	.q = (const u8*)&rsa_oaep_29_CRT_q,
	.qlen = sizeof(rsa_oaep_29_CRT_q),
	.dP = (const u8*)&rsa_oaep_29_CRT_dP,
	.dPlen = sizeof(rsa_oaep_29_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_29_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_29_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_29_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_29_CRT_qInv),
	.m = (const u8*)&rsa_oaep_29_CRT_m,
	.mlen = sizeof(rsa_oaep_29_CRT_m),
	.res = (const u8*)&rsa_oaep_29_CRT_res,
	.reslen = sizeof(rsa_oaep_29_CRT_res),
	.salt = (const u8*)&rsa_oaep_29_CRT_salt,
	.saltlen = sizeof(rsa_oaep_29_CRT_salt),
};
static const u8 rsa_oaep_30_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_30_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_30_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_30_m[] = {
0x6c, 0xc6, 0x41, 0xb6, 0xb6, 0x1e, 0x6f, 0x96, 0x39, 0x74, 0xda, 0xd2, 0x3a, 0x90, 0x13, 0x28, 0x4e, 0xf1, 
};
static const u8 rsa_oaep_30_res[] = {
0x02, 0x99, 0x4c, 0x62, 0xaf, 0xd7, 0x6f, 0x49, 0x8b, 0xa1, 0xfd, 0x2c, 0xf6, 0x42, 0x85, 0x7f, 0xca, 0x81, 0xf4, 0x37, 0x3c, 0xb0, 0x8f, 0x1c, 0xba, 0xee, 0x6f, 0x02, 0x5c, 0x3b, 0x51, 0x2b, 0x42, 0xc3, 0xe8, 0x77, 0x91, 0x13, 0x47, 0x66, 0x48, 0x03, 0x9d, 0xbe, 0x04, 0x93, 0xf9, 0x24, 0x62, 0x92, 0xfa, 0xc2, 0x89, 0x50, 0x60, 0x0e, 0x7c, 0x0f, 0x32, 0xed, 0xf9, 0xc8, 0x1b, 0x9d, 0xec, 0x45, 0xc3, 0xbd, 0xe0, 0xcc, 0x8d, 0x88, 0x47, 0x59, 0x01, 0x69, 0x90, 0x7b, 0x7d, 0xc5, 0x99, 0x1c, 0xeb, 0x29, 0xbb, 0x07, 0x14, 0xd6, 0x13, 0xd9, 0x6d, 0xf0, 0xf1, 0x2e, 0xc5, 0xd8, 0xd3, 0x50, 0x7c, 0x8e, 0xe7, 0xae, 0x78, 0xdd, 0x83, 0xf2, 0x16, 0xfa, 0x61, 0xde, 0x10, 0x03, 0x63, 0xac, 0xa4, 0x8a, 0x7e, 0x91, 0x4a, 0xe9, 0xf4, 0x2d, 0xdf, 0xbe, 0x94, 0x3b, 0x09, 0xd9, 0xa0, 
};
static const u8 rsa_oaep_30_salt[] = {
0x6e, 0x29, 0x79, 0xf5, 0x2d, 0x68, 0x14, 0xa5, 0x7d, 0x83, 0xb0, 0x90, 0x05, 0x48, 0x88, 0xf1, 0x19, 0xa5, 0xb9, 0xa3, 
};


static const rsa_test test_rsa_oaep_30 = {
	.name = "rsa_oaep_30",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_30_n,
	.nlen = sizeof(rsa_oaep_30_n),
	.d = (const u8*)&rsa_oaep_30_d,
	.dlen = sizeof(rsa_oaep_30_d),
	.e = (const u8*)&rsa_oaep_30_e,
	.elen = sizeof(rsa_oaep_30_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_30_m,
	.mlen = sizeof(rsa_oaep_30_m),
	.res = (const u8*)&rsa_oaep_30_res,
	.reslen = sizeof(rsa_oaep_30_res),
	.salt = (const u8*)&rsa_oaep_30_salt,
	.saltlen = sizeof(rsa_oaep_30_salt),
};
static const u8 rsa_oaep_31_CRT_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_31_CRT_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_31_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_31_CRT_m[] = {
0x6c, 0xc6, 0x41, 0xb6, 0xb6, 0x1e, 0x6f, 0x96, 0x39, 0x74, 0xda, 0xd2, 0x3a, 0x90, 0x13, 0x28, 0x4e, 0xf1, 
};
static const u8 rsa_oaep_31_CRT_res[] = {
0x02, 0x99, 0x4c, 0x62, 0xaf, 0xd7, 0x6f, 0x49, 0x8b, 0xa1, 0xfd, 0x2c, 0xf6, 0x42, 0x85, 0x7f, 0xca, 0x81, 0xf4, 0x37, 0x3c, 0xb0, 0x8f, 0x1c, 0xba, 0xee, 0x6f, 0x02, 0x5c, 0x3b, 0x51, 0x2b, 0x42, 0xc3, 0xe8, 0x77, 0x91, 0x13, 0x47, 0x66, 0x48, 0x03, 0x9d, 0xbe, 0x04, 0x93, 0xf9, 0x24, 0x62, 0x92, 0xfa, 0xc2, 0x89, 0x50, 0x60, 0x0e, 0x7c, 0x0f, 0x32, 0xed, 0xf9, 0xc8, 0x1b, 0x9d, 0xec, 0x45, 0xc3, 0xbd, 0xe0, 0xcc, 0x8d, 0x88, 0x47, 0x59, 0x01, 0x69, 0x90, 0x7b, 0x7d, 0xc5, 0x99, 0x1c, 0xeb, 0x29, 0xbb, 0x07, 0x14, 0xd6, 0x13, 0xd9, 0x6d, 0xf0, 0xf1, 0x2e, 0xc5, 0xd8, 0xd3, 0x50, 0x7c, 0x8e, 0xe7, 0xae, 0x78, 0xdd, 0x83, 0xf2, 0x16, 0xfa, 0x61, 0xde, 0x10, 0x03, 0x63, 0xac, 0xa4, 0x8a, 0x7e, 0x91, 0x4a, 0xe9, 0xf4, 0x2d, 0xdf, 0xbe, 0x94, 0x3b, 0x09, 0xd9, 0xa0, 
};
static const u8 rsa_oaep_31_CRT_salt[] = {
0x6e, 0x29, 0x79, 0xf5, 0x2d, 0x68, 0x14, 0xa5, 0x7d, 0x83, 0xb0, 0x90, 0x05, 0x48, 0x88, 0xf1, 0x19, 0xa5, 0xb9, 0xa3, 
};
static const u8 rsa_oaep_31_CRT_p[] = {
0x01, 0xbf, 0x01, 0xd2, 0x16, 0xd7, 0x35, 0x95, 0xcf, 0x02, 0x70, 0xc2, 0xbe, 0xb7, 0x8d, 0x40, 0xa0, 0xd8, 0x44, 0x7d, 0x31, 0xda, 0x91, 0x9a, 0x98, 0x3f, 0x7e, 0xea, 0x78, 0x1b, 0x77, 0xd8, 0x5f, 0xe3, 0x71, 0xb3, 0xe9, 0x37, 0x3e, 0x7b, 0x69, 0x21, 0x7d, 0x31, 0x50, 0xa0, 0x2d, 0x89, 0x58, 0xde, 0x7f, 0xad, 0x9d, 0x55, 0x51, 0x60, 0x95, 0x8b, 0x44, 0x54, 0x12, 0x7e, 0x0e, 0x7e, 0xaf, 
};
static const u8 rsa_oaep_31_CRT_q[] = {
0x01, 0x8d, 0x33, 0x99, 0x65, 0x81, 0x66, 0xdb, 0x38, 0x29, 0x81, 0x6d, 0x7b, 0x29, 0x54, 0x16, 0x75, 0x9e, 0x9c, 0x91, 0x98, 0x7f, 0x5b, 0x2d, 0x8a, 0xec, 0xd6, 0x3b, 0x04, 0xb4, 0x8b, 0xd7, 0xb2, 0xfc, 0xf2, 0x29, 0xbb, 0x7f, 0x8a, 0x6d, 0xc8, 0x8b, 0xa1, 0x3d, 0xd2, 0xe3, 0x9a, 0xd5, 0x5b, 0x6d, 0x1a, 0x06, 0x16, 0x07, 0x08, 0xf9, 0x70, 0x0b, 0xe8, 0x0b, 0x8f, 0xd3, 0x74, 0x4c, 0xe7, 
};
static const u8 rsa_oaep_31_CRT_dP[] = {
0x06, 0xc0, 0xa2, 0x49, 0xd2, 0x0a, 0x6f, 0x2e, 0xe7, 0x5c, 0x88, 0xb4, 0x94, 0xd5, 0x3f, 0x6a, 0xae, 0x99, 0xaa, 0x42, 0x7c, 0x88, 0xc2, 0x8b, 0x16, 0x3a, 0x76, 0x94, 0x45, 0xe5, 0xf3, 0x90, 0xcf, 0x40, 0xc2, 0x74, 0xfd, 0x6e, 0xa6, 0x32, 0x9a, 0x5c, 0xe7, 0xc7, 0xce, 0x03, 0xa2, 0x15, 0x83, 0x96, 0xee, 0x2a, 0x78, 0x45, 0x78, 0x6e, 0x09, 0xe2, 0x88, 0x5a, 0x97, 0x28, 0xe4, 0xe5, 
};
static const u8 rsa_oaep_31_CRT_dQ[] = {
0xd1, 0xd2, 0x7c, 0x29, 0xfe, 0xdd, 0x92, 0xd8, 0x6c, 0x34, 0x8e, 0xdd, 0x0c, 0xcb, 0xfa, 0xc1, 0x4f, 0x74, 0x6e, 0x05, 0x1c, 0xe1, 0xd1, 0x81, 0x1d, 0xf3, 0x5d, 0x61, 0xf2, 0xee, 0x1c, 0x97, 0xd4, 0xbf, 0x28, 0x04, 0x80, 0x2f, 0x64, 0x27, 0x18, 0x7b, 0xa8, 0xe9, 0x0a, 0x8a, 0xf4, 0x42, 0x43, 0xb4, 0x07, 0x9b, 0x03, 0x44, 0x5e, 0x60, 0x2e, 0x29, 0xfa, 0x51, 0x93, 0xe6, 0x4f, 0xe9, 
};
static const u8 rsa_oaep_31_CRT_qInv[] = {
0x8c, 0xb2, 0xf7, 0x56, 0xbd, 0x89, 0x41, 0xb1, 0xd3, 0xb7, 0x70, 0xe5, 0xad, 0x31, 0xee, 0x37, 0x3b, 0x28, 0xac, 0xda, 0x69, 0xff, 0x9b, 0x6f, 0x40, 0xfe, 0x57, 0x8b, 0x9f, 0x1a, 0xfb, 0x85, 0x83, 0x6f, 0x96, 0x27, 0xd3, 0x7a, 0xcf, 0xf7, 0x3c, 0x27, 0x79, 0xe6, 0x34, 0xbb, 0x26, 0x01, 0x1c, 0x2c, 0x8f, 0x7f, 0x33, 0x61, 0xae, 0x2a, 0x9e, 0xa6, 0x5e, 0xd6, 0x89, 0xe3, 0x63, 0x9a, 
};


static const rsa_test test_rsa_oaep_31_CRT = {
	.name = "rsa_oaep_31_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_31_CRT_n,
	.nlen = sizeof(rsa_oaep_31_CRT_n),
	.d = (const u8*)&rsa_oaep_31_CRT_d,
	.dlen = sizeof(rsa_oaep_31_CRT_d),
	.e = (const u8*)&rsa_oaep_31_CRT_e,
	.elen = sizeof(rsa_oaep_31_CRT_e),
	.p = (const u8*)&rsa_oaep_31_CRT_p,
	.plen = sizeof(rsa_oaep_31_CRT_p),
	.q = (const u8*)&rsa_oaep_31_CRT_q,
	.qlen = sizeof(rsa_oaep_31_CRT_q),
	.dP = (const u8*)&rsa_oaep_31_CRT_dP,
	.dPlen = sizeof(rsa_oaep_31_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_31_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_31_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_31_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_31_CRT_qInv),
	.m = (const u8*)&rsa_oaep_31_CRT_m,
	.mlen = sizeof(rsa_oaep_31_CRT_m),
	.res = (const u8*)&rsa_oaep_31_CRT_res,
	.reslen = sizeof(rsa_oaep_31_CRT_res),
	.salt = (const u8*)&rsa_oaep_31_CRT_salt,
	.saltlen = sizeof(rsa_oaep_31_CRT_salt),
};
static const u8 rsa_oaep_32_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_32_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_32_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_32_m[] = {
0xdf, 0x51, 0x51, 0x83, 0x2b, 0x61, 0xf4, 0xf2, 0x58, 0x91, 0xfb, 0x41, 0x72, 0xf3, 0x28, 0xd2, 0xed, 0xdf, 0x83, 0x71, 0xff, 0xcf, 0xdb, 0xe9, 0x97, 0x93, 0x92, 0x95, 0xf3, 0x0e, 0xca, 0x69, 0x18, 0x01, 0x7c, 0xfd, 0xa1, 0x15, 0x3b, 0xf7, 0xa6, 0xaf, 0x87, 0x59, 0x32, 0x23, 
};
static const u8 rsa_oaep_32_res[] = {
0x01, 0x62, 0x04, 0x2f, 0xf6, 0x96, 0x95, 0x92, 0xa6, 0x16, 0x70, 0x31, 0x81, 0x1a, 0x23, 0x98, 0x34, 0xce, 0x63, 0x8a, 0xbf, 0x54, 0xfe, 0xc8, 0xb9, 0x94, 0x78, 0x12, 0x2a, 0xfe, 0x2e, 0xe6, 0x7f, 0x8c, 0x5b, 0x18, 0xb0, 0x33, 0x98, 0x05, 0xbf, 0xdb, 0xc5, 0xa4, 0xe6, 0x72, 0x0b, 0x37, 0xc5, 0x9c, 0xfb, 0xa9, 0x42, 0x46, 0x4c, 0x59, 0x7f, 0xf5, 0x32, 0xa1, 0x19, 0x82, 0x15, 0x45, 0xfd, 0x2e, 0x59, 0xb1, 0x14, 0xe6, 0x1d, 0xaf, 0x71, 0x82, 0x05, 0x29, 0xf5, 0x02, 0x9c, 0xf5, 0x24, 0x95, 0x43, 0x27, 0xc3, 0x4e, 0xc5, 0xe6, 0xf5, 0xba, 0x7e, 0xfc, 0xc4, 0xde, 0x94, 0x3a, 0xb8, 0xad, 0x4e, 0xd7, 0x87, 0xb1, 0x45, 0x43, 0x29, 0xf7, 0x0d, 0xb7, 0x98, 0xa3, 0xa8, 0xf4, 0xd9, 0x2f, 0x82, 0x74, 0xe2, 0xb2, 0x94, 0x8a, 0xde, 0x62, 0x7c, 0xe8, 0xee, 0x33, 0xe4, 0x3c, 0x60, 
};
static const u8 rsa_oaep_32_salt[] = {
0x2d, 0x76, 0x0b, 0xfe, 0x38, 0xc5, 0x9d, 0xe3, 0x4c, 0xdc, 0x8b, 0x8c, 0x78, 0xa3, 0x8e, 0x66, 0x28, 0x4a, 0x2d, 0x27, 
};


static const rsa_test test_rsa_oaep_32 = {
	.name = "rsa_oaep_32",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_32_n,
	.nlen = sizeof(rsa_oaep_32_n),
	.d = (const u8*)&rsa_oaep_32_d,
	.dlen = sizeof(rsa_oaep_32_d),
	.e = (const u8*)&rsa_oaep_32_e,
	.elen = sizeof(rsa_oaep_32_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_32_m,
	.mlen = sizeof(rsa_oaep_32_m),
	.res = (const u8*)&rsa_oaep_32_res,
	.reslen = sizeof(rsa_oaep_32_res),
	.salt = (const u8*)&rsa_oaep_32_salt,
	.saltlen = sizeof(rsa_oaep_32_salt),
};
static const u8 rsa_oaep_33_CRT_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_33_CRT_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_33_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_33_CRT_m[] = {
0xdf, 0x51, 0x51, 0x83, 0x2b, 0x61, 0xf4, 0xf2, 0x58, 0x91, 0xfb, 0x41, 0x72, 0xf3, 0x28, 0xd2, 0xed, 0xdf, 0x83, 0x71, 0xff, 0xcf, 0xdb, 0xe9, 0x97, 0x93, 0x92, 0x95, 0xf3, 0x0e, 0xca, 0x69, 0x18, 0x01, 0x7c, 0xfd, 0xa1, 0x15, 0x3b, 0xf7, 0xa6, 0xaf, 0x87, 0x59, 0x32, 0x23, 
};
static const u8 rsa_oaep_33_CRT_res[] = {
0x01, 0x62, 0x04, 0x2f, 0xf6, 0x96, 0x95, 0x92, 0xa6, 0x16, 0x70, 0x31, 0x81, 0x1a, 0x23, 0x98, 0x34, 0xce, 0x63, 0x8a, 0xbf, 0x54, 0xfe, 0xc8, 0xb9, 0x94, 0x78, 0x12, 0x2a, 0xfe, 0x2e, 0xe6, 0x7f, 0x8c, 0x5b, 0x18, 0xb0, 0x33, 0x98, 0x05, 0xbf, 0xdb, 0xc5, 0xa4, 0xe6, 0x72, 0x0b, 0x37, 0xc5, 0x9c, 0xfb, 0xa9, 0x42, 0x46, 0x4c, 0x59, 0x7f, 0xf5, 0x32, 0xa1, 0x19, 0x82, 0x15, 0x45, 0xfd, 0x2e, 0x59, 0xb1, 0x14, 0xe6, 0x1d, 0xaf, 0x71, 0x82, 0x05, 0x29, 0xf5, 0x02, 0x9c, 0xf5, 0x24, 0x95, 0x43, 0x27, 0xc3, 0x4e, 0xc5, 0xe6, 0xf5, 0xba, 0x7e, 0xfc, 0xc4, 0xde, 0x94, 0x3a, 0xb8, 0xad, 0x4e, 0xd7, 0x87, 0xb1, 0x45, 0x43, 0x29, 0xf7, 0x0d, 0xb7, 0x98, 0xa3, 0xa8, 0xf4, 0xd9, 0x2f, 0x82, 0x74, 0xe2, 0xb2, 0x94, 0x8a, 0xde, 0x62, 0x7c, 0xe8, 0xee, 0x33, 0xe4, 0x3c, 0x60, 
};
static const u8 rsa_oaep_33_CRT_salt[] = {
0x2d, 0x76, 0x0b, 0xfe, 0x38, 0xc5, 0x9d, 0xe3, 0x4c, 0xdc, 0x8b, 0x8c, 0x78, 0xa3, 0x8e, 0x66, 0x28, 0x4a, 0x2d, 0x27, 
};
static const u8 rsa_oaep_33_CRT_p[] = {
0x01, 0xbf, 0x01, 0xd2, 0x16, 0xd7, 0x35, 0x95, 0xcf, 0x02, 0x70, 0xc2, 0xbe, 0xb7, 0x8d, 0x40, 0xa0, 0xd8, 0x44, 0x7d, 0x31, 0xda, 0x91, 0x9a, 0x98, 0x3f, 0x7e, 0xea, 0x78, 0x1b, 0x77, 0xd8, 0x5f, 0xe3, 0x71, 0xb3, 0xe9, 0x37, 0x3e, 0x7b, 0x69, 0x21, 0x7d, 0x31, 0x50, 0xa0, 0x2d, 0x89, 0x58, 0xde, 0x7f, 0xad, 0x9d, 0x55, 0x51, 0x60, 0x95, 0x8b, 0x44, 0x54, 0x12, 0x7e, 0x0e, 0x7e, 0xaf, 
};
static const u8 rsa_oaep_33_CRT_q[] = {
0x01, 0x8d, 0x33, 0x99, 0x65, 0x81, 0x66, 0xdb, 0x38, 0x29, 0x81, 0x6d, 0x7b, 0x29, 0x54, 0x16, 0x75, 0x9e, 0x9c, 0x91, 0x98, 0x7f, 0x5b, 0x2d, 0x8a, 0xec, 0xd6, 0x3b, 0x04, 0xb4, 0x8b, 0xd7, 0xb2, 0xfc, 0xf2, 0x29, 0xbb, 0x7f, 0x8a, 0x6d, 0xc8, 0x8b, 0xa1, 0x3d, 0xd2, 0xe3, 0x9a, 0xd5, 0x5b, 0x6d, 0x1a, 0x06, 0x16, 0x07, 0x08, 0xf9, 0x70, 0x0b, 0xe8, 0x0b, 0x8f, 0xd3, 0x74, 0x4c, 0xe7, 
};
static const u8 rsa_oaep_33_CRT_dP[] = {
0x06, 0xc0, 0xa2, 0x49, 0xd2, 0x0a, 0x6f, 0x2e, 0xe7, 0x5c, 0x88, 0xb4, 0x94, 0xd5, 0x3f, 0x6a, 0xae, 0x99, 0xaa, 0x42, 0x7c, 0x88, 0xc2, 0x8b, 0x16, 0x3a, 0x76, 0x94, 0x45, 0xe5, 0xf3, 0x90, 0xcf, 0x40, 0xc2, 0x74, 0xfd, 0x6e, 0xa6, 0x32, 0x9a, 0x5c, 0xe7, 0xc7, 0xce, 0x03, 0xa2, 0x15, 0x83, 0x96, 0xee, 0x2a, 0x78, 0x45, 0x78, 0x6e, 0x09, 0xe2, 0x88, 0x5a, 0x97, 0x28, 0xe4, 0xe5, 
};
static const u8 rsa_oaep_33_CRT_dQ[] = {
0xd1, 0xd2, 0x7c, 0x29, 0xfe, 0xdd, 0x92, 0xd8, 0x6c, 0x34, 0x8e, 0xdd, 0x0c, 0xcb, 0xfa, 0xc1, 0x4f, 0x74, 0x6e, 0x05, 0x1c, 0xe1, 0xd1, 0x81, 0x1d, 0xf3, 0x5d, 0x61, 0xf2, 0xee, 0x1c, 0x97, 0xd4, 0xbf, 0x28, 0x04, 0x80, 0x2f, 0x64, 0x27, 0x18, 0x7b, 0xa8, 0xe9, 0x0a, 0x8a, 0xf4, 0x42, 0x43, 0xb4, 0x07, 0x9b, 0x03, 0x44, 0x5e, 0x60, 0x2e, 0x29, 0xfa, 0x51, 0x93, 0xe6, 0x4f, 0xe9, 
};
static const u8 rsa_oaep_33_CRT_qInv[] = {
0x8c, 0xb2, 0xf7, 0x56, 0xbd, 0x89, 0x41, 0xb1, 0xd3, 0xb7, 0x70, 0xe5, 0xad, 0x31, 0xee, 0x37, 0x3b, 0x28, 0xac, 0xda, 0x69, 0xff, 0x9b, 0x6f, 0x40, 0xfe, 0x57, 0x8b, 0x9f, 0x1a, 0xfb, 0x85, 0x83, 0x6f, 0x96, 0x27, 0xd3, 0x7a, 0xcf, 0xf7, 0x3c, 0x27, 0x79, 0xe6, 0x34, 0xbb, 0x26, 0x01, 0x1c, 0x2c, 0x8f, 0x7f, 0x33, 0x61, 0xae, 0x2a, 0x9e, 0xa6, 0x5e, 0xd6, 0x89, 0xe3, 0x63, 0x9a, 
};


static const rsa_test test_rsa_oaep_33_CRT = {
	.name = "rsa_oaep_33_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_33_CRT_n,
	.nlen = sizeof(rsa_oaep_33_CRT_n),
	.d = (const u8*)&rsa_oaep_33_CRT_d,
	.dlen = sizeof(rsa_oaep_33_CRT_d),
	.e = (const u8*)&rsa_oaep_33_CRT_e,
	.elen = sizeof(rsa_oaep_33_CRT_e),
	.p = (const u8*)&rsa_oaep_33_CRT_p,
	.plen = sizeof(rsa_oaep_33_CRT_p),
	.q = (const u8*)&rsa_oaep_33_CRT_q,
	.qlen = sizeof(rsa_oaep_33_CRT_q),
	.dP = (const u8*)&rsa_oaep_33_CRT_dP,
	.dPlen = sizeof(rsa_oaep_33_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_33_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_33_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_33_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_33_CRT_qInv),
	.m = (const u8*)&rsa_oaep_33_CRT_m,
	.mlen = sizeof(rsa_oaep_33_CRT_m),
	.res = (const u8*)&rsa_oaep_33_CRT_res,
	.reslen = sizeof(rsa_oaep_33_CRT_res),
	.salt = (const u8*)&rsa_oaep_33_CRT_salt,
	.saltlen = sizeof(rsa_oaep_33_CRT_salt),
};
static const u8 rsa_oaep_34_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_34_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_34_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_34_m[] = {
0x3c, 0x3b, 0xad, 0x89, 0x3c, 0x54, 0x4a, 0x6d, 0x52, 0x0a, 0xb0, 0x22, 0x31, 0x91, 0x88, 0xc8, 0xd5, 0x04, 0xb7, 0xa7, 0x88, 0xb8, 0x50, 0x90, 0x3b, 0x85, 0x97, 0x2e, 0xaa, 0x18, 0x55, 0x2e, 0x11, 0x34, 0xa7, 0xad, 0x60, 0x98, 0x82, 0x62, 0x54, 0xff, 0x7a, 0xb6, 0x72, 0xb3, 0xd8, 0xeb, 0x31, 0x58, 0xfa, 0xc6, 0xd4, 0xcb, 0xae, 0xf1, 
};
static const u8 rsa_oaep_34_res[] = {
0x00, 0x11, 0x20, 0x51, 0xe7, 0x5d, 0x06, 0x49, 0x43, 0xbc, 0x44, 0x78, 0x07, 0x5e, 0x43, 0x48, 0x2f, 0xd5, 0x9c, 0xee, 0x06, 0x79, 0xde, 0x68, 0x93, 0xee, 0xc3, 0xa9, 0x43, 0xda, 0xa4, 0x90, 0xb9, 0x69, 0x1c, 0x93, 0xdf, 0xc0, 0x46, 0x4b, 0x66, 0x23, 0xb9, 0xf3, 0xdb, 0xd3, 0xe7, 0x00, 0x83, 0x26, 0x4f, 0x03, 0x4b, 0x37, 0x4f, 0x74, 0x16, 0x4e, 0x1a, 0x00, 0x76, 0x37, 0x25, 0xe5, 0x74, 0x74, 0x4b, 0xa0, 0xb9, 0xdb, 0x83, 0x43, 0x4f, 0x31, 0xdf, 0x96, 0xf6, 0xe2, 0xa2, 0x6f, 0x6d, 0x8e, 0xba, 0x34, 0x8b, 0xd4, 0x68, 0x6c, 0x22, 0x38, 0xac, 0x07, 0xc3, 0x7a, 0xac, 0x37, 0x85, 0xd1, 0xc7, 0xee, 0xa2, 0xf8, 0x19, 0xfd, 0x91, 0x49, 0x17, 0x98, 0xed, 0x8e, 0x9c, 0xef, 0x5e, 0x43, 0xb7, 0x81, 0xb0, 0xe0, 0x27, 0x6e, 0x37, 0xc4, 0x3f, 0xf9, 0x49, 0x2d, 0x00, 0x57, 0x30, 
};
static const u8 rsa_oaep_34_salt[] = {
0xf1, 0x74, 0x77, 0x9c, 0x5f, 0xd3, 0xcf, 0xe0, 0x07, 0xba, 0xdc, 0xb7, 0xa3, 0x6c, 0x9b, 0x55, 0xbf, 0xcf, 0xbf, 0x0e, 
};


static const rsa_test test_rsa_oaep_34 = {
	.name = "rsa_oaep_34",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_34_n,
	.nlen = sizeof(rsa_oaep_34_n),
	.d = (const u8*)&rsa_oaep_34_d,
	.dlen = sizeof(rsa_oaep_34_d),
	.e = (const u8*)&rsa_oaep_34_e,
	.elen = sizeof(rsa_oaep_34_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_34_m,
	.mlen = sizeof(rsa_oaep_34_m),
	.res = (const u8*)&rsa_oaep_34_res,
	.reslen = sizeof(rsa_oaep_34_res),
	.salt = (const u8*)&rsa_oaep_34_salt,
	.saltlen = sizeof(rsa_oaep_34_salt),
};
static const u8 rsa_oaep_35_CRT_n[] = {
0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9, 
};
static const u8 rsa_oaep_35_CRT_d[] = {
0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd, 
};
static const u8 rsa_oaep_35_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_35_CRT_m[] = {
0x3c, 0x3b, 0xad, 0x89, 0x3c, 0x54, 0x4a, 0x6d, 0x52, 0x0a, 0xb0, 0x22, 0x31, 0x91, 0x88, 0xc8, 0xd5, 0x04, 0xb7, 0xa7, 0x88, 0xb8, 0x50, 0x90, 0x3b, 0x85, 0x97, 0x2e, 0xaa, 0x18, 0x55, 0x2e, 0x11, 0x34, 0xa7, 0xad, 0x60, 0x98, 0x82, 0x62, 0x54, 0xff, 0x7a, 0xb6, 0x72, 0xb3, 0xd8, 0xeb, 0x31, 0x58, 0xfa, 0xc6, 0xd4, 0xcb, 0xae, 0xf1, 
};
static const u8 rsa_oaep_35_CRT_res[] = {
0x00, 0x11, 0x20, 0x51, 0xe7, 0x5d, 0x06, 0x49, 0x43, 0xbc, 0x44, 0x78, 0x07, 0x5e, 0x43, 0x48, 0x2f, 0xd5, 0x9c, 0xee, 0x06, 0x79, 0xde, 0x68, 0x93, 0xee, 0xc3, 0xa9, 0x43, 0xda, 0xa4, 0x90, 0xb9, 0x69, 0x1c, 0x93, 0xdf, 0xc0, 0x46, 0x4b, 0x66, 0x23, 0xb9, 0xf3, 0xdb, 0xd3, 0xe7, 0x00, 0x83, 0x26, 0x4f, 0x03, 0x4b, 0x37, 0x4f, 0x74, 0x16, 0x4e, 0x1a, 0x00, 0x76, 0x37, 0x25, 0xe5, 0x74, 0x74, 0x4b, 0xa0, 0xb9, 0xdb, 0x83, 0x43, 0x4f, 0x31, 0xdf, 0x96, 0xf6, 0xe2, 0xa2, 0x6f, 0x6d, 0x8e, 0xba, 0x34, 0x8b, 0xd4, 0x68, 0x6c, 0x22, 0x38, 0xac, 0x07, 0xc3, 0x7a, 0xac, 0x37, 0x85, 0xd1, 0xc7, 0xee, 0xa2, 0xf8, 0x19, 0xfd, 0x91, 0x49, 0x17, 0x98, 0xed, 0x8e, 0x9c, 0xef, 0x5e, 0x43, 0xb7, 0x81, 0xb0, 0xe0, 0x27, 0x6e, 0x37, 0xc4, 0x3f, 0xf9, 0x49, 0x2d, 0x00, 0x57, 0x30, 
};
static const u8 rsa_oaep_35_CRT_salt[] = {
0xf1, 0x74, 0x77, 0x9c, 0x5f, 0xd3, 0xcf, 0xe0, 0x07, 0xba, 0xdc, 0xb7, 0xa3, 0x6c, 0x9b, 0x55, 0xbf, 0xcf, 0xbf, 0x0e, 
};
static const u8 rsa_oaep_35_CRT_p[] = {
0x01, 0xbf, 0x01, 0xd2, 0x16, 0xd7, 0x35, 0x95, 0xcf, 0x02, 0x70, 0xc2, 0xbe, 0xb7, 0x8d, 0x40, 0xa0, 0xd8, 0x44, 0x7d, 0x31, 0xda, 0x91, 0x9a, 0x98, 0x3f, 0x7e, 0xea, 0x78, 0x1b, 0x77, 0xd8, 0x5f, 0xe3, 0x71, 0xb3, 0xe9, 0x37, 0x3e, 0x7b, 0x69, 0x21, 0x7d, 0x31, 0x50, 0xa0, 0x2d, 0x89, 0x58, 0xde, 0x7f, 0xad, 0x9d, 0x55, 0x51, 0x60, 0x95, 0x8b, 0x44, 0x54, 0x12, 0x7e, 0x0e, 0x7e, 0xaf, 
};
static const u8 rsa_oaep_35_CRT_q[] = {
0x01, 0x8d, 0x33, 0x99, 0x65, 0x81, 0x66, 0xdb, 0x38, 0x29, 0x81, 0x6d, 0x7b, 0x29, 0x54, 0x16, 0x75, 0x9e, 0x9c, 0x91, 0x98, 0x7f, 0x5b, 0x2d, 0x8a, 0xec, 0xd6, 0x3b, 0x04, 0xb4, 0x8b, 0xd7, 0xb2, 0xfc, 0xf2, 0x29, 0xbb, 0x7f, 0x8a, 0x6d, 0xc8, 0x8b, 0xa1, 0x3d, 0xd2, 0xe3, 0x9a, 0xd5, 0x5b, 0x6d, 0x1a, 0x06, 0x16, 0x07, 0x08, 0xf9, 0x70, 0x0b, 0xe8, 0x0b, 0x8f, 0xd3, 0x74, 0x4c, 0xe7, 
};
static const u8 rsa_oaep_35_CRT_dP[] = {
0x06, 0xc0, 0xa2, 0x49, 0xd2, 0x0a, 0x6f, 0x2e, 0xe7, 0x5c, 0x88, 0xb4, 0x94, 0xd5, 0x3f, 0x6a, 0xae, 0x99, 0xaa, 0x42, 0x7c, 0x88, 0xc2, 0x8b, 0x16, 0x3a, 0x76, 0x94, 0x45, 0xe5, 0xf3, 0x90, 0xcf, 0x40, 0xc2, 0x74, 0xfd, 0x6e, 0xa6, 0x32, 0x9a, 0x5c, 0xe7, 0xc7, 0xce, 0x03, 0xa2, 0x15, 0x83, 0x96, 0xee, 0x2a, 0x78, 0x45, 0x78, 0x6e, 0x09, 0xe2, 0x88, 0x5a, 0x97, 0x28, 0xe4, 0xe5, 
};
static const u8 rsa_oaep_35_CRT_dQ[] = {
0xd1, 0xd2, 0x7c, 0x29, 0xfe, 0xdd, 0x92, 0xd8, 0x6c, 0x34, 0x8e, 0xdd, 0x0c, 0xcb, 0xfa, 0xc1, 0x4f, 0x74, 0x6e, 0x05, 0x1c, 0xe1, 0xd1, 0x81, 0x1d, 0xf3, 0x5d, 0x61, 0xf2, 0xee, 0x1c, 0x97, 0xd4, 0xbf, 0x28, 0x04, 0x80, 0x2f, 0x64, 0x27, 0x18, 0x7b, 0xa8, 0xe9, 0x0a, 0x8a, 0xf4, 0x42, 0x43, 0xb4, 0x07, 0x9b, 0x03, 0x44, 0x5e, 0x60, 0x2e, 0x29, 0xfa, 0x51, 0x93, 0xe6, 0x4f, 0xe9, 
};
static const u8 rsa_oaep_35_CRT_qInv[] = {
0x8c, 0xb2, 0xf7, 0x56, 0xbd, 0x89, 0x41, 0xb1, 0xd3, 0xb7, 0x70, 0xe5, 0xad, 0x31, 0xee, 0x37, 0x3b, 0x28, 0xac, 0xda, 0x69, 0xff, 0x9b, 0x6f, 0x40, 0xfe, 0x57, 0x8b, 0x9f, 0x1a, 0xfb, 0x85, 0x83, 0x6f, 0x96, 0x27, 0xd3, 0x7a, 0xcf, 0xf7, 0x3c, 0x27, 0x79, 0xe6, 0x34, 0xbb, 0x26, 0x01, 0x1c, 0x2c, 0x8f, 0x7f, 0x33, 0x61, 0xae, 0x2a, 0x9e, 0xa6, 0x5e, 0xd6, 0x89, 0xe3, 0x63, 0x9a, 
};


static const rsa_test test_rsa_oaep_35_CRT = {
	.name = "rsa_oaep_35_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_35_CRT_n,
	.nlen = sizeof(rsa_oaep_35_CRT_n),
	.d = (const u8*)&rsa_oaep_35_CRT_d,
	.dlen = sizeof(rsa_oaep_35_CRT_d),
	.e = (const u8*)&rsa_oaep_35_CRT_e,
	.elen = sizeof(rsa_oaep_35_CRT_e),
	.p = (const u8*)&rsa_oaep_35_CRT_p,
	.plen = sizeof(rsa_oaep_35_CRT_p),
	.q = (const u8*)&rsa_oaep_35_CRT_q,
	.qlen = sizeof(rsa_oaep_35_CRT_q),
	.dP = (const u8*)&rsa_oaep_35_CRT_dP,
	.dPlen = sizeof(rsa_oaep_35_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_35_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_35_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_35_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_35_CRT_qInv),
	.m = (const u8*)&rsa_oaep_35_CRT_m,
	.mlen = sizeof(rsa_oaep_35_CRT_m),
	.res = (const u8*)&rsa_oaep_35_CRT_res,
	.reslen = sizeof(rsa_oaep_35_CRT_res),
	.salt = (const u8*)&rsa_oaep_35_CRT_salt,
	.saltlen = sizeof(rsa_oaep_35_CRT_salt),
};
static const u8 rsa_oaep_36_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_36_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_36_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_36_m[] = {
0x4a, 0x86, 0x60, 0x95, 0x34, 0xee, 0x43, 0x4a, 0x6c, 0xbc, 0xa3, 0xf7, 0xe9, 0x62, 0xe7, 0x6d, 0x45, 0x5e, 0x32, 0x64, 0xc1, 0x9f, 0x60, 0x5f, 0x6e, 0x5f, 0xf6, 0x13, 0x7c, 0x65, 0xc5, 0x6d, 0x7f, 0xb3, 0x44, 0xcd, 0x52, 0xbc, 0x93, 0x37, 0x4f, 0x3d, 0x16, 0x6c, 0x9f, 0x0c, 0x6f, 0x9c, 0x50, 0x6b, 0xad, 0x19, 0x33, 0x09, 0x72, 0xd2, 
};
static const u8 rsa_oaep_36_res[] = {
0x04, 0xcc, 0xe1, 0x96, 0x14, 0x84, 0x5e, 0x09, 0x41, 0x52, 0xa3, 0xfe, 0x18, 0xe5, 0x4e, 0x33, 0x30, 0xc4, 0x4e, 0x5e, 0xfb, 0xc6, 0x4a, 0xe1, 0x68, 0x86, 0xcb, 0x18, 0x69, 0x01, 0x4c, 0xc5, 0x78, 0x1b, 0x1f, 0x8f, 0x9e, 0x04, 0x53, 0x84, 0xd0, 0x11, 0x2a, 0x13, 0x5c, 0xa0, 0xd1, 0x2e, 0x9c, 0x88, 0xa8, 0xe4, 0x06, 0x34, 0x16, 0xde, 0xaa, 0xe3, 0x84, 0x4f, 0x60, 0xd6, 0xe9, 0x6f, 0xe1, 0x55, 0x14, 0x5f, 0x45, 0x25, 0xb9, 0xa3, 0x44, 0x31, 0xca, 0x37, 0x66, 0x18, 0x0f, 0x70, 0xe1, 0x5a, 0x5e, 0x5d, 0x8e, 0x8b, 0x1a, 0x51, 0x6f, 0xf8, 0x70, 0x60, 0x9f, 0x13, 0xf8, 0x96, 0x93, 0x5c, 0xed, 0x18, 0x82, 0x79, 0xa5, 0x8e, 0xd1, 0x3d, 0x07, 0x11, 0x42, 0x77, 0xd7, 0x5c, 0x65, 0x68, 0x60, 0x7e, 0x0a, 0xb0, 0x92, 0xfd, 0x80, 0x3a, 0x22, 0x3e, 0x4a, 0x8e, 0xe0, 0xb1, 0xa8, 
};
static const u8 rsa_oaep_36_salt[] = {
0x1c, 0xac, 0x19, 0xce, 0x99, 0x3d, 0xef, 0x55, 0xf9, 0x82, 0x03, 0xf6, 0x85, 0x28, 0x96, 0xc9, 0x5c, 0xcc, 0xa1, 0xf3, 
};


static const rsa_test test_rsa_oaep_36 = {
	.name = "rsa_oaep_36",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_36_n,
	.nlen = sizeof(rsa_oaep_36_n),
	.d = (const u8*)&rsa_oaep_36_d,
	.dlen = sizeof(rsa_oaep_36_d),
	.e = (const u8*)&rsa_oaep_36_e,
	.elen = sizeof(rsa_oaep_36_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_36_m,
	.mlen = sizeof(rsa_oaep_36_m),
	.res = (const u8*)&rsa_oaep_36_res,
	.reslen = sizeof(rsa_oaep_36_res),
	.salt = (const u8*)&rsa_oaep_36_salt,
	.saltlen = sizeof(rsa_oaep_36_salt),
};
static const u8 rsa_oaep_37_CRT_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_37_CRT_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_37_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_37_CRT_m[] = {
0x4a, 0x86, 0x60, 0x95, 0x34, 0xee, 0x43, 0x4a, 0x6c, 0xbc, 0xa3, 0xf7, 0xe9, 0x62, 0xe7, 0x6d, 0x45, 0x5e, 0x32, 0x64, 0xc1, 0x9f, 0x60, 0x5f, 0x6e, 0x5f, 0xf6, 0x13, 0x7c, 0x65, 0xc5, 0x6d, 0x7f, 0xb3, 0x44, 0xcd, 0x52, 0xbc, 0x93, 0x37, 0x4f, 0x3d, 0x16, 0x6c, 0x9f, 0x0c, 0x6f, 0x9c, 0x50, 0x6b, 0xad, 0x19, 0x33, 0x09, 0x72, 0xd2, 
};
static const u8 rsa_oaep_37_CRT_res[] = {
0x04, 0xcc, 0xe1, 0x96, 0x14, 0x84, 0x5e, 0x09, 0x41, 0x52, 0xa3, 0xfe, 0x18, 0xe5, 0x4e, 0x33, 0x30, 0xc4, 0x4e, 0x5e, 0xfb, 0xc6, 0x4a, 0xe1, 0x68, 0x86, 0xcb, 0x18, 0x69, 0x01, 0x4c, 0xc5, 0x78, 0x1b, 0x1f, 0x8f, 0x9e, 0x04, 0x53, 0x84, 0xd0, 0x11, 0x2a, 0x13, 0x5c, 0xa0, 0xd1, 0x2e, 0x9c, 0x88, 0xa8, 0xe4, 0x06, 0x34, 0x16, 0xde, 0xaa, 0xe3, 0x84, 0x4f, 0x60, 0xd6, 0xe9, 0x6f, 0xe1, 0x55, 0x14, 0x5f, 0x45, 0x25, 0xb9, 0xa3, 0x44, 0x31, 0xca, 0x37, 0x66, 0x18, 0x0f, 0x70, 0xe1, 0x5a, 0x5e, 0x5d, 0x8e, 0x8b, 0x1a, 0x51, 0x6f, 0xf8, 0x70, 0x60, 0x9f, 0x13, 0xf8, 0x96, 0x93, 0x5c, 0xed, 0x18, 0x82, 0x79, 0xa5, 0x8e, 0xd1, 0x3d, 0x07, 0x11, 0x42, 0x77, 0xd7, 0x5c, 0x65, 0x68, 0x60, 0x7e, 0x0a, 0xb0, 0x92, 0xfd, 0x80, 0x3a, 0x22, 0x3e, 0x4a, 0x8e, 0xe0, 0xb1, 0xa8, 
};
static const u8 rsa_oaep_37_CRT_salt[] = {
0x1c, 0xac, 0x19, 0xce, 0x99, 0x3d, 0xef, 0x55, 0xf9, 0x82, 0x03, 0xf6, 0x85, 0x28, 0x96, 0xc9, 0x5c, 0xcc, 0xa1, 0xf3, 
};
static const u8 rsa_oaep_37_CRT_p[] = {
0x02, 0x74, 0x58, 0xc1, 0x9e, 0xc1, 0x63, 0x69, 0x19, 0xe7, 0x36, 0xc9, 0xaf, 0x25, 0xd6, 0x09, 0xa5, 0x1b, 0x8f, 0x56, 0x1d, 0x19, 0xc6, 0xbf, 0x69, 0x43, 0xdd, 0x1e, 0xe1, 0xab, 0x8a, 0x4a, 0x3f, 0x23, 0x21, 0x00, 0xbd, 0x40, 0xb8, 0x8d, 0xec, 0xc6, 0xba, 0x23, 0x55, 0x48, 0xb6, 0xef, 0x79, 0x2a, 0x11, 0xc9, 0xde, 0x82, 0x3d, 0x0a, 0x79, 0x22, 0xc7, 0x09, 0x5b, 0x6e, 0xba, 0x57, 0x01, 
};
static const u8 rsa_oaep_37_CRT_q[] = {
0x02, 0x10, 0xee, 0x9b, 0x33, 0xab, 0x61, 0x71, 0x6e, 0x27, 0xd2, 0x51, 0xbd, 0x46, 0x5f, 0x4b, 0x35, 0xa1, 0xa2, 0x32, 0xe2, 0xda, 0x00, 0x90, 0x1c, 0x29, 0x4b, 0xf2, 0x23, 0x50, 0xce, 0x49, 0x0d, 0x09, 0x9f, 0x64, 0x2b, 0x53, 0x75, 0x61, 0x2d, 0xb6, 0x3b, 0xa1, 0xf2, 0x03, 0x86, 0x49, 0x2b, 0xf0, 0x4d, 0x34, 0xb3, 0xc2, 0x2b, 0xce, 0xb9, 0x09, 0xd1, 0x34, 0x41, 0xb5, 0x3b, 0x51, 0x39, 
};
static const u8 rsa_oaep_37_CRT_dP[] = {
0x39, 0xfa, 0x02, 0x8b, 0x82, 0x6e, 0x88, 0xc1, 0x12, 0x1b, 0x75, 0x0a, 0x8b, 0x24, 0x2f, 0xa9, 0xa3, 0x5c, 0x5b, 0x66, 0xbd, 0xfd, 0x1f, 0xa6, 0x37, 0xd3, 0xcc, 0x48, 0xa8, 0x4a, 0x4f, 0x45, 0x7a, 0x19, 0x4e, 0x77, 0x27, 0xe4, 0x9f, 0x7b, 0xcc, 0x6e, 0x5a, 0x5a, 0x41, 0x26, 0x57, 0xfc, 0x47, 0x0c, 0x73, 0x22, 0xeb, 0xc3, 0x74, 0x16, 0xef, 0x45, 0x8c, 0x30, 0x7a, 0x8c, 0x09, 0x01, 
};
static const u8 rsa_oaep_37_CRT_dQ[] = {
0x01, 0x5d, 0x99, 0xa8, 0x41, 0x95, 0x94, 0x39, 0x79, 0xfa, 0x9e, 0x1b, 0xe2, 0xc3, 0xc1, 0xb6, 0x9f, 0x43, 0x2f, 0x46, 0xfd, 0x03, 0xe4, 0x7d, 0x5b, 0xef, 0xbb, 0xbf, 0xd6, 0xb1, 0xd1, 0x37, 0x1d, 0x83, 0xef, 0xb3, 0x30, 0xa3, 0xe0, 0x20, 0x94, 0x2b, 0x2f, 0xed, 0x11, 0x5e, 0x5d, 0x02, 0xbe, 0x24, 0xfd, 0x92, 0xc9, 0x01, 0x9d, 0x1c, 0xec, 0xd6, 0xdd, 0x4c, 0xf1, 0xe5, 0x4c, 0xc8, 0x99, 
};
static const u8 rsa_oaep_37_CRT_qInv[] = {
0x01, 0xf0, 0xb7, 0x01, 0x51, 0x70, 0xb3, 0xf5, 0xe4, 0x22, 0x23, 0xba, 0x30, 0x30, 0x1c, 0x41, 0xa6, 0xd8, 0x7c, 0xbb, 0x70, 0xe3, 0x0c, 0xb7, 0xd3, 0xc6, 0x7d, 0x25, 0x47, 0x3d, 0xb1, 0xf6, 0xcb, 0xf0, 0x3e, 0x3f, 0x91, 0x26, 0xe3, 0xe9, 0x79, 0x68, 0x27, 0x9a, 0x86, 0x5b, 0x2c, 0x2b, 0x42, 0x65, 0x24, 0xcf, 0xc5, 0x2a, 0x68, 0x3d, 0x31, 0xed, 0x30, 0xeb, 0x98, 0x4b, 0xe4, 0x12, 0xba, 
};


static const rsa_test test_rsa_oaep_37_CRT = {
	.name = "rsa_oaep_37_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_37_CRT_n,
	.nlen = sizeof(rsa_oaep_37_CRT_n),
	.d = (const u8*)&rsa_oaep_37_CRT_d,
	.dlen = sizeof(rsa_oaep_37_CRT_d),
	.e = (const u8*)&rsa_oaep_37_CRT_e,
	.elen = sizeof(rsa_oaep_37_CRT_e),
	.p = (const u8*)&rsa_oaep_37_CRT_p,
	.plen = sizeof(rsa_oaep_37_CRT_p),
	.q = (const u8*)&rsa_oaep_37_CRT_q,
	.qlen = sizeof(rsa_oaep_37_CRT_q),
	.dP = (const u8*)&rsa_oaep_37_CRT_dP,
	.dPlen = sizeof(rsa_oaep_37_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_37_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_37_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_37_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_37_CRT_qInv),
	.m = (const u8*)&rsa_oaep_37_CRT_m,
	.mlen = sizeof(rsa_oaep_37_CRT_m),
	.res = (const u8*)&rsa_oaep_37_CRT_res,
	.reslen = sizeof(rsa_oaep_37_CRT_res),
	.salt = (const u8*)&rsa_oaep_37_CRT_salt,
	.saltlen = sizeof(rsa_oaep_37_CRT_salt),
};
static const u8 rsa_oaep_38_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_38_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_38_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_38_m[] = {
0xb0, 0xad, 0xc4, 0xf3, 0xfe, 0x11, 0xda, 0x59, 0xce, 0x99, 0x27, 0x73, 0xd9, 0x05, 0x99, 0x43, 0xc0, 0x30, 0x46, 0x49, 0x7e, 0xe9, 0xd9, 0xf9, 0xa0, 0x6d, 0xf1, 0x16, 0x6d, 0xb4, 0x6d, 0x98, 0xf5, 0x8d, 0x27, 0xec, 0x07, 0x4c, 0x02, 0xee, 0xe6, 0xcb, 0xe2, 0x44, 0x9c, 0x8b, 0x9f, 0xc5, 0x08, 0x0c, 0x5c, 0x3f, 0x44, 0x33, 0x09, 0x25, 0x12, 0xec, 0x46, 0xaa, 0x79, 0x37, 0x43, 0xc8, 
};
static const u8 rsa_oaep_38_res[] = {
0x00, 0x97, 0xb6, 0x98, 0xc6, 0x16, 0x56, 0x45, 0xb3, 0x03, 0x48, 0x6f, 0xbf, 0x5a, 0x2a, 0x44, 0x79, 0xc0, 0xee, 0x85, 0x88, 0x9b, 0x54, 0x1a, 0x6f, 0x0b, 0x85, 0x8d, 0x6b, 0x65, 0x97, 0xb1, 0x3b, 0x85, 0x4e, 0xb4, 0xf8, 0x39, 0xaf, 0x03, 0x39, 0x9a, 0x80, 0xd7, 0x9b, 0xda, 0x65, 0x78, 0xc8, 0x41, 0xf9, 0x0d, 0x64, 0x57, 0x15, 0xb2, 0x80, 0xd3, 0x71, 0x43, 0x99, 0x2d, 0xd1, 0x86, 0xc8, 0x0b, 0x94, 0x9b, 0x77, 0x5c, 0xae, 0x97, 0x37, 0x0e, 0x4e, 0xc9, 0x74, 0x43, 0x13, 0x6c, 0x6d, 0xa4, 0x84, 0xe9, 0x70, 0xff, 0xdb, 0x13, 0x23, 0xa2, 0x08, 0x47, 0x82, 0x1d, 0x3b, 0x18, 0x38, 0x1d, 0xe1, 0x3b, 0xb4, 0x9a, 0xae, 0xa6, 0x65, 0x30, 0xc4, 0xa4, 0xb8, 0x27, 0x1f, 0x3e, 0xae, 0x17, 0x2c, 0xd3, 0x66, 0xe0, 0x7e, 0x66, 0x36, 0xf1, 0x01, 0x9d, 0x2a, 0x28, 0xae, 0xd1, 0x5e, 
};
static const u8 rsa_oaep_38_salt[] = {
0xf5, 0x45, 0xd5, 0x89, 0x75, 0x85, 0xe3, 0xdb, 0x71, 0xaa, 0x0c, 0xb8, 0xda, 0x76, 0xc5, 0x1d, 0x03, 0x2a, 0xe9, 0x63, 
};


static const rsa_test test_rsa_oaep_38 = {
	.name = "rsa_oaep_38",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_38_n,
	.nlen = sizeof(rsa_oaep_38_n),
	.d = (const u8*)&rsa_oaep_38_d,
	.dlen = sizeof(rsa_oaep_38_d),
	.e = (const u8*)&rsa_oaep_38_e,
	.elen = sizeof(rsa_oaep_38_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_38_m,
	.mlen = sizeof(rsa_oaep_38_m),
	.res = (const u8*)&rsa_oaep_38_res,
	.reslen = sizeof(rsa_oaep_38_res),
	.salt = (const u8*)&rsa_oaep_38_salt,
	.saltlen = sizeof(rsa_oaep_38_salt),
};
static const u8 rsa_oaep_39_CRT_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_39_CRT_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_39_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_39_CRT_m[] = {
0xb0, 0xad, 0xc4, 0xf3, 0xfe, 0x11, 0xda, 0x59, 0xce, 0x99, 0x27, 0x73, 0xd9, 0x05, 0x99, 0x43, 0xc0, 0x30, 0x46, 0x49, 0x7e, 0xe9, 0xd9, 0xf9, 0xa0, 0x6d, 0xf1, 0x16, 0x6d, 0xb4, 0x6d, 0x98, 0xf5, 0x8d, 0x27, 0xec, 0x07, 0x4c, 0x02, 0xee, 0xe6, 0xcb, 0xe2, 0x44, 0x9c, 0x8b, 0x9f, 0xc5, 0x08, 0x0c, 0x5c, 0x3f, 0x44, 0x33, 0x09, 0x25, 0x12, 0xec, 0x46, 0xaa, 0x79, 0x37, 0x43, 0xc8, 
};
static const u8 rsa_oaep_39_CRT_res[] = {
0x00, 0x97, 0xb6, 0x98, 0xc6, 0x16, 0x56, 0x45, 0xb3, 0x03, 0x48, 0x6f, 0xbf, 0x5a, 0x2a, 0x44, 0x79, 0xc0, 0xee, 0x85, 0x88, 0x9b, 0x54, 0x1a, 0x6f, 0x0b, 0x85, 0x8d, 0x6b, 0x65, 0x97, 0xb1, 0x3b, 0x85, 0x4e, 0xb4, 0xf8, 0x39, 0xaf, 0x03, 0x39, 0x9a, 0x80, 0xd7, 0x9b, 0xda, 0x65, 0x78, 0xc8, 0x41, 0xf9, 0x0d, 0x64, 0x57, 0x15, 0xb2, 0x80, 0xd3, 0x71, 0x43, 0x99, 0x2d, 0xd1, 0x86, 0xc8, 0x0b, 0x94, 0x9b, 0x77, 0x5c, 0xae, 0x97, 0x37, 0x0e, 0x4e, 0xc9, 0x74, 0x43, 0x13, 0x6c, 0x6d, 0xa4, 0x84, 0xe9, 0x70, 0xff, 0xdb, 0x13, 0x23, 0xa2, 0x08, 0x47, 0x82, 0x1d, 0x3b, 0x18, 0x38, 0x1d, 0xe1, 0x3b, 0xb4, 0x9a, 0xae, 0xa6, 0x65, 0x30, 0xc4, 0xa4, 0xb8, 0x27, 0x1f, 0x3e, 0xae, 0x17, 0x2c, 0xd3, 0x66, 0xe0, 0x7e, 0x66, 0x36, 0xf1, 0x01, 0x9d, 0x2a, 0x28, 0xae, 0xd1, 0x5e, 
};
static const u8 rsa_oaep_39_CRT_salt[] = {
0xf5, 0x45, 0xd5, 0x89, 0x75, 0x85, 0xe3, 0xdb, 0x71, 0xaa, 0x0c, 0xb8, 0xda, 0x76, 0xc5, 0x1d, 0x03, 0x2a, 0xe9, 0x63, 
};
static const u8 rsa_oaep_39_CRT_p[] = {
0x02, 0x74, 0x58, 0xc1, 0x9e, 0xc1, 0x63, 0x69, 0x19, 0xe7, 0x36, 0xc9, 0xaf, 0x25, 0xd6, 0x09, 0xa5, 0x1b, 0x8f, 0x56, 0x1d, 0x19, 0xc6, 0xbf, 0x69, 0x43, 0xdd, 0x1e, 0xe1, 0xab, 0x8a, 0x4a, 0x3f, 0x23, 0x21, 0x00, 0xbd, 0x40, 0xb8, 0x8d, 0xec, 0xc6, 0xba, 0x23, 0x55, 0x48, 0xb6, 0xef, 0x79, 0x2a, 0x11, 0xc9, 0xde, 0x82, 0x3d, 0x0a, 0x79, 0x22, 0xc7, 0x09, 0x5b, 0x6e, 0xba, 0x57, 0x01, 
};
static const u8 rsa_oaep_39_CRT_q[] = {
0x02, 0x10, 0xee, 0x9b, 0x33, 0xab, 0x61, 0x71, 0x6e, 0x27, 0xd2, 0x51, 0xbd, 0x46, 0x5f, 0x4b, 0x35, 0xa1, 0xa2, 0x32, 0xe2, 0xda, 0x00, 0x90, 0x1c, 0x29, 0x4b, 0xf2, 0x23, 0x50, 0xce, 0x49, 0x0d, 0x09, 0x9f, 0x64, 0x2b, 0x53, 0x75, 0x61, 0x2d, 0xb6, 0x3b, 0xa1, 0xf2, 0x03, 0x86, 0x49, 0x2b, 0xf0, 0x4d, 0x34, 0xb3, 0xc2, 0x2b, 0xce, 0xb9, 0x09, 0xd1, 0x34, 0x41, 0xb5, 0x3b, 0x51, 0x39, 
};
static const u8 rsa_oaep_39_CRT_dP[] = {
0x39, 0xfa, 0x02, 0x8b, 0x82, 0x6e, 0x88, 0xc1, 0x12, 0x1b, 0x75, 0x0a, 0x8b, 0x24, 0x2f, 0xa9, 0xa3, 0x5c, 0x5b, 0x66, 0xbd, 0xfd, 0x1f, 0xa6, 0x37, 0xd3, 0xcc, 0x48, 0xa8, 0x4a, 0x4f, 0x45, 0x7a, 0x19, 0x4e, 0x77, 0x27, 0xe4, 0x9f, 0x7b, 0xcc, 0x6e, 0x5a, 0x5a, 0x41, 0x26, 0x57, 0xfc, 0x47, 0x0c, 0x73, 0x22, 0xeb, 0xc3, 0x74, 0x16, 0xef, 0x45, 0x8c, 0x30, 0x7a, 0x8c, 0x09, 0x01, 
};
static const u8 rsa_oaep_39_CRT_dQ[] = {
0x01, 0x5d, 0x99, 0xa8, 0x41, 0x95, 0x94, 0x39, 0x79, 0xfa, 0x9e, 0x1b, 0xe2, 0xc3, 0xc1, 0xb6, 0x9f, 0x43, 0x2f, 0x46, 0xfd, 0x03, 0xe4, 0x7d, 0x5b, 0xef, 0xbb, 0xbf, 0xd6, 0xb1, 0xd1, 0x37, 0x1d, 0x83, 0xef, 0xb3, 0x30, 0xa3, 0xe0, 0x20, 0x94, 0x2b, 0x2f, 0xed, 0x11, 0x5e, 0x5d, 0x02, 0xbe, 0x24, 0xfd, 0x92, 0xc9, 0x01, 0x9d, 0x1c, 0xec, 0xd6, 0xdd, 0x4c, 0xf1, 0xe5, 0x4c, 0xc8, 0x99, 
};
static const u8 rsa_oaep_39_CRT_qInv[] = {
0x01, 0xf0, 0xb7, 0x01, 0x51, 0x70, 0xb3, 0xf5, 0xe4, 0x22, 0x23, 0xba, 0x30, 0x30, 0x1c, 0x41, 0xa6, 0xd8, 0x7c, 0xbb, 0x70, 0xe3, 0x0c, 0xb7, 0xd3, 0xc6, 0x7d, 0x25, 0x47, 0x3d, 0xb1, 0xf6, 0xcb, 0xf0, 0x3e, 0x3f, 0x91, 0x26, 0xe3, 0xe9, 0x79, 0x68, 0x27, 0x9a, 0x86, 0x5b, 0x2c, 0x2b, 0x42, 0x65, 0x24, 0xcf, 0xc5, 0x2a, 0x68, 0x3d, 0x31, 0xed, 0x30, 0xeb, 0x98, 0x4b, 0xe4, 0x12, 0xba, 
};


static const rsa_test test_rsa_oaep_39_CRT = {
	.name = "rsa_oaep_39_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_39_CRT_n,
	.nlen = sizeof(rsa_oaep_39_CRT_n),
	.d = (const u8*)&rsa_oaep_39_CRT_d,
	.dlen = sizeof(rsa_oaep_39_CRT_d),
	.e = (const u8*)&rsa_oaep_39_CRT_e,
	.elen = sizeof(rsa_oaep_39_CRT_e),
	.p = (const u8*)&rsa_oaep_39_CRT_p,
	.plen = sizeof(rsa_oaep_39_CRT_p),
	.q = (const u8*)&rsa_oaep_39_CRT_q,
	.qlen = sizeof(rsa_oaep_39_CRT_q),
	.dP = (const u8*)&rsa_oaep_39_CRT_dP,
	.dPlen = sizeof(rsa_oaep_39_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_39_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_39_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_39_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_39_CRT_qInv),
	.m = (const u8*)&rsa_oaep_39_CRT_m,
	.mlen = sizeof(rsa_oaep_39_CRT_m),
	.res = (const u8*)&rsa_oaep_39_CRT_res,
	.reslen = sizeof(rsa_oaep_39_CRT_res),
	.salt = (const u8*)&rsa_oaep_39_CRT_salt,
	.saltlen = sizeof(rsa_oaep_39_CRT_salt),
};
static const u8 rsa_oaep_40_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_40_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_40_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_40_m[] = {
0xbf, 0x6d, 0x42, 0xe7, 0x01, 0x70, 0x7b, 0x1d, 0x02, 0x06, 0xb0, 0xc8, 0xb4, 0x5a, 0x1c, 0x72, 0x64, 0x1f, 0xf1, 0x28, 0x89, 0x21, 0x9a, 0x82, 0xbd, 0xea, 0x96, 0x5b, 0x5e, 0x79, 0xa9, 0x6b, 0x0d, 0x01, 0x63, 0xed, 0x9d, 0x57, 0x8e, 0xc9, 0xad, 0xa2, 0x0f, 0x2f, 0xbc, 0xf1, 0xea, 0x3c, 0x40, 0x89, 0xd8, 0x34, 0x19, 0xba, 0x81, 0xb0, 0xc6, 0x0f, 0x36, 0x06, 0xda, 0x99, 
};
static const u8 rsa_oaep_40_res[] = {
0x03, 0x01, 0xf9, 0x35, 0xe9, 0xc4, 0x7a, 0xbc, 0xb4, 0x8a, 0xcb, 0xbe, 0x09, 0x89, 0x5d, 0x9f, 0x59, 0x71, 0xaf, 0x14, 0x83, 0x9d, 0xa4, 0xff, 0x95, 0x41, 0x7e, 0xe4, 0x53, 0xd1, 0xfd, 0x77, 0x31, 0x90, 0x72, 0xbb, 0x72, 0x97, 0xe1, 0xb5, 0x5d, 0x75, 0x61, 0xcd, 0x9d, 0x1b, 0xb2, 0x4c, 0x1a, 0x9a, 0x37, 0xc6, 0x19, 0x86, 0x43, 0x08, 0x24, 0x28, 0x04, 0x87, 0x9d, 0x86, 0xeb, 0xd0, 0x01, 0xdc, 0xe5, 0x18, 0x39, 0x75, 0xe1, 0x50, 0x69, 0x89, 0xb7, 0x0e, 0x5a, 0x83, 0x43, 0x41, 0x54, 0xd5, 0xcb, 0xfd, 0x6a, 0x24, 0x78, 0x7e, 0x60, 0xeb, 0x0c, 0x65, 0x8d, 0x2a, 0xc1, 0x93, 0x30, 0x2d, 0x11, 0x92, 0xc6, 0xe6, 0x22, 0xd4, 0xa1, 0x2a, 0xd4, 0xb5, 0x39, 0x23, 0xbc, 0xa2, 0x46, 0xdf, 0x31, 0xc6, 0x39, 0x5e, 0x37, 0x70, 0x2c, 0x6a, 0x78, 0xae, 0x08, 0x1f, 0xb9, 0xd0, 0x65, 
};
static const u8 rsa_oaep_40_salt[] = {
0xad, 0x99, 0x7f, 0xee, 0xf7, 0x30, 0xd6, 0xea, 0x7b, 0xe6, 0x0d, 0x0d, 0xc5, 0x2e, 0x72, 0xea, 0xcb, 0xfd, 0xd2, 0x75, 
};


static const rsa_test test_rsa_oaep_40 = {
	.name = "rsa_oaep_40",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_40_n,
	.nlen = sizeof(rsa_oaep_40_n),
	.d = (const u8*)&rsa_oaep_40_d,
	.dlen = sizeof(rsa_oaep_40_d),
	.e = (const u8*)&rsa_oaep_40_e,
	.elen = sizeof(rsa_oaep_40_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_40_m,
	.mlen = sizeof(rsa_oaep_40_m),
	.res = (const u8*)&rsa_oaep_40_res,
	.reslen = sizeof(rsa_oaep_40_res),
	.salt = (const u8*)&rsa_oaep_40_salt,
	.saltlen = sizeof(rsa_oaep_40_salt),
};
static const u8 rsa_oaep_41_CRT_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_41_CRT_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_41_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_41_CRT_m[] = {
0xbf, 0x6d, 0x42, 0xe7, 0x01, 0x70, 0x7b, 0x1d, 0x02, 0x06, 0xb0, 0xc8, 0xb4, 0x5a, 0x1c, 0x72, 0x64, 0x1f, 0xf1, 0x28, 0x89, 0x21, 0x9a, 0x82, 0xbd, 0xea, 0x96, 0x5b, 0x5e, 0x79, 0xa9, 0x6b, 0x0d, 0x01, 0x63, 0xed, 0x9d, 0x57, 0x8e, 0xc9, 0xad, 0xa2, 0x0f, 0x2f, 0xbc, 0xf1, 0xea, 0x3c, 0x40, 0x89, 0xd8, 0x34, 0x19, 0xba, 0x81, 0xb0, 0xc6, 0x0f, 0x36, 0x06, 0xda, 0x99, 
};
static const u8 rsa_oaep_41_CRT_res[] = {
0x03, 0x01, 0xf9, 0x35, 0xe9, 0xc4, 0x7a, 0xbc, 0xb4, 0x8a, 0xcb, 0xbe, 0x09, 0x89, 0x5d, 0x9f, 0x59, 0x71, 0xaf, 0x14, 0x83, 0x9d, 0xa4, 0xff, 0x95, 0x41, 0x7e, 0xe4, 0x53, 0xd1, 0xfd, 0x77, 0x31, 0x90, 0x72, 0xbb, 0x72, 0x97, 0xe1, 0xb5, 0x5d, 0x75, 0x61, 0xcd, 0x9d, 0x1b, 0xb2, 0x4c, 0x1a, 0x9a, 0x37, 0xc6, 0x19, 0x86, 0x43, 0x08, 0x24, 0x28, 0x04, 0x87, 0x9d, 0x86, 0xeb, 0xd0, 0x01, 0xdc, 0xe5, 0x18, 0x39, 0x75, 0xe1, 0x50, 0x69, 0x89, 0xb7, 0x0e, 0x5a, 0x83, 0x43, 0x41, 0x54, 0xd5, 0xcb, 0xfd, 0x6a, 0x24, 0x78, 0x7e, 0x60, 0xeb, 0x0c, 0x65, 0x8d, 0x2a, 0xc1, 0x93, 0x30, 0x2d, 0x11, 0x92, 0xc6, 0xe6, 0x22, 0xd4, 0xa1, 0x2a, 0xd4, 0xb5, 0x39, 0x23, 0xbc, 0xa2, 0x46, 0xdf, 0x31, 0xc6, 0x39, 0x5e, 0x37, 0x70, 0x2c, 0x6a, 0x78, 0xae, 0x08, 0x1f, 0xb9, 0xd0, 0x65, 
};
static const u8 rsa_oaep_41_CRT_salt[] = {
0xad, 0x99, 0x7f, 0xee, 0xf7, 0x30, 0xd6, 0xea, 0x7b, 0xe6, 0x0d, 0x0d, 0xc5, 0x2e, 0x72, 0xea, 0xcb, 0xfd, 0xd2, 0x75, 
};
static const u8 rsa_oaep_41_CRT_p[] = {
0x02, 0x74, 0x58, 0xc1, 0x9e, 0xc1, 0x63, 0x69, 0x19, 0xe7, 0x36, 0xc9, 0xaf, 0x25, 0xd6, 0x09, 0xa5, 0x1b, 0x8f, 0x56, 0x1d, 0x19, 0xc6, 0xbf, 0x69, 0x43, 0xdd, 0x1e, 0xe1, 0xab, 0x8a, 0x4a, 0x3f, 0x23, 0x21, 0x00, 0xbd, 0x40, 0xb8, 0x8d, 0xec, 0xc6, 0xba, 0x23, 0x55, 0x48, 0xb6, 0xef, 0x79, 0x2a, 0x11, 0xc9, 0xde, 0x82, 0x3d, 0x0a, 0x79, 0x22, 0xc7, 0x09, 0x5b, 0x6e, 0xba, 0x57, 0x01, 
};
static const u8 rsa_oaep_41_CRT_q[] = {
0x02, 0x10, 0xee, 0x9b, 0x33, 0xab, 0x61, 0x71, 0x6e, 0x27, 0xd2, 0x51, 0xbd, 0x46, 0x5f, 0x4b, 0x35, 0xa1, 0xa2, 0x32, 0xe2, 0xda, 0x00, 0x90, 0x1c, 0x29, 0x4b, 0xf2, 0x23, 0x50, 0xce, 0x49, 0x0d, 0x09, 0x9f, 0x64, 0x2b, 0x53, 0x75, 0x61, 0x2d, 0xb6, 0x3b, 0xa1, 0xf2, 0x03, 0x86, 0x49, 0x2b, 0xf0, 0x4d, 0x34, 0xb3, 0xc2, 0x2b, 0xce, 0xb9, 0x09, 0xd1, 0x34, 0x41, 0xb5, 0x3b, 0x51, 0x39, 
};
static const u8 rsa_oaep_41_CRT_dP[] = {
0x39, 0xfa, 0x02, 0x8b, 0x82, 0x6e, 0x88, 0xc1, 0x12, 0x1b, 0x75, 0x0a, 0x8b, 0x24, 0x2f, 0xa9, 0xa3, 0x5c, 0x5b, 0x66, 0xbd, 0xfd, 0x1f, 0xa6, 0x37, 0xd3, 0xcc, 0x48, 0xa8, 0x4a, 0x4f, 0x45, 0x7a, 0x19, 0x4e, 0x77, 0x27, 0xe4, 0x9f, 0x7b, 0xcc, 0x6e, 0x5a, 0x5a, 0x41, 0x26, 0x57, 0xfc, 0x47, 0x0c, 0x73, 0x22, 0xeb, 0xc3, 0x74, 0x16, 0xef, 0x45, 0x8c, 0x30, 0x7a, 0x8c, 0x09, 0x01, 
};
static const u8 rsa_oaep_41_CRT_dQ[] = {
0x01, 0x5d, 0x99, 0xa8, 0x41, 0x95, 0x94, 0x39, 0x79, 0xfa, 0x9e, 0x1b, 0xe2, 0xc3, 0xc1, 0xb6, 0x9f, 0x43, 0x2f, 0x46, 0xfd, 0x03, 0xe4, 0x7d, 0x5b, 0xef, 0xbb, 0xbf, 0xd6, 0xb1, 0xd1, 0x37, 0x1d, 0x83, 0xef, 0xb3, 0x30, 0xa3, 0xe0, 0x20, 0x94, 0x2b, 0x2f, 0xed, 0x11, 0x5e, 0x5d, 0x02, 0xbe, 0x24, 0xfd, 0x92, 0xc9, 0x01, 0x9d, 0x1c, 0xec, 0xd6, 0xdd, 0x4c, 0xf1, 0xe5, 0x4c, 0xc8, 0x99, 
};
static const u8 rsa_oaep_41_CRT_qInv[] = {
0x01, 0xf0, 0xb7, 0x01, 0x51, 0x70, 0xb3, 0xf5, 0xe4, 0x22, 0x23, 0xba, 0x30, 0x30, 0x1c, 0x41, 0xa6, 0xd8, 0x7c, 0xbb, 0x70, 0xe3, 0x0c, 0xb7, 0xd3, 0xc6, 0x7d, 0x25, 0x47, 0x3d, 0xb1, 0xf6, 0xcb, 0xf0, 0x3e, 0x3f, 0x91, 0x26, 0xe3, 0xe9, 0x79, 0x68, 0x27, 0x9a, 0x86, 0x5b, 0x2c, 0x2b, 0x42, 0x65, 0x24, 0xcf, 0xc5, 0x2a, 0x68, 0x3d, 0x31, 0xed, 0x30, 0xeb, 0x98, 0x4b, 0xe4, 0x12, 0xba, 
};


static const rsa_test test_rsa_oaep_41_CRT = {
	.name = "rsa_oaep_41_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_41_CRT_n,
	.nlen = sizeof(rsa_oaep_41_CRT_n),
	.d = (const u8*)&rsa_oaep_41_CRT_d,
	.dlen = sizeof(rsa_oaep_41_CRT_d),
	.e = (const u8*)&rsa_oaep_41_CRT_e,
	.elen = sizeof(rsa_oaep_41_CRT_e),
	.p = (const u8*)&rsa_oaep_41_CRT_p,
	.plen = sizeof(rsa_oaep_41_CRT_p),
	.q = (const u8*)&rsa_oaep_41_CRT_q,
	.qlen = sizeof(rsa_oaep_41_CRT_q),
	.dP = (const u8*)&rsa_oaep_41_CRT_dP,
	.dPlen = sizeof(rsa_oaep_41_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_41_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_41_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_41_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_41_CRT_qInv),
	.m = (const u8*)&rsa_oaep_41_CRT_m,
	.mlen = sizeof(rsa_oaep_41_CRT_m),
	.res = (const u8*)&rsa_oaep_41_CRT_res,
	.reslen = sizeof(rsa_oaep_41_CRT_res),
	.salt = (const u8*)&rsa_oaep_41_CRT_salt,
	.saltlen = sizeof(rsa_oaep_41_CRT_salt),
};
static const u8 rsa_oaep_42_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_42_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_42_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_42_m[] = {
0xfb, 0x2e, 0xf1, 0x12, 0xf5, 0xe7, 0x66, 0xeb, 0x94, 0x01, 0x92, 0x97, 0x93, 0x47, 0x94, 0xf7, 0xbe, 0x2f, 0x6f, 0xc1, 0xc5, 0x8e, 
};
static const u8 rsa_oaep_42_res[] = {
0x02, 0xd1, 0x10, 0xad, 0x30, 0xaf, 0xb7, 0x27, 0xbe, 0xb6, 0x91, 0xdd, 0x0c, 0xf1, 0x7d, 0x0a, 0xf1, 0xa1, 0xe7, 0xfa, 0x0c, 0xc0, 0x40, 0xec, 0x1a, 0x4b, 0xa2, 0x6a, 0x42, 0xc5, 0x9d, 0x0a, 0x79, 0x6a, 0x2e, 0x22, 0xc8, 0xf3, 0x57, 0xcc, 0xc9, 0x8b, 0x65, 0x19, 0xac, 0xeb, 0x68, 0x2e, 0x94, 0x5e, 0x62, 0xcb, 0x73, 0x46, 0x14, 0xa5, 0x29, 0x40, 0x7c, 0xd4, 0x52, 0xbe, 0xe3, 0xe4, 0x4f, 0xec, 0xe8, 0x42, 0x3c, 0xc1, 0x9e, 0x55, 0x54, 0x8b, 0x8b, 0x99, 0x4b, 0x84, 0x9c, 0x7e, 0xcd, 0xe4, 0x93, 0x3e, 0x76, 0x03, 0x7e, 0x1d, 0x0c, 0xe4, 0x42, 0x75, 0xb0, 0x87, 0x10, 0xc6, 0x8e, 0x43, 0x01, 0x30, 0xb9, 0x29, 0x73, 0x0e, 0xd7, 0x7e, 0x09, 0xb0, 0x15, 0x64, 0x2c, 0x55, 0x93, 0xf0, 0x4e, 0x4f, 0xfb, 0x94, 0x10, 0x79, 0x81, 0x02, 0xa8, 0xe9, 0x6f, 0xfd, 0xfe, 0x11, 0xe4, 
};
static const u8 rsa_oaep_42_salt[] = {
0x13, 0x64, 0x54, 0xdf, 0x57, 0x30, 0xf7, 0x3c, 0x80, 0x7a, 0x7e, 0x40, 0xd8, 0xc1, 0xa3, 0x12, 0xac, 0x5b, 0x9d, 0xd3, 
};


static const rsa_test test_rsa_oaep_42 = {
	.name = "rsa_oaep_42",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_42_n,
	.nlen = sizeof(rsa_oaep_42_n),
	.d = (const u8*)&rsa_oaep_42_d,
	.dlen = sizeof(rsa_oaep_42_d),
	.e = (const u8*)&rsa_oaep_42_e,
	.elen = sizeof(rsa_oaep_42_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_42_m,
	.mlen = sizeof(rsa_oaep_42_m),
	.res = (const u8*)&rsa_oaep_42_res,
	.reslen = sizeof(rsa_oaep_42_res),
	.salt = (const u8*)&rsa_oaep_42_salt,
	.saltlen = sizeof(rsa_oaep_42_salt),
};
static const u8 rsa_oaep_43_CRT_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_43_CRT_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_43_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_43_CRT_m[] = {
0xfb, 0x2e, 0xf1, 0x12, 0xf5, 0xe7, 0x66, 0xeb, 0x94, 0x01, 0x92, 0x97, 0x93, 0x47, 0x94, 0xf7, 0xbe, 0x2f, 0x6f, 0xc1, 0xc5, 0x8e, 
};
static const u8 rsa_oaep_43_CRT_res[] = {
0x02, 0xd1, 0x10, 0xad, 0x30, 0xaf, 0xb7, 0x27, 0xbe, 0xb6, 0x91, 0xdd, 0x0c, 0xf1, 0x7d, 0x0a, 0xf1, 0xa1, 0xe7, 0xfa, 0x0c, 0xc0, 0x40, 0xec, 0x1a, 0x4b, 0xa2, 0x6a, 0x42, 0xc5, 0x9d, 0x0a, 0x79, 0x6a, 0x2e, 0x22, 0xc8, 0xf3, 0x57, 0xcc, 0xc9, 0x8b, 0x65, 0x19, 0xac, 0xeb, 0x68, 0x2e, 0x94, 0x5e, 0x62, 0xcb, 0x73, 0x46, 0x14, 0xa5, 0x29, 0x40, 0x7c, 0xd4, 0x52, 0xbe, 0xe3, 0xe4, 0x4f, 0xec, 0xe8, 0x42, 0x3c, 0xc1, 0x9e, 0x55, 0x54, 0x8b, 0x8b, 0x99, 0x4b, 0x84, 0x9c, 0x7e, 0xcd, 0xe4, 0x93, 0x3e, 0x76, 0x03, 0x7e, 0x1d, 0x0c, 0xe4, 0x42, 0x75, 0xb0, 0x87, 0x10, 0xc6, 0x8e, 0x43, 0x01, 0x30, 0xb9, 0x29, 0x73, 0x0e, 0xd7, 0x7e, 0x09, 0xb0, 0x15, 0x64, 0x2c, 0x55, 0x93, 0xf0, 0x4e, 0x4f, 0xfb, 0x94, 0x10, 0x79, 0x81, 0x02, 0xa8, 0xe9, 0x6f, 0xfd, 0xfe, 0x11, 0xe4, 
};
static const u8 rsa_oaep_43_CRT_salt[] = {
0x13, 0x64, 0x54, 0xdf, 0x57, 0x30, 0xf7, 0x3c, 0x80, 0x7a, 0x7e, 0x40, 0xd8, 0xc1, 0xa3, 0x12, 0xac, 0x5b, 0x9d, 0xd3, 
};
static const u8 rsa_oaep_43_CRT_p[] = {
0x02, 0x74, 0x58, 0xc1, 0x9e, 0xc1, 0x63, 0x69, 0x19, 0xe7, 0x36, 0xc9, 0xaf, 0x25, 0xd6, 0x09, 0xa5, 0x1b, 0x8f, 0x56, 0x1d, 0x19, 0xc6, 0xbf, 0x69, 0x43, 0xdd, 0x1e, 0xe1, 0xab, 0x8a, 0x4a, 0x3f, 0x23, 0x21, 0x00, 0xbd, 0x40, 0xb8, 0x8d, 0xec, 0xc6, 0xba, 0x23, 0x55, 0x48, 0xb6, 0xef, 0x79, 0x2a, 0x11, 0xc9, 0xde, 0x82, 0x3d, 0x0a, 0x79, 0x22, 0xc7, 0x09, 0x5b, 0x6e, 0xba, 0x57, 0x01, 
};
static const u8 rsa_oaep_43_CRT_q[] = {
0x02, 0x10, 0xee, 0x9b, 0x33, 0xab, 0x61, 0x71, 0x6e, 0x27, 0xd2, 0x51, 0xbd, 0x46, 0x5f, 0x4b, 0x35, 0xa1, 0xa2, 0x32, 0xe2, 0xda, 0x00, 0x90, 0x1c, 0x29, 0x4b, 0xf2, 0x23, 0x50, 0xce, 0x49, 0x0d, 0x09, 0x9f, 0x64, 0x2b, 0x53, 0x75, 0x61, 0x2d, 0xb6, 0x3b, 0xa1, 0xf2, 0x03, 0x86, 0x49, 0x2b, 0xf0, 0x4d, 0x34, 0xb3, 0xc2, 0x2b, 0xce, 0xb9, 0x09, 0xd1, 0x34, 0x41, 0xb5, 0x3b, 0x51, 0x39, 
};
static const u8 rsa_oaep_43_CRT_dP[] = {
0x39, 0xfa, 0x02, 0x8b, 0x82, 0x6e, 0x88, 0xc1, 0x12, 0x1b, 0x75, 0x0a, 0x8b, 0x24, 0x2f, 0xa9, 0xa3, 0x5c, 0x5b, 0x66, 0xbd, 0xfd, 0x1f, 0xa6, 0x37, 0xd3, 0xcc, 0x48, 0xa8, 0x4a, 0x4f, 0x45, 0x7a, 0x19, 0x4e, 0x77, 0x27, 0xe4, 0x9f, 0x7b, 0xcc, 0x6e, 0x5a, 0x5a, 0x41, 0x26, 0x57, 0xfc, 0x47, 0x0c, 0x73, 0x22, 0xeb, 0xc3, 0x74, 0x16, 0xef, 0x45, 0x8c, 0x30, 0x7a, 0x8c, 0x09, 0x01, 
};
static const u8 rsa_oaep_43_CRT_dQ[] = {
0x01, 0x5d, 0x99, 0xa8, 0x41, 0x95, 0x94, 0x39, 0x79, 0xfa, 0x9e, 0x1b, 0xe2, 0xc3, 0xc1, 0xb6, 0x9f, 0x43, 0x2f, 0x46, 0xfd, 0x03, 0xe4, 0x7d, 0x5b, 0xef, 0xbb, 0xbf, 0xd6, 0xb1, 0xd1, 0x37, 0x1d, 0x83, 0xef, 0xb3, 0x30, 0xa3, 0xe0, 0x20, 0x94, 0x2b, 0x2f, 0xed, 0x11, 0x5e, 0x5d, 0x02, 0xbe, 0x24, 0xfd, 0x92, 0xc9, 0x01, 0x9d, 0x1c, 0xec, 0xd6, 0xdd, 0x4c, 0xf1, 0xe5, 0x4c, 0xc8, 0x99, 
};
static const u8 rsa_oaep_43_CRT_qInv[] = {
0x01, 0xf0, 0xb7, 0x01, 0x51, 0x70, 0xb3, 0xf5, 0xe4, 0x22, 0x23, 0xba, 0x30, 0x30, 0x1c, 0x41, 0xa6, 0xd8, 0x7c, 0xbb, 0x70, 0xe3, 0x0c, 0xb7, 0xd3, 0xc6, 0x7d, 0x25, 0x47, 0x3d, 0xb1, 0xf6, 0xcb, 0xf0, 0x3e, 0x3f, 0x91, 0x26, 0xe3, 0xe9, 0x79, 0x68, 0x27, 0x9a, 0x86, 0x5b, 0x2c, 0x2b, 0x42, 0x65, 0x24, 0xcf, 0xc5, 0x2a, 0x68, 0x3d, 0x31, 0xed, 0x30, 0xeb, 0x98, 0x4b, 0xe4, 0x12, 0xba, 
};


static const rsa_test test_rsa_oaep_43_CRT = {
	.name = "rsa_oaep_43_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_43_CRT_n,
	.nlen = sizeof(rsa_oaep_43_CRT_n),
	.d = (const u8*)&rsa_oaep_43_CRT_d,
	.dlen = sizeof(rsa_oaep_43_CRT_d),
	.e = (const u8*)&rsa_oaep_43_CRT_e,
	.elen = sizeof(rsa_oaep_43_CRT_e),
	.p = (const u8*)&rsa_oaep_43_CRT_p,
	.plen = sizeof(rsa_oaep_43_CRT_p),
	.q = (const u8*)&rsa_oaep_43_CRT_q,
	.qlen = sizeof(rsa_oaep_43_CRT_q),
	.dP = (const u8*)&rsa_oaep_43_CRT_dP,
	.dPlen = sizeof(rsa_oaep_43_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_43_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_43_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_43_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_43_CRT_qInv),
	.m = (const u8*)&rsa_oaep_43_CRT_m,
	.mlen = sizeof(rsa_oaep_43_CRT_m),
	.res = (const u8*)&rsa_oaep_43_CRT_res,
	.reslen = sizeof(rsa_oaep_43_CRT_res),
	.salt = (const u8*)&rsa_oaep_43_CRT_salt,
	.saltlen = sizeof(rsa_oaep_43_CRT_salt),
};
static const u8 rsa_oaep_44_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_44_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_44_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_44_m[] = {
0x28, 0xcc, 0xd4, 0x47, 0xbb, 0x9e, 0x85, 0x16, 0x6d, 0xab, 0xb9, 0xe5, 0xb7, 0xd1, 0xad, 0xad, 0xc4, 0xb9, 0xd3, 0x9f, 0x20, 0x4e, 0x96, 0xd5, 0xe4, 0x40, 0xce, 0x9a, 0xd9, 0x28, 0xbc, 0x1c, 0x22, 0x84, 
};
static const u8 rsa_oaep_44_res[] = {
0x00, 0xdb, 0xb8, 0xa7, 0x43, 0x9d, 0x90, 0xef, 0xd9, 0x19, 0xa3, 0x77, 0xc5, 0x4f, 0xae, 0x8f, 0xe1, 0x1e, 0xc5, 0x8c, 0x3b, 0x85, 0x83, 0x62, 0xe2, 0x3a, 0xd1, 0xb8, 0xa4, 0x43, 0x10, 0x79, 0x90, 0x66, 0xb9, 0x93, 0x47, 0xaa, 0x52, 0x56, 0x91, 0xd2, 0xad, 0xc5, 0x8d, 0x9b, 0x06, 0xe3, 0x4f, 0x28, 0x8c, 0x17, 0x03, 0x90, 0xc5, 0xf0, 0xe1, 0x1c, 0x0a, 0xa3, 0x64, 0x59, 0x59, 0xf1, 0x8e, 0xe7, 0x9e, 0x8f, 0x2b, 0xe8, 0xd7, 0xac, 0x5c, 0x23, 0xd0, 0x61, 0xf1, 0x8d, 0xd7, 0x4b, 0x8c, 0x5f, 0x2a, 0x58, 0xfc, 0xb5, 0xeb, 0x0c, 0x54, 0xf9, 0x9f, 0x01, 0xa8, 0x32, 0x47, 0x56, 0x82, 0x92, 0x53, 0x65, 0x83, 0x34, 0x09, 0x48, 0xd7, 0xa8, 0xc9, 0x7c, 0x4a, 0xcd, 0x1e, 0x98, 0xd1, 0xe2, 0x9d, 0xc3, 0x20, 0xe9, 0x7a, 0x26, 0x05, 0x32, 0xa8, 0xaa, 0x7a, 0x75, 0x8a, 0x1e, 0xc2, 
};
static const u8 rsa_oaep_44_salt[] = {
0xbc, 0xa8, 0x05, 0x7f, 0x82, 0x4b, 0x2e, 0xa2, 0x57, 0xf2, 0x86, 0x14, 0x07, 0xee, 0xf6, 0x3d, 0x33, 0x20, 0x86, 0x81, 
};


static const rsa_test test_rsa_oaep_44 = {
	.name = "rsa_oaep_44",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_44_n,
	.nlen = sizeof(rsa_oaep_44_n),
	.d = (const u8*)&rsa_oaep_44_d,
	.dlen = sizeof(rsa_oaep_44_d),
	.e = (const u8*)&rsa_oaep_44_e,
	.elen = sizeof(rsa_oaep_44_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_44_m,
	.mlen = sizeof(rsa_oaep_44_m),
	.res = (const u8*)&rsa_oaep_44_res,
	.reslen = sizeof(rsa_oaep_44_res),
	.salt = (const u8*)&rsa_oaep_44_salt,
	.saltlen = sizeof(rsa_oaep_44_salt),
};
static const u8 rsa_oaep_45_CRT_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_45_CRT_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_45_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_45_CRT_m[] = {
0x28, 0xcc, 0xd4, 0x47, 0xbb, 0x9e, 0x85, 0x16, 0x6d, 0xab, 0xb9, 0xe5, 0xb7, 0xd1, 0xad, 0xad, 0xc4, 0xb9, 0xd3, 0x9f, 0x20, 0x4e, 0x96, 0xd5, 0xe4, 0x40, 0xce, 0x9a, 0xd9, 0x28, 0xbc, 0x1c, 0x22, 0x84, 
};
static const u8 rsa_oaep_45_CRT_res[] = {
0x00, 0xdb, 0xb8, 0xa7, 0x43, 0x9d, 0x90, 0xef, 0xd9, 0x19, 0xa3, 0x77, 0xc5, 0x4f, 0xae, 0x8f, 0xe1, 0x1e, 0xc5, 0x8c, 0x3b, 0x85, 0x83, 0x62, 0xe2, 0x3a, 0xd1, 0xb8, 0xa4, 0x43, 0x10, 0x79, 0x90, 0x66, 0xb9, 0x93, 0x47, 0xaa, 0x52, 0x56, 0x91, 0xd2, 0xad, 0xc5, 0x8d, 0x9b, 0x06, 0xe3, 0x4f, 0x28, 0x8c, 0x17, 0x03, 0x90, 0xc5, 0xf0, 0xe1, 0x1c, 0x0a, 0xa3, 0x64, 0x59, 0x59, 0xf1, 0x8e, 0xe7, 0x9e, 0x8f, 0x2b, 0xe8, 0xd7, 0xac, 0x5c, 0x23, 0xd0, 0x61, 0xf1, 0x8d, 0xd7, 0x4b, 0x8c, 0x5f, 0x2a, 0x58, 0xfc, 0xb5, 0xeb, 0x0c, 0x54, 0xf9, 0x9f, 0x01, 0xa8, 0x32, 0x47, 0x56, 0x82, 0x92, 0x53, 0x65, 0x83, 0x34, 0x09, 0x48, 0xd7, 0xa8, 0xc9, 0x7c, 0x4a, 0xcd, 0x1e, 0x98, 0xd1, 0xe2, 0x9d, 0xc3, 0x20, 0xe9, 0x7a, 0x26, 0x05, 0x32, 0xa8, 0xaa, 0x7a, 0x75, 0x8a, 0x1e, 0xc2, 
};
static const u8 rsa_oaep_45_CRT_salt[] = {
0xbc, 0xa8, 0x05, 0x7f, 0x82, 0x4b, 0x2e, 0xa2, 0x57, 0xf2, 0x86, 0x14, 0x07, 0xee, 0xf6, 0x3d, 0x33, 0x20, 0x86, 0x81, 
};
static const u8 rsa_oaep_45_CRT_p[] = {
0x02, 0x74, 0x58, 0xc1, 0x9e, 0xc1, 0x63, 0x69, 0x19, 0xe7, 0x36, 0xc9, 0xaf, 0x25, 0xd6, 0x09, 0xa5, 0x1b, 0x8f, 0x56, 0x1d, 0x19, 0xc6, 0xbf, 0x69, 0x43, 0xdd, 0x1e, 0xe1, 0xab, 0x8a, 0x4a, 0x3f, 0x23, 0x21, 0x00, 0xbd, 0x40, 0xb8, 0x8d, 0xec, 0xc6, 0xba, 0x23, 0x55, 0x48, 0xb6, 0xef, 0x79, 0x2a, 0x11, 0xc9, 0xde, 0x82, 0x3d, 0x0a, 0x79, 0x22, 0xc7, 0x09, 0x5b, 0x6e, 0xba, 0x57, 0x01, 
};
static const u8 rsa_oaep_45_CRT_q[] = {
0x02, 0x10, 0xee, 0x9b, 0x33, 0xab, 0x61, 0x71, 0x6e, 0x27, 0xd2, 0x51, 0xbd, 0x46, 0x5f, 0x4b, 0x35, 0xa1, 0xa2, 0x32, 0xe2, 0xda, 0x00, 0x90, 0x1c, 0x29, 0x4b, 0xf2, 0x23, 0x50, 0xce, 0x49, 0x0d, 0x09, 0x9f, 0x64, 0x2b, 0x53, 0x75, 0x61, 0x2d, 0xb6, 0x3b, 0xa1, 0xf2, 0x03, 0x86, 0x49, 0x2b, 0xf0, 0x4d, 0x34, 0xb3, 0xc2, 0x2b, 0xce, 0xb9, 0x09, 0xd1, 0x34, 0x41, 0xb5, 0x3b, 0x51, 0x39, 
};
static const u8 rsa_oaep_45_CRT_dP[] = {
0x39, 0xfa, 0x02, 0x8b, 0x82, 0x6e, 0x88, 0xc1, 0x12, 0x1b, 0x75, 0x0a, 0x8b, 0x24, 0x2f, 0xa9, 0xa3, 0x5c, 0x5b, 0x66, 0xbd, 0xfd, 0x1f, 0xa6, 0x37, 0xd3, 0xcc, 0x48, 0xa8, 0x4a, 0x4f, 0x45, 0x7a, 0x19, 0x4e, 0x77, 0x27, 0xe4, 0x9f, 0x7b, 0xcc, 0x6e, 0x5a, 0x5a, 0x41, 0x26, 0x57, 0xfc, 0x47, 0x0c, 0x73, 0x22, 0xeb, 0xc3, 0x74, 0x16, 0xef, 0x45, 0x8c, 0x30, 0x7a, 0x8c, 0x09, 0x01, 
};
static const u8 rsa_oaep_45_CRT_dQ[] = {
0x01, 0x5d, 0x99, 0xa8, 0x41, 0x95, 0x94, 0x39, 0x79, 0xfa, 0x9e, 0x1b, 0xe2, 0xc3, 0xc1, 0xb6, 0x9f, 0x43, 0x2f, 0x46, 0xfd, 0x03, 0xe4, 0x7d, 0x5b, 0xef, 0xbb, 0xbf, 0xd6, 0xb1, 0xd1, 0x37, 0x1d, 0x83, 0xef, 0xb3, 0x30, 0xa3, 0xe0, 0x20, 0x94, 0x2b, 0x2f, 0xed, 0x11, 0x5e, 0x5d, 0x02, 0xbe, 0x24, 0xfd, 0x92, 0xc9, 0x01, 0x9d, 0x1c, 0xec, 0xd6, 0xdd, 0x4c, 0xf1, 0xe5, 0x4c, 0xc8, 0x99, 
};
static const u8 rsa_oaep_45_CRT_qInv[] = {
0x01, 0xf0, 0xb7, 0x01, 0x51, 0x70, 0xb3, 0xf5, 0xe4, 0x22, 0x23, 0xba, 0x30, 0x30, 0x1c, 0x41, 0xa6, 0xd8, 0x7c, 0xbb, 0x70, 0xe3, 0x0c, 0xb7, 0xd3, 0xc6, 0x7d, 0x25, 0x47, 0x3d, 0xb1, 0xf6, 0xcb, 0xf0, 0x3e, 0x3f, 0x91, 0x26, 0xe3, 0xe9, 0x79, 0x68, 0x27, 0x9a, 0x86, 0x5b, 0x2c, 0x2b, 0x42, 0x65, 0x24, 0xcf, 0xc5, 0x2a, 0x68, 0x3d, 0x31, 0xed, 0x30, 0xeb, 0x98, 0x4b, 0xe4, 0x12, 0xba, 
};


static const rsa_test test_rsa_oaep_45_CRT = {
	.name = "rsa_oaep_45_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_45_CRT_n,
	.nlen = sizeof(rsa_oaep_45_CRT_n),
	.d = (const u8*)&rsa_oaep_45_CRT_d,
	.dlen = sizeof(rsa_oaep_45_CRT_d),
	.e = (const u8*)&rsa_oaep_45_CRT_e,
	.elen = sizeof(rsa_oaep_45_CRT_e),
	.p = (const u8*)&rsa_oaep_45_CRT_p,
	.plen = sizeof(rsa_oaep_45_CRT_p),
	.q = (const u8*)&rsa_oaep_45_CRT_q,
	.qlen = sizeof(rsa_oaep_45_CRT_q),
	.dP = (const u8*)&rsa_oaep_45_CRT_dP,
	.dPlen = sizeof(rsa_oaep_45_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_45_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_45_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_45_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_45_CRT_qInv),
	.m = (const u8*)&rsa_oaep_45_CRT_m,
	.mlen = sizeof(rsa_oaep_45_CRT_m),
	.res = (const u8*)&rsa_oaep_45_CRT_res,
	.reslen = sizeof(rsa_oaep_45_CRT_res),
	.salt = (const u8*)&rsa_oaep_45_CRT_salt,
	.saltlen = sizeof(rsa_oaep_45_CRT_salt),
};
static const u8 rsa_oaep_46_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_46_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_46_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_46_m[] = {
0xf2, 0x22, 0x42, 0x75, 0x1e, 0xc6, 0xb1, 
};
static const u8 rsa_oaep_46_res[] = {
0x00, 0xa5, 0xff, 0xa4, 0x76, 0x8c, 0x8b, 0xbe, 0xca, 0xee, 0x2d, 0xb7, 0x7e, 0x8f, 0x2e, 0xec, 0x99, 0x59, 0x59, 0x33, 0x54, 0x55, 0x20, 0x83, 0x5e, 0x5b, 0xa7, 0xdb, 0x94, 0x93, 0xd3, 0xe1, 0x7c, 0xdd, 0xef, 0xe6, 0xa5, 0xf5, 0x67, 0x62, 0x44, 0x71, 0x90, 0x8d, 0xb4, 0xe2, 0xd8, 0x3a, 0x0f, 0xbe, 0xe6, 0x06, 0x08, 0xfc, 0x84, 0x04, 0x95, 0x03, 0xb2, 0x23, 0x4a, 0x07, 0xdc, 0x83, 0xb2, 0x7b, 0x22, 0x84, 0x7a, 0xd8, 0x92, 0x0f, 0xf4, 0x2f, 0x67, 0x4e, 0xf7, 0x9b, 0x76, 0x28, 0x0b, 0x00, 0x23, 0x3d, 0x2b, 0x51, 0xb8, 0xcb, 0x27, 0x03, 0xa9, 0xd4, 0x2b, 0xfb, 0xc8, 0x25, 0x0c, 0x96, 0xec, 0x32, 0xc0, 0x51, 0xe5, 0x7f, 0x1b, 0x4b, 0xa5, 0x28, 0xdb, 0x89, 0xc3, 0x7e, 0x4c, 0x54, 0xe2, 0x7e, 0x6e, 0x64, 0xac, 0x69, 0x63, 0x5a, 0xe8, 0x87, 0xd9, 0x54, 0x16, 0x19, 0xa9, 
};
static const u8 rsa_oaep_46_salt[] = {
0x2e, 0x7e, 0x1e, 0x17, 0xf6, 0x47, 0xb5, 0xdd, 0xd0, 0x33, 0xe1, 0x54, 0x72, 0xf9, 0x0f, 0x68, 0x12, 0xf3, 0xac, 0x4e, 
};


static const rsa_test test_rsa_oaep_46 = {
	.name = "rsa_oaep_46",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_46_n,
	.nlen = sizeof(rsa_oaep_46_n),
	.d = (const u8*)&rsa_oaep_46_d,
	.dlen = sizeof(rsa_oaep_46_d),
	.e = (const u8*)&rsa_oaep_46_e,
	.elen = sizeof(rsa_oaep_46_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_46_m,
	.mlen = sizeof(rsa_oaep_46_m),
	.res = (const u8*)&rsa_oaep_46_res,
	.reslen = sizeof(rsa_oaep_46_res),
	.salt = (const u8*)&rsa_oaep_46_salt,
	.saltlen = sizeof(rsa_oaep_46_salt),
};
static const u8 rsa_oaep_47_CRT_n[] = {
0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39, 
};
static const u8 rsa_oaep_47_CRT_d[] = {
0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01, 
};
static const u8 rsa_oaep_47_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_47_CRT_m[] = {
0xf2, 0x22, 0x42, 0x75, 0x1e, 0xc6, 0xb1, 
};
static const u8 rsa_oaep_47_CRT_res[] = {
0x00, 0xa5, 0xff, 0xa4, 0x76, 0x8c, 0x8b, 0xbe, 0xca, 0xee, 0x2d, 0xb7, 0x7e, 0x8f, 0x2e, 0xec, 0x99, 0x59, 0x59, 0x33, 0x54, 0x55, 0x20, 0x83, 0x5e, 0x5b, 0xa7, 0xdb, 0x94, 0x93, 0xd3, 0xe1, 0x7c, 0xdd, 0xef, 0xe6, 0xa5, 0xf5, 0x67, 0x62, 0x44, 0x71, 0x90, 0x8d, 0xb4, 0xe2, 0xd8, 0x3a, 0x0f, 0xbe, 0xe6, 0x06, 0x08, 0xfc, 0x84, 0x04, 0x95, 0x03, 0xb2, 0x23, 0x4a, 0x07, 0xdc, 0x83, 0xb2, 0x7b, 0x22, 0x84, 0x7a, 0xd8, 0x92, 0x0f, 0xf4, 0x2f, 0x67, 0x4e, 0xf7, 0x9b, 0x76, 0x28, 0x0b, 0x00, 0x23, 0x3d, 0x2b, 0x51, 0xb8, 0xcb, 0x27, 0x03, 0xa9, 0xd4, 0x2b, 0xfb, 0xc8, 0x25, 0x0c, 0x96, 0xec, 0x32, 0xc0, 0x51, 0xe5, 0x7f, 0x1b, 0x4b, 0xa5, 0x28, 0xdb, 0x89, 0xc3, 0x7e, 0x4c, 0x54, 0xe2, 0x7e, 0x6e, 0x64, 0xac, 0x69, 0x63, 0x5a, 0xe8, 0x87, 0xd9, 0x54, 0x16, 0x19, 0xa9, 
};
static const u8 rsa_oaep_47_CRT_salt[] = {
0x2e, 0x7e, 0x1e, 0x17, 0xf6, 0x47, 0xb5, 0xdd, 0xd0, 0x33, 0xe1, 0x54, 0x72, 0xf9, 0x0f, 0x68, 0x12, 0xf3, 0xac, 0x4e, 
};
static const u8 rsa_oaep_47_CRT_p[] = {
0x02, 0x74, 0x58, 0xc1, 0x9e, 0xc1, 0x63, 0x69, 0x19, 0xe7, 0x36, 0xc9, 0xaf, 0x25, 0xd6, 0x09, 0xa5, 0x1b, 0x8f, 0x56, 0x1d, 0x19, 0xc6, 0xbf, 0x69, 0x43, 0xdd, 0x1e, 0xe1, 0xab, 0x8a, 0x4a, 0x3f, 0x23, 0x21, 0x00, 0xbd, 0x40, 0xb8, 0x8d, 0xec, 0xc6, 0xba, 0x23, 0x55, 0x48, 0xb6, 0xef, 0x79, 0x2a, 0x11, 0xc9, 0xde, 0x82, 0x3d, 0x0a, 0x79, 0x22, 0xc7, 0x09, 0x5b, 0x6e, 0xba, 0x57, 0x01, 
};
static const u8 rsa_oaep_47_CRT_q[] = {
0x02, 0x10, 0xee, 0x9b, 0x33, 0xab, 0x61, 0x71, 0x6e, 0x27, 0xd2, 0x51, 0xbd, 0x46, 0x5f, 0x4b, 0x35, 0xa1, 0xa2, 0x32, 0xe2, 0xda, 0x00, 0x90, 0x1c, 0x29, 0x4b, 0xf2, 0x23, 0x50, 0xce, 0x49, 0x0d, 0x09, 0x9f, 0x64, 0x2b, 0x53, 0x75, 0x61, 0x2d, 0xb6, 0x3b, 0xa1, 0xf2, 0x03, 0x86, 0x49, 0x2b, 0xf0, 0x4d, 0x34, 0xb3, 0xc2, 0x2b, 0xce, 0xb9, 0x09, 0xd1, 0x34, 0x41, 0xb5, 0x3b, 0x51, 0x39, 
};
static const u8 rsa_oaep_47_CRT_dP[] = {
0x39, 0xfa, 0x02, 0x8b, 0x82, 0x6e, 0x88, 0xc1, 0x12, 0x1b, 0x75, 0x0a, 0x8b, 0x24, 0x2f, 0xa9, 0xa3, 0x5c, 0x5b, 0x66, 0xbd, 0xfd, 0x1f, 0xa6, 0x37, 0xd3, 0xcc, 0x48, 0xa8, 0x4a, 0x4f, 0x45, 0x7a, 0x19, 0x4e, 0x77, 0x27, 0xe4, 0x9f, 0x7b, 0xcc, 0x6e, 0x5a, 0x5a, 0x41, 0x26, 0x57, 0xfc, 0x47, 0x0c, 0x73, 0x22, 0xeb, 0xc3, 0x74, 0x16, 0xef, 0x45, 0x8c, 0x30, 0x7a, 0x8c, 0x09, 0x01, 
};
static const u8 rsa_oaep_47_CRT_dQ[] = {
0x01, 0x5d, 0x99, 0xa8, 0x41, 0x95, 0x94, 0x39, 0x79, 0xfa, 0x9e, 0x1b, 0xe2, 0xc3, 0xc1, 0xb6, 0x9f, 0x43, 0x2f, 0x46, 0xfd, 0x03, 0xe4, 0x7d, 0x5b, 0xef, 0xbb, 0xbf, 0xd6, 0xb1, 0xd1, 0x37, 0x1d, 0x83, 0xef, 0xb3, 0x30, 0xa3, 0xe0, 0x20, 0x94, 0x2b, 0x2f, 0xed, 0x11, 0x5e, 0x5d, 0x02, 0xbe, 0x24, 0xfd, 0x92, 0xc9, 0x01, 0x9d, 0x1c, 0xec, 0xd6, 0xdd, 0x4c, 0xf1, 0xe5, 0x4c, 0xc8, 0x99, 
};
static const u8 rsa_oaep_47_CRT_qInv[] = {
0x01, 0xf0, 0xb7, 0x01, 0x51, 0x70, 0xb3, 0xf5, 0xe4, 0x22, 0x23, 0xba, 0x30, 0x30, 0x1c, 0x41, 0xa6, 0xd8, 0x7c, 0xbb, 0x70, 0xe3, 0x0c, 0xb7, 0xd3, 0xc6, 0x7d, 0x25, 0x47, 0x3d, 0xb1, 0xf6, 0xcb, 0xf0, 0x3e, 0x3f, 0x91, 0x26, 0xe3, 0xe9, 0x79, 0x68, 0x27, 0x9a, 0x86, 0x5b, 0x2c, 0x2b, 0x42, 0x65, 0x24, 0xcf, 0xc5, 0x2a, 0x68, 0x3d, 0x31, 0xed, 0x30, 0xeb, 0x98, 0x4b, 0xe4, 0x12, 0xba, 
};


static const rsa_test test_rsa_oaep_47_CRT = {
	.name = "rsa_oaep_47_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_47_CRT_n,
	.nlen = sizeof(rsa_oaep_47_CRT_n),
	.d = (const u8*)&rsa_oaep_47_CRT_d,
	.dlen = sizeof(rsa_oaep_47_CRT_d),
	.e = (const u8*)&rsa_oaep_47_CRT_e,
	.elen = sizeof(rsa_oaep_47_CRT_e),
	.p = (const u8*)&rsa_oaep_47_CRT_p,
	.plen = sizeof(rsa_oaep_47_CRT_p),
	.q = (const u8*)&rsa_oaep_47_CRT_q,
	.qlen = sizeof(rsa_oaep_47_CRT_q),
	.dP = (const u8*)&rsa_oaep_47_CRT_dP,
	.dPlen = sizeof(rsa_oaep_47_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_47_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_47_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_47_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_47_CRT_qInv),
	.m = (const u8*)&rsa_oaep_47_CRT_m,
	.mlen = sizeof(rsa_oaep_47_CRT_m),
	.res = (const u8*)&rsa_oaep_47_CRT_res,
	.reslen = sizeof(rsa_oaep_47_CRT_res),
	.salt = (const u8*)&rsa_oaep_47_CRT_salt,
	.saltlen = sizeof(rsa_oaep_47_CRT_salt),
};
static const u8 rsa_oaep_48_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_48_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_48_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_48_m[] = {
0xaf, 0x71, 0xa9, 0x01, 0xe3, 0xa6, 0x1d, 0x31, 0x32, 0xf0, 0xfc, 0x1f, 0xdb, 0x47, 0x4f, 0x9e, 0xa6, 0x57, 0x92, 0x57, 0xff, 0xc2, 0x4d, 0x16, 0x41, 0x70, 0x14, 0x5b, 0x3d, 0xbd, 0xe8, 
};
static const u8 rsa_oaep_48_res[] = {
0x03, 0x60, 0x46, 0xa4, 0xa4, 0x7d, 0x9e, 0xd3, 0xba, 0x9a, 0x89, 0x13, 0x9c, 0x10, 0x50, 0x38, 0xeb, 0x74, 0x92, 0xb0, 0x5a, 0x5d, 0x68, 0xbf, 0xd5, 0x3a, 0xcc, 0xff, 0x45, 0x97, 0xf7, 0xa6, 0x86, 0x51, 0xb4, 0x7b, 0x4a, 0x46, 0x27, 0xd9, 0x27, 0xe4, 0x85, 0xee, 0xd7, 0xb4, 0x56, 0x64, 0x20, 0xe8, 0xb4, 0x09, 0x87, 0x9e, 0x5d, 0x60, 0x6e, 0xae, 0x25, 0x1d, 0x22, 0xa5, 0xdf, 0x79, 0x9f, 0x79, 0x20, 0xbf, 0xc1, 0x17, 0xb9, 0x92, 0x57, 0x2a, 0x53, 0xb1, 0x26, 0x31, 0x46, 0xbc, 0xea, 0x03, 0x38, 0x5c, 0xc5, 0xe8, 0x53, 0xc9, 0xa1, 0x01, 0xc8, 0xc3, 0xe1, 0xbd, 0xa3, 0x1a, 0x51, 0x98, 0x07, 0x49, 0x6c, 0x6c, 0xb5, 0xe5, 0xef, 0xb4, 0x08, 0x82, 0x3a, 0x35, 0x2b, 0x8f, 0xa0, 0x66, 0x1f, 0xb6, 0x64, 0xef, 0xad, 0xd5, 0x93, 0xde, 0xb9, 0x9f, 0xff, 0x5e, 0xd0, 0x00, 0xe5, 
};
static const u8 rsa_oaep_48_salt[] = {
0x44, 0xc9, 0x2e, 0x28, 0x3f, 0x77, 0xb9, 0x49, 0x9c, 0x60, 0x3d, 0x96, 0x36, 0x60, 0xc8, 0x7d, 0x2f, 0x93, 0x94, 0x61, 
};


static const rsa_test test_rsa_oaep_48 = {
	.name = "rsa_oaep_48",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_48_n,
	.nlen = sizeof(rsa_oaep_48_n),
	.d = (const u8*)&rsa_oaep_48_d,
	.dlen = sizeof(rsa_oaep_48_d),
	.e = (const u8*)&rsa_oaep_48_e,
	.elen = sizeof(rsa_oaep_48_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_48_m,
	.mlen = sizeof(rsa_oaep_48_m),
	.res = (const u8*)&rsa_oaep_48_res,
	.reslen = sizeof(rsa_oaep_48_res),
	.salt = (const u8*)&rsa_oaep_48_salt,
	.saltlen = sizeof(rsa_oaep_48_salt),
};
static const u8 rsa_oaep_49_CRT_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_49_CRT_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_49_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_49_CRT_m[] = {
0xaf, 0x71, 0xa9, 0x01, 0xe3, 0xa6, 0x1d, 0x31, 0x32, 0xf0, 0xfc, 0x1f, 0xdb, 0x47, 0x4f, 0x9e, 0xa6, 0x57, 0x92, 0x57, 0xff, 0xc2, 0x4d, 0x16, 0x41, 0x70, 0x14, 0x5b, 0x3d, 0xbd, 0xe8, 
};
static const u8 rsa_oaep_49_CRT_res[] = {
0x03, 0x60, 0x46, 0xa4, 0xa4, 0x7d, 0x9e, 0xd3, 0xba, 0x9a, 0x89, 0x13, 0x9c, 0x10, 0x50, 0x38, 0xeb, 0x74, 0x92, 0xb0, 0x5a, 0x5d, 0x68, 0xbf, 0xd5, 0x3a, 0xcc, 0xff, 0x45, 0x97, 0xf7, 0xa6, 0x86, 0x51, 0xb4, 0x7b, 0x4a, 0x46, 0x27, 0xd9, 0x27, 0xe4, 0x85, 0xee, 0xd7, 0xb4, 0x56, 0x64, 0x20, 0xe8, 0xb4, 0x09, 0x87, 0x9e, 0x5d, 0x60, 0x6e, 0xae, 0x25, 0x1d, 0x22, 0xa5, 0xdf, 0x79, 0x9f, 0x79, 0x20, 0xbf, 0xc1, 0x17, 0xb9, 0x92, 0x57, 0x2a, 0x53, 0xb1, 0x26, 0x31, 0x46, 0xbc, 0xea, 0x03, 0x38, 0x5c, 0xc5, 0xe8, 0x53, 0xc9, 0xa1, 0x01, 0xc8, 0xc3, 0xe1, 0xbd, 0xa3, 0x1a, 0x51, 0x98, 0x07, 0x49, 0x6c, 0x6c, 0xb5, 0xe5, 0xef, 0xb4, 0x08, 0x82, 0x3a, 0x35, 0x2b, 0x8f, 0xa0, 0x66, 0x1f, 0xb6, 0x64, 0xef, 0xad, 0xd5, 0x93, 0xde, 0xb9, 0x9f, 0xff, 0x5e, 0xd0, 0x00, 0xe5, 
};
static const u8 rsa_oaep_49_CRT_salt[] = {
0x44, 0xc9, 0x2e, 0x28, 0x3f, 0x77, 0xb9, 0x49, 0x9c, 0x60, 0x3d, 0x96, 0x36, 0x60, 0xc8, 0x7d, 0x2f, 0x93, 0x94, 0x61, 
};
static const u8 rsa_oaep_49_CRT_p[] = {
0x03, 0xb0, 0xd3, 0x96, 0x2f, 0x6d, 0x17, 0x54, 0x9c, 0xbf, 0xca, 0x11, 0x29, 0x43, 0x48, 0xdc, 0xf0, 0xe7, 0xe3, 0x9f, 0x8c, 0x2b, 0xc6, 0x82, 0x4f, 0x21, 0x64, 0xb6, 0x06, 0xd6, 0x87, 0x86, 0x0d, 0xae, 0x1e, 0x63, 0x23, 0x93, 0xcf, 0xed, 0xf5, 0x13, 0x22, 0x82, 0x29, 0x06, 0x9e, 0x2f, 0x60, 0xe4, 0xac, 0xd7, 0xe6, 0x33, 0xa4, 0x36, 0x06, 0x3f, 0x82, 0x38, 0x5f, 0x48, 0x99, 0x37, 0x07, 
};
static const u8 rsa_oaep_49_CRT_q[] = {
0x02, 0xe4, 0xc3, 0x2e, 0x2f, 0x51, 0x72, 0x69, 0xb7, 0x07, 0x23, 0x09, 0xf0, 0x0c, 0x0e, 0x31, 0x36, 0x5f, 0x7c, 0xe2, 0x8b, 0x23, 0x6b, 0x82, 0x91, 0x2d, 0xf2, 0x39, 0xab, 0xf3, 0x95, 0x72, 0xcf, 0x0e, 0xd6, 0x04, 0xb0, 0x29, 0x82, 0xe5, 0x35, 0x64, 0xc5, 0x2d, 0x6a, 0x05, 0x39, 0x7d, 0xe5, 0xc0, 0x52, 0xa2, 0xfd, 0xdc, 0x14, 0x1e, 0xf7, 0x18, 0x98, 0x36, 0x34, 0x6a, 0xeb, 0x33, 0x1f, 
};
static const u8 rsa_oaep_49_CRT_dP[] = {
0x01, 0xe8, 0x4b, 0x11, 0x9d, 0x25, 0x16, 0x1f, 0xa6, 0x7b, 0x00, 0x25, 0x6a, 0x5b, 0xd9, 0xb6, 0x45, 0xd2, 0xb2, 0x32, 0xec, 0xb0, 0x5b, 0x01, 0x51, 0x80, 0x02, 0x9a, 0x88, 0x62, 0x2a, 0xdc, 0x3f, 0x09, 0xb3, 0xae, 0xac, 0xde, 0x61, 0x61, 0xab, 0x7c, 0xde, 0x22, 0xc2, 0xad, 0x26, 0xe7, 0x79, 0x7d, 0xf5, 0x4e, 0x07, 0x2c, 0xbd, 0x3b, 0x26, 0x73, 0x80, 0x0b, 0x3e, 0x43, 0x38, 0xdb, 0xd5, 
};
static const u8 rsa_oaep_49_CRT_dQ[] = {
0xeb, 0x90, 0xaa, 0x1a, 0x40, 0x13, 0x5b, 0x4c, 0xea, 0x07, 0x19, 0x7c, 0xed, 0xc8, 0x81, 0x9b, 0xe1, 0xe7, 0xcb, 0xff, 0x25, 0x47, 0x66, 0x21, 0x16, 0xf4, 0x65, 0xa4, 0xa9, 0xf4, 0x87, 0xab, 0x12, 0xf3, 0xba, 0x4f, 0xef, 0x13, 0x82, 0x22, 0x65, 0xa6, 0x52, 0x97, 0xd9, 0x8b, 0x7b, 0xde, 0xd9, 0x37, 0x2e, 0x3f, 0xfe, 0x81, 0xa3, 0x8b, 0x3e, 0x96, 0x00, 0xfe, 0xd0, 0x55, 0x75, 0x4f, 
};
static const u8 rsa_oaep_49_CRT_qInv[] = {
0x01, 0x2f, 0x7f, 0x81, 0x38, 0xf9, 0x40, 0x40, 0x62, 0xeb, 0x85, 0xa4, 0x29, 0x24, 0x52, 0x0b, 0x38, 0xf5, 0xbb, 0x88, 0x6a, 0x01, 0x96, 0xf4, 0x8b, 0xb8, 0xdc, 0xea, 0x60, 0xfd, 0x92, 0xcc, 0x02, 0x7f, 0x18, 0xe7, 0x81, 0x58, 0xa3, 0x4a, 0x5c, 0x5d, 0x5f, 0x86, 0x0a, 0x0f, 0x6c, 0x04, 0x07, 0x1a, 0x7d, 0x01, 0x31, 0x2c, 0x06, 0x50, 0x62, 0xf1, 0xeb, 0x48, 0xb7, 0x9d, 0x1c, 0x83, 0xcb, 
};


static const rsa_test test_rsa_oaep_49_CRT = {
	.name = "rsa_oaep_49_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_49_CRT_n,
	.nlen = sizeof(rsa_oaep_49_CRT_n),
	.d = (const u8*)&rsa_oaep_49_CRT_d,
	.dlen = sizeof(rsa_oaep_49_CRT_d),
	.e = (const u8*)&rsa_oaep_49_CRT_e,
	.elen = sizeof(rsa_oaep_49_CRT_e),
	.p = (const u8*)&rsa_oaep_49_CRT_p,
	.plen = sizeof(rsa_oaep_49_CRT_p),
	.q = (const u8*)&rsa_oaep_49_CRT_q,
	.qlen = sizeof(rsa_oaep_49_CRT_q),
	.dP = (const u8*)&rsa_oaep_49_CRT_dP,
	.dPlen = sizeof(rsa_oaep_49_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_49_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_49_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_49_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_49_CRT_qInv),
	.m = (const u8*)&rsa_oaep_49_CRT_m,
	.mlen = sizeof(rsa_oaep_49_CRT_m),
	.res = (const u8*)&rsa_oaep_49_CRT_res,
	.reslen = sizeof(rsa_oaep_49_CRT_res),
	.salt = (const u8*)&rsa_oaep_49_CRT_salt,
	.saltlen = sizeof(rsa_oaep_49_CRT_salt),
};
static const u8 rsa_oaep_50_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_50_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_50_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_50_m[] = {
0xa3, 0xb8, 0x44, 0xa0, 0x82, 0x39, 0xa8, 0xac, 0x41, 0x60, 0x5a, 0xf1, 0x7a, 0x6c, 0xfd, 0xa4, 0xd3, 0x50, 0x13, 0x65, 0x85, 0x90, 0x3a, 0x41, 0x7a, 0x79, 0x26, 0x87, 0x60, 0x51, 0x9a, 0x4b, 0x4a, 0xc3, 0x30, 0x3e, 0xc7, 0x3f, 0x0f, 0x87, 0xcf, 0xb3, 0x23, 0x99, 
};
static const u8 rsa_oaep_50_res[] = {
0x03, 0xd6, 0xeb, 0x65, 0x4e, 0xdc, 0xe6, 0x15, 0xbc, 0x59, 0xf4, 0x55, 0x26, 0x5e, 0xd4, 0xe5, 0xa1, 0x82, 0x23, 0xcb, 0xb9, 0xbe, 0x4e, 0x40, 0x69, 0xb4, 0x73, 0x80, 0x4d, 0x5d, 0xe9, 0x6f, 0x54, 0xdc, 0xaa, 0xa6, 0x03, 0xd0, 0x49, 0xc5, 0xd9, 0x4a, 0xa1, 0x47, 0x0d, 0xfc, 0xd2, 0x25, 0x40, 0x66, 0xb7, 0xc7, 0xb6, 0x1f, 0xf1, 0xf6, 0xf6, 0x77, 0x0e, 0x32, 0x15, 0xc5, 0x13, 0x99, 0xfd, 0x4e, 0x34, 0xec, 0x50, 0x82, 0xbc, 0x48, 0xf0, 0x89, 0x84, 0x0a, 0xd0, 0x43, 0x54, 0xae, 0x66, 0xdc, 0x0f, 0x1b, 0xd1, 0x8e, 0x46, 0x1a, 0x33, 0xcc, 0x12, 0x58, 0xb4, 0x43, 0xa2, 0x83, 0x7a, 0x6d, 0xf2, 0x67, 0x59, 0xaa, 0x23, 0x02, 0x33, 0x49, 0x86, 0xf8, 0x73, 0x80, 0xc9, 0xcc, 0x9d, 0x53, 0xbe, 0x9f, 0x99, 0x60, 0x5d, 0x2c, 0x9a, 0x97, 0xda, 0x7b, 0x09, 0x15, 0xa4, 0xa7, 0xad, 
};
static const u8 rsa_oaep_50_salt[] = {
0xcb, 0x28, 0xf5, 0x86, 0x06, 0x59, 0xfc, 0xee, 0xe4, 0x9c, 0x3e, 0xea, 0xfc, 0xe6, 0x25, 0xa7, 0x08, 0x03, 0xbd, 0x32, 
};


static const rsa_test test_rsa_oaep_50 = {
	.name = "rsa_oaep_50",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_50_n,
	.nlen = sizeof(rsa_oaep_50_n),
	.d = (const u8*)&rsa_oaep_50_d,
	.dlen = sizeof(rsa_oaep_50_d),
	.e = (const u8*)&rsa_oaep_50_e,
	.elen = sizeof(rsa_oaep_50_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_50_m,
	.mlen = sizeof(rsa_oaep_50_m),
	.res = (const u8*)&rsa_oaep_50_res,
	.reslen = sizeof(rsa_oaep_50_res),
	.salt = (const u8*)&rsa_oaep_50_salt,
	.saltlen = sizeof(rsa_oaep_50_salt),
};
static const u8 rsa_oaep_51_CRT_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_51_CRT_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_51_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_51_CRT_m[] = {
0xa3, 0xb8, 0x44, 0xa0, 0x82, 0x39, 0xa8, 0xac, 0x41, 0x60, 0x5a, 0xf1, 0x7a, 0x6c, 0xfd, 0xa4, 0xd3, 0x50, 0x13, 0x65, 0x85, 0x90, 0x3a, 0x41, 0x7a, 0x79, 0x26, 0x87, 0x60, 0x51, 0x9a, 0x4b, 0x4a, 0xc3, 0x30, 0x3e, 0xc7, 0x3f, 0x0f, 0x87, 0xcf, 0xb3, 0x23, 0x99, 
};
static const u8 rsa_oaep_51_CRT_res[] = {
0x03, 0xd6, 0xeb, 0x65, 0x4e, 0xdc, 0xe6, 0x15, 0xbc, 0x59, 0xf4, 0x55, 0x26, 0x5e, 0xd4, 0xe5, 0xa1, 0x82, 0x23, 0xcb, 0xb9, 0xbe, 0x4e, 0x40, 0x69, 0xb4, 0x73, 0x80, 0x4d, 0x5d, 0xe9, 0x6f, 0x54, 0xdc, 0xaa, 0xa6, 0x03, 0xd0, 0x49, 0xc5, 0xd9, 0x4a, 0xa1, 0x47, 0x0d, 0xfc, 0xd2, 0x25, 0x40, 0x66, 0xb7, 0xc7, 0xb6, 0x1f, 0xf1, 0xf6, 0xf6, 0x77, 0x0e, 0x32, 0x15, 0xc5, 0x13, 0x99, 0xfd, 0x4e, 0x34, 0xec, 0x50, 0x82, 0xbc, 0x48, 0xf0, 0x89, 0x84, 0x0a, 0xd0, 0x43, 0x54, 0xae, 0x66, 0xdc, 0x0f, 0x1b, 0xd1, 0x8e, 0x46, 0x1a, 0x33, 0xcc, 0x12, 0x58, 0xb4, 0x43, 0xa2, 0x83, 0x7a, 0x6d, 0xf2, 0x67, 0x59, 0xaa, 0x23, 0x02, 0x33, 0x49, 0x86, 0xf8, 0x73, 0x80, 0xc9, 0xcc, 0x9d, 0x53, 0xbe, 0x9f, 0x99, 0x60, 0x5d, 0x2c, 0x9a, 0x97, 0xda, 0x7b, 0x09, 0x15, 0xa4, 0xa7, 0xad, 
};
static const u8 rsa_oaep_51_CRT_salt[] = {
0xcb, 0x28, 0xf5, 0x86, 0x06, 0x59, 0xfc, 0xee, 0xe4, 0x9c, 0x3e, 0xea, 0xfc, 0xe6, 0x25, 0xa7, 0x08, 0x03, 0xbd, 0x32, 
};
static const u8 rsa_oaep_51_CRT_p[] = {
0x03, 0xb0, 0xd3, 0x96, 0x2f, 0x6d, 0x17, 0x54, 0x9c, 0xbf, 0xca, 0x11, 0x29, 0x43, 0x48, 0xdc, 0xf0, 0xe7, 0xe3, 0x9f, 0x8c, 0x2b, 0xc6, 0x82, 0x4f, 0x21, 0x64, 0xb6, 0x06, 0xd6, 0x87, 0x86, 0x0d, 0xae, 0x1e, 0x63, 0x23, 0x93, 0xcf, 0xed, 0xf5, 0x13, 0x22, 0x82, 0x29, 0x06, 0x9e, 0x2f, 0x60, 0xe4, 0xac, 0xd7, 0xe6, 0x33, 0xa4, 0x36, 0x06, 0x3f, 0x82, 0x38, 0x5f, 0x48, 0x99, 0x37, 0x07, 
};
static const u8 rsa_oaep_51_CRT_q[] = {
0x02, 0xe4, 0xc3, 0x2e, 0x2f, 0x51, 0x72, 0x69, 0xb7, 0x07, 0x23, 0x09, 0xf0, 0x0c, 0x0e, 0x31, 0x36, 0x5f, 0x7c, 0xe2, 0x8b, 0x23, 0x6b, 0x82, 0x91, 0x2d, 0xf2, 0x39, 0xab, 0xf3, 0x95, 0x72, 0xcf, 0x0e, 0xd6, 0x04, 0xb0, 0x29, 0x82, 0xe5, 0x35, 0x64, 0xc5, 0x2d, 0x6a, 0x05, 0x39, 0x7d, 0xe5, 0xc0, 0x52, 0xa2, 0xfd, 0xdc, 0x14, 0x1e, 0xf7, 0x18, 0x98, 0x36, 0x34, 0x6a, 0xeb, 0x33, 0x1f, 
};
static const u8 rsa_oaep_51_CRT_dP[] = {
0x01, 0xe8, 0x4b, 0x11, 0x9d, 0x25, 0x16, 0x1f, 0xa6, 0x7b, 0x00, 0x25, 0x6a, 0x5b, 0xd9, 0xb6, 0x45, 0xd2, 0xb2, 0x32, 0xec, 0xb0, 0x5b, 0x01, 0x51, 0x80, 0x02, 0x9a, 0x88, 0x62, 0x2a, 0xdc, 0x3f, 0x09, 0xb3, 0xae, 0xac, 0xde, 0x61, 0x61, 0xab, 0x7c, 0xde, 0x22, 0xc2, 0xad, 0x26, 0xe7, 0x79, 0x7d, 0xf5, 0x4e, 0x07, 0x2c, 0xbd, 0x3b, 0x26, 0x73, 0x80, 0x0b, 0x3e, 0x43, 0x38, 0xdb, 0xd5, 
};
static const u8 rsa_oaep_51_CRT_dQ[] = {
0xeb, 0x90, 0xaa, 0x1a, 0x40, 0x13, 0x5b, 0x4c, 0xea, 0x07, 0x19, 0x7c, 0xed, 0xc8, 0x81, 0x9b, 0xe1, 0xe7, 0xcb, 0xff, 0x25, 0x47, 0x66, 0x21, 0x16, 0xf4, 0x65, 0xa4, 0xa9, 0xf4, 0x87, 0xab, 0x12, 0xf3, 0xba, 0x4f, 0xef, 0x13, 0x82, 0x22, 0x65, 0xa6, 0x52, 0x97, 0xd9, 0x8b, 0x7b, 0xde, 0xd9, 0x37, 0x2e, 0x3f, 0xfe, 0x81, 0xa3, 0x8b, 0x3e, 0x96, 0x00, 0xfe, 0xd0, 0x55, 0x75, 0x4f, 
};
static const u8 rsa_oaep_51_CRT_qInv[] = {
0x01, 0x2f, 0x7f, 0x81, 0x38, 0xf9, 0x40, 0x40, 0x62, 0xeb, 0x85, 0xa4, 0x29, 0x24, 0x52, 0x0b, 0x38, 0xf5, 0xbb, 0x88, 0x6a, 0x01, 0x96, 0xf4, 0x8b, 0xb8, 0xdc, 0xea, 0x60, 0xfd, 0x92, 0xcc, 0x02, 0x7f, 0x18, 0xe7, 0x81, 0x58, 0xa3, 0x4a, 0x5c, 0x5d, 0x5f, 0x86, 0x0a, 0x0f, 0x6c, 0x04, 0x07, 0x1a, 0x7d, 0x01, 0x31, 0x2c, 0x06, 0x50, 0x62, 0xf1, 0xeb, 0x48, 0xb7, 0x9d, 0x1c, 0x83, 0xcb, 
};


static const rsa_test test_rsa_oaep_51_CRT = {
	.name = "rsa_oaep_51_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_51_CRT_n,
	.nlen = sizeof(rsa_oaep_51_CRT_n),
	.d = (const u8*)&rsa_oaep_51_CRT_d,
	.dlen = sizeof(rsa_oaep_51_CRT_d),
	.e = (const u8*)&rsa_oaep_51_CRT_e,
	.elen = sizeof(rsa_oaep_51_CRT_e),
	.p = (const u8*)&rsa_oaep_51_CRT_p,
	.plen = sizeof(rsa_oaep_51_CRT_p),
	.q = (const u8*)&rsa_oaep_51_CRT_q,
	.qlen = sizeof(rsa_oaep_51_CRT_q),
	.dP = (const u8*)&rsa_oaep_51_CRT_dP,
	.dPlen = sizeof(rsa_oaep_51_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_51_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_51_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_51_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_51_CRT_qInv),
	.m = (const u8*)&rsa_oaep_51_CRT_m,
	.mlen = sizeof(rsa_oaep_51_CRT_m),
	.res = (const u8*)&rsa_oaep_51_CRT_res,
	.reslen = sizeof(rsa_oaep_51_CRT_res),
	.salt = (const u8*)&rsa_oaep_51_CRT_salt,
	.saltlen = sizeof(rsa_oaep_51_CRT_salt),
};
static const u8 rsa_oaep_52_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_52_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_52_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_52_m[] = {
0x30, 0x8b, 0x0e, 0xcb, 0xd2, 0xc7, 0x6c, 0xb7, 0x7f, 0xc6, 0xf7, 0x0c, 0x5e, 0xdd, 0x23, 0x3f, 0xd2, 0xf2, 0x09, 0x29, 0xd6, 0x29, 0xf0, 0x26, 0x95, 0x3b, 0xb6, 0x2a, 0x8f, 0x4a, 0x3a, 0x31, 0x4b, 0xde, 0x19, 0x5d, 0xe8, 0x5b, 0x5f, 0x81, 0x6d, 0xa2, 0xaa, 0xb0, 0x74, 0xd2, 0x6c, 0xb6, 0xac, 0xdd, 0xf3, 0x23, 0xae, 0x3b, 0x9c, 0x67, 0x8a, 0xc3, 0xcf, 0x12, 0xfb, 0xdd, 0xe7, 
};
static const u8 rsa_oaep_52_res[] = {
0x07, 0x70, 0x95, 0x21, 0x81, 0x64, 0x9f, 0x9f, 0x9f, 0x07, 0xff, 0x62, 0x6f, 0xf3, 0xa2, 0x2c, 0x35, 0xc4, 0x62, 0x44, 0x3d, 0x90, 0x5d, 0x45, 0x6a, 0x9f, 0xd0, 0xbf, 0xf4, 0x3c, 0xac, 0x2c, 0xa7, 0xa9, 0xf5, 0x54, 0xe9, 0x47, 0x8b, 0x9a, 0xcc, 0x3a, 0xc8, 0x38, 0xb0, 0x20, 0x40, 0xff, 0xd3, 0xe1, 0x84, 0x7d, 0xe2, 0xe4, 0x25, 0x39, 0x29, 0xf9, 0xdd, 0x9e, 0xe4, 0x04, 0x43, 0x25, 0xa9, 0xb0, 0x5c, 0xab, 0xb8, 0x08, 0xb2, 0xee, 0x84, 0x0d, 0x34, 0xe1, 0x5d, 0x10, 0x5a, 0x3f, 0x1f, 0x7b, 0x27, 0x69, 0x5a, 0x1a, 0x07, 0xa2, 0xd7, 0x3f, 0xe0, 0x8e, 0xca, 0xaa, 0x3c, 0x9c, 0x9d, 0x4d, 0x5a, 0x89, 0xff, 0x89, 0x0d, 0x54, 0x72, 0x7d, 0x7a, 0xe4, 0x0c, 0x0e, 0xc1, 0xa8, 0xdd, 0x86, 0x16, 0x5d, 0x8e, 0xe2, 0xc6, 0x36, 0x81, 0x41, 0x01, 0x6a, 0x48, 0xb5, 0x5b, 0x69, 0x67, 
};
static const u8 rsa_oaep_52_salt[] = {
0x22, 0x85, 0xf4, 0x0d, 0x77, 0x04, 0x82, 0xf9, 0xa9, 0xef, 0xa2, 0xc7, 0x2c, 0xb3, 0xac, 0x55, 0x71, 0x6d, 0xc0, 0xca, 
};


static const rsa_test test_rsa_oaep_52 = {
	.name = "rsa_oaep_52",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_52_n,
	.nlen = sizeof(rsa_oaep_52_n),
	.d = (const u8*)&rsa_oaep_52_d,
	.dlen = sizeof(rsa_oaep_52_d),
	.e = (const u8*)&rsa_oaep_52_e,
	.elen = sizeof(rsa_oaep_52_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_52_m,
	.mlen = sizeof(rsa_oaep_52_m),
	.res = (const u8*)&rsa_oaep_52_res,
	.reslen = sizeof(rsa_oaep_52_res),
	.salt = (const u8*)&rsa_oaep_52_salt,
	.saltlen = sizeof(rsa_oaep_52_salt),
};
static const u8 rsa_oaep_53_CRT_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_53_CRT_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_53_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_53_CRT_m[] = {
0x30, 0x8b, 0x0e, 0xcb, 0xd2, 0xc7, 0x6c, 0xb7, 0x7f, 0xc6, 0xf7, 0x0c, 0x5e, 0xdd, 0x23, 0x3f, 0xd2, 0xf2, 0x09, 0x29, 0xd6, 0x29, 0xf0, 0x26, 0x95, 0x3b, 0xb6, 0x2a, 0x8f, 0x4a, 0x3a, 0x31, 0x4b, 0xde, 0x19, 0x5d, 0xe8, 0x5b, 0x5f, 0x81, 0x6d, 0xa2, 0xaa, 0xb0, 0x74, 0xd2, 0x6c, 0xb6, 0xac, 0xdd, 0xf3, 0x23, 0xae, 0x3b, 0x9c, 0x67, 0x8a, 0xc3, 0xcf, 0x12, 0xfb, 0xdd, 0xe7, 
};
static const u8 rsa_oaep_53_CRT_res[] = {
0x07, 0x70, 0x95, 0x21, 0x81, 0x64, 0x9f, 0x9f, 0x9f, 0x07, 0xff, 0x62, 0x6f, 0xf3, 0xa2, 0x2c, 0x35, 0xc4, 0x62, 0x44, 0x3d, 0x90, 0x5d, 0x45, 0x6a, 0x9f, 0xd0, 0xbf, 0xf4, 0x3c, 0xac, 0x2c, 0xa7, 0xa9, 0xf5, 0x54, 0xe9, 0x47, 0x8b, 0x9a, 0xcc, 0x3a, 0xc8, 0x38, 0xb0, 0x20, 0x40, 0xff, 0xd3, 0xe1, 0x84, 0x7d, 0xe2, 0xe4, 0x25, 0x39, 0x29, 0xf9, 0xdd, 0x9e, 0xe4, 0x04, 0x43, 0x25, 0xa9, 0xb0, 0x5c, 0xab, 0xb8, 0x08, 0xb2, 0xee, 0x84, 0x0d, 0x34, 0xe1, 0x5d, 0x10, 0x5a, 0x3f, 0x1f, 0x7b, 0x27, 0x69, 0x5a, 0x1a, 0x07, 0xa2, 0xd7, 0x3f, 0xe0, 0x8e, 0xca, 0xaa, 0x3c, 0x9c, 0x9d, 0x4d, 0x5a, 0x89, 0xff, 0x89, 0x0d, 0x54, 0x72, 0x7d, 0x7a, 0xe4, 0x0c, 0x0e, 0xc1, 0xa8, 0xdd, 0x86, 0x16, 0x5d, 0x8e, 0xe2, 0xc6, 0x36, 0x81, 0x41, 0x01, 0x6a, 0x48, 0xb5, 0x5b, 0x69, 0x67, 
};
static const u8 rsa_oaep_53_CRT_salt[] = {
0x22, 0x85, 0xf4, 0x0d, 0x77, 0x04, 0x82, 0xf9, 0xa9, 0xef, 0xa2, 0xc7, 0x2c, 0xb3, 0xac, 0x55, 0x71, 0x6d, 0xc0, 0xca, 
};
static const u8 rsa_oaep_53_CRT_p[] = {
0x03, 0xb0, 0xd3, 0x96, 0x2f, 0x6d, 0x17, 0x54, 0x9c, 0xbf, 0xca, 0x11, 0x29, 0x43, 0x48, 0xdc, 0xf0, 0xe7, 0xe3, 0x9f, 0x8c, 0x2b, 0xc6, 0x82, 0x4f, 0x21, 0x64, 0xb6, 0x06, 0xd6, 0x87, 0x86, 0x0d, 0xae, 0x1e, 0x63, 0x23, 0x93, 0xcf, 0xed, 0xf5, 0x13, 0x22, 0x82, 0x29, 0x06, 0x9e, 0x2f, 0x60, 0xe4, 0xac, 0xd7, 0xe6, 0x33, 0xa4, 0x36, 0x06, 0x3f, 0x82, 0x38, 0x5f, 0x48, 0x99, 0x37, 0x07, 
};
static const u8 rsa_oaep_53_CRT_q[] = {
0x02, 0xe4, 0xc3, 0x2e, 0x2f, 0x51, 0x72, 0x69, 0xb7, 0x07, 0x23, 0x09, 0xf0, 0x0c, 0x0e, 0x31, 0x36, 0x5f, 0x7c, 0xe2, 0x8b, 0x23, 0x6b, 0x82, 0x91, 0x2d, 0xf2, 0x39, 0xab, 0xf3, 0x95, 0x72, 0xcf, 0x0e, 0xd6, 0x04, 0xb0, 0x29, 0x82, 0xe5, 0x35, 0x64, 0xc5, 0x2d, 0x6a, 0x05, 0x39, 0x7d, 0xe5, 0xc0, 0x52, 0xa2, 0xfd, 0xdc, 0x14, 0x1e, 0xf7, 0x18, 0x98, 0x36, 0x34, 0x6a, 0xeb, 0x33, 0x1f, 
};
static const u8 rsa_oaep_53_CRT_dP[] = {
0x01, 0xe8, 0x4b, 0x11, 0x9d, 0x25, 0x16, 0x1f, 0xa6, 0x7b, 0x00, 0x25, 0x6a, 0x5b, 0xd9, 0xb6, 0x45, 0xd2, 0xb2, 0x32, 0xec, 0xb0, 0x5b, 0x01, 0x51, 0x80, 0x02, 0x9a, 0x88, 0x62, 0x2a, 0xdc, 0x3f, 0x09, 0xb3, 0xae, 0xac, 0xde, 0x61, 0x61, 0xab, 0x7c, 0xde, 0x22, 0xc2, 0xad, 0x26, 0xe7, 0x79, 0x7d, 0xf5, 0x4e, 0x07, 0x2c, 0xbd, 0x3b, 0x26, 0x73, 0x80, 0x0b, 0x3e, 0x43, 0x38, 0xdb, 0xd5, 
};
static const u8 rsa_oaep_53_CRT_dQ[] = {
0xeb, 0x90, 0xaa, 0x1a, 0x40, 0x13, 0x5b, 0x4c, 0xea, 0x07, 0x19, 0x7c, 0xed, 0xc8, 0x81, 0x9b, 0xe1, 0xe7, 0xcb, 0xff, 0x25, 0x47, 0x66, 0x21, 0x16, 0xf4, 0x65, 0xa4, 0xa9, 0xf4, 0x87, 0xab, 0x12, 0xf3, 0xba, 0x4f, 0xef, 0x13, 0x82, 0x22, 0x65, 0xa6, 0x52, 0x97, 0xd9, 0x8b, 0x7b, 0xde, 0xd9, 0x37, 0x2e, 0x3f, 0xfe, 0x81, 0xa3, 0x8b, 0x3e, 0x96, 0x00, 0xfe, 0xd0, 0x55, 0x75, 0x4f, 
};
static const u8 rsa_oaep_53_CRT_qInv[] = {
0x01, 0x2f, 0x7f, 0x81, 0x38, 0xf9, 0x40, 0x40, 0x62, 0xeb, 0x85, 0xa4, 0x29, 0x24, 0x52, 0x0b, 0x38, 0xf5, 0xbb, 0x88, 0x6a, 0x01, 0x96, 0xf4, 0x8b, 0xb8, 0xdc, 0xea, 0x60, 0xfd, 0x92, 0xcc, 0x02, 0x7f, 0x18, 0xe7, 0x81, 0x58, 0xa3, 0x4a, 0x5c, 0x5d, 0x5f, 0x86, 0x0a, 0x0f, 0x6c, 0x04, 0x07, 0x1a, 0x7d, 0x01, 0x31, 0x2c, 0x06, 0x50, 0x62, 0xf1, 0xeb, 0x48, 0xb7, 0x9d, 0x1c, 0x83, 0xcb, 
};


static const rsa_test test_rsa_oaep_53_CRT = {
	.name = "rsa_oaep_53_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_53_CRT_n,
	.nlen = sizeof(rsa_oaep_53_CRT_n),
	.d = (const u8*)&rsa_oaep_53_CRT_d,
	.dlen = sizeof(rsa_oaep_53_CRT_d),
	.e = (const u8*)&rsa_oaep_53_CRT_e,
	.elen = sizeof(rsa_oaep_53_CRT_e),
	.p = (const u8*)&rsa_oaep_53_CRT_p,
	.plen = sizeof(rsa_oaep_53_CRT_p),
	.q = (const u8*)&rsa_oaep_53_CRT_q,
	.qlen = sizeof(rsa_oaep_53_CRT_q),
	.dP = (const u8*)&rsa_oaep_53_CRT_dP,
	.dPlen = sizeof(rsa_oaep_53_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_53_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_53_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_53_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_53_CRT_qInv),
	.m = (const u8*)&rsa_oaep_53_CRT_m,
	.mlen = sizeof(rsa_oaep_53_CRT_m),
	.res = (const u8*)&rsa_oaep_53_CRT_res,
	.reslen = sizeof(rsa_oaep_53_CRT_res),
	.salt = (const u8*)&rsa_oaep_53_CRT_salt,
	.saltlen = sizeof(rsa_oaep_53_CRT_salt),
};
static const u8 rsa_oaep_54_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_54_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_54_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_54_m[] = {
0x15, 0xc5, 0xb9, 0xee, 0x11, 0x85, 
};
static const u8 rsa_oaep_54_res[] = {
0x08, 0x12, 0xb7, 0x67, 0x68, 0xeb, 0xcb, 0x64, 0x2d, 0x04, 0x02, 0x58, 0xe5, 0xf4, 0x44, 0x1a, 0x01, 0x85, 0x21, 0xbd, 0x96, 0x68, 0x7e, 0x6c, 0x5e, 0x89, 0x9f, 0xcd, 0x6c, 0x17, 0x58, 0x8f, 0xf5, 0x9a, 0x82, 0xcc, 0x8a, 0xe0, 0x3a, 0x4b, 0x45, 0xb3, 0x12, 0x99, 0xaf, 0x17, 0x88, 0xc3, 0x29, 0xf7, 0xdc, 0xd2, 0x85, 0xf8, 0xcf, 0x4c, 0xed, 0x82, 0x60, 0x6b, 0x97, 0x61, 0x26, 0x71, 0xa4, 0x5b, 0xed, 0xca, 0x13, 0x34, 0x42, 0x14, 0x4d, 0x16, 0x17, 0xd1, 0x14, 0xf8, 0x02, 0x85, 0x7f, 0x0f, 0x9d, 0x73, 0x97, 0x51, 0xc5, 0x7a, 0x3f, 0x9e, 0xe4, 0x00, 0x91, 0x2c, 0x61, 0xe2, 0xe6, 0x99, 0x2b, 0xe0, 0x31, 0xa4, 0x3d, 0xd4, 0x8f, 0xa6, 0xba, 0x14, 0xee, 0xf7, 0xc4, 0x22, 0xb5, 0xed, 0xc4, 0xe7, 0xaf, 0xa0, 0x4f, 0xdd, 0x38, 0xf4, 0x02, 0xd1, 0xc8, 0xbb, 0x71, 0x9a, 0xbf, 
};
static const u8 rsa_oaep_54_salt[] = {
0x49, 0xfa, 0x45, 0xd3, 0xa7, 0x8d, 0xd1, 0x0d, 0xfd, 0x57, 0x73, 0x99, 0xd1, 0xeb, 0x00, 0xaf, 0x7e, 0xed, 0x55, 0x13, 
};


static const rsa_test test_rsa_oaep_54 = {
	.name = "rsa_oaep_54",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_54_n,
	.nlen = sizeof(rsa_oaep_54_n),
	.d = (const u8*)&rsa_oaep_54_d,
	.dlen = sizeof(rsa_oaep_54_d),
	.e = (const u8*)&rsa_oaep_54_e,
	.elen = sizeof(rsa_oaep_54_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_54_m,
	.mlen = sizeof(rsa_oaep_54_m),
	.res = (const u8*)&rsa_oaep_54_res,
	.reslen = sizeof(rsa_oaep_54_res),
	.salt = (const u8*)&rsa_oaep_54_salt,
	.saltlen = sizeof(rsa_oaep_54_salt),
};
static const u8 rsa_oaep_55_CRT_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_55_CRT_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_55_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_55_CRT_m[] = {
0x15, 0xc5, 0xb9, 0xee, 0x11, 0x85, 
};
static const u8 rsa_oaep_55_CRT_res[] = {
0x08, 0x12, 0xb7, 0x67, 0x68, 0xeb, 0xcb, 0x64, 0x2d, 0x04, 0x02, 0x58, 0xe5, 0xf4, 0x44, 0x1a, 0x01, 0x85, 0x21, 0xbd, 0x96, 0x68, 0x7e, 0x6c, 0x5e, 0x89, 0x9f, 0xcd, 0x6c, 0x17, 0x58, 0x8f, 0xf5, 0x9a, 0x82, 0xcc, 0x8a, 0xe0, 0x3a, 0x4b, 0x45, 0xb3, 0x12, 0x99, 0xaf, 0x17, 0x88, 0xc3, 0x29, 0xf7, 0xdc, 0xd2, 0x85, 0xf8, 0xcf, 0x4c, 0xed, 0x82, 0x60, 0x6b, 0x97, 0x61, 0x26, 0x71, 0xa4, 0x5b, 0xed, 0xca, 0x13, 0x34, 0x42, 0x14, 0x4d, 0x16, 0x17, 0xd1, 0x14, 0xf8, 0x02, 0x85, 0x7f, 0x0f, 0x9d, 0x73, 0x97, 0x51, 0xc5, 0x7a, 0x3f, 0x9e, 0xe4, 0x00, 0x91, 0x2c, 0x61, 0xe2, 0xe6, 0x99, 0x2b, 0xe0, 0x31, 0xa4, 0x3d, 0xd4, 0x8f, 0xa6, 0xba, 0x14, 0xee, 0xf7, 0xc4, 0x22, 0xb5, 0xed, 0xc4, 0xe7, 0xaf, 0xa0, 0x4f, 0xdd, 0x38, 0xf4, 0x02, 0xd1, 0xc8, 0xbb, 0x71, 0x9a, 0xbf, 
};
static const u8 rsa_oaep_55_CRT_salt[] = {
0x49, 0xfa, 0x45, 0xd3, 0xa7, 0x8d, 0xd1, 0x0d, 0xfd, 0x57, 0x73, 0x99, 0xd1, 0xeb, 0x00, 0xaf, 0x7e, 0xed, 0x55, 0x13, 
};
static const u8 rsa_oaep_55_CRT_p[] = {
0x03, 0xb0, 0xd3, 0x96, 0x2f, 0x6d, 0x17, 0x54, 0x9c, 0xbf, 0xca, 0x11, 0x29, 0x43, 0x48, 0xdc, 0xf0, 0xe7, 0xe3, 0x9f, 0x8c, 0x2b, 0xc6, 0x82, 0x4f, 0x21, 0x64, 0xb6, 0x06, 0xd6, 0x87, 0x86, 0x0d, 0xae, 0x1e, 0x63, 0x23, 0x93, 0xcf, 0xed, 0xf5, 0x13, 0x22, 0x82, 0x29, 0x06, 0x9e, 0x2f, 0x60, 0xe4, 0xac, 0xd7, 0xe6, 0x33, 0xa4, 0x36, 0x06, 0x3f, 0x82, 0x38, 0x5f, 0x48, 0x99, 0x37, 0x07, 
};
static const u8 rsa_oaep_55_CRT_q[] = {
0x02, 0xe4, 0xc3, 0x2e, 0x2f, 0x51, 0x72, 0x69, 0xb7, 0x07, 0x23, 0x09, 0xf0, 0x0c, 0x0e, 0x31, 0x36, 0x5f, 0x7c, 0xe2, 0x8b, 0x23, 0x6b, 0x82, 0x91, 0x2d, 0xf2, 0x39, 0xab, 0xf3, 0x95, 0x72, 0xcf, 0x0e, 0xd6, 0x04, 0xb0, 0x29, 0x82, 0xe5, 0x35, 0x64, 0xc5, 0x2d, 0x6a, 0x05, 0x39, 0x7d, 0xe5, 0xc0, 0x52, 0xa2, 0xfd, 0xdc, 0x14, 0x1e, 0xf7, 0x18, 0x98, 0x36, 0x34, 0x6a, 0xeb, 0x33, 0x1f, 
};
static const u8 rsa_oaep_55_CRT_dP[] = {
0x01, 0xe8, 0x4b, 0x11, 0x9d, 0x25, 0x16, 0x1f, 0xa6, 0x7b, 0x00, 0x25, 0x6a, 0x5b, 0xd9, 0xb6, 0x45, 0xd2, 0xb2, 0x32, 0xec, 0xb0, 0x5b, 0x01, 0x51, 0x80, 0x02, 0x9a, 0x88, 0x62, 0x2a, 0xdc, 0x3f, 0x09, 0xb3, 0xae, 0xac, 0xde, 0x61, 0x61, 0xab, 0x7c, 0xde, 0x22, 0xc2, 0xad, 0x26, 0xe7, 0x79, 0x7d, 0xf5, 0x4e, 0x07, 0x2c, 0xbd, 0x3b, 0x26, 0x73, 0x80, 0x0b, 0x3e, 0x43, 0x38, 0xdb, 0xd5, 
};
static const u8 rsa_oaep_55_CRT_dQ[] = {
0xeb, 0x90, 0xaa, 0x1a, 0x40, 0x13, 0x5b, 0x4c, 0xea, 0x07, 0x19, 0x7c, 0xed, 0xc8, 0x81, 0x9b, 0xe1, 0xe7, 0xcb, 0xff, 0x25, 0x47, 0x66, 0x21, 0x16, 0xf4, 0x65, 0xa4, 0xa9, 0xf4, 0x87, 0xab, 0x12, 0xf3, 0xba, 0x4f, 0xef, 0x13, 0x82, 0x22, 0x65, 0xa6, 0x52, 0x97, 0xd9, 0x8b, 0x7b, 0xde, 0xd9, 0x37, 0x2e, 0x3f, 0xfe, 0x81, 0xa3, 0x8b, 0x3e, 0x96, 0x00, 0xfe, 0xd0, 0x55, 0x75, 0x4f, 
};
static const u8 rsa_oaep_55_CRT_qInv[] = {
0x01, 0x2f, 0x7f, 0x81, 0x38, 0xf9, 0x40, 0x40, 0x62, 0xeb, 0x85, 0xa4, 0x29, 0x24, 0x52, 0x0b, 0x38, 0xf5, 0xbb, 0x88, 0x6a, 0x01, 0x96, 0xf4, 0x8b, 0xb8, 0xdc, 0xea, 0x60, 0xfd, 0x92, 0xcc, 0x02, 0x7f, 0x18, 0xe7, 0x81, 0x58, 0xa3, 0x4a, 0x5c, 0x5d, 0x5f, 0x86, 0x0a, 0x0f, 0x6c, 0x04, 0x07, 0x1a, 0x7d, 0x01, 0x31, 0x2c, 0x06, 0x50, 0x62, 0xf1, 0xeb, 0x48, 0xb7, 0x9d, 0x1c, 0x83, 0xcb, 
};


static const rsa_test test_rsa_oaep_55_CRT = {
	.name = "rsa_oaep_55_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_55_CRT_n,
	.nlen = sizeof(rsa_oaep_55_CRT_n),
	.d = (const u8*)&rsa_oaep_55_CRT_d,
	.dlen = sizeof(rsa_oaep_55_CRT_d),
	.e = (const u8*)&rsa_oaep_55_CRT_e,
	.elen = sizeof(rsa_oaep_55_CRT_e),
	.p = (const u8*)&rsa_oaep_55_CRT_p,
	.plen = sizeof(rsa_oaep_55_CRT_p),
	.q = (const u8*)&rsa_oaep_55_CRT_q,
	.qlen = sizeof(rsa_oaep_55_CRT_q),
	.dP = (const u8*)&rsa_oaep_55_CRT_dP,
	.dPlen = sizeof(rsa_oaep_55_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_55_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_55_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_55_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_55_CRT_qInv),
	.m = (const u8*)&rsa_oaep_55_CRT_m,
	.mlen = sizeof(rsa_oaep_55_CRT_m),
	.res = (const u8*)&rsa_oaep_55_CRT_res,
	.reslen = sizeof(rsa_oaep_55_CRT_res),
	.salt = (const u8*)&rsa_oaep_55_CRT_salt,
	.saltlen = sizeof(rsa_oaep_55_CRT_salt),
};
static const u8 rsa_oaep_56_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_56_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_56_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_56_m[] = {
0x21, 0x02, 0x6e, 0x68, 0x00, 0xc7, 0xfa, 0x72, 0x8f, 0xca, 0xab, 0xa0, 0xd1, 0x96, 0xae, 0x28, 0xd7, 0xa2, 0xac, 0x4f, 0xfd, 0x8a, 0xbc, 0xe7, 0x94, 0xf0, 0x98, 0x5f, 0x60, 0xc8, 0xa6, 0x73, 0x72, 0x77, 0x36, 0x5d, 0x3f, 0xea, 0x11, 0xdb, 0x89, 0x23, 0xa2, 0x02, 0x9a, 
};
static const u8 rsa_oaep_56_res[] = {
0x07, 0xb6, 0x0e, 0x14, 0xec, 0x95, 0x4b, 0xfd, 0x29, 0xe6, 0x0d, 0x00, 0x47, 0xe7, 0x89, 0xf5, 0x1d, 0x57, 0x18, 0x6c, 0x63, 0x58, 0x99, 0x03, 0x30, 0x67, 0x93, 0xce, 0xd3, 0xf6, 0x82, 0x41, 0xc7, 0x43, 0x52, 0x9a, 0xba, 0x6a, 0x63, 0x74, 0xf9, 0x2e, 0x19, 0xe0, 0x16, 0x3e, 0xfa, 0x33, 0x69, 0x7e, 0x19, 0x6f, 0x76, 0x61, 0xdf, 0xaa, 0xa4, 0x7a, 0xac, 0x6b, 0xde, 0x5e, 0x51, 0xde, 0xb5, 0x07, 0xc7, 0x2c, 0x58, 0x9a, 0x2c, 0xa1, 0x69, 0x3d, 0x96, 0xb1, 0x46, 0x03, 0x81, 0x24, 0x9b, 0x2c, 0xdb, 0x9e, 0xac, 0x44, 0x76, 0x9f, 0x24, 0x89, 0xc5, 0xd3, 0xd2, 0xf9, 0x9f, 0x0e, 0xe3, 0xc7, 0xee, 0x5b, 0xf6, 0x4a, 0x5a, 0xc7, 0x9c, 0x42, 0xbd, 0x43, 0x3f, 0x14, 0x9b, 0xe8, 0xcb, 0x59, 0x54, 0x83, 0x61, 0x64, 0x05, 0x95, 0x51, 0x3c, 0x97, 0xaf, 0x7b, 0xc2, 0x50, 0x97, 0x23, 
};
static const u8 rsa_oaep_56_salt[] = {
0xf0, 0x28, 0x74, 0x13, 0x23, 0x4c, 0xc5, 0x03, 0x47, 0x24, 0xa0, 0x94, 0xc4, 0x58, 0x6b, 0x87, 0xaf, 0xf1, 0x33, 0xfc, 
};


static const rsa_test test_rsa_oaep_56 = {
	.name = "rsa_oaep_56",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_56_n,
	.nlen = sizeof(rsa_oaep_56_n),
	.d = (const u8*)&rsa_oaep_56_d,
	.dlen = sizeof(rsa_oaep_56_d),
	.e = (const u8*)&rsa_oaep_56_e,
	.elen = sizeof(rsa_oaep_56_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_56_m,
	.mlen = sizeof(rsa_oaep_56_m),
	.res = (const u8*)&rsa_oaep_56_res,
	.reslen = sizeof(rsa_oaep_56_res),
	.salt = (const u8*)&rsa_oaep_56_salt,
	.saltlen = sizeof(rsa_oaep_56_salt),
};
static const u8 rsa_oaep_57_CRT_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_57_CRT_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_57_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_57_CRT_m[] = {
0x21, 0x02, 0x6e, 0x68, 0x00, 0xc7, 0xfa, 0x72, 0x8f, 0xca, 0xab, 0xa0, 0xd1, 0x96, 0xae, 0x28, 0xd7, 0xa2, 0xac, 0x4f, 0xfd, 0x8a, 0xbc, 0xe7, 0x94, 0xf0, 0x98, 0x5f, 0x60, 0xc8, 0xa6, 0x73, 0x72, 0x77, 0x36, 0x5d, 0x3f, 0xea, 0x11, 0xdb, 0x89, 0x23, 0xa2, 0x02, 0x9a, 
};
static const u8 rsa_oaep_57_CRT_res[] = {
0x07, 0xb6, 0x0e, 0x14, 0xec, 0x95, 0x4b, 0xfd, 0x29, 0xe6, 0x0d, 0x00, 0x47, 0xe7, 0x89, 0xf5, 0x1d, 0x57, 0x18, 0x6c, 0x63, 0x58, 0x99, 0x03, 0x30, 0x67, 0x93, 0xce, 0xd3, 0xf6, 0x82, 0x41, 0xc7, 0x43, 0x52, 0x9a, 0xba, 0x6a, 0x63, 0x74, 0xf9, 0x2e, 0x19, 0xe0, 0x16, 0x3e, 0xfa, 0x33, 0x69, 0x7e, 0x19, 0x6f, 0x76, 0x61, 0xdf, 0xaa, 0xa4, 0x7a, 0xac, 0x6b, 0xde, 0x5e, 0x51, 0xde, 0xb5, 0x07, 0xc7, 0x2c, 0x58, 0x9a, 0x2c, 0xa1, 0x69, 0x3d, 0x96, 0xb1, 0x46, 0x03, 0x81, 0x24, 0x9b, 0x2c, 0xdb, 0x9e, 0xac, 0x44, 0x76, 0x9f, 0x24, 0x89, 0xc5, 0xd3, 0xd2, 0xf9, 0x9f, 0x0e, 0xe3, 0xc7, 0xee, 0x5b, 0xf6, 0x4a, 0x5a, 0xc7, 0x9c, 0x42, 0xbd, 0x43, 0x3f, 0x14, 0x9b, 0xe8, 0xcb, 0x59, 0x54, 0x83, 0x61, 0x64, 0x05, 0x95, 0x51, 0x3c, 0x97, 0xaf, 0x7b, 0xc2, 0x50, 0x97, 0x23, 
};
static const u8 rsa_oaep_57_CRT_salt[] = {
0xf0, 0x28, 0x74, 0x13, 0x23, 0x4c, 0xc5, 0x03, 0x47, 0x24, 0xa0, 0x94, 0xc4, 0x58, 0x6b, 0x87, 0xaf, 0xf1, 0x33, 0xfc, 
};
static const u8 rsa_oaep_57_CRT_p[] = {
0x03, 0xb0, 0xd3, 0x96, 0x2f, 0x6d, 0x17, 0x54, 0x9c, 0xbf, 0xca, 0x11, 0x29, 0x43, 0x48, 0xdc, 0xf0, 0xe7, 0xe3, 0x9f, 0x8c, 0x2b, 0xc6, 0x82, 0x4f, 0x21, 0x64, 0xb6, 0x06, 0xd6, 0x87, 0x86, 0x0d, 0xae, 0x1e, 0x63, 0x23, 0x93, 0xcf, 0xed, 0xf5, 0x13, 0x22, 0x82, 0x29, 0x06, 0x9e, 0x2f, 0x60, 0xe4, 0xac, 0xd7, 0xe6, 0x33, 0xa4, 0x36, 0x06, 0x3f, 0x82, 0x38, 0x5f, 0x48, 0x99, 0x37, 0x07, 
};
static const u8 rsa_oaep_57_CRT_q[] = {
0x02, 0xe4, 0xc3, 0x2e, 0x2f, 0x51, 0x72, 0x69, 0xb7, 0x07, 0x23, 0x09, 0xf0, 0x0c, 0x0e, 0x31, 0x36, 0x5f, 0x7c, 0xe2, 0x8b, 0x23, 0x6b, 0x82, 0x91, 0x2d, 0xf2, 0x39, 0xab, 0xf3, 0x95, 0x72, 0xcf, 0x0e, 0xd6, 0x04, 0xb0, 0x29, 0x82, 0xe5, 0x35, 0x64, 0xc5, 0x2d, 0x6a, 0x05, 0x39, 0x7d, 0xe5, 0xc0, 0x52, 0xa2, 0xfd, 0xdc, 0x14, 0x1e, 0xf7, 0x18, 0x98, 0x36, 0x34, 0x6a, 0xeb, 0x33, 0x1f, 
};
static const u8 rsa_oaep_57_CRT_dP[] = {
0x01, 0xe8, 0x4b, 0x11, 0x9d, 0x25, 0x16, 0x1f, 0xa6, 0x7b, 0x00, 0x25, 0x6a, 0x5b, 0xd9, 0xb6, 0x45, 0xd2, 0xb2, 0x32, 0xec, 0xb0, 0x5b, 0x01, 0x51, 0x80, 0x02, 0x9a, 0x88, 0x62, 0x2a, 0xdc, 0x3f, 0x09, 0xb3, 0xae, 0xac, 0xde, 0x61, 0x61, 0xab, 0x7c, 0xde, 0x22, 0xc2, 0xad, 0x26, 0xe7, 0x79, 0x7d, 0xf5, 0x4e, 0x07, 0x2c, 0xbd, 0x3b, 0x26, 0x73, 0x80, 0x0b, 0x3e, 0x43, 0x38, 0xdb, 0xd5, 
};
static const u8 rsa_oaep_57_CRT_dQ[] = {
0xeb, 0x90, 0xaa, 0x1a, 0x40, 0x13, 0x5b, 0x4c, 0xea, 0x07, 0x19, 0x7c, 0xed, 0xc8, 0x81, 0x9b, 0xe1, 0xe7, 0xcb, 0xff, 0x25, 0x47, 0x66, 0x21, 0x16, 0xf4, 0x65, 0xa4, 0xa9, 0xf4, 0x87, 0xab, 0x12, 0xf3, 0xba, 0x4f, 0xef, 0x13, 0x82, 0x22, 0x65, 0xa6, 0x52, 0x97, 0xd9, 0x8b, 0x7b, 0xde, 0xd9, 0x37, 0x2e, 0x3f, 0xfe, 0x81, 0xa3, 0x8b, 0x3e, 0x96, 0x00, 0xfe, 0xd0, 0x55, 0x75, 0x4f, 
};
static const u8 rsa_oaep_57_CRT_qInv[] = {
0x01, 0x2f, 0x7f, 0x81, 0x38, 0xf9, 0x40, 0x40, 0x62, 0xeb, 0x85, 0xa4, 0x29, 0x24, 0x52, 0x0b, 0x38, 0xf5, 0xbb, 0x88, 0x6a, 0x01, 0x96, 0xf4, 0x8b, 0xb8, 0xdc, 0xea, 0x60, 0xfd, 0x92, 0xcc, 0x02, 0x7f, 0x18, 0xe7, 0x81, 0x58, 0xa3, 0x4a, 0x5c, 0x5d, 0x5f, 0x86, 0x0a, 0x0f, 0x6c, 0x04, 0x07, 0x1a, 0x7d, 0x01, 0x31, 0x2c, 0x06, 0x50, 0x62, 0xf1, 0xeb, 0x48, 0xb7, 0x9d, 0x1c, 0x83, 0xcb, 
};


static const rsa_test test_rsa_oaep_57_CRT = {
	.name = "rsa_oaep_57_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_57_CRT_n,
	.nlen = sizeof(rsa_oaep_57_CRT_n),
	.d = (const u8*)&rsa_oaep_57_CRT_d,
	.dlen = sizeof(rsa_oaep_57_CRT_d),
	.e = (const u8*)&rsa_oaep_57_CRT_e,
	.elen = sizeof(rsa_oaep_57_CRT_e),
	.p = (const u8*)&rsa_oaep_57_CRT_p,
	.plen = sizeof(rsa_oaep_57_CRT_p),
	.q = (const u8*)&rsa_oaep_57_CRT_q,
	.qlen = sizeof(rsa_oaep_57_CRT_q),
	.dP = (const u8*)&rsa_oaep_57_CRT_dP,
	.dPlen = sizeof(rsa_oaep_57_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_57_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_57_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_57_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_57_CRT_qInv),
	.m = (const u8*)&rsa_oaep_57_CRT_m,
	.mlen = sizeof(rsa_oaep_57_CRT_m),
	.res = (const u8*)&rsa_oaep_57_CRT_res,
	.reslen = sizeof(rsa_oaep_57_CRT_res),
	.salt = (const u8*)&rsa_oaep_57_CRT_salt,
	.saltlen = sizeof(rsa_oaep_57_CRT_salt),
};
static const u8 rsa_oaep_58_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_58_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_58_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_58_m[] = {
0x54, 0x1e, 0x37, 0xb6, 0x8b, 0x6c, 0x88, 0x72, 0xb8, 0x4c, 0x02, 
};
static const u8 rsa_oaep_58_res[] = {
0x08, 0xc3, 0x6d, 0x4d, 0xda, 0x33, 0x42, 0x3b, 0x2e, 0xd6, 0x83, 0x0d, 0x85, 0xf6, 0x41, 0x1b, 0xa1, 0xdc, 0xf4, 0x70, 0xa1, 0xfa, 0xe0, 0xeb, 0xef, 0xee, 0x7c, 0x08, 0x9f, 0x25, 0x6c, 0xef, 0x74, 0xcb, 0x96, 0xea, 0x69, 0xc3, 0x8f, 0x60, 0xf3, 0x9a, 0xbe, 0xe4, 0x41, 0x29, 0xbc, 0xb4, 0xc9, 0x2d, 0xe7, 0xf7, 0x97, 0x62, 0x3b, 0x20, 0x07, 0x4e, 0x3d, 0x9c, 0x28, 0x99, 0x70, 0x1e, 0xd9, 0x07, 0x1e, 0x1e, 0xfa, 0x0b, 0xdd, 0x84, 0xd4, 0xc3, 0xe5, 0x13, 0x03, 0x02, 0xd8, 0xf0, 0x24, 0x0b, 0xab, 0xa4, 0xb8, 0x4a, 0x71, 0xcc, 0x03, 0x2f, 0x22, 0x35, 0xa5, 0xff, 0x0f, 0xae, 0x27, 0x7c, 0x3e, 0x8f, 0x91, 0x12, 0xbe, 0xf4, 0x4c, 0x9a, 0xe2, 0x0d, 0x17, 0x5f, 0xc9, 0xa4, 0x05, 0x8b, 0xfc, 0x93, 0x0b, 0xa3, 0x1b, 0x02, 0xe2, 0xe4, 0xf4, 0x44, 0x48, 0x37, 0x10, 0xf2, 0x4a, 
};
static const u8 rsa_oaep_58_salt[] = {
0xd9, 0xfb, 0xa4, 0x5c, 0x96, 0xf2, 0x1e, 0x6e, 0x26, 0xd2, 0x9e, 0xb2, 0xcd, 0xcb, 0x65, 0x85, 0xbe, 0x9c, 0xb3, 0x41, 
};


static const rsa_test test_rsa_oaep_58 = {
	.name = "rsa_oaep_58",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_58_n,
	.nlen = sizeof(rsa_oaep_58_n),
	.d = (const u8*)&rsa_oaep_58_d,
	.dlen = sizeof(rsa_oaep_58_d),
	.e = (const u8*)&rsa_oaep_58_e,
	.elen = sizeof(rsa_oaep_58_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_58_m,
	.mlen = sizeof(rsa_oaep_58_m),
	.res = (const u8*)&rsa_oaep_58_res,
	.reslen = sizeof(rsa_oaep_58_res),
	.salt = (const u8*)&rsa_oaep_58_salt,
	.saltlen = sizeof(rsa_oaep_58_salt),
};
static const u8 rsa_oaep_59_CRT_n[] = {
0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9, 
};
static const u8 rsa_oaep_59_CRT_d[] = {
0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5, 
};
static const u8 rsa_oaep_59_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_59_CRT_m[] = {
0x54, 0x1e, 0x37, 0xb6, 0x8b, 0x6c, 0x88, 0x72, 0xb8, 0x4c, 0x02, 
};
static const u8 rsa_oaep_59_CRT_res[] = {
0x08, 0xc3, 0x6d, 0x4d, 0xda, 0x33, 0x42, 0x3b, 0x2e, 0xd6, 0x83, 0x0d, 0x85, 0xf6, 0x41, 0x1b, 0xa1, 0xdc, 0xf4, 0x70, 0xa1, 0xfa, 0xe0, 0xeb, 0xef, 0xee, 0x7c, 0x08, 0x9f, 0x25, 0x6c, 0xef, 0x74, 0xcb, 0x96, 0xea, 0x69, 0xc3, 0x8f, 0x60, 0xf3, 0x9a, 0xbe, 0xe4, 0x41, 0x29, 0xbc, 0xb4, 0xc9, 0x2d, 0xe7, 0xf7, 0x97, 0x62, 0x3b, 0x20, 0x07, 0x4e, 0x3d, 0x9c, 0x28, 0x99, 0x70, 0x1e, 0xd9, 0x07, 0x1e, 0x1e, 0xfa, 0x0b, 0xdd, 0x84, 0xd4, 0xc3, 0xe5, 0x13, 0x03, 0x02, 0xd8, 0xf0, 0x24, 0x0b, 0xab, 0xa4, 0xb8, 0x4a, 0x71, 0xcc, 0x03, 0x2f, 0x22, 0x35, 0xa5, 0xff, 0x0f, 0xae, 0x27, 0x7c, 0x3e, 0x8f, 0x91, 0x12, 0xbe, 0xf4, 0x4c, 0x9a, 0xe2, 0x0d, 0x17, 0x5f, 0xc9, 0xa4, 0x05, 0x8b, 0xfc, 0x93, 0x0b, 0xa3, 0x1b, 0x02, 0xe2, 0xe4, 0xf4, 0x44, 0x48, 0x37, 0x10, 0xf2, 0x4a, 
};
static const u8 rsa_oaep_59_CRT_salt[] = {
0xd9, 0xfb, 0xa4, 0x5c, 0x96, 0xf2, 0x1e, 0x6e, 0x26, 0xd2, 0x9e, 0xb2, 0xcd, 0xcb, 0x65, 0x85, 0xbe, 0x9c, 0xb3, 0x41, 
};
static const u8 rsa_oaep_59_CRT_p[] = {
0x03, 0xb0, 0xd3, 0x96, 0x2f, 0x6d, 0x17, 0x54, 0x9c, 0xbf, 0xca, 0x11, 0x29, 0x43, 0x48, 0xdc, 0xf0, 0xe7, 0xe3, 0x9f, 0x8c, 0x2b, 0xc6, 0x82, 0x4f, 0x21, 0x64, 0xb6, 0x06, 0xd6, 0x87, 0x86, 0x0d, 0xae, 0x1e, 0x63, 0x23, 0x93, 0xcf, 0xed, 0xf5, 0x13, 0x22, 0x82, 0x29, 0x06, 0x9e, 0x2f, 0x60, 0xe4, 0xac, 0xd7, 0xe6, 0x33, 0xa4, 0x36, 0x06, 0x3f, 0x82, 0x38, 0x5f, 0x48, 0x99, 0x37, 0x07, 
};
static const u8 rsa_oaep_59_CRT_q[] = {
0x02, 0xe4, 0xc3, 0x2e, 0x2f, 0x51, 0x72, 0x69, 0xb7, 0x07, 0x23, 0x09, 0xf0, 0x0c, 0x0e, 0x31, 0x36, 0x5f, 0x7c, 0xe2, 0x8b, 0x23, 0x6b, 0x82, 0x91, 0x2d, 0xf2, 0x39, 0xab, 0xf3, 0x95, 0x72, 0xcf, 0x0e, 0xd6, 0x04, 0xb0, 0x29, 0x82, 0xe5, 0x35, 0x64, 0xc5, 0x2d, 0x6a, 0x05, 0x39, 0x7d, 0xe5, 0xc0, 0x52, 0xa2, 0xfd, 0xdc, 0x14, 0x1e, 0xf7, 0x18, 0x98, 0x36, 0x34, 0x6a, 0xeb, 0x33, 0x1f, 
};
static const u8 rsa_oaep_59_CRT_dP[] = {
0x01, 0xe8, 0x4b, 0x11, 0x9d, 0x25, 0x16, 0x1f, 0xa6, 0x7b, 0x00, 0x25, 0x6a, 0x5b, 0xd9, 0xb6, 0x45, 0xd2, 0xb2, 0x32, 0xec, 0xb0, 0x5b, 0x01, 0x51, 0x80, 0x02, 0x9a, 0x88, 0x62, 0x2a, 0xdc, 0x3f, 0x09, 0xb3, 0xae, 0xac, 0xde, 0x61, 0x61, 0xab, 0x7c, 0xde, 0x22, 0xc2, 0xad, 0x26, 0xe7, 0x79, 0x7d, 0xf5, 0x4e, 0x07, 0x2c, 0xbd, 0x3b, 0x26, 0x73, 0x80, 0x0b, 0x3e, 0x43, 0x38, 0xdb, 0xd5, 
};
static const u8 rsa_oaep_59_CRT_dQ[] = {
0xeb, 0x90, 0xaa, 0x1a, 0x40, 0x13, 0x5b, 0x4c, 0xea, 0x07, 0x19, 0x7c, 0xed, 0xc8, 0x81, 0x9b, 0xe1, 0xe7, 0xcb, 0xff, 0x25, 0x47, 0x66, 0x21, 0x16, 0xf4, 0x65, 0xa4, 0xa9, 0xf4, 0x87, 0xab, 0x12, 0xf3, 0xba, 0x4f, 0xef, 0x13, 0x82, 0x22, 0x65, 0xa6, 0x52, 0x97, 0xd9, 0x8b, 0x7b, 0xde, 0xd9, 0x37, 0x2e, 0x3f, 0xfe, 0x81, 0xa3, 0x8b, 0x3e, 0x96, 0x00, 0xfe, 0xd0, 0x55, 0x75, 0x4f, 
};
static const u8 rsa_oaep_59_CRT_qInv[] = {
0x01, 0x2f, 0x7f, 0x81, 0x38, 0xf9, 0x40, 0x40, 0x62, 0xeb, 0x85, 0xa4, 0x29, 0x24, 0x52, 0x0b, 0x38, 0xf5, 0xbb, 0x88, 0x6a, 0x01, 0x96, 0xf4, 0x8b, 0xb8, 0xdc, 0xea, 0x60, 0xfd, 0x92, 0xcc, 0x02, 0x7f, 0x18, 0xe7, 0x81, 0x58, 0xa3, 0x4a, 0x5c, 0x5d, 0x5f, 0x86, 0x0a, 0x0f, 0x6c, 0x04, 0x07, 0x1a, 0x7d, 0x01, 0x31, 0x2c, 0x06, 0x50, 0x62, 0xf1, 0xeb, 0x48, 0xb7, 0x9d, 0x1c, 0x83, 0xcb, 
};


static const rsa_test test_rsa_oaep_59_CRT = {
	.name = "rsa_oaep_59_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_59_CRT_n,
	.nlen = sizeof(rsa_oaep_59_CRT_n),
	.d = (const u8*)&rsa_oaep_59_CRT_d,
	.dlen = sizeof(rsa_oaep_59_CRT_d),
	.e = (const u8*)&rsa_oaep_59_CRT_e,
	.elen = sizeof(rsa_oaep_59_CRT_e),
	.p = (const u8*)&rsa_oaep_59_CRT_p,
	.plen = sizeof(rsa_oaep_59_CRT_p),
	.q = (const u8*)&rsa_oaep_59_CRT_q,
	.qlen = sizeof(rsa_oaep_59_CRT_q),
	.dP = (const u8*)&rsa_oaep_59_CRT_dP,
	.dPlen = sizeof(rsa_oaep_59_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_59_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_59_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_59_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_59_CRT_qInv),
	.m = (const u8*)&rsa_oaep_59_CRT_m,
	.mlen = sizeof(rsa_oaep_59_CRT_m),
	.res = (const u8*)&rsa_oaep_59_CRT_res,
	.reslen = sizeof(rsa_oaep_59_CRT_res),
	.salt = (const u8*)&rsa_oaep_59_CRT_salt,
	.saltlen = sizeof(rsa_oaep_59_CRT_salt),
};
static const u8 rsa_oaep_60_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_60_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_60_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_60_m[] = {
0x40, 0x46, 0xca, 0x8b, 0xaa, 0x33, 0x47, 0xca, 0x27, 0xf4, 0x9e, 0x0d, 0x81, 0xf9, 0xcc, 0x1d, 0x71, 0xbe, 0x9b, 0xa5, 0x17, 0xd4, 
};
static const u8 rsa_oaep_60_res[] = {
0x06, 0x30, 0xee, 0xbc, 0xd2, 0x85, 0x6c, 0x24, 0xf7, 0x98, 0x80, 0x6e, 0x41, 0xf9, 0xe6, 0x73, 0x45, 0xed, 0xa9, 0xce, 0xda, 0x38, 0x6a, 0xcc, 0x9f, 0xac, 0xae, 0xa1, 0xee, 0xed, 0x06, 0xac, 0xe5, 0x83, 0x70, 0x97, 0x18, 0xd9, 0xd1, 0x69, 0xfa, 0xdf, 0x41, 0x4d, 0x5c, 0x76, 0xf9, 0x29, 0x96, 0x83, 0x3e, 0xf3, 0x05, 0xb7, 0x5b, 0x1e, 0x4b, 0x95, 0xf6, 0x62, 0xa2, 0x0f, 0xae, 0xdc, 0x3b, 0xae, 0x0c, 0x48, 0x27, 0xa8, 0xbf, 0x8a, 0x88, 0xed, 0xbd, 0x57, 0xec, 0x20, 0x3a, 0x27, 0xa8, 0x41, 0xf0, 0x2e, 0x43, 0xa6, 0x15, 0xba, 0xb1, 0xa8, 0xca, 0xc0, 0x70, 0x1d, 0xe3, 0x4d, 0xeb, 0xde, 0xf6, 0x2a, 0x08, 0x80, 0x89, 0xb5, 0x5e, 0xc3, 0x6e, 0xa7, 0x52, 0x2f, 0xd3, 0xec, 0x8d, 0x06, 0xb6, 0xa0, 0x73, 0xe6, 0xdf, 0x83, 0x31, 0x53, 0xbc, 0x0a, 0xef, 0xd9, 0x3b, 0xd1, 0xa3, 
};
static const u8 rsa_oaep_60_salt[] = {
0xdd, 0x0f, 0x6c, 0xfe, 0x41, 0x5e, 0x88, 0xe5, 0xa4, 0x69, 0xa5, 0x1f, 0xbb, 0xa6, 0xdf, 0xd4, 0x0a, 0xdb, 0x43, 0x84, 
};


static const rsa_test test_rsa_oaep_60 = {
	.name = "rsa_oaep_60",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_60_n,
	.nlen = sizeof(rsa_oaep_60_n),
	.d = (const u8*)&rsa_oaep_60_d,
	.dlen = sizeof(rsa_oaep_60_d),
	.e = (const u8*)&rsa_oaep_60_e,
	.elen = sizeof(rsa_oaep_60_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_60_m,
	.mlen = sizeof(rsa_oaep_60_m),
	.res = (const u8*)&rsa_oaep_60_res,
	.reslen = sizeof(rsa_oaep_60_res),
	.salt = (const u8*)&rsa_oaep_60_salt,
	.saltlen = sizeof(rsa_oaep_60_salt),
};
static const u8 rsa_oaep_61_CRT_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_61_CRT_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_61_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_61_CRT_m[] = {
0x40, 0x46, 0xca, 0x8b, 0xaa, 0x33, 0x47, 0xca, 0x27, 0xf4, 0x9e, 0x0d, 0x81, 0xf9, 0xcc, 0x1d, 0x71, 0xbe, 0x9b, 0xa5, 0x17, 0xd4, 
};
static const u8 rsa_oaep_61_CRT_res[] = {
0x06, 0x30, 0xee, 0xbc, 0xd2, 0x85, 0x6c, 0x24, 0xf7, 0x98, 0x80, 0x6e, 0x41, 0xf9, 0xe6, 0x73, 0x45, 0xed, 0xa9, 0xce, 0xda, 0x38, 0x6a, 0xcc, 0x9f, 0xac, 0xae, 0xa1, 0xee, 0xed, 0x06, 0xac, 0xe5, 0x83, 0x70, 0x97, 0x18, 0xd9, 0xd1, 0x69, 0xfa, 0xdf, 0x41, 0x4d, 0x5c, 0x76, 0xf9, 0x29, 0x96, 0x83, 0x3e, 0xf3, 0x05, 0xb7, 0x5b, 0x1e, 0x4b, 0x95, 0xf6, 0x62, 0xa2, 0x0f, 0xae, 0xdc, 0x3b, 0xae, 0x0c, 0x48, 0x27, 0xa8, 0xbf, 0x8a, 0x88, 0xed, 0xbd, 0x57, 0xec, 0x20, 0x3a, 0x27, 0xa8, 0x41, 0xf0, 0x2e, 0x43, 0xa6, 0x15, 0xba, 0xb1, 0xa8, 0xca, 0xc0, 0x70, 0x1d, 0xe3, 0x4d, 0xeb, 0xde, 0xf6, 0x2a, 0x08, 0x80, 0x89, 0xb5, 0x5e, 0xc3, 0x6e, 0xa7, 0x52, 0x2f, 0xd3, 0xec, 0x8d, 0x06, 0xb6, 0xa0, 0x73, 0xe6, 0xdf, 0x83, 0x31, 0x53, 0xbc, 0x0a, 0xef, 0xd9, 0x3b, 0xd1, 0xa3, 
};
static const u8 rsa_oaep_61_CRT_salt[] = {
0xdd, 0x0f, 0x6c, 0xfe, 0x41, 0x5e, 0x88, 0xe5, 0xa4, 0x69, 0xa5, 0x1f, 0xbb, 0xa6, 0xdf, 0xd4, 0x0a, 0xdb, 0x43, 0x84, 
};
static const u8 rsa_oaep_61_CRT_p[] = {
0x04, 0xa6, 0xce, 0x8b, 0x73, 0x58, 0xdf, 0xa6, 0x9b, 0xdc, 0xf7, 0x42, 0x61, 0x70, 0x05, 0xaf, 0xb5, 0x38, 0x5f, 0x5f, 0x3a, 0x58, 0xa2, 0x4e, 0xf7, 0x4a, 0x22, 0xa8, 0xc0, 0x5c, 0xb7, 0xcc, 0x38, 0xeb, 0xd4, 0xcc, 0x9d, 0x9a, 0x9d, 0x78, 0x9a, 0x62, 0xcd, 0x0f, 0x60, 0xf0, 0xcb, 0x94, 0x1d, 0x34, 0x23, 0xc9, 0x69, 0x2e, 0xfa, 0x4f, 0xe3, 0xad, 0xff, 0x29, 0x0c, 0x47, 0x49, 0xa3, 0x8b, 
};
static const u8 rsa_oaep_61_CRT_q[] = {
0x04, 0x04, 0xc9, 0xa8, 0x03, 0x37, 0x1f, 0xed, 0xb4, 0xc5, 0xbe, 0x39, 0xf3, 0xc0, 0x0b, 0x00, 0x9e, 0x5e, 0x08, 0xa6, 0x3b, 0xe1, 0xe4, 0x00, 0x35, 0xcd, 0xac, 0xa5, 0x01, 0x1c, 0xc7, 0x01, 0xcf, 0x7e, 0xeb, 0xcb, 0x99, 0xf0, 0xff, 0xe1, 0x7c, 0xfd, 0x0a, 0x4b, 0xf7, 0xbe, 0xfd, 0x2d, 0xd5, 0x36, 0xac, 0x94, 0x6d, 0xb7, 0x97, 0xfd, 0xbc, 0x4a, 0xbe, 0x8f, 0x29, 0x34, 0x9b, 0x91, 0xed, 
};
static const u8 rsa_oaep_61_CRT_dP[] = {
0x03, 0x96, 0x1c, 0x8f, 0x76, 0x0a, 0xa2, 0xbd, 0x51, 0x54, 0xc7, 0xaa, 0xfd, 0x77, 0x22, 0x5b, 0x3b, 0xac, 0xd0, 0x13, 0x9a, 0xe7, 0xb5, 0x94, 0x8e, 0xa3, 0x31, 0x1f, 0xcc, 0xd8, 0x6f, 0xb9, 0x5c, 0x75, 0xaf, 0xa7, 0x67, 0x28, 0x4b, 0x9b, 0x2d, 0xe5, 0x59, 0x57, 0x2f, 0x15, 0xd8, 0xd0, 0x44, 0xc7, 0xeb, 0x83, 0xa1, 0xbe, 0x5f, 0xad, 0xf2, 0xcc, 0x37, 0x7c, 0x0d, 0x84, 0x75, 0x29, 0x4b, 
};
static const u8 rsa_oaep_61_CRT_dQ[] = {
0x02, 0x21, 0x97, 0xe0, 0x66, 0x74, 0x21, 0x96, 0xaa, 0xbc, 0x03, 0xfa, 0x2f, 0xee, 0xb4, 0xe7, 0x0b, 0x15, 0xcb, 0x78, 0x7d, 0x61, 0x7a, 0xcd, 0x31, 0xbb, 0x75, 0xc7, 0xbc, 0x23, 0x4a, 0xd7, 0x06, 0xf7, 0xc4, 0x8d, 0x21, 0x82, 0xd1, 0xf0, 0xff, 0x9c, 0x22, 0x8d, 0xcf, 0x41, 0x96, 0x7b, 0x6c, 0x0b, 0xa6, 0xd2, 0xc0, 0xad, 0x11, 0x0a, 0x1b, 0x85, 0x78, 0x31, 0xec, 0x24, 0x5e, 0x2c, 0xb1, 
};
static const u8 rsa_oaep_61_CRT_qInv[] = {
0x04, 0x01, 0xc4, 0xc0, 0xc5, 0x3d, 0x45, 0xdb, 0xdb, 0x5e, 0x9d, 0x96, 0xd0, 0xfe, 0xcf, 0x42, 0x75, 0xdf, 0x09, 0x74, 0xbc, 0x4a, 0x07, 0x36, 0xb4, 0xa7, 0x4c, 0x32, 0x69, 0x05, 0x3e, 0xfb, 0x68, 0x6a, 0xce, 0x24, 0x06, 0xe2, 0x2c, 0x9e, 0x05, 0x8d, 0xdb, 0x4a, 0xe5, 0x40, 0x62, 0x7a, 0xe2, 0xfd, 0xb0, 0x82, 0x61, 0xe8, 0xe7, 0xe4, 0xbc, 0xbc, 0x99, 0x4d, 0xaa, 0xfa, 0x30, 0x5c, 0x45, 
};


static const rsa_test test_rsa_oaep_61_CRT = {
	.name = "rsa_oaep_61_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_61_CRT_n,
	.nlen = sizeof(rsa_oaep_61_CRT_n),
	.d = (const u8*)&rsa_oaep_61_CRT_d,
	.dlen = sizeof(rsa_oaep_61_CRT_d),
	.e = (const u8*)&rsa_oaep_61_CRT_e,
	.elen = sizeof(rsa_oaep_61_CRT_e),
	.p = (const u8*)&rsa_oaep_61_CRT_p,
	.plen = sizeof(rsa_oaep_61_CRT_p),
	.q = (const u8*)&rsa_oaep_61_CRT_q,
	.qlen = sizeof(rsa_oaep_61_CRT_q),
	.dP = (const u8*)&rsa_oaep_61_CRT_dP,
	.dPlen = sizeof(rsa_oaep_61_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_61_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_61_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_61_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_61_CRT_qInv),
	.m = (const u8*)&rsa_oaep_61_CRT_m,
	.mlen = sizeof(rsa_oaep_61_CRT_m),
	.res = (const u8*)&rsa_oaep_61_CRT_res,
	.reslen = sizeof(rsa_oaep_61_CRT_res),
	.salt = (const u8*)&rsa_oaep_61_CRT_salt,
	.saltlen = sizeof(rsa_oaep_61_CRT_salt),
};
static const u8 rsa_oaep_62_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_62_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_62_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_62_m[] = {
0x5c, 0xc7, 0x2c, 0x60, 0x23, 0x1d, 0xf0, 0x3b, 0x3d, 0x40, 0xf9, 0xb5, 0x79, 0x31, 0xbc, 0x31, 0x10, 0x9f, 0x97, 0x25, 0x27, 0xf2, 0x8b, 0x19, 0xe7, 0x48, 0x0c, 0x72, 0x88, 0xcb, 0x3c, 0x92, 0xb2, 0x25, 0x12, 0x21, 0x4e, 0x4b, 0xe6, 0xc9, 0x14, 0x79, 0x2d, 0xda, 0xbd, 0xf5, 0x7f, 0xaa, 0x8a, 0xa7, 
};
static const u8 rsa_oaep_62_res[] = {
0x0e, 0xbc, 0x37, 0x37, 0x61, 0x73, 0xa4, 0xfd, 0x2f, 0x89, 0xcc, 0x55, 0xc2, 0xca, 0x62, 0xb2, 0x6b, 0x11, 0xd5, 0x1c, 0x3c, 0x7c, 0xe4, 0x9e, 0x88, 0x45, 0xf7, 0x4e, 0x76, 0x07, 0x31, 0x7c, 0x43, 0x6b, 0xc8, 0xd2, 0x3b, 0x96, 0x67, 0xdf, 0xeb, 0x9d, 0x08, 0x72, 0x34, 0xb4, 0x7b, 0xc6, 0x83, 0x71, 0x75, 0xae, 0x5c, 0x05, 0x59, 0xf6, 0xb8, 0x1d, 0x7d, 0x22, 0x41, 0x6d, 0x3e, 0x50, 0xf4, 0xac, 0x53, 0x3d, 0x8f, 0x08, 0x12, 0xf2, 0xdb, 0x9e, 0x79, 0x1f, 0xe9, 0xc7, 0x75, 0xac, 0x8b, 0x6a, 0xd0, 0xf5, 0x35, 0xad, 0x9c, 0xeb, 0x23, 0xa4, 0xa0, 0x20, 0x14, 0xc5, 0x8a, 0xb3, 0xf8, 0xd3, 0x16, 0x14, 0x99, 0xa2, 0x60, 0xf3, 0x93, 0x48, 0xe7, 0x14, 0xae, 0x2a, 0x1d, 0x34, 0x43, 0x20, 0x8f, 0xd8, 0xb7, 0x22, 0xcc, 0xfd, 0xfb, 0x39, 0x3e, 0x98, 0x01, 0x1f, 0x99, 0xe6, 0x3f, 
};
static const u8 rsa_oaep_62_salt[] = {
0x8d, 0x14, 0xbd, 0x94, 0x6a, 0x13, 0x51, 0x14, 0x8f, 0x5c, 0xae, 0x2e, 0xd9, 0xa0, 0xc6, 0x53, 0xe8, 0x5e, 0xbd, 0x85, 
};


static const rsa_test test_rsa_oaep_62 = {
	.name = "rsa_oaep_62",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_62_n,
	.nlen = sizeof(rsa_oaep_62_n),
	.d = (const u8*)&rsa_oaep_62_d,
	.dlen = sizeof(rsa_oaep_62_d),
	.e = (const u8*)&rsa_oaep_62_e,
	.elen = sizeof(rsa_oaep_62_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_62_m,
	.mlen = sizeof(rsa_oaep_62_m),
	.res = (const u8*)&rsa_oaep_62_res,
	.reslen = sizeof(rsa_oaep_62_res),
	.salt = (const u8*)&rsa_oaep_62_salt,
	.saltlen = sizeof(rsa_oaep_62_salt),
};
static const u8 rsa_oaep_63_CRT_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_63_CRT_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_63_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_63_CRT_m[] = {
0x5c, 0xc7, 0x2c, 0x60, 0x23, 0x1d, 0xf0, 0x3b, 0x3d, 0x40, 0xf9, 0xb5, 0x79, 0x31, 0xbc, 0x31, 0x10, 0x9f, 0x97, 0x25, 0x27, 0xf2, 0x8b, 0x19, 0xe7, 0x48, 0x0c, 0x72, 0x88, 0xcb, 0x3c, 0x92, 0xb2, 0x25, 0x12, 0x21, 0x4e, 0x4b, 0xe6, 0xc9, 0x14, 0x79, 0x2d, 0xda, 0xbd, 0xf5, 0x7f, 0xaa, 0x8a, 0xa7, 
};
static const u8 rsa_oaep_63_CRT_res[] = {
0x0e, 0xbc, 0x37, 0x37, 0x61, 0x73, 0xa4, 0xfd, 0x2f, 0x89, 0xcc, 0x55, 0xc2, 0xca, 0x62, 0xb2, 0x6b, 0x11, 0xd5, 0x1c, 0x3c, 0x7c, 0xe4, 0x9e, 0x88, 0x45, 0xf7, 0x4e, 0x76, 0x07, 0x31, 0x7c, 0x43, 0x6b, 0xc8, 0xd2, 0x3b, 0x96, 0x67, 0xdf, 0xeb, 0x9d, 0x08, 0x72, 0x34, 0xb4, 0x7b, 0xc6, 0x83, 0x71, 0x75, 0xae, 0x5c, 0x05, 0x59, 0xf6, 0xb8, 0x1d, 0x7d, 0x22, 0x41, 0x6d, 0x3e, 0x50, 0xf4, 0xac, 0x53, 0x3d, 0x8f, 0x08, 0x12, 0xf2, 0xdb, 0x9e, 0x79, 0x1f, 0xe9, 0xc7, 0x75, 0xac, 0x8b, 0x6a, 0xd0, 0xf5, 0x35, 0xad, 0x9c, 0xeb, 0x23, 0xa4, 0xa0, 0x20, 0x14, 0xc5, 0x8a, 0xb3, 0xf8, 0xd3, 0x16, 0x14, 0x99, 0xa2, 0x60, 0xf3, 0x93, 0x48, 0xe7, 0x14, 0xae, 0x2a, 0x1d, 0x34, 0x43, 0x20, 0x8f, 0xd8, 0xb7, 0x22, 0xcc, 0xfd, 0xfb, 0x39, 0x3e, 0x98, 0x01, 0x1f, 0x99, 0xe6, 0x3f, 
};
static const u8 rsa_oaep_63_CRT_salt[] = {
0x8d, 0x14, 0xbd, 0x94, 0x6a, 0x13, 0x51, 0x14, 0x8f, 0x5c, 0xae, 0x2e, 0xd9, 0xa0, 0xc6, 0x53, 0xe8, 0x5e, 0xbd, 0x85, 
};
static const u8 rsa_oaep_63_CRT_p[] = {
0x04, 0xa6, 0xce, 0x8b, 0x73, 0x58, 0xdf, 0xa6, 0x9b, 0xdc, 0xf7, 0x42, 0x61, 0x70, 0x05, 0xaf, 0xb5, 0x38, 0x5f, 0x5f, 0x3a, 0x58, 0xa2, 0x4e, 0xf7, 0x4a, 0x22, 0xa8, 0xc0, 0x5c, 0xb7, 0xcc, 0x38, 0xeb, 0xd4, 0xcc, 0x9d, 0x9a, 0x9d, 0x78, 0x9a, 0x62, 0xcd, 0x0f, 0x60, 0xf0, 0xcb, 0x94, 0x1d, 0x34, 0x23, 0xc9, 0x69, 0x2e, 0xfa, 0x4f, 0xe3, 0xad, 0xff, 0x29, 0x0c, 0x47, 0x49, 0xa3, 0x8b, 
};
static const u8 rsa_oaep_63_CRT_q[] = {
0x04, 0x04, 0xc9, 0xa8, 0x03, 0x37, 0x1f, 0xed, 0xb4, 0xc5, 0xbe, 0x39, 0xf3, 0xc0, 0x0b, 0x00, 0x9e, 0x5e, 0x08, 0xa6, 0x3b, 0xe1, 0xe4, 0x00, 0x35, 0xcd, 0xac, 0xa5, 0x01, 0x1c, 0xc7, 0x01, 0xcf, 0x7e, 0xeb, 0xcb, 0x99, 0xf0, 0xff, 0xe1, 0x7c, 0xfd, 0x0a, 0x4b, 0xf7, 0xbe, 0xfd, 0x2d, 0xd5, 0x36, 0xac, 0x94, 0x6d, 0xb7, 0x97, 0xfd, 0xbc, 0x4a, 0xbe, 0x8f, 0x29, 0x34, 0x9b, 0x91, 0xed, 
};
static const u8 rsa_oaep_63_CRT_dP[] = {
0x03, 0x96, 0x1c, 0x8f, 0x76, 0x0a, 0xa2, 0xbd, 0x51, 0x54, 0xc7, 0xaa, 0xfd, 0x77, 0x22, 0x5b, 0x3b, 0xac, 0xd0, 0x13, 0x9a, 0xe7, 0xb5, 0x94, 0x8e, 0xa3, 0x31, 0x1f, 0xcc, 0xd8, 0x6f, 0xb9, 0x5c, 0x75, 0xaf, 0xa7, 0x67, 0x28, 0x4b, 0x9b, 0x2d, 0xe5, 0x59, 0x57, 0x2f, 0x15, 0xd8, 0xd0, 0x44, 0xc7, 0xeb, 0x83, 0xa1, 0xbe, 0x5f, 0xad, 0xf2, 0xcc, 0x37, 0x7c, 0x0d, 0x84, 0x75, 0x29, 0x4b, 
};
static const u8 rsa_oaep_63_CRT_dQ[] = {
0x02, 0x21, 0x97, 0xe0, 0x66, 0x74, 0x21, 0x96, 0xaa, 0xbc, 0x03, 0xfa, 0x2f, 0xee, 0xb4, 0xe7, 0x0b, 0x15, 0xcb, 0x78, 0x7d, 0x61, 0x7a, 0xcd, 0x31, 0xbb, 0x75, 0xc7, 0xbc, 0x23, 0x4a, 0xd7, 0x06, 0xf7, 0xc4, 0x8d, 0x21, 0x82, 0xd1, 0xf0, 0xff, 0x9c, 0x22, 0x8d, 0xcf, 0x41, 0x96, 0x7b, 0x6c, 0x0b, 0xa6, 0xd2, 0xc0, 0xad, 0x11, 0x0a, 0x1b, 0x85, 0x78, 0x31, 0xec, 0x24, 0x5e, 0x2c, 0xb1, 
};
static const u8 rsa_oaep_63_CRT_qInv[] = {
0x04, 0x01, 0xc4, 0xc0, 0xc5, 0x3d, 0x45, 0xdb, 0xdb, 0x5e, 0x9d, 0x96, 0xd0, 0xfe, 0xcf, 0x42, 0x75, 0xdf, 0x09, 0x74, 0xbc, 0x4a, 0x07, 0x36, 0xb4, 0xa7, 0x4c, 0x32, 0x69, 0x05, 0x3e, 0xfb, 0x68, 0x6a, 0xce, 0x24, 0x06, 0xe2, 0x2c, 0x9e, 0x05, 0x8d, 0xdb, 0x4a, 0xe5, 0x40, 0x62, 0x7a, 0xe2, 0xfd, 0xb0, 0x82, 0x61, 0xe8, 0xe7, 0xe4, 0xbc, 0xbc, 0x99, 0x4d, 0xaa, 0xfa, 0x30, 0x5c, 0x45, 
};


static const rsa_test test_rsa_oaep_63_CRT = {
	.name = "rsa_oaep_63_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_63_CRT_n,
	.nlen = sizeof(rsa_oaep_63_CRT_n),
	.d = (const u8*)&rsa_oaep_63_CRT_d,
	.dlen = sizeof(rsa_oaep_63_CRT_d),
	.e = (const u8*)&rsa_oaep_63_CRT_e,
	.elen = sizeof(rsa_oaep_63_CRT_e),
	.p = (const u8*)&rsa_oaep_63_CRT_p,
	.plen = sizeof(rsa_oaep_63_CRT_p),
	.q = (const u8*)&rsa_oaep_63_CRT_q,
	.qlen = sizeof(rsa_oaep_63_CRT_q),
	.dP = (const u8*)&rsa_oaep_63_CRT_dP,
	.dPlen = sizeof(rsa_oaep_63_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_63_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_63_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_63_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_63_CRT_qInv),
	.m = (const u8*)&rsa_oaep_63_CRT_m,
	.mlen = sizeof(rsa_oaep_63_CRT_m),
	.res = (const u8*)&rsa_oaep_63_CRT_res,
	.reslen = sizeof(rsa_oaep_63_CRT_res),
	.salt = (const u8*)&rsa_oaep_63_CRT_salt,
	.saltlen = sizeof(rsa_oaep_63_CRT_salt),
};
static const u8 rsa_oaep_64_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_64_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_64_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_64_m[] = {
0xb2, 0x0e, 0x65, 0x13, 0x03, 0x09, 0x2f, 0x4b, 0xcc, 0xb4, 0x30, 0x70, 0xc0, 0xf8, 0x6d, 0x23, 0x04, 0x93, 0x62, 0xed, 0x96, 0x64, 0x2f, 0xc5, 0x63, 0x2c, 0x27, 0xdb, 0x4a, 0x52, 0xe3, 0xd8, 0x31, 0xf2, 0xab, 0x06, 0x8b, 0x23, 0xb1, 0x49, 0x87, 0x9c, 0x00, 0x2f, 0x6b, 0xf3, 0xfe, 0xee, 0x97, 0x59, 0x11, 0x12, 0x56, 0x2c, 
};
static const u8 rsa_oaep_64_res[] = {
0x0a, 0x98, 0xbf, 0x10, 0x93, 0x61, 0x93, 0x94, 0x43, 0x6c, 0xf6, 0x8d, 0x8f, 0x38, 0xe2, 0xf1, 0x58, 0xfd, 0xe8, 0xea, 0x54, 0xf3, 0x43, 0x5f, 0x23, 0x9b, 0x8d, 0x06, 0xb8, 0x32, 0x18, 0x44, 0x20, 0x24, 0x76, 0xae, 0xed, 0x96, 0x00, 0x94, 0x92, 0x48, 0x0c, 0xe3, 0xa8, 0xd7, 0x05, 0x49, 0x8c, 0x4c, 0x8c, 0x68, 0xf0, 0x15, 0x01, 0xdc, 0x81, 0xdb, 0x60, 0x8f, 0x60, 0x08, 0x73, 0x50, 0xc8, 0xc3, 0xb0, 0xbd, 0x2e, 0x9e, 0xf6, 0xa8, 0x14, 0x58, 0xb7, 0xc8, 0x01, 0xb8, 0x9f, 0x2e, 0x4f, 0xe9, 0x9d, 0x49, 0x00, 0xba, 0x6a, 0x4b, 0x5e, 0x5a, 0x96, 0xd8, 0x65, 0xdc, 0x67, 0x6c, 0x77, 0x55, 0x92, 0x87, 0x94, 0x13, 0x0d, 0x62, 0x80, 0xa8, 0x16, 0x0a, 0x19, 0x0f, 0x2d, 0xf3, 0xea, 0x7c, 0xf9, 0xaa, 0x02, 0x71, 0xd8, 0x8e, 0x9e, 0x69, 0x05, 0xec, 0xf1, 0xc5, 0x15, 0x2d, 0x65, 
};
static const u8 rsa_oaep_64_salt[] = {
0x6c, 0x07, 0x5b, 0xc4, 0x55, 0x20, 0xf1, 0x65, 0xc0, 0xbf, 0x5e, 0xa4, 0xc5, 0xdf, 0x19, 0x1b, 0xc9, 0xef, 0x0e, 0x44, 
};


static const rsa_test test_rsa_oaep_64 = {
	.name = "rsa_oaep_64",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_64_n,
	.nlen = sizeof(rsa_oaep_64_n),
	.d = (const u8*)&rsa_oaep_64_d,
	.dlen = sizeof(rsa_oaep_64_d),
	.e = (const u8*)&rsa_oaep_64_e,
	.elen = sizeof(rsa_oaep_64_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_64_m,
	.mlen = sizeof(rsa_oaep_64_m),
	.res = (const u8*)&rsa_oaep_64_res,
	.reslen = sizeof(rsa_oaep_64_res),
	.salt = (const u8*)&rsa_oaep_64_salt,
	.saltlen = sizeof(rsa_oaep_64_salt),
};
static const u8 rsa_oaep_65_CRT_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_65_CRT_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_65_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_65_CRT_m[] = {
0xb2, 0x0e, 0x65, 0x13, 0x03, 0x09, 0x2f, 0x4b, 0xcc, 0xb4, 0x30, 0x70, 0xc0, 0xf8, 0x6d, 0x23, 0x04, 0x93, 0x62, 0xed, 0x96, 0x64, 0x2f, 0xc5, 0x63, 0x2c, 0x27, 0xdb, 0x4a, 0x52, 0xe3, 0xd8, 0x31, 0xf2, 0xab, 0x06, 0x8b, 0x23, 0xb1, 0x49, 0x87, 0x9c, 0x00, 0x2f, 0x6b, 0xf3, 0xfe, 0xee, 0x97, 0x59, 0x11, 0x12, 0x56, 0x2c, 
};
static const u8 rsa_oaep_65_CRT_res[] = {
0x0a, 0x98, 0xbf, 0x10, 0x93, 0x61, 0x93, 0x94, 0x43, 0x6c, 0xf6, 0x8d, 0x8f, 0x38, 0xe2, 0xf1, 0x58, 0xfd, 0xe8, 0xea, 0x54, 0xf3, 0x43, 0x5f, 0x23, 0x9b, 0x8d, 0x06, 0xb8, 0x32, 0x18, 0x44, 0x20, 0x24, 0x76, 0xae, 0xed, 0x96, 0x00, 0x94, 0x92, 0x48, 0x0c, 0xe3, 0xa8, 0xd7, 0x05, 0x49, 0x8c, 0x4c, 0x8c, 0x68, 0xf0, 0x15, 0x01, 0xdc, 0x81, 0xdb, 0x60, 0x8f, 0x60, 0x08, 0x73, 0x50, 0xc8, 0xc3, 0xb0, 0xbd, 0x2e, 0x9e, 0xf6, 0xa8, 0x14, 0x58, 0xb7, 0xc8, 0x01, 0xb8, 0x9f, 0x2e, 0x4f, 0xe9, 0x9d, 0x49, 0x00, 0xba, 0x6a, 0x4b, 0x5e, 0x5a, 0x96, 0xd8, 0x65, 0xdc, 0x67, 0x6c, 0x77, 0x55, 0x92, 0x87, 0x94, 0x13, 0x0d, 0x62, 0x80, 0xa8, 0x16, 0x0a, 0x19, 0x0f, 0x2d, 0xf3, 0xea, 0x7c, 0xf9, 0xaa, 0x02, 0x71, 0xd8, 0x8e, 0x9e, 0x69, 0x05, 0xec, 0xf1, 0xc5, 0x15, 0x2d, 0x65, 
};
static const u8 rsa_oaep_65_CRT_salt[] = {
0x6c, 0x07, 0x5b, 0xc4, 0x55, 0x20, 0xf1, 0x65, 0xc0, 0xbf, 0x5e, 0xa4, 0xc5, 0xdf, 0x19, 0x1b, 0xc9, 0xef, 0x0e, 0x44, 
};
static const u8 rsa_oaep_65_CRT_p[] = {
0x04, 0xa6, 0xce, 0x8b, 0x73, 0x58, 0xdf, 0xa6, 0x9b, 0xdc, 0xf7, 0x42, 0x61, 0x70, 0x05, 0xaf, 0xb5, 0x38, 0x5f, 0x5f, 0x3a, 0x58, 0xa2, 0x4e, 0xf7, 0x4a, 0x22, 0xa8, 0xc0, 0x5c, 0xb7, 0xcc, 0x38, 0xeb, 0xd4, 0xcc, 0x9d, 0x9a, 0x9d, 0x78, 0x9a, 0x62, 0xcd, 0x0f, 0x60, 0xf0, 0xcb, 0x94, 0x1d, 0x34, 0x23, 0xc9, 0x69, 0x2e, 0xfa, 0x4f, 0xe3, 0xad, 0xff, 0x29, 0x0c, 0x47, 0x49, 0xa3, 0x8b, 
};
static const u8 rsa_oaep_65_CRT_q[] = {
0x04, 0x04, 0xc9, 0xa8, 0x03, 0x37, 0x1f, 0xed, 0xb4, 0xc5, 0xbe, 0x39, 0xf3, 0xc0, 0x0b, 0x00, 0x9e, 0x5e, 0x08, 0xa6, 0x3b, 0xe1, 0xe4, 0x00, 0x35, 0xcd, 0xac, 0xa5, 0x01, 0x1c, 0xc7, 0x01, 0xcf, 0x7e, 0xeb, 0xcb, 0x99, 0xf0, 0xff, 0xe1, 0x7c, 0xfd, 0x0a, 0x4b, 0xf7, 0xbe, 0xfd, 0x2d, 0xd5, 0x36, 0xac, 0x94, 0x6d, 0xb7, 0x97, 0xfd, 0xbc, 0x4a, 0xbe, 0x8f, 0x29, 0x34, 0x9b, 0x91, 0xed, 
};
static const u8 rsa_oaep_65_CRT_dP[] = {
0x03, 0x96, 0x1c, 0x8f, 0x76, 0x0a, 0xa2, 0xbd, 0x51, 0x54, 0xc7, 0xaa, 0xfd, 0x77, 0x22, 0x5b, 0x3b, 0xac, 0xd0, 0x13, 0x9a, 0xe7, 0xb5, 0x94, 0x8e, 0xa3, 0x31, 0x1f, 0xcc, 0xd8, 0x6f, 0xb9, 0x5c, 0x75, 0xaf, 0xa7, 0x67, 0x28, 0x4b, 0x9b, 0x2d, 0xe5, 0x59, 0x57, 0x2f, 0x15, 0xd8, 0xd0, 0x44, 0xc7, 0xeb, 0x83, 0xa1, 0xbe, 0x5f, 0xad, 0xf2, 0xcc, 0x37, 0x7c, 0x0d, 0x84, 0x75, 0x29, 0x4b, 
};
static const u8 rsa_oaep_65_CRT_dQ[] = {
0x02, 0x21, 0x97, 0xe0, 0x66, 0x74, 0x21, 0x96, 0xaa, 0xbc, 0x03, 0xfa, 0x2f, 0xee, 0xb4, 0xe7, 0x0b, 0x15, 0xcb, 0x78, 0x7d, 0x61, 0x7a, 0xcd, 0x31, 0xbb, 0x75, 0xc7, 0xbc, 0x23, 0x4a, 0xd7, 0x06, 0xf7, 0xc4, 0x8d, 0x21, 0x82, 0xd1, 0xf0, 0xff, 0x9c, 0x22, 0x8d, 0xcf, 0x41, 0x96, 0x7b, 0x6c, 0x0b, 0xa6, 0xd2, 0xc0, 0xad, 0x11, 0x0a, 0x1b, 0x85, 0x78, 0x31, 0xec, 0x24, 0x5e, 0x2c, 0xb1, 
};
static const u8 rsa_oaep_65_CRT_qInv[] = {
0x04, 0x01, 0xc4, 0xc0, 0xc5, 0x3d, 0x45, 0xdb, 0xdb, 0x5e, 0x9d, 0x96, 0xd0, 0xfe, 0xcf, 0x42, 0x75, 0xdf, 0x09, 0x74, 0xbc, 0x4a, 0x07, 0x36, 0xb4, 0xa7, 0x4c, 0x32, 0x69, 0x05, 0x3e, 0xfb, 0x68, 0x6a, 0xce, 0x24, 0x06, 0xe2, 0x2c, 0x9e, 0x05, 0x8d, 0xdb, 0x4a, 0xe5, 0x40, 0x62, 0x7a, 0xe2, 0xfd, 0xb0, 0x82, 0x61, 0xe8, 0xe7, 0xe4, 0xbc, 0xbc, 0x99, 0x4d, 0xaa, 0xfa, 0x30, 0x5c, 0x45, 
};


static const rsa_test test_rsa_oaep_65_CRT = {
	.name = "rsa_oaep_65_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_65_CRT_n,
	.nlen = sizeof(rsa_oaep_65_CRT_n),
	.d = (const u8*)&rsa_oaep_65_CRT_d,
	.dlen = sizeof(rsa_oaep_65_CRT_d),
	.e = (const u8*)&rsa_oaep_65_CRT_e,
	.elen = sizeof(rsa_oaep_65_CRT_e),
	.p = (const u8*)&rsa_oaep_65_CRT_p,
	.plen = sizeof(rsa_oaep_65_CRT_p),
	.q = (const u8*)&rsa_oaep_65_CRT_q,
	.qlen = sizeof(rsa_oaep_65_CRT_q),
	.dP = (const u8*)&rsa_oaep_65_CRT_dP,
	.dPlen = sizeof(rsa_oaep_65_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_65_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_65_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_65_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_65_CRT_qInv),
	.m = (const u8*)&rsa_oaep_65_CRT_m,
	.mlen = sizeof(rsa_oaep_65_CRT_m),
	.res = (const u8*)&rsa_oaep_65_CRT_res,
	.reslen = sizeof(rsa_oaep_65_CRT_res),
	.salt = (const u8*)&rsa_oaep_65_CRT_salt,
	.saltlen = sizeof(rsa_oaep_65_CRT_salt),
};
static const u8 rsa_oaep_66_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_66_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_66_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_66_m[] = {
0x68, 0x4e, 0x30, 0x38, 0xc5, 0xc0, 0x41, 0xf7, 
};
static const u8 rsa_oaep_66_res[] = {
0x00, 0x8e, 0x7a, 0x67, 0xca, 0xcf, 0xb5, 0xc4, 0xe2, 0x4b, 0xec, 0x7d, 0xee, 0x14, 0x91, 0x17, 0xf1, 0x95, 0x98, 0xce, 0x8c, 0x45, 0x80, 0x8f, 0xef, 0x88, 0xc6, 0x08, 0xff, 0x9c, 0xd6, 0xe6, 0x95, 0x26, 0x3b, 0x9a, 0x3c, 0x0a, 0xd4, 0xb8, 0xba, 0x4c, 0x95, 0x23, 0x8e, 0x96, 0xa8, 0x42, 0x2b, 0x85, 0x35, 0x62, 0x9c, 0x8d, 0x53, 0x82, 0x37, 0x44, 0x79, 0xad, 0x13, 0xfa, 0x39, 0x97, 0x4b, 0x24, 0x2f, 0x9a, 0x75, 0x9e, 0xea, 0xf9, 0xc8, 0x3a, 0xd5, 0xa8, 0xca, 0x18, 0x94, 0x0a, 0x01, 0x62, 0xba, 0x75, 0x58, 0x76, 0xdf, 0x26, 0x3f, 0x4b, 0xd5, 0x0c, 0x65, 0x25, 0xc5, 0x60, 0x90, 0x26, 0x7c, 0x1f, 0x0e, 0x09, 0xce, 0x08, 0x99, 0xa0, 0xcf, 0x35, 0x9e, 0x88, 0x12, 0x0a, 0xbd, 0x9b, 0xf8, 0x93, 0x44, 0x5b, 0x3c, 0xae, 0x77, 0xd3, 0x60, 0x73, 0x59, 0xae, 0x9a, 0x52, 0xf8, 
};
static const u8 rsa_oaep_66_salt[] = {
0x3b, 0xbc, 0x3b, 0xd6, 0x63, 0x7d, 0xfe, 0x12, 0x84, 0x69, 0x01, 0x02, 0x9b, 0xf5, 0xb0, 0xc0, 0x71, 0x03, 0x43, 0x9c, 
};


static const rsa_test test_rsa_oaep_66 = {
	.name = "rsa_oaep_66",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_66_n,
	.nlen = sizeof(rsa_oaep_66_n),
	.d = (const u8*)&rsa_oaep_66_d,
	.dlen = sizeof(rsa_oaep_66_d),
	.e = (const u8*)&rsa_oaep_66_e,
	.elen = sizeof(rsa_oaep_66_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_66_m,
	.mlen = sizeof(rsa_oaep_66_m),
	.res = (const u8*)&rsa_oaep_66_res,
	.reslen = sizeof(rsa_oaep_66_res),
	.salt = (const u8*)&rsa_oaep_66_salt,
	.saltlen = sizeof(rsa_oaep_66_salt),
};
static const u8 rsa_oaep_67_CRT_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_67_CRT_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_67_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_67_CRT_m[] = {
0x68, 0x4e, 0x30, 0x38, 0xc5, 0xc0, 0x41, 0xf7, 
};
static const u8 rsa_oaep_67_CRT_res[] = {
0x00, 0x8e, 0x7a, 0x67, 0xca, 0xcf, 0xb5, 0xc4, 0xe2, 0x4b, 0xec, 0x7d, 0xee, 0x14, 0x91, 0x17, 0xf1, 0x95, 0x98, 0xce, 0x8c, 0x45, 0x80, 0x8f, 0xef, 0x88, 0xc6, 0x08, 0xff, 0x9c, 0xd6, 0xe6, 0x95, 0x26, 0x3b, 0x9a, 0x3c, 0x0a, 0xd4, 0xb8, 0xba, 0x4c, 0x95, 0x23, 0x8e, 0x96, 0xa8, 0x42, 0x2b, 0x85, 0x35, 0x62, 0x9c, 0x8d, 0x53, 0x82, 0x37, 0x44, 0x79, 0xad, 0x13, 0xfa, 0x39, 0x97, 0x4b, 0x24, 0x2f, 0x9a, 0x75, 0x9e, 0xea, 0xf9, 0xc8, 0x3a, 0xd5, 0xa8, 0xca, 0x18, 0x94, 0x0a, 0x01, 0x62, 0xba, 0x75, 0x58, 0x76, 0xdf, 0x26, 0x3f, 0x4b, 0xd5, 0x0c, 0x65, 0x25, 0xc5, 0x60, 0x90, 0x26, 0x7c, 0x1f, 0x0e, 0x09, 0xce, 0x08, 0x99, 0xa0, 0xcf, 0x35, 0x9e, 0x88, 0x12, 0x0a, 0xbd, 0x9b, 0xf8, 0x93, 0x44, 0x5b, 0x3c, 0xae, 0x77, 0xd3, 0x60, 0x73, 0x59, 0xae, 0x9a, 0x52, 0xf8, 
};
static const u8 rsa_oaep_67_CRT_salt[] = {
0x3b, 0xbc, 0x3b, 0xd6, 0x63, 0x7d, 0xfe, 0x12, 0x84, 0x69, 0x01, 0x02, 0x9b, 0xf5, 0xb0, 0xc0, 0x71, 0x03, 0x43, 0x9c, 
};
static const u8 rsa_oaep_67_CRT_p[] = {
0x04, 0xa6, 0xce, 0x8b, 0x73, 0x58, 0xdf, 0xa6, 0x9b, 0xdc, 0xf7, 0x42, 0x61, 0x70, 0x05, 0xaf, 0xb5, 0x38, 0x5f, 0x5f, 0x3a, 0x58, 0xa2, 0x4e, 0xf7, 0x4a, 0x22, 0xa8, 0xc0, 0x5c, 0xb7, 0xcc, 0x38, 0xeb, 0xd4, 0xcc, 0x9d, 0x9a, 0x9d, 0x78, 0x9a, 0x62, 0xcd, 0x0f, 0x60, 0xf0, 0xcb, 0x94, 0x1d, 0x34, 0x23, 0xc9, 0x69, 0x2e, 0xfa, 0x4f, 0xe3, 0xad, 0xff, 0x29, 0x0c, 0x47, 0x49, 0xa3, 0x8b, 
};
static const u8 rsa_oaep_67_CRT_q[] = {
0x04, 0x04, 0xc9, 0xa8, 0x03, 0x37, 0x1f, 0xed, 0xb4, 0xc5, 0xbe, 0x39, 0xf3, 0xc0, 0x0b, 0x00, 0x9e, 0x5e, 0x08, 0xa6, 0x3b, 0xe1, 0xe4, 0x00, 0x35, 0xcd, 0xac, 0xa5, 0x01, 0x1c, 0xc7, 0x01, 0xcf, 0x7e, 0xeb, 0xcb, 0x99, 0xf0, 0xff, 0xe1, 0x7c, 0xfd, 0x0a, 0x4b, 0xf7, 0xbe, 0xfd, 0x2d, 0xd5, 0x36, 0xac, 0x94, 0x6d, 0xb7, 0x97, 0xfd, 0xbc, 0x4a, 0xbe, 0x8f, 0x29, 0x34, 0x9b, 0x91, 0xed, 
};
static const u8 rsa_oaep_67_CRT_dP[] = {
0x03, 0x96, 0x1c, 0x8f, 0x76, 0x0a, 0xa2, 0xbd, 0x51, 0x54, 0xc7, 0xaa, 0xfd, 0x77, 0x22, 0x5b, 0x3b, 0xac, 0xd0, 0x13, 0x9a, 0xe7, 0xb5, 0x94, 0x8e, 0xa3, 0x31, 0x1f, 0xcc, 0xd8, 0x6f, 0xb9, 0x5c, 0x75, 0xaf, 0xa7, 0x67, 0x28, 0x4b, 0x9b, 0x2d, 0xe5, 0x59, 0x57, 0x2f, 0x15, 0xd8, 0xd0, 0x44, 0xc7, 0xeb, 0x83, 0xa1, 0xbe, 0x5f, 0xad, 0xf2, 0xcc, 0x37, 0x7c, 0x0d, 0x84, 0x75, 0x29, 0x4b, 
};
static const u8 rsa_oaep_67_CRT_dQ[] = {
0x02, 0x21, 0x97, 0xe0, 0x66, 0x74, 0x21, 0x96, 0xaa, 0xbc, 0x03, 0xfa, 0x2f, 0xee, 0xb4, 0xe7, 0x0b, 0x15, 0xcb, 0x78, 0x7d, 0x61, 0x7a, 0xcd, 0x31, 0xbb, 0x75, 0xc7, 0xbc, 0x23, 0x4a, 0xd7, 0x06, 0xf7, 0xc4, 0x8d, 0x21, 0x82, 0xd1, 0xf0, 0xff, 0x9c, 0x22, 0x8d, 0xcf, 0x41, 0x96, 0x7b, 0x6c, 0x0b, 0xa6, 0xd2, 0xc0, 0xad, 0x11, 0x0a, 0x1b, 0x85, 0x78, 0x31, 0xec, 0x24, 0x5e, 0x2c, 0xb1, 
};
static const u8 rsa_oaep_67_CRT_qInv[] = {
0x04, 0x01, 0xc4, 0xc0, 0xc5, 0x3d, 0x45, 0xdb, 0xdb, 0x5e, 0x9d, 0x96, 0xd0, 0xfe, 0xcf, 0x42, 0x75, 0xdf, 0x09, 0x74, 0xbc, 0x4a, 0x07, 0x36, 0xb4, 0xa7, 0x4c, 0x32, 0x69, 0x05, 0x3e, 0xfb, 0x68, 0x6a, 0xce, 0x24, 0x06, 0xe2, 0x2c, 0x9e, 0x05, 0x8d, 0xdb, 0x4a, 0xe5, 0x40, 0x62, 0x7a, 0xe2, 0xfd, 0xb0, 0x82, 0x61, 0xe8, 0xe7, 0xe4, 0xbc, 0xbc, 0x99, 0x4d, 0xaa, 0xfa, 0x30, 0x5c, 0x45, 
};


static const rsa_test test_rsa_oaep_67_CRT = {
	.name = "rsa_oaep_67_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_67_CRT_n,
	.nlen = sizeof(rsa_oaep_67_CRT_n),
	.d = (const u8*)&rsa_oaep_67_CRT_d,
	.dlen = sizeof(rsa_oaep_67_CRT_d),
	.e = (const u8*)&rsa_oaep_67_CRT_e,
	.elen = sizeof(rsa_oaep_67_CRT_e),
	.p = (const u8*)&rsa_oaep_67_CRT_p,
	.plen = sizeof(rsa_oaep_67_CRT_p),
	.q = (const u8*)&rsa_oaep_67_CRT_q,
	.qlen = sizeof(rsa_oaep_67_CRT_q),
	.dP = (const u8*)&rsa_oaep_67_CRT_dP,
	.dPlen = sizeof(rsa_oaep_67_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_67_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_67_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_67_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_67_CRT_qInv),
	.m = (const u8*)&rsa_oaep_67_CRT_m,
	.mlen = sizeof(rsa_oaep_67_CRT_m),
	.res = (const u8*)&rsa_oaep_67_CRT_res,
	.reslen = sizeof(rsa_oaep_67_CRT_res),
	.salt = (const u8*)&rsa_oaep_67_CRT_salt,
	.saltlen = sizeof(rsa_oaep_67_CRT_salt),
};
static const u8 rsa_oaep_68_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_68_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_68_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_68_m[] = {
0x32, 0x48, 0x8c, 0xb2, 0x62, 0xd0, 0x41, 0xd6, 0xe4, 0xdd, 0x35, 0xf9, 0x87, 0xbf, 0x3c, 0xa6, 0x96, 0xdb, 0x1f, 0x06, 0xac, 0x29, 0xa4, 0x46, 0x93, 
};
static const u8 rsa_oaep_68_res[] = {
0x00, 0x00, 0x34, 0x74, 0x41, 0x6c, 0x7b, 0x68, 0xbd, 0xf9, 0x61, 0xc3, 0x85, 0x73, 0x79, 0x44, 0xd7, 0xf1, 0xf4, 0x0c, 0xb3, 0x95, 0x34, 0x3c, 0x69, 0x3c, 0xc0, 0xb4, 0xfe, 0x63, 0xb3, 0x1f, 0xed, 0xf1, 0xea, 0xee, 0xac, 0x9c, 0xcc, 0x06, 0x78, 0xb3, 0x1d, 0xc3, 0x2e, 0x09, 0x77, 0x48, 0x95, 0x14, 0xc4, 0xf0, 0x90, 0x85, 0xf6, 0x29, 0x8a, 0x96, 0x53, 0xf0, 0x1a, 0xea, 0x40, 0x45, 0xff, 0x58, 0x2e, 0xe8, 0x87, 0xbe, 0x26, 0xae, 0x57, 0x5b, 0x73, 0xee, 0xf7, 0xf3, 0x77, 0x49, 0x21, 0xe3, 0x75, 0xa3, 0xd1, 0x9a, 0xdd, 0xa0, 0xca, 0x31, 0xaa, 0x18, 0x49, 0x88, 0x7c, 0x1f, 0x42, 0xca, 0xc9, 0x67, 0x7f, 0x7a, 0x2f, 0x4e, 0x92, 0x3f, 0x6e, 0x5a, 0x86, 0x8b, 0x38, 0xc0, 0x84, 0xef, 0x18, 0x75, 0x94, 0xdc, 0x9f, 0x7f, 0x04, 0x8f, 0xea, 0x2e, 0x02, 0x95, 0x53, 0x84, 0xab, 
};
static const u8 rsa_oaep_68_salt[] = {
0xb4, 0x6b, 0x41, 0x89, 0x3e, 0x8b, 0xef, 0x32, 0x6f, 0x67, 0x59, 0x38, 0x3a, 0x83, 0x07, 0x1d, 0xae, 0x7f, 0xca, 0xbc, 
};


static const rsa_test test_rsa_oaep_68 = {
	.name = "rsa_oaep_68",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_68_n,
	.nlen = sizeof(rsa_oaep_68_n),
	.d = (const u8*)&rsa_oaep_68_d,
	.dlen = sizeof(rsa_oaep_68_d),
	.e = (const u8*)&rsa_oaep_68_e,
	.elen = sizeof(rsa_oaep_68_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_68_m,
	.mlen = sizeof(rsa_oaep_68_m),
	.res = (const u8*)&rsa_oaep_68_res,
	.reslen = sizeof(rsa_oaep_68_res),
	.salt = (const u8*)&rsa_oaep_68_salt,
	.saltlen = sizeof(rsa_oaep_68_salt),
};
static const u8 rsa_oaep_69_CRT_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_69_CRT_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_69_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_69_CRT_m[] = {
0x32, 0x48, 0x8c, 0xb2, 0x62, 0xd0, 0x41, 0xd6, 0xe4, 0xdd, 0x35, 0xf9, 0x87, 0xbf, 0x3c, 0xa6, 0x96, 0xdb, 0x1f, 0x06, 0xac, 0x29, 0xa4, 0x46, 0x93, 
};
static const u8 rsa_oaep_69_CRT_res[] = {
0x00, 0x00, 0x34, 0x74, 0x41, 0x6c, 0x7b, 0x68, 0xbd, 0xf9, 0x61, 0xc3, 0x85, 0x73, 0x79, 0x44, 0xd7, 0xf1, 0xf4, 0x0c, 0xb3, 0x95, 0x34, 0x3c, 0x69, 0x3c, 0xc0, 0xb4, 0xfe, 0x63, 0xb3, 0x1f, 0xed, 0xf1, 0xea, 0xee, 0xac, 0x9c, 0xcc, 0x06, 0x78, 0xb3, 0x1d, 0xc3, 0x2e, 0x09, 0x77, 0x48, 0x95, 0x14, 0xc4, 0xf0, 0x90, 0x85, 0xf6, 0x29, 0x8a, 0x96, 0x53, 0xf0, 0x1a, 0xea, 0x40, 0x45, 0xff, 0x58, 0x2e, 0xe8, 0x87, 0xbe, 0x26, 0xae, 0x57, 0x5b, 0x73, 0xee, 0xf7, 0xf3, 0x77, 0x49, 0x21, 0xe3, 0x75, 0xa3, 0xd1, 0x9a, 0xdd, 0xa0, 0xca, 0x31, 0xaa, 0x18, 0x49, 0x88, 0x7c, 0x1f, 0x42, 0xca, 0xc9, 0x67, 0x7f, 0x7a, 0x2f, 0x4e, 0x92, 0x3f, 0x6e, 0x5a, 0x86, 0x8b, 0x38, 0xc0, 0x84, 0xef, 0x18, 0x75, 0x94, 0xdc, 0x9f, 0x7f, 0x04, 0x8f, 0xea, 0x2e, 0x02, 0x95, 0x53, 0x84, 0xab, 
};
static const u8 rsa_oaep_69_CRT_salt[] = {
0xb4, 0x6b, 0x41, 0x89, 0x3e, 0x8b, 0xef, 0x32, 0x6f, 0x67, 0x59, 0x38, 0x3a, 0x83, 0x07, 0x1d, 0xae, 0x7f, 0xca, 0xbc, 
};
static const u8 rsa_oaep_69_CRT_p[] = {
0x04, 0xa6, 0xce, 0x8b, 0x73, 0x58, 0xdf, 0xa6, 0x9b, 0xdc, 0xf7, 0x42, 0x61, 0x70, 0x05, 0xaf, 0xb5, 0x38, 0x5f, 0x5f, 0x3a, 0x58, 0xa2, 0x4e, 0xf7, 0x4a, 0x22, 0xa8, 0xc0, 0x5c, 0xb7, 0xcc, 0x38, 0xeb, 0xd4, 0xcc, 0x9d, 0x9a, 0x9d, 0x78, 0x9a, 0x62, 0xcd, 0x0f, 0x60, 0xf0, 0xcb, 0x94, 0x1d, 0x34, 0x23, 0xc9, 0x69, 0x2e, 0xfa, 0x4f, 0xe3, 0xad, 0xff, 0x29, 0x0c, 0x47, 0x49, 0xa3, 0x8b, 
};
static const u8 rsa_oaep_69_CRT_q[] = {
0x04, 0x04, 0xc9, 0xa8, 0x03, 0x37, 0x1f, 0xed, 0xb4, 0xc5, 0xbe, 0x39, 0xf3, 0xc0, 0x0b, 0x00, 0x9e, 0x5e, 0x08, 0xa6, 0x3b, 0xe1, 0xe4, 0x00, 0x35, 0xcd, 0xac, 0xa5, 0x01, 0x1c, 0xc7, 0x01, 0xcf, 0x7e, 0xeb, 0xcb, 0x99, 0xf0, 0xff, 0xe1, 0x7c, 0xfd, 0x0a, 0x4b, 0xf7, 0xbe, 0xfd, 0x2d, 0xd5, 0x36, 0xac, 0x94, 0x6d, 0xb7, 0x97, 0xfd, 0xbc, 0x4a, 0xbe, 0x8f, 0x29, 0x34, 0x9b, 0x91, 0xed, 
};
static const u8 rsa_oaep_69_CRT_dP[] = {
0x03, 0x96, 0x1c, 0x8f, 0x76, 0x0a, 0xa2, 0xbd, 0x51, 0x54, 0xc7, 0xaa, 0xfd, 0x77, 0x22, 0x5b, 0x3b, 0xac, 0xd0, 0x13, 0x9a, 0xe7, 0xb5, 0x94, 0x8e, 0xa3, 0x31, 0x1f, 0xcc, 0xd8, 0x6f, 0xb9, 0x5c, 0x75, 0xaf, 0xa7, 0x67, 0x28, 0x4b, 0x9b, 0x2d, 0xe5, 0x59, 0x57, 0x2f, 0x15, 0xd8, 0xd0, 0x44, 0xc7, 0xeb, 0x83, 0xa1, 0xbe, 0x5f, 0xad, 0xf2, 0xcc, 0x37, 0x7c, 0x0d, 0x84, 0x75, 0x29, 0x4b, 
};
static const u8 rsa_oaep_69_CRT_dQ[] = {
0x02, 0x21, 0x97, 0xe0, 0x66, 0x74, 0x21, 0x96, 0xaa, 0xbc, 0x03, 0xfa, 0x2f, 0xee, 0xb4, 0xe7, 0x0b, 0x15, 0xcb, 0x78, 0x7d, 0x61, 0x7a, 0xcd, 0x31, 0xbb, 0x75, 0xc7, 0xbc, 0x23, 0x4a, 0xd7, 0x06, 0xf7, 0xc4, 0x8d, 0x21, 0x82, 0xd1, 0xf0, 0xff, 0x9c, 0x22, 0x8d, 0xcf, 0x41, 0x96, 0x7b, 0x6c, 0x0b, 0xa6, 0xd2, 0xc0, 0xad, 0x11, 0x0a, 0x1b, 0x85, 0x78, 0x31, 0xec, 0x24, 0x5e, 0x2c, 0xb1, 
};
static const u8 rsa_oaep_69_CRT_qInv[] = {
0x04, 0x01, 0xc4, 0xc0, 0xc5, 0x3d, 0x45, 0xdb, 0xdb, 0x5e, 0x9d, 0x96, 0xd0, 0xfe, 0xcf, 0x42, 0x75, 0xdf, 0x09, 0x74, 0xbc, 0x4a, 0x07, 0x36, 0xb4, 0xa7, 0x4c, 0x32, 0x69, 0x05, 0x3e, 0xfb, 0x68, 0x6a, 0xce, 0x24, 0x06, 0xe2, 0x2c, 0x9e, 0x05, 0x8d, 0xdb, 0x4a, 0xe5, 0x40, 0x62, 0x7a, 0xe2, 0xfd, 0xb0, 0x82, 0x61, 0xe8, 0xe7, 0xe4, 0xbc, 0xbc, 0x99, 0x4d, 0xaa, 0xfa, 0x30, 0x5c, 0x45, 
};


static const rsa_test test_rsa_oaep_69_CRT = {
	.name = "rsa_oaep_69_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_69_CRT_n,
	.nlen = sizeof(rsa_oaep_69_CRT_n),
	.d = (const u8*)&rsa_oaep_69_CRT_d,
	.dlen = sizeof(rsa_oaep_69_CRT_d),
	.e = (const u8*)&rsa_oaep_69_CRT_e,
	.elen = sizeof(rsa_oaep_69_CRT_e),
	.p = (const u8*)&rsa_oaep_69_CRT_p,
	.plen = sizeof(rsa_oaep_69_CRT_p),
	.q = (const u8*)&rsa_oaep_69_CRT_q,
	.qlen = sizeof(rsa_oaep_69_CRT_q),
	.dP = (const u8*)&rsa_oaep_69_CRT_dP,
	.dPlen = sizeof(rsa_oaep_69_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_69_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_69_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_69_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_69_CRT_qInv),
	.m = (const u8*)&rsa_oaep_69_CRT_m,
	.mlen = sizeof(rsa_oaep_69_CRT_m),
	.res = (const u8*)&rsa_oaep_69_CRT_res,
	.reslen = sizeof(rsa_oaep_69_CRT_res),
	.salt = (const u8*)&rsa_oaep_69_CRT_salt,
	.saltlen = sizeof(rsa_oaep_69_CRT_salt),
};
static const u8 rsa_oaep_70_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_70_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_70_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_70_m[] = {
0x50, 0xba, 0x14, 0xbe, 0x84, 0x62, 0x72, 0x02, 0x79, 0xc3, 0x06, 0xba, 
};
static const u8 rsa_oaep_70_res[] = {
0x0a, 0x02, 0x6d, 0xda, 0x5f, 0xc8, 0x78, 0x5f, 0x7b, 0xd9, 0xbf, 0x75, 0x32, 0x7b, 0x63, 0xe8, 0x5e, 0x2c, 0x0f, 0xde, 0xe5, 0xda, 0xdb, 0x65, 0xeb, 0xdc, 0xac, 0x9a, 0xe1, 0xde, 0x95, 0xc9, 0x2c, 0x67, 0x2a, 0xb4, 0x33, 0xaa, 0x7a, 0x8e, 0x69, 0xce, 0x6a, 0x6d, 0x88, 0x97, 0xfa, 0xc4, 0xac, 0x4a, 0x54, 0xde, 0x84, 0x1a, 0xe5, 0xe5, 0xbb, 0xce, 0x76, 0x87, 0x87, 0x9d, 0x79, 0x63, 0x4c, 0xea, 0x7a, 0x30, 0x68, 0x40, 0x65, 0xc7, 0x14, 0xd5, 0x24, 0x09, 0xb9, 0x28, 0x25, 0x6b, 0xbf, 0x53, 0xea, 0xbc, 0xd5, 0x23, 0x1e, 0xb7, 0x25, 0x95, 0x04, 0x53, 0x73, 0x99, 0xbd, 0x29, 0x16, 0x4b, 0x72, 0x6d, 0x33, 0xa4, 0x6d, 0xa7, 0x01, 0x36, 0x0a, 0x41, 0x68, 0xa0, 0x91, 0xcc, 0xab, 0x72, 0xd4, 0x4a, 0x62, 0xfe, 0xd2, 0x46, 0xc0, 0xff, 0xea, 0x5b, 0x13, 0x48, 0xab, 0x54, 0x70, 
};
static const u8 rsa_oaep_70_salt[] = {
0x0a, 0x24, 0x03, 0x31, 0x2a, 0x41, 0xe3, 0xd5, 0x2f, 0x06, 0x0f, 0xbc, 0x13, 0xa6, 0x7d, 0xe5, 0xcf, 0x76, 0x09, 0xa7, 
};


static const rsa_test test_rsa_oaep_70 = {
	.name = "rsa_oaep_70",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_70_n,
	.nlen = sizeof(rsa_oaep_70_n),
	.d = (const u8*)&rsa_oaep_70_d,
	.dlen = sizeof(rsa_oaep_70_d),
	.e = (const u8*)&rsa_oaep_70_e,
	.elen = sizeof(rsa_oaep_70_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_70_m,
	.mlen = sizeof(rsa_oaep_70_m),
	.res = (const u8*)&rsa_oaep_70_res,
	.reslen = sizeof(rsa_oaep_70_res),
	.salt = (const u8*)&rsa_oaep_70_salt,
	.saltlen = sizeof(rsa_oaep_70_salt),
};
static const u8 rsa_oaep_71_CRT_n[] = {
0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf, 
};
static const u8 rsa_oaep_71_CRT_d[] = {
0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9, 
};
static const u8 rsa_oaep_71_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_71_CRT_m[] = {
0x50, 0xba, 0x14, 0xbe, 0x84, 0x62, 0x72, 0x02, 0x79, 0xc3, 0x06, 0xba, 
};
static const u8 rsa_oaep_71_CRT_res[] = {
0x0a, 0x02, 0x6d, 0xda, 0x5f, 0xc8, 0x78, 0x5f, 0x7b, 0xd9, 0xbf, 0x75, 0x32, 0x7b, 0x63, 0xe8, 0x5e, 0x2c, 0x0f, 0xde, 0xe5, 0xda, 0xdb, 0x65, 0xeb, 0xdc, 0xac, 0x9a, 0xe1, 0xde, 0x95, 0xc9, 0x2c, 0x67, 0x2a, 0xb4, 0x33, 0xaa, 0x7a, 0x8e, 0x69, 0xce, 0x6a, 0x6d, 0x88, 0x97, 0xfa, 0xc4, 0xac, 0x4a, 0x54, 0xde, 0x84, 0x1a, 0xe5, 0xe5, 0xbb, 0xce, 0x76, 0x87, 0x87, 0x9d, 0x79, 0x63, 0x4c, 0xea, 0x7a, 0x30, 0x68, 0x40, 0x65, 0xc7, 0x14, 0xd5, 0x24, 0x09, 0xb9, 0x28, 0x25, 0x6b, 0xbf, 0x53, 0xea, 0xbc, 0xd5, 0x23, 0x1e, 0xb7, 0x25, 0x95, 0x04, 0x53, 0x73, 0x99, 0xbd, 0x29, 0x16, 0x4b, 0x72, 0x6d, 0x33, 0xa4, 0x6d, 0xa7, 0x01, 0x36, 0x0a, 0x41, 0x68, 0xa0, 0x91, 0xcc, 0xab, 0x72, 0xd4, 0x4a, 0x62, 0xfe, 0xd2, 0x46, 0xc0, 0xff, 0xea, 0x5b, 0x13, 0x48, 0xab, 0x54, 0x70, 
};
static const u8 rsa_oaep_71_CRT_salt[] = {
0x0a, 0x24, 0x03, 0x31, 0x2a, 0x41, 0xe3, 0xd5, 0x2f, 0x06, 0x0f, 0xbc, 0x13, 0xa6, 0x7d, 0xe5, 0xcf, 0x76, 0x09, 0xa7, 
};
static const u8 rsa_oaep_71_CRT_p[] = {
0x04, 0xa6, 0xce, 0x8b, 0x73, 0x58, 0xdf, 0xa6, 0x9b, 0xdc, 0xf7, 0x42, 0x61, 0x70, 0x05, 0xaf, 0xb5, 0x38, 0x5f, 0x5f, 0x3a, 0x58, 0xa2, 0x4e, 0xf7, 0x4a, 0x22, 0xa8, 0xc0, 0x5c, 0xb7, 0xcc, 0x38, 0xeb, 0xd4, 0xcc, 0x9d, 0x9a, 0x9d, 0x78, 0x9a, 0x62, 0xcd, 0x0f, 0x60, 0xf0, 0xcb, 0x94, 0x1d, 0x34, 0x23, 0xc9, 0x69, 0x2e, 0xfa, 0x4f, 0xe3, 0xad, 0xff, 0x29, 0x0c, 0x47, 0x49, 0xa3, 0x8b, 
};
static const u8 rsa_oaep_71_CRT_q[] = {
0x04, 0x04, 0xc9, 0xa8, 0x03, 0x37, 0x1f, 0xed, 0xb4, 0xc5, 0xbe, 0x39, 0xf3, 0xc0, 0x0b, 0x00, 0x9e, 0x5e, 0x08, 0xa6, 0x3b, 0xe1, 0xe4, 0x00, 0x35, 0xcd, 0xac, 0xa5, 0x01, 0x1c, 0xc7, 0x01, 0xcf, 0x7e, 0xeb, 0xcb, 0x99, 0xf0, 0xff, 0xe1, 0x7c, 0xfd, 0x0a, 0x4b, 0xf7, 0xbe, 0xfd, 0x2d, 0xd5, 0x36, 0xac, 0x94, 0x6d, 0xb7, 0x97, 0xfd, 0xbc, 0x4a, 0xbe, 0x8f, 0x29, 0x34, 0x9b, 0x91, 0xed, 
};
static const u8 rsa_oaep_71_CRT_dP[] = {
0x03, 0x96, 0x1c, 0x8f, 0x76, 0x0a, 0xa2, 0xbd, 0x51, 0x54, 0xc7, 0xaa, 0xfd, 0x77, 0x22, 0x5b, 0x3b, 0xac, 0xd0, 0x13, 0x9a, 0xe7, 0xb5, 0x94, 0x8e, 0xa3, 0x31, 0x1f, 0xcc, 0xd8, 0x6f, 0xb9, 0x5c, 0x75, 0xaf, 0xa7, 0x67, 0x28, 0x4b, 0x9b, 0x2d, 0xe5, 0x59, 0x57, 0x2f, 0x15, 0xd8, 0xd0, 0x44, 0xc7, 0xeb, 0x83, 0xa1, 0xbe, 0x5f, 0xad, 0xf2, 0xcc, 0x37, 0x7c, 0x0d, 0x84, 0x75, 0x29, 0x4b, 
};
static const u8 rsa_oaep_71_CRT_dQ[] = {
0x02, 0x21, 0x97, 0xe0, 0x66, 0x74, 0x21, 0x96, 0xaa, 0xbc, 0x03, 0xfa, 0x2f, 0xee, 0xb4, 0xe7, 0x0b, 0x15, 0xcb, 0x78, 0x7d, 0x61, 0x7a, 0xcd, 0x31, 0xbb, 0x75, 0xc7, 0xbc, 0x23, 0x4a, 0xd7, 0x06, 0xf7, 0xc4, 0x8d, 0x21, 0x82, 0xd1, 0xf0, 0xff, 0x9c, 0x22, 0x8d, 0xcf, 0x41, 0x96, 0x7b, 0x6c, 0x0b, 0xa6, 0xd2, 0xc0, 0xad, 0x11, 0x0a, 0x1b, 0x85, 0x78, 0x31, 0xec, 0x24, 0x5e, 0x2c, 0xb1, 
};
static const u8 rsa_oaep_71_CRT_qInv[] = {
0x04, 0x01, 0xc4, 0xc0, 0xc5, 0x3d, 0x45, 0xdb, 0xdb, 0x5e, 0x9d, 0x96, 0xd0, 0xfe, 0xcf, 0x42, 0x75, 0xdf, 0x09, 0x74, 0xbc, 0x4a, 0x07, 0x36, 0xb4, 0xa7, 0x4c, 0x32, 0x69, 0x05, 0x3e, 0xfb, 0x68, 0x6a, 0xce, 0x24, 0x06, 0xe2, 0x2c, 0x9e, 0x05, 0x8d, 0xdb, 0x4a, 0xe5, 0x40, 0x62, 0x7a, 0xe2, 0xfd, 0xb0, 0x82, 0x61, 0xe8, 0xe7, 0xe4, 0xbc, 0xbc, 0x99, 0x4d, 0xaa, 0xfa, 0x30, 0x5c, 0x45, 
};


static const rsa_test test_rsa_oaep_71_CRT = {
	.name = "rsa_oaep_71_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_71_CRT_n,
	.nlen = sizeof(rsa_oaep_71_CRT_n),
	.d = (const u8*)&rsa_oaep_71_CRT_d,
	.dlen = sizeof(rsa_oaep_71_CRT_d),
	.e = (const u8*)&rsa_oaep_71_CRT_e,
	.elen = sizeof(rsa_oaep_71_CRT_e),
	.p = (const u8*)&rsa_oaep_71_CRT_p,
	.plen = sizeof(rsa_oaep_71_CRT_p),
	.q = (const u8*)&rsa_oaep_71_CRT_q,
	.qlen = sizeof(rsa_oaep_71_CRT_q),
	.dP = (const u8*)&rsa_oaep_71_CRT_dP,
	.dPlen = sizeof(rsa_oaep_71_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_71_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_71_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_71_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_71_CRT_qInv),
	.m = (const u8*)&rsa_oaep_71_CRT_m,
	.mlen = sizeof(rsa_oaep_71_CRT_m),
	.res = (const u8*)&rsa_oaep_71_CRT_res,
	.reslen = sizeof(rsa_oaep_71_CRT_res),
	.salt = (const u8*)&rsa_oaep_71_CRT_salt,
	.saltlen = sizeof(rsa_oaep_71_CRT_salt),
};
static const u8 rsa_oaep_72_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_72_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_72_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_72_m[] = {
0x47, 0xaa, 0xe9, 0x09, 
};
static const u8 rsa_oaep_72_res[] = {
0x16, 0x88, 0xe4, 0xce, 0x77, 0x94, 0xbb, 0xa6, 0xcb, 0x70, 0x14, 0x16, 0x9e, 0xcd, 0x55, 0x9c, 0xed, 0xe2, 0xa3, 0x0b, 0x56, 0xa5, 0x2b, 0x68, 0xd9, 0xfe, 0x18, 0xcf, 0x19, 0x73, 0xef, 0x97, 0xb2, 0xa0, 0x31, 0x53, 0x95, 0x1c, 0x75, 0x5f, 0x62, 0x94, 0xaa, 0x49, 0xad, 0xbd, 0xb5, 0x58, 0x45, 0xab, 0x68, 0x75, 0xfb, 0x39, 0x86, 0xc9, 0x3e, 0xcf, 0x92, 0x79, 0x62, 0x84, 0x0d, 0x28, 0x2f, 0x9e, 0x54, 0xce, 0x8b, 0x69, 0x0f, 0x7c, 0x0c, 0xb8, 0xbb, 0xd7, 0x34, 0x40, 0xd9, 0x57, 0x1d, 0x1b, 0x16, 0xcd, 0x92, 0x60, 0xf9, 0xea, 0xb4, 0x78, 0x3c, 0xc4, 0x82, 0xe5, 0x22, 0x3d, 0xc6, 0x09, 0x73, 0x87, 0x17, 0x83, 0xec, 0x27, 0xb0, 0xae, 0x0f, 0xd4, 0x77, 0x32, 0xcb, 0xc2, 0x86, 0xa1, 0x73, 0xfc, 0x92, 0xb0, 0x0f, 0xb4, 0xba, 0x68, 0x24, 0x64, 0x7c, 0xd9, 0x3c, 0x85, 0xc1, 
};
static const u8 rsa_oaep_72_salt[] = {
0x43, 0xdd, 0x09, 0xa0, 0x7f, 0xf4, 0xca, 0xc7, 0x1c, 0xaa, 0x46, 0x32, 0xee, 0x5e, 0x1c, 0x1d, 0xae, 0xe4, 0xcd, 0x8f, 
};


static const rsa_test test_rsa_oaep_72 = {
	.name = "rsa_oaep_72",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_72_n,
	.nlen = sizeof(rsa_oaep_72_n),
	.d = (const u8*)&rsa_oaep_72_d,
	.dlen = sizeof(rsa_oaep_72_d),
	.e = (const u8*)&rsa_oaep_72_e,
	.elen = sizeof(rsa_oaep_72_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_72_m,
	.mlen = sizeof(rsa_oaep_72_m),
	.res = (const u8*)&rsa_oaep_72_res,
	.reslen = sizeof(rsa_oaep_72_res),
	.salt = (const u8*)&rsa_oaep_72_salt,
	.saltlen = sizeof(rsa_oaep_72_salt),
};
static const u8 rsa_oaep_73_CRT_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_73_CRT_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_73_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_73_CRT_m[] = {
0x47, 0xaa, 0xe9, 0x09, 
};
static const u8 rsa_oaep_73_CRT_res[] = {
0x16, 0x88, 0xe4, 0xce, 0x77, 0x94, 0xbb, 0xa6, 0xcb, 0x70, 0x14, 0x16, 0x9e, 0xcd, 0x55, 0x9c, 0xed, 0xe2, 0xa3, 0x0b, 0x56, 0xa5, 0x2b, 0x68, 0xd9, 0xfe, 0x18, 0xcf, 0x19, 0x73, 0xef, 0x97, 0xb2, 0xa0, 0x31, 0x53, 0x95, 0x1c, 0x75, 0x5f, 0x62, 0x94, 0xaa, 0x49, 0xad, 0xbd, 0xb5, 0x58, 0x45, 0xab, 0x68, 0x75, 0xfb, 0x39, 0x86, 0xc9, 0x3e, 0xcf, 0x92, 0x79, 0x62, 0x84, 0x0d, 0x28, 0x2f, 0x9e, 0x54, 0xce, 0x8b, 0x69, 0x0f, 0x7c, 0x0c, 0xb8, 0xbb, 0xd7, 0x34, 0x40, 0xd9, 0x57, 0x1d, 0x1b, 0x16, 0xcd, 0x92, 0x60, 0xf9, 0xea, 0xb4, 0x78, 0x3c, 0xc4, 0x82, 0xe5, 0x22, 0x3d, 0xc6, 0x09, 0x73, 0x87, 0x17, 0x83, 0xec, 0x27, 0xb0, 0xae, 0x0f, 0xd4, 0x77, 0x32, 0xcb, 0xc2, 0x86, 0xa1, 0x73, 0xfc, 0x92, 0xb0, 0x0f, 0xb4, 0xba, 0x68, 0x24, 0x64, 0x7c, 0xd9, 0x3c, 0x85, 0xc1, 
};
static const u8 rsa_oaep_73_CRT_salt[] = {
0x43, 0xdd, 0x09, 0xa0, 0x7f, 0xf4, 0xca, 0xc7, 0x1c, 0xaa, 0x46, 0x32, 0xee, 0x5e, 0x1c, 0x1d, 0xae, 0xe4, 0xcd, 0x8f, 
};
static const u8 rsa_oaep_73_CRT_p[] = {
0x07, 0x49, 0x26, 0x2c, 0x11, 0x1c, 0xd4, 0x70, 0xec, 0x25, 0x66, 0xe6, 0xb3, 0x73, 0x2f, 0xc0, 0x93, 0x29, 0x46, 0x9a, 0xa1, 0x90, 0x71, 0xd3, 0xb9, 0xc0, 0x19, 0x06, 0x51, 0x4c, 0x6f, 0x1d, 0x26, 0xba, 0xa1, 0x4b, 0xea, 0xb0, 0x97, 0x1c, 0x8b, 0x7e, 0x61, 0x1a, 0x4f, 0x79, 0x00, 0x9d, 0x6f, 0xea, 0x77, 0x69, 0x28, 0xca, 0x25, 0x28, 0x5b, 0x0d, 0xe3, 0x64, 0x3d, 0x1a, 0x3f, 0x8c, 0x71, 
};
static const u8 rsa_oaep_73_CRT_q[] = {
0x06, 0xbc, 0x1e, 0x50, 0xe9, 0x6c, 0x02, 0xbf, 0x63, 0x6e, 0x9e, 0xea, 0x8b, 0x89, 0x9b, 0xbe, 0xbf, 0x76, 0x51, 0xde, 0x77, 0xdd, 0x47, 0x4c, 0x3e, 0x9b, 0xc2, 0x3b, 0xad, 0x81, 0x82, 0xb6, 0x19, 0x04, 0xc7, 0xd9, 0x7d, 0xfb, 0xeb, 0xfb, 0x1e, 0x00, 0x10, 0x88, 0x78, 0xb6, 0xe6, 0x7e, 0x41, 0x53, 0x91, 0xd6, 0x79, 0x42, 0xc2, 0xb2, 0xbf, 0x9b, 0x44, 0x35, 0xf8, 0x8b, 0x0c, 0xb0, 0x23, 
};
static const u8 rsa_oaep_73_CRT_dP[] = {
0x03, 0xbc, 0x7e, 0xa7, 0xf0, 0xaa, 0xb1, 0x43, 0xab, 0xc6, 0xce, 0x8b, 0x97, 0x11, 0x86, 0x36, 0xa3, 0x01, 0x72, 0xe4, 0xcf, 0xe0, 0x2c, 0x8f, 0xa0, 0xdd, 0xa3, 0xb7, 0xba, 0xaf, 0x90, 0xf8, 0x09, 0x29, 0x82, 0x98, 0x55, 0x25, 0xf4, 0x88, 0xbd, 0xfc, 0xb4, 0xbd, 0x72, 0x6e, 0x22, 0x63, 0x9a, 0xc6, 0x4a, 0x30, 0x92, 0xab, 0x7f, 0xfc, 0xbf, 0x1d, 0x53, 0x34, 0xcf, 0xa5, 0x0b, 0x5b, 0xf1, 
};
static const u8 rsa_oaep_73_CRT_dQ[] = {
0x02, 0x62, 0xa6, 0xaa, 0x29, 0xc2, 0xa3, 0xc6, 0x7d, 0xc5, 0x34, 0x6c, 0x06, 0x38, 0x1a, 0xfd, 0x98, 0x7a, 0xa3, 0xcc, 0x93, 0xcf, 0xbf, 0xec, 0xf5, 0x4f, 0xdd, 0x9f, 0x9d, 0x78, 0x7d, 0x7f, 0x59, 0xa5, 0x23, 0xd3, 0x98, 0x97, 0x9d, 0xa1, 0x37, 0xa2, 0xf6, 0x38, 0x1f, 0xe9, 0x48, 0x01, 0xf7, 0xc9, 0x4d, 0xa2, 0x15, 0x18, 0xdc, 0x34, 0xcb, 0x40, 0x87, 0x0c, 0x46, 0x97, 0x99, 0x4a, 0xd9, 
};
static const u8 rsa_oaep_73_CRT_qInv[] = {
0x64, 0x9d, 0x4c, 0x17, 0xb6, 0xee, 0x17, 0x21, 0xe7, 0x72, 0xd0, 0x38, 0x9a, 0x55, 0x9c, 0x3d, 0x3c, 0xdf, 0x95, 0x50, 0xd4, 0x57, 0xc4, 0x6b, 0x03, 0x7b, 0x74, 0x64, 0x1b, 0x1d, 0x52, 0x16, 0x6a, 0xf8, 0xa2, 0x13, 0xc8, 0x39, 0x62, 0x06, 0xcd, 0xfb, 0xa4, 0x42, 0x2f, 0x18, 0xd6, 0xf6, 0x1d, 0xbc, 0xb5, 0xd2, 0x14, 0xc9, 0x71, 0xbf, 0x48, 0x2a, 0xeb, 0x97, 0x6a, 0x73, 0x70, 0xc2, 
};


static const rsa_test test_rsa_oaep_73_CRT = {
	.name = "rsa_oaep_73_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_73_CRT_n,
	.nlen = sizeof(rsa_oaep_73_CRT_n),
	.d = (const u8*)&rsa_oaep_73_CRT_d,
	.dlen = sizeof(rsa_oaep_73_CRT_d),
	.e = (const u8*)&rsa_oaep_73_CRT_e,
	.elen = sizeof(rsa_oaep_73_CRT_e),
	.p = (const u8*)&rsa_oaep_73_CRT_p,
	.plen = sizeof(rsa_oaep_73_CRT_p),
	.q = (const u8*)&rsa_oaep_73_CRT_q,
	.qlen = sizeof(rsa_oaep_73_CRT_q),
	.dP = (const u8*)&rsa_oaep_73_CRT_dP,
	.dPlen = sizeof(rsa_oaep_73_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_73_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_73_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_73_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_73_CRT_qInv),
	.m = (const u8*)&rsa_oaep_73_CRT_m,
	.mlen = sizeof(rsa_oaep_73_CRT_m),
	.res = (const u8*)&rsa_oaep_73_CRT_res,
	.reslen = sizeof(rsa_oaep_73_CRT_res),
	.salt = (const u8*)&rsa_oaep_73_CRT_salt,
	.saltlen = sizeof(rsa_oaep_73_CRT_salt),
};
static const u8 rsa_oaep_74_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_74_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_74_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_74_m[] = {
0x1d, 0x9b, 0x2e, 0x22, 0x23, 0xd9, 0xbc, 0x13, 0xbf, 0xb9, 0xf1, 0x62, 0xce, 0x73, 0x5d, 0xb4, 0x8b, 0xa7, 0xc6, 0x8f, 0x68, 0x22, 0xa0, 0xa1, 0xa7, 0xb6, 0xae, 0x16, 0x58, 0x34, 0xe7, 
};
static const u8 rsa_oaep_74_res[] = {
0x10, 0x52, 0xed, 0x39, 0x7b, 0x2e, 0x01, 0xe1, 0xd0, 0xee, 0x1c, 0x50, 0xbf, 0x24, 0x36, 0x3f, 0x95, 0xe5, 0x04, 0xf4, 0xa0, 0x34, 0x34, 0xa0, 0x8f, 0xd8, 0x22, 0x57, 0x4e, 0xd6, 0xb9, 0x73, 0x6e, 0xdb, 0xb5, 0xf3, 0x90, 0xdb, 0x10, 0x32, 0x14, 0x79, 0xa8, 0xa1, 0x39, 0x35, 0x0e, 0x2b, 0xd4, 0x97, 0x7c, 0x37, 0x78, 0xef, 0x33, 0x1f, 0x3e, 0x78, 0xae, 0x11, 0x8b, 0x26, 0x84, 0x51, 0xf2, 0x0a, 0x2f, 0x01, 0xd4, 0x71, 0xf5, 0xd5, 0x3c, 0x56, 0x69, 0x37, 0x17, 0x1b, 0x2d, 0xbc, 0x2d, 0x4b, 0xde, 0x45, 0x9a, 0x57, 0x99, 0xf0, 0x37, 0x2d, 0x65, 0x74, 0x23, 0x9b, 0x23, 0x23, 0xd2, 0x45, 0xd0, 0xbb, 0x81, 0xc2, 0x86, 0xb6, 0x3c, 0x89, 0xa3, 0x61, 0x01, 0x73, 0x37, 0xe4, 0x90, 0x2f, 0x88, 0xa4, 0x67, 0xf4, 0xc7, 0xf2, 0x44, 0xbf, 0xd5, 0xab, 0x46, 0x43, 0x7f, 0xf3, 0xb6, 
};
static const u8 rsa_oaep_74_salt[] = {
0x3a, 0x9c, 0x3c, 0xec, 0x7b, 0x84, 0xf9, 0xbd, 0x3a, 0xde, 0xcb, 0xc6, 0x73, 0xec, 0x99, 0xd5, 0x4b, 0x22, 0xbc, 0x9b, 
};


static const rsa_test test_rsa_oaep_74 = {
	.name = "rsa_oaep_74",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_74_n,
	.nlen = sizeof(rsa_oaep_74_n),
	.d = (const u8*)&rsa_oaep_74_d,
	.dlen = sizeof(rsa_oaep_74_d),
	.e = (const u8*)&rsa_oaep_74_e,
	.elen = sizeof(rsa_oaep_74_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_74_m,
	.mlen = sizeof(rsa_oaep_74_m),
	.res = (const u8*)&rsa_oaep_74_res,
	.reslen = sizeof(rsa_oaep_74_res),
	.salt = (const u8*)&rsa_oaep_74_salt,
	.saltlen = sizeof(rsa_oaep_74_salt),
};
static const u8 rsa_oaep_75_CRT_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_75_CRT_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_75_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_75_CRT_m[] = {
0x1d, 0x9b, 0x2e, 0x22, 0x23, 0xd9, 0xbc, 0x13, 0xbf, 0xb9, 0xf1, 0x62, 0xce, 0x73, 0x5d, 0xb4, 0x8b, 0xa7, 0xc6, 0x8f, 0x68, 0x22, 0xa0, 0xa1, 0xa7, 0xb6, 0xae, 0x16, 0x58, 0x34, 0xe7, 
};
static const u8 rsa_oaep_75_CRT_res[] = {
0x10, 0x52, 0xed, 0x39, 0x7b, 0x2e, 0x01, 0xe1, 0xd0, 0xee, 0x1c, 0x50, 0xbf, 0x24, 0x36, 0x3f, 0x95, 0xe5, 0x04, 0xf4, 0xa0, 0x34, 0x34, 0xa0, 0x8f, 0xd8, 0x22, 0x57, 0x4e, 0xd6, 0xb9, 0x73, 0x6e, 0xdb, 0xb5, 0xf3, 0x90, 0xdb, 0x10, 0x32, 0x14, 0x79, 0xa8, 0xa1, 0x39, 0x35, 0x0e, 0x2b, 0xd4, 0x97, 0x7c, 0x37, 0x78, 0xef, 0x33, 0x1f, 0x3e, 0x78, 0xae, 0x11, 0x8b, 0x26, 0x84, 0x51, 0xf2, 0x0a, 0x2f, 0x01, 0xd4, 0x71, 0xf5, 0xd5, 0x3c, 0x56, 0x69, 0x37, 0x17, 0x1b, 0x2d, 0xbc, 0x2d, 0x4b, 0xde, 0x45, 0x9a, 0x57, 0x99, 0xf0, 0x37, 0x2d, 0x65, 0x74, 0x23, 0x9b, 0x23, 0x23, 0xd2, 0x45, 0xd0, 0xbb, 0x81, 0xc2, 0x86, 0xb6, 0x3c, 0x89, 0xa3, 0x61, 0x01, 0x73, 0x37, 0xe4, 0x90, 0x2f, 0x88, 0xa4, 0x67, 0xf4, 0xc7, 0xf2, 0x44, 0xbf, 0xd5, 0xab, 0x46, 0x43, 0x7f, 0xf3, 0xb6, 
};
static const u8 rsa_oaep_75_CRT_salt[] = {
0x3a, 0x9c, 0x3c, 0xec, 0x7b, 0x84, 0xf9, 0xbd, 0x3a, 0xde, 0xcb, 0xc6, 0x73, 0xec, 0x99, 0xd5, 0x4b, 0x22, 0xbc, 0x9b, 
};
static const u8 rsa_oaep_75_CRT_p[] = {
0x07, 0x49, 0x26, 0x2c, 0x11, 0x1c, 0xd4, 0x70, 0xec, 0x25, 0x66, 0xe6, 0xb3, 0x73, 0x2f, 0xc0, 0x93, 0x29, 0x46, 0x9a, 0xa1, 0x90, 0x71, 0xd3, 0xb9, 0xc0, 0x19, 0x06, 0x51, 0x4c, 0x6f, 0x1d, 0x26, 0xba, 0xa1, 0x4b, 0xea, 0xb0, 0x97, 0x1c, 0x8b, 0x7e, 0x61, 0x1a, 0x4f, 0x79, 0x00, 0x9d, 0x6f, 0xea, 0x77, 0x69, 0x28, 0xca, 0x25, 0x28, 0x5b, 0x0d, 0xe3, 0x64, 0x3d, 0x1a, 0x3f, 0x8c, 0x71, 
};
static const u8 rsa_oaep_75_CRT_q[] = {
0x06, 0xbc, 0x1e, 0x50, 0xe9, 0x6c, 0x02, 0xbf, 0x63, 0x6e, 0x9e, 0xea, 0x8b, 0x89, 0x9b, 0xbe, 0xbf, 0x76, 0x51, 0xde, 0x77, 0xdd, 0x47, 0x4c, 0x3e, 0x9b, 0xc2, 0x3b, 0xad, 0x81, 0x82, 0xb6, 0x19, 0x04, 0xc7, 0xd9, 0x7d, 0xfb, 0xeb, 0xfb, 0x1e, 0x00, 0x10, 0x88, 0x78, 0xb6, 0xe6, 0x7e, 0x41, 0x53, 0x91, 0xd6, 0x79, 0x42, 0xc2, 0xb2, 0xbf, 0x9b, 0x44, 0x35, 0xf8, 0x8b, 0x0c, 0xb0, 0x23, 
};
static const u8 rsa_oaep_75_CRT_dP[] = {
0x03, 0xbc, 0x7e, 0xa7, 0xf0, 0xaa, 0xb1, 0x43, 0xab, 0xc6, 0xce, 0x8b, 0x97, 0x11, 0x86, 0x36, 0xa3, 0x01, 0x72, 0xe4, 0xcf, 0xe0, 0x2c, 0x8f, 0xa0, 0xdd, 0xa3, 0xb7, 0xba, 0xaf, 0x90, 0xf8, 0x09, 0x29, 0x82, 0x98, 0x55, 0x25, 0xf4, 0x88, 0xbd, 0xfc, 0xb4, 0xbd, 0x72, 0x6e, 0x22, 0x63, 0x9a, 0xc6, 0x4a, 0x30, 0x92, 0xab, 0x7f, 0xfc, 0xbf, 0x1d, 0x53, 0x34, 0xcf, 0xa5, 0x0b, 0x5b, 0xf1, 
};
static const u8 rsa_oaep_75_CRT_dQ[] = {
0x02, 0x62, 0xa6, 0xaa, 0x29, 0xc2, 0xa3, 0xc6, 0x7d, 0xc5, 0x34, 0x6c, 0x06, 0x38, 0x1a, 0xfd, 0x98, 0x7a, 0xa3, 0xcc, 0x93, 0xcf, 0xbf, 0xec, 0xf5, 0x4f, 0xdd, 0x9f, 0x9d, 0x78, 0x7d, 0x7f, 0x59, 0xa5, 0x23, 0xd3, 0x98, 0x97, 0x9d, 0xa1, 0x37, 0xa2, 0xf6, 0x38, 0x1f, 0xe9, 0x48, 0x01, 0xf7, 0xc9, 0x4d, 0xa2, 0x15, 0x18, 0xdc, 0x34, 0xcb, 0x40, 0x87, 0x0c, 0x46, 0x97, 0x99, 0x4a, 0xd9, 
};
static const u8 rsa_oaep_75_CRT_qInv[] = {
0x64, 0x9d, 0x4c, 0x17, 0xb6, 0xee, 0x17, 0x21, 0xe7, 0x72, 0xd0, 0x38, 0x9a, 0x55, 0x9c, 0x3d, 0x3c, 0xdf, 0x95, 0x50, 0xd4, 0x57, 0xc4, 0x6b, 0x03, 0x7b, 0x74, 0x64, 0x1b, 0x1d, 0x52, 0x16, 0x6a, 0xf8, 0xa2, 0x13, 0xc8, 0x39, 0x62, 0x06, 0xcd, 0xfb, 0xa4, 0x42, 0x2f, 0x18, 0xd6, 0xf6, 0x1d, 0xbc, 0xb5, 0xd2, 0x14, 0xc9, 0x71, 0xbf, 0x48, 0x2a, 0xeb, 0x97, 0x6a, 0x73, 0x70, 0xc2, 
};


static const rsa_test test_rsa_oaep_75_CRT = {
	.name = "rsa_oaep_75_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_75_CRT_n,
	.nlen = sizeof(rsa_oaep_75_CRT_n),
	.d = (const u8*)&rsa_oaep_75_CRT_d,
	.dlen = sizeof(rsa_oaep_75_CRT_d),
	.e = (const u8*)&rsa_oaep_75_CRT_e,
	.elen = sizeof(rsa_oaep_75_CRT_e),
	.p = (const u8*)&rsa_oaep_75_CRT_p,
	.plen = sizeof(rsa_oaep_75_CRT_p),
	.q = (const u8*)&rsa_oaep_75_CRT_q,
	.qlen = sizeof(rsa_oaep_75_CRT_q),
	.dP = (const u8*)&rsa_oaep_75_CRT_dP,
	.dPlen = sizeof(rsa_oaep_75_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_75_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_75_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_75_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_75_CRT_qInv),
	.m = (const u8*)&rsa_oaep_75_CRT_m,
	.mlen = sizeof(rsa_oaep_75_CRT_m),
	.res = (const u8*)&rsa_oaep_75_CRT_res,
	.reslen = sizeof(rsa_oaep_75_CRT_res),
	.salt = (const u8*)&rsa_oaep_75_CRT_salt,
	.saltlen = sizeof(rsa_oaep_75_CRT_salt),
};
static const u8 rsa_oaep_76_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_76_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_76_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_76_m[] = {
0xd9, 0x76, 0xfc, 
};
static const u8 rsa_oaep_76_res[] = {
0x21, 0x55, 0xcd, 0x84, 0x3f, 0xf2, 0x4a, 0x4e, 0xe8, 0xba, 0xdb, 0x76, 0x94, 0x26, 0x00, 0x28, 0xa4, 0x90, 0x81, 0x3b, 0xa8, 0xb3, 0x69, 0xa4, 0xcb, 0xf1, 0x06, 0xec, 0x14, 0x8e, 0x52, 0x98, 0x70, 0x7f, 0x59, 0x65, 0xbe, 0x7d, 0x10, 0x1c, 0x10, 0x49, 0xea, 0x85, 0x84, 0xc2, 0x4c, 0xd6, 0x34, 0x55, 0xad, 0x9c, 0x10, 0x4d, 0x68, 0x62, 0x82, 0xd3, 0xfb, 0x80, 0x3a, 0x4c, 0x11, 0xc1, 0xc2, 0xe9, 0xb9, 0x1c, 0x71, 0x78, 0x80, 0x1d, 0x1b, 0x66, 0x40, 0xf0, 0x03, 0xf5, 0x72, 0x8d, 0xf0, 0x07, 0xb8, 0xa4, 0xcc, 0xc9, 0x2b, 0xce, 0x05, 0xe4, 0x1a, 0x27, 0x27, 0x8d, 0x7c, 0x85, 0x01, 0x8c, 0x52, 0x41, 0x43, 0x13, 0xa5, 0x07, 0x77, 0x89, 0x00, 0x1d, 0x4f, 0x01, 0x91, 0x0b, 0x72, 0xaa, 0xd0, 0x5d, 0x22, 0x0a, 0xa1, 0x4a, 0x58, 0x73, 0x3a, 0x74, 0x89, 0xbc, 0x54, 0x55, 0x6b, 
};
static const u8 rsa_oaep_76_salt[] = {
0x76, 0xa7, 0x5e, 0x5b, 0x61, 0x57, 0xa5, 0x56, 0xcf, 0x88, 0x84, 0xbb, 0x2e, 0x45, 0xc2, 0x93, 0xdd, 0x54, 0x5c, 0xf5, 
};


static const rsa_test test_rsa_oaep_76 = {
	.name = "rsa_oaep_76",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_76_n,
	.nlen = sizeof(rsa_oaep_76_n),
	.d = (const u8*)&rsa_oaep_76_d,
	.dlen = sizeof(rsa_oaep_76_d),
	.e = (const u8*)&rsa_oaep_76_e,
	.elen = sizeof(rsa_oaep_76_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_76_m,
	.mlen = sizeof(rsa_oaep_76_m),
	.res = (const u8*)&rsa_oaep_76_res,
	.reslen = sizeof(rsa_oaep_76_res),
	.salt = (const u8*)&rsa_oaep_76_salt,
	.saltlen = sizeof(rsa_oaep_76_salt),
};
static const u8 rsa_oaep_77_CRT_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_77_CRT_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_77_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_77_CRT_m[] = {
0xd9, 0x76, 0xfc, 
};
static const u8 rsa_oaep_77_CRT_res[] = {
0x21, 0x55, 0xcd, 0x84, 0x3f, 0xf2, 0x4a, 0x4e, 0xe8, 0xba, 0xdb, 0x76, 0x94, 0x26, 0x00, 0x28, 0xa4, 0x90, 0x81, 0x3b, 0xa8, 0xb3, 0x69, 0xa4, 0xcb, 0xf1, 0x06, 0xec, 0x14, 0x8e, 0x52, 0x98, 0x70, 0x7f, 0x59, 0x65, 0xbe, 0x7d, 0x10, 0x1c, 0x10, 0x49, 0xea, 0x85, 0x84, 0xc2, 0x4c, 0xd6, 0x34, 0x55, 0xad, 0x9c, 0x10, 0x4d, 0x68, 0x62, 0x82, 0xd3, 0xfb, 0x80, 0x3a, 0x4c, 0x11, 0xc1, 0xc2, 0xe9, 0xb9, 0x1c, 0x71, 0x78, 0x80, 0x1d, 0x1b, 0x66, 0x40, 0xf0, 0x03, 0xf5, 0x72, 0x8d, 0xf0, 0x07, 0xb8, 0xa4, 0xcc, 0xc9, 0x2b, 0xce, 0x05, 0xe4, 0x1a, 0x27, 0x27, 0x8d, 0x7c, 0x85, 0x01, 0x8c, 0x52, 0x41, 0x43, 0x13, 0xa5, 0x07, 0x77, 0x89, 0x00, 0x1d, 0x4f, 0x01, 0x91, 0x0b, 0x72, 0xaa, 0xd0, 0x5d, 0x22, 0x0a, 0xa1, 0x4a, 0x58, 0x73, 0x3a, 0x74, 0x89, 0xbc, 0x54, 0x55, 0x6b, 
};
static const u8 rsa_oaep_77_CRT_salt[] = {
0x76, 0xa7, 0x5e, 0x5b, 0x61, 0x57, 0xa5, 0x56, 0xcf, 0x88, 0x84, 0xbb, 0x2e, 0x45, 0xc2, 0x93, 0xdd, 0x54, 0x5c, 0xf5, 
};
static const u8 rsa_oaep_77_CRT_p[] = {
0x07, 0x49, 0x26, 0x2c, 0x11, 0x1c, 0xd4, 0x70, 0xec, 0x25, 0x66, 0xe6, 0xb3, 0x73, 0x2f, 0xc0, 0x93, 0x29, 0x46, 0x9a, 0xa1, 0x90, 0x71, 0xd3, 0xb9, 0xc0, 0x19, 0x06, 0x51, 0x4c, 0x6f, 0x1d, 0x26, 0xba, 0xa1, 0x4b, 0xea, 0xb0, 0x97, 0x1c, 0x8b, 0x7e, 0x61, 0x1a, 0x4f, 0x79, 0x00, 0x9d, 0x6f, 0xea, 0x77, 0x69, 0x28, 0xca, 0x25, 0x28, 0x5b, 0x0d, 0xe3, 0x64, 0x3d, 0x1a, 0x3f, 0x8c, 0x71, 
};
static const u8 rsa_oaep_77_CRT_q[] = {
0x06, 0xbc, 0x1e, 0x50, 0xe9, 0x6c, 0x02, 0xbf, 0x63, 0x6e, 0x9e, 0xea, 0x8b, 0x89, 0x9b, 0xbe, 0xbf, 0x76, 0x51, 0xde, 0x77, 0xdd, 0x47, 0x4c, 0x3e, 0x9b, 0xc2, 0x3b, 0xad, 0x81, 0x82, 0xb6, 0x19, 0x04, 0xc7, 0xd9, 0x7d, 0xfb, 0xeb, 0xfb, 0x1e, 0x00, 0x10, 0x88, 0x78, 0xb6, 0xe6, 0x7e, 0x41, 0x53, 0x91, 0xd6, 0x79, 0x42, 0xc2, 0xb2, 0xbf, 0x9b, 0x44, 0x35, 0xf8, 0x8b, 0x0c, 0xb0, 0x23, 
};
static const u8 rsa_oaep_77_CRT_dP[] = {
0x03, 0xbc, 0x7e, 0xa7, 0xf0, 0xaa, 0xb1, 0x43, 0xab, 0xc6, 0xce, 0x8b, 0x97, 0x11, 0x86, 0x36, 0xa3, 0x01, 0x72, 0xe4, 0xcf, 0xe0, 0x2c, 0x8f, 0xa0, 0xdd, 0xa3, 0xb7, 0xba, 0xaf, 0x90, 0xf8, 0x09, 0x29, 0x82, 0x98, 0x55, 0x25, 0xf4, 0x88, 0xbd, 0xfc, 0xb4, 0xbd, 0x72, 0x6e, 0x22, 0x63, 0x9a, 0xc6, 0x4a, 0x30, 0x92, 0xab, 0x7f, 0xfc, 0xbf, 0x1d, 0x53, 0x34, 0xcf, 0xa5, 0x0b, 0x5b, 0xf1, 
};
static const u8 rsa_oaep_77_CRT_dQ[] = {
0x02, 0x62, 0xa6, 0xaa, 0x29, 0xc2, 0xa3, 0xc6, 0x7d, 0xc5, 0x34, 0x6c, 0x06, 0x38, 0x1a, 0xfd, 0x98, 0x7a, 0xa3, 0xcc, 0x93, 0xcf, 0xbf, 0xec, 0xf5, 0x4f, 0xdd, 0x9f, 0x9d, 0x78, 0x7d, 0x7f, 0x59, 0xa5, 0x23, 0xd3, 0x98, 0x97, 0x9d, 0xa1, 0x37, 0xa2, 0xf6, 0x38, 0x1f, 0xe9, 0x48, 0x01, 0xf7, 0xc9, 0x4d, 0xa2, 0x15, 0x18, 0xdc, 0x34, 0xcb, 0x40, 0x87, 0x0c, 0x46, 0x97, 0x99, 0x4a, 0xd9, 
};
static const u8 rsa_oaep_77_CRT_qInv[] = {
0x64, 0x9d, 0x4c, 0x17, 0xb6, 0xee, 0x17, 0x21, 0xe7, 0x72, 0xd0, 0x38, 0x9a, 0x55, 0x9c, 0x3d, 0x3c, 0xdf, 0x95, 0x50, 0xd4, 0x57, 0xc4, 0x6b, 0x03, 0x7b, 0x74, 0x64, 0x1b, 0x1d, 0x52, 0x16, 0x6a, 0xf8, 0xa2, 0x13, 0xc8, 0x39, 0x62, 0x06, 0xcd, 0xfb, 0xa4, 0x42, 0x2f, 0x18, 0xd6, 0xf6, 0x1d, 0xbc, 0xb5, 0xd2, 0x14, 0xc9, 0x71, 0xbf, 0x48, 0x2a, 0xeb, 0x97, 0x6a, 0x73, 0x70, 0xc2, 
};


static const rsa_test test_rsa_oaep_77_CRT = {
	.name = "rsa_oaep_77_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_77_CRT_n,
	.nlen = sizeof(rsa_oaep_77_CRT_n),
	.d = (const u8*)&rsa_oaep_77_CRT_d,
	.dlen = sizeof(rsa_oaep_77_CRT_d),
	.e = (const u8*)&rsa_oaep_77_CRT_e,
	.elen = sizeof(rsa_oaep_77_CRT_e),
	.p = (const u8*)&rsa_oaep_77_CRT_p,
	.plen = sizeof(rsa_oaep_77_CRT_p),
	.q = (const u8*)&rsa_oaep_77_CRT_q,
	.qlen = sizeof(rsa_oaep_77_CRT_q),
	.dP = (const u8*)&rsa_oaep_77_CRT_dP,
	.dPlen = sizeof(rsa_oaep_77_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_77_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_77_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_77_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_77_CRT_qInv),
	.m = (const u8*)&rsa_oaep_77_CRT_m,
	.mlen = sizeof(rsa_oaep_77_CRT_m),
	.res = (const u8*)&rsa_oaep_77_CRT_res,
	.reslen = sizeof(rsa_oaep_77_CRT_res),
	.salt = (const u8*)&rsa_oaep_77_CRT_salt,
	.saltlen = sizeof(rsa_oaep_77_CRT_salt),
};
static const u8 rsa_oaep_78_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_78_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_78_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_78_m[] = {
0xd4, 0x73, 0x86, 0x23, 0xdf, 0x22, 0x3a, 0xa4, 0x38, 0x43, 0xdf, 0x84, 0x67, 0x53, 0x4c, 0x41, 0xd0, 0x13, 0xe0, 0xc8, 0x03, 0xc6, 0x24, 0xe2, 0x63, 0x66, 0x6b, 0x23, 0x9b, 0xde, 0x40, 0xa5, 0xf2, 0x9a, 0xeb, 0x8d, 0xe7, 0x9e, 0x3d, 0xaa, 0x61, 0xdd, 0x03, 0x70, 0xf4, 0x9b, 0xd4, 0xb0, 0x13, 0x83, 0x4b, 0x98, 0x21, 0x2a, 0xef, 0x6b, 0x1c, 0x5e, 0xe3, 0x73, 0xb3, 0xcb, 
};
static const u8 rsa_oaep_78_res[] = {
0x0a, 0xb1, 0x4c, 0x37, 0x3a, 0xeb, 0x7d, 0x43, 0x28, 0xd0, 0xaa, 0xad, 0x8c, 0x09, 0x4d, 0x88, 0xb9, 0xeb, 0x09, 0x8b, 0x95, 0xf2, 0x10, 0x54, 0xa2, 0x90, 0x82, 0x52, 0x2b, 0xe7, 0xc2, 0x7a, 0x31, 0x28, 0x78, 0xb6, 0x37, 0x91, 0x7e, 0x3d, 0x81, 0x9e, 0x6c, 0x3c, 0x56, 0x8d, 0xb5, 0xd8, 0x43, 0x80, 0x2b, 0x06, 0xd5, 0x1d, 0x9e, 0x98, 0xa2, 0xbe, 0x0b, 0xf4, 0x0c, 0x03, 0x14, 0x23, 0xb0, 0x0e, 0xdf, 0xbf, 0xf8, 0x32, 0x0e, 0xfb, 0x91, 0x71, 0xbd, 0x20, 0x44, 0x65, 0x3a, 0x4c, 0xb9, 0xc5, 0x12, 0x2f, 0x6c, 0x65, 0xe8, 0x3c, 0xda, 0x2e, 0xc3, 0xc1, 0x26, 0x02, 0x7a, 0x9c, 0x1a, 0x56, 0xba, 0x87, 0x4d, 0x0f, 0xea, 0x23, 0xf3, 0x80, 0xb8, 0x2c, 0xf2, 0x40, 0xb8, 0xcf, 0x54, 0x00, 0x04, 0x75, 0x8c, 0x4c, 0x77, 0xd9, 0x34, 0x15, 0x7a, 0x74, 0xf3, 0xfc, 0x12, 0xbf, 0xac, 
};
static const u8 rsa_oaep_78_salt[] = {
0x78, 0x66, 0x31, 0x4a, 0x6a, 0xd6, 0xf2, 0xb2, 0x50, 0xa3, 0x59, 0x41, 0xdb, 0x28, 0xf5, 0x86, 0x4b, 0x58, 0x58, 0x59, 
};


static const rsa_test test_rsa_oaep_78 = {
	.name = "rsa_oaep_78",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_78_n,
	.nlen = sizeof(rsa_oaep_78_n),
	.d = (const u8*)&rsa_oaep_78_d,
	.dlen = sizeof(rsa_oaep_78_d),
	.e = (const u8*)&rsa_oaep_78_e,
	.elen = sizeof(rsa_oaep_78_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_78_m,
	.mlen = sizeof(rsa_oaep_78_m),
	.res = (const u8*)&rsa_oaep_78_res,
	.reslen = sizeof(rsa_oaep_78_res),
	.salt = (const u8*)&rsa_oaep_78_salt,
	.saltlen = sizeof(rsa_oaep_78_salt),
};
static const u8 rsa_oaep_79_CRT_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_79_CRT_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_79_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_79_CRT_m[] = {
0xd4, 0x73, 0x86, 0x23, 0xdf, 0x22, 0x3a, 0xa4, 0x38, 0x43, 0xdf, 0x84, 0x67, 0x53, 0x4c, 0x41, 0xd0, 0x13, 0xe0, 0xc8, 0x03, 0xc6, 0x24, 0xe2, 0x63, 0x66, 0x6b, 0x23, 0x9b, 0xde, 0x40, 0xa5, 0xf2, 0x9a, 0xeb, 0x8d, 0xe7, 0x9e, 0x3d, 0xaa, 0x61, 0xdd, 0x03, 0x70, 0xf4, 0x9b, 0xd4, 0xb0, 0x13, 0x83, 0x4b, 0x98, 0x21, 0x2a, 0xef, 0x6b, 0x1c, 0x5e, 0xe3, 0x73, 0xb3, 0xcb, 
};
static const u8 rsa_oaep_79_CRT_res[] = {
0x0a, 0xb1, 0x4c, 0x37, 0x3a, 0xeb, 0x7d, 0x43, 0x28, 0xd0, 0xaa, 0xad, 0x8c, 0x09, 0x4d, 0x88, 0xb9, 0xeb, 0x09, 0x8b, 0x95, 0xf2, 0x10, 0x54, 0xa2, 0x90, 0x82, 0x52, 0x2b, 0xe7, 0xc2, 0x7a, 0x31, 0x28, 0x78, 0xb6, 0x37, 0x91, 0x7e, 0x3d, 0x81, 0x9e, 0x6c, 0x3c, 0x56, 0x8d, 0xb5, 0xd8, 0x43, 0x80, 0x2b, 0x06, 0xd5, 0x1d, 0x9e, 0x98, 0xa2, 0xbe, 0x0b, 0xf4, 0x0c, 0x03, 0x14, 0x23, 0xb0, 0x0e, 0xdf, 0xbf, 0xf8, 0x32, 0x0e, 0xfb, 0x91, 0x71, 0xbd, 0x20, 0x44, 0x65, 0x3a, 0x4c, 0xb9, 0xc5, 0x12, 0x2f, 0x6c, 0x65, 0xe8, 0x3c, 0xda, 0x2e, 0xc3, 0xc1, 0x26, 0x02, 0x7a, 0x9c, 0x1a, 0x56, 0xba, 0x87, 0x4d, 0x0f, 0xea, 0x23, 0xf3, 0x80, 0xb8, 0x2c, 0xf2, 0x40, 0xb8, 0xcf, 0x54, 0x00, 0x04, 0x75, 0x8c, 0x4c, 0x77, 0xd9, 0x34, 0x15, 0x7a, 0x74, 0xf3, 0xfc, 0x12, 0xbf, 0xac, 
};
static const u8 rsa_oaep_79_CRT_salt[] = {
0x78, 0x66, 0x31, 0x4a, 0x6a, 0xd6, 0xf2, 0xb2, 0x50, 0xa3, 0x59, 0x41, 0xdb, 0x28, 0xf5, 0x86, 0x4b, 0x58, 0x58, 0x59, 
};
static const u8 rsa_oaep_79_CRT_p[] = {
0x07, 0x49, 0x26, 0x2c, 0x11, 0x1c, 0xd4, 0x70, 0xec, 0x25, 0x66, 0xe6, 0xb3, 0x73, 0x2f, 0xc0, 0x93, 0x29, 0x46, 0x9a, 0xa1, 0x90, 0x71, 0xd3, 0xb9, 0xc0, 0x19, 0x06, 0x51, 0x4c, 0x6f, 0x1d, 0x26, 0xba, 0xa1, 0x4b, 0xea, 0xb0, 0x97, 0x1c, 0x8b, 0x7e, 0x61, 0x1a, 0x4f, 0x79, 0x00, 0x9d, 0x6f, 0xea, 0x77, 0x69, 0x28, 0xca, 0x25, 0x28, 0x5b, 0x0d, 0xe3, 0x64, 0x3d, 0x1a, 0x3f, 0x8c, 0x71, 
};
static const u8 rsa_oaep_79_CRT_q[] = {
0x06, 0xbc, 0x1e, 0x50, 0xe9, 0x6c, 0x02, 0xbf, 0x63, 0x6e, 0x9e, 0xea, 0x8b, 0x89, 0x9b, 0xbe, 0xbf, 0x76, 0x51, 0xde, 0x77, 0xdd, 0x47, 0x4c, 0x3e, 0x9b, 0xc2, 0x3b, 0xad, 0x81, 0x82, 0xb6, 0x19, 0x04, 0xc7, 0xd9, 0x7d, 0xfb, 0xeb, 0xfb, 0x1e, 0x00, 0x10, 0x88, 0x78, 0xb6, 0xe6, 0x7e, 0x41, 0x53, 0x91, 0xd6, 0x79, 0x42, 0xc2, 0xb2, 0xbf, 0x9b, 0x44, 0x35, 0xf8, 0x8b, 0x0c, 0xb0, 0x23, 
};
static const u8 rsa_oaep_79_CRT_dP[] = {
0x03, 0xbc, 0x7e, 0xa7, 0xf0, 0xaa, 0xb1, 0x43, 0xab, 0xc6, 0xce, 0x8b, 0x97, 0x11, 0x86, 0x36, 0xa3, 0x01, 0x72, 0xe4, 0xcf, 0xe0, 0x2c, 0x8f, 0xa0, 0xdd, 0xa3, 0xb7, 0xba, 0xaf, 0x90, 0xf8, 0x09, 0x29, 0x82, 0x98, 0x55, 0x25, 0xf4, 0x88, 0xbd, 0xfc, 0xb4, 0xbd, 0x72, 0x6e, 0x22, 0x63, 0x9a, 0xc6, 0x4a, 0x30, 0x92, 0xab, 0x7f, 0xfc, 0xbf, 0x1d, 0x53, 0x34, 0xcf, 0xa5, 0x0b, 0x5b, 0xf1, 
};
static const u8 rsa_oaep_79_CRT_dQ[] = {
0x02, 0x62, 0xa6, 0xaa, 0x29, 0xc2, 0xa3, 0xc6, 0x7d, 0xc5, 0x34, 0x6c, 0x06, 0x38, 0x1a, 0xfd, 0x98, 0x7a, 0xa3, 0xcc, 0x93, 0xcf, 0xbf, 0xec, 0xf5, 0x4f, 0xdd, 0x9f, 0x9d, 0x78, 0x7d, 0x7f, 0x59, 0xa5, 0x23, 0xd3, 0x98, 0x97, 0x9d, 0xa1, 0x37, 0xa2, 0xf6, 0x38, 0x1f, 0xe9, 0x48, 0x01, 0xf7, 0xc9, 0x4d, 0xa2, 0x15, 0x18, 0xdc, 0x34, 0xcb, 0x40, 0x87, 0x0c, 0x46, 0x97, 0x99, 0x4a, 0xd9, 
};
static const u8 rsa_oaep_79_CRT_qInv[] = {
0x64, 0x9d, 0x4c, 0x17, 0xb6, 0xee, 0x17, 0x21, 0xe7, 0x72, 0xd0, 0x38, 0x9a, 0x55, 0x9c, 0x3d, 0x3c, 0xdf, 0x95, 0x50, 0xd4, 0x57, 0xc4, 0x6b, 0x03, 0x7b, 0x74, 0x64, 0x1b, 0x1d, 0x52, 0x16, 0x6a, 0xf8, 0xa2, 0x13, 0xc8, 0x39, 0x62, 0x06, 0xcd, 0xfb, 0xa4, 0x42, 0x2f, 0x18, 0xd6, 0xf6, 0x1d, 0xbc, 0xb5, 0xd2, 0x14, 0xc9, 0x71, 0xbf, 0x48, 0x2a, 0xeb, 0x97, 0x6a, 0x73, 0x70, 0xc2, 
};


static const rsa_test test_rsa_oaep_79_CRT = {
	.name = "rsa_oaep_79_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_79_CRT_n,
	.nlen = sizeof(rsa_oaep_79_CRT_n),
	.d = (const u8*)&rsa_oaep_79_CRT_d,
	.dlen = sizeof(rsa_oaep_79_CRT_d),
	.e = (const u8*)&rsa_oaep_79_CRT_e,
	.elen = sizeof(rsa_oaep_79_CRT_e),
	.p = (const u8*)&rsa_oaep_79_CRT_p,
	.plen = sizeof(rsa_oaep_79_CRT_p),
	.q = (const u8*)&rsa_oaep_79_CRT_q,
	.qlen = sizeof(rsa_oaep_79_CRT_q),
	.dP = (const u8*)&rsa_oaep_79_CRT_dP,
	.dPlen = sizeof(rsa_oaep_79_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_79_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_79_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_79_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_79_CRT_qInv),
	.m = (const u8*)&rsa_oaep_79_CRT_m,
	.mlen = sizeof(rsa_oaep_79_CRT_m),
	.res = (const u8*)&rsa_oaep_79_CRT_res,
	.reslen = sizeof(rsa_oaep_79_CRT_res),
	.salt = (const u8*)&rsa_oaep_79_CRT_salt,
	.saltlen = sizeof(rsa_oaep_79_CRT_salt),
};
static const u8 rsa_oaep_80_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_80_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_80_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_80_m[] = {
0xbb, 0x47, 0x23, 0x1c, 0xa5, 0xea, 0x1d, 0x3a, 0xd4, 0x6c, 0x99, 0x34, 0x5d, 0x9a, 0x8a, 0x61, 
};
static const u8 rsa_oaep_80_res[] = {
0x02, 0x83, 0x87, 0xa3, 0x18, 0x27, 0x74, 0x34, 0x79, 0x8b, 0x4d, 0x97, 0xf4, 0x60, 0x06, 0x8d, 0xf5, 0x29, 0x8f, 0xab, 0xa5, 0x04, 0x1b, 0xa1, 0x17, 0x61, 0xa1, 0xcb, 0x73, 0x16, 0xb2, 0x41, 0x84, 0x11, 0x4e, 0xc5, 0x00, 0x25, 0x7e, 0x25, 0x89, 0xed, 0x3b, 0x60, 0x7a, 0x1e, 0xbb, 0xe9, 0x7a, 0x6c, 0xc2, 0xe0, 0x2b, 0xf1, 0xb6, 0x81, 0xf4, 0x23, 0x12, 0xa3, 0x3b, 0x7a, 0x77, 0xd8, 0xe7, 0x85, 0x5c, 0x4a, 0x6d, 0xe0, 0x3e, 0x3c, 0x04, 0x64, 0x3f, 0x78, 0x6b, 0x91, 0xa2, 0x64, 0xa0, 0xd6, 0x80, 0x5e, 0x2c, 0xea, 0x91, 0xe6, 0x81, 0x77, 0xeb, 0x7a, 0x64, 0xd9, 0x25, 0x5e, 0x4f, 0x27, 0xe7, 0x13, 0xb7, 0xcc, 0xec, 0x00, 0xdc, 0x20, 0x0e, 0xbd, 0x21, 0xc2, 0xea, 0x2b, 0xb8, 0x90, 0xfe, 0xae, 0x49, 0x42, 0xdf, 0x94, 0x1d, 0xc3, 0xf9, 0x78, 0x90, 0xed, 0x34, 0x74, 0x78, 
};
static const u8 rsa_oaep_80_salt[] = {
0xb2, 0x16, 0x6e, 0xd4, 0x72, 0xd5, 0x8d, 0xb1, 0x0c, 0xab, 0x2c, 0x6b, 0x00, 0x0c, 0xcc, 0xf1, 0x0a, 0x7d, 0xc5, 0x09, 
};


static const rsa_test test_rsa_oaep_80 = {
	.name = "rsa_oaep_80",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_80_n,
	.nlen = sizeof(rsa_oaep_80_n),
	.d = (const u8*)&rsa_oaep_80_d,
	.dlen = sizeof(rsa_oaep_80_d),
	.e = (const u8*)&rsa_oaep_80_e,
	.elen = sizeof(rsa_oaep_80_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_80_m,
	.mlen = sizeof(rsa_oaep_80_m),
	.res = (const u8*)&rsa_oaep_80_res,
	.reslen = sizeof(rsa_oaep_80_res),
	.salt = (const u8*)&rsa_oaep_80_salt,
	.saltlen = sizeof(rsa_oaep_80_salt),
};
static const u8 rsa_oaep_81_CRT_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_81_CRT_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_81_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_81_CRT_m[] = {
0xbb, 0x47, 0x23, 0x1c, 0xa5, 0xea, 0x1d, 0x3a, 0xd4, 0x6c, 0x99, 0x34, 0x5d, 0x9a, 0x8a, 0x61, 
};
static const u8 rsa_oaep_81_CRT_res[] = {
0x02, 0x83, 0x87, 0xa3, 0x18, 0x27, 0x74, 0x34, 0x79, 0x8b, 0x4d, 0x97, 0xf4, 0x60, 0x06, 0x8d, 0xf5, 0x29, 0x8f, 0xab, 0xa5, 0x04, 0x1b, 0xa1, 0x17, 0x61, 0xa1, 0xcb, 0x73, 0x16, 0xb2, 0x41, 0x84, 0x11, 0x4e, 0xc5, 0x00, 0x25, 0x7e, 0x25, 0x89, 0xed, 0x3b, 0x60, 0x7a, 0x1e, 0xbb, 0xe9, 0x7a, 0x6c, 0xc2, 0xe0, 0x2b, 0xf1, 0xb6, 0x81, 0xf4, 0x23, 0x12, 0xa3, 0x3b, 0x7a, 0x77, 0xd8, 0xe7, 0x85, 0x5c, 0x4a, 0x6d, 0xe0, 0x3e, 0x3c, 0x04, 0x64, 0x3f, 0x78, 0x6b, 0x91, 0xa2, 0x64, 0xa0, 0xd6, 0x80, 0x5e, 0x2c, 0xea, 0x91, 0xe6, 0x81, 0x77, 0xeb, 0x7a, 0x64, 0xd9, 0x25, 0x5e, 0x4f, 0x27, 0xe7, 0x13, 0xb7, 0xcc, 0xec, 0x00, 0xdc, 0x20, 0x0e, 0xbd, 0x21, 0xc2, 0xea, 0x2b, 0xb8, 0x90, 0xfe, 0xae, 0x49, 0x42, 0xdf, 0x94, 0x1d, 0xc3, 0xf9, 0x78, 0x90, 0xed, 0x34, 0x74, 0x78, 
};
static const u8 rsa_oaep_81_CRT_salt[] = {
0xb2, 0x16, 0x6e, 0xd4, 0x72, 0xd5, 0x8d, 0xb1, 0x0c, 0xab, 0x2c, 0x6b, 0x00, 0x0c, 0xcc, 0xf1, 0x0a, 0x7d, 0xc5, 0x09, 
};
static const u8 rsa_oaep_81_CRT_p[] = {
0x07, 0x49, 0x26, 0x2c, 0x11, 0x1c, 0xd4, 0x70, 0xec, 0x25, 0x66, 0xe6, 0xb3, 0x73, 0x2f, 0xc0, 0x93, 0x29, 0x46, 0x9a, 0xa1, 0x90, 0x71, 0xd3, 0xb9, 0xc0, 0x19, 0x06, 0x51, 0x4c, 0x6f, 0x1d, 0x26, 0xba, 0xa1, 0x4b, 0xea, 0xb0, 0x97, 0x1c, 0x8b, 0x7e, 0x61, 0x1a, 0x4f, 0x79, 0x00, 0x9d, 0x6f, 0xea, 0x77, 0x69, 0x28, 0xca, 0x25, 0x28, 0x5b, 0x0d, 0xe3, 0x64, 0x3d, 0x1a, 0x3f, 0x8c, 0x71, 
};
static const u8 rsa_oaep_81_CRT_q[] = {
0x06, 0xbc, 0x1e, 0x50, 0xe9, 0x6c, 0x02, 0xbf, 0x63, 0x6e, 0x9e, 0xea, 0x8b, 0x89, 0x9b, 0xbe, 0xbf, 0x76, 0x51, 0xde, 0x77, 0xdd, 0x47, 0x4c, 0x3e, 0x9b, 0xc2, 0x3b, 0xad, 0x81, 0x82, 0xb6, 0x19, 0x04, 0xc7, 0xd9, 0x7d, 0xfb, 0xeb, 0xfb, 0x1e, 0x00, 0x10, 0x88, 0x78, 0xb6, 0xe6, 0x7e, 0x41, 0x53, 0x91, 0xd6, 0x79, 0x42, 0xc2, 0xb2, 0xbf, 0x9b, 0x44, 0x35, 0xf8, 0x8b, 0x0c, 0xb0, 0x23, 
};
static const u8 rsa_oaep_81_CRT_dP[] = {
0x03, 0xbc, 0x7e, 0xa7, 0xf0, 0xaa, 0xb1, 0x43, 0xab, 0xc6, 0xce, 0x8b, 0x97, 0x11, 0x86, 0x36, 0xa3, 0x01, 0x72, 0xe4, 0xcf, 0xe0, 0x2c, 0x8f, 0xa0, 0xdd, 0xa3, 0xb7, 0xba, 0xaf, 0x90, 0xf8, 0x09, 0x29, 0x82, 0x98, 0x55, 0x25, 0xf4, 0x88, 0xbd, 0xfc, 0xb4, 0xbd, 0x72, 0x6e, 0x22, 0x63, 0x9a, 0xc6, 0x4a, 0x30, 0x92, 0xab, 0x7f, 0xfc, 0xbf, 0x1d, 0x53, 0x34, 0xcf, 0xa5, 0x0b, 0x5b, 0xf1, 
};
static const u8 rsa_oaep_81_CRT_dQ[] = {
0x02, 0x62, 0xa6, 0xaa, 0x29, 0xc2, 0xa3, 0xc6, 0x7d, 0xc5, 0x34, 0x6c, 0x06, 0x38, 0x1a, 0xfd, 0x98, 0x7a, 0xa3, 0xcc, 0x93, 0xcf, 0xbf, 0xec, 0xf5, 0x4f, 0xdd, 0x9f, 0x9d, 0x78, 0x7d, 0x7f, 0x59, 0xa5, 0x23, 0xd3, 0x98, 0x97, 0x9d, 0xa1, 0x37, 0xa2, 0xf6, 0x38, 0x1f, 0xe9, 0x48, 0x01, 0xf7, 0xc9, 0x4d, 0xa2, 0x15, 0x18, 0xdc, 0x34, 0xcb, 0x40, 0x87, 0x0c, 0x46, 0x97, 0x99, 0x4a, 0xd9, 
};
static const u8 rsa_oaep_81_CRT_qInv[] = {
0x64, 0x9d, 0x4c, 0x17, 0xb6, 0xee, 0x17, 0x21, 0xe7, 0x72, 0xd0, 0x38, 0x9a, 0x55, 0x9c, 0x3d, 0x3c, 0xdf, 0x95, 0x50, 0xd4, 0x57, 0xc4, 0x6b, 0x03, 0x7b, 0x74, 0x64, 0x1b, 0x1d, 0x52, 0x16, 0x6a, 0xf8, 0xa2, 0x13, 0xc8, 0x39, 0x62, 0x06, 0xcd, 0xfb, 0xa4, 0x42, 0x2f, 0x18, 0xd6, 0xf6, 0x1d, 0xbc, 0xb5, 0xd2, 0x14, 0xc9, 0x71, 0xbf, 0x48, 0x2a, 0xeb, 0x97, 0x6a, 0x73, 0x70, 0xc2, 
};


static const rsa_test test_rsa_oaep_81_CRT = {
	.name = "rsa_oaep_81_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_81_CRT_n,
	.nlen = sizeof(rsa_oaep_81_CRT_n),
	.d = (const u8*)&rsa_oaep_81_CRT_d,
	.dlen = sizeof(rsa_oaep_81_CRT_d),
	.e = (const u8*)&rsa_oaep_81_CRT_e,
	.elen = sizeof(rsa_oaep_81_CRT_e),
	.p = (const u8*)&rsa_oaep_81_CRT_p,
	.plen = sizeof(rsa_oaep_81_CRT_p),
	.q = (const u8*)&rsa_oaep_81_CRT_q,
	.qlen = sizeof(rsa_oaep_81_CRT_q),
	.dP = (const u8*)&rsa_oaep_81_CRT_dP,
	.dPlen = sizeof(rsa_oaep_81_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_81_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_81_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_81_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_81_CRT_qInv),
	.m = (const u8*)&rsa_oaep_81_CRT_m,
	.mlen = sizeof(rsa_oaep_81_CRT_m),
	.res = (const u8*)&rsa_oaep_81_CRT_res,
	.reslen = sizeof(rsa_oaep_81_CRT_res),
	.salt = (const u8*)&rsa_oaep_81_CRT_salt,
	.saltlen = sizeof(rsa_oaep_81_CRT_salt),
};
static const u8 rsa_oaep_82_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_82_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_82_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_82_m[] = {
0x21, 0x84, 0x82, 0x70, 0x95, 0xd3, 0x5c, 0x3f, 0x86, 0xf6, 0x00, 0xe8, 0xe5, 0x97, 0x54, 0x01, 0x32, 0x96, 
};
static const u8 rsa_oaep_82_res[] = {
0x14, 0xc6, 0x78, 0xa9, 0x4a, 0xd6, 0x05, 0x25, 0xef, 0x39, 0xe9, 0x59, 0xb2, 0xf3, 0xba, 0x5c, 0x09, 0x7a, 0x94, 0xff, 0x91, 0x2b, 0x67, 0xdb, 0xac, 0xe8, 0x05, 0x35, 0xc1, 0x87, 0xab, 0xd4, 0x7d, 0x07, 0x54, 0x20, 0xb1, 0x87, 0x21, 0x52, 0xbb, 0xa0, 0x8f, 0x7f, 0xc3, 0x1f, 0x31, 0x3b, 0xbf, 0x92, 0x73, 0xc9, 0x12, 0xfc, 0x4c, 0x01, 0x49, 0xa9, 0xb0, 0xcf, 0xb7, 0x98, 0x07, 0xe3, 0x46, 0xeb, 0x33, 0x20, 0x69, 0x61, 0x1b, 0xec, 0x0f, 0xf9, 0xbc, 0xd1, 0x68, 0xf1, 0xf7, 0xc3, 0x3e, 0x77, 0x31, 0x3c, 0xea, 0x45, 0x4b, 0x94, 0xe2, 0x54, 0x9e, 0xec, 0xf0, 0x02, 0xe2, 0xac, 0xf7, 0xf6, 0xf2, 0xd2, 0x84, 0x5d, 0x4f, 0xe0, 0xaa, 0xb2, 0xe5, 0xa9, 0x2d, 0xdf, 0x68, 0xc4, 0x80, 0xae, 0x11, 0x24, 0x79, 0x35, 0xd1, 0xf6, 0x25, 0x74, 0x84, 0x22, 0x16, 0xae, 0x67, 0x41, 0x15, 
};
static const u8 rsa_oaep_82_salt[] = {
0x52, 0x67, 0x3b, 0xde, 0x2c, 0xa1, 0x66, 0xc2, 0xaa, 0x46, 0x13, 0x1a, 0xc1, 0xdc, 0x80, 0x8d, 0x67, 0xd7, 0xd3, 0xb1, 
};


static const rsa_test test_rsa_oaep_82 = {
	.name = "rsa_oaep_82",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_82_n,
	.nlen = sizeof(rsa_oaep_82_n),
	.d = (const u8*)&rsa_oaep_82_d,
	.dlen = sizeof(rsa_oaep_82_d),
	.e = (const u8*)&rsa_oaep_82_e,
	.elen = sizeof(rsa_oaep_82_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_82_m,
	.mlen = sizeof(rsa_oaep_82_m),
	.res = (const u8*)&rsa_oaep_82_res,
	.reslen = sizeof(rsa_oaep_82_res),
	.salt = (const u8*)&rsa_oaep_82_salt,
	.saltlen = sizeof(rsa_oaep_82_salt),
};
static const u8 rsa_oaep_83_CRT_n[] = {
0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73, 
};
static const u8 rsa_oaep_83_CRT_d[] = {
0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1, 
};
static const u8 rsa_oaep_83_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_83_CRT_m[] = {
0x21, 0x84, 0x82, 0x70, 0x95, 0xd3, 0x5c, 0x3f, 0x86, 0xf6, 0x00, 0xe8, 0xe5, 0x97, 0x54, 0x01, 0x32, 0x96, 
};
static const u8 rsa_oaep_83_CRT_res[] = {
0x14, 0xc6, 0x78, 0xa9, 0x4a, 0xd6, 0x05, 0x25, 0xef, 0x39, 0xe9, 0x59, 0xb2, 0xf3, 0xba, 0x5c, 0x09, 0x7a, 0x94, 0xff, 0x91, 0x2b, 0x67, 0xdb, 0xac, 0xe8, 0x05, 0x35, 0xc1, 0x87, 0xab, 0xd4, 0x7d, 0x07, 0x54, 0x20, 0xb1, 0x87, 0x21, 0x52, 0xbb, 0xa0, 0x8f, 0x7f, 0xc3, 0x1f, 0x31, 0x3b, 0xbf, 0x92, 0x73, 0xc9, 0x12, 0xfc, 0x4c, 0x01, 0x49, 0xa9, 0xb0, 0xcf, 0xb7, 0x98, 0x07, 0xe3, 0x46, 0xeb, 0x33, 0x20, 0x69, 0x61, 0x1b, 0xec, 0x0f, 0xf9, 0xbc, 0xd1, 0x68, 0xf1, 0xf7, 0xc3, 0x3e, 0x77, 0x31, 0x3c, 0xea, 0x45, 0x4b, 0x94, 0xe2, 0x54, 0x9e, 0xec, 0xf0, 0x02, 0xe2, 0xac, 0xf7, 0xf6, 0xf2, 0xd2, 0x84, 0x5d, 0x4f, 0xe0, 0xaa, 0xb2, 0xe5, 0xa9, 0x2d, 0xdf, 0x68, 0xc4, 0x80, 0xae, 0x11, 0x24, 0x79, 0x35, 0xd1, 0xf6, 0x25, 0x74, 0x84, 0x22, 0x16, 0xae, 0x67, 0x41, 0x15, 
};
static const u8 rsa_oaep_83_CRT_salt[] = {
0x52, 0x67, 0x3b, 0xde, 0x2c, 0xa1, 0x66, 0xc2, 0xaa, 0x46, 0x13, 0x1a, 0xc1, 0xdc, 0x80, 0x8d, 0x67, 0xd7, 0xd3, 0xb1, 
};
static const u8 rsa_oaep_83_CRT_p[] = {
0x07, 0x49, 0x26, 0x2c, 0x11, 0x1c, 0xd4, 0x70, 0xec, 0x25, 0x66, 0xe6, 0xb3, 0x73, 0x2f, 0xc0, 0x93, 0x29, 0x46, 0x9a, 0xa1, 0x90, 0x71, 0xd3, 0xb9, 0xc0, 0x19, 0x06, 0x51, 0x4c, 0x6f, 0x1d, 0x26, 0xba, 0xa1, 0x4b, 0xea, 0xb0, 0x97, 0x1c, 0x8b, 0x7e, 0x61, 0x1a, 0x4f, 0x79, 0x00, 0x9d, 0x6f, 0xea, 0x77, 0x69, 0x28, 0xca, 0x25, 0x28, 0x5b, 0x0d, 0xe3, 0x64, 0x3d, 0x1a, 0x3f, 0x8c, 0x71, 
};
static const u8 rsa_oaep_83_CRT_q[] = {
0x06, 0xbc, 0x1e, 0x50, 0xe9, 0x6c, 0x02, 0xbf, 0x63, 0x6e, 0x9e, 0xea, 0x8b, 0x89, 0x9b, 0xbe, 0xbf, 0x76, 0x51, 0xde, 0x77, 0xdd, 0x47, 0x4c, 0x3e, 0x9b, 0xc2, 0x3b, 0xad, 0x81, 0x82, 0xb6, 0x19, 0x04, 0xc7, 0xd9, 0x7d, 0xfb, 0xeb, 0xfb, 0x1e, 0x00, 0x10, 0x88, 0x78, 0xb6, 0xe6, 0x7e, 0x41, 0x53, 0x91, 0xd6, 0x79, 0x42, 0xc2, 0xb2, 0xbf, 0x9b, 0x44, 0x35, 0xf8, 0x8b, 0x0c, 0xb0, 0x23, 
};
static const u8 rsa_oaep_83_CRT_dP[] = {
0x03, 0xbc, 0x7e, 0xa7, 0xf0, 0xaa, 0xb1, 0x43, 0xab, 0xc6, 0xce, 0x8b, 0x97, 0x11, 0x86, 0x36, 0xa3, 0x01, 0x72, 0xe4, 0xcf, 0xe0, 0x2c, 0x8f, 0xa0, 0xdd, 0xa3, 0xb7, 0xba, 0xaf, 0x90, 0xf8, 0x09, 0x29, 0x82, 0x98, 0x55, 0x25, 0xf4, 0x88, 0xbd, 0xfc, 0xb4, 0xbd, 0x72, 0x6e, 0x22, 0x63, 0x9a, 0xc6, 0x4a, 0x30, 0x92, 0xab, 0x7f, 0xfc, 0xbf, 0x1d, 0x53, 0x34, 0xcf, 0xa5, 0x0b, 0x5b, 0xf1, 
};
static const u8 rsa_oaep_83_CRT_dQ[] = {
0x02, 0x62, 0xa6, 0xaa, 0x29, 0xc2, 0xa3, 0xc6, 0x7d, 0xc5, 0x34, 0x6c, 0x06, 0x38, 0x1a, 0xfd, 0x98, 0x7a, 0xa3, 0xcc, 0x93, 0xcf, 0xbf, 0xec, 0xf5, 0x4f, 0xdd, 0x9f, 0x9d, 0x78, 0x7d, 0x7f, 0x59, 0xa5, 0x23, 0xd3, 0x98, 0x97, 0x9d, 0xa1, 0x37, 0xa2, 0xf6, 0x38, 0x1f, 0xe9, 0x48, 0x01, 0xf7, 0xc9, 0x4d, 0xa2, 0x15, 0x18, 0xdc, 0x34, 0xcb, 0x40, 0x87, 0x0c, 0x46, 0x97, 0x99, 0x4a, 0xd9, 
};
static const u8 rsa_oaep_83_CRT_qInv[] = {
0x64, 0x9d, 0x4c, 0x17, 0xb6, 0xee, 0x17, 0x21, 0xe7, 0x72, 0xd0, 0x38, 0x9a, 0x55, 0x9c, 0x3d, 0x3c, 0xdf, 0x95, 0x50, 0xd4, 0x57, 0xc4, 0x6b, 0x03, 0x7b, 0x74, 0x64, 0x1b, 0x1d, 0x52, 0x16, 0x6a, 0xf8, 0xa2, 0x13, 0xc8, 0x39, 0x62, 0x06, 0xcd, 0xfb, 0xa4, 0x42, 0x2f, 0x18, 0xd6, 0xf6, 0x1d, 0xbc, 0xb5, 0xd2, 0x14, 0xc9, 0x71, 0xbf, 0x48, 0x2a, 0xeb, 0x97, 0x6a, 0x73, 0x70, 0xc2, 
};


static const rsa_test test_rsa_oaep_83_CRT = {
	.name = "rsa_oaep_83_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1030,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_83_CRT_n,
	.nlen = sizeof(rsa_oaep_83_CRT_n),
	.d = (const u8*)&rsa_oaep_83_CRT_d,
	.dlen = sizeof(rsa_oaep_83_CRT_d),
	.e = (const u8*)&rsa_oaep_83_CRT_e,
	.elen = sizeof(rsa_oaep_83_CRT_e),
	.p = (const u8*)&rsa_oaep_83_CRT_p,
	.plen = sizeof(rsa_oaep_83_CRT_p),
	.q = (const u8*)&rsa_oaep_83_CRT_q,
	.qlen = sizeof(rsa_oaep_83_CRT_q),
	.dP = (const u8*)&rsa_oaep_83_CRT_dP,
	.dPlen = sizeof(rsa_oaep_83_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_83_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_83_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_83_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_83_CRT_qInv),
	.m = (const u8*)&rsa_oaep_83_CRT_m,
	.mlen = sizeof(rsa_oaep_83_CRT_m),
	.res = (const u8*)&rsa_oaep_83_CRT_res,
	.reslen = sizeof(rsa_oaep_83_CRT_res),
	.salt = (const u8*)&rsa_oaep_83_CRT_salt,
	.saltlen = sizeof(rsa_oaep_83_CRT_salt),
};
static const u8 rsa_oaep_84_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_84_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_84_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_84_m[] = {
0x05, 0x0b, 0x75, 0x5e, 0x5e, 0x68, 0x80, 0xf7, 0xb9, 0xe9, 0xd6, 0x92, 0xa7, 0x4c, 0x37, 0xaa, 0xe4, 0x49, 0xb3, 0x1b, 0xfe, 0xa6, 0xde, 0xff, 0x83, 0x74, 0x7a, 0x89, 0x7f, 0x6c, 0x2c, 0x82, 0x5b, 0xb1, 0xad, 0xbf, 0x85, 0x0a, 0x3c, 0x96, 0x99, 0x4b, 0x5d, 0xe5, 0xb3, 0x3c, 0xbc, 0x7d, 0x4a, 0x17, 0x91, 0x3a, 0x79, 0x67, 
};
static const u8 rsa_oaep_84_res[] = {
0x09, 0xb3, 0x68, 0x3d, 0x8a, 0x2e, 0xb0, 0xfb, 0x29, 0x5b, 0x62, 0xed, 0x1f, 0xb9, 0x29, 0x0b, 0x71, 0x44, 0x57, 0xb7, 0x82, 0x53, 0x19, 0xf4, 0x64, 0x78, 0x72, 0xaf, 0x88, 0x9b, 0x30, 0x40, 0x94, 0x72, 0x02, 0x0a, 0xd1, 0x29, 0x12, 0xbf, 0x19, 0xb1, 0x1d, 0x48, 0x19, 0xf4, 0x96, 0x14, 0x82, 0x4f, 0xfd, 0x84, 0xd0, 0x9c, 0x0a, 0x17, 0xe7, 0xd1, 0x73, 0x09, 0xd1, 0x29, 0x19, 0x79, 0x04, 0x10, 0xaa, 0x29, 0x95, 0x69, 0x9f, 0x6a, 0x86, 0xdb, 0xe3, 0x24, 0x2b, 0x5a, 0xcc, 0x23, 0xaf, 0x45, 0x69, 0x10, 0x80, 0xd6, 0xb1, 0xae, 0x81, 0x0f, 0xb3, 0xe3, 0x05, 0x70, 0x87, 0xf0, 0x97, 0x00, 0x92, 0xce, 0x00, 0xbe, 0x95, 0x62, 0xff, 0x40, 0x53, 0xb6, 0x26, 0x2c, 0xe0, 0xca, 0xa9, 0x3e, 0x13, 0x72, 0x3d, 0x2e, 0x3a, 0x5b, 0xa0, 0x75, 0xd4, 0x5f, 0x0d, 0x61, 0xb5, 0x4b, 0x61, 
};
static const u8 rsa_oaep_84_salt[] = {
0x77, 0x06, 0xff, 0xca, 0x1e, 0xcf, 0xb1, 0xeb, 0xee, 0x2a, 0x55, 0xe5, 0xc6, 0xe2, 0x4c, 0xd2, 0x79, 0x7a, 0x41, 0x25, 
};


static const rsa_test test_rsa_oaep_84 = {
	.name = "rsa_oaep_84",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_84_n,
	.nlen = sizeof(rsa_oaep_84_n),
	.d = (const u8*)&rsa_oaep_84_d,
	.dlen = sizeof(rsa_oaep_84_d),
	.e = (const u8*)&rsa_oaep_84_e,
	.elen = sizeof(rsa_oaep_84_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_84_m,
	.mlen = sizeof(rsa_oaep_84_m),
	.res = (const u8*)&rsa_oaep_84_res,
	.reslen = sizeof(rsa_oaep_84_res),
	.salt = (const u8*)&rsa_oaep_84_salt,
	.saltlen = sizeof(rsa_oaep_84_salt),
};
static const u8 rsa_oaep_85_CRT_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_85_CRT_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_85_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_85_CRT_m[] = {
0x05, 0x0b, 0x75, 0x5e, 0x5e, 0x68, 0x80, 0xf7, 0xb9, 0xe9, 0xd6, 0x92, 0xa7, 0x4c, 0x37, 0xaa, 0xe4, 0x49, 0xb3, 0x1b, 0xfe, 0xa6, 0xde, 0xff, 0x83, 0x74, 0x7a, 0x89, 0x7f, 0x6c, 0x2c, 0x82, 0x5b, 0xb1, 0xad, 0xbf, 0x85, 0x0a, 0x3c, 0x96, 0x99, 0x4b, 0x5d, 0xe5, 0xb3, 0x3c, 0xbc, 0x7d, 0x4a, 0x17, 0x91, 0x3a, 0x79, 0x67, 
};
static const u8 rsa_oaep_85_CRT_res[] = {
0x09, 0xb3, 0x68, 0x3d, 0x8a, 0x2e, 0xb0, 0xfb, 0x29, 0x5b, 0x62, 0xed, 0x1f, 0xb9, 0x29, 0x0b, 0x71, 0x44, 0x57, 0xb7, 0x82, 0x53, 0x19, 0xf4, 0x64, 0x78, 0x72, 0xaf, 0x88, 0x9b, 0x30, 0x40, 0x94, 0x72, 0x02, 0x0a, 0xd1, 0x29, 0x12, 0xbf, 0x19, 0xb1, 0x1d, 0x48, 0x19, 0xf4, 0x96, 0x14, 0x82, 0x4f, 0xfd, 0x84, 0xd0, 0x9c, 0x0a, 0x17, 0xe7, 0xd1, 0x73, 0x09, 0xd1, 0x29, 0x19, 0x79, 0x04, 0x10, 0xaa, 0x29, 0x95, 0x69, 0x9f, 0x6a, 0x86, 0xdb, 0xe3, 0x24, 0x2b, 0x5a, 0xcc, 0x23, 0xaf, 0x45, 0x69, 0x10, 0x80, 0xd6, 0xb1, 0xae, 0x81, 0x0f, 0xb3, 0xe3, 0x05, 0x70, 0x87, 0xf0, 0x97, 0x00, 0x92, 0xce, 0x00, 0xbe, 0x95, 0x62, 0xff, 0x40, 0x53, 0xb6, 0x26, 0x2c, 0xe0, 0xca, 0xa9, 0x3e, 0x13, 0x72, 0x3d, 0x2e, 0x3a, 0x5b, 0xa0, 0x75, 0xd4, 0x5f, 0x0d, 0x61, 0xb5, 0x4b, 0x61, 
};
static const u8 rsa_oaep_85_CRT_salt[] = {
0x77, 0x06, 0xff, 0xca, 0x1e, 0xcf, 0xb1, 0xeb, 0xee, 0x2a, 0x55, 0xe5, 0xc6, 0xe2, 0x4c, 0xd2, 0x79, 0x7a, 0x41, 0x25, 
};
static const u8 rsa_oaep_85_CRT_p[] = {
0x0a, 0x02, 0xef, 0x84, 0x48, 0xd9, 0xfa, 0xd8, 0xbb, 0xd0, 0xd0, 0x04, 0xc8, 0xc2, 0xaa, 0x97, 0x51, 0xef, 0x97, 0x21, 0xc1, 0xb0, 0xd0, 0x32, 0x36, 0xa5, 0x4b, 0x0d, 0xf9, 0x47, 0xcb, 0xae, 0xd5, 0xa2, 0x55, 0xee, 0x9e, 0x8e, 0x20, 0xd4, 0x91, 0xea, 0x17, 0x23, 0xfe, 0x09, 0x47, 0x04, 0xa9, 0x76, 0x2e, 0x88, 0xaf, 0xd1, 0x6e, 0xbb, 0x59, 0x94, 0x41, 0x2c, 0xa9, 0x66, 0xdc, 0x4f, 0x9f, 
};
static const u8 rsa_oaep_85_CRT_q[] = {
0x09, 0x2d, 0x36, 0x2e, 0x7e, 0xd3, 0xa0, 0xbf, 0xd9, 0xe9, 0xfd, 0x0e, 0x6c, 0x03, 0x01, 0xb6, 0xdf, 0x29, 0x15, 0x9c, 0xf5, 0x0c, 0xc8, 0x3b, 0x9b, 0x0c, 0xf4, 0xd6, 0xee, 0xa7, 0x1a, 0x61, 0xe0, 0x02, 0xb4, 0x6e, 0x0a, 0xe9, 0xf2, 0xde, 0x62, 0xd2, 0x5b, 0x5d, 0x74, 0x52, 0xd4, 0x98, 0xb8, 0x1c, 0x9a, 0xc6, 0xfc, 0x58, 0x59, 0x3d, 0x4c, 0x3f, 0xb4, 0xf5, 0xd7, 0x2d, 0xfb, 0xb0, 0xa9, 
};
static const u8 rsa_oaep_85_CRT_dP[] = {
0x07, 0xc7, 0x14, 0x10, 0xaf, 0x10, 0x39, 0x62, 0xdb, 0x36, 0x74, 0x04, 0xe3, 0x7a, 0xe8, 0x50, 0xba, 0xa4, 0xe9, 0xc2, 0x9d, 0xd9, 0x21, 0x45, 0x81, 0x52, 0x94, 0xa6, 0x7c, 0x7d, 0x1c, 0x6d, 0xed, 0x26, 0x3a, 0xa0, 0x30, 0xa9, 0xb6, 0x33, 0xae, 0x50, 0x30, 0x3e, 0x14, 0x03, 0x5d, 0x1a, 0xf0, 0x14, 0x12, 0x3e, 0xba, 0x68, 0x78, 0x20, 0x30, 0x8d, 0x8e, 0xbc, 0x85, 0xb6, 0x95, 0x7d, 0x7d, 
};
static const u8 rsa_oaep_85_CRT_dQ[] = {
0xae, 0x2c, 0x75, 0x38, 0x0c, 0x02, 0xc0, 0x16, 0xad, 0x05, 0x89, 0x1b, 0x33, 0x01, 0xde, 0x88, 0x1f, 0x28, 0xae, 0x11, 0x71, 0x18, 0x2b, 0x6b, 0x2c, 0x83, 0xbe, 0xa7, 0xc5, 0x15, 0xec, 0xa9, 0xca, 0x29, 0x8c, 0x7b, 0x1c, 0xab, 0x58, 0x17, 0xa5, 0x97, 0x06, 0x8f, 0xc8, 0x50, 0x60, 0xde, 0x4d, 0xa8, 0xa0, 0x16, 0x37, 0x8a, 0xae, 0x43, 0xc7, 0xf9, 0x67, 0xbc, 0xc3, 0x79, 0x04, 0xb9, 
};
static const u8 rsa_oaep_85_CRT_qInv[] = {
0x05, 0x98, 0xd1, 0x05, 0x9e, 0x3a, 0xda, 0x4f, 0x63, 0x20, 0x75, 0x2c, 0x09, 0xd8, 0x05, 0xff, 0x7d, 0x1f, 0x1a, 0xe0, 0xd0, 0x17, 0xae, 0xee, 0xe9, 0xce, 0xfa, 0x0d, 0x7d, 0xd7, 0xff, 0x77, 0x5e, 0x44, 0xb5, 0x78, 0x32, 0x2f, 0x64, 0x05, 0xd6, 0x21, 0x1d, 0xa1, 0x95, 0x19, 0x66, 0x6a, 0xa8, 0x7f, 0xdc, 0x4c, 0xd8, 0xc8, 0x8f, 0x6b, 0x6e, 0x3d, 0x67, 0xe9, 0x61, 0xdc, 0xbb, 0xa3, 0xd0, 
};


static const rsa_test test_rsa_oaep_85_CRT = {
	.name = "rsa_oaep_85_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_85_CRT_n,
	.nlen = sizeof(rsa_oaep_85_CRT_n),
	.d = (const u8*)&rsa_oaep_85_CRT_d,
	.dlen = sizeof(rsa_oaep_85_CRT_d),
	.e = (const u8*)&rsa_oaep_85_CRT_e,
	.elen = sizeof(rsa_oaep_85_CRT_e),
	.p = (const u8*)&rsa_oaep_85_CRT_p,
	.plen = sizeof(rsa_oaep_85_CRT_p),
	.q = (const u8*)&rsa_oaep_85_CRT_q,
	.qlen = sizeof(rsa_oaep_85_CRT_q),
	.dP = (const u8*)&rsa_oaep_85_CRT_dP,
	.dPlen = sizeof(rsa_oaep_85_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_85_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_85_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_85_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_85_CRT_qInv),
	.m = (const u8*)&rsa_oaep_85_CRT_m,
	.mlen = sizeof(rsa_oaep_85_CRT_m),
	.res = (const u8*)&rsa_oaep_85_CRT_res,
	.reslen = sizeof(rsa_oaep_85_CRT_res),
	.salt = (const u8*)&rsa_oaep_85_CRT_salt,
	.saltlen = sizeof(rsa_oaep_85_CRT_salt),
};
static const u8 rsa_oaep_86_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_86_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_86_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_86_m[] = {
0x4e, 0xb6, 0x8d, 0xcd, 0x93, 0xca, 0x9b, 0x19, 0xdf, 0x11, 0x1b, 0xd4, 0x36, 0x08, 0xf5, 0x57, 0x02, 0x6f, 0xe4, 0xaa, 0x1d, 0x5c, 0xfa, 0xc2, 0x27, 0xa3, 0xeb, 0x5a, 0xb9, 0x54, 0x8c, 0x18, 0xa0, 0x6d, 0xde, 0xd2, 0x3f, 0x81, 0x82, 0x59, 0x86, 0xb2, 0xfc, 0xd7, 0x11, 0x09, 0xec, 0xef, 0x7e, 0xff, 0x88, 0x87, 0x3f, 0x07, 0x5c, 0x2a, 0xa0, 0xc4, 0x69, 0xf6, 0x9c, 0x92, 0xbc, 
};
static const u8 rsa_oaep_86_res[] = {
0x2e, 0xcf, 0x15, 0xc9, 0x7c, 0x5a, 0x15, 0xb1, 0x47, 0x6a, 0xe9, 0x86, 0xb3, 0x71, 0xb5, 0x7a, 0x24, 0x28, 0x4f, 0x4a, 0x16, 0x2a, 0x8d, 0x0c, 0x81, 0x82, 0xe7, 0x90, 0x5e, 0x79, 0x22, 0x56, 0xf1, 0x81, 0x2b, 0xa5, 0xf8, 0x3f, 0x1f, 0x7a, 0x13, 0x0e, 0x42, 0xdc, 0xc0, 0x22, 0x32, 0x84, 0x4e, 0xdc, 0x14, 0xa3, 0x1a, 0x68, 0xee, 0x97, 0xae, 0x56, 0x4a, 0x38, 0x3a, 0x34, 0x11, 0x65, 0x64, 0x24, 0xc5, 0xf6, 0x2d, 0xdb, 0x64, 0x60, 0x93, 0xc3, 0x67, 0xbe, 0x1f, 0xcd, 0xa4, 0x26, 0xcf, 0x00, 0xa0, 0x6d, 0x8a, 0xcb, 0x7e, 0x57, 0x77, 0x6f, 0xbb, 0xd8, 0x55, 0xac, 0x3d, 0xf5, 0x06, 0xfc, 0x16, 0xb1, 0xd7, 0xc3, 0xf2, 0x11, 0x0f, 0x3d, 0x80, 0x68, 0xe9, 0x1e, 0x18, 0x63, 0x63, 0x83, 0x1c, 0x84, 0x09, 0x68, 0x0d, 0x8d, 0xa9, 0xec, 0xd8, 0xcf, 0x1f, 0xa2, 0x0e, 0xe3, 0x9d, 
};
static const u8 rsa_oaep_86_salt[] = {
0xa3, 0x71, 0x7d, 0xa1, 0x43, 0xb4, 0xdc, 0xff, 0xbc, 0x74, 0x26, 0x65, 0xa8, 0xfa, 0x95, 0x05, 0x85, 0x54, 0x83, 0x43, 
};


static const rsa_test test_rsa_oaep_86 = {
	.name = "rsa_oaep_86",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_86_n,
	.nlen = sizeof(rsa_oaep_86_n),
	.d = (const u8*)&rsa_oaep_86_d,
	.dlen = sizeof(rsa_oaep_86_d),
	.e = (const u8*)&rsa_oaep_86_e,
	.elen = sizeof(rsa_oaep_86_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_86_m,
	.mlen = sizeof(rsa_oaep_86_m),
	.res = (const u8*)&rsa_oaep_86_res,
	.reslen = sizeof(rsa_oaep_86_res),
	.salt = (const u8*)&rsa_oaep_86_salt,
	.saltlen = sizeof(rsa_oaep_86_salt),
};
static const u8 rsa_oaep_87_CRT_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_87_CRT_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_87_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_87_CRT_m[] = {
0x4e, 0xb6, 0x8d, 0xcd, 0x93, 0xca, 0x9b, 0x19, 0xdf, 0x11, 0x1b, 0xd4, 0x36, 0x08, 0xf5, 0x57, 0x02, 0x6f, 0xe4, 0xaa, 0x1d, 0x5c, 0xfa, 0xc2, 0x27, 0xa3, 0xeb, 0x5a, 0xb9, 0x54, 0x8c, 0x18, 0xa0, 0x6d, 0xde, 0xd2, 0x3f, 0x81, 0x82, 0x59, 0x86, 0xb2, 0xfc, 0xd7, 0x11, 0x09, 0xec, 0xef, 0x7e, 0xff, 0x88, 0x87, 0x3f, 0x07, 0x5c, 0x2a, 0xa0, 0xc4, 0x69, 0xf6, 0x9c, 0x92, 0xbc, 
};
static const u8 rsa_oaep_87_CRT_res[] = {
0x2e, 0xcf, 0x15, 0xc9, 0x7c, 0x5a, 0x15, 0xb1, 0x47, 0x6a, 0xe9, 0x86, 0xb3, 0x71, 0xb5, 0x7a, 0x24, 0x28, 0x4f, 0x4a, 0x16, 0x2a, 0x8d, 0x0c, 0x81, 0x82, 0xe7, 0x90, 0x5e, 0x79, 0x22, 0x56, 0xf1, 0x81, 0x2b, 0xa5, 0xf8, 0x3f, 0x1f, 0x7a, 0x13, 0x0e, 0x42, 0xdc, 0xc0, 0x22, 0x32, 0x84, 0x4e, 0xdc, 0x14, 0xa3, 0x1a, 0x68, 0xee, 0x97, 0xae, 0x56, 0x4a, 0x38, 0x3a, 0x34, 0x11, 0x65, 0x64, 0x24, 0xc5, 0xf6, 0x2d, 0xdb, 0x64, 0x60, 0x93, 0xc3, 0x67, 0xbe, 0x1f, 0xcd, 0xa4, 0x26, 0xcf, 0x00, 0xa0, 0x6d, 0x8a, 0xcb, 0x7e, 0x57, 0x77, 0x6f, 0xbb, 0xd8, 0x55, 0xac, 0x3d, 0xf5, 0x06, 0xfc, 0x16, 0xb1, 0xd7, 0xc3, 0xf2, 0x11, 0x0f, 0x3d, 0x80, 0x68, 0xe9, 0x1e, 0x18, 0x63, 0x63, 0x83, 0x1c, 0x84, 0x09, 0x68, 0x0d, 0x8d, 0xa9, 0xec, 0xd8, 0xcf, 0x1f, 0xa2, 0x0e, 0xe3, 0x9d, 
};
static const u8 rsa_oaep_87_CRT_salt[] = {
0xa3, 0x71, 0x7d, 0xa1, 0x43, 0xb4, 0xdc, 0xff, 0xbc, 0x74, 0x26, 0x65, 0xa8, 0xfa, 0x95, 0x05, 0x85, 0x54, 0x83, 0x43, 
};
static const u8 rsa_oaep_87_CRT_p[] = {
0x0a, 0x02, 0xef, 0x84, 0x48, 0xd9, 0xfa, 0xd8, 0xbb, 0xd0, 0xd0, 0x04, 0xc8, 0xc2, 0xaa, 0x97, 0x51, 0xef, 0x97, 0x21, 0xc1, 0xb0, 0xd0, 0x32, 0x36, 0xa5, 0x4b, 0x0d, 0xf9, 0x47, 0xcb, 0xae, 0xd5, 0xa2, 0x55, 0xee, 0x9e, 0x8e, 0x20, 0xd4, 0x91, 0xea, 0x17, 0x23, 0xfe, 0x09, 0x47, 0x04, 0xa9, 0x76, 0x2e, 0x88, 0xaf, 0xd1, 0x6e, 0xbb, 0x59, 0x94, 0x41, 0x2c, 0xa9, 0x66, 0xdc, 0x4f, 0x9f, 
};
static const u8 rsa_oaep_87_CRT_q[] = {
0x09, 0x2d, 0x36, 0x2e, 0x7e, 0xd3, 0xa0, 0xbf, 0xd9, 0xe9, 0xfd, 0x0e, 0x6c, 0x03, 0x01, 0xb6, 0xdf, 0x29, 0x15, 0x9c, 0xf5, 0x0c, 0xc8, 0x3b, 0x9b, 0x0c, 0xf4, 0xd6, 0xee, 0xa7, 0x1a, 0x61, 0xe0, 0x02, 0xb4, 0x6e, 0x0a, 0xe9, 0xf2, 0xde, 0x62, 0xd2, 0x5b, 0x5d, 0x74, 0x52, 0xd4, 0x98, 0xb8, 0x1c, 0x9a, 0xc6, 0xfc, 0x58, 0x59, 0x3d, 0x4c, 0x3f, 0xb4, 0xf5, 0xd7, 0x2d, 0xfb, 0xb0, 0xa9, 
};
static const u8 rsa_oaep_87_CRT_dP[] = {
0x07, 0xc7, 0x14, 0x10, 0xaf, 0x10, 0x39, 0x62, 0xdb, 0x36, 0x74, 0x04, 0xe3, 0x7a, 0xe8, 0x50, 0xba, 0xa4, 0xe9, 0xc2, 0x9d, 0xd9, 0x21, 0x45, 0x81, 0x52, 0x94, 0xa6, 0x7c, 0x7d, 0x1c, 0x6d, 0xed, 0x26, 0x3a, 0xa0, 0x30, 0xa9, 0xb6, 0x33, 0xae, 0x50, 0x30, 0x3e, 0x14, 0x03, 0x5d, 0x1a, 0xf0, 0x14, 0x12, 0x3e, 0xba, 0x68, 0x78, 0x20, 0x30, 0x8d, 0x8e, 0xbc, 0x85, 0xb6, 0x95, 0x7d, 0x7d, 
};
static const u8 rsa_oaep_87_CRT_dQ[] = {
0xae, 0x2c, 0x75, 0x38, 0x0c, 0x02, 0xc0, 0x16, 0xad, 0x05, 0x89, 0x1b, 0x33, 0x01, 0xde, 0x88, 0x1f, 0x28, 0xae, 0x11, 0x71, 0x18, 0x2b, 0x6b, 0x2c, 0x83, 0xbe, 0xa7, 0xc5, 0x15, 0xec, 0xa9, 0xca, 0x29, 0x8c, 0x7b, 0x1c, 0xab, 0x58, 0x17, 0xa5, 0x97, 0x06, 0x8f, 0xc8, 0x50, 0x60, 0xde, 0x4d, 0xa8, 0xa0, 0x16, 0x37, 0x8a, 0xae, 0x43, 0xc7, 0xf9, 0x67, 0xbc, 0xc3, 0x79, 0x04, 0xb9, 
};
static const u8 rsa_oaep_87_CRT_qInv[] = {
0x05, 0x98, 0xd1, 0x05, 0x9e, 0x3a, 0xda, 0x4f, 0x63, 0x20, 0x75, 0x2c, 0x09, 0xd8, 0x05, 0xff, 0x7d, 0x1f, 0x1a, 0xe0, 0xd0, 0x17, 0xae, 0xee, 0xe9, 0xce, 0xfa, 0x0d, 0x7d, 0xd7, 0xff, 0x77, 0x5e, 0x44, 0xb5, 0x78, 0x32, 0x2f, 0x64, 0x05, 0xd6, 0x21, 0x1d, 0xa1, 0x95, 0x19, 0x66, 0x6a, 0xa8, 0x7f, 0xdc, 0x4c, 0xd8, 0xc8, 0x8f, 0x6b, 0x6e, 0x3d, 0x67, 0xe9, 0x61, 0xdc, 0xbb, 0xa3, 0xd0, 
};


static const rsa_test test_rsa_oaep_87_CRT = {
	.name = "rsa_oaep_87_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_87_CRT_n,
	.nlen = sizeof(rsa_oaep_87_CRT_n),
	.d = (const u8*)&rsa_oaep_87_CRT_d,
	.dlen = sizeof(rsa_oaep_87_CRT_d),
	.e = (const u8*)&rsa_oaep_87_CRT_e,
	.elen = sizeof(rsa_oaep_87_CRT_e),
	.p = (const u8*)&rsa_oaep_87_CRT_p,
	.plen = sizeof(rsa_oaep_87_CRT_p),
	.q = (const u8*)&rsa_oaep_87_CRT_q,
	.qlen = sizeof(rsa_oaep_87_CRT_q),
	.dP = (const u8*)&rsa_oaep_87_CRT_dP,
	.dPlen = sizeof(rsa_oaep_87_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_87_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_87_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_87_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_87_CRT_qInv),
	.m = (const u8*)&rsa_oaep_87_CRT_m,
	.mlen = sizeof(rsa_oaep_87_CRT_m),
	.res = (const u8*)&rsa_oaep_87_CRT_res,
	.reslen = sizeof(rsa_oaep_87_CRT_res),
	.salt = (const u8*)&rsa_oaep_87_CRT_salt,
	.saltlen = sizeof(rsa_oaep_87_CRT_salt),
};
static const u8 rsa_oaep_88_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_88_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_88_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_88_m[] = {
0x86, 0x04, 0xac, 0x56, 0x32, 0x8c, 0x1a, 0xb5, 0xad, 0x91, 0x78, 0x61, 
};
static const u8 rsa_oaep_88_res[] = {
0x4b, 0xc8, 0x91, 0x30, 0xa5, 0xb2, 0xda, 0xbb, 0x7c, 0x2f, 0xcf, 0x90, 0xeb, 0x5d, 0x0e, 0xaf, 0x9e, 0x68, 0x1b, 0x71, 0x46, 0xa3, 0x8f, 0x31, 0x73, 0xa3, 0xd9, 0xcf, 0xec, 0x52, 0xea, 0x9e, 0x0a, 0x41, 0x93, 0x2e, 0x64, 0x8a, 0x9d, 0x69, 0x34, 0x4c, 0x50, 0xda, 0x76, 0x3f, 0x51, 0xa0, 0x3c, 0x95, 0x76, 0x21, 0x31, 0xe8, 0x05, 0x22, 0x54, 0xdc, 0xd2, 0x24, 0x8c, 0xba, 0x40, 0xfd, 0x31, 0x66, 0x77, 0x86, 0xce, 0x05, 0xa2, 0xb7, 0xb5, 0x31, 0xac, 0x9d, 0xac, 0x9e, 0xd5, 0x84, 0xa5, 0x9b, 0x67, 0x7c, 0x1a, 0x8a, 0xed, 0x8c, 0x5d, 0x15, 0xd6, 0x8c, 0x05, 0x56, 0x9e, 0x2b, 0xe7, 0x80, 0xbf, 0x7d, 0xb6, 0x38, 0xfd, 0x2b, 0xfd, 0x2a, 0x85, 0xab, 0x27, 0x68, 0x60, 0xf3, 0x77, 0x73, 0x38, 0xfc, 0xa9, 0x89, 0xff, 0xd7, 0x43, 0xd1, 0x3e, 0xe0, 0x8e, 0x0c, 0xa9, 0x89, 0x3f, 
};
static const u8 rsa_oaep_88_salt[] = {
0xee, 0x06, 0x20, 0x90, 0x73, 0xcc, 0xa0, 0x26, 0xbb, 0x26, 0x4e, 0x51, 0x85, 0xbf, 0x8c, 0x68, 0xb7, 0x73, 0x9f, 0x86, 
};


static const rsa_test test_rsa_oaep_88 = {
	.name = "rsa_oaep_88",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_88_n,
	.nlen = sizeof(rsa_oaep_88_n),
	.d = (const u8*)&rsa_oaep_88_d,
	.dlen = sizeof(rsa_oaep_88_d),
	.e = (const u8*)&rsa_oaep_88_e,
	.elen = sizeof(rsa_oaep_88_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_88_m,
	.mlen = sizeof(rsa_oaep_88_m),
	.res = (const u8*)&rsa_oaep_88_res,
	.reslen = sizeof(rsa_oaep_88_res),
	.salt = (const u8*)&rsa_oaep_88_salt,
	.saltlen = sizeof(rsa_oaep_88_salt),
};
static const u8 rsa_oaep_89_CRT_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_89_CRT_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_89_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_89_CRT_m[] = {
0x86, 0x04, 0xac, 0x56, 0x32, 0x8c, 0x1a, 0xb5, 0xad, 0x91, 0x78, 0x61, 
};
static const u8 rsa_oaep_89_CRT_res[] = {
0x4b, 0xc8, 0x91, 0x30, 0xa5, 0xb2, 0xda, 0xbb, 0x7c, 0x2f, 0xcf, 0x90, 0xeb, 0x5d, 0x0e, 0xaf, 0x9e, 0x68, 0x1b, 0x71, 0x46, 0xa3, 0x8f, 0x31, 0x73, 0xa3, 0xd9, 0xcf, 0xec, 0x52, 0xea, 0x9e, 0x0a, 0x41, 0x93, 0x2e, 0x64, 0x8a, 0x9d, 0x69, 0x34, 0x4c, 0x50, 0xda, 0x76, 0x3f, 0x51, 0xa0, 0x3c, 0x95, 0x76, 0x21, 0x31, 0xe8, 0x05, 0x22, 0x54, 0xdc, 0xd2, 0x24, 0x8c, 0xba, 0x40, 0xfd, 0x31, 0x66, 0x77, 0x86, 0xce, 0x05, 0xa2, 0xb7, 0xb5, 0x31, 0xac, 0x9d, 0xac, 0x9e, 0xd5, 0x84, 0xa5, 0x9b, 0x67, 0x7c, 0x1a, 0x8a, 0xed, 0x8c, 0x5d, 0x15, 0xd6, 0x8c, 0x05, 0x56, 0x9e, 0x2b, 0xe7, 0x80, 0xbf, 0x7d, 0xb6, 0x38, 0xfd, 0x2b, 0xfd, 0x2a, 0x85, 0xab, 0x27, 0x68, 0x60, 0xf3, 0x77, 0x73, 0x38, 0xfc, 0xa9, 0x89, 0xff, 0xd7, 0x43, 0xd1, 0x3e, 0xe0, 0x8e, 0x0c, 0xa9, 0x89, 0x3f, 
};
static const u8 rsa_oaep_89_CRT_salt[] = {
0xee, 0x06, 0x20, 0x90, 0x73, 0xcc, 0xa0, 0x26, 0xbb, 0x26, 0x4e, 0x51, 0x85, 0xbf, 0x8c, 0x68, 0xb7, 0x73, 0x9f, 0x86, 
};
static const u8 rsa_oaep_89_CRT_p[] = {
0x0a, 0x02, 0xef, 0x84, 0x48, 0xd9, 0xfa, 0xd8, 0xbb, 0xd0, 0xd0, 0x04, 0xc8, 0xc2, 0xaa, 0x97, 0x51, 0xef, 0x97, 0x21, 0xc1, 0xb0, 0xd0, 0x32, 0x36, 0xa5, 0x4b, 0x0d, 0xf9, 0x47, 0xcb, 0xae, 0xd5, 0xa2, 0x55, 0xee, 0x9e, 0x8e, 0x20, 0xd4, 0x91, 0xea, 0x17, 0x23, 0xfe, 0x09, 0x47, 0x04, 0xa9, 0x76, 0x2e, 0x88, 0xaf, 0xd1, 0x6e, 0xbb, 0x59, 0x94, 0x41, 0x2c, 0xa9, 0x66, 0xdc, 0x4f, 0x9f, 
};
static const u8 rsa_oaep_89_CRT_q[] = {
0x09, 0x2d, 0x36, 0x2e, 0x7e, 0xd3, 0xa0, 0xbf, 0xd9, 0xe9, 0xfd, 0x0e, 0x6c, 0x03, 0x01, 0xb6, 0xdf, 0x29, 0x15, 0x9c, 0xf5, 0x0c, 0xc8, 0x3b, 0x9b, 0x0c, 0xf4, 0xd6, 0xee, 0xa7, 0x1a, 0x61, 0xe0, 0x02, 0xb4, 0x6e, 0x0a, 0xe9, 0xf2, 0xde, 0x62, 0xd2, 0x5b, 0x5d, 0x74, 0x52, 0xd4, 0x98, 0xb8, 0x1c, 0x9a, 0xc6, 0xfc, 0x58, 0x59, 0x3d, 0x4c, 0x3f, 0xb4, 0xf5, 0xd7, 0x2d, 0xfb, 0xb0, 0xa9, 
};
static const u8 rsa_oaep_89_CRT_dP[] = {
0x07, 0xc7, 0x14, 0x10, 0xaf, 0x10, 0x39, 0x62, 0xdb, 0x36, 0x74, 0x04, 0xe3, 0x7a, 0xe8, 0x50, 0xba, 0xa4, 0xe9, 0xc2, 0x9d, 0xd9, 0x21, 0x45, 0x81, 0x52, 0x94, 0xa6, 0x7c, 0x7d, 0x1c, 0x6d, 0xed, 0x26, 0x3a, 0xa0, 0x30, 0xa9, 0xb6, 0x33, 0xae, 0x50, 0x30, 0x3e, 0x14, 0x03, 0x5d, 0x1a, 0xf0, 0x14, 0x12, 0x3e, 0xba, 0x68, 0x78, 0x20, 0x30, 0x8d, 0x8e, 0xbc, 0x85, 0xb6, 0x95, 0x7d, 0x7d, 
};
static const u8 rsa_oaep_89_CRT_dQ[] = {
0xae, 0x2c, 0x75, 0x38, 0x0c, 0x02, 0xc0, 0x16, 0xad, 0x05, 0x89, 0x1b, 0x33, 0x01, 0xde, 0x88, 0x1f, 0x28, 0xae, 0x11, 0x71, 0x18, 0x2b, 0x6b, 0x2c, 0x83, 0xbe, 0xa7, 0xc5, 0x15, 0xec, 0xa9, 0xca, 0x29, 0x8c, 0x7b, 0x1c, 0xab, 0x58, 0x17, 0xa5, 0x97, 0x06, 0x8f, 0xc8, 0x50, 0x60, 0xde, 0x4d, 0xa8, 0xa0, 0x16, 0x37, 0x8a, 0xae, 0x43, 0xc7, 0xf9, 0x67, 0xbc, 0xc3, 0x79, 0x04, 0xb9, 
};
static const u8 rsa_oaep_89_CRT_qInv[] = {
0x05, 0x98, 0xd1, 0x05, 0x9e, 0x3a, 0xda, 0x4f, 0x63, 0x20, 0x75, 0x2c, 0x09, 0xd8, 0x05, 0xff, 0x7d, 0x1f, 0x1a, 0xe0, 0xd0, 0x17, 0xae, 0xee, 0xe9, 0xce, 0xfa, 0x0d, 0x7d, 0xd7, 0xff, 0x77, 0x5e, 0x44, 0xb5, 0x78, 0x32, 0x2f, 0x64, 0x05, 0xd6, 0x21, 0x1d, 0xa1, 0x95, 0x19, 0x66, 0x6a, 0xa8, 0x7f, 0xdc, 0x4c, 0xd8, 0xc8, 0x8f, 0x6b, 0x6e, 0x3d, 0x67, 0xe9, 0x61, 0xdc, 0xbb, 0xa3, 0xd0, 
};


static const rsa_test test_rsa_oaep_89_CRT = {
	.name = "rsa_oaep_89_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_89_CRT_n,
	.nlen = sizeof(rsa_oaep_89_CRT_n),
	.d = (const u8*)&rsa_oaep_89_CRT_d,
	.dlen = sizeof(rsa_oaep_89_CRT_d),
	.e = (const u8*)&rsa_oaep_89_CRT_e,
	.elen = sizeof(rsa_oaep_89_CRT_e),
	.p = (const u8*)&rsa_oaep_89_CRT_p,
	.plen = sizeof(rsa_oaep_89_CRT_p),
	.q = (const u8*)&rsa_oaep_89_CRT_q,
	.qlen = sizeof(rsa_oaep_89_CRT_q),
	.dP = (const u8*)&rsa_oaep_89_CRT_dP,
	.dPlen = sizeof(rsa_oaep_89_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_89_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_89_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_89_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_89_CRT_qInv),
	.m = (const u8*)&rsa_oaep_89_CRT_m,
	.mlen = sizeof(rsa_oaep_89_CRT_m),
	.res = (const u8*)&rsa_oaep_89_CRT_res,
	.reslen = sizeof(rsa_oaep_89_CRT_res),
	.salt = (const u8*)&rsa_oaep_89_CRT_salt,
	.saltlen = sizeof(rsa_oaep_89_CRT_salt),
};
static const u8 rsa_oaep_90_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_90_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_90_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_90_m[] = {
0xfd, 0xda, 0x5f, 0xbf, 0x6e, 0xc3, 0x61, 0xa9, 0xd9, 0xa4, 0xac, 0x68, 0xaf, 0x21, 0x6a, 0x06, 0x86, 0xf4, 0x38, 0xb1, 0xe0, 0xe5, 0xc3, 0x6b, 0x95, 0x5f, 0x74, 0xe1, 0x07, 0xf3, 0x9c, 0x0d, 0xdd, 0xcc, 
};
static const u8 rsa_oaep_90_res[] = {
0x2e, 0x45, 0x68, 0x47, 0xd8, 0xfc, 0x36, 0xff, 0x01, 0x47, 0xd6, 0x99, 0x35, 0x94, 0xb9, 0x39, 0x72, 0x27, 0xd5, 0x77, 0x75, 0x2c, 0x79, 0xd0, 0xf9, 0x04, 0xfc, 0xb0, 0x39, 0xd4, 0xd8, 0x12, 0xfe, 0xa6, 0x05, 0xa7, 0xb5, 0x74, 0xdd, 0x82, 0xca, 0x78, 0x6f, 0x93, 0x75, 0x23, 0x48, 0x43, 0x8e, 0xe9, 0xf5, 0xb5, 0x45, 0x49, 0x85, 0xd5, 0xf0, 0xe1, 0x69, 0x9e, 0x3e, 0x7a, 0xd1, 0x75, 0xa3, 0x2e, 0x15, 0xf0, 0x3d, 0xeb, 0x04, 0x2a, 0xb9, 0xfe, 0x1d, 0xd9, 0xdb, 0x1b, 0xb8, 0x6f, 0x8c, 0x08, 0x9c, 0xcb, 0x45, 0xe7, 0xef, 0x0c, 0x5e, 0xe7, 0xca, 0x9b, 0x72, 0x90, 0xca, 0x6b, 0x15, 0xbe, 0xd4, 0x70, 0x39, 0x78, 0x8a, 0x8a, 0x93, 0xff, 0x83, 0xe0, 0xe8, 0xd6, 0x24, 0x4c, 0x71, 0x00, 0x63, 0x62, 0xde, 0xef, 0x69, 0xb6, 0xf4, 0x16, 0xfb, 0x3c, 0x68, 0x43, 0x83, 0xfb, 0xd0, 
};
static const u8 rsa_oaep_90_salt[] = {
0x99, 0x0a, 0xd5, 0x73, 0xdc, 0x48, 0xa9, 0x73, 0x23, 0x5b, 0x6d, 0x82, 0x54, 0x36, 0x18, 0xf2, 0xe9, 0x55, 0x10, 0x5d, 
};


static const rsa_test test_rsa_oaep_90 = {
	.name = "rsa_oaep_90",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_90_n,
	.nlen = sizeof(rsa_oaep_90_n),
	.d = (const u8*)&rsa_oaep_90_d,
	.dlen = sizeof(rsa_oaep_90_d),
	.e = (const u8*)&rsa_oaep_90_e,
	.elen = sizeof(rsa_oaep_90_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_90_m,
	.mlen = sizeof(rsa_oaep_90_m),
	.res = (const u8*)&rsa_oaep_90_res,
	.reslen = sizeof(rsa_oaep_90_res),
	.salt = (const u8*)&rsa_oaep_90_salt,
	.saltlen = sizeof(rsa_oaep_90_salt),
};
static const u8 rsa_oaep_91_CRT_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_91_CRT_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_91_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_91_CRT_m[] = {
0xfd, 0xda, 0x5f, 0xbf, 0x6e, 0xc3, 0x61, 0xa9, 0xd9, 0xa4, 0xac, 0x68, 0xaf, 0x21, 0x6a, 0x06, 0x86, 0xf4, 0x38, 0xb1, 0xe0, 0xe5, 0xc3, 0x6b, 0x95, 0x5f, 0x74, 0xe1, 0x07, 0xf3, 0x9c, 0x0d, 0xdd, 0xcc, 
};
static const u8 rsa_oaep_91_CRT_res[] = {
0x2e, 0x45, 0x68, 0x47, 0xd8, 0xfc, 0x36, 0xff, 0x01, 0x47, 0xd6, 0x99, 0x35, 0x94, 0xb9, 0x39, 0x72, 0x27, 0xd5, 0x77, 0x75, 0x2c, 0x79, 0xd0, 0xf9, 0x04, 0xfc, 0xb0, 0x39, 0xd4, 0xd8, 0x12, 0xfe, 0xa6, 0x05, 0xa7, 0xb5, 0x74, 0xdd, 0x82, 0xca, 0x78, 0x6f, 0x93, 0x75, 0x23, 0x48, 0x43, 0x8e, 0xe9, 0xf5, 0xb5, 0x45, 0x49, 0x85, 0xd5, 0xf0, 0xe1, 0x69, 0x9e, 0x3e, 0x7a, 0xd1, 0x75, 0xa3, 0x2e, 0x15, 0xf0, 0x3d, 0xeb, 0x04, 0x2a, 0xb9, 0xfe, 0x1d, 0xd9, 0xdb, 0x1b, 0xb8, 0x6f, 0x8c, 0x08, 0x9c, 0xcb, 0x45, 0xe7, 0xef, 0x0c, 0x5e, 0xe7, 0xca, 0x9b, 0x72, 0x90, 0xca, 0x6b, 0x15, 0xbe, 0xd4, 0x70, 0x39, 0x78, 0x8a, 0x8a, 0x93, 0xff, 0x83, 0xe0, 0xe8, 0xd6, 0x24, 0x4c, 0x71, 0x00, 0x63, 0x62, 0xde, 0xef, 0x69, 0xb6, 0xf4, 0x16, 0xfb, 0x3c, 0x68, 0x43, 0x83, 0xfb, 0xd0, 
};
static const u8 rsa_oaep_91_CRT_salt[] = {
0x99, 0x0a, 0xd5, 0x73, 0xdc, 0x48, 0xa9, 0x73, 0x23, 0x5b, 0x6d, 0x82, 0x54, 0x36, 0x18, 0xf2, 0xe9, 0x55, 0x10, 0x5d, 
};
static const u8 rsa_oaep_91_CRT_p[] = {
0x0a, 0x02, 0xef, 0x84, 0x48, 0xd9, 0xfa, 0xd8, 0xbb, 0xd0, 0xd0, 0x04, 0xc8, 0xc2, 0xaa, 0x97, 0x51, 0xef, 0x97, 0x21, 0xc1, 0xb0, 0xd0, 0x32, 0x36, 0xa5, 0x4b, 0x0d, 0xf9, 0x47, 0xcb, 0xae, 0xd5, 0xa2, 0x55, 0xee, 0x9e, 0x8e, 0x20, 0xd4, 0x91, 0xea, 0x17, 0x23, 0xfe, 0x09, 0x47, 0x04, 0xa9, 0x76, 0x2e, 0x88, 0xaf, 0xd1, 0x6e, 0xbb, 0x59, 0x94, 0x41, 0x2c, 0xa9, 0x66, 0xdc, 0x4f, 0x9f, 
};
static const u8 rsa_oaep_91_CRT_q[] = {
0x09, 0x2d, 0x36, 0x2e, 0x7e, 0xd3, 0xa0, 0xbf, 0xd9, 0xe9, 0xfd, 0x0e, 0x6c, 0x03, 0x01, 0xb6, 0xdf, 0x29, 0x15, 0x9c, 0xf5, 0x0c, 0xc8, 0x3b, 0x9b, 0x0c, 0xf4, 0xd6, 0xee, 0xa7, 0x1a, 0x61, 0xe0, 0x02, 0xb4, 0x6e, 0x0a, 0xe9, 0xf2, 0xde, 0x62, 0xd2, 0x5b, 0x5d, 0x74, 0x52, 0xd4, 0x98, 0xb8, 0x1c, 0x9a, 0xc6, 0xfc, 0x58, 0x59, 0x3d, 0x4c, 0x3f, 0xb4, 0xf5, 0xd7, 0x2d, 0xfb, 0xb0, 0xa9, 
};
static const u8 rsa_oaep_91_CRT_dP[] = {
0x07, 0xc7, 0x14, 0x10, 0xaf, 0x10, 0x39, 0x62, 0xdb, 0x36, 0x74, 0x04, 0xe3, 0x7a, 0xe8, 0x50, 0xba, 0xa4, 0xe9, 0xc2, 0x9d, 0xd9, 0x21, 0x45, 0x81, 0x52, 0x94, 0xa6, 0x7c, 0x7d, 0x1c, 0x6d, 0xed, 0x26, 0x3a, 0xa0, 0x30, 0xa9, 0xb6, 0x33, 0xae, 0x50, 0x30, 0x3e, 0x14, 0x03, 0x5d, 0x1a, 0xf0, 0x14, 0x12, 0x3e, 0xba, 0x68, 0x78, 0x20, 0x30, 0x8d, 0x8e, 0xbc, 0x85, 0xb6, 0x95, 0x7d, 0x7d, 
};
static const u8 rsa_oaep_91_CRT_dQ[] = {
0xae, 0x2c, 0x75, 0x38, 0x0c, 0x02, 0xc0, 0x16, 0xad, 0x05, 0x89, 0x1b, 0x33, 0x01, 0xde, 0x88, 0x1f, 0x28, 0xae, 0x11, 0x71, 0x18, 0x2b, 0x6b, 0x2c, 0x83, 0xbe, 0xa7, 0xc5, 0x15, 0xec, 0xa9, 0xca, 0x29, 0x8c, 0x7b, 0x1c, 0xab, 0x58, 0x17, 0xa5, 0x97, 0x06, 0x8f, 0xc8, 0x50, 0x60, 0xde, 0x4d, 0xa8, 0xa0, 0x16, 0x37, 0x8a, 0xae, 0x43, 0xc7, 0xf9, 0x67, 0xbc, 0xc3, 0x79, 0x04, 0xb9, 
};
static const u8 rsa_oaep_91_CRT_qInv[] = {
0x05, 0x98, 0xd1, 0x05, 0x9e, 0x3a, 0xda, 0x4f, 0x63, 0x20, 0x75, 0x2c, 0x09, 0xd8, 0x05, 0xff, 0x7d, 0x1f, 0x1a, 0xe0, 0xd0, 0x17, 0xae, 0xee, 0xe9, 0xce, 0xfa, 0x0d, 0x7d, 0xd7, 0xff, 0x77, 0x5e, 0x44, 0xb5, 0x78, 0x32, 0x2f, 0x64, 0x05, 0xd6, 0x21, 0x1d, 0xa1, 0x95, 0x19, 0x66, 0x6a, 0xa8, 0x7f, 0xdc, 0x4c, 0xd8, 0xc8, 0x8f, 0x6b, 0x6e, 0x3d, 0x67, 0xe9, 0x61, 0xdc, 0xbb, 0xa3, 0xd0, 
};


static const rsa_test test_rsa_oaep_91_CRT = {
	.name = "rsa_oaep_91_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_91_CRT_n,
	.nlen = sizeof(rsa_oaep_91_CRT_n),
	.d = (const u8*)&rsa_oaep_91_CRT_d,
	.dlen = sizeof(rsa_oaep_91_CRT_d),
	.e = (const u8*)&rsa_oaep_91_CRT_e,
	.elen = sizeof(rsa_oaep_91_CRT_e),
	.p = (const u8*)&rsa_oaep_91_CRT_p,
	.plen = sizeof(rsa_oaep_91_CRT_p),
	.q = (const u8*)&rsa_oaep_91_CRT_q,
	.qlen = sizeof(rsa_oaep_91_CRT_q),
	.dP = (const u8*)&rsa_oaep_91_CRT_dP,
	.dPlen = sizeof(rsa_oaep_91_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_91_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_91_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_91_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_91_CRT_qInv),
	.m = (const u8*)&rsa_oaep_91_CRT_m,
	.mlen = sizeof(rsa_oaep_91_CRT_m),
	.res = (const u8*)&rsa_oaep_91_CRT_res,
	.reslen = sizeof(rsa_oaep_91_CRT_res),
	.salt = (const u8*)&rsa_oaep_91_CRT_salt,
	.saltlen = sizeof(rsa_oaep_91_CRT_salt),
};
static const u8 rsa_oaep_92_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_92_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_92_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_92_m[] = {
0x4a, 0x5f, 0x49, 0x14, 0xbe, 0xe2, 0x5d, 0xe3, 0xc6, 0x93, 0x41, 0xde, 0x07, 
};
static const u8 rsa_oaep_92_res[] = {
0x1f, 0xb9, 0x35, 0x6f, 0xd5, 0xc4, 0xb1, 0x79, 0x6d, 0xb2, 0xeb, 0xf7, 0xd0, 0xd3, 0x93, 0xcc, 0x81, 0x0a, 0xdf, 0x61, 0x45, 0xde, 0xfc, 0x2f, 0xce, 0x71, 0x4f, 0x79, 0xd9, 0x38, 0x00, 0xd5, 0xe2, 0xac, 0x21, 0x1e, 0xa8, 0xbb, 0xec, 0xca, 0x4b, 0x65, 0x4b, 0x94, 0xc3, 0xb1, 0x8b, 0x30, 0xdd, 0x57, 0x6c, 0xe3, 0x4d, 0xc9, 0x54, 0x36, 0xef, 0x57, 0xa0, 0x94, 0x15, 0x64, 0x59, 0x23, 0x35, 0x9a, 0x5d, 0x7b, 0x41, 0x71, 0xef, 0x22, 0xc2, 0x46, 0x70, 0xf1, 0xb2, 0x29, 0xd3, 0x60, 0x3e, 0x91, 0xf7, 0x66, 0x71, 0xb7, 0xdf, 0x97, 0xe7, 0x31, 0x7c, 0x97, 0x73, 0x44, 0x76, 0xd5, 0xf3, 0xd1, 0x7d, 0x21, 0xcf, 0x82, 0xb5, 0xba, 0x9f, 0x83, 0xdf, 0x2e, 0x58, 0x8d, 0x36, 0x98, 0x4f, 0xd1, 0xb5, 0x84, 0x46, 0x8b, 0xd2, 0x3b, 0x2e, 0x87, 0x5f, 0x32, 0xf6, 0x89, 0x53, 0xf7, 0xb2, 
};
static const u8 rsa_oaep_92_salt[] = {
0xec, 0xc6, 0x3b, 0x28, 0xf0, 0x75, 0x6f, 0x22, 0xf5, 0x2a, 0xc8, 0xe6, 0xec, 0x12, 0x51, 0xa6, 0xec, 0x30, 0x47, 0x18, 
};


static const rsa_test test_rsa_oaep_92 = {
	.name = "rsa_oaep_92",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_92_n,
	.nlen = sizeof(rsa_oaep_92_n),
	.d = (const u8*)&rsa_oaep_92_d,
	.dlen = sizeof(rsa_oaep_92_d),
	.e = (const u8*)&rsa_oaep_92_e,
	.elen = sizeof(rsa_oaep_92_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_92_m,
	.mlen = sizeof(rsa_oaep_92_m),
	.res = (const u8*)&rsa_oaep_92_res,
	.reslen = sizeof(rsa_oaep_92_res),
	.salt = (const u8*)&rsa_oaep_92_salt,
	.saltlen = sizeof(rsa_oaep_92_salt),
};
static const u8 rsa_oaep_93_CRT_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_93_CRT_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_93_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_93_CRT_m[] = {
0x4a, 0x5f, 0x49, 0x14, 0xbe, 0xe2, 0x5d, 0xe3, 0xc6, 0x93, 0x41, 0xde, 0x07, 
};
static const u8 rsa_oaep_93_CRT_res[] = {
0x1f, 0xb9, 0x35, 0x6f, 0xd5, 0xc4, 0xb1, 0x79, 0x6d, 0xb2, 0xeb, 0xf7, 0xd0, 0xd3, 0x93, 0xcc, 0x81, 0x0a, 0xdf, 0x61, 0x45, 0xde, 0xfc, 0x2f, 0xce, 0x71, 0x4f, 0x79, 0xd9, 0x38, 0x00, 0xd5, 0xe2, 0xac, 0x21, 0x1e, 0xa8, 0xbb, 0xec, 0xca, 0x4b, 0x65, 0x4b, 0x94, 0xc3, 0xb1, 0x8b, 0x30, 0xdd, 0x57, 0x6c, 0xe3, 0x4d, 0xc9, 0x54, 0x36, 0xef, 0x57, 0xa0, 0x94, 0x15, 0x64, 0x59, 0x23, 0x35, 0x9a, 0x5d, 0x7b, 0x41, 0x71, 0xef, 0x22, 0xc2, 0x46, 0x70, 0xf1, 0xb2, 0x29, 0xd3, 0x60, 0x3e, 0x91, 0xf7, 0x66, 0x71, 0xb7, 0xdf, 0x97, 0xe7, 0x31, 0x7c, 0x97, 0x73, 0x44, 0x76, 0xd5, 0xf3, 0xd1, 0x7d, 0x21, 0xcf, 0x82, 0xb5, 0xba, 0x9f, 0x83, 0xdf, 0x2e, 0x58, 0x8d, 0x36, 0x98, 0x4f, 0xd1, 0xb5, 0x84, 0x46, 0x8b, 0xd2, 0x3b, 0x2e, 0x87, 0x5f, 0x32, 0xf6, 0x89, 0x53, 0xf7, 0xb2, 
};
static const u8 rsa_oaep_93_CRT_salt[] = {
0xec, 0xc6, 0x3b, 0x28, 0xf0, 0x75, 0x6f, 0x22, 0xf5, 0x2a, 0xc8, 0xe6, 0xec, 0x12, 0x51, 0xa6, 0xec, 0x30, 0x47, 0x18, 
};
static const u8 rsa_oaep_93_CRT_p[] = {
0x0a, 0x02, 0xef, 0x84, 0x48, 0xd9, 0xfa, 0xd8, 0xbb, 0xd0, 0xd0, 0x04, 0xc8, 0xc2, 0xaa, 0x97, 0x51, 0xef, 0x97, 0x21, 0xc1, 0xb0, 0xd0, 0x32, 0x36, 0xa5, 0x4b, 0x0d, 0xf9, 0x47, 0xcb, 0xae, 0xd5, 0xa2, 0x55, 0xee, 0x9e, 0x8e, 0x20, 0xd4, 0x91, 0xea, 0x17, 0x23, 0xfe, 0x09, 0x47, 0x04, 0xa9, 0x76, 0x2e, 0x88, 0xaf, 0xd1, 0x6e, 0xbb, 0x59, 0x94, 0x41, 0x2c, 0xa9, 0x66, 0xdc, 0x4f, 0x9f, 
};
static const u8 rsa_oaep_93_CRT_q[] = {
0x09, 0x2d, 0x36, 0x2e, 0x7e, 0xd3, 0xa0, 0xbf, 0xd9, 0xe9, 0xfd, 0x0e, 0x6c, 0x03, 0x01, 0xb6, 0xdf, 0x29, 0x15, 0x9c, 0xf5, 0x0c, 0xc8, 0x3b, 0x9b, 0x0c, 0xf4, 0xd6, 0xee, 0xa7, 0x1a, 0x61, 0xe0, 0x02, 0xb4, 0x6e, 0x0a, 0xe9, 0xf2, 0xde, 0x62, 0xd2, 0x5b, 0x5d, 0x74, 0x52, 0xd4, 0x98, 0xb8, 0x1c, 0x9a, 0xc6, 0xfc, 0x58, 0x59, 0x3d, 0x4c, 0x3f, 0xb4, 0xf5, 0xd7, 0x2d, 0xfb, 0xb0, 0xa9, 
};
static const u8 rsa_oaep_93_CRT_dP[] = {
0x07, 0xc7, 0x14, 0x10, 0xaf, 0x10, 0x39, 0x62, 0xdb, 0x36, 0x74, 0x04, 0xe3, 0x7a, 0xe8, 0x50, 0xba, 0xa4, 0xe9, 0xc2, 0x9d, 0xd9, 0x21, 0x45, 0x81, 0x52, 0x94, 0xa6, 0x7c, 0x7d, 0x1c, 0x6d, 0xed, 0x26, 0x3a, 0xa0, 0x30, 0xa9, 0xb6, 0x33, 0xae, 0x50, 0x30, 0x3e, 0x14, 0x03, 0x5d, 0x1a, 0xf0, 0x14, 0x12, 0x3e, 0xba, 0x68, 0x78, 0x20, 0x30, 0x8d, 0x8e, 0xbc, 0x85, 0xb6, 0x95, 0x7d, 0x7d, 
};
static const u8 rsa_oaep_93_CRT_dQ[] = {
0xae, 0x2c, 0x75, 0x38, 0x0c, 0x02, 0xc0, 0x16, 0xad, 0x05, 0x89, 0x1b, 0x33, 0x01, 0xde, 0x88, 0x1f, 0x28, 0xae, 0x11, 0x71, 0x18, 0x2b, 0x6b, 0x2c, 0x83, 0xbe, 0xa7, 0xc5, 0x15, 0xec, 0xa9, 0xca, 0x29, 0x8c, 0x7b, 0x1c, 0xab, 0x58, 0x17, 0xa5, 0x97, 0x06, 0x8f, 0xc8, 0x50, 0x60, 0xde, 0x4d, 0xa8, 0xa0, 0x16, 0x37, 0x8a, 0xae, 0x43, 0xc7, 0xf9, 0x67, 0xbc, 0xc3, 0x79, 0x04, 0xb9, 
};
static const u8 rsa_oaep_93_CRT_qInv[] = {
0x05, 0x98, 0xd1, 0x05, 0x9e, 0x3a, 0xda, 0x4f, 0x63, 0x20, 0x75, 0x2c, 0x09, 0xd8, 0x05, 0xff, 0x7d, 0x1f, 0x1a, 0xe0, 0xd0, 0x17, 0xae, 0xee, 0xe9, 0xce, 0xfa, 0x0d, 0x7d, 0xd7, 0xff, 0x77, 0x5e, 0x44, 0xb5, 0x78, 0x32, 0x2f, 0x64, 0x05, 0xd6, 0x21, 0x1d, 0xa1, 0x95, 0x19, 0x66, 0x6a, 0xa8, 0x7f, 0xdc, 0x4c, 0xd8, 0xc8, 0x8f, 0x6b, 0x6e, 0x3d, 0x67, 0xe9, 0x61, 0xdc, 0xbb, 0xa3, 0xd0, 
};


static const rsa_test test_rsa_oaep_93_CRT = {
	.name = "rsa_oaep_93_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_93_CRT_n,
	.nlen = sizeof(rsa_oaep_93_CRT_n),
	.d = (const u8*)&rsa_oaep_93_CRT_d,
	.dlen = sizeof(rsa_oaep_93_CRT_d),
	.e = (const u8*)&rsa_oaep_93_CRT_e,
	.elen = sizeof(rsa_oaep_93_CRT_e),
	.p = (const u8*)&rsa_oaep_93_CRT_p,
	.plen = sizeof(rsa_oaep_93_CRT_p),
	.q = (const u8*)&rsa_oaep_93_CRT_q,
	.qlen = sizeof(rsa_oaep_93_CRT_q),
	.dP = (const u8*)&rsa_oaep_93_CRT_dP,
	.dPlen = sizeof(rsa_oaep_93_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_93_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_93_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_93_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_93_CRT_qInv),
	.m = (const u8*)&rsa_oaep_93_CRT_m,
	.mlen = sizeof(rsa_oaep_93_CRT_m),
	.res = (const u8*)&rsa_oaep_93_CRT_res,
	.reslen = sizeof(rsa_oaep_93_CRT_res),
	.salt = (const u8*)&rsa_oaep_93_CRT_salt,
	.saltlen = sizeof(rsa_oaep_93_CRT_salt),
};
static const u8 rsa_oaep_94_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_94_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_94_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_94_m[] = {
0x8e, 0x07, 0xd6, 0x6f, 0x7b, 0x88, 0x0a, 0x72, 0x56, 0x3a, 0xbc, 0xd3, 0xf3, 0x50, 0x92, 0xbc, 0x33, 0x40, 0x9f, 0xb7, 0xf8, 0x8f, 0x24, 0x72, 0xbe, 
};
static const u8 rsa_oaep_94_res[] = {
0x3a, 0xfd, 0x9c, 0x66, 0x00, 0x14, 0x7b, 0x21, 0x79, 0x8d, 0x81, 0x8c, 0x65, 0x5a, 0x0f, 0x4c, 0x92, 0x12, 0xdb, 0x26, 0xd0, 0xb0, 0xdf, 0xdc, 0x2a, 0x75, 0x94, 0xcc, 0xb3, 0xd2, 0x2f, 0x5b, 0xf1, 0xd7, 0xc3, 0xe1, 0x12, 0xcd, 0x73, 0xfc, 0x7d, 0x50, 0x9c, 0x7a, 0x8b, 0xaf, 0xdd, 0x3c, 0x27, 0x4d, 0x13, 0x99, 0x00, 0x9f, 0x96, 0x09, 0xec, 0x4b, 0xe6, 0x47, 0x7e, 0x45, 0x3f, 0x07, 0x5a, 0xa3, 0x3d, 0xb3, 0x82, 0x87, 0x0c, 0x1c, 0x34, 0x09, 0xae, 0xf3, 0x92, 0xd7, 0x38, 0x6a, 0xe3, 0xa6, 0x96, 0xb9, 0x9a, 0x94, 0xb4, 0xda, 0x05, 0x89, 0x44, 0x7e, 0x95, 0x5d, 0x16, 0xc9, 0x8b, 0x17, 0x60, 0x2a, 0x59, 0xbd, 0x73, 0x62, 0x79, 0xfc, 0xd8, 0xfb, 0x28, 0x0c, 0x44, 0x62, 0xd5, 0x90, 0xbf, 0xa9, 0xbf, 0x13, 0xfe, 0xd5, 0x70, 0xea, 0xfd, 0xe9, 0x73, 0x30, 0xa2, 0xc2, 0x10, 
};
static const u8 rsa_oaep_94_salt[] = {
0x39, 0x25, 0xc7, 0x1b, 0x36, 0x2d, 0x40, 0xa0, 0xa6, 0xde, 0x42, 0x14, 0x55, 0x79, 0xba, 0x1e, 0x7d, 0xd4, 0x59, 0xfc, 
};


static const rsa_test test_rsa_oaep_94 = {
	.name = "rsa_oaep_94",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_94_n,
	.nlen = sizeof(rsa_oaep_94_n),
	.d = (const u8*)&rsa_oaep_94_d,
	.dlen = sizeof(rsa_oaep_94_d),
	.e = (const u8*)&rsa_oaep_94_e,
	.elen = sizeof(rsa_oaep_94_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_94_m,
	.mlen = sizeof(rsa_oaep_94_m),
	.res = (const u8*)&rsa_oaep_94_res,
	.reslen = sizeof(rsa_oaep_94_res),
	.salt = (const u8*)&rsa_oaep_94_salt,
	.saltlen = sizeof(rsa_oaep_94_salt),
};
static const u8 rsa_oaep_95_CRT_n[] = {
0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7, 
};
static const u8 rsa_oaep_95_CRT_d[] = {
0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31, 
};
static const u8 rsa_oaep_95_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_95_CRT_m[] = {
0x8e, 0x07, 0xd6, 0x6f, 0x7b, 0x88, 0x0a, 0x72, 0x56, 0x3a, 0xbc, 0xd3, 0xf3, 0x50, 0x92, 0xbc, 0x33, 0x40, 0x9f, 0xb7, 0xf8, 0x8f, 0x24, 0x72, 0xbe, 
};
static const u8 rsa_oaep_95_CRT_res[] = {
0x3a, 0xfd, 0x9c, 0x66, 0x00, 0x14, 0x7b, 0x21, 0x79, 0x8d, 0x81, 0x8c, 0x65, 0x5a, 0x0f, 0x4c, 0x92, 0x12, 0xdb, 0x26, 0xd0, 0xb0, 0xdf, 0xdc, 0x2a, 0x75, 0x94, 0xcc, 0xb3, 0xd2, 0x2f, 0x5b, 0xf1, 0xd7, 0xc3, 0xe1, 0x12, 0xcd, 0x73, 0xfc, 0x7d, 0x50, 0x9c, 0x7a, 0x8b, 0xaf, 0xdd, 0x3c, 0x27, 0x4d, 0x13, 0x99, 0x00, 0x9f, 0x96, 0x09, 0xec, 0x4b, 0xe6, 0x47, 0x7e, 0x45, 0x3f, 0x07, 0x5a, 0xa3, 0x3d, 0xb3, 0x82, 0x87, 0x0c, 0x1c, 0x34, 0x09, 0xae, 0xf3, 0x92, 0xd7, 0x38, 0x6a, 0xe3, 0xa6, 0x96, 0xb9, 0x9a, 0x94, 0xb4, 0xda, 0x05, 0x89, 0x44, 0x7e, 0x95, 0x5d, 0x16, 0xc9, 0x8b, 0x17, 0x60, 0x2a, 0x59, 0xbd, 0x73, 0x62, 0x79, 0xfc, 0xd8, 0xfb, 0x28, 0x0c, 0x44, 0x62, 0xd5, 0x90, 0xbf, 0xa9, 0xbf, 0x13, 0xfe, 0xd5, 0x70, 0xea, 0xfd, 0xe9, 0x73, 0x30, 0xa2, 0xc2, 0x10, 
};
static const u8 rsa_oaep_95_CRT_salt[] = {
0x39, 0x25, 0xc7, 0x1b, 0x36, 0x2d, 0x40, 0xa0, 0xa6, 0xde, 0x42, 0x14, 0x55, 0x79, 0xba, 0x1e, 0x7d, 0xd4, 0x59, 0xfc, 
};
static const u8 rsa_oaep_95_CRT_p[] = {
0x0a, 0x02, 0xef, 0x84, 0x48, 0xd9, 0xfa, 0xd8, 0xbb, 0xd0, 0xd0, 0x04, 0xc8, 0xc2, 0xaa, 0x97, 0x51, 0xef, 0x97, 0x21, 0xc1, 0xb0, 0xd0, 0x32, 0x36, 0xa5, 0x4b, 0x0d, 0xf9, 0x47, 0xcb, 0xae, 0xd5, 0xa2, 0x55, 0xee, 0x9e, 0x8e, 0x20, 0xd4, 0x91, 0xea, 0x17, 0x23, 0xfe, 0x09, 0x47, 0x04, 0xa9, 0x76, 0x2e, 0x88, 0xaf, 0xd1, 0x6e, 0xbb, 0x59, 0x94, 0x41, 0x2c, 0xa9, 0x66, 0xdc, 0x4f, 0x9f, 
};
static const u8 rsa_oaep_95_CRT_q[] = {
0x09, 0x2d, 0x36, 0x2e, 0x7e, 0xd3, 0xa0, 0xbf, 0xd9, 0xe9, 0xfd, 0x0e, 0x6c, 0x03, 0x01, 0xb6, 0xdf, 0x29, 0x15, 0x9c, 0xf5, 0x0c, 0xc8, 0x3b, 0x9b, 0x0c, 0xf4, 0xd6, 0xee, 0xa7, 0x1a, 0x61, 0xe0, 0x02, 0xb4, 0x6e, 0x0a, 0xe9, 0xf2, 0xde, 0x62, 0xd2, 0x5b, 0x5d, 0x74, 0x52, 0xd4, 0x98, 0xb8, 0x1c, 0x9a, 0xc6, 0xfc, 0x58, 0x59, 0x3d, 0x4c, 0x3f, 0xb4, 0xf5, 0xd7, 0x2d, 0xfb, 0xb0, 0xa9, 
};
static const u8 rsa_oaep_95_CRT_dP[] = {
0x07, 0xc7, 0x14, 0x10, 0xaf, 0x10, 0x39, 0x62, 0xdb, 0x36, 0x74, 0x04, 0xe3, 0x7a, 0xe8, 0x50, 0xba, 0xa4, 0xe9, 0xc2, 0x9d, 0xd9, 0x21, 0x45, 0x81, 0x52, 0x94, 0xa6, 0x7c, 0x7d, 0x1c, 0x6d, 0xed, 0x26, 0x3a, 0xa0, 0x30, 0xa9, 0xb6, 0x33, 0xae, 0x50, 0x30, 0x3e, 0x14, 0x03, 0x5d, 0x1a, 0xf0, 0x14, 0x12, 0x3e, 0xba, 0x68, 0x78, 0x20, 0x30, 0x8d, 0x8e, 0xbc, 0x85, 0xb6, 0x95, 0x7d, 0x7d, 
};
static const u8 rsa_oaep_95_CRT_dQ[] = {
0xae, 0x2c, 0x75, 0x38, 0x0c, 0x02, 0xc0, 0x16, 0xad, 0x05, 0x89, 0x1b, 0x33, 0x01, 0xde, 0x88, 0x1f, 0x28, 0xae, 0x11, 0x71, 0x18, 0x2b, 0x6b, 0x2c, 0x83, 0xbe, 0xa7, 0xc5, 0x15, 0xec, 0xa9, 0xca, 0x29, 0x8c, 0x7b, 0x1c, 0xab, 0x58, 0x17, 0xa5, 0x97, 0x06, 0x8f, 0xc8, 0x50, 0x60, 0xde, 0x4d, 0xa8, 0xa0, 0x16, 0x37, 0x8a, 0xae, 0x43, 0xc7, 0xf9, 0x67, 0xbc, 0xc3, 0x79, 0x04, 0xb9, 
};
static const u8 rsa_oaep_95_CRT_qInv[] = {
0x05, 0x98, 0xd1, 0x05, 0x9e, 0x3a, 0xda, 0x4f, 0x63, 0x20, 0x75, 0x2c, 0x09, 0xd8, 0x05, 0xff, 0x7d, 0x1f, 0x1a, 0xe0, 0xd0, 0x17, 0xae, 0xee, 0xe9, 0xce, 0xfa, 0x0d, 0x7d, 0xd7, 0xff, 0x77, 0x5e, 0x44, 0xb5, 0x78, 0x32, 0x2f, 0x64, 0x05, 0xd6, 0x21, 0x1d, 0xa1, 0x95, 0x19, 0x66, 0x6a, 0xa8, 0x7f, 0xdc, 0x4c, 0xd8, 0xc8, 0x8f, 0x6b, 0x6e, 0x3d, 0x67, 0xe9, 0x61, 0xdc, 0xbb, 0xa3, 0xd0, 
};


static const rsa_test test_rsa_oaep_95_CRT = {
	.name = "rsa_oaep_95_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1031,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_95_CRT_n,
	.nlen = sizeof(rsa_oaep_95_CRT_n),
	.d = (const u8*)&rsa_oaep_95_CRT_d,
	.dlen = sizeof(rsa_oaep_95_CRT_d),
	.e = (const u8*)&rsa_oaep_95_CRT_e,
	.elen = sizeof(rsa_oaep_95_CRT_e),
	.p = (const u8*)&rsa_oaep_95_CRT_p,
	.plen = sizeof(rsa_oaep_95_CRT_p),
	.q = (const u8*)&rsa_oaep_95_CRT_q,
	.qlen = sizeof(rsa_oaep_95_CRT_q),
	.dP = (const u8*)&rsa_oaep_95_CRT_dP,
	.dPlen = sizeof(rsa_oaep_95_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_95_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_95_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_95_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_95_CRT_qInv),
	.m = (const u8*)&rsa_oaep_95_CRT_m,
	.mlen = sizeof(rsa_oaep_95_CRT_m),
	.res = (const u8*)&rsa_oaep_95_CRT_res,
	.reslen = sizeof(rsa_oaep_95_CRT_res),
	.salt = (const u8*)&rsa_oaep_95_CRT_salt,
	.saltlen = sizeof(rsa_oaep_95_CRT_salt),
};
static const u8 rsa_oaep_96_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_96_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_96_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_96_m[] = {
0xf7, 0x35, 0xfd, 0x55, 0xba, 0x92, 0x59, 0x2c, 0x3b, 0x52, 0xb8, 0xf9, 0xc4, 0xf6, 0x9a, 0xaa, 0x1c, 0xbe, 0xf8, 0xfe, 0x88, 0xad, 0xd0, 0x95, 0x59, 0x54, 0x12, 0x46, 0x7f, 0x9c, 0xf4, 0xec, 0x0b, 0x89, 0x6c, 0x59, 0xed, 0xa1, 0x62, 0x10, 0xe7, 0x54, 0x9c, 0x8a, 0xbb, 0x10, 0xcd, 0xbc, 0x21, 0xa1, 0x2e, 0xc9, 0xb6, 0xb5, 0xb8, 0xfd, 0x2f, 0x10, 0x39, 0x9e, 0xb6, 
};
static const u8 rsa_oaep_96_res[] = {
0x26, 0x7b, 0xcd, 0x11, 0x8a, 0xca, 0xb1, 0xfc, 0x8b, 0xa8, 0x1c, 0x85, 0xd7, 0x30, 0x03, 0xcb, 0x86, 0x10, 0xfa, 0x55, 0xc1, 0xd9, 0x7d, 0xa8, 0xd4, 0x8a, 0x7c, 0x7f, 0x06, 0x89, 0x6a, 0x4d, 0xb7, 0x51, 0xaa, 0x28, 0x42, 0x55, 0xb9, 0xd3, 0x6a, 0xd6, 0x5f, 0x37, 0x65, 0x3d, 0x82, 0x9f, 0x1b, 0x37, 0xf9, 0x7b, 0x80, 0x01, 0x94, 0x25, 0x45, 0xb2, 0xfc, 0x2c, 0x55, 0xa7, 0x37, 0x6c, 0xa7, 0xa1, 0xbe, 0x4b, 0x17, 0x60, 0xc8, 0xe0, 0x5a, 0x33, 0xe5, 0xaa, 0x25, 0x26, 0xb8, 0xd9, 0x8e, 0x31, 0x70, 0x88, 0xe7, 0x83, 0x4c, 0x75, 0x5b, 0x2a, 0x59, 0xb1, 0x26, 0x31, 0xa1, 0x82, 0xc0, 0x5d, 0x5d, 0x43, 0xab, 0x17, 0x79, 0x26, 0x4f, 0x84, 0x56, 0xf5, 0x15, 0xce, 0x57, 0xdf, 0xdf, 0x51, 0x2d, 0x54, 0x93, 0xda, 0xb7, 0xb7, 0x33, 0x8d, 0xc4, 0xb7, 0xd7, 0x8d, 0xb9, 0xc0, 0x91, 0xac, 0x3b, 0xaf, 0x53, 0x7a, 0x69, 0xfc, 0x7f, 0x54, 0x9d, 0x97, 0x9f, 0x0e, 0xff, 0x9a, 0x94, 0xfd, 0xa4, 0x16, 0x9b, 0xd4, 0xd1, 0xd1, 0x9a, 0x69, 0xc9, 0x9e, 0x33, 0xc3, 0xb5, 0x54, 0x90, 0xd5, 0x01, 0xb3, 0x9b, 0x1e, 0xda, 0xe1, 0x18, 0xff, 0x67, 0x93, 0xa1, 0x53, 0x26, 0x15, 0x84, 0xd3, 0xa5, 0xf3, 0x9f, 0x6e, 0x68, 0x2e, 0x3d, 0x17, 0xc8, 0xcd, 0x12, 0x61, 0xfa, 0x72, 
};
static const u8 rsa_oaep_96_salt[] = {
0x8e, 0xc9, 0x65, 0xf1, 0x34, 0xa3, 0xec, 0x99, 0x31, 0xe9, 0x2a, 0x1c, 0xa0, 0xdc, 0x81, 0x69, 0xd5, 0xea, 0x70, 0x5c, 
};


static const rsa_test test_rsa_oaep_96 = {
	.name = "rsa_oaep_96",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_96_n,
	.nlen = sizeof(rsa_oaep_96_n),
	.d = (const u8*)&rsa_oaep_96_d,
	.dlen = sizeof(rsa_oaep_96_d),
	.e = (const u8*)&rsa_oaep_96_e,
	.elen = sizeof(rsa_oaep_96_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_96_m,
	.mlen = sizeof(rsa_oaep_96_m),
	.res = (const u8*)&rsa_oaep_96_res,
	.reslen = sizeof(rsa_oaep_96_res),
	.salt = (const u8*)&rsa_oaep_96_salt,
	.saltlen = sizeof(rsa_oaep_96_salt),
};
static const u8 rsa_oaep_97_CRT_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_97_CRT_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_97_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_97_CRT_m[] = {
0xf7, 0x35, 0xfd, 0x55, 0xba, 0x92, 0x59, 0x2c, 0x3b, 0x52, 0xb8, 0xf9, 0xc4, 0xf6, 0x9a, 0xaa, 0x1c, 0xbe, 0xf8, 0xfe, 0x88, 0xad, 0xd0, 0x95, 0x59, 0x54, 0x12, 0x46, 0x7f, 0x9c, 0xf4, 0xec, 0x0b, 0x89, 0x6c, 0x59, 0xed, 0xa1, 0x62, 0x10, 0xe7, 0x54, 0x9c, 0x8a, 0xbb, 0x10, 0xcd, 0xbc, 0x21, 0xa1, 0x2e, 0xc9, 0xb6, 0xb5, 0xb8, 0xfd, 0x2f, 0x10, 0x39, 0x9e, 0xb6, 
};
static const u8 rsa_oaep_97_CRT_res[] = {
0x26, 0x7b, 0xcd, 0x11, 0x8a, 0xca, 0xb1, 0xfc, 0x8b, 0xa8, 0x1c, 0x85, 0xd7, 0x30, 0x03, 0xcb, 0x86, 0x10, 0xfa, 0x55, 0xc1, 0xd9, 0x7d, 0xa8, 0xd4, 0x8a, 0x7c, 0x7f, 0x06, 0x89, 0x6a, 0x4d, 0xb7, 0x51, 0xaa, 0x28, 0x42, 0x55, 0xb9, 0xd3, 0x6a, 0xd6, 0x5f, 0x37, 0x65, 0x3d, 0x82, 0x9f, 0x1b, 0x37, 0xf9, 0x7b, 0x80, 0x01, 0x94, 0x25, 0x45, 0xb2, 0xfc, 0x2c, 0x55, 0xa7, 0x37, 0x6c, 0xa7, 0xa1, 0xbe, 0x4b, 0x17, 0x60, 0xc8, 0xe0, 0x5a, 0x33, 0xe5, 0xaa, 0x25, 0x26, 0xb8, 0xd9, 0x8e, 0x31, 0x70, 0x88, 0xe7, 0x83, 0x4c, 0x75, 0x5b, 0x2a, 0x59, 0xb1, 0x26, 0x31, 0xa1, 0x82, 0xc0, 0x5d, 0x5d, 0x43, 0xab, 0x17, 0x79, 0x26, 0x4f, 0x84, 0x56, 0xf5, 0x15, 0xce, 0x57, 0xdf, 0xdf, 0x51, 0x2d, 0x54, 0x93, 0xda, 0xb7, 0xb7, 0x33, 0x8d, 0xc4, 0xb7, 0xd7, 0x8d, 0xb9, 0xc0, 0x91, 0xac, 0x3b, 0xaf, 0x53, 0x7a, 0x69, 0xfc, 0x7f, 0x54, 0x9d, 0x97, 0x9f, 0x0e, 0xff, 0x9a, 0x94, 0xfd, 0xa4, 0x16, 0x9b, 0xd4, 0xd1, 0xd1, 0x9a, 0x69, 0xc9, 0x9e, 0x33, 0xc3, 0xb5, 0x54, 0x90, 0xd5, 0x01, 0xb3, 0x9b, 0x1e, 0xda, 0xe1, 0x18, 0xff, 0x67, 0x93, 0xa1, 0x53, 0x26, 0x15, 0x84, 0xd3, 0xa5, 0xf3, 0x9f, 0x6e, 0x68, 0x2e, 0x3d, 0x17, 0xc8, 0xcd, 0x12, 0x61, 0xfa, 0x72, 
};
static const u8 rsa_oaep_97_CRT_salt[] = {
0x8e, 0xc9, 0x65, 0xf1, 0x34, 0xa3, 0xec, 0x99, 0x31, 0xe9, 0x2a, 0x1c, 0xa0, 0xdc, 0x81, 0x69, 0xd5, 0xea, 0x70, 0x5c, 
};
static const u8 rsa_oaep_97_CRT_p[] = {
0xfc, 0x8d, 0x6c, 0x04, 0xbe, 0xc4, 0xeb, 0x9a, 0x81, 0x92, 0xca, 0x79, 0x00, 0xcb, 0xe5, 0x36, 0xe2, 0xe8, 0xb5, 0x19, 0xde, 0xcf, 0x33, 0xb2, 0x45, 0x97, 0x98, 0xc6, 0x90, 0x9d, 0xf4, 0xf1, 0x76, 0xdb, 0x7d, 0x23, 0x19, 0x0f, 0xc7, 0x2b, 0x88, 0x65, 0xa7, 0x18, 0xaf, 0x89, 0x5f, 0x1b, 0xcd, 0x91, 0x45, 0x29, 0x80, 0x27, 0x42, 0x3b, 0x60, 0x5e, 0x70, 0xa4, 0x7c, 0xf5, 0x83, 0x90, 0xa8, 0xc3, 0xe8, 0x8f, 0xc8, 0xc4, 0x8e, 0x8b, 0x32, 0xe3, 0xda, 0x21, 0x0d, 0xfb, 0xe3, 0xe8, 0x81, 0xea, 0x56, 0x74, 0xb6, 0xa3, 0x48, 0xc2, 0x1e, 0x93, 0xf9, 0xe5, 0x5e, 0xa6, 0x5e, 0xfd, 
};
static const u8 rsa_oaep_97_CRT_q[] = {
0xd2, 0x00, 0xd4, 0x5e, 0x78, 0x8a, 0xac, 0xea, 0x60, 0x6a, 0x40, 0x1d, 0x04, 0x60, 0xf8, 0x7d, 0xd5, 0xc1, 0x02, 0x7e, 0x12, 0xdc, 0x1a, 0x0d, 0x75, 0x86, 0xe8, 0x93, 0x9d, 0x9c, 0xf7, 0x89, 0xb4, 0x0f, 0x51, 0xac, 0x04, 0x42, 0x96, 0x1d, 0xe7, 0xd2, 0x1c, 0xc2, 0x1e, 0x05, 0xc8, 0x31, 0x55, 0xc1, 0xf2, 0xaa, 0x91, 0x93, 0x38, 0x7c, 0xfd, 0xf9, 0x56, 0xcb, 0x48, 0xd1, 0x53, 0xba, 0x27, 0x04, 0x06, 0xf9, 0xbb, 0xba, 0x53, 0x7d, 0x49, 0x87, 0xd9, 0xe2, 0xf9, 0x94, 0x2d, 0x7a, 0x14, 0xcb, 0xff, 0xfe, 0xa7, 0x4f, 0xec, 0xdd, 0xa9, 0x28, 0xd2, 0x3e, 0x25, 0x9f, 0x5e, 0xe1, 
};
static const u8 rsa_oaep_97_CRT_dP[] = {
0xdb, 0x16, 0x80, 0x2f, 0x79, 0xa2, 0xf0, 0xd4, 0x5f, 0x35, 0x8d, 0x69, 0xfd, 0x33, 0xe4, 0x4b, 0x81, 0xfa, 0xe8, 0x28, 0x62, 0x2e, 0x93, 0xa5, 0x42, 0x53, 0xe9, 0x97, 0xd0, 0x1b, 0x07, 0x43, 0x75, 0x9d, 0xa0, 0xe8, 0x12, 0xb4, 0xaa, 0x4e, 0x6c, 0x8b, 0xea, 0xb2, 0x32, 0x8d, 0x54, 0x31, 0x95, 0x5a, 0x41, 0x8a, 0x67, 0xff, 0x26, 0xa8, 0xc5, 0xc8, 0x07, 0xa5, 0xda, 0x35, 0x4e, 0x05, 0xef, 0x31, 0xcc, 0x8c, 0xf7, 0x58, 0xf4, 0x63, 0x73, 0x29, 0x50, 0xb0, 0x3e, 0x26, 0x57, 0x26, 0xfb, 0x94, 0xe3, 0x9d, 0x6a, 0x57, 0x2a, 0x26, 0x24, 0x4a, 0xb0, 0x8d, 0xb7, 0x57, 0x52, 0xad, 
};
static const u8 rsa_oaep_97_CRT_dQ[] = {
0xa0, 0xa3, 0x17, 0xcf, 0xe7, 0xdf, 0x14, 0x23, 0xf8, 0x7a, 0x6d, 0xee, 0x84, 0x51, 0xf4, 0xe2, 0xb4, 0xa6, 0x7e, 0x54, 0x97, 0xf2, 0x9b, 0x4f, 0x1e, 0x4e, 0x83, 0x0b, 0x9f, 0xad, 0xd9, 0x40, 0x11, 0x67, 0x02, 0x6f, 0x55, 0x96, 0xe5, 0xa3, 0x9c, 0x97, 0x81, 0x7e, 0x0f, 0x5f, 0x16, 0xe2, 0x7e, 0x19, 0xec, 0x99, 0x02, 0xe0, 0x1d, 0x7e, 0xa6, 0xfb, 0x9a, 0xa3, 0xc7, 0x60, 0xaf, 0xee, 0x1e, 0x38, 0x1b, 0x69, 0xde, 0x6a, 0xc9, 0xc0, 0x75, 0x85, 0xa0, 0x6a, 0xd9, 0xc4, 0xba, 0x00, 0xbf, 0x75, 0xc8, 0xad, 0x2f, 0xa8, 0x98, 0xa4, 0x79, 0xe8, 0x0a, 0xe2, 0x94, 0xfe, 0xd2, 0xa1, 
};
static const u8 rsa_oaep_97_CRT_qInv[] = {
0x0b, 0x21, 0xf3, 0x35, 0xc3, 0x53, 0x34, 0x2e, 0xb4, 0x4c, 0x3a, 0xa2, 0x44, 0x45, 0x78, 0x0c, 0x2d, 0x65, 0x5b, 0x94, 0x01, 0x74, 0xca, 0xe3, 0x8c, 0x7c, 0x8a, 0x4e, 0x64, 0x93, 0xc0, 0xba, 0x9f, 0xd3, 0x03, 0x74, 0x82, 0x67, 0xb0, 0x83, 0xb9, 0xa7, 0xa6, 0xcb, 0x61, 0xe4, 0x2d, 0xb3, 0x62, 0xb8, 0xc9, 0x89, 0x6d, 0xb7, 0x06, 0x4e, 0x02, 0xad, 0x5a, 0xe6, 0x15, 0x87, 0xda, 0x15, 0xb4, 0x64, 0x9c, 0x90, 0x59, 0x49, 0x09, 0xfe, 0xb3, 0x7d, 0xbc, 0xb6, 0x54, 0xbe, 0xb7, 0x26, 0x8e, 0xc8, 0x01, 0xe5, 0xa8, 0xb4, 0xaa, 0x39, 0x11, 0xbe, 0xbd, 0x88, 0x54, 0x2f, 0x05, 0xbe, 
};


static const rsa_test test_rsa_oaep_97_CRT = {
	.name = "rsa_oaep_97_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_97_CRT_n,
	.nlen = sizeof(rsa_oaep_97_CRT_n),
	.d = (const u8*)&rsa_oaep_97_CRT_d,
	.dlen = sizeof(rsa_oaep_97_CRT_d),
	.e = (const u8*)&rsa_oaep_97_CRT_e,
	.elen = sizeof(rsa_oaep_97_CRT_e),
	.p = (const u8*)&rsa_oaep_97_CRT_p,
	.plen = sizeof(rsa_oaep_97_CRT_p),
	.q = (const u8*)&rsa_oaep_97_CRT_q,
	.qlen = sizeof(rsa_oaep_97_CRT_q),
	.dP = (const u8*)&rsa_oaep_97_CRT_dP,
	.dPlen = sizeof(rsa_oaep_97_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_97_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_97_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_97_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_97_CRT_qInv),
	.m = (const u8*)&rsa_oaep_97_CRT_m,
	.mlen = sizeof(rsa_oaep_97_CRT_m),
	.res = (const u8*)&rsa_oaep_97_CRT_res,
	.reslen = sizeof(rsa_oaep_97_CRT_res),
	.salt = (const u8*)&rsa_oaep_97_CRT_salt,
	.saltlen = sizeof(rsa_oaep_97_CRT_salt),
};
static const u8 rsa_oaep_98_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_98_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_98_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_98_m[] = {
0x81, 0xb9, 0x06, 0x60, 0x50, 0x15, 0xa6, 0x3a, 0xab, 0xe4, 0x2d, 0xdf, 0x11, 0xe1, 0x97, 0x89, 0x12, 0xf5, 0x40, 0x4c, 0x74, 0x74, 0xb2, 0x6d, 0xce, 0x3e, 0xd4, 0x82, 0xbf, 0x96, 0x1e, 0xcc, 0x81, 0x8b, 0xf4, 0x20, 0xc5, 0x46, 0x59, 
};
static const u8 rsa_oaep_98_res[] = {
0x93, 0xac, 0x9f, 0x06, 0x71, 0xec, 0x29, 0xac, 0xbb, 0x44, 0x4e, 0xff, 0xc1, 0xa5, 0x74, 0x13, 0x51, 0xd6, 0x0f, 0xdb, 0x0e, 0x39, 0x3f, 0xbf, 0x75, 0x4a, 0xcf, 0x0d, 0xe4, 0x97, 0x61, 0xa1, 0x48, 0x41, 0xdf, 0x77, 0x72, 0xe9, 0xbc, 0x82, 0x77, 0x39, 0x66, 0xa1, 0x58, 0x4c, 0x4d, 0x72, 0xba, 0xea, 0x00, 0x11, 0x8f, 0x83, 0xf3, 0x5c, 0xca, 0x6e, 0x53, 0x7c, 0xbd, 0x4d, 0x81, 0x1f, 0x55, 0x83, 0xb2, 0x97, 0x83, 0xd8, 0xa6, 0xd9, 0x4c, 0xd3, 0x1b, 0xe7, 0x0d, 0x6f, 0x52, 0x6c, 0x10, 0xff, 0x09, 0xc6, 0xfa, 0x7c, 0xe0, 0x69, 0x79, 0x5a, 0x3f, 0xcd, 0x05, 0x11, 0xfd, 0x5f, 0xcb, 0x56, 0x4b, 0xcc, 0x80, 0xea, 0x9c, 0x78, 0xf3, 0x8b, 0x80, 0x01, 0x25, 0x39, 0xd8, 0xa4, 0xdd, 0xf6, 0xfe, 0x81, 0xe9, 0xcd, 0xdb, 0x7f, 0x50, 0xdb, 0xbb, 0xbc, 0xc7, 0xe5, 0xd8, 0x60, 0x97, 0xcc, 0xf4, 0xec, 0x49, 0x18, 0x9f, 0xb8, 0xbf, 0x31, 0x8b, 0xe6, 0xd5, 0xa0, 0x71, 0x5d, 0x51, 0x6b, 0x49, 0xaf, 0x19, 0x12, 0x58, 0xcd, 0x32, 0xdc, 0x83, 0x3c, 0xe6, 0xeb, 0x46, 0x73, 0xc0, 0x3a, 0x19, 0xbb, 0xac, 0xe8, 0x8c, 0xc5, 0x48, 0x95, 0xf6, 0x36, 0xcc, 0x0c, 0x1e, 0xc8, 0x90, 0x96, 0xd1, 0x1c, 0xe2, 0x35, 0xa2, 0x65, 0xca, 0x17, 0x64, 0x23, 0x2a, 0x68, 0x9a, 0xe8, 
};
static const u8 rsa_oaep_98_salt[] = {
0xec, 0xb1, 0xb8, 0xb2, 0x5f, 0xa5, 0x0c, 0xda, 0xb0, 0x8e, 0x56, 0x04, 0x28, 0x67, 0xf4, 0xaf, 0x58, 0x26, 0xd1, 0x6c, 
};


static const rsa_test test_rsa_oaep_98 = {
	.name = "rsa_oaep_98",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_98_n,
	.nlen = sizeof(rsa_oaep_98_n),
	.d = (const u8*)&rsa_oaep_98_d,
	.dlen = sizeof(rsa_oaep_98_d),
	.e = (const u8*)&rsa_oaep_98_e,
	.elen = sizeof(rsa_oaep_98_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_98_m,
	.mlen = sizeof(rsa_oaep_98_m),
	.res = (const u8*)&rsa_oaep_98_res,
	.reslen = sizeof(rsa_oaep_98_res),
	.salt = (const u8*)&rsa_oaep_98_salt,
	.saltlen = sizeof(rsa_oaep_98_salt),
};
static const u8 rsa_oaep_99_CRT_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_99_CRT_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_99_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_99_CRT_m[] = {
0x81, 0xb9, 0x06, 0x60, 0x50, 0x15, 0xa6, 0x3a, 0xab, 0xe4, 0x2d, 0xdf, 0x11, 0xe1, 0x97, 0x89, 0x12, 0xf5, 0x40, 0x4c, 0x74, 0x74, 0xb2, 0x6d, 0xce, 0x3e, 0xd4, 0x82, 0xbf, 0x96, 0x1e, 0xcc, 0x81, 0x8b, 0xf4, 0x20, 0xc5, 0x46, 0x59, 
};
static const u8 rsa_oaep_99_CRT_res[] = {
0x93, 0xac, 0x9f, 0x06, 0x71, 0xec, 0x29, 0xac, 0xbb, 0x44, 0x4e, 0xff, 0xc1, 0xa5, 0x74, 0x13, 0x51, 0xd6, 0x0f, 0xdb, 0x0e, 0x39, 0x3f, 0xbf, 0x75, 0x4a, 0xcf, 0x0d, 0xe4, 0x97, 0x61, 0xa1, 0x48, 0x41, 0xdf, 0x77, 0x72, 0xe9, 0xbc, 0x82, 0x77, 0x39, 0x66, 0xa1, 0x58, 0x4c, 0x4d, 0x72, 0xba, 0xea, 0x00, 0x11, 0x8f, 0x83, 0xf3, 0x5c, 0xca, 0x6e, 0x53, 0x7c, 0xbd, 0x4d, 0x81, 0x1f, 0x55, 0x83, 0xb2, 0x97, 0x83, 0xd8, 0xa6, 0xd9, 0x4c, 0xd3, 0x1b, 0xe7, 0x0d, 0x6f, 0x52, 0x6c, 0x10, 0xff, 0x09, 0xc6, 0xfa, 0x7c, 0xe0, 0x69, 0x79, 0x5a, 0x3f, 0xcd, 0x05, 0x11, 0xfd, 0x5f, 0xcb, 0x56, 0x4b, 0xcc, 0x80, 0xea, 0x9c, 0x78, 0xf3, 0x8b, 0x80, 0x01, 0x25, 0x39, 0xd8, 0xa4, 0xdd, 0xf6, 0xfe, 0x81, 0xe9, 0xcd, 0xdb, 0x7f, 0x50, 0xdb, 0xbb, 0xbc, 0xc7, 0xe5, 0xd8, 0x60, 0x97, 0xcc, 0xf4, 0xec, 0x49, 0x18, 0x9f, 0xb8, 0xbf, 0x31, 0x8b, 0xe6, 0xd5, 0xa0, 0x71, 0x5d, 0x51, 0x6b, 0x49, 0xaf, 0x19, 0x12, 0x58, 0xcd, 0x32, 0xdc, 0x83, 0x3c, 0xe6, 0xeb, 0x46, 0x73, 0xc0, 0x3a, 0x19, 0xbb, 0xac, 0xe8, 0x8c, 0xc5, 0x48, 0x95, 0xf6, 0x36, 0xcc, 0x0c, 0x1e, 0xc8, 0x90, 0x96, 0xd1, 0x1c, 0xe2, 0x35, 0xa2, 0x65, 0xca, 0x17, 0x64, 0x23, 0x2a, 0x68, 0x9a, 0xe8, 
};
static const u8 rsa_oaep_99_CRT_salt[] = {
0xec, 0xb1, 0xb8, 0xb2, 0x5f, 0xa5, 0x0c, 0xda, 0xb0, 0x8e, 0x56, 0x04, 0x28, 0x67, 0xf4, 0xaf, 0x58, 0x26, 0xd1, 0x6c, 
};
static const u8 rsa_oaep_99_CRT_p[] = {
0xfc, 0x8d, 0x6c, 0x04, 0xbe, 0xc4, 0xeb, 0x9a, 0x81, 0x92, 0xca, 0x79, 0x00, 0xcb, 0xe5, 0x36, 0xe2, 0xe8, 0xb5, 0x19, 0xde, 0xcf, 0x33, 0xb2, 0x45, 0x97, 0x98, 0xc6, 0x90, 0x9d, 0xf4, 0xf1, 0x76, 0xdb, 0x7d, 0x23, 0x19, 0x0f, 0xc7, 0x2b, 0x88, 0x65, 0xa7, 0x18, 0xaf, 0x89, 0x5f, 0x1b, 0xcd, 0x91, 0x45, 0x29, 0x80, 0x27, 0x42, 0x3b, 0x60, 0x5e, 0x70, 0xa4, 0x7c, 0xf5, 0x83, 0x90, 0xa8, 0xc3, 0xe8, 0x8f, 0xc8, 0xc4, 0x8e, 0x8b, 0x32, 0xe3, 0xda, 0x21, 0x0d, 0xfb, 0xe3, 0xe8, 0x81, 0xea, 0x56, 0x74, 0xb6, 0xa3, 0x48, 0xc2, 0x1e, 0x93, 0xf9, 0xe5, 0x5e, 0xa6, 0x5e, 0xfd, 
};
static const u8 rsa_oaep_99_CRT_q[] = {
0xd2, 0x00, 0xd4, 0x5e, 0x78, 0x8a, 0xac, 0xea, 0x60, 0x6a, 0x40, 0x1d, 0x04, 0x60, 0xf8, 0x7d, 0xd5, 0xc1, 0x02, 0x7e, 0x12, 0xdc, 0x1a, 0x0d, 0x75, 0x86, 0xe8, 0x93, 0x9d, 0x9c, 0xf7, 0x89, 0xb4, 0x0f, 0x51, 0xac, 0x04, 0x42, 0x96, 0x1d, 0xe7, 0xd2, 0x1c, 0xc2, 0x1e, 0x05, 0xc8, 0x31, 0x55, 0xc1, 0xf2, 0xaa, 0x91, 0x93, 0x38, 0x7c, 0xfd, 0xf9, 0x56, 0xcb, 0x48, 0xd1, 0x53, 0xba, 0x27, 0x04, 0x06, 0xf9, 0xbb, 0xba, 0x53, 0x7d, 0x49, 0x87, 0xd9, 0xe2, 0xf9, 0x94, 0x2d, 0x7a, 0x14, 0xcb, 0xff, 0xfe, 0xa7, 0x4f, 0xec, 0xdd, 0xa9, 0x28, 0xd2, 0x3e, 0x25, 0x9f, 0x5e, 0xe1, 
};
static const u8 rsa_oaep_99_CRT_dP[] = {
0xdb, 0x16, 0x80, 0x2f, 0x79, 0xa2, 0xf0, 0xd4, 0x5f, 0x35, 0x8d, 0x69, 0xfd, 0x33, 0xe4, 0x4b, 0x81, 0xfa, 0xe8, 0x28, 0x62, 0x2e, 0x93, 0xa5, 0x42, 0x53, 0xe9, 0x97, 0xd0, 0x1b, 0x07, 0x43, 0x75, 0x9d, 0xa0, 0xe8, 0x12, 0xb4, 0xaa, 0x4e, 0x6c, 0x8b, 0xea, 0xb2, 0x32, 0x8d, 0x54, 0x31, 0x95, 0x5a, 0x41, 0x8a, 0x67, 0xff, 0x26, 0xa8, 0xc5, 0xc8, 0x07, 0xa5, 0xda, 0x35, 0x4e, 0x05, 0xef, 0x31, 0xcc, 0x8c, 0xf7, 0x58, 0xf4, 0x63, 0x73, 0x29, 0x50, 0xb0, 0x3e, 0x26, 0x57, 0x26, 0xfb, 0x94, 0xe3, 0x9d, 0x6a, 0x57, 0x2a, 0x26, 0x24, 0x4a, 0xb0, 0x8d, 0xb7, 0x57, 0x52, 0xad, 
};
static const u8 rsa_oaep_99_CRT_dQ[] = {
0xa0, 0xa3, 0x17, 0xcf, 0xe7, 0xdf, 0x14, 0x23, 0xf8, 0x7a, 0x6d, 0xee, 0x84, 0x51, 0xf4, 0xe2, 0xb4, 0xa6, 0x7e, 0x54, 0x97, 0xf2, 0x9b, 0x4f, 0x1e, 0x4e, 0x83, 0x0b, 0x9f, 0xad, 0xd9, 0x40, 0x11, 0x67, 0x02, 0x6f, 0x55, 0x96, 0xe5, 0xa3, 0x9c, 0x97, 0x81, 0x7e, 0x0f, 0x5f, 0x16, 0xe2, 0x7e, 0x19, 0xec, 0x99, 0x02, 0xe0, 0x1d, 0x7e, 0xa6, 0xfb, 0x9a, 0xa3, 0xc7, 0x60, 0xaf, 0xee, 0x1e, 0x38, 0x1b, 0x69, 0xde, 0x6a, 0xc9, 0xc0, 0x75, 0x85, 0xa0, 0x6a, 0xd9, 0xc4, 0xba, 0x00, 0xbf, 0x75, 0xc8, 0xad, 0x2f, 0xa8, 0x98, 0xa4, 0x79, 0xe8, 0x0a, 0xe2, 0x94, 0xfe, 0xd2, 0xa1, 
};
static const u8 rsa_oaep_99_CRT_qInv[] = {
0x0b, 0x21, 0xf3, 0x35, 0xc3, 0x53, 0x34, 0x2e, 0xb4, 0x4c, 0x3a, 0xa2, 0x44, 0x45, 0x78, 0x0c, 0x2d, 0x65, 0x5b, 0x94, 0x01, 0x74, 0xca, 0xe3, 0x8c, 0x7c, 0x8a, 0x4e, 0x64, 0x93, 0xc0, 0xba, 0x9f, 0xd3, 0x03, 0x74, 0x82, 0x67, 0xb0, 0x83, 0xb9, 0xa7, 0xa6, 0xcb, 0x61, 0xe4, 0x2d, 0xb3, 0x62, 0xb8, 0xc9, 0x89, 0x6d, 0xb7, 0x06, 0x4e, 0x02, 0xad, 0x5a, 0xe6, 0x15, 0x87, 0xda, 0x15, 0xb4, 0x64, 0x9c, 0x90, 0x59, 0x49, 0x09, 0xfe, 0xb3, 0x7d, 0xbc, 0xb6, 0x54, 0xbe, 0xb7, 0x26, 0x8e, 0xc8, 0x01, 0xe5, 0xa8, 0xb4, 0xaa, 0x39, 0x11, 0xbe, 0xbd, 0x88, 0x54, 0x2f, 0x05, 0xbe, 
};


static const rsa_test test_rsa_oaep_99_CRT = {
	.name = "rsa_oaep_99_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_99_CRT_n,
	.nlen = sizeof(rsa_oaep_99_CRT_n),
	.d = (const u8*)&rsa_oaep_99_CRT_d,
	.dlen = sizeof(rsa_oaep_99_CRT_d),
	.e = (const u8*)&rsa_oaep_99_CRT_e,
	.elen = sizeof(rsa_oaep_99_CRT_e),
	.p = (const u8*)&rsa_oaep_99_CRT_p,
	.plen = sizeof(rsa_oaep_99_CRT_p),
	.q = (const u8*)&rsa_oaep_99_CRT_q,
	.qlen = sizeof(rsa_oaep_99_CRT_q),
	.dP = (const u8*)&rsa_oaep_99_CRT_dP,
	.dPlen = sizeof(rsa_oaep_99_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_99_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_99_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_99_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_99_CRT_qInv),
	.m = (const u8*)&rsa_oaep_99_CRT_m,
	.mlen = sizeof(rsa_oaep_99_CRT_m),
	.res = (const u8*)&rsa_oaep_99_CRT_res,
	.reslen = sizeof(rsa_oaep_99_CRT_res),
	.salt = (const u8*)&rsa_oaep_99_CRT_salt,
	.saltlen = sizeof(rsa_oaep_99_CRT_salt),
};
static const u8 rsa_oaep_100_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_100_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_100_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_100_m[] = {
0xfd, 0x32, 0x64, 0x29, 0xdf, 0x9b, 0x89, 0x0e, 0x09, 0xb5, 0x4b, 0x18, 0xb8, 0xf3, 0x4f, 0x1e, 0x24, 
};
static const u8 rsa_oaep_100_res[] = {
0x81, 0xeb, 0xdd, 0x95, 0x05, 0x4b, 0x0c, 0x82, 0x2e, 0xf9, 0xad, 0x76, 0x93, 0xf5, 0xa8, 0x7a, 0xdf, 0xb4, 0xb4, 0xc4, 0xce, 0x70, 0xdf, 0x2d, 0xf8, 0x4e, 0xd4, 0x9c, 0x04, 0xda, 0x58, 0xba, 0x5f, 0xc2, 0x0a, 0x19, 0xe1, 0xa6, 0xe8, 0xb7, 0xa3, 0x90, 0x0b, 0x22, 0x79, 0x6d, 0xc4, 0xe8, 0x69, 0xee, 0x6b, 0x42, 0x79, 0x2d, 0x15, 0xa8, 0xec, 0xeb, 0x56, 0xc0, 0x9c, 0x69, 0x91, 0x4e, 0x81, 0x3c, 0xea, 0x8f, 0x69, 0x31, 0xe4, 0xb8, 0xed, 0x6f, 0x42, 0x1a, 0xf2, 0x98, 0xd5, 0x95, 0xc9, 0x7f, 0x47, 0x89, 0xc7, 0xca, 0xa6, 0x12, 0xc7, 0xef, 0x36, 0x09, 0x84, 0xc2, 0x1b, 0x93, 0xed, 0xc5, 0x40, 0x10, 0x68, 0xb5, 0xaf, 0x4c, 0x78, 0xa8, 0x77, 0x1b, 0x98, 0x4d, 0x53, 0xb8, 0xea, 0x8a, 0xdf, 0x2f, 0x6a, 0x7d, 0x4a, 0x0b, 0xa7, 0x6c, 0x75, 0xe1, 0xdd, 0x9f, 0x65, 0x8f, 0x20, 0xde, 0xd4, 0xa4, 0x60, 0x71, 0xd4, 0x6d, 0x77, 0x91, 0xb5, 0x68, 0x03, 0xd8, 0xfe, 0xa7, 0xf0, 0xb0, 0xf8, 0xe4, 0x1a, 0xe3, 0xf0, 0x93, 0x83, 0xa6, 0xf9, 0x58, 0x5f, 0xe7, 0x75, 0x3e, 0xaa, 0xff, 0xd2, 0xbf, 0x94, 0x56, 0x31, 0x08, 0xbe, 0xec, 0xc2, 0x07, 0xbb, 0xb5, 0x35, 0xf5, 0xfc, 0xc7, 0x05, 0xf0, 0xdd, 0xe9, 0xf7, 0x08, 0xc6, 0x2f, 0x49, 0xa9, 0xc9, 0x03, 0x71, 0xd3, 
};
static const u8 rsa_oaep_100_salt[] = {
0xe8, 0x9b, 0xb0, 0x32, 0xc6, 0xce, 0x62, 0x2c, 0xbd, 0xb5, 0x3b, 0xc9, 0x46, 0x60, 0x14, 0xea, 0x77, 0xf7, 0x77, 0xc0, 
};


static const rsa_test test_rsa_oaep_100 = {
	.name = "rsa_oaep_100",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_100_n,
	.nlen = sizeof(rsa_oaep_100_n),
	.d = (const u8*)&rsa_oaep_100_d,
	.dlen = sizeof(rsa_oaep_100_d),
	.e = (const u8*)&rsa_oaep_100_e,
	.elen = sizeof(rsa_oaep_100_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_100_m,
	.mlen = sizeof(rsa_oaep_100_m),
	.res = (const u8*)&rsa_oaep_100_res,
	.reslen = sizeof(rsa_oaep_100_res),
	.salt = (const u8*)&rsa_oaep_100_salt,
	.saltlen = sizeof(rsa_oaep_100_salt),
};
static const u8 rsa_oaep_101_CRT_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_101_CRT_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_101_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_101_CRT_m[] = {
0xfd, 0x32, 0x64, 0x29, 0xdf, 0x9b, 0x89, 0x0e, 0x09, 0xb5, 0x4b, 0x18, 0xb8, 0xf3, 0x4f, 0x1e, 0x24, 
};
static const u8 rsa_oaep_101_CRT_res[] = {
0x81, 0xeb, 0xdd, 0x95, 0x05, 0x4b, 0x0c, 0x82, 0x2e, 0xf9, 0xad, 0x76, 0x93, 0xf5, 0xa8, 0x7a, 0xdf, 0xb4, 0xb4, 0xc4, 0xce, 0x70, 0xdf, 0x2d, 0xf8, 0x4e, 0xd4, 0x9c, 0x04, 0xda, 0x58, 0xba, 0x5f, 0xc2, 0x0a, 0x19, 0xe1, 0xa6, 0xe8, 0xb7, 0xa3, 0x90, 0x0b, 0x22, 0x79, 0x6d, 0xc4, 0xe8, 0x69, 0xee, 0x6b, 0x42, 0x79, 0x2d, 0x15, 0xa8, 0xec, 0xeb, 0x56, 0xc0, 0x9c, 0x69, 0x91, 0x4e, 0x81, 0x3c, 0xea, 0x8f, 0x69, 0x31, 0xe4, 0xb8, 0xed, 0x6f, 0x42, 0x1a, 0xf2, 0x98, 0xd5, 0x95, 0xc9, 0x7f, 0x47, 0x89, 0xc7, 0xca, 0xa6, 0x12, 0xc7, 0xef, 0x36, 0x09, 0x84, 0xc2, 0x1b, 0x93, 0xed, 0xc5, 0x40, 0x10, 0x68, 0xb5, 0xaf, 0x4c, 0x78, 0xa8, 0x77, 0x1b, 0x98, 0x4d, 0x53, 0xb8, 0xea, 0x8a, 0xdf, 0x2f, 0x6a, 0x7d, 0x4a, 0x0b, 0xa7, 0x6c, 0x75, 0xe1, 0xdd, 0x9f, 0x65, 0x8f, 0x20, 0xde, 0xd4, 0xa4, 0x60, 0x71, 0xd4, 0x6d, 0x77, 0x91, 0xb5, 0x68, 0x03, 0xd8, 0xfe, 0xa7, 0xf0, 0xb0, 0xf8, 0xe4, 0x1a, 0xe3, 0xf0, 0x93, 0x83, 0xa6, 0xf9, 0x58, 0x5f, 0xe7, 0x75, 0x3e, 0xaa, 0xff, 0xd2, 0xbf, 0x94, 0x56, 0x31, 0x08, 0xbe, 0xec, 0xc2, 0x07, 0xbb, 0xb5, 0x35, 0xf5, 0xfc, 0xc7, 0x05, 0xf0, 0xdd, 0xe9, 0xf7, 0x08, 0xc6, 0x2f, 0x49, 0xa9, 0xc9, 0x03, 0x71, 0xd3, 
};
static const u8 rsa_oaep_101_CRT_salt[] = {
0xe8, 0x9b, 0xb0, 0x32, 0xc6, 0xce, 0x62, 0x2c, 0xbd, 0xb5, 0x3b, 0xc9, 0x46, 0x60, 0x14, 0xea, 0x77, 0xf7, 0x77, 0xc0, 
};
static const u8 rsa_oaep_101_CRT_p[] = {
0xfc, 0x8d, 0x6c, 0x04, 0xbe, 0xc4, 0xeb, 0x9a, 0x81, 0x92, 0xca, 0x79, 0x00, 0xcb, 0xe5, 0x36, 0xe2, 0xe8, 0xb5, 0x19, 0xde, 0xcf, 0x33, 0xb2, 0x45, 0x97, 0x98, 0xc6, 0x90, 0x9d, 0xf4, 0xf1, 0x76, 0xdb, 0x7d, 0x23, 0x19, 0x0f, 0xc7, 0x2b, 0x88, 0x65, 0xa7, 0x18, 0xaf, 0x89, 0x5f, 0x1b, 0xcd, 0x91, 0x45, 0x29, 0x80, 0x27, 0x42, 0x3b, 0x60, 0x5e, 0x70, 0xa4, 0x7c, 0xf5, 0x83, 0x90, 0xa8, 0xc3, 0xe8, 0x8f, 0xc8, 0xc4, 0x8e, 0x8b, 0x32, 0xe3, 0xda, 0x21, 0x0d, 0xfb, 0xe3, 0xe8, 0x81, 0xea, 0x56, 0x74, 0xb6, 0xa3, 0x48, 0xc2, 0x1e, 0x93, 0xf9, 0xe5, 0x5e, 0xa6, 0x5e, 0xfd, 
};
static const u8 rsa_oaep_101_CRT_q[] = {
0xd2, 0x00, 0xd4, 0x5e, 0x78, 0x8a, 0xac, 0xea, 0x60, 0x6a, 0x40, 0x1d, 0x04, 0x60, 0xf8, 0x7d, 0xd5, 0xc1, 0x02, 0x7e, 0x12, 0xdc, 0x1a, 0x0d, 0x75, 0x86, 0xe8, 0x93, 0x9d, 0x9c, 0xf7, 0x89, 0xb4, 0x0f, 0x51, 0xac, 0x04, 0x42, 0x96, 0x1d, 0xe7, 0xd2, 0x1c, 0xc2, 0x1e, 0x05, 0xc8, 0x31, 0x55, 0xc1, 0xf2, 0xaa, 0x91, 0x93, 0x38, 0x7c, 0xfd, 0xf9, 0x56, 0xcb, 0x48, 0xd1, 0x53, 0xba, 0x27, 0x04, 0x06, 0xf9, 0xbb, 0xba, 0x53, 0x7d, 0x49, 0x87, 0xd9, 0xe2, 0xf9, 0x94, 0x2d, 0x7a, 0x14, 0xcb, 0xff, 0xfe, 0xa7, 0x4f, 0xec, 0xdd, 0xa9, 0x28, 0xd2, 0x3e, 0x25, 0x9f, 0x5e, 0xe1, 
};
static const u8 rsa_oaep_101_CRT_dP[] = {
0xdb, 0x16, 0x80, 0x2f, 0x79, 0xa2, 0xf0, 0xd4, 0x5f, 0x35, 0x8d, 0x69, 0xfd, 0x33, 0xe4, 0x4b, 0x81, 0xfa, 0xe8, 0x28, 0x62, 0x2e, 0x93, 0xa5, 0x42, 0x53, 0xe9, 0x97, 0xd0, 0x1b, 0x07, 0x43, 0x75, 0x9d, 0xa0, 0xe8, 0x12, 0xb4, 0xaa, 0x4e, 0x6c, 0x8b, 0xea, 0xb2, 0x32, 0x8d, 0x54, 0x31, 0x95, 0x5a, 0x41, 0x8a, 0x67, 0xff, 0x26, 0xa8, 0xc5, 0xc8, 0x07, 0xa5, 0xda, 0x35, 0x4e, 0x05, 0xef, 0x31, 0xcc, 0x8c, 0xf7, 0x58, 0xf4, 0x63, 0x73, 0x29, 0x50, 0xb0, 0x3e, 0x26, 0x57, 0x26, 0xfb, 0x94, 0xe3, 0x9d, 0x6a, 0x57, 0x2a, 0x26, 0x24, 0x4a, 0xb0, 0x8d, 0xb7, 0x57, 0x52, 0xad, 
};
static const u8 rsa_oaep_101_CRT_dQ[] = {
0xa0, 0xa3, 0x17, 0xcf, 0xe7, 0xdf, 0x14, 0x23, 0xf8, 0x7a, 0x6d, 0xee, 0x84, 0x51, 0xf4, 0xe2, 0xb4, 0xa6, 0x7e, 0x54, 0x97, 0xf2, 0x9b, 0x4f, 0x1e, 0x4e, 0x83, 0x0b, 0x9f, 0xad, 0xd9, 0x40, 0x11, 0x67, 0x02, 0x6f, 0x55, 0x96, 0xe5, 0xa3, 0x9c, 0x97, 0x81, 0x7e, 0x0f, 0x5f, 0x16, 0xe2, 0x7e, 0x19, 0xec, 0x99, 0x02, 0xe0, 0x1d, 0x7e, 0xa6, 0xfb, 0x9a, 0xa3, 0xc7, 0x60, 0xaf, 0xee, 0x1e, 0x38, 0x1b, 0x69, 0xde, 0x6a, 0xc9, 0xc0, 0x75, 0x85, 0xa0, 0x6a, 0xd9, 0xc4, 0xba, 0x00, 0xbf, 0x75, 0xc8, 0xad, 0x2f, 0xa8, 0x98, 0xa4, 0x79, 0xe8, 0x0a, 0xe2, 0x94, 0xfe, 0xd2, 0xa1, 
};
static const u8 rsa_oaep_101_CRT_qInv[] = {
0x0b, 0x21, 0xf3, 0x35, 0xc3, 0x53, 0x34, 0x2e, 0xb4, 0x4c, 0x3a, 0xa2, 0x44, 0x45, 0x78, 0x0c, 0x2d, 0x65, 0x5b, 0x94, 0x01, 0x74, 0xca, 0xe3, 0x8c, 0x7c, 0x8a, 0x4e, 0x64, 0x93, 0xc0, 0xba, 0x9f, 0xd3, 0x03, 0x74, 0x82, 0x67, 0xb0, 0x83, 0xb9, 0xa7, 0xa6, 0xcb, 0x61, 0xe4, 0x2d, 0xb3, 0x62, 0xb8, 0xc9, 0x89, 0x6d, 0xb7, 0x06, 0x4e, 0x02, 0xad, 0x5a, 0xe6, 0x15, 0x87, 0xda, 0x15, 0xb4, 0x64, 0x9c, 0x90, 0x59, 0x49, 0x09, 0xfe, 0xb3, 0x7d, 0xbc, 0xb6, 0x54, 0xbe, 0xb7, 0x26, 0x8e, 0xc8, 0x01, 0xe5, 0xa8, 0xb4, 0xaa, 0x39, 0x11, 0xbe, 0xbd, 0x88, 0x54, 0x2f, 0x05, 0xbe, 
};


static const rsa_test test_rsa_oaep_101_CRT = {
	.name = "rsa_oaep_101_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_101_CRT_n,
	.nlen = sizeof(rsa_oaep_101_CRT_n),
	.d = (const u8*)&rsa_oaep_101_CRT_d,
	.dlen = sizeof(rsa_oaep_101_CRT_d),
	.e = (const u8*)&rsa_oaep_101_CRT_e,
	.elen = sizeof(rsa_oaep_101_CRT_e),
	.p = (const u8*)&rsa_oaep_101_CRT_p,
	.plen = sizeof(rsa_oaep_101_CRT_p),
	.q = (const u8*)&rsa_oaep_101_CRT_q,
	.qlen = sizeof(rsa_oaep_101_CRT_q),
	.dP = (const u8*)&rsa_oaep_101_CRT_dP,
	.dPlen = sizeof(rsa_oaep_101_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_101_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_101_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_101_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_101_CRT_qInv),
	.m = (const u8*)&rsa_oaep_101_CRT_m,
	.mlen = sizeof(rsa_oaep_101_CRT_m),
	.res = (const u8*)&rsa_oaep_101_CRT_res,
	.reslen = sizeof(rsa_oaep_101_CRT_res),
	.salt = (const u8*)&rsa_oaep_101_CRT_salt,
	.saltlen = sizeof(rsa_oaep_101_CRT_salt),
};
static const u8 rsa_oaep_102_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_102_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_102_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_102_m[] = {
0xf1, 0x45, 0x9b, 0x5f, 0x0c, 0x92, 0xf0, 0x1a, 0x0f, 0x72, 0x3a, 0x2e, 0x56, 0x62, 0x48, 0x4d, 0x8f, 0x8c, 0x0a, 0x20, 0xfc, 0x29, 0xda, 0xd6, 0xac, 0xd4, 0x3b, 0xb5, 0xf3, 0xef, 0xfd, 0xf4, 0xe1, 0xb6, 0x3e, 0x07, 0xfd, 0xfe, 0x66, 0x28, 0xd0, 0xd7, 0x4c, 0xa1, 0x9b, 0xf2, 0xd6, 0x9e, 0x4a, 0x0a, 0xbf, 0x86, 0xd2, 0x93, 0x92, 0x5a, 0x79, 0x67, 0x72, 0xf8, 0x08, 0x8e, 
};
static const u8 rsa_oaep_102_res[] = {
0xbc, 0xc3, 0x5f, 0x94, 0xcd, 0xe6, 0x6c, 0xb1, 0x13, 0x66, 0x25, 0xd6, 0x25, 0xb9, 0x44, 0x32, 0xa3, 0x5b, 0x22, 0xf3, 0xd2, 0xfa, 0x11, 0xa6, 0x13, 0xff, 0x0f, 0xca, 0x5b, 0xd5, 0x7f, 0x87, 0xb9, 0x02, 0xcc, 0xdc, 0x1c, 0xd0, 0xae, 0xbc, 0xb0, 0x71, 0x5e, 0xe8, 0x69, 0xd1, 0xd1, 0xfe, 0x39, 0x5f, 0x67, 0x93, 0x00, 0x3f, 0x5e, 0xca, 0x46, 0x50, 0x59, 0xc8, 0x86, 0x60, 0xd4, 0x46, 0xff, 0x5f, 0x08, 0x18, 0x55, 0x20, 0x22, 0x55, 0x7e, 0x38, 0xc0, 0x8a, 0x67, 0xea, 0xd9, 0x91, 0x26, 0x22, 0x54, 0xf1, 0x06, 0x82, 0x97, 0x5e, 0xc5, 0x63, 0x97, 0x76, 0x85, 0x37, 0xf4, 0x97, 0x7a, 0xf6, 0xd5, 0xf6, 0xaa, 0xce, 0xb7, 0xfb, 0x25, 0xde, 0xc5, 0x93, 0x72, 0x30, 0x23, 0x1f, 0xd8, 0x97, 0x8a, 0xf4, 0x91, 0x19, 0xa2, 0x9f, 0x29, 0xe4, 0x24, 0xab, 0x82, 0x72, 0xb4, 0x75, 0x62, 0x79, 0x2d, 0x5c, 0x94, 0xf7, 0x74, 0xb8, 0x82, 0x9d, 0x0b, 0x0d, 0x9f, 0x1a, 0x8c, 0x9e, 0xdd, 0xf3, 0x75, 0x74, 0xd5, 0xfa, 0x24, 0x8e, 0xef, 0xa9, 0xc5, 0x27, 0x1f, 0xc5, 0xec, 0x25, 0x79, 0xc8, 0x1b, 0xdd, 0x61, 0xb4, 0x10, 0xfa, 0x61, 0xfe, 0x36, 0xe4, 0x24, 0x22, 0x1c, 0x11, 0x3a, 0xdd, 0xb2, 0x75, 0x66, 0x4c, 0x80, 0x1d, 0x34, 0xca, 0x8c, 0x63, 0x51, 0xe4, 0xa8, 0x58, 
};
static const u8 rsa_oaep_102_salt[] = {
0x60, 0x6f, 0x3b, 0x99, 0xc0, 0xb9, 0xcc, 0xd7, 0x71, 0xea, 0xa2, 0x9e, 0xa0, 0xe4, 0xc8, 0x84, 0xf3, 0x18, 0x9c, 0xcc, 
};


static const rsa_test test_rsa_oaep_102 = {
	.name = "rsa_oaep_102",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_102_n,
	.nlen = sizeof(rsa_oaep_102_n),
	.d = (const u8*)&rsa_oaep_102_d,
	.dlen = sizeof(rsa_oaep_102_d),
	.e = (const u8*)&rsa_oaep_102_e,
	.elen = sizeof(rsa_oaep_102_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_102_m,
	.mlen = sizeof(rsa_oaep_102_m),
	.res = (const u8*)&rsa_oaep_102_res,
	.reslen = sizeof(rsa_oaep_102_res),
	.salt = (const u8*)&rsa_oaep_102_salt,
	.saltlen = sizeof(rsa_oaep_102_salt),
};
static const u8 rsa_oaep_103_CRT_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_103_CRT_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_103_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_103_CRT_m[] = {
0xf1, 0x45, 0x9b, 0x5f, 0x0c, 0x92, 0xf0, 0x1a, 0x0f, 0x72, 0x3a, 0x2e, 0x56, 0x62, 0x48, 0x4d, 0x8f, 0x8c, 0x0a, 0x20, 0xfc, 0x29, 0xda, 0xd6, 0xac, 0xd4, 0x3b, 0xb5, 0xf3, 0xef, 0xfd, 0xf4, 0xe1, 0xb6, 0x3e, 0x07, 0xfd, 0xfe, 0x66, 0x28, 0xd0, 0xd7, 0x4c, 0xa1, 0x9b, 0xf2, 0xd6, 0x9e, 0x4a, 0x0a, 0xbf, 0x86, 0xd2, 0x93, 0x92, 0x5a, 0x79, 0x67, 0x72, 0xf8, 0x08, 0x8e, 
};
static const u8 rsa_oaep_103_CRT_res[] = {
0xbc, 0xc3, 0x5f, 0x94, 0xcd, 0xe6, 0x6c, 0xb1, 0x13, 0x66, 0x25, 0xd6, 0x25, 0xb9, 0x44, 0x32, 0xa3, 0x5b, 0x22, 0xf3, 0xd2, 0xfa, 0x11, 0xa6, 0x13, 0xff, 0x0f, 0xca, 0x5b, 0xd5, 0x7f, 0x87, 0xb9, 0x02, 0xcc, 0xdc, 0x1c, 0xd0, 0xae, 0xbc, 0xb0, 0x71, 0x5e, 0xe8, 0x69, 0xd1, 0xd1, 0xfe, 0x39, 0x5f, 0x67, 0x93, 0x00, 0x3f, 0x5e, 0xca, 0x46, 0x50, 0x59, 0xc8, 0x86, 0x60, 0xd4, 0x46, 0xff, 0x5f, 0x08, 0x18, 0x55, 0x20, 0x22, 0x55, 0x7e, 0x38, 0xc0, 0x8a, 0x67, 0xea, 0xd9, 0x91, 0x26, 0x22, 0x54, 0xf1, 0x06, 0x82, 0x97, 0x5e, 0xc5, 0x63, 0x97, 0x76, 0x85, 0x37, 0xf4, 0x97, 0x7a, 0xf6, 0xd5, 0xf6, 0xaa, 0xce, 0xb7, 0xfb, 0x25, 0xde, 0xc5, 0x93, 0x72, 0x30, 0x23, 0x1f, 0xd8, 0x97, 0x8a, 0xf4, 0x91, 0x19, 0xa2, 0x9f, 0x29, 0xe4, 0x24, 0xab, 0x82, 0x72, 0xb4, 0x75, 0x62, 0x79, 0x2d, 0x5c, 0x94, 0xf7, 0x74, 0xb8, 0x82, 0x9d, 0x0b, 0x0d, 0x9f, 0x1a, 0x8c, 0x9e, 0xdd, 0xf3, 0x75, 0x74, 0xd5, 0xfa, 0x24, 0x8e, 0xef, 0xa9, 0xc5, 0x27, 0x1f, 0xc5, 0xec, 0x25, 0x79, 0xc8, 0x1b, 0xdd, 0x61, 0xb4, 0x10, 0xfa, 0x61, 0xfe, 0x36, 0xe4, 0x24, 0x22, 0x1c, 0x11, 0x3a, 0xdd, 0xb2, 0x75, 0x66, 0x4c, 0x80, 0x1d, 0x34, 0xca, 0x8c, 0x63, 0x51, 0xe4, 0xa8, 0x58, 
};
static const u8 rsa_oaep_103_CRT_salt[] = {
0x60, 0x6f, 0x3b, 0x99, 0xc0, 0xb9, 0xcc, 0xd7, 0x71, 0xea, 0xa2, 0x9e, 0xa0, 0xe4, 0xc8, 0x84, 0xf3, 0x18, 0x9c, 0xcc, 
};
static const u8 rsa_oaep_103_CRT_p[] = {
0xfc, 0x8d, 0x6c, 0x04, 0xbe, 0xc4, 0xeb, 0x9a, 0x81, 0x92, 0xca, 0x79, 0x00, 0xcb, 0xe5, 0x36, 0xe2, 0xe8, 0xb5, 0x19, 0xde, 0xcf, 0x33, 0xb2, 0x45, 0x97, 0x98, 0xc6, 0x90, 0x9d, 0xf4, 0xf1, 0x76, 0xdb, 0x7d, 0x23, 0x19, 0x0f, 0xc7, 0x2b, 0x88, 0x65, 0xa7, 0x18, 0xaf, 0x89, 0x5f, 0x1b, 0xcd, 0x91, 0x45, 0x29, 0x80, 0x27, 0x42, 0x3b, 0x60, 0x5e, 0x70, 0xa4, 0x7c, 0xf5, 0x83, 0x90, 0xa8, 0xc3, 0xe8, 0x8f, 0xc8, 0xc4, 0x8e, 0x8b, 0x32, 0xe3, 0xda, 0x21, 0x0d, 0xfb, 0xe3, 0xe8, 0x81, 0xea, 0x56, 0x74, 0xb6, 0xa3, 0x48, 0xc2, 0x1e, 0x93, 0xf9, 0xe5, 0x5e, 0xa6, 0x5e, 0xfd, 
};
static const u8 rsa_oaep_103_CRT_q[] = {
0xd2, 0x00, 0xd4, 0x5e, 0x78, 0x8a, 0xac, 0xea, 0x60, 0x6a, 0x40, 0x1d, 0x04, 0x60, 0xf8, 0x7d, 0xd5, 0xc1, 0x02, 0x7e, 0x12, 0xdc, 0x1a, 0x0d, 0x75, 0x86, 0xe8, 0x93, 0x9d, 0x9c, 0xf7, 0x89, 0xb4, 0x0f, 0x51, 0xac, 0x04, 0x42, 0x96, 0x1d, 0xe7, 0xd2, 0x1c, 0xc2, 0x1e, 0x05, 0xc8, 0x31, 0x55, 0xc1, 0xf2, 0xaa, 0x91, 0x93, 0x38, 0x7c, 0xfd, 0xf9, 0x56, 0xcb, 0x48, 0xd1, 0x53, 0xba, 0x27, 0x04, 0x06, 0xf9, 0xbb, 0xba, 0x53, 0x7d, 0x49, 0x87, 0xd9, 0xe2, 0xf9, 0x94, 0x2d, 0x7a, 0x14, 0xcb, 0xff, 0xfe, 0xa7, 0x4f, 0xec, 0xdd, 0xa9, 0x28, 0xd2, 0x3e, 0x25, 0x9f, 0x5e, 0xe1, 
};
static const u8 rsa_oaep_103_CRT_dP[] = {
0xdb, 0x16, 0x80, 0x2f, 0x79, 0xa2, 0xf0, 0xd4, 0x5f, 0x35, 0x8d, 0x69, 0xfd, 0x33, 0xe4, 0x4b, 0x81, 0xfa, 0xe8, 0x28, 0x62, 0x2e, 0x93, 0xa5, 0x42, 0x53, 0xe9, 0x97, 0xd0, 0x1b, 0x07, 0x43, 0x75, 0x9d, 0xa0, 0xe8, 0x12, 0xb4, 0xaa, 0x4e, 0x6c, 0x8b, 0xea, 0xb2, 0x32, 0x8d, 0x54, 0x31, 0x95, 0x5a, 0x41, 0x8a, 0x67, 0xff, 0x26, 0xa8, 0xc5, 0xc8, 0x07, 0xa5, 0xda, 0x35, 0x4e, 0x05, 0xef, 0x31, 0xcc, 0x8c, 0xf7, 0x58, 0xf4, 0x63, 0x73, 0x29, 0x50, 0xb0, 0x3e, 0x26, 0x57, 0x26, 0xfb, 0x94, 0xe3, 0x9d, 0x6a, 0x57, 0x2a, 0x26, 0x24, 0x4a, 0xb0, 0x8d, 0xb7, 0x57, 0x52, 0xad, 
};
static const u8 rsa_oaep_103_CRT_dQ[] = {
0xa0, 0xa3, 0x17, 0xcf, 0xe7, 0xdf, 0x14, 0x23, 0xf8, 0x7a, 0x6d, 0xee, 0x84, 0x51, 0xf4, 0xe2, 0xb4, 0xa6, 0x7e, 0x54, 0x97, 0xf2, 0x9b, 0x4f, 0x1e, 0x4e, 0x83, 0x0b, 0x9f, 0xad, 0xd9, 0x40, 0x11, 0x67, 0x02, 0x6f, 0x55, 0x96, 0xe5, 0xa3, 0x9c, 0x97, 0x81, 0x7e, 0x0f, 0x5f, 0x16, 0xe2, 0x7e, 0x19, 0xec, 0x99, 0x02, 0xe0, 0x1d, 0x7e, 0xa6, 0xfb, 0x9a, 0xa3, 0xc7, 0x60, 0xaf, 0xee, 0x1e, 0x38, 0x1b, 0x69, 0xde, 0x6a, 0xc9, 0xc0, 0x75, 0x85, 0xa0, 0x6a, 0xd9, 0xc4, 0xba, 0x00, 0xbf, 0x75, 0xc8, 0xad, 0x2f, 0xa8, 0x98, 0xa4, 0x79, 0xe8, 0x0a, 0xe2, 0x94, 0xfe, 0xd2, 0xa1, 
};
static const u8 rsa_oaep_103_CRT_qInv[] = {
0x0b, 0x21, 0xf3, 0x35, 0xc3, 0x53, 0x34, 0x2e, 0xb4, 0x4c, 0x3a, 0xa2, 0x44, 0x45, 0x78, 0x0c, 0x2d, 0x65, 0x5b, 0x94, 0x01, 0x74, 0xca, 0xe3, 0x8c, 0x7c, 0x8a, 0x4e, 0x64, 0x93, 0xc0, 0xba, 0x9f, 0xd3, 0x03, 0x74, 0x82, 0x67, 0xb0, 0x83, 0xb9, 0xa7, 0xa6, 0xcb, 0x61, 0xe4, 0x2d, 0xb3, 0x62, 0xb8, 0xc9, 0x89, 0x6d, 0xb7, 0x06, 0x4e, 0x02, 0xad, 0x5a, 0xe6, 0x15, 0x87, 0xda, 0x15, 0xb4, 0x64, 0x9c, 0x90, 0x59, 0x49, 0x09, 0xfe, 0xb3, 0x7d, 0xbc, 0xb6, 0x54, 0xbe, 0xb7, 0x26, 0x8e, 0xc8, 0x01, 0xe5, 0xa8, 0xb4, 0xaa, 0x39, 0x11, 0xbe, 0xbd, 0x88, 0x54, 0x2f, 0x05, 0xbe, 
};


static const rsa_test test_rsa_oaep_103_CRT = {
	.name = "rsa_oaep_103_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_103_CRT_n,
	.nlen = sizeof(rsa_oaep_103_CRT_n),
	.d = (const u8*)&rsa_oaep_103_CRT_d,
	.dlen = sizeof(rsa_oaep_103_CRT_d),
	.e = (const u8*)&rsa_oaep_103_CRT_e,
	.elen = sizeof(rsa_oaep_103_CRT_e),
	.p = (const u8*)&rsa_oaep_103_CRT_p,
	.plen = sizeof(rsa_oaep_103_CRT_p),
	.q = (const u8*)&rsa_oaep_103_CRT_q,
	.qlen = sizeof(rsa_oaep_103_CRT_q),
	.dP = (const u8*)&rsa_oaep_103_CRT_dP,
	.dPlen = sizeof(rsa_oaep_103_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_103_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_103_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_103_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_103_CRT_qInv),
	.m = (const u8*)&rsa_oaep_103_CRT_m,
	.mlen = sizeof(rsa_oaep_103_CRT_m),
	.res = (const u8*)&rsa_oaep_103_CRT_res,
	.reslen = sizeof(rsa_oaep_103_CRT_res),
	.salt = (const u8*)&rsa_oaep_103_CRT_salt,
	.saltlen = sizeof(rsa_oaep_103_CRT_salt),
};
static const u8 rsa_oaep_104_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_104_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_104_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_104_m[] = {
0x53, 0xe6, 0xe8, 0xc7, 0x29, 0xd6, 0xf9, 0xc3, 0x19, 0xdd, 0x31, 0x7e, 0x74, 0xb0, 0xdb, 0x8e, 0x4c, 0xcc, 0xa2, 0x5f, 0x3c, 0x83, 0x05, 0x74, 0x6e, 0x13, 0x7a, 0xc6, 0x3a, 0x63, 0xef, 0x37, 0x39, 0xe7, 0xb5, 0x95, 0xab, 0xb9, 0x6e, 0x8d, 0x55, 0xe5, 0x4f, 0x7b, 0xd4, 0x1a, 0xb4, 0x33, 0x37, 0x8f, 0xfb, 0x91, 0x1d, 
};
static const u8 rsa_oaep_104_res[] = {
0x23, 0x2a, 0xfb, 0xc9, 0x27, 0xfa, 0x08, 0xc2, 0xf6, 0xa2, 0x7b, 0x87, 0xd4, 0xa5, 0xcb, 0x09, 0xc0, 0x7d, 0xc2, 0x6f, 0xae, 0x73, 0xd7, 0x3a, 0x90, 0x55, 0x88, 0x39, 0xf4, 0xfd, 0x66, 0xd2, 0x81, 0xb8, 0x7e, 0xc7, 0x34, 0xbc, 0xe2, 0x37, 0xba, 0x16, 0x66, 0x98, 0xed, 0x82, 0x91, 0x06, 0xa7, 0xde, 0x69, 0x42, 0xcd, 0x6c, 0xdc, 0xe7, 0x8f, 0xed, 0x8d, 0x2e, 0x4d, 0x81, 0x42, 0x8e, 0x66, 0x49, 0x0d, 0x03, 0x62, 0x64, 0xce, 0xf9, 0x2a, 0xf9, 0x41, 0xd3, 0xe3, 0x50, 0x55, 0xfe, 0x39, 0x81, 0xe1, 0x4d, 0x29, 0xcb, 0xb9, 0xa4, 0xf6, 0x74, 0x73, 0x06, 0x3b, 0xae, 0xc7, 0x9a, 0x11, 0x79, 0xf5, 0xa1, 0x7c, 0x9c, 0x18, 0x32, 0xf2, 0x83, 0x8f, 0xd7, 0xd5, 0xe5, 0x9b, 0xb9, 0x65, 0x9d, 0x56, 0xdc, 0xe8, 0xa0, 0x19, 0xed, 0xef, 0x1b, 0xb3, 0xac, 0xcc, 0x69, 0x7c, 0xc6, 0xcc, 0x7a, 0x77, 0x8f, 0x60, 0xa0, 0x64, 0xc7, 0xf6, 0xf5, 0xd5, 0x29, 0xc6, 0x21, 0x02, 0x62, 0xe0, 0x03, 0xde, 0x58, 0x3e, 0x81, 0xe3, 0x16, 0x7b, 0x89, 0x97, 0x1f, 0xb8, 0xc0, 0xe1, 0x5d, 0x44, 0xff, 0xfe, 0xf8, 0x9b, 0x53, 0xd8, 0xd6, 0x4d, 0xd7, 0x97, 0xd1, 0x59, 0xb5, 0x6d, 0x2b, 0x08, 0xea, 0x53, 0x07, 0xea, 0x12, 0xc2, 0x41, 0xbd, 0x58, 0xd4, 0xee, 0x27, 0x8a, 0x1f, 0x2e, 
};
static const u8 rsa_oaep_104_salt[] = {
0xfc, 0xbc, 0x42, 0x14, 0x02, 0xe9, 0xec, 0xab, 0xc6, 0x08, 0x2a, 0xfa, 0x40, 0xba, 0x5f, 0x26, 0x52, 0x2c, 0x84, 0x0e, 
};


static const rsa_test test_rsa_oaep_104 = {
	.name = "rsa_oaep_104",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_104_n,
	.nlen = sizeof(rsa_oaep_104_n),
	.d = (const u8*)&rsa_oaep_104_d,
	.dlen = sizeof(rsa_oaep_104_d),
	.e = (const u8*)&rsa_oaep_104_e,
	.elen = sizeof(rsa_oaep_104_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_104_m,
	.mlen = sizeof(rsa_oaep_104_m),
	.res = (const u8*)&rsa_oaep_104_res,
	.reslen = sizeof(rsa_oaep_104_res),
	.salt = (const u8*)&rsa_oaep_104_salt,
	.saltlen = sizeof(rsa_oaep_104_salt),
};
static const u8 rsa_oaep_105_CRT_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_105_CRT_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_105_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_105_CRT_m[] = {
0x53, 0xe6, 0xe8, 0xc7, 0x29, 0xd6, 0xf9, 0xc3, 0x19, 0xdd, 0x31, 0x7e, 0x74, 0xb0, 0xdb, 0x8e, 0x4c, 0xcc, 0xa2, 0x5f, 0x3c, 0x83, 0x05, 0x74, 0x6e, 0x13, 0x7a, 0xc6, 0x3a, 0x63, 0xef, 0x37, 0x39, 0xe7, 0xb5, 0x95, 0xab, 0xb9, 0x6e, 0x8d, 0x55, 0xe5, 0x4f, 0x7b, 0xd4, 0x1a, 0xb4, 0x33, 0x37, 0x8f, 0xfb, 0x91, 0x1d, 
};
static const u8 rsa_oaep_105_CRT_res[] = {
0x23, 0x2a, 0xfb, 0xc9, 0x27, 0xfa, 0x08, 0xc2, 0xf6, 0xa2, 0x7b, 0x87, 0xd4, 0xa5, 0xcb, 0x09, 0xc0, 0x7d, 0xc2, 0x6f, 0xae, 0x73, 0xd7, 0x3a, 0x90, 0x55, 0x88, 0x39, 0xf4, 0xfd, 0x66, 0xd2, 0x81, 0xb8, 0x7e, 0xc7, 0x34, 0xbc, 0xe2, 0x37, 0xba, 0x16, 0x66, 0x98, 0xed, 0x82, 0x91, 0x06, 0xa7, 0xde, 0x69, 0x42, 0xcd, 0x6c, 0xdc, 0xe7, 0x8f, 0xed, 0x8d, 0x2e, 0x4d, 0x81, 0x42, 0x8e, 0x66, 0x49, 0x0d, 0x03, 0x62, 0x64, 0xce, 0xf9, 0x2a, 0xf9, 0x41, 0xd3, 0xe3, 0x50, 0x55, 0xfe, 0x39, 0x81, 0xe1, 0x4d, 0x29, 0xcb, 0xb9, 0xa4, 0xf6, 0x74, 0x73, 0x06, 0x3b, 0xae, 0xc7, 0x9a, 0x11, 0x79, 0xf5, 0xa1, 0x7c, 0x9c, 0x18, 0x32, 0xf2, 0x83, 0x8f, 0xd7, 0xd5, 0xe5, 0x9b, 0xb9, 0x65, 0x9d, 0x56, 0xdc, 0xe8, 0xa0, 0x19, 0xed, 0xef, 0x1b, 0xb3, 0xac, 0xcc, 0x69, 0x7c, 0xc6, 0xcc, 0x7a, 0x77, 0x8f, 0x60, 0xa0, 0x64, 0xc7, 0xf6, 0xf5, 0xd5, 0x29, 0xc6, 0x21, 0x02, 0x62, 0xe0, 0x03, 0xde, 0x58, 0x3e, 0x81, 0xe3, 0x16, 0x7b, 0x89, 0x97, 0x1f, 0xb8, 0xc0, 0xe1, 0x5d, 0x44, 0xff, 0xfe, 0xf8, 0x9b, 0x53, 0xd8, 0xd6, 0x4d, 0xd7, 0x97, 0xd1, 0x59, 0xb5, 0x6d, 0x2b, 0x08, 0xea, 0x53, 0x07, 0xea, 0x12, 0xc2, 0x41, 0xbd, 0x58, 0xd4, 0xee, 0x27, 0x8a, 0x1f, 0x2e, 
};
static const u8 rsa_oaep_105_CRT_salt[] = {
0xfc, 0xbc, 0x42, 0x14, 0x02, 0xe9, 0xec, 0xab, 0xc6, 0x08, 0x2a, 0xfa, 0x40, 0xba, 0x5f, 0x26, 0x52, 0x2c, 0x84, 0x0e, 
};
static const u8 rsa_oaep_105_CRT_p[] = {
0xfc, 0x8d, 0x6c, 0x04, 0xbe, 0xc4, 0xeb, 0x9a, 0x81, 0x92, 0xca, 0x79, 0x00, 0xcb, 0xe5, 0x36, 0xe2, 0xe8, 0xb5, 0x19, 0xde, 0xcf, 0x33, 0xb2, 0x45, 0x97, 0x98, 0xc6, 0x90, 0x9d, 0xf4, 0xf1, 0x76, 0xdb, 0x7d, 0x23, 0x19, 0x0f, 0xc7, 0x2b, 0x88, 0x65, 0xa7, 0x18, 0xaf, 0x89, 0x5f, 0x1b, 0xcd, 0x91, 0x45, 0x29, 0x80, 0x27, 0x42, 0x3b, 0x60, 0x5e, 0x70, 0xa4, 0x7c, 0xf5, 0x83, 0x90, 0xa8, 0xc3, 0xe8, 0x8f, 0xc8, 0xc4, 0x8e, 0x8b, 0x32, 0xe3, 0xda, 0x21, 0x0d, 0xfb, 0xe3, 0xe8, 0x81, 0xea, 0x56, 0x74, 0xb6, 0xa3, 0x48, 0xc2, 0x1e, 0x93, 0xf9, 0xe5, 0x5e, 0xa6, 0x5e, 0xfd, 
};
static const u8 rsa_oaep_105_CRT_q[] = {
0xd2, 0x00, 0xd4, 0x5e, 0x78, 0x8a, 0xac, 0xea, 0x60, 0x6a, 0x40, 0x1d, 0x04, 0x60, 0xf8, 0x7d, 0xd5, 0xc1, 0x02, 0x7e, 0x12, 0xdc, 0x1a, 0x0d, 0x75, 0x86, 0xe8, 0x93, 0x9d, 0x9c, 0xf7, 0x89, 0xb4, 0x0f, 0x51, 0xac, 0x04, 0x42, 0x96, 0x1d, 0xe7, 0xd2, 0x1c, 0xc2, 0x1e, 0x05, 0xc8, 0x31, 0x55, 0xc1, 0xf2, 0xaa, 0x91, 0x93, 0x38, 0x7c, 0xfd, 0xf9, 0x56, 0xcb, 0x48, 0xd1, 0x53, 0xba, 0x27, 0x04, 0x06, 0xf9, 0xbb, 0xba, 0x53, 0x7d, 0x49, 0x87, 0xd9, 0xe2, 0xf9, 0x94, 0x2d, 0x7a, 0x14, 0xcb, 0xff, 0xfe, 0xa7, 0x4f, 0xec, 0xdd, 0xa9, 0x28, 0xd2, 0x3e, 0x25, 0x9f, 0x5e, 0xe1, 
};
static const u8 rsa_oaep_105_CRT_dP[] = {
0xdb, 0x16, 0x80, 0x2f, 0x79, 0xa2, 0xf0, 0xd4, 0x5f, 0x35, 0x8d, 0x69, 0xfd, 0x33, 0xe4, 0x4b, 0x81, 0xfa, 0xe8, 0x28, 0x62, 0x2e, 0x93, 0xa5, 0x42, 0x53, 0xe9, 0x97, 0xd0, 0x1b, 0x07, 0x43, 0x75, 0x9d, 0xa0, 0xe8, 0x12, 0xb4, 0xaa, 0x4e, 0x6c, 0x8b, 0xea, 0xb2, 0x32, 0x8d, 0x54, 0x31, 0x95, 0x5a, 0x41, 0x8a, 0x67, 0xff, 0x26, 0xa8, 0xc5, 0xc8, 0x07, 0xa5, 0xda, 0x35, 0x4e, 0x05, 0xef, 0x31, 0xcc, 0x8c, 0xf7, 0x58, 0xf4, 0x63, 0x73, 0x29, 0x50, 0xb0, 0x3e, 0x26, 0x57, 0x26, 0xfb, 0x94, 0xe3, 0x9d, 0x6a, 0x57, 0x2a, 0x26, 0x24, 0x4a, 0xb0, 0x8d, 0xb7, 0x57, 0x52, 0xad, 
};
static const u8 rsa_oaep_105_CRT_dQ[] = {
0xa0, 0xa3, 0x17, 0xcf, 0xe7, 0xdf, 0x14, 0x23, 0xf8, 0x7a, 0x6d, 0xee, 0x84, 0x51, 0xf4, 0xe2, 0xb4, 0xa6, 0x7e, 0x54, 0x97, 0xf2, 0x9b, 0x4f, 0x1e, 0x4e, 0x83, 0x0b, 0x9f, 0xad, 0xd9, 0x40, 0x11, 0x67, 0x02, 0x6f, 0x55, 0x96, 0xe5, 0xa3, 0x9c, 0x97, 0x81, 0x7e, 0x0f, 0x5f, 0x16, 0xe2, 0x7e, 0x19, 0xec, 0x99, 0x02, 0xe0, 0x1d, 0x7e, 0xa6, 0xfb, 0x9a, 0xa3, 0xc7, 0x60, 0xaf, 0xee, 0x1e, 0x38, 0x1b, 0x69, 0xde, 0x6a, 0xc9, 0xc0, 0x75, 0x85, 0xa0, 0x6a, 0xd9, 0xc4, 0xba, 0x00, 0xbf, 0x75, 0xc8, 0xad, 0x2f, 0xa8, 0x98, 0xa4, 0x79, 0xe8, 0x0a, 0xe2, 0x94, 0xfe, 0xd2, 0xa1, 
};
static const u8 rsa_oaep_105_CRT_qInv[] = {
0x0b, 0x21, 0xf3, 0x35, 0xc3, 0x53, 0x34, 0x2e, 0xb4, 0x4c, 0x3a, 0xa2, 0x44, 0x45, 0x78, 0x0c, 0x2d, 0x65, 0x5b, 0x94, 0x01, 0x74, 0xca, 0xe3, 0x8c, 0x7c, 0x8a, 0x4e, 0x64, 0x93, 0xc0, 0xba, 0x9f, 0xd3, 0x03, 0x74, 0x82, 0x67, 0xb0, 0x83, 0xb9, 0xa7, 0xa6, 0xcb, 0x61, 0xe4, 0x2d, 0xb3, 0x62, 0xb8, 0xc9, 0x89, 0x6d, 0xb7, 0x06, 0x4e, 0x02, 0xad, 0x5a, 0xe6, 0x15, 0x87, 0xda, 0x15, 0xb4, 0x64, 0x9c, 0x90, 0x59, 0x49, 0x09, 0xfe, 0xb3, 0x7d, 0xbc, 0xb6, 0x54, 0xbe, 0xb7, 0x26, 0x8e, 0xc8, 0x01, 0xe5, 0xa8, 0xb4, 0xaa, 0x39, 0x11, 0xbe, 0xbd, 0x88, 0x54, 0x2f, 0x05, 0xbe, 
};


static const rsa_test test_rsa_oaep_105_CRT = {
	.name = "rsa_oaep_105_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_105_CRT_n,
	.nlen = sizeof(rsa_oaep_105_CRT_n),
	.d = (const u8*)&rsa_oaep_105_CRT_d,
	.dlen = sizeof(rsa_oaep_105_CRT_d),
	.e = (const u8*)&rsa_oaep_105_CRT_e,
	.elen = sizeof(rsa_oaep_105_CRT_e),
	.p = (const u8*)&rsa_oaep_105_CRT_p,
	.plen = sizeof(rsa_oaep_105_CRT_p),
	.q = (const u8*)&rsa_oaep_105_CRT_q,
	.qlen = sizeof(rsa_oaep_105_CRT_q),
	.dP = (const u8*)&rsa_oaep_105_CRT_dP,
	.dPlen = sizeof(rsa_oaep_105_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_105_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_105_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_105_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_105_CRT_qInv),
	.m = (const u8*)&rsa_oaep_105_CRT_m,
	.mlen = sizeof(rsa_oaep_105_CRT_m),
	.res = (const u8*)&rsa_oaep_105_CRT_res,
	.reslen = sizeof(rsa_oaep_105_CRT_res),
	.salt = (const u8*)&rsa_oaep_105_CRT_salt,
	.saltlen = sizeof(rsa_oaep_105_CRT_salt),
};
static const u8 rsa_oaep_106_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_106_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_106_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_106_m[] = {
0xb6, 0xb2, 0x8e, 0xa2, 0x19, 0x8d, 0x0c, 0x10, 0x08, 0xbc, 0x64, 
};
static const u8 rsa_oaep_106_res[] = {
0x43, 0x8c, 0xc7, 0xdc, 0x08, 0xa6, 0x8d, 0xa2, 0x49, 0xe4, 0x25, 0x05, 0xf8, 0x57, 0x3b, 0xa6, 0x0e, 0x2c, 0x27, 0x73, 0xd5, 0xb2, 0x90, 0xf4, 0xcf, 0x9d, 0xff, 0x71, 0x8e, 0x84, 0x20, 0x81, 0xc3, 0x83, 0xe6, 0x70, 0x24, 0xa0, 0xf2, 0x95, 0x94, 0xea, 0x98, 0x7b, 0x9d, 0x25, 0xe4, 0xb7, 0x38, 0xf2, 0x85, 0x97, 0x0d, 0x19, 0x5a, 0xbb, 0x3a, 0x8c, 0x80, 0x54, 0xe3, 0xd7, 0x9d, 0x6b, 0x9c, 0x9a, 0x83, 0x27, 0xba, 0x59, 0x6f, 0x12, 0x59, 0xe2, 0x71, 0x26, 0x67, 0x47, 0x66, 0x90, 0x7d, 0x8d, 0x58, 0x2f, 0xf3, 0xa8, 0x47, 0x61, 0x54, 0x92, 0x9a, 0xdb, 0x1e, 0x6d, 0x12, 0x35, 0xb2, 0xcc, 0xb4, 0xec, 0x8f, 0x66, 0x3b, 0xa9, 0xcc, 0x67, 0x0a, 0x92, 0xbe, 0xbd, 0x85, 0x3c, 0x8d, 0xbf, 0x69, 0xc6, 0x43, 0x6d, 0x01, 0x6f, 0x61, 0xad, 0xd8, 0x36, 0xe9, 0x47, 0x32, 0x45, 0x04, 0x34, 0x20, 0x7f, 0x9f, 0xd4, 0xc4, 0x3d, 0xec, 0x2a, 0x12, 0xa9, 0x58, 0xef, 0xa0, 0x1e, 0xfe, 0x26, 0x69, 0x89, 0x9b, 0x5e, 0x60, 0x4c, 0x25, 0x5c, 0x55, 0xfb, 0x71, 0x66, 0xde, 0x55, 0x89, 0xe3, 0x69, 0x59, 0x7b, 0xb0, 0x91, 0x68, 0xc0, 0x6d, 0xd5, 0xdb, 0x17, 0x7e, 0x06, 0xa1, 0x74, 0x0e, 0xb2, 0xd5, 0xc8, 0x2f, 0xae, 0xca, 0x6d, 0x92, 0xfc, 0xee, 0x99, 0x31, 0xba, 0x9f, 
};
static const u8 rsa_oaep_106_salt[] = {
0x23, 0xaa, 0xde, 0x0e, 0x1e, 0x08, 0xbb, 0x9b, 0x9a, 0x78, 0xd2, 0x30, 0x2a, 0x52, 0xf9, 0xc2, 0x1b, 0x2e, 0x1b, 0xa2, 
};


static const rsa_test test_rsa_oaep_106 = {
	.name = "rsa_oaep_106",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_106_n,
	.nlen = sizeof(rsa_oaep_106_n),
	.d = (const u8*)&rsa_oaep_106_d,
	.dlen = sizeof(rsa_oaep_106_d),
	.e = (const u8*)&rsa_oaep_106_e,
	.elen = sizeof(rsa_oaep_106_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_106_m,
	.mlen = sizeof(rsa_oaep_106_m),
	.res = (const u8*)&rsa_oaep_106_res,
	.reslen = sizeof(rsa_oaep_106_res),
	.salt = (const u8*)&rsa_oaep_106_salt,
	.saltlen = sizeof(rsa_oaep_106_salt),
};
static const u8 rsa_oaep_107_CRT_n[] = {
0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d, 
};
static const u8 rsa_oaep_107_CRT_d[] = {
0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1, 
};
static const u8 rsa_oaep_107_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_107_CRT_m[] = {
0xb6, 0xb2, 0x8e, 0xa2, 0x19, 0x8d, 0x0c, 0x10, 0x08, 0xbc, 0x64, 
};
static const u8 rsa_oaep_107_CRT_res[] = {
0x43, 0x8c, 0xc7, 0xdc, 0x08, 0xa6, 0x8d, 0xa2, 0x49, 0xe4, 0x25, 0x05, 0xf8, 0x57, 0x3b, 0xa6, 0x0e, 0x2c, 0x27, 0x73, 0xd5, 0xb2, 0x90, 0xf4, 0xcf, 0x9d, 0xff, 0x71, 0x8e, 0x84, 0x20, 0x81, 0xc3, 0x83, 0xe6, 0x70, 0x24, 0xa0, 0xf2, 0x95, 0x94, 0xea, 0x98, 0x7b, 0x9d, 0x25, 0xe4, 0xb7, 0x38, 0xf2, 0x85, 0x97, 0x0d, 0x19, 0x5a, 0xbb, 0x3a, 0x8c, 0x80, 0x54, 0xe3, 0xd7, 0x9d, 0x6b, 0x9c, 0x9a, 0x83, 0x27, 0xba, 0x59, 0x6f, 0x12, 0x59, 0xe2, 0x71, 0x26, 0x67, 0x47, 0x66, 0x90, 0x7d, 0x8d, 0x58, 0x2f, 0xf3, 0xa8, 0x47, 0x61, 0x54, 0x92, 0x9a, 0xdb, 0x1e, 0x6d, 0x12, 0x35, 0xb2, 0xcc, 0xb4, 0xec, 0x8f, 0x66, 0x3b, 0xa9, 0xcc, 0x67, 0x0a, 0x92, 0xbe, 0xbd, 0x85, 0x3c, 0x8d, 0xbf, 0x69, 0xc6, 0x43, 0x6d, 0x01, 0x6f, 0x61, 0xad, 0xd8, 0x36, 0xe9, 0x47, 0x32, 0x45, 0x04, 0x34, 0x20, 0x7f, 0x9f, 0xd4, 0xc4, 0x3d, 0xec, 0x2a, 0x12, 0xa9, 0x58, 0xef, 0xa0, 0x1e, 0xfe, 0x26, 0x69, 0x89, 0x9b, 0x5e, 0x60, 0x4c, 0x25, 0x5c, 0x55, 0xfb, 0x71, 0x66, 0xde, 0x55, 0x89, 0xe3, 0x69, 0x59, 0x7b, 0xb0, 0x91, 0x68, 0xc0, 0x6d, 0xd5, 0xdb, 0x17, 0x7e, 0x06, 0xa1, 0x74, 0x0e, 0xb2, 0xd5, 0xc8, 0x2f, 0xae, 0xca, 0x6d, 0x92, 0xfc, 0xee, 0x99, 0x31, 0xba, 0x9f, 
};
static const u8 rsa_oaep_107_CRT_salt[] = {
0x23, 0xaa, 0xde, 0x0e, 0x1e, 0x08, 0xbb, 0x9b, 0x9a, 0x78, 0xd2, 0x30, 0x2a, 0x52, 0xf9, 0xc2, 0x1b, 0x2e, 0x1b, 0xa2, 
};
static const u8 rsa_oaep_107_CRT_p[] = {
0xfc, 0x8d, 0x6c, 0x04, 0xbe, 0xc4, 0xeb, 0x9a, 0x81, 0x92, 0xca, 0x79, 0x00, 0xcb, 0xe5, 0x36, 0xe2, 0xe8, 0xb5, 0x19, 0xde, 0xcf, 0x33, 0xb2, 0x45, 0x97, 0x98, 0xc6, 0x90, 0x9d, 0xf4, 0xf1, 0x76, 0xdb, 0x7d, 0x23, 0x19, 0x0f, 0xc7, 0x2b, 0x88, 0x65, 0xa7, 0x18, 0xaf, 0x89, 0x5f, 0x1b, 0xcd, 0x91, 0x45, 0x29, 0x80, 0x27, 0x42, 0x3b, 0x60, 0x5e, 0x70, 0xa4, 0x7c, 0xf5, 0x83, 0x90, 0xa8, 0xc3, 0xe8, 0x8f, 0xc8, 0xc4, 0x8e, 0x8b, 0x32, 0xe3, 0xda, 0x21, 0x0d, 0xfb, 0xe3, 0xe8, 0x81, 0xea, 0x56, 0x74, 0xb6, 0xa3, 0x48, 0xc2, 0x1e, 0x93, 0xf9, 0xe5, 0x5e, 0xa6, 0x5e, 0xfd, 
};
static const u8 rsa_oaep_107_CRT_q[] = {
0xd2, 0x00, 0xd4, 0x5e, 0x78, 0x8a, 0xac, 0xea, 0x60, 0x6a, 0x40, 0x1d, 0x04, 0x60, 0xf8, 0x7d, 0xd5, 0xc1, 0x02, 0x7e, 0x12, 0xdc, 0x1a, 0x0d, 0x75, 0x86, 0xe8, 0x93, 0x9d, 0x9c, 0xf7, 0x89, 0xb4, 0x0f, 0x51, 0xac, 0x04, 0x42, 0x96, 0x1d, 0xe7, 0xd2, 0x1c, 0xc2, 0x1e, 0x05, 0xc8, 0x31, 0x55, 0xc1, 0xf2, 0xaa, 0x91, 0x93, 0x38, 0x7c, 0xfd, 0xf9, 0x56, 0xcb, 0x48, 0xd1, 0x53, 0xba, 0x27, 0x04, 0x06, 0xf9, 0xbb, 0xba, 0x53, 0x7d, 0x49, 0x87, 0xd9, 0xe2, 0xf9, 0x94, 0x2d, 0x7a, 0x14, 0xcb, 0xff, 0xfe, 0xa7, 0x4f, 0xec, 0xdd, 0xa9, 0x28, 0xd2, 0x3e, 0x25, 0x9f, 0x5e, 0xe1, 
};
static const u8 rsa_oaep_107_CRT_dP[] = {
0xdb, 0x16, 0x80, 0x2f, 0x79, 0xa2, 0xf0, 0xd4, 0x5f, 0x35, 0x8d, 0x69, 0xfd, 0x33, 0xe4, 0x4b, 0x81, 0xfa, 0xe8, 0x28, 0x62, 0x2e, 0x93, 0xa5, 0x42, 0x53, 0xe9, 0x97, 0xd0, 0x1b, 0x07, 0x43, 0x75, 0x9d, 0xa0, 0xe8, 0x12, 0xb4, 0xaa, 0x4e, 0x6c, 0x8b, 0xea, 0xb2, 0x32, 0x8d, 0x54, 0x31, 0x95, 0x5a, 0x41, 0x8a, 0x67, 0xff, 0x26, 0xa8, 0xc5, 0xc8, 0x07, 0xa5, 0xda, 0x35, 0x4e, 0x05, 0xef, 0x31, 0xcc, 0x8c, 0xf7, 0x58, 0xf4, 0x63, 0x73, 0x29, 0x50, 0xb0, 0x3e, 0x26, 0x57, 0x26, 0xfb, 0x94, 0xe3, 0x9d, 0x6a, 0x57, 0x2a, 0x26, 0x24, 0x4a, 0xb0, 0x8d, 0xb7, 0x57, 0x52, 0xad, 
};
static const u8 rsa_oaep_107_CRT_dQ[] = {
0xa0, 0xa3, 0x17, 0xcf, 0xe7, 0xdf, 0x14, 0x23, 0xf8, 0x7a, 0x6d, 0xee, 0x84, 0x51, 0xf4, 0xe2, 0xb4, 0xa6, 0x7e, 0x54, 0x97, 0xf2, 0x9b, 0x4f, 0x1e, 0x4e, 0x83, 0x0b, 0x9f, 0xad, 0xd9, 0x40, 0x11, 0x67, 0x02, 0x6f, 0x55, 0x96, 0xe5, 0xa3, 0x9c, 0x97, 0x81, 0x7e, 0x0f, 0x5f, 0x16, 0xe2, 0x7e, 0x19, 0xec, 0x99, 0x02, 0xe0, 0x1d, 0x7e, 0xa6, 0xfb, 0x9a, 0xa3, 0xc7, 0x60, 0xaf, 0xee, 0x1e, 0x38, 0x1b, 0x69, 0xde, 0x6a, 0xc9, 0xc0, 0x75, 0x85, 0xa0, 0x6a, 0xd9, 0xc4, 0xba, 0x00, 0xbf, 0x75, 0xc8, 0xad, 0x2f, 0xa8, 0x98, 0xa4, 0x79, 0xe8, 0x0a, 0xe2, 0x94, 0xfe, 0xd2, 0xa1, 
};
static const u8 rsa_oaep_107_CRT_qInv[] = {
0x0b, 0x21, 0xf3, 0x35, 0xc3, 0x53, 0x34, 0x2e, 0xb4, 0x4c, 0x3a, 0xa2, 0x44, 0x45, 0x78, 0x0c, 0x2d, 0x65, 0x5b, 0x94, 0x01, 0x74, 0xca, 0xe3, 0x8c, 0x7c, 0x8a, 0x4e, 0x64, 0x93, 0xc0, 0xba, 0x9f, 0xd3, 0x03, 0x74, 0x82, 0x67, 0xb0, 0x83, 0xb9, 0xa7, 0xa6, 0xcb, 0x61, 0xe4, 0x2d, 0xb3, 0x62, 0xb8, 0xc9, 0x89, 0x6d, 0xb7, 0x06, 0x4e, 0x02, 0xad, 0x5a, 0xe6, 0x15, 0x87, 0xda, 0x15, 0xb4, 0x64, 0x9c, 0x90, 0x59, 0x49, 0x09, 0xfe, 0xb3, 0x7d, 0xbc, 0xb6, 0x54, 0xbe, 0xb7, 0x26, 0x8e, 0xc8, 0x01, 0xe5, 0xa8, 0xb4, 0xaa, 0x39, 0x11, 0xbe, 0xbd, 0x88, 0x54, 0x2f, 0x05, 0xbe, 
};


static const rsa_test test_rsa_oaep_107_CRT = {
	.name = "rsa_oaep_107_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 1536,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_107_CRT_n,
	.nlen = sizeof(rsa_oaep_107_CRT_n),
	.d = (const u8*)&rsa_oaep_107_CRT_d,
	.dlen = sizeof(rsa_oaep_107_CRT_d),
	.e = (const u8*)&rsa_oaep_107_CRT_e,
	.elen = sizeof(rsa_oaep_107_CRT_e),
	.p = (const u8*)&rsa_oaep_107_CRT_p,
	.plen = sizeof(rsa_oaep_107_CRT_p),
	.q = (const u8*)&rsa_oaep_107_CRT_q,
	.qlen = sizeof(rsa_oaep_107_CRT_q),
	.dP = (const u8*)&rsa_oaep_107_CRT_dP,
	.dPlen = sizeof(rsa_oaep_107_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_107_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_107_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_107_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_107_CRT_qInv),
	.m = (const u8*)&rsa_oaep_107_CRT_m,
	.mlen = sizeof(rsa_oaep_107_CRT_m),
	.res = (const u8*)&rsa_oaep_107_CRT_res,
	.reslen = sizeof(rsa_oaep_107_CRT_res),
	.salt = (const u8*)&rsa_oaep_107_CRT_salt,
	.saltlen = sizeof(rsa_oaep_107_CRT_salt),
};
static const u8 rsa_oaep_108_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_108_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_108_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_108_m[] = {
0x8b, 0xba, 0x6b, 0xf8, 0x2a, 0x6c, 0x0f, 0x86, 0xd5, 0xf1, 0x75, 0x6e, 0x97, 0x95, 0x68, 0x70, 0xb0, 0x89, 0x53, 0xb0, 0x6b, 0x4e, 0xb2, 0x05, 0xbc, 0x16, 0x94, 0xee, 
};
static const u8 rsa_oaep_108_res[] = {
0x53, 0xea, 0x5d, 0xc0, 0x8c, 0xd2, 0x60, 0xfb, 0x3b, 0x85, 0x85, 0x67, 0x28, 0x7f, 0xa9, 0x15, 0x52, 0xc3, 0x0b, 0x2f, 0xeb, 0xfb, 0xa2, 0x13, 0xf0, 0xae, 0x87, 0x70, 0x2d, 0x06, 0x8d, 0x19, 0xba, 0xb0, 0x7f, 0xe5, 0x74, 0x52, 0x3d, 0xfb, 0x42, 0x13, 0x9d, 0x68, 0xc3, 0xc5, 0xaf, 0xee, 0xe0, 0xbf, 0xe4, 0xcb, 0x79, 0x69, 0xcb, 0xf3, 0x82, 0xb8, 0x04, 0xd6, 0xe6, 0x13, 0x96, 0x14, 0x4e, 0x2d, 0x0e, 0x60, 0x74, 0x1f, 0x89, 0x93, 0xc3, 0x01, 0x4b, 0x58, 0xb9, 0xb1, 0x95, 0x7a, 0x8b, 0xab, 0xcd, 0x23, 0xaf, 0x85, 0x4f, 0x4c, 0x35, 0x6f, 0xb1, 0x66, 0x2a, 0xa7, 0x2b, 0xfc, 0xc7, 0xe5, 0x86, 0x55, 0x9d, 0xc4, 0x28, 0x0d, 0x16, 0x0c, 0x12, 0x67, 0x85, 0xa7, 0x23, 0xeb, 0xee, 0xbe, 0xff, 0x71, 0xf1, 0x15, 0x94, 0x44, 0x0a, 0xae, 0xf8, 0x7d, 0x10, 0x79, 0x3a, 0x87, 0x74, 0xa2, 0x39, 0xd4, 0xa0, 0x4c, 0x87, 0xfe, 0x14, 0x67, 0xb9, 0xda, 0xf8, 0x52, 0x08, 0xec, 0x6c, 0x72, 0x55, 0x79, 0x4a, 0x96, 0xcc, 0x29, 0x14, 0x2f, 0x9a, 0x8b, 0xd4, 0x18, 0xe3, 0xc1, 0xfd, 0x67, 0x34, 0x4b, 0x0c, 0xd0, 0x82, 0x9d, 0xf3, 0xb2, 0xbe, 0xc6, 0x02, 0x53, 0x19, 0x62, 0x93, 0xc6, 0xb3, 0x4d, 0x3f, 0x75, 0xd3, 0x2f, 0x21, 0x3d, 0xd4, 0x5c, 0x62, 0x73, 0xd5, 0x05, 0xad, 0xf4, 0xcc, 0xed, 0x10, 0x57, 0xcb, 0x75, 0x8f, 0xc2, 0x6a, 0xee, 0xfa, 0x44, 0x12, 0x55, 0xed, 0x4e, 0x64, 0xc1, 0x99, 0xee, 0x07, 0x5e, 0x7f, 0x16, 0x64, 0x61, 0x82, 0xfd, 0xb4, 0x64, 0x73, 0x9b, 0x68, 0xab, 0x5d, 0xaf, 0xf0, 0xe6, 0x3e, 0x95, 0x52, 0x01, 0x68, 0x24, 0xf0, 0x54, 0xbf, 0x4d, 0x3c, 0x8c, 0x90, 0xa9, 0x7b, 0xb6, 0xb6, 0x55, 0x32, 0x84, 0xeb, 0x42, 0x9f, 0xcc, 
};
static const u8 rsa_oaep_108_salt[] = {
0x47, 0xe1, 0xab, 0x71, 0x19, 0xfe, 0xe5, 0x6c, 0x95, 0xee, 0x5e, 0xaa, 0xd8, 0x6f, 0x40, 0xd0, 0xaa, 0x63, 0xbd, 0x33, 
};


static const rsa_test test_rsa_oaep_108 = {
	.name = "rsa_oaep_108",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_108_n,
	.nlen = sizeof(rsa_oaep_108_n),
	.d = (const u8*)&rsa_oaep_108_d,
	.dlen = sizeof(rsa_oaep_108_d),
	.e = (const u8*)&rsa_oaep_108_e,
	.elen = sizeof(rsa_oaep_108_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_108_m,
	.mlen = sizeof(rsa_oaep_108_m),
	.res = (const u8*)&rsa_oaep_108_res,
	.reslen = sizeof(rsa_oaep_108_res),
	.salt = (const u8*)&rsa_oaep_108_salt,
	.saltlen = sizeof(rsa_oaep_108_salt),
};
static const u8 rsa_oaep_109_CRT_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_109_CRT_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_109_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_109_CRT_m[] = {
0x8b, 0xba, 0x6b, 0xf8, 0x2a, 0x6c, 0x0f, 0x86, 0xd5, 0xf1, 0x75, 0x6e, 0x97, 0x95, 0x68, 0x70, 0xb0, 0x89, 0x53, 0xb0, 0x6b, 0x4e, 0xb2, 0x05, 0xbc, 0x16, 0x94, 0xee, 
};
static const u8 rsa_oaep_109_CRT_res[] = {
0x53, 0xea, 0x5d, 0xc0, 0x8c, 0xd2, 0x60, 0xfb, 0x3b, 0x85, 0x85, 0x67, 0x28, 0x7f, 0xa9, 0x15, 0x52, 0xc3, 0x0b, 0x2f, 0xeb, 0xfb, 0xa2, 0x13, 0xf0, 0xae, 0x87, 0x70, 0x2d, 0x06, 0x8d, 0x19, 0xba, 0xb0, 0x7f, 0xe5, 0x74, 0x52, 0x3d, 0xfb, 0x42, 0x13, 0x9d, 0x68, 0xc3, 0xc5, 0xaf, 0xee, 0xe0, 0xbf, 0xe4, 0xcb, 0x79, 0x69, 0xcb, 0xf3, 0x82, 0xb8, 0x04, 0xd6, 0xe6, 0x13, 0x96, 0x14, 0x4e, 0x2d, 0x0e, 0x60, 0x74, 0x1f, 0x89, 0x93, 0xc3, 0x01, 0x4b, 0x58, 0xb9, 0xb1, 0x95, 0x7a, 0x8b, 0xab, 0xcd, 0x23, 0xaf, 0x85, 0x4f, 0x4c, 0x35, 0x6f, 0xb1, 0x66, 0x2a, 0xa7, 0x2b, 0xfc, 0xc7, 0xe5, 0x86, 0x55, 0x9d, 0xc4, 0x28, 0x0d, 0x16, 0x0c, 0x12, 0x67, 0x85, 0xa7, 0x23, 0xeb, 0xee, 0xbe, 0xff, 0x71, 0xf1, 0x15, 0x94, 0x44, 0x0a, 0xae, 0xf8, 0x7d, 0x10, 0x79, 0x3a, 0x87, 0x74, 0xa2, 0x39, 0xd4, 0xa0, 0x4c, 0x87, 0xfe, 0x14, 0x67, 0xb9, 0xda, 0xf8, 0x52, 0x08, 0xec, 0x6c, 0x72, 0x55, 0x79, 0x4a, 0x96, 0xcc, 0x29, 0x14, 0x2f, 0x9a, 0x8b, 0xd4, 0x18, 0xe3, 0xc1, 0xfd, 0x67, 0x34, 0x4b, 0x0c, 0xd0, 0x82, 0x9d, 0xf3, 0xb2, 0xbe, 0xc6, 0x02, 0x53, 0x19, 0x62, 0x93, 0xc6, 0xb3, 0x4d, 0x3f, 0x75, 0xd3, 0x2f, 0x21, 0x3d, 0xd4, 0x5c, 0x62, 0x73, 0xd5, 0x05, 0xad, 0xf4, 0xcc, 0xed, 0x10, 0x57, 0xcb, 0x75, 0x8f, 0xc2, 0x6a, 0xee, 0xfa, 0x44, 0x12, 0x55, 0xed, 0x4e, 0x64, 0xc1, 0x99, 0xee, 0x07, 0x5e, 0x7f, 0x16, 0x64, 0x61, 0x82, 0xfd, 0xb4, 0x64, 0x73, 0x9b, 0x68, 0xab, 0x5d, 0xaf, 0xf0, 0xe6, 0x3e, 0x95, 0x52, 0x01, 0x68, 0x24, 0xf0, 0x54, 0xbf, 0x4d, 0x3c, 0x8c, 0x90, 0xa9, 0x7b, 0xb6, 0xb6, 0x55, 0x32, 0x84, 0xeb, 0x42, 0x9f, 0xcc, 
};
static const u8 rsa_oaep_109_CRT_salt[] = {
0x47, 0xe1, 0xab, 0x71, 0x19, 0xfe, 0xe5, 0x6c, 0x95, 0xee, 0x5e, 0xaa, 0xd8, 0x6f, 0x40, 0xd0, 0xaa, 0x63, 0xbd, 0x33, 
};
static const u8 rsa_oaep_109_CRT_p[] = {
0xec, 0xf5, 0xae, 0xcd, 0x1e, 0x55, 0x15, 0xff, 0xfa, 0xcb, 0xd7, 0x5a, 0x28, 0x16, 0xc6, 0xeb, 0xf4, 0x90, 0x18, 0xcd, 0xfb, 0x46, 0x38, 0xe1, 0x85, 0xd6, 0x6a, 0x73, 0x96, 0xb6, 0xf8, 0x09, 0x0f, 0x80, 0x18, 0xc7, 0xfd, 0x95, 0xcc, 0x34, 0xb8, 0x57, 0xdc, 0x17, 0xf0, 0xcc, 0x65, 0x16, 0xbb, 0x13, 0x46, 0xab, 0x4d, 0x58, 0x2c, 0xad, 0xad, 0x7b, 0x41, 0x03, 0x35, 0x23, 0x87, 0xb7, 0x03, 0x38, 0xd0, 0x84, 0x04, 0x7c, 0x9d, 0x95, 0x39, 0xb6, 0x49, 0x62, 0x04, 0xb3, 0xdd, 0x6e, 0xa4, 0x42, 0x49, 0x92, 0x07, 0xbe, 0xc0, 0x1f, 0x96, 0x42, 0x87, 0xff, 0x63, 0x36, 0xc3, 0x98, 0x46, 0x58, 0x33, 0x68, 0x46, 0xf5, 0x6e, 0x46, 0x86, 0x18, 0x81, 0xc1, 0x02, 0x33, 0xd2, 0x17, 0x6b, 0xf1, 0x5a, 0x5e, 0x96, 0xdd, 0xc7, 0x80, 0xbc, 0x86, 0x8a, 0xa7, 0x7d, 0x3c, 0xe7, 0x69, 
};
static const u8 rsa_oaep_109_CRT_q[] = {
0xbc, 0x46, 0xc4, 0x64, 0xfc, 0x6a, 0xc4, 0xca, 0x78, 0x3b, 0x0e, 0xb0, 0x8a, 0x3c, 0x84, 0x1b, 0x77, 0x2f, 0x7e, 0x9b, 0x2f, 0x28, 0xba, 0xbd, 0x58, 0x8a, 0xe8, 0x85, 0xe1, 0xa0, 0xc6, 0x1e, 0x48, 0x58, 0xa0, 0xfb, 0x25, 0xac, 0x29, 0x99, 0x90, 0xf3, 0x5b, 0xe8, 0x51, 0x64, 0xc2, 0x59, 0xba, 0x11, 0x75, 0xcd, 0xd7, 0x19, 0x27, 0x07, 0x13, 0x51, 0x84, 0x99, 0x2b, 0x6c, 0x29, 0xb7, 0x46, 0xdd, 0x0d, 0x2c, 0xab, 0xe1, 0x42, 0x83, 0x5f, 0x7d, 0x14, 0x8c, 0xc1, 0x61, 0x52, 0x4b, 0x4a, 0x09, 0x94, 0x6d, 0x48, 0xb8, 0x28, 0x47, 0x3f, 0x1c, 0xe7, 0x6b, 0x6c, 0xb6, 0x88, 0x6c, 0x34, 0x5c, 0x03, 0xe0, 0x5f, 0x41, 0xd5, 0x1b, 0x5c, 0x3a, 0x90, 0xa3, 0xf2, 0x40, 0x73, 0xc7, 0xd7, 0x4a, 0x4f, 0xe2, 0x5d, 0x9c, 0xf2, 0x1c, 0x75, 0x96, 0x0f, 0x3f, 0xc3, 0x86, 0x31, 0x83, 
};
static const u8 rsa_oaep_109_CRT_dP[] = {
0xc7, 0x35, 0x64, 0x57, 0x1d, 0x00, 0xfb, 0x15, 0xd0, 0x8a, 0x3d, 0xe9, 0x95, 0x7a, 0x50, 0x91, 0x5d, 0x71, 0x26, 0xe9, 0x44, 0x2d, 0xac, 0xf4, 0x2b, 0xc8, 0x2e, 0x86, 0x2e, 0x56, 0x73, 0xff, 0x6a, 0x00, 0x8e, 0xd4, 0xd2, 0xe3, 0x74, 0x61, 0x7d, 0xf8, 0x9f, 0x17, 0xa1, 0x60, 0xb4, 0x3b, 0x7f, 0xda, 0x9c, 0xb6, 0xb6, 0xb7, 0x42, 0x18, 0x60, 0x98, 0x15, 0xf7, 0xd4, 0x5c, 0xa2, 0x63, 0xc1, 0x59, 0xaa, 0x32, 0xd2, 0x72, 0xd1, 0x27, 0xfa, 0xf4, 0xbc, 0x8c, 0xa2, 0xd7, 0x73, 0x78, 0xe8, 0xae, 0xb1, 0x9b, 0x0a, 0xd7, 0xda, 0x3c, 0xb3, 0xde, 0x0a, 0xe7, 0x31, 0x49, 0x80, 0xf6, 0x2b, 0x6d, 0x4b, 0x0a, 0x87, 0x5d, 0x1d, 0xf0, 0x3c, 0x1b, 0xae, 0x39, 0xcc, 0xd8, 0x33, 0xef, 0x6c, 0xd7, 0xe2, 0xd9, 0x52, 0x8b, 0xf0, 0x84, 0xd1, 0xf9, 0x69, 0xe7, 0x94, 0xe9, 0xf6, 0xc1, 
};
static const u8 rsa_oaep_109_CRT_dQ[] = {
0x26, 0x58, 0xb3, 0x7f, 0x6d, 0xf9, 0xc1, 0x03, 0x0b, 0xe1, 0xdb, 0x68, 0x11, 0x7f, 0xa9, 0xd8, 0x7e, 0x39, 0xea, 0x2b, 0x69, 0x3b, 0x7e, 0x6d, 0x3a, 0x2f, 0x70, 0x94, 0x74, 0x13, 0xee, 0xc6, 0x14, 0x2e, 0x18, 0xfb, 0x8d, 0xfc, 0xb6, 0xac, 0x54, 0x5d, 0x7c, 0x86, 0xa0, 0xad, 0x48, 0xf8, 0x45, 0x71, 0x70, 0xf0, 0xef, 0xb2, 0x6b, 0xc4, 0x81, 0x26, 0xc5, 0x3e, 0xfd, 0x1d, 0x16, 0x92, 0x01, 0x98, 0xdc, 0x2a, 0x11, 0x07, 0xdc, 0x28, 0x2d, 0xb6, 0xa8, 0x0c, 0xd3, 0x06, 0x23, 0x60, 0xba, 0x3f, 0xa1, 0x3f, 0x70, 0xe4, 0x31, 0x2f, 0xf1, 0xa6, 0xcd, 0x6b, 0x8f, 0xc4, 0xcd, 0x9c, 0x5c, 0x3d, 0xb1, 0x7c, 0x6d, 0x6a, 0x57, 0x21, 0x2f, 0x73, 0xae, 0x29, 0xf6, 0x19, 0x32, 0x7b, 0xad, 0x59, 0xb1, 0x53, 0x85, 0x85, 0x85, 0xba, 0x4e, 0x28, 0xb6, 0x0a, 0x62, 0xa4, 0x5e, 0x49, 
};
static const u8 rsa_oaep_109_CRT_qInv[] = {
0x6f, 0x38, 0x52, 0x6b, 0x39, 0x25, 0x08, 0x55, 0x34, 0xef, 0x3e, 0x41, 0x5a, 0x83, 0x6e, 0xde, 0x8b, 0x86, 0x15, 0x8a, 0x2c, 0x7c, 0xbf, 0xec, 0xcb, 0x0b, 0xd8, 0x34, 0x30, 0x4f, 0xec, 0x68, 0x3b, 0xa8, 0xd4, 0xf4, 0x79, 0xc4, 0x33, 0xd4, 0x34, 0x16, 0xe6, 0x32, 0x69, 0x62, 0x3c, 0xea, 0x10, 0x07, 0x76, 0xd8, 0x5a, 0xff, 0x40, 0x1d, 0x3f, 0xff, 0x61, 0x0e, 0xe6, 0x54, 0x11, 0xce, 0x3b, 0x13, 0x63, 0xd6, 0x3a, 0x97, 0x09, 0xee, 0xde, 0x42, 0x64, 0x7c, 0xea, 0x56, 0x14, 0x93, 0xd5, 0x45, 0x70, 0xa8, 0x79, 0xc1, 0x86, 0x82, 0xcd, 0x97, 0x71, 0x0b, 0x96, 0x20, 0x5e, 0xc3, 0x11, 0x17, 0xd7, 0x3b, 0x5f, 0x36, 0x22, 0x3f, 0xad, 0xd6, 0xe8, 0xba, 0x90, 0xdd, 0x7c, 0x0e, 0xe6, 0x1d, 0x44, 0xe1, 0x63, 0x25, 0x1e, 0x20, 0xc7, 0xf6, 0x6e, 0xb3, 0x05, 0x11, 0x7c, 0xb8, 
};


static const rsa_test test_rsa_oaep_109_CRT = {
	.name = "rsa_oaep_109_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_109_CRT_n,
	.nlen = sizeof(rsa_oaep_109_CRT_n),
	.d = (const u8*)&rsa_oaep_109_CRT_d,
	.dlen = sizeof(rsa_oaep_109_CRT_d),
	.e = (const u8*)&rsa_oaep_109_CRT_e,
	.elen = sizeof(rsa_oaep_109_CRT_e),
	.p = (const u8*)&rsa_oaep_109_CRT_p,
	.plen = sizeof(rsa_oaep_109_CRT_p),
	.q = (const u8*)&rsa_oaep_109_CRT_q,
	.qlen = sizeof(rsa_oaep_109_CRT_q),
	.dP = (const u8*)&rsa_oaep_109_CRT_dP,
	.dPlen = sizeof(rsa_oaep_109_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_109_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_109_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_109_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_109_CRT_qInv),
	.m = (const u8*)&rsa_oaep_109_CRT_m,
	.mlen = sizeof(rsa_oaep_109_CRT_m),
	.res = (const u8*)&rsa_oaep_109_CRT_res,
	.reslen = sizeof(rsa_oaep_109_CRT_res),
	.salt = (const u8*)&rsa_oaep_109_CRT_salt,
	.saltlen = sizeof(rsa_oaep_109_CRT_salt),
};
static const u8 rsa_oaep_110_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_110_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_110_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_110_m[] = {
0xe6, 0xad, 0x18, 0x1f, 0x05, 0x3b, 0x58, 0xa9, 0x04, 0xf2, 0x45, 0x75, 0x10, 0x37, 0x3e, 0x57, 
};
static const u8 rsa_oaep_110_res[] = {
0xa2, 0xb1, 0xa4, 0x30, 0xa9, 0xd6, 0x57, 0xe2, 0xfa, 0x1c, 0x2b, 0xb5, 0xed, 0x43, 0xff, 0xb2, 0x5c, 0x05, 0xa3, 0x08, 0xfe, 0x90, 0x93, 0xc0, 0x10, 0x31, 0x79, 0x5f, 0x58, 0x74, 0x40, 0x01, 0x10, 0x82, 0x8a, 0xe5, 0x8f, 0xb9, 0xb5, 0x81, 0xce, 0x9d, 0xdd, 0xd3, 0xe5, 0x49, 0xae, 0x04, 0xa0, 0x98, 0x54, 0x59, 0xbd, 0xe6, 0xc6, 0x26, 0x59, 0x4e, 0x7b, 0x05, 0xdc, 0x42, 0x78, 0xb2, 0xa1, 0x46, 0x5c, 0x13, 0x68, 0x40, 0x88, 0x23, 0xc8, 0x5e, 0x96, 0xdc, 0x66, 0xc3, 0xa3, 0x09, 0x83, 0xc6, 0x39, 0x66, 0x4f, 0xc4, 0x56, 0x9a, 0x37, 0xfe, 0x21, 0xe5, 0xa1, 0x95, 0xb5, 0x77, 0x6e, 0xed, 0x2d, 0xf8, 0xd8, 0xd3, 0x61, 0xaf, 0x68, 0x6e, 0x75, 0x02, 0x29, 0xbb, 0xd6, 0x63, 0xf1, 0x61, 0x86, 0x8a, 0x50, 0x61, 0x5e, 0x0c, 0x33, 0x7b, 0xec, 0x0c, 0xa3, 0x5f, 0xec, 0x0b, 0xb1, 0x9c, 0x36, 0xeb, 0x2e, 0x0b, 0xbc, 0xc0, 0x58, 0x2f, 0xa1, 0xd9, 0x3a, 0xac, 0xdb, 0x06, 0x10, 0x63, 0xf5, 0x9f, 0x2c, 0xe1, 0xee, 0x43, 0x60, 0x5e, 0x5d, 0x89, 0xec, 0xa1, 0x83, 0xd2, 0xac, 0xdf, 0xe9, 0xf8, 0x10, 0x11, 0x02, 0x2a, 0xd3, 0xb4, 0x3a, 0x3d, 0xd4, 0x17, 0xda, 0xc9, 0x4b, 0x4e, 0x11, 0xea, 0x81, 0xb1, 0x92, 0x96, 0x6e, 0x96, 0x6b, 0x18, 0x20, 0x82, 0xe7, 0x19, 0x64, 0x60, 0x7b, 0x4f, 0x80, 0x02, 0xf3, 0x62, 0x99, 0x84, 0x4a, 0x11, 0xf2, 0xae, 0x0f, 0xae, 0xac, 0x2e, 0xae, 0x70, 0xf8, 0xf4, 0xf9, 0x80, 0x88, 0xac, 0xdc, 0xd0, 0xac, 0x55, 0x6e, 0x9f, 0xcc, 0xc5, 0x11, 0x52, 0x19, 0x08, 0xfa, 0xd2, 0x6f, 0x04, 0xc6, 0x42, 0x01, 0x45, 0x03, 0x05, 0x77, 0x87, 0x58, 0xb0, 0x53, 0x8b, 0xf8, 0xb5, 0xbb, 0x14, 0x4a, 0x82, 0x8e, 0x62, 0x97, 0x95, 
};
static const u8 rsa_oaep_110_salt[] = {
0x6d, 0x17, 0xf5, 0xb4, 0xc1, 0xff, 0xac, 0x35, 0x1d, 0x19, 0x5b, 0xf7, 0xb0, 0x9d, 0x09, 0xf0, 0x9a, 0x40, 0x79, 0xcf, 
};


static const rsa_test test_rsa_oaep_110 = {
	.name = "rsa_oaep_110",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_110_n,
	.nlen = sizeof(rsa_oaep_110_n),
	.d = (const u8*)&rsa_oaep_110_d,
	.dlen = sizeof(rsa_oaep_110_d),
	.e = (const u8*)&rsa_oaep_110_e,
	.elen = sizeof(rsa_oaep_110_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_110_m,
	.mlen = sizeof(rsa_oaep_110_m),
	.res = (const u8*)&rsa_oaep_110_res,
	.reslen = sizeof(rsa_oaep_110_res),
	.salt = (const u8*)&rsa_oaep_110_salt,
	.saltlen = sizeof(rsa_oaep_110_salt),
};
static const u8 rsa_oaep_111_CRT_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_111_CRT_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_111_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_111_CRT_m[] = {
0xe6, 0xad, 0x18, 0x1f, 0x05, 0x3b, 0x58, 0xa9, 0x04, 0xf2, 0x45, 0x75, 0x10, 0x37, 0x3e, 0x57, 
};
static const u8 rsa_oaep_111_CRT_res[] = {
0xa2, 0xb1, 0xa4, 0x30, 0xa9, 0xd6, 0x57, 0xe2, 0xfa, 0x1c, 0x2b, 0xb5, 0xed, 0x43, 0xff, 0xb2, 0x5c, 0x05, 0xa3, 0x08, 0xfe, 0x90, 0x93, 0xc0, 0x10, 0x31, 0x79, 0x5f, 0x58, 0x74, 0x40, 0x01, 0x10, 0x82, 0x8a, 0xe5, 0x8f, 0xb9, 0xb5, 0x81, 0xce, 0x9d, 0xdd, 0xd3, 0xe5, 0x49, 0xae, 0x04, 0xa0, 0x98, 0x54, 0x59, 0xbd, 0xe6, 0xc6, 0x26, 0x59, 0x4e, 0x7b, 0x05, 0xdc, 0x42, 0x78, 0xb2, 0xa1, 0x46, 0x5c, 0x13, 0x68, 0x40, 0x88, 0x23, 0xc8, 0x5e, 0x96, 0xdc, 0x66, 0xc3, 0xa3, 0x09, 0x83, 0xc6, 0x39, 0x66, 0x4f, 0xc4, 0x56, 0x9a, 0x37, 0xfe, 0x21, 0xe5, 0xa1, 0x95, 0xb5, 0x77, 0x6e, 0xed, 0x2d, 0xf8, 0xd8, 0xd3, 0x61, 0xaf, 0x68, 0x6e, 0x75, 0x02, 0x29, 0xbb, 0xd6, 0x63, 0xf1, 0x61, 0x86, 0x8a, 0x50, 0x61, 0x5e, 0x0c, 0x33, 0x7b, 0xec, 0x0c, 0xa3, 0x5f, 0xec, 0x0b, 0xb1, 0x9c, 0x36, 0xeb, 0x2e, 0x0b, 0xbc, 0xc0, 0x58, 0x2f, 0xa1, 0xd9, 0x3a, 0xac, 0xdb, 0x06, 0x10, 0x63, 0xf5, 0x9f, 0x2c, 0xe1, 0xee, 0x43, 0x60, 0x5e, 0x5d, 0x89, 0xec, 0xa1, 0x83, 0xd2, 0xac, 0xdf, 0xe9, 0xf8, 0x10, 0x11, 0x02, 0x2a, 0xd3, 0xb4, 0x3a, 0x3d, 0xd4, 0x17, 0xda, 0xc9, 0x4b, 0x4e, 0x11, 0xea, 0x81, 0xb1, 0x92, 0x96, 0x6e, 0x96, 0x6b, 0x18, 0x20, 0x82, 0xe7, 0x19, 0x64, 0x60, 0x7b, 0x4f, 0x80, 0x02, 0xf3, 0x62, 0x99, 0x84, 0x4a, 0x11, 0xf2, 0xae, 0x0f, 0xae, 0xac, 0x2e, 0xae, 0x70, 0xf8, 0xf4, 0xf9, 0x80, 0x88, 0xac, 0xdc, 0xd0, 0xac, 0x55, 0x6e, 0x9f, 0xcc, 0xc5, 0x11, 0x52, 0x19, 0x08, 0xfa, 0xd2, 0x6f, 0x04, 0xc6, 0x42, 0x01, 0x45, 0x03, 0x05, 0x77, 0x87, 0x58, 0xb0, 0x53, 0x8b, 0xf8, 0xb5, 0xbb, 0x14, 0x4a, 0x82, 0x8e, 0x62, 0x97, 0x95, 
};
static const u8 rsa_oaep_111_CRT_salt[] = {
0x6d, 0x17, 0xf5, 0xb4, 0xc1, 0xff, 0xac, 0x35, 0x1d, 0x19, 0x5b, 0xf7, 0xb0, 0x9d, 0x09, 0xf0, 0x9a, 0x40, 0x79, 0xcf, 
};
static const u8 rsa_oaep_111_CRT_p[] = {
0xec, 0xf5, 0xae, 0xcd, 0x1e, 0x55, 0x15, 0xff, 0xfa, 0xcb, 0xd7, 0x5a, 0x28, 0x16, 0xc6, 0xeb, 0xf4, 0x90, 0x18, 0xcd, 0xfb, 0x46, 0x38, 0xe1, 0x85, 0xd6, 0x6a, 0x73, 0x96, 0xb6, 0xf8, 0x09, 0x0f, 0x80, 0x18, 0xc7, 0xfd, 0x95, 0xcc, 0x34, 0xb8, 0x57, 0xdc, 0x17, 0xf0, 0xcc, 0x65, 0x16, 0xbb, 0x13, 0x46, 0xab, 0x4d, 0x58, 0x2c, 0xad, 0xad, 0x7b, 0x41, 0x03, 0x35, 0x23, 0x87, 0xb7, 0x03, 0x38, 0xd0, 0x84, 0x04, 0x7c, 0x9d, 0x95, 0x39, 0xb6, 0x49, 0x62, 0x04, 0xb3, 0xdd, 0x6e, 0xa4, 0x42, 0x49, 0x92, 0x07, 0xbe, 0xc0, 0x1f, 0x96, 0x42, 0x87, 0xff, 0x63, 0x36, 0xc3, 0x98, 0x46, 0x58, 0x33, 0x68, 0x46, 0xf5, 0x6e, 0x46, 0x86, 0x18, 0x81, 0xc1, 0x02, 0x33, 0xd2, 0x17, 0x6b, 0xf1, 0x5a, 0x5e, 0x96, 0xdd, 0xc7, 0x80, 0xbc, 0x86, 0x8a, 0xa7, 0x7d, 0x3c, 0xe7, 0x69, 
};
static const u8 rsa_oaep_111_CRT_q[] = {
0xbc, 0x46, 0xc4, 0x64, 0xfc, 0x6a, 0xc4, 0xca, 0x78, 0x3b, 0x0e, 0xb0, 0x8a, 0x3c, 0x84, 0x1b, 0x77, 0x2f, 0x7e, 0x9b, 0x2f, 0x28, 0xba, 0xbd, 0x58, 0x8a, 0xe8, 0x85, 0xe1, 0xa0, 0xc6, 0x1e, 0x48, 0x58, 0xa0, 0xfb, 0x25, 0xac, 0x29, 0x99, 0x90, 0xf3, 0x5b, 0xe8, 0x51, 0x64, 0xc2, 0x59, 0xba, 0x11, 0x75, 0xcd, 0xd7, 0x19, 0x27, 0x07, 0x13, 0x51, 0x84, 0x99, 0x2b, 0x6c, 0x29, 0xb7, 0x46, 0xdd, 0x0d, 0x2c, 0xab, 0xe1, 0x42, 0x83, 0x5f, 0x7d, 0x14, 0x8c, 0xc1, 0x61, 0x52, 0x4b, 0x4a, 0x09, 0x94, 0x6d, 0x48, 0xb8, 0x28, 0x47, 0x3f, 0x1c, 0xe7, 0x6b, 0x6c, 0xb6, 0x88, 0x6c, 0x34, 0x5c, 0x03, 0xe0, 0x5f, 0x41, 0xd5, 0x1b, 0x5c, 0x3a, 0x90, 0xa3, 0xf2, 0x40, 0x73, 0xc7, 0xd7, 0x4a, 0x4f, 0xe2, 0x5d, 0x9c, 0xf2, 0x1c, 0x75, 0x96, 0x0f, 0x3f, 0xc3, 0x86, 0x31, 0x83, 
};
static const u8 rsa_oaep_111_CRT_dP[] = {
0xc7, 0x35, 0x64, 0x57, 0x1d, 0x00, 0xfb, 0x15, 0xd0, 0x8a, 0x3d, 0xe9, 0x95, 0x7a, 0x50, 0x91, 0x5d, 0x71, 0x26, 0xe9, 0x44, 0x2d, 0xac, 0xf4, 0x2b, 0xc8, 0x2e, 0x86, 0x2e, 0x56, 0x73, 0xff, 0x6a, 0x00, 0x8e, 0xd4, 0xd2, 0xe3, 0x74, 0x61, 0x7d, 0xf8, 0x9f, 0x17, 0xa1, 0x60, 0xb4, 0x3b, 0x7f, 0xda, 0x9c, 0xb6, 0xb6, 0xb7, 0x42, 0x18, 0x60, 0x98, 0x15, 0xf7, 0xd4, 0x5c, 0xa2, 0x63, 0xc1, 0x59, 0xaa, 0x32, 0xd2, 0x72, 0xd1, 0x27, 0xfa, 0xf4, 0xbc, 0x8c, 0xa2, 0xd7, 0x73, 0x78, 0xe8, 0xae, 0xb1, 0x9b, 0x0a, 0xd7, 0xda, 0x3c, 0xb3, 0xde, 0x0a, 0xe7, 0x31, 0x49, 0x80, 0xf6, 0x2b, 0x6d, 0x4b, 0x0a, 0x87, 0x5d, 0x1d, 0xf0, 0x3c, 0x1b, 0xae, 0x39, 0xcc, 0xd8, 0x33, 0xef, 0x6c, 0xd7, 0xe2, 0xd9, 0x52, 0x8b, 0xf0, 0x84, 0xd1, 0xf9, 0x69, 0xe7, 0x94, 0xe9, 0xf6, 0xc1, 
};
static const u8 rsa_oaep_111_CRT_dQ[] = {
0x26, 0x58, 0xb3, 0x7f, 0x6d, 0xf9, 0xc1, 0x03, 0x0b, 0xe1, 0xdb, 0x68, 0x11, 0x7f, 0xa9, 0xd8, 0x7e, 0x39, 0xea, 0x2b, 0x69, 0x3b, 0x7e, 0x6d, 0x3a, 0x2f, 0x70, 0x94, 0x74, 0x13, 0xee, 0xc6, 0x14, 0x2e, 0x18, 0xfb, 0x8d, 0xfc, 0xb6, 0xac, 0x54, 0x5d, 0x7c, 0x86, 0xa0, 0xad, 0x48, 0xf8, 0x45, 0x71, 0x70, 0xf0, 0xef, 0xb2, 0x6b, 0xc4, 0x81, 0x26, 0xc5, 0x3e, 0xfd, 0x1d, 0x16, 0x92, 0x01, 0x98, 0xdc, 0x2a, 0x11, 0x07, 0xdc, 0x28, 0x2d, 0xb6, 0xa8, 0x0c, 0xd3, 0x06, 0x23, 0x60, 0xba, 0x3f, 0xa1, 0x3f, 0x70, 0xe4, 0x31, 0x2f, 0xf1, 0xa6, 0xcd, 0x6b, 0x8f, 0xc4, 0xcd, 0x9c, 0x5c, 0x3d, 0xb1, 0x7c, 0x6d, 0x6a, 0x57, 0x21, 0x2f, 0x73, 0xae, 0x29, 0xf6, 0x19, 0x32, 0x7b, 0xad, 0x59, 0xb1, 0x53, 0x85, 0x85, 0x85, 0xba, 0x4e, 0x28, 0xb6, 0x0a, 0x62, 0xa4, 0x5e, 0x49, 
};
static const u8 rsa_oaep_111_CRT_qInv[] = {
0x6f, 0x38, 0x52, 0x6b, 0x39, 0x25, 0x08, 0x55, 0x34, 0xef, 0x3e, 0x41, 0x5a, 0x83, 0x6e, 0xde, 0x8b, 0x86, 0x15, 0x8a, 0x2c, 0x7c, 0xbf, 0xec, 0xcb, 0x0b, 0xd8, 0x34, 0x30, 0x4f, 0xec, 0x68, 0x3b, 0xa8, 0xd4, 0xf4, 0x79, 0xc4, 0x33, 0xd4, 0x34, 0x16, 0xe6, 0x32, 0x69, 0x62, 0x3c, 0xea, 0x10, 0x07, 0x76, 0xd8, 0x5a, 0xff, 0x40, 0x1d, 0x3f, 0xff, 0x61, 0x0e, 0xe6, 0x54, 0x11, 0xce, 0x3b, 0x13, 0x63, 0xd6, 0x3a, 0x97, 0x09, 0xee, 0xde, 0x42, 0x64, 0x7c, 0xea, 0x56, 0x14, 0x93, 0xd5, 0x45, 0x70, 0xa8, 0x79, 0xc1, 0x86, 0x82, 0xcd, 0x97, 0x71, 0x0b, 0x96, 0x20, 0x5e, 0xc3, 0x11, 0x17, 0xd7, 0x3b, 0x5f, 0x36, 0x22, 0x3f, 0xad, 0xd6, 0xe8, 0xba, 0x90, 0xdd, 0x7c, 0x0e, 0xe6, 0x1d, 0x44, 0xe1, 0x63, 0x25, 0x1e, 0x20, 0xc7, 0xf6, 0x6e, 0xb3, 0x05, 0x11, 0x7c, 0xb8, 
};


static const rsa_test test_rsa_oaep_111_CRT = {
	.name = "rsa_oaep_111_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_111_CRT_n,
	.nlen = sizeof(rsa_oaep_111_CRT_n),
	.d = (const u8*)&rsa_oaep_111_CRT_d,
	.dlen = sizeof(rsa_oaep_111_CRT_d),
	.e = (const u8*)&rsa_oaep_111_CRT_e,
	.elen = sizeof(rsa_oaep_111_CRT_e),
	.p = (const u8*)&rsa_oaep_111_CRT_p,
	.plen = sizeof(rsa_oaep_111_CRT_p),
	.q = (const u8*)&rsa_oaep_111_CRT_q,
	.qlen = sizeof(rsa_oaep_111_CRT_q),
	.dP = (const u8*)&rsa_oaep_111_CRT_dP,
	.dPlen = sizeof(rsa_oaep_111_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_111_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_111_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_111_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_111_CRT_qInv),
	.m = (const u8*)&rsa_oaep_111_CRT_m,
	.mlen = sizeof(rsa_oaep_111_CRT_m),
	.res = (const u8*)&rsa_oaep_111_CRT_res,
	.reslen = sizeof(rsa_oaep_111_CRT_res),
	.salt = (const u8*)&rsa_oaep_111_CRT_salt,
	.saltlen = sizeof(rsa_oaep_111_CRT_salt),
};
static const u8 rsa_oaep_112_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_112_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_112_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_112_m[] = {
0x51, 0x0a, 0x2c, 0xf6, 0x0e, 0x86, 0x6f, 0xa2, 0x34, 0x05, 0x53, 0xc9, 0x4e, 0xa3, 0x9f, 0xbc, 0x25, 0x63, 0x11, 0xe8, 0x3e, 0x94, 0x45, 0x4b, 0x41, 0x24, 
};
static const u8 rsa_oaep_112_res[] = {
0x98, 0x86, 0xc3, 0xe6, 0x76, 0x4a, 0x8b, 0x9a, 0x84, 0xe8, 0x41, 0x48, 0xeb, 0xd8, 0xc3, 0xb1, 0xaa, 0x80, 0x50, 0x38, 0x1a, 0x78, 0xf6, 0x68, 0x71, 0x4c, 0x16, 0xd9, 0xcf, 0xd2, 0xa6, 0xed, 0xc5, 0x69, 0x79, 0xc5, 0x35, 0xd9, 0xde, 0xe3, 0xb4, 0x4b, 0x85, 0xc1, 0x8b, 0xe8, 0x92, 0x89, 0x92, 0x37, 0x17, 0x11, 0x47, 0x22, 0x16, 0xd9, 0x5d, 0xda, 0x98, 0xd2, 0xee, 0x83, 0x47, 0xc9, 0xb1, 0x4d, 0xff, 0xdf, 0xf8, 0x4a, 0xa4, 0x8d, 0x25, 0xac, 0x06, 0xf7, 0xd7, 0xe6, 0x53, 0x98, 0xac, 0x96, 0x7b, 0x1c, 0xe9, 0x09, 0x25, 0xf6, 0x7d, 0xce, 0x04, 0x9b, 0x7f, 0x81, 0x2d, 0xb0, 0x74, 0x29, 0x97, 0xa7, 0x4d, 0x44, 0xfe, 0x81, 0xdb, 0xe0, 0xe7, 0xa3, 0xfe, 0xaf, 0x2e, 0x5c, 0x40, 0xaf, 0x88, 0x8d, 0x55, 0x0d, 0xdb, 0xbe, 0x3b, 0xc2, 0x06, 0x57, 0xa2, 0x95, 0x43, 0xf8, 0xfc, 0x29, 0x13, 0xb9, 0xbd, 0x1a, 0x61, 0xb2, 0xab, 0x22, 0x56, 0xec, 0x40, 0x9b, 0xbd, 0x7d, 0xc0, 0xd1, 0x77, 0x17, 0xea, 0x25, 0xc4, 0x3f, 0x42, 0xed, 0x27, 0xdf, 0x87, 0x38, 0xbf, 0x4a, 0xfc, 0x67, 0x66, 0xff, 0x7a, 0xff, 0x08, 0x59, 0x55, 0x5e, 0xe2, 0x83, 0x92, 0x0f, 0x4c, 0x8a, 0x63, 0xc4, 0xa7, 0x34, 0x0c, 0xba, 0xfd, 0xdc, 0x33, 0x9e, 0xcd, 0xb4, 0xb0, 0x51, 0x50, 0x02, 0xf9, 0x6c, 0x93, 0x2b, 0x5b, 0x79, 0x16, 0x7a, 0xf6, 0x99, 0xc0, 0xad, 0x3f, 0xcc, 0xfd, 0xf0, 0xf4, 0x4e, 0x85, 0xa7, 0x02, 0x62, 0xbf, 0x2e, 0x18, 0xfe, 0x34, 0xb8, 0x50, 0x58, 0x99, 0x75, 0xe8, 0x67, 0xff, 0x96, 0x9d, 0x48, 0xea, 0xbf, 0x21, 0x22, 0x71, 0x54, 0x6c, 0xdc, 0x05, 0xa6, 0x9e, 0xcb, 0x52, 0x6e, 0x52, 0x87, 0x0c, 0x83, 0x6f, 0x30, 0x7b, 0xd7, 0x98, 0x78, 0x0e, 0xde, 
};
static const u8 rsa_oaep_112_salt[] = {
0x38, 0x53, 0x87, 0x51, 0x4d, 0xec, 0xcc, 0x7c, 0x74, 0x0d, 0xd8, 0xcd, 0xf9, 0xda, 0xee, 0x49, 0xa1, 0xcb, 0xfd, 0x54, 
};


static const rsa_test test_rsa_oaep_112 = {
	.name = "rsa_oaep_112",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_112_n,
	.nlen = sizeof(rsa_oaep_112_n),
	.d = (const u8*)&rsa_oaep_112_d,
	.dlen = sizeof(rsa_oaep_112_d),
	.e = (const u8*)&rsa_oaep_112_e,
	.elen = sizeof(rsa_oaep_112_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_112_m,
	.mlen = sizeof(rsa_oaep_112_m),
	.res = (const u8*)&rsa_oaep_112_res,
	.reslen = sizeof(rsa_oaep_112_res),
	.salt = (const u8*)&rsa_oaep_112_salt,
	.saltlen = sizeof(rsa_oaep_112_salt),
};
static const u8 rsa_oaep_113_CRT_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_113_CRT_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_113_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_113_CRT_m[] = {
0x51, 0x0a, 0x2c, 0xf6, 0x0e, 0x86, 0x6f, 0xa2, 0x34, 0x05, 0x53, 0xc9, 0x4e, 0xa3, 0x9f, 0xbc, 0x25, 0x63, 0x11, 0xe8, 0x3e, 0x94, 0x45, 0x4b, 0x41, 0x24, 
};
static const u8 rsa_oaep_113_CRT_res[] = {
0x98, 0x86, 0xc3, 0xe6, 0x76, 0x4a, 0x8b, 0x9a, 0x84, 0xe8, 0x41, 0x48, 0xeb, 0xd8, 0xc3, 0xb1, 0xaa, 0x80, 0x50, 0x38, 0x1a, 0x78, 0xf6, 0x68, 0x71, 0x4c, 0x16, 0xd9, 0xcf, 0xd2, 0xa6, 0xed, 0xc5, 0x69, 0x79, 0xc5, 0x35, 0xd9, 0xde, 0xe3, 0xb4, 0x4b, 0x85, 0xc1, 0x8b, 0xe8, 0x92, 0x89, 0x92, 0x37, 0x17, 0x11, 0x47, 0x22, 0x16, 0xd9, 0x5d, 0xda, 0x98, 0xd2, 0xee, 0x83, 0x47, 0xc9, 0xb1, 0x4d, 0xff, 0xdf, 0xf8, 0x4a, 0xa4, 0x8d, 0x25, 0xac, 0x06, 0xf7, 0xd7, 0xe6, 0x53, 0x98, 0xac, 0x96, 0x7b, 0x1c, 0xe9, 0x09, 0x25, 0xf6, 0x7d, 0xce, 0x04, 0x9b, 0x7f, 0x81, 0x2d, 0xb0, 0x74, 0x29, 0x97, 0xa7, 0x4d, 0x44, 0xfe, 0x81, 0xdb, 0xe0, 0xe7, 0xa3, 0xfe, 0xaf, 0x2e, 0x5c, 0x40, 0xaf, 0x88, 0x8d, 0x55, 0x0d, 0xdb, 0xbe, 0x3b, 0xc2, 0x06, 0x57, 0xa2, 0x95, 0x43, 0xf8, 0xfc, 0x29, 0x13, 0xb9, 0xbd, 0x1a, 0x61, 0xb2, 0xab, 0x22, 0x56, 0xec, 0x40, 0x9b, 0xbd, 0x7d, 0xc0, 0xd1, 0x77, 0x17, 0xea, 0x25, 0xc4, 0x3f, 0x42, 0xed, 0x27, 0xdf, 0x87, 0x38, 0xbf, 0x4a, 0xfc, 0x67, 0x66, 0xff, 0x7a, 0xff, 0x08, 0x59, 0x55, 0x5e, 0xe2, 0x83, 0x92, 0x0f, 0x4c, 0x8a, 0x63, 0xc4, 0xa7, 0x34, 0x0c, 0xba, 0xfd, 0xdc, 0x33, 0x9e, 0xcd, 0xb4, 0xb0, 0x51, 0x50, 0x02, 0xf9, 0x6c, 0x93, 0x2b, 0x5b, 0x79, 0x16, 0x7a, 0xf6, 0x99, 0xc0, 0xad, 0x3f, 0xcc, 0xfd, 0xf0, 0xf4, 0x4e, 0x85, 0xa7, 0x02, 0x62, 0xbf, 0x2e, 0x18, 0xfe, 0x34, 0xb8, 0x50, 0x58, 0x99, 0x75, 0xe8, 0x67, 0xff, 0x96, 0x9d, 0x48, 0xea, 0xbf, 0x21, 0x22, 0x71, 0x54, 0x6c, 0xdc, 0x05, 0xa6, 0x9e, 0xcb, 0x52, 0x6e, 0x52, 0x87, 0x0c, 0x83, 0x6f, 0x30, 0x7b, 0xd7, 0x98, 0x78, 0x0e, 0xde, 
};
static const u8 rsa_oaep_113_CRT_salt[] = {
0x38, 0x53, 0x87, 0x51, 0x4d, 0xec, 0xcc, 0x7c, 0x74, 0x0d, 0xd8, 0xcd, 0xf9, 0xda, 0xee, 0x49, 0xa1, 0xcb, 0xfd, 0x54, 
};
static const u8 rsa_oaep_113_CRT_p[] = {
0xec, 0xf5, 0xae, 0xcd, 0x1e, 0x55, 0x15, 0xff, 0xfa, 0xcb, 0xd7, 0x5a, 0x28, 0x16, 0xc6, 0xeb, 0xf4, 0x90, 0x18, 0xcd, 0xfb, 0x46, 0x38, 0xe1, 0x85, 0xd6, 0x6a, 0x73, 0x96, 0xb6, 0xf8, 0x09, 0x0f, 0x80, 0x18, 0xc7, 0xfd, 0x95, 0xcc, 0x34, 0xb8, 0x57, 0xdc, 0x17, 0xf0, 0xcc, 0x65, 0x16, 0xbb, 0x13, 0x46, 0xab, 0x4d, 0x58, 0x2c, 0xad, 0xad, 0x7b, 0x41, 0x03, 0x35, 0x23, 0x87, 0xb7, 0x03, 0x38, 0xd0, 0x84, 0x04, 0x7c, 0x9d, 0x95, 0x39, 0xb6, 0x49, 0x62, 0x04, 0xb3, 0xdd, 0x6e, 0xa4, 0x42, 0x49, 0x92, 0x07, 0xbe, 0xc0, 0x1f, 0x96, 0x42, 0x87, 0xff, 0x63, 0x36, 0xc3, 0x98, 0x46, 0x58, 0x33, 0x68, 0x46, 0xf5, 0x6e, 0x46, 0x86, 0x18, 0x81, 0xc1, 0x02, 0x33, 0xd2, 0x17, 0x6b, 0xf1, 0x5a, 0x5e, 0x96, 0xdd, 0xc7, 0x80, 0xbc, 0x86, 0x8a, 0xa7, 0x7d, 0x3c, 0xe7, 0x69, 
};
static const u8 rsa_oaep_113_CRT_q[] = {
0xbc, 0x46, 0xc4, 0x64, 0xfc, 0x6a, 0xc4, 0xca, 0x78, 0x3b, 0x0e, 0xb0, 0x8a, 0x3c, 0x84, 0x1b, 0x77, 0x2f, 0x7e, 0x9b, 0x2f, 0x28, 0xba, 0xbd, 0x58, 0x8a, 0xe8, 0x85, 0xe1, 0xa0, 0xc6, 0x1e, 0x48, 0x58, 0xa0, 0xfb, 0x25, 0xac, 0x29, 0x99, 0x90, 0xf3, 0x5b, 0xe8, 0x51, 0x64, 0xc2, 0x59, 0xba, 0x11, 0x75, 0xcd, 0xd7, 0x19, 0x27, 0x07, 0x13, 0x51, 0x84, 0x99, 0x2b, 0x6c, 0x29, 0xb7, 0x46, 0xdd, 0x0d, 0x2c, 0xab, 0xe1, 0x42, 0x83, 0x5f, 0x7d, 0x14, 0x8c, 0xc1, 0x61, 0x52, 0x4b, 0x4a, 0x09, 0x94, 0x6d, 0x48, 0xb8, 0x28, 0x47, 0x3f, 0x1c, 0xe7, 0x6b, 0x6c, 0xb6, 0x88, 0x6c, 0x34, 0x5c, 0x03, 0xe0, 0x5f, 0x41, 0xd5, 0x1b, 0x5c, 0x3a, 0x90, 0xa3, 0xf2, 0x40, 0x73, 0xc7, 0xd7, 0x4a, 0x4f, 0xe2, 0x5d, 0x9c, 0xf2, 0x1c, 0x75, 0x96, 0x0f, 0x3f, 0xc3, 0x86, 0x31, 0x83, 
};
static const u8 rsa_oaep_113_CRT_dP[] = {
0xc7, 0x35, 0x64, 0x57, 0x1d, 0x00, 0xfb, 0x15, 0xd0, 0x8a, 0x3d, 0xe9, 0x95, 0x7a, 0x50, 0x91, 0x5d, 0x71, 0x26, 0xe9, 0x44, 0x2d, 0xac, 0xf4, 0x2b, 0xc8, 0x2e, 0x86, 0x2e, 0x56, 0x73, 0xff, 0x6a, 0x00, 0x8e, 0xd4, 0xd2, 0xe3, 0x74, 0x61, 0x7d, 0xf8, 0x9f, 0x17, 0xa1, 0x60, 0xb4, 0x3b, 0x7f, 0xda, 0x9c, 0xb6, 0xb6, 0xb7, 0x42, 0x18, 0x60, 0x98, 0x15, 0xf7, 0xd4, 0x5c, 0xa2, 0x63, 0xc1, 0x59, 0xaa, 0x32, 0xd2, 0x72, 0xd1, 0x27, 0xfa, 0xf4, 0xbc, 0x8c, 0xa2, 0xd7, 0x73, 0x78, 0xe8, 0xae, 0xb1, 0x9b, 0x0a, 0xd7, 0xda, 0x3c, 0xb3, 0xde, 0x0a, 0xe7, 0x31, 0x49, 0x80, 0xf6, 0x2b, 0x6d, 0x4b, 0x0a, 0x87, 0x5d, 0x1d, 0xf0, 0x3c, 0x1b, 0xae, 0x39, 0xcc, 0xd8, 0x33, 0xef, 0x6c, 0xd7, 0xe2, 0xd9, 0x52, 0x8b, 0xf0, 0x84, 0xd1, 0xf9, 0x69, 0xe7, 0x94, 0xe9, 0xf6, 0xc1, 
};
static const u8 rsa_oaep_113_CRT_dQ[] = {
0x26, 0x58, 0xb3, 0x7f, 0x6d, 0xf9, 0xc1, 0x03, 0x0b, 0xe1, 0xdb, 0x68, 0x11, 0x7f, 0xa9, 0xd8, 0x7e, 0x39, 0xea, 0x2b, 0x69, 0x3b, 0x7e, 0x6d, 0x3a, 0x2f, 0x70, 0x94, 0x74, 0x13, 0xee, 0xc6, 0x14, 0x2e, 0x18, 0xfb, 0x8d, 0xfc, 0xb6, 0xac, 0x54, 0x5d, 0x7c, 0x86, 0xa0, 0xad, 0x48, 0xf8, 0x45, 0x71, 0x70, 0xf0, 0xef, 0xb2, 0x6b, 0xc4, 0x81, 0x26, 0xc5, 0x3e, 0xfd, 0x1d, 0x16, 0x92, 0x01, 0x98, 0xdc, 0x2a, 0x11, 0x07, 0xdc, 0x28, 0x2d, 0xb6, 0xa8, 0x0c, 0xd3, 0x06, 0x23, 0x60, 0xba, 0x3f, 0xa1, 0x3f, 0x70, 0xe4, 0x31, 0x2f, 0xf1, 0xa6, 0xcd, 0x6b, 0x8f, 0xc4, 0xcd, 0x9c, 0x5c, 0x3d, 0xb1, 0x7c, 0x6d, 0x6a, 0x57, 0x21, 0x2f, 0x73, 0xae, 0x29, 0xf6, 0x19, 0x32, 0x7b, 0xad, 0x59, 0xb1, 0x53, 0x85, 0x85, 0x85, 0xba, 0x4e, 0x28, 0xb6, 0x0a, 0x62, 0xa4, 0x5e, 0x49, 
};
static const u8 rsa_oaep_113_CRT_qInv[] = {
0x6f, 0x38, 0x52, 0x6b, 0x39, 0x25, 0x08, 0x55, 0x34, 0xef, 0x3e, 0x41, 0x5a, 0x83, 0x6e, 0xde, 0x8b, 0x86, 0x15, 0x8a, 0x2c, 0x7c, 0xbf, 0xec, 0xcb, 0x0b, 0xd8, 0x34, 0x30, 0x4f, 0xec, 0x68, 0x3b, 0xa8, 0xd4, 0xf4, 0x79, 0xc4, 0x33, 0xd4, 0x34, 0x16, 0xe6, 0x32, 0x69, 0x62, 0x3c, 0xea, 0x10, 0x07, 0x76, 0xd8, 0x5a, 0xff, 0x40, 0x1d, 0x3f, 0xff, 0x61, 0x0e, 0xe6, 0x54, 0x11, 0xce, 0x3b, 0x13, 0x63, 0xd6, 0x3a, 0x97, 0x09, 0xee, 0xde, 0x42, 0x64, 0x7c, 0xea, 0x56, 0x14, 0x93, 0xd5, 0x45, 0x70, 0xa8, 0x79, 0xc1, 0x86, 0x82, 0xcd, 0x97, 0x71, 0x0b, 0x96, 0x20, 0x5e, 0xc3, 0x11, 0x17, 0xd7, 0x3b, 0x5f, 0x36, 0x22, 0x3f, 0xad, 0xd6, 0xe8, 0xba, 0x90, 0xdd, 0x7c, 0x0e, 0xe6, 0x1d, 0x44, 0xe1, 0x63, 0x25, 0x1e, 0x20, 0xc7, 0xf6, 0x6e, 0xb3, 0x05, 0x11, 0x7c, 0xb8, 
};


static const rsa_test test_rsa_oaep_113_CRT = {
	.name = "rsa_oaep_113_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_113_CRT_n,
	.nlen = sizeof(rsa_oaep_113_CRT_n),
	.d = (const u8*)&rsa_oaep_113_CRT_d,
	.dlen = sizeof(rsa_oaep_113_CRT_d),
	.e = (const u8*)&rsa_oaep_113_CRT_e,
	.elen = sizeof(rsa_oaep_113_CRT_e),
	.p = (const u8*)&rsa_oaep_113_CRT_p,
	.plen = sizeof(rsa_oaep_113_CRT_p),
	.q = (const u8*)&rsa_oaep_113_CRT_q,
	.qlen = sizeof(rsa_oaep_113_CRT_q),
	.dP = (const u8*)&rsa_oaep_113_CRT_dP,
	.dPlen = sizeof(rsa_oaep_113_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_113_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_113_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_113_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_113_CRT_qInv),
	.m = (const u8*)&rsa_oaep_113_CRT_m,
	.mlen = sizeof(rsa_oaep_113_CRT_m),
	.res = (const u8*)&rsa_oaep_113_CRT_res,
	.reslen = sizeof(rsa_oaep_113_CRT_res),
	.salt = (const u8*)&rsa_oaep_113_CRT_salt,
	.saltlen = sizeof(rsa_oaep_113_CRT_salt),
};
static const u8 rsa_oaep_114_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_114_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_114_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_114_m[] = {
0xbc, 0xdd, 0x19, 0x0d, 0xa3, 0xb7, 0xd3, 0x00, 0xdf, 0x9a, 0x06, 0xe2, 0x2c, 0xaa, 0xe2, 0xa7, 0x5f, 0x10, 0xc9, 0x1f, 0xf6, 0x67, 0xb7, 0xc1, 0x6b, 0xde, 0x8b, 0x53, 0x06, 0x4a, 0x26, 0x49, 0xa9, 0x40, 0x45, 0xc9, 
};
static const u8 rsa_oaep_114_res[] = {
0x63, 0x18, 0xe9, 0xfb, 0x5c, 0x0d, 0x05, 0xe5, 0x30, 0x7e, 0x16, 0x83, 0x43, 0x6e, 0x90, 0x32, 0x93, 0xac, 0x46, 0x42, 0x35, 0x8a, 0xaa, 0x22, 0x3d, 0x71, 0x63, 0x01, 0x3a, 0xba, 0x87, 0xe2, 0xdf, 0xda, 0x8e, 0x60, 0xc6, 0x86, 0x0e, 0x29, 0xa1, 0xe9, 0x26, 0x86, 0x16, 0x3e, 0xa0, 0xb9, 0x17, 0x5f, 0x32, 0x9c, 0xa3, 0xb1, 0x31, 0xa1, 0xed, 0xd3, 0xa7, 0x77, 0x59, 0xa8, 0xb9, 0x7b, 0xad, 0x6a, 0x4f, 0x8f, 0x43, 0x96, 0xf2, 0x8c, 0xf6, 0xf3, 0x9c, 0xa5, 0x81, 0x12, 0xe4, 0x81, 0x60, 0xd6, 0xe2, 0x03, 0xda, 0xa5, 0x85, 0x6f, 0x3a, 0xca, 0x5f, 0xfe, 0xd5, 0x77, 0xaf, 0x49, 0x94, 0x08, 0xe3, 0xdf, 0xd2, 0x33, 0xe3, 0xe6, 0x04, 0xdb, 0xe3, 0x4a, 0x9c, 0x4c, 0x90, 0x82, 0xde, 0x65, 0x52, 0x7c, 0xac, 0x63, 0x31, 0xd2, 0x9d, 0xc8, 0x0e, 0x05, 0x08, 0xa0, 0xfa, 0x71, 0x22, 0xe7, 0xf3, 0x29, 0xf6, 0xcc, 0xa5, 0xcf, 0xa3, 0x4d, 0x4d, 0x1d, 0xa4, 0x17, 0x80, 0x54, 0x57, 0xe0, 0x08, 0xbe, 0xc5, 0x49, 0xe4, 0x78, 0xff, 0x9e, 0x12, 0xa7, 0x63, 0xc4, 0x77, 0xd1, 0x5b, 0xbb, 0x78, 0xf5, 0xb6, 0x9b, 0xd5, 0x78, 0x30, 0xfc, 0x2c, 0x4e, 0xd6, 0x86, 0xd7, 0x9b, 0xc7, 0x2a, 0x95, 0xd8, 0x5f, 0x88, 0x13, 0x4c, 0x6b, 0x0a, 0xfe, 0x56, 0xa8, 0xcc, 0xfb, 0xc8, 0x55, 0x82, 0x8b, 0xb3, 0x39, 0xbd, 0x17, 0x90, 0x9c, 0xf1, 0xd7, 0x0d, 0xe3, 0x33, 0x5a, 0xe0, 0x70, 0x39, 0x09, 0x3e, 0x60, 0x6d, 0x65, 0x53, 0x65, 0xde, 0x65, 0x50, 0xb8, 0x72, 0xcd, 0x6d, 0xe1, 0xd4, 0x40, 0xee, 0x03, 0x1b, 0x61, 0x94, 0x5f, 0x62, 0x9a, 0xd8, 0xa3, 0x53, 0xb0, 0xd4, 0x09, 0x39, 0xe9, 0x6a, 0x3c, 0x45, 0x0d, 0x2a, 0x8d, 0x5e, 0xee, 0x9f, 0x67, 0x80, 0x93, 0xc8, 
};
static const u8 rsa_oaep_114_salt[] = {
0x5c, 0xac, 0xa6, 0xa0, 0xf7, 0x64, 0x16, 0x1a, 0x96, 0x84, 0xf8, 0x5d, 0x92, 0xb6, 0xe0, 0xef, 0x37, 0xca, 0x8b, 0x65, 
};


static const rsa_test test_rsa_oaep_114 = {
	.name = "rsa_oaep_114",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_114_n,
	.nlen = sizeof(rsa_oaep_114_n),
	.d = (const u8*)&rsa_oaep_114_d,
	.dlen = sizeof(rsa_oaep_114_d),
	.e = (const u8*)&rsa_oaep_114_e,
	.elen = sizeof(rsa_oaep_114_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_114_m,
	.mlen = sizeof(rsa_oaep_114_m),
	.res = (const u8*)&rsa_oaep_114_res,
	.reslen = sizeof(rsa_oaep_114_res),
	.salt = (const u8*)&rsa_oaep_114_salt,
	.saltlen = sizeof(rsa_oaep_114_salt),
};
static const u8 rsa_oaep_115_CRT_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_115_CRT_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_115_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_115_CRT_m[] = {
0xbc, 0xdd, 0x19, 0x0d, 0xa3, 0xb7, 0xd3, 0x00, 0xdf, 0x9a, 0x06, 0xe2, 0x2c, 0xaa, 0xe2, 0xa7, 0x5f, 0x10, 0xc9, 0x1f, 0xf6, 0x67, 0xb7, 0xc1, 0x6b, 0xde, 0x8b, 0x53, 0x06, 0x4a, 0x26, 0x49, 0xa9, 0x40, 0x45, 0xc9, 
};
static const u8 rsa_oaep_115_CRT_res[] = {
0x63, 0x18, 0xe9, 0xfb, 0x5c, 0x0d, 0x05, 0xe5, 0x30, 0x7e, 0x16, 0x83, 0x43, 0x6e, 0x90, 0x32, 0x93, 0xac, 0x46, 0x42, 0x35, 0x8a, 0xaa, 0x22, 0x3d, 0x71, 0x63, 0x01, 0x3a, 0xba, 0x87, 0xe2, 0xdf, 0xda, 0x8e, 0x60, 0xc6, 0x86, 0x0e, 0x29, 0xa1, 0xe9, 0x26, 0x86, 0x16, 0x3e, 0xa0, 0xb9, 0x17, 0x5f, 0x32, 0x9c, 0xa3, 0xb1, 0x31, 0xa1, 0xed, 0xd3, 0xa7, 0x77, 0x59, 0xa8, 0xb9, 0x7b, 0xad, 0x6a, 0x4f, 0x8f, 0x43, 0x96, 0xf2, 0x8c, 0xf6, 0xf3, 0x9c, 0xa5, 0x81, 0x12, 0xe4, 0x81, 0x60, 0xd6, 0xe2, 0x03, 0xda, 0xa5, 0x85, 0x6f, 0x3a, 0xca, 0x5f, 0xfe, 0xd5, 0x77, 0xaf, 0x49, 0x94, 0x08, 0xe3, 0xdf, 0xd2, 0x33, 0xe3, 0xe6, 0x04, 0xdb, 0xe3, 0x4a, 0x9c, 0x4c, 0x90, 0x82, 0xde, 0x65, 0x52, 0x7c, 0xac, 0x63, 0x31, 0xd2, 0x9d, 0xc8, 0x0e, 0x05, 0x08, 0xa0, 0xfa, 0x71, 0x22, 0xe7, 0xf3, 0x29, 0xf6, 0xcc, 0xa5, 0xcf, 0xa3, 0x4d, 0x4d, 0x1d, 0xa4, 0x17, 0x80, 0x54, 0x57, 0xe0, 0x08, 0xbe, 0xc5, 0x49, 0xe4, 0x78, 0xff, 0x9e, 0x12, 0xa7, 0x63, 0xc4, 0x77, 0xd1, 0x5b, 0xbb, 0x78, 0xf5, 0xb6, 0x9b, 0xd5, 0x78, 0x30, 0xfc, 0x2c, 0x4e, 0xd6, 0x86, 0xd7, 0x9b, 0xc7, 0x2a, 0x95, 0xd8, 0x5f, 0x88, 0x13, 0x4c, 0x6b, 0x0a, 0xfe, 0x56, 0xa8, 0xcc, 0xfb, 0xc8, 0x55, 0x82, 0x8b, 0xb3, 0x39, 0xbd, 0x17, 0x90, 0x9c, 0xf1, 0xd7, 0x0d, 0xe3, 0x33, 0x5a, 0xe0, 0x70, 0x39, 0x09, 0x3e, 0x60, 0x6d, 0x65, 0x53, 0x65, 0xde, 0x65, 0x50, 0xb8, 0x72, 0xcd, 0x6d, 0xe1, 0xd4, 0x40, 0xee, 0x03, 0x1b, 0x61, 0x94, 0x5f, 0x62, 0x9a, 0xd8, 0xa3, 0x53, 0xb0, 0xd4, 0x09, 0x39, 0xe9, 0x6a, 0x3c, 0x45, 0x0d, 0x2a, 0x8d, 0x5e, 0xee, 0x9f, 0x67, 0x80, 0x93, 0xc8, 
};
static const u8 rsa_oaep_115_CRT_salt[] = {
0x5c, 0xac, 0xa6, 0xa0, 0xf7, 0x64, 0x16, 0x1a, 0x96, 0x84, 0xf8, 0x5d, 0x92, 0xb6, 0xe0, 0xef, 0x37, 0xca, 0x8b, 0x65, 
};
static const u8 rsa_oaep_115_CRT_p[] = {
0xec, 0xf5, 0xae, 0xcd, 0x1e, 0x55, 0x15, 0xff, 0xfa, 0xcb, 0xd7, 0x5a, 0x28, 0x16, 0xc6, 0xeb, 0xf4, 0x90, 0x18, 0xcd, 0xfb, 0x46, 0x38, 0xe1, 0x85, 0xd6, 0x6a, 0x73, 0x96, 0xb6, 0xf8, 0x09, 0x0f, 0x80, 0x18, 0xc7, 0xfd, 0x95, 0xcc, 0x34, 0xb8, 0x57, 0xdc, 0x17, 0xf0, 0xcc, 0x65, 0x16, 0xbb, 0x13, 0x46, 0xab, 0x4d, 0x58, 0x2c, 0xad, 0xad, 0x7b, 0x41, 0x03, 0x35, 0x23, 0x87, 0xb7, 0x03, 0x38, 0xd0, 0x84, 0x04, 0x7c, 0x9d, 0x95, 0x39, 0xb6, 0x49, 0x62, 0x04, 0xb3, 0xdd, 0x6e, 0xa4, 0x42, 0x49, 0x92, 0x07, 0xbe, 0xc0, 0x1f, 0x96, 0x42, 0x87, 0xff, 0x63, 0x36, 0xc3, 0x98, 0x46, 0x58, 0x33, 0x68, 0x46, 0xf5, 0x6e, 0x46, 0x86, 0x18, 0x81, 0xc1, 0x02, 0x33, 0xd2, 0x17, 0x6b, 0xf1, 0x5a, 0x5e, 0x96, 0xdd, 0xc7, 0x80, 0xbc, 0x86, 0x8a, 0xa7, 0x7d, 0x3c, 0xe7, 0x69, 
};
static const u8 rsa_oaep_115_CRT_q[] = {
0xbc, 0x46, 0xc4, 0x64, 0xfc, 0x6a, 0xc4, 0xca, 0x78, 0x3b, 0x0e, 0xb0, 0x8a, 0x3c, 0x84, 0x1b, 0x77, 0x2f, 0x7e, 0x9b, 0x2f, 0x28, 0xba, 0xbd, 0x58, 0x8a, 0xe8, 0x85, 0xe1, 0xa0, 0xc6, 0x1e, 0x48, 0x58, 0xa0, 0xfb, 0x25, 0xac, 0x29, 0x99, 0x90, 0xf3, 0x5b, 0xe8, 0x51, 0x64, 0xc2, 0x59, 0xba, 0x11, 0x75, 0xcd, 0xd7, 0x19, 0x27, 0x07, 0x13, 0x51, 0x84, 0x99, 0x2b, 0x6c, 0x29, 0xb7, 0x46, 0xdd, 0x0d, 0x2c, 0xab, 0xe1, 0x42, 0x83, 0x5f, 0x7d, 0x14, 0x8c, 0xc1, 0x61, 0x52, 0x4b, 0x4a, 0x09, 0x94, 0x6d, 0x48, 0xb8, 0x28, 0x47, 0x3f, 0x1c, 0xe7, 0x6b, 0x6c, 0xb6, 0x88, 0x6c, 0x34, 0x5c, 0x03, 0xe0, 0x5f, 0x41, 0xd5, 0x1b, 0x5c, 0x3a, 0x90, 0xa3, 0xf2, 0x40, 0x73, 0xc7, 0xd7, 0x4a, 0x4f, 0xe2, 0x5d, 0x9c, 0xf2, 0x1c, 0x75, 0x96, 0x0f, 0x3f, 0xc3, 0x86, 0x31, 0x83, 
};
static const u8 rsa_oaep_115_CRT_dP[] = {
0xc7, 0x35, 0x64, 0x57, 0x1d, 0x00, 0xfb, 0x15, 0xd0, 0x8a, 0x3d, 0xe9, 0x95, 0x7a, 0x50, 0x91, 0x5d, 0x71, 0x26, 0xe9, 0x44, 0x2d, 0xac, 0xf4, 0x2b, 0xc8, 0x2e, 0x86, 0x2e, 0x56, 0x73, 0xff, 0x6a, 0x00, 0x8e, 0xd4, 0xd2, 0xe3, 0x74, 0x61, 0x7d, 0xf8, 0x9f, 0x17, 0xa1, 0x60, 0xb4, 0x3b, 0x7f, 0xda, 0x9c, 0xb6, 0xb6, 0xb7, 0x42, 0x18, 0x60, 0x98, 0x15, 0xf7, 0xd4, 0x5c, 0xa2, 0x63, 0xc1, 0x59, 0xaa, 0x32, 0xd2, 0x72, 0xd1, 0x27, 0xfa, 0xf4, 0xbc, 0x8c, 0xa2, 0xd7, 0x73, 0x78, 0xe8, 0xae, 0xb1, 0x9b, 0x0a, 0xd7, 0xda, 0x3c, 0xb3, 0xde, 0x0a, 0xe7, 0x31, 0x49, 0x80, 0xf6, 0x2b, 0x6d, 0x4b, 0x0a, 0x87, 0x5d, 0x1d, 0xf0, 0x3c, 0x1b, 0xae, 0x39, 0xcc, 0xd8, 0x33, 0xef, 0x6c, 0xd7, 0xe2, 0xd9, 0x52, 0x8b, 0xf0, 0x84, 0xd1, 0xf9, 0x69, 0xe7, 0x94, 0xe9, 0xf6, 0xc1, 
};
static const u8 rsa_oaep_115_CRT_dQ[] = {
0x26, 0x58, 0xb3, 0x7f, 0x6d, 0xf9, 0xc1, 0x03, 0x0b, 0xe1, 0xdb, 0x68, 0x11, 0x7f, 0xa9, 0xd8, 0x7e, 0x39, 0xea, 0x2b, 0x69, 0x3b, 0x7e, 0x6d, 0x3a, 0x2f, 0x70, 0x94, 0x74, 0x13, 0xee, 0xc6, 0x14, 0x2e, 0x18, 0xfb, 0x8d, 0xfc, 0xb6, 0xac, 0x54, 0x5d, 0x7c, 0x86, 0xa0, 0xad, 0x48, 0xf8, 0x45, 0x71, 0x70, 0xf0, 0xef, 0xb2, 0x6b, 0xc4, 0x81, 0x26, 0xc5, 0x3e, 0xfd, 0x1d, 0x16, 0x92, 0x01, 0x98, 0xdc, 0x2a, 0x11, 0x07, 0xdc, 0x28, 0x2d, 0xb6, 0xa8, 0x0c, 0xd3, 0x06, 0x23, 0x60, 0xba, 0x3f, 0xa1, 0x3f, 0x70, 0xe4, 0x31, 0x2f, 0xf1, 0xa6, 0xcd, 0x6b, 0x8f, 0xc4, 0xcd, 0x9c, 0x5c, 0x3d, 0xb1, 0x7c, 0x6d, 0x6a, 0x57, 0x21, 0x2f, 0x73, 0xae, 0x29, 0xf6, 0x19, 0x32, 0x7b, 0xad, 0x59, 0xb1, 0x53, 0x85, 0x85, 0x85, 0xba, 0x4e, 0x28, 0xb6, 0x0a, 0x62, 0xa4, 0x5e, 0x49, 
};
static const u8 rsa_oaep_115_CRT_qInv[] = {
0x6f, 0x38, 0x52, 0x6b, 0x39, 0x25, 0x08, 0x55, 0x34, 0xef, 0x3e, 0x41, 0x5a, 0x83, 0x6e, 0xde, 0x8b, 0x86, 0x15, 0x8a, 0x2c, 0x7c, 0xbf, 0xec, 0xcb, 0x0b, 0xd8, 0x34, 0x30, 0x4f, 0xec, 0x68, 0x3b, 0xa8, 0xd4, 0xf4, 0x79, 0xc4, 0x33, 0xd4, 0x34, 0x16, 0xe6, 0x32, 0x69, 0x62, 0x3c, 0xea, 0x10, 0x07, 0x76, 0xd8, 0x5a, 0xff, 0x40, 0x1d, 0x3f, 0xff, 0x61, 0x0e, 0xe6, 0x54, 0x11, 0xce, 0x3b, 0x13, 0x63, 0xd6, 0x3a, 0x97, 0x09, 0xee, 0xde, 0x42, 0x64, 0x7c, 0xea, 0x56, 0x14, 0x93, 0xd5, 0x45, 0x70, 0xa8, 0x79, 0xc1, 0x86, 0x82, 0xcd, 0x97, 0x71, 0x0b, 0x96, 0x20, 0x5e, 0xc3, 0x11, 0x17, 0xd7, 0x3b, 0x5f, 0x36, 0x22, 0x3f, 0xad, 0xd6, 0xe8, 0xba, 0x90, 0xdd, 0x7c, 0x0e, 0xe6, 0x1d, 0x44, 0xe1, 0x63, 0x25, 0x1e, 0x20, 0xc7, 0xf6, 0x6e, 0xb3, 0x05, 0x11, 0x7c, 0xb8, 
};


static const rsa_test test_rsa_oaep_115_CRT = {
	.name = "rsa_oaep_115_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_115_CRT_n,
	.nlen = sizeof(rsa_oaep_115_CRT_n),
	.d = (const u8*)&rsa_oaep_115_CRT_d,
	.dlen = sizeof(rsa_oaep_115_CRT_d),
	.e = (const u8*)&rsa_oaep_115_CRT_e,
	.elen = sizeof(rsa_oaep_115_CRT_e),
	.p = (const u8*)&rsa_oaep_115_CRT_p,
	.plen = sizeof(rsa_oaep_115_CRT_p),
	.q = (const u8*)&rsa_oaep_115_CRT_q,
	.qlen = sizeof(rsa_oaep_115_CRT_q),
	.dP = (const u8*)&rsa_oaep_115_CRT_dP,
	.dPlen = sizeof(rsa_oaep_115_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_115_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_115_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_115_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_115_CRT_qInv),
	.m = (const u8*)&rsa_oaep_115_CRT_m,
	.mlen = sizeof(rsa_oaep_115_CRT_m),
	.res = (const u8*)&rsa_oaep_115_CRT_res,
	.reslen = sizeof(rsa_oaep_115_CRT_res),
	.salt = (const u8*)&rsa_oaep_115_CRT_salt,
	.saltlen = sizeof(rsa_oaep_115_CRT_salt),
};
static const u8 rsa_oaep_116_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_116_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_116_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_116_m[] = {
0xa7, 0xdd, 0x6c, 0x7d, 0xc2, 0x4b, 0x46, 0xf9, 0xdd, 0x5f, 0x1e, 0x91, 0xad, 0xa4, 0xc3, 0xb3, 0xdf, 0x94, 0x7e, 0x87, 0x72, 0x32, 0xa9, 
};
static const u8 rsa_oaep_116_res[] = {
0x75, 0x29, 0x08, 0x72, 0xcc, 0xfd, 0x4a, 0x45, 0x05, 0x66, 0x0d, 0x65, 0x1f, 0x56, 0xda, 0x6d, 0xaa, 0x09, 0xca, 0x13, 0x01, 0xd8, 0x90, 0x63, 0x2f, 0x6a, 0x99, 0x2f, 0x3d, 0x56, 0x5c, 0xee, 0x46, 0x4a, 0xfd, 0xed, 0x40, 0xed, 0x3b, 0x5b, 0xe9, 0x35, 0x67, 0x14, 0xea, 0x5a, 0xa7, 0x65, 0x5f, 0x4a, 0x13, 0x66, 0xc2, 0xf1, 0x7c, 0x72, 0x8f, 0x6f, 0x2c, 0x5a, 0x5d, 0x1f, 0x8e, 0x28, 0x42, 0x9b, 0xc4, 0xe6, 0xf8, 0xf2, 0xcf, 0xf8, 0xda, 0x8d, 0xc0, 0xe0, 0xa9, 0x80, 0x8e, 0x45, 0xfd, 0x09, 0xea, 0x2f, 0xa4, 0x0c, 0xb2, 0xb6, 0xce, 0x6f, 0xff, 0xf5, 0xc0, 0xe1, 0x59, 0xd1, 0x1b, 0x68, 0xd9, 0x0a, 0x85, 0xf7, 0xb8, 0x4e, 0x10, 0x3b, 0x09, 0xe6, 0x82, 0x66, 0x64, 0x80, 0xc6, 0x57, 0x50, 0x5c, 0x09, 0x29, 0x25, 0x94, 0x68, 0xa3, 0x14, 0x78, 0x6d, 0x74, 0xea, 0xb1, 0x31, 0x57, 0x3c, 0xf2, 0x34, 0xbf, 0x57, 0xdb, 0x7d, 0x9e, 0x66, 0xcc, 0x67, 0x48, 0x19, 0x2e, 0x00, 0x2d, 0xc0, 0xde, 0xea, 0x93, 0x05, 0x85, 0xf0, 0x83, 0x1f, 0xdc, 0xd9, 0xbc, 0x33, 0xd5, 0x1f, 0x79, 0xed, 0x2f, 0xfc, 0x16, 0xbc, 0xf4, 0xd5, 0x98, 0x12, 0xfc, 0xeb, 0xca, 0xa3, 0xf9, 0x06, 0x9b, 0x0e, 0x44, 0x56, 0x86, 0xd6, 0x44, 0xc2, 0x5c, 0xcf, 0x63, 0xb4, 0x56, 0xee, 0x5f, 0xa6, 0xff, 0xe9, 0x6f, 0x19, 0xcd, 0xf7, 0x51, 0xfe, 0xd9, 0xea, 0xf3, 0x59, 0x57, 0x75, 0x4d, 0xbf, 0x4b, 0xfe, 0xa5, 0x21, 0x6a, 0xa1, 0x84, 0x4d, 0xc5, 0x07, 0xcb, 0x2d, 0x08, 0x0e, 0x72, 0x2e, 0xba, 0x15, 0x03, 0x08, 0xc2, 0xb5, 0xff, 0x11, 0x93, 0x62, 0x0f, 0x17, 0x66, 0xec, 0xf4, 0x48, 0x1b, 0xaf, 0xb9, 0x43, 0xbd, 0x29, 0x28, 0x77, 0xf2, 0x13, 0x6c, 0xa4, 0x94, 0xab, 0xa0, 
};
static const u8 rsa_oaep_116_salt[] = {
0x95, 0xbc, 0xa9, 0xe3, 0x85, 0x98, 0x94, 0xb3, 0xdd, 0x86, 0x9f, 0xa7, 0xec, 0xd5, 0xbb, 0xc6, 0x40, 0x1b, 0xf3, 0xe4, 
};


static const rsa_test test_rsa_oaep_116 = {
	.name = "rsa_oaep_116",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_116_n,
	.nlen = sizeof(rsa_oaep_116_n),
	.d = (const u8*)&rsa_oaep_116_d,
	.dlen = sizeof(rsa_oaep_116_d),
	.e = (const u8*)&rsa_oaep_116_e,
	.elen = sizeof(rsa_oaep_116_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_116_m,
	.mlen = sizeof(rsa_oaep_116_m),
	.res = (const u8*)&rsa_oaep_116_res,
	.reslen = sizeof(rsa_oaep_116_res),
	.salt = (const u8*)&rsa_oaep_116_salt,
	.saltlen = sizeof(rsa_oaep_116_salt),
};
static const u8 rsa_oaep_117_CRT_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_117_CRT_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_117_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_117_CRT_m[] = {
0xa7, 0xdd, 0x6c, 0x7d, 0xc2, 0x4b, 0x46, 0xf9, 0xdd, 0x5f, 0x1e, 0x91, 0xad, 0xa4, 0xc3, 0xb3, 0xdf, 0x94, 0x7e, 0x87, 0x72, 0x32, 0xa9, 
};
static const u8 rsa_oaep_117_CRT_res[] = {
0x75, 0x29, 0x08, 0x72, 0xcc, 0xfd, 0x4a, 0x45, 0x05, 0x66, 0x0d, 0x65, 0x1f, 0x56, 0xda, 0x6d, 0xaa, 0x09, 0xca, 0x13, 0x01, 0xd8, 0x90, 0x63, 0x2f, 0x6a, 0x99, 0x2f, 0x3d, 0x56, 0x5c, 0xee, 0x46, 0x4a, 0xfd, 0xed, 0x40, 0xed, 0x3b, 0x5b, 0xe9, 0x35, 0x67, 0x14, 0xea, 0x5a, 0xa7, 0x65, 0x5f, 0x4a, 0x13, 0x66, 0xc2, 0xf1, 0x7c, 0x72, 0x8f, 0x6f, 0x2c, 0x5a, 0x5d, 0x1f, 0x8e, 0x28, 0x42, 0x9b, 0xc4, 0xe6, 0xf8, 0xf2, 0xcf, 0xf8, 0xda, 0x8d, 0xc0, 0xe0, 0xa9, 0x80, 0x8e, 0x45, 0xfd, 0x09, 0xea, 0x2f, 0xa4, 0x0c, 0xb2, 0xb6, 0xce, 0x6f, 0xff, 0xf5, 0xc0, 0xe1, 0x59, 0xd1, 0x1b, 0x68, 0xd9, 0x0a, 0x85, 0xf7, 0xb8, 0x4e, 0x10, 0x3b, 0x09, 0xe6, 0x82, 0x66, 0x64, 0x80, 0xc6, 0x57, 0x50, 0x5c, 0x09, 0x29, 0x25, 0x94, 0x68, 0xa3, 0x14, 0x78, 0x6d, 0x74, 0xea, 0xb1, 0x31, 0x57, 0x3c, 0xf2, 0x34, 0xbf, 0x57, 0xdb, 0x7d, 0x9e, 0x66, 0xcc, 0x67, 0x48, 0x19, 0x2e, 0x00, 0x2d, 0xc0, 0xde, 0xea, 0x93, 0x05, 0x85, 0xf0, 0x83, 0x1f, 0xdc, 0xd9, 0xbc, 0x33, 0xd5, 0x1f, 0x79, 0xed, 0x2f, 0xfc, 0x16, 0xbc, 0xf4, 0xd5, 0x98, 0x12, 0xfc, 0xeb, 0xca, 0xa3, 0xf9, 0x06, 0x9b, 0x0e, 0x44, 0x56, 0x86, 0xd6, 0x44, 0xc2, 0x5c, 0xcf, 0x63, 0xb4, 0x56, 0xee, 0x5f, 0xa6, 0xff, 0xe9, 0x6f, 0x19, 0xcd, 0xf7, 0x51, 0xfe, 0xd9, 0xea, 0xf3, 0x59, 0x57, 0x75, 0x4d, 0xbf, 0x4b, 0xfe, 0xa5, 0x21, 0x6a, 0xa1, 0x84, 0x4d, 0xc5, 0x07, 0xcb, 0x2d, 0x08, 0x0e, 0x72, 0x2e, 0xba, 0x15, 0x03, 0x08, 0xc2, 0xb5, 0xff, 0x11, 0x93, 0x62, 0x0f, 0x17, 0x66, 0xec, 0xf4, 0x48, 0x1b, 0xaf, 0xb9, 0x43, 0xbd, 0x29, 0x28, 0x77, 0xf2, 0x13, 0x6c, 0xa4, 0x94, 0xab, 0xa0, 
};
static const u8 rsa_oaep_117_CRT_salt[] = {
0x95, 0xbc, 0xa9, 0xe3, 0x85, 0x98, 0x94, 0xb3, 0xdd, 0x86, 0x9f, 0xa7, 0xec, 0xd5, 0xbb, 0xc6, 0x40, 0x1b, 0xf3, 0xe4, 
};
static const u8 rsa_oaep_117_CRT_p[] = {
0xec, 0xf5, 0xae, 0xcd, 0x1e, 0x55, 0x15, 0xff, 0xfa, 0xcb, 0xd7, 0x5a, 0x28, 0x16, 0xc6, 0xeb, 0xf4, 0x90, 0x18, 0xcd, 0xfb, 0x46, 0x38, 0xe1, 0x85, 0xd6, 0x6a, 0x73, 0x96, 0xb6, 0xf8, 0x09, 0x0f, 0x80, 0x18, 0xc7, 0xfd, 0x95, 0xcc, 0x34, 0xb8, 0x57, 0xdc, 0x17, 0xf0, 0xcc, 0x65, 0x16, 0xbb, 0x13, 0x46, 0xab, 0x4d, 0x58, 0x2c, 0xad, 0xad, 0x7b, 0x41, 0x03, 0x35, 0x23, 0x87, 0xb7, 0x03, 0x38, 0xd0, 0x84, 0x04, 0x7c, 0x9d, 0x95, 0x39, 0xb6, 0x49, 0x62, 0x04, 0xb3, 0xdd, 0x6e, 0xa4, 0x42, 0x49, 0x92, 0x07, 0xbe, 0xc0, 0x1f, 0x96, 0x42, 0x87, 0xff, 0x63, 0x36, 0xc3, 0x98, 0x46, 0x58, 0x33, 0x68, 0x46, 0xf5, 0x6e, 0x46, 0x86, 0x18, 0x81, 0xc1, 0x02, 0x33, 0xd2, 0x17, 0x6b, 0xf1, 0x5a, 0x5e, 0x96, 0xdd, 0xc7, 0x80, 0xbc, 0x86, 0x8a, 0xa7, 0x7d, 0x3c, 0xe7, 0x69, 
};
static const u8 rsa_oaep_117_CRT_q[] = {
0xbc, 0x46, 0xc4, 0x64, 0xfc, 0x6a, 0xc4, 0xca, 0x78, 0x3b, 0x0e, 0xb0, 0x8a, 0x3c, 0x84, 0x1b, 0x77, 0x2f, 0x7e, 0x9b, 0x2f, 0x28, 0xba, 0xbd, 0x58, 0x8a, 0xe8, 0x85, 0xe1, 0xa0, 0xc6, 0x1e, 0x48, 0x58, 0xa0, 0xfb, 0x25, 0xac, 0x29, 0x99, 0x90, 0xf3, 0x5b, 0xe8, 0x51, 0x64, 0xc2, 0x59, 0xba, 0x11, 0x75, 0xcd, 0xd7, 0x19, 0x27, 0x07, 0x13, 0x51, 0x84, 0x99, 0x2b, 0x6c, 0x29, 0xb7, 0x46, 0xdd, 0x0d, 0x2c, 0xab, 0xe1, 0x42, 0x83, 0x5f, 0x7d, 0x14, 0x8c, 0xc1, 0x61, 0x52, 0x4b, 0x4a, 0x09, 0x94, 0x6d, 0x48, 0xb8, 0x28, 0x47, 0x3f, 0x1c, 0xe7, 0x6b, 0x6c, 0xb6, 0x88, 0x6c, 0x34, 0x5c, 0x03, 0xe0, 0x5f, 0x41, 0xd5, 0x1b, 0x5c, 0x3a, 0x90, 0xa3, 0xf2, 0x40, 0x73, 0xc7, 0xd7, 0x4a, 0x4f, 0xe2, 0x5d, 0x9c, 0xf2, 0x1c, 0x75, 0x96, 0x0f, 0x3f, 0xc3, 0x86, 0x31, 0x83, 
};
static const u8 rsa_oaep_117_CRT_dP[] = {
0xc7, 0x35, 0x64, 0x57, 0x1d, 0x00, 0xfb, 0x15, 0xd0, 0x8a, 0x3d, 0xe9, 0x95, 0x7a, 0x50, 0x91, 0x5d, 0x71, 0x26, 0xe9, 0x44, 0x2d, 0xac, 0xf4, 0x2b, 0xc8, 0x2e, 0x86, 0x2e, 0x56, 0x73, 0xff, 0x6a, 0x00, 0x8e, 0xd4, 0xd2, 0xe3, 0x74, 0x61, 0x7d, 0xf8, 0x9f, 0x17, 0xa1, 0x60, 0xb4, 0x3b, 0x7f, 0xda, 0x9c, 0xb6, 0xb6, 0xb7, 0x42, 0x18, 0x60, 0x98, 0x15, 0xf7, 0xd4, 0x5c, 0xa2, 0x63, 0xc1, 0x59, 0xaa, 0x32, 0xd2, 0x72, 0xd1, 0x27, 0xfa, 0xf4, 0xbc, 0x8c, 0xa2, 0xd7, 0x73, 0x78, 0xe8, 0xae, 0xb1, 0x9b, 0x0a, 0xd7, 0xda, 0x3c, 0xb3, 0xde, 0x0a, 0xe7, 0x31, 0x49, 0x80, 0xf6, 0x2b, 0x6d, 0x4b, 0x0a, 0x87, 0x5d, 0x1d, 0xf0, 0x3c, 0x1b, 0xae, 0x39, 0xcc, 0xd8, 0x33, 0xef, 0x6c, 0xd7, 0xe2, 0xd9, 0x52, 0x8b, 0xf0, 0x84, 0xd1, 0xf9, 0x69, 0xe7, 0x94, 0xe9, 0xf6, 0xc1, 
};
static const u8 rsa_oaep_117_CRT_dQ[] = {
0x26, 0x58, 0xb3, 0x7f, 0x6d, 0xf9, 0xc1, 0x03, 0x0b, 0xe1, 0xdb, 0x68, 0x11, 0x7f, 0xa9, 0xd8, 0x7e, 0x39, 0xea, 0x2b, 0x69, 0x3b, 0x7e, 0x6d, 0x3a, 0x2f, 0x70, 0x94, 0x74, 0x13, 0xee, 0xc6, 0x14, 0x2e, 0x18, 0xfb, 0x8d, 0xfc, 0xb6, 0xac, 0x54, 0x5d, 0x7c, 0x86, 0xa0, 0xad, 0x48, 0xf8, 0x45, 0x71, 0x70, 0xf0, 0xef, 0xb2, 0x6b, 0xc4, 0x81, 0x26, 0xc5, 0x3e, 0xfd, 0x1d, 0x16, 0x92, 0x01, 0x98, 0xdc, 0x2a, 0x11, 0x07, 0xdc, 0x28, 0x2d, 0xb6, 0xa8, 0x0c, 0xd3, 0x06, 0x23, 0x60, 0xba, 0x3f, 0xa1, 0x3f, 0x70, 0xe4, 0x31, 0x2f, 0xf1, 0xa6, 0xcd, 0x6b, 0x8f, 0xc4, 0xcd, 0x9c, 0x5c, 0x3d, 0xb1, 0x7c, 0x6d, 0x6a, 0x57, 0x21, 0x2f, 0x73, 0xae, 0x29, 0xf6, 0x19, 0x32, 0x7b, 0xad, 0x59, 0xb1, 0x53, 0x85, 0x85, 0x85, 0xba, 0x4e, 0x28, 0xb6, 0x0a, 0x62, 0xa4, 0x5e, 0x49, 
};
static const u8 rsa_oaep_117_CRT_qInv[] = {
0x6f, 0x38, 0x52, 0x6b, 0x39, 0x25, 0x08, 0x55, 0x34, 0xef, 0x3e, 0x41, 0x5a, 0x83, 0x6e, 0xde, 0x8b, 0x86, 0x15, 0x8a, 0x2c, 0x7c, 0xbf, 0xec, 0xcb, 0x0b, 0xd8, 0x34, 0x30, 0x4f, 0xec, 0x68, 0x3b, 0xa8, 0xd4, 0xf4, 0x79, 0xc4, 0x33, 0xd4, 0x34, 0x16, 0xe6, 0x32, 0x69, 0x62, 0x3c, 0xea, 0x10, 0x07, 0x76, 0xd8, 0x5a, 0xff, 0x40, 0x1d, 0x3f, 0xff, 0x61, 0x0e, 0xe6, 0x54, 0x11, 0xce, 0x3b, 0x13, 0x63, 0xd6, 0x3a, 0x97, 0x09, 0xee, 0xde, 0x42, 0x64, 0x7c, 0xea, 0x56, 0x14, 0x93, 0xd5, 0x45, 0x70, 0xa8, 0x79, 0xc1, 0x86, 0x82, 0xcd, 0x97, 0x71, 0x0b, 0x96, 0x20, 0x5e, 0xc3, 0x11, 0x17, 0xd7, 0x3b, 0x5f, 0x36, 0x22, 0x3f, 0xad, 0xd6, 0xe8, 0xba, 0x90, 0xdd, 0x7c, 0x0e, 0xe6, 0x1d, 0x44, 0xe1, 0x63, 0x25, 0x1e, 0x20, 0xc7, 0xf6, 0x6e, 0xb3, 0x05, 0x11, 0x7c, 0xb8, 
};


static const rsa_test test_rsa_oaep_117_CRT = {
	.name = "rsa_oaep_117_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_117_CRT_n,
	.nlen = sizeof(rsa_oaep_117_CRT_n),
	.d = (const u8*)&rsa_oaep_117_CRT_d,
	.dlen = sizeof(rsa_oaep_117_CRT_d),
	.e = (const u8*)&rsa_oaep_117_CRT_e,
	.elen = sizeof(rsa_oaep_117_CRT_e),
	.p = (const u8*)&rsa_oaep_117_CRT_p,
	.plen = sizeof(rsa_oaep_117_CRT_p),
	.q = (const u8*)&rsa_oaep_117_CRT_q,
	.qlen = sizeof(rsa_oaep_117_CRT_q),
	.dP = (const u8*)&rsa_oaep_117_CRT_dP,
	.dPlen = sizeof(rsa_oaep_117_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_117_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_117_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_117_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_117_CRT_qInv),
	.m = (const u8*)&rsa_oaep_117_CRT_m,
	.mlen = sizeof(rsa_oaep_117_CRT_m),
	.res = (const u8*)&rsa_oaep_117_CRT_res,
	.reslen = sizeof(rsa_oaep_117_CRT_res),
	.salt = (const u8*)&rsa_oaep_117_CRT_salt,
	.saltlen = sizeof(rsa_oaep_117_CRT_salt),
};
static const u8 rsa_oaep_118_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_118_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_118_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_118_m[] = {
0xea, 0xf1, 0xa7, 0x3a, 0x1b, 0x0c, 0x46, 0x09, 0x53, 0x7d, 0xe6, 0x9c, 0xd9, 0x22, 0x8b, 0xbc, 0xfb, 0x9a, 0x8c, 0xa8, 0xc6, 0xc3, 0xef, 0xaf, 0x05, 0x6f, 0xe4, 0xa7, 0xf4, 0x63, 0x4e, 0xd0, 0x0b, 0x7c, 0x39, 0xec, 0x69, 0x22, 0xd7, 0xb8, 0xea, 0x2c, 0x04, 0xeb, 0xac, 
};
static const u8 rsa_oaep_118_res[] = {
0x2d, 0x20, 0x7a, 0x73, 0x43, 0x2a, 0x8f, 0xb4, 0xc0, 0x30, 0x51, 0xb3, 0xf7, 0x3b, 0x28, 0xa6, 0x17, 0x64, 0x09, 0x8d, 0xfa, 0x34, 0xc4, 0x7a, 0x20, 0x99, 0x5f, 0x81, 0x15, 0xaa, 0x68, 0x16, 0x67, 0x9b, 0x55, 0x7e, 0x82, 0xdb, 0xee, 0x58, 0x49, 0x08, 0xc6, 0xe6, 0x97, 0x82, 0xd7, 0xde, 0xb3, 0x4d, 0xbd, 0x65, 0xaf, 0x06, 0x3d, 0x57, 0xfc, 0xa7, 0x6a, 0x5f, 0xd0, 0x69, 0x49, 0x2f, 0xd6, 0x06, 0x8d, 0x99, 0x84, 0xd2, 0x09, 0x35, 0x05, 0x65, 0xa6, 0x2e, 0x5c, 0x77, 0xf2, 0x30, 0x38, 0xc1, 0x2c, 0xb1, 0x0c, 0x66, 0x34, 0x70, 0x9b, 0x54, 0x7c, 0x46, 0xf6, 0xb4, 0xa7, 0x09, 0xbd, 0x85, 0xca, 0x12, 0x2d, 0x74, 0x46, 0x5e, 0xf9, 0x77, 0x62, 0xc2, 0x97, 0x63, 0xe0, 0x6d, 0xbc, 0x7a, 0x9e, 0x73, 0x8c, 0x78, 0xbf, 0xca, 0x01, 0x02, 0xdc, 0x5e, 0x79, 0xd6, 0x5b, 0x97, 0x3f, 0x28, 0x24, 0x0c, 0xaa, 0xb2, 0xe1, 0x61, 0xa7, 0x8b, 0x57, 0xd2, 0x62, 0x45, 0x7e, 0xd8, 0x19, 0x5d, 0x53, 0xe3, 0xc7, 0xae, 0x9d, 0xa0, 0x21, 0x88, 0x3c, 0x6d, 0xb7, 0xc2, 0x4a, 0xfd, 0xd2, 0x32, 0x2e, 0xac, 0x97, 0x2a, 0xd3, 0xc3, 0x54, 0xc5, 0xfc, 0xef, 0x1e, 0x14, 0x6c, 0x3a, 0x02, 0x90, 0xfb, 0x67, 0xad, 0xf0, 0x07, 0x06, 0x6e, 0x00, 0x42, 0x8d, 0x2c, 0xec, 0x18, 0xce, 0x58, 0xf9, 0x32, 0x86, 0x98, 0xde, 0xfe, 0xf4, 0xb2, 0xeb, 0x5e, 0xc7, 0x69, 0x18, 0xfd, 0xe1, 0xc1, 0x98, 0xcb, 0xb3, 0x8b, 0x7a, 0xfc, 0x67, 0x62, 0x6a, 0x9a, 0xef, 0xec, 0x43, 0x22, 0xbf, 0xd9, 0x0d, 0x25, 0x63, 0x48, 0x1c, 0x9a, 0x22, 0x1f, 0x78, 0xc8, 0x27, 0x2c, 0x82, 0xd1, 0xb6, 0x2a, 0xb9, 0x14, 0xe1, 0xc6, 0x9f, 0x6a, 0xf6, 0xef, 0x30, 0xca, 0x52, 0x60, 0xdb, 0x4a, 0x46, 
};
static const u8 rsa_oaep_118_salt[] = {
0x9f, 0x47, 0xdd, 0xf4, 0x2e, 0x97, 0xee, 0xa8, 0x56, 0xa9, 0xbd, 0xbc, 0x71, 0x4e, 0xb3, 0xac, 0x22, 0xf6, 0xeb, 0x32, 
};


static const rsa_test test_rsa_oaep_118 = {
	.name = "rsa_oaep_118",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_118_n,
	.nlen = sizeof(rsa_oaep_118_n),
	.d = (const u8*)&rsa_oaep_118_d,
	.dlen = sizeof(rsa_oaep_118_d),
	.e = (const u8*)&rsa_oaep_118_e,
	.elen = sizeof(rsa_oaep_118_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_oaep_118_m,
	.mlen = sizeof(rsa_oaep_118_m),
	.res = (const u8*)&rsa_oaep_118_res,
	.reslen = sizeof(rsa_oaep_118_res),
	.salt = (const u8*)&rsa_oaep_118_salt,
	.saltlen = sizeof(rsa_oaep_118_salt),
};
static const u8 rsa_oaep_119_CRT_n[] = {
0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb, 
};
static const u8 rsa_oaep_119_CRT_d[] = {
0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79, 
};
static const u8 rsa_oaep_119_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_oaep_119_CRT_m[] = {
0xea, 0xf1, 0xa7, 0x3a, 0x1b, 0x0c, 0x46, 0x09, 0x53, 0x7d, 0xe6, 0x9c, 0xd9, 0x22, 0x8b, 0xbc, 0xfb, 0x9a, 0x8c, 0xa8, 0xc6, 0xc3, 0xef, 0xaf, 0x05, 0x6f, 0xe4, 0xa7, 0xf4, 0x63, 0x4e, 0xd0, 0x0b, 0x7c, 0x39, 0xec, 0x69, 0x22, 0xd7, 0xb8, 0xea, 0x2c, 0x04, 0xeb, 0xac, 
};
static const u8 rsa_oaep_119_CRT_res[] = {
0x2d, 0x20, 0x7a, 0x73, 0x43, 0x2a, 0x8f, 0xb4, 0xc0, 0x30, 0x51, 0xb3, 0xf7, 0x3b, 0x28, 0xa6, 0x17, 0x64, 0x09, 0x8d, 0xfa, 0x34, 0xc4, 0x7a, 0x20, 0x99, 0x5f, 0x81, 0x15, 0xaa, 0x68, 0x16, 0x67, 0x9b, 0x55, 0x7e, 0x82, 0xdb, 0xee, 0x58, 0x49, 0x08, 0xc6, 0xe6, 0x97, 0x82, 0xd7, 0xde, 0xb3, 0x4d, 0xbd, 0x65, 0xaf, 0x06, 0x3d, 0x57, 0xfc, 0xa7, 0x6a, 0x5f, 0xd0, 0x69, 0x49, 0x2f, 0xd6, 0x06, 0x8d, 0x99, 0x84, 0xd2, 0x09, 0x35, 0x05, 0x65, 0xa6, 0x2e, 0x5c, 0x77, 0xf2, 0x30, 0x38, 0xc1, 0x2c, 0xb1, 0x0c, 0x66, 0x34, 0x70, 0x9b, 0x54, 0x7c, 0x46, 0xf6, 0xb4, 0xa7, 0x09, 0xbd, 0x85, 0xca, 0x12, 0x2d, 0x74, 0x46, 0x5e, 0xf9, 0x77, 0x62, 0xc2, 0x97, 0x63, 0xe0, 0x6d, 0xbc, 0x7a, 0x9e, 0x73, 0x8c, 0x78, 0xbf, 0xca, 0x01, 0x02, 0xdc, 0x5e, 0x79, 0xd6, 0x5b, 0x97, 0x3f, 0x28, 0x24, 0x0c, 0xaa, 0xb2, 0xe1, 0x61, 0xa7, 0x8b, 0x57, 0xd2, 0x62, 0x45, 0x7e, 0xd8, 0x19, 0x5d, 0x53, 0xe3, 0xc7, 0xae, 0x9d, 0xa0, 0x21, 0x88, 0x3c, 0x6d, 0xb7, 0xc2, 0x4a, 0xfd, 0xd2, 0x32, 0x2e, 0xac, 0x97, 0x2a, 0xd3, 0xc3, 0x54, 0xc5, 0xfc, 0xef, 0x1e, 0x14, 0x6c, 0x3a, 0x02, 0x90, 0xfb, 0x67, 0xad, 0xf0, 0x07, 0x06, 0x6e, 0x00, 0x42, 0x8d, 0x2c, 0xec, 0x18, 0xce, 0x58, 0xf9, 0x32, 0x86, 0x98, 0xde, 0xfe, 0xf4, 0xb2, 0xeb, 0x5e, 0xc7, 0x69, 0x18, 0xfd, 0xe1, 0xc1, 0x98, 0xcb, 0xb3, 0x8b, 0x7a, 0xfc, 0x67, 0x62, 0x6a, 0x9a, 0xef, 0xec, 0x43, 0x22, 0xbf, 0xd9, 0x0d, 0x25, 0x63, 0x48, 0x1c, 0x9a, 0x22, 0x1f, 0x78, 0xc8, 0x27, 0x2c, 0x82, 0xd1, 0xb6, 0x2a, 0xb9, 0x14, 0xe1, 0xc6, 0x9f, 0x6a, 0xf6, 0xef, 0x30, 0xca, 0x52, 0x60, 0xdb, 0x4a, 0x46, 
};
static const u8 rsa_oaep_119_CRT_salt[] = {
0x9f, 0x47, 0xdd, 0xf4, 0x2e, 0x97, 0xee, 0xa8, 0x56, 0xa9, 0xbd, 0xbc, 0x71, 0x4e, 0xb3, 0xac, 0x22, 0xf6, 0xeb, 0x32, 
};
static const u8 rsa_oaep_119_CRT_p[] = {
0xec, 0xf5, 0xae, 0xcd, 0x1e, 0x55, 0x15, 0xff, 0xfa, 0xcb, 0xd7, 0x5a, 0x28, 0x16, 0xc6, 0xeb, 0xf4, 0x90, 0x18, 0xcd, 0xfb, 0x46, 0x38, 0xe1, 0x85, 0xd6, 0x6a, 0x73, 0x96, 0xb6, 0xf8, 0x09, 0x0f, 0x80, 0x18, 0xc7, 0xfd, 0x95, 0xcc, 0x34, 0xb8, 0x57, 0xdc, 0x17, 0xf0, 0xcc, 0x65, 0x16, 0xbb, 0x13, 0x46, 0xab, 0x4d, 0x58, 0x2c, 0xad, 0xad, 0x7b, 0x41, 0x03, 0x35, 0x23, 0x87, 0xb7, 0x03, 0x38, 0xd0, 0x84, 0x04, 0x7c, 0x9d, 0x95, 0x39, 0xb6, 0x49, 0x62, 0x04, 0xb3, 0xdd, 0x6e, 0xa4, 0x42, 0x49, 0x92, 0x07, 0xbe, 0xc0, 0x1f, 0x96, 0x42, 0x87, 0xff, 0x63, 0x36, 0xc3, 0x98, 0x46, 0x58, 0x33, 0x68, 0x46, 0xf5, 0x6e, 0x46, 0x86, 0x18, 0x81, 0xc1, 0x02, 0x33, 0xd2, 0x17, 0x6b, 0xf1, 0x5a, 0x5e, 0x96, 0xdd, 0xc7, 0x80, 0xbc, 0x86, 0x8a, 0xa7, 0x7d, 0x3c, 0xe7, 0x69, 
};
static const u8 rsa_oaep_119_CRT_q[] = {
0xbc, 0x46, 0xc4, 0x64, 0xfc, 0x6a, 0xc4, 0xca, 0x78, 0x3b, 0x0e, 0xb0, 0x8a, 0x3c, 0x84, 0x1b, 0x77, 0x2f, 0x7e, 0x9b, 0x2f, 0x28, 0xba, 0xbd, 0x58, 0x8a, 0xe8, 0x85, 0xe1, 0xa0, 0xc6, 0x1e, 0x48, 0x58, 0xa0, 0xfb, 0x25, 0xac, 0x29, 0x99, 0x90, 0xf3, 0x5b, 0xe8, 0x51, 0x64, 0xc2, 0x59, 0xba, 0x11, 0x75, 0xcd, 0xd7, 0x19, 0x27, 0x07, 0x13, 0x51, 0x84, 0x99, 0x2b, 0x6c, 0x29, 0xb7, 0x46, 0xdd, 0x0d, 0x2c, 0xab, 0xe1, 0x42, 0x83, 0x5f, 0x7d, 0x14, 0x8c, 0xc1, 0x61, 0x52, 0x4b, 0x4a, 0x09, 0x94, 0x6d, 0x48, 0xb8, 0x28, 0x47, 0x3f, 0x1c, 0xe7, 0x6b, 0x6c, 0xb6, 0x88, 0x6c, 0x34, 0x5c, 0x03, 0xe0, 0x5f, 0x41, 0xd5, 0x1b, 0x5c, 0x3a, 0x90, 0xa3, 0xf2, 0x40, 0x73, 0xc7, 0xd7, 0x4a, 0x4f, 0xe2, 0x5d, 0x9c, 0xf2, 0x1c, 0x75, 0x96, 0x0f, 0x3f, 0xc3, 0x86, 0x31, 0x83, 
};
static const u8 rsa_oaep_119_CRT_dP[] = {
0xc7, 0x35, 0x64, 0x57, 0x1d, 0x00, 0xfb, 0x15, 0xd0, 0x8a, 0x3d, 0xe9, 0x95, 0x7a, 0x50, 0x91, 0x5d, 0x71, 0x26, 0xe9, 0x44, 0x2d, 0xac, 0xf4, 0x2b, 0xc8, 0x2e, 0x86, 0x2e, 0x56, 0x73, 0xff, 0x6a, 0x00, 0x8e, 0xd4, 0xd2, 0xe3, 0x74, 0x61, 0x7d, 0xf8, 0x9f, 0x17, 0xa1, 0x60, 0xb4, 0x3b, 0x7f, 0xda, 0x9c, 0xb6, 0xb6, 0xb7, 0x42, 0x18, 0x60, 0x98, 0x15, 0xf7, 0xd4, 0x5c, 0xa2, 0x63, 0xc1, 0x59, 0xaa, 0x32, 0xd2, 0x72, 0xd1, 0x27, 0xfa, 0xf4, 0xbc, 0x8c, 0xa2, 0xd7, 0x73, 0x78, 0xe8, 0xae, 0xb1, 0x9b, 0x0a, 0xd7, 0xda, 0x3c, 0xb3, 0xde, 0x0a, 0xe7, 0x31, 0x49, 0x80, 0xf6, 0x2b, 0x6d, 0x4b, 0x0a, 0x87, 0x5d, 0x1d, 0xf0, 0x3c, 0x1b, 0xae, 0x39, 0xcc, 0xd8, 0x33, 0xef, 0x6c, 0xd7, 0xe2, 0xd9, 0x52, 0x8b, 0xf0, 0x84, 0xd1, 0xf9, 0x69, 0xe7, 0x94, 0xe9, 0xf6, 0xc1, 
};
static const u8 rsa_oaep_119_CRT_dQ[] = {
0x26, 0x58, 0xb3, 0x7f, 0x6d, 0xf9, 0xc1, 0x03, 0x0b, 0xe1, 0xdb, 0x68, 0x11, 0x7f, 0xa9, 0xd8, 0x7e, 0x39, 0xea, 0x2b, 0x69, 0x3b, 0x7e, 0x6d, 0x3a, 0x2f, 0x70, 0x94, 0x74, 0x13, 0xee, 0xc6, 0x14, 0x2e, 0x18, 0xfb, 0x8d, 0xfc, 0xb6, 0xac, 0x54, 0x5d, 0x7c, 0x86, 0xa0, 0xad, 0x48, 0xf8, 0x45, 0x71, 0x70, 0xf0, 0xef, 0xb2, 0x6b, 0xc4, 0x81, 0x26, 0xc5, 0x3e, 0xfd, 0x1d, 0x16, 0x92, 0x01, 0x98, 0xdc, 0x2a, 0x11, 0x07, 0xdc, 0x28, 0x2d, 0xb6, 0xa8, 0x0c, 0xd3, 0x06, 0x23, 0x60, 0xba, 0x3f, 0xa1, 0x3f, 0x70, 0xe4, 0x31, 0x2f, 0xf1, 0xa6, 0xcd, 0x6b, 0x8f, 0xc4, 0xcd, 0x9c, 0x5c, 0x3d, 0xb1, 0x7c, 0x6d, 0x6a, 0x57, 0x21, 0x2f, 0x73, 0xae, 0x29, 0xf6, 0x19, 0x32, 0x7b, 0xad, 0x59, 0xb1, 0x53, 0x85, 0x85, 0x85, 0xba, 0x4e, 0x28, 0xb6, 0x0a, 0x62, 0xa4, 0x5e, 0x49, 
};
static const u8 rsa_oaep_119_CRT_qInv[] = {
0x6f, 0x38, 0x52, 0x6b, 0x39, 0x25, 0x08, 0x55, 0x34, 0xef, 0x3e, 0x41, 0x5a, 0x83, 0x6e, 0xde, 0x8b, 0x86, 0x15, 0x8a, 0x2c, 0x7c, 0xbf, 0xec, 0xcb, 0x0b, 0xd8, 0x34, 0x30, 0x4f, 0xec, 0x68, 0x3b, 0xa8, 0xd4, 0xf4, 0x79, 0xc4, 0x33, 0xd4, 0x34, 0x16, 0xe6, 0x32, 0x69, 0x62, 0x3c, 0xea, 0x10, 0x07, 0x76, 0xd8, 0x5a, 0xff, 0x40, 0x1d, 0x3f, 0xff, 0x61, 0x0e, 0xe6, 0x54, 0x11, 0xce, 0x3b, 0x13, 0x63, 0xd6, 0x3a, 0x97, 0x09, 0xee, 0xde, 0x42, 0x64, 0x7c, 0xea, 0x56, 0x14, 0x93, 0xd5, 0x45, 0x70, 0xa8, 0x79, 0xc1, 0x86, 0x82, 0xcd, 0x97, 0x71, 0x0b, 0x96, 0x20, 0x5e, 0xc3, 0x11, 0x17, 0xd7, 0x3b, 0x5f, 0x36, 0x22, 0x3f, 0xad, 0xd6, 0xe8, 0xba, 0x90, 0xdd, 0x7c, 0x0e, 0xe6, 0x1d, 0x44, 0xe1, 0x63, 0x25, 0x1e, 0x20, 0xc7, 0xf6, 0x6e, 0xb3, 0x05, 0x11, 0x7c, 0xb8, 
};


static const rsa_test test_rsa_oaep_119_CRT = {
	.name = "rsa_oaep_119_CRT",
	.type = RSA_OAEP_ENC,
	.modbits = 2048,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_oaep_119_CRT_n,
	.nlen = sizeof(rsa_oaep_119_CRT_n),
	.d = (const u8*)&rsa_oaep_119_CRT_d,
	.dlen = sizeof(rsa_oaep_119_CRT_d),
	.e = (const u8*)&rsa_oaep_119_CRT_e,
	.elen = sizeof(rsa_oaep_119_CRT_e),
	.p = (const u8*)&rsa_oaep_119_CRT_p,
	.plen = sizeof(rsa_oaep_119_CRT_p),
	.q = (const u8*)&rsa_oaep_119_CRT_q,
	.qlen = sizeof(rsa_oaep_119_CRT_q),
	.dP = (const u8*)&rsa_oaep_119_CRT_dP,
	.dPlen = sizeof(rsa_oaep_119_CRT_dP),
	.dQ = (const u8*)&rsa_oaep_119_CRT_dQ,
	.dQlen = sizeof(rsa_oaep_119_CRT_dQ),
	.qInv = (const u8*)&rsa_oaep_119_CRT_qInv,
	.qInvlen = sizeof(rsa_oaep_119_CRT_qInv),
	.m = (const u8*)&rsa_oaep_119_CRT_m,
	.mlen = sizeof(rsa_oaep_119_CRT_m),
	.res = (const u8*)&rsa_oaep_119_CRT_res,
	.reslen = sizeof(rsa_oaep_119_CRT_res),
	.salt = (const u8*)&rsa_oaep_119_CRT_salt,
	.saltlen = sizeof(rsa_oaep_119_CRT_salt),
};
static const u8 rsa_pss_120_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_120_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_120_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_120_m[] = {
0xcd, 0xc8, 0x7d, 0xa2, 0x23, 0xd7, 0x86, 0xdf, 0x3b, 0x45, 0xe0, 0xbb, 0xbc, 0x72, 0x13, 0x26, 0xd1, 0xee, 0x2a, 0xf8, 0x06, 0xcc, 0x31, 0x54, 0x75, 0xcc, 0x6f, 0x0d, 0x9c, 0x66, 0xe1, 0xb6, 0x23, 0x71, 0xd4, 0x5c, 0xe2, 0x39, 0x2e, 0x1a, 0xc9, 0x28, 0x44, 0xc3, 0x10, 0x10, 0x2f, 0x15, 0x6a, 0x0d, 0x8d, 0x52, 0xc1, 0xf4, 0xc4, 0x0b, 0xa3, 0xaa, 0x65, 0x09, 0x57, 0x86, 0xcb, 0x76, 0x97, 0x57, 0xa6, 0x56, 0x3b, 0xa9, 0x58, 0xfe, 0xd0, 0xbc, 0xc9, 0x84, 0xe8, 0xb5, 0x17, 0xa3, 0xd5, 0xf5, 0x15, 0xb2, 0x3b, 0x8a, 0x41, 0xe7, 0x4a, 0xa8, 0x67, 0x69, 0x3f, 0x90, 0xdf, 0xb0, 0x61, 0xa6, 0xe8, 0x6d, 0xfa, 0xae, 0xe6, 0x44, 0x72, 0xc0, 0x0e, 0x5f, 0x20, 0x94, 0x57, 0x29, 0xcb, 0xeb, 0xe7, 0x7f, 0x06, 0xce, 0x78, 0xe0, 0x8f, 0x40, 0x98, 0xfb, 0xa4, 0x1f, 0x9d, 0x61, 0x93, 0xc0, 0x31, 0x7e, 0x8b, 0x60, 0xd4, 0xb6, 0x08, 0x4a, 0xcb, 0x42, 0xd2, 0x9e, 0x38, 0x08, 0xa3, 0xbc, 0x37, 0x2d, 0x85, 0xe3, 0x31, 0x17, 0x0f, 0xcb, 0xf7, 0xcc, 0x72, 0xd0, 0xb7, 0x1c, 0x29, 0x66, 0x48, 0xb3, 0xa4, 0xd1, 0x0f, 0x41, 0x62, 0x95, 0xd0, 0x80, 0x7a, 0xa6, 0x25, 0xca, 0xb2, 0x74, 0x4f, 0xd9, 0xea, 0x8f, 0xd2, 0x23, 0xc4, 0x25, 0x37, 0x02, 0x98, 0x28, 0xbd, 0x16, 0xbe, 0x02, 0x54, 0x6f, 0x13, 0x0f, 0xd2, 0xe3, 0x3b, 0x93, 0x6d, 0x26, 0x76, 0xe0, 0x8a, 0xed, 0x1b, 0x73, 0x31, 0x8b, 0x75, 0x0a, 0x01, 0x67, 0xd0, 
};
static const u8 rsa_pss_120_res[] = {
0x90, 0x74, 0x30, 0x8f, 0xb5, 0x98, 0xe9, 0x70, 0x1b, 0x22, 0x94, 0x38, 0x8e, 0x52, 0xf9, 0x71, 0xfa, 0xac, 0x2b, 0x60, 0xa5, 0x14, 0x5a, 0xf1, 0x85, 0xdf, 0x52, 0x87, 0xb5, 0xed, 0x28, 0x87, 0xe5, 0x7c, 0xe7, 0xfd, 0x44, 0xdc, 0x86, 0x34, 0xe4, 0x07, 0xc8, 0xe0, 0xe4, 0x36, 0x0b, 0xc2, 0x26, 0xf3, 0xec, 0x22, 0x7f, 0x9d, 0x9e, 0x54, 0x63, 0x8e, 0x8d, 0x31, 0xf5, 0x05, 0x12, 0x15, 0xdf, 0x6e, 0xbb, 0x9c, 0x2f, 0x95, 0x79, 0xaa, 0x77, 0x59, 0x8a, 0x38, 0xf9, 0x14, 0xb5, 0xb9, 0xc1, 0xbd, 0x83, 0xc4, 0xe2, 0xf9, 0xf3, 0x82, 0xa0, 0xd0, 0xaa, 0x35, 0x42, 0xff, 0xee, 0x65, 0x98, 0x4a, 0x60, 0x1b, 0xc6, 0x9e, 0xb2, 0x8d, 0xeb, 0x27, 0xdc, 0xa1, 0x2c, 0x82, 0xc2, 0xd4, 0xc3, 0xf6, 0x6c, 0xd5, 0x00, 0xf1, 0xff, 0x2b, 0x99, 0x4d, 0x8a, 0x4e, 0x30, 0xcb, 0xb3, 0x3c, 
};
static const u8 rsa_pss_120_salt[] = {
0xde, 0xe9, 0x59, 0xc7, 0xe0, 0x64, 0x11, 0x36, 0x14, 0x20, 0xff, 0x80, 0x18, 0x5e, 0xd5, 0x7f, 0x3e, 0x67, 0x76, 0xaf, 
};


static const rsa_test test_rsa_pss_120 = {
	.name = "rsa_pss_120",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_120_n,
	.nlen = sizeof(rsa_pss_120_n),
	.d = (const u8*)&rsa_pss_120_d,
	.dlen = sizeof(rsa_pss_120_d),
	.e = (const u8*)&rsa_pss_120_e,
	.elen = sizeof(rsa_pss_120_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_120_m,
	.mlen = sizeof(rsa_pss_120_m),
	.res = (const u8*)&rsa_pss_120_res,
	.reslen = sizeof(rsa_pss_120_res),
	.salt = (const u8*)&rsa_pss_120_salt,
	.saltlen = sizeof(rsa_pss_120_salt),
};
static const u8 rsa_pss_121_CRT_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_121_CRT_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_121_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_121_CRT_m[] = {
0xcd, 0xc8, 0x7d, 0xa2, 0x23, 0xd7, 0x86, 0xdf, 0x3b, 0x45, 0xe0, 0xbb, 0xbc, 0x72, 0x13, 0x26, 0xd1, 0xee, 0x2a, 0xf8, 0x06, 0xcc, 0x31, 0x54, 0x75, 0xcc, 0x6f, 0x0d, 0x9c, 0x66, 0xe1, 0xb6, 0x23, 0x71, 0xd4, 0x5c, 0xe2, 0x39, 0x2e, 0x1a, 0xc9, 0x28, 0x44, 0xc3, 0x10, 0x10, 0x2f, 0x15, 0x6a, 0x0d, 0x8d, 0x52, 0xc1, 0xf4, 0xc4, 0x0b, 0xa3, 0xaa, 0x65, 0x09, 0x57, 0x86, 0xcb, 0x76, 0x97, 0x57, 0xa6, 0x56, 0x3b, 0xa9, 0x58, 0xfe, 0xd0, 0xbc, 0xc9, 0x84, 0xe8, 0xb5, 0x17, 0xa3, 0xd5, 0xf5, 0x15, 0xb2, 0x3b, 0x8a, 0x41, 0xe7, 0x4a, 0xa8, 0x67, 0x69, 0x3f, 0x90, 0xdf, 0xb0, 0x61, 0xa6, 0xe8, 0x6d, 0xfa, 0xae, 0xe6, 0x44, 0x72, 0xc0, 0x0e, 0x5f, 0x20, 0x94, 0x57, 0x29, 0xcb, 0xeb, 0xe7, 0x7f, 0x06, 0xce, 0x78, 0xe0, 0x8f, 0x40, 0x98, 0xfb, 0xa4, 0x1f, 0x9d, 0x61, 0x93, 0xc0, 0x31, 0x7e, 0x8b, 0x60, 0xd4, 0xb6, 0x08, 0x4a, 0xcb, 0x42, 0xd2, 0x9e, 0x38, 0x08, 0xa3, 0xbc, 0x37, 0x2d, 0x85, 0xe3, 0x31, 0x17, 0x0f, 0xcb, 0xf7, 0xcc, 0x72, 0xd0, 0xb7, 0x1c, 0x29, 0x66, 0x48, 0xb3, 0xa4, 0xd1, 0x0f, 0x41, 0x62, 0x95, 0xd0, 0x80, 0x7a, 0xa6, 0x25, 0xca, 0xb2, 0x74, 0x4f, 0xd9, 0xea, 0x8f, 0xd2, 0x23, 0xc4, 0x25, 0x37, 0x02, 0x98, 0x28, 0xbd, 0x16, 0xbe, 0x02, 0x54, 0x6f, 0x13, 0x0f, 0xd2, 0xe3, 0x3b, 0x93, 0x6d, 0x26, 0x76, 0xe0, 0x8a, 0xed, 0x1b, 0x73, 0x31, 0x8b, 0x75, 0x0a, 0x01, 0x67, 0xd0, 
};
static const u8 rsa_pss_121_CRT_res[] = {
0x90, 0x74, 0x30, 0x8f, 0xb5, 0x98, 0xe9, 0x70, 0x1b, 0x22, 0x94, 0x38, 0x8e, 0x52, 0xf9, 0x71, 0xfa, 0xac, 0x2b, 0x60, 0xa5, 0x14, 0x5a, 0xf1, 0x85, 0xdf, 0x52, 0x87, 0xb5, 0xed, 0x28, 0x87, 0xe5, 0x7c, 0xe7, 0xfd, 0x44, 0xdc, 0x86, 0x34, 0xe4, 0x07, 0xc8, 0xe0, 0xe4, 0x36, 0x0b, 0xc2, 0x26, 0xf3, 0xec, 0x22, 0x7f, 0x9d, 0x9e, 0x54, 0x63, 0x8e, 0x8d, 0x31, 0xf5, 0x05, 0x12, 0x15, 0xdf, 0x6e, 0xbb, 0x9c, 0x2f, 0x95, 0x79, 0xaa, 0x77, 0x59, 0x8a, 0x38, 0xf9, 0x14, 0xb5, 0xb9, 0xc1, 0xbd, 0x83, 0xc4, 0xe2, 0xf9, 0xf3, 0x82, 0xa0, 0xd0, 0xaa, 0x35, 0x42, 0xff, 0xee, 0x65, 0x98, 0x4a, 0x60, 0x1b, 0xc6, 0x9e, 0xb2, 0x8d, 0xeb, 0x27, 0xdc, 0xa1, 0x2c, 0x82, 0xc2, 0xd4, 0xc3, 0xf6, 0x6c, 0xd5, 0x00, 0xf1, 0xff, 0x2b, 0x99, 0x4d, 0x8a, 0x4e, 0x30, 0xcb, 0xb3, 0x3c, 
};
static const u8 rsa_pss_121_CRT_salt[] = {
0xde, 0xe9, 0x59, 0xc7, 0xe0, 0x64, 0x11, 0x36, 0x14, 0x20, 0xff, 0x80, 0x18, 0x5e, 0xd5, 0x7f, 0x3e, 0x67, 0x76, 0xaf, 
};
static const u8 rsa_pss_121_CRT_p[] = {
0xe7, 0xe8, 0x94, 0x27, 0x20, 0xa8, 0x77, 0x51, 0x72, 0x73, 0xa3, 0x56, 0x05, 0x3e, 0xa2, 0xa1, 0xbc, 0x0c, 0x94, 0xaa, 0x72, 0xd5, 0x5c, 0x6e, 0x86, 0x29, 0x6b, 0x2d, 0xfc, 0x96, 0x79, 0x48, 0xc0, 0xa7, 0x2c, 0xbc, 0xcc, 0xa7, 0xea, 0xcb, 0x35, 0x70, 0x6e, 0x09, 0xa1, 0xdf, 0x55, 0xa1, 0x53, 0x5b, 0xd9, 0xb3, 0xcc, 0x34, 0x16, 0x0b, 0x3b, 0x6d, 0xcd, 0x3e, 0xda, 0x8e, 0x64, 0x43, 
};
static const u8 rsa_pss_121_CRT_q[] = {
0xb6, 0x9d, 0xca, 0x1c, 0xf7, 0xd4, 0xd7, 0xec, 0x81, 0xe7, 0x5b, 0x90, 0xfc, 0xca, 0x87, 0x4a, 0xbc, 0xde, 0x12, 0x3f, 0xd2, 0x70, 0x01, 0x80, 0xaa, 0x90, 0x47, 0x9b, 0x6e, 0x48, 0xde, 0x8d, 0x67, 0xed, 0x24, 0xf9, 0xf1, 0x9d, 0x85, 0xba, 0x27, 0x58, 0x74, 0xf5, 0x42, 0xcd, 0x20, 0xdc, 0x72, 0x3e, 0x69, 0x63, 0x36, 0x4a, 0x1f, 0x94, 0x25, 0x45, 0x2b, 0x26, 0x9a, 0x67, 0x99, 0xfd, 
};
static const u8 rsa_pss_121_CRT_dP[] = {
0x28, 0xfa, 0x13, 0x93, 0x86, 0x55, 0xbe, 0x1f, 0x8a, 0x15, 0x9c, 0xba, 0xca, 0x5a, 0x72, 0xea, 0x19, 0x0c, 0x30, 0x08, 0x9e, 0x19, 0xcd, 0x27, 0x4a, 0x55, 0x6f, 0x36, 0xc4, 0xf6, 0xe1, 0x9f, 0x55, 0x4b, 0x34, 0xc0, 0x77, 0x79, 0x04, 0x27, 0xbb, 0xdd, 0x8d, 0xd3, 0xed, 0xe2, 0x44, 0x83, 0x28, 0xf3, 0x85, 0xd8, 0x1b, 0x30, 0xe8, 0xe4, 0x3b, 0x2f, 0xff, 0xa0, 0x27, 0x86, 0x19, 0x79, 
};
static const u8 rsa_pss_121_CRT_dQ[] = {
0x1a, 0x8b, 0x38, 0xf3, 0x98, 0xfa, 0x71, 0x20, 0x49, 0x89, 0x8d, 0x7f, 0xb7, 0x9e, 0xe0, 0xa7, 0x76, 0x68, 0x79, 0x12, 0x99, 0xcd, 0xfa, 0x09, 0xef, 0xc0, 0xe5, 0x07, 0xac, 0xb2, 0x1e, 0xd7, 0x43, 0x01, 0xef, 0x5b, 0xfd, 0x48, 0xbe, 0x45, 0x5e, 0xae, 0xb6, 0xe1, 0x67, 0x82, 0x55, 0x82, 0x75, 0x80, 0xa8, 0xe4, 0xe8, 0xe1, 0x41, 0x51, 0xd1, 0x51, 0x0a, 0x82, 0xa3, 0xf2, 0xe7, 0x29, 
};
static const u8 rsa_pss_121_CRT_qInv[] = {
0x27, 0x15, 0x6a, 0xba, 0x41, 0x26, 0xd2, 0x4a, 0x81, 0xf3, 0xa5, 0x28, 0xcb, 0xfb, 0x27, 0xf5, 0x68, 0x86, 0xf8, 0x40, 0xa9, 0xf6, 0xe8, 0x6e, 0x17, 0xa4, 0x4b, 0x94, 0xfe, 0x93, 0x19, 0x58, 0x4b, 0x8e, 0x22, 0xfd, 0xde, 0x1e, 0x5a, 0x2e, 0x3b, 0xd8, 0xaa, 0x5b, 0xa8, 0xd8, 0x58, 0x41, 0x94, 0xeb, 0x21, 0x90, 0xac, 0xf8, 0x32, 0xb8, 0x47, 0xf1, 0x3a, 0x3d, 0x24, 0xa7, 0x9f, 0x4d, 
};


static const rsa_test test_rsa_pss_121_CRT = {
	.name = "rsa_pss_121_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_121_CRT_n,
	.nlen = sizeof(rsa_pss_121_CRT_n),
	.d = (const u8*)&rsa_pss_121_CRT_d,
	.dlen = sizeof(rsa_pss_121_CRT_d),
	.e = (const u8*)&rsa_pss_121_CRT_e,
	.elen = sizeof(rsa_pss_121_CRT_e),
	.p = (const u8*)&rsa_pss_121_CRT_p,
	.plen = sizeof(rsa_pss_121_CRT_p),
	.q = (const u8*)&rsa_pss_121_CRT_q,
	.qlen = sizeof(rsa_pss_121_CRT_q),
	.dP = (const u8*)&rsa_pss_121_CRT_dP,
	.dPlen = sizeof(rsa_pss_121_CRT_dP),
	.dQ = (const u8*)&rsa_pss_121_CRT_dQ,
	.dQlen = sizeof(rsa_pss_121_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_121_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_121_CRT_qInv),
	.m = (const u8*)&rsa_pss_121_CRT_m,
	.mlen = sizeof(rsa_pss_121_CRT_m),
	.res = (const u8*)&rsa_pss_121_CRT_res,
	.reslen = sizeof(rsa_pss_121_CRT_res),
	.salt = (const u8*)&rsa_pss_121_CRT_salt,
	.saltlen = sizeof(rsa_pss_121_CRT_salt),
};
static const u8 rsa_pss_122_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_122_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_122_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_122_m[] = {
0x85, 0x13, 0x84, 0xcd, 0xfe, 0x81, 0x9c, 0x22, 0xed, 0x6c, 0x4c, 0xcb, 0x30, 0xda, 0xeb, 0x5c, 0xf0, 0x59, 0xbc, 0x8e, 0x11, 0x66, 0xb7, 0xe3, 0x53, 0x0c, 0x4c, 0x23, 0x3e, 0x2b, 0x5f, 0x8f, 0x71, 0xa1, 0xcc, 0xa5, 0x82, 0xd4, 0x3e, 0xcc, 0x72, 0xb1, 0xbc, 0xa1, 0x6d, 0xfc, 0x70, 0x13, 0x22, 0x6b, 0x9e, 
};
static const u8 rsa_pss_122_res[] = {
0x3e, 0xf7, 0xf4, 0x6e, 0x83, 0x1b, 0xf9, 0x2b, 0x32, 0x27, 0x41, 0x42, 0xa5, 0x85, 0xff, 0xce, 0xfb, 0xdc, 0xa7, 0xb3, 0x2a, 0xe9, 0x0d, 0x10, 0xfb, 0x0f, 0x0c, 0x72, 0x99, 0x84, 0xf0, 0x4e, 0xf2, 0x9a, 0x9d, 0xf0, 0x78, 0x07, 0x75, 0xce, 0x43, 0x73, 0x9b, 0x97, 0x83, 0x83, 0x90, 0xdb, 0x0a, 0x55, 0x05, 0xe6, 0x3d, 0xe9, 0x27, 0x02, 0x8d, 0x9d, 0x29, 0xb2, 0x19, 0xca, 0x2c, 0x45, 0x17, 0x83, 0x25, 0x58, 0xa5, 0x5d, 0x69, 0x4a, 0x6d, 0x25, 0xb9, 0xda, 0xb6, 0x60, 0x03, 0xc4, 0xcc, 0xcd, 0x90, 0x78, 0x02, 0x19, 0x3b, 0xe5, 0x17, 0x0d, 0x26, 0x14, 0x7d, 0x37, 0xb9, 0x35, 0x90, 0x24, 0x1b, 0xe5, 0x1c, 0x25, 0x05, 0x5f, 0x47, 0xef, 0x62, 0x75, 0x2c, 0xfb, 0xe2, 0x14, 0x18, 0xfa, 0xfe, 0x98, 0xc2, 0x2c, 0x4d, 0x4d, 0x47, 0x72, 0x4f, 0xdb, 0x56, 0x69, 0xe8, 0x43, 
};
static const u8 rsa_pss_122_salt[] = {
0xef, 0x28, 0x69, 0xfa, 0x40, 0xc3, 0x46, 0xcb, 0x18, 0x3d, 0xab, 0x3d, 0x7b, 0xff, 0xc9, 0x8f, 0xd5, 0x6d, 0xf4, 0x2d, 
};


static const rsa_test test_rsa_pss_122 = {
	.name = "rsa_pss_122",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_122_n,
	.nlen = sizeof(rsa_pss_122_n),
	.d = (const u8*)&rsa_pss_122_d,
	.dlen = sizeof(rsa_pss_122_d),
	.e = (const u8*)&rsa_pss_122_e,
	.elen = sizeof(rsa_pss_122_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_122_m,
	.mlen = sizeof(rsa_pss_122_m),
	.res = (const u8*)&rsa_pss_122_res,
	.reslen = sizeof(rsa_pss_122_res),
	.salt = (const u8*)&rsa_pss_122_salt,
	.saltlen = sizeof(rsa_pss_122_salt),
};
static const u8 rsa_pss_123_CRT_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_123_CRT_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_123_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_123_CRT_m[] = {
0x85, 0x13, 0x84, 0xcd, 0xfe, 0x81, 0x9c, 0x22, 0xed, 0x6c, 0x4c, 0xcb, 0x30, 0xda, 0xeb, 0x5c, 0xf0, 0x59, 0xbc, 0x8e, 0x11, 0x66, 0xb7, 0xe3, 0x53, 0x0c, 0x4c, 0x23, 0x3e, 0x2b, 0x5f, 0x8f, 0x71, 0xa1, 0xcc, 0xa5, 0x82, 0xd4, 0x3e, 0xcc, 0x72, 0xb1, 0xbc, 0xa1, 0x6d, 0xfc, 0x70, 0x13, 0x22, 0x6b, 0x9e, 
};
static const u8 rsa_pss_123_CRT_res[] = {
0x3e, 0xf7, 0xf4, 0x6e, 0x83, 0x1b, 0xf9, 0x2b, 0x32, 0x27, 0x41, 0x42, 0xa5, 0x85, 0xff, 0xce, 0xfb, 0xdc, 0xa7, 0xb3, 0x2a, 0xe9, 0x0d, 0x10, 0xfb, 0x0f, 0x0c, 0x72, 0x99, 0x84, 0xf0, 0x4e, 0xf2, 0x9a, 0x9d, 0xf0, 0x78, 0x07, 0x75, 0xce, 0x43, 0x73, 0x9b, 0x97, 0x83, 0x83, 0x90, 0xdb, 0x0a, 0x55, 0x05, 0xe6, 0x3d, 0xe9, 0x27, 0x02, 0x8d, 0x9d, 0x29, 0xb2, 0x19, 0xca, 0x2c, 0x45, 0x17, 0x83, 0x25, 0x58, 0xa5, 0x5d, 0x69, 0x4a, 0x6d, 0x25, 0xb9, 0xda, 0xb6, 0x60, 0x03, 0xc4, 0xcc, 0xcd, 0x90, 0x78, 0x02, 0x19, 0x3b, 0xe5, 0x17, 0x0d, 0x26, 0x14, 0x7d, 0x37, 0xb9, 0x35, 0x90, 0x24, 0x1b, 0xe5, 0x1c, 0x25, 0x05, 0x5f, 0x47, 0xef, 0x62, 0x75, 0x2c, 0xfb, 0xe2, 0x14, 0x18, 0xfa, 0xfe, 0x98, 0xc2, 0x2c, 0x4d, 0x4d, 0x47, 0x72, 0x4f, 0xdb, 0x56, 0x69, 0xe8, 0x43, 
};
static const u8 rsa_pss_123_CRT_salt[] = {
0xef, 0x28, 0x69, 0xfa, 0x40, 0xc3, 0x46, 0xcb, 0x18, 0x3d, 0xab, 0x3d, 0x7b, 0xff, 0xc9, 0x8f, 0xd5, 0x6d, 0xf4, 0x2d, 
};
static const u8 rsa_pss_123_CRT_p[] = {
0xe7, 0xe8, 0x94, 0x27, 0x20, 0xa8, 0x77, 0x51, 0x72, 0x73, 0xa3, 0x56, 0x05, 0x3e, 0xa2, 0xa1, 0xbc, 0x0c, 0x94, 0xaa, 0x72, 0xd5, 0x5c, 0x6e, 0x86, 0x29, 0x6b, 0x2d, 0xfc, 0x96, 0x79, 0x48, 0xc0, 0xa7, 0x2c, 0xbc, 0xcc, 0xa7, 0xea, 0xcb, 0x35, 0x70, 0x6e, 0x09, 0xa1, 0xdf, 0x55, 0xa1, 0x53, 0x5b, 0xd9, 0xb3, 0xcc, 0x34, 0x16, 0x0b, 0x3b, 0x6d, 0xcd, 0x3e, 0xda, 0x8e, 0x64, 0x43, 
};
static const u8 rsa_pss_123_CRT_q[] = {
0xb6, 0x9d, 0xca, 0x1c, 0xf7, 0xd4, 0xd7, 0xec, 0x81, 0xe7, 0x5b, 0x90, 0xfc, 0xca, 0x87, 0x4a, 0xbc, 0xde, 0x12, 0x3f, 0xd2, 0x70, 0x01, 0x80, 0xaa, 0x90, 0x47, 0x9b, 0x6e, 0x48, 0xde, 0x8d, 0x67, 0xed, 0x24, 0xf9, 0xf1, 0x9d, 0x85, 0xba, 0x27, 0x58, 0x74, 0xf5, 0x42, 0xcd, 0x20, 0xdc, 0x72, 0x3e, 0x69, 0x63, 0x36, 0x4a, 0x1f, 0x94, 0x25, 0x45, 0x2b, 0x26, 0x9a, 0x67, 0x99, 0xfd, 
};
static const u8 rsa_pss_123_CRT_dP[] = {
0x28, 0xfa, 0x13, 0x93, 0x86, 0x55, 0xbe, 0x1f, 0x8a, 0x15, 0x9c, 0xba, 0xca, 0x5a, 0x72, 0xea, 0x19, 0x0c, 0x30, 0x08, 0x9e, 0x19, 0xcd, 0x27, 0x4a, 0x55, 0x6f, 0x36, 0xc4, 0xf6, 0xe1, 0x9f, 0x55, 0x4b, 0x34, 0xc0, 0x77, 0x79, 0x04, 0x27, 0xbb, 0xdd, 0x8d, 0xd3, 0xed, 0xe2, 0x44, 0x83, 0x28, 0xf3, 0x85, 0xd8, 0x1b, 0x30, 0xe8, 0xe4, 0x3b, 0x2f, 0xff, 0xa0, 0x27, 0x86, 0x19, 0x79, 
};
static const u8 rsa_pss_123_CRT_dQ[] = {
0x1a, 0x8b, 0x38, 0xf3, 0x98, 0xfa, 0x71, 0x20, 0x49, 0x89, 0x8d, 0x7f, 0xb7, 0x9e, 0xe0, 0xa7, 0x76, 0x68, 0x79, 0x12, 0x99, 0xcd, 0xfa, 0x09, 0xef, 0xc0, 0xe5, 0x07, 0xac, 0xb2, 0x1e, 0xd7, 0x43, 0x01, 0xef, 0x5b, 0xfd, 0x48, 0xbe, 0x45, 0x5e, 0xae, 0xb6, 0xe1, 0x67, 0x82, 0x55, 0x82, 0x75, 0x80, 0xa8, 0xe4, 0xe8, 0xe1, 0x41, 0x51, 0xd1, 0x51, 0x0a, 0x82, 0xa3, 0xf2, 0xe7, 0x29, 
};
static const u8 rsa_pss_123_CRT_qInv[] = {
0x27, 0x15, 0x6a, 0xba, 0x41, 0x26, 0xd2, 0x4a, 0x81, 0xf3, 0xa5, 0x28, 0xcb, 0xfb, 0x27, 0xf5, 0x68, 0x86, 0xf8, 0x40, 0xa9, 0xf6, 0xe8, 0x6e, 0x17, 0xa4, 0x4b, 0x94, 0xfe, 0x93, 0x19, 0x58, 0x4b, 0x8e, 0x22, 0xfd, 0xde, 0x1e, 0x5a, 0x2e, 0x3b, 0xd8, 0xaa, 0x5b, 0xa8, 0xd8, 0x58, 0x41, 0x94, 0xeb, 0x21, 0x90, 0xac, 0xf8, 0x32, 0xb8, 0x47, 0xf1, 0x3a, 0x3d, 0x24, 0xa7, 0x9f, 0x4d, 
};


static const rsa_test test_rsa_pss_123_CRT = {
	.name = "rsa_pss_123_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_123_CRT_n,
	.nlen = sizeof(rsa_pss_123_CRT_n),
	.d = (const u8*)&rsa_pss_123_CRT_d,
	.dlen = sizeof(rsa_pss_123_CRT_d),
	.e = (const u8*)&rsa_pss_123_CRT_e,
	.elen = sizeof(rsa_pss_123_CRT_e),
	.p = (const u8*)&rsa_pss_123_CRT_p,
	.plen = sizeof(rsa_pss_123_CRT_p),
	.q = (const u8*)&rsa_pss_123_CRT_q,
	.qlen = sizeof(rsa_pss_123_CRT_q),
	.dP = (const u8*)&rsa_pss_123_CRT_dP,
	.dPlen = sizeof(rsa_pss_123_CRT_dP),
	.dQ = (const u8*)&rsa_pss_123_CRT_dQ,
	.dQlen = sizeof(rsa_pss_123_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_123_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_123_CRT_qInv),
	.m = (const u8*)&rsa_pss_123_CRT_m,
	.mlen = sizeof(rsa_pss_123_CRT_m),
	.res = (const u8*)&rsa_pss_123_CRT_res,
	.reslen = sizeof(rsa_pss_123_CRT_res),
	.salt = (const u8*)&rsa_pss_123_CRT_salt,
	.saltlen = sizeof(rsa_pss_123_CRT_salt),
};
static const u8 rsa_pss_124_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_124_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_124_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_124_m[] = {
0xa4, 0xb1, 0x59, 0x94, 0x17, 0x61, 0xc4, 0x0c, 0x6a, 0x82, 0xf2, 0xb8, 0x0d, 0x1b, 0x94, 0xf5, 0xaa, 0x26, 0x54, 0xfd, 0x17, 0xe1, 0x2d, 0x58, 0x88, 0x64, 0x67, 0x9b, 0x54, 0xcd, 0x04, 0xef, 0x8b, 0xd0, 0x30, 0x12, 0xbe, 0x8d, 0xc3, 0x7f, 0x4b, 0x83, 0xaf, 0x79, 0x63, 0xfa, 0xff, 0x0d, 0xfa, 0x22, 0x54, 0x77, 0x43, 0x7c, 0x48, 0x01, 0x7f, 0xf2, 0xbe, 0x81, 0x91, 0xcf, 0x39, 0x55, 0xfc, 0x07, 0x35, 0x6e, 0xab, 0x3f, 0x32, 0x2f, 0x7f, 0x62, 0x0e, 0x21, 0xd2, 0x54, 0xe5, 0xdb, 0x43, 0x24, 0x27, 0x9f, 0xe0, 0x67, 0xe0, 0x91, 0x0e, 0x2e, 0x81, 0xca, 0x2c, 0xab, 0x31, 0xc7, 0x45, 0xe6, 0x7a, 0x54, 0x05, 0x8e, 0xb5, 0x0d, 0x99, 0x3c, 0xdb, 0x9e, 0xd0, 0xb4, 0xd0, 0x29, 0xc0, 0x6d, 0x21, 0xa9, 0x4c, 0xa6, 0x61, 0xc3, 0xce, 0x27, 0xfa, 0xe1, 0xd6, 0xcb, 0x20, 0xf4, 0x56, 0x4d, 0x66, 0xce, 0x47, 0x67, 0x58, 0x3d, 0x0e, 0x5f, 0x06, 0x02, 0x15, 0xb5, 0x90, 0x17, 0xbe, 0x85, 0xea, 0x84, 0x89, 0x39, 0x12, 0x7b, 0xd8, 0xc9, 0xc4, 0xd4, 0x7b, 0x51, 0x05, 0x6c, 0x03, 0x1c, 0xf3, 0x36, 0xf1, 0x7c, 0x99, 0x80, 0xf3, 0xb8, 0xf5, 0xb9, 0xb6, 0x87, 0x8e, 0x8b, 0x79, 0x7a, 0xa4, 0x3b, 0x88, 0x26, 0x84, 0x33, 0x3e, 0x17, 0x89, 0x3f, 0xe9, 0xca, 0xa6, 0xaa, 0x29, 0x9f, 0x7e, 0xd1, 0xa1, 0x8e, 0xe2, 0xc5, 0x48, 0x64, 0xb7, 0xb2, 0xb9, 0x9b, 0x72, 0x61, 0x8f, 0xb0, 0x25, 0x74, 0xd1, 0x39, 0xef, 0x50, 0xf0, 0x19, 0xc9, 0xee, 0xf4, 0x16, 0x97, 0x13, 0x38, 0xe7, 0xd4, 0x70, 
};
static const u8 rsa_pss_124_res[] = {
0x66, 0x60, 0x26, 0xfb, 0xa7, 0x1b, 0xd3, 0xe7, 0xcf, 0x13, 0x15, 0x7c, 0xc2, 0xc5, 0x1a, 0x8e, 0x4a, 0xa6, 0x84, 0xaf, 0x97, 0x78, 0xf9, 0x18, 0x49, 0xf3, 0x43, 0x35, 0xd1, 0x41, 0xc0, 0x01, 0x54, 0xc4, 0x19, 0x76, 0x21, 0xf9, 0x62, 0x4a, 0x67, 0x5b, 0x5a, 0xbc, 0x22, 0xee, 0x7d, 0x5b, 0xaa, 0xff, 0xaa, 0xe1, 0xc9, 0xba, 0xca, 0x2c, 0xc3, 0x73, 0xb3, 0xf3, 0x3e, 0x78, 0xe6, 0x14, 0x3c, 0x39, 0x5a, 0x91, 0xaa, 0x7f, 0xac, 0xa6, 0x64, 0xeb, 0x73, 0x3a, 0xfd, 0x14, 0xd8, 0x82, 0x72, 0x59, 0xd9, 0x9a, 0x75, 0x50, 0xfa, 0xca, 0x50, 0x1e, 0xf2, 0xb0, 0x4e, 0x33, 0xc2, 0x3a, 0xa5, 0x1f, 0x4b, 0x9e, 0x82, 0x82, 0xef, 0xdb, 0x72, 0x8c, 0xc0, 0xab, 0x09, 0x40, 0x5a, 0x91, 0x60, 0x7c, 0x63, 0x69, 0x96, 0x1b, 0xc8, 0x27, 0x0d, 0x2d, 0x4f, 0x39, 0xfc, 0xe6, 0x12, 0xb1, 
};
static const u8 rsa_pss_124_salt[] = {
0x71, 0x0b, 0x9c, 0x47, 0x47, 0xd8, 0x00, 0xd4, 0xde, 0x87, 0xf1, 0x2a, 0xfd, 0xce, 0x6d, 0xf1, 0x81, 0x07, 0xcc, 0x77, 
};


static const rsa_test test_rsa_pss_124 = {
	.name = "rsa_pss_124",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_124_n,
	.nlen = sizeof(rsa_pss_124_n),
	.d = (const u8*)&rsa_pss_124_d,
	.dlen = sizeof(rsa_pss_124_d),
	.e = (const u8*)&rsa_pss_124_e,
	.elen = sizeof(rsa_pss_124_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_124_m,
	.mlen = sizeof(rsa_pss_124_m),
	.res = (const u8*)&rsa_pss_124_res,
	.reslen = sizeof(rsa_pss_124_res),
	.salt = (const u8*)&rsa_pss_124_salt,
	.saltlen = sizeof(rsa_pss_124_salt),
};
static const u8 rsa_pss_125_CRT_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_125_CRT_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_125_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_125_CRT_m[] = {
0xa4, 0xb1, 0x59, 0x94, 0x17, 0x61, 0xc4, 0x0c, 0x6a, 0x82, 0xf2, 0xb8, 0x0d, 0x1b, 0x94, 0xf5, 0xaa, 0x26, 0x54, 0xfd, 0x17, 0xe1, 0x2d, 0x58, 0x88, 0x64, 0x67, 0x9b, 0x54, 0xcd, 0x04, 0xef, 0x8b, 0xd0, 0x30, 0x12, 0xbe, 0x8d, 0xc3, 0x7f, 0x4b, 0x83, 0xaf, 0x79, 0x63, 0xfa, 0xff, 0x0d, 0xfa, 0x22, 0x54, 0x77, 0x43, 0x7c, 0x48, 0x01, 0x7f, 0xf2, 0xbe, 0x81, 0x91, 0xcf, 0x39, 0x55, 0xfc, 0x07, 0x35, 0x6e, 0xab, 0x3f, 0x32, 0x2f, 0x7f, 0x62, 0x0e, 0x21, 0xd2, 0x54, 0xe5, 0xdb, 0x43, 0x24, 0x27, 0x9f, 0xe0, 0x67, 0xe0, 0x91, 0x0e, 0x2e, 0x81, 0xca, 0x2c, 0xab, 0x31, 0xc7, 0x45, 0xe6, 0x7a, 0x54, 0x05, 0x8e, 0xb5, 0x0d, 0x99, 0x3c, 0xdb, 0x9e, 0xd0, 0xb4, 0xd0, 0x29, 0xc0, 0x6d, 0x21, 0xa9, 0x4c, 0xa6, 0x61, 0xc3, 0xce, 0x27, 0xfa, 0xe1, 0xd6, 0xcb, 0x20, 0xf4, 0x56, 0x4d, 0x66, 0xce, 0x47, 0x67, 0x58, 0x3d, 0x0e, 0x5f, 0x06, 0x02, 0x15, 0xb5, 0x90, 0x17, 0xbe, 0x85, 0xea, 0x84, 0x89, 0x39, 0x12, 0x7b, 0xd8, 0xc9, 0xc4, 0xd4, 0x7b, 0x51, 0x05, 0x6c, 0x03, 0x1c, 0xf3, 0x36, 0xf1, 0x7c, 0x99, 0x80, 0xf3, 0xb8, 0xf5, 0xb9, 0xb6, 0x87, 0x8e, 0x8b, 0x79, 0x7a, 0xa4, 0x3b, 0x88, 0x26, 0x84, 0x33, 0x3e, 0x17, 0x89, 0x3f, 0xe9, 0xca, 0xa6, 0xaa, 0x29, 0x9f, 0x7e, 0xd1, 0xa1, 0x8e, 0xe2, 0xc5, 0x48, 0x64, 0xb7, 0xb2, 0xb9, 0x9b, 0x72, 0x61, 0x8f, 0xb0, 0x25, 0x74, 0xd1, 0x39, 0xef, 0x50, 0xf0, 0x19, 0xc9, 0xee, 0xf4, 0x16, 0x97, 0x13, 0x38, 0xe7, 0xd4, 0x70, 
};
static const u8 rsa_pss_125_CRT_res[] = {
0x66, 0x60, 0x26, 0xfb, 0xa7, 0x1b, 0xd3, 0xe7, 0xcf, 0x13, 0x15, 0x7c, 0xc2, 0xc5, 0x1a, 0x8e, 0x4a, 0xa6, 0x84, 0xaf, 0x97, 0x78, 0xf9, 0x18, 0x49, 0xf3, 0x43, 0x35, 0xd1, 0x41, 0xc0, 0x01, 0x54, 0xc4, 0x19, 0x76, 0x21, 0xf9, 0x62, 0x4a, 0x67, 0x5b, 0x5a, 0xbc, 0x22, 0xee, 0x7d, 0x5b, 0xaa, 0xff, 0xaa, 0xe1, 0xc9, 0xba, 0xca, 0x2c, 0xc3, 0x73, 0xb3, 0xf3, 0x3e, 0x78, 0xe6, 0x14, 0x3c, 0x39, 0x5a, 0x91, 0xaa, 0x7f, 0xac, 0xa6, 0x64, 0xeb, 0x73, 0x3a, 0xfd, 0x14, 0xd8, 0x82, 0x72, 0x59, 0xd9, 0x9a, 0x75, 0x50, 0xfa, 0xca, 0x50, 0x1e, 0xf2, 0xb0, 0x4e, 0x33, 0xc2, 0x3a, 0xa5, 0x1f, 0x4b, 0x9e, 0x82, 0x82, 0xef, 0xdb, 0x72, 0x8c, 0xc0, 0xab, 0x09, 0x40, 0x5a, 0x91, 0x60, 0x7c, 0x63, 0x69, 0x96, 0x1b, 0xc8, 0x27, 0x0d, 0x2d, 0x4f, 0x39, 0xfc, 0xe6, 0x12, 0xb1, 
};
static const u8 rsa_pss_125_CRT_salt[] = {
0x71, 0x0b, 0x9c, 0x47, 0x47, 0xd8, 0x00, 0xd4, 0xde, 0x87, 0xf1, 0x2a, 0xfd, 0xce, 0x6d, 0xf1, 0x81, 0x07, 0xcc, 0x77, 
};
static const u8 rsa_pss_125_CRT_p[] = {
0xe7, 0xe8, 0x94, 0x27, 0x20, 0xa8, 0x77, 0x51, 0x72, 0x73, 0xa3, 0x56, 0x05, 0x3e, 0xa2, 0xa1, 0xbc, 0x0c, 0x94, 0xaa, 0x72, 0xd5, 0x5c, 0x6e, 0x86, 0x29, 0x6b, 0x2d, 0xfc, 0x96, 0x79, 0x48, 0xc0, 0xa7, 0x2c, 0xbc, 0xcc, 0xa7, 0xea, 0xcb, 0x35, 0x70, 0x6e, 0x09, 0xa1, 0xdf, 0x55, 0xa1, 0x53, 0x5b, 0xd9, 0xb3, 0xcc, 0x34, 0x16, 0x0b, 0x3b, 0x6d, 0xcd, 0x3e, 0xda, 0x8e, 0x64, 0x43, 
};
static const u8 rsa_pss_125_CRT_q[] = {
0xb6, 0x9d, 0xca, 0x1c, 0xf7, 0xd4, 0xd7, 0xec, 0x81, 0xe7, 0x5b, 0x90, 0xfc, 0xca, 0x87, 0x4a, 0xbc, 0xde, 0x12, 0x3f, 0xd2, 0x70, 0x01, 0x80, 0xaa, 0x90, 0x47, 0x9b, 0x6e, 0x48, 0xde, 0x8d, 0x67, 0xed, 0x24, 0xf9, 0xf1, 0x9d, 0x85, 0xba, 0x27, 0x58, 0x74, 0xf5, 0x42, 0xcd, 0x20, 0xdc, 0x72, 0x3e, 0x69, 0x63, 0x36, 0x4a, 0x1f, 0x94, 0x25, 0x45, 0x2b, 0x26, 0x9a, 0x67, 0x99, 0xfd, 
};
static const u8 rsa_pss_125_CRT_dP[] = {
0x28, 0xfa, 0x13, 0x93, 0x86, 0x55, 0xbe, 0x1f, 0x8a, 0x15, 0x9c, 0xba, 0xca, 0x5a, 0x72, 0xea, 0x19, 0x0c, 0x30, 0x08, 0x9e, 0x19, 0xcd, 0x27, 0x4a, 0x55, 0x6f, 0x36, 0xc4, 0xf6, 0xe1, 0x9f, 0x55, 0x4b, 0x34, 0xc0, 0x77, 0x79, 0x04, 0x27, 0xbb, 0xdd, 0x8d, 0xd3, 0xed, 0xe2, 0x44, 0x83, 0x28, 0xf3, 0x85, 0xd8, 0x1b, 0x30, 0xe8, 0xe4, 0x3b, 0x2f, 0xff, 0xa0, 0x27, 0x86, 0x19, 0x79, 
};
static const u8 rsa_pss_125_CRT_dQ[] = {
0x1a, 0x8b, 0x38, 0xf3, 0x98, 0xfa, 0x71, 0x20, 0x49, 0x89, 0x8d, 0x7f, 0xb7, 0x9e, 0xe0, 0xa7, 0x76, 0x68, 0x79, 0x12, 0x99, 0xcd, 0xfa, 0x09, 0xef, 0xc0, 0xe5, 0x07, 0xac, 0xb2, 0x1e, 0xd7, 0x43, 0x01, 0xef, 0x5b, 0xfd, 0x48, 0xbe, 0x45, 0x5e, 0xae, 0xb6, 0xe1, 0x67, 0x82, 0x55, 0x82, 0x75, 0x80, 0xa8, 0xe4, 0xe8, 0xe1, 0x41, 0x51, 0xd1, 0x51, 0x0a, 0x82, 0xa3, 0xf2, 0xe7, 0x29, 
};
static const u8 rsa_pss_125_CRT_qInv[] = {
0x27, 0x15, 0x6a, 0xba, 0x41, 0x26, 0xd2, 0x4a, 0x81, 0xf3, 0xa5, 0x28, 0xcb, 0xfb, 0x27, 0xf5, 0x68, 0x86, 0xf8, 0x40, 0xa9, 0xf6, 0xe8, 0x6e, 0x17, 0xa4, 0x4b, 0x94, 0xfe, 0x93, 0x19, 0x58, 0x4b, 0x8e, 0x22, 0xfd, 0xde, 0x1e, 0x5a, 0x2e, 0x3b, 0xd8, 0xaa, 0x5b, 0xa8, 0xd8, 0x58, 0x41, 0x94, 0xeb, 0x21, 0x90, 0xac, 0xf8, 0x32, 0xb8, 0x47, 0xf1, 0x3a, 0x3d, 0x24, 0xa7, 0x9f, 0x4d, 
};


static const rsa_test test_rsa_pss_125_CRT = {
	.name = "rsa_pss_125_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_125_CRT_n,
	.nlen = sizeof(rsa_pss_125_CRT_n),
	.d = (const u8*)&rsa_pss_125_CRT_d,
	.dlen = sizeof(rsa_pss_125_CRT_d),
	.e = (const u8*)&rsa_pss_125_CRT_e,
	.elen = sizeof(rsa_pss_125_CRT_e),
	.p = (const u8*)&rsa_pss_125_CRT_p,
	.plen = sizeof(rsa_pss_125_CRT_p),
	.q = (const u8*)&rsa_pss_125_CRT_q,
	.qlen = sizeof(rsa_pss_125_CRT_q),
	.dP = (const u8*)&rsa_pss_125_CRT_dP,
	.dPlen = sizeof(rsa_pss_125_CRT_dP),
	.dQ = (const u8*)&rsa_pss_125_CRT_dQ,
	.dQlen = sizeof(rsa_pss_125_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_125_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_125_CRT_qInv),
	.m = (const u8*)&rsa_pss_125_CRT_m,
	.mlen = sizeof(rsa_pss_125_CRT_m),
	.res = (const u8*)&rsa_pss_125_CRT_res,
	.reslen = sizeof(rsa_pss_125_CRT_res),
	.salt = (const u8*)&rsa_pss_125_CRT_salt,
	.saltlen = sizeof(rsa_pss_125_CRT_salt),
};
static const u8 rsa_pss_126_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_126_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_126_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_126_m[] = {
0xbc, 0x65, 0x67, 0x47, 0xfa, 0x9e, 0xaf, 0xb3, 0xf0, 
};
static const u8 rsa_pss_126_res[] = {
0x46, 0x09, 0x79, 0x3b, 0x23, 0xe9, 0xd0, 0x93, 0x62, 0xdc, 0x21, 0xbb, 0x47, 0xda, 0x0b, 0x4f, 0x3a, 0x76, 0x22, 0x64, 0x9a, 0x47, 0xd4, 0x64, 0x01, 0x9b, 0x9a, 0xea, 0xfe, 0x53, 0x35, 0x9c, 0x17, 0x8c, 0x91, 0xcd, 0x58, 0xba, 0x6b, 0xcb, 0x78, 0xbe, 0x03, 0x46, 0xa7, 0xbc, 0x63, 0x7f, 0x4b, 0x87, 0x3d, 0x4b, 0xab, 0x38, 0xee, 0x66, 0x1f, 0x19, 0x96, 0x34, 0xc5, 0x47, 0xa1, 0xad, 0x84, 0x42, 0xe0, 0x3d, 0xa0, 0x15, 0xb1, 0x36, 0xe5, 0x43, 0xf7, 0xab, 0x07, 0xc0, 0xc1, 0x3e, 0x42, 0x25, 0xb8, 0xde, 0x8c, 0xce, 0x25, 0xd4, 0xf6, 0xeb, 0x84, 0x00, 0xf8, 0x1f, 0x7e, 0x18, 0x33, 0xb7, 0xee, 0x6e, 0x33, 0x4d, 0x37, 0x09, 0x64, 0xca, 0x79, 0xfd, 0xb8, 0x72, 0xb4, 0xd7, 0x52, 0x23, 0xb5, 0xee, 0xb0, 0x81, 0x01, 0x59, 0x1f, 0xb5, 0x32, 0xd1, 0x55, 0xa6, 0xde, 0x87, 
};
static const u8 rsa_pss_126_salt[] = {
0x05, 0x6f, 0x00, 0x98, 0x5d, 0xe1, 0x4d, 0x8e, 0xf5, 0xce, 0xa9, 0xe8, 0x2f, 0x8c, 0x27, 0xbe, 0xf7, 0x20, 0x33, 0x5e, 
};


static const rsa_test test_rsa_pss_126 = {
	.name = "rsa_pss_126",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_126_n,
	.nlen = sizeof(rsa_pss_126_n),
	.d = (const u8*)&rsa_pss_126_d,
	.dlen = sizeof(rsa_pss_126_d),
	.e = (const u8*)&rsa_pss_126_e,
	.elen = sizeof(rsa_pss_126_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_126_m,
	.mlen = sizeof(rsa_pss_126_m),
	.res = (const u8*)&rsa_pss_126_res,
	.reslen = sizeof(rsa_pss_126_res),
	.salt = (const u8*)&rsa_pss_126_salt,
	.saltlen = sizeof(rsa_pss_126_salt),
};
static const u8 rsa_pss_127_CRT_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_127_CRT_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_127_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_127_CRT_m[] = {
0xbc, 0x65, 0x67, 0x47, 0xfa, 0x9e, 0xaf, 0xb3, 0xf0, 
};
static const u8 rsa_pss_127_CRT_res[] = {
0x46, 0x09, 0x79, 0x3b, 0x23, 0xe9, 0xd0, 0x93, 0x62, 0xdc, 0x21, 0xbb, 0x47, 0xda, 0x0b, 0x4f, 0x3a, 0x76, 0x22, 0x64, 0x9a, 0x47, 0xd4, 0x64, 0x01, 0x9b, 0x9a, 0xea, 0xfe, 0x53, 0x35, 0x9c, 0x17, 0x8c, 0x91, 0xcd, 0x58, 0xba, 0x6b, 0xcb, 0x78, 0xbe, 0x03, 0x46, 0xa7, 0xbc, 0x63, 0x7f, 0x4b, 0x87, 0x3d, 0x4b, 0xab, 0x38, 0xee, 0x66, 0x1f, 0x19, 0x96, 0x34, 0xc5, 0x47, 0xa1, 0xad, 0x84, 0x42, 0xe0, 0x3d, 0xa0, 0x15, 0xb1, 0x36, 0xe5, 0x43, 0xf7, 0xab, 0x07, 0xc0, 0xc1, 0x3e, 0x42, 0x25, 0xb8, 0xde, 0x8c, 0xce, 0x25, 0xd4, 0xf6, 0xeb, 0x84, 0x00, 0xf8, 0x1f, 0x7e, 0x18, 0x33, 0xb7, 0xee, 0x6e, 0x33, 0x4d, 0x37, 0x09, 0x64, 0xca, 0x79, 0xfd, 0xb8, 0x72, 0xb4, 0xd7, 0x52, 0x23, 0xb5, 0xee, 0xb0, 0x81, 0x01, 0x59, 0x1f, 0xb5, 0x32, 0xd1, 0x55, 0xa6, 0xde, 0x87, 
};
static const u8 rsa_pss_127_CRT_salt[] = {
0x05, 0x6f, 0x00, 0x98, 0x5d, 0xe1, 0x4d, 0x8e, 0xf5, 0xce, 0xa9, 0xe8, 0x2f, 0x8c, 0x27, 0xbe, 0xf7, 0x20, 0x33, 0x5e, 
};
static const u8 rsa_pss_127_CRT_p[] = {
0xe7, 0xe8, 0x94, 0x27, 0x20, 0xa8, 0x77, 0x51, 0x72, 0x73, 0xa3, 0x56, 0x05, 0x3e, 0xa2, 0xa1, 0xbc, 0x0c, 0x94, 0xaa, 0x72, 0xd5, 0x5c, 0x6e, 0x86, 0x29, 0x6b, 0x2d, 0xfc, 0x96, 0x79, 0x48, 0xc0, 0xa7, 0x2c, 0xbc, 0xcc, 0xa7, 0xea, 0xcb, 0x35, 0x70, 0x6e, 0x09, 0xa1, 0xdf, 0x55, 0xa1, 0x53, 0x5b, 0xd9, 0xb3, 0xcc, 0x34, 0x16, 0x0b, 0x3b, 0x6d, 0xcd, 0x3e, 0xda, 0x8e, 0x64, 0x43, 
};
static const u8 rsa_pss_127_CRT_q[] = {
0xb6, 0x9d, 0xca, 0x1c, 0xf7, 0xd4, 0xd7, 0xec, 0x81, 0xe7, 0x5b, 0x90, 0xfc, 0xca, 0x87, 0x4a, 0xbc, 0xde, 0x12, 0x3f, 0xd2, 0x70, 0x01, 0x80, 0xaa, 0x90, 0x47, 0x9b, 0x6e, 0x48, 0xde, 0x8d, 0x67, 0xed, 0x24, 0xf9, 0xf1, 0x9d, 0x85, 0xba, 0x27, 0x58, 0x74, 0xf5, 0x42, 0xcd, 0x20, 0xdc, 0x72, 0x3e, 0x69, 0x63, 0x36, 0x4a, 0x1f, 0x94, 0x25, 0x45, 0x2b, 0x26, 0x9a, 0x67, 0x99, 0xfd, 
};
static const u8 rsa_pss_127_CRT_dP[] = {
0x28, 0xfa, 0x13, 0x93, 0x86, 0x55, 0xbe, 0x1f, 0x8a, 0x15, 0x9c, 0xba, 0xca, 0x5a, 0x72, 0xea, 0x19, 0x0c, 0x30, 0x08, 0x9e, 0x19, 0xcd, 0x27, 0x4a, 0x55, 0x6f, 0x36, 0xc4, 0xf6, 0xe1, 0x9f, 0x55, 0x4b, 0x34, 0xc0, 0x77, 0x79, 0x04, 0x27, 0xbb, 0xdd, 0x8d, 0xd3, 0xed, 0xe2, 0x44, 0x83, 0x28, 0xf3, 0x85, 0xd8, 0x1b, 0x30, 0xe8, 0xe4, 0x3b, 0x2f, 0xff, 0xa0, 0x27, 0x86, 0x19, 0x79, 
};
static const u8 rsa_pss_127_CRT_dQ[] = {
0x1a, 0x8b, 0x38, 0xf3, 0x98, 0xfa, 0x71, 0x20, 0x49, 0x89, 0x8d, 0x7f, 0xb7, 0x9e, 0xe0, 0xa7, 0x76, 0x68, 0x79, 0x12, 0x99, 0xcd, 0xfa, 0x09, 0xef, 0xc0, 0xe5, 0x07, 0xac, 0xb2, 0x1e, 0xd7, 0x43, 0x01, 0xef, 0x5b, 0xfd, 0x48, 0xbe, 0x45, 0x5e, 0xae, 0xb6, 0xe1, 0x67, 0x82, 0x55, 0x82, 0x75, 0x80, 0xa8, 0xe4, 0xe8, 0xe1, 0x41, 0x51, 0xd1, 0x51, 0x0a, 0x82, 0xa3, 0xf2, 0xe7, 0x29, 
};
static const u8 rsa_pss_127_CRT_qInv[] = {
0x27, 0x15, 0x6a, 0xba, 0x41, 0x26, 0xd2, 0x4a, 0x81, 0xf3, 0xa5, 0x28, 0xcb, 0xfb, 0x27, 0xf5, 0x68, 0x86, 0xf8, 0x40, 0xa9, 0xf6, 0xe8, 0x6e, 0x17, 0xa4, 0x4b, 0x94, 0xfe, 0x93, 0x19, 0x58, 0x4b, 0x8e, 0x22, 0xfd, 0xde, 0x1e, 0x5a, 0x2e, 0x3b, 0xd8, 0xaa, 0x5b, 0xa8, 0xd8, 0x58, 0x41, 0x94, 0xeb, 0x21, 0x90, 0xac, 0xf8, 0x32, 0xb8, 0x47, 0xf1, 0x3a, 0x3d, 0x24, 0xa7, 0x9f, 0x4d, 
};


static const rsa_test test_rsa_pss_127_CRT = {
	.name = "rsa_pss_127_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_127_CRT_n,
	.nlen = sizeof(rsa_pss_127_CRT_n),
	.d = (const u8*)&rsa_pss_127_CRT_d,
	.dlen = sizeof(rsa_pss_127_CRT_d),
	.e = (const u8*)&rsa_pss_127_CRT_e,
	.elen = sizeof(rsa_pss_127_CRT_e),
	.p = (const u8*)&rsa_pss_127_CRT_p,
	.plen = sizeof(rsa_pss_127_CRT_p),
	.q = (const u8*)&rsa_pss_127_CRT_q,
	.qlen = sizeof(rsa_pss_127_CRT_q),
	.dP = (const u8*)&rsa_pss_127_CRT_dP,
	.dPlen = sizeof(rsa_pss_127_CRT_dP),
	.dQ = (const u8*)&rsa_pss_127_CRT_dQ,
	.dQlen = sizeof(rsa_pss_127_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_127_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_127_CRT_qInv),
	.m = (const u8*)&rsa_pss_127_CRT_m,
	.mlen = sizeof(rsa_pss_127_CRT_m),
	.res = (const u8*)&rsa_pss_127_CRT_res,
	.reslen = sizeof(rsa_pss_127_CRT_res),
	.salt = (const u8*)&rsa_pss_127_CRT_salt,
	.saltlen = sizeof(rsa_pss_127_CRT_salt),
};
static const u8 rsa_pss_128_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_128_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_128_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_128_m[] = {
0xb4, 0x55, 0x81, 0x54, 0x7e, 0x54, 0x27, 0x77, 0x0c, 0x76, 0x8e, 0x8b, 0x82, 0xb7, 0x55, 0x64, 0xe0, 0xea, 0x4e, 0x9c, 0x32, 0x59, 0x4d, 0x6b, 0xff, 0x70, 0x65, 0x44, 0xde, 0x0a, 0x87, 0x76, 0xc7, 0xa8, 0x0b, 0x45, 0x76, 0x55, 0x0e, 0xee, 0x1b, 0x2a, 0xca, 0xbc, 0x7e, 0x8b, 0x7d, 0x3e, 0xf7, 0xbb, 0x5b, 0x03, 0xe4, 0x62, 0xc1, 0x10, 0x47, 0xea, 0xdd, 0x00, 0x62, 0x9a, 0xe5, 0x75, 0x48, 0x0a, 0xc1, 0x47, 0x0f, 0xe0, 0x46, 0xf1, 0x3a, 0x2b, 0xf5, 0xaf, 0x17, 0x92, 0x1d, 0xc4, 0xb0, 0xaa, 0x8b, 0x02, 0xbe, 0xe6, 0x33, 0x49, 0x11, 0x65, 0x1d, 0x7f, 0x85, 0x25, 0xd1, 0x0f, 0x32, 0xb5, 0x1d, 0x33, 0xbe, 0x52, 0x0d, 0x3d, 0xdf, 0x5a, 0x70, 0x99, 0x55, 0xa3, 0xdf, 0xe7, 0x82, 0x83, 0xb9, 0xe0, 0xab, 0x54, 0x04, 0x6d, 0x15, 0x0c, 0x17, 0x7f, 0x03, 0x7f, 0xdc, 0xcc, 0x5b, 0xe4, 0xea, 0x5f, 0x68, 0xb5, 0xe5, 0xa3, 0x8c, 0x9d, 0x7e, 0xdc, 0xcc, 0xc4, 0x97, 0x5f, 0x45, 0x5a, 0x69, 0x09, 0xb4, 
};
static const u8 rsa_pss_128_res[] = {
0x1d, 0x2a, 0xad, 0x22, 0x1c, 0xa4, 0xd3, 0x1d, 0xdf, 0x13, 0x50, 0x92, 0x39, 0x01, 0x93, 0x98, 0xe3, 0xd1, 0x4b, 0x32, 0xdc, 0x34, 0xdc, 0x5a, 0xf4, 0xae, 0xae, 0xa3, 0xc0, 0x95, 0xaf, 0x73, 0x47, 0x9c, 0xf0, 0xa4, 0x5e, 0x56, 0x29, 0x63, 0x5a, 0x53, 0xa0, 0x18, 0x37, 0x76, 0x15, 0xb1, 0x6c, 0xb9, 0xb1, 0x3b, 0x3e, 0x09, 0xd6, 0x71, 0xeb, 0x71, 0xe3, 0x87, 0xb8, 0x54, 0x5c, 0x59, 0x60, 0xda, 0x5a, 0x64, 0x77, 0x6e, 0x76, 0x8e, 0x82, 0xb2, 0xc9, 0x35, 0x83, 0xbf, 0x10, 0x4c, 0x3f, 0xdb, 0x23, 0x51, 0x2b, 0x7b, 0x4e, 0x89, 0xf6, 0x33, 0xdd, 0x00, 0x63, 0xa5, 0x30, 0xdb, 0x45, 0x24, 0xb0, 0x1c, 0x3f, 0x38, 0x4c, 0x09, 0x31, 0x0e, 0x31, 0x5a, 0x79, 0xdc, 0xd3, 0xd6, 0x84, 0x02, 0x2a, 0x7f, 0x31, 0xc8, 0x65, 0xa6, 0x64, 0xe3, 0x16, 0x97, 0x8b, 0x75, 0x9f, 0xad, 
};
static const u8 rsa_pss_128_salt[] = {
0x80, 0xe7, 0x0f, 0xf8, 0x6a, 0x08, 0xde, 0x3e, 0xc6, 0x09, 0x72, 0xb3, 0x9b, 0x4f, 0xbf, 0xdc, 0xea, 0x67, 0xae, 0x8e, 
};


static const rsa_test test_rsa_pss_128 = {
	.name = "rsa_pss_128",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_128_n,
	.nlen = sizeof(rsa_pss_128_n),
	.d = (const u8*)&rsa_pss_128_d,
	.dlen = sizeof(rsa_pss_128_d),
	.e = (const u8*)&rsa_pss_128_e,
	.elen = sizeof(rsa_pss_128_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_128_m,
	.mlen = sizeof(rsa_pss_128_m),
	.res = (const u8*)&rsa_pss_128_res,
	.reslen = sizeof(rsa_pss_128_res),
	.salt = (const u8*)&rsa_pss_128_salt,
	.saltlen = sizeof(rsa_pss_128_salt),
};
static const u8 rsa_pss_129_CRT_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_129_CRT_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_129_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_129_CRT_m[] = {
0xb4, 0x55, 0x81, 0x54, 0x7e, 0x54, 0x27, 0x77, 0x0c, 0x76, 0x8e, 0x8b, 0x82, 0xb7, 0x55, 0x64, 0xe0, 0xea, 0x4e, 0x9c, 0x32, 0x59, 0x4d, 0x6b, 0xff, 0x70, 0x65, 0x44, 0xde, 0x0a, 0x87, 0x76, 0xc7, 0xa8, 0x0b, 0x45, 0x76, 0x55, 0x0e, 0xee, 0x1b, 0x2a, 0xca, 0xbc, 0x7e, 0x8b, 0x7d, 0x3e, 0xf7, 0xbb, 0x5b, 0x03, 0xe4, 0x62, 0xc1, 0x10, 0x47, 0xea, 0xdd, 0x00, 0x62, 0x9a, 0xe5, 0x75, 0x48, 0x0a, 0xc1, 0x47, 0x0f, 0xe0, 0x46, 0xf1, 0x3a, 0x2b, 0xf5, 0xaf, 0x17, 0x92, 0x1d, 0xc4, 0xb0, 0xaa, 0x8b, 0x02, 0xbe, 0xe6, 0x33, 0x49, 0x11, 0x65, 0x1d, 0x7f, 0x85, 0x25, 0xd1, 0x0f, 0x32, 0xb5, 0x1d, 0x33, 0xbe, 0x52, 0x0d, 0x3d, 0xdf, 0x5a, 0x70, 0x99, 0x55, 0xa3, 0xdf, 0xe7, 0x82, 0x83, 0xb9, 0xe0, 0xab, 0x54, 0x04, 0x6d, 0x15, 0x0c, 0x17, 0x7f, 0x03, 0x7f, 0xdc, 0xcc, 0x5b, 0xe4, 0xea, 0x5f, 0x68, 0xb5, 0xe5, 0xa3, 0x8c, 0x9d, 0x7e, 0xdc, 0xcc, 0xc4, 0x97, 0x5f, 0x45, 0x5a, 0x69, 0x09, 0xb4, 
};
static const u8 rsa_pss_129_CRT_res[] = {
0x1d, 0x2a, 0xad, 0x22, 0x1c, 0xa4, 0xd3, 0x1d, 0xdf, 0x13, 0x50, 0x92, 0x39, 0x01, 0x93, 0x98, 0xe3, 0xd1, 0x4b, 0x32, 0xdc, 0x34, 0xdc, 0x5a, 0xf4, 0xae, 0xae, 0xa3, 0xc0, 0x95, 0xaf, 0x73, 0x47, 0x9c, 0xf0, 0xa4, 0x5e, 0x56, 0x29, 0x63, 0x5a, 0x53, 0xa0, 0x18, 0x37, 0x76, 0x15, 0xb1, 0x6c, 0xb9, 0xb1, 0x3b, 0x3e, 0x09, 0xd6, 0x71, 0xeb, 0x71, 0xe3, 0x87, 0xb8, 0x54, 0x5c, 0x59, 0x60, 0xda, 0x5a, 0x64, 0x77, 0x6e, 0x76, 0x8e, 0x82, 0xb2, 0xc9, 0x35, 0x83, 0xbf, 0x10, 0x4c, 0x3f, 0xdb, 0x23, 0x51, 0x2b, 0x7b, 0x4e, 0x89, 0xf6, 0x33, 0xdd, 0x00, 0x63, 0xa5, 0x30, 0xdb, 0x45, 0x24, 0xb0, 0x1c, 0x3f, 0x38, 0x4c, 0x09, 0x31, 0x0e, 0x31, 0x5a, 0x79, 0xdc, 0xd3, 0xd6, 0x84, 0x02, 0x2a, 0x7f, 0x31, 0xc8, 0x65, 0xa6, 0x64, 0xe3, 0x16, 0x97, 0x8b, 0x75, 0x9f, 0xad, 
};
static const u8 rsa_pss_129_CRT_salt[] = {
0x80, 0xe7, 0x0f, 0xf8, 0x6a, 0x08, 0xde, 0x3e, 0xc6, 0x09, 0x72, 0xb3, 0x9b, 0x4f, 0xbf, 0xdc, 0xea, 0x67, 0xae, 0x8e, 
};
static const u8 rsa_pss_129_CRT_p[] = {
0xe7, 0xe8, 0x94, 0x27, 0x20, 0xa8, 0x77, 0x51, 0x72, 0x73, 0xa3, 0x56, 0x05, 0x3e, 0xa2, 0xa1, 0xbc, 0x0c, 0x94, 0xaa, 0x72, 0xd5, 0x5c, 0x6e, 0x86, 0x29, 0x6b, 0x2d, 0xfc, 0x96, 0x79, 0x48, 0xc0, 0xa7, 0x2c, 0xbc, 0xcc, 0xa7, 0xea, 0xcb, 0x35, 0x70, 0x6e, 0x09, 0xa1, 0xdf, 0x55, 0xa1, 0x53, 0x5b, 0xd9, 0xb3, 0xcc, 0x34, 0x16, 0x0b, 0x3b, 0x6d, 0xcd, 0x3e, 0xda, 0x8e, 0x64, 0x43, 
};
static const u8 rsa_pss_129_CRT_q[] = {
0xb6, 0x9d, 0xca, 0x1c, 0xf7, 0xd4, 0xd7, 0xec, 0x81, 0xe7, 0x5b, 0x90, 0xfc, 0xca, 0x87, 0x4a, 0xbc, 0xde, 0x12, 0x3f, 0xd2, 0x70, 0x01, 0x80, 0xaa, 0x90, 0x47, 0x9b, 0x6e, 0x48, 0xde, 0x8d, 0x67, 0xed, 0x24, 0xf9, 0xf1, 0x9d, 0x85, 0xba, 0x27, 0x58, 0x74, 0xf5, 0x42, 0xcd, 0x20, 0xdc, 0x72, 0x3e, 0x69, 0x63, 0x36, 0x4a, 0x1f, 0x94, 0x25, 0x45, 0x2b, 0x26, 0x9a, 0x67, 0x99, 0xfd, 
};
static const u8 rsa_pss_129_CRT_dP[] = {
0x28, 0xfa, 0x13, 0x93, 0x86, 0x55, 0xbe, 0x1f, 0x8a, 0x15, 0x9c, 0xba, 0xca, 0x5a, 0x72, 0xea, 0x19, 0x0c, 0x30, 0x08, 0x9e, 0x19, 0xcd, 0x27, 0x4a, 0x55, 0x6f, 0x36, 0xc4, 0xf6, 0xe1, 0x9f, 0x55, 0x4b, 0x34, 0xc0, 0x77, 0x79, 0x04, 0x27, 0xbb, 0xdd, 0x8d, 0xd3, 0xed, 0xe2, 0x44, 0x83, 0x28, 0xf3, 0x85, 0xd8, 0x1b, 0x30, 0xe8, 0xe4, 0x3b, 0x2f, 0xff, 0xa0, 0x27, 0x86, 0x19, 0x79, 
};
static const u8 rsa_pss_129_CRT_dQ[] = {
0x1a, 0x8b, 0x38, 0xf3, 0x98, 0xfa, 0x71, 0x20, 0x49, 0x89, 0x8d, 0x7f, 0xb7, 0x9e, 0xe0, 0xa7, 0x76, 0x68, 0x79, 0x12, 0x99, 0xcd, 0xfa, 0x09, 0xef, 0xc0, 0xe5, 0x07, 0xac, 0xb2, 0x1e, 0xd7, 0x43, 0x01, 0xef, 0x5b, 0xfd, 0x48, 0xbe, 0x45, 0x5e, 0xae, 0xb6, 0xe1, 0x67, 0x82, 0x55, 0x82, 0x75, 0x80, 0xa8, 0xe4, 0xe8, 0xe1, 0x41, 0x51, 0xd1, 0x51, 0x0a, 0x82, 0xa3, 0xf2, 0xe7, 0x29, 
};
static const u8 rsa_pss_129_CRT_qInv[] = {
0x27, 0x15, 0x6a, 0xba, 0x41, 0x26, 0xd2, 0x4a, 0x81, 0xf3, 0xa5, 0x28, 0xcb, 0xfb, 0x27, 0xf5, 0x68, 0x86, 0xf8, 0x40, 0xa9, 0xf6, 0xe8, 0x6e, 0x17, 0xa4, 0x4b, 0x94, 0xfe, 0x93, 0x19, 0x58, 0x4b, 0x8e, 0x22, 0xfd, 0xde, 0x1e, 0x5a, 0x2e, 0x3b, 0xd8, 0xaa, 0x5b, 0xa8, 0xd8, 0x58, 0x41, 0x94, 0xeb, 0x21, 0x90, 0xac, 0xf8, 0x32, 0xb8, 0x47, 0xf1, 0x3a, 0x3d, 0x24, 0xa7, 0x9f, 0x4d, 
};


static const rsa_test test_rsa_pss_129_CRT = {
	.name = "rsa_pss_129_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_129_CRT_n,
	.nlen = sizeof(rsa_pss_129_CRT_n),
	.d = (const u8*)&rsa_pss_129_CRT_d,
	.dlen = sizeof(rsa_pss_129_CRT_d),
	.e = (const u8*)&rsa_pss_129_CRT_e,
	.elen = sizeof(rsa_pss_129_CRT_e),
	.p = (const u8*)&rsa_pss_129_CRT_p,
	.plen = sizeof(rsa_pss_129_CRT_p),
	.q = (const u8*)&rsa_pss_129_CRT_q,
	.qlen = sizeof(rsa_pss_129_CRT_q),
	.dP = (const u8*)&rsa_pss_129_CRT_dP,
	.dPlen = sizeof(rsa_pss_129_CRT_dP),
	.dQ = (const u8*)&rsa_pss_129_CRT_dQ,
	.dQlen = sizeof(rsa_pss_129_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_129_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_129_CRT_qInv),
	.m = (const u8*)&rsa_pss_129_CRT_m,
	.mlen = sizeof(rsa_pss_129_CRT_m),
	.res = (const u8*)&rsa_pss_129_CRT_res,
	.reslen = sizeof(rsa_pss_129_CRT_res),
	.salt = (const u8*)&rsa_pss_129_CRT_salt,
	.saltlen = sizeof(rsa_pss_129_CRT_salt),
};
static const u8 rsa_pss_130_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_130_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_130_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_130_m[] = {
0x10, 0xaa, 0xe9, 0xa0, 0xab, 0x0b, 0x59, 0x5d, 0x08, 0x41, 0x20, 0x7b, 0x70, 0x0d, 0x48, 0xd7, 0x5f, 0xae, 0xdd, 0xe3, 0xb7, 0x75, 0xcd, 0x6b, 0x4c, 0xc8, 0x8a, 0xe0, 0x6e, 0x46, 0x94, 0xec, 0x74, 0xba, 0x18, 0xf8, 0x52, 0x0d, 0x4f, 0x5e, 0xa6, 0x9c, 0xbb, 0xe7, 0xcc, 0x2b, 0xeb, 0xa4, 0x3e, 0xfd, 0xc1, 0x02, 0x15, 0xac, 0x4e, 0xb3, 0x2d, 0xc3, 0x02, 0xa1, 0xf5, 0x3d, 0xc6, 0xc4, 0x35, 0x22, 0x67, 0xe7, 0x93, 0x6c, 0xfe, 0xbf, 0x7c, 0x8d, 0x67, 0x03, 0x57, 0x84, 0xa3, 0x90, 0x9f, 0xa8, 0x59, 0xc7, 0xb7, 0xb5, 0x9b, 0x8e, 0x39, 0xc5, 0xc2, 0x34, 0x9f, 0x18, 0x86, 0xb7, 0x05, 0xa3, 0x02, 0x67, 0xd4, 0x02, 0xf7, 0x48, 0x6a, 0xb4, 0xf5, 0x8c, 0xad, 0x5d, 0x69, 0xad, 0xb1, 0x7a, 0xb8, 0xcd, 0x0c, 0xe1, 0xca, 0xf5, 0x02, 0x5a, 0xf4, 0xae, 0x24, 0xb1, 0xfb, 0x87, 0x94, 0xc6, 0x07, 0x0c, 0xc0, 0x9a, 0x51, 0xe2, 0xf9, 0x91, 0x13, 0x11, 0xe3, 0x87, 0x7d, 0x00, 0x44, 0xc7, 0x1c, 0x57, 0xa9, 0x93, 0x39, 0x50, 0x08, 0x80, 0x6b, 0x72, 0x3a, 0xc3, 0x83, 0x73, 0xd3, 0x95, 0x48, 0x18, 0x18, 0x52, 0x8c, 0x1e, 0x70, 0x53, 0x73, 0x92, 0x82, 0x05, 0x35, 0x29, 0x51, 0x0e, 0x93, 0x5c, 0xd0, 0xfa, 0x77, 0xb8, 0xfa, 0x53, 0xcc, 0x2d, 0x47, 0x4b, 0xd4, 0xfb, 0x3c, 0xc5, 0xc6, 0x72, 0xd6, 0xff, 0xdc, 0x90, 0xa0, 0x0f, 0x98, 0x48, 0x71, 0x2c, 0x4b, 0xcf, 0xe4, 0x6c, 0x60, 0x57, 0x36, 0x59, 0xb1, 0x1e, 0x64, 0x57, 0xe8, 0x61, 0xf0, 0xf6, 0x04, 0xb6, 0x13, 0x8d, 0x14, 0x4f, 0x8c, 0xe4, 0xe2, 0xda, 0x73, 
};
static const u8 rsa_pss_130_res[] = {
0x2a, 0x34, 0xf6, 0x12, 0x5e, 0x1f, 0x6b, 0x0b, 0xf9, 0x71, 0xe8, 0x4f, 0xbd, 0x41, 0xc6, 0x32, 0xbe, 0x8f, 0x2c, 0x2a, 0xce, 0x7d, 0xe8, 0xb6, 0x92, 0x6e, 0x31, 0xff, 0x93, 0xe9, 0xaf, 0x98, 0x7f, 0xbc, 0x06, 0xe5, 0x1e, 0x9b, 0xe1, 0x4f, 0x51, 0x98, 0xf9, 0x1f, 0x3f, 0x95, 0x3b, 0xd6, 0x7d, 0xa6, 0x0a, 0x9d, 0xf5, 0x97, 0x64, 0xc3, 0xdc, 0x0f, 0xe0, 0x8e, 0x1c, 0xbe, 0xf0, 0xb7, 0x5f, 0x86, 0x8d, 0x10, 0xad, 0x3f, 0xba, 0x74, 0x9f, 0xef, 0x59, 0xfb, 0x6d, 0xac, 0x46, 0xa0, 0xd6, 0xe5, 0x04, 0x36, 0x93, 0x31, 0x58, 0x6f, 0x58, 0xe4, 0x62, 0x8f, 0x39, 0xaa, 0x27, 0x89, 0x82, 0x54, 0x3b, 0xc0, 0xee, 0xb5, 0x37, 0xdc, 0x61, 0x95, 0x80, 0x19, 0xb3, 0x94, 0xfb, 0x27, 0x3f, 0x21, 0x58, 0x58, 0xa0, 0xa0, 0x1a, 0xc4, 0xd6, 0x50, 0xb9, 0x55, 0xc6, 0x7f, 0x4c, 0x58, 
};
static const u8 rsa_pss_130_salt[] = {
0xa8, 0xab, 0x69, 0xdd, 0x80, 0x1f, 0x00, 0x74, 0xc2, 0xa1, 0xfc, 0x60, 0x64, 0x98, 0x36, 0xc6, 0x16, 0xd9, 0x96, 0x81, 
};


static const rsa_test test_rsa_pss_130 = {
	.name = "rsa_pss_130",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_130_n,
	.nlen = sizeof(rsa_pss_130_n),
	.d = (const u8*)&rsa_pss_130_d,
	.dlen = sizeof(rsa_pss_130_d),
	.e = (const u8*)&rsa_pss_130_e,
	.elen = sizeof(rsa_pss_130_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_130_m,
	.mlen = sizeof(rsa_pss_130_m),
	.res = (const u8*)&rsa_pss_130_res,
	.reslen = sizeof(rsa_pss_130_res),
	.salt = (const u8*)&rsa_pss_130_salt,
	.saltlen = sizeof(rsa_pss_130_salt),
};
static const u8 rsa_pss_131_CRT_n[] = {
0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37, 
};
static const u8 rsa_pss_131_CRT_d[] = {
0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25, 
};
static const u8 rsa_pss_131_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_131_CRT_m[] = {
0x10, 0xaa, 0xe9, 0xa0, 0xab, 0x0b, 0x59, 0x5d, 0x08, 0x41, 0x20, 0x7b, 0x70, 0x0d, 0x48, 0xd7, 0x5f, 0xae, 0xdd, 0xe3, 0xb7, 0x75, 0xcd, 0x6b, 0x4c, 0xc8, 0x8a, 0xe0, 0x6e, 0x46, 0x94, 0xec, 0x74, 0xba, 0x18, 0xf8, 0x52, 0x0d, 0x4f, 0x5e, 0xa6, 0x9c, 0xbb, 0xe7, 0xcc, 0x2b, 0xeb, 0xa4, 0x3e, 0xfd, 0xc1, 0x02, 0x15, 0xac, 0x4e, 0xb3, 0x2d, 0xc3, 0x02, 0xa1, 0xf5, 0x3d, 0xc6, 0xc4, 0x35, 0x22, 0x67, 0xe7, 0x93, 0x6c, 0xfe, 0xbf, 0x7c, 0x8d, 0x67, 0x03, 0x57, 0x84, 0xa3, 0x90, 0x9f, 0xa8, 0x59, 0xc7, 0xb7, 0xb5, 0x9b, 0x8e, 0x39, 0xc5, 0xc2, 0x34, 0x9f, 0x18, 0x86, 0xb7, 0x05, 0xa3, 0x02, 0x67, 0xd4, 0x02, 0xf7, 0x48, 0x6a, 0xb4, 0xf5, 0x8c, 0xad, 0x5d, 0x69, 0xad, 0xb1, 0x7a, 0xb8, 0xcd, 0x0c, 0xe1, 0xca, 0xf5, 0x02, 0x5a, 0xf4, 0xae, 0x24, 0xb1, 0xfb, 0x87, 0x94, 0xc6, 0x07, 0x0c, 0xc0, 0x9a, 0x51, 0xe2, 0xf9, 0x91, 0x13, 0x11, 0xe3, 0x87, 0x7d, 0x00, 0x44, 0xc7, 0x1c, 0x57, 0xa9, 0x93, 0x39, 0x50, 0x08, 0x80, 0x6b, 0x72, 0x3a, 0xc3, 0x83, 0x73, 0xd3, 0x95, 0x48, 0x18, 0x18, 0x52, 0x8c, 0x1e, 0x70, 0x53, 0x73, 0x92, 0x82, 0x05, 0x35, 0x29, 0x51, 0x0e, 0x93, 0x5c, 0xd0, 0xfa, 0x77, 0xb8, 0xfa, 0x53, 0xcc, 0x2d, 0x47, 0x4b, 0xd4, 0xfb, 0x3c, 0xc5, 0xc6, 0x72, 0xd6, 0xff, 0xdc, 0x90, 0xa0, 0x0f, 0x98, 0x48, 0x71, 0x2c, 0x4b, 0xcf, 0xe4, 0x6c, 0x60, 0x57, 0x36, 0x59, 0xb1, 0x1e, 0x64, 0x57, 0xe8, 0x61, 0xf0, 0xf6, 0x04, 0xb6, 0x13, 0x8d, 0x14, 0x4f, 0x8c, 0xe4, 0xe2, 0xda, 0x73, 
};
static const u8 rsa_pss_131_CRT_res[] = {
0x2a, 0x34, 0xf6, 0x12, 0x5e, 0x1f, 0x6b, 0x0b, 0xf9, 0x71, 0xe8, 0x4f, 0xbd, 0x41, 0xc6, 0x32, 0xbe, 0x8f, 0x2c, 0x2a, 0xce, 0x7d, 0xe8, 0xb6, 0x92, 0x6e, 0x31, 0xff, 0x93, 0xe9, 0xaf, 0x98, 0x7f, 0xbc, 0x06, 0xe5, 0x1e, 0x9b, 0xe1, 0x4f, 0x51, 0x98, 0xf9, 0x1f, 0x3f, 0x95, 0x3b, 0xd6, 0x7d, 0xa6, 0x0a, 0x9d, 0xf5, 0x97, 0x64, 0xc3, 0xdc, 0x0f, 0xe0, 0x8e, 0x1c, 0xbe, 0xf0, 0xb7, 0x5f, 0x86, 0x8d, 0x10, 0xad, 0x3f, 0xba, 0x74, 0x9f, 0xef, 0x59, 0xfb, 0x6d, 0xac, 0x46, 0xa0, 0xd6, 0xe5, 0x04, 0x36, 0x93, 0x31, 0x58, 0x6f, 0x58, 0xe4, 0x62, 0x8f, 0x39, 0xaa, 0x27, 0x89, 0x82, 0x54, 0x3b, 0xc0, 0xee, 0xb5, 0x37, 0xdc, 0x61, 0x95, 0x80, 0x19, 0xb3, 0x94, 0xfb, 0x27, 0x3f, 0x21, 0x58, 0x58, 0xa0, 0xa0, 0x1a, 0xc4, 0xd6, 0x50, 0xb9, 0x55, 0xc6, 0x7f, 0x4c, 0x58, 
};
static const u8 rsa_pss_131_CRT_salt[] = {
0xa8, 0xab, 0x69, 0xdd, 0x80, 0x1f, 0x00, 0x74, 0xc2, 0xa1, 0xfc, 0x60, 0x64, 0x98, 0x36, 0xc6, 0x16, 0xd9, 0x96, 0x81, 
};
static const u8 rsa_pss_131_CRT_p[] = {
0xe7, 0xe8, 0x94, 0x27, 0x20, 0xa8, 0x77, 0x51, 0x72, 0x73, 0xa3, 0x56, 0x05, 0x3e, 0xa2, 0xa1, 0xbc, 0x0c, 0x94, 0xaa, 0x72, 0xd5, 0x5c, 0x6e, 0x86, 0x29, 0x6b, 0x2d, 0xfc, 0x96, 0x79, 0x48, 0xc0, 0xa7, 0x2c, 0xbc, 0xcc, 0xa7, 0xea, 0xcb, 0x35, 0x70, 0x6e, 0x09, 0xa1, 0xdf, 0x55, 0xa1, 0x53, 0x5b, 0xd9, 0xb3, 0xcc, 0x34, 0x16, 0x0b, 0x3b, 0x6d, 0xcd, 0x3e, 0xda, 0x8e, 0x64, 0x43, 
};
static const u8 rsa_pss_131_CRT_q[] = {
0xb6, 0x9d, 0xca, 0x1c, 0xf7, 0xd4, 0xd7, 0xec, 0x81, 0xe7, 0x5b, 0x90, 0xfc, 0xca, 0x87, 0x4a, 0xbc, 0xde, 0x12, 0x3f, 0xd2, 0x70, 0x01, 0x80, 0xaa, 0x90, 0x47, 0x9b, 0x6e, 0x48, 0xde, 0x8d, 0x67, 0xed, 0x24, 0xf9, 0xf1, 0x9d, 0x85, 0xba, 0x27, 0x58, 0x74, 0xf5, 0x42, 0xcd, 0x20, 0xdc, 0x72, 0x3e, 0x69, 0x63, 0x36, 0x4a, 0x1f, 0x94, 0x25, 0x45, 0x2b, 0x26, 0x9a, 0x67, 0x99, 0xfd, 
};
static const u8 rsa_pss_131_CRT_dP[] = {
0x28, 0xfa, 0x13, 0x93, 0x86, 0x55, 0xbe, 0x1f, 0x8a, 0x15, 0x9c, 0xba, 0xca, 0x5a, 0x72, 0xea, 0x19, 0x0c, 0x30, 0x08, 0x9e, 0x19, 0xcd, 0x27, 0x4a, 0x55, 0x6f, 0x36, 0xc4, 0xf6, 0xe1, 0x9f, 0x55, 0x4b, 0x34, 0xc0, 0x77, 0x79, 0x04, 0x27, 0xbb, 0xdd, 0x8d, 0xd3, 0xed, 0xe2, 0x44, 0x83, 0x28, 0xf3, 0x85, 0xd8, 0x1b, 0x30, 0xe8, 0xe4, 0x3b, 0x2f, 0xff, 0xa0, 0x27, 0x86, 0x19, 0x79, 
};
static const u8 rsa_pss_131_CRT_dQ[] = {
0x1a, 0x8b, 0x38, 0xf3, 0x98, 0xfa, 0x71, 0x20, 0x49, 0x89, 0x8d, 0x7f, 0xb7, 0x9e, 0xe0, 0xa7, 0x76, 0x68, 0x79, 0x12, 0x99, 0xcd, 0xfa, 0x09, 0xef, 0xc0, 0xe5, 0x07, 0xac, 0xb2, 0x1e, 0xd7, 0x43, 0x01, 0xef, 0x5b, 0xfd, 0x48, 0xbe, 0x45, 0x5e, 0xae, 0xb6, 0xe1, 0x67, 0x82, 0x55, 0x82, 0x75, 0x80, 0xa8, 0xe4, 0xe8, 0xe1, 0x41, 0x51, 0xd1, 0x51, 0x0a, 0x82, 0xa3, 0xf2, 0xe7, 0x29, 
};
static const u8 rsa_pss_131_CRT_qInv[] = {
0x27, 0x15, 0x6a, 0xba, 0x41, 0x26, 0xd2, 0x4a, 0x81, 0xf3, 0xa5, 0x28, 0xcb, 0xfb, 0x27, 0xf5, 0x68, 0x86, 0xf8, 0x40, 0xa9, 0xf6, 0xe8, 0x6e, 0x17, 0xa4, 0x4b, 0x94, 0xfe, 0x93, 0x19, 0x58, 0x4b, 0x8e, 0x22, 0xfd, 0xde, 0x1e, 0x5a, 0x2e, 0x3b, 0xd8, 0xaa, 0x5b, 0xa8, 0xd8, 0x58, 0x41, 0x94, 0xeb, 0x21, 0x90, 0xac, 0xf8, 0x32, 0xb8, 0x47, 0xf1, 0x3a, 0x3d, 0x24, 0xa7, 0x9f, 0x4d, 
};


static const rsa_test test_rsa_pss_131_CRT = {
	.name = "rsa_pss_131_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1024,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_131_CRT_n,
	.nlen = sizeof(rsa_pss_131_CRT_n),
	.d = (const u8*)&rsa_pss_131_CRT_d,
	.dlen = sizeof(rsa_pss_131_CRT_d),
	.e = (const u8*)&rsa_pss_131_CRT_e,
	.elen = sizeof(rsa_pss_131_CRT_e),
	.p = (const u8*)&rsa_pss_131_CRT_p,
	.plen = sizeof(rsa_pss_131_CRT_p),
	.q = (const u8*)&rsa_pss_131_CRT_q,
	.qlen = sizeof(rsa_pss_131_CRT_q),
	.dP = (const u8*)&rsa_pss_131_CRT_dP,
	.dPlen = sizeof(rsa_pss_131_CRT_dP),
	.dQ = (const u8*)&rsa_pss_131_CRT_dQ,
	.dQlen = sizeof(rsa_pss_131_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_131_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_131_CRT_qInv),
	.m = (const u8*)&rsa_pss_131_CRT_m,
	.mlen = sizeof(rsa_pss_131_CRT_m),
	.res = (const u8*)&rsa_pss_131_CRT_res,
	.reslen = sizeof(rsa_pss_131_CRT_res),
	.salt = (const u8*)&rsa_pss_131_CRT_salt,
	.saltlen = sizeof(rsa_pss_131_CRT_salt),
};
static const u8 rsa_pss_132_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_132_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_132_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_132_m[] = {
0xda, 0xba, 0x03, 0x20, 0x66, 0x26, 0x3f, 0xae, 0xdb, 0x65, 0x98, 0x48, 0x11, 0x52, 0x78, 0xa5, 0x2c, 0x44, 0xfa, 0xa3, 0xa7, 0x6f, 0x37, 0x51, 0x5e, 0xd3, 0x36, 0x32, 0x10, 0x72, 0xc4, 0x0a, 0x9d, 0x9b, 0x53, 0xbc, 0x05, 0x01, 0x40, 0x78, 0xad, 0xf5, 0x20, 0x87, 0x51, 0x46, 0xaa, 0xe7, 0x0f, 0xf0, 0x60, 0x22, 0x6d, 0xcb, 0x7b, 0x1f, 0x1f, 0xc2, 0x7e, 0x93, 0x60, 
};
static const u8 rsa_pss_132_res[] = {
0x01, 0x4c, 0x5b, 0xa5, 0x33, 0x83, 0x28, 0xcc, 0xc6, 0xe7, 0xa9, 0x0b, 0xf1, 0xc0, 0xab, 0x3f, 0xd6, 0x06, 0xff, 0x47, 0x96, 0xd3, 0xc1, 0x2e, 0x4b, 0x63, 0x9e, 0xd9, 0x13, 0x6a, 0x5f, 0xec, 0x6c, 0x16, 0xd8, 0x88, 0x4b, 0xdd, 0x99, 0xcf, 0xdc, 0x52, 0x14, 0x56, 0xb0, 0x74, 0x2b, 0x73, 0x68, 0x68, 0xcf, 0x90, 0xde, 0x09, 0x9a, 0xdb, 0x8d, 0x5f, 0xfd, 0x1d, 0xef, 0xf3, 0x9b, 0xa4, 0x00, 0x7a, 0xb7, 0x46, 0xce, 0xfd, 0xb2, 0x2d, 0x7d, 0xf0, 0xe2, 0x25, 0xf5, 0x46, 0x27, 0xdc, 0x65, 0x46, 0x61, 0x31, 0x72, 0x1b, 0x90, 0xaf, 0x44, 0x53, 0x63, 0xa8, 0x35, 0x8b, 0x9f, 0x60, 0x76, 0x42, 0xf7, 0x8f, 0xab, 0x0a, 0xb0, 0xf4, 0x3b, 0x71, 0x68, 0xd6, 0x4b, 0xae, 0x70, 0xd8, 0x82, 0x78, 0x48, 0xd8, 0xef, 0x1e, 0x42, 0x1c, 0x57, 0x54, 0xdd, 0xf4, 0x2c, 0x25, 0x89, 0xb5, 0xb3, 
};
static const u8 rsa_pss_132_salt[] = {
0x57, 0xbf, 0x16, 0x0b, 0xcb, 0x02, 0xbb, 0x1d, 0xc7, 0x28, 0x0c, 0xf0, 0x45, 0x85, 0x30, 0xb7, 0xd2, 0x83, 0x2f, 0xf7, 
};


static const rsa_test test_rsa_pss_132 = {
	.name = "rsa_pss_132",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_132_n,
	.nlen = sizeof(rsa_pss_132_n),
	.d = (const u8*)&rsa_pss_132_d,
	.dlen = sizeof(rsa_pss_132_d),
	.e = (const u8*)&rsa_pss_132_e,
	.elen = sizeof(rsa_pss_132_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_132_m,
	.mlen = sizeof(rsa_pss_132_m),
	.res = (const u8*)&rsa_pss_132_res,
	.reslen = sizeof(rsa_pss_132_res),
	.salt = (const u8*)&rsa_pss_132_salt,
	.saltlen = sizeof(rsa_pss_132_salt),
};
static const u8 rsa_pss_133_CRT_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_133_CRT_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_133_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_133_CRT_m[] = {
0xda, 0xba, 0x03, 0x20, 0x66, 0x26, 0x3f, 0xae, 0xdb, 0x65, 0x98, 0x48, 0x11, 0x52, 0x78, 0xa5, 0x2c, 0x44, 0xfa, 0xa3, 0xa7, 0x6f, 0x37, 0x51, 0x5e, 0xd3, 0x36, 0x32, 0x10, 0x72, 0xc4, 0x0a, 0x9d, 0x9b, 0x53, 0xbc, 0x05, 0x01, 0x40, 0x78, 0xad, 0xf5, 0x20, 0x87, 0x51, 0x46, 0xaa, 0xe7, 0x0f, 0xf0, 0x60, 0x22, 0x6d, 0xcb, 0x7b, 0x1f, 0x1f, 0xc2, 0x7e, 0x93, 0x60, 
};
static const u8 rsa_pss_133_CRT_res[] = {
0x01, 0x4c, 0x5b, 0xa5, 0x33, 0x83, 0x28, 0xcc, 0xc6, 0xe7, 0xa9, 0x0b, 0xf1, 0xc0, 0xab, 0x3f, 0xd6, 0x06, 0xff, 0x47, 0x96, 0xd3, 0xc1, 0x2e, 0x4b, 0x63, 0x9e, 0xd9, 0x13, 0x6a, 0x5f, 0xec, 0x6c, 0x16, 0xd8, 0x88, 0x4b, 0xdd, 0x99, 0xcf, 0xdc, 0x52, 0x14, 0x56, 0xb0, 0x74, 0x2b, 0x73, 0x68, 0x68, 0xcf, 0x90, 0xde, 0x09, 0x9a, 0xdb, 0x8d, 0x5f, 0xfd, 0x1d, 0xef, 0xf3, 0x9b, 0xa4, 0x00, 0x7a, 0xb7, 0x46, 0xce, 0xfd, 0xb2, 0x2d, 0x7d, 0xf0, 0xe2, 0x25, 0xf5, 0x46, 0x27, 0xdc, 0x65, 0x46, 0x61, 0x31, 0x72, 0x1b, 0x90, 0xaf, 0x44, 0x53, 0x63, 0xa8, 0x35, 0x8b, 0x9f, 0x60, 0x76, 0x42, 0xf7, 0x8f, 0xab, 0x0a, 0xb0, 0xf4, 0x3b, 0x71, 0x68, 0xd6, 0x4b, 0xae, 0x70, 0xd8, 0x82, 0x78, 0x48, 0xd8, 0xef, 0x1e, 0x42, 0x1c, 0x57, 0x54, 0xdd, 0xf4, 0x2c, 0x25, 0x89, 0xb5, 0xb3, 
};
static const u8 rsa_pss_133_CRT_salt[] = {
0x57, 0xbf, 0x16, 0x0b, 0xcb, 0x02, 0xbb, 0x1d, 0xc7, 0x28, 0x0c, 0xf0, 0x45, 0x85, 0x30, 0xb7, 0xd2, 0x83, 0x2f, 0xf7, 
};
static const u8 rsa_pss_133_CRT_p[] = {
0x01, 0x66, 0x01, 0xe9, 0x26, 0xa0, 0xf8, 0xc9, 0xe2, 0x6e, 0xca, 0xb7, 0x69, 0xea, 0x65, 0xa5, 0xe7, 0xc5, 0x2c, 0xc9, 0xe0, 0x80, 0xef, 0x51, 0x94, 0x57, 0xc6, 0x44, 0xda, 0x68, 0x91, 0xc5, 0xa1, 0x04, 0xd3, 0xea, 0x79, 0x55, 0x92, 0x9a, 0x22, 0xe7, 0xc6, 0x8a, 0x7a, 0xf9, 0xfc, 0xad, 0x77, 0x7c, 0x3c, 0xcc, 0x2b, 0x9e, 0x3d, 0x36, 0x50, 0xbc, 0xe4, 0x04, 0x39, 0x9b, 0x7e, 0x59, 0xd1, 
};
static const u8 rsa_pss_133_CRT_q[] = {
0x01, 0x4e, 0xaf, 0xa1, 0xd4, 0xd0, 0x18, 0x4d, 0xa7, 0xe3, 0x1f, 0x87, 0x7d, 0x12, 0x81, 0xdd, 0xda, 0x62, 0x56, 0x64, 0x86, 0x9e, 0x83, 0x79, 0xe6, 0x7a, 0xd3, 0xb7, 0x5e, 0xae, 0x74, 0xa5, 0x80, 0xe9, 0x82, 0x7a, 0xbd, 0x6e, 0xb7, 0xa0, 0x02, 0xcb, 0x54, 0x11, 0xf5, 0x26, 0x67, 0x97, 0x76, 0x8f, 0xb8, 0xe9, 0x5a, 0xe4, 0x0e, 0x3e, 0x8a, 0x01, 0xf3, 0x5f, 0xf8, 0x9e, 0x56, 0xc0, 0x79, 
};
static const u8 rsa_pss_133_CRT_dP[] = {
0xe2, 0x47, 0xcc, 0xe5, 0x04, 0x93, 0x9b, 0x8f, 0x0a, 0x36, 0x09, 0x0d, 0xe2, 0x00, 0x93, 0x87, 0x55, 0xe2, 0x44, 0x4b, 0x29, 0x53, 0x9a, 0x7d, 0xa7, 0xa9, 0x02, 0xf6, 0x05, 0x68, 0x35, 0xc0, 0xdb, 0x7b, 0x52, 0x55, 0x94, 0x97, 0xcf, 0xe2, 0xc6, 0x1a, 0x80, 0x86, 0xd0, 0x21, 0x3c, 0x47, 0x2c, 0x78, 0x85, 0x18, 0x00, 0xb1, 0x71, 0xf6, 0x40, 0x1d, 0xe2, 0xe9, 0xc2, 0x75, 0x6f, 0x31, 
};
static const u8 rsa_pss_133_CRT_dQ[] = {
0xb1, 0x2f, 0xba, 0x75, 0x78, 0x55, 0xe5, 0x86, 0xe4, 0x6f, 0x64, 0xc3, 0x8a, 0x70, 0xc6, 0x8b, 0x3f, 0x54, 0x8d, 0x93, 0xd7, 0x87, 0xb3, 0x99, 0x99, 0x9d, 0x4c, 0x8f, 0x0b, 0xbd, 0x25, 0x81, 0xc2, 0x1e, 0x19, 0xed, 0x00, 0x18, 0xa6, 0xd5, 0xd3, 0xdf, 0x86, 0x42, 0x4b, 0x3a, 0xbc, 0xad, 0x40, 0x19, 0x9d, 0x31, 0x49, 0x5b, 0x61, 0x30, 0x9f, 0x27, 0xc1, 0xbf, 0x55, 0xd4, 0x87, 0xc1, 
};
static const u8 rsa_pss_133_CRT_qInv[] = {
0x56, 0x4b, 0x1e, 0x1f, 0xa0, 0x03, 0xbd, 0xa9, 0x1e, 0x89, 0x09, 0x04, 0x25, 0xaa, 0xc0, 0x5b, 0x91, 0xda, 0x9e, 0xe2, 0x50, 0x61, 0xe7, 0x62, 0x8d, 0x5f, 0x51, 0x30, 0x4a, 0x84, 0x99, 0x2f, 0xdc, 0x33, 0x76, 0x2b, 0xd3, 0x78, 0xa5, 0x9f, 0x03, 0x0a, 0x33, 0x4d, 0x53, 0x2b, 0xd0, 0xda, 0xe8, 0xf2, 0x98, 0xea, 0x9e, 0xd8, 0x44, 0x63, 0x6a, 0xd5, 0xfb, 0x8c, 0xbd, 0xc0, 0x3c, 0xad, 
};


static const rsa_test test_rsa_pss_133_CRT = {
	.name = "rsa_pss_133_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_133_CRT_n,
	.nlen = sizeof(rsa_pss_133_CRT_n),
	.d = (const u8*)&rsa_pss_133_CRT_d,
	.dlen = sizeof(rsa_pss_133_CRT_d),
	.e = (const u8*)&rsa_pss_133_CRT_e,
	.elen = sizeof(rsa_pss_133_CRT_e),
	.p = (const u8*)&rsa_pss_133_CRT_p,
	.plen = sizeof(rsa_pss_133_CRT_p),
	.q = (const u8*)&rsa_pss_133_CRT_q,
	.qlen = sizeof(rsa_pss_133_CRT_q),
	.dP = (const u8*)&rsa_pss_133_CRT_dP,
	.dPlen = sizeof(rsa_pss_133_CRT_dP),
	.dQ = (const u8*)&rsa_pss_133_CRT_dQ,
	.dQlen = sizeof(rsa_pss_133_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_133_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_133_CRT_qInv),
	.m = (const u8*)&rsa_pss_133_CRT_m,
	.mlen = sizeof(rsa_pss_133_CRT_m),
	.res = (const u8*)&rsa_pss_133_CRT_res,
	.reslen = sizeof(rsa_pss_133_CRT_res),
	.salt = (const u8*)&rsa_pss_133_CRT_salt,
	.saltlen = sizeof(rsa_pss_133_CRT_salt),
};
static const u8 rsa_pss_134_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_134_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_134_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_134_m[] = {
0xe4, 0xf8, 0x60, 0x1a, 0x8a, 0x6d, 0xa1, 0xbe, 0x34, 0x44, 0x7c, 0x09, 0x59, 0xc0, 0x58, 0x57, 0x0c, 0x36, 0x68, 0xcf, 0xd5, 0x1d, 0xd5, 0xf9, 0xcc, 0xd6, 0xad, 0x44, 0x11, 0xfe, 0x82, 0x13, 0x48, 0x6d, 0x78, 0xa6, 0xc4, 0x9f, 0x93, 0xef, 0xc2, 0xca, 0x22, 0x88, 0xce, 0xbc, 0x2b, 0x9b, 0x60, 0xbd, 0x04, 0xb1, 0xe2, 0x20, 0xd8, 0x6e, 0x3d, 0x48, 0x48, 0xd7, 0x09, 0xd0, 0x32, 0xd1, 0xe8, 0xc6, 0xa0, 0x70, 0xc6, 0xaf, 0x9a, 0x49, 0x9f, 0xcf, 0x95, 0x35, 0x4b, 0x14, 0xba, 0x61, 0x27, 0xc7, 0x39, 0xde, 0x1b, 0xb0, 0xfd, 0x16, 0x43, 0x1e, 0x46, 0x93, 0x8a, 0xec, 0x0c, 0xf8, 0xad, 0x9e, 0xb7, 0x2e, 0x83, 0x2a, 0x70, 0x35, 0xde, 0x9b, 0x78, 0x07, 0xbd, 0xc0, 0xed, 0x8b, 0x68, 0xeb, 0x0f, 0x5a, 0xc2, 0x21, 0x6b, 0xe4, 0x0c, 0xe9, 0x20, 0xc0, 0xdb, 0x0e, 0xdd, 0xd3, 0x86, 0x0e, 0xd7, 0x88, 0xef, 0xac, 0xca, 0xca, 0x50, 0x2d, 0x8f, 0x2b, 0xd6, 0xd1, 0xa7, 0xc1, 0xf4, 0x1f, 0xf4, 0x6f, 0x16, 0x81, 0xc8, 0xf1, 0xf8, 0x18, 0xe9, 0xc4, 0xf6, 0xd9, 0x1a, 0x0c, 0x78, 0x03, 0xcc, 0xc6, 0x3d, 0x76, 0xa6, 0x54, 0x4d, 0x84, 0x3e, 0x08, 0x4e, 0x36, 0x3b, 0x8a, 0xcc, 0x55, 0xaa, 0x53, 0x17, 0x33, 0xed, 0xb5, 0xde, 0xe5, 0xb5, 0x19, 0x6e, 0x9f, 0x03, 0xe8, 0xb7, 0x31, 0xb3, 0x77, 0x64, 0x28, 0xd9, 0xe4, 0x57, 0xfe, 0x3f, 0xbc, 0xb3, 0xdb, 0x72, 0x74, 0x44, 0x2d, 0x78, 0x58, 0x90, 0xe9, 0xcb, 0x08, 0x54, 0xb6, 0x44, 0x4d, 0xac, 0xe7, 0x91, 0xd7, 0x27, 0x3d, 0xe1, 0x88, 0x97, 0x19, 0x33, 0x8a, 0x77, 0xfe, 
};
static const u8 rsa_pss_134_res[] = {
0x01, 0x09, 0x91, 0x65, 0x6c, 0xca, 0x18, 0x2b, 0x7f, 0x29, 0xd2, 0xdb, 0xc0, 0x07, 0xe7, 0xae, 0x0f, 0xec, 0x15, 0x8e, 0xb6, 0x75, 0x9c, 0xb9, 0xc4, 0x5c, 0x5f, 0xf8, 0x7c, 0x76, 0x35, 0xdd, 0x46, 0xd1, 0x50, 0x88, 0x2f, 0x4d, 0xe1, 0xe9, 0xae, 0x65, 0xe7, 0xf7, 0xd9, 0x01, 0x8f, 0x68, 0x36, 0x95, 0x4a, 0x47, 0xc0, 0xa8, 0x1a, 0x8a, 0x6b, 0x6f, 0x83, 0xf2, 0x94, 0x4d, 0x60, 0x81, 0xb1, 0xaa, 0x7c, 0x75, 0x9b, 0x25, 0x4b, 0x2c, 0x34, 0xb6, 0x91, 0xda, 0x67, 0xcc, 0x02, 0x26, 0xe2, 0x0b, 0x2f, 0x18, 0xb4, 0x22, 0x12, 0x76, 0x1d, 0xcd, 0x4b, 0x90, 0x8a, 0x62, 0xb3, 0x71, 0xb5, 0x91, 0x8c, 0x57, 0x42, 0xaf, 0x4b, 0x53, 0x7e, 0x29, 0x69, 0x17, 0x67, 0x4f, 0xb9, 0x14, 0x19, 0x47, 0x61, 0x62, 0x1c, 0xc1, 0x9a, 0x41, 0xf6, 0xfb, 0x95, 0x3f, 0xbc, 0xbb, 0x64, 0x9d, 0xea, 
};
static const u8 rsa_pss_134_salt[] = {
0x7f, 0x6d, 0xd3, 0x59, 0xe6, 0x04, 0xe6, 0x08, 0x70, 0xe8, 0x98, 0xe4, 0x7b, 0x19, 0xbf, 0x2e, 0x5a, 0x7b, 0x2a, 0x90, 
};


static const rsa_test test_rsa_pss_134 = {
	.name = "rsa_pss_134",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_134_n,
	.nlen = sizeof(rsa_pss_134_n),
	.d = (const u8*)&rsa_pss_134_d,
	.dlen = sizeof(rsa_pss_134_d),
	.e = (const u8*)&rsa_pss_134_e,
	.elen = sizeof(rsa_pss_134_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_134_m,
	.mlen = sizeof(rsa_pss_134_m),
	.res = (const u8*)&rsa_pss_134_res,
	.reslen = sizeof(rsa_pss_134_res),
	.salt = (const u8*)&rsa_pss_134_salt,
	.saltlen = sizeof(rsa_pss_134_salt),
};
static const u8 rsa_pss_135_CRT_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_135_CRT_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_135_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_135_CRT_m[] = {
0xe4, 0xf8, 0x60, 0x1a, 0x8a, 0x6d, 0xa1, 0xbe, 0x34, 0x44, 0x7c, 0x09, 0x59, 0xc0, 0x58, 0x57, 0x0c, 0x36, 0x68, 0xcf, 0xd5, 0x1d, 0xd5, 0xf9, 0xcc, 0xd6, 0xad, 0x44, 0x11, 0xfe, 0x82, 0x13, 0x48, 0x6d, 0x78, 0xa6, 0xc4, 0x9f, 0x93, 0xef, 0xc2, 0xca, 0x22, 0x88, 0xce, 0xbc, 0x2b, 0x9b, 0x60, 0xbd, 0x04, 0xb1, 0xe2, 0x20, 0xd8, 0x6e, 0x3d, 0x48, 0x48, 0xd7, 0x09, 0xd0, 0x32, 0xd1, 0xe8, 0xc6, 0xa0, 0x70, 0xc6, 0xaf, 0x9a, 0x49, 0x9f, 0xcf, 0x95, 0x35, 0x4b, 0x14, 0xba, 0x61, 0x27, 0xc7, 0x39, 0xde, 0x1b, 0xb0, 0xfd, 0x16, 0x43, 0x1e, 0x46, 0x93, 0x8a, 0xec, 0x0c, 0xf8, 0xad, 0x9e, 0xb7, 0x2e, 0x83, 0x2a, 0x70, 0x35, 0xde, 0x9b, 0x78, 0x07, 0xbd, 0xc0, 0xed, 0x8b, 0x68, 0xeb, 0x0f, 0x5a, 0xc2, 0x21, 0x6b, 0xe4, 0x0c, 0xe9, 0x20, 0xc0, 0xdb, 0x0e, 0xdd, 0xd3, 0x86, 0x0e, 0xd7, 0x88, 0xef, 0xac, 0xca, 0xca, 0x50, 0x2d, 0x8f, 0x2b, 0xd6, 0xd1, 0xa7, 0xc1, 0xf4, 0x1f, 0xf4, 0x6f, 0x16, 0x81, 0xc8, 0xf1, 0xf8, 0x18, 0xe9, 0xc4, 0xf6, 0xd9, 0x1a, 0x0c, 0x78, 0x03, 0xcc, 0xc6, 0x3d, 0x76, 0xa6, 0x54, 0x4d, 0x84, 0x3e, 0x08, 0x4e, 0x36, 0x3b, 0x8a, 0xcc, 0x55, 0xaa, 0x53, 0x17, 0x33, 0xed, 0xb5, 0xde, 0xe5, 0xb5, 0x19, 0x6e, 0x9f, 0x03, 0xe8, 0xb7, 0x31, 0xb3, 0x77, 0x64, 0x28, 0xd9, 0xe4, 0x57, 0xfe, 0x3f, 0xbc, 0xb3, 0xdb, 0x72, 0x74, 0x44, 0x2d, 0x78, 0x58, 0x90, 0xe9, 0xcb, 0x08, 0x54, 0xb6, 0x44, 0x4d, 0xac, 0xe7, 0x91, 0xd7, 0x27, 0x3d, 0xe1, 0x88, 0x97, 0x19, 0x33, 0x8a, 0x77, 0xfe, 
};
static const u8 rsa_pss_135_CRT_res[] = {
0x01, 0x09, 0x91, 0x65, 0x6c, 0xca, 0x18, 0x2b, 0x7f, 0x29, 0xd2, 0xdb, 0xc0, 0x07, 0xe7, 0xae, 0x0f, 0xec, 0x15, 0x8e, 0xb6, 0x75, 0x9c, 0xb9, 0xc4, 0x5c, 0x5f, 0xf8, 0x7c, 0x76, 0x35, 0xdd, 0x46, 0xd1, 0x50, 0x88, 0x2f, 0x4d, 0xe1, 0xe9, 0xae, 0x65, 0xe7, 0xf7, 0xd9, 0x01, 0x8f, 0x68, 0x36, 0x95, 0x4a, 0x47, 0xc0, 0xa8, 0x1a, 0x8a, 0x6b, 0x6f, 0x83, 0xf2, 0x94, 0x4d, 0x60, 0x81, 0xb1, 0xaa, 0x7c, 0x75, 0x9b, 0x25, 0x4b, 0x2c, 0x34, 0xb6, 0x91, 0xda, 0x67, 0xcc, 0x02, 0x26, 0xe2, 0x0b, 0x2f, 0x18, 0xb4, 0x22, 0x12, 0x76, 0x1d, 0xcd, 0x4b, 0x90, 0x8a, 0x62, 0xb3, 0x71, 0xb5, 0x91, 0x8c, 0x57, 0x42, 0xaf, 0x4b, 0x53, 0x7e, 0x29, 0x69, 0x17, 0x67, 0x4f, 0xb9, 0x14, 0x19, 0x47, 0x61, 0x62, 0x1c, 0xc1, 0x9a, 0x41, 0xf6, 0xfb, 0x95, 0x3f, 0xbc, 0xbb, 0x64, 0x9d, 0xea, 
};
static const u8 rsa_pss_135_CRT_salt[] = {
0x7f, 0x6d, 0xd3, 0x59, 0xe6, 0x04, 0xe6, 0x08, 0x70, 0xe8, 0x98, 0xe4, 0x7b, 0x19, 0xbf, 0x2e, 0x5a, 0x7b, 0x2a, 0x90, 
};
static const u8 rsa_pss_135_CRT_p[] = {
0x01, 0x66, 0x01, 0xe9, 0x26, 0xa0, 0xf8, 0xc9, 0xe2, 0x6e, 0xca, 0xb7, 0x69, 0xea, 0x65, 0xa5, 0xe7, 0xc5, 0x2c, 0xc9, 0xe0, 0x80, 0xef, 0x51, 0x94, 0x57, 0xc6, 0x44, 0xda, 0x68, 0x91, 0xc5, 0xa1, 0x04, 0xd3, 0xea, 0x79, 0x55, 0x92, 0x9a, 0x22, 0xe7, 0xc6, 0x8a, 0x7a, 0xf9, 0xfc, 0xad, 0x77, 0x7c, 0x3c, 0xcc, 0x2b, 0x9e, 0x3d, 0x36, 0x50, 0xbc, 0xe4, 0x04, 0x39, 0x9b, 0x7e, 0x59, 0xd1, 
};
static const u8 rsa_pss_135_CRT_q[] = {
0x01, 0x4e, 0xaf, 0xa1, 0xd4, 0xd0, 0x18, 0x4d, 0xa7, 0xe3, 0x1f, 0x87, 0x7d, 0x12, 0x81, 0xdd, 0xda, 0x62, 0x56, 0x64, 0x86, 0x9e, 0x83, 0x79, 0xe6, 0x7a, 0xd3, 0xb7, 0x5e, 0xae, 0x74, 0xa5, 0x80, 0xe9, 0x82, 0x7a, 0xbd, 0x6e, 0xb7, 0xa0, 0x02, 0xcb, 0x54, 0x11, 0xf5, 0x26, 0x67, 0x97, 0x76, 0x8f, 0xb8, 0xe9, 0x5a, 0xe4, 0x0e, 0x3e, 0x8a, 0x01, 0xf3, 0x5f, 0xf8, 0x9e, 0x56, 0xc0, 0x79, 
};
static const u8 rsa_pss_135_CRT_dP[] = {
0xe2, 0x47, 0xcc, 0xe5, 0x04, 0x93, 0x9b, 0x8f, 0x0a, 0x36, 0x09, 0x0d, 0xe2, 0x00, 0x93, 0x87, 0x55, 0xe2, 0x44, 0x4b, 0x29, 0x53, 0x9a, 0x7d, 0xa7, 0xa9, 0x02, 0xf6, 0x05, 0x68, 0x35, 0xc0, 0xdb, 0x7b, 0x52, 0x55, 0x94, 0x97, 0xcf, 0xe2, 0xc6, 0x1a, 0x80, 0x86, 0xd0, 0x21, 0x3c, 0x47, 0x2c, 0x78, 0x85, 0x18, 0x00, 0xb1, 0x71, 0xf6, 0x40, 0x1d, 0xe2, 0xe9, 0xc2, 0x75, 0x6f, 0x31, 
};
static const u8 rsa_pss_135_CRT_dQ[] = {
0xb1, 0x2f, 0xba, 0x75, 0x78, 0x55, 0xe5, 0x86, 0xe4, 0x6f, 0x64, 0xc3, 0x8a, 0x70, 0xc6, 0x8b, 0x3f, 0x54, 0x8d, 0x93, 0xd7, 0x87, 0xb3, 0x99, 0x99, 0x9d, 0x4c, 0x8f, 0x0b, 0xbd, 0x25, 0x81, 0xc2, 0x1e, 0x19, 0xed, 0x00, 0x18, 0xa6, 0xd5, 0xd3, 0xdf, 0x86, 0x42, 0x4b, 0x3a, 0xbc, 0xad, 0x40, 0x19, 0x9d, 0x31, 0x49, 0x5b, 0x61, 0x30, 0x9f, 0x27, 0xc1, 0xbf, 0x55, 0xd4, 0x87, 0xc1, 
};
static const u8 rsa_pss_135_CRT_qInv[] = {
0x56, 0x4b, 0x1e, 0x1f, 0xa0, 0x03, 0xbd, 0xa9, 0x1e, 0x89, 0x09, 0x04, 0x25, 0xaa, 0xc0, 0x5b, 0x91, 0xda, 0x9e, 0xe2, 0x50, 0x61, 0xe7, 0x62, 0x8d, 0x5f, 0x51, 0x30, 0x4a, 0x84, 0x99, 0x2f, 0xdc, 0x33, 0x76, 0x2b, 0xd3, 0x78, 0xa5, 0x9f, 0x03, 0x0a, 0x33, 0x4d, 0x53, 0x2b, 0xd0, 0xda, 0xe8, 0xf2, 0x98, 0xea, 0x9e, 0xd8, 0x44, 0x63, 0x6a, 0xd5, 0xfb, 0x8c, 0xbd, 0xc0, 0x3c, 0xad, 
};


static const rsa_test test_rsa_pss_135_CRT = {
	.name = "rsa_pss_135_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_135_CRT_n,
	.nlen = sizeof(rsa_pss_135_CRT_n),
	.d = (const u8*)&rsa_pss_135_CRT_d,
	.dlen = sizeof(rsa_pss_135_CRT_d),
	.e = (const u8*)&rsa_pss_135_CRT_e,
	.elen = sizeof(rsa_pss_135_CRT_e),
	.p = (const u8*)&rsa_pss_135_CRT_p,
	.plen = sizeof(rsa_pss_135_CRT_p),
	.q = (const u8*)&rsa_pss_135_CRT_q,
	.qlen = sizeof(rsa_pss_135_CRT_q),
	.dP = (const u8*)&rsa_pss_135_CRT_dP,
	.dPlen = sizeof(rsa_pss_135_CRT_dP),
	.dQ = (const u8*)&rsa_pss_135_CRT_dQ,
	.dQlen = sizeof(rsa_pss_135_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_135_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_135_CRT_qInv),
	.m = (const u8*)&rsa_pss_135_CRT_m,
	.mlen = sizeof(rsa_pss_135_CRT_m),
	.res = (const u8*)&rsa_pss_135_CRT_res,
	.reslen = sizeof(rsa_pss_135_CRT_res),
	.salt = (const u8*)&rsa_pss_135_CRT_salt,
	.saltlen = sizeof(rsa_pss_135_CRT_salt),
};
static const u8 rsa_pss_136_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_136_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_136_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_136_m[] = {
0x52, 0xa1, 0xd9, 0x6c, 0x8a, 0xc3, 0x9e, 0x41, 0xe4, 0x55, 0x80, 0x98, 0x01, 0xb9, 0x27, 0xa5, 0xb4, 0x45, 0xc1, 0x0d, 0x90, 0x2a, 0x0d, 0xcd, 0x38, 0x50, 0xd2, 0x2a, 0x66, 0xd2, 0xbb, 0x07, 0x03, 0xe6, 0x7d, 0x58, 0x67, 0x11, 0x45, 0x95, 0xaa, 0xbf, 0x5a, 0x7a, 0xeb, 0x5a, 0x8f, 0x87, 0x03, 0x4b, 0xbb, 0x30, 0xe1, 0x3c, 0xfd, 0x48, 0x17, 0xa9, 0xbe, 0x76, 0x23, 0x00, 0x23, 0x60, 0x6d, 0x02, 0x86, 0xa3, 0xfa, 0xf8, 0xa4, 0xd2, 0x2b, 0x72, 0x8e, 0xc5, 0x18, 0x07, 0x9f, 0x9e, 0x64, 0x52, 0x6e, 0x3a, 0x0c, 0xc7, 0x94, 0x1a, 0xa3, 0x38, 0xc4, 0x37, 0x99, 0x7c, 0x68, 0x0c, 0xca, 0xc6, 0x7c, 0x66, 0xbf, 0xa1, 
};
static const u8 rsa_pss_136_res[] = {
0x00, 0x7f, 0x00, 0x30, 0x01, 0x8f, 0x53, 0xcd, 0xc7, 0x1f, 0x23, 0xd0, 0x36, 0x59, 0xfd, 0xe5, 0x4d, 0x42, 0x41, 0xf7, 0x58, 0xa7, 0x50, 0xb4, 0x2f, 0x18, 0x5f, 0x87, 0x57, 0x85, 0x20, 0xc3, 0x07, 0x42, 0xaf, 0xd8, 0x43, 0x59, 0xb6, 0xe6, 0xe8, 0xd3, 0xed, 0x95, 0x9d, 0xc6, 0xfe, 0x48, 0x6b, 0xed, 0xc8, 0xe2, 0xcf, 0x00, 0x1f, 0x63, 0xa7, 0xab, 0xe1, 0x62, 0x56, 0xa1, 0xb8, 0x4d, 0xf0, 0xd2, 0x49, 0xfc, 0x05, 0xd3, 0x19, 0x4c, 0xe5, 0xf0, 0x91, 0x27, 0x42, 0xdb, 0xbf, 0x80, 0xdd, 0x17, 0x4f, 0x6c, 0x51, 0xf6, 0xba, 0xd7, 0xf1, 0x6c, 0xf3, 0x36, 0x4e, 0xba, 0x09, 0x5a, 0x06, 0x26, 0x7d, 0xc3, 0x79, 0x38, 0x03, 0xac, 0x75, 0x26, 0xae, 0xbe, 0x0a, 0x47, 0x5d, 0x38, 0xb8, 0xc2, 0x24, 0x7a, 0xb5, 0x1c, 0x48, 0x98, 0xdf, 0x70, 0x47, 0xdc, 0x6a, 0xdf, 0x52, 0xc6, 0xc4, 
};
static const u8 rsa_pss_136_salt[] = {
0xfc, 0xa8, 0x62, 0x06, 0x8b, 0xce, 0x22, 0x46, 0x72, 0x4b, 0x70, 0x8a, 0x05, 0x19, 0xda, 0x17, 0xe6, 0x48, 0x68, 0x8c, 
};


static const rsa_test test_rsa_pss_136 = {
	.name = "rsa_pss_136",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_136_n,
	.nlen = sizeof(rsa_pss_136_n),
	.d = (const u8*)&rsa_pss_136_d,
	.dlen = sizeof(rsa_pss_136_d),
	.e = (const u8*)&rsa_pss_136_e,
	.elen = sizeof(rsa_pss_136_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_136_m,
	.mlen = sizeof(rsa_pss_136_m),
	.res = (const u8*)&rsa_pss_136_res,
	.reslen = sizeof(rsa_pss_136_res),
	.salt = (const u8*)&rsa_pss_136_salt,
	.saltlen = sizeof(rsa_pss_136_salt),
};
static const u8 rsa_pss_137_CRT_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_137_CRT_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_137_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_137_CRT_m[] = {
0x52, 0xa1, 0xd9, 0x6c, 0x8a, 0xc3, 0x9e, 0x41, 0xe4, 0x55, 0x80, 0x98, 0x01, 0xb9, 0x27, 0xa5, 0xb4, 0x45, 0xc1, 0x0d, 0x90, 0x2a, 0x0d, 0xcd, 0x38, 0x50, 0xd2, 0x2a, 0x66, 0xd2, 0xbb, 0x07, 0x03, 0xe6, 0x7d, 0x58, 0x67, 0x11, 0x45, 0x95, 0xaa, 0xbf, 0x5a, 0x7a, 0xeb, 0x5a, 0x8f, 0x87, 0x03, 0x4b, 0xbb, 0x30, 0xe1, 0x3c, 0xfd, 0x48, 0x17, 0xa9, 0xbe, 0x76, 0x23, 0x00, 0x23, 0x60, 0x6d, 0x02, 0x86, 0xa3, 0xfa, 0xf8, 0xa4, 0xd2, 0x2b, 0x72, 0x8e, 0xc5, 0x18, 0x07, 0x9f, 0x9e, 0x64, 0x52, 0x6e, 0x3a, 0x0c, 0xc7, 0x94, 0x1a, 0xa3, 0x38, 0xc4, 0x37, 0x99, 0x7c, 0x68, 0x0c, 0xca, 0xc6, 0x7c, 0x66, 0xbf, 0xa1, 
};
static const u8 rsa_pss_137_CRT_res[] = {
0x00, 0x7f, 0x00, 0x30, 0x01, 0x8f, 0x53, 0xcd, 0xc7, 0x1f, 0x23, 0xd0, 0x36, 0x59, 0xfd, 0xe5, 0x4d, 0x42, 0x41, 0xf7, 0x58, 0xa7, 0x50, 0xb4, 0x2f, 0x18, 0x5f, 0x87, 0x57, 0x85, 0x20, 0xc3, 0x07, 0x42, 0xaf, 0xd8, 0x43, 0x59, 0xb6, 0xe6, 0xe8, 0xd3, 0xed, 0x95, 0x9d, 0xc6, 0xfe, 0x48, 0x6b, 0xed, 0xc8, 0xe2, 0xcf, 0x00, 0x1f, 0x63, 0xa7, 0xab, 0xe1, 0x62, 0x56, 0xa1, 0xb8, 0x4d, 0xf0, 0xd2, 0x49, 0xfc, 0x05, 0xd3, 0x19, 0x4c, 0xe5, 0xf0, 0x91, 0x27, 0x42, 0xdb, 0xbf, 0x80, 0xdd, 0x17, 0x4f, 0x6c, 0x51, 0xf6, 0xba, 0xd7, 0xf1, 0x6c, 0xf3, 0x36, 0x4e, 0xba, 0x09, 0x5a, 0x06, 0x26, 0x7d, 0xc3, 0x79, 0x38, 0x03, 0xac, 0x75, 0x26, 0xae, 0xbe, 0x0a, 0x47, 0x5d, 0x38, 0xb8, 0xc2, 0x24, 0x7a, 0xb5, 0x1c, 0x48, 0x98, 0xdf, 0x70, 0x47, 0xdc, 0x6a, 0xdf, 0x52, 0xc6, 0xc4, 
};
static const u8 rsa_pss_137_CRT_salt[] = {
0xfc, 0xa8, 0x62, 0x06, 0x8b, 0xce, 0x22, 0x46, 0x72, 0x4b, 0x70, 0x8a, 0x05, 0x19, 0xda, 0x17, 0xe6, 0x48, 0x68, 0x8c, 
};
static const u8 rsa_pss_137_CRT_p[] = {
0x01, 0x66, 0x01, 0xe9, 0x26, 0xa0, 0xf8, 0xc9, 0xe2, 0x6e, 0xca, 0xb7, 0x69, 0xea, 0x65, 0xa5, 0xe7, 0xc5, 0x2c, 0xc9, 0xe0, 0x80, 0xef, 0x51, 0x94, 0x57, 0xc6, 0x44, 0xda, 0x68, 0x91, 0xc5, 0xa1, 0x04, 0xd3, 0xea, 0x79, 0x55, 0x92, 0x9a, 0x22, 0xe7, 0xc6, 0x8a, 0x7a, 0xf9, 0xfc, 0xad, 0x77, 0x7c, 0x3c, 0xcc, 0x2b, 0x9e, 0x3d, 0x36, 0x50, 0xbc, 0xe4, 0x04, 0x39, 0x9b, 0x7e, 0x59, 0xd1, 
};
static const u8 rsa_pss_137_CRT_q[] = {
0x01, 0x4e, 0xaf, 0xa1, 0xd4, 0xd0, 0x18, 0x4d, 0xa7, 0xe3, 0x1f, 0x87, 0x7d, 0x12, 0x81, 0xdd, 0xda, 0x62, 0x56, 0x64, 0x86, 0x9e, 0x83, 0x79, 0xe6, 0x7a, 0xd3, 0xb7, 0x5e, 0xae, 0x74, 0xa5, 0x80, 0xe9, 0x82, 0x7a, 0xbd, 0x6e, 0xb7, 0xa0, 0x02, 0xcb, 0x54, 0x11, 0xf5, 0x26, 0x67, 0x97, 0x76, 0x8f, 0xb8, 0xe9, 0x5a, 0xe4, 0x0e, 0x3e, 0x8a, 0x01, 0xf3, 0x5f, 0xf8, 0x9e, 0x56, 0xc0, 0x79, 
};
static const u8 rsa_pss_137_CRT_dP[] = {
0xe2, 0x47, 0xcc, 0xe5, 0x04, 0x93, 0x9b, 0x8f, 0x0a, 0x36, 0x09, 0x0d, 0xe2, 0x00, 0x93, 0x87, 0x55, 0xe2, 0x44, 0x4b, 0x29, 0x53, 0x9a, 0x7d, 0xa7, 0xa9, 0x02, 0xf6, 0x05, 0x68, 0x35, 0xc0, 0xdb, 0x7b, 0x52, 0x55, 0x94, 0x97, 0xcf, 0xe2, 0xc6, 0x1a, 0x80, 0x86, 0xd0, 0x21, 0x3c, 0x47, 0x2c, 0x78, 0x85, 0x18, 0x00, 0xb1, 0x71, 0xf6, 0x40, 0x1d, 0xe2, 0xe9, 0xc2, 0x75, 0x6f, 0x31, 
};
static const u8 rsa_pss_137_CRT_dQ[] = {
0xb1, 0x2f, 0xba, 0x75, 0x78, 0x55, 0xe5, 0x86, 0xe4, 0x6f, 0x64, 0xc3, 0x8a, 0x70, 0xc6, 0x8b, 0x3f, 0x54, 0x8d, 0x93, 0xd7, 0x87, 0xb3, 0x99, 0x99, 0x9d, 0x4c, 0x8f, 0x0b, 0xbd, 0x25, 0x81, 0xc2, 0x1e, 0x19, 0xed, 0x00, 0x18, 0xa6, 0xd5, 0xd3, 0xdf, 0x86, 0x42, 0x4b, 0x3a, 0xbc, 0xad, 0x40, 0x19, 0x9d, 0x31, 0x49, 0x5b, 0x61, 0x30, 0x9f, 0x27, 0xc1, 0xbf, 0x55, 0xd4, 0x87, 0xc1, 
};
static const u8 rsa_pss_137_CRT_qInv[] = {
0x56, 0x4b, 0x1e, 0x1f, 0xa0, 0x03, 0xbd, 0xa9, 0x1e, 0x89, 0x09, 0x04, 0x25, 0xaa, 0xc0, 0x5b, 0x91, 0xda, 0x9e, 0xe2, 0x50, 0x61, 0xe7, 0x62, 0x8d, 0x5f, 0x51, 0x30, 0x4a, 0x84, 0x99, 0x2f, 0xdc, 0x33, 0x76, 0x2b, 0xd3, 0x78, 0xa5, 0x9f, 0x03, 0x0a, 0x33, 0x4d, 0x53, 0x2b, 0xd0, 0xda, 0xe8, 0xf2, 0x98, 0xea, 0x9e, 0xd8, 0x44, 0x63, 0x6a, 0xd5, 0xfb, 0x8c, 0xbd, 0xc0, 0x3c, 0xad, 
};


static const rsa_test test_rsa_pss_137_CRT = {
	.name = "rsa_pss_137_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_137_CRT_n,
	.nlen = sizeof(rsa_pss_137_CRT_n),
	.d = (const u8*)&rsa_pss_137_CRT_d,
	.dlen = sizeof(rsa_pss_137_CRT_d),
	.e = (const u8*)&rsa_pss_137_CRT_e,
	.elen = sizeof(rsa_pss_137_CRT_e),
	.p = (const u8*)&rsa_pss_137_CRT_p,
	.plen = sizeof(rsa_pss_137_CRT_p),
	.q = (const u8*)&rsa_pss_137_CRT_q,
	.qlen = sizeof(rsa_pss_137_CRT_q),
	.dP = (const u8*)&rsa_pss_137_CRT_dP,
	.dPlen = sizeof(rsa_pss_137_CRT_dP),
	.dQ = (const u8*)&rsa_pss_137_CRT_dQ,
	.dQlen = sizeof(rsa_pss_137_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_137_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_137_CRT_qInv),
	.m = (const u8*)&rsa_pss_137_CRT_m,
	.mlen = sizeof(rsa_pss_137_CRT_m),
	.res = (const u8*)&rsa_pss_137_CRT_res,
	.reslen = sizeof(rsa_pss_137_CRT_res),
	.salt = (const u8*)&rsa_pss_137_CRT_salt,
	.saltlen = sizeof(rsa_pss_137_CRT_salt),
};
static const u8 rsa_pss_138_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_138_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_138_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_138_m[] = {
0xa7, 0x18, 0x2c, 0x83, 0xac, 0x18, 0xbe, 0x65, 0x70, 0xa1, 0x06, 0xaa, 0x9d, 0x5c, 0x4e, 0x3d, 0xbb, 0xd4, 0xaf, 0xae, 0xb0, 0xc6, 0x0c, 0x4a, 0x23, 0xe1, 0x96, 0x9d, 0x79, 0xff, 
};
static const u8 rsa_pss_138_res[] = {
0x00, 0x9c, 0xd2, 0xf4, 0xed, 0xbe, 0x23, 0xe1, 0x23, 0x46, 0xae, 0x8c, 0x76, 0xdd, 0x9a, 0xd3, 0x23, 0x0a, 0x62, 0x07, 0x61, 0x41, 0xf1, 0x6c, 0x15, 0x2b, 0xa1, 0x85, 0x13, 0xa4, 0x8e, 0xf6, 0xf0, 0x10, 0xe0, 0xe3, 0x7f, 0xd3, 0xdf, 0x10, 0xa1, 0xec, 0x62, 0x9a, 0x0c, 0xb5, 0xa3, 0xb5, 0xd2, 0x89, 0x30, 0x07, 0x29, 0x8c, 0x30, 0x93, 0x6a, 0x95, 0x90, 0x3b, 0x6b, 0xa8, 0x55, 0x55, 0xd9, 0xec, 0x36, 0x73, 0xa0, 0x61, 0x08, 0xfd, 0x62, 0xa2, 0xfd, 0xa5, 0x6d, 0x1c, 0xe2, 0xe8, 0x5c, 0x4d, 0xb6, 0xb2, 0x4a, 0x81, 0xca, 0x3b, 0x49, 0x6c, 0x36, 0xd4, 0xfd, 0x06, 0xeb, 0x7c, 0x91, 0x66, 0xd8, 0xe9, 0x48, 0x77, 0xc4, 0x2b, 0xea, 0x62, 0x2b, 0x3b, 0xfe, 0x92, 0x51, 0xfd, 0xc2, 0x1d, 0x8d, 0x53, 0x71, 0xba, 0xda, 0xd7, 0x8a, 0x48, 0x82, 0x14, 0x79, 0x63, 0x35, 0xb4, 0x0b, 
};
static const u8 rsa_pss_138_salt[] = {
0x80, 0x70, 0xef, 0x2d, 0xe9, 0x45, 0xc0, 0x23, 0x87, 0x68, 0x4b, 0xa0, 0xd3, 0x30, 0x96, 0x73, 0x22, 0x35, 0xd4, 0x40, 
};


static const rsa_test test_rsa_pss_138 = {
	.name = "rsa_pss_138",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_138_n,
	.nlen = sizeof(rsa_pss_138_n),
	.d = (const u8*)&rsa_pss_138_d,
	.dlen = sizeof(rsa_pss_138_d),
	.e = (const u8*)&rsa_pss_138_e,
	.elen = sizeof(rsa_pss_138_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_138_m,
	.mlen = sizeof(rsa_pss_138_m),
	.res = (const u8*)&rsa_pss_138_res,
	.reslen = sizeof(rsa_pss_138_res),
	.salt = (const u8*)&rsa_pss_138_salt,
	.saltlen = sizeof(rsa_pss_138_salt),
};
static const u8 rsa_pss_139_CRT_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_139_CRT_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_139_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_139_CRT_m[] = {
0xa7, 0x18, 0x2c, 0x83, 0xac, 0x18, 0xbe, 0x65, 0x70, 0xa1, 0x06, 0xaa, 0x9d, 0x5c, 0x4e, 0x3d, 0xbb, 0xd4, 0xaf, 0xae, 0xb0, 0xc6, 0x0c, 0x4a, 0x23, 0xe1, 0x96, 0x9d, 0x79, 0xff, 
};
static const u8 rsa_pss_139_CRT_res[] = {
0x00, 0x9c, 0xd2, 0xf4, 0xed, 0xbe, 0x23, 0xe1, 0x23, 0x46, 0xae, 0x8c, 0x76, 0xdd, 0x9a, 0xd3, 0x23, 0x0a, 0x62, 0x07, 0x61, 0x41, 0xf1, 0x6c, 0x15, 0x2b, 0xa1, 0x85, 0x13, 0xa4, 0x8e, 0xf6, 0xf0, 0x10, 0xe0, 0xe3, 0x7f, 0xd3, 0xdf, 0x10, 0xa1, 0xec, 0x62, 0x9a, 0x0c, 0xb5, 0xa3, 0xb5, 0xd2, 0x89, 0x30, 0x07, 0x29, 0x8c, 0x30, 0x93, 0x6a, 0x95, 0x90, 0x3b, 0x6b, 0xa8, 0x55, 0x55, 0xd9, 0xec, 0x36, 0x73, 0xa0, 0x61, 0x08, 0xfd, 0x62, 0xa2, 0xfd, 0xa5, 0x6d, 0x1c, 0xe2, 0xe8, 0x5c, 0x4d, 0xb6, 0xb2, 0x4a, 0x81, 0xca, 0x3b, 0x49, 0x6c, 0x36, 0xd4, 0xfd, 0x06, 0xeb, 0x7c, 0x91, 0x66, 0xd8, 0xe9, 0x48, 0x77, 0xc4, 0x2b, 0xea, 0x62, 0x2b, 0x3b, 0xfe, 0x92, 0x51, 0xfd, 0xc2, 0x1d, 0x8d, 0x53, 0x71, 0xba, 0xda, 0xd7, 0x8a, 0x48, 0x82, 0x14, 0x79, 0x63, 0x35, 0xb4, 0x0b, 
};
static const u8 rsa_pss_139_CRT_salt[] = {
0x80, 0x70, 0xef, 0x2d, 0xe9, 0x45, 0xc0, 0x23, 0x87, 0x68, 0x4b, 0xa0, 0xd3, 0x30, 0x96, 0x73, 0x22, 0x35, 0xd4, 0x40, 
};
static const u8 rsa_pss_139_CRT_p[] = {
0x01, 0x66, 0x01, 0xe9, 0x26, 0xa0, 0xf8, 0xc9, 0xe2, 0x6e, 0xca, 0xb7, 0x69, 0xea, 0x65, 0xa5, 0xe7, 0xc5, 0x2c, 0xc9, 0xe0, 0x80, 0xef, 0x51, 0x94, 0x57, 0xc6, 0x44, 0xda, 0x68, 0x91, 0xc5, 0xa1, 0x04, 0xd3, 0xea, 0x79, 0x55, 0x92, 0x9a, 0x22, 0xe7, 0xc6, 0x8a, 0x7a, 0xf9, 0xfc, 0xad, 0x77, 0x7c, 0x3c, 0xcc, 0x2b, 0x9e, 0x3d, 0x36, 0x50, 0xbc, 0xe4, 0x04, 0x39, 0x9b, 0x7e, 0x59, 0xd1, 
};
static const u8 rsa_pss_139_CRT_q[] = {
0x01, 0x4e, 0xaf, 0xa1, 0xd4, 0xd0, 0x18, 0x4d, 0xa7, 0xe3, 0x1f, 0x87, 0x7d, 0x12, 0x81, 0xdd, 0xda, 0x62, 0x56, 0x64, 0x86, 0x9e, 0x83, 0x79, 0xe6, 0x7a, 0xd3, 0xb7, 0x5e, 0xae, 0x74, 0xa5, 0x80, 0xe9, 0x82, 0x7a, 0xbd, 0x6e, 0xb7, 0xa0, 0x02, 0xcb, 0x54, 0x11, 0xf5, 0x26, 0x67, 0x97, 0x76, 0x8f, 0xb8, 0xe9, 0x5a, 0xe4, 0x0e, 0x3e, 0x8a, 0x01, 0xf3, 0x5f, 0xf8, 0x9e, 0x56, 0xc0, 0x79, 
};
static const u8 rsa_pss_139_CRT_dP[] = {
0xe2, 0x47, 0xcc, 0xe5, 0x04, 0x93, 0x9b, 0x8f, 0x0a, 0x36, 0x09, 0x0d, 0xe2, 0x00, 0x93, 0x87, 0x55, 0xe2, 0x44, 0x4b, 0x29, 0x53, 0x9a, 0x7d, 0xa7, 0xa9, 0x02, 0xf6, 0x05, 0x68, 0x35, 0xc0, 0xdb, 0x7b, 0x52, 0x55, 0x94, 0x97, 0xcf, 0xe2, 0xc6, 0x1a, 0x80, 0x86, 0xd0, 0x21, 0x3c, 0x47, 0x2c, 0x78, 0x85, 0x18, 0x00, 0xb1, 0x71, 0xf6, 0x40, 0x1d, 0xe2, 0xe9, 0xc2, 0x75, 0x6f, 0x31, 
};
static const u8 rsa_pss_139_CRT_dQ[] = {
0xb1, 0x2f, 0xba, 0x75, 0x78, 0x55, 0xe5, 0x86, 0xe4, 0x6f, 0x64, 0xc3, 0x8a, 0x70, 0xc6, 0x8b, 0x3f, 0x54, 0x8d, 0x93, 0xd7, 0x87, 0xb3, 0x99, 0x99, 0x9d, 0x4c, 0x8f, 0x0b, 0xbd, 0x25, 0x81, 0xc2, 0x1e, 0x19, 0xed, 0x00, 0x18, 0xa6, 0xd5, 0xd3, 0xdf, 0x86, 0x42, 0x4b, 0x3a, 0xbc, 0xad, 0x40, 0x19, 0x9d, 0x31, 0x49, 0x5b, 0x61, 0x30, 0x9f, 0x27, 0xc1, 0xbf, 0x55, 0xd4, 0x87, 0xc1, 
};
static const u8 rsa_pss_139_CRT_qInv[] = {
0x56, 0x4b, 0x1e, 0x1f, 0xa0, 0x03, 0xbd, 0xa9, 0x1e, 0x89, 0x09, 0x04, 0x25, 0xaa, 0xc0, 0x5b, 0x91, 0xda, 0x9e, 0xe2, 0x50, 0x61, 0xe7, 0x62, 0x8d, 0x5f, 0x51, 0x30, 0x4a, 0x84, 0x99, 0x2f, 0xdc, 0x33, 0x76, 0x2b, 0xd3, 0x78, 0xa5, 0x9f, 0x03, 0x0a, 0x33, 0x4d, 0x53, 0x2b, 0xd0, 0xda, 0xe8, 0xf2, 0x98, 0xea, 0x9e, 0xd8, 0x44, 0x63, 0x6a, 0xd5, 0xfb, 0x8c, 0xbd, 0xc0, 0x3c, 0xad, 
};


static const rsa_test test_rsa_pss_139_CRT = {
	.name = "rsa_pss_139_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_139_CRT_n,
	.nlen = sizeof(rsa_pss_139_CRT_n),
	.d = (const u8*)&rsa_pss_139_CRT_d,
	.dlen = sizeof(rsa_pss_139_CRT_d),
	.e = (const u8*)&rsa_pss_139_CRT_e,
	.elen = sizeof(rsa_pss_139_CRT_e),
	.p = (const u8*)&rsa_pss_139_CRT_p,
	.plen = sizeof(rsa_pss_139_CRT_p),
	.q = (const u8*)&rsa_pss_139_CRT_q,
	.qlen = sizeof(rsa_pss_139_CRT_q),
	.dP = (const u8*)&rsa_pss_139_CRT_dP,
	.dPlen = sizeof(rsa_pss_139_CRT_dP),
	.dQ = (const u8*)&rsa_pss_139_CRT_dQ,
	.dQlen = sizeof(rsa_pss_139_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_139_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_139_CRT_qInv),
	.m = (const u8*)&rsa_pss_139_CRT_m,
	.mlen = sizeof(rsa_pss_139_CRT_m),
	.res = (const u8*)&rsa_pss_139_CRT_res,
	.reslen = sizeof(rsa_pss_139_CRT_res),
	.salt = (const u8*)&rsa_pss_139_CRT_salt,
	.saltlen = sizeof(rsa_pss_139_CRT_salt),
};
static const u8 rsa_pss_140_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_140_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_140_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_140_m[] = {
0x86, 0xa8, 0x3d, 0x4a, 0x72, 0xee, 0x93, 0x2a, 0x4f, 0x56, 0x30, 0xaf, 0x65, 0x79, 0xa3, 0x86, 0xb7, 0x8f, 0xe8, 0x89, 0x99, 0xe0, 0xab, 0xd2, 0xd4, 0x90, 0x34, 0xa4, 0xbf, 0xc8, 0x54, 0xdd, 0x94, 0xf1, 0x09, 0x4e, 0x2e, 0x8c, 0xd7, 0xa1, 0x79, 0xd1, 0x95, 0x88, 0xe4, 0xae, 0xfc, 0x1b, 0x1b, 0xd2, 0x5e, 0x95, 0xe3, 0xdd, 0x46, 0x1f, 
};
static const u8 rsa_pss_140_res[] = {
0x00, 0xec, 0x43, 0x08, 0x24, 0x93, 0x1e, 0xbd, 0x3b, 0xaa, 0x43, 0x03, 0x4d, 0xae, 0x98, 0xba, 0x64, 0x6b, 0x8c, 0x36, 0x01, 0x3d, 0x16, 0x71, 0xc3, 0xcf, 0x1c, 0xf8, 0x26, 0x0c, 0x37, 0x4b, 0x19, 0xf8, 0xe1, 0xcc, 0x8d, 0x96, 0x50, 0x12, 0x40, 0x5e, 0x7e, 0x9b, 0xf7, 0x37, 0x86, 0x12, 0xdf, 0xcc, 0x85, 0xfc, 0xe1, 0x2c, 0xda, 0x11, 0xf9, 0x50, 0xbd, 0x0b, 0xa8, 0x87, 0x67, 0x40, 0x43, 0x6c, 0x1d, 0x25, 0x95, 0xa6, 0x4a, 0x1b, 0x32, 0xef, 0xcf, 0xb7, 0x4a, 0x21, 0xc8, 0x73, 0xb3, 0xcc, 0x33, 0xaa, 0xf4, 0xe3, 0xdc, 0x39, 0x53, 0xde, 0x67, 0xf0, 0x67, 0x4c, 0x04, 0x53, 0xb4, 0xfd, 0x9f, 0x60, 0x44, 0x06, 0xd4, 0x41, 0xb8, 0x16, 0x09, 0x8c, 0xb1, 0x06, 0xfe, 0x34, 0x72, 0xbc, 0x25, 0x1f, 0x81, 0x5f, 0x59, 0xdb, 0x2e, 0x43, 0x78, 0xa3, 0xad, 0xdc, 0x18, 0x1e, 0xcf, 
};
static const u8 rsa_pss_140_salt[] = {
0x17, 0x63, 0x9a, 0x4e, 0x88, 0xd7, 0x22, 0xc4, 0xfc, 0xa2, 0x4d, 0x07, 0x9a, 0x8b, 0x29, 0xc3, 0x24, 0x33, 0xb0, 0xc9, 
};


static const rsa_test test_rsa_pss_140 = {
	.name = "rsa_pss_140",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_140_n,
	.nlen = sizeof(rsa_pss_140_n),
	.d = (const u8*)&rsa_pss_140_d,
	.dlen = sizeof(rsa_pss_140_d),
	.e = (const u8*)&rsa_pss_140_e,
	.elen = sizeof(rsa_pss_140_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_140_m,
	.mlen = sizeof(rsa_pss_140_m),
	.res = (const u8*)&rsa_pss_140_res,
	.reslen = sizeof(rsa_pss_140_res),
	.salt = (const u8*)&rsa_pss_140_salt,
	.saltlen = sizeof(rsa_pss_140_salt),
};
static const u8 rsa_pss_141_CRT_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_141_CRT_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_141_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_141_CRT_m[] = {
0x86, 0xa8, 0x3d, 0x4a, 0x72, 0xee, 0x93, 0x2a, 0x4f, 0x56, 0x30, 0xaf, 0x65, 0x79, 0xa3, 0x86, 0xb7, 0x8f, 0xe8, 0x89, 0x99, 0xe0, 0xab, 0xd2, 0xd4, 0x90, 0x34, 0xa4, 0xbf, 0xc8, 0x54, 0xdd, 0x94, 0xf1, 0x09, 0x4e, 0x2e, 0x8c, 0xd7, 0xa1, 0x79, 0xd1, 0x95, 0x88, 0xe4, 0xae, 0xfc, 0x1b, 0x1b, 0xd2, 0x5e, 0x95, 0xe3, 0xdd, 0x46, 0x1f, 
};
static const u8 rsa_pss_141_CRT_res[] = {
0x00, 0xec, 0x43, 0x08, 0x24, 0x93, 0x1e, 0xbd, 0x3b, 0xaa, 0x43, 0x03, 0x4d, 0xae, 0x98, 0xba, 0x64, 0x6b, 0x8c, 0x36, 0x01, 0x3d, 0x16, 0x71, 0xc3, 0xcf, 0x1c, 0xf8, 0x26, 0x0c, 0x37, 0x4b, 0x19, 0xf8, 0xe1, 0xcc, 0x8d, 0x96, 0x50, 0x12, 0x40, 0x5e, 0x7e, 0x9b, 0xf7, 0x37, 0x86, 0x12, 0xdf, 0xcc, 0x85, 0xfc, 0xe1, 0x2c, 0xda, 0x11, 0xf9, 0x50, 0xbd, 0x0b, 0xa8, 0x87, 0x67, 0x40, 0x43, 0x6c, 0x1d, 0x25, 0x95, 0xa6, 0x4a, 0x1b, 0x32, 0xef, 0xcf, 0xb7, 0x4a, 0x21, 0xc8, 0x73, 0xb3, 0xcc, 0x33, 0xaa, 0xf4, 0xe3, 0xdc, 0x39, 0x53, 0xde, 0x67, 0xf0, 0x67, 0x4c, 0x04, 0x53, 0xb4, 0xfd, 0x9f, 0x60, 0x44, 0x06, 0xd4, 0x41, 0xb8, 0x16, 0x09, 0x8c, 0xb1, 0x06, 0xfe, 0x34, 0x72, 0xbc, 0x25, 0x1f, 0x81, 0x5f, 0x59, 0xdb, 0x2e, 0x43, 0x78, 0xa3, 0xad, 0xdc, 0x18, 0x1e, 0xcf, 
};
static const u8 rsa_pss_141_CRT_salt[] = {
0x17, 0x63, 0x9a, 0x4e, 0x88, 0xd7, 0x22, 0xc4, 0xfc, 0xa2, 0x4d, 0x07, 0x9a, 0x8b, 0x29, 0xc3, 0x24, 0x33, 0xb0, 0xc9, 
};
static const u8 rsa_pss_141_CRT_p[] = {
0x01, 0x66, 0x01, 0xe9, 0x26, 0xa0, 0xf8, 0xc9, 0xe2, 0x6e, 0xca, 0xb7, 0x69, 0xea, 0x65, 0xa5, 0xe7, 0xc5, 0x2c, 0xc9, 0xe0, 0x80, 0xef, 0x51, 0x94, 0x57, 0xc6, 0x44, 0xda, 0x68, 0x91, 0xc5, 0xa1, 0x04, 0xd3, 0xea, 0x79, 0x55, 0x92, 0x9a, 0x22, 0xe7, 0xc6, 0x8a, 0x7a, 0xf9, 0xfc, 0xad, 0x77, 0x7c, 0x3c, 0xcc, 0x2b, 0x9e, 0x3d, 0x36, 0x50, 0xbc, 0xe4, 0x04, 0x39, 0x9b, 0x7e, 0x59, 0xd1, 
};
static const u8 rsa_pss_141_CRT_q[] = {
0x01, 0x4e, 0xaf, 0xa1, 0xd4, 0xd0, 0x18, 0x4d, 0xa7, 0xe3, 0x1f, 0x87, 0x7d, 0x12, 0x81, 0xdd, 0xda, 0x62, 0x56, 0x64, 0x86, 0x9e, 0x83, 0x79, 0xe6, 0x7a, 0xd3, 0xb7, 0x5e, 0xae, 0x74, 0xa5, 0x80, 0xe9, 0x82, 0x7a, 0xbd, 0x6e, 0xb7, 0xa0, 0x02, 0xcb, 0x54, 0x11, 0xf5, 0x26, 0x67, 0x97, 0x76, 0x8f, 0xb8, 0xe9, 0x5a, 0xe4, 0x0e, 0x3e, 0x8a, 0x01, 0xf3, 0x5f, 0xf8, 0x9e, 0x56, 0xc0, 0x79, 
};
static const u8 rsa_pss_141_CRT_dP[] = {
0xe2, 0x47, 0xcc, 0xe5, 0x04, 0x93, 0x9b, 0x8f, 0x0a, 0x36, 0x09, 0x0d, 0xe2, 0x00, 0x93, 0x87, 0x55, 0xe2, 0x44, 0x4b, 0x29, 0x53, 0x9a, 0x7d, 0xa7, 0xa9, 0x02, 0xf6, 0x05, 0x68, 0x35, 0xc0, 0xdb, 0x7b, 0x52, 0x55, 0x94, 0x97, 0xcf, 0xe2, 0xc6, 0x1a, 0x80, 0x86, 0xd0, 0x21, 0x3c, 0x47, 0x2c, 0x78, 0x85, 0x18, 0x00, 0xb1, 0x71, 0xf6, 0x40, 0x1d, 0xe2, 0xe9, 0xc2, 0x75, 0x6f, 0x31, 
};
static const u8 rsa_pss_141_CRT_dQ[] = {
0xb1, 0x2f, 0xba, 0x75, 0x78, 0x55, 0xe5, 0x86, 0xe4, 0x6f, 0x64, 0xc3, 0x8a, 0x70, 0xc6, 0x8b, 0x3f, 0x54, 0x8d, 0x93, 0xd7, 0x87, 0xb3, 0x99, 0x99, 0x9d, 0x4c, 0x8f, 0x0b, 0xbd, 0x25, 0x81, 0xc2, 0x1e, 0x19, 0xed, 0x00, 0x18, 0xa6, 0xd5, 0xd3, 0xdf, 0x86, 0x42, 0x4b, 0x3a, 0xbc, 0xad, 0x40, 0x19, 0x9d, 0x31, 0x49, 0x5b, 0x61, 0x30, 0x9f, 0x27, 0xc1, 0xbf, 0x55, 0xd4, 0x87, 0xc1, 
};
static const u8 rsa_pss_141_CRT_qInv[] = {
0x56, 0x4b, 0x1e, 0x1f, 0xa0, 0x03, 0xbd, 0xa9, 0x1e, 0x89, 0x09, 0x04, 0x25, 0xaa, 0xc0, 0x5b, 0x91, 0xda, 0x9e, 0xe2, 0x50, 0x61, 0xe7, 0x62, 0x8d, 0x5f, 0x51, 0x30, 0x4a, 0x84, 0x99, 0x2f, 0xdc, 0x33, 0x76, 0x2b, 0xd3, 0x78, 0xa5, 0x9f, 0x03, 0x0a, 0x33, 0x4d, 0x53, 0x2b, 0xd0, 0xda, 0xe8, 0xf2, 0x98, 0xea, 0x9e, 0xd8, 0x44, 0x63, 0x6a, 0xd5, 0xfb, 0x8c, 0xbd, 0xc0, 0x3c, 0xad, 
};


static const rsa_test test_rsa_pss_141_CRT = {
	.name = "rsa_pss_141_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_141_CRT_n,
	.nlen = sizeof(rsa_pss_141_CRT_n),
	.d = (const u8*)&rsa_pss_141_CRT_d,
	.dlen = sizeof(rsa_pss_141_CRT_d),
	.e = (const u8*)&rsa_pss_141_CRT_e,
	.elen = sizeof(rsa_pss_141_CRT_e),
	.p = (const u8*)&rsa_pss_141_CRT_p,
	.plen = sizeof(rsa_pss_141_CRT_p),
	.q = (const u8*)&rsa_pss_141_CRT_q,
	.qlen = sizeof(rsa_pss_141_CRT_q),
	.dP = (const u8*)&rsa_pss_141_CRT_dP,
	.dPlen = sizeof(rsa_pss_141_CRT_dP),
	.dQ = (const u8*)&rsa_pss_141_CRT_dQ,
	.dQlen = sizeof(rsa_pss_141_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_141_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_141_CRT_qInv),
	.m = (const u8*)&rsa_pss_141_CRT_m,
	.mlen = sizeof(rsa_pss_141_CRT_m),
	.res = (const u8*)&rsa_pss_141_CRT_res,
	.reslen = sizeof(rsa_pss_141_CRT_res),
	.salt = (const u8*)&rsa_pss_141_CRT_salt,
	.saltlen = sizeof(rsa_pss_141_CRT_salt),
};
static const u8 rsa_pss_142_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_142_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_142_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_142_m[] = {
0x04, 0x9f, 0x91, 0x54, 0xd8, 0x71, 0xac, 0x4a, 0x7c, 0x7a, 0xb4, 0x53, 0x25, 0xba, 0x75, 0x45, 0xa1, 0xed, 0x08, 0xf7, 0x05, 0x25, 0xb2, 0x66, 0x7c, 0xf1, 
};
static const u8 rsa_pss_142_res[] = {
0x00, 0x47, 0x5b, 0x16, 0x48, 0xf8, 0x14, 0xa8, 0xdc, 0x0a, 0xbd, 0xc3, 0x7b, 0x55, 0x27, 0xf5, 0x43, 0xb6, 0x66, 0xbb, 0x6e, 0x39, 0xd3, 0x0e, 0x5b, 0x49, 0xd3, 0xb8, 0x76, 0xdc, 0xcc, 0x58, 0xea, 0xc1, 0x4e, 0x32, 0xa2, 0xd5, 0x5c, 0x26, 0x16, 0x01, 0x44, 0x56, 0xad, 0x2f, 0x24, 0x6f, 0xc8, 0xe3, 0xd5, 0x60, 0xda, 0x3d, 0xdf, 0x37, 0x9a, 0x1c, 0x0b, 0xd2, 0x00, 0xf1, 0x02, 0x21, 0xdf, 0x07, 0x8c, 0x21, 0x9a, 0x15, 0x1b, 0xc8, 0xd4, 0xec, 0x9d, 0x2f, 0xc2, 0x56, 0x44, 0x67, 0x81, 0x10, 0x14, 0xef, 0x15, 0xd8, 0xea, 0x01, 0xc2, 0xeb, 0xbf, 0xf8, 0xc2, 0xc8, 0xef, 0xab, 0x38, 0x09, 0x6e, 0x55, 0xfc, 0xbe, 0x32, 0x85, 0xc7, 0xaa, 0x55, 0x88, 0x51, 0x25, 0x4f, 0xaf, 0xfa, 0x92, 0xc1, 0xc7, 0x2b, 0x78, 0x75, 0x86, 0x63, 0xef, 0x45, 0x82, 0x84, 0x31, 0x39, 0xd7, 0xa6, 
};
static const u8 rsa_pss_142_salt[] = {
0x37, 0x81, 0x0d, 0xef, 0x10, 0x55, 0xed, 0x92, 0x2b, 0x06, 0x3d, 0xf7, 0x98, 0xde, 0x5d, 0x0a, 0xab, 0xf8, 0x86, 0xee, 
};


static const rsa_test test_rsa_pss_142 = {
	.name = "rsa_pss_142",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_142_n,
	.nlen = sizeof(rsa_pss_142_n),
	.d = (const u8*)&rsa_pss_142_d,
	.dlen = sizeof(rsa_pss_142_d),
	.e = (const u8*)&rsa_pss_142_e,
	.elen = sizeof(rsa_pss_142_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_142_m,
	.mlen = sizeof(rsa_pss_142_m),
	.res = (const u8*)&rsa_pss_142_res,
	.reslen = sizeof(rsa_pss_142_res),
	.salt = (const u8*)&rsa_pss_142_salt,
	.saltlen = sizeof(rsa_pss_142_salt),
};
static const u8 rsa_pss_143_CRT_n[] = {
0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9, 
};
static const u8 rsa_pss_143_CRT_d[] = {
0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1, 
};
static const u8 rsa_pss_143_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_143_CRT_m[] = {
0x04, 0x9f, 0x91, 0x54, 0xd8, 0x71, 0xac, 0x4a, 0x7c, 0x7a, 0xb4, 0x53, 0x25, 0xba, 0x75, 0x45, 0xa1, 0xed, 0x08, 0xf7, 0x05, 0x25, 0xb2, 0x66, 0x7c, 0xf1, 
};
static const u8 rsa_pss_143_CRT_res[] = {
0x00, 0x47, 0x5b, 0x16, 0x48, 0xf8, 0x14, 0xa8, 0xdc, 0x0a, 0xbd, 0xc3, 0x7b, 0x55, 0x27, 0xf5, 0x43, 0xb6, 0x66, 0xbb, 0x6e, 0x39, 0xd3, 0x0e, 0x5b, 0x49, 0xd3, 0xb8, 0x76, 0xdc, 0xcc, 0x58, 0xea, 0xc1, 0x4e, 0x32, 0xa2, 0xd5, 0x5c, 0x26, 0x16, 0x01, 0x44, 0x56, 0xad, 0x2f, 0x24, 0x6f, 0xc8, 0xe3, 0xd5, 0x60, 0xda, 0x3d, 0xdf, 0x37, 0x9a, 0x1c, 0x0b, 0xd2, 0x00, 0xf1, 0x02, 0x21, 0xdf, 0x07, 0x8c, 0x21, 0x9a, 0x15, 0x1b, 0xc8, 0xd4, 0xec, 0x9d, 0x2f, 0xc2, 0x56, 0x44, 0x67, 0x81, 0x10, 0x14, 0xef, 0x15, 0xd8, 0xea, 0x01, 0xc2, 0xeb, 0xbf, 0xf8, 0xc2, 0xc8, 0xef, 0xab, 0x38, 0x09, 0x6e, 0x55, 0xfc, 0xbe, 0x32, 0x85, 0xc7, 0xaa, 0x55, 0x88, 0x51, 0x25, 0x4f, 0xaf, 0xfa, 0x92, 0xc1, 0xc7, 0x2b, 0x78, 0x75, 0x86, 0x63, 0xef, 0x45, 0x82, 0x84, 0x31, 0x39, 0xd7, 0xa6, 
};
static const u8 rsa_pss_143_CRT_salt[] = {
0x37, 0x81, 0x0d, 0xef, 0x10, 0x55, 0xed, 0x92, 0x2b, 0x06, 0x3d, 0xf7, 0x98, 0xde, 0x5d, 0x0a, 0xab, 0xf8, 0x86, 0xee, 
};
static const u8 rsa_pss_143_CRT_p[] = {
0x01, 0x66, 0x01, 0xe9, 0x26, 0xa0, 0xf8, 0xc9, 0xe2, 0x6e, 0xca, 0xb7, 0x69, 0xea, 0x65, 0xa5, 0xe7, 0xc5, 0x2c, 0xc9, 0xe0, 0x80, 0xef, 0x51, 0x94, 0x57, 0xc6, 0x44, 0xda, 0x68, 0x91, 0xc5, 0xa1, 0x04, 0xd3, 0xea, 0x79, 0x55, 0x92, 0x9a, 0x22, 0xe7, 0xc6, 0x8a, 0x7a, 0xf9, 0xfc, 0xad, 0x77, 0x7c, 0x3c, 0xcc, 0x2b, 0x9e, 0x3d, 0x36, 0x50, 0xbc, 0xe4, 0x04, 0x39, 0x9b, 0x7e, 0x59, 0xd1, 
};
static const u8 rsa_pss_143_CRT_q[] = {
0x01, 0x4e, 0xaf, 0xa1, 0xd4, 0xd0, 0x18, 0x4d, 0xa7, 0xe3, 0x1f, 0x87, 0x7d, 0x12, 0x81, 0xdd, 0xda, 0x62, 0x56, 0x64, 0x86, 0x9e, 0x83, 0x79, 0xe6, 0x7a, 0xd3, 0xb7, 0x5e, 0xae, 0x74, 0xa5, 0x80, 0xe9, 0x82, 0x7a, 0xbd, 0x6e, 0xb7, 0xa0, 0x02, 0xcb, 0x54, 0x11, 0xf5, 0x26, 0x67, 0x97, 0x76, 0x8f, 0xb8, 0xe9, 0x5a, 0xe4, 0x0e, 0x3e, 0x8a, 0x01, 0xf3, 0x5f, 0xf8, 0x9e, 0x56, 0xc0, 0x79, 
};
static const u8 rsa_pss_143_CRT_dP[] = {
0xe2, 0x47, 0xcc, 0xe5, 0x04, 0x93, 0x9b, 0x8f, 0x0a, 0x36, 0x09, 0x0d, 0xe2, 0x00, 0x93, 0x87, 0x55, 0xe2, 0x44, 0x4b, 0x29, 0x53, 0x9a, 0x7d, 0xa7, 0xa9, 0x02, 0xf6, 0x05, 0x68, 0x35, 0xc0, 0xdb, 0x7b, 0x52, 0x55, 0x94, 0x97, 0xcf, 0xe2, 0xc6, 0x1a, 0x80, 0x86, 0xd0, 0x21, 0x3c, 0x47, 0x2c, 0x78, 0x85, 0x18, 0x00, 0xb1, 0x71, 0xf6, 0x40, 0x1d, 0xe2, 0xe9, 0xc2, 0x75, 0x6f, 0x31, 
};
static const u8 rsa_pss_143_CRT_dQ[] = {
0xb1, 0x2f, 0xba, 0x75, 0x78, 0x55, 0xe5, 0x86, 0xe4, 0x6f, 0x64, 0xc3, 0x8a, 0x70, 0xc6, 0x8b, 0x3f, 0x54, 0x8d, 0x93, 0xd7, 0x87, 0xb3, 0x99, 0x99, 0x9d, 0x4c, 0x8f, 0x0b, 0xbd, 0x25, 0x81, 0xc2, 0x1e, 0x19, 0xed, 0x00, 0x18, 0xa6, 0xd5, 0xd3, 0xdf, 0x86, 0x42, 0x4b, 0x3a, 0xbc, 0xad, 0x40, 0x19, 0x9d, 0x31, 0x49, 0x5b, 0x61, 0x30, 0x9f, 0x27, 0xc1, 0xbf, 0x55, 0xd4, 0x87, 0xc1, 
};
static const u8 rsa_pss_143_CRT_qInv[] = {
0x56, 0x4b, 0x1e, 0x1f, 0xa0, 0x03, 0xbd, 0xa9, 0x1e, 0x89, 0x09, 0x04, 0x25, 0xaa, 0xc0, 0x5b, 0x91, 0xda, 0x9e, 0xe2, 0x50, 0x61, 0xe7, 0x62, 0x8d, 0x5f, 0x51, 0x30, 0x4a, 0x84, 0x99, 0x2f, 0xdc, 0x33, 0x76, 0x2b, 0xd3, 0x78, 0xa5, 0x9f, 0x03, 0x0a, 0x33, 0x4d, 0x53, 0x2b, 0xd0, 0xda, 0xe8, 0xf2, 0x98, 0xea, 0x9e, 0xd8, 0x44, 0x63, 0x6a, 0xd5, 0xfb, 0x8c, 0xbd, 0xc0, 0x3c, 0xad, 
};


static const rsa_test test_rsa_pss_143_CRT = {
	.name = "rsa_pss_143_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1025,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_143_CRT_n,
	.nlen = sizeof(rsa_pss_143_CRT_n),
	.d = (const u8*)&rsa_pss_143_CRT_d,
	.dlen = sizeof(rsa_pss_143_CRT_d),
	.e = (const u8*)&rsa_pss_143_CRT_e,
	.elen = sizeof(rsa_pss_143_CRT_e),
	.p = (const u8*)&rsa_pss_143_CRT_p,
	.plen = sizeof(rsa_pss_143_CRT_p),
	.q = (const u8*)&rsa_pss_143_CRT_q,
	.qlen = sizeof(rsa_pss_143_CRT_q),
	.dP = (const u8*)&rsa_pss_143_CRT_dP,
	.dPlen = sizeof(rsa_pss_143_CRT_dP),
	.dQ = (const u8*)&rsa_pss_143_CRT_dQ,
	.dQlen = sizeof(rsa_pss_143_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_143_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_143_CRT_qInv),
	.m = (const u8*)&rsa_pss_143_CRT_m,
	.mlen = sizeof(rsa_pss_143_CRT_m),
	.res = (const u8*)&rsa_pss_143_CRT_res,
	.reslen = sizeof(rsa_pss_143_CRT_res),
	.salt = (const u8*)&rsa_pss_143_CRT_salt,
	.saltlen = sizeof(rsa_pss_143_CRT_salt),
};
static const u8 rsa_pss_144_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_144_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_144_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_144_m[] = {
0x59, 0x4b, 0x37, 0x33, 0x3b, 0xbb, 0x2c, 0x84, 0x52, 0x4a, 0x87, 0xc1, 0xa0, 0x1f, 0x75, 0xfc, 0xec, 0x0e, 0x32, 0x56, 0xf1, 0x08, 0xe3, 0x8d, 0xca, 0x36, 0xd7, 0x0d, 0x00, 0x57, 
};
static const u8 rsa_pss_144_res[] = {
0x00, 0x88, 0xb1, 0x35, 0xfb, 0x17, 0x94, 0xb6, 0xb9, 0x6c, 0x4a, 0x3e, 0x67, 0x81, 0x97, 0xf8, 0xca, 0xc5, 0x2b, 0x64, 0xb2, 0xfe, 0x90, 0x7d, 0x6f, 0x27, 0xde, 0x76, 0x11, 0x24, 0x96, 0x4a, 0x99, 0xa0, 0x1a, 0x88, 0x27, 0x40, 0xec, 0xfa, 0xed, 0x6c, 0x01, 0xa4, 0x74, 0x64, 0xbb, 0x05, 0x18, 0x23, 0x13, 0xc0, 0x13, 0x38, 0xa8, 0xcd, 0x09, 0x72, 0x14, 0xcd, 0x68, 0xca, 0x10, 0x3b, 0xd5, 0x7d, 0x3b, 0xc9, 0xe8, 0x16, 0x21, 0x3e, 0x61, 0xd7, 0x84, 0xf1, 0x82, 0x46, 0x7a, 0xbf, 0x8a, 0x01, 0xcf, 0x25, 0x3e, 0x99, 0xa1, 0x56, 0xea, 0xa8, 0xe3, 0xe1, 0xf9, 0x0e, 0x3c, 0x6e, 0x4e, 0x3a, 0xa2, 0xd8, 0x3e, 0xd0, 0x34, 0x5b, 0x89, 0xfa, 0xfc, 0x9c, 0x26, 0x07, 0x7c, 0x14, 0xb6, 0xac, 0x51, 0x45, 0x4f, 0xa2, 0x6e, 0x44, 0x6e, 0x3a, 0x2f, 0x15, 0x3b, 0x2b, 0x16, 0x79, 0x7f, 
};
static const u8 rsa_pss_144_salt[] = {
0xf3, 0x1a, 0xd6, 0xc8, 0xcf, 0x89, 0xdf, 0x78, 0xed, 0x77, 0xfe, 0xac, 0xbc, 0xc2, 0xf8, 0xb0, 0xa8, 0xe4, 0xcf, 0xaa, 
};


static const rsa_test test_rsa_pss_144 = {
	.name = "rsa_pss_144",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_144_n,
	.nlen = sizeof(rsa_pss_144_n),
	.d = (const u8*)&rsa_pss_144_d,
	.dlen = sizeof(rsa_pss_144_d),
	.e = (const u8*)&rsa_pss_144_e,
	.elen = sizeof(rsa_pss_144_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_144_m,
	.mlen = sizeof(rsa_pss_144_m),
	.res = (const u8*)&rsa_pss_144_res,
	.reslen = sizeof(rsa_pss_144_res),
	.salt = (const u8*)&rsa_pss_144_salt,
	.saltlen = sizeof(rsa_pss_144_salt),
};
static const u8 rsa_pss_145_CRT_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_145_CRT_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_145_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_145_CRT_m[] = {
0x59, 0x4b, 0x37, 0x33, 0x3b, 0xbb, 0x2c, 0x84, 0x52, 0x4a, 0x87, 0xc1, 0xa0, 0x1f, 0x75, 0xfc, 0xec, 0x0e, 0x32, 0x56, 0xf1, 0x08, 0xe3, 0x8d, 0xca, 0x36, 0xd7, 0x0d, 0x00, 0x57, 
};
static const u8 rsa_pss_145_CRT_res[] = {
0x00, 0x88, 0xb1, 0x35, 0xfb, 0x17, 0x94, 0xb6, 0xb9, 0x6c, 0x4a, 0x3e, 0x67, 0x81, 0x97, 0xf8, 0xca, 0xc5, 0x2b, 0x64, 0xb2, 0xfe, 0x90, 0x7d, 0x6f, 0x27, 0xde, 0x76, 0x11, 0x24, 0x96, 0x4a, 0x99, 0xa0, 0x1a, 0x88, 0x27, 0x40, 0xec, 0xfa, 0xed, 0x6c, 0x01, 0xa4, 0x74, 0x64, 0xbb, 0x05, 0x18, 0x23, 0x13, 0xc0, 0x13, 0x38, 0xa8, 0xcd, 0x09, 0x72, 0x14, 0xcd, 0x68, 0xca, 0x10, 0x3b, 0xd5, 0x7d, 0x3b, 0xc9, 0xe8, 0x16, 0x21, 0x3e, 0x61, 0xd7, 0x84, 0xf1, 0x82, 0x46, 0x7a, 0xbf, 0x8a, 0x01, 0xcf, 0x25, 0x3e, 0x99, 0xa1, 0x56, 0xea, 0xa8, 0xe3, 0xe1, 0xf9, 0x0e, 0x3c, 0x6e, 0x4e, 0x3a, 0xa2, 0xd8, 0x3e, 0xd0, 0x34, 0x5b, 0x89, 0xfa, 0xfc, 0x9c, 0x26, 0x07, 0x7c, 0x14, 0xb6, 0xac, 0x51, 0x45, 0x4f, 0xa2, 0x6e, 0x44, 0x6e, 0x3a, 0x2f, 0x15, 0x3b, 0x2b, 0x16, 0x79, 0x7f, 
};
static const u8 rsa_pss_145_CRT_salt[] = {
0xf3, 0x1a, 0xd6, 0xc8, 0xcf, 0x89, 0xdf, 0x78, 0xed, 0x77, 0xfe, 0xac, 0xbc, 0xc2, 0xf8, 0xb0, 0xa8, 0xe4, 0xcf, 0xaa, 
};
static const u8 rsa_pss_145_CRT_p[] = {
0x01, 0xbd, 0x36, 0xe1, 0x8e, 0xce, 0x4b, 0x0f, 0xdb, 0x2e, 0x9c, 0x9d, 0x54, 0x8b, 0xd1, 0xa7, 0xd6, 0xe2, 0xc2, 0x1c, 0x6f, 0xdc, 0x35, 0x07, 0x4a, 0x1d, 0x05, 0xb1, 0xc6, 0xc8, 0xb3, 0xd5, 0x58, 0xea, 0x26, 0x39, 0xc9, 0xa9, 0xa4, 0x21, 0x68, 0x01, 0x69, 0x31, 0x72, 0x52, 0x55, 0x8b, 0xd1, 0x48, 0xad, 0x21, 0x5a, 0xac, 0x55, 0x0e, 0x2d, 0xcf, 0x12, 0xa8, 0x2d, 0x0e, 0xbf, 0xe8, 0x53, 
};
static const u8 rsa_pss_145_CRT_q[] = {
0x01, 0xb1, 0xb6, 0x56, 0xad, 0x86, 0xd8, 0xe1, 0x9d, 0x5d, 0xc8, 0x62, 0x92, 0xb3, 0xa1, 0x92, 0xfd, 0xf6, 0xe0, 0xdd, 0x37, 0x87, 0x7b, 0xad, 0x14, 0x82, 0x2f, 0xa0, 0x01, 0x90, 0xca, 0xb2, 0x65, 0xf9, 0x0d, 0x3f, 0x02, 0x05, 0x7b, 0x6f, 0x54, 0xd6, 0xec, 0xb1, 0x44, 0x91, 0xe5, 0xad, 0xea, 0xce, 0xbc, 0x48, 0xbf, 0x0e, 0xbd, 0x2a, 0x2a, 0xd2, 0x6d, 0x40, 0x2e, 0x54, 0xf6, 0x16, 0x51, 
};
static const u8 rsa_pss_145_CRT_dP[] = {
0x1f, 0x27, 0x79, 0xfd, 0x2e, 0x3e, 0x5e, 0x6b, 0xae, 0x05, 0x53, 0x95, 0x18, 0xfb, 0xa0, 0xcd, 0x0e, 0xad, 0x1a, 0xa4, 0x51, 0x3a, 0x7c, 0xba, 0x18, 0xf1, 0xcf, 0x10, 0xe3, 0xf6, 0x81, 0x95, 0x69, 0x3d, 0x27, 0x8a, 0x0f, 0x0e, 0xe7, 0x2f, 0x89, 0xf9, 0xbc, 0x76, 0x0d, 0x80, 0xe2, 0xf9, 0xd0, 0x26, 0x1d, 0x51, 0x65, 0x01, 0xc6, 0xae, 0x39, 0xf1, 0x4a, 0x47, 0x6c, 0xe2, 0xcc, 0xf5, 
};
static const u8 rsa_pss_145_CRT_dQ[] = {
0x01, 0x1a, 0x0d, 0x36, 0x79, 0x4b, 0x04, 0xa8, 0x54, 0xaa, 0xb4, 0xb2, 0x46, 0x2d, 0x43, 0x9a, 0x50, 0x46, 0xc9, 0x1d, 0x94, 0x0b, 0x2b, 0xc6, 0xf7, 0x5b, 0x62, 0x95, 0x6f, 0xef, 0x35, 0xa2, 0xa6, 0xe6, 0x3c, 0x53, 0x09, 0x81, 0x7f, 0x30, 0x7b, 0xbf, 0xf9, 0xd5, 0x9e, 0x7e, 0x33, 0x1b, 0xd3, 0x63, 0xf6, 0xd6, 0x68, 0x49, 0xb1, 0x83, 0x46, 0xad, 0xea, 0x16, 0x9f, 0x0a, 0xe9, 0xae, 0xc1, 
};
static const u8 rsa_pss_145_CRT_qInv[] = {
0x0b, 0x30, 0xf0, 0xec, 0xf5, 0x58, 0x75, 0x2f, 0xb3, 0xa6, 0xce, 0x4b, 0xa2, 0xb8, 0xc6, 0x75, 0xf6, 0x59, 0xeb, 0xa6, 0xc3, 0x76, 0x58, 0x5a, 0x1b, 0x39, 0x71, 0x2d, 0x03, 0x8a, 0xe3, 0xd2, 0xb4, 0x6f, 0xcb, 0x41, 0x8a, 0xe1, 0x5d, 0x09, 0x05, 0xda, 0x64, 0x40, 0xe1, 0x51, 0x3a, 0x30, 0xb9, 0xb7, 0xd6, 0x66, 0x8f, 0xbc, 0x5e, 0x88, 0xe5, 0xab, 0x7a, 0x17, 0x5e, 0x73, 0xba, 0x35, 
};


static const rsa_test test_rsa_pss_145_CRT = {
	.name = "rsa_pss_145_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_145_CRT_n,
	.nlen = sizeof(rsa_pss_145_CRT_n),
	.d = (const u8*)&rsa_pss_145_CRT_d,
	.dlen = sizeof(rsa_pss_145_CRT_d),
	.e = (const u8*)&rsa_pss_145_CRT_e,
	.elen = sizeof(rsa_pss_145_CRT_e),
	.p = (const u8*)&rsa_pss_145_CRT_p,
	.plen = sizeof(rsa_pss_145_CRT_p),
	.q = (const u8*)&rsa_pss_145_CRT_q,
	.qlen = sizeof(rsa_pss_145_CRT_q),
	.dP = (const u8*)&rsa_pss_145_CRT_dP,
	.dPlen = sizeof(rsa_pss_145_CRT_dP),
	.dQ = (const u8*)&rsa_pss_145_CRT_dQ,
	.dQlen = sizeof(rsa_pss_145_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_145_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_145_CRT_qInv),
	.m = (const u8*)&rsa_pss_145_CRT_m,
	.mlen = sizeof(rsa_pss_145_CRT_m),
	.res = (const u8*)&rsa_pss_145_CRT_res,
	.reslen = sizeof(rsa_pss_145_CRT_res),
	.salt = (const u8*)&rsa_pss_145_CRT_salt,
	.saltlen = sizeof(rsa_pss_145_CRT_salt),
};
static const u8 rsa_pss_146_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_146_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_146_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_146_m[] = {
0x8b, 0x76, 0x95, 0x28, 0x88, 0x4a, 0x0d, 0x1f, 0xfd, 0x09, 0x0c, 0xf1, 0x02, 0x99, 0x3e, 0x79, 0x6d, 0xad, 0xcf, 0xbd, 0xdd, 0x38, 0xe4, 0x4f, 0xf6, 0x32, 0x4c, 0xa4, 0x51, 
};
static const u8 rsa_pss_146_res[] = {
0x02, 0xa5, 0xf0, 0xa8, 0x58, 0xa0, 0x86, 0x4a, 0x4f, 0x65, 0x01, 0x7a, 0x7d, 0x69, 0x45, 0x4f, 0x3f, 0x97, 0x3a, 0x29, 0x99, 0x83, 0x9b, 0x7b, 0xbc, 0x48, 0xbf, 0x78, 0x64, 0x11, 0x69, 0x17, 0x95, 0x56, 0xf5, 0x95, 0xfa, 0x41, 0xf6, 0xff, 0x18, 0xe2, 0x86, 0xc2, 0x78, 0x30, 0x79, 0xbc, 0x09, 0x10, 0xee, 0x9c, 0xc3, 0x4f, 0x49, 0xba, 0x68, 0x11, 0x24, 0xf9, 0x23, 0xdf, 0xa8, 0x8f, 0x42, 0x61, 0x41, 0xa3, 0x68, 0xa5, 0xf5, 0xa9, 0x30, 0xc6, 0x28, 0xc2, 0xc3, 0xc2, 0x00, 0xe1, 0x8a, 0x76, 0x44, 0x72, 0x1a, 0x0c, 0xbe, 0xc6, 0xdd, 0x3f, 0x62, 0x79, 0xbd, 0xe3, 0xe8, 0xf2, 0xbe, 0x5e, 0x2d, 0x4e, 0xe5, 0x6f, 0x97, 0xe7, 0xce, 0xaf, 0x33, 0x05, 0x4b, 0xe7, 0x04, 0x2b, 0xd9, 0x1a, 0x63, 0xbb, 0x09, 0xf8, 0x97, 0xbd, 0x41, 0xe8, 0x11, 0x97, 0xde, 0xe9, 0x9b, 0x11, 0xaf, 
};
static const u8 rsa_pss_146_salt[] = {
0xfc, 0xf9, 0xf0, 0xe1, 0xf1, 0x99, 0xa3, 0xd1, 0xd0, 0xda, 0x68, 0x1c, 0x5b, 0x86, 0x06, 0xfc, 0x64, 0x29, 0x39, 0xf7, 
};


static const rsa_test test_rsa_pss_146 = {
	.name = "rsa_pss_146",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_146_n,
	.nlen = sizeof(rsa_pss_146_n),
	.d = (const u8*)&rsa_pss_146_d,
	.dlen = sizeof(rsa_pss_146_d),
	.e = (const u8*)&rsa_pss_146_e,
	.elen = sizeof(rsa_pss_146_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_146_m,
	.mlen = sizeof(rsa_pss_146_m),
	.res = (const u8*)&rsa_pss_146_res,
	.reslen = sizeof(rsa_pss_146_res),
	.salt = (const u8*)&rsa_pss_146_salt,
	.saltlen = sizeof(rsa_pss_146_salt),
};
static const u8 rsa_pss_147_CRT_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_147_CRT_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_147_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_147_CRT_m[] = {
0x8b, 0x76, 0x95, 0x28, 0x88, 0x4a, 0x0d, 0x1f, 0xfd, 0x09, 0x0c, 0xf1, 0x02, 0x99, 0x3e, 0x79, 0x6d, 0xad, 0xcf, 0xbd, 0xdd, 0x38, 0xe4, 0x4f, 0xf6, 0x32, 0x4c, 0xa4, 0x51, 
};
static const u8 rsa_pss_147_CRT_res[] = {
0x02, 0xa5, 0xf0, 0xa8, 0x58, 0xa0, 0x86, 0x4a, 0x4f, 0x65, 0x01, 0x7a, 0x7d, 0x69, 0x45, 0x4f, 0x3f, 0x97, 0x3a, 0x29, 0x99, 0x83, 0x9b, 0x7b, 0xbc, 0x48, 0xbf, 0x78, 0x64, 0x11, 0x69, 0x17, 0x95, 0x56, 0xf5, 0x95, 0xfa, 0x41, 0xf6, 0xff, 0x18, 0xe2, 0x86, 0xc2, 0x78, 0x30, 0x79, 0xbc, 0x09, 0x10, 0xee, 0x9c, 0xc3, 0x4f, 0x49, 0xba, 0x68, 0x11, 0x24, 0xf9, 0x23, 0xdf, 0xa8, 0x8f, 0x42, 0x61, 0x41, 0xa3, 0x68, 0xa5, 0xf5, 0xa9, 0x30, 0xc6, 0x28, 0xc2, 0xc3, 0xc2, 0x00, 0xe1, 0x8a, 0x76, 0x44, 0x72, 0x1a, 0x0c, 0xbe, 0xc6, 0xdd, 0x3f, 0x62, 0x79, 0xbd, 0xe3, 0xe8, 0xf2, 0xbe, 0x5e, 0x2d, 0x4e, 0xe5, 0x6f, 0x97, 0xe7, 0xce, 0xaf, 0x33, 0x05, 0x4b, 0xe7, 0x04, 0x2b, 0xd9, 0x1a, 0x63, 0xbb, 0x09, 0xf8, 0x97, 0xbd, 0x41, 0xe8, 0x11, 0x97, 0xde, 0xe9, 0x9b, 0x11, 0xaf, 
};
static const u8 rsa_pss_147_CRT_salt[] = {
0xfc, 0xf9, 0xf0, 0xe1, 0xf1, 0x99, 0xa3, 0xd1, 0xd0, 0xda, 0x68, 0x1c, 0x5b, 0x86, 0x06, 0xfc, 0x64, 0x29, 0x39, 0xf7, 
};
static const u8 rsa_pss_147_CRT_p[] = {
0x01, 0xbd, 0x36, 0xe1, 0x8e, 0xce, 0x4b, 0x0f, 0xdb, 0x2e, 0x9c, 0x9d, 0x54, 0x8b, 0xd1, 0xa7, 0xd6, 0xe2, 0xc2, 0x1c, 0x6f, 0xdc, 0x35, 0x07, 0x4a, 0x1d, 0x05, 0xb1, 0xc6, 0xc8, 0xb3, 0xd5, 0x58, 0xea, 0x26, 0x39, 0xc9, 0xa9, 0xa4, 0x21, 0x68, 0x01, 0x69, 0x31, 0x72, 0x52, 0x55, 0x8b, 0xd1, 0x48, 0xad, 0x21, 0x5a, 0xac, 0x55, 0x0e, 0x2d, 0xcf, 0x12, 0xa8, 0x2d, 0x0e, 0xbf, 0xe8, 0x53, 
};
static const u8 rsa_pss_147_CRT_q[] = {
0x01, 0xb1, 0xb6, 0x56, 0xad, 0x86, 0xd8, 0xe1, 0x9d, 0x5d, 0xc8, 0x62, 0x92, 0xb3, 0xa1, 0x92, 0xfd, 0xf6, 0xe0, 0xdd, 0x37, 0x87, 0x7b, 0xad, 0x14, 0x82, 0x2f, 0xa0, 0x01, 0x90, 0xca, 0xb2, 0x65, 0xf9, 0x0d, 0x3f, 0x02, 0x05, 0x7b, 0x6f, 0x54, 0xd6, 0xec, 0xb1, 0x44, 0x91, 0xe5, 0xad, 0xea, 0xce, 0xbc, 0x48, 0xbf, 0x0e, 0xbd, 0x2a, 0x2a, 0xd2, 0x6d, 0x40, 0x2e, 0x54, 0xf6, 0x16, 0x51, 
};
static const u8 rsa_pss_147_CRT_dP[] = {
0x1f, 0x27, 0x79, 0xfd, 0x2e, 0x3e, 0x5e, 0x6b, 0xae, 0x05, 0x53, 0x95, 0x18, 0xfb, 0xa0, 0xcd, 0x0e, 0xad, 0x1a, 0xa4, 0x51, 0x3a, 0x7c, 0xba, 0x18, 0xf1, 0xcf, 0x10, 0xe3, 0xf6, 0x81, 0x95, 0x69, 0x3d, 0x27, 0x8a, 0x0f, 0x0e, 0xe7, 0x2f, 0x89, 0xf9, 0xbc, 0x76, 0x0d, 0x80, 0xe2, 0xf9, 0xd0, 0x26, 0x1d, 0x51, 0x65, 0x01, 0xc6, 0xae, 0x39, 0xf1, 0x4a, 0x47, 0x6c, 0xe2, 0xcc, 0xf5, 
};
static const u8 rsa_pss_147_CRT_dQ[] = {
0x01, 0x1a, 0x0d, 0x36, 0x79, 0x4b, 0x04, 0xa8, 0x54, 0xaa, 0xb4, 0xb2, 0x46, 0x2d, 0x43, 0x9a, 0x50, 0x46, 0xc9, 0x1d, 0x94, 0x0b, 0x2b, 0xc6, 0xf7, 0x5b, 0x62, 0x95, 0x6f, 0xef, 0x35, 0xa2, 0xa6, 0xe6, 0x3c, 0x53, 0x09, 0x81, 0x7f, 0x30, 0x7b, 0xbf, 0xf9, 0xd5, 0x9e, 0x7e, 0x33, 0x1b, 0xd3, 0x63, 0xf6, 0xd6, 0x68, 0x49, 0xb1, 0x83, 0x46, 0xad, 0xea, 0x16, 0x9f, 0x0a, 0xe9, 0xae, 0xc1, 
};
static const u8 rsa_pss_147_CRT_qInv[] = {
0x0b, 0x30, 0xf0, 0xec, 0xf5, 0x58, 0x75, 0x2f, 0xb3, 0xa6, 0xce, 0x4b, 0xa2, 0xb8, 0xc6, 0x75, 0xf6, 0x59, 0xeb, 0xa6, 0xc3, 0x76, 0x58, 0x5a, 0x1b, 0x39, 0x71, 0x2d, 0x03, 0x8a, 0xe3, 0xd2, 0xb4, 0x6f, 0xcb, 0x41, 0x8a, 0xe1, 0x5d, 0x09, 0x05, 0xda, 0x64, 0x40, 0xe1, 0x51, 0x3a, 0x30, 0xb9, 0xb7, 0xd6, 0x66, 0x8f, 0xbc, 0x5e, 0x88, 0xe5, 0xab, 0x7a, 0x17, 0x5e, 0x73, 0xba, 0x35, 
};


static const rsa_test test_rsa_pss_147_CRT = {
	.name = "rsa_pss_147_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_147_CRT_n,
	.nlen = sizeof(rsa_pss_147_CRT_n),
	.d = (const u8*)&rsa_pss_147_CRT_d,
	.dlen = sizeof(rsa_pss_147_CRT_d),
	.e = (const u8*)&rsa_pss_147_CRT_e,
	.elen = sizeof(rsa_pss_147_CRT_e),
	.p = (const u8*)&rsa_pss_147_CRT_p,
	.plen = sizeof(rsa_pss_147_CRT_p),
	.q = (const u8*)&rsa_pss_147_CRT_q,
	.qlen = sizeof(rsa_pss_147_CRT_q),
	.dP = (const u8*)&rsa_pss_147_CRT_dP,
	.dPlen = sizeof(rsa_pss_147_CRT_dP),
	.dQ = (const u8*)&rsa_pss_147_CRT_dQ,
	.dQlen = sizeof(rsa_pss_147_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_147_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_147_CRT_qInv),
	.m = (const u8*)&rsa_pss_147_CRT_m,
	.mlen = sizeof(rsa_pss_147_CRT_m),
	.res = (const u8*)&rsa_pss_147_CRT_res,
	.reslen = sizeof(rsa_pss_147_CRT_res),
	.salt = (const u8*)&rsa_pss_147_CRT_salt,
	.saltlen = sizeof(rsa_pss_147_CRT_salt),
};
static const u8 rsa_pss_148_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_148_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_148_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_148_m[] = {
0x1a, 0xbd, 0xba, 0x48, 0x9c, 0x5a, 0xda, 0x2f, 0x99, 0x5e, 0xd1, 0x6f, 0x19, 0xd5, 0xa9, 0x4d, 0x9e, 0x6e, 0xc3, 0x4a, 0x8d, 0x84, 0xf8, 0x45, 0x57, 0xd2, 0x6e, 0x5e, 0xf9, 0xb0, 0x2b, 0x22, 0x88, 0x7e, 0x3f, 0x9a, 0x4b, 0x69, 0x0a, 0xd1, 0x14, 0x92, 0x09, 0xc2, 0x0c, 0x61, 0x43, 0x1f, 0x0c, 0x01, 0x7c, 0x36, 0xc2, 0x65, 0x7b, 0x35, 0xd7, 0xb0, 0x7d, 0x3f, 0x5a, 0xd8, 0x70, 0x85, 0x07, 0xa9, 0xc1, 0xb8, 0x31, 0xdf, 0x83, 0x5a, 0x56, 0xf8, 0x31, 0x07, 0x18, 0x14, 0xea, 0x5d, 0x3d, 0x8d, 0x8f, 0x6a, 0xde, 0x40, 0xcb, 0xa3, 0x8b, 0x42, 0xdb, 0x7a, 0x2d, 0x3d, 0x7a, 0x29, 0xc8, 0xf0, 0xa7, 0x9a, 0x78, 0x38, 0xcf, 0x58, 0xa9, 0x75, 0x7f, 0xa2, 0xfe, 0x4c, 0x40, 0xdf, 0x9b, 0xaa, 0x19, 0x3b, 0xfc, 0x6f, 0x92, 0xb1, 0x23, 0xad, 0x57, 0xb0, 0x7a, 0xce, 0x3e, 0x6a, 0xc0, 0x68, 0xc9, 0xf1, 0x06, 0xaf, 0xd9, 0xee, 0xb0, 0x3b, 0x4f, 0x37, 0xc2, 0x5d, 0xbf, 0xbc, 0xfb, 0x30, 0x71, 0xf6, 0xf9, 0x77, 0x17, 0x66, 0xd0, 0x72, 0xf3, 0xbb, 0x07, 0x0a, 0xf6, 0x60, 0x55, 0x32, 0x97, 0x3a, 0xe2, 0x50, 0x51, 
};
static const u8 rsa_pss_148_res[] = {
0x02, 0x44, 0xbc, 0xd1, 0xc8, 0xc1, 0x69, 0x55, 0x73, 0x6c, 0x80, 0x3b, 0xe4, 0x01, 0x27, 0x2e, 0x18, 0xcb, 0x99, 0x08, 0x11, 0xb1, 0x4f, 0x72, 0xdb, 0x96, 0x41, 0x24, 0xd5, 0xfa, 0x76, 0x06, 0x49, 0xcb, 0xb5, 0x7a, 0xfb, 0x87, 0x55, 0xdb, 0xb6, 0x2b, 0xf5, 0x1f, 0x46, 0x6c, 0xf2, 0x3a, 0x0a, 0x16, 0x07, 0x57, 0x6e, 0x98, 0x3d, 0x77, 0x8f, 0xce, 0xff, 0xa9, 0x2d, 0xf7, 0x54, 0x8a, 0xea, 0x8e, 0xa4, 0xec, 0xad, 0x2c, 0x29, 0xdd, 0x9f, 0x95, 0xbc, 0x07, 0xfe, 0x91, 0xec, 0xf8, 0xbe, 0xe2, 0x55, 0xbf, 0xe8, 0x76, 0x2f, 0xd7, 0x69, 0x0a, 0xa9, 0xbf, 0xa4, 0xfa, 0x08, 0x49, 0xef, 0x72, 0x8c, 0x2c, 0x42, 0xc4, 0x53, 0x23, 0x64, 0x52, 0x2d, 0xf2, 0xab, 0x7f, 0x9f, 0x8a, 0x03, 0xb6, 0x3f, 0x7a, 0x49, 0x91, 0x75, 0x82, 0x86, 0x68, 0xf5, 0xef, 0x5a, 0x29, 0xe3, 0x80, 0x2c, 
};
static const u8 rsa_pss_148_salt[] = {
0x98, 0x6e, 0x7c, 0x43, 0xdb, 0xb6, 0x71, 0xbd, 0x41, 0xb9, 0xa7, 0xf4, 0xb6, 0xaf, 0xc8, 0x0e, 0x80, 0x5f, 0x24, 0x23, 
};


static const rsa_test test_rsa_pss_148 = {
	.name = "rsa_pss_148",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_148_n,
	.nlen = sizeof(rsa_pss_148_n),
	.d = (const u8*)&rsa_pss_148_d,
	.dlen = sizeof(rsa_pss_148_d),
	.e = (const u8*)&rsa_pss_148_e,
	.elen = sizeof(rsa_pss_148_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_148_m,
	.mlen = sizeof(rsa_pss_148_m),
	.res = (const u8*)&rsa_pss_148_res,
	.reslen = sizeof(rsa_pss_148_res),
	.salt = (const u8*)&rsa_pss_148_salt,
	.saltlen = sizeof(rsa_pss_148_salt),
};
static const u8 rsa_pss_149_CRT_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_149_CRT_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_149_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_149_CRT_m[] = {
0x1a, 0xbd, 0xba, 0x48, 0x9c, 0x5a, 0xda, 0x2f, 0x99, 0x5e, 0xd1, 0x6f, 0x19, 0xd5, 0xa9, 0x4d, 0x9e, 0x6e, 0xc3, 0x4a, 0x8d, 0x84, 0xf8, 0x45, 0x57, 0xd2, 0x6e, 0x5e, 0xf9, 0xb0, 0x2b, 0x22, 0x88, 0x7e, 0x3f, 0x9a, 0x4b, 0x69, 0x0a, 0xd1, 0x14, 0x92, 0x09, 0xc2, 0x0c, 0x61, 0x43, 0x1f, 0x0c, 0x01, 0x7c, 0x36, 0xc2, 0x65, 0x7b, 0x35, 0xd7, 0xb0, 0x7d, 0x3f, 0x5a, 0xd8, 0x70, 0x85, 0x07, 0xa9, 0xc1, 0xb8, 0x31, 0xdf, 0x83, 0x5a, 0x56, 0xf8, 0x31, 0x07, 0x18, 0x14, 0xea, 0x5d, 0x3d, 0x8d, 0x8f, 0x6a, 0xde, 0x40, 0xcb, 0xa3, 0x8b, 0x42, 0xdb, 0x7a, 0x2d, 0x3d, 0x7a, 0x29, 0xc8, 0xf0, 0xa7, 0x9a, 0x78, 0x38, 0xcf, 0x58, 0xa9, 0x75, 0x7f, 0xa2, 0xfe, 0x4c, 0x40, 0xdf, 0x9b, 0xaa, 0x19, 0x3b, 0xfc, 0x6f, 0x92, 0xb1, 0x23, 0xad, 0x57, 0xb0, 0x7a, 0xce, 0x3e, 0x6a, 0xc0, 0x68, 0xc9, 0xf1, 0x06, 0xaf, 0xd9, 0xee, 0xb0, 0x3b, 0x4f, 0x37, 0xc2, 0x5d, 0xbf, 0xbc, 0xfb, 0x30, 0x71, 0xf6, 0xf9, 0x77, 0x17, 0x66, 0xd0, 0x72, 0xf3, 0xbb, 0x07, 0x0a, 0xf6, 0x60, 0x55, 0x32, 0x97, 0x3a, 0xe2, 0x50, 0x51, 
};
static const u8 rsa_pss_149_CRT_res[] = {
0x02, 0x44, 0xbc, 0xd1, 0xc8, 0xc1, 0x69, 0x55, 0x73, 0x6c, 0x80, 0x3b, 0xe4, 0x01, 0x27, 0x2e, 0x18, 0xcb, 0x99, 0x08, 0x11, 0xb1, 0x4f, 0x72, 0xdb, 0x96, 0x41, 0x24, 0xd5, 0xfa, 0x76, 0x06, 0x49, 0xcb, 0xb5, 0x7a, 0xfb, 0x87, 0x55, 0xdb, 0xb6, 0x2b, 0xf5, 0x1f, 0x46, 0x6c, 0xf2, 0x3a, 0x0a, 0x16, 0x07, 0x57, 0x6e, 0x98, 0x3d, 0x77, 0x8f, 0xce, 0xff, 0xa9, 0x2d, 0xf7, 0x54, 0x8a, 0xea, 0x8e, 0xa4, 0xec, 0xad, 0x2c, 0x29, 0xdd, 0x9f, 0x95, 0xbc, 0x07, 0xfe, 0x91, 0xec, 0xf8, 0xbe, 0xe2, 0x55, 0xbf, 0xe8, 0x76, 0x2f, 0xd7, 0x69, 0x0a, 0xa9, 0xbf, 0xa4, 0xfa, 0x08, 0x49, 0xef, 0x72, 0x8c, 0x2c, 0x42, 0xc4, 0x53, 0x23, 0x64, 0x52, 0x2d, 0xf2, 0xab, 0x7f, 0x9f, 0x8a, 0x03, 0xb6, 0x3f, 0x7a, 0x49, 0x91, 0x75, 0x82, 0x86, 0x68, 0xf5, 0xef, 0x5a, 0x29, 0xe3, 0x80, 0x2c, 
};
static const u8 rsa_pss_149_CRT_salt[] = {
0x98, 0x6e, 0x7c, 0x43, 0xdb, 0xb6, 0x71, 0xbd, 0x41, 0xb9, 0xa7, 0xf4, 0xb6, 0xaf, 0xc8, 0x0e, 0x80, 0x5f, 0x24, 0x23, 
};
static const u8 rsa_pss_149_CRT_p[] = {
0x01, 0xbd, 0x36, 0xe1, 0x8e, 0xce, 0x4b, 0x0f, 0xdb, 0x2e, 0x9c, 0x9d, 0x54, 0x8b, 0xd1, 0xa7, 0xd6, 0xe2, 0xc2, 0x1c, 0x6f, 0xdc, 0x35, 0x07, 0x4a, 0x1d, 0x05, 0xb1, 0xc6, 0xc8, 0xb3, 0xd5, 0x58, 0xea, 0x26, 0x39, 0xc9, 0xa9, 0xa4, 0x21, 0x68, 0x01, 0x69, 0x31, 0x72, 0x52, 0x55, 0x8b, 0xd1, 0x48, 0xad, 0x21, 0x5a, 0xac, 0x55, 0x0e, 0x2d, 0xcf, 0x12, 0xa8, 0x2d, 0x0e, 0xbf, 0xe8, 0x53, 
};
static const u8 rsa_pss_149_CRT_q[] = {
0x01, 0xb1, 0xb6, 0x56, 0xad, 0x86, 0xd8, 0xe1, 0x9d, 0x5d, 0xc8, 0x62, 0x92, 0xb3, 0xa1, 0x92, 0xfd, 0xf6, 0xe0, 0xdd, 0x37, 0x87, 0x7b, 0xad, 0x14, 0x82, 0x2f, 0xa0, 0x01, 0x90, 0xca, 0xb2, 0x65, 0xf9, 0x0d, 0x3f, 0x02, 0x05, 0x7b, 0x6f, 0x54, 0xd6, 0xec, 0xb1, 0x44, 0x91, 0xe5, 0xad, 0xea, 0xce, 0xbc, 0x48, 0xbf, 0x0e, 0xbd, 0x2a, 0x2a, 0xd2, 0x6d, 0x40, 0x2e, 0x54, 0xf6, 0x16, 0x51, 
};
static const u8 rsa_pss_149_CRT_dP[] = {
0x1f, 0x27, 0x79, 0xfd, 0x2e, 0x3e, 0x5e, 0x6b, 0xae, 0x05, 0x53, 0x95, 0x18, 0xfb, 0xa0, 0xcd, 0x0e, 0xad, 0x1a, 0xa4, 0x51, 0x3a, 0x7c, 0xba, 0x18, 0xf1, 0xcf, 0x10, 0xe3, 0xf6, 0x81, 0x95, 0x69, 0x3d, 0x27, 0x8a, 0x0f, 0x0e, 0xe7, 0x2f, 0x89, 0xf9, 0xbc, 0x76, 0x0d, 0x80, 0xe2, 0xf9, 0xd0, 0x26, 0x1d, 0x51, 0x65, 0x01, 0xc6, 0xae, 0x39, 0xf1, 0x4a, 0x47, 0x6c, 0xe2, 0xcc, 0xf5, 
};
static const u8 rsa_pss_149_CRT_dQ[] = {
0x01, 0x1a, 0x0d, 0x36, 0x79, 0x4b, 0x04, 0xa8, 0x54, 0xaa, 0xb4, 0xb2, 0x46, 0x2d, 0x43, 0x9a, 0x50, 0x46, 0xc9, 0x1d, 0x94, 0x0b, 0x2b, 0xc6, 0xf7, 0x5b, 0x62, 0x95, 0x6f, 0xef, 0x35, 0xa2, 0xa6, 0xe6, 0x3c, 0x53, 0x09, 0x81, 0x7f, 0x30, 0x7b, 0xbf, 0xf9, 0xd5, 0x9e, 0x7e, 0x33, 0x1b, 0xd3, 0x63, 0xf6, 0xd6, 0x68, 0x49, 0xb1, 0x83, 0x46, 0xad, 0xea, 0x16, 0x9f, 0x0a, 0xe9, 0xae, 0xc1, 
};
static const u8 rsa_pss_149_CRT_qInv[] = {
0x0b, 0x30, 0xf0, 0xec, 0xf5, 0x58, 0x75, 0x2f, 0xb3, 0xa6, 0xce, 0x4b, 0xa2, 0xb8, 0xc6, 0x75, 0xf6, 0x59, 0xeb, 0xa6, 0xc3, 0x76, 0x58, 0x5a, 0x1b, 0x39, 0x71, 0x2d, 0x03, 0x8a, 0xe3, 0xd2, 0xb4, 0x6f, 0xcb, 0x41, 0x8a, 0xe1, 0x5d, 0x09, 0x05, 0xda, 0x64, 0x40, 0xe1, 0x51, 0x3a, 0x30, 0xb9, 0xb7, 0xd6, 0x66, 0x8f, 0xbc, 0x5e, 0x88, 0xe5, 0xab, 0x7a, 0x17, 0x5e, 0x73, 0xba, 0x35, 
};


static const rsa_test test_rsa_pss_149_CRT = {
	.name = "rsa_pss_149_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_149_CRT_n,
	.nlen = sizeof(rsa_pss_149_CRT_n),
	.d = (const u8*)&rsa_pss_149_CRT_d,
	.dlen = sizeof(rsa_pss_149_CRT_d),
	.e = (const u8*)&rsa_pss_149_CRT_e,
	.elen = sizeof(rsa_pss_149_CRT_e),
	.p = (const u8*)&rsa_pss_149_CRT_p,
	.plen = sizeof(rsa_pss_149_CRT_p),
	.q = (const u8*)&rsa_pss_149_CRT_q,
	.qlen = sizeof(rsa_pss_149_CRT_q),
	.dP = (const u8*)&rsa_pss_149_CRT_dP,
	.dPlen = sizeof(rsa_pss_149_CRT_dP),
	.dQ = (const u8*)&rsa_pss_149_CRT_dQ,
	.dQlen = sizeof(rsa_pss_149_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_149_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_149_CRT_qInv),
	.m = (const u8*)&rsa_pss_149_CRT_m,
	.mlen = sizeof(rsa_pss_149_CRT_m),
	.res = (const u8*)&rsa_pss_149_CRT_res,
	.reslen = sizeof(rsa_pss_149_CRT_res),
	.salt = (const u8*)&rsa_pss_149_CRT_salt,
	.saltlen = sizeof(rsa_pss_149_CRT_salt),
};
static const u8 rsa_pss_150_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_150_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_150_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_150_m[] = {
0x8f, 0xb4, 0x31, 0xf5, 0xee, 0x79, 0x2b, 0x6c, 0x2a, 0xc7, 0xdb, 0x53, 0xcc, 0x42, 0x86, 0x55, 0xae, 0xb3, 0x2d, 0x03, 0xf4, 0xe8, 0x89, 0xc5, 0xc2, 0x5d, 0xe6, 0x83, 0xc4, 0x61, 0xb5, 0x3a, 0xcf, 0x89, 0xf9, 0xf8, 0xd3, 0xaa, 0xbd, 0xf6, 0xb9, 0xf0, 0xc2, 0xa1, 0xde, 0x12, 0xe1, 0x5b, 0x49, 0xed, 0xb3, 0x91, 0x9a, 0x65, 0x2f, 0xe9, 0x49, 0x1c, 0x25, 0xa7, 0xfc, 0xe1, 0xf7, 0x22, 0xc2, 0x54, 0x36, 0x08, 0xb6, 0x9d, 0xc3, 0x75, 0xec, 
};
static const u8 rsa_pss_150_res[] = {
0x01, 0x96, 0xf1, 0x2a, 0x00, 0x5b, 0x98, 0x12, 0x9c, 0x8d, 0xf1, 0x3c, 0x4c, 0xb1, 0x6f, 0x8a, 0xa8, 0x87, 0xd3, 0xc4, 0x0d, 0x96, 0xdf, 0x3a, 0x88, 0xe7, 0x53, 0x2e, 0xf3, 0x9c, 0xd9, 0x92, 0xf2, 0x73, 0xab, 0xc3, 0x70, 0xbc, 0x1b, 0xe6, 0xf0, 0x97, 0xcf, 0xeb, 0xbf, 0x01, 0x18, 0xfd, 0x9e, 0xf4, 0xb9, 0x27, 0x15, 0x5f, 0x3d, 0xf2, 0x2b, 0x90, 0x4d, 0x90, 0x70, 0x2d, 0x1f, 0x7b, 0xa7, 0xa5, 0x2b, 0xed, 0x8b, 0x89, 0x42, 0xf4, 0x12, 0xcd, 0x7b, 0xd6, 0x76, 0xc9, 0xd1, 0x8e, 0x17, 0x03, 0x91, 0xdc, 0xd3, 0x45, 0xc0, 0x6a, 0x73, 0x09, 0x64, 0xb3, 0xf3, 0x0b, 0xcc, 0xe0, 0xbb, 0x20, 0xba, 0x10, 0x6f, 0x9a, 0xb0, 0xee, 0xb3, 0x9c, 0xf8, 0xa6, 0x60, 0x7f, 0x75, 0xc0, 0x34, 0x7f, 0x0a, 0xf7, 0x9f, 0x16, 0xaf, 0xa0, 0x81, 0xd2, 0xc9, 0x2d, 0x1e, 0xe6, 0xf8, 0x36, 0xb8, 
};
static const u8 rsa_pss_150_salt[] = {
0xf8, 0x31, 0x2d, 0x9c, 0x8e, 0xea, 0x13, 0xec, 0x0a, 0x4c, 0x7b, 0x98, 0x12, 0x0c, 0x87, 0x50, 0x90, 0x87, 0xc4, 0x78, 
};


static const rsa_test test_rsa_pss_150 = {
	.name = "rsa_pss_150",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_150_n,
	.nlen = sizeof(rsa_pss_150_n),
	.d = (const u8*)&rsa_pss_150_d,
	.dlen = sizeof(rsa_pss_150_d),
	.e = (const u8*)&rsa_pss_150_e,
	.elen = sizeof(rsa_pss_150_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_150_m,
	.mlen = sizeof(rsa_pss_150_m),
	.res = (const u8*)&rsa_pss_150_res,
	.reslen = sizeof(rsa_pss_150_res),
	.salt = (const u8*)&rsa_pss_150_salt,
	.saltlen = sizeof(rsa_pss_150_salt),
};
static const u8 rsa_pss_151_CRT_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_151_CRT_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_151_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_151_CRT_m[] = {
0x8f, 0xb4, 0x31, 0xf5, 0xee, 0x79, 0x2b, 0x6c, 0x2a, 0xc7, 0xdb, 0x53, 0xcc, 0x42, 0x86, 0x55, 0xae, 0xb3, 0x2d, 0x03, 0xf4, 0xe8, 0x89, 0xc5, 0xc2, 0x5d, 0xe6, 0x83, 0xc4, 0x61, 0xb5, 0x3a, 0xcf, 0x89, 0xf9, 0xf8, 0xd3, 0xaa, 0xbd, 0xf6, 0xb9, 0xf0, 0xc2, 0xa1, 0xde, 0x12, 0xe1, 0x5b, 0x49, 0xed, 0xb3, 0x91, 0x9a, 0x65, 0x2f, 0xe9, 0x49, 0x1c, 0x25, 0xa7, 0xfc, 0xe1, 0xf7, 0x22, 0xc2, 0x54, 0x36, 0x08, 0xb6, 0x9d, 0xc3, 0x75, 0xec, 
};
static const u8 rsa_pss_151_CRT_res[] = {
0x01, 0x96, 0xf1, 0x2a, 0x00, 0x5b, 0x98, 0x12, 0x9c, 0x8d, 0xf1, 0x3c, 0x4c, 0xb1, 0x6f, 0x8a, 0xa8, 0x87, 0xd3, 0xc4, 0x0d, 0x96, 0xdf, 0x3a, 0x88, 0xe7, 0x53, 0x2e, 0xf3, 0x9c, 0xd9, 0x92, 0xf2, 0x73, 0xab, 0xc3, 0x70, 0xbc, 0x1b, 0xe6, 0xf0, 0x97, 0xcf, 0xeb, 0xbf, 0x01, 0x18, 0xfd, 0x9e, 0xf4, 0xb9, 0x27, 0x15, 0x5f, 0x3d, 0xf2, 0x2b, 0x90, 0x4d, 0x90, 0x70, 0x2d, 0x1f, 0x7b, 0xa7, 0xa5, 0x2b, 0xed, 0x8b, 0x89, 0x42, 0xf4, 0x12, 0xcd, 0x7b, 0xd6, 0x76, 0xc9, 0xd1, 0x8e, 0x17, 0x03, 0x91, 0xdc, 0xd3, 0x45, 0xc0, 0x6a, 0x73, 0x09, 0x64, 0xb3, 0xf3, 0x0b, 0xcc, 0xe0, 0xbb, 0x20, 0xba, 0x10, 0x6f, 0x9a, 0xb0, 0xee, 0xb3, 0x9c, 0xf8, 0xa6, 0x60, 0x7f, 0x75, 0xc0, 0x34, 0x7f, 0x0a, 0xf7, 0x9f, 0x16, 0xaf, 0xa0, 0x81, 0xd2, 0xc9, 0x2d, 0x1e, 0xe6, 0xf8, 0x36, 0xb8, 
};
static const u8 rsa_pss_151_CRT_salt[] = {
0xf8, 0x31, 0x2d, 0x9c, 0x8e, 0xea, 0x13, 0xec, 0x0a, 0x4c, 0x7b, 0x98, 0x12, 0x0c, 0x87, 0x50, 0x90, 0x87, 0xc4, 0x78, 
};
static const u8 rsa_pss_151_CRT_p[] = {
0x01, 0xbd, 0x36, 0xe1, 0x8e, 0xce, 0x4b, 0x0f, 0xdb, 0x2e, 0x9c, 0x9d, 0x54, 0x8b, 0xd1, 0xa7, 0xd6, 0xe2, 0xc2, 0x1c, 0x6f, 0xdc, 0x35, 0x07, 0x4a, 0x1d, 0x05, 0xb1, 0xc6, 0xc8, 0xb3, 0xd5, 0x58, 0xea, 0x26, 0x39, 0xc9, 0xa9, 0xa4, 0x21, 0x68, 0x01, 0x69, 0x31, 0x72, 0x52, 0x55, 0x8b, 0xd1, 0x48, 0xad, 0x21, 0x5a, 0xac, 0x55, 0x0e, 0x2d, 0xcf, 0x12, 0xa8, 0x2d, 0x0e, 0xbf, 0xe8, 0x53, 
};
static const u8 rsa_pss_151_CRT_q[] = {
0x01, 0xb1, 0xb6, 0x56, 0xad, 0x86, 0xd8, 0xe1, 0x9d, 0x5d, 0xc8, 0x62, 0x92, 0xb3, 0xa1, 0x92, 0xfd, 0xf6, 0xe0, 0xdd, 0x37, 0x87, 0x7b, 0xad, 0x14, 0x82, 0x2f, 0xa0, 0x01, 0x90, 0xca, 0xb2, 0x65, 0xf9, 0x0d, 0x3f, 0x02, 0x05, 0x7b, 0x6f, 0x54, 0xd6, 0xec, 0xb1, 0x44, 0x91, 0xe5, 0xad, 0xea, 0xce, 0xbc, 0x48, 0xbf, 0x0e, 0xbd, 0x2a, 0x2a, 0xd2, 0x6d, 0x40, 0x2e, 0x54, 0xf6, 0x16, 0x51, 
};
static const u8 rsa_pss_151_CRT_dP[] = {
0x1f, 0x27, 0x79, 0xfd, 0x2e, 0x3e, 0x5e, 0x6b, 0xae, 0x05, 0x53, 0x95, 0x18, 0xfb, 0xa0, 0xcd, 0x0e, 0xad, 0x1a, 0xa4, 0x51, 0x3a, 0x7c, 0xba, 0x18, 0xf1, 0xcf, 0x10, 0xe3, 0xf6, 0x81, 0x95, 0x69, 0x3d, 0x27, 0x8a, 0x0f, 0x0e, 0xe7, 0x2f, 0x89, 0xf9, 0xbc, 0x76, 0x0d, 0x80, 0xe2, 0xf9, 0xd0, 0x26, 0x1d, 0x51, 0x65, 0x01, 0xc6, 0xae, 0x39, 0xf1, 0x4a, 0x47, 0x6c, 0xe2, 0xcc, 0xf5, 
};
static const u8 rsa_pss_151_CRT_dQ[] = {
0x01, 0x1a, 0x0d, 0x36, 0x79, 0x4b, 0x04, 0xa8, 0x54, 0xaa, 0xb4, 0xb2, 0x46, 0x2d, 0x43, 0x9a, 0x50, 0x46, 0xc9, 0x1d, 0x94, 0x0b, 0x2b, 0xc6, 0xf7, 0x5b, 0x62, 0x95, 0x6f, 0xef, 0x35, 0xa2, 0xa6, 0xe6, 0x3c, 0x53, 0x09, 0x81, 0x7f, 0x30, 0x7b, 0xbf, 0xf9, 0xd5, 0x9e, 0x7e, 0x33, 0x1b, 0xd3, 0x63, 0xf6, 0xd6, 0x68, 0x49, 0xb1, 0x83, 0x46, 0xad, 0xea, 0x16, 0x9f, 0x0a, 0xe9, 0xae, 0xc1, 
};
static const u8 rsa_pss_151_CRT_qInv[] = {
0x0b, 0x30, 0xf0, 0xec, 0xf5, 0x58, 0x75, 0x2f, 0xb3, 0xa6, 0xce, 0x4b, 0xa2, 0xb8, 0xc6, 0x75, 0xf6, 0x59, 0xeb, 0xa6, 0xc3, 0x76, 0x58, 0x5a, 0x1b, 0x39, 0x71, 0x2d, 0x03, 0x8a, 0xe3, 0xd2, 0xb4, 0x6f, 0xcb, 0x41, 0x8a, 0xe1, 0x5d, 0x09, 0x05, 0xda, 0x64, 0x40, 0xe1, 0x51, 0x3a, 0x30, 0xb9, 0xb7, 0xd6, 0x66, 0x8f, 0xbc, 0x5e, 0x88, 0xe5, 0xab, 0x7a, 0x17, 0x5e, 0x73, 0xba, 0x35, 
};


static const rsa_test test_rsa_pss_151_CRT = {
	.name = "rsa_pss_151_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_151_CRT_n,
	.nlen = sizeof(rsa_pss_151_CRT_n),
	.d = (const u8*)&rsa_pss_151_CRT_d,
	.dlen = sizeof(rsa_pss_151_CRT_d),
	.e = (const u8*)&rsa_pss_151_CRT_e,
	.elen = sizeof(rsa_pss_151_CRT_e),
	.p = (const u8*)&rsa_pss_151_CRT_p,
	.plen = sizeof(rsa_pss_151_CRT_p),
	.q = (const u8*)&rsa_pss_151_CRT_q,
	.qlen = sizeof(rsa_pss_151_CRT_q),
	.dP = (const u8*)&rsa_pss_151_CRT_dP,
	.dPlen = sizeof(rsa_pss_151_CRT_dP),
	.dQ = (const u8*)&rsa_pss_151_CRT_dQ,
	.dQlen = sizeof(rsa_pss_151_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_151_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_151_CRT_qInv),
	.m = (const u8*)&rsa_pss_151_CRT_m,
	.mlen = sizeof(rsa_pss_151_CRT_m),
	.res = (const u8*)&rsa_pss_151_CRT_res,
	.reslen = sizeof(rsa_pss_151_CRT_res),
	.salt = (const u8*)&rsa_pss_151_CRT_salt,
	.saltlen = sizeof(rsa_pss_151_CRT_salt),
};
static const u8 rsa_pss_152_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_152_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_152_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_152_m[] = {
0xfe, 0xf4, 0x16, 0x1d, 0xfa, 0xaf, 0x9c, 0x52, 0x95, 0x05, 0x1d, 0xfc, 0x1f, 0xf3, 0x81, 0x0c, 0x8c, 0x9e, 0xc2, 0xe8, 0x66, 0xf7, 0x07, 0x54, 0x22, 0xc8, 0xec, 0x42, 0x16, 0xa9, 0xc4, 0xff, 0x49, 0x42, 0x7d, 0x48, 0x3c, 0xae, 0x10, 0xc8, 0x53, 0x4a, 0x41, 0xb2, 0xfd, 0x15, 0xfe, 0xe0, 0x69, 0x60, 0xec, 0x6f, 0xb3, 0xf7, 0xa7, 0xe9, 0x4a, 0x2f, 0x8a, 0x2e, 0x3e, 0x43, 0xdc, 0x4a, 0x40, 0x57, 0x6c, 0x30, 0x97, 0xac, 0x95, 0x3b, 0x1d, 0xe8, 0x6f, 0x0b, 0x4e, 0xd3, 0x6d, 0x64, 0x4f, 0x23, 0xae, 0x14, 0x42, 0x55, 0x29, 0x62, 0x24, 0x64, 0xca, 0x0c, 0xbf, 0x0b, 0x17, 0x41, 0x34, 0x72, 0x38, 0x15, 0x7f, 0xab, 0x59, 0xe4, 0xde, 0x55, 0x24, 0x09, 0x6d, 0x62, 0xba, 0xec, 0x63, 0xac, 0x64, 
};
static const u8 rsa_pss_152_res[] = {
0x02, 0x1e, 0xca, 0x3a, 0xb4, 0x89, 0x22, 0x64, 0xec, 0x22, 0x41, 0x1a, 0x75, 0x2d, 0x92, 0x22, 0x10, 0x76, 0xd4, 0xe0, 0x1c, 0x0e, 0x6f, 0x0d, 0xde, 0x9a, 0xfd, 0x26, 0xba, 0x5a, 0xcf, 0x6d, 0x73, 0x9e, 0xf9, 0x87, 0x54, 0x5d, 0x16, 0x68, 0x3e, 0x56, 0x74, 0xc9, 0xe7, 0x0f, 0x1d, 0xe6, 0x49, 0xd7, 0xe6, 0x1d, 0x48, 0xd0, 0xca, 0xeb, 0x4f, 0xb4, 0xd8, 0xb2, 0x4f, 0xba, 0x84, 0xa6, 0xe3, 0x10, 0x8f, 0xee, 0x7d, 0x07, 0x05, 0x97, 0x32, 0x66, 0xac, 0x52, 0x4b, 0x4a, 0xd2, 0x80, 0xf7, 0xae, 0x17, 0xdc, 0x59, 0xd9, 0x6d, 0x33, 0x51, 0x58, 0x6b, 0x5a, 0x3b, 0xdb, 0x89, 0x5d, 0x1e, 0x1f, 0x78, 0x20, 0xac, 0x61, 0x35, 0xd8, 0x75, 0x34, 0x80, 0x99, 0x83, 0x82, 0xba, 0x32, 0xb7, 0x34, 0x95, 0x59, 0x60, 0x8c, 0x38, 0x74, 0x52, 0x90, 0xa8, 0x5e, 0xf4, 0xe9, 0xf9, 0xbd, 0x83, 
};
static const u8 rsa_pss_152_salt[] = {
0x50, 0x32, 0x7e, 0xfe, 0xc6, 0x29, 0x2f, 0x98, 0x01, 0x9f, 0xc6, 0x7a, 0x2a, 0x66, 0x38, 0x56, 0x3e, 0x9b, 0x6e, 0x2d, 
};


static const rsa_test test_rsa_pss_152 = {
	.name = "rsa_pss_152",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_152_n,
	.nlen = sizeof(rsa_pss_152_n),
	.d = (const u8*)&rsa_pss_152_d,
	.dlen = sizeof(rsa_pss_152_d),
	.e = (const u8*)&rsa_pss_152_e,
	.elen = sizeof(rsa_pss_152_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_152_m,
	.mlen = sizeof(rsa_pss_152_m),
	.res = (const u8*)&rsa_pss_152_res,
	.reslen = sizeof(rsa_pss_152_res),
	.salt = (const u8*)&rsa_pss_152_salt,
	.saltlen = sizeof(rsa_pss_152_salt),
};
static const u8 rsa_pss_153_CRT_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_153_CRT_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_153_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_153_CRT_m[] = {
0xfe, 0xf4, 0x16, 0x1d, 0xfa, 0xaf, 0x9c, 0x52, 0x95, 0x05, 0x1d, 0xfc, 0x1f, 0xf3, 0x81, 0x0c, 0x8c, 0x9e, 0xc2, 0xe8, 0x66, 0xf7, 0x07, 0x54, 0x22, 0xc8, 0xec, 0x42, 0x16, 0xa9, 0xc4, 0xff, 0x49, 0x42, 0x7d, 0x48, 0x3c, 0xae, 0x10, 0xc8, 0x53, 0x4a, 0x41, 0xb2, 0xfd, 0x15, 0xfe, 0xe0, 0x69, 0x60, 0xec, 0x6f, 0xb3, 0xf7, 0xa7, 0xe9, 0x4a, 0x2f, 0x8a, 0x2e, 0x3e, 0x43, 0xdc, 0x4a, 0x40, 0x57, 0x6c, 0x30, 0x97, 0xac, 0x95, 0x3b, 0x1d, 0xe8, 0x6f, 0x0b, 0x4e, 0xd3, 0x6d, 0x64, 0x4f, 0x23, 0xae, 0x14, 0x42, 0x55, 0x29, 0x62, 0x24, 0x64, 0xca, 0x0c, 0xbf, 0x0b, 0x17, 0x41, 0x34, 0x72, 0x38, 0x15, 0x7f, 0xab, 0x59, 0xe4, 0xde, 0x55, 0x24, 0x09, 0x6d, 0x62, 0xba, 0xec, 0x63, 0xac, 0x64, 
};
static const u8 rsa_pss_153_CRT_res[] = {
0x02, 0x1e, 0xca, 0x3a, 0xb4, 0x89, 0x22, 0x64, 0xec, 0x22, 0x41, 0x1a, 0x75, 0x2d, 0x92, 0x22, 0x10, 0x76, 0xd4, 0xe0, 0x1c, 0x0e, 0x6f, 0x0d, 0xde, 0x9a, 0xfd, 0x26, 0xba, 0x5a, 0xcf, 0x6d, 0x73, 0x9e, 0xf9, 0x87, 0x54, 0x5d, 0x16, 0x68, 0x3e, 0x56, 0x74, 0xc9, 0xe7, 0x0f, 0x1d, 0xe6, 0x49, 0xd7, 0xe6, 0x1d, 0x48, 0xd0, 0xca, 0xeb, 0x4f, 0xb4, 0xd8, 0xb2, 0x4f, 0xba, 0x84, 0xa6, 0xe3, 0x10, 0x8f, 0xee, 0x7d, 0x07, 0x05, 0x97, 0x32, 0x66, 0xac, 0x52, 0x4b, 0x4a, 0xd2, 0x80, 0xf7, 0xae, 0x17, 0xdc, 0x59, 0xd9, 0x6d, 0x33, 0x51, 0x58, 0x6b, 0x5a, 0x3b, 0xdb, 0x89, 0x5d, 0x1e, 0x1f, 0x78, 0x20, 0xac, 0x61, 0x35, 0xd8, 0x75, 0x34, 0x80, 0x99, 0x83, 0x82, 0xba, 0x32, 0xb7, 0x34, 0x95, 0x59, 0x60, 0x8c, 0x38, 0x74, 0x52, 0x90, 0xa8, 0x5e, 0xf4, 0xe9, 0xf9, 0xbd, 0x83, 
};
static const u8 rsa_pss_153_CRT_salt[] = {
0x50, 0x32, 0x7e, 0xfe, 0xc6, 0x29, 0x2f, 0x98, 0x01, 0x9f, 0xc6, 0x7a, 0x2a, 0x66, 0x38, 0x56, 0x3e, 0x9b, 0x6e, 0x2d, 
};
static const u8 rsa_pss_153_CRT_p[] = {
0x01, 0xbd, 0x36, 0xe1, 0x8e, 0xce, 0x4b, 0x0f, 0xdb, 0x2e, 0x9c, 0x9d, 0x54, 0x8b, 0xd1, 0xa7, 0xd6, 0xe2, 0xc2, 0x1c, 0x6f, 0xdc, 0x35, 0x07, 0x4a, 0x1d, 0x05, 0xb1, 0xc6, 0xc8, 0xb3, 0xd5, 0x58, 0xea, 0x26, 0x39, 0xc9, 0xa9, 0xa4, 0x21, 0x68, 0x01, 0x69, 0x31, 0x72, 0x52, 0x55, 0x8b, 0xd1, 0x48, 0xad, 0x21, 0x5a, 0xac, 0x55, 0x0e, 0x2d, 0xcf, 0x12, 0xa8, 0x2d, 0x0e, 0xbf, 0xe8, 0x53, 
};
static const u8 rsa_pss_153_CRT_q[] = {
0x01, 0xb1, 0xb6, 0x56, 0xad, 0x86, 0xd8, 0xe1, 0x9d, 0x5d, 0xc8, 0x62, 0x92, 0xb3, 0xa1, 0x92, 0xfd, 0xf6, 0xe0, 0xdd, 0x37, 0x87, 0x7b, 0xad, 0x14, 0x82, 0x2f, 0xa0, 0x01, 0x90, 0xca, 0xb2, 0x65, 0xf9, 0x0d, 0x3f, 0x02, 0x05, 0x7b, 0x6f, 0x54, 0xd6, 0xec, 0xb1, 0x44, 0x91, 0xe5, 0xad, 0xea, 0xce, 0xbc, 0x48, 0xbf, 0x0e, 0xbd, 0x2a, 0x2a, 0xd2, 0x6d, 0x40, 0x2e, 0x54, 0xf6, 0x16, 0x51, 
};
static const u8 rsa_pss_153_CRT_dP[] = {
0x1f, 0x27, 0x79, 0xfd, 0x2e, 0x3e, 0x5e, 0x6b, 0xae, 0x05, 0x53, 0x95, 0x18, 0xfb, 0xa0, 0xcd, 0x0e, 0xad, 0x1a, 0xa4, 0x51, 0x3a, 0x7c, 0xba, 0x18, 0xf1, 0xcf, 0x10, 0xe3, 0xf6, 0x81, 0x95, 0x69, 0x3d, 0x27, 0x8a, 0x0f, 0x0e, 0xe7, 0x2f, 0x89, 0xf9, 0xbc, 0x76, 0x0d, 0x80, 0xe2, 0xf9, 0xd0, 0x26, 0x1d, 0x51, 0x65, 0x01, 0xc6, 0xae, 0x39, 0xf1, 0x4a, 0x47, 0x6c, 0xe2, 0xcc, 0xf5, 
};
static const u8 rsa_pss_153_CRT_dQ[] = {
0x01, 0x1a, 0x0d, 0x36, 0x79, 0x4b, 0x04, 0xa8, 0x54, 0xaa, 0xb4, 0xb2, 0x46, 0x2d, 0x43, 0x9a, 0x50, 0x46, 0xc9, 0x1d, 0x94, 0x0b, 0x2b, 0xc6, 0xf7, 0x5b, 0x62, 0x95, 0x6f, 0xef, 0x35, 0xa2, 0xa6, 0xe6, 0x3c, 0x53, 0x09, 0x81, 0x7f, 0x30, 0x7b, 0xbf, 0xf9, 0xd5, 0x9e, 0x7e, 0x33, 0x1b, 0xd3, 0x63, 0xf6, 0xd6, 0x68, 0x49, 0xb1, 0x83, 0x46, 0xad, 0xea, 0x16, 0x9f, 0x0a, 0xe9, 0xae, 0xc1, 
};
static const u8 rsa_pss_153_CRT_qInv[] = {
0x0b, 0x30, 0xf0, 0xec, 0xf5, 0x58, 0x75, 0x2f, 0xb3, 0xa6, 0xce, 0x4b, 0xa2, 0xb8, 0xc6, 0x75, 0xf6, 0x59, 0xeb, 0xa6, 0xc3, 0x76, 0x58, 0x5a, 0x1b, 0x39, 0x71, 0x2d, 0x03, 0x8a, 0xe3, 0xd2, 0xb4, 0x6f, 0xcb, 0x41, 0x8a, 0xe1, 0x5d, 0x09, 0x05, 0xda, 0x64, 0x40, 0xe1, 0x51, 0x3a, 0x30, 0xb9, 0xb7, 0xd6, 0x66, 0x8f, 0xbc, 0x5e, 0x88, 0xe5, 0xab, 0x7a, 0x17, 0x5e, 0x73, 0xba, 0x35, 
};


static const rsa_test test_rsa_pss_153_CRT = {
	.name = "rsa_pss_153_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_153_CRT_n,
	.nlen = sizeof(rsa_pss_153_CRT_n),
	.d = (const u8*)&rsa_pss_153_CRT_d,
	.dlen = sizeof(rsa_pss_153_CRT_d),
	.e = (const u8*)&rsa_pss_153_CRT_e,
	.elen = sizeof(rsa_pss_153_CRT_e),
	.p = (const u8*)&rsa_pss_153_CRT_p,
	.plen = sizeof(rsa_pss_153_CRT_p),
	.q = (const u8*)&rsa_pss_153_CRT_q,
	.qlen = sizeof(rsa_pss_153_CRT_q),
	.dP = (const u8*)&rsa_pss_153_CRT_dP,
	.dPlen = sizeof(rsa_pss_153_CRT_dP),
	.dQ = (const u8*)&rsa_pss_153_CRT_dQ,
	.dQlen = sizeof(rsa_pss_153_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_153_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_153_CRT_qInv),
	.m = (const u8*)&rsa_pss_153_CRT_m,
	.mlen = sizeof(rsa_pss_153_CRT_m),
	.res = (const u8*)&rsa_pss_153_CRT_res,
	.reslen = sizeof(rsa_pss_153_CRT_res),
	.salt = (const u8*)&rsa_pss_153_CRT_salt,
	.saltlen = sizeof(rsa_pss_153_CRT_salt),
};
static const u8 rsa_pss_154_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_154_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_154_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_154_m[] = {
0xef, 0xd2, 0x37, 0xbb, 0x09, 0x8a, 0x44, 0x3a, 0xee, 0xb2, 0xbf, 0x6c, 0x3f, 0x8c, 0x81, 0xb8, 0xc0, 0x1b, 0x7f, 0xcb, 0x3f, 0xeb, 
};
static const u8 rsa_pss_154_res[] = {
0x01, 0x2f, 0xaf, 0xec, 0x86, 0x2f, 0x56, 0xe9, 0xe9, 0x2f, 0x60, 0xab, 0x0c, 0x77, 0x82, 0x4f, 0x42, 0x99, 0xa0, 0xca, 0x73, 0x4e, 0xd2, 0x6e, 0x06, 0x44, 0xd5, 0xd2, 0x22, 0xc7, 0xf0, 0xbd, 0xe0, 0x39, 0x64, 0xf8, 0xe7, 0x0a, 0x5c, 0xb6, 0x5e, 0xd4, 0x4e, 0x44, 0xd5, 0x6a, 0xe0, 0xed, 0xf1, 0xff, 0x86, 0xca, 0x03, 0x2c, 0xc5, 0xdd, 0x44, 0x04, 0xdb, 0xb7, 0x6a, 0xb8, 0x54, 0x58, 0x6c, 0x44, 0xee, 0xd8, 0x33, 0x6d, 0x08, 0xd4, 0x57, 0xce, 0x6c, 0x03, 0x69, 0x3b, 0x45, 0xc0, 0xf1, 0xef, 0xef, 0x93, 0x62, 0x4b, 0x95, 0xb8, 0xec, 0x16, 0x9c, 0x61, 0x6d, 0x20, 0xe5, 0x53, 0x8e, 0xbc, 0x0b, 0x67, 0x37, 0xa6, 0xf8, 0x2b, 0x4b, 0xc0, 0x57, 0x09, 0x24, 0xfc, 0x6b, 0x35, 0x75, 0x9a, 0x33, 0x48, 0x42, 0x62, 0x79, 0xf8, 0xb3, 0xd7, 0x74, 0x4e, 0x2d, 0x22, 0x24, 0x26, 0xce, 
};
static const u8 rsa_pss_154_salt[] = {
0xb0, 0xde, 0x3f, 0xc2, 0x5b, 0x65, 0xf5, 0xaf, 0x96, 0xb1, 0xd5, 0xcc, 0x3b, 0x27, 0xd0, 0xc6, 0x05, 0x30, 0x87, 0xb3, 
};


static const rsa_test test_rsa_pss_154 = {
	.name = "rsa_pss_154",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_154_n,
	.nlen = sizeof(rsa_pss_154_n),
	.d = (const u8*)&rsa_pss_154_d,
	.dlen = sizeof(rsa_pss_154_d),
	.e = (const u8*)&rsa_pss_154_e,
	.elen = sizeof(rsa_pss_154_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_154_m,
	.mlen = sizeof(rsa_pss_154_m),
	.res = (const u8*)&rsa_pss_154_res,
	.reslen = sizeof(rsa_pss_154_res),
	.salt = (const u8*)&rsa_pss_154_salt,
	.saltlen = sizeof(rsa_pss_154_salt),
};
static const u8 rsa_pss_155_CRT_n[] = {
0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43, 
};
static const u8 rsa_pss_155_CRT_d[] = {
0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91, 
};
static const u8 rsa_pss_155_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_155_CRT_m[] = {
0xef, 0xd2, 0x37, 0xbb, 0x09, 0x8a, 0x44, 0x3a, 0xee, 0xb2, 0xbf, 0x6c, 0x3f, 0x8c, 0x81, 0xb8, 0xc0, 0x1b, 0x7f, 0xcb, 0x3f, 0xeb, 
};
static const u8 rsa_pss_155_CRT_res[] = {
0x01, 0x2f, 0xaf, 0xec, 0x86, 0x2f, 0x56, 0xe9, 0xe9, 0x2f, 0x60, 0xab, 0x0c, 0x77, 0x82, 0x4f, 0x42, 0x99, 0xa0, 0xca, 0x73, 0x4e, 0xd2, 0x6e, 0x06, 0x44, 0xd5, 0xd2, 0x22, 0xc7, 0xf0, 0xbd, 0xe0, 0x39, 0x64, 0xf8, 0xe7, 0x0a, 0x5c, 0xb6, 0x5e, 0xd4, 0x4e, 0x44, 0xd5, 0x6a, 0xe0, 0xed, 0xf1, 0xff, 0x86, 0xca, 0x03, 0x2c, 0xc5, 0xdd, 0x44, 0x04, 0xdb, 0xb7, 0x6a, 0xb8, 0x54, 0x58, 0x6c, 0x44, 0xee, 0xd8, 0x33, 0x6d, 0x08, 0xd4, 0x57, 0xce, 0x6c, 0x03, 0x69, 0x3b, 0x45, 0xc0, 0xf1, 0xef, 0xef, 0x93, 0x62, 0x4b, 0x95, 0xb8, 0xec, 0x16, 0x9c, 0x61, 0x6d, 0x20, 0xe5, 0x53, 0x8e, 0xbc, 0x0b, 0x67, 0x37, 0xa6, 0xf8, 0x2b, 0x4b, 0xc0, 0x57, 0x09, 0x24, 0xfc, 0x6b, 0x35, 0x75, 0x9a, 0x33, 0x48, 0x42, 0x62, 0x79, 0xf8, 0xb3, 0xd7, 0x74, 0x4e, 0x2d, 0x22, 0x24, 0x26, 0xce, 
};
static const u8 rsa_pss_155_CRT_salt[] = {
0xb0, 0xde, 0x3f, 0xc2, 0x5b, 0x65, 0xf5, 0xaf, 0x96, 0xb1, 0xd5, 0xcc, 0x3b, 0x27, 0xd0, 0xc6, 0x05, 0x30, 0x87, 0xb3, 
};
static const u8 rsa_pss_155_CRT_p[] = {
0x01, 0xbd, 0x36, 0xe1, 0x8e, 0xce, 0x4b, 0x0f, 0xdb, 0x2e, 0x9c, 0x9d, 0x54, 0x8b, 0xd1, 0xa7, 0xd6, 0xe2, 0xc2, 0x1c, 0x6f, 0xdc, 0x35, 0x07, 0x4a, 0x1d, 0x05, 0xb1, 0xc6, 0xc8, 0xb3, 0xd5, 0x58, 0xea, 0x26, 0x39, 0xc9, 0xa9, 0xa4, 0x21, 0x68, 0x01, 0x69, 0x31, 0x72, 0x52, 0x55, 0x8b, 0xd1, 0x48, 0xad, 0x21, 0x5a, 0xac, 0x55, 0x0e, 0x2d, 0xcf, 0x12, 0xa8, 0x2d, 0x0e, 0xbf, 0xe8, 0x53, 
};
static const u8 rsa_pss_155_CRT_q[] = {
0x01, 0xb1, 0xb6, 0x56, 0xad, 0x86, 0xd8, 0xe1, 0x9d, 0x5d, 0xc8, 0x62, 0x92, 0xb3, 0xa1, 0x92, 0xfd, 0xf6, 0xe0, 0xdd, 0x37, 0x87, 0x7b, 0xad, 0x14, 0x82, 0x2f, 0xa0, 0x01, 0x90, 0xca, 0xb2, 0x65, 0xf9, 0x0d, 0x3f, 0x02, 0x05, 0x7b, 0x6f, 0x54, 0xd6, 0xec, 0xb1, 0x44, 0x91, 0xe5, 0xad, 0xea, 0xce, 0xbc, 0x48, 0xbf, 0x0e, 0xbd, 0x2a, 0x2a, 0xd2, 0x6d, 0x40, 0x2e, 0x54, 0xf6, 0x16, 0x51, 
};
static const u8 rsa_pss_155_CRT_dP[] = {
0x1f, 0x27, 0x79, 0xfd, 0x2e, 0x3e, 0x5e, 0x6b, 0xae, 0x05, 0x53, 0x95, 0x18, 0xfb, 0xa0, 0xcd, 0x0e, 0xad, 0x1a, 0xa4, 0x51, 0x3a, 0x7c, 0xba, 0x18, 0xf1, 0xcf, 0x10, 0xe3, 0xf6, 0x81, 0x95, 0x69, 0x3d, 0x27, 0x8a, 0x0f, 0x0e, 0xe7, 0x2f, 0x89, 0xf9, 0xbc, 0x76, 0x0d, 0x80, 0xe2, 0xf9, 0xd0, 0x26, 0x1d, 0x51, 0x65, 0x01, 0xc6, 0xae, 0x39, 0xf1, 0x4a, 0x47, 0x6c, 0xe2, 0xcc, 0xf5, 
};
static const u8 rsa_pss_155_CRT_dQ[] = {
0x01, 0x1a, 0x0d, 0x36, 0x79, 0x4b, 0x04, 0xa8, 0x54, 0xaa, 0xb4, 0xb2, 0x46, 0x2d, 0x43, 0x9a, 0x50, 0x46, 0xc9, 0x1d, 0x94, 0x0b, 0x2b, 0xc6, 0xf7, 0x5b, 0x62, 0x95, 0x6f, 0xef, 0x35, 0xa2, 0xa6, 0xe6, 0x3c, 0x53, 0x09, 0x81, 0x7f, 0x30, 0x7b, 0xbf, 0xf9, 0xd5, 0x9e, 0x7e, 0x33, 0x1b, 0xd3, 0x63, 0xf6, 0xd6, 0x68, 0x49, 0xb1, 0x83, 0x46, 0xad, 0xea, 0x16, 0x9f, 0x0a, 0xe9, 0xae, 0xc1, 
};
static const u8 rsa_pss_155_CRT_qInv[] = {
0x0b, 0x30, 0xf0, 0xec, 0xf5, 0x58, 0x75, 0x2f, 0xb3, 0xa6, 0xce, 0x4b, 0xa2, 0xb8, 0xc6, 0x75, 0xf6, 0x59, 0xeb, 0xa6, 0xc3, 0x76, 0x58, 0x5a, 0x1b, 0x39, 0x71, 0x2d, 0x03, 0x8a, 0xe3, 0xd2, 0xb4, 0x6f, 0xcb, 0x41, 0x8a, 0xe1, 0x5d, 0x09, 0x05, 0xda, 0x64, 0x40, 0xe1, 0x51, 0x3a, 0x30, 0xb9, 0xb7, 0xd6, 0x66, 0x8f, 0xbc, 0x5e, 0x88, 0xe5, 0xab, 0x7a, 0x17, 0x5e, 0x73, 0xba, 0x35, 
};


static const rsa_test test_rsa_pss_155_CRT = {
	.name = "rsa_pss_155_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1026,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_155_CRT_n,
	.nlen = sizeof(rsa_pss_155_CRT_n),
	.d = (const u8*)&rsa_pss_155_CRT_d,
	.dlen = sizeof(rsa_pss_155_CRT_d),
	.e = (const u8*)&rsa_pss_155_CRT_e,
	.elen = sizeof(rsa_pss_155_CRT_e),
	.p = (const u8*)&rsa_pss_155_CRT_p,
	.plen = sizeof(rsa_pss_155_CRT_p),
	.q = (const u8*)&rsa_pss_155_CRT_q,
	.qlen = sizeof(rsa_pss_155_CRT_q),
	.dP = (const u8*)&rsa_pss_155_CRT_dP,
	.dPlen = sizeof(rsa_pss_155_CRT_dP),
	.dQ = (const u8*)&rsa_pss_155_CRT_dQ,
	.dQlen = sizeof(rsa_pss_155_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_155_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_155_CRT_qInv),
	.m = (const u8*)&rsa_pss_155_CRT_m,
	.mlen = sizeof(rsa_pss_155_CRT_m),
	.res = (const u8*)&rsa_pss_155_CRT_res,
	.reslen = sizeof(rsa_pss_155_CRT_res),
	.salt = (const u8*)&rsa_pss_155_CRT_salt,
	.saltlen = sizeof(rsa_pss_155_CRT_salt),
};
static const u8 rsa_pss_156_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_156_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_156_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_156_m[] = {
0x9f, 0xb0, 0x3b, 0x82, 0x7c, 0x82, 0x17, 0xd9, 
};
static const u8 rsa_pss_156_res[] = {
0x03, 0x23, 0xd5, 0xb7, 0xbf, 0x20, 0xba, 0x45, 0x39, 0x28, 0x9a, 0xe4, 0x52, 0xae, 0x42, 0x97, 0x08, 0x0f, 0xef, 0xf4, 0x51, 0x84, 0x23, 0xff, 0x48, 0x11, 0xa8, 0x17, 0x83, 0x7e, 0x7d, 0x82, 0xf1, 0x83, 0x6c, 0xdf, 0xab, 0x54, 0x51, 0x4f, 0xf0, 0x88, 0x7b, 0xdd, 0xee, 0xbf, 0x40, 0xbf, 0x99, 0xb0, 0x47, 0xab, 0xc3, 0xec, 0xfa, 0x6a, 0x37, 0xa3, 0xef, 0x00, 0xf4, 0xa0, 0xc4, 0xa8, 0x8a, 0xae, 0x09, 0x04, 0xb7, 0x45, 0xc8, 0x46, 0xc4, 0x10, 0x7e, 0x87, 0x97, 0x72, 0x3e, 0x8a, 0xc8, 0x10, 0xd9, 0xe3, 0xd9, 0x5d, 0xfa, 0x30, 0xff, 0x49, 0x66, 0xf4, 0xd7, 0x5d, 0x13, 0x76, 0x8d, 0x20, 0x85, 0x7f, 0x2b, 0x14, 0x06, 0xf2, 0x64, 0xcf, 0xe7, 0x5e, 0x27, 0xd7, 0x65, 0x2f, 0x4b, 0x5e, 0xd3, 0x57, 0x5f, 0x28, 0xa7, 0x02, 0xf8, 0xc4, 0xed, 0x9c, 0xf9, 0xb2, 0xd4, 0x49, 0x48, 
};
static const u8 rsa_pss_156_salt[] = {
0xed, 0x7c, 0x98, 0xc9, 0x5f, 0x30, 0x97, 0x4f, 0xbe, 0x4f, 0xbd, 0xdc, 0xf0, 0xf2, 0x8d, 0x60, 0x21, 0xc0, 0xe9, 0x1d, 
};


static const rsa_test test_rsa_pss_156 = {
	.name = "rsa_pss_156",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_156_n,
	.nlen = sizeof(rsa_pss_156_n),
	.d = (const u8*)&rsa_pss_156_d,
	.dlen = sizeof(rsa_pss_156_d),
	.e = (const u8*)&rsa_pss_156_e,
	.elen = sizeof(rsa_pss_156_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_156_m,
	.mlen = sizeof(rsa_pss_156_m),
	.res = (const u8*)&rsa_pss_156_res,
	.reslen = sizeof(rsa_pss_156_res),
	.salt = (const u8*)&rsa_pss_156_salt,
	.saltlen = sizeof(rsa_pss_156_salt),
};
static const u8 rsa_pss_157_CRT_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_157_CRT_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_157_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_157_CRT_m[] = {
0x9f, 0xb0, 0x3b, 0x82, 0x7c, 0x82, 0x17, 0xd9, 
};
static const u8 rsa_pss_157_CRT_res[] = {
0x03, 0x23, 0xd5, 0xb7, 0xbf, 0x20, 0xba, 0x45, 0x39, 0x28, 0x9a, 0xe4, 0x52, 0xae, 0x42, 0x97, 0x08, 0x0f, 0xef, 0xf4, 0x51, 0x84, 0x23, 0xff, 0x48, 0x11, 0xa8, 0x17, 0x83, 0x7e, 0x7d, 0x82, 0xf1, 0x83, 0x6c, 0xdf, 0xab, 0x54, 0x51, 0x4f, 0xf0, 0x88, 0x7b, 0xdd, 0xee, 0xbf, 0x40, 0xbf, 0x99, 0xb0, 0x47, 0xab, 0xc3, 0xec, 0xfa, 0x6a, 0x37, 0xa3, 0xef, 0x00, 0xf4, 0xa0, 0xc4, 0xa8, 0x8a, 0xae, 0x09, 0x04, 0xb7, 0x45, 0xc8, 0x46, 0xc4, 0x10, 0x7e, 0x87, 0x97, 0x72, 0x3e, 0x8a, 0xc8, 0x10, 0xd9, 0xe3, 0xd9, 0x5d, 0xfa, 0x30, 0xff, 0x49, 0x66, 0xf4, 0xd7, 0x5d, 0x13, 0x76, 0x8d, 0x20, 0x85, 0x7f, 0x2b, 0x14, 0x06, 0xf2, 0x64, 0xcf, 0xe7, 0x5e, 0x27, 0xd7, 0x65, 0x2f, 0x4b, 0x5e, 0xd3, 0x57, 0x5f, 0x28, 0xa7, 0x02, 0xf8, 0xc4, 0xed, 0x9c, 0xf9, 0xb2, 0xd4, 0x49, 0x48, 
};
static const u8 rsa_pss_157_CRT_salt[] = {
0xed, 0x7c, 0x98, 0xc9, 0x5f, 0x30, 0x97, 0x4f, 0xbe, 0x4f, 0xbd, 0xdc, 0xf0, 0xf2, 0x8d, 0x60, 0x21, 0xc0, 0xe9, 0x1d, 
};
static const u8 rsa_pss_157_CRT_p[] = {
0x02, 0x92, 0x32, 0x33, 0x6d, 0x28, 0x38, 0x94, 0x5d, 0xba, 0x9d, 0xd7, 0x72, 0x3f, 0x4e, 0x62, 0x4a, 0x05, 0xf7, 0x37, 0x5b, 0x92, 0x7a, 0x87, 0xab, 0xe6, 0xa8, 0x93, 0xa1, 0x65, 0x8f, 0xd4, 0x9f, 0x47, 0xf6, 0xc7, 0xb0, 0xfa, 0x59, 0x6c, 0x65, 0xfa, 0x68, 0xa2, 0x3f, 0x0a, 0xb4, 0x32, 0x96, 0x2d, 0x18, 0xd4, 0x34, 0x3b, 0xd6, 0xfd, 0x67, 0x1a, 0x5e, 0xa8, 0xd1, 0x48, 0x41, 0x39, 0x95, 
};
static const u8 rsa_pss_157_CRT_q[] = {
0x02, 0x0e, 0xf5, 0xef, 0xe7, 0xc5, 0x39, 0x4a, 0xed, 0x22, 0x72, 0xf7, 0xe8, 0x1a, 0x74, 0xf4, 0xc0, 0x2d, 0x14, 0x58, 0x94, 0xcb, 0x1b, 0x3c, 0xab, 0x23, 0xa9, 0xa0, 0x71, 0x0a, 0x2a, 0xfc, 0x7e, 0x33, 0x29, 0xac, 0xbb, 0x74, 0x3d, 0x01, 0xf6, 0x80, 0xc4, 0xd0, 0x2a, 0xfb, 0x4c, 0x8f, 0xde, 0x7e, 0x20, 0x93, 0x08, 0x11, 0xbb, 0x2b, 0x99, 0x57, 0x88, 0xb5, 0xe8, 0x72, 0xc2, 0x0b, 0xb1, 
};
static const u8 rsa_pss_157_CRT_dP[] = {
0x02, 0x6e, 0x7e, 0x28, 0x01, 0x0e, 0xcf, 0x24, 0x12, 0xd9, 0x52, 0x3a, 0xd7, 0x04, 0x64, 0x7f, 0xb4, 0xfe, 0x9b, 0x66, 0xb1, 0xa6, 0x81, 0x58, 0x1b, 0x0e, 0x15, 0x55, 0x3a, 0x89, 0xb1, 0x54, 0x28, 0x28, 0x89, 0x8f, 0x27, 0x24, 0x3e, 0xba, 0xb4, 0x5f, 0xf5, 0xe1, 0xac, 0xb9, 0xd4, 0xdf, 0x1b, 0x05, 0x1f, 0xbc, 0x62, 0x82, 0x4d, 0xbc, 0x6f, 0x6c, 0x93, 0x26, 0x1a, 0x78, 0xb9, 0xa7, 0x59, 
};
static const u8 rsa_pss_157_CRT_dQ[] = {
0x01, 0x2d, 0xdc, 0xc8, 0x6e, 0xf6, 0x55, 0x99, 0x8c, 0x39, 0xdd, 0xae, 0x11, 0x71, 0x86, 0x69, 0xe5, 0xe4, 0x6c, 0xf1, 0x49, 0x5b, 0x07, 0xe1, 0x3b, 0x10, 0x14, 0xcd, 0x69, 0xb3, 0xaf, 0x68, 0x30, 0x4a, 0xd2, 0xa6, 0xb6, 0x43, 0x21, 0xe7, 0x8b, 0xf3, 0xbb, 0xca, 0x9b, 0xb4, 0x94, 0xe9, 0x1d, 0x45, 0x17, 0x17, 0xe2, 0xd9, 0x75, 0x64, 0xc6, 0x54, 0x94, 0x65, 0xd0, 0x20, 0x5c, 0xf4, 0x21, 
};
static const u8 rsa_pss_157_CRT_qInv[] = {
0x01, 0x06, 0x00, 0xc4, 0xc2, 0x18, 0x47, 0x45, 0x9f, 0xe5, 0x76, 0x70, 0x3e, 0x2e, 0xbe, 0xca, 0xe8, 0xa5, 0x09, 0x4e, 0xe6, 0x3f, 0x53, 0x6b, 0xf4, 0xac, 0x68, 0xd3, 0xc1, 0x3e, 0x5e, 0x4f, 0x12, 0xac, 0x5c, 0xc1, 0x0a, 0xb6, 0xa2, 0xd0, 0x5a, 0x19, 0x92, 0x14, 0xd1, 0x82, 0x47, 0x47, 0xd5, 0x51, 0x90, 0x96, 0x36, 0xb7, 0x74, 0xc2, 0x2c, 0xac, 0x0b, 0x83, 0x75, 0x99, 0xab, 0xcc, 0x75, 
};


static const rsa_test test_rsa_pss_157_CRT = {
	.name = "rsa_pss_157_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_157_CRT_n,
	.nlen = sizeof(rsa_pss_157_CRT_n),
	.d = (const u8*)&rsa_pss_157_CRT_d,
	.dlen = sizeof(rsa_pss_157_CRT_d),
	.e = (const u8*)&rsa_pss_157_CRT_e,
	.elen = sizeof(rsa_pss_157_CRT_e),
	.p = (const u8*)&rsa_pss_157_CRT_p,
	.plen = sizeof(rsa_pss_157_CRT_p),
	.q = (const u8*)&rsa_pss_157_CRT_q,
	.qlen = sizeof(rsa_pss_157_CRT_q),
	.dP = (const u8*)&rsa_pss_157_CRT_dP,
	.dPlen = sizeof(rsa_pss_157_CRT_dP),
	.dQ = (const u8*)&rsa_pss_157_CRT_dQ,
	.dQlen = sizeof(rsa_pss_157_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_157_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_157_CRT_qInv),
	.m = (const u8*)&rsa_pss_157_CRT_m,
	.mlen = sizeof(rsa_pss_157_CRT_m),
	.res = (const u8*)&rsa_pss_157_CRT_res,
	.reslen = sizeof(rsa_pss_157_CRT_res),
	.salt = (const u8*)&rsa_pss_157_CRT_salt,
	.saltlen = sizeof(rsa_pss_157_CRT_salt),
};
static const u8 rsa_pss_158_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_158_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_158_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_158_m[] = {
0x0c, 0xa2, 0xad, 0x77, 0x79, 0x7e, 0xce, 0x86, 0xde, 0x5b, 0xf7, 0x68, 0x75, 0x0d, 0xdb, 0x5e, 0xd6, 0xa3, 0x11, 0x6a, 0xd9, 0x9b, 0xbd, 0x17, 0xed, 0xf7, 0xf7, 0x82, 0xf0, 0xdb, 0x1c, 0xd0, 0x5b, 0x0f, 0x67, 0x74, 0x68, 0xc5, 0xea, 0x42, 0x0d, 0xc1, 0x16, 0xb1, 0x0e, 0x80, 0xd1, 0x10, 0xde, 0x2b, 0x04, 0x61, 0xea, 0x14, 0xa3, 0x8b, 0xe6, 0x86, 0x20, 0x39, 0x2e, 0x7e, 0x89, 0x3c, 0xb4, 0xea, 0x93, 0x93, 0xfb, 0x88, 0x6c, 0x20, 0xff, 0x79, 0x06, 0x42, 0x30, 0x5b, 0xf3, 0x02, 0x00, 0x38, 0x92, 0xe5, 0x4d, 0xf9, 0xf6, 0x67, 0x50, 0x9d, 0xc5, 0x39, 0x20, 0xdf, 0x58, 0x3f, 0x50, 0xa3, 0xdd, 0x61, 0xab, 0xb6, 0xfa, 0xb7, 0x5d, 0x60, 0x03, 0x77, 0xe3, 0x83, 0xe6, 0xac, 0xa6, 0x71, 0x0e, 0xee, 0xa2, 0x71, 0x56, 0xe0, 0x67, 0x52, 0xc9, 0x4c, 0xe2, 0x5a, 0xe9, 0x9f, 0xcb, 0xf8, 0x59, 0x2d, 0xbe, 0x2d, 0x7e, 0x27, 0x45, 0x3c, 0xb4, 0x4d, 0xe0, 0x71, 0x00, 0xeb, 0xb1, 0xa2, 0xa1, 0x98, 0x11, 0xa4, 0x78, 0xad, 0xbe, 0xab, 0x27, 0x0f, 0x94, 0xe8, 0xfe, 0x36, 0x9d, 0x90, 0xb3, 0xca, 0x61, 0x2f, 0x9f, 
};
static const u8 rsa_pss_158_res[] = {
0x04, 0x9d, 0x01, 0x85, 0x84, 0x5a, 0x26, 0x4d, 0x28, 0xfe, 0xb1, 0xe6, 0x9e, 0xda, 0xec, 0x09, 0x06, 0x09, 0xe8, 0xe4, 0x6d, 0x93, 0xab, 0xb3, 0x83, 0x71, 0xce, 0x51, 0xf4, 0xaa, 0x65, 0xa5, 0x99, 0xbd, 0xaa, 0xa8, 0x1d, 0x24, 0xfb, 0xa6, 0x6a, 0x08, 0xa1, 0x16, 0xcb, 0x64, 0x4f, 0x3f, 0x1e, 0x65, 0x3d, 0x95, 0xc8, 0x9d, 0xb8, 0xbb, 0xd5, 0xda, 0xac, 0x27, 0x09, 0xc8, 0x98, 0x40, 0x00, 0x17, 0x84, 0x10, 0xa7, 0xc6, 0xaa, 0x86, 0x67, 0xdd, 0xc3, 0x8c, 0x74, 0x1f, 0x71, 0x0e, 0xc8, 0x66, 0x5a, 0xa9, 0x05, 0x2b, 0xe9, 0x29, 0xd4, 0xe3, 0xb1, 0x67, 0x82, 0xc1, 0x66, 0x21, 0x14, 0xc5, 0x41, 0x4b, 0xb0, 0x35, 0x34, 0x55, 0xc3, 0x92, 0xfc, 0x28, 0xf3, 0xdb, 0x59, 0x05, 0x4b, 0x5f, 0x36, 0x5c, 0x49, 0xe1, 0xd1, 0x56, 0xf8, 0x76, 0xee, 0x10, 0xcb, 0x4f, 0xd7, 0x05, 0x98, 
};
static const u8 rsa_pss_158_salt[] = {
0x22, 0xd7, 0x1d, 0x54, 0x36, 0x3a, 0x42, 0x17, 0xaa, 0x55, 0x11, 0x3f, 0x05, 0x9b, 0x33, 0x84, 0xe3, 0xe5, 0x7e, 0x44, 
};


static const rsa_test test_rsa_pss_158 = {
	.name = "rsa_pss_158",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_158_n,
	.nlen = sizeof(rsa_pss_158_n),
	.d = (const u8*)&rsa_pss_158_d,
	.dlen = sizeof(rsa_pss_158_d),
	.e = (const u8*)&rsa_pss_158_e,
	.elen = sizeof(rsa_pss_158_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_158_m,
	.mlen = sizeof(rsa_pss_158_m),
	.res = (const u8*)&rsa_pss_158_res,
	.reslen = sizeof(rsa_pss_158_res),
	.salt = (const u8*)&rsa_pss_158_salt,
	.saltlen = sizeof(rsa_pss_158_salt),
};
static const u8 rsa_pss_159_CRT_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_159_CRT_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_159_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_159_CRT_m[] = {
0x0c, 0xa2, 0xad, 0x77, 0x79, 0x7e, 0xce, 0x86, 0xde, 0x5b, 0xf7, 0x68, 0x75, 0x0d, 0xdb, 0x5e, 0xd6, 0xa3, 0x11, 0x6a, 0xd9, 0x9b, 0xbd, 0x17, 0xed, 0xf7, 0xf7, 0x82, 0xf0, 0xdb, 0x1c, 0xd0, 0x5b, 0x0f, 0x67, 0x74, 0x68, 0xc5, 0xea, 0x42, 0x0d, 0xc1, 0x16, 0xb1, 0x0e, 0x80, 0xd1, 0x10, 0xde, 0x2b, 0x04, 0x61, 0xea, 0x14, 0xa3, 0x8b, 0xe6, 0x86, 0x20, 0x39, 0x2e, 0x7e, 0x89, 0x3c, 0xb4, 0xea, 0x93, 0x93, 0xfb, 0x88, 0x6c, 0x20, 0xff, 0x79, 0x06, 0x42, 0x30, 0x5b, 0xf3, 0x02, 0x00, 0x38, 0x92, 0xe5, 0x4d, 0xf9, 0xf6, 0x67, 0x50, 0x9d, 0xc5, 0x39, 0x20, 0xdf, 0x58, 0x3f, 0x50, 0xa3, 0xdd, 0x61, 0xab, 0xb6, 0xfa, 0xb7, 0x5d, 0x60, 0x03, 0x77, 0xe3, 0x83, 0xe6, 0xac, 0xa6, 0x71, 0x0e, 0xee, 0xa2, 0x71, 0x56, 0xe0, 0x67, 0x52, 0xc9, 0x4c, 0xe2, 0x5a, 0xe9, 0x9f, 0xcb, 0xf8, 0x59, 0x2d, 0xbe, 0x2d, 0x7e, 0x27, 0x45, 0x3c, 0xb4, 0x4d, 0xe0, 0x71, 0x00, 0xeb, 0xb1, 0xa2, 0xa1, 0x98, 0x11, 0xa4, 0x78, 0xad, 0xbe, 0xab, 0x27, 0x0f, 0x94, 0xe8, 0xfe, 0x36, 0x9d, 0x90, 0xb3, 0xca, 0x61, 0x2f, 0x9f, 
};
static const u8 rsa_pss_159_CRT_res[] = {
0x04, 0x9d, 0x01, 0x85, 0x84, 0x5a, 0x26, 0x4d, 0x28, 0xfe, 0xb1, 0xe6, 0x9e, 0xda, 0xec, 0x09, 0x06, 0x09, 0xe8, 0xe4, 0x6d, 0x93, 0xab, 0xb3, 0x83, 0x71, 0xce, 0x51, 0xf4, 0xaa, 0x65, 0xa5, 0x99, 0xbd, 0xaa, 0xa8, 0x1d, 0x24, 0xfb, 0xa6, 0x6a, 0x08, 0xa1, 0x16, 0xcb, 0x64, 0x4f, 0x3f, 0x1e, 0x65, 0x3d, 0x95, 0xc8, 0x9d, 0xb8, 0xbb, 0xd5, 0xda, 0xac, 0x27, 0x09, 0xc8, 0x98, 0x40, 0x00, 0x17, 0x84, 0x10, 0xa7, 0xc6, 0xaa, 0x86, 0x67, 0xdd, 0xc3, 0x8c, 0x74, 0x1f, 0x71, 0x0e, 0xc8, 0x66, 0x5a, 0xa9, 0x05, 0x2b, 0xe9, 0x29, 0xd4, 0xe3, 0xb1, 0x67, 0x82, 0xc1, 0x66, 0x21, 0x14, 0xc5, 0x41, 0x4b, 0xb0, 0x35, 0x34, 0x55, 0xc3, 0x92, 0xfc, 0x28, 0xf3, 0xdb, 0x59, 0x05, 0x4b, 0x5f, 0x36, 0x5c, 0x49, 0xe1, 0xd1, 0x56, 0xf8, 0x76, 0xee, 0x10, 0xcb, 0x4f, 0xd7, 0x05, 0x98, 
};
static const u8 rsa_pss_159_CRT_salt[] = {
0x22, 0xd7, 0x1d, 0x54, 0x36, 0x3a, 0x42, 0x17, 0xaa, 0x55, 0x11, 0x3f, 0x05, 0x9b, 0x33, 0x84, 0xe3, 0xe5, 0x7e, 0x44, 
};
static const u8 rsa_pss_159_CRT_p[] = {
0x02, 0x92, 0x32, 0x33, 0x6d, 0x28, 0x38, 0x94, 0x5d, 0xba, 0x9d, 0xd7, 0x72, 0x3f, 0x4e, 0x62, 0x4a, 0x05, 0xf7, 0x37, 0x5b, 0x92, 0x7a, 0x87, 0xab, 0xe6, 0xa8, 0x93, 0xa1, 0x65, 0x8f, 0xd4, 0x9f, 0x47, 0xf6, 0xc7, 0xb0, 0xfa, 0x59, 0x6c, 0x65, 0xfa, 0x68, 0xa2, 0x3f, 0x0a, 0xb4, 0x32, 0x96, 0x2d, 0x18, 0xd4, 0x34, 0x3b, 0xd6, 0xfd, 0x67, 0x1a, 0x5e, 0xa8, 0xd1, 0x48, 0x41, 0x39, 0x95, 
};
static const u8 rsa_pss_159_CRT_q[] = {
0x02, 0x0e, 0xf5, 0xef, 0xe7, 0xc5, 0x39, 0x4a, 0xed, 0x22, 0x72, 0xf7, 0xe8, 0x1a, 0x74, 0xf4, 0xc0, 0x2d, 0x14, 0x58, 0x94, 0xcb, 0x1b, 0x3c, 0xab, 0x23, 0xa9, 0xa0, 0x71, 0x0a, 0x2a, 0xfc, 0x7e, 0x33, 0x29, 0xac, 0xbb, 0x74, 0x3d, 0x01, 0xf6, 0x80, 0xc4, 0xd0, 0x2a, 0xfb, 0x4c, 0x8f, 0xde, 0x7e, 0x20, 0x93, 0x08, 0x11, 0xbb, 0x2b, 0x99, 0x57, 0x88, 0xb5, 0xe8, 0x72, 0xc2, 0x0b, 0xb1, 
};
static const u8 rsa_pss_159_CRT_dP[] = {
0x02, 0x6e, 0x7e, 0x28, 0x01, 0x0e, 0xcf, 0x24, 0x12, 0xd9, 0x52, 0x3a, 0xd7, 0x04, 0x64, 0x7f, 0xb4, 0xfe, 0x9b, 0x66, 0xb1, 0xa6, 0x81, 0x58, 0x1b, 0x0e, 0x15, 0x55, 0x3a, 0x89, 0xb1, 0x54, 0x28, 0x28, 0x89, 0x8f, 0x27, 0x24, 0x3e, 0xba, 0xb4, 0x5f, 0xf5, 0xe1, 0xac, 0xb9, 0xd4, 0xdf, 0x1b, 0x05, 0x1f, 0xbc, 0x62, 0x82, 0x4d, 0xbc, 0x6f, 0x6c, 0x93, 0x26, 0x1a, 0x78, 0xb9, 0xa7, 0x59, 
};
static const u8 rsa_pss_159_CRT_dQ[] = {
0x01, 0x2d, 0xdc, 0xc8, 0x6e, 0xf6, 0x55, 0x99, 0x8c, 0x39, 0xdd, 0xae, 0x11, 0x71, 0x86, 0x69, 0xe5, 0xe4, 0x6c, 0xf1, 0x49, 0x5b, 0x07, 0xe1, 0x3b, 0x10, 0x14, 0xcd, 0x69, 0xb3, 0xaf, 0x68, 0x30, 0x4a, 0xd2, 0xa6, 0xb6, 0x43, 0x21, 0xe7, 0x8b, 0xf3, 0xbb, 0xca, 0x9b, 0xb4, 0x94, 0xe9, 0x1d, 0x45, 0x17, 0x17, 0xe2, 0xd9, 0x75, 0x64, 0xc6, 0x54, 0x94, 0x65, 0xd0, 0x20, 0x5c, 0xf4, 0x21, 
};
static const u8 rsa_pss_159_CRT_qInv[] = {
0x01, 0x06, 0x00, 0xc4, 0xc2, 0x18, 0x47, 0x45, 0x9f, 0xe5, 0x76, 0x70, 0x3e, 0x2e, 0xbe, 0xca, 0xe8, 0xa5, 0x09, 0x4e, 0xe6, 0x3f, 0x53, 0x6b, 0xf4, 0xac, 0x68, 0xd3, 0xc1, 0x3e, 0x5e, 0x4f, 0x12, 0xac, 0x5c, 0xc1, 0x0a, 0xb6, 0xa2, 0xd0, 0x5a, 0x19, 0x92, 0x14, 0xd1, 0x82, 0x47, 0x47, 0xd5, 0x51, 0x90, 0x96, 0x36, 0xb7, 0x74, 0xc2, 0x2c, 0xac, 0x0b, 0x83, 0x75, 0x99, 0xab, 0xcc, 0x75, 
};


static const rsa_test test_rsa_pss_159_CRT = {
	.name = "rsa_pss_159_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_159_CRT_n,
	.nlen = sizeof(rsa_pss_159_CRT_n),
	.d = (const u8*)&rsa_pss_159_CRT_d,
	.dlen = sizeof(rsa_pss_159_CRT_d),
	.e = (const u8*)&rsa_pss_159_CRT_e,
	.elen = sizeof(rsa_pss_159_CRT_e),
	.p = (const u8*)&rsa_pss_159_CRT_p,
	.plen = sizeof(rsa_pss_159_CRT_p),
	.q = (const u8*)&rsa_pss_159_CRT_q,
	.qlen = sizeof(rsa_pss_159_CRT_q),
	.dP = (const u8*)&rsa_pss_159_CRT_dP,
	.dPlen = sizeof(rsa_pss_159_CRT_dP),
	.dQ = (const u8*)&rsa_pss_159_CRT_dQ,
	.dQlen = sizeof(rsa_pss_159_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_159_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_159_CRT_qInv),
	.m = (const u8*)&rsa_pss_159_CRT_m,
	.mlen = sizeof(rsa_pss_159_CRT_m),
	.res = (const u8*)&rsa_pss_159_CRT_res,
	.reslen = sizeof(rsa_pss_159_CRT_res),
	.salt = (const u8*)&rsa_pss_159_CRT_salt,
	.saltlen = sizeof(rsa_pss_159_CRT_salt),
};
static const u8 rsa_pss_160_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_160_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_160_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_160_m[] = {
0x28, 0x80, 0x62, 0xaf, 0xc0, 0x8f, 0xcd, 0xb7, 0xc5, 0xf8, 0x65, 0x0b, 0x29, 0x83, 0x73, 0x00, 0x46, 0x1d, 0xd5, 0x67, 0x6c, 0x17, 0xa2, 0x0a, 0x3c, 0x8f, 0xb5, 0x14, 0x89, 0x49, 0xe3, 0xf7, 0x3d, 0x66, 0xb3, 0xae, 0x82, 0xc7, 0x24, 0x0e, 0x27, 0xc5, 0xb3, 0xec, 0x43, 0x28, 0xee, 0x7d, 0x6d, 0xdf, 0x6a, 0x6a, 0x0c, 0x9b, 0x5b, 0x15, 0xbc, 0xda, 0x19, 0x6a, 0x9d, 0x0c, 0x76, 0xb1, 0x19, 0xd5, 0x34, 0xd8, 0x5a, 0xbd, 0x12, 0x39, 0x62, 0xd5, 0x83, 0xb7, 0x6c, 0xe9, 0xd1, 0x80, 0xbc, 0xe1, 0xca, 
};
static const u8 rsa_pss_160_res[] = {
0x03, 0xfb, 0xc4, 0x10, 0xa2, 0xce, 0xd5, 0x95, 0x00, 0xfb, 0x99, 0xf9, 0xe2, 0xaf, 0x27, 0x81, 0xad, 0xa7, 0x4e, 0x13, 0x14, 0x56, 0x24, 0x60, 0x27, 0x82, 0xe2, 0x99, 0x48, 0x13, 0xee, 0xfc, 0xa0, 0x51, 0x9e, 0xcd, 0x25, 0x3b, 0x85, 0x5f, 0xb6, 0x26, 0xa9, 0x0d, 0x77, 0x1e, 0xae, 0x02, 0x8b, 0x0c, 0x47, 0xa1, 0x99, 0xcb, 0xd9, 0xf8, 0xe3, 0x26, 0x97, 0x34, 0xaf, 0x41, 0x63, 0x59, 0x90, 0x90, 0x71, 0x3a, 0x3f, 0xa9, 0x10, 0xfa, 0x09, 0x60, 0x65, 0x27, 0x21, 0x43, 0x2b, 0x97, 0x10, 0x36, 0xa7, 0x18, 0x1a, 0x2b, 0xc0, 0xca, 0xb4, 0x3b, 0x0b, 0x59, 0x8b, 0xc6, 0x21, 0x74, 0x61, 0xd7, 0xdb, 0x30, 0x5f, 0xf7, 0xe9, 0x54, 0xc5, 0xb5, 0xbb, 0x23, 0x1c, 0x39, 0xe7, 0x91, 0xaf, 0x6b, 0xcf, 0xa7, 0x6b, 0x14, 0x7b, 0x08, 0x13, 0x21, 0xf7, 0x26, 0x41, 0x48, 0x2a, 0x2a, 0xad, 
};
static const u8 rsa_pss_160_salt[] = {
0x4a, 0xf8, 0x70, 0xfb, 0xc6, 0x51, 0x60, 0x12, 0xca, 0x91, 0x6c, 0x70, 0xba, 0x86, 0x2a, 0xc7, 0xe8, 0x24, 0x36, 0x17, 
};


static const rsa_test test_rsa_pss_160 = {
	.name = "rsa_pss_160",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_160_n,
	.nlen = sizeof(rsa_pss_160_n),
	.d = (const u8*)&rsa_pss_160_d,
	.dlen = sizeof(rsa_pss_160_d),
	.e = (const u8*)&rsa_pss_160_e,
	.elen = sizeof(rsa_pss_160_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_160_m,
	.mlen = sizeof(rsa_pss_160_m),
	.res = (const u8*)&rsa_pss_160_res,
	.reslen = sizeof(rsa_pss_160_res),
	.salt = (const u8*)&rsa_pss_160_salt,
	.saltlen = sizeof(rsa_pss_160_salt),
};
static const u8 rsa_pss_161_CRT_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_161_CRT_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_161_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_161_CRT_m[] = {
0x28, 0x80, 0x62, 0xaf, 0xc0, 0x8f, 0xcd, 0xb7, 0xc5, 0xf8, 0x65, 0x0b, 0x29, 0x83, 0x73, 0x00, 0x46, 0x1d, 0xd5, 0x67, 0x6c, 0x17, 0xa2, 0x0a, 0x3c, 0x8f, 0xb5, 0x14, 0x89, 0x49, 0xe3, 0xf7, 0x3d, 0x66, 0xb3, 0xae, 0x82, 0xc7, 0x24, 0x0e, 0x27, 0xc5, 0xb3, 0xec, 0x43, 0x28, 0xee, 0x7d, 0x6d, 0xdf, 0x6a, 0x6a, 0x0c, 0x9b, 0x5b, 0x15, 0xbc, 0xda, 0x19, 0x6a, 0x9d, 0x0c, 0x76, 0xb1, 0x19, 0xd5, 0x34, 0xd8, 0x5a, 0xbd, 0x12, 0x39, 0x62, 0xd5, 0x83, 0xb7, 0x6c, 0xe9, 0xd1, 0x80, 0xbc, 0xe1, 0xca, 
};
static const u8 rsa_pss_161_CRT_res[] = {
0x03, 0xfb, 0xc4, 0x10, 0xa2, 0xce, 0xd5, 0x95, 0x00, 0xfb, 0x99, 0xf9, 0xe2, 0xaf, 0x27, 0x81, 0xad, 0xa7, 0x4e, 0x13, 0x14, 0x56, 0x24, 0x60, 0x27, 0x82, 0xe2, 0x99, 0x48, 0x13, 0xee, 0xfc, 0xa0, 0x51, 0x9e, 0xcd, 0x25, 0x3b, 0x85, 0x5f, 0xb6, 0x26, 0xa9, 0x0d, 0x77, 0x1e, 0xae, 0x02, 0x8b, 0x0c, 0x47, 0xa1, 0x99, 0xcb, 0xd9, 0xf8, 0xe3, 0x26, 0x97, 0x34, 0xaf, 0x41, 0x63, 0x59, 0x90, 0x90, 0x71, 0x3a, 0x3f, 0xa9, 0x10, 0xfa, 0x09, 0x60, 0x65, 0x27, 0x21, 0x43, 0x2b, 0x97, 0x10, 0x36, 0xa7, 0x18, 0x1a, 0x2b, 0xc0, 0xca, 0xb4, 0x3b, 0x0b, 0x59, 0x8b, 0xc6, 0x21, 0x74, 0x61, 0xd7, 0xdb, 0x30, 0x5f, 0xf7, 0xe9, 0x54, 0xc5, 0xb5, 0xbb, 0x23, 0x1c, 0x39, 0xe7, 0x91, 0xaf, 0x6b, 0xcf, 0xa7, 0x6b, 0x14, 0x7b, 0x08, 0x13, 0x21, 0xf7, 0x26, 0x41, 0x48, 0x2a, 0x2a, 0xad, 
};
static const u8 rsa_pss_161_CRT_salt[] = {
0x4a, 0xf8, 0x70, 0xfb, 0xc6, 0x51, 0x60, 0x12, 0xca, 0x91, 0x6c, 0x70, 0xba, 0x86, 0x2a, 0xc7, 0xe8, 0x24, 0x36, 0x17, 
};
static const u8 rsa_pss_161_CRT_p[] = {
0x02, 0x92, 0x32, 0x33, 0x6d, 0x28, 0x38, 0x94, 0x5d, 0xba, 0x9d, 0xd7, 0x72, 0x3f, 0x4e, 0x62, 0x4a, 0x05, 0xf7, 0x37, 0x5b, 0x92, 0x7a, 0x87, 0xab, 0xe6, 0xa8, 0x93, 0xa1, 0x65, 0x8f, 0xd4, 0x9f, 0x47, 0xf6, 0xc7, 0xb0, 0xfa, 0x59, 0x6c, 0x65, 0xfa, 0x68, 0xa2, 0x3f, 0x0a, 0xb4, 0x32, 0x96, 0x2d, 0x18, 0xd4, 0x34, 0x3b, 0xd6, 0xfd, 0x67, 0x1a, 0x5e, 0xa8, 0xd1, 0x48, 0x41, 0x39, 0x95, 
};
static const u8 rsa_pss_161_CRT_q[] = {
0x02, 0x0e, 0xf5, 0xef, 0xe7, 0xc5, 0x39, 0x4a, 0xed, 0x22, 0x72, 0xf7, 0xe8, 0x1a, 0x74, 0xf4, 0xc0, 0x2d, 0x14, 0x58, 0x94, 0xcb, 0x1b, 0x3c, 0xab, 0x23, 0xa9, 0xa0, 0x71, 0x0a, 0x2a, 0xfc, 0x7e, 0x33, 0x29, 0xac, 0xbb, 0x74, 0x3d, 0x01, 0xf6, 0x80, 0xc4, 0xd0, 0x2a, 0xfb, 0x4c, 0x8f, 0xde, 0x7e, 0x20, 0x93, 0x08, 0x11, 0xbb, 0x2b, 0x99, 0x57, 0x88, 0xb5, 0xe8, 0x72, 0xc2, 0x0b, 0xb1, 
};
static const u8 rsa_pss_161_CRT_dP[] = {
0x02, 0x6e, 0x7e, 0x28, 0x01, 0x0e, 0xcf, 0x24, 0x12, 0xd9, 0x52, 0x3a, 0xd7, 0x04, 0x64, 0x7f, 0xb4, 0xfe, 0x9b, 0x66, 0xb1, 0xa6, 0x81, 0x58, 0x1b, 0x0e, 0x15, 0x55, 0x3a, 0x89, 0xb1, 0x54, 0x28, 0x28, 0x89, 0x8f, 0x27, 0x24, 0x3e, 0xba, 0xb4, 0x5f, 0xf5, 0xe1, 0xac, 0xb9, 0xd4, 0xdf, 0x1b, 0x05, 0x1f, 0xbc, 0x62, 0x82, 0x4d, 0xbc, 0x6f, 0x6c, 0x93, 0x26, 0x1a, 0x78, 0xb9, 0xa7, 0x59, 
};
static const u8 rsa_pss_161_CRT_dQ[] = {
0x01, 0x2d, 0xdc, 0xc8, 0x6e, 0xf6, 0x55, 0x99, 0x8c, 0x39, 0xdd, 0xae, 0x11, 0x71, 0x86, 0x69, 0xe5, 0xe4, 0x6c, 0xf1, 0x49, 0x5b, 0x07, 0xe1, 0x3b, 0x10, 0x14, 0xcd, 0x69, 0xb3, 0xaf, 0x68, 0x30, 0x4a, 0xd2, 0xa6, 0xb6, 0x43, 0x21, 0xe7, 0x8b, 0xf3, 0xbb, 0xca, 0x9b, 0xb4, 0x94, 0xe9, 0x1d, 0x45, 0x17, 0x17, 0xe2, 0xd9, 0x75, 0x64, 0xc6, 0x54, 0x94, 0x65, 0xd0, 0x20, 0x5c, 0xf4, 0x21, 
};
static const u8 rsa_pss_161_CRT_qInv[] = {
0x01, 0x06, 0x00, 0xc4, 0xc2, 0x18, 0x47, 0x45, 0x9f, 0xe5, 0x76, 0x70, 0x3e, 0x2e, 0xbe, 0xca, 0xe8, 0xa5, 0x09, 0x4e, 0xe6, 0x3f, 0x53, 0x6b, 0xf4, 0xac, 0x68, 0xd3, 0xc1, 0x3e, 0x5e, 0x4f, 0x12, 0xac, 0x5c, 0xc1, 0x0a, 0xb6, 0xa2, 0xd0, 0x5a, 0x19, 0x92, 0x14, 0xd1, 0x82, 0x47, 0x47, 0xd5, 0x51, 0x90, 0x96, 0x36, 0xb7, 0x74, 0xc2, 0x2c, 0xac, 0x0b, 0x83, 0x75, 0x99, 0xab, 0xcc, 0x75, 
};


static const rsa_test test_rsa_pss_161_CRT = {
	.name = "rsa_pss_161_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_161_CRT_n,
	.nlen = sizeof(rsa_pss_161_CRT_n),
	.d = (const u8*)&rsa_pss_161_CRT_d,
	.dlen = sizeof(rsa_pss_161_CRT_d),
	.e = (const u8*)&rsa_pss_161_CRT_e,
	.elen = sizeof(rsa_pss_161_CRT_e),
	.p = (const u8*)&rsa_pss_161_CRT_p,
	.plen = sizeof(rsa_pss_161_CRT_p),
	.q = (const u8*)&rsa_pss_161_CRT_q,
	.qlen = sizeof(rsa_pss_161_CRT_q),
	.dP = (const u8*)&rsa_pss_161_CRT_dP,
	.dPlen = sizeof(rsa_pss_161_CRT_dP),
	.dQ = (const u8*)&rsa_pss_161_CRT_dQ,
	.dQlen = sizeof(rsa_pss_161_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_161_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_161_CRT_qInv),
	.m = (const u8*)&rsa_pss_161_CRT_m,
	.mlen = sizeof(rsa_pss_161_CRT_m),
	.res = (const u8*)&rsa_pss_161_CRT_res,
	.reslen = sizeof(rsa_pss_161_CRT_res),
	.salt = (const u8*)&rsa_pss_161_CRT_salt,
	.saltlen = sizeof(rsa_pss_161_CRT_salt),
};
static const u8 rsa_pss_162_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_162_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_162_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_162_m[] = {
0x6f, 0x4f, 0x9a, 0xb9, 0x50, 0x11, 0x99, 0xce, 0xf5, 0x5c, 0x6c, 0xf4, 0x08, 0xfe, 0x7b, 0x36, 0xc5, 0x57, 0xc4, 0x9d, 0x42, 0x0a, 0x47, 0x63, 0xd2, 0x46, 0x3c, 0x8a, 0xd4, 0x4b, 0x3c, 0xfc, 0x5b, 0xe2, 0x74, 0x2c, 0x0e, 0x7d, 0x9b, 0x0f, 0x66, 0x08, 0xf0, 0x8c, 0x7f, 0x47, 0xb6, 0x93, 0xee, 
};
static const u8 rsa_pss_162_res[] = {
0x04, 0x86, 0x64, 0x4b, 0xc6, 0x6b, 0xf7, 0x5d, 0x28, 0x33, 0x5a, 0x61, 0x79, 0xb1, 0x08, 0x51, 0xf4, 0x3f, 0x09, 0xbd, 0xed, 0x9f, 0xac, 0x1a, 0xf3, 0x32, 0x52, 0xbb, 0x99, 0x53, 0xba, 0x42, 0x98, 0xcd, 0x64, 0x66, 0xb2, 0x75, 0x39, 0xa7, 0x0a, 0xda, 0xa3, 0xf8, 0x9b, 0x3d, 0xb3, 0xc7, 0x4a, 0xb6, 0x35, 0xd1, 0x22, 0xf4, 0xee, 0x7c, 0xe5, 0x57, 0xa6, 0x1e, 0x59, 0xb8, 0x2f, 0xfb, 0x78, 0x66, 0x30, 0xe5, 0xf9, 0xdb, 0x53, 0xc7, 0x7d, 0x9a, 0x0c, 0x12, 0xfa, 0xb5, 0x95, 0x8d, 0x4c, 0x2c, 0xe7, 0xda, 0xa8, 0x07, 0xcd, 0x89, 0xba, 0x2c, 0xc7, 0xfc, 0xd0, 0x2f, 0xf4, 0x70, 0xca, 0x67, 0xb2, 0x29, 0xfc, 0xce, 0x81, 0x4c, 0x85, 0x2c, 0x73, 0xcc, 0x93, 0xbe, 0xa3, 0x5b, 0xe6, 0x84, 0x59, 0xce, 0x47, 0x8e, 0x9d, 0x46, 0x55, 0xd1, 0x21, 0xc8, 0x47, 0x2f, 0x37, 0x1d, 0x4f, 
};
static const u8 rsa_pss_162_salt[] = {
0x40, 0xd2, 0xe1, 0x80, 0xfa, 0xe1, 0xea, 0xc4, 0x39, 0xc1, 0x90, 0xb5, 0x6c, 0x2c, 0x0e, 0x14, 0xdd, 0xf9, 0xa2, 0x26, 
};


static const rsa_test test_rsa_pss_162 = {
	.name = "rsa_pss_162",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_162_n,
	.nlen = sizeof(rsa_pss_162_n),
	.d = (const u8*)&rsa_pss_162_d,
	.dlen = sizeof(rsa_pss_162_d),
	.e = (const u8*)&rsa_pss_162_e,
	.elen = sizeof(rsa_pss_162_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_162_m,
	.mlen = sizeof(rsa_pss_162_m),
	.res = (const u8*)&rsa_pss_162_res,
	.reslen = sizeof(rsa_pss_162_res),
	.salt = (const u8*)&rsa_pss_162_salt,
	.saltlen = sizeof(rsa_pss_162_salt),
};
static const u8 rsa_pss_163_CRT_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_163_CRT_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_163_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_163_CRT_m[] = {
0x6f, 0x4f, 0x9a, 0xb9, 0x50, 0x11, 0x99, 0xce, 0xf5, 0x5c, 0x6c, 0xf4, 0x08, 0xfe, 0x7b, 0x36, 0xc5, 0x57, 0xc4, 0x9d, 0x42, 0x0a, 0x47, 0x63, 0xd2, 0x46, 0x3c, 0x8a, 0xd4, 0x4b, 0x3c, 0xfc, 0x5b, 0xe2, 0x74, 0x2c, 0x0e, 0x7d, 0x9b, 0x0f, 0x66, 0x08, 0xf0, 0x8c, 0x7f, 0x47, 0xb6, 0x93, 0xee, 
};
static const u8 rsa_pss_163_CRT_res[] = {
0x04, 0x86, 0x64, 0x4b, 0xc6, 0x6b, 0xf7, 0x5d, 0x28, 0x33, 0x5a, 0x61, 0x79, 0xb1, 0x08, 0x51, 0xf4, 0x3f, 0x09, 0xbd, 0xed, 0x9f, 0xac, 0x1a, 0xf3, 0x32, 0x52, 0xbb, 0x99, 0x53, 0xba, 0x42, 0x98, 0xcd, 0x64, 0x66, 0xb2, 0x75, 0x39, 0xa7, 0x0a, 0xda, 0xa3, 0xf8, 0x9b, 0x3d, 0xb3, 0xc7, 0x4a, 0xb6, 0x35, 0xd1, 0x22, 0xf4, 0xee, 0x7c, 0xe5, 0x57, 0xa6, 0x1e, 0x59, 0xb8, 0x2f, 0xfb, 0x78, 0x66, 0x30, 0xe5, 0xf9, 0xdb, 0x53, 0xc7, 0x7d, 0x9a, 0x0c, 0x12, 0xfa, 0xb5, 0x95, 0x8d, 0x4c, 0x2c, 0xe7, 0xda, 0xa8, 0x07, 0xcd, 0x89, 0xba, 0x2c, 0xc7, 0xfc, 0xd0, 0x2f, 0xf4, 0x70, 0xca, 0x67, 0xb2, 0x29, 0xfc, 0xce, 0x81, 0x4c, 0x85, 0x2c, 0x73, 0xcc, 0x93, 0xbe, 0xa3, 0x5b, 0xe6, 0x84, 0x59, 0xce, 0x47, 0x8e, 0x9d, 0x46, 0x55, 0xd1, 0x21, 0xc8, 0x47, 0x2f, 0x37, 0x1d, 0x4f, 
};
static const u8 rsa_pss_163_CRT_salt[] = {
0x40, 0xd2, 0xe1, 0x80, 0xfa, 0xe1, 0xea, 0xc4, 0x39, 0xc1, 0x90, 0xb5, 0x6c, 0x2c, 0x0e, 0x14, 0xdd, 0xf9, 0xa2, 0x26, 
};
static const u8 rsa_pss_163_CRT_p[] = {
0x02, 0x92, 0x32, 0x33, 0x6d, 0x28, 0x38, 0x94, 0x5d, 0xba, 0x9d, 0xd7, 0x72, 0x3f, 0x4e, 0x62, 0x4a, 0x05, 0xf7, 0x37, 0x5b, 0x92, 0x7a, 0x87, 0xab, 0xe6, 0xa8, 0x93, 0xa1, 0x65, 0x8f, 0xd4, 0x9f, 0x47, 0xf6, 0xc7, 0xb0, 0xfa, 0x59, 0x6c, 0x65, 0xfa, 0x68, 0xa2, 0x3f, 0x0a, 0xb4, 0x32, 0x96, 0x2d, 0x18, 0xd4, 0x34, 0x3b, 0xd6, 0xfd, 0x67, 0x1a, 0x5e, 0xa8, 0xd1, 0x48, 0x41, 0x39, 0x95, 
};
static const u8 rsa_pss_163_CRT_q[] = {
0x02, 0x0e, 0xf5, 0xef, 0xe7, 0xc5, 0x39, 0x4a, 0xed, 0x22, 0x72, 0xf7, 0xe8, 0x1a, 0x74, 0xf4, 0xc0, 0x2d, 0x14, 0x58, 0x94, 0xcb, 0x1b, 0x3c, 0xab, 0x23, 0xa9, 0xa0, 0x71, 0x0a, 0x2a, 0xfc, 0x7e, 0x33, 0x29, 0xac, 0xbb, 0x74, 0x3d, 0x01, 0xf6, 0x80, 0xc4, 0xd0, 0x2a, 0xfb, 0x4c, 0x8f, 0xde, 0x7e, 0x20, 0x93, 0x08, 0x11, 0xbb, 0x2b, 0x99, 0x57, 0x88, 0xb5, 0xe8, 0x72, 0xc2, 0x0b, 0xb1, 
};
static const u8 rsa_pss_163_CRT_dP[] = {
0x02, 0x6e, 0x7e, 0x28, 0x01, 0x0e, 0xcf, 0x24, 0x12, 0xd9, 0x52, 0x3a, 0xd7, 0x04, 0x64, 0x7f, 0xb4, 0xfe, 0x9b, 0x66, 0xb1, 0xa6, 0x81, 0x58, 0x1b, 0x0e, 0x15, 0x55, 0x3a, 0x89, 0xb1, 0x54, 0x28, 0x28, 0x89, 0x8f, 0x27, 0x24, 0x3e, 0xba, 0xb4, 0x5f, 0xf5, 0xe1, 0xac, 0xb9, 0xd4, 0xdf, 0x1b, 0x05, 0x1f, 0xbc, 0x62, 0x82, 0x4d, 0xbc, 0x6f, 0x6c, 0x93, 0x26, 0x1a, 0x78, 0xb9, 0xa7, 0x59, 
};
static const u8 rsa_pss_163_CRT_dQ[] = {
0x01, 0x2d, 0xdc, 0xc8, 0x6e, 0xf6, 0x55, 0x99, 0x8c, 0x39, 0xdd, 0xae, 0x11, 0x71, 0x86, 0x69, 0xe5, 0xe4, 0x6c, 0xf1, 0x49, 0x5b, 0x07, 0xe1, 0x3b, 0x10, 0x14, 0xcd, 0x69, 0xb3, 0xaf, 0x68, 0x30, 0x4a, 0xd2, 0xa6, 0xb6, 0x43, 0x21, 0xe7, 0x8b, 0xf3, 0xbb, 0xca, 0x9b, 0xb4, 0x94, 0xe9, 0x1d, 0x45, 0x17, 0x17, 0xe2, 0xd9, 0x75, 0x64, 0xc6, 0x54, 0x94, 0x65, 0xd0, 0x20, 0x5c, 0xf4, 0x21, 
};
static const u8 rsa_pss_163_CRT_qInv[] = {
0x01, 0x06, 0x00, 0xc4, 0xc2, 0x18, 0x47, 0x45, 0x9f, 0xe5, 0x76, 0x70, 0x3e, 0x2e, 0xbe, 0xca, 0xe8, 0xa5, 0x09, 0x4e, 0xe6, 0x3f, 0x53, 0x6b, 0xf4, 0xac, 0x68, 0xd3, 0xc1, 0x3e, 0x5e, 0x4f, 0x12, 0xac, 0x5c, 0xc1, 0x0a, 0xb6, 0xa2, 0xd0, 0x5a, 0x19, 0x92, 0x14, 0xd1, 0x82, 0x47, 0x47, 0xd5, 0x51, 0x90, 0x96, 0x36, 0xb7, 0x74, 0xc2, 0x2c, 0xac, 0x0b, 0x83, 0x75, 0x99, 0xab, 0xcc, 0x75, 
};


static const rsa_test test_rsa_pss_163_CRT = {
	.name = "rsa_pss_163_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_163_CRT_n,
	.nlen = sizeof(rsa_pss_163_CRT_n),
	.d = (const u8*)&rsa_pss_163_CRT_d,
	.dlen = sizeof(rsa_pss_163_CRT_d),
	.e = (const u8*)&rsa_pss_163_CRT_e,
	.elen = sizeof(rsa_pss_163_CRT_e),
	.p = (const u8*)&rsa_pss_163_CRT_p,
	.plen = sizeof(rsa_pss_163_CRT_p),
	.q = (const u8*)&rsa_pss_163_CRT_q,
	.qlen = sizeof(rsa_pss_163_CRT_q),
	.dP = (const u8*)&rsa_pss_163_CRT_dP,
	.dPlen = sizeof(rsa_pss_163_CRT_dP),
	.dQ = (const u8*)&rsa_pss_163_CRT_dQ,
	.dQlen = sizeof(rsa_pss_163_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_163_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_163_CRT_qInv),
	.m = (const u8*)&rsa_pss_163_CRT_m,
	.mlen = sizeof(rsa_pss_163_CRT_m),
	.res = (const u8*)&rsa_pss_163_CRT_res,
	.reslen = sizeof(rsa_pss_163_CRT_res),
	.salt = (const u8*)&rsa_pss_163_CRT_salt,
	.saltlen = sizeof(rsa_pss_163_CRT_salt),
};
static const u8 rsa_pss_164_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_164_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_164_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_164_m[] = {
0xe1, 0x7d, 0x20, 0x38, 0x5d, 0x50, 0x19, 0x55, 0x82, 0x3c, 0x3f, 0x66, 0x62, 0x54, 0xc1, 0xd3, 0xdd, 0x36, 0xad, 0x51, 0x68, 0xb8, 0xf1, 0x8d, 0x28, 0x6f, 0xdc, 0xf6, 0x7a, 0x7d, 0xad, 0x94, 0x09, 0x70, 0x85, 0xfa, 0xb7, 0xed, 0x86, 0xfe, 0x21, 0x42, 0xa2, 0x87, 0x71, 0x71, 0x79, 0x97, 0xef, 0x1a, 0x7a, 0x08, 0x88, 0x4e, 0xfc, 0x39, 0x35, 0x6d, 0x76, 0x07, 0x7a, 0xaf, 0x82, 0x45, 0x9a, 0x7f, 0xad, 0x45, 0x84, 0x88, 0x75, 0xf2, 0x81, 0x9b, 0x09, 0x89, 0x37, 0xfe, 0x92, 0x3b, 0xcc, 0x9d, 0xc4, 0x42, 0xd7, 0x2d, 0x75, 0x4d, 0x81, 0x20, 0x25, 0x09, 0x0c, 0x9b, 0xc0, 0x3d, 0xb3, 0x08, 0x0c, 0x13, 0x8d, 0xd6, 0x3b, 0x35, 0x5d, 0x0b, 0x4b, 0x85, 0xd6, 0x68, 0x8a, 0xc1, 0x9f, 0x4d, 0xe1, 0x50, 0x84, 0xa0, 0xba, 0x4e, 0x37, 0x3b, 0x93, 0xef, 0x4a, 0x55, 0x50, 0x96, 0x69, 0x19, 0x15, 0xdc, 0x23, 0xc0, 0x0e, 0x95, 0x4c, 0xde, 0xb2, 0x0a, 0x47, 0xcd, 0x55, 0xd1, 0x6c, 0x3d, 0x86, 0x81, 0xd4, 0x6e, 0xd7, 0xf2, 0xed, 0x5e, 0xa4, 0x27, 0x95, 0xbe, 0x17, 0xba, 0xed, 0x25, 0xf0, 0xf4, 0xd1, 0x13, 0xb3, 0x63, 0x6a, 0xdd, 0xd5, 0x85, 0xf1, 0x6a, 0x8b, 0x5a, 0xec, 0x0c, 0x8f, 0xa9, 0xc5, 0xf0, 0x3c, 0xbf, 0x3b, 0x9b, 0x73, 
};
static const u8 rsa_pss_164_res[] = {
0x02, 0x2a, 0x80, 0x04, 0x53, 0x53, 0x90, 0x4c, 0xb3, 0x0c, 0xbb, 0x54, 0x2d, 0x7d, 0x49, 0x90, 0x42, 0x1a, 0x6e, 0xec, 0x16, 0xa8, 0x02, 0x9a, 0x84, 0x22, 0xad, 0xfd, 0x22, 0xd6, 0xaf, 0xf8, 0xc4, 0xcc, 0x02, 0x94, 0xaf, 0x11, 0x0a, 0x0c, 0x06, 0x7e, 0xc8, 0x6a, 0x7d, 0x36, 0x41, 0x34, 0x45, 0x9b, 0xb1, 0xae, 0x8f, 0xf8, 0x36, 0xd5, 0xa8, 0xa2, 0x57, 0x98, 0x40, 0x99, 0x6b, 0x32, 0x0b, 0x19, 0xf1, 0x3a, 0x13, 0xfa, 0xd3, 0x78, 0xd9, 0x31, 0xa6, 0x56, 0x25, 0xda, 0xe2, 0x73, 0x9f, 0x0c, 0x53, 0x67, 0x0b, 0x35, 0xd9, 0xd3, 0xcb, 0xac, 0x08, 0xe7, 0x33, 0xe4, 0xec, 0x2b, 0x83, 0xaf, 0x4b, 0x91, 0x96, 0xd6, 0x3e, 0x7c, 0x4f, 0xf1, 0xdd, 0xea, 0xe2, 0xa1, 0x22, 0x79, 0x1a, 0x12, 0x5b, 0xfe, 0xa8, 0xde, 0xb0, 0xde, 0x8c, 0xcf, 0x1f, 0x4f, 0xfa, 0xf6, 0xe6, 0xfb, 0x0a, 
};
static const u8 rsa_pss_164_salt[] = {
0x24, 0x97, 0xdc, 0x2b, 0x46, 0x15, 0xdf, 0xae, 0x5a, 0x66, 0x3d, 0x49, 0xff, 0xd5, 0x6b, 0xf7, 0xef, 0xc1, 0x13, 0x04, 
};


static const rsa_test test_rsa_pss_164 = {
	.name = "rsa_pss_164",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_164_n,
	.nlen = sizeof(rsa_pss_164_n),
	.d = (const u8*)&rsa_pss_164_d,
	.dlen = sizeof(rsa_pss_164_d),
	.e = (const u8*)&rsa_pss_164_e,
	.elen = sizeof(rsa_pss_164_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_164_m,
	.mlen = sizeof(rsa_pss_164_m),
	.res = (const u8*)&rsa_pss_164_res,
	.reslen = sizeof(rsa_pss_164_res),
	.salt = (const u8*)&rsa_pss_164_salt,
	.saltlen = sizeof(rsa_pss_164_salt),
};
static const u8 rsa_pss_165_CRT_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_165_CRT_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_165_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_165_CRT_m[] = {
0xe1, 0x7d, 0x20, 0x38, 0x5d, 0x50, 0x19, 0x55, 0x82, 0x3c, 0x3f, 0x66, 0x62, 0x54, 0xc1, 0xd3, 0xdd, 0x36, 0xad, 0x51, 0x68, 0xb8, 0xf1, 0x8d, 0x28, 0x6f, 0xdc, 0xf6, 0x7a, 0x7d, 0xad, 0x94, 0x09, 0x70, 0x85, 0xfa, 0xb7, 0xed, 0x86, 0xfe, 0x21, 0x42, 0xa2, 0x87, 0x71, 0x71, 0x79, 0x97, 0xef, 0x1a, 0x7a, 0x08, 0x88, 0x4e, 0xfc, 0x39, 0x35, 0x6d, 0x76, 0x07, 0x7a, 0xaf, 0x82, 0x45, 0x9a, 0x7f, 0xad, 0x45, 0x84, 0x88, 0x75, 0xf2, 0x81, 0x9b, 0x09, 0x89, 0x37, 0xfe, 0x92, 0x3b, 0xcc, 0x9d, 0xc4, 0x42, 0xd7, 0x2d, 0x75, 0x4d, 0x81, 0x20, 0x25, 0x09, 0x0c, 0x9b, 0xc0, 0x3d, 0xb3, 0x08, 0x0c, 0x13, 0x8d, 0xd6, 0x3b, 0x35, 0x5d, 0x0b, 0x4b, 0x85, 0xd6, 0x68, 0x8a, 0xc1, 0x9f, 0x4d, 0xe1, 0x50, 0x84, 0xa0, 0xba, 0x4e, 0x37, 0x3b, 0x93, 0xef, 0x4a, 0x55, 0x50, 0x96, 0x69, 0x19, 0x15, 0xdc, 0x23, 0xc0, 0x0e, 0x95, 0x4c, 0xde, 0xb2, 0x0a, 0x47, 0xcd, 0x55, 0xd1, 0x6c, 0x3d, 0x86, 0x81, 0xd4, 0x6e, 0xd7, 0xf2, 0xed, 0x5e, 0xa4, 0x27, 0x95, 0xbe, 0x17, 0xba, 0xed, 0x25, 0xf0, 0xf4, 0xd1, 0x13, 0xb3, 0x63, 0x6a, 0xdd, 0xd5, 0x85, 0xf1, 0x6a, 0x8b, 0x5a, 0xec, 0x0c, 0x8f, 0xa9, 0xc5, 0xf0, 0x3c, 0xbf, 0x3b, 0x9b, 0x73, 
};
static const u8 rsa_pss_165_CRT_res[] = {
0x02, 0x2a, 0x80, 0x04, 0x53, 0x53, 0x90, 0x4c, 0xb3, 0x0c, 0xbb, 0x54, 0x2d, 0x7d, 0x49, 0x90, 0x42, 0x1a, 0x6e, 0xec, 0x16, 0xa8, 0x02, 0x9a, 0x84, 0x22, 0xad, 0xfd, 0x22, 0xd6, 0xaf, 0xf8, 0xc4, 0xcc, 0x02, 0x94, 0xaf, 0x11, 0x0a, 0x0c, 0x06, 0x7e, 0xc8, 0x6a, 0x7d, 0x36, 0x41, 0x34, 0x45, 0x9b, 0xb1, 0xae, 0x8f, 0xf8, 0x36, 0xd5, 0xa8, 0xa2, 0x57, 0x98, 0x40, 0x99, 0x6b, 0x32, 0x0b, 0x19, 0xf1, 0x3a, 0x13, 0xfa, 0xd3, 0x78, 0xd9, 0x31, 0xa6, 0x56, 0x25, 0xda, 0xe2, 0x73, 0x9f, 0x0c, 0x53, 0x67, 0x0b, 0x35, 0xd9, 0xd3, 0xcb, 0xac, 0x08, 0xe7, 0x33, 0xe4, 0xec, 0x2b, 0x83, 0xaf, 0x4b, 0x91, 0x96, 0xd6, 0x3e, 0x7c, 0x4f, 0xf1, 0xdd, 0xea, 0xe2, 0xa1, 0x22, 0x79, 0x1a, 0x12, 0x5b, 0xfe, 0xa8, 0xde, 0xb0, 0xde, 0x8c, 0xcf, 0x1f, 0x4f, 0xfa, 0xf6, 0xe6, 0xfb, 0x0a, 
};
static const u8 rsa_pss_165_CRT_salt[] = {
0x24, 0x97, 0xdc, 0x2b, 0x46, 0x15, 0xdf, 0xae, 0x5a, 0x66, 0x3d, 0x49, 0xff, 0xd5, 0x6b, 0xf7, 0xef, 0xc1, 0x13, 0x04, 
};
static const u8 rsa_pss_165_CRT_p[] = {
0x02, 0x92, 0x32, 0x33, 0x6d, 0x28, 0x38, 0x94, 0x5d, 0xba, 0x9d, 0xd7, 0x72, 0x3f, 0x4e, 0x62, 0x4a, 0x05, 0xf7, 0x37, 0x5b, 0x92, 0x7a, 0x87, 0xab, 0xe6, 0xa8, 0x93, 0xa1, 0x65, 0x8f, 0xd4, 0x9f, 0x47, 0xf6, 0xc7, 0xb0, 0xfa, 0x59, 0x6c, 0x65, 0xfa, 0x68, 0xa2, 0x3f, 0x0a, 0xb4, 0x32, 0x96, 0x2d, 0x18, 0xd4, 0x34, 0x3b, 0xd6, 0xfd, 0x67, 0x1a, 0x5e, 0xa8, 0xd1, 0x48, 0x41, 0x39, 0x95, 
};
static const u8 rsa_pss_165_CRT_q[] = {
0x02, 0x0e, 0xf5, 0xef, 0xe7, 0xc5, 0x39, 0x4a, 0xed, 0x22, 0x72, 0xf7, 0xe8, 0x1a, 0x74, 0xf4, 0xc0, 0x2d, 0x14, 0x58, 0x94, 0xcb, 0x1b, 0x3c, 0xab, 0x23, 0xa9, 0xa0, 0x71, 0x0a, 0x2a, 0xfc, 0x7e, 0x33, 0x29, 0xac, 0xbb, 0x74, 0x3d, 0x01, 0xf6, 0x80, 0xc4, 0xd0, 0x2a, 0xfb, 0x4c, 0x8f, 0xde, 0x7e, 0x20, 0x93, 0x08, 0x11, 0xbb, 0x2b, 0x99, 0x57, 0x88, 0xb5, 0xe8, 0x72, 0xc2, 0x0b, 0xb1, 
};
static const u8 rsa_pss_165_CRT_dP[] = {
0x02, 0x6e, 0x7e, 0x28, 0x01, 0x0e, 0xcf, 0x24, 0x12, 0xd9, 0x52, 0x3a, 0xd7, 0x04, 0x64, 0x7f, 0xb4, 0xfe, 0x9b, 0x66, 0xb1, 0xa6, 0x81, 0x58, 0x1b, 0x0e, 0x15, 0x55, 0x3a, 0x89, 0xb1, 0x54, 0x28, 0x28, 0x89, 0x8f, 0x27, 0x24, 0x3e, 0xba, 0xb4, 0x5f, 0xf5, 0xe1, 0xac, 0xb9, 0xd4, 0xdf, 0x1b, 0x05, 0x1f, 0xbc, 0x62, 0x82, 0x4d, 0xbc, 0x6f, 0x6c, 0x93, 0x26, 0x1a, 0x78, 0xb9, 0xa7, 0x59, 
};
static const u8 rsa_pss_165_CRT_dQ[] = {
0x01, 0x2d, 0xdc, 0xc8, 0x6e, 0xf6, 0x55, 0x99, 0x8c, 0x39, 0xdd, 0xae, 0x11, 0x71, 0x86, 0x69, 0xe5, 0xe4, 0x6c, 0xf1, 0x49, 0x5b, 0x07, 0xe1, 0x3b, 0x10, 0x14, 0xcd, 0x69, 0xb3, 0xaf, 0x68, 0x30, 0x4a, 0xd2, 0xa6, 0xb6, 0x43, 0x21, 0xe7, 0x8b, 0xf3, 0xbb, 0xca, 0x9b, 0xb4, 0x94, 0xe9, 0x1d, 0x45, 0x17, 0x17, 0xe2, 0xd9, 0x75, 0x64, 0xc6, 0x54, 0x94, 0x65, 0xd0, 0x20, 0x5c, 0xf4, 0x21, 
};
static const u8 rsa_pss_165_CRT_qInv[] = {
0x01, 0x06, 0x00, 0xc4, 0xc2, 0x18, 0x47, 0x45, 0x9f, 0xe5, 0x76, 0x70, 0x3e, 0x2e, 0xbe, 0xca, 0xe8, 0xa5, 0x09, 0x4e, 0xe6, 0x3f, 0x53, 0x6b, 0xf4, 0xac, 0x68, 0xd3, 0xc1, 0x3e, 0x5e, 0x4f, 0x12, 0xac, 0x5c, 0xc1, 0x0a, 0xb6, 0xa2, 0xd0, 0x5a, 0x19, 0x92, 0x14, 0xd1, 0x82, 0x47, 0x47, 0xd5, 0x51, 0x90, 0x96, 0x36, 0xb7, 0x74, 0xc2, 0x2c, 0xac, 0x0b, 0x83, 0x75, 0x99, 0xab, 0xcc, 0x75, 
};


static const rsa_test test_rsa_pss_165_CRT = {
	.name = "rsa_pss_165_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_165_CRT_n,
	.nlen = sizeof(rsa_pss_165_CRT_n),
	.d = (const u8*)&rsa_pss_165_CRT_d,
	.dlen = sizeof(rsa_pss_165_CRT_d),
	.e = (const u8*)&rsa_pss_165_CRT_e,
	.elen = sizeof(rsa_pss_165_CRT_e),
	.p = (const u8*)&rsa_pss_165_CRT_p,
	.plen = sizeof(rsa_pss_165_CRT_p),
	.q = (const u8*)&rsa_pss_165_CRT_q,
	.qlen = sizeof(rsa_pss_165_CRT_q),
	.dP = (const u8*)&rsa_pss_165_CRT_dP,
	.dPlen = sizeof(rsa_pss_165_CRT_dP),
	.dQ = (const u8*)&rsa_pss_165_CRT_dQ,
	.dQlen = sizeof(rsa_pss_165_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_165_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_165_CRT_qInv),
	.m = (const u8*)&rsa_pss_165_CRT_m,
	.mlen = sizeof(rsa_pss_165_CRT_m),
	.res = (const u8*)&rsa_pss_165_CRT_res,
	.reslen = sizeof(rsa_pss_165_CRT_res),
	.salt = (const u8*)&rsa_pss_165_CRT_salt,
	.saltlen = sizeof(rsa_pss_165_CRT_salt),
};
static const u8 rsa_pss_166_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_166_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_166_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_166_m[] = {
0xaf, 0xbc, 0x19, 0xd4, 0x79, 0x24, 0x90, 0x18, 0xfd, 0xf4, 0xe0, 0x9f, 0x61, 0x87, 0x26, 0x44, 0x04, 0x95, 0xde, 0x11, 0xdd, 0xee, 0xe3, 0x88, 0x72, 0xd7, 0x75, 0xfc, 0xea, 0x74, 0xa2, 0x38, 0x96, 0xb5, 0x34, 0x3c, 0x9c, 0x38, 0xd4, 0x6a, 0xf0, 0xdb, 0xa2, 0x24, 0xd0, 0x47, 0x58, 0x0c, 0xc6, 0x0a, 0x65, 0xe9, 0x39, 0x1c, 0xf9, 0xb5, 0x9b, 0x36, 0xa8, 0x60, 0x59, 0x8d, 0x4e, 0x82, 0x16, 0x72, 0x2f, 0x99, 0x3b, 0x91, 0xcf, 0xae, 0x87, 0xbc, 0x25, 0x5a, 0xf8, 0x9a, 0x6a, 0x19, 0x9b, 0xca, 0x4a, 0x39, 0x1e, 0xad, 0xbc, 0x3a, 0x24, 0x90, 0x3c, 0x0b, 0xd6, 0x67, 0x36, 0x8f, 0x6b, 0xe7, 0x8e, 0x3f, 0xea, 0xbf, 0xb4, 0xff, 0xd4, 0x63, 0x12, 0x27, 0x63, 0x74, 0x0f, 0xfb, 0xbe, 0xfe, 0xab, 0x9a, 0x25, 0x56, 0x4b, 0xc5, 0xd1, 0xc2, 0x4c, 0x93, 0xe4, 0x22, 0xf7, 0x50, 0x73, 0xe2, 0xad, 0x72, 0xbf, 0x45, 0xb1, 0x0d, 0xf0, 0x0b, 0x52, 0xa1, 0x47, 0x12, 0x8e, 0x73, 0xfe, 0xe3, 0x3f, 0xa3, 0xf0, 0x57, 0x7d, 0x77, 0xf8, 0x0f, 0xbc, 0x2d, 0xf1, 0xbe, 0xd3, 0x13, 0x29, 0x0c, 0x12, 0x77, 0x7f, 0x50, 
};
static const u8 rsa_pss_166_res[] = {
0x00, 0x93, 0x8d, 0xcb, 0x6d, 0x58, 0x30, 0x46, 0x06, 0x5f, 0x69, 0xc7, 0x8d, 0xa7, 0xa1, 0xf1, 0x75, 0x70, 0x66, 0xa7, 0xfa, 0x75, 0x12, 0x5a, 0x9d, 0x29, 0x29, 0xf0, 0xb7, 0x9a, 0x60, 0xb6, 0x27, 0xb0, 0x82, 0xf1, 0x1f, 0x5b, 0x19, 0x6f, 0x28, 0xeb, 0x9d, 0xaa, 0x6f, 0x21, 0xc0, 0x5e, 0x51, 0x40, 0xf6, 0xae, 0xf1, 0x73, 0x7d, 0x20, 0x23, 0x07, 0x5c, 0x05, 0xec, 0xf0, 0x4a, 0x02, 0x8c, 0x68, 0x6a, 0x2a, 0xb3, 0xe7, 0xd5, 0xa0, 0x66, 0x4f, 0x29, 0x5c, 0xe1, 0x29, 0x95, 0xe8, 0x90, 0x90, 0x8b, 0x6a, 0xd2, 0x1f, 0x08, 0x39, 0xeb, 0x65, 0xb7, 0x03, 0x93, 0xa7, 0xb5, 0xaf, 0xd9, 0x87, 0x1d, 0xe0, 0xca, 0xa0, 0xce, 0xde, 0xc5, 0xb8, 0x19, 0x62, 0x67, 0x56, 0x20, 0x9d, 0x13, 0xab, 0x1e, 0x7b, 0xb9, 0x54, 0x6a, 0x26, 0xff, 0x37, 0xe9, 0xa5, 0x1a, 0xf9, 0xfd, 0x56, 0x2e, 
};
static const u8 rsa_pss_166_salt[] = {
0xa3, 0x34, 0xdb, 0x6f, 0xae, 0xbf, 0x11, 0x08, 0x1a, 0x04, 0xf8, 0x7c, 0x2d, 0x62, 0x1c, 0xde, 0xc7, 0x93, 0x0b, 0x9b, 
};


static const rsa_test test_rsa_pss_166 = {
	.name = "rsa_pss_166",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_166_n,
	.nlen = sizeof(rsa_pss_166_n),
	.d = (const u8*)&rsa_pss_166_d,
	.dlen = sizeof(rsa_pss_166_d),
	.e = (const u8*)&rsa_pss_166_e,
	.elen = sizeof(rsa_pss_166_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_166_m,
	.mlen = sizeof(rsa_pss_166_m),
	.res = (const u8*)&rsa_pss_166_res,
	.reslen = sizeof(rsa_pss_166_res),
	.salt = (const u8*)&rsa_pss_166_salt,
	.saltlen = sizeof(rsa_pss_166_salt),
};
static const u8 rsa_pss_167_CRT_n[] = {
0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05, 
};
static const u8 rsa_pss_167_CRT_d[] = {
0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11, 
};
static const u8 rsa_pss_167_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_167_CRT_m[] = {
0xaf, 0xbc, 0x19, 0xd4, 0x79, 0x24, 0x90, 0x18, 0xfd, 0xf4, 0xe0, 0x9f, 0x61, 0x87, 0x26, 0x44, 0x04, 0x95, 0xde, 0x11, 0xdd, 0xee, 0xe3, 0x88, 0x72, 0xd7, 0x75, 0xfc, 0xea, 0x74, 0xa2, 0x38, 0x96, 0xb5, 0x34, 0x3c, 0x9c, 0x38, 0xd4, 0x6a, 0xf0, 0xdb, 0xa2, 0x24, 0xd0, 0x47, 0x58, 0x0c, 0xc6, 0x0a, 0x65, 0xe9, 0x39, 0x1c, 0xf9, 0xb5, 0x9b, 0x36, 0xa8, 0x60, 0x59, 0x8d, 0x4e, 0x82, 0x16, 0x72, 0x2f, 0x99, 0x3b, 0x91, 0xcf, 0xae, 0x87, 0xbc, 0x25, 0x5a, 0xf8, 0x9a, 0x6a, 0x19, 0x9b, 0xca, 0x4a, 0x39, 0x1e, 0xad, 0xbc, 0x3a, 0x24, 0x90, 0x3c, 0x0b, 0xd6, 0x67, 0x36, 0x8f, 0x6b, 0xe7, 0x8e, 0x3f, 0xea, 0xbf, 0xb4, 0xff, 0xd4, 0x63, 0x12, 0x27, 0x63, 0x74, 0x0f, 0xfb, 0xbe, 0xfe, 0xab, 0x9a, 0x25, 0x56, 0x4b, 0xc5, 0xd1, 0xc2, 0x4c, 0x93, 0xe4, 0x22, 0xf7, 0x50, 0x73, 0xe2, 0xad, 0x72, 0xbf, 0x45, 0xb1, 0x0d, 0xf0, 0x0b, 0x52, 0xa1, 0x47, 0x12, 0x8e, 0x73, 0xfe, 0xe3, 0x3f, 0xa3, 0xf0, 0x57, 0x7d, 0x77, 0xf8, 0x0f, 0xbc, 0x2d, 0xf1, 0xbe, 0xd3, 0x13, 0x29, 0x0c, 0x12, 0x77, 0x7f, 0x50, 
};
static const u8 rsa_pss_167_CRT_res[] = {
0x00, 0x93, 0x8d, 0xcb, 0x6d, 0x58, 0x30, 0x46, 0x06, 0x5f, 0x69, 0xc7, 0x8d, 0xa7, 0xa1, 0xf1, 0x75, 0x70, 0x66, 0xa7, 0xfa, 0x75, 0x12, 0x5a, 0x9d, 0x29, 0x29, 0xf0, 0xb7, 0x9a, 0x60, 0xb6, 0x27, 0xb0, 0x82, 0xf1, 0x1f, 0x5b, 0x19, 0x6f, 0x28, 0xeb, 0x9d, 0xaa, 0x6f, 0x21, 0xc0, 0x5e, 0x51, 0x40, 0xf6, 0xae, 0xf1, 0x73, 0x7d, 0x20, 0x23, 0x07, 0x5c, 0x05, 0xec, 0xf0, 0x4a, 0x02, 0x8c, 0x68, 0x6a, 0x2a, 0xb3, 0xe7, 0xd5, 0xa0, 0x66, 0x4f, 0x29, 0x5c, 0xe1, 0x29, 0x95, 0xe8, 0x90, 0x90, 0x8b, 0x6a, 0xd2, 0x1f, 0x08, 0x39, 0xeb, 0x65, 0xb7, 0x03, 0x93, 0xa7, 0xb5, 0xaf, 0xd9, 0x87, 0x1d, 0xe0, 0xca, 0xa0, 0xce, 0xde, 0xc5, 0xb8, 0x19, 0x62, 0x67, 0x56, 0x20, 0x9d, 0x13, 0xab, 0x1e, 0x7b, 0xb9, 0x54, 0x6a, 0x26, 0xff, 0x37, 0xe9, 0xa5, 0x1a, 0xf9, 0xfd, 0x56, 0x2e, 
};
static const u8 rsa_pss_167_CRT_salt[] = {
0xa3, 0x34, 0xdb, 0x6f, 0xae, 0xbf, 0x11, 0x08, 0x1a, 0x04, 0xf8, 0x7c, 0x2d, 0x62, 0x1c, 0xde, 0xc7, 0x93, 0x0b, 0x9b, 
};
static const u8 rsa_pss_167_CRT_p[] = {
0x02, 0x92, 0x32, 0x33, 0x6d, 0x28, 0x38, 0x94, 0x5d, 0xba, 0x9d, 0xd7, 0x72, 0x3f, 0x4e, 0x62, 0x4a, 0x05, 0xf7, 0x37, 0x5b, 0x92, 0x7a, 0x87, 0xab, 0xe6, 0xa8, 0x93, 0xa1, 0x65, 0x8f, 0xd4, 0x9f, 0x47, 0xf6, 0xc7, 0xb0, 0xfa, 0x59, 0x6c, 0x65, 0xfa, 0x68, 0xa2, 0x3f, 0x0a, 0xb4, 0x32, 0x96, 0x2d, 0x18, 0xd4, 0x34, 0x3b, 0xd6, 0xfd, 0x67, 0x1a, 0x5e, 0xa8, 0xd1, 0x48, 0x41, 0x39, 0x95, 
};
static const u8 rsa_pss_167_CRT_q[] = {
0x02, 0x0e, 0xf5, 0xef, 0xe7, 0xc5, 0x39, 0x4a, 0xed, 0x22, 0x72, 0xf7, 0xe8, 0x1a, 0x74, 0xf4, 0xc0, 0x2d, 0x14, 0x58, 0x94, 0xcb, 0x1b, 0x3c, 0xab, 0x23, 0xa9, 0xa0, 0x71, 0x0a, 0x2a, 0xfc, 0x7e, 0x33, 0x29, 0xac, 0xbb, 0x74, 0x3d, 0x01, 0xf6, 0x80, 0xc4, 0xd0, 0x2a, 0xfb, 0x4c, 0x8f, 0xde, 0x7e, 0x20, 0x93, 0x08, 0x11, 0xbb, 0x2b, 0x99, 0x57, 0x88, 0xb5, 0xe8, 0x72, 0xc2, 0x0b, 0xb1, 
};
static const u8 rsa_pss_167_CRT_dP[] = {
0x02, 0x6e, 0x7e, 0x28, 0x01, 0x0e, 0xcf, 0x24, 0x12, 0xd9, 0x52, 0x3a, 0xd7, 0x04, 0x64, 0x7f, 0xb4, 0xfe, 0x9b, 0x66, 0xb1, 0xa6, 0x81, 0x58, 0x1b, 0x0e, 0x15, 0x55, 0x3a, 0x89, 0xb1, 0x54, 0x28, 0x28, 0x89, 0x8f, 0x27, 0x24, 0x3e, 0xba, 0xb4, 0x5f, 0xf5, 0xe1, 0xac, 0xb9, 0xd4, 0xdf, 0x1b, 0x05, 0x1f, 0xbc, 0x62, 0x82, 0x4d, 0xbc, 0x6f, 0x6c, 0x93, 0x26, 0x1a, 0x78, 0xb9, 0xa7, 0x59, 
};
static const u8 rsa_pss_167_CRT_dQ[] = {
0x01, 0x2d, 0xdc, 0xc8, 0x6e, 0xf6, 0x55, 0x99, 0x8c, 0x39, 0xdd, 0xae, 0x11, 0x71, 0x86, 0x69, 0xe5, 0xe4, 0x6c, 0xf1, 0x49, 0x5b, 0x07, 0xe1, 0x3b, 0x10, 0x14, 0xcd, 0x69, 0xb3, 0xaf, 0x68, 0x30, 0x4a, 0xd2, 0xa6, 0xb6, 0x43, 0x21, 0xe7, 0x8b, 0xf3, 0xbb, 0xca, 0x9b, 0xb4, 0x94, 0xe9, 0x1d, 0x45, 0x17, 0x17, 0xe2, 0xd9, 0x75, 0x64, 0xc6, 0x54, 0x94, 0x65, 0xd0, 0x20, 0x5c, 0xf4, 0x21, 
};
static const u8 rsa_pss_167_CRT_qInv[] = {
0x01, 0x06, 0x00, 0xc4, 0xc2, 0x18, 0x47, 0x45, 0x9f, 0xe5, 0x76, 0x70, 0x3e, 0x2e, 0xbe, 0xca, 0xe8, 0xa5, 0x09, 0x4e, 0xe6, 0x3f, 0x53, 0x6b, 0xf4, 0xac, 0x68, 0xd3, 0xc1, 0x3e, 0x5e, 0x4f, 0x12, 0xac, 0x5c, 0xc1, 0x0a, 0xb6, 0xa2, 0xd0, 0x5a, 0x19, 0x92, 0x14, 0xd1, 0x82, 0x47, 0x47, 0xd5, 0x51, 0x90, 0x96, 0x36, 0xb7, 0x74, 0xc2, 0x2c, 0xac, 0x0b, 0x83, 0x75, 0x99, 0xab, 0xcc, 0x75, 
};


static const rsa_test test_rsa_pss_167_CRT = {
	.name = "rsa_pss_167_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1027,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_167_CRT_n,
	.nlen = sizeof(rsa_pss_167_CRT_n),
	.d = (const u8*)&rsa_pss_167_CRT_d,
	.dlen = sizeof(rsa_pss_167_CRT_d),
	.e = (const u8*)&rsa_pss_167_CRT_e,
	.elen = sizeof(rsa_pss_167_CRT_e),
	.p = (const u8*)&rsa_pss_167_CRT_p,
	.plen = sizeof(rsa_pss_167_CRT_p),
	.q = (const u8*)&rsa_pss_167_CRT_q,
	.qlen = sizeof(rsa_pss_167_CRT_q),
	.dP = (const u8*)&rsa_pss_167_CRT_dP,
	.dPlen = sizeof(rsa_pss_167_CRT_dP),
	.dQ = (const u8*)&rsa_pss_167_CRT_dQ,
	.dQlen = sizeof(rsa_pss_167_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_167_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_167_CRT_qInv),
	.m = (const u8*)&rsa_pss_167_CRT_m,
	.mlen = sizeof(rsa_pss_167_CRT_m),
	.res = (const u8*)&rsa_pss_167_CRT_res,
	.reslen = sizeof(rsa_pss_167_CRT_res),
	.salt = (const u8*)&rsa_pss_167_CRT_salt,
	.saltlen = sizeof(rsa_pss_167_CRT_salt),
};
static const u8 rsa_pss_168_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_168_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_168_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_168_m[] = {
0x30, 0xc7, 0xd5, 0x57, 0x45, 0x8b, 0x43, 0x6d, 0xec, 0xfd, 0xc1, 0x4d, 0x06, 0xcb, 0x7b, 0x96, 0xb0, 0x67, 0x18, 0xc4, 0x8d, 0x7d, 0xe5, 0x74, 0x82, 0xa8, 0x68, 0xae, 0x7f, 0x06, 0x58, 0x70, 0xa6, 0x21, 0x65, 0x06, 0xd1, 0x1b, 0x77, 0x93, 0x23, 0xdf, 0xdf, 0x04, 0x6c, 0xf5, 0x77, 0x51, 0x29, 0x13, 0x4b, 0x4d, 0x56, 0x89, 0xe4, 0xd9, 0xc0, 0xce, 0x1e, 0x12, 0xd7, 0xd4, 0xb0, 0x6c, 0xb5, 0xfc, 0x58, 0x20, 0xde, 0xcf, 0xa4, 0x1b, 0xaf, 0x59, 0xbf, 0x25, 0x7b, 0x32, 0xf0, 0x25, 0xb7, 0x67, 0x9b, 0x44, 0x5b, 0x94, 0x99, 0xc9, 0x25, 0x55, 0x14, 0x58, 0x85, 0x99, 0x2f, 0x1b, 0x76, 0xf8, 0x48, 0x91, 0xee, 0x4d, 0x3b, 0xe0, 0xf5, 0x15, 0x0f, 0xd5, 0x90, 0x1e, 0x3a, 0x4c, 0x8e, 0xd4, 0x3f, 0xd3, 0x6b, 0x61, 0xd0, 0x22, 0xe6, 0x5a, 0xd5, 0x00, 0x8d, 0xbf, 0x33, 0x29, 0x3c, 0x22, 0xbf, 0xbf, 0xd0, 0x73, 0x21, 0xf0, 0xf1, 0xd5, 0xfa, 0x9f, 0xdf, 0x00, 0x14, 0xc2, 0xfc, 0xb0, 0x35, 0x8a, 0xad, 0x0e, 0x35, 0x4b, 0x0d, 0x29, 
};
static const u8 rsa_pss_168_res[] = {
0x0b, 0xa3, 0x73, 0xf7, 0x6e, 0x09, 0x21, 0xb7, 0x0a, 0x8f, 0xbf, 0xe6, 0x22, 0xf0, 0xbf, 0x77, 0xb2, 0x8a, 0x3d, 0xb9, 0x8e, 0x36, 0x10, 0x51, 0xc3, 0xd7, 0xcb, 0x92, 0xad, 0x04, 0x52, 0x91, 0x5a, 0x4d, 0xe9, 0xc0, 0x17, 0x22, 0xf6, 0x82, 0x3e, 0xeb, 0x6a, 0xdf, 0x7e, 0x0c, 0xa8, 0x29, 0x0f, 0x5d, 0xe3, 0xe5, 0x49, 0x89, 0x0a, 0xc2, 0xa3, 0xc5, 0x95, 0x0a, 0xb2, 0x17, 0xba, 0x58, 0x59, 0x08, 0x94, 0x95, 0x2d, 0xe9, 0x6f, 0x8d, 0xf1, 0x11, 0xb2, 0x57, 0x52, 0x15, 0xda, 0x6c, 0x16, 0x15, 0x90, 0xc7, 0x45, 0xbe, 0x61, 0x24, 0x76, 0xee, 0x57, 0x8e, 0xd3, 0x84, 0xab, 0x33, 0xe3, 0xec, 0xe9, 0x74, 0x81, 0xa2, 0x52, 0xf5, 0xc7, 0x9a, 0x98, 0xb5, 0x53, 0x2a, 0xe0, 0x0c, 0xdd, 0x62, 0xf2, 0xec, 0xc0, 0xcd, 0x1b, 0xae, 0xfe, 0x80, 0xd8, 0x0b, 0x96, 0x21, 0x93, 0xec, 0x1d, 
};
static const u8 rsa_pss_168_salt[] = {
0x08, 0x1b, 0x23, 0x3b, 0x43, 0x56, 0x77, 0x50, 0xbd, 0x6e, 0x78, 0xf3, 0x96, 0xa8, 0x8b, 0x9f, 0x6a, 0x44, 0x51, 0x51, 
};


static const rsa_test test_rsa_pss_168 = {
	.name = "rsa_pss_168",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_168_n,
	.nlen = sizeof(rsa_pss_168_n),
	.d = (const u8*)&rsa_pss_168_d,
	.dlen = sizeof(rsa_pss_168_d),
	.e = (const u8*)&rsa_pss_168_e,
	.elen = sizeof(rsa_pss_168_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_168_m,
	.mlen = sizeof(rsa_pss_168_m),
	.res = (const u8*)&rsa_pss_168_res,
	.reslen = sizeof(rsa_pss_168_res),
	.salt = (const u8*)&rsa_pss_168_salt,
	.saltlen = sizeof(rsa_pss_168_salt),
};
static const u8 rsa_pss_169_CRT_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_169_CRT_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_169_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_169_CRT_m[] = {
0x30, 0xc7, 0xd5, 0x57, 0x45, 0x8b, 0x43, 0x6d, 0xec, 0xfd, 0xc1, 0x4d, 0x06, 0xcb, 0x7b, 0x96, 0xb0, 0x67, 0x18, 0xc4, 0x8d, 0x7d, 0xe5, 0x74, 0x82, 0xa8, 0x68, 0xae, 0x7f, 0x06, 0x58, 0x70, 0xa6, 0x21, 0x65, 0x06, 0xd1, 0x1b, 0x77, 0x93, 0x23, 0xdf, 0xdf, 0x04, 0x6c, 0xf5, 0x77, 0x51, 0x29, 0x13, 0x4b, 0x4d, 0x56, 0x89, 0xe4, 0xd9, 0xc0, 0xce, 0x1e, 0x12, 0xd7, 0xd4, 0xb0, 0x6c, 0xb5, 0xfc, 0x58, 0x20, 0xde, 0xcf, 0xa4, 0x1b, 0xaf, 0x59, 0xbf, 0x25, 0x7b, 0x32, 0xf0, 0x25, 0xb7, 0x67, 0x9b, 0x44, 0x5b, 0x94, 0x99, 0xc9, 0x25, 0x55, 0x14, 0x58, 0x85, 0x99, 0x2f, 0x1b, 0x76, 0xf8, 0x48, 0x91, 0xee, 0x4d, 0x3b, 0xe0, 0xf5, 0x15, 0x0f, 0xd5, 0x90, 0x1e, 0x3a, 0x4c, 0x8e, 0xd4, 0x3f, 0xd3, 0x6b, 0x61, 0xd0, 0x22, 0xe6, 0x5a, 0xd5, 0x00, 0x8d, 0xbf, 0x33, 0x29, 0x3c, 0x22, 0xbf, 0xbf, 0xd0, 0x73, 0x21, 0xf0, 0xf1, 0xd5, 0xfa, 0x9f, 0xdf, 0x00, 0x14, 0xc2, 0xfc, 0xb0, 0x35, 0x8a, 0xad, 0x0e, 0x35, 0x4b, 0x0d, 0x29, 
};
static const u8 rsa_pss_169_CRT_res[] = {
0x0b, 0xa3, 0x73, 0xf7, 0x6e, 0x09, 0x21, 0xb7, 0x0a, 0x8f, 0xbf, 0xe6, 0x22, 0xf0, 0xbf, 0x77, 0xb2, 0x8a, 0x3d, 0xb9, 0x8e, 0x36, 0x10, 0x51, 0xc3, 0xd7, 0xcb, 0x92, 0xad, 0x04, 0x52, 0x91, 0x5a, 0x4d, 0xe9, 0xc0, 0x17, 0x22, 0xf6, 0x82, 0x3e, 0xeb, 0x6a, 0xdf, 0x7e, 0x0c, 0xa8, 0x29, 0x0f, 0x5d, 0xe3, 0xe5, 0x49, 0x89, 0x0a, 0xc2, 0xa3, 0xc5, 0x95, 0x0a, 0xb2, 0x17, 0xba, 0x58, 0x59, 0x08, 0x94, 0x95, 0x2d, 0xe9, 0x6f, 0x8d, 0xf1, 0x11, 0xb2, 0x57, 0x52, 0x15, 0xda, 0x6c, 0x16, 0x15, 0x90, 0xc7, 0x45, 0xbe, 0x61, 0x24, 0x76, 0xee, 0x57, 0x8e, 0xd3, 0x84, 0xab, 0x33, 0xe3, 0xec, 0xe9, 0x74, 0x81, 0xa2, 0x52, 0xf5, 0xc7, 0x9a, 0x98, 0xb5, 0x53, 0x2a, 0xe0, 0x0c, 0xdd, 0x62, 0xf2, 0xec, 0xc0, 0xcd, 0x1b, 0xae, 0xfe, 0x80, 0xd8, 0x0b, 0x96, 0x21, 0x93, 0xec, 0x1d, 
};
static const u8 rsa_pss_169_CRT_salt[] = {
0x08, 0x1b, 0x23, 0x3b, 0x43, 0x56, 0x77, 0x50, 0xbd, 0x6e, 0x78, 0xf3, 0x96, 0xa8, 0x8b, 0x9f, 0x6a, 0x44, 0x51, 0x51, 
};
static const u8 rsa_pss_169_CRT_p[] = {
0x03, 0xf2, 0xf3, 0x31, 0xf4, 0x14, 0x2d, 0x4f, 0x24, 0xb4, 0x3a, 0xa1, 0x02, 0x79, 0xa8, 0x96, 0x52, 0xd4, 0xe7, 0x53, 0x72, 0x21, 0xa1, 0xa7, 0xb2, 0xa2, 0x5d, 0xeb, 0x55, 0x1e, 0x5d, 0xe9, 0xac, 0x49, 0x74, 0x11, 0xc2, 0x27, 0xa9, 0x4e, 0x45, 0xf9, 0x1c, 0x2d, 0x1c, 0x13, 0xcc, 0x04, 0x6c, 0xf4, 0xce, 0x14, 0xe3, 0x2d, 0x05, 0x87, 0x34, 0x21, 0x0d, 0x44, 0xa8, 0x7e, 0xe1, 0xb7, 0x3f, 
};
static const u8 rsa_pss_169_CRT_q[] = {
0x03, 0x4f, 0x09, 0x0d, 0x73, 0xb5, 0x58, 0x03, 0x03, 0x0c, 0xf0, 0x36, 0x1a, 0x5d, 0x80, 0x81, 0xbf, 0xb7, 0x9f, 0x85, 0x15, 0x23, 0xfe, 0xac, 0x0a, 0x21, 0x24, 0xd0, 0x8d, 0x40, 0x13, 0xff, 0x08, 0x48, 0x77, 0x71, 0xa8, 0x70, 0xd0, 0x47, 0x9d, 0xc0, 0x68, 0x6c, 0x62, 0xf7, 0x71, 0x8d, 0xfe, 0xcf, 0x02, 0x4b, 0x17, 0xc9, 0x26, 0x76, 0x78, 0x05, 0x91, 0x71, 0x33, 0x9c, 0xc0, 0x08, 0x39, 
};
static const u8 rsa_pss_169_CRT_dP[] = {
0x02, 0xaa, 0x66, 0x3a, 0xdb, 0xf5, 0x1a, 0xb8, 0x87, 0xa0, 0x18, 0xcb, 0x42, 0x6e, 0x78, 0xbc, 0x2f, 0xe1, 0x82, 0xdc, 0xb2, 0xf7, 0xbc, 0xb5, 0x04, 0x41, 0xd1, 0x7f, 0xdf, 0x0f, 0x06, 0x79, 0x8b, 0x50, 0x71, 0xc6, 0xe2, 0xf5, 0xfe, 0xb4, 0xd5, 0x4a, 0xd8, 0x18, 0x23, 0x11, 0xc1, 0xef, 0x62, 0xd4, 0xc4, 0x9f, 0x18, 0xd1, 0xf5, 0x1f, 0x54, 0xb2, 0xd2, 0xcf, 0xfb, 0xa4, 0xda, 0x1b, 0xe5, 
};
static const u8 rsa_pss_169_CRT_dQ[] = {
0x02, 0xbb, 0xe7, 0x06, 0x07, 0x8b, 0x5c, 0x0b, 0x39, 0x15, 0x12, 0xd4, 0x11, 0xdb, 0x1b, 0x19, 0x9b, 0x5a, 0x56, 0x64, 0xb8, 0x40, 0x42, 0xea, 0xd3, 0x7f, 0xe9, 0x94, 0xae, 0x72, 0xb9, 0x53, 0x2d, 0xfb, 0xfb, 0x3e, 0x9e, 0x69, 0x81, 0xa0, 0xfb, 0xb8, 0x06, 0x51, 0x31, 0x41, 0xb7, 0xc2, 0x16, 0x3f, 0xe5, 0x6c, 0x39, 0x5e, 0x4b, 0xfa, 0xee, 0x57, 0xe3, 0x83, 0x3f, 0x9b, 0x91, 0x8d, 0xf9, 
};
static const u8 rsa_pss_169_CRT_qInv[] = {
0x02, 0x42, 0xb6, 0xcd, 0x00, 0xd3, 0x0a, 0x76, 0x7a, 0xee, 0x9a, 0x89, 0x8e, 0xad, 0x45, 0x3c, 0x8e, 0xae, 0xa6, 0x3d, 0x50, 0x0b, 0x7d, 0x1e, 0x00, 0x71, 0x3e, 0xda, 0xe5, 0x1c, 0xe3, 0x6b, 0x23, 0xb6, 0x64, 0xdf, 0x26, 0xe6, 0x3e, 0x26, 0x6e, 0xc8, 0xf7, 0x6e, 0x6e, 0x63, 0xed, 0x1b, 0xa4, 0x1e, 0xb0, 0x33, 0xb1, 0x20, 0xf7, 0xea, 0x52, 0x12, 0xae, 0x21, 0xa9, 0x8f, 0xbc, 0x16, 
};


static const rsa_test test_rsa_pss_169_CRT = {
	.name = "rsa_pss_169_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_169_CRT_n,
	.nlen = sizeof(rsa_pss_169_CRT_n),
	.d = (const u8*)&rsa_pss_169_CRT_d,
	.dlen = sizeof(rsa_pss_169_CRT_d),
	.e = (const u8*)&rsa_pss_169_CRT_e,
	.elen = sizeof(rsa_pss_169_CRT_e),
	.p = (const u8*)&rsa_pss_169_CRT_p,
	.plen = sizeof(rsa_pss_169_CRT_p),
	.q = (const u8*)&rsa_pss_169_CRT_q,
	.qlen = sizeof(rsa_pss_169_CRT_q),
	.dP = (const u8*)&rsa_pss_169_CRT_dP,
	.dPlen = sizeof(rsa_pss_169_CRT_dP),
	.dQ = (const u8*)&rsa_pss_169_CRT_dQ,
	.dQlen = sizeof(rsa_pss_169_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_169_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_169_CRT_qInv),
	.m = (const u8*)&rsa_pss_169_CRT_m,
	.mlen = sizeof(rsa_pss_169_CRT_m),
	.res = (const u8*)&rsa_pss_169_CRT_res,
	.reslen = sizeof(rsa_pss_169_CRT_res),
	.salt = (const u8*)&rsa_pss_169_CRT_salt,
	.saltlen = sizeof(rsa_pss_169_CRT_salt),
};
static const u8 rsa_pss_170_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_170_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_170_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_170_m[] = {
0xe7, 0xb3, 0x2e, 0x15, 0x56, 0xea, 0x1b, 0x27, 0x95, 0x04, 0x6a, 0xc6, 0x97, 0x39, 0xd2, 0x2a, 0xc8, 0x96, 0x6b, 0xf1, 0x1c, 0x11, 0x6f, 0x61, 0x4b, 0x16, 0x67, 0x40, 0xe9, 0x6b, 0x90, 0x65, 0x3e, 0x57, 0x50, 0x94, 0x5f, 0xcf, 0x77, 0x21, 0x86, 0xc0, 0x37, 0x90, 0xa0, 0x7f, 0xda, 0x32, 0x3e, 0x1a, 0x61, 0x91, 0x6b, 0x06, 0xee, 0x21, 0x57, 0xdb, 0x3d, 0xff, 0x80, 0xd6, 0x7d, 0x5e, 0x39, 0xa5, 0x3a, 0xe2, 0x68, 0xc8, 0xf0, 0x9e, 0xd9, 0x9a, 0x73, 0x20, 0x05, 0xb0, 0xbc, 0x6a, 0x04, 0xaf, 0x4e, 0x08, 0xd5, 0x7a, 0x00, 0xe7, 0x20, 0x1b, 0x30, 0x60, 0xef, 0xaa, 0xdb, 0x73, 0x11, 0x3b, 0xfc, 0x08, 0x7f, 0xd8, 0x37, 0x09, 0x3a, 0xa2, 0x52, 0x35, 0xb8, 0xc1, 0x49, 0xf5, 0x62, 0x15, 0xf0, 0x31, 0xc2, 0x4a, 0xd5, 0xbd, 0xe7, 0xf2, 0x99, 0x60, 0xdf, 0x7d, 0x52, 0x40, 0x70, 0xf7, 0x44, 0x9c, 0x6f, 0x78, 0x50, 0x84, 0xbe, 0x1a, 0x0f, 0x73, 0x30, 0x47, 0xf3, 0x36, 0xf9, 0x15, 0x47, 0x38, 0x67, 0x45, 0x47, 0xdb, 0x02, 0xa9, 0xf4, 0x4d, 0xfc, 0x6e, 0x60, 0x30, 0x10, 0x81, 0xe1, 0xce, 0x99, 0x84, 0x7f, 0x3b, 0x5b, 0x60, 0x1f, 0xf0, 0x6b, 0x4d, 0x57, 0x76, 0xa9, 0x74, 0x0b, 0x9a, 0xa0, 0xd3, 0x40, 0x58, 0xfd, 0x3b, 0x90, 0x6e, 0x4f, 0x78, 0x59, 0xdf, 0xb0, 0x7d, 0x71, 0x73, 0xe5, 0xe6, 0xf6, 0x35, 0x0a, 0xda, 0xc2, 0x1f, 0x27, 0xb2, 0x30, 0x74, 0x69, 
};
static const u8 rsa_pss_170_res[] = {
0x08, 0x18, 0x0d, 0xe8, 0x25, 0xe4, 0xb8, 0xb0, 0x14, 0xa3, 0x2d, 0xa8, 0xba, 0x76, 0x15, 0x55, 0x92, 0x12, 0x04, 0xf2, 0xf9, 0x0d, 0x5f, 0x24, 0xb7, 0x12, 0x90, 0x8f, 0xf8, 0x4f, 0x3e, 0x22, 0x0a, 0xd1, 0x79, 0x97, 0xc0, 0xdd, 0x6e, 0x70, 0x66, 0x30, 0xba, 0x3e, 0x84, 0xad, 0xd4, 0xd5, 0xe7, 0xab, 0x00, 0x4e, 0x58, 0x07, 0x4b, 0x54, 0x97, 0x09, 0x56, 0x5d, 0x43, 0xad, 0x9e, 0x97, 0xb5, 0xa7, 0xa1, 0xa2, 0x9e, 0x85, 0xb9, 0xf9, 0x0f, 0x4a, 0xaf, 0xcd, 0xf5, 0x83, 0x21, 0xde, 0x8c, 0x59, 0x74, 0xef, 0x9a, 0xbf, 0x2d, 0x52, 0x6f, 0x33, 0xc0, 0xf2, 0xf8, 0x2e, 0x95, 0xd1, 0x58, 0xea, 0x6b, 0x81, 0xf1, 0x73, 0x6d, 0xb8, 0xd1, 0xaf, 0x3d, 0x6a, 0xc6, 0xa8, 0x3b, 0x32, 0xd1, 0x8b, 0xae, 0x0f, 0xf1, 0xb2, 0xfe, 0x27, 0xde, 0x4c, 0x76, 0xed, 0x8c, 0x79, 0x80, 0xa3, 0x4e, 
};
static const u8 rsa_pss_170_salt[] = {
0xbd, 0x0c, 0xe1, 0x95, 0x49, 0xd0, 0x70, 0x01, 0x20, 0xcb, 0xe5, 0x10, 0x77, 0xdb, 0xbb, 0xb0, 0x0a, 0x8d, 0x8b, 0x09, 
};


static const rsa_test test_rsa_pss_170 = {
	.name = "rsa_pss_170",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_170_n,
	.nlen = sizeof(rsa_pss_170_n),
	.d = (const u8*)&rsa_pss_170_d,
	.dlen = sizeof(rsa_pss_170_d),
	.e = (const u8*)&rsa_pss_170_e,
	.elen = sizeof(rsa_pss_170_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_170_m,
	.mlen = sizeof(rsa_pss_170_m),
	.res = (const u8*)&rsa_pss_170_res,
	.reslen = sizeof(rsa_pss_170_res),
	.salt = (const u8*)&rsa_pss_170_salt,
	.saltlen = sizeof(rsa_pss_170_salt),
};
static const u8 rsa_pss_171_CRT_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_171_CRT_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_171_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_171_CRT_m[] = {
0xe7, 0xb3, 0x2e, 0x15, 0x56, 0xea, 0x1b, 0x27, 0x95, 0x04, 0x6a, 0xc6, 0x97, 0x39, 0xd2, 0x2a, 0xc8, 0x96, 0x6b, 0xf1, 0x1c, 0x11, 0x6f, 0x61, 0x4b, 0x16, 0x67, 0x40, 0xe9, 0x6b, 0x90, 0x65, 0x3e, 0x57, 0x50, 0x94, 0x5f, 0xcf, 0x77, 0x21, 0x86, 0xc0, 0x37, 0x90, 0xa0, 0x7f, 0xda, 0x32, 0x3e, 0x1a, 0x61, 0x91, 0x6b, 0x06, 0xee, 0x21, 0x57, 0xdb, 0x3d, 0xff, 0x80, 0xd6, 0x7d, 0x5e, 0x39, 0xa5, 0x3a, 0xe2, 0x68, 0xc8, 0xf0, 0x9e, 0xd9, 0x9a, 0x73, 0x20, 0x05, 0xb0, 0xbc, 0x6a, 0x04, 0xaf, 0x4e, 0x08, 0xd5, 0x7a, 0x00, 0xe7, 0x20, 0x1b, 0x30, 0x60, 0xef, 0xaa, 0xdb, 0x73, 0x11, 0x3b, 0xfc, 0x08, 0x7f, 0xd8, 0x37, 0x09, 0x3a, 0xa2, 0x52, 0x35, 0xb8, 0xc1, 0x49, 0xf5, 0x62, 0x15, 0xf0, 0x31, 0xc2, 0x4a, 0xd5, 0xbd, 0xe7, 0xf2, 0x99, 0x60, 0xdf, 0x7d, 0x52, 0x40, 0x70, 0xf7, 0x44, 0x9c, 0x6f, 0x78, 0x50, 0x84, 0xbe, 0x1a, 0x0f, 0x73, 0x30, 0x47, 0xf3, 0x36, 0xf9, 0x15, 0x47, 0x38, 0x67, 0x45, 0x47, 0xdb, 0x02, 0xa9, 0xf4, 0x4d, 0xfc, 0x6e, 0x60, 0x30, 0x10, 0x81, 0xe1, 0xce, 0x99, 0x84, 0x7f, 0x3b, 0x5b, 0x60, 0x1f, 0xf0, 0x6b, 0x4d, 0x57, 0x76, 0xa9, 0x74, 0x0b, 0x9a, 0xa0, 0xd3, 0x40, 0x58, 0xfd, 0x3b, 0x90, 0x6e, 0x4f, 0x78, 0x59, 0xdf, 0xb0, 0x7d, 0x71, 0x73, 0xe5, 0xe6, 0xf6, 0x35, 0x0a, 0xda, 0xc2, 0x1f, 0x27, 0xb2, 0x30, 0x74, 0x69, 
};
static const u8 rsa_pss_171_CRT_res[] = {
0x08, 0x18, 0x0d, 0xe8, 0x25, 0xe4, 0xb8, 0xb0, 0x14, 0xa3, 0x2d, 0xa8, 0xba, 0x76, 0x15, 0x55, 0x92, 0x12, 0x04, 0xf2, 0xf9, 0x0d, 0x5f, 0x24, 0xb7, 0x12, 0x90, 0x8f, 0xf8, 0x4f, 0x3e, 0x22, 0x0a, 0xd1, 0x79, 0x97, 0xc0, 0xdd, 0x6e, 0x70, 0x66, 0x30, 0xba, 0x3e, 0x84, 0xad, 0xd4, 0xd5, 0xe7, 0xab, 0x00, 0x4e, 0x58, 0x07, 0x4b, 0x54, 0x97, 0x09, 0x56, 0x5d, 0x43, 0xad, 0x9e, 0x97, 0xb5, 0xa7, 0xa1, 0xa2, 0x9e, 0x85, 0xb9, 0xf9, 0x0f, 0x4a, 0xaf, 0xcd, 0xf5, 0x83, 0x21, 0xde, 0x8c, 0x59, 0x74, 0xef, 0x9a, 0xbf, 0x2d, 0x52, 0x6f, 0x33, 0xc0, 0xf2, 0xf8, 0x2e, 0x95, 0xd1, 0x58, 0xea, 0x6b, 0x81, 0xf1, 0x73, 0x6d, 0xb8, 0xd1, 0xaf, 0x3d, 0x6a, 0xc6, 0xa8, 0x3b, 0x32, 0xd1, 0x8b, 0xae, 0x0f, 0xf1, 0xb2, 0xfe, 0x27, 0xde, 0x4c, 0x76, 0xed, 0x8c, 0x79, 0x80, 0xa3, 0x4e, 
};
static const u8 rsa_pss_171_CRT_salt[] = {
0xbd, 0x0c, 0xe1, 0x95, 0x49, 0xd0, 0x70, 0x01, 0x20, 0xcb, 0xe5, 0x10, 0x77, 0xdb, 0xbb, 0xb0, 0x0a, 0x8d, 0x8b, 0x09, 
};
static const u8 rsa_pss_171_CRT_p[] = {
0x03, 0xf2, 0xf3, 0x31, 0xf4, 0x14, 0x2d, 0x4f, 0x24, 0xb4, 0x3a, 0xa1, 0x02, 0x79, 0xa8, 0x96, 0x52, 0xd4, 0xe7, 0x53, 0x72, 0x21, 0xa1, 0xa7, 0xb2, 0xa2, 0x5d, 0xeb, 0x55, 0x1e, 0x5d, 0xe9, 0xac, 0x49, 0x74, 0x11, 0xc2, 0x27, 0xa9, 0x4e, 0x45, 0xf9, 0x1c, 0x2d, 0x1c, 0x13, 0xcc, 0x04, 0x6c, 0xf4, 0xce, 0x14, 0xe3, 0x2d, 0x05, 0x87, 0x34, 0x21, 0x0d, 0x44, 0xa8, 0x7e, 0xe1, 0xb7, 0x3f, 
};
static const u8 rsa_pss_171_CRT_q[] = {
0x03, 0x4f, 0x09, 0x0d, 0x73, 0xb5, 0x58, 0x03, 0x03, 0x0c, 0xf0, 0x36, 0x1a, 0x5d, 0x80, 0x81, 0xbf, 0xb7, 0x9f, 0x85, 0x15, 0x23, 0xfe, 0xac, 0x0a, 0x21, 0x24, 0xd0, 0x8d, 0x40, 0x13, 0xff, 0x08, 0x48, 0x77, 0x71, 0xa8, 0x70, 0xd0, 0x47, 0x9d, 0xc0, 0x68, 0x6c, 0x62, 0xf7, 0x71, 0x8d, 0xfe, 0xcf, 0x02, 0x4b, 0x17, 0xc9, 0x26, 0x76, 0x78, 0x05, 0x91, 0x71, 0x33, 0x9c, 0xc0, 0x08, 0x39, 
};
static const u8 rsa_pss_171_CRT_dP[] = {
0x02, 0xaa, 0x66, 0x3a, 0xdb, 0xf5, 0x1a, 0xb8, 0x87, 0xa0, 0x18, 0xcb, 0x42, 0x6e, 0x78, 0xbc, 0x2f, 0xe1, 0x82, 0xdc, 0xb2, 0xf7, 0xbc, 0xb5, 0x04, 0x41, 0xd1, 0x7f, 0xdf, 0x0f, 0x06, 0x79, 0x8b, 0x50, 0x71, 0xc6, 0xe2, 0xf5, 0xfe, 0xb4, 0xd5, 0x4a, 0xd8, 0x18, 0x23, 0x11, 0xc1, 0xef, 0x62, 0xd4, 0xc4, 0x9f, 0x18, 0xd1, 0xf5, 0x1f, 0x54, 0xb2, 0xd2, 0xcf, 0xfb, 0xa4, 0xda, 0x1b, 0xe5, 
};
static const u8 rsa_pss_171_CRT_dQ[] = {
0x02, 0xbb, 0xe7, 0x06, 0x07, 0x8b, 0x5c, 0x0b, 0x39, 0x15, 0x12, 0xd4, 0x11, 0xdb, 0x1b, 0x19, 0x9b, 0x5a, 0x56, 0x64, 0xb8, 0x40, 0x42, 0xea, 0xd3, 0x7f, 0xe9, 0x94, 0xae, 0x72, 0xb9, 0x53, 0x2d, 0xfb, 0xfb, 0x3e, 0x9e, 0x69, 0x81, 0xa0, 0xfb, 0xb8, 0x06, 0x51, 0x31, 0x41, 0xb7, 0xc2, 0x16, 0x3f, 0xe5, 0x6c, 0x39, 0x5e, 0x4b, 0xfa, 0xee, 0x57, 0xe3, 0x83, 0x3f, 0x9b, 0x91, 0x8d, 0xf9, 
};
static const u8 rsa_pss_171_CRT_qInv[] = {
0x02, 0x42, 0xb6, 0xcd, 0x00, 0xd3, 0x0a, 0x76, 0x7a, 0xee, 0x9a, 0x89, 0x8e, 0xad, 0x45, 0x3c, 0x8e, 0xae, 0xa6, 0x3d, 0x50, 0x0b, 0x7d, 0x1e, 0x00, 0x71, 0x3e, 0xda, 0xe5, 0x1c, 0xe3, 0x6b, 0x23, 0xb6, 0x64, 0xdf, 0x26, 0xe6, 0x3e, 0x26, 0x6e, 0xc8, 0xf7, 0x6e, 0x6e, 0x63, 0xed, 0x1b, 0xa4, 0x1e, 0xb0, 0x33, 0xb1, 0x20, 0xf7, 0xea, 0x52, 0x12, 0xae, 0x21, 0xa9, 0x8f, 0xbc, 0x16, 
};


static const rsa_test test_rsa_pss_171_CRT = {
	.name = "rsa_pss_171_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_171_CRT_n,
	.nlen = sizeof(rsa_pss_171_CRT_n),
	.d = (const u8*)&rsa_pss_171_CRT_d,
	.dlen = sizeof(rsa_pss_171_CRT_d),
	.e = (const u8*)&rsa_pss_171_CRT_e,
	.elen = sizeof(rsa_pss_171_CRT_e),
	.p = (const u8*)&rsa_pss_171_CRT_p,
	.plen = sizeof(rsa_pss_171_CRT_p),
	.q = (const u8*)&rsa_pss_171_CRT_q,
	.qlen = sizeof(rsa_pss_171_CRT_q),
	.dP = (const u8*)&rsa_pss_171_CRT_dP,
	.dPlen = sizeof(rsa_pss_171_CRT_dP),
	.dQ = (const u8*)&rsa_pss_171_CRT_dQ,
	.dQlen = sizeof(rsa_pss_171_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_171_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_171_CRT_qInv),
	.m = (const u8*)&rsa_pss_171_CRT_m,
	.mlen = sizeof(rsa_pss_171_CRT_m),
	.res = (const u8*)&rsa_pss_171_CRT_res,
	.reslen = sizeof(rsa_pss_171_CRT_res),
	.salt = (const u8*)&rsa_pss_171_CRT_salt,
	.saltlen = sizeof(rsa_pss_171_CRT_salt),
};
static const u8 rsa_pss_172_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_172_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_172_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_172_m[] = {
0x8d, 0x83, 0x96, 0xe3, 0x65, 0x07, 0xfe, 0x1e, 0xf6, 0xa1, 0x90, 0x17, 0x54, 0x8e, 0x0c, 0x71, 0x66, 0x74, 0xc2, 0xfe, 0xc2, 0x33, 0xad, 0xb2, 0xf7, 0x75, 0x66, 0x5e, 0xc4, 0x1f, 0x2b, 0xd0, 0xba, 0x39, 0x6b, 0x06, 0x1a, 0x9d, 0xaa, 0x7e, 0x86, 0x6f, 0x7c, 0x23, 0xfd, 0x35, 0x31, 0x95, 0x43, 0x00, 0xa3, 0x42, 0xf9, 0x24, 0x53, 0x5e, 0xa1, 0x49, 0x8c, 0x48, 0xf6, 0xc8, 0x79, 0x93, 0x28, 0x65, 0xfc, 0x02, 0x00, 0x0c, 0x52, 0x87, 0x23, 0xb7, 0xad, 0x03, 0x35, 0x74, 0x5b, 0x51, 0x20, 0x9a, 0x0a, 0xfe, 0xd9, 0x32, 0xaf, 0x8f, 0x08, 0x87, 0xc2, 0x19, 0x00, 0x4d, 0x2a, 0xbd, 0x89, 0x4e, 0xa9, 0x25, 0x59, 0xee, 0x31, 0x98, 0xaf, 0x3a, 0x73, 0x4f, 0xe9, 0xb9, 0x63, 0x8c, 0x26, 0x3a, 0x72, 0x8a, 0xd9, 0x5a, 0x5a, 0xe8, 0xce, 0x3e, 0xb1, 0x58, 0x39, 0xf3, 0xaa, 0x78, 0x52, 0xbb, 0x39, 0x07, 0x06, 0xe7, 0x76, 0x0e, 0x43, 0xa7, 0x12, 0x91, 0xa2, 0xe3, 0xf8, 0x27, 0x23, 0x7d, 0xed, 0xa8, 0x51, 0x87, 0x4c, 0x51, 0x76, 0x65, 0xf5, 0x45, 0xf2, 0x72, 0x38, 0xdf, 0x86, 0x55, 0x7f, 0x37, 0x5d, 0x09, 0xcc, 0xd8, 0xbd, 0x15, 0xd8, 0xcc, 0xf6, 0x1f, 0x5d, 0x78, 0xca, 0x5c, 0x7f, 0x5c, 0xde, 0x78, 0x2e, 0x6b, 0xf5, 0xd0, 0x05, 0x70, 0x56, 0xd4, 0xba, 0xd9, 0x8b, 0x3d, 0x2f, 0x95, 0x75, 0xe8, 0x24, 0xab, 0x7a, 0x33, 0xff, 0x57, 0xb0, 0xac, 0x10, 0x0a, 0xb0, 0xd6, 0xea, 0xd7, 0xaa, 0x0b, 0x50, 0xf6, 0xe4, 0xd3, 0xe5, 0xec, 0x0b, 0x96, 0x6b, 
};
static const u8 rsa_pss_172_res[] = {
0x05, 0xe0, 0xfd, 0xbd, 0xf6, 0xf7, 0x56, 0xef, 0x73, 0x31, 0x85, 0xcc, 0xfa, 0x8c, 0xed, 0x2e, 0xb6, 0xd0, 0x29, 0xd9, 0xd5, 0x6e, 0x35, 0x56, 0x1b, 0x5d, 0xb8, 0xe7, 0x02, 0x57, 0xee, 0x6f, 0xd0, 0x19, 0xd2, 0xf0, 0xbb, 0xf6, 0x69, 0xfe, 0x9b, 0x98, 0x21, 0xe7, 0x8d, 0xf6, 0xd4, 0x1e, 0x31, 0x60, 0x8d, 0x58, 0x28, 0x0f, 0x31, 0x8e, 0xe3, 0x4f, 0x55, 0x99, 0x41, 0xc8, 0xdf, 0x13, 0x28, 0x75, 0x74, 0xba, 0xc0, 0x00, 0xb7, 0xe5, 0x8d, 0xc4, 0xf4, 0x14, 0xba, 0x49, 0xfb, 0x12, 0x7f, 0x9d, 0x0f, 0x89, 0x36, 0x63, 0x8c, 0x76, 0xe8, 0x53, 0x56, 0xc9, 0x94, 0xf7, 0x97, 0x50, 0xf7, 0xfa, 0x3c, 0xf4, 0xfd, 0x48, 0x2d, 0xf7, 0x5e, 0x3f, 0xb9, 0x97, 0x8c, 0xd0, 0x61, 0xf7, 0xab, 0xb1, 0x75, 0x72, 0xe6, 0xe6, 0x3e, 0x0b, 0xde, 0x12, 0xcb, 0xdc, 0xf1, 0x8c, 0x68, 0xb9, 0x79, 
};
static const u8 rsa_pss_172_salt[] = {
0x81, 0x57, 0x79, 0xa9, 0x1b, 0x3a, 0x8b, 0xd0, 0x49, 0xbf, 0x2a, 0xeb, 0x92, 0x01, 0x42, 0x77, 0x22, 0x22, 0xc9, 0xca, 
};


static const rsa_test test_rsa_pss_172 = {
	.name = "rsa_pss_172",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_172_n,
	.nlen = sizeof(rsa_pss_172_n),
	.d = (const u8*)&rsa_pss_172_d,
	.dlen = sizeof(rsa_pss_172_d),
	.e = (const u8*)&rsa_pss_172_e,
	.elen = sizeof(rsa_pss_172_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_172_m,
	.mlen = sizeof(rsa_pss_172_m),
	.res = (const u8*)&rsa_pss_172_res,
	.reslen = sizeof(rsa_pss_172_res),
	.salt = (const u8*)&rsa_pss_172_salt,
	.saltlen = sizeof(rsa_pss_172_salt),
};
static const u8 rsa_pss_173_CRT_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_173_CRT_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_173_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_173_CRT_m[] = {
0x8d, 0x83, 0x96, 0xe3, 0x65, 0x07, 0xfe, 0x1e, 0xf6, 0xa1, 0x90, 0x17, 0x54, 0x8e, 0x0c, 0x71, 0x66, 0x74, 0xc2, 0xfe, 0xc2, 0x33, 0xad, 0xb2, 0xf7, 0x75, 0x66, 0x5e, 0xc4, 0x1f, 0x2b, 0xd0, 0xba, 0x39, 0x6b, 0x06, 0x1a, 0x9d, 0xaa, 0x7e, 0x86, 0x6f, 0x7c, 0x23, 0xfd, 0x35, 0x31, 0x95, 0x43, 0x00, 0xa3, 0x42, 0xf9, 0x24, 0x53, 0x5e, 0xa1, 0x49, 0x8c, 0x48, 0xf6, 0xc8, 0x79, 0x93, 0x28, 0x65, 0xfc, 0x02, 0x00, 0x0c, 0x52, 0x87, 0x23, 0xb7, 0xad, 0x03, 0x35, 0x74, 0x5b, 0x51, 0x20, 0x9a, 0x0a, 0xfe, 0xd9, 0x32, 0xaf, 0x8f, 0x08, 0x87, 0xc2, 0x19, 0x00, 0x4d, 0x2a, 0xbd, 0x89, 0x4e, 0xa9, 0x25, 0x59, 0xee, 0x31, 0x98, 0xaf, 0x3a, 0x73, 0x4f, 0xe9, 0xb9, 0x63, 0x8c, 0x26, 0x3a, 0x72, 0x8a, 0xd9, 0x5a, 0x5a, 0xe8, 0xce, 0x3e, 0xb1, 0x58, 0x39, 0xf3, 0xaa, 0x78, 0x52, 0xbb, 0x39, 0x07, 0x06, 0xe7, 0x76, 0x0e, 0x43, 0xa7, 0x12, 0x91, 0xa2, 0xe3, 0xf8, 0x27, 0x23, 0x7d, 0xed, 0xa8, 0x51, 0x87, 0x4c, 0x51, 0x76, 0x65, 0xf5, 0x45, 0xf2, 0x72, 0x38, 0xdf, 0x86, 0x55, 0x7f, 0x37, 0x5d, 0x09, 0xcc, 0xd8, 0xbd, 0x15, 0xd8, 0xcc, 0xf6, 0x1f, 0x5d, 0x78, 0xca, 0x5c, 0x7f, 0x5c, 0xde, 0x78, 0x2e, 0x6b, 0xf5, 0xd0, 0x05, 0x70, 0x56, 0xd4, 0xba, 0xd9, 0x8b, 0x3d, 0x2f, 0x95, 0x75, 0xe8, 0x24, 0xab, 0x7a, 0x33, 0xff, 0x57, 0xb0, 0xac, 0x10, 0x0a, 0xb0, 0xd6, 0xea, 0xd7, 0xaa, 0x0b, 0x50, 0xf6, 0xe4, 0xd3, 0xe5, 0xec, 0x0b, 0x96, 0x6b, 
};
static const u8 rsa_pss_173_CRT_res[] = {
0x05, 0xe0, 0xfd, 0xbd, 0xf6, 0xf7, 0x56, 0xef, 0x73, 0x31, 0x85, 0xcc, 0xfa, 0x8c, 0xed, 0x2e, 0xb6, 0xd0, 0x29, 0xd9, 0xd5, 0x6e, 0x35, 0x56, 0x1b, 0x5d, 0xb8, 0xe7, 0x02, 0x57, 0xee, 0x6f, 0xd0, 0x19, 0xd2, 0xf0, 0xbb, 0xf6, 0x69, 0xfe, 0x9b, 0x98, 0x21, 0xe7, 0x8d, 0xf6, 0xd4, 0x1e, 0x31, 0x60, 0x8d, 0x58, 0x28, 0x0f, 0x31, 0x8e, 0xe3, 0x4f, 0x55, 0x99, 0x41, 0xc8, 0xdf, 0x13, 0x28, 0x75, 0x74, 0xba, 0xc0, 0x00, 0xb7, 0xe5, 0x8d, 0xc4, 0xf4, 0x14, 0xba, 0x49, 0xfb, 0x12, 0x7f, 0x9d, 0x0f, 0x89, 0x36, 0x63, 0x8c, 0x76, 0xe8, 0x53, 0x56, 0xc9, 0x94, 0xf7, 0x97, 0x50, 0xf7, 0xfa, 0x3c, 0xf4, 0xfd, 0x48, 0x2d, 0xf7, 0x5e, 0x3f, 0xb9, 0x97, 0x8c, 0xd0, 0x61, 0xf7, 0xab, 0xb1, 0x75, 0x72, 0xe6, 0xe6, 0x3e, 0x0b, 0xde, 0x12, 0xcb, 0xdc, 0xf1, 0x8c, 0x68, 0xb9, 0x79, 
};
static const u8 rsa_pss_173_CRT_salt[] = {
0x81, 0x57, 0x79, 0xa9, 0x1b, 0x3a, 0x8b, 0xd0, 0x49, 0xbf, 0x2a, 0xeb, 0x92, 0x01, 0x42, 0x77, 0x22, 0x22, 0xc9, 0xca, 
};
static const u8 rsa_pss_173_CRT_p[] = {
0x03, 0xf2, 0xf3, 0x31, 0xf4, 0x14, 0x2d, 0x4f, 0x24, 0xb4, 0x3a, 0xa1, 0x02, 0x79, 0xa8, 0x96, 0x52, 0xd4, 0xe7, 0x53, 0x72, 0x21, 0xa1, 0xa7, 0xb2, 0xa2, 0x5d, 0xeb, 0x55, 0x1e, 0x5d, 0xe9, 0xac, 0x49, 0x74, 0x11, 0xc2, 0x27, 0xa9, 0x4e, 0x45, 0xf9, 0x1c, 0x2d, 0x1c, 0x13, 0xcc, 0x04, 0x6c, 0xf4, 0xce, 0x14, 0xe3, 0x2d, 0x05, 0x87, 0x34, 0x21, 0x0d, 0x44, 0xa8, 0x7e, 0xe1, 0xb7, 0x3f, 
};
static const u8 rsa_pss_173_CRT_q[] = {
0x03, 0x4f, 0x09, 0x0d, 0x73, 0xb5, 0x58, 0x03, 0x03, 0x0c, 0xf0, 0x36, 0x1a, 0x5d, 0x80, 0x81, 0xbf, 0xb7, 0x9f, 0x85, 0x15, 0x23, 0xfe, 0xac, 0x0a, 0x21, 0x24, 0xd0, 0x8d, 0x40, 0x13, 0xff, 0x08, 0x48, 0x77, 0x71, 0xa8, 0x70, 0xd0, 0x47, 0x9d, 0xc0, 0x68, 0x6c, 0x62, 0xf7, 0x71, 0x8d, 0xfe, 0xcf, 0x02, 0x4b, 0x17, 0xc9, 0x26, 0x76, 0x78, 0x05, 0x91, 0x71, 0x33, 0x9c, 0xc0, 0x08, 0x39, 
};
static const u8 rsa_pss_173_CRT_dP[] = {
0x02, 0xaa, 0x66, 0x3a, 0xdb, 0xf5, 0x1a, 0xb8, 0x87, 0xa0, 0x18, 0xcb, 0x42, 0x6e, 0x78, 0xbc, 0x2f, 0xe1, 0x82, 0xdc, 0xb2, 0xf7, 0xbc, 0xb5, 0x04, 0x41, 0xd1, 0x7f, 0xdf, 0x0f, 0x06, 0x79, 0x8b, 0x50, 0x71, 0xc6, 0xe2, 0xf5, 0xfe, 0xb4, 0xd5, 0x4a, 0xd8, 0x18, 0x23, 0x11, 0xc1, 0xef, 0x62, 0xd4, 0xc4, 0x9f, 0x18, 0xd1, 0xf5, 0x1f, 0x54, 0xb2, 0xd2, 0xcf, 0xfb, 0xa4, 0xda, 0x1b, 0xe5, 
};
static const u8 rsa_pss_173_CRT_dQ[] = {
0x02, 0xbb, 0xe7, 0x06, 0x07, 0x8b, 0x5c, 0x0b, 0x39, 0x15, 0x12, 0xd4, 0x11, 0xdb, 0x1b, 0x19, 0x9b, 0x5a, 0x56, 0x64, 0xb8, 0x40, 0x42, 0xea, 0xd3, 0x7f, 0xe9, 0x94, 0xae, 0x72, 0xb9, 0x53, 0x2d, 0xfb, 0xfb, 0x3e, 0x9e, 0x69, 0x81, 0xa0, 0xfb, 0xb8, 0x06, 0x51, 0x31, 0x41, 0xb7, 0xc2, 0x16, 0x3f, 0xe5, 0x6c, 0x39, 0x5e, 0x4b, 0xfa, 0xee, 0x57, 0xe3, 0x83, 0x3f, 0x9b, 0x91, 0x8d, 0xf9, 
};
static const u8 rsa_pss_173_CRT_qInv[] = {
0x02, 0x42, 0xb6, 0xcd, 0x00, 0xd3, 0x0a, 0x76, 0x7a, 0xee, 0x9a, 0x89, 0x8e, 0xad, 0x45, 0x3c, 0x8e, 0xae, 0xa6, 0x3d, 0x50, 0x0b, 0x7d, 0x1e, 0x00, 0x71, 0x3e, 0xda, 0xe5, 0x1c, 0xe3, 0x6b, 0x23, 0xb6, 0x64, 0xdf, 0x26, 0xe6, 0x3e, 0x26, 0x6e, 0xc8, 0xf7, 0x6e, 0x6e, 0x63, 0xed, 0x1b, 0xa4, 0x1e, 0xb0, 0x33, 0xb1, 0x20, 0xf7, 0xea, 0x52, 0x12, 0xae, 0x21, 0xa9, 0x8f, 0xbc, 0x16, 
};


static const rsa_test test_rsa_pss_173_CRT = {
	.name = "rsa_pss_173_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_173_CRT_n,
	.nlen = sizeof(rsa_pss_173_CRT_n),
	.d = (const u8*)&rsa_pss_173_CRT_d,
	.dlen = sizeof(rsa_pss_173_CRT_d),
	.e = (const u8*)&rsa_pss_173_CRT_e,
	.elen = sizeof(rsa_pss_173_CRT_e),
	.p = (const u8*)&rsa_pss_173_CRT_p,
	.plen = sizeof(rsa_pss_173_CRT_p),
	.q = (const u8*)&rsa_pss_173_CRT_q,
	.qlen = sizeof(rsa_pss_173_CRT_q),
	.dP = (const u8*)&rsa_pss_173_CRT_dP,
	.dPlen = sizeof(rsa_pss_173_CRT_dP),
	.dQ = (const u8*)&rsa_pss_173_CRT_dQ,
	.dQlen = sizeof(rsa_pss_173_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_173_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_173_CRT_qInv),
	.m = (const u8*)&rsa_pss_173_CRT_m,
	.mlen = sizeof(rsa_pss_173_CRT_m),
	.res = (const u8*)&rsa_pss_173_CRT_res,
	.reslen = sizeof(rsa_pss_173_CRT_res),
	.salt = (const u8*)&rsa_pss_173_CRT_salt,
	.saltlen = sizeof(rsa_pss_173_CRT_salt),
};
static const u8 rsa_pss_174_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_174_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_174_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_174_m[] = {
0x32, 0x8c, 0x65, 0x9e, 0x0a, 0x64, 0x37, 0x43, 0x3c, 0xce, 0xb7, 0x3c, 0x14, 
};
static const u8 rsa_pss_174_res[] = {
0x0b, 0xc9, 0x89, 0x85, 0x3b, 0xc2, 0xea, 0x86, 0x87, 0x32, 0x71, 0xce, 0x18, 0x3a, 0x92, 0x3a, 0xb6, 0x5e, 0x8a, 0x53, 0x10, 0x0e, 0x6d, 0xf5, 0xd8, 0x7a, 0x24, 0xc4, 0x19, 0x4e, 0xb7, 0x97, 0x81, 0x3e, 0xe2, 0xa1, 0x87, 0xc0, 0x97, 0xdd, 0x87, 0x2d, 0x59, 0x1d, 0xa6, 0x0c, 0x56, 0x86, 0x05, 0xdd, 0x7e, 0x74, 0x2d, 0x5a, 0xf4, 0xe3, 0x3b, 0x11, 0x67, 0x8c, 0xcb, 0x63, 0x90, 0x32, 0x04, 0xa3, 0xd0, 0x80, 0xb0, 0x90, 0x2c, 0x89, 0xab, 0xa8, 0x86, 0x8f, 0x00, 0x9c, 0x0f, 0x1c, 0x0c, 0xb8, 0x58, 0x10, 0xbb, 0xdd, 0x29, 0x12, 0x1a, 0xbb, 0x84, 0x71, 0xff, 0x2d, 0x39, 0xe4, 0x9f, 0xd9, 0x2d, 0x56, 0xc6, 0x55, 0xc8, 0xe0, 0x37, 0xad, 0x18, 0xfa, 0xfb, 0xdc, 0x92, 0xc9, 0x58, 0x63, 0xf7, 0xf6, 0x1e, 0xa9, 0xef, 0xa2, 0x8f, 0xea, 0x40, 0x13, 0x69, 0xd1, 0x9d, 0xae, 0xa1, 
};
static const u8 rsa_pss_174_salt[] = {
0x9a, 0xec, 0x4a, 0x74, 0x80, 0xd5, 0xbb, 0xc4, 0x29, 0x20, 0xd7, 0xca, 0x23, 0x5d, 0xb6, 0x74, 0x98, 0x9c, 0x9a, 0xac, 
};


static const rsa_test test_rsa_pss_174 = {
	.name = "rsa_pss_174",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_174_n,
	.nlen = sizeof(rsa_pss_174_n),
	.d = (const u8*)&rsa_pss_174_d,
	.dlen = sizeof(rsa_pss_174_d),
	.e = (const u8*)&rsa_pss_174_e,
	.elen = sizeof(rsa_pss_174_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_174_m,
	.mlen = sizeof(rsa_pss_174_m),
	.res = (const u8*)&rsa_pss_174_res,
	.reslen = sizeof(rsa_pss_174_res),
	.salt = (const u8*)&rsa_pss_174_salt,
	.saltlen = sizeof(rsa_pss_174_salt),
};
static const u8 rsa_pss_175_CRT_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_175_CRT_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_175_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_175_CRT_m[] = {
0x32, 0x8c, 0x65, 0x9e, 0x0a, 0x64, 0x37, 0x43, 0x3c, 0xce, 0xb7, 0x3c, 0x14, 
};
static const u8 rsa_pss_175_CRT_res[] = {
0x0b, 0xc9, 0x89, 0x85, 0x3b, 0xc2, 0xea, 0x86, 0x87, 0x32, 0x71, 0xce, 0x18, 0x3a, 0x92, 0x3a, 0xb6, 0x5e, 0x8a, 0x53, 0x10, 0x0e, 0x6d, 0xf5, 0xd8, 0x7a, 0x24, 0xc4, 0x19, 0x4e, 0xb7, 0x97, 0x81, 0x3e, 0xe2, 0xa1, 0x87, 0xc0, 0x97, 0xdd, 0x87, 0x2d, 0x59, 0x1d, 0xa6, 0x0c, 0x56, 0x86, 0x05, 0xdd, 0x7e, 0x74, 0x2d, 0x5a, 0xf4, 0xe3, 0x3b, 0x11, 0x67, 0x8c, 0xcb, 0x63, 0x90, 0x32, 0x04, 0xa3, 0xd0, 0x80, 0xb0, 0x90, 0x2c, 0x89, 0xab, 0xa8, 0x86, 0x8f, 0x00, 0x9c, 0x0f, 0x1c, 0x0c, 0xb8, 0x58, 0x10, 0xbb, 0xdd, 0x29, 0x12, 0x1a, 0xbb, 0x84, 0x71, 0xff, 0x2d, 0x39, 0xe4, 0x9f, 0xd9, 0x2d, 0x56, 0xc6, 0x55, 0xc8, 0xe0, 0x37, 0xad, 0x18, 0xfa, 0xfb, 0xdc, 0x92, 0xc9, 0x58, 0x63, 0xf7, 0xf6, 0x1e, 0xa9, 0xef, 0xa2, 0x8f, 0xea, 0x40, 0x13, 0x69, 0xd1, 0x9d, 0xae, 0xa1, 
};
static const u8 rsa_pss_175_CRT_salt[] = {
0x9a, 0xec, 0x4a, 0x74, 0x80, 0xd5, 0xbb, 0xc4, 0x29, 0x20, 0xd7, 0xca, 0x23, 0x5d, 0xb6, 0x74, 0x98, 0x9c, 0x9a, 0xac, 
};
static const u8 rsa_pss_175_CRT_p[] = {
0x03, 0xf2, 0xf3, 0x31, 0xf4, 0x14, 0x2d, 0x4f, 0x24, 0xb4, 0x3a, 0xa1, 0x02, 0x79, 0xa8, 0x96, 0x52, 0xd4, 0xe7, 0x53, 0x72, 0x21, 0xa1, 0xa7, 0xb2, 0xa2, 0x5d, 0xeb, 0x55, 0x1e, 0x5d, 0xe9, 0xac, 0x49, 0x74, 0x11, 0xc2, 0x27, 0xa9, 0x4e, 0x45, 0xf9, 0x1c, 0x2d, 0x1c, 0x13, 0xcc, 0x04, 0x6c, 0xf4, 0xce, 0x14, 0xe3, 0x2d, 0x05, 0x87, 0x34, 0x21, 0x0d, 0x44, 0xa8, 0x7e, 0xe1, 0xb7, 0x3f, 
};
static const u8 rsa_pss_175_CRT_q[] = {
0x03, 0x4f, 0x09, 0x0d, 0x73, 0xb5, 0x58, 0x03, 0x03, 0x0c, 0xf0, 0x36, 0x1a, 0x5d, 0x80, 0x81, 0xbf, 0xb7, 0x9f, 0x85, 0x15, 0x23, 0xfe, 0xac, 0x0a, 0x21, 0x24, 0xd0, 0x8d, 0x40, 0x13, 0xff, 0x08, 0x48, 0x77, 0x71, 0xa8, 0x70, 0xd0, 0x47, 0x9d, 0xc0, 0x68, 0x6c, 0x62, 0xf7, 0x71, 0x8d, 0xfe, 0xcf, 0x02, 0x4b, 0x17, 0xc9, 0x26, 0x76, 0x78, 0x05, 0x91, 0x71, 0x33, 0x9c, 0xc0, 0x08, 0x39, 
};
static const u8 rsa_pss_175_CRT_dP[] = {
0x02, 0xaa, 0x66, 0x3a, 0xdb, 0xf5, 0x1a, 0xb8, 0x87, 0xa0, 0x18, 0xcb, 0x42, 0x6e, 0x78, 0xbc, 0x2f, 0xe1, 0x82, 0xdc, 0xb2, 0xf7, 0xbc, 0xb5, 0x04, 0x41, 0xd1, 0x7f, 0xdf, 0x0f, 0x06, 0x79, 0x8b, 0x50, 0x71, 0xc6, 0xe2, 0xf5, 0xfe, 0xb4, 0xd5, 0x4a, 0xd8, 0x18, 0x23, 0x11, 0xc1, 0xef, 0x62, 0xd4, 0xc4, 0x9f, 0x18, 0xd1, 0xf5, 0x1f, 0x54, 0xb2, 0xd2, 0xcf, 0xfb, 0xa4, 0xda, 0x1b, 0xe5, 
};
static const u8 rsa_pss_175_CRT_dQ[] = {
0x02, 0xbb, 0xe7, 0x06, 0x07, 0x8b, 0x5c, 0x0b, 0x39, 0x15, 0x12, 0xd4, 0x11, 0xdb, 0x1b, 0x19, 0x9b, 0x5a, 0x56, 0x64, 0xb8, 0x40, 0x42, 0xea, 0xd3, 0x7f, 0xe9, 0x94, 0xae, 0x72, 0xb9, 0x53, 0x2d, 0xfb, 0xfb, 0x3e, 0x9e, 0x69, 0x81, 0xa0, 0xfb, 0xb8, 0x06, 0x51, 0x31, 0x41, 0xb7, 0xc2, 0x16, 0x3f, 0xe5, 0x6c, 0x39, 0x5e, 0x4b, 0xfa, 0xee, 0x57, 0xe3, 0x83, 0x3f, 0x9b, 0x91, 0x8d, 0xf9, 
};
static const u8 rsa_pss_175_CRT_qInv[] = {
0x02, 0x42, 0xb6, 0xcd, 0x00, 0xd3, 0x0a, 0x76, 0x7a, 0xee, 0x9a, 0x89, 0x8e, 0xad, 0x45, 0x3c, 0x8e, 0xae, 0xa6, 0x3d, 0x50, 0x0b, 0x7d, 0x1e, 0x00, 0x71, 0x3e, 0xda, 0xe5, 0x1c, 0xe3, 0x6b, 0x23, 0xb6, 0x64, 0xdf, 0x26, 0xe6, 0x3e, 0x26, 0x6e, 0xc8, 0xf7, 0x6e, 0x6e, 0x63, 0xed, 0x1b, 0xa4, 0x1e, 0xb0, 0x33, 0xb1, 0x20, 0xf7, 0xea, 0x52, 0x12, 0xae, 0x21, 0xa9, 0x8f, 0xbc, 0x16, 
};


static const rsa_test test_rsa_pss_175_CRT = {
	.name = "rsa_pss_175_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_175_CRT_n,
	.nlen = sizeof(rsa_pss_175_CRT_n),
	.d = (const u8*)&rsa_pss_175_CRT_d,
	.dlen = sizeof(rsa_pss_175_CRT_d),
	.e = (const u8*)&rsa_pss_175_CRT_e,
	.elen = sizeof(rsa_pss_175_CRT_e),
	.p = (const u8*)&rsa_pss_175_CRT_p,
	.plen = sizeof(rsa_pss_175_CRT_p),
	.q = (const u8*)&rsa_pss_175_CRT_q,
	.qlen = sizeof(rsa_pss_175_CRT_q),
	.dP = (const u8*)&rsa_pss_175_CRT_dP,
	.dPlen = sizeof(rsa_pss_175_CRT_dP),
	.dQ = (const u8*)&rsa_pss_175_CRT_dQ,
	.dQlen = sizeof(rsa_pss_175_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_175_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_175_CRT_qInv),
	.m = (const u8*)&rsa_pss_175_CRT_m,
	.mlen = sizeof(rsa_pss_175_CRT_m),
	.res = (const u8*)&rsa_pss_175_CRT_res,
	.reslen = sizeof(rsa_pss_175_CRT_res),
	.salt = (const u8*)&rsa_pss_175_CRT_salt,
	.saltlen = sizeof(rsa_pss_175_CRT_salt),
};
static const u8 rsa_pss_176_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_176_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_176_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_176_m[] = {
0xf3, 0x7b, 0x96, 0x23, 0x79, 0xa4, 0x7d, 0x41, 0x5a, 0x37, 0x6e, 0xec, 0x89, 0x73, 0x15, 0x0b, 0xcb, 0x34, 0xed, 0xd5, 0xab, 0x65, 0x40, 0x41, 0xb6, 0x14, 0x30, 0x56, 0x0c, 0x21, 0x44, 0x58, 0x2b, 0xa1, 0x33, 0xc8, 0x67, 0xd8, 0x52, 0xd6, 0xb8, 0xe2, 0x33, 0x21, 0x90, 0x13, 0x02, 0xec, 0xb4, 0x5b, 0x09, 0xec, 0x88, 0xb1, 0x52, 0x71, 0x78, 0xfa, 0x04, 0x32, 0x63, 0xf3, 0x06, 0x7d, 0x9f, 0xfe, 0x97, 0x30, 0x32, 0xa9, 0x9f, 0x4c, 0xb0, 0x8a, 0xd2, 0xc7, 0xe0, 0xa2, 0x45, 0x6c, 0xdd, 0x57, 0xa7, 0xdf, 0x56, 0xfe, 0x60, 0x53, 0x52, 0x7a, 0x5a, 0xeb, 0x67, 0xd7, 0xe5, 0x52, 0x06, 0x3c, 0x1c, 0xa9, 0x7b, 0x1b, 0xef, 0xfa, 0x7b, 0x39, 0xe9, 0x97, 0xca, 0xf2, 0x78, 0x78, 0xea, 0x0f, 0x62, 0xcb, 0xeb, 0xc8, 0xc2, 0x1d, 0xf4, 0xc8, 0x89, 0xa2, 0x02, 0x85, 0x1e, 0x94, 0x90, 0x88, 0x49, 0x0c, 0x24, 0x9b, 0x6e, 0x9a, 0xcf, 0x1d, 0x80, 0x63, 0xf5, 0xbe, 0x23, 0x43, 0x98, 0x9b, 0xf9, 0x5c, 0x4d, 0xa0, 0x1a, 0x2b, 0xe7, 0x8b, 0x4a, 0xb6, 0xb3, 0x78, 0x01, 0x5b, 0xc3, 0x79, 0x57, 0xf7, 0x69, 0x48, 0xb5, 0xe5, 0x8e, 0x44, 0x0c, 0x28, 0x45, 0x3d, 0x40, 0xd7, 0xcf, 0xd5, 0x7e, 0x7d, 0x69, 0x06, 0x00, 0x47, 0x4a, 0xb5, 0xe7, 0x59, 0x73, 0xb1, 0xea, 0x0c, 0x5f, 0x1e, 0x45, 0xd1, 0x41, 0x90, 0xaf, 0xe2, 0xf4, 0xeb, 0x6d, 0x3b, 0xdf, 0x71, 0xf1, 0xd2, 0xf8, 0xbb, 0x15, 0x6a, 0x1c, 0x29, 0x5d, 0x04, 0xaa, 0xeb, 0x9d, 0x68, 0x9d, 0xce, 0x79, 0xed, 0x62, 0xbc, 0x44, 0x3e, 
};
static const u8 rsa_pss_176_res[] = {
0x0a, 0xef, 0xa9, 0x43, 0xb6, 0x98, 0xb9, 0x60, 0x9e, 0xdf, 0x89, 0x8a, 0xd2, 0x27, 0x44, 0xac, 0x28, 0xdc, 0x23, 0x94, 0x97, 0xce, 0xa3, 0x69, 0xcb, 0xbd, 0x84, 0xf6, 0x5c, 0x95, 0xc0, 0xad, 0x77, 0x6b, 0x59, 0x47, 0x40, 0x16, 0x4b, 0x59, 0xa7, 0x39, 0xc6, 0xff, 0x7c, 0x2f, 0x07, 0xc7, 0xc0, 0x77, 0xa8, 0x6d, 0x95, 0x23, 0x8f, 0xe5, 0x1e, 0x1f, 0xcf, 0x33, 0x57, 0x4a, 0x4a, 0xe0, 0x68, 0x4b, 0x42, 0xa3, 0xf6, 0xbf, 0x67, 0x7d, 0x91, 0x82, 0x0c, 0xa8, 0x98, 0x74, 0x46, 0x7b, 0x2c, 0x23, 0xad, 0xd7, 0x79, 0x69, 0xc8, 0x07, 0x17, 0x43, 0x0d, 0x0e, 0xfc, 0x1d, 0x36, 0x95, 0x89, 0x2c, 0xe8, 0x55, 0xcb, 0x7f, 0x70, 0x11, 0x63, 0x0f, 0x4d, 0xf2, 0x6d, 0xef, 0x8d, 0xdf, 0x36, 0xfc, 0x23, 0x90, 0x5f, 0x57, 0xfa, 0x62, 0x43, 0xa4, 0x85, 0xc7, 0x70, 0xd5, 0x68, 0x1f, 0xcd, 
};
static const u8 rsa_pss_176_salt[] = {
0xe2, 0x0c, 0x1e, 0x98, 0x78, 0x51, 0x2c, 0x39, 0x97, 0x0f, 0x58, 0x37, 0x5e, 0x15, 0x49, 0xa6, 0x8b, 0x64, 0xf3, 0x1d, 
};


static const rsa_test test_rsa_pss_176 = {
	.name = "rsa_pss_176",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_176_n,
	.nlen = sizeof(rsa_pss_176_n),
	.d = (const u8*)&rsa_pss_176_d,
	.dlen = sizeof(rsa_pss_176_d),
	.e = (const u8*)&rsa_pss_176_e,
	.elen = sizeof(rsa_pss_176_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_176_m,
	.mlen = sizeof(rsa_pss_176_m),
	.res = (const u8*)&rsa_pss_176_res,
	.reslen = sizeof(rsa_pss_176_res),
	.salt = (const u8*)&rsa_pss_176_salt,
	.saltlen = sizeof(rsa_pss_176_salt),
};
static const u8 rsa_pss_177_CRT_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_177_CRT_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_177_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_177_CRT_m[] = {
0xf3, 0x7b, 0x96, 0x23, 0x79, 0xa4, 0x7d, 0x41, 0x5a, 0x37, 0x6e, 0xec, 0x89, 0x73, 0x15, 0x0b, 0xcb, 0x34, 0xed, 0xd5, 0xab, 0x65, 0x40, 0x41, 0xb6, 0x14, 0x30, 0x56, 0x0c, 0x21, 0x44, 0x58, 0x2b, 0xa1, 0x33, 0xc8, 0x67, 0xd8, 0x52, 0xd6, 0xb8, 0xe2, 0x33, 0x21, 0x90, 0x13, 0x02, 0xec, 0xb4, 0x5b, 0x09, 0xec, 0x88, 0xb1, 0x52, 0x71, 0x78, 0xfa, 0x04, 0x32, 0x63, 0xf3, 0x06, 0x7d, 0x9f, 0xfe, 0x97, 0x30, 0x32, 0xa9, 0x9f, 0x4c, 0xb0, 0x8a, 0xd2, 0xc7, 0xe0, 0xa2, 0x45, 0x6c, 0xdd, 0x57, 0xa7, 0xdf, 0x56, 0xfe, 0x60, 0x53, 0x52, 0x7a, 0x5a, 0xeb, 0x67, 0xd7, 0xe5, 0x52, 0x06, 0x3c, 0x1c, 0xa9, 0x7b, 0x1b, 0xef, 0xfa, 0x7b, 0x39, 0xe9, 0x97, 0xca, 0xf2, 0x78, 0x78, 0xea, 0x0f, 0x62, 0xcb, 0xeb, 0xc8, 0xc2, 0x1d, 0xf4, 0xc8, 0x89, 0xa2, 0x02, 0x85, 0x1e, 0x94, 0x90, 0x88, 0x49, 0x0c, 0x24, 0x9b, 0x6e, 0x9a, 0xcf, 0x1d, 0x80, 0x63, 0xf5, 0xbe, 0x23, 0x43, 0x98, 0x9b, 0xf9, 0x5c, 0x4d, 0xa0, 0x1a, 0x2b, 0xe7, 0x8b, 0x4a, 0xb6, 0xb3, 0x78, 0x01, 0x5b, 0xc3, 0x79, 0x57, 0xf7, 0x69, 0x48, 0xb5, 0xe5, 0x8e, 0x44, 0x0c, 0x28, 0x45, 0x3d, 0x40, 0xd7, 0xcf, 0xd5, 0x7e, 0x7d, 0x69, 0x06, 0x00, 0x47, 0x4a, 0xb5, 0xe7, 0x59, 0x73, 0xb1, 0xea, 0x0c, 0x5f, 0x1e, 0x45, 0xd1, 0x41, 0x90, 0xaf, 0xe2, 0xf4, 0xeb, 0x6d, 0x3b, 0xdf, 0x71, 0xf1, 0xd2, 0xf8, 0xbb, 0x15, 0x6a, 0x1c, 0x29, 0x5d, 0x04, 0xaa, 0xeb, 0x9d, 0x68, 0x9d, 0xce, 0x79, 0xed, 0x62, 0xbc, 0x44, 0x3e, 
};
static const u8 rsa_pss_177_CRT_res[] = {
0x0a, 0xef, 0xa9, 0x43, 0xb6, 0x98, 0xb9, 0x60, 0x9e, 0xdf, 0x89, 0x8a, 0xd2, 0x27, 0x44, 0xac, 0x28, 0xdc, 0x23, 0x94, 0x97, 0xce, 0xa3, 0x69, 0xcb, 0xbd, 0x84, 0xf6, 0x5c, 0x95, 0xc0, 0xad, 0x77, 0x6b, 0x59, 0x47, 0x40, 0x16, 0x4b, 0x59, 0xa7, 0x39, 0xc6, 0xff, 0x7c, 0x2f, 0x07, 0xc7, 0xc0, 0x77, 0xa8, 0x6d, 0x95, 0x23, 0x8f, 0xe5, 0x1e, 0x1f, 0xcf, 0x33, 0x57, 0x4a, 0x4a, 0xe0, 0x68, 0x4b, 0x42, 0xa3, 0xf6, 0xbf, 0x67, 0x7d, 0x91, 0x82, 0x0c, 0xa8, 0x98, 0x74, 0x46, 0x7b, 0x2c, 0x23, 0xad, 0xd7, 0x79, 0x69, 0xc8, 0x07, 0x17, 0x43, 0x0d, 0x0e, 0xfc, 0x1d, 0x36, 0x95, 0x89, 0x2c, 0xe8, 0x55, 0xcb, 0x7f, 0x70, 0x11, 0x63, 0x0f, 0x4d, 0xf2, 0x6d, 0xef, 0x8d, 0xdf, 0x36, 0xfc, 0x23, 0x90, 0x5f, 0x57, 0xfa, 0x62, 0x43, 0xa4, 0x85, 0xc7, 0x70, 0xd5, 0x68, 0x1f, 0xcd, 
};
static const u8 rsa_pss_177_CRT_salt[] = {
0xe2, 0x0c, 0x1e, 0x98, 0x78, 0x51, 0x2c, 0x39, 0x97, 0x0f, 0x58, 0x37, 0x5e, 0x15, 0x49, 0xa6, 0x8b, 0x64, 0xf3, 0x1d, 
};
static const u8 rsa_pss_177_CRT_p[] = {
0x03, 0xf2, 0xf3, 0x31, 0xf4, 0x14, 0x2d, 0x4f, 0x24, 0xb4, 0x3a, 0xa1, 0x02, 0x79, 0xa8, 0x96, 0x52, 0xd4, 0xe7, 0x53, 0x72, 0x21, 0xa1, 0xa7, 0xb2, 0xa2, 0x5d, 0xeb, 0x55, 0x1e, 0x5d, 0xe9, 0xac, 0x49, 0x74, 0x11, 0xc2, 0x27, 0xa9, 0x4e, 0x45, 0xf9, 0x1c, 0x2d, 0x1c, 0x13, 0xcc, 0x04, 0x6c, 0xf4, 0xce, 0x14, 0xe3, 0x2d, 0x05, 0x87, 0x34, 0x21, 0x0d, 0x44, 0xa8, 0x7e, 0xe1, 0xb7, 0x3f, 
};
static const u8 rsa_pss_177_CRT_q[] = {
0x03, 0x4f, 0x09, 0x0d, 0x73, 0xb5, 0x58, 0x03, 0x03, 0x0c, 0xf0, 0x36, 0x1a, 0x5d, 0x80, 0x81, 0xbf, 0xb7, 0x9f, 0x85, 0x15, 0x23, 0xfe, 0xac, 0x0a, 0x21, 0x24, 0xd0, 0x8d, 0x40, 0x13, 0xff, 0x08, 0x48, 0x77, 0x71, 0xa8, 0x70, 0xd0, 0x47, 0x9d, 0xc0, 0x68, 0x6c, 0x62, 0xf7, 0x71, 0x8d, 0xfe, 0xcf, 0x02, 0x4b, 0x17, 0xc9, 0x26, 0x76, 0x78, 0x05, 0x91, 0x71, 0x33, 0x9c, 0xc0, 0x08, 0x39, 
};
static const u8 rsa_pss_177_CRT_dP[] = {
0x02, 0xaa, 0x66, 0x3a, 0xdb, 0xf5, 0x1a, 0xb8, 0x87, 0xa0, 0x18, 0xcb, 0x42, 0x6e, 0x78, 0xbc, 0x2f, 0xe1, 0x82, 0xdc, 0xb2, 0xf7, 0xbc, 0xb5, 0x04, 0x41, 0xd1, 0x7f, 0xdf, 0x0f, 0x06, 0x79, 0x8b, 0x50, 0x71, 0xc6, 0xe2, 0xf5, 0xfe, 0xb4, 0xd5, 0x4a, 0xd8, 0x18, 0x23, 0x11, 0xc1, 0xef, 0x62, 0xd4, 0xc4, 0x9f, 0x18, 0xd1, 0xf5, 0x1f, 0x54, 0xb2, 0xd2, 0xcf, 0xfb, 0xa4, 0xda, 0x1b, 0xe5, 
};
static const u8 rsa_pss_177_CRT_dQ[] = {
0x02, 0xbb, 0xe7, 0x06, 0x07, 0x8b, 0x5c, 0x0b, 0x39, 0x15, 0x12, 0xd4, 0x11, 0xdb, 0x1b, 0x19, 0x9b, 0x5a, 0x56, 0x64, 0xb8, 0x40, 0x42, 0xea, 0xd3, 0x7f, 0xe9, 0x94, 0xae, 0x72, 0xb9, 0x53, 0x2d, 0xfb, 0xfb, 0x3e, 0x9e, 0x69, 0x81, 0xa0, 0xfb, 0xb8, 0x06, 0x51, 0x31, 0x41, 0xb7, 0xc2, 0x16, 0x3f, 0xe5, 0x6c, 0x39, 0x5e, 0x4b, 0xfa, 0xee, 0x57, 0xe3, 0x83, 0x3f, 0x9b, 0x91, 0x8d, 0xf9, 
};
static const u8 rsa_pss_177_CRT_qInv[] = {
0x02, 0x42, 0xb6, 0xcd, 0x00, 0xd3, 0x0a, 0x76, 0x7a, 0xee, 0x9a, 0x89, 0x8e, 0xad, 0x45, 0x3c, 0x8e, 0xae, 0xa6, 0x3d, 0x50, 0x0b, 0x7d, 0x1e, 0x00, 0x71, 0x3e, 0xda, 0xe5, 0x1c, 0xe3, 0x6b, 0x23, 0xb6, 0x64, 0xdf, 0x26, 0xe6, 0x3e, 0x26, 0x6e, 0xc8, 0xf7, 0x6e, 0x6e, 0x63, 0xed, 0x1b, 0xa4, 0x1e, 0xb0, 0x33, 0xb1, 0x20, 0xf7, 0xea, 0x52, 0x12, 0xae, 0x21, 0xa9, 0x8f, 0xbc, 0x16, 
};


static const rsa_test test_rsa_pss_177_CRT = {
	.name = "rsa_pss_177_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_177_CRT_n,
	.nlen = sizeof(rsa_pss_177_CRT_n),
	.d = (const u8*)&rsa_pss_177_CRT_d,
	.dlen = sizeof(rsa_pss_177_CRT_d),
	.e = (const u8*)&rsa_pss_177_CRT_e,
	.elen = sizeof(rsa_pss_177_CRT_e),
	.p = (const u8*)&rsa_pss_177_CRT_p,
	.plen = sizeof(rsa_pss_177_CRT_p),
	.q = (const u8*)&rsa_pss_177_CRT_q,
	.qlen = sizeof(rsa_pss_177_CRT_q),
	.dP = (const u8*)&rsa_pss_177_CRT_dP,
	.dPlen = sizeof(rsa_pss_177_CRT_dP),
	.dQ = (const u8*)&rsa_pss_177_CRT_dQ,
	.dQlen = sizeof(rsa_pss_177_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_177_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_177_CRT_qInv),
	.m = (const u8*)&rsa_pss_177_CRT_m,
	.mlen = sizeof(rsa_pss_177_CRT_m),
	.res = (const u8*)&rsa_pss_177_CRT_res,
	.reslen = sizeof(rsa_pss_177_CRT_res),
	.salt = (const u8*)&rsa_pss_177_CRT_salt,
	.saltlen = sizeof(rsa_pss_177_CRT_salt),
};
static const u8 rsa_pss_178_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_178_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_178_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_178_m[] = {
0xc6, 0x10, 0x3c, 0x33, 0x0c, 0x1e, 0xf7, 0x18, 0xc1, 0x41, 0xe4, 0x7b, 0x8f, 0xa8, 0x59, 0xbe, 0x4d, 0x5b, 0x96, 0x25, 0x9e, 0x7d, 0x14, 0x20, 0x70, 0xec, 0xd4, 0x85, 0x83, 0x9d, 0xba, 0x5a, 0x83, 0x69, 0xc1, 0x7c, 0x11, 0x14, 0x03, 0x5e, 0x53, 0x2d, 0x19, 0x5c, 0x74, 0xf4, 0x4a, 0x04, 0x76, 0xa2, 0xd3, 0xe8, 0xa4, 0xda, 0x21, 0x00, 0x16, 0xca, 0xce, 0xd0, 0xe3, 0x67, 0xcb, 0x86, 0x77, 0x10, 0xa4, 0xb5, 0xaa, 0x2d, 0xf2, 0xb8, 0xe5, 0xda, 0xf5, 0xfd, 0xc6, 0x47, 0x80, 0x7d, 0x4d, 0x5e, 0xbb, 0x6c, 0x56, 0xb9, 0x76, 0x3c, 0xcd, 0xae, 0x4d, 0xea, 0x33, 0x08, 0xeb, 0x0a, 0xc2, 0xa8, 0x95, 0x01, 0xcb, 0x20, 0x9d, 0x26, 0x39, 0xfa, 0x5b, 0xf8, 0x7c, 0xe7, 0x90, 0x74, 0x7d, 0x3c, 0xb2, 0xd2, 0x95, 0xe8, 0x45, 0x64, 0xf2, 0xf6, 0x37, 0x82, 0x4f, 0x0c, 0x13, 0x02, 0x81, 0x29, 0xb0, 0xaa, 0x4a, 0x42, 0x2d, 0x16, 0x22, 0x82, 
};
static const u8 rsa_pss_178_res[] = {
0x02, 0x80, 0x2d, 0xcc, 0xfa, 0x8d, 0xfa, 0xf5, 0x27, 0x9b, 0xf0, 0xb4, 0xa2, 0x9b, 0xa1, 0xb1, 0x57, 0x61, 0x1f, 0xae, 0xaa, 0xf4, 0x19, 0xb8, 0x91, 0x9d, 0x15, 0x94, 0x19, 0x00, 0xc1, 0x33, 0x9e, 0x7e, 0x92, 0xe6, 0xfa, 0xe5, 0x62, 0xc5, 0x3e, 0x6c, 0xc8, 0xe8, 0x41, 0x04, 0xb1, 0x10, 0xbc, 0xe0, 0x3a, 0xd1, 0x85, 0x25, 0xe3, 0xc4, 0x9a, 0x0e, 0xad, 0xad, 0x5d, 0x3f, 0x28, 0xf2, 0x44, 0xa8, 0xed, 0x89, 0xed, 0xba, 0xfb, 0xb6, 0x86, 0x27, 0x7c, 0xfa, 0x8a, 0xe9, 0x09, 0x71, 0x4d, 0x6b, 0x28, 0xf4, 0xbf, 0x8e, 0x29, 0x3a, 0xa0, 0x4c, 0x41, 0xef, 0xe7, 0xc0, 0xa8, 0x12, 0x66, 0xd5, 0xc0, 0x61, 0xe2, 0x57, 0x5b, 0xe0, 0x32, 0xaa, 0x46, 0x46, 0x74, 0xff, 0x71, 0x62, 0x62, 0x19, 0xbd, 0x74, 0xcc, 0x45, 0xf0, 0xe7, 0xed, 0x4e, 0x3f, 0xf9, 0x6e, 0xee, 0x75, 0x8e, 0x8f, 
};
static const u8 rsa_pss_178_salt[] = {
0x23, 0x29, 0x1e, 0x4a, 0x33, 0x07, 0xe8, 0xbb, 0xb7, 0x76, 0x62, 0x3a, 0xb3, 0x4e, 0x4a, 0x5f, 0x4c, 0xc8, 0xa8, 0xdb, 
};


static const rsa_test test_rsa_pss_178 = {
	.name = "rsa_pss_178",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_178_n,
	.nlen = sizeof(rsa_pss_178_n),
	.d = (const u8*)&rsa_pss_178_d,
	.dlen = sizeof(rsa_pss_178_d),
	.e = (const u8*)&rsa_pss_178_e,
	.elen = sizeof(rsa_pss_178_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_178_m,
	.mlen = sizeof(rsa_pss_178_m),
	.res = (const u8*)&rsa_pss_178_res,
	.reslen = sizeof(rsa_pss_178_res),
	.salt = (const u8*)&rsa_pss_178_salt,
	.saltlen = sizeof(rsa_pss_178_salt),
};
static const u8 rsa_pss_179_CRT_n[] = {
0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07, 
};
static const u8 rsa_pss_179_CRT_d[] = {
0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1, 
};
static const u8 rsa_pss_179_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_179_CRT_m[] = {
0xc6, 0x10, 0x3c, 0x33, 0x0c, 0x1e, 0xf7, 0x18, 0xc1, 0x41, 0xe4, 0x7b, 0x8f, 0xa8, 0x59, 0xbe, 0x4d, 0x5b, 0x96, 0x25, 0x9e, 0x7d, 0x14, 0x20, 0x70, 0xec, 0xd4, 0x85, 0x83, 0x9d, 0xba, 0x5a, 0x83, 0x69, 0xc1, 0x7c, 0x11, 0x14, 0x03, 0x5e, 0x53, 0x2d, 0x19, 0x5c, 0x74, 0xf4, 0x4a, 0x04, 0x76, 0xa2, 0xd3, 0xe8, 0xa4, 0xda, 0x21, 0x00, 0x16, 0xca, 0xce, 0xd0, 0xe3, 0x67, 0xcb, 0x86, 0x77, 0x10, 0xa4, 0xb5, 0xaa, 0x2d, 0xf2, 0xb8, 0xe5, 0xda, 0xf5, 0xfd, 0xc6, 0x47, 0x80, 0x7d, 0x4d, 0x5e, 0xbb, 0x6c, 0x56, 0xb9, 0x76, 0x3c, 0xcd, 0xae, 0x4d, 0xea, 0x33, 0x08, 0xeb, 0x0a, 0xc2, 0xa8, 0x95, 0x01, 0xcb, 0x20, 0x9d, 0x26, 0x39, 0xfa, 0x5b, 0xf8, 0x7c, 0xe7, 0x90, 0x74, 0x7d, 0x3c, 0xb2, 0xd2, 0x95, 0xe8, 0x45, 0x64, 0xf2, 0xf6, 0x37, 0x82, 0x4f, 0x0c, 0x13, 0x02, 0x81, 0x29, 0xb0, 0xaa, 0x4a, 0x42, 0x2d, 0x16, 0x22, 0x82, 
};
static const u8 rsa_pss_179_CRT_res[] = {
0x02, 0x80, 0x2d, 0xcc, 0xfa, 0x8d, 0xfa, 0xf5, 0x27, 0x9b, 0xf0, 0xb4, 0xa2, 0x9b, 0xa1, 0xb1, 0x57, 0x61, 0x1f, 0xae, 0xaa, 0xf4, 0x19, 0xb8, 0x91, 0x9d, 0x15, 0x94, 0x19, 0x00, 0xc1, 0x33, 0x9e, 0x7e, 0x92, 0xe6, 0xfa, 0xe5, 0x62, 0xc5, 0x3e, 0x6c, 0xc8, 0xe8, 0x41, 0x04, 0xb1, 0x10, 0xbc, 0xe0, 0x3a, 0xd1, 0x85, 0x25, 0xe3, 0xc4, 0x9a, 0x0e, 0xad, 0xad, 0x5d, 0x3f, 0x28, 0xf2, 0x44, 0xa8, 0xed, 0x89, 0xed, 0xba, 0xfb, 0xb6, 0x86, 0x27, 0x7c, 0xfa, 0x8a, 0xe9, 0x09, 0x71, 0x4d, 0x6b, 0x28, 0xf4, 0xbf, 0x8e, 0x29, 0x3a, 0xa0, 0x4c, 0x41, 0xef, 0xe7, 0xc0, 0xa8, 0x12, 0x66, 0xd5, 0xc0, 0x61, 0xe2, 0x57, 0x5b, 0xe0, 0x32, 0xaa, 0x46, 0x46, 0x74, 0xff, 0x71, 0x62, 0x62, 0x19, 0xbd, 0x74, 0xcc, 0x45, 0xf0, 0xe7, 0xed, 0x4e, 0x3f, 0xf9, 0x6e, 0xee, 0x75, 0x8e, 0x8f, 
};
static const u8 rsa_pss_179_CRT_salt[] = {
0x23, 0x29, 0x1e, 0x4a, 0x33, 0x07, 0xe8, 0xbb, 0xb7, 0x76, 0x62, 0x3a, 0xb3, 0x4e, 0x4a, 0x5f, 0x4c, 0xc8, 0xa8, 0xdb, 
};
static const u8 rsa_pss_179_CRT_p[] = {
0x03, 0xf2, 0xf3, 0x31, 0xf4, 0x14, 0x2d, 0x4f, 0x24, 0xb4, 0x3a, 0xa1, 0x02, 0x79, 0xa8, 0x96, 0x52, 0xd4, 0xe7, 0x53, 0x72, 0x21, 0xa1, 0xa7, 0xb2, 0xa2, 0x5d, 0xeb, 0x55, 0x1e, 0x5d, 0xe9, 0xac, 0x49, 0x74, 0x11, 0xc2, 0x27, 0xa9, 0x4e, 0x45, 0xf9, 0x1c, 0x2d, 0x1c, 0x13, 0xcc, 0x04, 0x6c, 0xf4, 0xce, 0x14, 0xe3, 0x2d, 0x05, 0x87, 0x34, 0x21, 0x0d, 0x44, 0xa8, 0x7e, 0xe1, 0xb7, 0x3f, 
};
static const u8 rsa_pss_179_CRT_q[] = {
0x03, 0x4f, 0x09, 0x0d, 0x73, 0xb5, 0x58, 0x03, 0x03, 0x0c, 0xf0, 0x36, 0x1a, 0x5d, 0x80, 0x81, 0xbf, 0xb7, 0x9f, 0x85, 0x15, 0x23, 0xfe, 0xac, 0x0a, 0x21, 0x24, 0xd0, 0x8d, 0x40, 0x13, 0xff, 0x08, 0x48, 0x77, 0x71, 0xa8, 0x70, 0xd0, 0x47, 0x9d, 0xc0, 0x68, 0x6c, 0x62, 0xf7, 0x71, 0x8d, 0xfe, 0xcf, 0x02, 0x4b, 0x17, 0xc9, 0x26, 0x76, 0x78, 0x05, 0x91, 0x71, 0x33, 0x9c, 0xc0, 0x08, 0x39, 
};
static const u8 rsa_pss_179_CRT_dP[] = {
0x02, 0xaa, 0x66, 0x3a, 0xdb, 0xf5, 0x1a, 0xb8, 0x87, 0xa0, 0x18, 0xcb, 0x42, 0x6e, 0x78, 0xbc, 0x2f, 0xe1, 0x82, 0xdc, 0xb2, 0xf7, 0xbc, 0xb5, 0x04, 0x41, 0xd1, 0x7f, 0xdf, 0x0f, 0x06, 0x79, 0x8b, 0x50, 0x71, 0xc6, 0xe2, 0xf5, 0xfe, 0xb4, 0xd5, 0x4a, 0xd8, 0x18, 0x23, 0x11, 0xc1, 0xef, 0x62, 0xd4, 0xc4, 0x9f, 0x18, 0xd1, 0xf5, 0x1f, 0x54, 0xb2, 0xd2, 0xcf, 0xfb, 0xa4, 0xda, 0x1b, 0xe5, 
};
static const u8 rsa_pss_179_CRT_dQ[] = {
0x02, 0xbb, 0xe7, 0x06, 0x07, 0x8b, 0x5c, 0x0b, 0x39, 0x15, 0x12, 0xd4, 0x11, 0xdb, 0x1b, 0x19, 0x9b, 0x5a, 0x56, 0x64, 0xb8, 0x40, 0x42, 0xea, 0xd3, 0x7f, 0xe9, 0x94, 0xae, 0x72, 0xb9, 0x53, 0x2d, 0xfb, 0xfb, 0x3e, 0x9e, 0x69, 0x81, 0xa0, 0xfb, 0xb8, 0x06, 0x51, 0x31, 0x41, 0xb7, 0xc2, 0x16, 0x3f, 0xe5, 0x6c, 0x39, 0x5e, 0x4b, 0xfa, 0xee, 0x57, 0xe3, 0x83, 0x3f, 0x9b, 0x91, 0x8d, 0xf9, 
};
static const u8 rsa_pss_179_CRT_qInv[] = {
0x02, 0x42, 0xb6, 0xcd, 0x00, 0xd3, 0x0a, 0x76, 0x7a, 0xee, 0x9a, 0x89, 0x8e, 0xad, 0x45, 0x3c, 0x8e, 0xae, 0xa6, 0x3d, 0x50, 0x0b, 0x7d, 0x1e, 0x00, 0x71, 0x3e, 0xda, 0xe5, 0x1c, 0xe3, 0x6b, 0x23, 0xb6, 0x64, 0xdf, 0x26, 0xe6, 0x3e, 0x26, 0x6e, 0xc8, 0xf7, 0x6e, 0x6e, 0x63, 0xed, 0x1b, 0xa4, 0x1e, 0xb0, 0x33, 0xb1, 0x20, 0xf7, 0xea, 0x52, 0x12, 0xae, 0x21, 0xa9, 0x8f, 0xbc, 0x16, 
};


static const rsa_test test_rsa_pss_179_CRT = {
	.name = "rsa_pss_179_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1028,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_179_CRT_n,
	.nlen = sizeof(rsa_pss_179_CRT_n),
	.d = (const u8*)&rsa_pss_179_CRT_d,
	.dlen = sizeof(rsa_pss_179_CRT_d),
	.e = (const u8*)&rsa_pss_179_CRT_e,
	.elen = sizeof(rsa_pss_179_CRT_e),
	.p = (const u8*)&rsa_pss_179_CRT_p,
	.plen = sizeof(rsa_pss_179_CRT_p),
	.q = (const u8*)&rsa_pss_179_CRT_q,
	.qlen = sizeof(rsa_pss_179_CRT_q),
	.dP = (const u8*)&rsa_pss_179_CRT_dP,
	.dPlen = sizeof(rsa_pss_179_CRT_dP),
	.dQ = (const u8*)&rsa_pss_179_CRT_dQ,
	.dQlen = sizeof(rsa_pss_179_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_179_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_179_CRT_qInv),
	.m = (const u8*)&rsa_pss_179_CRT_m,
	.mlen = sizeof(rsa_pss_179_CRT_m),
	.res = (const u8*)&rsa_pss_179_CRT_res,
	.reslen = sizeof(rsa_pss_179_CRT_res),
	.salt = (const u8*)&rsa_pss_179_CRT_salt,
	.saltlen = sizeof(rsa_pss_179_CRT_salt),
};
static const u8 rsa_pss_180_n[] = {
0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1, 
};
static const u8 rsa_pss_180_d[] = {
0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f, 
};
static const u8 rsa_pss_180_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_180_m[] = {
0x0a, 0x20, 0xb7, 0x74, 0xad, 0xdc, 0x2f, 0xa5, 0x12, 0x45, 0xed, 0x7c, 0xb9, 0xda, 0x60, 0x9e, 0x50, 0xca, 0xc6, 0x63, 0x6a, 0x52, 0x54, 0x3f, 0x97, 0x45, 0x8e, 0xed, 0x73, 0x40, 0xf8, 0xd5, 0x3f, 0xfc, 0x64, 0x91, 0x8f, 0x94, 0x90, 0x78, 0xee, 0x03, 0xef, 0x60, 0xd4, 0x2b, 0x5f, 0xec, 0x24, 0x60, 0x50, 0xbd, 0x55, 0x05, 0xcd, 0x8c, 0xb5, 0x97, 0xba, 0xd3, 0xc4, 0xe7, 0x13, 0xb0, 0xef, 0x30, 0x64, 0x4e, 0x76, 0xad, 0xab, 0xb0, 0xde, 0x01, 0xa1, 0x56, 0x1e, 0xfb, 0x25, 0x51, 0x58, 0xc7, 0x4f, 0xc8, 0x01, 0xe6, 0xe9, 0x19, 0xe5, 0x81, 0xb4, 0x6f, 0x0f, 0x0d, 0xdd, 0x08, 0xe4, 0xf3, 0x4c, 0x78, 0x10, 0xb5, 0xed, 0x83, 0x18, 0xf9, 0x1d, 0x7c, 0x8c, 
};
static const u8 rsa_pss_180_res[] = {
0x04, 0xc0, 0xcf, 0xac, 0xec, 0x04, 0xe5, 0xba, 0xdb, 0xec, 0xe1, 0x59, 0xa5, 0xa1, 0x10, 0x3f, 0x69, 0xb3, 0xf3, 0x2b, 0xa5, 0x93, 0xcb, 0x4c, 0xc4, 0xb1, 0xb7, 0xab, 0x45, 0x59, 0x16, 0xa9, 0x6a, 0x27, 0xcd, 0x26, 0x78, 0xea, 0x0f, 0x46, 0xba, 0x37, 0xf7, 0xfc, 0x9c, 0x86, 0x32, 0x5f, 0x29, 0x73, 0x3b, 0x38, 0x9f, 0x1d, 0x97, 0xf4, 0x3e, 0x72, 0x01, 0xc0, 0xf3, 0x48, 0xfc, 0x45, 0xfe, 0x42, 0x89, 0x23, 0x35, 0x36, 0x2e, 0xee, 0x01, 0x8b, 0x5b, 0x16, 0x1f, 0x2f, 0x93, 0x93, 0x03, 0x12, 0x25, 0xc7, 0x13, 0x01, 0x2a, 0x57, 0x6b, 0xc8, 0x8e, 0x23, 0x05, 0x24, 0x89, 0x86, 0x8d, 0x90, 0x10, 0xcb, 0xf0, 0x33, 0xec, 0xc5, 0x68, 0xe8, 0xbc, 0x15, 0x2b, 0xdc, 0x59, 0xd5, 0x60, 0xe4, 0x12, 0x91, 0x91, 0x5d, 0x28, 0x56, 0x52, 0x08, 0xe2, 0x2a, 0xee, 0xc9, 0xef, 0x85, 0xd1, 
};
static const u8 rsa_pss_180_salt[] = {
0x5b, 0x4e, 0xa2, 0xef, 0x62, 0x9c, 0xc2, 0x2f, 0x3b, 0x53, 0x8e, 0x01, 0x69, 0x04, 0xb4, 0x7b, 0x1e, 0x40, 0xbf, 0xd5, 
};


static const rsa_test test_rsa_pss_180 = {
	.name = "rsa_pss_180",
	.type = RSA_PSS_SIG,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_180_n,
	.nlen = sizeof(rsa_pss_180_n),
	.d = (const u8*)&rsa_pss_180_d,
	.dlen = sizeof(rsa_pss_180_d),
	.e = (const u8*)&rsa_pss_180_e,
	.elen = sizeof(rsa_pss_180_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_180_m,
	.mlen = sizeof(rsa_pss_180_m),
	.res = (const u8*)&rsa_pss_180_res,
	.reslen = sizeof(rsa_pss_180_res),
	.salt = (const u8*)&rsa_pss_180_salt,
	.saltlen = sizeof(rsa_pss_180_salt),
};
static const u8 rsa_pss_181_CRT_n[] = {
0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1, 
};
static const u8 rsa_pss_181_CRT_d[] = {
0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f, 
};
static const u8 rsa_pss_181_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_181_CRT_m[] = {
0x0a, 0x20, 0xb7, 0x74, 0xad, 0xdc, 0x2f, 0xa5, 0x12, 0x45, 0xed, 0x7c, 0xb9, 0xda, 0x60, 0x9e, 0x50, 0xca, 0xc6, 0x63, 0x6a, 0x52, 0x54, 0x3f, 0x97, 0x45, 0x8e, 0xed, 0x73, 0x40, 0xf8, 0xd5, 0x3f, 0xfc, 0x64, 0x91, 0x8f, 0x94, 0x90, 0x78, 0xee, 0x03, 0xef, 0x60, 0xd4, 0x2b, 0x5f, 0xec, 0x24, 0x60, 0x50, 0xbd, 0x55, 0x05, 0xcd, 0x8c, 0xb5, 0x97, 0xba, 0xd3, 0xc4, 0xe7, 0x13, 0xb0, 0xef, 0x30, 0x64, 0x4e, 0x76, 0xad, 0xab, 0xb0, 0xde, 0x01, 0xa1, 0x56, 0x1e, 0xfb, 0x25, 0x51, 0x58, 0xc7, 0x4f, 0xc8, 0x01, 0xe6, 0xe9, 0x19, 0xe5, 0x81, 0xb4, 0x6f, 0x0f, 0x0d, 0xdd, 0x08, 0xe4, 0xf3, 0x4c, 0x78, 0x10, 0xb5, 0xed, 0x83, 0x18, 0xf9, 0x1d, 0x7c, 0x8c, 
};
static const u8 rsa_pss_181_CRT_res[] = {
0x04, 0xc0, 0xcf, 0xac, 0xec, 0x04, 0xe5, 0xba, 0xdb, 0xec, 0xe1, 0x59, 0xa5, 0xa1, 0x10, 0x3f, 0x69, 0xb3, 0xf3, 0x2b, 0xa5, 0x93, 0xcb, 0x4c, 0xc4, 0xb1, 0xb7, 0xab, 0x45, 0x59, 0x16, 0xa9, 0x6a, 0x27, 0xcd, 0x26, 0x78, 0xea, 0x0f, 0x46, 0xba, 0x37, 0xf7, 0xfc, 0x9c, 0x86, 0x32, 0x5f, 0x29, 0x73, 0x3b, 0x38, 0x9f, 0x1d, 0x97, 0xf4, 0x3e, 0x72, 0x01, 0xc0, 0xf3, 0x48, 0xfc, 0x45, 0xfe, 0x42, 0x89, 0x23, 0x35, 0x36, 0x2e, 0xee, 0x01, 0x8b, 0x5b, 0x16, 0x1f, 0x2f, 0x93, 0x93, 0x03, 0x12, 0x25, 0xc7, 0x13, 0x01, 0x2a, 0x57, 0x6b, 0xc8, 0x8e, 0x23, 0x05, 0x24, 0x89, 0x86, 0x8d, 0x90, 0x10, 0xcb, 0xf0, 0x33, 0xec, 0xc5, 0x68, 0xe8, 0xbc, 0x15, 0x2b, 0xdc, 0x59, 0xd5, 0x60, 0xe4, 0x12, 0x91, 0x91, 0x5d, 0x28, 0x56, 0x52, 0x08, 0xe2, 0x2a, 0xee, 0xc9, 0xef, 0x85, 0xd1, 
};
static const u8 rsa_pss_181_CRT_salt[] = {
0x5b, 0x4e, 0xa2, 0xef, 0x62, 0x9c, 0xc2, 0x2f, 0x3b, 0x53, 0x8e, 0x01, 0x69, 0x04, 0xb4, 0x7b, 0x1e, 0x40, 0xbf, 0xd5, 
};
static const u8 rsa_pss_181_CRT_p[] = {
0x04, 0xf0, 0x54, 0x8c, 0x96, 0x26, 0xab, 0x1e, 0xbf, 0x12, 0x44, 0x93, 0x47, 0x41, 0xd9, 0x9a, 0x06, 0x22, 0x0e, 0xfa, 0x2a, 0x58, 0x56, 0xaa, 0x0e, 0x75, 0x73, 0x0b, 0x2e, 0xc9, 0x6a, 0xdc, 0x86, 0xbe, 0x89, 0x4f, 0xa2, 0x80, 0x3b, 0x53, 0xa5, 0xe8, 0x5d, 0x27, 0x6a, 0xcb, 0xd2, 0x9a, 0xb8, 0x23, 0xf8, 0x0a, 0x73, 0x91, 0xbb, 0x54, 0xa5, 0x05, 0x16, 0x72, 0xfb, 0x04, 0xee, 0xb5, 0x43, 
};
static const u8 rsa_pss_181_CRT_q[] = {
0x04, 0x83, 0xe0, 0xae, 0x47, 0x91, 0x55, 0x87, 0x74, 0x3f, 0xf3, 0x45, 0x36, 0x2b, 0x55, 0x5d, 0x39, 0x62, 0xd9, 0x8b, 0xb6, 0xf1, 0x5f, 0x84, 0x8b, 0x4c, 0x92, 0xb1, 0x77, 0x1c, 0xa8, 0xed, 0x10, 0x7d, 0x8d, 0x3e, 0xe6, 0x5e, 0xc4, 0x45, 0x17, 0xdd, 0x0f, 0xaa, 0x48, 0x1a, 0x38, 0x7e, 0x90, 0x2f, 0x7a, 0x2e, 0x74, 0x7c, 0x26, 0x9e, 0x7e, 0xa4, 0x44, 0x80, 0xbc, 0x53, 0x8b, 0x8e, 0x5b, 
};
static const u8 rsa_pss_181_CRT_dP[] = {
0x03, 0xa8, 0xe8, 0xae, 0xa9, 0x92, 0x0c, 0x1a, 0xa3, 0xb2, 0xf0, 0xd8, 0x46, 0xe4, 0xb8, 0x50, 0xd8, 0x1c, 0xa3, 0x06, 0xa5, 0x1c, 0x83, 0x54, 0x4f, 0x94, 0x9f, 0x64, 0xf9, 0x0d, 0xcf, 0x3f, 0x8e, 0x26, 0x61, 0xf0, 0x7e, 0x56, 0x12, 0x20, 0xa1, 0x80, 0x38, 0x8f, 0xbe, 0x27, 0x3e, 0x70, 0xe2, 0xe5, 0xdc, 0xa8, 0x3a, 0x0e, 0x13, 0x48, 0xdd, 0x64, 0x90, 0xc7, 0x31, 0xd6, 0xec, 0xe1, 0xab, 
};
static const u8 rsa_pss_181_CRT_dQ[] = {
0x01, 0x35, 0xbd, 0xcd, 0xb6, 0x0b, 0xf2, 0x19, 0x7c, 0x43, 0x6e, 0xd3, 0x4b, 0x32, 0xcd, 0x8b, 0x4f, 0xc7, 0x77, 0x78, 0x83, 0x2b, 0xa7, 0x67, 0x03, 0x55, 0x1f, 0xb2, 0x42, 0xb3, 0x01, 0x69, 0x95, 0x93, 0xaf, 0x77, 0xfd, 0x8f, 0xc3, 0x94, 0xa8, 0x52, 0x6a, 0xd2, 0x3c, 0xc4, 0x1a, 0x03, 0x80, 0x6b, 0xd8, 0x97, 0xfe, 0x4b, 0x0e, 0xa6, 0x46, 0x55, 0x8a, 0xad, 0xdc, 0xc9, 0x9e, 0x8a, 0x25, 
};
static const u8 rsa_pss_181_CRT_qInv[] = {
0x03, 0x04, 0xc0, 0x3d, 0x9c, 0x73, 0x65, 0x03, 0xa9, 0x84, 0xab, 0xbd, 0x9b, 0xa2, 0x23, 0x01, 0x40, 0x7c, 0x4a, 0x2a, 0xb1, 0xdd, 0x85, 0x76, 0x64, 0x81, 0xb6, 0x0d, 0x45, 0x40, 0x11, 0x52, 0xe6, 0x92, 0xbe, 0x14, 0xf4, 0x12, 0x1d, 0x9a, 0xa3, 0xfd, 0x6e, 0x0b, 0x4d, 0x1d, 0x3a, 0x97, 0x35, 0x38, 0xa3, 0x1d, 0x42, 0xee, 0x6e, 0x1e, 0x5e, 0xf6, 0x20, 0x23, 0x1a, 0x2b, 0xba, 0xf3, 0x5f, 
};


static const rsa_test test_rsa_pss_181_CRT = {
	.name = "rsa_pss_181_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_181_CRT_n,
	.nlen = sizeof(rsa_pss_181_CRT_n),
	.d = (const u8*)&rsa_pss_181_CRT_d,
	.dlen = sizeof(rsa_pss_181_CRT_d),
	.e = (const u8*)&rsa_pss_181_CRT_e,
	.elen = sizeof(rsa_pss_181_CRT_e),
	.p = (const u8*)&rsa_pss_181_CRT_p,
	.plen = sizeof(rsa_pss_181_CRT_p),
	.q = (const u8*)&rsa_pss_181_CRT_q,
	.qlen = sizeof(rsa_pss_181_CRT_q),
	.dP = (const u8*)&rsa_pss_181_CRT_dP,
	.dPlen = sizeof(rsa_pss_181_CRT_dP),
	.dQ = (const u8*)&rsa_pss_181_CRT_dQ,
	.dQlen = sizeof(rsa_pss_181_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_181_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_181_CRT_qInv),
	.m = (const u8*)&rsa_pss_181_CRT_m,
	.mlen = sizeof(rsa_pss_181_CRT_m),
	.res = (const u8*)&rsa_pss_181_CRT_res,
	.reslen = sizeof(rsa_pss_181_CRT_res),
	.salt = (const u8*)&rsa_pss_181_CRT_salt,
	.saltlen = sizeof(rsa_pss_181_CRT_salt),
};
static const u8 rsa_pss_182_n[] = {
0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1, 
};
static const u8 rsa_pss_182_d[] = {
0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f, 
};
static const u8 rsa_pss_182_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_182_m[] = {
0x2a, 0xaf, 0xf6, 0x63, 0x1f, 0x62, 0x1c, 0xe6, 0x15, 0x76, 0x0a, 0x9e, 0xbc, 0xe9, 0x4b, 0xb3, 0x33, 0x07, 0x7a, 0xd8, 0x64, 0x88, 0xc8, 0x61, 0xd4, 0xb7, 0x6d, 0x29, 0xc1, 0xf4, 0x87, 0x46, 0xc6, 0x11, 0xae, 0x1e, 0x03, 0xce, 0xd4, 0x44, 0x5d, 0x7c, 0xfa, 0x1f, 0xe5, 0xf6, 0x2e, 0x1b, 0x3f, 0x08, 0x45, 0x2b, 0xde, 0x3b, 0x6e, 0xf8, 0x19, 0x73, 0xba, 0xfb, 0xb5, 0x7f, 0x97, 0xbc, 0xee, 0xf8, 0x73, 0x98, 0x53, 0x95, 0xb8, 0x26, 0x05, 0x89, 0xaa, 0x88, 0xcb, 0x7d, 0xb5, 0x0a, 0xb4, 0x69, 0x26, 0x2e, 0x55, 0x1b, 0xdc, 0xd9, 0xa5, 0x6f, 0x27, 0x5a, 0x0a, 0xc4, 0xfe, 0x48, 0x47, 0x00, 0xc3, 0x5f, 0x3d, 0xbf, 0x2b, 0x46, 0x9e, 0xde, 0x86, 0x47, 0x41, 0xb8, 0x6f, 0xa5, 0x91, 0x72, 0xa3, 0x60, 0xba, 0x95, 0xa0, 0x2e, 0x13, 0x9b, 0xe5, 0x0d, 0xdf, 0xb7, 0xcf, 0x0b, 0x42, 0xfa, 0xea, 0xbb, 0xfb, 0xba, 0xa8, 0x6a, 0x44, 0x97, 0x69, 0x9c, 0x4f, 0x2d, 0xfd, 0x5b, 0x08, 0x40, 0x6a, 0xf7, 0xe1, 0x41, 0x44, 0x42, 0x7c, 0x25, 0x3e, 0xc0, 0xef, 0xa2, 0x0e, 0xaf, 0x9a, 0x8b, 0xe8, 0xcd, 0x49, 0xce, 0x1f, 0x1b, 0xc4, 0xe9, 0x3e, 0x61, 0x9c, 0xf2, 0xaa, 0x8e, 0xd4, 0xfb, 0x39, 0xbc, 0x85, 0x90, 0xd0, 0xf7, 0xb9, 0x64, 0x88, 0xf7, 0x31, 0x7a, 0xc9, 0xab, 0xf7, 0xbe, 0xe4, 0xe3, 0xa0, 0xe7, 0x15, 
};
static const u8 rsa_pss_182_res[] = {
0x0a, 0x23, 0x14, 0x25, 0x0c, 0xf5, 0x2b, 0x6e, 0x4e, 0x90, 0x8d, 0xe5, 0xb3, 0x56, 0x46, 0xbc, 0xaa, 0x24, 0x36, 0x1d, 0xa8, 0x16, 0x0f, 0xb0, 0xf9, 0x25, 0x75, 0x90, 0xab, 0x3a, 0xce, 0x42, 0xb0, 0xdc, 0x3e, 0x77, 0xad, 0x2d, 0xb7, 0xc2, 0x03, 0xa2, 0x0b, 0xd9, 0x52, 0xfb, 0xb5, 0x6b, 0x15, 0x67, 0x04, 0x6e, 0xcf, 0xaa, 0x93, 0x3d, 0x7b, 0x10, 0x00, 0xc3, 0xde, 0x9f, 0xf0, 0x5b, 0x7d, 0x98, 0x9b, 0xa4, 0x6f, 0xd4, 0x3b, 0xc4, 0xc2, 0xd0, 0xa3, 0x98, 0x6b, 0x7f, 0xfa, 0x13, 0x47, 0x1d, 0x37, 0xeb, 0x5b, 0x47, 0xd6, 0x47, 0x07, 0xbd, 0x29, 0x0c, 0xfd, 0x6a, 0x9f, 0x39, 0x3a, 0xd0, 0x8e, 0xc1, 0xe3, 0xbd, 0x71, 0xbb, 0x57, 0x92, 0x61, 0x50, 0x35, 0xcd, 0xaf, 0x2d, 0x89, 0x29, 0xae, 0xd3, 0xbe, 0x09, 0x83, 0x79, 0x37, 0x7e, 0x77, 0x7c, 0xe7, 0x9a, 0xaa, 0x47, 0x73, 
};
static const u8 rsa_pss_182_salt[] = {
0x83, 0x14, 0x6a, 0x9e, 0x78, 0x27, 0x22, 0xc2, 0x8b, 0x01, 0x4f, 0x98, 0xb4, 0x26, 0x7b, 0xda, 0x2a, 0xc9, 0x50, 0x4f, 
};


static const rsa_test test_rsa_pss_182 = {
	.name = "rsa_pss_182",
	.type = RSA_PSS_SIG,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_182_n,
	.nlen = sizeof(rsa_pss_182_n),
	.d = (const u8*)&rsa_pss_182_d,
	.dlen = sizeof(rsa_pss_182_d),
	.e = (const u8*)&rsa_pss_182_e,
	.elen = sizeof(rsa_pss_182_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_182_m,
	.mlen = sizeof(rsa_pss_182_m),
	.res = (const u8*)&rsa_pss_182_res,
	.reslen = sizeof(rsa_pss_182_res),
	.salt = (const u8*)&rsa_pss_182_salt,
	.saltlen = sizeof(rsa_pss_182_salt),
};
static const u8 rsa_pss_183_CRT_n[] = {
0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1, 
};
static const u8 rsa_pss_183_CRT_d[] = {
0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f, 
};
static const u8 rsa_pss_183_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_183_CRT_m[] = {
0x2a, 0xaf, 0xf6, 0x63, 0x1f, 0x62, 0x1c, 0xe6, 0x15, 0x76, 0x0a, 0x9e, 0xbc, 0xe9, 0x4b, 0xb3, 0x33, 0x07, 0x7a, 0xd8, 0x64, 0x88, 0xc8, 0x61, 0xd4, 0xb7, 0x6d, 0x29, 0xc1, 0xf4, 0x87, 0x46, 0xc6, 0x11, 0xae, 0x1e, 0x03, 0xce, 0xd4, 0x44, 0x5d, 0x7c, 0xfa, 0x1f, 0xe5, 0xf6, 0x2e, 0x1b, 0x3f, 0x08, 0x45, 0x2b, 0xde, 0x3b, 0x6e, 0xf8, 0x19, 0x73, 0xba, 0xfb, 0xb5, 0x7f, 0x97, 0xbc, 0xee, 0xf8, 0x73, 0x98, 0x53, 0x95, 0xb8, 0x26, 0x05, 0x89, 0xaa, 0x88, 0xcb, 0x7d, 0xb5, 0x0a, 0xb4, 0x69, 0x26, 0x2e, 0x55, 0x1b, 0xdc, 0xd9, 0xa5, 0x6f, 0x27, 0x5a, 0x0a, 0xc4, 0xfe, 0x48, 0x47, 0x00, 0xc3, 0x5f, 0x3d, 0xbf, 0x2b, 0x46, 0x9e, 0xde, 0x86, 0x47, 0x41, 0xb8, 0x6f, 0xa5, 0x91, 0x72, 0xa3, 0x60, 0xba, 0x95, 0xa0, 0x2e, 0x13, 0x9b, 0xe5, 0x0d, 0xdf, 0xb7, 0xcf, 0x0b, 0x42, 0xfa, 0xea, 0xbb, 0xfb, 0xba, 0xa8, 0x6a, 0x44, 0x97, 0x69, 0x9c, 0x4f, 0x2d, 0xfd, 0x5b, 0x08, 0x40, 0x6a, 0xf7, 0xe1, 0x41, 0x44, 0x42, 0x7c, 0x25, 0x3e, 0xc0, 0xef, 0xa2, 0x0e, 0xaf, 0x9a, 0x8b, 0xe8, 0xcd, 0x49, 0xce, 0x1f, 0x1b, 0xc4, 0xe9, 0x3e, 0x61, 0x9c, 0xf2, 0xaa, 0x8e, 0xd4, 0xfb, 0x39, 0xbc, 0x85, 0x90, 0xd0, 0xf7, 0xb9, 0x64, 0x88, 0xf7, 0x31, 0x7a, 0xc9, 0xab, 0xf7, 0xbe, 0xe4, 0xe3, 0xa0, 0xe7, 0x15, 
};
static const u8 rsa_pss_183_CRT_res[] = {
0x0a, 0x23, 0x14, 0x25, 0x0c, 0xf5, 0x2b, 0x6e, 0x4e, 0x90, 0x8d, 0xe5, 0xb3, 0x56, 0x46, 0xbc, 0xaa, 0x24, 0x36, 0x1d, 0xa8, 0x16, 0x0f, 0xb0, 0xf9, 0x25, 0x75, 0x90, 0xab, 0x3a, 0xce, 0x42, 0xb0, 0xdc, 0x3e, 0x77, 0xad, 0x2d, 0xb7, 0xc2, 0x03, 0xa2, 0x0b, 0xd9, 0x52, 0xfb, 0xb5, 0x6b, 0x15, 0x67, 0x04, 0x6e, 0xcf, 0xaa, 0x93, 0x3d, 0x7b, 0x10, 0x00, 0xc3, 0xde, 0x9f, 0xf0, 0x5b, 0x7d, 0x98, 0x9b, 0xa4, 0x6f, 0xd4, 0x3b, 0xc4, 0xc2, 0xd0, 0xa3, 0x98, 0x6b, 0x7f, 0xfa, 0x13, 0x47, 0x1d, 0x37, 0xeb, 0x5b, 0x47, 0xd6, 0x47, 0x07, 0xbd, 0x29, 0x0c, 0xfd, 0x6a, 0x9f, 0x39, 0x3a, 0xd0, 0x8e, 0xc1, 0xe3, 0xbd, 0x71, 0xbb, 0x57, 0x92, 0x61, 0x50, 0x35, 0xcd, 0xaf, 0x2d, 0x89, 0x29, 0xae, 0xd3, 0xbe, 0x09, 0x83, 0x79, 0x37, 0x7e, 0x77, 0x7c, 0xe7, 0x9a, 0xaa, 0x47, 0x73, 
};
static const u8 rsa_pss_183_CRT_salt[] = {
0x83, 0x14, 0x6a, 0x9e, 0x78, 0x27, 0x22, 0xc2, 0x8b, 0x01, 0x4f, 0x98, 0xb4, 0x26, 0x7b, 0xda, 0x2a, 0xc9, 0x50, 0x4f, 
};
static const u8 rsa_pss_183_CRT_p[] = {
0x04, 0xf0, 0x54, 0x8c, 0x96, 0x26, 0xab, 0x1e, 0xbf, 0x12, 0x44, 0x93, 0x47, 0x41, 0xd9, 0x9a, 0x06, 0x22, 0x0e, 0xfa, 0x2a, 0x58, 0x56, 0xaa, 0x0e, 0x75, 0x73, 0x0b, 0x2e, 0xc9, 0x6a, 0xdc, 0x86, 0xbe, 0x89, 0x4f, 0xa2, 0x80, 0x3b, 0x53, 0xa5, 0xe8, 0x5d, 0x27, 0x6a, 0xcb, 0xd2, 0x9a, 0xb8, 0x23, 0xf8, 0x0a, 0x73, 0x91, 0xbb, 0x54, 0xa5, 0x05, 0x16, 0x72, 0xfb, 0x04, 0xee, 0xb5, 0x43, 
};
static const u8 rsa_pss_183_CRT_q[] = {
0x04, 0x83, 0xe0, 0xae, 0x47, 0x91, 0x55, 0x87, 0x74, 0x3f, 0xf3, 0x45, 0x36, 0x2b, 0x55, 0x5d, 0x39, 0x62, 0xd9, 0x8b, 0xb6, 0xf1, 0x5f, 0x84, 0x8b, 0x4c, 0x92, 0xb1, 0x77, 0x1c, 0xa8, 0xed, 0x10, 0x7d, 0x8d, 0x3e, 0xe6, 0x5e, 0xc4, 0x45, 0x17, 0xdd, 0x0f, 0xaa, 0x48, 0x1a, 0x38, 0x7e, 0x90, 0x2f, 0x7a, 0x2e, 0x74, 0x7c, 0x26, 0x9e, 0x7e, 0xa4, 0x44, 0x80, 0xbc, 0x53, 0x8b, 0x8e, 0x5b, 
};
static const u8 rsa_pss_183_CRT_dP[] = {
0x03, 0xa8, 0xe8, 0xae, 0xa9, 0x92, 0x0c, 0x1a, 0xa3, 0xb2, 0xf0, 0xd8, 0x46, 0xe4, 0xb8, 0x50, 0xd8, 0x1c, 0xa3, 0x06, 0xa5, 0x1c, 0x83, 0x54, 0x4f, 0x94, 0x9f, 0x64, 0xf9, 0x0d, 0xcf, 0x3f, 0x8e, 0x26, 0x61, 0xf0, 0x7e, 0x56, 0x12, 0x20, 0xa1, 0x80, 0x38, 0x8f, 0xbe, 0x27, 0x3e, 0x70, 0xe2, 0xe5, 0xdc, 0xa8, 0x3a, 0x0e, 0x13, 0x48, 0xdd, 0x64, 0x90, 0xc7, 0x31, 0xd6, 0xec, 0xe1, 0xab, 
};
static const u8 rsa_pss_183_CRT_dQ[] = {
0x01, 0x35, 0xbd, 0xcd, 0xb6, 0x0b, 0xf2, 0x19, 0x7c, 0x43, 0x6e, 0xd3, 0x4b, 0x32, 0xcd, 0x8b, 0x4f, 0xc7, 0x77, 0x78, 0x83, 0x2b, 0xa7, 0x67, 0x03, 0x55, 0x1f, 0xb2, 0x42, 0xb3, 0x01, 0x69, 0x95, 0x93, 0xaf, 0x77, 0xfd, 0x8f, 0xc3, 0x94, 0xa8, 0x52, 0x6a, 0xd2, 0x3c, 0xc4, 0x1a, 0x03, 0x80, 0x6b, 0xd8, 0x97, 0xfe, 0x4b, 0x0e, 0xa6, 0x46, 0x55, 0x8a, 0xad, 0xdc, 0xc9, 0x9e, 0x8a, 0x25, 
};
static const u8 rsa_pss_183_CRT_qInv[] = {
0x03, 0x04, 0xc0, 0x3d, 0x9c, 0x73, 0x65, 0x03, 0xa9, 0x84, 0xab, 0xbd, 0x9b, 0xa2, 0x23, 0x01, 0x40, 0x7c, 0x4a, 0x2a, 0xb1, 0xdd, 0x85, 0x76, 0x64, 0x81, 0xb6, 0x0d, 0x45, 0x40, 0x11, 0x52, 0xe6, 0x92, 0xbe, 0x14, 0xf4, 0x12, 0x1d, 0x9a, 0xa3, 0xfd, 0x6e, 0x0b, 0x4d, 0x1d, 0x3a, 0x97, 0x35, 0x38, 0xa3, 0x1d, 0x42, 0xee, 0x6e, 0x1e, 0x5e, 0xf6, 0x20, 0x23, 0x1a, 0x2b, 0xba, 0xf3, 0x5f, 
};


static const rsa_test test_rsa_pss_183_CRT = {
	.name = "rsa_pss_183_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_183_CRT_n,
	.nlen = sizeof(rsa_pss_183_CRT_n),
	.d = (const u8*)&rsa_pss_183_CRT_d,
	.dlen = sizeof(rsa_pss_183_CRT_d),
	.e = (const u8*)&rsa_pss_183_CRT_e,
	.elen = sizeof(rsa_pss_183_CRT_e),
	.p = (const u8*)&rsa_pss_183_CRT_p,
	.plen = sizeof(rsa_pss_183_CRT_p),
	.q = (const u8*)&rsa_pss_183_CRT_q,
	.qlen = sizeof(rsa_pss_183_CRT_q),
	.dP = (const u8*)&rsa_pss_183_CRT_dP,
	.dPlen = sizeof(rsa_pss_183_CRT_dP),
	.dQ = (const u8*)&rsa_pss_183_CRT_dQ,
	.dQlen = sizeof(rsa_pss_183_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_183_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_183_CRT_qInv),
	.m = (const u8*)&rsa_pss_183_CRT_m,
	.mlen = sizeof(rsa_pss_183_CRT_m),
	.res = (const u8*)&rsa_pss_183_CRT_res,
	.reslen = sizeof(rsa_pss_183_CRT_res),
	.salt = (const u8*)&rsa_pss_183_CRT_salt,
	.saltlen = sizeof(rsa_pss_183_CRT_salt),
};
static const u8 rsa_pss_184_n[] = {
0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1, 
};
static const u8 rsa_pss_184_d[] = {
0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f, 
};
static const u8 rsa_pss_184_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_184_m[] = {
0x0f, 0x61, 0x95, 0xd0, 0x4a, 0x6e, 0x6f, 0xc7, 0xe2, 0xc9, 0x60, 0x0d, 0xbf, 0x84, 0x0c, 0x39, 0xea, 0x8d, 0x4d, 0x62, 0x4f, 0xd5, 0x35, 0x07, 0x01, 0x6b, 0x0e, 0x26, 0x85, 0x8a, 0x5e, 0x0a, 0xec, 0xd7, 0xad, 0xa5, 0x43, 0xae, 0x5c, 0x0a, 0xb3, 0xa6, 0x25, 0x99, 0xcb, 0xa0, 0xa5, 0x4e, 0x6b, 0xf4, 0x46, 0xe2, 0x62, 0xf9, 0x89, 0x97, 0x8f, 0x9d, 0xdf, 0x5e, 0x9a, 0x41, 
};
static const u8 rsa_pss_184_res[] = {
0x08, 0x6d, 0xf6, 0xb5, 0x00, 0x09, 0x8c, 0x12, 0x0f, 0x24, 0xff, 0x84, 0x23, 0xf7, 0x27, 0xd9, 0xc6, 0x1a, 0x5c, 0x90, 0x07, 0xd3, 0xb6, 0xa3, 0x1c, 0xe7, 0xcf, 0x8f, 0x3c, 0xbe, 0xc1, 0xa2, 0x6b, 0xb2, 0x0e, 0x2b, 0xd4, 0xa0, 0x46, 0x79, 0x32, 0x99, 0xe0, 0x3e, 0x37, 0xa2, 0x1b, 0x40, 0x19, 0x4f, 0xb0, 0x45, 0xf9, 0x0b, 0x18, 0xbf, 0x20, 0xa4, 0x79, 0x92, 0xcc, 0xd7, 0x99, 0xcf, 0x9c, 0x05, 0x9c, 0x29, 0x9c, 0x05, 0x26, 0x85, 0x49, 0x54, 0xaa, 0xde, 0x8a, 0x6a, 0xd9, 0xd9, 0x7e, 0xc9, 0x1a, 0x11, 0x45, 0x38, 0x3f, 0x42, 0x46, 0x8b, 0x23, 0x1f, 0x4d, 0x72, 0xf2, 0x37, 0x06, 0xd9, 0x85, 0x3c, 0x3f, 0xa4, 0x3c, 0xe8, 0xac, 0xe8, 0xbf, 0xe7, 0x48, 0x49, 0x87, 0xa1, 0xec, 0x6a, 0x16, 0xc8, 0xda, 0xf8, 0x1f, 0x7c, 0x8b, 0xf4, 0x27, 0x74, 0x70, 0x7a, 0x9d, 0xf4, 0x56, 
};
static const u8 rsa_pss_184_salt[] = {
0xa8, 0x7b, 0x8a, 0xed, 0x07, 0xd7, 0xb8, 0xe2, 0xda, 0xf1, 0x4d, 0xdc, 0xa4, 0xac, 0x68, 0xc4, 0xd0, 0xaa, 0xbf, 0xf8, 
};


static const rsa_test test_rsa_pss_184 = {
	.name = "rsa_pss_184",
	.type = RSA_PSS_SIG,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_184_n,
	.nlen = sizeof(rsa_pss_184_n),
	.d = (const u8*)&rsa_pss_184_d,
	.dlen = sizeof(rsa_pss_184_d),
	.e = (const u8*)&rsa_pss_184_e,
	.elen = sizeof(rsa_pss_184_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_184_m,
	.mlen = sizeof(rsa_pss_184_m),
	.res = (const u8*)&rsa_pss_184_res,
	.reslen = sizeof(rsa_pss_184_res),
	.salt = (const u8*)&rsa_pss_184_salt,
	.saltlen = sizeof(rsa_pss_184_salt),
};
static const u8 rsa_pss_185_CRT_n[] = {
0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1, 
};
static const u8 rsa_pss_185_CRT_d[] = {
0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f, 
};
static const u8 rsa_pss_185_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_185_CRT_m[] = {
0x0f, 0x61, 0x95, 0xd0, 0x4a, 0x6e, 0x6f, 0xc7, 0xe2, 0xc9, 0x60, 0x0d, 0xbf, 0x84, 0x0c, 0x39, 0xea, 0x8d, 0x4d, 0x62, 0x4f, 0xd5, 0x35, 0x07, 0x01, 0x6b, 0x0e, 0x26, 0x85, 0x8a, 0x5e, 0x0a, 0xec, 0xd7, 0xad, 0xa5, 0x43, 0xae, 0x5c, 0x0a, 0xb3, 0xa6, 0x25, 0x99, 0xcb, 0xa0, 0xa5, 0x4e, 0x6b, 0xf4, 0x46, 0xe2, 0x62, 0xf9, 0x89, 0x97, 0x8f, 0x9d, 0xdf, 0x5e, 0x9a, 0x41, 
};
static const u8 rsa_pss_185_CRT_res[] = {
0x08, 0x6d, 0xf6, 0xb5, 0x00, 0x09, 0x8c, 0x12, 0x0f, 0x24, 0xff, 0x84, 0x23, 0xf7, 0x27, 0xd9, 0xc6, 0x1a, 0x5c, 0x90, 0x07, 0xd3, 0xb6, 0xa3, 0x1c, 0xe7, 0xcf, 0x8f, 0x3c, 0xbe, 0xc1, 0xa2, 0x6b, 0xb2, 0x0e, 0x2b, 0xd4, 0xa0, 0x46, 0x79, 0x32, 0x99, 0xe0, 0x3e, 0x37, 0xa2, 0x1b, 0x40, 0x19, 0x4f, 0xb0, 0x45, 0xf9, 0x0b, 0x18, 0xbf, 0x20, 0xa4, 0x79, 0x92, 0xcc, 0xd7, 0x99, 0xcf, 0x9c, 0x05, 0x9c, 0x29, 0x9c, 0x05, 0x26, 0x85, 0x49, 0x54, 0xaa, 0xde, 0x8a, 0x6a, 0xd9, 0xd9, 0x7e, 0xc9, 0x1a, 0x11, 0x45, 0x38, 0x3f, 0x42, 0x46, 0x8b, 0x23, 0x1f, 0x4d, 0x72, 0xf2, 0x37, 0x06, 0xd9, 0x85, 0x3c, 0x3f, 0xa4, 0x3c, 0xe8, 0xac, 0xe8, 0xbf, 0xe7, 0x48, 0x49, 0x87, 0xa1, 0xec, 0x6a, 0x16, 0xc8, 0xda, 0xf8, 0x1f, 0x7c, 0x8b, 0xf4, 0x27, 0x74, 0x70, 0x7a, 0x9d, 0xf4, 0x56, 
};
static const u8 rsa_pss_185_CRT_salt[] = {
0xa8, 0x7b, 0x8a, 0xed, 0x07, 0xd7, 0xb8, 0xe2, 0xda, 0xf1, 0x4d, 0xdc, 0xa4, 0xac, 0x68, 0xc4, 0xd0, 0xaa, 0xbf, 0xf8, 
};
static const u8 rsa_pss_185_CRT_p[] = {
0x04, 0xf0, 0x54, 0x8c, 0x96, 0x26, 0xab, 0x1e, 0xbf, 0x12, 0x44, 0x93, 0x47, 0x41, 0xd9, 0x9a, 0x06, 0x22, 0x0e, 0xfa, 0x2a, 0x58, 0x56, 0xaa, 0x0e, 0x75, 0x73, 0x0b, 0x2e, 0xc9, 0x6a, 0xdc, 0x86, 0xbe, 0x89, 0x4f, 0xa2, 0x80, 0x3b, 0x53, 0xa5, 0xe8, 0x5d, 0x27, 0x6a, 0xcb, 0xd2, 0x9a, 0xb8, 0x23, 0xf8, 0x0a, 0x73, 0x91, 0xbb, 0x54, 0xa5, 0x05, 0x16, 0x72, 0xfb, 0x04, 0xee, 0xb5, 0x43, 
};
static const u8 rsa_pss_185_CRT_q[] = {
0x04, 0x83, 0xe0, 0xae, 0x47, 0x91, 0x55, 0x87, 0x74, 0x3f, 0xf3, 0x45, 0x36, 0x2b, 0x55, 0x5d, 0x39, 0x62, 0xd9, 0x8b, 0xb6, 0xf1, 0x5f, 0x84, 0x8b, 0x4c, 0x92, 0xb1, 0x77, 0x1c, 0xa8, 0xed, 0x10, 0x7d, 0x8d, 0x3e, 0xe6, 0x5e, 0xc4, 0x45, 0x17, 0xdd, 0x0f, 0xaa, 0x48, 0x1a, 0x38, 0x7e, 0x90, 0x2f, 0x7a, 0x2e, 0x74, 0x7c, 0x26, 0x9e, 0x7e, 0xa4, 0x44, 0x80, 0xbc, 0x53, 0x8b, 0x8e, 0x5b, 
};
static const u8 rsa_pss_185_CRT_dP[] = {
0x03, 0xa8, 0xe8, 0xae, 0xa9, 0x92, 0x0c, 0x1a, 0xa3, 0xb2, 0xf0, 0xd8, 0x46, 0xe4, 0xb8, 0x50, 0xd8, 0x1c, 0xa3, 0x06, 0xa5, 0x1c, 0x83, 0x54, 0x4f, 0x94, 0x9f, 0x64, 0xf9, 0x0d, 0xcf, 0x3f, 0x8e, 0x26, 0x61, 0xf0, 0x7e, 0x56, 0x12, 0x20, 0xa1, 0x80, 0x38, 0x8f, 0xbe, 0x27, 0x3e, 0x70, 0xe2, 0xe5, 0xdc, 0xa8, 0x3a, 0x0e, 0x13, 0x48, 0xdd, 0x64, 0x90, 0xc7, 0x31, 0xd6, 0xec, 0xe1, 0xab, 
};
static const u8 rsa_pss_185_CRT_dQ[] = {
0x01, 0x35, 0xbd, 0xcd, 0xb6, 0x0b, 0xf2, 0x19, 0x7c, 0x43, 0x6e, 0xd3, 0x4b, 0x32, 0xcd, 0x8b, 0x4f, 0xc7, 0x77, 0x78, 0x83, 0x2b, 0xa7, 0x67, 0x03, 0x55, 0x1f, 0xb2, 0x42, 0xb3, 0x01, 0x69, 0x95, 0x93, 0xaf, 0x77, 0xfd, 0x8f, 0xc3, 0x94, 0xa8, 0x52, 0x6a, 0xd2, 0x3c, 0xc4, 0x1a, 0x03, 0x80, 0x6b, 0xd8, 0x97, 0xfe, 0x4b, 0x0e, 0xa6, 0x46, 0x55, 0x8a, 0xad, 0xdc, 0xc9, 0x9e, 0x8a, 0x25, 
};
static const u8 rsa_pss_185_CRT_qInv[] = {
0x03, 0x04, 0xc0, 0x3d, 0x9c, 0x73, 0x65, 0x03, 0xa9, 0x84, 0xab, 0xbd, 0x9b, 0xa2, 0x23, 0x01, 0x40, 0x7c, 0x4a, 0x2a, 0xb1, 0xdd, 0x85, 0x76, 0x64, 0x81, 0xb6, 0x0d, 0x45, 0x40, 0x11, 0x52, 0xe6, 0x92, 0xbe, 0x14, 0xf4, 0x12, 0x1d, 0x9a, 0xa3, 0xfd, 0x6e, 0x0b, 0x4d, 0x1d, 0x3a, 0x97, 0x35, 0x38, 0xa3, 0x1d, 0x42, 0xee, 0x6e, 0x1e, 0x5e, 0xf6, 0x20, 0x23, 0x1a, 0x2b, 0xba, 0xf3, 0x5f, 
};


static const rsa_test test_rsa_pss_185_CRT = {
	.name = "rsa_pss_185_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_185_CRT_n,
	.nlen = sizeof(rsa_pss_185_CRT_n),
	.d = (const u8*)&rsa_pss_185_CRT_d,
	.dlen = sizeof(rsa_pss_185_CRT_d),
	.e = (const u8*)&rsa_pss_185_CRT_e,
	.elen = sizeof(rsa_pss_185_CRT_e),
	.p = (const u8*)&rsa_pss_185_CRT_p,
	.plen = sizeof(rsa_pss_185_CRT_p),
	.q = (const u8*)&rsa_pss_185_CRT_q,
	.qlen = sizeof(rsa_pss_185_CRT_q),
	.dP = (const u8*)&rsa_pss_185_CRT_dP,
	.dPlen = sizeof(rsa_pss_185_CRT_dP),
	.dQ = (const u8*)&rsa_pss_185_CRT_dQ,
	.dQlen = sizeof(rsa_pss_185_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_185_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_185_CRT_qInv),
	.m = (const u8*)&rsa_pss_185_CRT_m,
	.mlen = sizeof(rsa_pss_185_CRT_m),
	.res = (const u8*)&rsa_pss_185_CRT_res,
	.reslen = sizeof(rsa_pss_185_CRT_res),
	.salt = (const u8*)&rsa_pss_185_CRT_salt,
	.saltlen = sizeof(rsa_pss_185_CRT_salt),
};
static const u8 rsa_pss_186_n[] = {
0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1, 
};
static const u8 rsa_pss_186_d[] = {
0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f, 
};
static const u8 rsa_pss_186_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_186_m[] = {
0x33, 0x7d, 0x25, 0xfe, 0x98, 0x10, 0xeb, 0xca, 0x0d, 0xe4, 0xd4, 0x65, 0x8d, 0x3c, 0xeb, 0x8e, 0x0f, 0xe4, 0xc0, 0x66, 0xab, 0xa3, 0xbc, 0xc4, 0x8b, 0x10, 0x5d, 0x3b, 0xf7, 0xe0, 0x25, 0x7d, 0x44, 0xfe, 0xce, 0xa6, 0x59, 0x6f, 0x4d, 0x0c, 0x59, 0xa0, 0x84, 0x02, 0x83, 0x36, 0x78, 0xf7, 0x06, 0x20, 0xf9, 0x13, 0x8d, 0xfe, 0xb7, 0xde, 0xd9, 0x05, 0xe4, 0xa6, 0xd5, 0xf0, 0x5c, 0x47, 0x3d, 0x55, 0x93, 0x66, 0x52, 0xe2, 0xa5, 0xdf, 0x43, 0xc0, 0xcf, 0xda, 0x7b, 0xac, 0xaf, 0x30, 0x87, 0xf4, 0x52, 0x4b, 0x06, 0xcf, 0x42, 0x15, 0x7d, 0x01, 0x53, 0x97, 0x39, 0xf7, 0xfd, 0xde, 0xc9, 0xd5, 0x81, 0x25, 0xdf, 0x31, 0xa3, 0x2e, 0xab, 0x06, 0xc1, 0x9b, 0x71, 0xf1, 0xd5, 0xbf, 
};
static const u8 rsa_pss_186_res[] = {
0x0b, 0x5b, 0x11, 0xad, 0x54, 0x98, 0x63, 0xff, 0xa9, 0xc5, 0x1a, 0x14, 0xa1, 0x10, 0x6c, 0x2a, 0x72, 0xcc, 0x8b, 0x64, 0x6e, 0x5c, 0x72, 0x62, 0x50, 0x97, 0x86, 0x10, 0x5a, 0x98, 0x47, 0x76, 0x53, 0x4c, 0xa9, 0xb5, 0x4c, 0x1c, 0xc6, 0x4b, 0xf2, 0xd5, 0xa4, 0x4f, 0xd7, 0xe8, 0xa6, 0x9d, 0xb6, 0x99, 0xd5, 0xea, 0x52, 0x08, 0x7a, 0x47, 0x48, 0xfd, 0x2a, 0xbc, 0x1a, 0xfe, 0xd1, 0xe5, 0xd6, 0xf7, 0xc8, 0x90, 0x25, 0x53, 0x0b, 0xda, 0xa2, 0x21, 0x3d, 0x7e, 0x03, 0x0f, 0xa5, 0x5d, 0xf6, 0xf3, 0x4b, 0xcf, 0x1c, 0xe4, 0x6d, 0x2e, 0xdf, 0x4e, 0x3a, 0xe4, 0xf3, 0xb0, 0x18, 0x91, 0xa0, 0x68, 0xc9, 0xe3, 0xa4, 0x4b, 0xbc, 0x43, 0x13, 0x3e, 0xda, 0xd6, 0xec, 0xb9, 0xf3, 0x54, 0x00, 0xc4, 0x25, 0x2a, 0x57, 0x62, 0xd6, 0x57, 0x44, 0xb9, 0x9c, 0xb9, 0xf4, 0xc5, 0x59, 0x32, 0x9f, 
};
static const u8 rsa_pss_186_salt[] = {
0xa3, 0x79, 0x32, 0xf8, 0xa7, 0x49, 0x4a, 0x94, 0x2d, 0x6f, 0x76, 0x74, 0x38, 0xe7, 0x24, 0xd6, 0xd0, 0xc0, 0xef, 0x18, 
};


static const rsa_test test_rsa_pss_186 = {
	.name = "rsa_pss_186",
	.type = RSA_PSS_SIG,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_186_n,
	.nlen = sizeof(rsa_pss_186_n),
	.d = (const u8*)&rsa_pss_186_d,
	.dlen = sizeof(rsa_pss_186_d),
	.e = (const u8*)&rsa_pss_186_e,
	.elen = sizeof(rsa_pss_186_e),
	.p = NULL,
	.plen = 0,
	.q = NULL,
	.qlen = 0,
	.dP = NULL,
	.dPlen = 0,
	.dQ = NULL,
	.dQlen = 0,
	.qInv = NULL,
	.qInvlen = 0,
	.m = (const u8*)&rsa_pss_186_m,
	.mlen = sizeof(rsa_pss_186_m),
	.res = (const u8*)&rsa_pss_186_res,
	.reslen = sizeof(rsa_pss_186_res),
	.salt = (const u8*)&rsa_pss_186_salt,
	.saltlen = sizeof(rsa_pss_186_salt),
};
static const u8 rsa_pss_187_CRT_n[] = {
0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1, 
};
static const u8 rsa_pss_187_CRT_d[] = {
0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f, 
};
static const u8 rsa_pss_187_CRT_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_187_CRT_m[] = {
0x33, 0x7d, 0x25, 0xfe, 0x98, 0x10, 0xeb, 0xca, 0x0d, 0xe4, 0xd4, 0x65, 0x8d, 0x3c, 0xeb, 0x8e, 0x0f, 0xe4, 0xc0, 0x66, 0xab, 0xa3, 0xbc, 0xc4, 0x8b, 0x10, 0x5d, 0x3b, 0xf7, 0xe0, 0x25, 0x7d, 0x44, 0xfe, 0xce, 0xa6, 0x59, 0x6f, 0x4d, 0x0c, 0x59, 0xa0, 0x84, 0x02, 0x83, 0x36, 0x78, 0xf7, 0x06, 0x20, 0xf9, 0x13, 0x8d, 0xfe, 0xb7, 0xde, 0xd9, 0x05, 0xe4, 0xa6, 0xd5, 0xf0, 0x5c, 0x47, 0x3d, 0x55, 0x93, 0x66, 0x52, 0xe2, 0xa5, 0xdf, 0x43, 0xc0, 0xcf, 0xda, 0x7b, 0xac, 0xaf, 0x30, 0x87, 0xf4, 0x52, 0x4b, 0x06, 0xcf, 0x42, 0x15, 0x7d, 0x01, 0x53, 0x97, 0x39, 0xf7, 0xfd, 0xde, 0xc9, 0xd5, 0x81, 0x25, 0xdf, 0x31, 0xa3, 0x2e, 0xab, 0x06, 0xc1, 0x9b, 0x71, 0xf1, 0xd5, 0xbf, 
};
static const u8 rsa_pss_187_CRT_res[] = {
0x0b, 0x5b, 0x11, 0xad, 0x54, 0x98, 0x63, 0xff, 0xa9, 0xc5, 0x1a, 0x14, 0xa1, 0x10, 0x6c, 0x2a, 0x72, 0xcc, 0x8b, 0x64, 0x6e, 0x5c, 0x72, 0x62, 0x50, 0x97, 0x86, 0x10, 0x5a, 0x98, 0x47, 0x76, 0x53, 0x4c, 0xa9, 0xb5, 0x4c, 0x1c, 0xc6, 0x4b, 0xf2, 0xd5, 0xa4, 0x4f, 0xd7, 0xe8, 0xa6, 0x9d, 0xb6, 0x99, 0xd5, 0xea, 0x52, 0x08, 0x7a, 0x47, 0x48, 0xfd, 0x2a, 0xbc, 0x1a, 0xfe, 0xd1, 0xe5, 0xd6, 0xf7, 0xc8, 0x90, 0x25, 0x53, 0x0b, 0xda, 0xa2, 0x21, 0x3d, 0x7e, 0x03, 0x0f, 0xa5, 0x5d, 0xf6, 0xf3, 0x4b, 0xcf, 0x1c, 0xe4, 0x6d, 0x2e, 0xdf, 0x4e, 0x3a, 0xe4, 0xf3, 0xb0, 0x18, 0x91, 0xa0, 0x68, 0xc9, 0xe3, 0xa4, 0x4b, 0xbc, 0x43, 0x13, 0x3e, 0xda, 0xd6, 0xec, 0xb9, 0xf3, 0x54, 0x00, 0xc4, 0x25, 0x2a, 0x57, 0x62, 0xd6, 0x57, 0x44, 0xb9, 0x9c, 0xb9, 0xf4, 0xc5, 0x59, 0x32, 0x9f, 
};
static const u8 rsa_pss_187_CRT_salt[] = {
0xa3, 0x79, 0x32, 0xf8, 0xa7, 0x49, 0x4a, 0x94, 0x2d, 0x6f, 0x76, 0x74, 0x38, 0xe7, 0x24, 0xd6, 0xd0, 0xc0, 0xef, 0x18, 
};
static const u8 rsa_pss_187_CRT_p[] = {
0x04, 0xf0, 0x54, 0x8c, 0x96, 0x26, 0xab, 0x1e, 0xbf, 0x12, 0x44, 0x93, 0x47, 0x41, 0xd9, 0x9a, 0x06, 0x22, 0x0e, 0xfa, 0x2a, 0x58, 0x56, 0xaa, 0x0e, 0x75, 0x73, 0x0b, 0x2e, 0xc9, 0x6a, 0xdc, 0x86, 0xbe, 0x89, 0x4f, 0xa2, 0x80, 0x3b, 0x53, 0xa5, 0xe8, 0x5d, 0x27, 0x6a, 0xcb, 0xd2, 0x9a, 0xb8, 0x23, 0xf8, 0x0a, 0x73, 0x91, 0xbb, 0x54, 0xa5, 0x05, 0x16, 0x72, 0xfb, 0x04, 0xee, 0xb5, 0x43, 
};
static const u8 rsa_pss_187_CRT_q[] = {
0x04, 0x83, 0xe0, 0xae, 0x47, 0x91, 0x55, 0x87, 0x74, 0x3f, 0xf3, 0x45, 0x36, 0x2b, 0x55, 0x5d, 0x39, 0x62, 0xd9, 0x8b, 0xb6, 0xf1, 0x5f, 0x84, 0x8b, 0x4c, 0x92, 0xb1, 0x77, 0x1c, 0xa8, 0xed, 0x10, 0x7d, 0x8d, 0x3e, 0xe6, 0x5e, 0xc4, 0x45, 0x17, 0xdd, 0x0f, 0xaa, 0x48, 0x1a, 0x38, 0x7e, 0x90, 0x2f, 0x7a, 0x2e, 0x74, 0x7c, 0x26, 0x9e, 0x7e, 0xa4, 0x44, 0x80, 0xbc, 0x53, 0x8b, 0x8e, 0x5b, 
};
static const u8 rsa_pss_187_CRT_dP[] = {
0x03, 0xa8, 0xe8, 0xae, 0xa9, 0x92, 0x0c, 0x1a, 0xa3, 0xb2, 0xf0, 0xd8, 0x46, 0xe4, 0xb8, 0x50, 0xd8, 0x1c, 0xa3, 0x06, 0xa5, 0x1c, 0x83, 0x54, 0x4f, 0x94, 0x9f, 0x64, 0xf9, 0x0d, 0xcf, 0x3f, 0x8e, 0x26, 0x61, 0xf0, 0x7e, 0x56, 0x12, 0x20, 0xa1, 0x80, 0x38, 0x8f, 0xbe, 0x27, 0x3e, 0x70, 0xe2, 0xe5, 0xdc, 0xa8, 0x3a, 0x0e, 0x13, 0x48, 0xdd, 0x64, 0x90, 0xc7, 0x31, 0xd6, 0xec, 0xe1, 0xab, 
};
static const u8 rsa_pss_187_CRT_dQ[] = {
0x01, 0x35, 0xbd, 0xcd, 0xb6, 0x0b, 0xf2, 0x19, 0x7c, 0x43, 0x6e, 0xd3, 0x4b, 0x32, 0xcd, 0x8b, 0x4f, 0xc7, 0x77, 0x78, 0x83, 0x2b, 0xa7, 0x67, 0x03, 0x55, 0x1f, 0xb2, 0x42, 0xb3, 0x01, 0x69, 0x95, 0x93, 0xaf, 0x77, 0xfd, 0x8f, 0xc3, 0x94, 0xa8, 0x52, 0x6a, 0xd2, 0x3c, 0xc4, 0x1a, 0x03, 0x80, 0x6b, 0xd8, 0x97, 0xfe, 0x4b, 0x0e, 0xa6, 0x46, 0x55, 0x8a, 0xad, 0xdc, 0xc9, 0x9e, 0x8a, 0x25, 
};
static const u8 rsa_pss_187_CRT_qInv[] = {
0x03, 0x04, 0xc0, 0x3d, 0x9c, 0x73, 0x65, 0x03, 0xa9, 0x84, 0xab, 0xbd, 0x9b, 0xa2, 0x23, 0x01, 0x40, 0x7c, 0x4a, 0x2a, 0xb1, 0xdd, 0x85, 0x76, 0x64, 0x81, 0xb6, 0x0d, 0x45, 0x40, 0x11, 0x52, 0xe6, 0x92, 0xbe, 0x14, 0xf4, 0x12, 0x1d, 0x9a, 0xa3, 0xfd, 0x6e, 0x0b, 0x4d, 0x1d, 0x3a, 0x97, 0x35, 0x38, 0xa3, 0x1d, 0x42, 0xee, 0x6e, 0x1e, 0x5e, 0xf6, 0x20, 0x23, 0x1a, 0x2b, 0xba, 0xf3, 0x5f, 
};


static const rsa_test test_rsa_pss_187_CRT = {
	.name = "rsa_pss_187_CRT",
	.type = RSA_PSS_SIG,
	.modbits = 1029,
	.hash = HASH_SHA1,
	.n = (const u8*)&rsa_pss_187_CRT_n,
	.nlen = sizeof(rsa_pss_187_CRT_n),
	.d = (const u8*)&rsa_pss_187_CRT_d,
	.dlen = sizeof(rsa_pss_187_CRT_d),
	.e = (const u8*)&rsa_pss_187_CRT_e,
	.elen = sizeof(rsa_pss_187_CRT_e),
	.p = (const u8*)&rsa_pss_187_CRT_p,
	.plen = sizeof(rsa_pss_187_CRT_p),
	.q = (const u8*)&rsa_pss_187_CRT_q,
	.qlen = sizeof(rsa_pss_187_CRT_q),
	.dP = (const u8*)&rsa_pss_187_CRT_dP,
	.dPlen = sizeof(rsa_pss_187_CRT_dP),
	.dQ = (const u8*)&rsa_pss_187_CRT_dQ,
	.dQlen = sizeof(rsa_pss_187_CRT_dQ),
	.qInv = (const u8*)&rsa_pss_187_CRT_qInv,
	.qInvlen = sizeof(rsa_pss_187_CRT_qInv),
	.m = (const u8*)&rsa_pss_187_CRT_m,
	.mlen = sizeof(rsa_pss_187_CRT_m),
	.res = (const u8*)&rsa_pss_187_CRT_res,
	.reslen = sizeof(rsa_pss_187_CRT_res),
	.salt = (const u8*)&rsa_pss_187_CRT_salt,
	.saltlen = sizeof(rsa_pss_187_CRT_salt),
};
static const u8 rsa_pss_188_n[] = {
0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1, 
};
static const u8 rsa_pss_188_d[] = {
0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f, 
};
static const u8 rsa_pss_188_e[] = {
0x01, 0x00, 0x01, 
};
static const u8 rsa_pss_188_m[] = {
0x84, 0xec, 0x50, 0x2b, 0x07, 0x2e, 0x82, 0x87, 0x78, 0x9d, 0x8f, 0x92, 0x35, 0x82, 0x9e, 0xa3, 0xb1, 0x87, 0xaf, 0xd4, 0xd4, 0xc7, 0x85, 0x61, 0x1b, 0xda, 0x5f, 0x9e, 0xb3, 0xcb, 0x96, 0x71, 0x7e, 0xfa, 0x70, 0x07, 0x22, 0x7f, 0x1c, 0x08, 0xcb, 0xcb, 0x97, 0x2e, 0x66, 0x72, 0x35, 0xe0, 0xfb, 0x7d, 0x43, 0x1a, 0x65, 0x70, 0x32, 0x6d, 0x2e, 0xcc, 0xe3, 0x5a, 0xdb, 0x37, 0x3d, 0xc7, 0x53, 0xb3, 0xbe, 0x5f, 0x82, 0x9b, 0x89, 0x17, 0x54, 0x93, 0x19, 0x3f, 0xab, 0x16, 0xba, 0xdb, 0x41, 0x37, 0x1b, 0x3a, 0xac, 0x0a, 0xe6, 0x70, 0x07, 0x6f, 0x24, 0xbe, 0xf4, 0x20, 0xc1, 0x35, 0xad, 0xd7, 0xce, 0xe8, 0xd3, 0x5f, 0xbc, 0x94, 0x4d, 0x79, 0xfa, 0xfb, 0x9e, 0x30, 0x7a, 0x13, 0xb0, 0xf5, 0x56, 0xcb, 0x65, 0x4a, 0x06, 0xf9, 0x73, 0xed, 0x22, 0x67, 0x23, 0x30, 0x19, 0x7e, 0xf5, 0xa7, 0x48, 0xbf, 0x82, 0x6a, 0x5d, 0xb2, 0x38, 0x3a, 0x25, 0x36, 0x4b, 0x68, 0x6b, 0x93, 0x72, 0xbb, 0x23, 0x39, 0xae, 0xb1, 0xac, 0x9e, 0x98, 0x89, 0x32, 0x7d, 0x01, 0x6f, 0x16, 0x70, 0x77, 0x6d, 0xb0, 0x62, 0x01, 0xad, 0xbd, 0xca, 0xf8, 0xa5, 0xe3, 0xb7, 0x4e, 0x10, 0x8b, 0x73, 
};
static const u8 rsa_pss_188_res[] = {
0x02, 0xd7, 0x1f, 0xa9, 0xb5, 0x3e, 0x46, 0x54, 0xfe, 0xfb, 0x7f, 0x08, 0x38, 0x5c, 0xf6, 0xb0, 0xae, 0x3a, 0x81, 0x79, 0x42, 0xeb, 0xf6, 0x6c, 0x35, 0xac, 0x67, 0xf0, 0xb0, 0x69, 0x95, 0x2a, 0x3c, 0xe9, 0xc7, 0xe1, 0xf1, 0xb0, 0x2e, 0x48, 0x0a, 0x95, 0x00, 0x83, 0x6d, 0xe5, 0xd6, 0x4c, 0xdb, 0x7e, 0xcd, 0xe0, 0x45, 0x42, 0xf7, 0xa7, 0x99, 0x88, 0x78, 0x7e, 0x24,