/*
 * Written by Guy Roberts of Object Skills Ltd, drifting
 * in cyberspace without a domain or email address right 
 * now. 
 * May 7 1993. You can use this as a base for a better application
 * as long as it is made publically available.
 */
 
/* Controller coordinates the selection of header files and
 * the creation of Translator objects which themselves
 * create the rich text output of a manual page and optionally
 * launch the Edit application.
 */
 
#import "Controller.h"

@implementation Controller

#define SUFFIX "h"
#define IS_DIR(m)      (((m)&S_IFMT) == S_IFDIR)

- init
{
	[super init];
	
	openReq = [OpenPanel new];
	lastDirectoryUsed = (char *) NXHomeDirectory();
	
	/* Become the delegate of the panels to get 
	 * panel:filterFile:inDirectory messages.
	 */
	[openReq	setDelegate:self];
	[NXApp	setDelegate: self];
	
	return self;
}

- appDidInit: sender
{
	[self	open: self];

	return self;
}

- (int) app: sender 
		openFile: (const char *) fileName 
		type: (const char *) aType
{	
	[self	createATranslator: (char *) fileName];

	return YES;
}

-(BOOL) appAcceptsAnotherFile:sender
{
  return (YES);
}

- open: sender
{
	const	char	*nameToUse = NULL;
	const	char	*documentDir = NULL;
	char	theTypes[2];
	
	theTypes[0] = 'h';
	theTypes[1] = 0;

	[[[openReq	setTitle: [headingNames	valueForStringKey: "openPanelTitle"]]	
		setRequiredFileType: SUFFIX]
		runModalForDirectory: lastDirectoryUsed
		file: ""];
		
	nameToUse = [openReq	filename];
	
	if (!nameToUse)
		return self;

	/* Remember where to open the next open panel */
	
	[self createATranslator: (char *) nameToUse];
	
	{
		char	buffer[1024], *ptr;
		
		buffer[0] = '\0';
		strcat(buffer, nameToUse);
		ptr = index(buffer, '/'); /* Truncate it */
		*ptr = '\0';
		/* BUG we leak the space pointed to previously by lastDirectoryUsed */
		lastDirectoryUsed = NXCopyStringBuffer(buffer);
	}

	return self;
}

- createATranslator: (char *) name;
{	
	/* These Translator objects do the work of creating rich text */
	[[Translator	alloc]	initForHeaderFile: name withTable: headingNames];
	
	return self;
}

- (BOOL) panelValidateFilenames:sender
{
	return(YES);
}

- (BOOL) panel: panel 
	filterFile: (const char *) fileName
	inDirectory: (const char *) directory
{
	char	*suffix = rindex(fileName, '.');
	char	fullPath[1024];
	struct	stat	buffer;

	sprintf(fullPath, "%s/%s", directory, fileName);

	/* Collect information about the file to be filtered */ 
	if (stat(fullPath, &buffer) == -1)
		return NO;
	else if (IS_DIR(buffer.st_mode))
			return YES;
	else if (suffix && (strcmp(suffix, ".h") == 0))
		return(YES);
	else
		return(NO);
}

- showInfoPanel: sender;
{
	if (infoview == 0)
		[NXApp loadNibSection: "info.nib" owner:self];
	
	[[infoview window] makeKeyAndOrderFront: self];
	
#ifdef SHOW_OFF
	[infoview	 fadeAway:self];
#endif

	return self;
}

- showPreferences:sender
{
    if (preferences == nil)
			[NXApp loadNibSection:"Preferences.nib" owner:self];
  
    [preferences	showPreferencePanel: self];

    return self;
}

- endAllWars: sender
{
    NXRunAlertPanel(NULL, [headingNames	valueForStringKey: "notImplemented"]
			, NULL, NULL, NULL, "Continue");

	return self;
}

- free
{
	return [super free];
}

@end
