/*
 * A controller object for a DSPRecorder.
 */

#import <dpsclient/dpsclient.h>
#import <sound/soundstruct.h>
#import <appkit/SavePanel.h>
#import "DSPRecorder.h"

#define HEADER_SIZE	vm_page_size

/* Tags for the stop/pause/play/record buttons */
#define STOP_TAG	0
#define PAUSE_TAG	1
#define PLAY_TAG	2
#define RECORD_TAG	3

/* Tags for the sample rate buttons */
#define	SRATE_44K_TAG	0
#define SRATE_22K_TAG	1

/* Tags for the mono/stereo buttons */
#define	STEREO_TAG	0
#define	MONO_MIX_TAG	1
#define	MONO_L_TAG	2
#define	MONO_R_TAG	3

#define FD_CLOSED	-1

@interface Transport:Object
{
  id fileNameWindow;		/* File we'll record into and play from */
  id statusWindow;		/* Where we display the current status */
  id monoStereoButtons;		/* mono/stereo control */
  id samplingRateButtons;	/* set the sampling rate */
  DPSTimedEntry statusTE;	/* Timed entry to update status window */
  int outFileFD;		/* fd of sound file open for writing */
  const char *outFilename;	/* name of the output file. */
  DSPRecorder *dspRecorder;	/* The DSPRecorder object */
  SavePanel *savePanel;		/* where we save the output file */
  int monoStereo;		/* cached value of the Mono/Stereo buttons */
  int samplingRate;		/* cached value of the samplingRate buttons */
  Sound *playSound;		/* sound object that we'll play */
}

/*
 * Standard methods needed by the IB to initialize the instance variables.
 */
+ new;
- setFileNameWindow:anObject;
- setStatusWindow:anObject;
- setMonoStereoButtons:anObject;
- setSamplingRateButtons:anObject;

- (SavePanel *)savePanel;
- openOutput:sender;
- closeOutput :sender;
- closeOutputFD :sender;

/* Handle Stop/Pause/Record button pushes */
- stop :sender;
- pause :sender;
- play :sender;
- record :sender;

/* Internal methods */
- updateStatus;

/* Delegate methods */
- willRecord :recorder;
- didRecord :recorder;
- recordData :recorder :(char *)data :(int)size;


@end

