/*
 * combine.c:
 *
 * This program will take a NIBLIST and a set of NIBS in your directory
 * and a program and recombine them into a new program...
 */

#include <libc.h>
FILE	*nibfile;
char	**niblist;
int	nibs=0;
char	*inprog;
char	*outprog;
char	tempprog[256];

void	usage()
{
	printf("usage: extract <input-program> <output-program>\n");
	exit(1);
}


int	insert_nib(char *nibname,char *filename)
{
	char	buf[256];

	sprintf(buf,"/bin/segedit -replace __NIB %s %s %s -output %s",
		nibname,filename,outprog,tempprog);

	puts(buf);
	system(buf);

	sprintf(buf,"/bin/mv %s %s",tempprog,outprog);
	system(buf);
	printf("\t%s\n",buf);
}



int	main(int argc,char **argv)
{
	char	buf[256];

	if(argc<3){
		usage();
	}

	inprog	= argv[1];
	outprog	= argv[2];

	sprintf(tempprog,"%s.new",outprog);
	sprintf(buf,"/bin/cp %s %s",inprog,outprog);
	system(buf);

	/* process NIBLIST */

	nibfile	= fopen("NIBLIST","r");
	if(!nibfile){
		perror("NIBLIST");
		exit(1);
	}

	while(!feof(nibfile)){
		char	nibname[256];
		char	filename[256];
		long	mtime;
		
		if(fscanf(nibfile,"%s %s %ld",nibname,filename,&mtime)==3){
			struct stat sbuf;

			stat(filename,&sbuf);
			if(mtime!=sbuf.st_mtime){
				insert_nib(nibname,filename);
			}
		}
	}
	return(0);
}
