;
;    THIS IS THE DSPBUG UTILITY DEFINITION TABLE.  GOOD PROGRAMMING
;    PRACTICE WILL REFERENCE THE DSPBUG UTILITIES THROUGH THIS EQUATE
;    TABLE TO PROVIDE UPWARD COMPATIBILITY WITH CHANGES IN THE
;    MONITOR DEFINITION.
;
; This program, originally available on the Motorola DSP bulletin board,
; is provided under a DISCLAIMER OF WARRANTY available from Motorola DSP
; Operation, 6501 William Cannon Drive, West, Austin, Texas  78735-8598.
;

;             MONITOR COLD START
DSPBUG        EQU    $E000    

;             MONITOR WARM START (COMMAND LEVEL ENTRY POINT)
CMD           EQU    $E002    

;             SET TERMINAL AS I/O DEVICE
SET_TERM      EQU    $E004    

;             SET HOST AS I/O DEVICE
SET_HOST      EQU    $E006    

;             DEFINE TERMINAL WITH DEV IN B AND INIT
DEFINE_TERM   EQU    $E008    

;             DEFINE HOST WITH DEV IN B AND INIT
DEFINE_HOST   EQU    $E00A    

;             SCAN INPUT DEVICE, A=CHAR IF Z=0
IN0           EQU    $E00C    

;             8 BIT DATA INPUT TO A1 LOWER BYTE
IN1           EQU    $E00E    

;             INPUT CHAR, MASK PARITY, TOP BYTE OF A1
IN2           EQU    $E010    

;             IN2 + ECHO CHARACTER
IN3           EQU    $E012    

;             INPUT A 2 NIBBLE BYTE TO B1
INBYTE        EQU    $E014    

;             INPUT A 4 NIBBLE ADDRESS INTO B1
INADD         EQU    $E016    

;             INPUT A 6 NIBBLE DATA INTO B1
INDAT         EQU    $E018    

;             INBYTE BUT IGNORES LEADING BLANKS
INBYTE_NLS    EQU    $E01A    

;             INADD BUT IGNORES LEADING BLANKS
INADD_NLS     EQU    $E01C    

;             INDAT BUT IGNORES LEADING BLANKS
INDAT_NLS     EQU    $E01E    

;             8 BIT OUTPUT FROM A1 LOWER BYTE
OUT0          EQU    $E020    

;             OUT0 + CTRL/S/Q PROTOCOL
OUT1          EQU    $E022    

;             MASK PARITY, OUTPUT FROM TOP OF A1 USING OUT1
OUT2          EQU    $E024    

;             OUTPUT 3 PACKED CHARACTERS FROM A1
OUT3          EQU    $E026    

;             OUTPUT N0 PACKED CHARS POINTED TO BY R0
OUT4          EQU    $E028    

;             OUTPUT PACKED CHARS PNTED TO BY R0, ENDING IN 0
OUT5          EQU    $E02A    

;             OUTPUT 2 NIBBLE BYTE FROM LOWER B1 IN HEX
OUTBYTE       EQU    $E02C    

;             OUTPUT 4 NIBBLE ADDRESS FROM LOWER B1 IN HEX
OUTADD        EQU    $E02E    

;             OUTPUT 6 NIBBLE ADDRESS FROM LOWER B1 IN HEX
OUTDAT        EQU    $E030    

;             OUTPUT B1 IN DECIMAL (MAX INPUT VALUE=F423F)
OUTDEC        EQU    $E032    

;             ADD COMMAND TO COMMAND TABLE
ADDCMD        EQU    $E034    

;             OUTPUT <CR><LF>
CRLF          EQU    $E036    

;             OUTPUT <SPC>
PRTSPC        EQU    $E038    

;             UPLOAD DATA FORMAT
UP_DATA       EQU    $E03A    

;             UPLOAD OMF RECORDS
UP_OMF        EQU    $E03C    

;             OUTPUT VALUE IN B AS A SIGNED FRACTION
OUTFRAC       EQU    $E03E

;             INPUT NUMBER IN DECIMAL
INDEC         EQU    $E040
