/* Document.m
*  Purpose: A subclass of Window which creates an instance of the PageScrollView.
*
*  You may freely copy, distribute, and reuse the code in this example.
*  NeXT disclaims any warranty of any kind, expressed or  implied, as to its fitness
*  for any particular use.
*
*/

#import <appkit/Text.h>
#import "Document.h"
#import "PageScrollView.h"

@implementation Document : Window

/* Initialize the document to be something reasonable */
- init
{
	NXRect	aRect = {{0.0, 0.0}, {500.0, 700.0}};
	[self initContent: &aRect  
		style: NX_TITLEDSTYLE  
		backing: NX_BUFFERED 
		buttonMask:  NX_CLOSEBUTTONMASK | NX_MINIATURIZEBUTTONMASK
		defer: NO  screen: NULL];
	return self;
}

- initContent:(const NXRect *)contentRect  style:(int)aStyle  backing:(int)bufferingType
	buttonMask:(int)mask  defer:(BOOL)flag  screen:(const NXScreen *)aScreen
{
	id scroller, docView;
	NXRect aRect = {{0.0, 0.0}, {1000.0, 1000.0}};
	
	[super initContent: contentRect  style: aStyle  backing: bufferingType
		buttonMask: mask  defer: flag  screen: aScreen];
	docView = [[Text alloc] initFrame: &aRect];
	[docView setClipping:NO];
	scroller = [[PageScrollView alloc] initFrame: &aRect];
	[scroller setVertScrollerRequired:YES];
	[scroller setHorizScrollerRequired:YES];
	[scroller setDocView: docView];
	[scroller setDisplayOnScroll:YES];
	[scroller setLineScroll:14.0];
	[[self setContentView: scroller] free];
	[self setTitle: "UNTITLED"];
	return self;
}


@end
