/*  
 * 
 * TestView.m	-- How to rotate an NXImage
 * 
 * This View is the view that displays the NXImage.  The actual rotation
 * is done in MyImage
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by Henry Krempel -- NeXT Developer Support
 *
 * Wed Apr 10 17:39:50 1991
 */
#import "TestView.h"
#import "MyImage.h"
#import <appkit/defaults.h>
#import <appkit/Control.h>
#import <dpsclient/wraps.h>
#import <strings.h>

@implementation TestView

- initFrame:(NXRect *)r
{
	[super initFrame:r];
    image1 = [[MyImage alloc] initFromSection:"one"];

    return self;
}

/*
 * Set the rotation from the value of the sender (could be a slider)
 *
 */

- setR1:sender
{
    [image1 setRotation:[sender intValue]];
    [self display];
    return self;
}


- flipImage:sender
{
    [image1 flip:sender];
    [self display];
    return self;
}

/*
 * the drawing routine:  fill with grey,  and then composite the image
 *
 */
 
- drawSelf:(NXRect *)r :(int)rectCount
{
    NXPoint p1 = {0.0, 0.0};

    PSsetgray (NX_LTGRAY);
    NXRectFill (&bounds);

    [image1 composite:NX_SOVER toPoint:&p1];

    return self;
}

@end
