/*  
 * 
 * MyImage.m	-- How to rotate an NXImage
 * 
 * This is a subclass of NXImage that supports rotation by overriding 
 * drawRepresentation:inRect:
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by Henry Krempel -- NeXT Developer Support
 *
 * Wed Apr 10 17:39:50 1991
 */
#import "MyImage.h"
#import <appkit/NXImage.h>
#import <appkit/View.h>
#import <dpsclient/wraps.h>
#import <math.h>
#import "wraps.h"


@implementation MyImage

 
- initFromFile:(const char *)fileName
{
	[super initFromFile:fileName];
	[self getSize:&origSize];
	rotSize.width=origSize.height;
	rotSize.height=origSize.width;
	currentSize=&origSize;
	flipped=0;
	return self;
}

- initFromSection:(const char *)imageName
{
	[super initFromSection:imageName];
	[self getSize:&origSize];
	rotSize.width=origSize.height;
	rotSize.height=origSize.width;
	currentSize=&origSize;
	flipped=0;
	return self;
}

/*
 *
 * drawRepresentation:inRect: override.  Any changes to the PostScript 
 * transformation matrix can take effect here. Compositing normally ignores
 * these changes,  but we are doing the transformation before the offscreen 
 * NXImage is rendered,  then compositing this into our visible window.
 *
 */
 
- (BOOL)drawRepresentation:(NXImageRep *)imageRep inRect:(const NXRect *)rect
{
    if (NXDrawingStatus == NX_DRAWING) {	// Don't do this when printing
	PSgsave();
	NXSetColor (NX_COLORCLEAR);
	NXRectFill (rect);
	PSgrestore();
    }
	
  /*
   * The wrap below translates and rotates to the appropriate starting point,
   * based on the rotation state (0 1 2 3) and the angle
   */
	 
    PSW_transformToFit(rotation, rotation*90, origSize.width, origSize.height);
	
	if (flipped) PSW_flipit(origSize.width, origSize.height);
            
    return [super drawRepresentation:imageRep inRect:rect];
}

/*
 * Set the rotation of the image.  This will be one of 4 values 0..3 for the 
 * four rotations we do here.  We only support these four since the size of
 * these rectangles is easy to calculate.
 *
 */
 
- setRotation:(int)anInt
{
    NXSize *size;
	rotation = anInt;
	
  /*
   * Handles 2 rectangles, the original and the sideways (rotSize).
   */
	 
	if ( (rotation % 2) == 0 ) size=&origSize;
	else size=&rotSize;
	
	if (currentSize != size) {
    	[self setSize:size];
    	[self recache];
		currentSize=size;
		}
	
    return self;
}

- flip:sender
{
	flipped = (flipped+1) % 2;
	[self recache];
	return sender;
}

@end

