/* MyPageLayout.h
 * Purpose: A subclass of the PageLayout panel that displays more of the
 * information from NXApp's PrintInfo object.  If you add an accessory
 * View to the PageLayout panel, you commonly need to subclass it to
 * keep your fields in sync with the user's chosen units.
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 */
#import <appkit/PageLayout.h>

@interface MyPageLayout : PageLayout
{
	id	p1AccessoryView;
	id	centerButtons;
	id	vertButtons;
	id	paginationButtons;
	id	margins;
	id	horButtons;
}

/* Methods overridden from superclass */

- (int) runModal;
- pickedUnits:sender;
- readPrintInfo;
- writePrintInfo;

@end
