// GraphicImage.h
// By Jayson Adams
// NeXT Strategic Developer Engineer
//
// You may freely copy, distribute and reuse the code in this example.
// NeXT disclaims any warranty of any kind, expressed or implied, as to its
// fitness for any particular use.

#import <objc/Object.h>
#import <appkit/graphics.h>
#import <dpsclient/event.h>

@interface GraphicImage:Object
{
    id		image;
    BOOL	highlighted;
}

/* instance methods */
- initForImage:anImage;
- free;
- calcCellSize:(NXSize *)theSize;
- highlight:(const NXRect *)cellFrame inView:controlView lit:(BOOL)flag;
- drawSelf:(const NXRect *)cellFrame inView:controlView;
- trackMouse:(NXEvent *)theEvent inRect:(const NXRect *)cellFrame
  ofView:controlView;
- readRichText:(NXStream *)stream forView:view;
- writeRichText:(NXStream *)stream forView:view;
- performDoubleClickAction;

@end
