
/* Generated by Interface Builder */

#import "Verifier.h"
#import <string.h>
#import <appkit/publicWraps.h>
#import <appkit/Matrix.h>
#import <appkit/Cell.h>
#import <appkit/Text.h>

/*
 *
 * The Verifier Object
 *
 * This Object is a Text Delegate that enforces valid data entry on
 * Forms that use it as a Text Delegate.  The FormCells must have their
 * Entry types set ( [cellname setEntryType:NX_FLOATTYPE] for instance.
 *
 * The Verifier also enforces a length restriction.  In this example,  it is 
 * used for the separator,  which must be a single character.
 *
 * Whenever the user type a character,  the FormCell's validity is checked,
 * and invalid changes are rejected.
 *
 */
 
@implementation Verifier

- textDidGetKeys:sender isEmpty:(BOOL)flag
{
    id testCell;
    testCell = [[sender delegate] selectedCell];
    if (! flag) {
        char testString[500];
        int length, testLength;
        strcpy(testString,[testCell stringValue]);
        if ( ! [testCell isEntryAcceptable:[testCell stringValue]] ) {
        /*
         *  set the selection to the invalid character, and delete it
         */
            int badChar;
            badChar=strlen(testString);
            [sender setSel:badChar-1:badChar];
            [sender delete:self];
            NXBeep();
            strcpy(testString,[testCell stringValue]);
        }
      /*
       * Check the length of the entry as well.  The tag is used to set the 
       * valid length. If Tag is zero,  skip this check.
       */
        length=[testCell tag];
        if ( length) {
            testLength = strlen(testString);
            if ( length == 1 ) {
              /*
               * Special case for length == 1: cut off the first part of the
               * string,  leaving the last char typed,  don't beep
               */
                if ( testLength > 1 ) {
                    [sender setSel:0:testLength-1];
                    [sender delete:self];
                    }
                [sender setSel:0:1];
                }
            else if ( testLength > length ) {
              /*
               * Length is invalid, cut off some chars
               */
                    [sender setSel:length-1:testLength];
                    [sender delete:self];               
                    NXBeep();
                }
        }
    }
    return self;
}
@end
