
/* The serviceHandler object controls the enabling and disabling of services
 * from the Preferences panel.  It is hooked up to a matrix of checkboxes each
 * of which has a title corresponding to a service that can be controlled. When
 * any of the checkboxes are selected,  the corresponding service is enabled or 
 * disabled, depending on the state of the checkbox.
 */

#import "ServicesHandler.h"
#import <appkit/Matrix.h>
#import <appkit/Listener.h>

@implementation ServicesHandler


/* Enable/Disable Services from a matrix of buttonCells which have
 * titles corresponding to the Service menu entries
 */

- servicesEnable:sender
{
    NXSetServicesMenuItemEnabled([[sender selectedCell] title], 
        [[sender selectedCell] intValue]);
    return self;
}


/* On initialisation, the following methods insure that the checkboxes
 * show the state of their corresponding service
 *
 * Set the state of the sender (a checkbox) based on whether the
 * corresponding service is enabled
 */

- servicesSetState:sender
{
    [sender setIntValue:
        NXIsServicesMenuItemEnabled([sender title]) ? 1 : 0];
    return (id) YES;
}

/* The application's delegate calls this method on initialisation. It simply
 * calls the above method for each cell in the matrix
 */

- prefSetup:sender
{
    [prefMatrix sendAction:(SEL) @selector(servicesSetState:) 
        to:self forAllCells:YES];
    return self;
}

@end
